![kitshn (for Tandoor)](/images/title_light.png#gh-light-mode-only)
![kitshn (for Tandoor)](/images/title_dark.png#gh-dark-mode-only)
---
![GitHub](https://img.shields.io/github/license/aimok04/kitshn?style=for-the-badge) ![GitHub release (latest by date)](https://img.shields.io/github/v/release/aimok04/kitshn?style=for-the-badge)

**kitshn** is an unofficial multiplatform client for the self-hosted [Tandoor recipe management software](https://github.com/TandoorRecipes/recipes). The app is built with **Compose**, and **Material 3 Expressive** to deliver a modern, intuitive and responsive user experience and is developed for Android, iOS and Desktop.

> [!IMPORTANT]
> Although kitshn is available to multiple platforms, the main focus is still on Android.
> Some features are exclusive to that platform.

## 📦 Installation

> [!TIP]
> Install the kitshn beta for compatibility with Tandoor v2.

[<img src="/images/badge_google.png"
alt="Join the beta on Google Play"
height="80">](https://play.google.com/apps/testing/de.kitshn.android)
[<img src="/images/badge_testflight.png"
alt="Join the beta through Testflight"
height="80">](https://testflight.apple.com/join/zx1xzSMg)

---

[<img src="/images/badge_github.png"
alt="Get it on GitHub"
height="80">](https://github.com/aimok04/kitshn/releases)
[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
alt="Get it on F-Droid"
height="80">](https://f-droid.org/packages/de.kitshn.android/)
[<img src="/images/badge_google.png"
alt="Get it on Google Play"
height="80">](https://play.google.com/store/apps/details?id=de.kitshn.android)
[<img src="/images/badge_apple.png"
alt="Download on the App Store"
height="80">](https://apps.apple.com/us/app/kitshn-for-tandoor/id6740168361)

## 🔑 Certificate Fingerprints (.apk)
```
SHA1:
CC:1A:8C:30:9B:DF:36:67:CE:E6:AC:FA:5D:74:FA:6A:56:70:73:A4

SHA256:
5D:1A:9A:D4:16:24:6D:76:75:3F:51:57:7E:00:CD:6D:72:DC:7C:3F:36:F5:F3:EC:1F:CB:DB:2B:C8:DD:31:7D
```
## 🌍 l10n

You can help translate kitshn on [Weblate](https://hosted.weblate.org/projects/kitshn/).
Contributions are very welcome 😊

[![Translation status](https://hosted.weblate.org/widget/kitshn/app/multi-auto.svg)](https://hosted.weblate.org/engage/kitshn/)

## 💪 Notable Features

- [x] Dynamic *home screen*
- UI
    - [x] Material You customization
    - [x] Material 3 *Expressive*
    - [x] Adaptive layout for *phones*, *tablets* and *foldables*
- Recipes
    - [x] *Markdown* support
    - [x] Cooking mode
        - [x] Creating timers
          with [timer detection](https://kitshn.app/docs/features/timer-detection)
    - [x] [App links](https://kitshn.app/docs/features/share-wrapping.html)
    - [x] [Embedding videos](https://kitshn.app/docs/features/embedding-videos-inside-steps.html)
      inside steps
    - [x] Importing
        - [x] [Social Media Importing](https://kitshn.app/docs/features/social-media-import.html)
          *powered by AI*
        - [x] Share links with *kitshn* for import
    - [x] Easy ingredient allocation tool
- [x] Meal plan
- [x] Shopping list
    - [x] Shopping mode
    - [x] Offline sync
- [x] Recipe books
    - [x] [Favorites](https://kitshn.app/docs/features/favorites.html) system

## 🖼️ Impressions

> [!TIP]
> More screenshots available here:
> https://kitshn.app/screenshots

<div>    
    <img height="500" alt="Home" src="/web/public/images/screenshots/sevenInchScreenshots/LIGHT_02_HOME_RECIPE_VIEW.png#gh-light-mode-only" />
    <img height="500" alt="Home" src="/web/public/images/screenshots/sevenInchScreenshots/DARK_02_HOME_RECIPE_VIEW.png#gh-dark-mode-only" />
    <img height="500" alt="Meal plan" src="/web/public/images/screenshots/phoneScreenshots/LIGHT_05_MEAL_PLAN.png#gh-light-mode-only" />
    <img height="500" alt="Meal plan" src="/web/public/images/screenshots/phoneScreenshots/DARK_05_MEAL_PLAN.png#gh-dark-mode-only" />
    <img height="500" alt="Shopping" src="/web/public/images/screenshots/sevenInchScreenshots/LIGHT_07_SHOPPING.png#gh-light-mode-only" />
    <img height="500" alt="Shopping" src="/web/public/images/screenshots/sevenInchScreenshots/DARK_07_SHOPPING.png#gh-dark-mode-only" />
    <img height="500" alt="Shopping mode" src="/web/public/images/screenshots/phoneScreenshots/LIGHT_08_SHOPPING_MODE.png#gh-light-mode-only" />
    <img height="500" alt="Shopping mode" src="/web/public/images/screenshots/phoneScreenshots/DARK_08_SHOPPING_MODE.png#gh-dark-mode-only" />
    <img height="500" alt="Books" src="/web/public/images/screenshots/sevenInchScreenshots/LIGHT_10_BOOKS_DETAILS_VIEW.png#gh-light-mode-only" />
    <img height="500" alt="Books" src="/web/public/images/screenshots/sevenInchScreenshots/DARK_10_BOOKS_DETAILS_VIEW.png#gh-dark-mode-only" />
    <img height="500" alt="Cooking mode" src="/web/public/images/screenshots/phoneScreenshots/LIGHT_03_RECIPE_COOKING_MODE.png#gh-light-mode-only" />
    <img height="500" alt="Cooking mode" src="/web/public/images/screenshots/phoneScreenshots/DARK_03_RECIPE_COOKING_MODE.png#gh-dark-mode-only" />
</div>

<details>
    <summary>Dark mode / light mode</summary>
    <img height="500" alt="Home" src="/web/public/images/screenshots/sevenInchScreenshots/LIGHT_02_HOME_RECIPE_VIEW.png#gh-dark-mode-only" />
    <img height="500" alt="Home" src="/web/public/images/screenshots/sevenInchScreenshots/DARK_02_HOME_RECIPE_VIEW.png#gh-light-mode-only" />
    <img height="500" alt="Meal plan" src="/web/public/images/screenshots/phoneScreenshots/LIGHT_05_MEAL_PLAN.png#gh-dark-mode-only" />
    <img height="500" alt="Meal plan" src="/web/public/images/screenshots/phoneScreenshots/DARK_05_MEAL_PLAN.png#gh-light-mode-only" />
    <img height="500" alt="Shopping" src="/web/public/images/screenshots/sevenInchScreenshots/LIGHT_07_SHOPPING.png#gh-dark-mode-only" />
    <img height="500" alt="Shopping" src="/web/public/images/screenshots/sevenInchScreenshots/DARK_07_SHOPPING.png#gh-light-mode-only" />
    <img height="500" alt="Shopping mode" src="/web/public/images/screenshots/phoneScreenshots/LIGHT_08_SHOPPING_MODE.png#gh-dark-mode-only" />
    <img height="500" alt="Shopping mode" src="/web/public/images/screenshots/phoneScreenshots/DARK_08_SHOPPING_MODE.png#gh-light-mode-only" />
    <img height="500" alt="Books" src="/web/public/images/screenshots/sevenInchScreenshots/LIGHT_10_BOOKS_DETAILS_VIEW.png#gh-dark-mode-only" />
    <img height="500" alt="Books" src="/web/public/images/screenshots/sevenInchScreenshots/DARK_10_BOOKS_DETAILS_VIEW.png#gh-light-mode-only" />
    <img height="500" alt="Cooking mode" src="/web/public/images/screenshots/phoneScreenshots/LIGHT_03_RECIPE_COOKING_MODE.png#gh-dark-mode-only" />
    <img height="500" alt="Cooking mode" src="/web/public/images/screenshots/phoneScreenshots/DARK_03_RECIPE_COOKING_MODE.png#gh-light-mode-only" />
</details>

## 📜 License & Credits

[GNU General Public License v3.0](/LICENSE)<br>
Icon made by Freepik from www.flaticon.com
