
<img width="1604" height="267" alt="kitshn (for Tandoor)" src="https://github.com/user-attachments/assets/746041d2-1a85-44b4-a03b-aef0c792cc87" />


### Hey ✌️

I finally decided to release **kitshn v2** 🥳.
While it still isn't *perfect* yet, the *stable* release is quite *outdated* now, because it isn't even *compatible* with the **new** Tandoor versions.

### These are the **highlights** of **kitshn v2**:

1. Compatibility with **Tandoor v2** (#95):
    - **kitshn v2** is of course compatible with **Tandoor v2** and also includes some new features like **AI import** or **activity**.
2. Overhauled design using **Material 3 Expressive** (#204):
    - **kitshn v2** contains some fresh new *components* and *design concepts*.
    - **kitshn v2** will make more use of *haptic feedback*.
3. New **features** and improved *usability*:
    - **kitshn v2** features a new **Social Media Import** function which can import posts from *Instagram* and *TikTok*.
    - **kitshn v2** supports detecting *timer ranges*.
    - **kitshn v2** supports creating timers on *iOS* (#115).
    - ...
4. A lot of *bug fixes* and *minor* improvements:
    - **kitshn v2** will now provide *experimental* `.flatpak` binaries.
    - ...

---

<img width="200" alt="Onboarding" src="https://github.com/user-attachments/assets/e2b3b5a0-2948-4539-88f3-3a753863545e" />

<img width="200" alt="Home" src="https://github.com/user-attachments/assets/126159a7-9f45-4743-af5f-b4275207e804" />

<img width="200" alt="Recipe" src="https://github.com/user-attachments/assets/8534f0df-c071-46b7-862a-41d30856626d" />

<img width="200" alt="Meal plan" src="https://github.com/user-attachments/assets/18b9f5aa-fc00-483c-8671-5cbd81c0a797" />

<img width="200" alt="Shopping" src="https://github.com/user-attachments/assets/28f89cd7-a4dd-402e-8f51-fe5b3d549b96" />

<img width="200" alt="Books" src="https://github.com/user-attachments/assets/041e118d-059c-4782-a177-cb7c74047520" />

<img width="200" alt="Settings" src="https://github.com/user-attachments/assets/f53fa5ef-a38d-4e94-b9a5-19a04e7a9f5c" />

<img width="200" alt="Timer ranges" src="https://github.com/user-attachments/assets/fc1e80e5-f3f6-4eee-b508-363fc96f669b" />

---

## Commits
- fix(commonMain/api): increased timeout values for multipart requests to 60s (#301)
- fix(commonMain/import): improved fetching post content for instagram posts (resolved #302)
- fix(commonMain/books): issue when recipe book has more than 50 books (resolved #297)
- fix(commonMain/import): allow interaction with webview in RecipeImportSocialMediaDialog.kt (resolved #278)
- fix(commonMain/import): improved animation in RecipeImportSocialMediaDialog.kt (#278)
- fix(commonMain/utils): disable "day_after_tomorrow" and "day_before_yesterday" labels in english
- fix(commonMain/import): replace servings value with 1 if null (#295)
- chore(libs): version bumps
- feat(commonMain/import): replace servingsText when smaller than 6 characters (resolved #296)
- feat(commonMain/dialog): added "ignore" button to version compatibility dialog (#293)
- feat(commonMain/recipes): don't show merged ingredient list when recipe has only one step (resolved #294)
- feat(flatpak): added new flatpak directory with metadata
- feat(build.gradle): added appImage to targetFormats (for non Mac devices)
- fix(flatpak): added .java/.userPrefs as persistent folder
- fix(flatpak): changed socket to x11
- chore(libs): version bumps
- chore(libs): version bumps
- chore(gradle): bump compileSdk and targetSdk to 36
- github(workflows): added "Build flatpak on new version tag" workflow
- github(workflows): added "Build flatpak manually" workflow
- feat(commonMain/recipes): highlight IngredientItem when food has recipe value and open recipe link dialog on click (resolved #284)
- fix(commonMain/settings): close app when signing out
- Revert "fix(commonMain/mealplan): disabled date picker temporarily for iOS because it depends on kotlinx.datetime.Clock (#282)"
- chore(libs): version bumps (resolved #282)
- chore(commonMain/api): marked v2.3.3 as compatible
- chore(commonMain/api): marked v2.3.0 - v2.3.2 as compatible
- feat(commonMain/utils): improved formatDecimalToFraction with more accurate fraction matching (resolved #281)
- fix(commonMain/import): don't proceed with autoFetch when there is no default ai provider in social media import
- fix(commonMain/mealplan): disabled date picker temporarily for iOS because it depends on kotlinx.datetime.Clock (#282)
- feat(commonMain/import): improved image fetching when importing TikTok with social media import
- feat(commonMain/import): improved image fetching for instagram in social media import
- fix(libs): downgraded agp for compatibility with F-Droid
- fix(commonMain/api): increased timeout values for multipart requests to prevent timeouts for long requests (e.g. /ai-import/)
- fix(commonMain/import): added social media import url as sourceUrl when creating recipe
- fix(gradle): problem with compiling for android
- fix(commonMain/import): don't fetch imageURL if blank (resolved #266)
- fix(commonMain/import): wait until content is loaded in social media import (resolved #276)
- fix(commonMain/import): added error handler to fetchAiRequestState in RecipeImportSocialMediaDialog.kt (resolved #275)
- fix(commonMain/import): improved detection of iOS platform in social media import
- fix(commonMain/import): added error when recipe description is no longer than three characters in RecipeImportSocialMediaDialog.kt
- fix(libs): downgrade adaptive and compose material3 to fix paste issue on iOS (resolved #273)
- fix(mobileMain/ui): compiling error in ChoosePhotoBottomSheet.mobile.kt
- chore(libs): version bumps and downgrade compose
- fix(commonMain/home): replaced ExpandedDockedSearchbar with ExpandedFullScreenSearchbar again but its hidden when searchBarState != expanded (resolved #289)
- fix(commonMain/ui): replaced every KeyboardType.Number with KeyboardType.Decimal
- feat(commonMain/shopping): improved ShoppingListEntryCreationDialog for larger screens
- fix(commonMain/home): replaced ExpandedFullScreenSearchBar with ExpandedDockedSearchbar as a quickfix (#289)
- fix(commonMain/home): search toolbar color on large screen devices
- feat(README.md): added kitshn beta invite links to installation section
- feat(commonMain/import): added AI provider selector and adapted to AI related API changes
- feat(commonMain/ui): removed peekaboo and implemented ChoosePhotoBottomSheet for every photo upload situation
- feat(commonMain/recipes): implemented timer ranges regex and bottom sheet (resolved #169)
- feat(web/funding): update to funding api v2
- feat(README.md): add kitshn.app screenshots page link to impressions
- feat(README.md): improve impressions layout
- feat(README.md): update impressions to kitshn v2
- feat(web/screenshots): update screenshots to kitshn v2
- feat(fastlane): added Android take_screenshots lane and take_android_screenshots actions
- feat(commonMain & androidTest): added automatic screenshot creation for Android
- feat(README.md): update features
- feat(README.md): removed roadmap
- fix(commonMain): replaced kotlinx.datetime.Clock with kotlin.time.Clock and updated kotlinx-datetime
- fix(images): added testflight badge
- fix(commonMain/strings.xml): added search_providers string
- fix(commonMain/import): replaced search_categories with search_providers string in SelectAIProviderDialog.kt
- fix(commonMain/import): added SelectAIProviderDialog to RecipeImportAIDialog.kt
- fix(fastlane): increased sleep in take_android_screenshots.rb to ensure system ui demo mode being enabled
- fix(fastlane): changed Android take_screenshots lane to copy screenshots to web
- fix(fastlane): added missing screenshots
- fix(commonMain/books): also show placeholder icon when all recipes have no images
- fix(commonMain/mealplan): changed sorting order of mealplans to meal type time value (resolved #268)
- fix(commonMain/books): wrapped listAllEntries with TandoorRequestState to prevent exception
- fix(commonMain/books): filter recipes were not cleared/ updated when selecting different book (resolved #256)
- fix(commonMain/recipes): issue where ingredient amount template wasn't scaling (resolved #264)
- chore(fastlane): ran android take_screenshots
- chore(fastlane): ran android take_screenshots
- chore(libs): version bumps
- chore(fastlane): ran android take_screenshots
- chore(composeApp/composeResources): update aboutlibraries.json
- chore(commonMain/api): marked v2.0.3 - v2.2.7 as compatible
- l10n(German): translated using Weblate
- l10n(Ukrainian): translated using Weblate
- l10n(German): translated using Weblate
- l10n(Czech): translated using Weblate
- l10n(Catalan): translated using Weblate
- l10n(Czech): translated using Weblate
- l10n(Dutch): translated using Weblate
- feat(commonMain/shopping): show individual entries in ShoppingListEntryDetailsBottomSheet and added button to open it in shopping mode (resolved #249)
- feat(commonMain/shopping): added amount edit dialog to shopping list entries (resolved #232)
- feat(commonMain/recipes): added ingredients.amount, ingredients.unit, ingredients.food, and ingredients.note templates (resolved #250)
- feat(commonMain/home): added sorting option to HomeTraditionalLayout (resolved #251)
- feat(commonMain/recipes): improved details view when viewing shared recipes
- feat(commonMain/import): adapted RecipeFromSource model and fetch functions to v2 api
- feat(commonMain/import): improved social media import script
- feat(web/docs): update templating.md
- fix(commonMain/ui): added .imePadding in AdaptiveFullscreenDialog to make text fields accessible when focused (resolved #247)
- fix(commonMain/recipes): issue with parsing shared recipe link (resolved #253)
- fix(commonMain/mealplan): update details dialog when editing entry (resolved #246)
- fix(commonMain/import): save social media url as source url when importing (resolved #248)
- fix(commonMain/ui): layout issues when AdaptiveFullscreenDialog is fullscreen
- fix(commonMain/ui): removed window insets from AdaptiveFullscreenDialog when not fullscreen and enlarged click to dismiss area (resolved #252)
- chore(commonMain/api): marked v2.0.2 as compatible
- l10n(Ukrainian): translated using Weblate
- feat(commonMain/import): implemented new social media import with support for TikTok and Instagram (resolved #219)
- feat(*Main): added support for creating timers on iOS (resolved #115)
- feat(commonMain/recipes): display created by and created at data in RecipeDetails.kt
- feat(commonMain/home): implemented compact home screen design (resolved #239)
- feat(commonMain/onboarding): added iOS local network permission info hint (resolved #240)
- feat(commonMain): added SelectionContainers to multiple Text components (resolved #225)
- feat(commonMain/components): improved HorizontalRecipeCardLink design
- feat(commonMain/mealplan): added floating toolbar layout to MealPlanDetailsDialog (resolved #242)
- feat(commonMain/components): added min height to RecipeStepMultimediaBox (resolved #233)
- fix(commonMain/utils): removed annoying pager state haptics
- fix(commonMain/onboarding): removed PasswordVisualTransformation to allow paste on iOS (resolved #227)
- fix(commonMain/shopping): serialization issue with entries associated to meal plans with empty recipe field (resolved #244)
- fix(commonMain/import): adapted social media import script to iOS
- fix(commonMain/import): issue with social media import script on Android
- fix(commonMain/ui): changed containerColor of HorizontalRecipeLinkCard in SelectRecipeDialog.kt
- fix(commonMain/recipes): search view not opening correctly when clicking keyword chip
- fix(commonMain/mealplan): text overlapping in MealPlanDetailsCard (resolved #245)
- fix(commonMain/home): set new parameter to true in extended list query in HomeTraditionalLayout
- fix(commonMain/shopping): apply floatingToolbarVerticalNestedScroll after initial load  (#235) (#230)
- fix(commonMain/home): changed floating toolbar to be horizontal (#234) (resolved #230)
- fix(commonMain/shopping): ignore casing when sorting shopping list items alphabetically (#236) (resolved #237)
- fix(commonMain/recipes): layout issue with long step title in RecipeStepCard.kt (resolved #223)
- chore(libs): updated library definitions
- chore(libs): version bumps
- chore(commonMain/api): marked v2.0.0/1 as compatible and removed alpha and beta versions
- l10n(Catalan): translated using Weblate
- l10n(Dutch): translated using Weblate
- l10n(French): translated using Weblate
- l10n(Russian): translated using Weblate
- l10n(Ukrainian): translated using Weblate
- l10n(Spanish): translated using Weblate
- feat(commonMain/import): added auto ingredient sorting to RecipeImportCommon.kt (resolved #186)
- feat(commonMain/recipes): added bottom sheet for adding comment to cook log in RouteRecipeCookPageDone
- feat(commonMain/recipes): added "Activity" card and bottom sheet dialog which display cook logs like the web app does (resolved #194)
- feat(commonMain/recipes): merge ingredients with shared unit, food and notes in RecipeDetails.kt (resolved #217)
- feat(commonMain): updated funding banner to api v2
- fix(commonMain/import): added position parameters to SettingsSwitchListItems in RecipeImportCommon.kt
- fix(commonMain/recipes): bug where ingredient amount gets multiplied in RecipeDetails view
- fix(commonMain/recipes): crash when recipe has no cook logs in RecipeActivityPreviewCard.kt
- chore(commonMain/api): marked v2.0.0-beta-2/3/4/5 as compatible
- Revert "fix(commonMain/shopping): disabled auto focus of food input field in ShoppingListEntryCreationDialog (#141)" (resolved #141)
- l10n(Chinese (Simplified Han script)): added translation using Weblate
- l10n(Ukrainian): translated using Weblate
- l10n(French): translated using Weblate
- l10n(Tamil): translated using Weblate
- l10n(Hindi (Latin script)): added translation using Weblate
- l10n(Portuguese (Brazil)): translated using Weblate
- l10n(Russian): translated using Weblate
- l10n(Russian): added translation using Weblate
- feat(iosApp): added app icon with liquid glass effect
- feat(commonMain/ui): replaced outdated progress indicators (Material3Expressive) (#204)
- feat(commonMain/ui): added haptic feedback to many actions and components (Material3Expressive) (#204)
- feat(commonMain/recipes): moved dropdown menu actions into HorizontalFloatingToolbar (Material3Expressive) (#204)
- feat(commonMain/recipes): adapted image roundness to screen rounding on Android (Material3Expressive) (#204)
- feat(commonMain/ui): added haptic feedback to selectors (meal plan and servings) (Material3Expressive) (#204)
- feat(commonMain/mealplan): added animation to date range chip in tool bar (Material3Expressive) (#204)
- feat(commonMain/ui): replaced some outlined text fields and cards (Material3Expressive) (#204)
- feat(commonMain/onboarding): replaced Autofill modifier with .semantics contentType
- feat(commonMain/ui): misc changes (Material3Expressive) (#204)
- feat(commonMain/ui): added loading indicator to list route (Material3Expressive) (#204)
- feat(commonMain/ui): redesign IngredientsList and IngredientItem (Material3Expressive) (#204)
- feat(commonMain/ui): redesign recipe views and routes (Material3Expressive) (#204)
- feat(commonMain/ui): redesign onboarding routes (Material3Expressive) (#204)
- feat(commonMain/ui): redesign settings views (Material3Expressive) (#204)
- feat(commonMain/ui): redesign AdaptiveFullscreenDialog (Material3Expressive) (#204)
- feat(commonMain/ui): redesign book views (Material3Expressive) (#204)
- feat(commonMain/ui): redesign shopping view and shopping mode route (Material3Expressive) (#204)
- feat(commonMain/ui): redesign meal plan view (Material3Expressive) (#204)
- feat(commonMain/ui): redesign home view and search (Material3Expressive) (#204)
- feat(commonMain/ui): add new components and classes (Material3Expressive) (#204)
- feat(commonMain/ui): adapt back button design (Material3Expressive) (#204)
- feat(commonMain/mealplan): use "default" meal type by default when creating new meal plan entry (resolved #211)
- fix(libs): reverted some version bumps
- fix(iosApp): updated import in SubscriptionView.swift
- fix(commonMain/main): set default sub route navigation animation to fade
- fix(iosMain/main.kt): disable default back gesture
- fix(commonMain/recipes): removed empty nav back stack read call
- fix(commonMain/mealplan): error when trying to move meal plan entry with associated recipe
- fix(commonMain): adapted to new back stack entry arguments api (Material3Expressive) (#204)
- fix(commonMain/ui): adapted funding banner (Material3Expressive) (#204)
- fix(commonMain/ui): show animation of TandoorBetaInfoDialog
- fix(composeApp): adapt to jetbrains compose alpha (#204)
- chore(libs): version bumps
- chore(commonMain/api): marked v2.0.0-alpha-5/6/7 and v2.0.0-beta-1 as compatible
- chore(libs): version bumps (Material3Expressive) (#204)
- feat(androidMain/AndroidManifest.xml): added android:enableOnBackInvokedCallback="true" to AppActivity
- feat(commonMain/api): update recipeOverview map when retrieving recipe model from server (resolved #171)
- feat(commonMain/search): improved buttons and cursor position when reopening dialog (resolved #203)
- feat(web/vitepress): changed website description
- feat(web): merged kitshn.app into main repo
- feat(README.md): update alerts
- feat(README.md): added certificate fingerprints (resolved #202)
- fix(commonMain/search): crash on Android due to using rememberSaveable with TextFieldValue
- fix(commonMain/home): issue where wrong meal plan entries were shown in promotion section (resolved #200)
- chore(gradle): update gradle/agp
- chore(libs): version bumps
- chore(commonMain/api): marked v2.0.0-alpha-4 as compatible
- chore(web): update dependencies
- github(workflows): added "Deploy kitshn.app" workflow
- l10n(Ukrainian): translated using Weblate
- l10n(Spanish): translated using Weblate
- l10n(French): translated using Weblate
- l10n(Polish): translated using Weblate
- l10n(Dutch): translated using Weblate
- l10n(Catalan): translated using Weblate
- l10n(Catalan): added translation using Weblate
- l10n(Polish): translated using Weblate
- l10n(Polish): fix short_description.txt being too long
- feat(androidMain/AndroidManifest.xml): added android:enableOnBackInvokedCallback="true" to AppActivity
- feat(commonMain/api): update recipeOverview map when retrieving recipe model from server (resolved #171)
- feat(commonMain/search): improved buttons and cursor position when reopening dialog (resolved #203)
- feat(web/vitepress): changed website description
- feat(web): merged kitshn.app into main repo
- feat(README.md): update alerts
- feat(README.md): added certificate fingerprints (resolved #202)
- fix(commonMain/search): crash on Android due to using rememberSaveable with TextFieldValue
- fix(commonMain/home): issue where wrong meal plan entries were shown in promotion section (resolved #200)
- chore(gradle): update gradle/agp
- chore(libs): version bumps
- chore(commonMain/api): marked v2.0.0-alpha-4 as compatible
- chore(web): update dependencies
- github(workflows): added "Deploy kitshn.app" workflow
- l10n(Ukrainian): translated using Weblate
- l10n(Spanish): translated using Weblate
- l10n(French): translated using Weblate
- l10n(Polish): translated using Weblate
- l10n(Dutch): translated using Weblate
- l10n(Catalan): translated using Weblate
- l10n(Catalan): added translation using Weblate
- l10n(Polish): translated using Weblate
- l10n(Polish): fix short_description.txt being too long
- feat(commonMain/recipes): implemented step editing and creation with markdown support (resolved #177)
- feat(build.gradle): removed F-Droid checkupdates fix (fdroid/fdroiddata#3531 on gitlab.com)
- feat(fastlane): added prepare_release and commit_release for easier and faster changelog and release creation
- fix(commonMain/recipes): fetch steps before creating new step to avoid discarding changes in StepCreationAndEditDialog
- fix(commonMain/recipes): moved save/create button into TopAppBar in StepCreationAndEditDialog for usability
- l10n(Russian): translated using Weblate
- l10n(German): translated using Weblate
- l10n(Ukrainian): translated using Weblate
- l10n(Polish): translated using Weblate
- l10n(Polish): added translation using Weblate
- feat(iosApp): added camera usage description in project.pbxproj
- fix(commonMain/shopping): increased entries clear dialog width (resolved #188)
- fix(androidMain/AndroidManifest.xml): removed unnecessary peekaboo READ_MEDIA_IMAGES permission
- fix(commonMain/api): changed date values to include time in UTC time zone (resolved #191)
- fix(commonMain): issue with converting the value of datePickerState to LocalDate (resolved #191)
- fix(androidMain, iosMain): parsing issue with new v2 recipe url in AppLinkHandler (resolved #189)
- chore(commonMain/api): marked v2.0.0-alpha-3 as compatible
- feat(build.gradle): added new "mobileMain" source set to unify peekaboo for androidMain and iosMain
- feat(androidMain/ui): added disableAnimation parameter to AdaptiveFullscreenDialog
- feat(commonMain/shopping): added "enlarge shopping mode" setting (resolved #181)
- feat(commonMain/shopping): implemented clear shopping list dialog (#95)
- feat(commonMain/ui): replaced peekaboo with FileKit in PhotoPickerDialog
- feat(commonMain/import): implemented support for import using AI
- feat(mobileMain/ui): added photo taking dialog using peekaboo library
- feat(commonMain/recipes): added recipe name to sharing text (resolved #185)
- fix(build.gradle): issue with applying default hierarchy template
- fix(commonMain/shopping): don't purge checked items from cache
- fix(commonMain/shopping): issue with deleting shopping list entries (resolved #184)
- chore(commonMain/api): marked v2.0.0-alpha-2 as compatible
- l10n(Ukrainian): translated using Weblate
- l10n(German): translated using Weblate
- l10n(Czech): added translation using Weblate
- l10n(Portuguese (Brazil)): added translation using Weblate
- feat(commonMain/mealplan): implemented fractional servings (resolved #168)
- feat(commonMain/recipes): added unified formatDuration method and support for displaying hours (resolved #173)
- feat(androidMain/shortcuts): added meal plan, shopping, shopping mode and books shortcuts (resolved #164)
- feat(androidMain/shortcuts): modernized icon of new instance shortcut
- feat(androidMain/acra): modernized icons in AcraCrashReportDialog
- feat(commonMain/navigation): replaced "default" icons and added inactive/active icons
- feat(commonMain/api): added server version breadcrumb
- fix(commonMain/recipes): keep food cell in ingredients table bigger (resolved #166)
- fix(commonMain/recipes): duplicate ingredients when unchecking item in RecipeIngredientAllocationDialog (resolved #174)
- fix(commonMain/strings.xml): removed unused error string
- fix(commonMain/ui): removed isSupported check in SpaceSwitchIconButton
- l10n(French): translated using Weblate
- l10n(Dutch): translated using Weblate
- l10n(Ukrainian): translated using Weblate
- l10n(German): translated using Weblate
- feat(commonMain): improved space switcher with new Tandoor v2 space api
- feat(commonMain): improved timer detection to support hours and multiple languages (resolved #167)
- feat(commonMain): added Ko-Fi link in Settings for android and jvm
- feat(fastlane): added beta deploy lanes for GitHub, Google Play and TestFlight
- feat(commonMain/main): added info dialog for the kitshn beta
- feat(commonMain/onboarding): added Tandoor v1 instance error to OnboardingSignIn
- feat(commonMain): implemented serverSettings api and outdated Tandoor v1 alert
- feat(commonMain/vm): added favorites.init and connectivityCheck to signIn function
- feat(commonMain): adapted importing to Tandoor v2
- feat(commonMain): adapted supermarket and supermarket category to Tandoor v2
- feat(commonMain/api): adapted recipe overview model to Tandoor v2
- feat(commonMain): adapted shopping meal plan data / recipe data to Tandoor v2
- feat(commonMain): adapted recipe model to Tandoor v2
- feat(commonMain/api): adapted mealplan and meal type to Tandoor v2
- feat(commonMain): adapted books to Tandoor v2
- feat(commonMain/shopping): adapted ViewModel to Tandoor v2
- feat(commonMain): adapted shopping to Tandoor v2
- feat(commonMain/shopping): adapted user and user preference api to Tandoor v2
- feat(commonMain/onboarding): unified signIn method for OnboardingSignIn(Browser)
- fix(commonMain/onboarding): remove mention of alpha in OnboardingWelcome
- fix(commonMain/dialog): width issue when opening SpaceSwitchDialog
- fix(commonMain/dialog): crash when creating duplicate keyword in SelectMultipleKeywordsDialog
- fix(commonMain/mealplan): increase fetch date range to cover issue with timestamps
- fix(commonMain/onboarding): NullPointerException in OnboardingSignIn
- fix(commonMain/api): removed unused fun in TandoorUserRoute
- fix(commonMain/shopping): remove all entries in update()
- fix(commonMain): FocusRequester is not initialized issue
- l10n(Italian): translated using Weblate
- l10n(Italian): added translation using Weblate
- l10n(Ukrainian): translated using Weblate
- l10n(German): translated using Weblate