package de.kitshn.ui.theme.custom

import androidx.compose.material3.darkColorScheme
import androidx.compose.material3.lightColorScheme
import androidx.compose.ui.graphics.Color

val cupertinoLightColorScheme = lightColorScheme(
    primary = Color(0xFF007AFF),
    onPrimary = Color.White,
    primaryContainer = Color(0xFFE5F2FF),
    onPrimaryContainer = Color(0xFF007AFF0),
    secondary = Color(0xFF007AFF),
    onSecondary = Color.White,
    secondaryContainer = Color(0xFF007AFF),
    onSecondaryContainer = Color(0xFFE5F2FF),
    tertiary = Color(0xFF5AC8FA),
    onTertiary = Color.White,
    tertiaryContainer = Color(0xFFE0FFFF),
    onTertiaryContainer = Color(0xFF5AC8FA),
    error = Color(0xFFFF3B30),
    onError = Color.White,
    errorContainer = Color(0xFFFFEBEB),
    onErrorContainer = Color(0xFFFF3B30),
    background = Color(0xFFFFFFFF),
    onBackground = Color.Black,
    surface = Color.White,
    onSurface = Color.Black,
    surfaceVariant = Color(0xFFF2F2F7),
    onSurfaceVariant = Color.Black,
    outline = Color(0xFFC7C7CC),
    outlineVariant = Color(0xFFDBDBE1),
    scrim = Color.Black.copy(alpha = 0.5f),
    surfaceTint = Color.Transparent,
    inverseSurface = Color(0xFF000000),
    inverseOnSurface = Color.White,
    inversePrimary = Color(0xFF007AFF),
    surfaceDim = Color(0xFFF0F0F5),
    surfaceBright = Color(0xFFFFFFFF),
    surfaceContainerLowest = Color(0xFFFFFFFF),
    surfaceContainerLow = Color(0xFFF8F8F9),
    surfaceContainer = Color(0xFFF2F2F7),
    surfaceContainerHigh = Color(0xFFEBEBEF),
    surfaceContainerHighest = Color(0xFFE4E4E8),
)

val cupertinoDarkColorScheme = darkColorScheme(
    primary = Color(0xFF0A84FF),
    onPrimary = Color.Black,
    primaryContainer = Color(0xFF001E36),
    onPrimaryContainer = Color(0xFF0A84FF),
    secondary = Color(0xFF0A84FF),
    onSecondary = Color.Black,
    secondaryContainer = Color(0xFF0A84FF),
    onSecondaryContainer = Color(0xFF001E36),
    tertiary = Color(0xFF64D2FF),
    onTertiary = Color.Black,
    tertiaryContainer = Color(0xFF003758),
    onTertiaryContainer = Color(0xFF64D2FF),
    error = Color(0xFFFF453A),
    onError = Color.Black,
    errorContainer = Color(0xFF580000),
    onErrorContainer = Color(0xFFFF453A),
    background = Color(0xFF000000),
    onBackground = Color.White,
    surface = Color.Black,
    onSurface = Color.White,
    surfaceVariant = Color(0xFF2C2C2E),
    onSurfaceVariant = Color.White,
    outline = Color(0xFF545458),
    outlineVariant = Color(0xFF444448),
    scrim = Color.Black.copy(alpha = 0.5f),
    surfaceTint = Color.Transparent,
    inverseSurface = Color(0xFFFFFFFF),
    inverseOnSurface = Color.Black,
    inversePrimary = Color(0xFF0A84FF),
    surfaceDim = Color(0xFF141416),
    surfaceBright = Color(0xFF28282A),
    surfaceContainerLowest = Color(0xFF000000),
    surfaceContainerLow = Color(0xFF0C0C0E),
    surfaceContainer = Color(0xFF1C1C1E),
    surfaceContainerHigh = Color(0xFF28282A),
    surfaceContainerHighest = Color(0xFF343436),
)