package de.katzenmue.birdipedia.ui.theme

import android.os.Build
import androidx.compose.foundation.isSystemInDarkTheme
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.darkColorScheme
import androidx.compose.material3.dynamicDarkColorScheme
import androidx.compose.material3.dynamicLightColorScheme
import androidx.compose.material3.lightColorScheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.platform.LocalContext

private val DarkColorScheme = darkColorScheme(
    primary = Red40,
    secondary = RedGrey40,
    tertiary = Cream40,
    primaryContainer = Red40,
    secondaryContainer = Red40,
    tertiaryContainer = Red40,
    onPrimary = Cream40,
//    onSecondary = Color.Yellow,
//    onTertiary = Color.Yellow,
//    onPrimaryContainer = Color.Yellow,
//    onSecondaryContainer = Color.Yellow,
//    onTertiaryContainer = Color.Yellow,
//    onSurface = Color.Blue,
//    inverseOnSurface = Color.Red,
//    inverseSurface = Color.Green,
    inversePrimary = RedGrey40,
//    outline = Color.Yellow,
//    outlineVariant = Color.Yellow,
    )

private val LightColorScheme = lightColorScheme(
    primary = Yellow80,
    secondary = RedGrey80,
    tertiary = Cream80,
    primaryContainer = Yellow80,
    secondaryContainer = Yellow80,
    tertiaryContainer = Yellow80,
    inversePrimary = DarkGray,


//    /* Other default colors to override
//    background = Color(0xFFFFFBFE),
//    surface = Color(0xFFFFFBFE),
//    onPrimary = Color.White,
//    onSecondary = Color.White,
//    onTertiary = Color.White,
//    onBackground = Color.Black,
//    onTertiary = Color.White,
//    onBackground = Color(0xFF1C1B1F),
//    onSurface = Color(0xFF1C1B1F),
//    */
)

enum class ThemeMode {
    Light, Dark, System, LightDyn, DarkDyn, SystemDyn
}

@Composable
fun BirdipediaTheme(
    themeMode: ThemeMode = ThemeMode.System,
    dynamicColor: Boolean = true,
    content: @Composable () -> Unit
) {
    val darkTheme = when (themeMode) {
        ThemeMode.DarkDyn -> true
        ThemeMode.LightDyn -> false
        ThemeMode.SystemDyn -> isSystemInDarkTheme()
        ThemeMode.Dark -> true
        ThemeMode.Light -> false
        ThemeMode.System -> isSystemInDarkTheme()
    }
    val dynamicColor = when (themeMode) {
        ThemeMode.DarkDyn -> true
        ThemeMode.LightDyn -> true
        ThemeMode.SystemDyn -> true
        ThemeMode.Dark -> false
        ThemeMode.Light -> false
        ThemeMode.System -> false
    }

    val colorScheme = when {
        dynamicColor && Build.VERSION.SDK_INT >= Build.VERSION_CODES.S -> {
            val context = LocalContext.current
            if (darkTheme) dynamicDarkColorScheme(context) else dynamicLightColorScheme(context)
        }
        darkTheme -> DarkColorScheme
        else -> LightColorScheme
    }

    MaterialTheme(
        colorScheme = colorScheme,
        typography = Typography,
        content = content
    )
}