package de.katzenmue.birdipedia

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.activity.enableEdgeToEdge
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.material3.DrawerValue
import androidx.compose.material3.Scaffold
import androidx.compose.material3.rememberDrawerState
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalContext
import androidx.navigation.compose.NavHost
import androidx.navigation.compose.composable
import androidx.navigation.compose.rememberNavController
import de.katzenmue.birdipedia.ui.theme.BirdipediaTheme
import de.katzenmue.birdipedia.ui.theme.ThemeMode

class MainActivity : ComponentActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        enableEdgeToEdge()
        setContent {
            BirdipediaTheme {
                val navController = rememberNavController()
                val drawerState = rememberDrawerState(initialValue = DrawerValue.Closed)

                val eBirdList = loadEbirdList(LocalContext.current)
                val labelList = loadLabels(LocalContext.current)
                val sciList = loadSciLabels(LocalContext.current)
                val assetList = loadAssetList(LocalContext.current)
                val orderList = loadOrderList(LocalContext.current)
                val regionList = loadRegionList(LocalContext.current)
                val IUCNList = loadIUCNList(LocalContext.current)

                var currentFilterText = remember { mutableStateOf("") }

                val sharedPreferences =
                    LocalContext.current.getSharedPreferences("app_prefs", MODE_PRIVATE)
                
                val storedTheme = sharedPreferences.getString("themeMode", "System") ?: "System"
                var themeMode = remember { mutableStateOf(ThemeMode.valueOf(storedTheme)) }
                var region = sharedPreferences.getString("region", "NULL") ?: "NULL"

                val showIUCN = remember { mutableStateOf(sharedPreferences.getBoolean("showIUCN", false)) }

                val viewModel = FilterBirdViewModel(
                    labelList, eBirdList, sciList, assetList, regionList, IUCNList, sharedPreferences, currentFilterText
                )

                Scaffold(modifier = Modifier.fillMaxSize()) { innerPadding ->
                    NavHost(
                        navController = navController, startDestination = Routes.Home.route,
                    ) {
                        composable(Routes.Home.route) {
                            Home(
                                navController = navController,
                                viewModel = viewModel,
                                eBirdList,
                                labelList,
                                sciList,
                                assetList,
                                orderList,
                                regionList,
                                IUCNList,
                                currentFilterText
                            )
                        }
                        composable(Routes.Settings.route) {
                            Settings(
                                navController = navController,
                                drawerState = drawerState,
                                viewModel = viewModel,
                                currentFilterText
                            )
                        }
                        composable(Routes.Credits.route) {
                            Credits(navController = navController)
                        }
                    }
                }
            }
        }
    }
}



