package de.katzenmue.birdipedia

import android.content.Context
import androidx.compose.foundation.Canvas
import androidx.compose.foundation.background
import androidx.compose.foundation.border
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.Path
import androidx.compose.ui.unit.dp
import de.katzenmue.birdipedia.ui.theme.Blue
import de.katzenmue.birdipedia.ui.theme.Green
import de.katzenmue.birdipedia.ui.theme.Orange
import de.katzenmue.birdipedia.ui.theme.Red40
import de.katzenmue.birdipedia.ui.theme.Yellow
import java.io.BufferedReader
import java.io.IOException
import java.io.InputStreamReader
import java.util.Locale

@Composable
fun previewImageModifier(modifier: Modifier): Modifier {
    return modifier
        .size(128.dp)
        .background(MaterialTheme.colorScheme.inversePrimary)
}

val birdBoxModifier = Modifier.border(1.dp, Color.DarkGray)
val rowArrangement = Arrangement.spacedBy(10.dp)
val columnArrangement = Arrangement.spacedBy(8.dp)
val drawerItemSpacing = Modifier.padding(16.dp)
val birdNameSpacing = Arrangement.spacedBy(8.dp)

@Composable
fun IUCNTriangle(code: String, color: Color) {
    Box(modifier = Modifier.fillMaxWidth(), contentAlignment = Alignment.TopEnd) {
        Canvas(
            modifier = Modifier
//                .fillMaxSize()
                .size(40.dp)
                .align(Alignment.TopEnd)
        ) {
            val path = Path().apply {
                moveTo(size.width, 0f)
                lineTo(size.width, size.height)
                lineTo(0f, 0f)
                close()
            }
            drawPath(path, color)
        }
//        Box() {
//            Text(text = code, modifier = Modifier.align(Alignment.TopEnd).border(1.dp, Color.White))
//        }
    }
}

@Composable
fun getIUCNColor(code: String): Color {
    if (code == "LC") {
        return Green
    } else if (code == "NT") {
        return Blue
    } else if (code == "VU") {
        return Yellow
    } else if (code == "EN") {
        return Orange
    } else if (code.contains("CR")) {
        return Red40
    } else if (code.contains("EW")) {
        return Color.Black
    } else if (code.contains("NE") or code.contains("DD")) {
        return Color.DarkGray
    } else {
        return MaterialTheme.colorScheme.primary
    }
}

////// Adapted from https://github.com/woheller69/whoBIRD/blob/master/app/src/main/java/org/tensorflow/lite/examples/soundclassifier/BirdInfoActivity.kt#L154 //////
///// START ADAPTED CODE //////
fun loadAssetList(context: Context): List<String> {
    var assetList = emptyList<String>()
    try {
        val reader = BufferedReader(InputStreamReader(context.assets.open("assets.txt")))
        val wordList = mutableListOf<String>()
        reader.useLines { lines ->
            lines.forEach {
                wordList.add(it.trim())
            }
        }
        assetList = wordList.map { it }
    } catch (e: IOException) {
    }
    return assetList
}

fun loadEbirdList(context: Context): List<String> {
    var eBirdList = emptyList<String>()
    try {
        val reader = BufferedReader(InputStreamReader(context.assets.open("ebird_abbr.txt")))
        val wordList = mutableListOf<String>()
        reader.useLines { lines ->
            lines.forEach {
                wordList.add(it.trim())
            }
        }
        eBirdList = wordList.map { it }
    } catch (e: IOException) {
    }
    return eBirdList
}

fun loadSciLabels(context: Context): List<String> {
    var sciList = emptyList<String>()
    try {
        val reader = BufferedReader(InputStreamReader(context.assets.open("sci_labels.txt")))
        val wordList = mutableListOf<String>()
        reader.useLines { lines ->
            lines.forEach {
                wordList.add(it.trim())
            }
        }
        sciList = wordList.map { it }
    } catch (e: IOException) {
    }
    return sciList
}

fun loadOrderList(context: Context): List<String> {
    var orderList = emptyList<String>()
    try {
        val reader = BufferedReader(InputStreamReader(context.assets.open("order.txt")))
        val wordList = mutableListOf<String>()
        reader.useLines { lines ->
            lines.forEach {
                wordList.add(it.trim())
            }
        }
        orderList = wordList.map { it }
    } catch (e: IOException) {
    }
    return orderList
}

fun loadRegionList(context: Context): List<String> {
    var regionList = emptyList<String>()
    try {
        val reader = BufferedReader(InputStreamReader(context.assets.open("ranges.txt")))
        val wordList = mutableListOf<String>()
        reader.useLines { lines ->
            lines.forEach {
                wordList.add(it.trim())
            }
        }
        regionList = wordList.map { it }
//        regionList = wordList.map { it.split("_").get(2) }
    } catch (e: IOException) {
    }
    return regionList
}

fun loadIUCNList(context: Context): List<String> {
    var IUCNList = emptyList<String>()
    try {
        val reader = BufferedReader(InputStreamReader(context.assets.open("iucn.txt")))
        val wordList = mutableListOf<String>()
        reader.useLines { lines ->
            lines.forEach {
                wordList.add(it.trim())
            }
        }
        IUCNList = wordList.map { it }
//        regionList = wordList.map { it.split("_").get(2) }
    } catch (e: IOException) {
    }
    return IUCNList
}

fun loadLabels(context: Context): List<String> { //TODO: Refactor
    val localeList = context.resources.configuration.locales
    val language = localeList.get(0).language
    var filename = "labels" + "_${language}.txt"    // TODO: Common definition for all classes

    //Check if file exists
    val assetManager = context.assets // Replace 'assets' with actual AssetManager instance
    try {
        val mapList = assetManager.list("")?.toMutableList()
        if (mapList != null) {
            if (!mapList.contains(filename)) {
                filename = "labels" + "_en.txt"
            }
        }
    } catch (ex: IOException) {
        ex.printStackTrace()
        filename = "labels" + "_en.txt"
    }
    var labelList = emptyList<String>()
    try {
        val reader = BufferedReader(InputStreamReader(context.assets.open(filename)))
        val wordList = mutableListOf<String>()
        reader.useLines { lines ->
            lines.forEach {
                wordList.add(it)
            }
        }
        labelList = wordList.map { it.toTitleCase() }
    } catch (e: IOException) {
    }
    return labelList
}

private fun String.toTitleCase() =
    splitToSequence("_").map { it.replaceFirstChar { if (it.isLowerCase()) it.titlecase(Locale.ROOT) else it.toString() } }
        .joinToString("_").trim()

////// END ADAPTED CODE //////
