+++
  weight = 100
+++

# FOSS Launchers

This is a comparison of open-source home screens for Android.

**Inclusion criteria:** Apps in this list must be [open source](https://opensource.org/licenses) and maintained

<!-- New contributors, please reference https://www.markdownguide.org/basic-syntax/ -->

<!-- TEMPLATE

### <launcher name>

**License:** `<license type>`
[Website](<launcher website url>) | [Repository](<github or other repo url>) | [F-Droid](<fdroid url>)

<notes can go here>

**Main mode of interaction:** `<Search | Gestures | App grid>`

#### Features:
:white_check_mark: | :x: | :grey_question: Search:  <list what you can search: e.g., apps, contacts, call history, ...>
:white_check_mark: | :x: | :grey_question: Search history
:white_check_mark: | :x: | :grey_question: Customizable gestures: <list usable gestures: e.g., up, down, tap+up, ...>
:white_check_mark: | :x: | :grey_question: Folders
:white_check_mark: | :x: | :grey_question: Tags
:white_check_mark: | :x: | :grey_question: Rename apps
:white_check_mark: | :x: | :grey_question: Widgets
:white_check_mark: | :x: | :grey_question: Private space
:white_check_mark: | :x: | :grey_question: Work profile
:white_check_mark: | :x: | :grey_question: Pinned shortcuts
:white_check_mark: | :x: | :grey_question: Icon packs
:white_check_mark: | :x: | :grey_question: Material You

---

 -->

## Grid-Based Launchers

### Discreet Launcher

**License:** `GPL-3.0`  
[Website](https://vincent-falzon.com/) | [Repository](https://github.com/falzonv/discreet-launcher) | [F-Droid](https://f-droid.org/en/packages/com.vincent_falzon.discreetlauncher/)

**Main mode of interaction:** `app grid`

#### Features:

:white_check_mark: Search: `apps`  
:x: Search history  
:x: Customizable gestures  
:white_check_mark:Folders  
:x: Tags  
:white_check_mark: Rename apps  
:x: Widgets  
:grey_question: Private space  
:white_check_mark: Work profile  
:white_check_mark: Pinned shortcuts  
:white_check_mark: Icon packs  
:x: Material You  

---

### Fossify

**License:** `GPL-3.0`  
[Website](https://www.fossify.org/) | [Repository](https://github.com/FossifyOrg/Launcher) | [F-Droid](https://f-droid.org/en/packages/org.fossify.home/)

**Main mode of interaction:** `app grid`

#### Features:

:white_check_mark: Search:  `apps`  
:x: Search history  
:x: Customizable gestures  
:white_check_mark: Folders  
:x: Tags  
:white_check_mark: Rename apps  
:white_check_mark: Widgets  
:grey_question: Private space  
:x: Work profile  
:white_check_mark: Pinned shortcuts  
:x: Icon packs  
:white_check_mark: Material You  

---

### Lawnchair

**License:** `Apache License 2.0`  
[Website](https://lawnchair.app/) | [Repository](https://github.com/LawnchairLauncher/lawnchair)
    
Seems to be a regular (grid of apps) launcher.

**Main mode of interaction:** App grid
    
#### Features:
    
:white_check_mark: Search: `Apps & Shortcuts` `Web suggestions` `People` `Files` `Android Settings` `Calculator`  
:white_check_mark: Search history  
:white_check_mark: Customizable gestures: `double tap` `swipe up` `swipe down` `home button` `back button`  
:white_check_mark: Folders  
:x: Tags  
:white_check_mark: Rename apps  
:white_check_mark: Widgets  
:grey_question: Private space  
:grey_question: Work profile  
:x: Pinned shortcuts  
:white_check_mark: Icon packs  
:white_check_mark: Material You  

---

### Rootless Pixel Launcher

> **Abandoned**

**License:** `Apache License 2.0`  
[Repository](https://github.com/amirzaidi/Launcher3)

**Main mode of interaction:** `App grid`

#### Features:

:white_check_mark: Search:  `Apps`  
:x: Search history  
:x: Customizable gestures  
:x: Folders  
:x: Tags  
:x: Rename apps  
:warning: Widgets `buggy/broken`  
:grey_question: Private space  
:white_check_mark: Work profile  
:white_check_mark: Pinned shortcuts  
:white_check_mark: Icon packs  
:x: Material You  

---

## Search-Based

### Aster Launcher

> **Abandoned**
> 
**License:** `GPL-3.0`  
[Repository](https://github.com/neophtex/AsterLauncher) | [F-Droid](https://f-droid.org/en/packages/com.series.aster.launcher/)

**Main mode of interaction:** `search`

#### Features:

:warning: Search:  `apps` (apps list is buggy/broken) `web`  
:x: Search history  
:x: Customizable gestures  
:x: Folders  
:x: Tags  
:x: Rename apps  
:x: Widgets  
:grey_question: Private space  
:white_check_mark: Work profile  
:white_check_mark: Pinned shortcuts  
:x: Icon packs  
:x: Material You  

---

### KISS Launcher

**License:** `GPL-3.0`  
[Website](https://kisslauncher.com/) | [Repository](https://github.com/Neamar/KISS) | [F-Droid](https://f-droid.org/packages/fr.neamar.kiss/)

**Main mode of interaction:** `Search` `Some gestures available`

#### Features:

:white_check_mark: Search:  `Apps` `Contacts` `Call history`  
:white_check_mark: Search history  
:white_check_mark: Customizable gestures: `swipe left` `swipe right` `swipe up` `swipe down` `long press` `double tap`  
:x: Folders  
:white_check_mark: Tags  
:white_check_mark: Rename apps  
:white_check_mark: Widgets  
:grey_question: Private space  
:white_check_mark: Work profile  
:white_check_mark: Pinned shortcuts  
:white_check_mark: Icon packs  
:grey_question: Material You  

---

### Lunar Launcher
**License:** `GPL-3.0`  
[Repository](https://github.com/iamrasel/lunar-launcher) | [F-Droid](https://f-droid.org/en/packages/rasel.lunar.launcher/)

Even natively supports RSS feeds to the homescreen?

**Main mode of interaction:** `alphabet scroller`

#### Features:

:white_check_mark: Search:  `swipe up` `swipe down` `swipe left` `swipe right` `tap and hold battery indicator/clock` `tap and hold lower part of screen` `double tap` `tap and hold favorite item`  
:x: Search history  
:x: Customizable gestures  
:x: Folders  
:x: Tags  
:x: Rename apps  
:x: Widgets  
:grey_question: Private space  
:x: Work profile  
:white_check_mark: Pinned shortcuts  
:x: Icon packs  
:x: Material You  

---

### OLauncher

**License:** `GPL-3.0`  
[Repository](https://github.com/tanujnotes/Olauncher) | [F-Droid](https://f-droid.org/en/packages/app.olauncher/)

Extremely minimal launcher with lots of forks.

**Main mode of interaction:** `Search`

#### Features:

:white_check_mark: Search:  `apps`  
:x: Search history. 
:white_check_mark: Customizable gestures: `swipe left` `swipe right` `double tap`  
:x: Folders  
:x: Tags  
:white_check_mark: Rename apps  
:x: Widgets  
:grey_question: Private space  
:white_check_mark: Work profile  
:grey_question: Pinned shortcuts  
:x: Icon packs  
:grey_question: Material You  

#### Forks:

* [Olauncher Clutter Free](https://f-droid.org/en/packages/app.olaunchercf/)
* [mLauncher](https://f-droid.org/en/packages/app.mlauncher/)
* [CLauncher](https://f-droid.org/en/packages/app.clauncher/) (even more minimalistic, search without feedback)
  * [CCLauncher](https://f-droid.org/en/packages/app.cclauncher/) (rewrite using compose)

---
  
### TinyBit Launcher

**License:** `GPL-3.0`  
[Repository](https://github.com/TBog/TBLauncher) | [F-Droid](https://f-droid.org/en/packages/rocks.tbog.tblauncher/)

**Main mode of interaction:** `search` `some gestures`

#### Features:

:white_check_mark: Search:  `apps` `contacts` `web` `maps` `playstore` `youtube`  
:white_check_mark: Search history  
:white_check_mark: Customizable gestures: `tap` `double tap` `swipe up` `swipe left` `swipe right` `swipe down on left` `swipe down on right`  
:x: Folders  
:white_check_mark: Tags  
:white_check_mark: Rename apps  
:white_check_mark: Widgets  
:grey_question: Private space  
:white_check_mark: Work profile  
:white_check_mark: Pinned shortcuts  
:white_check_mark: Icon packs  
:x: Material You  

---

### YAM Launcher

**License:** `MIT`  
[Repository](https://codeberg.org/ottoptj/yamlauncher) | [F-Droid](https://f-droid.org/en/packages/eu.ottop.yamlauncher/)

Similar to OLauncher?

**Main mode of interaction:** `search` `home screen text buttons`

#### Features:

:white_check_mark: Search:  `apps` `contacts (optional)`  
:x: Search history  
:white_check_mark: Customizable gestures: `swipe left` `swipe right`  
:x: Folders  
:x: Tags  
:white_check_mark: Rename apps  
:x: Widgets  
:grey_question: Private space  
:white_check_mark: Work profile  
:white_check_mark: Pinned shortcuts  
:x: Icon packs  
:white_check_mark: Material You  

---

## Directory-Based

### folder launcher

**License:** `MIT`  
[Repository](https://github.com/Robby-Blue/SimpleFolderLauncher) | [F-Droid](https://f-droid.org/en/packages/me.robbyblue.mylauncher/)

**Main mode of interaction:** `directory navigation`

#### Features:

:white_check_mark: Search:  `apps`  
:x: Search history  
:x: Customizable gestures  
:white_check_mark: Folders  
:x: Tags  
:white_check_mark: Rename apps  
:white_check_mark: Widgets  
:grey_question: Private space  
:x: Work profile  
:white_check_mark: Pinned shortcuts  
:x: Icon packs  
:x: Material You  

---

### Ion Launcher

**License:** `GPL-3.0`  
[Repository](https://codeberg.org/zagura/ion-launcher) | [F-Droid](https://f-droid.org/en/packages/one.zagura.IonLauncher/)

**Main mode of interaction:** `App grid` `Search`

#### Features:

:warning: Search:  `apps` `contacts: buggy/broken`  
:white_check_mark: Search history: `shows recently launched apps`  
:x: Customizable gestures  
:warning: Folders `prebuilt` `not customizable`  
:x: Tags  
:white_check_mark: Rename apps  
:x: Widgets  
:grey_question: Private space  
:white_check_mark: Work profile  
:white_check_mark: Pinned shortcuts  
:white_check_mark: Icon packs  
:x: Material You  

---

## Gesture-Based

### Pie Launcher

**License:** `MIT`  
[Repository](https://github.com/markusfisch/PieLauncher)

**Main mode of interaction:** `Selection wheel`

#### Features:

:white_check_mark: Search:  `apps`  
:x: Search history  
:x: Customizable gestures  
:x: Folders  
:x: Tags  
:x: Rename apps  
:x: Widgets  
:grey_question: Private space  
:white_check_mark: Work profile  
:white_check_mark: Pinned shortcuts  
:x: Icon packs  
:x: Material You  

---

### µLauncher

**License:** `MIT`  
[Repository](https://github.com/jrpie/launcher) | [F-Droid](https://f-droid.org/en/packages/de.jrpie.android.launcher/)

**Main mode of interaction:** `Gestures` `Search`

#### Features:

:white_check_mark: Search:  `apps`  
:x: Search history  
:white_check_mark: Customizable gestures: `35 avilable` [read the docs](https://github.com/jrpie/launcher/blob/master/docs/actions-and-gestures.md)  
:x: Folders  
:x: Tags  
:white_check_mark: Rename apps  
:white_check_mark: Widgets  
:white_check_mark: Private space  
:white_check_mark: Work profile  
:white_check_mark: Pinned shortcuts  
:x:Icon packs  
:white_check_mark: Material You  

---

## Tabular Summary

#### Legend:

:white_check_mark: = Supported
:x: = Unsupported
:warning: = Buggy/Broken; check this launcher's notes above

| Launcher                                             | Search             | Search history     | Customizable gestures | Folders            | Tags               | Rename apps        | Widgets            | Private space      | Work profile       | Pinned shortcuts   | Icon packs         | Material You       |
|------------------------------------------------------|--------------------|--------------------|-----------------------|--------------------|--------------------|--------------------|--------------------|--------------------|--------------------|--------------------|--------------------|--------------------|
| [µLauncher](#µLauncher)                              | :white_check_mark: | :x:                | :white_check_mark:    | :x:                | :x:                | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :white_check_mark: | :x:                | :white_check_mark: |
| [Fossify](#Fossify)                                  | :white_check_mark: | :x:                | :x:                   | :white_check_mark: | :x:                | :white_check_mark: | :white_check_mark: | :grey_question:    | :x:                | :white_check_mark: | :x:                | :white_check_mark: |
| [Lawnchair](#Lawnchair)                              | :white_check_mark: | :white_check_mark: | :white_check_mark:    | :white_check_mark: | :x:                | :white_check_mark: | :white_check_mark: | :grey_question:    | :grey_question:    | :x:                | :white_check_mark: | :white_check_mark: |
| [Rootless Pixel Launcher](#Rootless-Pixel-Launcher)  | :white_check_mark: | :x:                | :x:                   | :x:                | :x:                | :x:                | :warning:          | :grey_question:    | :white_check_mark: | :white_check_mark: | :white_check_mark: | :x:                |
| [KISS Launcher](#KISS-Launcher)                      | :white_check_mark: | :white_check_mark: | :white_check_mark:    | :x:                | :white_check_mark: | :white_check_mark: | :white_check_mark: | :grey_question:    | :white_check_mark: | :white_check_mark: | :white_check_mark: | :grey_question:    |
| [Lunar Launcher](#Lunar-Launcher)                    | :white_check_mark: | :x:                | :x:                   | :x:                | :x:                | :x:                | :x:                | :grey_question:    | :x:                | :white_check_mark: | :x:                | :x:                |
| [OLauncher](#OLauncher)                              | :white_check_mark: | :x:                | :white_check_mark:    | :x:                | :x:                | :white_check_mark: | :x:                | :grey_question:    | :white_check_mark: | :grey_question:    | :x:                | :grey_question:    |
| [TinyBit Launcher](#TinyBit-Launcher)                | :white_check_mark: | :white_check_mark: | :white_check_mark:    | :x:                | :white_check_mark: | :white_check_mark: | :white_check_mark: | :grey_question:    | :white_check_mark: | :white_check_mark: | :white_check_mark: | :x:                |
| [YAM Launcher](#YAM-Launcher)                        | :white_check_mark: | :x:                | :white_check_mark:    | :x:                | :x:                | :white_check_mark: | :x:                | :grey_question:    | :white_check_mark: | :white_check_mark: | :x:                | :white_check_mark: |
| [Ion Launcher](#Ion-Launcher)                        | :warning:          | :white_check_mark: | :x:                   | :warning:          | :x:                | :white_check_mark: | :x:                | :grey_question:    | :white_check_mark: | :white_check_mark: | :white_check_mark: | :x:                |
| [Pie Launcher](#Pie-Launcher)                        | :white_check_mark: | :x:                | :x:                   | :x:                | :x:                | :x:                | :x:                | :grey_question:    | :white_check_mark: | :white_check_mark: | :x:                | :x:                |
| [folder launcher](#folder-launcher)                  | :white_check_mark: | :x:                | :x:                   | :white_check_mark: | :x:                | :white_check_mark: | :white_check_mark: | :grey_question:    | :x:                | :white_check_mark: | :x:                | :x:                |
| [Discreet Launcher](#Discreet-Launcher)              | :white_check_mark: | :x:                | :x:                   | :white_check_mark: | :x:                | :white_check_mark: | :x:                | :grey_question:    | :white_check_mark: | :white_check_mark: | :white_check_mark: | :x:                |
| [Aster Launcher](#Aster-Launcher)                    | :warning:          | :x:                | :x:                   | :x:                | :x:                | :x:                | :x:                | :grey_question:    | :white_check_mark: | :white_check_mark: | :x:                | :x:                |

<!-- Automating checkboxes for the table

You can use this python script, copy the contents of the Features section for the launcher, and paste it in the fixit() function. Note, since you're pasting in multiple lines, you will need to start and end your paste with triple-quotes.

import re
def fix(features):
    # Use: fixed("""<paste here>""")
    fixed = ' | '.join(re.findall('(:[\w\_]*:)', features))
    return f"| {fixed} |"

-->

---

## Not Tested
Feel free to test these and add 
* https://f-droid.org/en/packages/app.easy.launcher/
* https://f-droid.org/en/packages/de.nodomain.tobihille.seniorlauncher/
* https://f-droid.org/en/packages/com.mrmannwood.hexlauncher/
* https://f-droid.org/en/packages/com.simplemobiletools.applauncher/
* https://f-droid.org/en/packages/peterfajdiga.fastdraw/
* https://f-droid.org/en/packages/de.mm20.launcher2.release/
* https://apt.izzysoft.de/fdroid/index/apk/com.saggitt.omega
* [Even more launchers](https://docs.arcticons.com/faq/supported-launchers) (most of them don't seem to be FOSS)

The code for this page can be found on [GitHub](https://github.com/jrpie/launcher/blob/master/docs/alternatives.md).
