package de.jepfa.yapm.usecase.label

import de.jepfa.yapm.service.label.LabelFilter
import de.jepfa.yapm.service.label.LabelService
import de.jepfa.yapm.ui.SecureActivity
import de.jepfa.yapm.ui.label.Label
import de.jepfa.yapm.usecase.InputUseCase


object DeleteLabelUseCase: InputUseCase<Label, SecureActivity>() {

    override suspend fun doExecute(label: Label, activity: SecureActivity): Boolean {
        val key = activity.masterSecretKey
        val labelId = label.labelId
        if (key != null && labelId != null) {
            val credentialsToUpdate = LabelService.defaultHolder.getCredentialIdsForLabelId(labelId)
            credentialsToUpdate?.forEach { credentialId ->
                val credential = activity.getApp().credentialRepository.findByIdSync(credentialId)

                credential?.let {
                    val labels = LabelService.defaultHolder.decryptLabelsForCredential(key, credential)

                    val remainingLabelChips = labels
                        .filterNot { it.labelId == labelId}
                        .map { it.name }
                    val encLabelIds = LabelService.defaultHolder.encryptLabelIds(key, remainingLabelChips)
                    credential.labels = encLabelIds
                    activity.credentialViewModel.update(credential, activity)
                    LabelService.defaultHolder.updateLabelsForCredential(key, credential)

                }

            }
            LabelService.defaultHolder.removeLabel(label)
            LabelFilter.unsetFilterFor(label)
            activity.labelViewModel.deleteById(label.labelId, activity)
        }

        return true
    }

}