![](https://github.com/LinXunFeng/flutter_assets/raw/main/flutter_scrollview_observer/banner.png)

# Flutter ScrollView Observer

[![author](https://img.shields.io/badge/author-LinXunFeng-blue.svg?style=flat-square&logo=Iconify)](https://github.com/LinXunFeng/) [![pub](https://img.shields.io/pub/v/scrollview_observer?&style=flat-square&label=pub&logo=dart)](https://pub.dev/packages/scrollview_observer) [![stars](https://img.shields.io/github/stars/fluttercandies/flutter_scrollview_observer?style=flat-square&logo=github)](https://github.com/fluttercandies/flutter_scrollview_observer)

Language: English | [中文](https://github.com/fluttercandies/flutter_scrollview_observer/blob/main/README-zh.md)


This is a library of widget that can be used to listen for child widgets those are being displayed in the scroll view.

## ☕ Support me

[![ko-fi](https://ko-fi.com/img/githubbutton_sm.svg)](https://ko-fi.com/T6T4JKVRP) [![wechat](https://img.shields.io/static/v1?label=WeChat&message=WeChat&nbsp;Pay&color=brightgreen&style=for-the-badge&logo=WeChat)](https://cdn.jsdelivr.net/gh/FullStackAction/PicBed@resource20220417121922/image/202303181116760.jpeg)

Chat: [Join WeChat group](https://mp.weixin.qq.com/s/JBbMstn0qW6M71hh-BRKzw)

## 📖 Article

- [Flutter - Getting the items information those are currently displaying in ScrollView](https://medium.com/@linxunfeng/flutter-gets-the-items-information-those-are-currently-displaying-in-scrollview-6cb4f27f2536) | [WeChat](https://mp.weixin.qq.com/s/cN3qeinBPlo5rtEpoQBVVA) | [JueJin](https://juejin.cn/post/7103058155692621837)
- [Flutter - Scrolling to a specific item in the ScrollView！🔥](https://medium.com/@linxunfeng/flutter-scrolling-to-a-specific-item-in-the-scrollview-b89d3f10eee0) | [WeChat](https://mp.weixin.qq.com/s/fplqfBpXwvx6mEO6vflkww) | [JueJin](https://juejin.cn/post/7129888644290068487)
- [Flutter - Quickly implement the effect of the chat session list, perfect 💯](https://medium.com/@linxunfeng/flutter-quickly-implement-the-effect-of-the-chat-session-list-perfect-68c8acea4568) | [WeChat](https://mp.weixin.qq.com/s/xNiGuSLcJtDAiLoHuGWp6A) | [JueJin](https://juejin.cn/post/7152307272436154405)
- [Flutter - New upgrade😱Supports observing ScrollView built by third package💪](https://medium.com/@linxunfeng/flutter-new-upgrade-supports-observing-scrollview-built-by-third-package-2e5af3d84c64) | [WeChat](https://mp.weixin.qq.com/s/FMXPyT-lX8YOXVmbLCsVUA) | [JueJin](https://juejin.cn/post/7240751116702269477)
- [Flutter - Play alternately waterfall flow video 🎞](https://medium.com/@linxunfeng/flutter-play-alternately-waterfall-flow-video-015279bc8e14) | [WeChat](https://mp.weixin.qq.com/s/miP5CfKtcRhFGr08ot5wOg) | [JueJin](https://juejin.cn/post/7243240589293142077)
- [Flutter - Keep IM message position greatly upgraded (supports generative messages like ChatGPT) 🤖](https://medium.com/@linxunfeng/flutter-keep-im-message-position-greatly-upgraded-supports-generative-messages-like-chatgpt-2b199a7b14e7) | [WeChat](https://mp.weixin.qq.com/s/Y3EN9ZpLb6HLke2vkw0Zwg) | [JueJin](https://juejin.cn/post/7245753944180523067)
- [Flutter - Anti-occlusion of form in ScrollView 🗒](https://medium.com/@linxunfeng/flutter-anti-occlusion-of-form-in-scrollview-ad8bde15e18d) | [WeChat](https://mp.weixin.qq.com/s/iaHyYMjZSPBggLw2yZv8dQ) | [JueJin](https://juejin.cn/spost/7266455050632921107)
- [Flutter - Quickly achieve half-view exposure statistic 📊](https://medium.com/@linxunfeng/flutter-quickly-achieve-half-view-exposure-statistic-097fd4b237ef) | [WeChat](https://mp.weixin.qq.com/s/gNFX4Au4esftgTPXHvB4LQ) | [JueJin](https://juejin.cn/post/7271248528998121512)
- [Flutter - How to quickly implement an contact list page (azlist) 📓](https://medium.com/@linxunfeng/flutter-how-to-quickly-implement-an-contact-list-page-azlist-829bbef12d8f) | [WeChat](https://mp.weixin.qq.com/s/1bmYSvtOYX83DLncvnBjqA) | [JueJin](https://juejin.cn/post/7294884963631497254)
- [Flutter - Supports observing NestedScrollView, with greater compatibility 😈](https://medium.com/@linxunfeng/flutter-supports-observing-nestedscrollview-with-greater-compatibility-86f49dce7955) | [WeChat](https://mp.weixin.qq.com/s/1dsmRg8q2VJ6HzasLgoVpA) | [JueJin](https://juejin.cn/post/7388444606456840211)
- [Flutter - Offset effect in PageView](https://medium.com/@linxunfeng/flutter-offset-effect-in-pageview-cec39572d56a) | [WeChat](https://mp.weixin.qq.com/s/Q8zk89bgr_8bgWQ4F86VUQ) | [JueJin](https://juejin.cn/post/7411516362916216859)
- [Flutter - Parallax effect in PageView](https://medium.com/@linxunfeng/flutter-parallax-effect-in-pageview-ccff6b0b34aa) | [WeChat](https://mp.weixin.qq.com/s/Fi-X2eJRWj17sqCcVqbPRQ) | [JueJin](https://juejin.cn/post/7416655730214699017)
- [Flutter - Syncing Detail Page TabBar with Modules? Nailed It!](https://medium.com/@linxunfeng/flutter-syncing-detail-page-tabbar-with-modules-nailed-it-60f2ca67e100) | [WeChat](https://mp.weixin.qq.com/s/uLRLzxS4IqmCq0gewTS8kQ) | [JueJin](https://juejin.cn/post/7538868042961911817)
- [Flutter - Initial Anchor And Optimization For Detail Pages](https://medium.com/@linxunfeng/flutter-initial-anchor-and-optimization-for-detail-pages-86aa5b9c4186) | [WeChat](https://mp.weixin.qq.com/s/hRPc_eHjl0OSKFKfmj6q_g) | [JueJin](https://juejin.cn/post/7541801054188109850)

## 🔨 Feature

> You do not need to change the view you are currently using, just wrap a `ViewObserver` around the view to achieve the following features.

- [x] Observing child widgets those are being displayed in ScrollView
- [x] Support for scrolling to a specific item in ScrollView
- [x] Quickly implement the chat session page effect
- [x] Support for keeping IM message position when inserting or updating messages, avoiding jitter.

## 🎀 Support

- [x] `PageView`
- [x] `ListView`
- [x] `SliverList`
- [x] `GridView`
- [x] `SliverGrid`
- [x] Mixing usage of `SliverPersistentHeader`, `SliverList` and `SliverGrid`
- [x] `NestedScrollView`
- [x] `ScrollView` built by third-party package.

## 🕹 Preview

- 🖥 [Online Preview](https://fluttercandies.github.io/flutter_scrollview_observer/)
- 🏞 [Sample images](https://github.com/fluttercandies/flutter_scrollview_observer/wiki/Example)

## 📦 Installing

Add `scrollview_observer` to your pubspec.yaml file:


```yaml
dependencies:
  scrollview_observer: latest_version
```

Import `scrollview_observer` in files that it will be used:

```dart
import 'package:scrollview_observer/scrollview_observer.dart';
```

## 📚 Wiki

- [Wiki Home](https://github.com/fluttercandies/flutter_scrollview_observer/wiki)
- [1、Observing child widgets those are being displayed in the ScrollView](https://github.com/fluttercandies/flutter_scrollview_observer/wiki/1%E3%80%81Observing-child-widgets-those-are-being-displayed-in-the-ScrollView)
- [2、Scrolling to the specified index location](https://github.com/fluttercandies/flutter_scrollview_observer/wiki/2%E3%80%81Scrolling-to-the-specified-index-location)
- [3、Chat Observer](https://github.com/fluttercandies/flutter_scrollview_observer/wiki/3%E3%80%81Chat-Observer)

## 🖨 About Me

- GitHub: [https://github.com/LinXunFeng](https://github.com/LinXunFeng)
- Email: [linxunfeng@yeah.net](mailto:linxunfeng@yeah.net)
- Blogs: 
  - 全栈行动: [https://fullstackaction.com](https://fullstackaction.com)
  - 掘金: [https://juejin.cn/user/1820446984512392](https://juejin.cn/user/1820446984512392) 

<img height="267.5" width="481.5" src="https://github.com/LinXunFeng/LinXunFeng/raw/master/static/img/FSAQR.png"/>