import 'package:flutter/services.dart';
import 'package:flutter_test/flutter_test.dart';
import 'package:flutter_sound_bridge/flutter_sound_bridge_method_channel.dart';

void main() {
  MethodChannelFlutterSoundBridge platform = MethodChannelFlutterSoundBridge();
  const MethodChannel channel = MethodChannel('flutter_sound_bridge');

  TestWidgetsFlutterBinding.ensureInitialized();

  setUp(() {
    channel.setMockMethodCallHandler((MethodCall methodCall) async {
      return '42';
    });
  });

  tearDown(() {
    channel.setMockMethodCallHandler(null);
  });

  test('getPlatformVersion', () async {
    expect(await platform.getPlatformVersion(), '42');
  });
}
