import 'package:simple_sparse_list/simple_sparse_list.dart';

UnicodeBlock getUnicodeBlock(int character) {
  if (character < 0 || character > 1114111) {
    throw RangeError.range(character, 0, 1114111, 'character');
  }

  final result = _data[character];
  return result;
}

enum UnicodeBlock {adlam, aegeanNumbers, ahom, alchemicalSymbols, alphabeticPresentationForms, anatolianHieroglyphs, ancientGreekMusicalNotation, ancientGreekNumbers, ancientSymbols, arabic, arabicExtendedA, arabicExtendedB, arabicExtendedC, arabicMathematicalAlphabeticSymbols, arabicPresentationFormsA, arabicPresentationFormsB, arabicSupplement, armenian, arrows, avestan, balinese, bamum, bamumSupplement, basicLatin, bassaVah, batak, bengali, bhaiksuki, blockElements, bopomofo, bopomofoExtended, boxDrawing, brahmi, braillePatterns, buginese, buhid, byzantineMusicalSymbols, carian, caucasianAlbanian, chakma, cham, cherokee, cherokeeSupplement, chessSymbols, chorasmian, cjkCompatibility, cjkCompatibilityForms, cjkCompatibilityIdeographs, cjkCompatibilityIdeographsSupplement, cjkRadicalsSupplement, cjkStrokes, cjkSymbolsandPunctuation, cjkUnifiedIdeographs, cjkUnifiedIdeographsExtensionA, cjkUnifiedIdeographsExtensionB, cjkUnifiedIdeographsExtensionC, cjkUnifiedIdeographsExtensionD, cjkUnifiedIdeographsExtensionE, cjkUnifiedIdeographsExtensionF, cjkUnifiedIdeographsExtensionG, cjkUnifiedIdeographsExtensionH, cjkUnifiedIdeographsExtensionI, combiningDiacriticalMarks, combiningDiacriticalMarksExtended, combiningDiacriticalMarksSupplement, combiningDiacriticalMarksforSymbols, combiningHalfMarks, commonIndicNumberForms, controlPictures, coptic, copticEpactNumbers, countingRodNumerals, cuneiform, cuneiformNumbersandPunctuation, currencySymbols, cypriotSyllabary, cyproMinoan, cyrillic, cyrillicExtendedA, cyrillicExtendedB, cyrillicExtendedC, cyrillicExtendedD, cyrillicSupplement, deseret, devanagari, devanagariExtended, devanagariExtendedA, dingbats, divesAkuru, dogra, dominoTiles, duployan, earlyDynasticCuneiform, egyptianHieroglyphFormatControls, egyptianHieroglyphs, egyptianHieroglyphsExtendedA, elbasan, elymaic, emoticons, enclosedAlphanumericSupplement, enclosedAlphanumerics, enclosedCJKLettersandMonths, enclosedIdeographicSupplement, ethiopic, ethiopicExtended, ethiopicExtendedA, ethiopicExtendedB, ethiopicSupplement, garay, generalPunctuation, geometricShapes, geometricShapesExtended, georgian, georgianExtended, georgianSupplement, glagolitic, glagoliticSupplement, gothic, grantha, greekExtended, greekandCoptic, gujarati, gunjalaGondi, gurmukhi, gurungKhema, halfwidthandFullwidthForms, hangulCompatibilityJamo, hangulJamo, hangulJamoExtendedA, hangulJamoExtendedB, hangulSyllables, hanifiRohingya, hanunoo, hatran, hebrew, highPrivateUseSurrogates, highSurrogates, hiragana, ideographicDescriptionCharacters, ideographicSymbolsandPunctuation, imperialAramaic, indicSiyaqNumbers, inscriptionalPahlavi, inscriptionalParthian, ipaExtensions, javanese, kaithi, kaktovikNumerals, kanaExtendedA, kanaExtendedB, kanaSupplement, kanbun, kangxiRadicals, kannada, katakana, katakanaPhoneticExtensions, kawi, kayahLi, kharoshthi, khitanSmallScript, khmer, khmerSymbols, khojki, khudawadi, kiratRai, lao, latin1Supplement, latinExtendedA, latinExtendedAdditional, latinExtendedB, latinExtendedC, latinExtendedD, latinExtendedE, latinExtendedF, latinExtendedG, lepcha, letterlikeSymbols, limbu, linearA, linearBIdeograms, linearBSyllabary, lisu, lisuSupplement, lowSurrogates, lycian, lydian, mahajani, mahjongTiles, makasar, malayalam, mandaic, manichaean, marchen, masaramGondi, mathematicalAlphanumericSymbols, mathematicalOperators, mayanNumerals, medefaidrin, meeteiMayek, meeteiMayekExtensions, mendeKikakui, meroiticCursive, meroiticHieroglyphs, miao, miscellaneousMathematicalSymbolsA, miscellaneousMathematicalSymbolsB, miscellaneousSymbols, miscellaneousSymbolsandArrows, miscellaneousSymbolsandPictographs, miscellaneousTechnical, modi, modifierToneLetters, mongolian, mongolianSupplement, mro, multani, musicalSymbols, myanmar, myanmarExtendedA, myanmarExtendedB, myanmarExtendedC, nKo, nabataean, nagMundari, nandinagari, newTaiLue, newa, noBlock, numberForms, nushu, nyiakengPuachueHmong, ogham, olChiki, olOnal, oldHungarian, oldItalic, oldNorthArabian, oldPermic, oldPersian, oldSogdian, oldSouthArabian, oldTurkic, oldUyghur, opticalCharacterRecognition, oriya, ornamentalDingbats, osage, osmanya, ottomanSiyaqNumbers, pahawhHmong, palmyrene, pauCinHau, phagspa, phaistosDisc, phoenician, phoneticExtensions, phoneticExtensionsSupplement, playingCards, privateUseArea, psalterPahlavi, rejang, rumiNumeralSymbols, runic, samaritan, saurashtra, sharada, shavian, shorthandFormatControls, siddham, sinhala, sinhalaArchaicNumbers, smallFormVariants, smallKanaExtension, sogdian, soraSompeng, soyombo, spacingModifierLetters, specials, sundanese, sundaneseSupplement, sunuwar, superscriptsandSubscripts, supplementalArrowsA, supplementalArrowsB, supplementalArrowsC, supplementalMathematicalOperators, supplementalPunctuation, supplementalSymbolsandPictographs, supplementaryPrivateUseAreaA, supplementaryPrivateUseAreaB, suttonSignWriting, sylotiNagri, symbolsandPictographsExtendedA, symbolsforLegacyComputing, symbolsforLegacyComputingSupplement, syriac, syriacSupplement, tagalog, tagbanwa, tags, taiLe, taiTham, taiViet, taiXuanJingSymbols, takri, tamil, tamilSupplement, tangsa, tangut, tangutComponents, tangutSupplement, telugu, thaana, thai, tibetan, tifinagh, tirhuta, todhri, toto, transportandMapSymbols, tuluTigalari, ugaritic, unifiedCanadianAboriginalSyllabics, unifiedCanadianAboriginalSyllabicsExtended, unifiedCanadianAboriginalSyllabicsExtendedA, vai, variationSelectors, variationSelectorsSupplement, vedicExtensions, verticalForms, vithkuqi, wancho, warangCiti, yezidi, yiRadicals, yiSyllables, yijingHexagramSymbols, zanabazarSquare, znamennyMusicalNotation}

final _data = SparseList([(0, 127, UnicodeBlock.basicLatin), (128, 255, UnicodeBlock.latin1Supplement), (256, 383, UnicodeBlock.latinExtendedA), (384, 591, UnicodeBlock.latinExtendedB), (592, 687, UnicodeBlock.ipaExtensions), (688, 767, UnicodeBlock.spacingModifierLetters), (768, 879, UnicodeBlock.combiningDiacriticalMarks), (880, 1023, UnicodeBlock.greekandCoptic), (1024, 1279, UnicodeBlock.cyrillic), (1280, 1327, UnicodeBlock.cyrillicSupplement), (1328, 1423, UnicodeBlock.armenian), (1424, 1535, UnicodeBlock.hebrew), (1536, 1791, UnicodeBlock.arabic), (1792, 1871, UnicodeBlock.syriac), (1872, 1919, UnicodeBlock.arabicSupplement), (1920, 1983, UnicodeBlock.thaana), (1984, 2047, UnicodeBlock.nKo), (2048, 2111, UnicodeBlock.samaritan), (2112, 2143, UnicodeBlock.mandaic), (2144, 2159, UnicodeBlock.syriacSupplement), (2160, 2207, UnicodeBlock.arabicExtendedB), (2208, 2303, UnicodeBlock.arabicExtendedA), (2304, 2431, UnicodeBlock.devanagari), (2432, 2559, UnicodeBlock.bengali), (2560, 2687, UnicodeBlock.gurmukhi), (2688, 2815, UnicodeBlock.gujarati), (2816, 2943, UnicodeBlock.oriya), (2944, 3071, UnicodeBlock.tamil), (3072, 3199, UnicodeBlock.telugu), (3200, 3327, UnicodeBlock.kannada), (3328, 3455, UnicodeBlock.malayalam), (3456, 3583, UnicodeBlock.sinhala), (3584, 3711, UnicodeBlock.thai), (3712, 3839, UnicodeBlock.lao), (3840, 4095, UnicodeBlock.tibetan), (4096, 4255, UnicodeBlock.myanmar), (4256, 4351, UnicodeBlock.georgian), (4352, 4607, UnicodeBlock.hangulJamo), (4608, 4991, UnicodeBlock.ethiopic), (4992, 5023, UnicodeBlock.ethiopicSupplement), (5024, 5119, UnicodeBlock.cherokee), (5120, 5759, UnicodeBlock.unifiedCanadianAboriginalSyllabics), (5760, 5791, UnicodeBlock.ogham), (5792, 5887, UnicodeBlock.runic), (5888, 5919, UnicodeBlock.tagalog), (5920, 5951, UnicodeBlock.hanunoo), (5952, 5983, UnicodeBlock.buhid), (5984, 6015, UnicodeBlock.tagbanwa), (6016, 6143, UnicodeBlock.khmer), (6144, 6319, UnicodeBlock.mongolian), (6320, 6399, UnicodeBlock.unifiedCanadianAboriginalSyllabicsExtended), (6400, 6479, UnicodeBlock.limbu), (6480, 6527, UnicodeBlock.taiLe), (6528, 6623, UnicodeBlock.newTaiLue), (6624, 6655, UnicodeBlock.khmerSymbols), (6656, 6687, UnicodeBlock.buginese), (6688, 6831, UnicodeBlock.taiTham), (6832, 6911, UnicodeBlock.combiningDiacriticalMarksExtended), (6912, 7039, UnicodeBlock.balinese), (7040, 7103, UnicodeBlock.sundanese), (7104, 7167, UnicodeBlock.batak), (7168, 7247, UnicodeBlock.lepcha), (7248, 7295, UnicodeBlock.olChiki), (7296, 7311, UnicodeBlock.cyrillicExtendedC), (7312, 7359, UnicodeBlock.georgianExtended), (7360, 7375, UnicodeBlock.sundaneseSupplement), (7376, 7423, UnicodeBlock.vedicExtensions), (7424, 7551, UnicodeBlock.phoneticExtensions), (7552, 7615, UnicodeBlock.phoneticExtensionsSupplement), (7616, 7679, UnicodeBlock.combiningDiacriticalMarksSupplement), (7680, 7935, UnicodeBlock.latinExtendedAdditional), (7936, 8191, UnicodeBlock.greekExtended), (8192, 8303, UnicodeBlock.generalPunctuation), (8304, 8351, UnicodeBlock.superscriptsandSubscripts), (8352, 8399, UnicodeBlock.currencySymbols), (8400, 8447, UnicodeBlock.combiningDiacriticalMarksforSymbols), (8448, 8527, UnicodeBlock.letterlikeSymbols), (8528, 8591, UnicodeBlock.numberForms), (8592, 8703, UnicodeBlock.arrows), (8704, 8959, UnicodeBlock.mathematicalOperators), (8960, 9215, UnicodeBlock.miscellaneousTechnical), (9216, 9279, UnicodeBlock.controlPictures), (9280, 9311, UnicodeBlock.opticalCharacterRecognition), (9312, 9471, UnicodeBlock.enclosedAlphanumerics), (9472, 9599, UnicodeBlock.boxDrawing), (9600, 9631, UnicodeBlock.blockElements), (9632, 9727, UnicodeBlock.geometricShapes), (9728, 9983, UnicodeBlock.miscellaneousSymbols), (9984, 10175, UnicodeBlock.dingbats), (10176, 10223, UnicodeBlock.miscellaneousMathematicalSymbolsA), (10224, 10239, UnicodeBlock.supplementalArrowsA), (10240, 10495, UnicodeBlock.braillePatterns), (10496, 10623, UnicodeBlock.supplementalArrowsB), (10624, 10751, UnicodeBlock.miscellaneousMathematicalSymbolsB), (10752, 11007, UnicodeBlock.supplementalMathematicalOperators), (11008, 11263, UnicodeBlock.miscellaneousSymbolsandArrows), (11264, 11359, UnicodeBlock.glagolitic), (11360, 11391, UnicodeBlock.latinExtendedC), (11392, 11519, UnicodeBlock.coptic), (11520, 11567, UnicodeBlock.georgianSupplement), (11568, 11647, UnicodeBlock.tifinagh), (11648, 11743, UnicodeBlock.ethiopicExtended), (11744, 11775, UnicodeBlock.cyrillicExtendedA), (11776, 11903, UnicodeBlock.supplementalPunctuation), (11904, 12031, UnicodeBlock.cjkRadicalsSupplement), (12032, 12255, UnicodeBlock.kangxiRadicals), (12272, 12287, UnicodeBlock.ideographicDescriptionCharacters), (12288, 12351, UnicodeBlock.cjkSymbolsandPunctuation), (12352, 12447, UnicodeBlock.hiragana), (12448, 12543, UnicodeBlock.katakana), (12544, 12591, UnicodeBlock.bopomofo), (12592, 12687, UnicodeBlock.hangulCompatibilityJamo), (12688, 12703, UnicodeBlock.kanbun), (12704, 12735, UnicodeBlock.bopomofoExtended), (12736, 12783, UnicodeBlock.cjkStrokes), (12784, 12799, UnicodeBlock.katakanaPhoneticExtensions), (12800, 13055, UnicodeBlock.enclosedCJKLettersandMonths), (13056, 13311, UnicodeBlock.cjkCompatibility), (13312, 19903, UnicodeBlock.cjkUnifiedIdeographsExtensionA), (19904, 19967, UnicodeBlock.yijingHexagramSymbols), (19968, 40959, UnicodeBlock.cjkUnifiedIdeographs), (40960, 42127, UnicodeBlock.yiSyllables), (42128, 42191, UnicodeBlock.yiRadicals), (42192, 42239, UnicodeBlock.lisu), (42240, 42559, UnicodeBlock.vai), (42560, 42655, UnicodeBlock.cyrillicExtendedB), (42656, 42751, UnicodeBlock.bamum), (42752, 42783, UnicodeBlock.modifierToneLetters), (42784, 43007, UnicodeBlock.latinExtendedD), (43008, 43055, UnicodeBlock.sylotiNagri), (43056, 43071, UnicodeBlock.commonIndicNumberForms), (43072, 43135, UnicodeBlock.phagspa), (43136, 43231, UnicodeBlock.saurashtra), (43232, 43263, UnicodeBlock.devanagariExtended), (43264, 43311, UnicodeBlock.kayahLi), (43312, 43359, UnicodeBlock.rejang), (43360, 43391, UnicodeBlock.hangulJamoExtendedA), (43392, 43487, UnicodeBlock.javanese), (43488, 43519, UnicodeBlock.myanmarExtendedB), (43520, 43615, UnicodeBlock.cham), (43616, 43647, UnicodeBlock.myanmarExtendedA), (43648, 43743, UnicodeBlock.taiViet), (43744, 43775, UnicodeBlock.meeteiMayekExtensions), (43776, 43823, UnicodeBlock.ethiopicExtendedA), (43824, 43887, UnicodeBlock.latinExtendedE), (43888, 43967, UnicodeBlock.cherokeeSupplement), (43968, 44031, UnicodeBlock.meeteiMayek), (44032, 55215, UnicodeBlock.hangulSyllables), (55216, 55295, UnicodeBlock.hangulJamoExtendedB), (55296, 56191, UnicodeBlock.highSurrogates), (56192, 56319, UnicodeBlock.highPrivateUseSurrogates), (56320, 57343, UnicodeBlock.lowSurrogates), (57344, 63743, UnicodeBlock.privateUseArea), (63744, 64255, UnicodeBlock.cjkCompatibilityIdeographs), (64256, 64335, UnicodeBlock.alphabeticPresentationForms), (64336, 65023, UnicodeBlock.arabicPresentationFormsA), (65024, 65039, UnicodeBlock.variationSelectors), (65040, 65055, UnicodeBlock.verticalForms), (65056, 65071, UnicodeBlock.combiningHalfMarks), (65072, 65103, UnicodeBlock.cjkCompatibilityForms), (65104, 65135, UnicodeBlock.smallFormVariants), (65136, 65279, UnicodeBlock.arabicPresentationFormsB), (65280, 65519, UnicodeBlock.halfwidthandFullwidthForms), (65520, 65535, UnicodeBlock.specials), (65536, 65663, UnicodeBlock.linearBSyllabary), (65664, 65791, UnicodeBlock.linearBIdeograms), (65792, 65855, UnicodeBlock.aegeanNumbers), (65856, 65935, UnicodeBlock.ancientGreekNumbers), (65936, 65999, UnicodeBlock.ancientSymbols), (66000, 66047, UnicodeBlock.phaistosDisc), (66176, 66207, UnicodeBlock.lycian), (66208, 66271, UnicodeBlock.carian), (66272, 66303, UnicodeBlock.copticEpactNumbers), (66304, 66351, UnicodeBlock.oldItalic), (66352, 66383, UnicodeBlock.gothic), (66384, 66431, UnicodeBlock.oldPermic), (66432, 66463, UnicodeBlock.ugaritic), (66464, 66527, UnicodeBlock.oldPersian), (66560, 66639, UnicodeBlock.deseret), (66640, 66687, UnicodeBlock.shavian), (66688, 66735, UnicodeBlock.osmanya), (66736, 66815, UnicodeBlock.osage), (66816, 66863, UnicodeBlock.elbasan), (66864, 66927, UnicodeBlock.caucasianAlbanian), (66928, 67007, UnicodeBlock.vithkuqi), (67008, 67071, UnicodeBlock.todhri), (67072, 67455, UnicodeBlock.linearA), (67456, 67519, UnicodeBlock.latinExtendedF), (67584, 67647, UnicodeBlock.cypriotSyllabary), (67648, 67679, UnicodeBlock.imperialAramaic), (67680, 67711, UnicodeBlock.palmyrene), (67712, 67759, UnicodeBlock.nabataean), (67808, 67839, UnicodeBlock.hatran), (67840, 67871, UnicodeBlock.phoenician), (67872, 67903, UnicodeBlock.lydian), (67968, 67999, UnicodeBlock.meroiticHieroglyphs), (68000, 68095, UnicodeBlock.meroiticCursive), (68096, 68191, UnicodeBlock.kharoshthi), (68192, 68223, UnicodeBlock.oldSouthArabian), (68224, 68255, UnicodeBlock.oldNorthArabian), (68288, 68351, UnicodeBlock.manichaean), (68352, 68415, UnicodeBlock.avestan), (68416, 68447, UnicodeBlock.inscriptionalParthian), (68448, 68479, UnicodeBlock.inscriptionalPahlavi), (68480, 68527, UnicodeBlock.psalterPahlavi), (68608, 68687, UnicodeBlock.oldTurkic), (68736, 68863, UnicodeBlock.oldHungarian), (68864, 68927, UnicodeBlock.hanifiRohingya), (68928, 69007, UnicodeBlock.garay), (69216, 69247, UnicodeBlock.rumiNumeralSymbols), (69248, 69311, UnicodeBlock.yezidi), (69312, 69375, UnicodeBlock.arabicExtendedC), (69376, 69423, UnicodeBlock.oldSogdian), (69424, 69487, UnicodeBlock.sogdian), (69488, 69551, UnicodeBlock.oldUyghur), (69552, 69599, UnicodeBlock.chorasmian), (69600, 69631, UnicodeBlock.elymaic), (69632, 69759, UnicodeBlock.brahmi), (69760, 69839, UnicodeBlock.kaithi), (69840, 69887, UnicodeBlock.soraSompeng), (69888, 69967, UnicodeBlock.chakma), (69968, 70015, UnicodeBlock.mahajani), (70016, 70111, UnicodeBlock.sharada), (70112, 70143, UnicodeBlock.sinhalaArchaicNumbers), (70144, 70223, UnicodeBlock.khojki), (70272, 70319, UnicodeBlock.multani), (70320, 70399, UnicodeBlock.khudawadi), (70400, 70527, UnicodeBlock.grantha), (70528, 70655, UnicodeBlock.tuluTigalari), (70656, 70783, UnicodeBlock.newa), (70784, 70879, UnicodeBlock.tirhuta), (71040, 71167, UnicodeBlock.siddham), (71168, 71263, UnicodeBlock.modi), (71264, 71295, UnicodeBlock.mongolianSupplement), (71296, 71375, UnicodeBlock.takri), (71376, 71423, UnicodeBlock.myanmarExtendedC), (71424, 71503, UnicodeBlock.ahom), (71680, 71759, UnicodeBlock.dogra), (71840, 71935, UnicodeBlock.warangCiti), (71936, 72031, UnicodeBlock.divesAkuru), (72096, 72191, UnicodeBlock.nandinagari), (72192, 72271, UnicodeBlock.zanabazarSquare), (72272, 72367, UnicodeBlock.soyombo), (72368, 72383, UnicodeBlock.unifiedCanadianAboriginalSyllabicsExtendedA), (72384, 72447, UnicodeBlock.pauCinHau), (72448, 72543, UnicodeBlock.devanagariExtendedA), (72640, 72703, UnicodeBlock.sunuwar), (72704, 72815, UnicodeBlock.bhaiksuki), (72816, 72895, UnicodeBlock.marchen), (72960, 73055, UnicodeBlock.masaramGondi), (73056, 73135, UnicodeBlock.gunjalaGondi), (73440, 73471, UnicodeBlock.makasar), (73472, 73567, UnicodeBlock.kawi), (73648, 73663, UnicodeBlock.lisuSupplement), (73664, 73727, UnicodeBlock.tamilSupplement), (73728, 74751, UnicodeBlock.cuneiform), (74752, 74879, UnicodeBlock.cuneiformNumbersandPunctuation), (74880, 75087, UnicodeBlock.earlyDynasticCuneiform), (77712, 77823, UnicodeBlock.cyproMinoan), (77824, 78895, UnicodeBlock.egyptianHieroglyphs), (78896, 78943, UnicodeBlock.egyptianHieroglyphFormatControls), (78944, 82943, UnicodeBlock.egyptianHieroglyphsExtendedA), (82944, 83583, UnicodeBlock.anatolianHieroglyphs), (90368, 90431, UnicodeBlock.gurungKhema), (92160, 92735, UnicodeBlock.bamumSupplement), (92736, 92783, UnicodeBlock.mro), (92784, 92879, UnicodeBlock.tangsa), (92880, 92927, UnicodeBlock.bassaVah), (92928, 93071, UnicodeBlock.pahawhHmong), (93504, 93567, UnicodeBlock.kiratRai), (93760, 93855, UnicodeBlock.medefaidrin), (93952, 94111, UnicodeBlock.miao), (94176, 94207, UnicodeBlock.ideographicSymbolsandPunctuation), (94208, 100351, UnicodeBlock.tangut), (100352, 101119, UnicodeBlock.tangutComponents), (101120, 101631, UnicodeBlock.khitanSmallScript), (101632, 101759, UnicodeBlock.tangutSupplement), (110576, 110591, UnicodeBlock.kanaExtendedB), (110592, 110847, UnicodeBlock.kanaSupplement), (110848, 110895, UnicodeBlock.kanaExtendedA), (110896, 110959, UnicodeBlock.smallKanaExtension), (110960, 111359, UnicodeBlock.nushu), (113664, 113823, UnicodeBlock.duployan), (113824, 113839, UnicodeBlock.shorthandFormatControls), (117760, 118463, UnicodeBlock.symbolsforLegacyComputingSupplement), (118528, 118735, UnicodeBlock.znamennyMusicalNotation), (118784, 119039, UnicodeBlock.byzantineMusicalSymbols), (119040, 119295, UnicodeBlock.musicalSymbols), (119296, 119375, UnicodeBlock.ancientGreekMusicalNotation), (119488, 119519, UnicodeBlock.kaktovikNumerals), (119520, 119551, UnicodeBlock.mayanNumerals), (119552, 119647, UnicodeBlock.taiXuanJingSymbols), (119648, 119679, UnicodeBlock.countingRodNumerals), (119808, 120831, UnicodeBlock.mathematicalAlphanumericSymbols), (120832, 121519, UnicodeBlock.suttonSignWriting), (122624, 122879, UnicodeBlock.latinExtendedG), (122880, 122927, UnicodeBlock.glagoliticSupplement), (122928, 123023, UnicodeBlock.cyrillicExtendedD), (123136, 123215, UnicodeBlock.nyiakengPuachueHmong), (123536, 123583, UnicodeBlock.toto), (123584, 123647, UnicodeBlock.wancho), (124112, 124159, UnicodeBlock.nagMundari), (124368, 124415, UnicodeBlock.olOnal), (124896, 124927, UnicodeBlock.ethiopicExtendedB), (124928, 125151, UnicodeBlock.mendeKikakui), (125184, 125279, UnicodeBlock.adlam), (126064, 126143, UnicodeBlock.indicSiyaqNumbers), (126208, 126287, UnicodeBlock.ottomanSiyaqNumbers), (126464, 126719, UnicodeBlock.arabicMathematicalAlphabeticSymbols), (126976, 127023, UnicodeBlock.mahjongTiles), (127024, 127135, UnicodeBlock.dominoTiles), (127136, 127231, UnicodeBlock.playingCards), (127232, 127487, UnicodeBlock.enclosedAlphanumericSupplement), (127488, 127743, UnicodeBlock.enclosedIdeographicSupplement), (127744, 128511, UnicodeBlock.miscellaneousSymbolsandPictographs), (128512, 128591, UnicodeBlock.emoticons), (128592, 128639, UnicodeBlock.ornamentalDingbats), (128640, 128767, UnicodeBlock.transportandMapSymbols), (128768, 128895, UnicodeBlock.alchemicalSymbols), (128896, 129023, UnicodeBlock.geometricShapesExtended), (129024, 129279, UnicodeBlock.supplementalArrowsC), (129280, 129535, UnicodeBlock.supplementalSymbolsandPictographs), (129536, 129647, UnicodeBlock.chessSymbols), (129648, 129791, UnicodeBlock.symbolsandPictographsExtendedA), (129792, 130047, UnicodeBlock.symbolsforLegacyComputing), (131072, 173791, UnicodeBlock.cjkUnifiedIdeographsExtensionB), (173824, 177983, UnicodeBlock.cjkUnifiedIdeographsExtensionC), (177984, 178207, UnicodeBlock.cjkUnifiedIdeographsExtensionD), (178208, 183983, UnicodeBlock.cjkUnifiedIdeographsExtensionE), (183984, 191471, UnicodeBlock.cjkUnifiedIdeographsExtensionF), (191472, 192095, UnicodeBlock.cjkUnifiedIdeographsExtensionI), (194560, 195103, UnicodeBlock.cjkCompatibilityIdeographsSupplement), (196608, 201551, UnicodeBlock.cjkUnifiedIdeographsExtensionG), (201552, 205743, UnicodeBlock.cjkUnifiedIdeographsExtensionH), (917504, 917631, UnicodeBlock.tags), (917760, 917999, UnicodeBlock.variationSelectorsSupplement), (983040, 1048575, UnicodeBlock.supplementaryPrivateUseAreaA), (1048576, 1114111, UnicodeBlock.supplementaryPrivateUseAreaB)], UnicodeBlock.noBlock, length: 0x110000);
