PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE topic (_id INT NOT NULL PRIMARY KEY, order_index INT NOT NULL UNIQUE, name TEXT NOT NULL, isprimary INT, version INT DEFAULT 1);
INSERT INTO topic VALUES(1,1,'Technische Kenntnisse (Klasse E)',1,1);
INSERT INTO topic VALUES(2,2,'Technische Kenntnisse (Klasse A)',1,1);
INSERT INTO topic VALUES(3,3,'Betriebliche Kenntnisse',1,1);
INSERT INTO topic VALUES(4,4,'Kenntnisse von Vorschriften',1,1);
INSERT INTO topic VALUES(5,5,'Klasse E alle (Technik, Betrieb, Vorschriften)',0,1);
INSERT INTO topic VALUES(6,6,'Technische Kenntnisse (Klasse N)',1,2);
INSERT INTO topic VALUES(7,7,'Technische Kenntnisse (Klasse E)',1,2);
INSERT INTO topic VALUES(8,8,'Technische Kenntnisse (Klasse A)',1,2);
INSERT INTO topic VALUES(9,9,'Betriebliche Kenntnisse',1,2);
INSERT INTO topic VALUES(10,10,'Kenntnisse Vorschriften',1,2);
INSERT INTO topic VALUES(11,11,'Klasse N alle (Technik, Betrieb, Vorschriften)',1,2);
INSERT INTO topic VALUES(12,12,'Klasse E alle (Technik, Betrieb, Vorschriften)',1,2);
CREATE TABLE category (_id INT NOT NULL PRIMARY KEY, name TEXT NOT NULL, reference TEXT NOT NULL, isprimary INT, parent INT REFERENCES category(_id));
INSERT INTO category VALUES(1,'Technische Kenntnisse (Klasse E)','T',1,0);
INSERT INTO category VALUES(2,'Allgemeine mathematische Grundkenntnisse und Größen','A',0,1);
INSERT INTO category VALUES(3,'Allgemeine mathematische Grundkenntnisse','1',0,2);
INSERT INTO category VALUES(4,'Größen und Einheiten','2',0,2);
INSERT INTO category VALUES(5,'Elektrizitäts-, Elektromagnetismus- und Funktheorie','B',0,1);
INSERT INTO category VALUES(6,'Leiter, Halbleiter und Isolator','1',0,5);
INSERT INTO category VALUES(7,'Strom- und Spannungsquellen','2',0,5);
INSERT INTO category VALUES(8,'Elektrisches Feld','3',0,5);
INSERT INTO category VALUES(9,'Magnetisches Feld','4',0,5);
INSERT INTO category VALUES(10,'Elektromagnetisches Feld','5',0,5);
INSERT INTO category VALUES(11,'Sinusförmige Signale','6',0,5);
INSERT INTO category VALUES(12,'Nichtsinusförmige Signale','7',0,5);
INSERT INTO category VALUES(13,'Modulierte Signale','8',0,5);
INSERT INTO category VALUES(14,'Ohmsches Gesetz, Leistung und Energie','9',0,5);
INSERT INTO category VALUES(15,'Elektrische und elektronische Bauteile','C',0,1);
INSERT INTO category VALUES(16,'Widerstand','1',0,15);
INSERT INTO category VALUES(17,'Kondensator','2',0,15);
INSERT INTO category VALUES(18,'Spule','3',0,15);
INSERT INTO category VALUES(19,'Übertrager und Transformatoren','4',0,15);
INSERT INTO category VALUES(20,'Diode','5',0,15);
INSERT INTO category VALUES(21,'Transistor','6',0,15);
INSERT INTO category VALUES(22,'Elektronische Schaltungen und deren Merkmale','D',0,1);
INSERT INTO category VALUES(23,'Serien- und Parallelschaltung von Widerständen, Spulen und Kondensatoren','1',0,22);
INSERT INTO category VALUES(24,'Schwingkreise und Filter','2',0,22);
INSERT INTO category VALUES(25,'Stromversorgung','3',0,22);
INSERT INTO category VALUES(26,'Verstärker','4',0,22);
INSERT INTO category VALUES(27,'Modulator / Demodulator','5',0,22);
INSERT INTO category VALUES(28,'Oszillator','6',0,22);
INSERT INTO category VALUES(29,'Analoge und digitale Modulationsverfahren','E',0,1);
INSERT INTO category VALUES(30,'Amplitudenmodulation AM, SSB','1',0,29);
INSERT INTO category VALUES(31,'Frequenzmodulation','2',0,29);
INSERT INTO category VALUES(32,'Text-, Daten- und Bildübertragung','3',0,29);
INSERT INTO category VALUES(33,'Funk-Empfänger','F',0,1);
INSERT INTO category VALUES(34,'Einfach- und Doppelüberlagerungsempfänger','1',0,33);
INSERT INTO category VALUES(35,'Blockschaltbilder','2',0,33);
INSERT INTO category VALUES(36,'Betrieb und Funktionsweise einzelner Stufen','3',0,33);
INSERT INTO category VALUES(37,'Empfängermerkmale','4',0,33);
INSERT INTO category VALUES(38,'Funksender','G',0,1);
INSERT INTO category VALUES(39,'Blockschaltbilder','1',0,38);
INSERT INTO category VALUES(40,'Betrieb und Funktionsweise einzelner Stufen','2',0,38);
INSERT INTO category VALUES(41,'Betrieb und Funktionsweise von HF-Leistungsverstärkern','3',0,38);
INSERT INTO category VALUES(42,'Betrieb und Funktionsweise von HF-Transceivern','4',0,38);
INSERT INTO category VALUES(43,'Unerwünschte Aussendungen','5',0,38);
INSERT INTO category VALUES(44,'Antennen und Übertragungsleitungen','H',0,1);
INSERT INTO category VALUES(45,'Antennen','1',0,44);
INSERT INTO category VALUES(46,'Antennenmerkmale ´','2',0,44);
INSERT INTO category VALUES(47,'Übertragungsleitungen','3',0,44);
INSERT INTO category VALUES(48,'Anpassung, Transformation und Symmetrierung','4',0,44);
INSERT INTO category VALUES(49,'Wellenausbreitung und Ionosphäre','I',0,1);
INSERT INTO category VALUES(50,'Ionosphäre','1',0,49);
INSERT INTO category VALUES(51,'Kurzwellenausbreitung','2',0,49);
INSERT INTO category VALUES(52,'Wellenausbreitung oberhalb 30 MHz','3',0,49);
INSERT INTO category VALUES(53,'Messungen und Messinstrumente','J',0,1);
INSERT INTO category VALUES(54,'Messinstrumente','1',0,53);
INSERT INTO category VALUES(55,'Durchführung von Messungen','2',0,53);
INSERT INTO category VALUES(56,'Störemissionen, Störfestigkeit, Schutzanforderungen, Ursachen, Abhilfe','K',0,1);
INSERT INTO category VALUES(57,'Störungen elektronischer Geräte','1',0,56);
INSERT INTO category VALUES(58,'Ursachen für Störungen','2',0,56);
INSERT INTO category VALUES(59,'Maßnahmen zur Störungsbeseitigung','3',0,56);
INSERT INTO category VALUES(60,'Elektromagnetische Verträglichkeit, Anwendung, Personen- und Sachschutz','L',0,1);
INSERT INTO category VALUES(61,'Störfestigkeit','1',0,60);
INSERT INTO category VALUES(62,'Schutz von Personen','2',0,60);
INSERT INTO category VALUES(63,'Sicherheit','3',0,60);
INSERT INTO category VALUES(64,'Technische Kenntnisse (Klasse A)','T',1,0);
INSERT INTO category VALUES(65,'Allgemeine mathematische Grundkenntnisse und Größen','A',0,64);
INSERT INTO category VALUES(66,'Größen und Einheiten','1',0,65);
INSERT INTO category VALUES(67,'Elektrizitäts-, Elektromagnetismus- und Funktheorie','B',0,64);
INSERT INTO category VALUES(68,'Leiter, Halbleiter und Isolator','1',0,67);
INSERT INTO category VALUES(69,'Strom- und Spannungsquellen','2',0,67);
INSERT INTO category VALUES(70,'Elektrisches Feld','3',0,67);
INSERT INTO category VALUES(71,'Magnetisches Feld','4',0,67);
INSERT INTO category VALUES(72,'Elektromagnetisches Feld','5',0,67);
INSERT INTO category VALUES(73,'Sinusförmige Signale','6',0,67);
INSERT INTO category VALUES(74,'Nichtsinusförmige Signale','7',0,67);
INSERT INTO category VALUES(75,'Modulierte Signale','8',0,67);
INSERT INTO category VALUES(76,'Leistung und Energie','9',0,67);
INSERT INTO category VALUES(77,'Elektrische und elektronische Bauteile','C',0,64);
INSERT INTO category VALUES(78,'Widerstand','1',0,77);
INSERT INTO category VALUES(79,'Kondensator','2',0,77);
INSERT INTO category VALUES(80,'Spule','3',0,77);
INSERT INTO category VALUES(81,'Übertrager und Transformatoren','4',0,77);
INSERT INTO category VALUES(82,'Diode','5',0,77);
INSERT INTO category VALUES(83,'Transistor','6',0,77);
INSERT INTO category VALUES(84,'Einfache digitale und analoge Schaltkreise und sonstige Bauelemente','7',0,77);
INSERT INTO category VALUES(85,'Elektronische Schaltungen und deren Merkmale','D',0,64);
INSERT INTO category VALUES(86,'Reihen- und Parallelschaltung von Widerständen, Spulen und Kondensatoren','1',0,85);
INSERT INTO category VALUES(87,'Schwingkreise und Filter','2',0,85);
INSERT INTO category VALUES(88,'Stromversorgung','3',0,85);
INSERT INTO category VALUES(89,'Verstärker','4',0,85);
INSERT INTO category VALUES(90,'Modulator / Demodulator','5',0,85);
INSERT INTO category VALUES(91,'Oszillator','6',0,85);
INSERT INTO category VALUES(92,'Phasenregelkreise','7',0,85);
INSERT INTO category VALUES(93,'Analoge und digitale Modulationsverfahren','E',0,64);
INSERT INTO category VALUES(94,'Amplitudenmodulation','1',0,93);
INSERT INTO category VALUES(95,'Frequenzmodulation','2',0,93);
INSERT INTO category VALUES(96,'Text- und Daten- und Bildübertragung','3',0,93);
INSERT INTO category VALUES(97,'Funk-Empfänger','F',0,64);
INSERT INTO category VALUES(98,'Einfach- und Doppelsuperhet-Empfänger','1',0,97);
INSERT INTO category VALUES(99,'Blockschaltbilder','2',0,97);
INSERT INTO category VALUES(100,'Betrieb und Funktionsweise einzelner Stufen','3',0,97);
INSERT INTO category VALUES(101,'Empfängermerkmale','4',0,97);
INSERT INTO category VALUES(102,'Digitale Signalverarbeitung','5',0,97);
INSERT INTO category VALUES(103,'Sender','G',0,64);
INSERT INTO category VALUES(104,'Blockschaltbilder','1',0,103);
INSERT INTO category VALUES(105,'Betrieb und Funktionsweise einzelner Stufen','2',0,103);
INSERT INTO category VALUES(106,'Betrieb und Funktionsweise von HF-Leistungsverstärkern','3',0,103);
INSERT INTO category VALUES(107,'Betrieb und Funktionsweise von HF-Transceivern','4',0,103);
INSERT INTO category VALUES(108,'Unerwünschte Aussendungen','5',0,103);
INSERT INTO category VALUES(109,'Antennen und Übertragungsleitungen','H',0,64);
INSERT INTO category VALUES(110,'Antennen','1',0,109);
INSERT INTO category VALUES(111,'Antennenmerkmale','2',0,109);
INSERT INTO category VALUES(112,'Übertragungsleitungen Anmerkung: Zur Lösung einiger, der folgenden Fragen ist im Formelanhang ein Diagramm mit den Grunddämpfungen verschiedener gebräuchlicher Koaxialleitungen enthalten.','3',0,109);
INSERT INTO category VALUES(113,'Anpassung, Transformation und Symmetrierung','4',0,109);
INSERT INTO category VALUES(114,'Wellenausbreitung, Ionosphäre','I',0,64);
INSERT INTO category VALUES(115,'Ionosphäre','1',0,114);
INSERT INTO category VALUES(116,'Kurzwellenausbreitung','2',0,114);
INSERT INTO category VALUES(117,'Wellenausbreitung oberhalb 30 MHz','3',0,114);
INSERT INTO category VALUES(118,'Messungen und Messinstrumente','J',0,64);
INSERT INTO category VALUES(119,'Strom- und Spannungsmesser','1',0,118);
INSERT INTO category VALUES(120,'Dipmeter','2',0,118);
INSERT INTO category VALUES(121,'Oszilloskop','3',0,118);
INSERT INTO category VALUES(122,'Stehwellenmessgerät','4',0,118);
INSERT INTO category VALUES(123,'Frequenzzähler','5',0,118);
INSERT INTO category VALUES(124,'Absorptionsfrequenzmesser','6',0,118);
INSERT INTO category VALUES(125,'Sonstige Messgeräte und Messmittel','7',0,118);
INSERT INTO category VALUES(126,'Durchführung von Messungen','8',0,118);
INSERT INTO category VALUES(127,'Störemissionen, Störfestigkeit, Schutzanforderungen, Ursachen, Abhilfe','K',0,64);
INSERT INTO category VALUES(128,'Störungen elektronischer Geräte','1',0,127);
INSERT INTO category VALUES(129,'Ursachen für Störungen und störende Beeinflussungen','2',0,127);
INSERT INTO category VALUES(130,'Maßnahmen gegen Störungen und störende Beeinflussungen','3',0,127);
INSERT INTO category VALUES(131,'Elektromagnetische Verträglichkeit und deren Anwendung, Personen- und Sachschutz','L',0,64);
INSERT INTO category VALUES(132,'Störfestigkeit','1',0,131);
INSERT INTO category VALUES(133,'Schutz von Personen','2',0,131);
INSERT INTO category VALUES(134,'Sicherheit','3',0,131);
INSERT INTO category VALUES(135,'Betriebliche Kenntnisse','B',1,0);
INSERT INTO category VALUES(136,'Internationales Buchstabieralphabet','A',0,135);
INSERT INTO category VALUES(137,'Betriebliche Abkürzungen, Q-Schlüssel, Signalbeurteilung, Sendearten','B',0,135);
INSERT INTO category VALUES(138,'Betriebliche Abkürzungen','1',0,137);
INSERT INTO category VALUES(139,'Q-Schlüssel','2',0,137);
INSERT INTO category VALUES(140,'Signalbeurteilung','3',0,137);
INSERT INTO category VALUES(141,'Bezeichnung der Aussendungen (Sendearten)','4',0,137);
INSERT INTO category VALUES(142,'Frequenzbereiche und IARU-Bandpläne','C',0,135);
INSERT INTO category VALUES(143,'Frequenzbereiche des Amateurfunkdienstes','1',0,142);
INSERT INTO category VALUES(144,'IARU-Bandpläne','2',0,142);
INSERT INTO category VALUES(145,'Rufzeichen, Landeskenner','D',0,135);
INSERT INTO category VALUES(146,'Deutsche Rufzeichen','1',0,145);
INSERT INTO category VALUES(147,'Europäische Landeskenner','2',0,145);
INSERT INTO category VALUES(148,'Internationale Landeskenner','3',0,145);
INSERT INTO category VALUES(149,'Abwicklung des Amateurfunkverkehrs','E',0,135);
INSERT INTO category VALUES(150,'Betriebsabwicklung, allgemein','1',0,149);
INSERT INTO category VALUES(151,'Betriebsabwicklung, speziell','2',0,149);
INSERT INTO category VALUES(152,'Betriebsabwicklung bei besonderen Betriebsarten','3',0,149);
INSERT INTO category VALUES(153,'Relaisfunkstellen, Transponder, Satelliten, Baken','4',0,149);
INSERT INTO category VALUES(154,'Notfunkverkehr und Nachrichtenverkehr bei Naturkatastrophen','F',0,135);
INSERT INTO category VALUES(155,'Stationstagebuch, QSL-Karte','G',0,135);
INSERT INTO category VALUES(156,'Kenntnisse von Vorschriften','V',1,0);
INSERT INTO category VALUES(157,'Vollzugsordnung für den Funkdienst der Internationalen Fernmeldeunion (ITU)','A',0,156);
INSERT INTO category VALUES(158,'Definition des Amateurfunkdienstes und des Amateurfunkdienstes über Satelliten','1',0,157);
INSERT INTO category VALUES(159,'Definition der Amateurfunkstelle','2',0,157);
INSERT INTO category VALUES(160,'Artikel 25','3',0,157);
INSERT INTO category VALUES(161,'Weitere Regelungen','4',0,157);
INSERT INTO category VALUES(162,'Regelungen der CEPT (Europäische Konferenz der Verwaltungen für Post und Telekommunikation) Hinweis: „ECC“ der Ausschuss für elektronische Kommunikation der CEPT. „ERC“ ist der Europäische Ausschuss für Funkangelegenheiten der CEPT. Der ERC ist die Vorgängerorganisation des ECC.','B',0,156);
INSERT INTO category VALUES(163,'Amateurfunkgesetz (AFuG)','C',0,156);
INSERT INTO category VALUES(164,'Amateurfunkverordnung (AFuV)','D',0,156);
INSERT INTO category VALUES(165,'Allgemeines','1',0,164);
INSERT INTO category VALUES(166,'Rufzeichen, Rufzeichenanwendung','2',0,164);
INSERT INTO category VALUES(167,'Ausbildungsfunkbetrieb','3',0,164);
INSERT INTO category VALUES(168,'Klubstationen','4',0,164);
INSERT INTO category VALUES(169,'Relaisfunkstellen und Funkbaken','5',0,164);
INSERT INTO category VALUES(170,'Frequenzbereiche und Frequenznutzungsparameter für den Amateurfunk','E',0,156);
INSERT INTO category VALUES(171,'Telekommunikationsgesetz (TKG)','F',0,156);
INSERT INTO category VALUES(172,'Gesetz über die elektromagnetische Verträglichkeit von Geräten (EMVG), Störfälle','G',0,156);
INSERT INTO category VALUES(173,'Gesetz über Funkanlagen und Telekommunikationsendeinrichtungen (FTEG)','H',0,156);
INSERT INTO category VALUES(174,'EMVU (elektromagnetische Umweltverträglichkeit) / BEMFV (Verordnung über das Nachweisverfahren zur Begrenzung elektromagnetischer Felder','I',0,156);
INSERT INTO category VALUES(175,'Sicherheitsvorschriften','J',0,156);
INSERT INTO category VALUES(176,'Sonstiges','K',0,156);
INSERT INTO category VALUES(289,'Allgemeine mathematische Grundkenntnisse und Größen',' ',0,1);
INSERT INTO category VALUES(290,'Allgemeine mathematische Grundkenntnisse',' ',0,177);
INSERT INTO category VALUES(291,'Größen und Einheiten',' ',0,177);
INSERT INTO category VALUES(292,'Binäres Zahlensystem',' ',0,177);
INSERT INTO category VALUES(293,'Elektrizitäts-, Elektromagnetismus- und Funktheorie',' ',0,1);
INSERT INTO category VALUES(294,'Leiter, Halbleiter und Isolator',' ',0,181);
INSERT INTO category VALUES(295,'Strom- und Spannungsquellen',' ',0,181);
INSERT INTO category VALUES(296,'Elektrisches Feld',' ',0,181);
INSERT INTO category VALUES(297,'Magnetisches Feld',' ',0,181);
INSERT INTO category VALUES(298,'Elektromagnetisches Feld',' ',0,181);
INSERT INTO category VALUES(299,'Sinusförmige Signale',' ',0,181);
INSERT INTO category VALUES(300,'Nichtsinusförmige Signale',' ',0,181);
INSERT INTO category VALUES(301,'Ohmsches Gesetz',' ',0,181);
INSERT INTO category VALUES(302,'Leistung',' ',0,181);
INSERT INTO category VALUES(303,'Ladung und Energie',' ',0,181);
INSERT INTO category VALUES(304,'Der Stromkreis',' ',0,181);
INSERT INTO category VALUES(305,'Elektrische und elektronische Bauteile',' ',0,1);
INSERT INTO category VALUES(306,'Widerstand',' ',0,193);
INSERT INTO category VALUES(307,'Kondensator',' ',0,193);
INSERT INTO category VALUES(308,'Spule',' ',0,193);
INSERT INTO category VALUES(309,'Übertrager und Transformatoren',' ',0,193);
INSERT INTO category VALUES(310,'Diode',' ',0,193);
INSERT INTO category VALUES(311,'Transistor',' ',0,193);
INSERT INTO category VALUES(312,'Integrierte Schaltkreise',' ',0,193);
INSERT INTO category VALUES(313,'Elektronische Schaltungen und deren Merkmale',' ',0,1);
INSERT INTO category VALUES(314,'Reihen- und Parallelschaltung von Widerständen, Spulen und Kondensatoren',' ',0,201);
INSERT INTO category VALUES(315,'Schwingkreise und Filter',' ',0,201);
INSERT INTO category VALUES(316,'Strom- und Spannungsversorgung',' ',0,201);
INSERT INTO category VALUES(317,'Verstärker',' ',0,201);
INSERT INTO category VALUES(318,'Modulator / Demodulator',' ',0,201);
INSERT INTO category VALUES(319,'Oszillator',' ',0,201);
INSERT INTO category VALUES(320,'Phasenregelkreise',' ',0,201);
INSERT INTO category VALUES(321,'Dämpfungsglieder',' ',0,201);
INSERT INTO category VALUES(322,'Modulations- und Übertragungsverfahren',' ',0,1);
INSERT INTO category VALUES(323,'Modulation allgemein',' ',0,210);
INSERT INTO category VALUES(324,'Amplitudenmodulation AM, SSB, CW',' ',0,210);
INSERT INTO category VALUES(325,'Frequenz- und Phasenmodulation',' ',0,210);
INSERT INTO category VALUES(326,'Digitale Übertragungsverfahren',' ',0,210);
INSERT INTO category VALUES(327,'Sender und Empfänger',' ',0,1);
INSERT INTO category VALUES(328,'Transceiver',' ',0,215);
INSERT INTO category VALUES(329,'Empfänger',' ',0,215);
INSERT INTO category VALUES(330,'Empfängerstufen',' ',0,215);
INSERT INTO category VALUES(331,'Sender und Senderstufen',' ',0,215);
INSERT INTO category VALUES(332,'Leistungsverstärker',' ',0,215);
INSERT INTO category VALUES(333,'Konverter und Transverter',' ',0,215);
INSERT INTO category VALUES(334,'Digitale Signalverarbeitung',' ',0,215);
INSERT INTO category VALUES(335,'Remote-Station',' ',0,215);
INSERT INTO category VALUES(336,'Antennen und Übertragungsleitungen',' ',0,1);
INSERT INTO category VALUES(337,'Antennen',' ',0,224);
INSERT INTO category VALUES(338,'Antennenmerkmale',' ',0,224);
INSERT INTO category VALUES(339,'Übertragungsleitungen',' ',0,224);
INSERT INTO category VALUES(340,'Anpassung, Transformation, Symmetrierung und Mantelwellen',' ',0,224);
INSERT INTO category VALUES(341,'Strahlungsleistung (EIRP und ERP)',' ',0,224);
INSERT INTO category VALUES(342,'Wellenausbreitung und Ionosphäre',' ',0,1);
INSERT INTO category VALUES(343,'Ionosphäre',' ',0,230);
INSERT INTO category VALUES(344,'Kurzwellenausbreitung',' ',0,230);
INSERT INTO category VALUES(345,'Wellenausbreitung oberhalb 30 MHz',' ',0,230);
INSERT INTO category VALUES(346,'Messungen und Messinstrumente',' ',0,1);
INSERT INTO category VALUES(347,'Strom- und Spannungsmessgeräte',' ',0,234);
INSERT INTO category VALUES(348,'Vektorieller Netzwerk Analysator (VNA)',' ',0,234);
INSERT INTO category VALUES(349,'Oszilloskop',' ',0,234);
INSERT INTO category VALUES(350,'Stehwellenmessgerät',' ',0,234);
INSERT INTO category VALUES(351,'Frequenzmessung',' ',0,234);
INSERT INTO category VALUES(352,'Sonstige Messgeräte und Messmittel',' ',0,234);
INSERT INTO category VALUES(353,'Störemissionen, -festigkeit, Schutzanforderungen, Ursachen, Abhilfe',' ',0,1);
INSERT INTO category VALUES(354,'Störungen elektronischer Geräte',' ',0,241);
INSERT INTO category VALUES(355,'Unerwünschte Aussendungen',' ',0,241);
INSERT INTO category VALUES(356,'Elektromagnetische Verträglichkeit, Anwendung, Personen- und Sachschutz',' ',0,1);
INSERT INTO category VALUES(357,'Störfestigkeit',' ',0,244);
INSERT INTO category VALUES(358,'Schutz von Personen',' ',0,244);
INSERT INTO category VALUES(359,'Sicherheit',' ',0,244);
INSERT INTO category VALUES(360,'Allgemeine mathematische Grundkenntnisse und Größen',' ',0,1);
INSERT INTO category VALUES(361,'Allgemeine mathematische Grundkenntnisse',' ',0,177);
INSERT INTO category VALUES(362,'Größen und Einheiten',' ',0,177);
INSERT INTO category VALUES(363,'Binäres Zahlensystem',' ',0,177);
INSERT INTO category VALUES(364,'Elektrizitäts-, Elektromagnetismus- und Funktheorie',' ',0,1);
INSERT INTO category VALUES(365,'Leiter, Halbleiter und Isolator',' ',0,181);
INSERT INTO category VALUES(366,'Strom- und Spannungsquellen',' ',0,181);
INSERT INTO category VALUES(367,'Elektrisches Feld',' ',0,181);
INSERT INTO category VALUES(368,'Magnetisches Feld',' ',0,181);
INSERT INTO category VALUES(369,'Elektromagnetisches Feld',' ',0,181);
INSERT INTO category VALUES(370,'Sinusförmige Signale',' ',0,181);
INSERT INTO category VALUES(371,'Nichtsinusförmige Signale',' ',0,181);
INSERT INTO category VALUES(372,'Ohmsches Gesetz',' ',0,181);
INSERT INTO category VALUES(373,'Leistung',' ',0,181);
INSERT INTO category VALUES(374,'Ladung und Energie',' ',0,181);
INSERT INTO category VALUES(375,'Der Stromkreis',' ',0,181);
INSERT INTO category VALUES(376,'Elektrische und elektronische Bauteile',' ',0,1);
INSERT INTO category VALUES(377,'Widerstand',' ',0,193);
INSERT INTO category VALUES(378,'Kondensator',' ',0,193);
INSERT INTO category VALUES(379,'Spule',' ',0,193);
INSERT INTO category VALUES(380,'Übertrager und Transformatoren',' ',0,193);
INSERT INTO category VALUES(381,'Diode',' ',0,193);
INSERT INTO category VALUES(382,'Transistor',' ',0,193);
INSERT INTO category VALUES(383,'Integrierte Schaltkreise',' ',0,193);
INSERT INTO category VALUES(384,'Elektronische Schaltungen und deren Merkmale',' ',0,1);
INSERT INTO category VALUES(385,'Reihen- und Parallelschaltung von Widerständen, Spulen und Kondensatoren',' ',0,201);
INSERT INTO category VALUES(386,'Schwingkreise und Filter',' ',0,201);
INSERT INTO category VALUES(387,'Strom- und Spannungsversorgung',' ',0,201);
INSERT INTO category VALUES(388,'Verstärker',' ',0,201);
INSERT INTO category VALUES(389,'Modulator / Demodulator',' ',0,201);
INSERT INTO category VALUES(390,'Oszillator',' ',0,201);
INSERT INTO category VALUES(391,'Phasenregelkreise',' ',0,201);
INSERT INTO category VALUES(392,'Dämpfungsglieder',' ',0,201);
INSERT INTO category VALUES(393,'Modulations- und Übertragungsverfahren',' ',0,1);
INSERT INTO category VALUES(394,'Modulation allgemein',' ',0,210);
INSERT INTO category VALUES(395,'Amplitudenmodulation AM, SSB, CW',' ',0,210);
INSERT INTO category VALUES(396,'Frequenz- und Phasenmodulation',' ',0,210);
INSERT INTO category VALUES(397,'Digitale Übertragungsverfahren',' ',0,210);
INSERT INTO category VALUES(398,'Sender und Empfänger',' ',0,1);
INSERT INTO category VALUES(399,'Transceiver',' ',0,215);
INSERT INTO category VALUES(400,'Empfänger',' ',0,215);
INSERT INTO category VALUES(401,'Empfängerstufen',' ',0,215);
INSERT INTO category VALUES(402,'Sender und Senderstufen',' ',0,215);
INSERT INTO category VALUES(403,'Leistungsverstärker',' ',0,215);
INSERT INTO category VALUES(404,'Konverter und Transverter',' ',0,215);
INSERT INTO category VALUES(405,'Digitale Signalverarbeitung',' ',0,215);
INSERT INTO category VALUES(406,'Remote-Station',' ',0,215);
INSERT INTO category VALUES(407,'Antennen und Übertragungsleitungen',' ',0,1);
INSERT INTO category VALUES(408,'Antennen',' ',0,224);
INSERT INTO category VALUES(409,'Antennenmerkmale',' ',0,224);
INSERT INTO category VALUES(410,'Übertragungsleitungen',' ',0,224);
INSERT INTO category VALUES(411,'Anpassung, Transformation, Symmetrierung und Mantelwellen',' ',0,224);
INSERT INTO category VALUES(412,'Strahlungsleistung (EIRP und ERP)',' ',0,224);
INSERT INTO category VALUES(413,'Wellenausbreitung und Ionosphäre',' ',0,1);
INSERT INTO category VALUES(414,'Ionosphäre',' ',0,230);
INSERT INTO category VALUES(415,'Kurzwellenausbreitung',' ',0,230);
INSERT INTO category VALUES(416,'Wellenausbreitung oberhalb 30 MHz',' ',0,230);
INSERT INTO category VALUES(417,'Messungen und Messinstrumente',' ',0,1);
INSERT INTO category VALUES(418,'Strom- und Spannungsmessgeräte',' ',0,234);
INSERT INTO category VALUES(419,'Vektorieller Netzwerk Analysator (VNA)',' ',0,234);
INSERT INTO category VALUES(420,'Oszilloskop',' ',0,234);
INSERT INTO category VALUES(421,'Stehwellenmessgerät',' ',0,234);
INSERT INTO category VALUES(422,'Frequenzmessung',' ',0,234);
INSERT INTO category VALUES(423,'Sonstige Messgeräte und Messmittel',' ',0,234);
INSERT INTO category VALUES(424,'Störemissionen, -festigkeit, Schutzanforderungen, Ursachen, Abhilfe',' ',0,1);
INSERT INTO category VALUES(425,'Störungen elektronischer Geräte',' ',0,241);
INSERT INTO category VALUES(426,'Unerwünschte Aussendungen',' ',0,241);
INSERT INTO category VALUES(427,'Elektromagnetische Verträglichkeit, Anwendung, Personen- und Sachschutz',' ',0,1);
INSERT INTO category VALUES(428,'Störfestigkeit',' ',0,244);
INSERT INTO category VALUES(429,'Schutz von Personen',' ',0,244);
INSERT INTO category VALUES(430,'Sicherheit',' ',0,244);
INSERT INTO category VALUES(431,'Allgemeine mathematische Grundkenntnisse und Größen',' ',0,1);
INSERT INTO category VALUES(432,'Allgemeine mathematische Grundkenntnisse',' ',0,177);
INSERT INTO category VALUES(433,'Größen und Einheiten',' ',0,177);
INSERT INTO category VALUES(434,'Binäres Zahlensystem',' ',0,177);
INSERT INTO category VALUES(435,'Elektrizitäts-, Elektromagnetismus- und Funktheorie',' ',0,1);
INSERT INTO category VALUES(436,'Leiter, Halbleiter und Isolator',' ',0,181);
INSERT INTO category VALUES(437,'Strom- und Spannungsquellen',' ',0,181);
INSERT INTO category VALUES(438,'Elektrisches Feld',' ',0,181);
INSERT INTO category VALUES(439,'Magnetisches Feld',' ',0,181);
INSERT INTO category VALUES(440,'Elektromagnetisches Feld',' ',0,181);
INSERT INTO category VALUES(441,'Sinusförmige Signale',' ',0,181);
INSERT INTO category VALUES(442,'Nichtsinusförmige Signale',' ',0,181);
INSERT INTO category VALUES(443,'Ohmsches Gesetz',' ',0,181);
INSERT INTO category VALUES(444,'Leistung',' ',0,181);
INSERT INTO category VALUES(445,'Ladung und Energie',' ',0,181);
INSERT INTO category VALUES(446,'Der Stromkreis',' ',0,181);
INSERT INTO category VALUES(447,'Elektrische und elektronische Bauteile',' ',0,1);
INSERT INTO category VALUES(448,'Widerstand',' ',0,193);
INSERT INTO category VALUES(449,'Kondensator',' ',0,193);
INSERT INTO category VALUES(450,'Spule',' ',0,193);
INSERT INTO category VALUES(451,'Übertrager und Transformatoren',' ',0,193);
INSERT INTO category VALUES(452,'Diode',' ',0,193);
INSERT INTO category VALUES(453,'Transistor',' ',0,193);
INSERT INTO category VALUES(454,'Integrierte Schaltkreise',' ',0,193);
INSERT INTO category VALUES(455,'Elektronische Schaltungen und deren Merkmale',' ',0,1);
INSERT INTO category VALUES(456,'Reihen- und Parallelschaltung von Widerständen, Spulen und Kondensatoren',' ',0,201);
INSERT INTO category VALUES(457,'Schwingkreise und Filter',' ',0,201);
INSERT INTO category VALUES(458,'Strom- und Spannungsversorgung',' ',0,201);
INSERT INTO category VALUES(459,'Verstärker',' ',0,201);
INSERT INTO category VALUES(460,'Modulator / Demodulator',' ',0,201);
INSERT INTO category VALUES(461,'Oszillator',' ',0,201);
INSERT INTO category VALUES(462,'Phasenregelkreise',' ',0,201);
INSERT INTO category VALUES(463,'Dämpfungsglieder',' ',0,201);
INSERT INTO category VALUES(464,'Modulations- und Übertragungsverfahren',' ',0,1);
INSERT INTO category VALUES(465,'Modulation allgemein',' ',0,210);
INSERT INTO category VALUES(466,'Amplitudenmodulation AM, SSB, CW',' ',0,210);
INSERT INTO category VALUES(467,'Frequenz- und Phasenmodulation',' ',0,210);
INSERT INTO category VALUES(468,'Digitale Übertragungsverfahren',' ',0,210);
INSERT INTO category VALUES(469,'Sender und Empfänger',' ',0,1);
INSERT INTO category VALUES(470,'Transceiver',' ',0,215);
INSERT INTO category VALUES(471,'Empfänger',' ',0,215);
INSERT INTO category VALUES(472,'Empfängerstufen',' ',0,215);
INSERT INTO category VALUES(473,'Sender und Senderstufen',' ',0,215);
INSERT INTO category VALUES(474,'Leistungsverstärker',' ',0,215);
INSERT INTO category VALUES(475,'Konverter und Transverter',' ',0,215);
INSERT INTO category VALUES(476,'Digitale Signalverarbeitung',' ',0,215);
INSERT INTO category VALUES(477,'Remote-Station',' ',0,215);
INSERT INTO category VALUES(478,'Antennen und Übertragungsleitungen',' ',0,1);
INSERT INTO category VALUES(479,'Antennen',' ',0,224);
INSERT INTO category VALUES(480,'Antennenmerkmale',' ',0,224);
INSERT INTO category VALUES(481,'Übertragungsleitungen',' ',0,224);
INSERT INTO category VALUES(482,'Anpassung, Transformation, Symmetrierung und Mantelwellen',' ',0,224);
INSERT INTO category VALUES(483,'Strahlungsleistung (EIRP und ERP)',' ',0,224);
INSERT INTO category VALUES(484,'Wellenausbreitung und Ionosphäre',' ',0,1);
INSERT INTO category VALUES(485,'Ionosphäre',' ',0,230);
INSERT INTO category VALUES(486,'Kurzwellenausbreitung',' ',0,230);
INSERT INTO category VALUES(487,'Wellenausbreitung oberhalb 30 MHz',' ',0,230);
INSERT INTO category VALUES(488,'Messungen und Messinstrumente',' ',0,1);
INSERT INTO category VALUES(489,'Strom- und Spannungsmessgeräte',' ',0,234);
INSERT INTO category VALUES(490,'Vektorieller Netzwerk Analysator (VNA)',' ',0,234);
INSERT INTO category VALUES(491,'Oszilloskop',' ',0,234);
INSERT INTO category VALUES(492,'Stehwellenmessgerät',' ',0,234);
INSERT INTO category VALUES(493,'Frequenzmessung',' ',0,234);
INSERT INTO category VALUES(494,'Sonstige Messgeräte und Messmittel',' ',0,234);
INSERT INTO category VALUES(495,'Störemissionen, -festigkeit, Schutzanforderungen, Ursachen, Abhilfe',' ',0,1);
INSERT INTO category VALUES(496,'Störungen elektronischer Geräte',' ',0,241);
INSERT INTO category VALUES(497,'Unerwünschte Aussendungen',' ',0,241);
INSERT INTO category VALUES(498,'Elektromagnetische Verträglichkeit, Anwendung, Personen- und Sachschutz',' ',0,1);
INSERT INTO category VALUES(499,'Störfestigkeit',' ',0,244);
INSERT INTO category VALUES(500,'Schutz von Personen',' ',0,244);
INSERT INTO category VALUES(501,'Sicherheit',' ',0,244);
INSERT INTO category VALUES(248,'Internationales Buchstabieralphabet',' ',0,2);
INSERT INTO category VALUES(249,'Betriebliche Abkürzungen und Q-Gruppen',' ',0,2);
INSERT INTO category VALUES(250,'Betriebliche Abkürzungen',' ',0,249);
INSERT INTO category VALUES(251,'Q-Gruppen',' ',0,249);
INSERT INTO category VALUES(252,'Frequenzbereiche',' ',0,2);
INSERT INTO category VALUES(253,'Frequenzbereiche',' ',0,252);
INSERT INTO category VALUES(254,'IARU-Bandpläne',' ',0,252);
INSERT INTO category VALUES(255,'Rufzeichen und Landeskenner',' ',0,2);
INSERT INTO category VALUES(256,'Rufzeichen',' ',0,255);
INSERT INTO category VALUES(257,'Rufzeichenzusätze',' ',0,255);
INSERT INTO category VALUES(258,'Landeskenner',' ',0,255);
INSERT INTO category VALUES(259,'Abwicklung des Amateurfunkverkehrs',' ',0,2);
INSERT INTO category VALUES(260,'Betriebsabwicklung',' ',0,259);
INSERT INTO category VALUES(261,'Signalbeurteilung',' ',0,259);
INSERT INTO category VALUES(262,'Contest, Pile-Up, DX-Pedition und Fuchsjagd',' ',0,259);
INSERT INTO category VALUES(263,'Relaisfunkstellen, Baken, Satelliten und Transponder',' ',0,259);
INSERT INTO category VALUES(264,'Notfunkverkehr und Nachrichtenverkehr bei Naturkatastrophen',' ',0,2);
INSERT INTO category VALUES(265,'Stationstagebuch und QSL-Karten',' ',0,2);
INSERT INTO category VALUES(266,'Radio Regulations (ITU RR)',' ',0,3);
INSERT INTO category VALUES(267,'Definition des Amateurfunkdienstes und des Amateurfunkdienstes über Satelliten',' ',0,266);
INSERT INTO category VALUES(268,'Definition der Amateurfunkstelle',' ',0,266);
INSERT INTO category VALUES(269,'Artikel 25',' ',0,266);
INSERT INTO category VALUES(270,'Weitere Regelungen',' ',0,266);
INSERT INTO category VALUES(271,'Regelungen der CEPT (Europäische Konferenz der Verwaltungen für Post und Telekommunikation)',' ',0,3);
INSERT INTO category VALUES(272,'Amateurfunkgesetz (AFuG)',' ',0,3);
INSERT INTO category VALUES(273,'Amateurfunkverordnung (AFuV)',' ',0,3);
INSERT INTO category VALUES(274,'Allgemeines',' ',0,273);
INSERT INTO category VALUES(275,'Rufzeichen und Rufzeichenanwendung',' ',0,273);
INSERT INTO category VALUES(276,'Ausbildungsfunkbetrieb',' ',0,273);
INSERT INTO category VALUES(277,'Klubstationen',' ',0,273);
INSERT INTO category VALUES(278,'Relaisfunkstellen und Funkbaken',' ',0,273);
INSERT INTO category VALUES(279,'Remote-Stationen',' ',0,273);
INSERT INTO category VALUES(280,'Frequenzbereiche und Frequenznutzungsparameter',' ',0,273);
INSERT INTO category VALUES(281,'Weitere Gesetze, Vorschriften und Bestimmungen',' ',0,3);
INSERT INTO category VALUES(282,'Telekommunikationsgesetz (TKG)',' ',0,281);
INSERT INTO category VALUES(283,'Telekommunikation-Telemedien-Datenschutz-Gesetz (TTDSG)',' ',0,281);
INSERT INTO category VALUES(284,'Gesetz über die elektromagnetische Verträglichkeit von Geräten (EMVG), Störfälle',' ',0,281);
INSERT INTO category VALUES(285,'Gesetz über die Bereitstellung von Funkanlagen auf dem Markt (FuAG)',' ',0,281);
INSERT INTO category VALUES(286,'EMVU (elektromagnetische Umweltverträglichkeit) / BEMFV',' ',0,281);
INSERT INTO category VALUES(287,'Sicherheitsvorschriften',' ',0,281);
INSERT INTO category VALUES(288,'Sonstiges',' ',0,281);
CREATE TABLE question (_id INT NOT NULL PRIMARY KEY, reference TEXT, question TEXT NOT NULL, level INT NOT NULL, next_time INT NOT NULL, wrong INT, correct INT, help TEXT);
INSERT INTO question VALUES(1,'TA101','0,042 A entspricht',0,1,0,0,'');
INSERT INTO question VALUES(2,'TA102','0,00042 A entspricht',0,1,0,0,'');
INSERT INTO question VALUES(3,'TA103','100 mW entspricht',0,1,0,0,'');
INSERT INTO question VALUES(4,'TA104','4 200 000 Hz entspricht',0,1,0,0,'');
INSERT INTO question VALUES(5,'TA201','Welche Einheit wird für die elektrische Spannung verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(6,'TA202','Welche Einheit wird für die elektrische Ladung verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(7,'TA203','Welche Einheit wird für die elektrische Leistung verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(8,'TA204','In welcher Einheit wird der elektrische Widerstand angegeben?',0,1,0,0,'');
INSERT INTO question VALUES(9,'TA205','Welche der nachfolgenden Antworten enthält nur Basiseinheiten nach dem internationalen Einheitensystem?',0,1,0,0,'');
INSERT INTO question VALUES(10,'TA206','0,22 µF sind',0,1,0,0,'');
INSERT INTO question VALUES(11,'TA207','3,75 MHz sind',0,1,0,0,'');
INSERT INTO question VALUES(12,'TA208','Welche Einheit wird für die Kapazität verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(13,'TB101','Welche Gruppe enthält insgesamt die besten gut leitenden Metalle?',0,1,0,0,'');
INSERT INTO question VALUES(14,'TB102','Welches der genannten Metalle hat die beste elektrische Leitfähigkeit?',0,1,0,0,'');
INSERT INTO question VALUES(15,'TB103','Welches der genannten Metalle hat die schlechteste elektrische Leitfähigkeit?',0,1,0,0,'');
INSERT INTO question VALUES(16,'TB104','Welche Gruppe von Materialien enthält nur Nichtleiter (Isolatoren)?',0,1,0,0,'');
INSERT INTO question VALUES(17,'TB105','Was verstehen Sie unter Halbleitermaterialien?',0,1,0,0,'');
INSERT INTO question VALUES(18,'TB201','Welche Spannung zeigt der Spannungsmesser in folgender Schaltung?<p><img src=''etb201f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(19,'TB202','Folgende Schaltung eines Akkus besteht aus Zellen von je 2 V. Jede Zelle kann 10 Ah Ladung liefern. Welche Daten hat der Akku?<p><img src=''etb202f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(20,'TB203','Was versteht man unter „technischer Stromrichtung“ in der Elektrotechnik?',0,1,0,0,'');
INSERT INTO question VALUES(21,'TB204','Kann in folgender Schaltung von zwei gleichen Spannungsquellen Strom fließen? Welche Begründung ist richtig?<p><img src=''etb204f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(22,'TB205','Wie lange könnte man mit einem voll geladenen Akku mit 55 Ah einen Amateurfunkempfänger betreiben, der einen Strom von 0,8 A aufnimmt?',0,1,0,0,'');
INSERT INTO question VALUES(23,'TB301','Welche Einheit wird für die elektrische Feldstärke verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(24,'TB302','Wie nennt man das Feld zwischen zwei parallelen Kondensatorplatten bei Anschluss einer Gleichspannung?<p><img src=''etb302f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(25,'TB303','Wie werden die mit X gekennzeichneten Feldlinien einer Vertikalantenne bezeichnet?<p><img src=''etb303f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(26,'TB401','Welche Einheit wird für die magnetische Feldstärke verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(27,'TB402','Wie nennt man das Feld im Innern einer langen Zylinderspule beim Fließen eines Gleichstroms?<p><img src=''etb402f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(28,'TB403','Wenn Strom durch einen gestreckten Leiter fließt, entsteht ein',0,1,0,0,'');
INSERT INTO question VALUES(29,'TB404','Wie werden die mit X gekennzeichneten Feldlinien einer Vertikalantenne bezeichnet?<p><img src=''etb404f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(30,'TB405','Welcher der nachfolgenden Werkstoffe ist ein ferromagnetischer Stoff?',0,1,0,0,'');
INSERT INTO question VALUES(31,'TB501','Wodurch entsteht ein elektromagnetisches Feld? Ein elektromagnetisches Feld entsteht,',0,1,0,0,'');
INSERT INTO question VALUES(32,'TB502','Wie erfolgt die Ausbreitung einer elektromagnetischen Welle? Die Ausbreitung erfolgt',0,1,0,0,'');
INSERT INTO question VALUES(33,'TB503','Das folgende Bild zeigt die Feldlinien eines elektromagnetischen Feldes. Welche Polarisation hat die skizzierte Wellenfront?<p><img src=''etb503f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(34,'TB504','Der Winkel zwischen den elektrischen und magnetischen Feldkomponenten eines elektromagnetischen Feldes beträgt im Fernfeld',0,1,0,0,'');
INSERT INTO question VALUES(35,'TB505','Die Polarisation des Sendesignals in der Hauptstrahlrichtung dieser Richtantenne ist<p><img src=''etb505f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(36,'TB601','Welches ist die Einheit der Wellenlänge?',0,1,0,0,'');
INSERT INTO question VALUES(37,'TB602','Welcher Wellenlänge &lambda; entspricht die Frequenz 1,84 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(38,'TB603','Welcher Wellenlänge &lambda; entspricht die Frequenz 28,48 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(39,'TB604','Eine Wellenlänge von 2,06 m entspricht einer Frequenz von',0,1,0,0,'');
INSERT INTO question VALUES(40,'TB605','Eine Wellenlänge von 80,0 m entspricht einer Frequenz von',0,1,0,0,'');
INSERT INTO question VALUES(41,'TB606','Welche Bezeichnung ist für eine Schwingung von 145 000 000 Perioden pro Sekunde richtig?',0,1,0,0,'');
INSERT INTO question VALUES(42,'TB607','Die Periodendauer von 50 µs entspricht einer Frequenz von',0,1,0,0,'');
INSERT INTO question VALUES(43,'TB608','Den Frequenzbereich zwischen 30 und 300 MHz bezeichnet man als',0,1,0,0,'');
INSERT INTO question VALUES(44,'TB609','Das 70-cm-Band befindet sich im',0,1,0,0,'');
INSERT INTO question VALUES(45,'TB610','Welche Frequenz hat die in diesem Oszillogramm dargestellte Spannung?<p><img src=''etb610f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(46,'TB611','Welche Frequenz hat das in diesem Schirmbild dargestellte Signal?<p><img src=''etb611f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(47,'TB612','Eine sinusförmige Wechselspannung hat einen Spitzenwert von 12 V. Wie groß ist der Effektivwert der Wechselspannung?',0,1,0,0,'');
INSERT INTO question VALUES(48,'TB613','Ein sinusförmiges Signal hat einen Effektivwert von 12 V. Wie groß ist der Spitzen-Spitzen-Wert?',0,1,0,0,'');
INSERT INTO question VALUES(49,'TB701','Welche Signalform sollte der Träger einer hochfrequenten Schwingung haben?',0,1,0,0,'');
INSERT INTO question VALUES(50,'TB702','Ein periodische Schwingung, die wie das folgende Signal aussieht, besteht<p><img src=''etb702f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(51,'TB801','Was ist der Unterschied zwischen AM und SSB?',0,1,0,0,'');
INSERT INTO question VALUES(52,'TB802','Was ist der Unterschied zwischen LSB und USB?',0,1,0,0,'');
INSERT INTO question VALUES(53,'TB803','Welche Aussage über modulierte Signale ist richtig?',0,1,0,0,'');
INSERT INTO question VALUES(54,'TB804','Was ist der Unterschied zwischen FSK und AFSK?',0,1,0,0,'');
INSERT INTO question VALUES(55,'TB805','Wie groß ist die HF-Bandbreite, die bei der Übertragung eines SSB-Signals entsteht?',0,1,0,0,'');
INSERT INTO question VALUES(56,'TB806','Ein Träger von 3,65 MHz wird mit der NF-Frequenz von 2 kHz in SSB (LSB) moduliert. Welche Frequenz/Frequenzen treten im modulierten HF-Signal hauptsächlich auf?',0,1,0,0,'');
INSERT INTO question VALUES(57,'TB901','Die Maßeinheit der elektrischen Leistung ist',0,1,0,0,'');
INSERT INTO question VALUES(58,'TB902','Welcher der nachfolgenden Zusammenhänge ist richtig?',0,1,0,0,'');
INSERT INTO question VALUES(59,'TB903','Welche Spannung lässt einen Strom von 2 A durch einen Widerstand von 50 Ohm fließen?',0,1,0,0,'');
INSERT INTO question VALUES(60,'TB904','Welcher Widerstand ist erforderlich um einen Strom von 3 A bei einer Spannung von 90 Volt fließen zu lassen?',0,1,0,0,'');
INSERT INTO question VALUES(61,'TB905','Eine Stromversorgung nimmt bei 230 V einen Strom von 0,63 A auf. Welche elektrische Arbeit (Energie) wird bei einer Betriebsdauer von 7 Stunden verbraucht?',0,1,0,0,'');
INSERT INTO question VALUES(62,'TB906','Eine Glühlampe hat einen Nennwert von 12 V und 48 W. Bei einer 12-V-Versorgung beträgt die Stromentnahme',0,1,0,0,'');
INSERT INTO question VALUES(63,'TB907','Der Effektivwert der Spannung an einer künstlichen 50-&Omega;-Antenne wird mit 100 V gemessen. Die Leistung an der Last beträgt',0,1,0,0,'');
INSERT INTO question VALUES(64,'TB908','Ein mit einer künstlichen 50-&Omega;-Antenne in Serie geschaltetes Amperemeter zeigt 2 A an. Die Leistung in der Last beträgt',0,1,0,0,'');
INSERT INTO question VALUES(65,'TB909','Ein Mobil-Transceiver (Sender-Empfänger) hat bei Sendebetrieb eine Leistungsaufnahme von 100 Watt aus dem 12-V-Bordnetz des Kraftfahrzeuges. Wie groß ist die Stromaufnahme?',0,1,0,0,'');
INSERT INTO question VALUES(66,'TB910','Ein 100-&Omega;-Widerstand, an dem 10 V anliegen, muss mindestens eine Belastbarkeit haben von',0,1,0,0,'');
INSERT INTO question VALUES(67,'TB911','Welche Belastbarkeit muss ein Vorwiderstand haben, an dem bei einem Strom von 50 mA eine Spannung von 50 V abfallen soll?',0,1,0,0,'');
INSERT INTO question VALUES(68,'TC101','Die Farbringe gelb, violett und orange auf einem Widerstand mit 4 Farbringen bedeuten einen Widerstandswert von',0,1,0,0,'');
INSERT INTO question VALUES(69,'TC102','Die Farbringe gelb, violett und rot auf einem Widerstand mit 4 Farbringen bedeuten einen Widerstandswert von',0,1,0,0,'');
INSERT INTO question VALUES(70,'TC103','Die Farbringe rot, violett und orange auf einem Widerstand mit 4 Farbringen bedeuten einen Widerstandswert von',0,1,0,0,'');
INSERT INTO question VALUES(71,'TC104','Die Farbringe rot, violett und rot auf einem Widerstand mit 4 Farbringen bedeuten einen Widerstandswert von',0,1,0,0,'');
INSERT INTO question VALUES(72,'TC105','Welches Bauteil hat folgendes Schaltzeichen?<p><img src=''etc105f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(73,'TC106','Welches der folgenden Bauteile ist ein NTC?',0,1,0,0,'');
INSERT INTO question VALUES(74,'TC107','Welches der folgenden Schaltsymbole stellt einen PTC-Widerstand dar?',0,1,0,0,'');
INSERT INTO question VALUES(75,'TC108','Ein Widerstand hat eine Toleranz von 10 %. Bei einem nominalen Widerstandswert von 5,6 k&Omega; liegt der tatsächliche Wert zwischen',0,1,0,0,'');
INSERT INTO question VALUES(76,'TC109','Welche Bauart von Widerstand folgender Auswahl ist am besten für eine künstliche Antenne (Dummy Load) geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(77,'TC110','Welchen Wert hat ein SMD-Widerstand mit der Kennzeichnung 221?',0,1,0,0,'');
INSERT INTO question VALUES(78,'TC111','Welchen Wert hat ein SMD-Widerstand mit der Kennzeichnung 223?',0,1,0,0,'');
INSERT INTO question VALUES(79,'TC201','Welche Aussage zur Kapazität eines Plattenkondensators ist richtig?',0,1,0,0,'');
INSERT INTO question VALUES(80,'TC202','Ein Bauelement, bei dem sich Platten auf einer isolierten Achse befinden, die zwischen fest stehende Platten hineingedreht werden können, nennt man',0,1,0,0,'');
INSERT INTO question VALUES(81,'TC203','Welche Kapazität hat nebenstehend abgebildeter Kondensator?<p><img src=''etc203f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(82,'TC204','Welche Kapazität hat nebenstehend abgebildeter Kondensator?<p><img src=''etc204f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(83,'TC205','Welche Kapazität hat nebenstehend abgebildeter Kondensator?<p><img src=''etc205f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(84,'TC206','Drei Kondensatoren mit den Kapazitäten C<sub>1</sub> = 0,1 µF, C<sub>2</sub> = 150 nF und C<sub>3</sub> = 50000 pF werden parallel geschaltet. Wie groß ist die Gesamtkapazität?',0,1,0,0,'');
INSERT INTO question VALUES(85,'TC207','Bei welchem der folgenden Bauformen von Kondensatoren muss beim Einbau auf die Polarität geachtet werden?',0,1,0,0,'');
INSERT INTO question VALUES(86,'TC208','Mit zunehmender Frequenz',0,1,0,0,'');
INSERT INTO question VALUES(87,'TC301','Wie ändert sich die Induktivität einer Spule von 12 µH, wenn die Windungszahl bei gleicher Wickellänge verdoppelt wird?<p><img src=''etc301f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(88,'TC302','Wie ändert sich die Induktivität einer Spule von 12 µH, wenn die Wicklung auf dem Wickelkörper bei gleicher Windungszahl auf die doppelte Länge auseinander gezogen wird?<p><img src=''etc302f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(89,'TC303','Wie kann man die Induktivität einer Spule vergrößern?',0,1,0,0,'');
INSERT INTO question VALUES(90,'TC304','Das folgende Bild zeigt einen Kern, um den ein Kabel für den Bau einer Netzdrossel gewickelt ist. Der Kern sollte aus<p><img src=''etc304f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(91,'TC305','Schaltet man zwei Glühlampen gleichzeitig an eine Spannungsquelle, wobei eine Glühlampe zum Helligkeitsausgleich über einen Widerstand und die andere über eine Spule mit vielen Windungen und Eisenkern angeschlossen ist, so<p><img src=''etc305f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(92,'TC306','Mit zunehmender Frequenz',0,1,0,0,'');
INSERT INTO question VALUES(93,'TC401','Ein Trafo liegt an 230 Volt und gibt 11,5 Volt ab. Seine Primärwicklung hat 600 Windungen. Wie groß ist seine Sekundärwindungszahl?',0,1,0,0,'');
INSERT INTO question VALUES(94,'TC402','Ein Trafo liegt an 45 Volt und gibt 180 Volt ab. Seine Primärwicklung hat 150 Windungen. Wie groß ist seine Sekundärwindungszahl?',0,1,0,0,'');
INSERT INTO question VALUES(95,'TC403','Die Primärspule eines Übertragers hat die fünffache Anzahl von Windungen der Sekundärspule. Wie hoch ist die erwartete Sekundärspannung, wenn die Primärspule an eine 230-V-Stromversorgung angeschlossen wird?',0,1,0,0,'');
INSERT INTO question VALUES(96,'TC501','P-dotiertes Halbleitermaterial ist solches, das mit einem zusätzlichen Stoff versehen wurde, der',0,1,0,0,'');
INSERT INTO question VALUES(97,'TC502','N-leitendes Halbleitermaterial ist gekennzeichnet durch',0,1,0,0,'');
INSERT INTO question VALUES(98,'TC503','Ein in Durchlassrichtung betriebener PN-Übergang ermöglicht',0,1,0,0,'');
INSERT INTO question VALUES(99,'TC504','Eine in Sperrrichtung betriebene Diode hat',0,1,0,0,'');
INSERT INTO question VALUES(100,'TC505','Die Auswahlantworten enthalten Silizium- Dioden mit unterschiedlichen Arbeitspunkten. Bei welcher Antwort befindet sich die Diode in leitendem Zustand?',0,1,0,0,'');
INSERT INTO question VALUES(101,'TC506','Die Auswahlantworten enthalten Silizium- Dioden mit unterschiedlichen Arbeitspunkten. Bei welcher Antwort befindet sich die Diode in leitendem Zustand?',0,1,0,0,'');
INSERT INTO question VALUES(102,'TC507','Wie verhält sich die Kapazität einer Kapazitätsdiode (Varicap)?',0,1,0,0,'');
INSERT INTO question VALUES(103,'TC508','Wozu dient folgende Schaltung? Sie dient<p><img src=''etc508f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(104,'TC509','Wozu dient die folgende Schaltung? Sie dient<p><img src=''etc509f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(105,'TC601','Was versteht man unter Stromverstärkung beim Transistor?',0,1,0,0,'');
INSERT INTO question VALUES(106,'TC602','Das Verhältnis von Kollektorstrom zum Basisstrom eines Transistors liegt üblicherweise im Bereich von',0,1,0,0,'');
INSERT INTO question VALUES(107,'TC603','Bei diesem Bauelement handelt es sich um einen<p><img src=''etc603f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(108,'TC604','Bei diesem Bauelement handelt es sich um einen<p><img src=''etc604f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(109,'TC605','Welche Kollektorspannungen haben NPN- und PNP-Transistoren?',0,1,0,0,'');
INSERT INTO question VALUES(110,'TC606','Bei einem bipolaren Transistor in leitendem Zustand befindet sich die Emitter-Basis-Diode',0,1,0,0,'');
INSERT INTO question VALUES(111,'TC607','Welche Transistortypen sind bipolare Transistoren?',0,1,0,0,'');
INSERT INTO question VALUES(112,'TC608','Wie lauten die Bezeichnungen der Anschlüsse eines bipolaren Transistors?',0,1,0,0,'');
INSERT INTO question VALUES(113,'TC609','Ein bipolarer Transistor ist',0,1,0,0,'');
INSERT INTO question VALUES(114,'TC610','Wenn die Basisspannung eines NPN-Transistors gleich der Emitterspannung ist,',0,1,0,0,'');
INSERT INTO question VALUES(115,'TC611','Wie erfolgt die Steuerung des Stroms im Feldeffekttransistor (FET)?',0,1,0,0,'');
INSERT INTO question VALUES(116,'TC612','Wie bezeichnet man die Anschlüsse des nebenstehenden Transistors? <p><img src=''etc612f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(117,'TD101','Wie groß ist der Ersatzwiderstand der Gesamtschaltung? Gegeben: R<sub>1</sub> = 500 &Omega;, R<sub>2</sub> = 1000 &Omega; und R<sub>3</sub> = 1 k&Omega;<p><img src=''etd101f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(118,'TD102','Wie groß ist der Ersatzwiderstand der Gesamtschaltung? Gegeben: R<sub>1</sub> = 1 k&Omega;, R<sub>2</sub> = 2000 &Omega; und R<sub>3</sub> = 2 k&Omega;<p><img src=''etd101f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(119,'TD103','Wie groß ist der Ersatzwiderstand der Gesamtschaltung? Gegeben: R<sub>1</sub> = 500 &Omega;, R<sub>2</sub> = 500 &Omega; und R<sub>3</sub> = 1 k&Omega;<p><img src=''etd103f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(120,'TD104','Wie groß ist der Ersatzwiderstand der Gesamtschaltung? Gegeben: R<sub>1</sub> = 500 &Omega;, R<sub>2</sub> = 1,5 k&Omega; und R<sub>3</sub> = 2 k&Omega;<p><img src=''etd103f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(121,'TD105','Welche Gesamtkapazität hat die folgende Schaltung? Gegeben: C<sub>1</sub> = 0,01 µF; C<sub>2</sub> = 5 nF, C<sub>3</sub> = 5000 pF<p><img src=''etd105f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(122,'TD106','Welche Gesamtkapazität hat die folgende Schaltung? Gegeben: C<sub>1</sub> = 0,02 µF; C<sub>2</sub> = 10 nF; C<sub>3</sub> = 10000 pF<p><img src=''etd105f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(123,'TD107','Welche Gesamtkapazität hat die folgende Schaltung? Gegeben: C<sub>1</sub> = 0,01 µF; C<sub>2</sub> = 10 nF; C<sub>3</sub> = 5000 pF<p><img src=''etd107f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(124,'TD108','Die Gesamtspannung U an folgendem Spannungsteiler beträgt 12,2 V. Die Widerstände haben die Werte R<sub>1</sub> = 10 k&Omega; und R<sub>2</sub> = 2,2 k&Omega; Wie groß ist die Teilspannung U<sub>2</sub>?<p><img src=''etd108f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(125,'TD109','Zwei Widerstände mit R<sub>1</sub> = 20 &Omega; und R<sub>2</sub> = 30 &Omega; sind parallel geschaltet. Wie groß ist der Ersatzwiderstand?',0,1,0,0,'');
INSERT INTO question VALUES(126,'TD110','Zwei Widerstände mit R<sub>1</sub> = 100 &Omega; und R<sub>2</sub> = 150 &Omega; sind parallel geschaltet. Wie groß ist der Ersatzwiderstand?',0,1,0,0,'');
INSERT INTO question VALUES(127,'TD201','Der Impedanzfrequenzgang in der Abbildung zeigt die Kennlinie<p><img src=''etd201f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(128,'TD202','Der im folgenden Bild dargestellte Impedanzfrequenzgang ist typisch für<p><img src=''etd202f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(129,'TD203','Welcher Schwingkreis passt zu dem neben der jeweiligen Schaltung dargestellten Verlauf des Scheinwiderstandes?',0,1,0,0,'');
INSERT INTO question VALUES(130,'TD204','Wie ändert sich die Resonanzfrequenz eines Schwingkreises, wenn 1. die Spule weniger Windungen erhält, 2. die Länge der Spule durch Zusammenschieben der Drahtwicklung verringert wird, 3. ein Ferritkern in das Innere der Spule gebracht wird?',0,1,0,0,'');
INSERT INTO question VALUES(131,'TD205','Wie verhält sich ein Parallelschwingkreis bei der Resonanzfrequenz?',0,1,0,0,'');
INSERT INTO question VALUES(132,'TD206','Was stellt die folgende Schaltung dar?<p><img src=''etd206f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(133,'TD207','Was stellt die folgende Schaltung dar?<p><img src=''etd207f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(134,'TD208','Was stellt die folgende Schaltung dar?<p><img src=''etd208f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(135,'TD209','Was stellt die folgende Schaltung dar?<p><img src=''etd209f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(136,'TD210','Welche der nachfolgenden Eigenschaften trifft auf einen Hochpass zu?',0,1,0,0,'');
INSERT INTO question VALUES(137,'TD301','Welche Eigenschaften sollten Strom- und Spannungsquellen aufweisen?',0,1,0,0,'');
INSERT INTO question VALUES(138,'TD302','Die Leerlaufspannung einer Gleichspannungsquelle beträgt 13,5 V. Wenn die Spannungsquelle einen Strom von 1 A abgibt, sinkt die Klemmenspannung auf 12,4 V. Wie groß ist der Innenwiderstand der Spannungsquelle?',0,1,0,0,'');
INSERT INTO question VALUES(139,'TD303','Die Leerlaufspannung einer Gleichspannungsquelle beträgt 13,5 V. Wenn die Spannungsquelle einen Strom von 2 A abgibt, sinkt die Klemmenspannung auf 13 V. Wie groß ist der Innenwiderstand der Spannungsquelle?',0,1,0,0,'');
INSERT INTO question VALUES(140,'TD304','Berechnen Sie die Leerlaufausgangsspannung dieser Schaltung für ein Transformationsverhältnis von 5:1.<p><img src=''etd304f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(141,'TD305','Berechnen Sie die Leerlaufausgangsspannung dieser Schaltung für ein Transformationsverhältnis von 8:1.<p><img src=''etd304f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(142,'TD306','Welches ist der Hauptnachteil eines Schaltnetzteils gegenüber einem konventionellen Netzteil?',0,1,0,0,'');
INSERT INTO question VALUES(143,'TD401','In welcher der folgenden Zeilen werden nur Verstärker-Bauelemente genannt?',0,1,0,0,'');
INSERT INTO question VALUES(144,'TD402','Was versteht man in der Elektronik unter Verstärkung? Man spricht von Verstärkung, wenn',0,1,0,0,'');
INSERT INTO question VALUES(145,'TD403','Was ist ein Operationsverstärker?',0,1,0,0,'');
INSERT INTO question VALUES(146,'TD404','Ein IC (integrated circuit) ist',0,1,0,0,'');
INSERT INTO question VALUES(147,'TD405','Worauf beruht die Verstärkerwirkung von Elektronenröhren?',0,1,0,0,'');
INSERT INTO question VALUES(148,'TD501','Durch Modulation',0,1,0,0,'');
INSERT INTO question VALUES(149,'TD502','Welche Aussage zum Frequenzmodulator ist richtig? Durch das Informationssignal',0,1,0,0,'');
INSERT INTO question VALUES(150,'TD503','Zur Aufbereitung des SSB-Signals müssen',0,1,0,0,'');
INSERT INTO question VALUES(151,'TD504','Wie kann ein SSB-Signal erzeugt werden?',0,1,0,0,'');
INSERT INTO question VALUES(152,'TD601','Was verstehen Sie unter einem „Oszillator“?',0,1,0,0,'');
INSERT INTO question VALUES(153,'TD602','Was ist ein LC-Oszillator? Es ist ein Schwingungserzeuger, wobei die Frequenz',0,1,0,0,'');
INSERT INTO question VALUES(154,'TD603','Was ist ein Quarz-Oszillator? Es ist ein Schwingungserzeuger, wobei die Frequenz',0,1,0,0,'');
INSERT INTO question VALUES(155,'TD604','Wie verhält sich die Frequenz eines LCOszillators bei Temperaturanstieg, wenn die Kapazität des Schwingkreiskondensators mit dem Temperaturanstieg geringer wird?',0,1,0,0,'');
INSERT INTO question VALUES(156,'TD605','Im VFO eines Senders steigt die Induktivität der Oszillatorspule mit der Temperatur. Der Kondensator bleibt sehr stabil. Welche Auswirkungen hat dies bei steigender Temperatur?',0,1,0,0,'');
INSERT INTO question VALUES(157,'TD606','Der Vorteil von Quarzoszillatoren gegenüber LC-Oszillatoren liegt darin, dass sie',0,1,0,0,'');
INSERT INTO question VALUES(158,'TE101','Wie unterscheidet sich SSB (J3E) von AM (A3E) in Bezug auf die Bandbreite?',0,1,0,0,'');
INSERT INTO question VALUES(159,'TE102','Welches der nachfolgenden Modulationsverfahren hat die geringste Störanfälligkeit bei Funkanlagen in Kraftfahrzeugen?',0,1,0,0,'');
INSERT INTO question VALUES(160,'TE103','Das folgende Oszillogramm zeigt ein AM-Signal. Der Modulationsgrad beträgt hier zirka<p><img src=''ete103f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(161,'TE104','Das folgende Oszillogramm zeigt ein AM-Signal. Der Modulationsgrad beträgt hier zirka<p><img src=''ete104f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(162,'TE105','Das folgende Oszillogramm zeigt<p><img src=''ete105f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(163,'TE106','Das folgende Oszillogramm zeigt ein typisches Zweiton-SSB-Testsignal. Bestimmen Sie den Modulationsgrad!<p><img src=''ete106f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(164,'TE201','Wodurch wird bei Frequenzmodulation die Lautstärke-Information übertragen?',0,1,0,0,'');
INSERT INTO question VALUES(165,'TE202','FM hat gegenüber SSB den Vorteil der',0,1,0,0,'');
INSERT INTO question VALUES(166,'TE203','Ein zu großer Hub eines FM-Senders führt dazu,',0,1,0,0,'');
INSERT INTO question VALUES(167,'TE204','Größerer Frequenzhub führt bei einem FM-Sender zu',0,1,0,0,'');
INSERT INTO question VALUES(168,'TE301','Welche HF-Bandbreite beansprucht ein 1200-Baud-Packet-Radio-AFSK-Signal?',0,1,0,0,'');
INSERT INTO question VALUES(169,'TE302','Welche HF-Bandbreite beansprucht ein 9600-Baud-FM-Packet-Radio-Signal?',0,1,0,0,'');
INSERT INTO question VALUES(170,'TE303','Welche NF-Zwischenträgerfrequenzen werden in der Regel in Packet Radio bei 1200 Baud benutzt?',0,1,0,0,'');
INSERT INTO question VALUES(171,'TE304','Was versteht man bei Packet Radio unter einem TNC (Terminal Network Controller)? Ein TNC',0,1,0,0,'');
INSERT INTO question VALUES(172,'TE305','Was bedeutet im Prinzip „Packet Radio“? Die Daten werden',0,1,0,0,'');
INSERT INTO question VALUES(173,'TE306','Was versteht man unter 1k2-Packet-Radio?',0,1,0,0,'');
INSERT INTO question VALUES(174,'TE307','Welches ist eine gängige Übertragungsrate in Packet Radio?',0,1,0,0,'');
INSERT INTO question VALUES(175,'TE308','Eine Packet-Radio-Mailbox ist',0,1,0,0,'');
INSERT INTO question VALUES(176,'TE309','Um RTTY-Betrieb durchzuführen benötigt man außer einem Transceiver beispielsweise',0,1,0,0,'');
INSERT INTO question VALUES(177,'TE310','Welcher Unterschied zwischen den Betriebsarten ATV und SSTV ist richtig?',0,1,0,0,'');
INSERT INTO question VALUES(178,'TE311','Welches der folgenden digitalen Übertragungsverfahren hat die geringste Bandbreite?',0,1,0,0,'');
INSERT INTO question VALUES(179,'TE312','Wie heißt die Übertragungsart mit einem Übertragungskanal, bei der durch Umschaltung abwechselnd in beide Richtungen gesendet werden kann?',0,1,0,0,'');
INSERT INTO question VALUES(180,'TF101','Eine hohe erste ZF vereinfacht die Filterung zur Vermeidung von',0,1,0,0,'');
INSERT INTO question VALUES(181,'TF102','Eine hohe erste Zwischenfrequenz',0,1,0,0,'');
INSERT INTO question VALUES(182,'TF103','Welche Aussage ist für einen Doppelsuper richtig?',0,1,0,0,'');
INSERT INTO question VALUES(183,'TF104','Ein Empfänger hat eine ZF von 10,7 MHz und ist auf 28,5 MHz abgestimmt. Der Oszillator des Empfängers schwingt oberhalb der Empfangsfrequenz. Welche Frequenz hat die Spielfrequenz?',0,1,0,0,'');
INSERT INTO question VALUES(184,'TF105','Wodurch wird beim Überlagerungsempfänger die Spiegelfrequenzdämpfung bestimmt? Sie wird vor allem bestimmt durch',0,1,0,0,'');
INSERT INTO question VALUES(185,'TF106','Einem Mischer werden die Frequenzen 136 MHz und 145 MHz zugeführt. Welche Frequenzen werden beim Mischvorgang erzeugt?',0,1,0,0,'');
INSERT INTO question VALUES(186,'TF107','Einem Mischer werden die Frequenzen 28 MHz und 38,7 MHz zugeführt. Welche Frequenzen werden beim Mischvorgang erzeugt?',0,1,0,0,'');
INSERT INTO question VALUES(187,'TF108','Eine schmale Empfängerbandbreite führt im allgemeinen zu einer',0,1,0,0,'');
INSERT INTO question VALUES(188,'TF109','Die Frequenzdifferenz zwischen dem HFNutzsignal und dem Spiegelsignal entspricht',0,1,0,0,'');
INSERT INTO question VALUES(189,'TF110','Durch welchen Vorgang setzt ein Konverter einen Frequenzbereich für einen vorhandenen Empfänger um?',0,1,0,0,'');
INSERT INTO question VALUES(190,'TF201','Um Schwankungen des NF-Ausgangssignals durch Schwankungen des HF-Eingangssignals zu verringern, wird ein Empfänger mit',0,1,0,0,'');
INSERT INTO question VALUES(191,'TF202','Bei Empfang eines sehr starken Signals verringert die AGC (automatic gain control)',0,1,0,0,'');
INSERT INTO question VALUES(192,'TF203','Was bewirkt die AGC (automatic gain control) bei einem starken Eingangssignal?',0,1,0,0,'');
INSERT INTO question VALUES(193,'TF204','Ein Doppelsuper hat eine erste ZF von 10,7 MHz und eine zweite ZF von 460 kHz. Die Empfangsfrequenz soll 28 MHz sein. Welche Frequenzen sind für den VFO und den CO erforderlich, wenn die Oszillatoren oberhalb der Mischer-Eingangssignale schwingen sollen?<p><img src=''etf204f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(194,'TF205','Ein Doppelsuper hat eine erste ZF von 9 MHz und eine zweite ZF von 460 kHz. Die Empfangsfrequenz soll 21,1 MHz sein. Welche Frequenzen sind für den VFO und den CO erforderlich, wenn die Oszillatoren oberhalb der Mischer-Eingangssignale schwingen sollen?<p><img src=''etf204f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(195,'TF301','In der folgenden Schaltung können bei einer Empfangsfrequenz von 28,3 MHz und einer Oszillatorfrequenz von 39 MHz Spiegelfrequenzstörungen bei<p><img src=''etf301f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(196,'TF302','Der Begrenzerverstärker eines FM-Empfängers ist ein Verstärker,',0,1,0,0,'');
INSERT INTO question VALUES(197,'TF303','Welcher der folgenden als Bandpass einsetzbaren Bauteile verfügt am ehesten über die geringste Bandbreite?',0,1,0,0,'');
INSERT INTO question VALUES(198,'TF401','Die Empfindlichkeit eines Empfängers bezieht sich auf die',0,1,0,0,'');
INSERT INTO question VALUES(199,'TF402','Welchen Vorteil bietet ein Überlagerungsempfänger gegenüber einem Geradeaus- Empfänger?',0,1,0,0,'');
INSERT INTO question VALUES(200,'TF403','Um wie viel S-Stufen müsste die S-Meter- Anzeige Ihres Empfängers steigen, wenn Ihr Partner die Sendeleistung von 10 Watt auf 40 Watt erhöht?',0,1,0,0,'');
INSERT INTO question VALUES(201,'TF404','Ein Funkamateur kommt laut S-Meter mit S7 an. Dann schaltet er seine Endstufe ein und bittet um einen erneuten Rapport. Das SMeter zeigt S9+8dB. Um welchen Faktor müsste der Funkamateur seine Leistung erhöht haben?',0,1,0,0,'');
INSERT INTO question VALUES(202,'TF405','Ein Funkamateur hat eine Endstufe, welche die Leistung verzehnfacht (von 10 auf 100 Watt). Ohne seine Endstufe zeigt Ihr S-Meter genau S8. Auf welchen Wert müsste die Anzeige Ihres S-Meters ansteigen, wenn er die Endstufe dazuschaltet?',0,1,0,0,'');
INSERT INTO question VALUES(203,'TF406','Wie groß ist der Unterschied von S4 nach S7 in dB?',0,1,0,0,'');
INSERT INTO question VALUES(204,'TF407','Welche Baugruppe könnte in einem Empfänger gegebenenfalls dazu verwendet werden, um einen schmalen Frequenzbereich zu unterdrücken, in dem Störungen empfangen werden?',0,1,0,0,'');
INSERT INTO question VALUES(205,'TF408','Was bedeutet an einem Abstimmelement eines Empfängers die Abkürzung AGC?',0,1,0,0,'');
INSERT INTO question VALUES(206,'TF409','Welche Baugruppe könnte in einem Empfänger gegebenenfalls dazu verwendet werden, impulsförmige Störungen auszublenden?',0,1,0,0,'');
INSERT INTO question VALUES(207,'TG101','Wie kann die hochfrequente Ausgangsleistung eines SSB-Senders vermindert werden?',0,1,0,0,'');
INSERT INTO question VALUES(208,'TG102','Welche der nachfolgenden Antworten trifft für die Wirkungsweise eines Transverters zu?',0,1,0,0,'');
INSERT INTO question VALUES(209,'TG103','Was kann man tun, wenn der Hub bei einem Handfunkgerät oder Mobil-Transceiver zu groß ist?',0,1,0,0,'');
INSERT INTO question VALUES(210,'TG104','Was bewirkt in der Regel eine zu hohe Mikrofonverstärkung bei einem SSB-Transceiver?',0,1,0,0,'');
INSERT INTO question VALUES(211,'TG105','Was bewirkt eine zu geringe Mikrofonverstärkung bei einem SSB-Transceiver?',0,1,0,0,'');
INSERT INTO question VALUES(212,'TG201','Wie heißt die Stufe in einem Sender, welche die Eigenschaft hat, leise Sprachsignale gegenüber den lauten etwas anzuheben?',0,1,0,0,'');
INSERT INTO question VALUES(213,'TG202','Welche Schaltung in einem Sender bewirkt, dass der Transceiver allein durch die Stimme auf Sendung geschaltet werden kann?',0,1,0,0,'');
INSERT INTO question VALUES(214,'TG203','Welche Anforderungen muss ein FM-Funkgerät erfüllen, damit es für die Übertragung von Packet Radio mit 9600 Baud geeignet ist?',0,1,0,0,'');
INSERT INTO question VALUES(215,'TG301','Ein Sender mit 1 Watt Ausgangsleistung ist an eine Endstufe mit einer Verstärkung von 10 dB angeschlossen. Wie groß ist der Ausgangspegel der Endstufe?',0,1,0,0,'');
INSERT INTO question VALUES(216,'TG302','Ein HF-Leistungsverstärker hat eine Verstärkung von 16 dB. Welche HF-Ausgangsleistung ist zu erwarten, wenn der Verstärker mit 1 W HF-Eingangsleistung angesteuert wird?',0,1,0,0,'');
INSERT INTO question VALUES(217,'TG303','Die Ausgangsleistung eines Senders ist',0,1,0,0,'');
INSERT INTO question VALUES(218,'TG304','Die Spitzenleistung eines Senders ist die',0,1,0,0,'');
INSERT INTO question VALUES(219,'TG305','Eine Verdopplung der Leistung entspricht wie viel dB?',0,1,0,0,'');
INSERT INTO question VALUES(220,'TG306','Die Ausgangsleistung eines FM-Senders',0,1,0,0,'');
INSERT INTO question VALUES(221,'TG307','Wie wird in der Regel die hochfrequente Ausgangsleistung eines SSB-Senders vermindert?',0,1,0,0,'');
INSERT INTO question VALUES(222,'TG401','Was kann man tun, wenn der Hub bei einem Handfunkgerät oder Mobil-Transceiver zu groß ist?',0,1,0,0,'');
INSERT INTO question VALUES(223,'TG402','In welcher der folgenden Antworten sind Betriebsarten üblicher Kurzwellen-Transceiver aufgezählt?',0,1,0,0,'');
INSERT INTO question VALUES(224,'TG403','Wenn man beim Funkbetrieb mit einem Transceiver die Empfangsfrequenz gegenüber der Senderfrequenz geringfügig verstellen möchte, muss man',0,1,0,0,'');
INSERT INTO question VALUES(225,'TG404','Wie wird die Taste am Mikrofon bezeichnet, mit der man einen Transceiver auf Sendung schalten kann?',0,1,0,0,'');
INSERT INTO question VALUES(226,'TG405','Wie wird der Funkbetrieb bezeichnet, bei dem man einen Transceiver allein durch die Stimme auf Sendung schalten kann?',0,1,0,0,'');
INSERT INTO question VALUES(227,'TG501','Wodurch werden Tastklicks bei einem CW-Sender hervorgerufen?',0,1,0,0,'');
INSERT INTO question VALUES(228,'TG502','Welches Filter wäre zwischen Senderausgang und Antenne eingeschleift am besten zur Verringerung der Oberwellenausstrahlungen geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(229,'TG503','Um Nachbarkanalstörungen zu minimieren, sollte die Übertragungsbandbreite bei SSB',0,1,0,0,'');
INSERT INTO question VALUES(230,'TG504','Welche Schaltung wäre zwischen Senderausgang und Antenne eingeschleift am besten zur Verringerung der Oberwellenausstrahlungen geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(231,'TG505','Bei der erstmaligen Prüfung eines Senders sollten die Signale zunächst',0,1,0,0,'');
INSERT INTO question VALUES(232,'TG506','Welche Filtercharakteristik würde sich am besten für einen KW-Mehrband-Sender eignen?',0,1,0,0,'');
INSERT INTO question VALUES(233,'TH101','Was sind typische Kurzwellen-Amateurfunksendeantennen?',0,1,0,0,'');
INSERT INTO question VALUES(234,'TH102','Welche Antennenformen werden im VHF-UHF- Bereich bei den Funkamateuren in der Regel nicht verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(235,'TH103','Welche magnetischen Antennen eignen sich für Sendebetrieb und strahlen dabei im Nahfeld ein starkes magnetisches Feld ab?',0,1,0,0,'');
INSERT INTO question VALUES(236,'TH104','Berechnen Sie die elektrische Länge eines 5/8-&lambda;-langen Vertikalstrahlers für das 10-m- Band (28,5 MHz).',0,1,0,0,'');
INSERT INTO question VALUES(237,'TH105','Sie wollen verschiedene Antennen testen, ob sie für den Funkbetrieb auf Kurzwelle für das 80-m-Band geeignet sind. Man stellt Ihnen jeweils drei Antennen zur Verfügung. Welches Angebot wählen sie, um nur die drei besonders geeigneten Antennen testen zu müssen?',0,1,0,0,'');
INSERT INTO question VALUES(238,'TH106','Welche Antenne gehört nicht zu den symmetrischen Antennen?',0,1,0,0,'');
INSERT INTO question VALUES(239,'TH107','Wie nennt man eine Schleifenantenne, die aus drei gleich langen Drahtstücken besteht?',0,1,0,0,'');
INSERT INTO question VALUES(240,'TH108','Bei welcher Länge hat eine Vertikalantenne die günstigsten Strahlungseigenschaften?',0,1,0,0,'');
INSERT INTO question VALUES(241,'TH109','Eine Vertikalantenne erzeugt',0,1,0,0,'');
INSERT INTO question VALUES(242,'TH110','Sie wollen eine Zweibandantenne für 160 und 80 m selbst bauen. Welche der folgenden Antworten enthält die richtige Drahtlänge l zwischen den Schwingkreisen und die richtige Resonanzfrequenz f<sub>res</sub> der Kreise?<p><img src=''eth110f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(243,'TH111','Die elektrischen Gegengewichte einer Groundplane-Antenne bezeichnet man auch als',0,1,0,0,'');
INSERT INTO question VALUES(244,'TH112','Das folgende Bild enthält eine einfache Richtantenne. Die Bezeichnungen der Elemente in numerischer Reihenfolge lauten<p><img src=''eth112f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(245,'TH113','An welchem Element einer Yagi-Antenne erfolgt die Energieeinspeisung? Sie erfolgt am',0,1,0,0,'');
INSERT INTO question VALUES(246,'TH201','Welche elektrische Länge muss eine Dipolantenne haben, damit sie in Resonanz ist?',0,1,0,0,'');
INSERT INTO question VALUES(247,'TH202','Welches Strahlungsdiagramm ist der Antenne richtig zugeordnet?',0,1,0,0,'');
INSERT INTO question VALUES(248,'TH203','Welchen Eingangs- bzw. Fußpunktwiderstand hat die Groundplane?',0,1,0,0,'');
INSERT INTO question VALUES(249,'TH204','Die Impedanz in der Mitte eines Halbwellendipols beträgt je nach Aufbauhöhe ungefähr',0,1,0,0,'');
INSERT INTO question VALUES(250,'TH205','Ein Faltdipol hat einen Eingangswiderstand von ungefähr',0,1,0,0,'');
INSERT INTO question VALUES(251,'TH206','Ein Halbwellendipol wird auf der Grundfrequenz in der Mitte',0,1,0,0,'');
INSERT INTO question VALUES(252,'TH207','Welcher Prozentsatz entspricht dem Korrekturfaktor, der üblicherweise für die Berechnung der Länge einer Drahtantenne verwendet wird?',0,1,0,0,'');
INSERT INTO question VALUES(253,'TH208','Das folgende Bild enthält verschiedene UKW-Vertikalantennen. In welcher der folgenden Zeilen ist die entsprechende Bezeichnung der Antenne richtig zugeordnet?<p><img src=''eth208f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(254,'TH209','Das folgende Bild enthält verschiedene UKW-Antennen. Welche der folgenden Antworten ist richtig?<p><img src=''eth209f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(255,'TH210','Eine Drahtantenne für den Amateurfunk im KW-Bereich',0,1,0,0,'');
INSERT INTO question VALUES(256,'TH301','Am Ende einer Leitung ist nur noch ein Viertel der Leistung vorhanden. Wie groß ist das Dämpfungsmaß des Kabels?',0,1,0,0,'');
INSERT INTO question VALUES(257,'TH302','Am Ende einer Leitung ist nur noch ein Zehntel der Leistung vorhanden. Wie groß ist das Dämpfungsmaß des Kabels?',0,1,0,0,'');
INSERT INTO question VALUES(258,'TH303','Eine HF-Ausgangleistung von 100 W wird in eine angepasste Übertragungsleitung eingespeist. Am antennenseitigen Ende der Leitung beträgt die Leistung 50 W bei einem Stehwellenverhältnis von 1:1. Wie hoch ist die Leitungsdämpfung?',0,1,0,0,'');
INSERT INTO question VALUES(259,'TH304','Welcher der nachfolgenden Zusammenhänge ist richtig?',0,1,0,0,'');
INSERT INTO question VALUES(260,'TH305','Welche Dämpfung hat ein 25 m langes Koaxkabel vom Typ Aircell 7 bei 145 MHz? (siehe hierzu beiliegendes Diagramm)<p><img src=''ekabeldaempfung.png''>',0,1,0,0,'');
INSERT INTO question VALUES(261,'TH306','Welche Dämpfung hat ein 20 m langes Koaxkabel vom Typ RG 58 bei 29 MHz? (siehe hierzu beiliegendes Diagramm)<p><img src=''ekabeldaempfung.png''>',0,1,0,0,'');
INSERT INTO question VALUES(262,'TH307','Der Wellenwiderstand einer Leitung',0,1,0,0,'');
INSERT INTO question VALUES(263,'TH308','Koaxialkabel weisen typischerweise Wellenwiderstände von',0,1,0,0,'');
INSERT INTO question VALUES(264,'TH309','Welche Vorteile hat eine Paralleldraht-Speiseleitung gegenüber der Speisung über ein Koaxialkabel?',0,1,0,0,'');
INSERT INTO question VALUES(265,'TH310','Wann ist eine Speiseleitung unsymmetrisch?',0,1,0,0,'');
INSERT INTO question VALUES(266,'TH311','Welche Leitungen sollten für die HF-Verbindungen zwischen Einrichtungen in der Amateurfunkstelle verwendet werden, um unerwünschte Abstrahlungen zu vermeiden?',0,1,0,0,'');
INSERT INTO question VALUES(267,'TH312','Welches der folgenden Koaxsteckverbindersysteme ist für sehr hohe Frequenzen (70-cm-Band) und hohe Leistungen am besten geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(268,'TH401','Bei welchem Stehwellenverhältnis (VSWR) ist eine Antenne am besten an die Leitung angepasst?',0,1,0,0,'');
INSERT INTO question VALUES(269,'TH402','Fehlanpassungen oder Beschädigungen von HF-Übertragungsleitungen',0,1,0,0,'');
INSERT INTO question VALUES(270,'TH403','Welche Auswirkungen hat es, wenn eine symmetrische Antenne (Dipol) mit einem Koaxkabel gleicher Impedanz gespeist wird?',0,1,0,0,'');
INSERT INTO question VALUES(271,'TH404','Ein symmetrischer Halbwellendipol wird direkt über ein Koaxialkabel von einem Sender gespeist. Das Kabel ist senkrecht am Haus entlang verlegt und verursacht geringe Störungen. Um das Problem weiter zu verringern, empfiehlt es sich',0,1,0,0,'');
INSERT INTO question VALUES(272,'TH405','Auf einem Ferritkern sind etliche Windungen Koaxialkabel aufgewickelt. Diese Anordnung kann dazu dienen,<p><img src=''eth405f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(273,'TH406','Am Eingang einer Antennenleitung misst man ein VSWR von 3. Wie groß ist in etwa die rücklaufende Leistung am Messpunkt, wenn die vorlaufende Leistung dort 100 Watt beträgt?',0,1,0,0,'');
INSERT INTO question VALUES(274,'TI101','Welche ionosphärischen Schichten bestimmen die Funkwellenausbreitung am Tage?',0,1,0,0,'');
INSERT INTO question VALUES(275,'TI102','Welche ionosphärischen Schichten bestimmen die Fernausbreitung in der Nacht?',0,1,0,0,'');
INSERT INTO question VALUES(276,'TI103','In welcher Höhe befinden sich die für die Fernausbreitung (DX) wichtigen ionosphärischen Schichten? Sie befinden sich in ungefähr',0,1,0,0,'');
INSERT INTO question VALUES(277,'TI104','Welchen Einfluss hat die D-Schicht auf die Fernausbreitung?',0,1,0,0,'');
INSERT INTO question VALUES(278,'TI105','Wie kommt die Fernausbreitung einer Funkwelle auf den Kurzwellenbändern zustande? Sie kommt zustande durch die Reflexion an',0,1,0,0,'');
INSERT INTO question VALUES(279,'TI106','Welche Schicht ist für die gute Ausbreitung im 10-m-Band in den Sommermonaten verantwortlich?',0,1,0,0,'');
INSERT INTO question VALUES(280,'TI107','Die Sonnenfleckenzahl ist einem regelmäßigen Zyklus unterworfen. Welchen Zeitraum hat dieser Zyklus zirka?',0,1,0,0,'');
INSERT INTO question VALUES(281,'TI201','Die Ausbreitungsgeschwindigkeit freier elektromagnetischer Wellen beträgt etwa',0,1,0,0,'');
INSERT INTO question VALUES(282,'TI202','Unter der "Toten Zone" wird der Bereich verstanden,',0,1,0,0,'');
INSERT INTO question VALUES(283,'TI203','Welche der folgenden Aussagen trifft für KW-Funkverbindungen zu, die über Bodenwellen erfolgen?',0,1,0,0,'');
INSERT INTO question VALUES(284,'TI204','Wie groß ist in etwa die maximale Entfernung, die ein KW-Signal bei Reflexion an der E-Schicht auf der Erdoberfläche mit einem Sprung (Hop) überbrücken kann?',0,1,0,0,'');
INSERT INTO question VALUES(285,'TI205','Von welchem der genannten Parameter ist die Sprungdistanz abhängig, die ein KW-Signal auf der Erdoberfläche überbrücken kann? Sie ist abhängig',0,1,0,0,'');
INSERT INTO question VALUES(286,'TI206','Bei der Ausbreitung auf Kurzwelle spielt die so genannte "Grey Line" eine besondere Rolle. Was ist die "Grey Line"?',0,1,0,0,'');
INSERT INTO question VALUES(287,'TI207','Was versteht man unter dem Begriff "Mögel-Dellinger-Effekt"?',0,1,0,0,'');
INSERT INTO question VALUES(288,'TI208','Ein plötzlicher Anstieg der Intensitäten von UV- und Röntgenstrahlung nach einem Flare (Energieausbruch auf der Sonne) führt zu erhöhter Ionisierung der D-Schicht und damit zu kurzzeitigem Totalausfall der ionosphärischen Kurzwellenausbreitung. Diese Erscheinung wird auch als',0,1,0,0,'');
INSERT INTO question VALUES(289,'TI209','Unter dem Begriff "Short Skip" versteht man Funkverbindungen besonders im 10-m-Band mit Sprungentfernungen unter 1000 km, die',0,1,0,0,'');
INSERT INTO question VALUES(290,'TI210','Warum sind Signale im 160- und 80-Meter- Band tagsüber nur schwach und nicht für den weltweiten Funkverkehr geeignet? Sie sind ungeeignet wegen der Tagesdämpfung in der',0,1,0,0,'');
INSERT INTO question VALUES(291,'TI211','In welcher ionosphärischen Schicht treten gelegentlich Aurora-Erscheinungen auf?',0,1,0,0,'');
INSERT INTO question VALUES(292,'TI212','Was bedeutet die „MUF“ bei der Kurzwellenausbreitung?',0,1,0,0,'');
INSERT INTO question VALUES(293,'TI213','Wie nennt man den ionosphärischen Feldstärkeschwund durch Überlagerung von Boden- und Raumwelle, der sich bei der Kurzwellenausbreitung besonders bei AM-Sendungen bemerkbar macht?',0,1,0,0,'');
INSERT INTO question VALUES(294,'TI301','Wie weit etwa reicht der Funkhorizont im UKW-Bereich über den geografischen Horizont hinaus? Er reicht etwa',0,1,0,0,'');
INSERT INTO question VALUES(295,'TI302','Überhorizontverbindungen im UHF/VHF-Bereich kommen u.a. zustande durch',0,1,0,0,'');
INSERT INTO question VALUES(296,'TI303','Für VHF-Weitverkehrsverbindungen wird hauptsächlich die',0,1,0,0,'');
INSERT INTO question VALUES(297,'TI304','Was ist die "Troposphäre"? Die Troposphäre ist der',0,1,0,0,'');
INSERT INTO question VALUES(298,'TI305','Wie wirkt die Antennenhöhe auf die Reichweite einer UKW-Verbindung aus? Die Reichweite steigt mit zunehmender Antennenhöhe, weil',0,1,0,0,'');
INSERT INTO question VALUES(299,'TI306','Was ist die Ursache für Aurora-Erscheinungen? Die Ursache ist',0,1,0,0,'');
INSERT INTO question VALUES(300,'TI307','Wie wirkt sich "Aurora" auf die Signalqualität eines Funksignals aus?',0,1,0,0,'');
INSERT INTO question VALUES(301,'TI308','Welche Betriebsart eignet sich am besten für Auroraverbindungen?',0,1,0,0,'');
INSERT INTO question VALUES(302,'TI309','Was verstehen Sie unter dem Begriff "Sporadic-E"? Ich verstehe darunter',0,1,0,0,'');
INSERT INTO question VALUES(303,'TI310','In dem folgenden Geländeprofil sei S ein Sender im 2-m-Band, E1 bis E4 vier Empfangsstationen. Welche Funkstrecke geht wahrscheinlich am besten, welche am schlechtesten?<p><img src=''eti310f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(304,'TJ101','Das Prinzip eines Drehspulmessgeräts beruht auf',0,1,0,0,'');
INSERT INTO question VALUES(305,'TJ102','Die Auflösung eines Messinstrumentes entspricht',0,1,0,0,'');
INSERT INTO question VALUES(306,'TJ103','Was ist ein Dipmeter? Ein Dipmeter ist',0,1,0,0,'');
INSERT INTO question VALUES(307,'TJ104','Wozu wird ein Dipmeter beispielsweise verwendet? Ein Dipmeter wird zur',0,1,0,0,'');
INSERT INTO question VALUES(308,'TJ105','Welches dieser Messgeräte ist für die Ermittlung der Resonanzfrequenz eines Traps, das für einen Dipol genutzt werden soll, am besten geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(309,'TJ106','Wie ermittelt man die Resonanzfrequenz eines Schwingkreises? Man ermittelt sie',0,1,0,0,'');
INSERT INTO question VALUES(310,'TJ107','Für welche Messungen verwendet man ein Oszilloskop? Ein Oszilloskop verwendet man, um',0,1,0,0,'');
INSERT INTO question VALUES(311,'TJ108','Welches dieser Geräte wird für die Anzeige von NF-Verzerrungen verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(312,'TJ109','Eine künstliche Antenne für den VHF-Bereich könnte beispielsweise aus',0,1,0,0,'');
INSERT INTO question VALUES(313,'TJ110','Welche der folgenden Bauteile könnten für eine genaue künstliche Antenne, die bei 28 MHz eingesetzt werden soll, verwendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(314,'TJ201','Welche Schaltung könnte dazu verwendet werden, den Wert eines Widerstandes anhand des ohmschen Gesetzes zu ermitteln?',0,1,0,0,'');
INSERT INTO question VALUES(315,'TJ202','Wie werden elektrische Spannungsmesser an Messobjekte angeschlossen und welche Anforderungen muss das Messgerät erfüllen, damit der Messfehler möglichst gering bleibt?',0,1,0,0,'');
INSERT INTO question VALUES(316,'TJ203','Die Zeitbasis eines Oszilloskops ist so eingestellt, dass ein Skalenteil 0,5 ms entspricht. Welche Frequenz hat die angelegte Spannung?<p><img src=''etj203f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(317,'TJ204','Für welchen Zweck wird eine Stehwellenmessbrücke verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(318,'TJ205','Welche Spannung wird bei dem folgenden Messinstrument angezeigt, wenn dessen Messbereich auf 10 V eingestellt ist?<p><img src=''etj205f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(319,'TJ206','An welcher Stelle einer Antennenanlage muss ein VSWR-Meter eingeschleift werden, um Aussagen über die Antenne selbst machen zu können? Das VSWR-Meter muss eingeschleift werden zwischen',0,1,0,0,'');
INSERT INTO question VALUES(320,'TJ207','Ein Stehwellenmessgerät wird in ein ideal angepasstes Sender-/Antennensystem eingeschleift. Das Messgerät sollte',0,1,0,0,'');
INSERT INTO question VALUES(321,'TJ208','Welches dieser Messgeräte ist für genaue Frequenzmessungen am besten geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(322,'TJ209','Wie misst man das Stehwellenverhältnis? Man misst es',0,1,0,0,'');
INSERT INTO question VALUES(323,'TJ210','Ein Stehwellenmessgerät wird eingesetzt bei Sendern zur Messung',0,1,0,0,'');
INSERT INTO question VALUES(324,'TJ211','An welchem Punkt sollte das Stehwellenmessgerät eingeschleift werden, um zu prüfen, ob der Sender gut an die Antennenanlage angepasst ist?<p><img src=''etj211f.png''>',0,1,0,0,'');
INSERT INTO question VALUES(325,'TK101','Wie äußert sich Zustopfen bzw. Blockierung eines Empfängers?',0,1,0,0,'');
INSERT INTO question VALUES(326,'TK102','Welche Effekte werden durch Intermodulation hervorgerufen?',0,1,0,0,'');
INSERT INTO question VALUES(327,'TK103','Welche Reaktion ist angebracht, wenn Störungen im TV-Rundfunk beim Nachbarn nicht mit den zur Verfügung stehenden Mitteln beseitigt werden können?',0,1,0,0,'');
INSERT INTO question VALUES(328,'TK104','Bei der Überprüfung des Ausgangssignals eines Senders sollte die Dämpfung der Oberwellen mindestens',0,1,0,0,'');
INSERT INTO question VALUES(329,'TK105','In welchem Fall spricht man von Einströmungen bei EMV? Einströmungen liegen dann vor, wenn die HF',0,1,0,0,'');
INSERT INTO question VALUES(330,'TK106','In welchem Fall spricht man von Einstrahlungen bei EMV? Einstrahlungen liegen dann vor, wenn die HF',0,1,0,0,'');
INSERT INTO question VALUES(331,'TK107','Wie nennt man die elektromagnetische Störung, die durch die Aussendung des reinen Nutzsignals beim Empfang anderer Frequenzen in benachbarten Empfängern auftreten kann?',0,1,0,0,'');
INSERT INTO question VALUES(332,'TK201','Wie kommen Geräusche aus den Lautsprechern einer abgeschalteten Stereoanlage möglicherweise zustande?',0,1,0,0,'');
INSERT INTO question VALUES(333,'TK202','Ein Fernsehgerät wird durch das Nutzsignal einer KW-Amateurfunkstelle gestört. Wie dringt das Signal mit größter Wahrscheinlichkeit in das Fernsehgerät ein?',0,1,0,0,'');
INSERT INTO question VALUES(334,'TK203','Die Übersteuerung eines Leistungsverstärkers führt zu',0,1,0,0,'');
INSERT INTO question VALUES(335,'TK204','Die gesamte Bandbreite einer FMÜbertragung beträgt 15 kHz. Wie nah an der Bandgrenze kann ein Träger übertragen werden, ohne dass Außerbandaussendungen erzeugt werden?',0,1,0,0,'');
INSERT INTO question VALUES(336,'TK301','Durch welche Maßnahme kann die übermäßige Bandbreite einer 2-m-FM-Übertragung verringert werden? Sie kann verringert werden durch die Änderung der',0,1,0,0,'');
INSERT INTO question VALUES(337,'TK302','Ein Sender sollte so betrieben werden, dass',0,1,0,0,'');
INSERT INTO question VALUES(338,'TK303','Durch eine Mantelwellendrossel in einem Fernseh-Antennenzuführungskabel',0,1,0,0,'');
INSERT INTO question VALUES(339,'TK304','Ein Funkamateur wohnt in einem Reihenhaus. An welcher Stelle sollte die KW-Drahtantenne angebracht werden, um störende Beeinflussungen auf ein Mindestmaß zu begrenzen?',0,1,0,0,'');
INSERT INTO question VALUES(340,'TK305','Beim Betrieb Ihres 2-m-Senders wird bei einem Ihrer Nachbarn ein Fernsehempfänger gestört, der mit einer Zimmerantenne betrieben wird. Zur Behebung des Problems schlagen Sie dem Nachbarn vor,',0,1,0,0,'');
INSERT INTO question VALUES(341,'TK306','Die Bemühungen, die durch eine in der Nähe befindliche Amateurfunkstelle hervorgerufenen Fernsehstörungen zu verringern, sind fehlgeschlagen. Als nächster Schritt ist',0,1,0,0,'');
INSERT INTO question VALUES(342,'TK307','Um die Störwahrscheinlichkeit zu verringern, sollte die benutzte Sendeleistung',0,1,0,0,'');
INSERT INTO question VALUES(343,'TK308','Welches Filter sollte im Störungsfall für die Dämpfung von Kurzwellensignalen in ein Fernsehantennenkabel eingeschleift werden?',0,1,0,0,'');
INSERT INTO question VALUES(344,'TK309','Was sollte zur Herabsetzung starker Signale eines 28-MHz-Senders in das Fernseh- Antennenzuführungskabel eingeschleift werden?',0,1,0,0,'');
INSERT INTO question VALUES(345,'TK310','Welche Filter sollten im Störungsfall vor die einzelnen Leitungsanschlüsse eines UKW oder Fernsehrundfunkgeräts oder angeschlossener Geräte eingeschleift werden, um Kurzwellensignale zu dämpfen?',0,1,0,0,'');
INSERT INTO question VALUES(346,'TK311','Die Signale eines 144-MHz-Senders werden in das Koax-Antennenkabel eines FM-Rundfunkempfängers induziert und verursachen Störungen. Eine Möglichkeit zur Verringerung der Störungen besteht darin,',0,1,0,0,'');
INSERT INTO question VALUES(347,'TK312','Um die Störwahrscheinlichkeit im eigenen Haus zu verringern, empfiehlt es sich vorzugsweise',0,1,0,0,'');
INSERT INTO question VALUES(348,'TK313','Bei der Hi-Fi-Anlage des Nachbarn wird Einströmung in die NF-Endstufe festgestellt. Eine mögliche Abhilfe wäre',0,1,0,0,'');
INSERT INTO question VALUES(349,'TK314','Eine KW-Amateurfunkstelle verursacht im Sendebetrieb in einem in der Nähe betriebenen Fernsehempfänger Störungen. Welches Filter schleifen Sie in das Fernsehantennenkabel ein, um die Störwahrscheinlichkeit zu verringern?',0,1,0,0,'');
INSERT INTO question VALUES(350,'TK315','Bei einem Wohnort in einem Ballungsgebiet empfiehlt es sich, während der abendlichen Fernsehstunden',0,1,0,0,'');
INSERT INTO question VALUES(351,'TK316','Falls sich eine Antenne in der Nähe und parallel zu einer 230-V-Wechselstrom-Freileitung befindet,',0,1,0,0,'');
INSERT INTO question VALUES(352,'TK317','Eine 435-MHz-Sendeantenne mit hohem Gewinn ist unmittelbar auf eine UHF-Fernseh-Empfangsantenne gerichtet. Dies führt gegebenenfalls zu',0,1,0,0,'');
INSERT INTO question VALUES(353,'TK318','Im Mittelwellenbereich ergeben sich häufig Spiegelfrequenzstörungen durch',0,1,0,0,'');
INSERT INTO question VALUES(354,'TK319','Ein korrodierter Anschluss an der Fernseh-Empfangsantenne des Nachbarn',0,1,0,0,'');
INSERT INTO question VALUES(355,'TL101','Um eine Amateurfunkstelle in Bezug auf EMV zu optimieren',0,1,0,0,'');
INSERT INTO question VALUES(356,'TL201','Nach welcher der Antworten kann die ERP (Effective Radiated Power) berechnet werden, und worauf ist die ERP bzw. der zu verwendende Antennengewinn bezogen?',0,1,0,0,'');
INSERT INTO question VALUES(357,'TL202','Nach welcher der Antworten kann die EIRP berechnet werden, und worauf ist die EIRP bzw. der zu verwendende Antennengewinn bezogen?',0,1,0,0,'');
INSERT INTO question VALUES(358,'TL203','Was versteht man unter dem Begriff "EIRP"?',0,1,0,0,'');
INSERT INTO question VALUES(359,'TL204','Ein Sender mit 0,6 Watt Ausgangsleistung ist über eine Antennenleitung, die 1 dB Kabelverluste hat, an eine Richtantenne mit 11 dB Gewinn (auf Dipol bezogen) angeschlossen. Welche EIRP wird von der Antenne maximal abgestrahlt?',0,1,0,0,'');
INSERT INTO question VALUES(360,'TL205','Ein Sender mit 5 Watt Ausgangsleistung ist über eine Antennenleitung, die 2 dB Kabelverluste hat, an eine Antenne mit 5 dB Gewinn (auf Dipol bezogen) angeschlossen. Welche EIRP wird von der Antenne maximal abgestrahlt?',0,1,0,0,'');
INSERT INTO question VALUES(361,'TL206','Ein Sender mit 75 Watt Ausgangsleistung ist über eine Antennenleitung, die 2,15 dB (Faktor 1,64) Kabelverluste hat, an eine Dipol- Antenne angeschlossen. Welche EIRP wird von der Antenne maximal abgestrahlt?',0,1,0,0,'');
INSERT INTO question VALUES(362,'TL207','Muss ein Funkamateur als Betreiber einer ortsfesten Amateurfunkstelle bei der Sendeart F3E und einer Senderleistung von 6 Watt an einer 15-Element-Yagiantenne mit 13 dB Gewinn für 2 m die Einhaltung der Personenschutzgrenzwerte nachweisen?',0,1,0,0,'');
INSERT INTO question VALUES(363,'TL208','Sie besitzen einen &lambda;/4-Vertikalstrahler. Da Sie für diese Antenne keine Selbsterklärung abgeben möchten und somit nur eine Strahlungsleistung von kleiner 10 W EIRP verwenden dürfen, müssen Sie die Sendeleistung soweit reduzieren, dass sie unter diesem Wert bleiben. Wie groß darf die Sendeleistung dabei sein?',0,1,0,0,'');
INSERT INTO question VALUES(364,'TL209','Sie möchten den Personenschutz-Sicherheitsabstand für die Antenne Ihrer Amateurfunkstelle für das 10-m-Band und die Betriebsart RTTY berechnen. Der Grenzwert im Fall des Personenschutzes beträgt 28 V/m. Sie betreiben einen Dipol, der von einem Sender mit einer Leistung von 100 W über ein Koaxialkabel gespeist wird. Die Kabeldämpfung sei vernachlässigbar. Wie groß muss der Sicherheitsabstand sein?',0,1,0,0,'');
INSERT INTO question VALUES(365,'TL210','Sie möchten den Personenschutz-Sicherheitsabstand für die Antenne Ihrer Amateurfunkstelle für das 10-m-Band und die Betriebsart FM berechnen. Der Grenzwert im Fall des Personenschutzes beträgt 28 V/m. Sie betreiben eine Yagi-Antenne mit einem Gewinn von 7,5 dBd. Die Antenne wird von einem Sender mit einer Leistung von 100 W über ein langes Koaxialkabel gespeist. Die Kabeldämpfung beträgt 1,5 dB. Wie groß muss der Sicherheitsabstand sein?',0,1,0,0,'');
INSERT INTO question VALUES(366,'TL211','Sie möchten den Personenschutz-Sicherheitsabstand für die Antenne Ihrer Amateurfunkstelle in Hauptstrahlrichtung für das 2- m-Band und die Betriebsart FM berechnen. Der Grenzwert im Fall des Personenschutzes beträgt 28 V/m. Sie betreiben eine Yagi- Antenne mit einem Gewinn von 11,5 dBd. Die Antenne wird von einem Sender mit einer Leistung von 75 W über ein Koaxialkabel gespeist. Die Kabeldämpfung beträgt 1,5 dB. Wie groß muss der Sicherheitsabstand sein?',0,1,0,0,'');
INSERT INTO question VALUES(367,'TL212','Sie errechnen einen Sicherheitsabstand für Ihre Antenne. Von welchem Punkt aus muss dieser Sicherheitsabstand eingehalten werden, wenn Sie bei der Berechnung die Fernfeldnäherung verwendet haben?',0,1,0,0,'');
INSERT INTO question VALUES(368,'TL213','Mit welcher Ausgangsleistung rechnen Sie im Fall des Personenschutzes, um den Sicherheitsabstand zu ermitteln?',0,1,0,0,'');
INSERT INTO question VALUES(369,'TL214','Herzschrittmacher können auch durch die Aussendung einer Amateurfunkstelle beeinflusst werden. Gibt es einen zeitlichen Grenzwert für die Einwirkdauer?',0,1,0,0,'');
INSERT INTO question VALUES(370,'TL301','Unter welchen Bedingungen darf das Standrohr einer Amateurfunkantenne auf einem Gebäude mit einer vorhandenen Blitzschutzanlage verbunden werden?',0,1,0,0,'');
INSERT INTO question VALUES(371,'TL302','Welches Material und welcher Mindestquerschnitt ist bei einer Erdungsleitung zwischen einem Antennenstandrohr und einer Erdungsanlage nach DIN VDE 0855 Teil 300 für Funksender bis 1 kW zu verwenden?',0,1,0,0,'');
INSERT INTO question VALUES(372,'TL303','Unter welchen Bedingungen darf ein Fundamenterder als Blitzschutzerder verwendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(373,'TL304','Welche Sicherheitsmaßnahmen müssen zum Schutz gegen atmosphärische Überspannungen und zur Verhinderung von Spannungsunterschieden bei Koaxialkabel- Niederführungen ergriffen werden?',0,1,0,0,'');
INSERT INTO question VALUES(374,'TL305','Welche der Antworten A bis D enthält die heutzutage normgerechten Adern- Kennfarben von 3-adrigen, isolierten Energieleitungen und -kabeln in der Abfolge: Schutzleiter, Außenleiter, Neutralleiter?',0,1,0,0,'');
INSERT INTO question VALUES(375,'TL306','Damit die Zulassung eines Kraftfahrzeugs nicht ungültig wird, sind vor dem Einbau einer mobilen Sende-/Empfangseinrichtung grundsätzlich',0,1,0,0,'');
INSERT INTO question VALUES(376,'TL307','Wo sollte aus funktechnischer Sicht eine mobile VHF-Antenne an einem PKW vorzugsweise installiert werden?',0,1,0,0,'');
INSERT INTO question VALUES(377,'TL308','Um ein Zusammenwirken mit der Elektronik des Kraftfahrzeugs zu verhindern, sollte das Antennenkabel',0,1,0,0,'');
INSERT INTO question VALUES(378,'TA101','Welche Einheit wird für die elektrische Feldstärke verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(379,'TA102','Welche Einheit wird für die magnetische Feldstärke verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(380,'TA103','In welcher Einheit wird die Impedanz angegeben?',0,1,0,0,'');
INSERT INTO question VALUES(381,'TA104','Die Einheit "Siemens" wird verwendet für die Angabe',0,1,0,0,'');
INSERT INTO question VALUES(382,'TA105','Wenn [s] für Sekunde steht, gilt für die Einheit der Frequenz',0,1,0,0,'');
INSERT INTO question VALUES(383,'TA106','Welche der nachfolgenden Antworten enthält nur Basiseinheiten nach dem internationalen Einheitensystem?',0,1,0,0,'');
INSERT INTO question VALUES(384,'TA107','Einem Spannungsverhältnis von 15 entsprechen',0,1,0,0,'');
INSERT INTO question VALUES(385,'TA108','Einer Leistungsverstärkung von 40 entsprechen',0,1,0,0,'');
INSERT INTO question VALUES(386,'TA109','Wie groß ist der Unterschied zwischen S4 und S7 in dB?',0,1,0,0,'');
INSERT INTO question VALUES(387,'TA110','Der Pegelwert 120 dB &micro;V/m entspricht einer elektrischen Feldstärke von',0,1,0,0,'');
INSERT INTO question VALUES(388,'TA111','100 mW entspricht',0,1,0,0,'');
INSERT INTO question VALUES(389,'TA112','Ein Sender mit 1 Watt Ausgangsleistung ist an eine Endstufe mit einer Verstärkung von 10 dB angeschlossen. Wie groß ist der Ausgangspegel der Endstufe?',0,1,0,0,'');
INSERT INTO question VALUES(390,'TA113','Der Ausgangspegel eines Senders beträgt 20 dBW. Dies entspricht einer Ausgangsleistung von',0,1,0,0,'');
INSERT INTO question VALUES(391,'TA114','Die Periodendauer von 50 µs entspricht einer Frequenz von',0,1,0,0,'');
INSERT INTO question VALUES(392,'TA115','Die zweite Harmonische der Frequenz 3,730 MHz befindet sich auf',0,1,0,0,'');
INSERT INTO question VALUES(393,'TA116','Die zweite ungeradzahlige Harmonische der Frequenz 144,690 MHz ist',0,1,0,0,'');
INSERT INTO question VALUES(394,'TA117','Eine Genauigkeit von 1 ppm entspricht',0,1,0,0,'');
INSERT INTO question VALUES(395,'TA118','Die digitale Anzeige eines Senders hat eine Anzeigegenauigkeit von 10 ppm. Sie zeigt die Sendefrequenz von 14,25 MHz an. In welchen Grenzen kann sich die tatsächliche Frequenz bewegen?',0,1,0,0,'');
INSERT INTO question VALUES(396,'TA119','Die Ausbreitungsgeschwindigkeit freier elektromagnetischer Wellen beträgt etwa',0,1,0,0,'');
INSERT INTO question VALUES(397,'TA120','Welche Frequenz entspricht einer Wellenlänge von 30 mm im Freiraum?',0,1,0,0,'');
INSERT INTO question VALUES(398,'TA121','Eine Wellenlänge von 10 cm im Freiraum entspricht einer Frequenz von',0,1,0,0,'');
INSERT INTO question VALUES(399,'TA122','Welcher Wellenlänge &lambda; entspricht die Frequenz f = 22 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(400,'TA123','Eine Wellenlänge von 2,06 m entspricht einer Frequenz von',0,1,0,0,'');
INSERT INTO question VALUES(401,'TA124','Eine Wellenlänge von 69 cm entspricht einer Frequenz von',0,1,0,0,'');
INSERT INTO question VALUES(402,'TA125','Der Verkürzungsfaktor ist',0,1,0,0,'');
INSERT INTO question VALUES(403,'TB101','Der spezifische Widerstand eines Drahtes entspricht dem Widerstand des Drahtes',0,1,0,0,'');
INSERT INTO question VALUES(404,'TB102','Welchen Widerstand hat eine Kupferdrahtwicklung, wenn der verwendete Draht eine Länge von 1,8 m und einen Durchmesser von 0,2 mm hat?',0,1,0,0,'');
INSERT INTO question VALUES(405,'TB103','Zwischen den Enden eines Kupferdrahtes mit einem Querschnitt von 0,5 mm² messen Sie einen Widerstand von 1,5 Ohm. Wie lang ist der Draht?',0,1,0,0,'');
INSERT INTO question VALUES(406,'TB104','Der Temperaturkoeffizient für den Widerstand von metallischen Leitern ist',0,1,0,0,'');
INSERT INTO question VALUES(407,'TB105','Welche Gruppe von Materialien enthält nur Nichtleiter (Isolatoren)?',0,1,0,0,'');
INSERT INTO question VALUES(408,'TB106','Was versteht man unter Halbleitermaterialien?',0,1,0,0,'');
INSERT INTO question VALUES(409,'TB107','P-leitendes Halbleitermaterial ist gekennzeichnet durch',0,1,0,0,'');
INSERT INTO question VALUES(410,'TB108','Was versteht man unter Dotierung zu P-leitendem Halbleitermaterial bei Halbleiterwerkstoffen?',0,1,0,0,'');
INSERT INTO question VALUES(411,'TB109','N-leitendes Halbleitermaterial ist gekennzeichnet durch',0,1,0,0,'');
INSERT INTO question VALUES(412,'TB110','Was versteht man unter Dotierung zu N-leitendem Halbleitermaterial bei Halbleiterwerkstoffen?',0,1,0,0,'');
INSERT INTO question VALUES(413,'TB111','Das folgende Bild zeigt den prinzipiellen Aufbau einer Halbleiterdiode. Wie entsteht die Sperrschicht?<p><img src=''tb111f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(414,'TB112','In einer Halbleiterdiode erweitert sich die Verarmungszone,<p><img src=''tb111f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(415,'TB201','Ein Sonnenkollektor besteht aus vier parallel geschalteten Reihen von je 30 Solarzellen mit je Zelle 0,6 V Leerlaufspannung und 1 A Kurzschlussstrom. Welche Leerlaufspannung und welchen Kurzschlussstrom liefert der Kollektor? In welcher Zeile sind beide Werte richtig angegeben?<p><img src=''tb201f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(416,'TB202','Die Leerlaufspannung einer Gleichspannungsquelle beträgt 13,5 V. Wenn die Spannungsquelle einen Strom von 0,9 A abgibt, sinkt die Klemmenspannung auf 12,4 V. Wie groß ist der Innenwiderstand der Spannungsquelle?',0,1,0,0,'');
INSERT INTO question VALUES(417,'TB203','Die Leerlaufspannung einer Gleichspannungsquelle beträgt 13,5 V. Wenn die Spannungsquelle einen Strom von 2 A abgibt, sinkt die Klemmenspannung auf 13 V. Wie groß ist der Innenwiderstand der Spannungsquelle?',0,1,0,0,'');
INSERT INTO question VALUES(418,'TB204','Die Leerlaufspannung einer Gleichspannungsquelle beträgt 13,5 V. Wenn die Spannungsquelle einen Strom von 1 A abgibt, sinkt die Klemmenspannung auf 12,5 V. Wie groß ist der Wirkungsgrad?',0,1,0,0,'');
INSERT INTO question VALUES(419,'TB205','Die Leerlaufspannung einer Gleichspannungsquelle beträgt 13,5 V. Wenn die Spannungsquelle einen Strom von 2 A abgibt, sinkt die Klemmenspannung auf 13 V. Wie groß ist der Wirkungsgrad?',0,1,0,0,'');
INSERT INTO question VALUES(420,'TB206','Die Leerlaufspannung einer Spannungsquelle beträgt 5,0 V. Schließt man einen Belastungswiderstand mit 1,2 &Omega; an, so geht die Klemmenspannung der Spannungsquelle auf 4,8 V zurück. Wie hoch ist der Innenwiderstand der Spannungsquelle?',0,1,0,0,'');
INSERT INTO question VALUES(421,'TB207','In welchem Zusammenhang müssen Innenwiderstand R<sub>i</sub> und Lastwiderstand R<sub>L</sub> stehen, damit Leistungsanpassung vorliegt?',0,1,0,0,'');
INSERT INTO question VALUES(422,'TB208','In welchem Zusammenhang müssen Innenwiderstand R<sub>i</sub> und Lastwiderstand R<sub>L</sub> stehen, damit Stromanpassung vorliegt?',0,1,0,0,'');
INSERT INTO question VALUES(423,'TB209','In welchem Zusammenhang müssen Innenwiderstand R<sub>i</sub> und Lastwiderstand R<sub>L</sub> stehen, damit Spannungsanpassung vorliegt?',0,1,0,0,'');
INSERT INTO question VALUES(424,'TB210','Welche Eigenschaften sollten Strom- und Spannungsquellen aufweisen?',0,1,0,0,'');
INSERT INTO question VALUES(425,'TB301','An den Metallbelägen eines Wickelkondensators mit 0,15 mm starkem Kunststoff-Dielektrikum liegt eine Spannung von 300 V. Wie hoch ist die elektrische Feldstärke zwischen den Metallbelägen?<p><img src=''tb301f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(426,'TB302','Eine Blockbatterie hat eine Klemmenspannung von 9 V (EMK). Wie groß ist die elektrische Feldstärke zwischen den beiden Polen der Batterie bei einem Polabstand von 0,6 cm?',0,1,0,0,'');
INSERT INTO question VALUES(427,'TB303','Die elektrische Feldstärke um einen einzelnen Leiter ist proportional',0,1,0,0,'');
INSERT INTO question VALUES(428,'TB304','Ein HF-Abklatschkondensator am Anodenkreis einer Senderendstufe hat eine 0,15 mm starke PTFE-Folie als Dielektrikum. Die Durchschlagsfestigkeit von PTFE beträgt ca. 400 kV/cm. Wie groß wäre die maximale Spannung, die an den Kondensator angelegt werden kann, ohne dass die Folie durchschlagen wird?',0,1,0,0,'');
INSERT INTO question VALUES(429,'TB305','Wie nennt man das Feld zwischen zwei parallelen Kondensatorplatten bei Anschluss einer Gleichspannung?<p><img src=''tb305f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(430,'TB306','Wie werden die mit X gekennzeichneten Feldlinien einer Vertikalantenne bezeichnet?<p><img src=''tb306f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(431,'TB401','Ein Ringkern hat einen mittleren Durchmesser von 2,6 cm und trägt 6 Windungen Kupferdraht. Wie groß ist die mittlere magnetische Feldstärke im Ringkern, wenn der Strom 2,5 A beträgt?<p><img src=''tb401f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(432,'TB402','Eine Spule ohne Eisenkern erzeugt eine Feldstärke von 200 A/m. Wie groß ist die magnetische Flussdichte?',0,1,0,0,'');
INSERT INTO question VALUES(433,'TB403','Welcher Effekt verringert die Induktivität einer von hochfrequentem Strom durchflossenen Spule beim Einführen eines Kupferoder Aluminiumkerns?',0,1,0,0,'');
INSERT INTO question VALUES(434,'TB404','Dauermagnete finden Anwendung in',0,1,0,0,'');
INSERT INTO question VALUES(435,'TB405','Wie nennt man das Feld im Innern einer langen Zylinderspule beim Fließen eines Gleichstroms?<p><img src=''tb405f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(436,'TB406','Wenn Strom durch einen gestreckten Leiter fließt, entsteht ein',0,1,0,0,'');
INSERT INTO question VALUES(437,'TB407','Wie werden die mit X gekennzeichneten Feldlinien einer Vertikalantenne bezeichnet?<p><img src=''tb407f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(438,'TB408','Welches sind die richtigen Einheiten der elektrischen und der magnetischen Feldstärke?',0,1,0,0,'');
INSERT INTO question VALUES(439,'TB501','Wodurch entsteht ein elektromagnetisches Feld und woraus besteht es?',0,1,0,0,'');
INSERT INTO question VALUES(440,'TB502','Wie erfolgt die Ausbreitung einer elektromagnetischen Welle? (Im folgenden Text ist H-Feld die magnetische Feldkomponente und E-Feld die elektrische Feldkomponente.)',0,1,0,0,'');
INSERT INTO question VALUES(441,'TB503','Die Polarisation einer elektromagnetischen Welle wird durch',0,1,0,0,'');
INSERT INTO question VALUES(442,'TB504','Das folgende Bild zeigt die Feldlinien eines elektromagnetischen Feldes. Welche Polarisation hat die skizzierte Wellenfront?<p><img src=''tb504f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(443,'TB505','Die Polarisation einer elektromagnetischen Welle wird definiert durch',0,1,0,0,'');
INSERT INTO question VALUES(444,'TB506','Der Winkel zwischen den E- und H-Feldkomponenten eines elektromagnetischen Feldes beträgt im Fernfeld',0,1,0,0,'');
INSERT INTO question VALUES(445,'TB507','Die Polarisation des Sendesignals in der Hauptstrahlrichtung dieser Richtantenne ist<p><img src=''tb507f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(446,'TB508','Welche Aussage trifft auf die elektromagnetische Ausstrahlung im ungestörten Fernfeld zu?',0,1,0,0,'');
INSERT INTO question VALUES(447,'TB509','Durch welche Größe sind elektrische und magnetische Komponenten eines elektromagnetischen Feldes im Fernfeld miteinander verknüpft?',0,1,0,0,'');
INSERT INTO question VALUES(448,'TB510','Eine vertikale Dipolantenne wird mit 10 W Senderleistung direkt gespeist. Welche elektrische Feldstärke ergibt sich bei Freiraumausbreitung in 10 m Entfernung?',0,1,0,0,'');
INSERT INTO question VALUES(449,'TB511','Eine Yagiantenne mit 12,15 dBi Antennengewinn wird mit 250 W Senderleistung direkt gespeist. Welche elektrische Feldstärke ergibt sich bei Freiraumausbreitung in 30 m Entfernung?',0,1,0,0,'');
INSERT INTO question VALUES(450,'TB512','Welche elektrische Feldstärke E herrscht in der Mitte der dargestellten, symmetrisch aufgebauten Messzelle, wenn der angeschlossene Sender 1 Watt Ausgangsleistung liefert?<p><img src=''tb512f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(451,'TB601','Welche der im folgenden Diagramm eingezeichneten Gleichspannungen (U<sub>1</sub> ... U<sub>6</sub>) setzen an einem Wirkwiderstand die gleiche Leistung um wie die dargestellte sinusförmige Wechselspannung?<p><img src=''tb601f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(452,'TB602','Wie groß ist der Spitzen-Spitzen-Wert (U<sub>ss</sub>) der in der Abbildung dargestellten Spannung?<p><img src=''tb602f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(453,'TB603','Wie groß ist der Spitzen-Spitzen-Wert der in diesem Schirmbild dargestellten Spannung?<p><img src=''tb603f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(454,'TB604','Welche Frequenz hat die in diesem Oszillogramm dargestellte Spannung?<p><img src=''tb603f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(455,'TB605','Welche Frequenz hat das in diesem Schirmbild dargestellte Signal?<p><img src=''tb605f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(456,'TB606','Welche Frequenz hat die in diesem Oszillogramm dargestellte Spannung?<p><img src=''tb602f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(457,'TB607','Ein sinusförmiges Signal hat einen Effektivwert von 12 V. Wie groß ist der Spitzen-Spitzen-Wert?',0,1,0,0,'');
INSERT INTO question VALUES(458,'TB608','Der Spitzenwert der häuslichen 230-V-Stromversorgung beträgt',0,1,0,0,'');
INSERT INTO question VALUES(459,'TB609','Der Spitzen-Spitzen-Wert der häuslichen 230-V-Stromversorgung ist',0,1,0,0,'');
INSERT INTO question VALUES(460,'TB610','Ein sinusförmiger Wechselstrom mit einer Amplitude (I<sub>max</sub>) von 0,5 Ampere fließt durch einen Widerstand von 20 Ohm. Wie hoch ist die aufgenommene Leistung?',0,1,0,0,'');
INSERT INTO question VALUES(461,'TB611','Welche Antwort enthält die richtigen Phasenwinkel einer sinusförmigen Wechselspannung an der mit X<sub>3</sub> bezeichneten Stelle?<p><img src=''tb611f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(462,'TB612','Die Phasendifferenz zwischen den beiden in der Abbildung dargestellten Sinussignalen beträgt<p><img src=''tb612f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(463,'TB701','Ein symmetrisches Rechtecksignal hat eine Grundfrequenz von 1500 Hz. Welche Frequenzen sind in diesem Signal enthalten?<p><img src=''tb701f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(464,'TB702','Die Impulsdauer beträgt hier<p><img src=''tb702f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(465,'TB703','Was sind Harmonische?',0,1,0,0,'');
INSERT INTO question VALUES(466,'TB704','Die dritte Oberwelle einer Frequenz ist',0,1,0,0,'');
INSERT INTO question VALUES(467,'TB705','Welche Schwingungen sind in der folgenden Wechselspannung enthalten, wenn die Grundwelle 2 kHz beträgt?<p><img src=''tb705f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(468,'TB706','Welche Schwingungen sind in der folgenden Wechselspannung enthalten, wenn die Grundwelle 2 kHz beträgt?<p><img src=''tb706f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(469,'TB707','Die Leistung eines gleichmäßig über einen Frequenzbereich verteilten Rauschens ist',0,1,0,0,'');
INSERT INTO question VALUES(470,'TB708','Wie verhält sich der Pegel des thermischen Rauschens am Empfängerausgang, wenn von einem Quarzfilter mit einer Bandbreite von 2,5 kHz auf ein Quarzfilter mit einer Bandbreite von 0,5 kHz mit gleicher Durchlassdämpfung und Flankensteilheit umgeschaltet wird? Der Rauschpegel',0,1,0,0,'');
INSERT INTO question VALUES(471,'TB801','Wie groß ist die HF-Bandbreite, die für die Übertragung eines SSB-Signals erforderlich ist?',0,1,0,0,'');
INSERT INTO question VALUES(472,'TB802','Ein Träger von 7,05 MHz wird mit der NF-Frequenz von 2 kHz in SSB (LSB) moduliert. Welche Frequenzen treten im modulierten HF-Signal auf?',0,1,0,0,'');
INSERT INTO question VALUES(473,'TB803','Ein Träger von 145 MHz wird mit der NF-Frequenz von 2 kHz und einem Hub von 1,8 kHz frequenzmoduliert. Welche Bandbreite hat das modulierte Signal?',0,1,0,0,'');
INSERT INTO question VALUES(474,'TB804','Warum wird bei FM senderseitig eine Preemphasis eingesetzt?',0,1,0,0,'');
INSERT INTO question VALUES(475,'TB805','Kann man auf der Empfängerseite bei Sprachübertragung Frequenz- und Phasenmodulation unterscheiden?',0,1,0,0,'');
INSERT INTO question VALUES(476,'TB806','Zwei in etwa pegelgleiche Aussendungen können an einer nichtlinear arbeitenden Empfängerstufe',0,1,0,0,'');
INSERT INTO question VALUES(477,'TB901','Die Ausgangsleistung eines Senders ist',0,1,0,0,'');
INSERT INTO question VALUES(478,'TB902','Die Spitzenleistung eines Senders (PEP) ist',0,1,0,0,'');
INSERT INTO question VALUES(479,'TB903','Die mittlere Leistung eines Senders ist',0,1,0,0,'');
INSERT INTO question VALUES(480,'TB904','Die äquivalente (effektive) Strahlungsleistung (ERP) ist',0,1,0,0,'');
INSERT INTO question VALUES(481,'TB905','Die äquivalente isotrope Strahlungsleistung (EIRP) ist',0,1,0,0,'');
INSERT INTO question VALUES(482,'TB906','Die belegte Bandbreite einer Aussendung ist die Frequenzbandbreite,',0,1,0,0,'');
INSERT INTO question VALUES(483,'TB907','Was versteht man unter dem Begriff "EIRP"?',0,1,0,0,'');
INSERT INTO question VALUES(484,'TB908','Die Spitzenleistung eines Senders ist die',0,1,0,0,'');
INSERT INTO question VALUES(485,'TB909','Wie wird die ERP (Effective Radiated Power oder auch Equivalent Radiated Power) berechnet und worauf ist sie bezogen?',0,1,0,0,'');
INSERT INTO question VALUES(486,'TB910','Wie wird die EIRP ermittelt?',0,1,0,0,'');
INSERT INTO question VALUES(487,'TB911','Um die Störwahrscheinlichkeit zu verringern, sollte die benutzte Sendeleistung',0,1,0,0,'');
INSERT INTO question VALUES(488,'TB912','Gelten die Formeln für die Leistung an einem ohmschen Widerstand auch bei Wechselspannung?',0,1,0,0,'');
INSERT INTO question VALUES(489,'TB913','An einem Kondensator mit einer Kapazität von 1 µF wird eine NF-Spannung von 10 kHz und 12 V<sub>eff</sub> angelegt. Wie groß ist die aufgenommene Wirkleistung im eingeschwungenen Zustand?',0,1,0,0,'');
INSERT INTO question VALUES(490,'TB914','Welche Belastbarkeit muss ein 100-Ohm-Widerstand, an dem 10 Volt anliegen, mindestens haben?',0,1,0,0,'');
INSERT INTO question VALUES(491,'TB915','Eine Glühlampe hat einen Nennwert von 12 V und 48 W. Wie hoch ist die Stromentnahme bei einer 12-V-Versorgung?',0,1,0,0,'');
INSERT INTO question VALUES(492,'TB916','Der Effektivwert der Spannung an einer künstlichen 50-&Omega;-Antenne wird mit 100 V gemessen. Die Leistung an der Last beträgt',0,1,0,0,'');
INSERT INTO question VALUES(493,'TB917','Eine künstliche 50-&Omega;-Antenne besteht aus elf 560-&Omega;-Kohleschichtwiderständen mit einem Belastungsnennwert von jeweils 5 W. Wie hoch ist die zulässige Gesamtleistung die angelegt werden darf?',0,1,0,0,'');
INSERT INTO question VALUES(494,'TB918','Ein mit einer künstlichen 50-&Omega;-Antenne in Serie geschaltetes Amperemeter zeigt 2 A an. Die Leistung in der Last beträgt',0,1,0,0,'');
INSERT INTO question VALUES(495,'TB919','Ein HF-Verstärker ist an eine 12,5-V-Gleichstrom-Versorgung angeschlossen. Wenn die HF-Ausgangsleistung des Verstärkers 90 W beträgt, zeigt das an die Stromversorgung angeschlossene Amperemeter 16 A an. Der Wirkungsgrad des Verstärkers beträgt',0,1,0,0,'');
INSERT INTO question VALUES(496,'TB920','Eine HF-Ausgangleistung von 100 W wird in eine angepasste Übertragungsleitung eingespeist. Am antennenseitigen Ende der Leitung beträgt die Leistung 50 W bei einem Stehwellenverhältnis von 1. Wie hoch ist die Leitungsdämpfung?',0,1,0,0,'');
INSERT INTO question VALUES(497,'TB921','Ein Spannungsmesser und ein Amperemeter werden für die Ermittlung der Gleichstromeingangsleistung einer Schaltung verwendet. Der Spannungsmesser zeigt 10 V, das Amperemeter 10 A an. Falls beide dabei im Rahmen ihrer Messgenauigkeit jeweils einen um 5 % zu geringen Wert anzeigen würden, würde man die elektrische Leistung um',0,1,0,0,'');
INSERT INTO question VALUES(498,'TB922','An einem Widerstand R wird die elektrische Leistung P in Wärme umgesetzt. Sie kennen die Größen P und R. Nach welcher der Formeln können Sie die Spannung ermitteln, die an dem Widerstand R anliegt?',0,1,0,0,'');
INSERT INTO question VALUES(499,'TB923','In welcher Antwort sind alle dargestellten Zusammenhänge zwischen Strom, Spannung, Widerstand und Leistung richtig?',0,1,0,0,'');
INSERT INTO question VALUES(500,'TB924','In welcher Antwort sind alle dargestellten Zusammenhänge zwischen Widerstand, Leistung, Spannung und Strom richtig?',0,1,0,0,'');
INSERT INTO question VALUES(501,'TC101','Welche Schaltung könnte dazu verwendet werden, den Wert eines Widerstandes anhand des ohmschen Gesetzes zu ermitteln?',0,1,0,0,'');
INSERT INTO question VALUES(502,'TC102','Metallschichtwiderstände',0,1,0,0,'');
INSERT INTO question VALUES(503,'TC103','Metalloxidwiderstände',0,1,0,0,'');
INSERT INTO question VALUES(504,'TC104','Drahtwiderstände',0,1,0,0,'');
INSERT INTO question VALUES(505,'TC105','Ein Widerstand von 10 k&Omega; hat eine maximale Spannungsfestigkeit von 0,7 kV und eine maximale Belastbarkeit von einem Watt. Welche Gleichspannung darf höchstens an den Widerstand angelegt werden ohne ihn zu überlasten?',0,1,0,0,'');
INSERT INTO question VALUES(506,'TC106','Ein Widerstand von 50 k&Omega; hat eine maximale Spannungsfestigkeit von 0,7 kV und eine maximale Belastbarkeit von 2 Watt. Welche Gleichspannung darf höchstens an den Widerstand angelegt werden ohne ihn zu überlasten?',0,1,0,0,'');
INSERT INTO question VALUES(507,'TC107','Welche Belastbarkeit muss ein Vorwiderstand haben, an dem bei einem Strom von 48 mA eine Spannung von 208 V abfallen soll?',0,1,0,0,'');
INSERT INTO question VALUES(508,'TC108','Ein Widerstand von 120 &Omega; hat eine Belastbarkeit von 23 Watt. Welcher Strom darf höchstens durch den Widerstand fließen, damit er nicht überlastet wird?',0,1,0,0,'');
INSERT INTO question VALUES(509,'TC109','Ein Widerstand hat eine Toleranz von 10 %. Bei einem nominalen Widerstandswert von 5,6 k&Omega; liegt der tatsächliche Wert zwischen',0,1,0,0,'');
INSERT INTO question VALUES(510,'TC110','Eine Glühlampe hat einen Nennwert von 12 V und 3 W. Wie viel Strom fließt beim Anschluss an 12 V?',0,1,0,0,'');
INSERT INTO question VALUES(511,'TC111','Ein Oszilloskop zeigt einen sinusförmigen Spitze-Spitze-Wert von 25 V an einem 1000-&Omega;-Widerstand an. Der Effektivstrom durch den Widerstand beträgt',0,1,0,0,'');
INSERT INTO question VALUES(512,'TC112','Ein Lastwiderstand besteht aus zwölf parallelgeschalteten 600-&Omega;-Drahtwiderständen. Er eignet sich höchstens',0,1,0,0,'');
INSERT INTO question VALUES(513,'TC113','Eine künstliche Antenne für den VHF-Bereich könnte beispielsweise aus',0,1,0,0,'');
INSERT INTO question VALUES(514,'TC114','Welche der folgenden Bauteile könnten für eine genaue künstliche Antenne, die bei 50 MHz eingesetzt werden soll, verwendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(515,'TC115','Aus welchen Bauteilen sollte eine künstliche Antenne für den VHF-Bereich gebaut werden?',0,1,0,0,'');
INSERT INTO question VALUES(516,'TC201','Welche Aussage zur Kapazität eines Plattenkondensators ist richtig?',0,1,0,0,'');
INSERT INTO question VALUES(517,'TC202','Welchen zeitlichen Verlauf hat die Spannung an einem entladenen Kondensator, wenn dieser über einen Widerstand an eine Gleichspannungsquelle angeschlossen wird?',0,1,0,0,'');
INSERT INTO question VALUES(518,'TC203','Ein verlustloser Kondensator wird an eine Wechselspannungsquelle angeschlossen. Welche Phasenverschiebung zwischen Spannung und Strom stellt sich ein?',0,1,0,0,'');
INSERT INTO question VALUES(519,'TC204','Wie verhält sich der Wechselstromwiderstand eines Kondensators mit zunehmender Frequenz?',0,1,0,0,'');
INSERT INTO question VALUES(520,'TC205','Wie groß ist der kapazitive Widerstand eines 10-pF-Kondensators bei 100 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(521,'TC206','An einem unbekannten Kondensator liegt eine Wechselspannung mit 16 V und 50 Hz. Es wird ein Strom von 32 mA gemessen. Welche Kapazität hat der Kondensator?',0,1,0,0,'');
INSERT INTO question VALUES(522,'TC207','Was versteht man unter dem Blindwiderstand eines Kondensators und von welchen physikalischen Größen hängt er ab?',0,1,0,0,'');
INSERT INTO question VALUES(523,'TC208','Neben dem kapazitiven Blindwiderstand treten im Wechselstrom durchflossenen Kondensator auch Verluste auf, die rechnerisch in einem parallelgeschalteten Verlustwiderstand zusammengefasst werden können. Die Kondensatorverluste werden angegeben durch',0,1,0,0,'');
INSERT INTO question VALUES(524,'TC209','Entsteht in einem Wechselstrom durchflossenen Kondensator eine Verlustleistung?',0,1,0,0,'');
INSERT INTO question VALUES(525,'TC301','An eine Spule wird über einen Widerstand eine Gleichspannung angelegt. Welches der nachfolgenden Diagramme zeigt den zeitlichen Verlauf der Spannung über der Spule?',0,1,0,0,'');
INSERT INTO question VALUES(526,'TC302','In einer reinen Induktivität, die an einer Wechselspannungsquelle angeschlossen ist, eilt der Strom der angelegten Spannung',0,1,0,0,'');
INSERT INTO question VALUES(527,'TC303','Wie verhält sich der Wechselstromwiderstand einer Spule mit zunehmender Frequenz?',0,1,0,0,'');
INSERT INTO question VALUES(528,'TC304','Beim Anlegen einer Gleichspannung U = 1 V an eine Spule messen Sie einen Strom. Wird der Strom beim Anlegen von einer Wechselspannung mit U<sub>eff</sub> = 1 V größer oder kleiner?',0,1,0,0,'');
INSERT INTO question VALUES(529,'TC305','Wie groß ist der Wechselstromwiderstand einer Spule mit 3 &micro;H Induktivität bei einer Frequenz von 100 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(530,'TC306','Was versteht man unter dem Blindwiderstand einer Spule und von welchen physikalischen Größen hängt er ab?',0,1,0,0,'');
INSERT INTO question VALUES(531,'TC307','Neben dem induktiven Blindwiderstand treten in der Wechselstrom durchflossenen Spule auch Verluste auf, die rechnerisch in einem seriellen Verlustwiderstand zusammengefasst werden können. Die Verluste einer Spule werden angegeben durch',0,1,0,0,'');
INSERT INTO question VALUES(532,'TC308','Hat ein gerades Leiterstück eine Induktivität?',0,1,0,0,'');
INSERT INTO question VALUES(533,'TC309','Wie kann man die Induktivität einer Spule vergrößern?',0,1,0,0,'');
INSERT INTO question VALUES(534,'TC310','Mit einem Schalenkern dessen A<sub>L</sub>-Wert mit 250 angegeben ist, soll eine Spule mit einer Induktivität von 2 mH hergestellt werden. Wie groß ist die erforderliche Windungszahl?',0,1,0,0,'');
INSERT INTO question VALUES(535,'TC311','Wie groß ist die Induktivität einer Spule mit 300 Windungen, die auf einen Kern mit einem A<sub>L</sub>-Wert von 1250 gewickelt ist?',0,1,0,0,'');
INSERT INTO question VALUES(536,'TC312','Wie groß ist die Induktivität einer Spule mit 14 Windungen, die auf einen Kern mit einem A<sub>L</sub>-Wert von 1,5 gewickelt ist?',0,1,0,0,'');
INSERT INTO question VALUES(537,'TC313','Ein Spulenkern hat einen A<sub>L</sub>-Wert von 30. Wie groß ist die erforderliche Windungszahl zur Herstellung einer Induktivität von 12 µH?',0,1,0,0,'');
INSERT INTO question VALUES(538,'TC314','Welche Folgen hat der Skin-Effekt?',0,1,0,0,'');
INSERT INTO question VALUES(539,'TC315','Was verstehen Sie unter dem technischen Ausdruck Skin-Effekt?',0,1,0,0,'');
INSERT INTO question VALUES(540,'TC316','Das folgende Bild zeigt einen Kern, um den ein Kabel für den Bau einer Netzdrossel gewickelt ist. Der Kern sollte aus<p><img src=''tb401f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(541,'TC317','Für die Unterdrückung parasitärer Schwingungen kann eine verlustbehaftete Drosselspule verwendet werden. Wie wird eine solche Spule gebaut?',0,1,0,0,'');
INSERT INTO question VALUES(542,'TC318','Um die Abstrahlungen der Spule eines abgestimmten Schwingkreises zu verringern, sollte die Spule',0,1,0,0,'');
INSERT INTO question VALUES(543,'TC319','Durch Gegeninduktion wird in einer Spule eine Spannung erzeugt, wenn',0,1,0,0,'');
INSERT INTO question VALUES(544,'TC401','Ein Trafo liegt an 230 Volt und gibt 11,5 Volt ab. Seine Primärwicklung hat 600 Windungen. Wie groß ist seine Sekundärwindungszahl?',0,1,0,0,'');
INSERT INTO question VALUES(545,'TC402','Ein Transformator setzt die Spannung von 230 Volt auf 6 Volt herunter und liefert dabei einen Strom von 1,15 A. Wie groß ist der dadurch in der Primärwicklung zu erwartende Strom bei Vernachlässigung der Verluste?',0,1,0,0,'');
INSERT INTO question VALUES(546,'TC403','Eine Transformatorwicklung hat einen Drahtdurchmesser von 0,5 mm. Die zulässige Stromdichte beträgt 2,5 A/mm². Wie groß ist der zulässige Strom?',0,1,0,0,'');
INSERT INTO question VALUES(547,'TC404','In dieser Schaltung ist R = 16 k&Omega;. Die Impedanz zwischen den Anschlüssen A und B beträgt somit<p><img src=''tc404f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(548,'TC405','In dieser Schaltung ist R = 6,4 k&Omega;. Die Impedanz zwischen den Anschlüssen A und B beträgt somit<p><img src=''tc404f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(549,'TC406','Für die Anpassung einer 300-&Omega;-Antenne an eine 75-&Omega;-Übertragungsleitung kann ein Übertrager mit einem Windungszahlenverhältnis von',0,1,0,0,'');
INSERT INTO question VALUES(550,'TC407','Für die Anpassung einer 50-&Omega;-Übertragungsleitung an eine 600-&Omega;-Antenne wird ein Übertrager verwendet. Er sollte ein Windungszahlverhältnis von',0,1,0,0,'');
INSERT INTO question VALUES(551,'TC501','Wie verhalten sich die Elektronen in einem in Durchlassrichtung betriebenen PN-Übergang?',0,1,0,0,'');
INSERT INTO question VALUES(552,'TC502','Ein in Durchlassrichtung betriebener PN-Übergang ermöglicht',0,1,0,0,'');
INSERT INTO question VALUES(553,'TC503','Eine in Sperrrichtung betriebene Diode hat',0,1,0,0,'');
INSERT INTO question VALUES(554,'TC504','Welche typischen Schwellspannungen haben Germanium- und Siliziumdioden? Sie liegen bei',0,1,0,0,'');
INSERT INTO question VALUES(555,'TC505','Wie ändert sich die Durchlassspannung einer Diode mit der Temperatur?',0,1,0,0,'');
INSERT INTO question VALUES(556,'TC506','Bei welcher Bedingung wird eine Siliziumdiode leitend?',0,1,0,0,'');
INSERT INTO question VALUES(557,'TC507','Die Auswahlantworten enthalten Siliziumdioden mit unterschiedlichen Arbeitspunkten. Bei welcher Antwort befindet sich die Diode in leitendem Zustand?',0,1,0,0,'');
INSERT INTO question VALUES(558,'TC508','Die Auswahlantworten enthalten Siliziumdioden mit unterschiedlichen Arbeitspunkten. Bei welcher Antwort befindet sich die Diode in leitendem Zustand?',0,1,0,0,'');
INSERT INTO question VALUES(559,'TC509','Die Auswahlantworten enthalten Siliziumdioden mit unterschiedlichen Arbeitspunkten. Bei welcher Antwort befindet sich die Diode in leitendem Zustand?',0,1,0,0,'');
INSERT INTO question VALUES(560,'TC510','Die Auswahlantworten enthalten Siliziumdioden mit unterschiedlichen Arbeitspunkten. Bei welcher Antwort befindet sich die Diode in leitendem Zustand?',0,1,0,0,'');
INSERT INTO question VALUES(561,'TC511','In welcher Zeile sind die Diodentypen der entsprechenden Kennlinie richtig zugeordnet?<p><img src=''tc511f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(562,'TC512','Welche der folgenden Kennlinien ist typisch für eine Germaniumdiode?<p><img src=''tc512f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(563,'TC513','In welcher Zeile sind die Diodentypen der entsprechenden Kennlinie richtig zugeordnet?<p><img src=''tc512f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(564,'TC514','In welcher der folgenden Schaltungen ist die Z-Diode zur Spannungsstabilisierung richtig eingesetzt?',0,1,0,0,'');
INSERT INTO question VALUES(565,'TC515','In welcher der folgenden Schaltungen ist die Z-Diode zur Spannungsstabilisierung richtig eingesetzt?',0,1,0,0,'');
INSERT INTO question VALUES(566,'TC516','Eine unbelastete Z-Diode soll eine 12-VBetriebsspannung auf 5 V stabilisieren. Dabei soll ein Strom von 25 mA durch die Z-Diode fließen. Berechnen Sie den Vorwiderstand. Die Werte des benötigten Vorwiderstandes betragen<p><img src=''tc516f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(567,'TC517','Folgende Schaltung einer Stabilisierungsschaltung mit Z-Diode ist gegeben. Der Strom durch die Z-Diode soll 25 mA betragen und der Laststrom ist 20 mA. Der Wert des notwendigen Vorwiderstandes beträgt<p><img src=''tc517f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(568,'TC518','Eine Leuchtdiode mit einer Durchlassspannung von 1,4 V und einem Durchlassstrom von 20 mA soll an eine Spannungsquelle von 5,0 V angeschlossen werden. Berechnen Sie den Vorwiderstand. Die Größe des benötigten Vorwiderstandes beträgt',0,1,0,0,'');
INSERT INTO question VALUES(569,'TC519','Folgende Schaltung einer Leuchtdiode wird an einer Betriebsspannung von 5,5 V betrieben. Der Strom durch die Leuchtdiode soll 25 mA betragen, wobei die Durchlassspannung 1,75 V beträgt. Der notwendige Vorwiderstand muss folgende Werte haben.<p><img src=''tc519f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(570,'TC520','Wie verändert sich die Frequenz des Schwingkreises in der folgenden Schaltung, wenn das Potentiometer P mehr in Richtung X gedreht wird?<p><img src=''tc520f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(571,'TC521','Wie verhält sich die Kapazität einer Kapazitätsdiode (Varicap)?',0,1,0,0,'');
INSERT INTO question VALUES(572,'TC522','Welches sind die Haupteigenschaften einer Schottkydiode?',0,1,0,0,'');
INSERT INTO question VALUES(573,'TC523','Die Hauptfunktion eines Optokopplers ist',0,1,0,0,'');
INSERT INTO question VALUES(574,'TC524','Die Hauptfunktion einer Fotodiode ist',0,1,0,0,'');
INSERT INTO question VALUES(575,'TC525','Das folgende Signal wird als U<sub>1</sub> an den Eingang der Schaltung mit Siliziumdioden gelegt. Wie sieht das zugehörige Ausgangssignal U<sub>2</sub> aus?<p><img src=''tc525f1.jpg''></p><p><img src=''tc525f2.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(576,'TC526','Das folgende Signal wird als U<sub>1</sub> an den Eingang der Schaltung mit Germaniumdioden gelegt. Wie sieht das zugehörige Ausgangssignal U<sub>2</sub> aus?<p><img src=''tc525f1.jpg''></p><p><img src=''tc525f2.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(577,'TC527','In der folgenden Schaltung werden 3 Siliziumdioden zur Entkopplung dreier Stromversorgungen eingesetzt. Der Sonnenkollektor liefert U<sub>1</sub> = 14,9 V. Der Akkumulator hat U<sub>2</sub> = 13,9 V. Das Netzteil ist auf U<sub>3</sub> = 13,5 V eingestellt. In welcher Zeile ist der sich unter diesen Voraussetzungen einstellende Zustand der 3 Dioden richtig beschrieben?<p><img src=''tc527f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(578,'TC528','In welcher der folgenden Schaltungen ist die Diode zur Spannungsbegrenzung einer Schaltstufe richtig eingesetzt?',0,1,0,0,'');
INSERT INTO question VALUES(579,'TC601','Welche Bezeichnungen für die Bauelemente sind richtig? <p>1: <img src=''tc601f1.png''></p><p>2: <img src=''tc601f2.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(580,'TC602','Welche Bezeichnungen für die Bauelemente sind richtig? <p>1: <img src=''tc602f1.png''></p><p>2: <img src=''tc602f2.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(581,'TC603','Der folgende Transistor ist ein<p><img src=''tc603f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(582,'TC604','Welcher der folgenden Transistoren ist ein selbstleitender P-Kanal MOSFET?',0,1,0,0,'');
INSERT INTO question VALUES(583,'TC605','Welcher der folgenden Transistoren ist ein selbstsperrender N-Kanal MOSFET?',0,1,0,0,'');
INSERT INTO question VALUES(584,'TC606','Wie bezeichnet man die Anschlüsse 2 und 3 des folgenden Transistors?<p><img src=''tc606f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(585,'TC607','Welche Kollektorspannungen haben NPN und PNP-Transistoren?',0,1,0,0,'');
INSERT INTO question VALUES(586,'TC608','Welche Transistortypen sind bipolare Transistoren?',0,1,0,0,'');
INSERT INTO question VALUES(587,'TC609','Wie erfolgt die Steuerung des Stroms im Feldeffekttransistor (FET)?',0,1,0,0,'');
INSERT INTO question VALUES(588,'TC610','Wie groß ist der Kollektorstrom eines bipolaren Transistors, wenn die Spannung an seiner Basis die gleiche Höhe hat wie die Spannung an seinem Emitter?',0,1,0,0,'');
INSERT INTO question VALUES(589,'TC611','Bei welcher Basisspannung ist ein NPN-Transistor ausgeschaltet? Er ist ausgeschaltet bei einer Basisspannung, die',0,1,0,0,'');
INSERT INTO question VALUES(590,'TC612','Wie groß ist die Basisspannung eines NPN-Silizium-Transistors, wenn sich dieser in leitendem Zustand befindet?',0,1,0,0,'');
INSERT INTO question VALUES(591,'TC613','Bei einem bipolaren Transistor in leitendem Zustand befindet sich die Emitter-Basis-Diode',0,1,0,0,'');
INSERT INTO question VALUES(592,'TC614','In einer Schaltung wurden die Spannungen der Transistoranschlüsse gegenüber Massepotenzial gemessen. Bei welchem der folgenden Transistoren fließt Kollektorstrom?',0,1,0,0,'');
INSERT INTO question VALUES(593,'TC615','In einer Schaltung wurden die Spannungen der Transistoranschlüsse gegenüber Massepotenzial gemessen. Bei welchem der folgenden Transistoren fließt Kollektorstrom?',0,1,0,0,'');
INSERT INTO question VALUES(594,'TC616','In einer Schaltung wurden die Spannungen der Transistoranschlüsse gegenüber Massepotenzial gemessen. Bei welchem der folgenden Transistoren fließt Kollektorstrom?',0,1,0,0,'');
INSERT INTO question VALUES(595,'TC617','In einer Schaltung wurden die Spannungen der Transistoranschlüsse gegenüber Massepotenzial gemessen. Bei welchem der folgenden Transistoren fließt Kollektorstrom?',0,1,0,0,'');
INSERT INTO question VALUES(596,'TC618','Die Betriebsspannung beträgt 10 V, der Kollektorstrom soll 2 mA betragen, die Gleichstromverstärkung des Transistors beträgt 200. Berechnen Sie den Vorwiderstand R<sub>1</sub>.<p><img src=''tc618f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(597,'TC619','Die Betriebsspannung beträgt 10 V, der Kollektorstrom soll 2 mA betragen, die Gleichstromverstärkung des Transistors beträgt 200. Durch den Querwiderstand R<sub>2</sub> soll der zehnfache Basisstrom fließen. Berechnen Sie den Vorwiderstand R<sub>1</sub>.<p><img src=''tc619f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(598,'TC620','Die Betriebsspannung beträgt 10 V, der Kollektorstrom soll 2 mA betragen, die Gleichstromverstärkung des Transistors beträgt 200. Durch den Querwiderstand R<sub>2</sub> soll der zehnfache Basisstrom fließen. Am Emitterwiderstand soll 1 V abfallen. Berechnen Sie den Vorwiderstand R<sub>1</sub>.<p><img src=''tc620f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(599,'TC621','Die Betriebsspannung beträgt 10 V, der Kollektorstrom soll 2 mA betragen, die Gleichstromverstärkung des Transistors beträgt 200. Die Kollektor-Emitterspannung soll 6 V betragen. Berechnen Sie den Vorwiderstand R<sub>1</sub>.<p><img src=''tc621f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(600,'TC622','Die Betriebsspannung beträgt 10 V, der Kollektorstrom soll 2 mA betragen, die Gleichstromverstärkung des Transistors beträgt 100. Die Kollektor-Emitterspannung soll 6 V betragen. Berechnen Sie den Kollektorwiderstand R<sub>C</sub>.<p><img src=''tc621f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(601,'TC623','Was passiert, wenn der Widerstand R<sub>2</sub> durch eine fehlerhafte Lötstelle an einer Seite keinen Kontakt mehr zur Schaltung hat (Leerlauf)? In welcher Zeile sind beide Aussagen richtig?<p><img src=''tc623f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(602,'TC624','Was passiert, wenn der Widerstand R<sub>1</sub> durch eine fehlerhafte Lötstelle an einer Seite keinen Kontakt mehr zur Schaltung hat (Leerlauf)? In welcher Zeile sind beide Aussagen richtig?<p><img src=''tc623f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(603,'TC625','Bei folgender Emitterschaltung wird die Schaltung ohne den Emitterkondensator betrieben. Auf welchen Betrag etwa sinkt die Spannungsverstärkung?<p><img src=''tc625f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(604,'TC626','Folgendes Signal U<sub>E</sub> wurde auf den Eingang folgender Schaltung gegeben. In welcher Antwort sind alle dargestellten Signale phasenrichtig zugeordnet?<p><img src=''tc626f1.jpg''></p><p><img src=''tc626f2.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(605,'TC701','Eine integrierte Schaltung ist',0,1,0,0,'');
INSERT INTO question VALUES(606,'TC702','Welche Funktion hat ein Gatter?',0,1,0,0,'');
INSERT INTO question VALUES(607,'TC703','Wie heißen die Grundbausteine in der Digitaltechnik?',0,1,0,0,'');
INSERT INTO question VALUES(608,'TC704','Welche der Aussagen trifft für diese Schaltung zu?<p><img src=''tc704f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(609,'TC705','Welche logische Grundschaltung stellt die folgende Transistorschaltung dar und wie arbeitet sie?<p><img src=''tc705f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(610,'TC706','Welche logische Grundschaltung stellt die folgende Transistorschaltung dar und wie arbeitet sie?<p><img src=''tc706f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(611,'TC707','Welches der vier im Bild dargestellten Ausgangssignale X<sub>1</sub> bis X<sub>4</sub> liefert ein ODER-Gatter, wenn an dessen Eingängen die Signale E<sub>1</sub> und E<sub>2</sub> anliegen?<p><img src=''tc707f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(612,'TC708','Welches der vier im Bild dargestellten Ausgangssignale X<sub>1</sub> bis X<sub>4</sub> liefert ein EXOR-Gatter, wenn an dessen Eingängen die Signale E<sub>1</sub> und E<sub>2</sub> anliegen?<p><img src=''tc707f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(613,'TC709','Welches der vier im Bild dargestellten Ausgangssignale X<sub>1</sub> bis X<sub>4</sub> liefert ein UND-Gatter, wenn an dessen Eingängen die Signale E<sub>1</sub> und E<sub>2</sub> anliegen?<p><img src=''tc707f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(614,'TC710','In welchem Versorgungsspannungsbereich können CMOS-ICs betrieben werden?',0,1,0,0,'');
INSERT INTO question VALUES(615,'TC711','Was ist ein Operationsverstärker?',0,1,0,0,'');
INSERT INTO question VALUES(616,'TC712','Welche Eigenschaften hat folgende Operationsverstärkerschaltung? In welcher Zeile stimmen alle drei Eigenschaften?<p><img src=''tc712f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(617,'TC713','Wie groß ist der Betrag der Spannungsverstärkung U<sub>A</sub>/U<sub>E</sub> der folgenden Operationsverstärkerschaltung?<p><img src=''tc713f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(618,'TC714','Wie groß ist die Spannungsverstärkung U<sub>A</sub>/U<sub>E</sub> der folgenden Operationsverstärkerschaltung?<p><img src=''tc714f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(619,'TC715','Der Eingangswiderstand der folgenden Operationsverstärkerschaltung soll 1 k&Omega; betragen und es wird eine Spannungsverstärkung von zirka 20 erwünscht. Wie groß muss der Rückkopplungswiderstand R<sub>2</sub> sein?<p><img src=''tc715f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(620,'TC716','Welche der folgenden Operationsverstärkerschaltungen arbeitet als invertierender Spannungsverstärker richtig?',0,1,0,0,'');
INSERT INTO question VALUES(621,'TC717','Welche der folgenden Operationsverstärkerschaltungen arbeitet als nichtinvertierender Spannungsverstärker richtig?',0,1,0,0,'');
INSERT INTO question VALUES(622,'TC718','Worauf beruht die Verstärkerwirkung von Elektronenröhren?',0,1,0,0,'');
INSERT INTO question VALUES(623,'TC719','In folgender Schaltung mit Elektronenröhre wird die Spannung -U<sub>g</sub> am Steuergitter erniedrigt (negativer gemacht). Wie verändert sich der Anodenstrom?<p><img src=''tc719f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(624,'TC720','Berechnen Sie den dezimalen Wert der 8-Bit-Dualzahl 10001110. Die Dezimalzahl lautet',0,1,0,0,'');
INSERT INTO question VALUES(625,'TC721','Wie lautet der dezimale Wert der zweistelligen Hexadezimalzahl 1A? Die Dezimalzahl lautet',0,1,0,0,'');
INSERT INTO question VALUES(626,'TC722','Welche dezimalen Werte haben die Stellen der Dualzahl 111111 von links nach rechts?',0,1,0,0,'');
INSERT INTO question VALUES(627,'TD101','Wie groß ist der Gesamtwiderstand dieser Schaltung, wenn R<sub>1</sub> = 3,3 k&Omega;, R<sub>2</sub> = 4,7 k&Omega; und R<sub>3</sub> = 27 k&Omega; betragen?<p><img src=''td101f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(628,'TD102','Eine Reihenschaltung besteht aus drei Kondensatoren von je 0,03 µF. Wie groß ist die Gesamtkapazität dieser Schaltung?',0,1,0,0,'');
INSERT INTO question VALUES(629,'TD103','Wie groß ist die Gesamtkapazität von drei parallel geschalteten Kondensatoren von 20 nF, 0,03 µF und 15000 pF?',0,1,0,0,'');
INSERT INTO question VALUES(630,'TD104','Wie groß ist die Gesamtinduktivität von drei in Reihe geschalteten Spulen von 2000 nH, 0,03 mH und 1500 µH?',0,1,0,0,'');
INSERT INTO question VALUES(631,'TD105','Wie groß ist die Gesamtinduktivität von drei parallel geschalteten Spulen von 2000 nH, 0,03 mH und 1500 µH?',0,1,0,0,'');
INSERT INTO question VALUES(632,'TD106','Wie groß ist die Gesamtkapazität, wenn drei Kondensatoren C1 = 0,06 nF, C<sub>2</sub> = 40 pF und C3 = 20 pF in Reihe geschaltet werden?',0,1,0,0,'');
INSERT INTO question VALUES(633,'TD107','Wie groß ist der Gesamtwiderstand der dargestellten Schaltung?<p><img src=''td107f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(634,'TD108','Wie teilt sich die Spannung an zwei in Reihe geschalteten Widerständen auf, wenn R<sub>1</sub> = 5 mal so groß ist wie R<sub>2</sub> ?<p><img src=''td108f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(635,'TD109','Wie teilt sich die Spannung an zwei in Reihe geschalteten Widerständen auf, wenn R<sub>1</sub> = 1/6 mal so groß ist wie R<sub>2</sub> ?<p><img src=''td108f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(636,'TD110','Was ist bei der Berechnung von Wechselstromkreisen, die Kombinationen von R, L und C enthalten, zu beachten?',0,1,0,0,'');
INSERT INTO question VALUES(637,'TD111','Wie groß ist die Spannung U, wenn durch R<sub>3</sub> ein Strom von 1 mA fließt und alle Widerstände R<sub>1</sub> bis R<sub>3</sub> je 10 k&Omega; betragen?<p><img src=''td111f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(638,'TD112','Wie groß ist der Strom durch R<sub>3</sub>, wenn U = 15 V und alle Widerstände R<sub>1</sub> bis R<sub>3</sub> je 10 k&Omega; betragen?<p><img src=''td111f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(639,'TD113','Welche Leistung tritt in R<sub>2</sub> auf, wenn U = 15 V und alle Widerstände R<sub>1</sub> bis R<sub>3</sub> je 10 k&Omega; betragen?<p><img src=''td111f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(640,'TD114','Drei gleich große parallel geschaltete Widerstände haben einen Gesamtwiderstand von 1,67 k&Omega;. Welchen Wert hat jeder Einzelwiderstand?',0,1,0,0,'');
INSERT INTO question VALUES(641,'TD115','Welche Belastbarkeit kann die Zusammenschaltung von drei gleich großen Widerständen mit einer Einzelbelastbarkeit von je 1 W erreichen, wenn alle 3 Widerstände entweder parallel oder in Reihe geschaltet werden?',0,1,0,0,'');
INSERT INTO question VALUES(642,'TD116','Welche Gesamtkapazität ergibt sich bei einer Parallelschaltung der Kondensatoren 0,1 µF; 150 nF und 50000 pF?',0,1,0,0,'');
INSERT INTO question VALUES(643,'TD117','Welche Gesamtkapazität ergibt sich bei einer Reihenschaltung der Kondensatoren 0,1 µF; 150 nF und 50000 pF?',0,1,0,0,'');
INSERT INTO question VALUES(644,'TD118','Welche Gesamtkapazität hat diese Schaltung, wenn C<sub>1</sub> = 0,01 µF, C<sub>2</sub> = 5 nF und C<sub>3</sub> = 5000 pF betragen?<p><img src=''td118f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(645,'TD119','Welche Gesamtkapazität hat diese Schaltung, wenn C<sub>1</sub> = 2 µF, C<sub>2</sub> = 1 µF und C<sub>3</sub> = 1 µF betragen?<p><img src=''td118f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(646,'TD120','Wie groß ist die Gesamtkapazität dieser Schaltung, wenn C<sub>1</sub> = 0,1 nF, C<sub>2</sub> = 1,5 nF, C<sub>3</sub> = 220 pF und die Eigenkapazität der Spule 1 pF beträgt?<p><img src=''td120f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(647,'TD121','Wenn R<sub>1</sub> und R<sub>3</sub> je 2 k&Omega; hat und R<sub>2</sub> und R<sub>4</sub> je 200 &Omega; betragen, hat die Schaltung einen Gesamtwiderstand von<p><img src=''td121f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(648,'TD122','In welchem Bereich bewegt sich der Eingangswiderstand der folgenden Schaltung, wenn R alle Werte von 0 bis unendlich durchläuft?<p><img src=''td122fj.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(649,'TD123','Wie groß ist der Gesamtwiderstand dieser Schaltung, wenn R<sub>1</sub> = 30 k&Omega;, R<sub>2</sub> = 15 k&Omega;, R<sub>3</sub> = 30 k&Omega; und R<sub>4</sub> = 2,7 k&Omega; betragen?<p><img src=''td123f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(650,'TD124','Wie groß ist der Gesamtwiderstand dieser Schaltung, wenn R<sub>1</sub> = 12 k&Omega;, R<sub>2</sub> = 12 k&Omega;, R<sub>3</sub> = 6 k&Omega; und R<sub>4</sub> = 1,5 k &Omega;betragen?<p><img src=''td123f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(651,'TD201','Der Impedanzfrequenzgang in der Abbildung zeigt die Kennlinie<p><img src=''td201f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(652,'TD202','Der im folgenden Bild dargestellte Impedanzfrequenzgang ist typisch für<p><img src=''td202f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(653,'TD203','Was ist im Resonanzfall bei der Reihenschaltung einer Induktivität mit einer Kapazität erfüllt?',0,1,0,0,'');
INSERT INTO question VALUES(654,'TD204','Welcher Schwingkreis passt zu dem neben der jeweiligen Schaltung dargestellten Verlauf des Scheinwiderstandes?',0,1,0,0,'');
INSERT INTO question VALUES(655,'TD205','Kann die Wicklung eines Übertragers zusammen mit einem Kondensator als Schwingkreis dienen?',0,1,0,0,'');
INSERT INTO question VALUES(656,'TD206','Wie ändert sich die Resonanzfrequenz eines Schwingkreises, wenn 1. die Spule mehr Windungen erhält,<br> 2. die Länge der Spule durch Zusammenschieben der Drahtwicklung verringert wird,<br> 3. ein Kupferkern in das Innere der Spule gebracht wird?',0,1,0,0,'');
INSERT INTO question VALUES(657,'TD207','Wie groß ist die Resonanzfrequenz dieser Schaltung, wenn C<sub>1</sub> = 0,1 nF, C<sub>2</sub> = 1,5 nF, C<sub>3</sub> = 220 pF und L = 1 mH beträgt?<p><img src=''td207f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(658,'TD208','Welche Resonanzfrequenz f<sub>res</sub> hat die Reihenschaltung einer Spule von 100 µH mit einem Kondensator von 0,01 µF und einem Widerstand von 100 &Omega;?',0,1,0,0,'');
INSERT INTO question VALUES(659,'TD209','Welche Resonanzfrequenz f<sub>res</sub> hat die Parallelschaltung einer Spule von 2 µH mit einem Kondensator von 60 pF und einem Widerstand von 10 k&Omega; ?',0,1,0,0,'');
INSERT INTO question VALUES(660,'TD210','Wie groß ist die Resonanzfrequenz dieser Schaltung, wenn C = 6,8 pF, R = 10 &Omega; und L = 1 µH beträgt?<p><img src=''td210f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(661,'TD211','Wie groß ist die Resonanzfrequenz dieser Schaltung, wenn C = 1 nF, R = 0,1 k&Omega; und L = 10 µH beträgt?<p><img src=''td210f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(662,'TD212','Bei Resonanz ist die Impedanz dieser Schaltung<p><img src=''td210f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(663,'TD213','Welche Grenzfrequenz ergibt sich bei einem Tiefpass mit einem Widerstand von 10 k&Omega; und einem Kondensator von 50 nF?<p><img src=''td213f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(664,'TD214','Welchen Gütefaktor Q hat die Reihenschaltung einer Spule von 100 µH mit einem Kondensator von 0,01 µF und einem Widerstand von 10 &Omega; ?',0,1,0,0,'');
INSERT INTO question VALUES(665,'TD215','Welchen Gütefaktor Q hat die Parallelschaltung einer Spule von 2 µH mit einem Kondensator von 60 pF und einem Widerstand von 1 k&Omega;?',0,1,0,0,'');
INSERT INTO question VALUES(666,'TD216','Welche Bandbreite B hat die Reihenschaltung einer Spule von 100 µH mit einem Kondensator von 0,01 µF und einem Widerstand von 10 &Omega;?',0,1,0,0,'');
INSERT INTO question VALUES(667,'TD217','Welche Bandbreite B hat die Parallelschaltung einer Spule von 2 µH mit einem Kondensator von 60 pF und einem Widerstand von 1 k&Omega;?',0,1,0,0,'');
INSERT INTO question VALUES(668,'TD218','Wie ergibt sich die Bandbreite B eines Schwingkreises aus der Resonanzkurve?',0,1,0,0,'');
INSERT INTO question VALUES(669,'TD219','Was stellt diese Schaltung dar?<p><img src=''td219f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(670,'TD220','Was stellt diese Schaltung dar?<p><img src=''td220f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(671,'TD221','Was stellt diese Schaltung dar?<p><img src=''td221f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(672,'TD222','Was stellt diese Schaltung dar?<p><img src=''td222f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(673,'TD223','Bei dem dargestellten Filter handelt es sich um ein<p><img src=''td223f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(674,'TD224','Welche der nachfolgenden Beschreibungen trifft auf diese Schaltung zu und wie nennt man sie?<p><img src=''td224f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(675,'TD225','Im folgenden Bild ist ein Filter dargestellt. Es handelt sich um ein<p><img src=''td225f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(676,'TD226','Welche Schaltung stellt ein Hochpassfilter dar?',0,1,0,0,'');
INSERT INTO question VALUES(677,'TD227','Für HF-Filter sollten vorzugsweise',0,1,0,0,'');
INSERT INTO question VALUES(678,'TD228','Welche Kopplung eines Bandfilters wird "kritische Kopplung" genannt?',0,1,0,0,'');
INSERT INTO question VALUES(679,'TD229','Das folgende Bild zeigt ein induktiv gekoppeltes Bandfilter und vier seiner möglichen Übertragungskurven (a bis d). Welche der folgenden Aussagen ist richtig?<p><img src=''td229f1.png''></p><p><img src=''td229f2.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(680,'TD230','Das folgende Bild zeigt ein typisches ZF-Filter und vier seiner möglichen Übertragungskurven (a bis d). Welche Kurve ergibt sich bei kritischer Kopplung und welche bei überkritischer Kopplung?<p><img src=''td229f1.png''></p><p><img src=''td229f2.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(681,'TD231','Ein Quarzfilter mit einer der 3-dB-Bandbreite von 2,3 kHz eignet sich besonders zur Verwendung in einem Sendeempfänger für',0,1,0,0,'');
INSERT INTO question VALUES(682,'TD232','Ein Quarzfilter mit einer der 3-dB-Bandbreite von 6 kHz eignet sich besonders zur Verwendung in einem Empfänger für',0,1,0,0,'');
INSERT INTO question VALUES(683,'TD233','Ein Quarzfilter mit einer der 3-dB-Bandbreite von 12 kHz eignet sich besonders zur Verwendung in einem Sendeempfänger für',0,1,0,0,'');
INSERT INTO question VALUES(684,'TD234','Ein Quarzfilter mit einer der 3-dB-Bandbreite von 500 Hz eignet sich besonders zur Verwendung in einem Sendeempfänger für',0,1,0,0,'');
INSERT INTO question VALUES(685,'TD301','Welche Form hat die Ausgangsspannung der dargestellten Schaltung?<p><img src=''td301f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(686,'TD302','Welche Ausgangsspannung wird erzeugt, wenn an die dargestellte Schaltung eine Wechselspannung angelegt wird?<p><img src=''td302f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(687,'TD303','Kann für den Kondensator der folgenden Schaltung ein Elektrolytkondensator verwendet werden?<p><img src=''td302f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(688,'TD304','Falls nachgewiesen wird, dass Störungen über das Stromversorgungsnetz in Geräte eindringen, ist wahrscheinlich',0,1,0,0,'');
INSERT INTO question VALUES(689,'TD305','Wie groß ist die Spannung am Siebkondensator Cs im Leerlauf, wenn die primäre Trafospannung 230 Volt und das Windungsverhältnis 8:1 beträgt? Die Spannung beträgt etwa<p><img src=''td305f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(690,'TD306','Welche Aussage enthält die richtige Beschreibung der Funktionsweise der Regelung in diesem Netzteil, wenn die Ausgangsspannung bei Belastung absinkt?<p><img src=''td306f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(691,'TD307','Eine Hochspannungs-Stromversorgung ist mit mehreren in Reihe geschalteten Gleichrichterdioden ausgestattet. Welches Bauelement sollte zu jeder Diode wie zugeschaltet sein?',0,1,0,0,'');
INSERT INTO question VALUES(692,'TD308','Für welchen Zweck werden Z-Dioden primär eingesetzt?',0,1,0,0,'');
INSERT INTO question VALUES(693,'TD309','Welche der folgenden Auswahlantworten enthält die richtige Diodenanordnung und Polarität eines Brückengleichrichters?',0,1,0,0,'');
INSERT INTO question VALUES(694,'TD310','Welche Beziehung muss zwischen der Eingangspannung und der Ausgangsspannung der folgenden Schaltung bestehen, damit der Spannungsregler Q1 seine Funktion erfüllen kann?<p><img src=''td310f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(695,'TD311','Welchen Verlauf hat die Spannung U ?<p><img src=''td311f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(696,'TD312','Die Ausgangsspannung zwischen A und B in der Schaltung beträgt ungefähr<p><img src=''td312f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(697,'TD313','Bei einem Transformationsverhältnis von 5:1 sollte die Spannungsfestigkeit der Diode (max. Spannung plus 10 % Sicherheitsaufschlag) in dieser Schaltung nicht weniger als<p><img src=''td313f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(698,'TD314','Bei einem Transformationsverhältnis von 8:1 sollte die Spannungsfestigkeit der Diode (max. Spannung plus 10 % Sicherheitsaufschlag) in dieser Schaltung nicht weniger als<p><img src=''td313f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(699,'TD315','Welche Gleichrichterschaltung erzeugt eine Vollweg-Gleichrichtung mit der angezeigten Polarität?',0,1,0,0,'');
INSERT INTO question VALUES(700,'TD316','Bei der Verbindung der Stromversorgung mit HF-Leistungsverstärkern ist',0,1,0,0,'');
INSERT INTO question VALUES(701,'TD317','Welche Funktion hat der Block E bei einem Schaltnetzteil?<p><img src=''td317f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(702,'TD318','Welches ist der Hauptnachteil eines Schaltnetzteils gegenüber einem Netzteil mit Längsregelung?<p><img src=''td317f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(703,'TD319','Welche Ausgangsspannung entsteht mit folgender Spannungsregler-Schaltung?<p><img src=''td319f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(704,'TD320','Im folgenden Bild ist die Spannung am Ausgang einer Stromversorgung dargestellt. Die Restwelligkeit und die Brummfrequenz betragen<p><img src=''td320f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(705,'TD321','Welche Grundfrequenz hat die Ausgangsspannung eines Vollweggleichrichters, der an eine 50-Hz-Versorgung angeschlossen ist?',0,1,0,0,'');
INSERT INTO question VALUES(706,'TD322','Welche der dargestellten Schaltungen könnte in den Netzeingang eines Geräts eingebaut werden, um HF-Rückfluss in das Stromversorgungsnetz zu verringern?',0,1,0,0,'');
INSERT INTO question VALUES(707,'TD401','Bei dieser Schaltung handelt es sich um<p><img src=''td401f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(708,'TD402','Welche Funktion haben die Widerstände R<sub>1</sub> und R<sub>2</sub> in der folgenden Schaltung? Sie dienen zur<p><img src=''td402f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(709,'TD403','Welche Funktion hat der Kondensator C<sub>1</sub> in der folgenden Schaltung? Er dient zur<p><img src=''td403f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(710,'TD404','Wie verhält sich die Spannungs-Verstärkung bei der folgenden Schaltung, wenn der Kondensator C<sub>1</sub> entfernt wird?<p><img src=''td403f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(711,'TD405','Welche Funktion haben die Kondensatoren C<sub>1</sub> und C<sub>2</sub> in der folgenden Schaltung? Sie dienen zur<p><img src=''td405f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(712,'TD406','Was lässt sich über die Wechselspannungsverstärkung v<sub>U</sub> und die Phasenverschiebung &phi; zwischen Ausgangs- und Eingangsspannung dieser Schaltung aussagen?<p><img src=''td401f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(713,'TD407','Was lässt sich über den Wechselstromeingangswiderstand r<sub>e</sub> und den Wechselstromausgangswiderstand r<sub>a</sub> dieser Vorverstärkerschaltung aussagen?<p><img src=''td401f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(714,'TD408','Bei dieser Schaltung handelt es sich um<p><img src=''td408f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(715,'TD409','Was lässt sich über die Wechselspannungsverstärkung v<sub>U</sub> und die Phasenverschiebung &phi; zwischen Ausgangs- und Eingangsspannung dieser Schaltung aussagen?<p><img src=''td408f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(716,'TD410','In welchem Bereich liegt der Wechselstrom-Eingangswiderstand eines Emitterfolgers?',0,1,0,0,'');
INSERT INTO question VALUES(717,'TD411','In welchem Bereich liegt der Wechselstrom-Ausgangswiderstand eines Emitterfolgers?',0,1,0,0,'');
INSERT INTO question VALUES(718,'TD412','Die Ausgangsimpedanz dieser Schaltung ist<p><img src=''td408f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(719,'TD413','Diese Schaltung kann unter anderem als<p><img src=''td408f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(720,'TD414','Das folgende Oszillogramm zeigt die Ausgangsspannung eines Verstärkers, an dessen Eingang eine rein sinusförmige Wechselspannung anliegt. Welche Harmonische wird von dem Verstärker erzeugt?<p><img src=''tb705f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(721,'TD415','Das folgende Oszillogramm zeigt die Ausgangsspannung eines Verstärkers, an dessen Eingang eine rein sinusförmige Wechselspannung anliegt. Welche Harmonische wird von dem Verstärker erzeugt?<p><img src=''tb706f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(722,'TD416','Ein NF-Verstärker hebt die Eingangsspannung von 1 mV auf 4 mV Ausgangsspannung an. Eingangs- und Ausgangswiderstand sind gleich. Wie groß ist die Spannungsverstärkung des Verstärkers?',0,1,0,0,'');
INSERT INTO question VALUES(723,'TD417','Ein Leistungsverstärker hebt die Eingangsleistung von 2,5 Watt auf 38 Watt Ausgangsleistung an. Dem entspricht eine Leistungsverstärkung von',0,1,0,0,'');
INSERT INTO question VALUES(724,'TD418','Ein HF-Leistungsverstärker hat eine Verstärkung von 16 dB. Welche HF-Ausgangsleistung ist zu erwarten, wenn der Verstärker mit 1 W HF-Eingangsleistung angesteuert wird?',0,1,0,0,'');
INSERT INTO question VALUES(725,'TD419','Das folgende Bild zeigt eine idealisierte Steuerkennlinie eines Transistors mit vier eingezeichneten Arbeitspunkten P<sub>1</sub> bis P<sub>4</sub>. Welcher Arbeitspunkt ist welcher Verstärkerbetriebsart zuzuordnen?<p><img src=''td419f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(726,'TD420','Welche Merkmale hat ein HF-Leistungsverstärker im A-Betrieb?',0,1,0,0,'');
INSERT INTO question VALUES(727,'TD421','Welche Merkmale hat ein HF-Leistungsverstärker im B-Betrieb?',0,1,0,0,'');
INSERT INTO question VALUES(728,'TD422','Welche Merkmale hat ein HF-Leistungsverstärker im C-Betrieb?',0,1,0,0,'');
INSERT INTO question VALUES(729,'TD423','Ein HF-Leistungsverstärker im A-Betrieb wird mit einer Anodenspannung von 800 V und einem Anodenstrom von 130 mA betrieben. Wie hoch ist die zu erwartende Ausgangsleistung des Verstärkers?',0,1,0,0,'');
INSERT INTO question VALUES(730,'TD424','Ein HF-Leistungsverstärker im C-Betrieb wird mit einer Anodenspannung von 800 V und einem Anodenstrom von 130 mA betrieben. Wie hoch ist die zu erwartende Ausgangsleistung des Verstärkers?',0,1,0,0,'');
INSERT INTO question VALUES(731,'TD425','In welcher Größenordnung liegt der Ruhestrom eines HF-Leistungsverstärkers im C-Betrieb?',0,1,0,0,'');
INSERT INTO question VALUES(732,'TD426','Eine Treiberstufe eines HF-Verstärkers braucht am Eingang eine Leistung von 1 Watt um am Ausgang 10 Watt an die Endstufe abgeben zu können. Sie benötigt dazu eine Gleichstromleistung von 25 Watt. Wie hoch ist der Wirkungsgrad der Treiberstufe?',0,1,0,0,'');
INSERT INTO question VALUES(733,'TD427','Wenn ein linearer HF-Leistungsverstärker im AB-Betrieb durch ein SSB-Signal übersteuert wird, führt dies zu',0,1,0,0,'');
INSERT INTO question VALUES(734,'TD428','Welche Baugruppe sollte für die Begrenzung der NF-Bandbreite eines Mikrofonverstärkers verwendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(735,'TD429','Was ist die Ursache für Eigenschwingungen eines Verstärkers?',0,1,0,0,'');
INSERT INTO question VALUES(736,'TD430','Welche Art von Schaltung wird im folgenden Bild dargestellt? Es handelt sich um einen<p><img src=''td430f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(737,'TD431','An den Eingang dieser Schaltung wird das folgende Signal gelegt. Welches ist ein mögliches Ausgangssignal U<sub>A</sub>?<p><img src=''td431f1.png''></p><p><img src=''td431f2.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(738,'TD432','An den Eingang dieser Schaltung wird das folgende Signal gelegt. Welches ist ein mögliches Ausgangssignal U<sub>A</sub>?<p><img src=''td432f1.png''></p><p><img src=''td431f2.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(739,'TD501','Bei dieser Schaltung handelt es sich um einen<p><img src=''td501f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(740,'TD502','Bei dieser Schaltung ist der mit X bezeichnete Anschluss<p><img src=''td502f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(741,'TD503','Am ZF-Eingang der folgenden Schaltung liegt ein sinusförmig moduliertes AM-Signal. Welches der folgenden Signale zeigt sich dabei an dem mit X bezeichneten Punkt der Schaltung?<p><img src=''td503f1.jpg''></p><p><img src=''td503f2.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(742,'TD504','Am ZF-Eingang der folgenden Schaltung liegt ein sinusförmig moduliertes AM-Signal. Welches der folgenden Signale zeigt sich dabei an dem mit X bezeichneten Punkt der Schaltung?<p><img src=''td504f1.png''></p><p><img src=''td503f2.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(743,'TD505','Bei dieser Schaltung handelt es sich um einen<p><img src=''td505f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(744,'TD506','Bei dieser Schaltung handelt es sich um einen<p><img src=''td506f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(745,'TD507','Bei dieser Schaltung handelt es sich um einen<p><img src=''td507f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(746,'TD508','Bei dieser Schaltung handelt es sich um einen<p><img src=''td508f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(747,'TD509','Bei dieser Schaltung handelt es sich um einen<p><img src=''td509f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(748,'TD510','Bei dieser Schaltung handelt es sich um einen<p><img src=''td510f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(749,'TD511','Bei dieser Schaltung handelt es sich um einen<p><img src=''td511f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(750,'TD512','Durch Addition eines Nutz- oder Störsignals zur Versorgungsspannung der Senderendstufe wird',0,1,0,0,'');
INSERT INTO question VALUES(751,'TD513','Bei dieser Schaltung handelt es sich um einen Modulator zur Erzeugung von<p><img src=''td513f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(752,'TD514','Bei dieser Schaltung handelt es sich um einen Modulator zur Erzeugung von<p><img src=''td514f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(753,'TD515','Bei dieser Schaltung handelt es sich um einen Modulator zur Erzeugung von<p><img src=''td515f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(754,'TD601','Bei dieser Schaltung handelt es sich um<p><img src=''td601f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(755,'TD602','Bei dieser Schaltung handelt es sich um<p><img src=''td602f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(756,'TD603','Bei dieser Schaltung handelt es sich um<p><img src=''td603f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(757,'TD604','Bei dieser Oszillatorschaltung handelt es sich um einen kapazitiv rückgekoppelten Quarz-Oszillator in<p><img src=''td604f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(758,'TD605','Bei dieser Oszillatorschaltung handelt es sich um einen kapazitiv rückgekoppelten Quarz-Oszillator in<p><img src=''td605f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(759,'TD606','Ist die folgende Schaltung als Oberton-Oszillator geeignet?<p><img src=''td606f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(760,'TD607','Was ist ein VCO und wie funktioniert er?',0,1,0,0,'');
INSERT INTO question VALUES(761,'TD608','Für die Messung der Oszillatorfrequenz sollte der Tastkopf hier vorzugsweise am Punkt<p><img src=''td608f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(762,'TD609','Welche Bedingungen müssen zur Erzeugung ungedämpfter Schwingungen in Oszillatoren erfüllt sein?',0,1,0,0,'');
INSERT INTO question VALUES(763,'TD610','Die Bezeichnungen "Colpitts" und "Hartley" stehen für',0,1,0,0,'');
INSERT INTO question VALUES(764,'TD611','"Chirp" ist eine Form der Frequenzinstabilität. Es wird hervorgerufen durch',0,1,0,0,'');
INSERT INTO question VALUES(765,'TD612','Wie verhält sich die Frequenz eines Oszillators bei Temperaturanstieg, wenn die Kapazität des Schwingkreiskondensators mit dem Temperaturanstieg ebenfalls ansteigt?',0,1,0,0,'');
INSERT INTO question VALUES(766,'TD613','Wie verhält sich die Frequenz eines Oszillators bei Temperaturanstieg, wenn die Kapazität des Schwingkreiskondensators mit dem Temperaturanstieg geringer wird?',0,1,0,0,'');
INSERT INTO question VALUES(767,'TD614','Im VFO eines Senders steigt die Induktivität der Spule mit der Temperatur. Der Kondensator bleibt sehr stabil. Welche Auswirkungen hat dies bei steigender Temperatur?',0,1,0,0,'');
INSERT INTO question VALUES(768,'TD615','Der Vorteil von Quarzoszillatoren gegenüber LC-Oszillatoren liegt darin, dass sie',0,1,0,0,'');
INSERT INTO question VALUES(769,'TD701','Welche der nachfolgenden Aussagen ist richtig, wenn die im Bild dargestellte Regelschleife in stabilem Zustand ist?<p><img src=''td701f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(770,'TD702','Ein Frequenzsynthesizer soll eine einstellbare Frequenz mit hoher Frequenzgenauigkeit erzeugen. Die Genauigkeit und Stabilität der Ausgangsfrequenz eines Frequenzsynthesizers wird hauptsächlich bestimmt von',0,1,0,0,'');
INSERT INTO question VALUES(771,'TD703','Welchen Einfluss kann der Tiefpass in der Phasenregelschleife (PLL) auf das vom spannungsgesteuerten Oszillator (VCO) erzeugte Ausgangssignal haben?',0,1,0,0,'');
INSERT INTO question VALUES(772,'TD704','Welche Baugruppen muss eine Phasenregelschleife (PLL) mindestens enthalten?',0,1,0,0,'');
INSERT INTO question VALUES(773,'TD705','Die Ausgangsfrequenz eines VCO ändert sich von 16,5 MHz auf 16,75 MHz, wenn sich die Regelspannung von 5,1 V auf 7,6 V ändert. Welche Regelempfindlichkeit hat der VCO?',0,1,0,0,'');
INSERT INTO question VALUES(774,'TD706','Die Frequenz an Punkt A beträgt 12,5 kHz. Es sollen Ausgangsfrequenzen im Bereich von 12,000 MHz bis 14,000 MHz erzeugt werden. In welchem Bereich bewegt sich dabei das Teilerverhältnis n?<p><img src=''td701f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(775,'TD707','Wie groß muss bei der folgenden Schaltung die Frequenz an Punkt A sein, wenn bei der versechsfachten Ausgangsfrequenz ein Kanalabstand von 25 kHz benötigt wird?<p><img src=''td701f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(776,'TE101','Wie unterscheidet sich J3E von A3E in Bezug auf die benötigte Bandbreite?',0,1,0,0,'');
INSERT INTO question VALUES(777,'TE102','Wodurch werden Tastklicks bei einem CW-Sender hervorgerufen?',0,1,0,0,'');
INSERT INTO question VALUES(778,'TE103','Auf welcher Frequenz sollte der Schwebungston eines BFO für den Empfang von CW-Signalen ungefähr liegen?',0,1,0,0,'');
INSERT INTO question VALUES(779,'TE104','Durch Modulation',0,1,0,0,'');
INSERT INTO question VALUES(780,'TE105','Welches Bild stellt die Übermodulation eines AM-Signals dar?',0,1,0,0,'');
INSERT INTO question VALUES(781,'TE106','Die Übermodulation eines SSB-Signals führt wahrscheinlich zu',0,1,0,0,'');
INSERT INTO question VALUES(782,'TE107','Wodurch wird Kreuzmodulation verursacht?',0,1,0,0,'');
INSERT INTO question VALUES(783,'TE108','Um unnötige Seitenband-Splatter zu vermeiden, sollte der Modulationsgrad eines AM-Signals unter',0,1,0,0,'');
INSERT INTO question VALUES(784,'TE109','Welche Sendeverfahren weisen das größte Störpotential in Bezug auf NF-Verstärkersysteme auf?',0,1,0,0,'');
INSERT INTO question VALUES(785,'TE110','In welcher Abbildung ist AM mit einem Modulationsgrad von 100 % dargestellt?',0,1,0,0,'');
INSERT INTO question VALUES(786,'TE111','Das folgende Oszillogramm zeigt ein AM-Signal. Der Modulationsgrad beträgt hier ca.<p><img src=''te111f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(787,'TE112','Das folgende Oszillogramm zeigt ein AM-Signal. Der Modulationsgrad beträgt hier ca.<p><img src=''te112f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(788,'TE113','Das folgende Oszillogramm zeigt<p><img src=''te113f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(789,'TE201','Welche nachfolgende Sendeart hat die geringste Störanfälligkeit bei Funkanlagen in Kraftfahrzeugen?',0,1,0,0,'');
INSERT INTO question VALUES(790,'TE202','Was gilt in etwa für die Bandbreite B eines FM-Signals, wenn der Modulationsindex m &lt; 0,5 wird? (f<sub>mod</sub> sei die Modulationsfrequenz und &Delta;F der Hub.)',0,1,0,0,'');
INSERT INTO question VALUES(791,'TE203','Was gilt in etwa für die Bandbreite B eines FM-Signals, wenn der Modulationsindex m &gt; 2 wird? (f<sub>mod</sub> sei die Modulationsfrequenz und &Delta;F der Hub.)',0,1,0,0,'');
INSERT INTO question VALUES(792,'TE204','Wodurch wird bei Frequenzmodulation die Lautstärke-Information übertragen?',0,1,0,0,'');
INSERT INTO question VALUES(793,'TE205','Theoretisch arbeitet die Frequenzmodulation mit',0,1,0,0,'');
INSERT INTO question VALUES(794,'TE206','FM hat gegenüber SSB den Vorteil der',0,1,0,0,'');
INSERT INTO question VALUES(795,'TE207','Ein zu großer Hub eines FM-Senders führt dazu,',0,1,0,0,'');
INSERT INTO question VALUES(796,'TE208','Die Änderung der Kapazität einer über einen Quarzoszillator angeschalteten Varicap-Diode stellt eine Möglichkeit dar',0,1,0,0,'');
INSERT INTO question VALUES(797,'TE209','Ein 2-m-Sender erzeugt seine Ausgangsfrequenz durch Vervielfachung der Oszillatorfrequenz um den Faktor 12. Der Hub der Ausgangsfrequenz beträgt 5 kHz. Wie groß ist der Hub der Oszillatorfrequenz?',0,1,0,0,'');
INSERT INTO question VALUES(798,'TE210','Eine FM-Telefonie-Aussendung mit zu großem Hub führt möglicherweise',0,1,0,0,'');
INSERT INTO question VALUES(799,'TE211','Was bewirkt die Erhöhung des Hubes eines frequenzmodulierten Senders?',0,1,0,0,'');
INSERT INTO question VALUES(800,'TE212','Größerer Frequenzhub führt bei einem FM-Sender zu',0,1,0,0,'');
INSERT INTO question VALUES(801,'TE213','Bei der FM-Übertragung werden Preemphasis und Deemphasis eingesetzt,',0,1,0,0,'');
INSERT INTO question VALUES(802,'TE214','Am Spektrumanalysator zeigt ein FM-Sender bei der Modulation mit einem 1-kHz-Ton die erste Trägernullstelle. Wie groß ist der Spitzenhub?',0,1,0,0,'');
INSERT INTO question VALUES(803,'TE215','Wenn ein FM-Sender mit einem Modulationsindex m = 2,4 betrieben wird,',0,1,0,0,'');
INSERT INTO question VALUES(804,'TE216','Wie wird die Empfindlichkeit eines FM-Modulators angegeben?',0,1,0,0,'');
INSERT INTO question VALUES(805,'TE217','Der typische Hub eines NBFM-Signals (Schmalband-FM) im Amateurfunk beträgt',0,1,0,0,'');
INSERT INTO question VALUES(806,'TE301','Wie wird ein Sender mit einem 1200-Bd-Packet-Radio-Signal moduliert? Ein weit verbreitetes Verfahren ist, das Signal',0,1,0,0,'');
INSERT INTO question VALUES(807,'TE302','Welche NF-Bandbreite beansprucht ein 1200-Bd-Packet-Radio-AFSK-Signal?',0,1,0,0,'');
INSERT INTO question VALUES(808,'TE303','Welche NF-Zwischenträgerfrequenzen werden in der Regel in Packet-Radio bei 1200 Bd benutzt?',0,1,0,0,'');
INSERT INTO question VALUES(809,'TE304','Wie erfolgt die Datenübertragung bei Packet-Radio?',0,1,0,0,'');
INSERT INTO question VALUES(810,'TE305','Wie erfolgt die synchrone Datenübertragung?',0,1,0,0,'');
INSERT INTO question VALUES(811,'TE306','Welche HF-Bandbreite beansprucht ein 1200-Baud-Packet-Radio-AFSK-Signal?',0,1,0,0,'');
INSERT INTO question VALUES(812,'TE307','Welche der nachfolgend genannten Einrichtungen würden Sie an einen Terminal-Node-Controller (TNC) anschließen um am Packet-Radio-Betrieb teilzunehmen?',0,1,0,0,'');
INSERT INTO question VALUES(813,'TE308','Beim Aussenden von Daten in der Betriebsart Packet-Radio muss nach dem Hochtasten des Senders eine gewisse Zeitspanne gewartet werden, bevor mit der Datenübertragung begonnen werden kann. Wie heißt der Parameter mit dem diese Zeitspanne eingestellt wird?',0,1,0,0,'');
INSERT INTO question VALUES(814,'TE309','Beim Aussenden von Daten in der Betriebsart Packet-Radio muss nach dem Hochtasten des Senders eine gewisse Zeitspanne gewartet werden, bevor mit der Datenübertragung begonnen werden kann. Diese Zeitspanne hängt ab',0,1,0,0,'');
INSERT INTO question VALUES(815,'TE310','Welche Anforderungen muss ein FM-Funkgerät erfüllen, damit es für die Übertragung von Packet-Radio mit 9600 Baud geeignet ist?',0,1,0,0,'');
INSERT INTO question VALUES(816,'TE311','Welche Punkte in einem FM-Transceiver sind für die Zuführung bzw. das Abgreifen eines 9600-Baud-FSK-Signals geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(817,'TE312','Was versteht man unter "DAMA" bei der Betriebsart Packet-Radio?',0,1,0,0,'');
INSERT INTO question VALUES(818,'TE313','Welche HF-Bandbreite beansprucht ein 9600-Baud-FM-Packet-Radio-Signal?',0,1,0,0,'');
INSERT INTO question VALUES(819,'TE314','Eine Packet-Radio-Mailbox ist',0,1,0,0,'');
INSERT INTO question VALUES(820,'TE315','Was versteht man bei Packet Radio unter einem TNC (Terminal Network Controller)? Ein TNC',0,1,0,0,'');
INSERT INTO question VALUES(821,'TE316','Warum können auf einer Frequenz mehrere Stationen gleichzeitig Verbindungen in der Betriebsart Packet Radio haben?',0,1,0,0,'');
INSERT INTO question VALUES(822,'TE317','Was versteht man bei Packet-Radio unter dem Begriff "TX-Delay"?',0,1,0,0,'');
INSERT INTO question VALUES(823,'TE318','Welches der genannten Übertragungsverfahren passt die Übertragungsgeschwindigkeit automatisch den Kanaleigenschaften an?',0,1,0,0,'');
INSERT INTO question VALUES(824,'TE319','Bei welchem Übertragungsverfahren für Digitalsignale wird ein niederfrequenter Zwischenträger vom Digitalsignal in der Frequenz umgetastet und wie wird das Sendesignal dem Sender zugeführt?',0,1,0,0,'');
INSERT INTO question VALUES(825,'TE320','Der Baudot-Code ist ein',0,1,0,0,'');
INSERT INTO question VALUES(826,'TE321','Was ist ein wesentlicher Unterschied zwischen den Betriebsarten RTTY und PACTOR?',0,1,0,0,'');
INSERT INTO question VALUES(827,'TE322','Um RTTY-Betrieb durchzuführen benötigt man außer einem Transceiver beispielsweise',0,1,0,0,'');
INSERT INTO question VALUES(828,'TE323','Welches der folgenden digitalen Übertragungsverfahren hat die geringste Bandbreite?',0,1,0,0,'');
INSERT INTO question VALUES(829,'TE324','Pactor ist ein digitales Übertragungsverfahren',0,1,0,0,'');
INSERT INTO question VALUES(830,'TE325','Die theoretische Bandbreite bei PSK31 beträgt',0,1,0,0,'');
INSERT INTO question VALUES(831,'TE326','Wie nennt man eine Darstellung der Empfangssignale auf einem Computer, wobei als horizontale Achse die Frequenz, als vertikale Achse die Zeit und als Stärke des Signals die Breite einer Linie dargestellt wird?',0,1,0,0,'');
INSERT INTO question VALUES(832,'TE327','Was ist ein Unterschied zwischen den Betriebsarten ATV und SSTV?',0,1,0,0,'');
INSERT INTO question VALUES(833,'TE328','Welche Aussage über die Übertragungsarten ist richtig?',0,1,0,0,'');
INSERT INTO question VALUES(834,'TE329','Wie heißt die Übertragungsart mit einem Übertragungskanal, bei der durch Umschaltung abwechselnd in beide Richtungen gesendet werden kann?',0,1,0,0,'');
INSERT INTO question VALUES(835,'TE330','Wie viel verschiedene Zeichen kann man mit 5 Bit (z.B. Baudot-Code bei RTTY) erzeugen?',0,1,0,0,'');
INSERT INTO question VALUES(836,'TF101','Welche Aussage ist für einen Doppelsuper richtig?',0,1,0,0,'');
INSERT INTO question VALUES(837,'TF102','Die Empfindlichkeit eines Empfängers bezieht sich auf die',0,1,0,0,'');
INSERT INTO question VALUES(838,'TF103','Eine hohe erste Zwischenfrequenz',0,1,0,0,'');
INSERT INTO question VALUES(839,'TF104','Wie ist bei modernen KW-Transceivern der Frequenzplan eines z.B. von 100 kHz bis 30 MHz durchstimmbaren Empfängers?',0,1,0,0,'');
INSERT INTO question VALUES(840,'TF105','Wo wird die Bandbreite eines durchstimmbaren Empfängers festgelegt?',0,1,0,0,'');
INSERT INTO question VALUES(841,'TF106','Wie groß sollte die Bandbreite des Filters für die 1. ZF in einem durchstimmbaren Empfänger sein?',0,1,0,0,'');
INSERT INTO question VALUES(842,'TF107','Womit kann die Frequenzanzeige eines durchstimmbaren Empfängers möglichst genau geprüft werden?',0,1,0,0,'');
INSERT INTO question VALUES(843,'TF201','In dieser Schaltung können bei einer Empfangsfrequenz von 145,6 MHz und einer Oszillatorfrequenz von 134,9 MHz Spiegelfrequenzstörungen bei<p><img src=''tf201f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(844,'TF202','In dieser Schaltung können bei einer Empfangsfrequenz von 28,3 MHz und einer Oszillatorfrequenz von 39 MHz Spiegelfrequenzstörungen bei<p><img src=''tf202f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(845,'TF203','Folgende Schaltung stellt einen Doppelsuper dar. Welche Funktion haben die drei mit X, Y und Z gekennzeichneten Blöcke?<p><img src=''tf203f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(846,'TF204','Folgende Schaltung stellt einen Doppelsuper dar. Welche Funktion haben die drei mit X, Y und Z gekennzeichneten Blöcke?<p><img src=''tf204f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(847,'TF205','Ein Doppelsuper hat eine erste ZF von 10,7 MHz und ein zweite ZF von 460 kHz. Die Empfangsfrequenz soll 28 MHz sein. Welche Frequenz ist für den VFO und für den CO erforderlich, wenn die Oszillatoren oberhalb des Nutzsignals schwingen sollen?<p><img src=''tf205f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(848,'TF206','Welche beiden Frequenzen muss der Quarzoszillator erzeugen, damit im 70-cm-Bereich die oberen 4 MHz durch diesen Konverter empfangen werden können? Die Oszillatorfrequenz f<sub>osz</sub> soll jeweils unterhalb des Nutzsignals liegen.<p><img src=''tf206f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(849,'TF207','Welche beiden Frequenzen muss der Quarzoszillator erzeugen, damit im 70-cm-Bereich die unteren 4 MHz durch diesen Konverter empfangen werden können? Die Oszillatorfrequenz f<sub>osz</sub> soll jeweils unterhalb des Nutzsignals liegen.<p><img src=''tf207f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(850,'TF208','Diese Schaltung stellt<p><img src=''tf208f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(851,'TF209','Welchen Vorteil haben Kurzwellen-Empfänger mit einer sehr hohen ersten ZF-Frequenz (z.B. 50 MHz)?<p><img src=''tf209f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(852,'TF210','Welchen Frequenzbereich kann der VFO des im folgenden Blockschaltbild gezeichneten HF-Teils eines Empfängers haben?<p><img src=''tf210f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(853,'TF211','Welchen Frequenzen können die drei Oszillatoren des im folgenden Blockschaltbild gezeichneten Empfängers haben, wenn eine Frequenz von 3,65 MHz empfangen wird? Bei welcher Antwort sind alle drei Frequenzen richtig?<p><img src=''tf211f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(854,'TF212','Diese Blockschaltung stellt<p><img src=''tf212f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(855,'TF213','Dies ist das Blockschaltbild eines modernen Empfängers mit PLL-Frequenzaufbereitung. Es soll eine Frequenz von 15,0 MHz empfangen werden. Welche Frequenzen liefern VCO<sub>1</sub> und VCO<sub>2</sub>, wenn der programmierbare Frequenzvervielfacher n<sub>p</sub> dabei 18 MHz liefert?<p><img src=''tf213f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(856,'TF214','An welcher Stelle einer Amateurfunkanlage sollte ein VHF-Vorverstärker eingefügt werden?',0,1,0,0,'');
INSERT INTO question VALUES(857,'TF301','Wo liegt bei einem Direktüberlagerungsempfänger üblicherweise die Injektionsfrequenz des Mischers? Sie liegt',0,1,0,0,'');
INSERT INTO question VALUES(858,'TF302','Welche Signale steuern gewöhnlich die Empfängerstummschaltung (Squelch)?',0,1,0,0,'');
INSERT INTO question VALUES(859,'TF303','Was bewirkt die AGC (automatic gain control) bei einem starken Eingangssignal? Sie reduziert die',0,1,0,0,'');
INSERT INTO question VALUES(860,'TF304','Welches sind die wichtigsten Ausgangsfrequenzen, die bei der Mischung einer Frequenz von 30 MHz mit einer Frequenz von 39 MHz entstehen?',0,1,0,0,'');
INSERT INTO question VALUES(861,'TF305','Welcher Mischertyp ist am besten geeignet, um ein Doppelseitenbandsignal mit unterdrücktem Träger zu erzeugen? Am besten geeignet ist ein',0,1,0,0,'');
INSERT INTO question VALUES(862,'TF306','Einem Mischer werden die Frequenzen 136 MHz und 145 MHz zugeführt. Welche Frequenzen werden beim Mischvorgang erzeugt?',0,1,0,0,'');
INSERT INTO question VALUES(863,'TF307','Ein Doppelsuper hat eine erste ZF (ZF<sub>1</sub>) von 10,7 MHz und eine zweite ZF (ZF<sub>2</sub>) von 450 kHz. Die Empfangsfrequenz soll 28 MHz sein. Die Oszillatoren sollen oberhalb des Nutzsignals schwingen. Welche Frequenzen sind für den VFO und den CO erforderlich, wenn die Oszillatoren oberhalb des Mischer-Eingangssignals schwingen sollen?',0,1,0,0,'');
INSERT INTO question VALUES(864,'TF308','Welche ungefähren Werte sollte die Bandbreite der ZF-Verstärker eines Amateurfunk-Empfängers für folgende Sendearten aufweisen: J3E, F1B (RTTY Shift 170 Hz), F3E?',0,1,0,0,'');
INSERT INTO question VALUES(865,'TF309','Um wie viel S-Stufen müsste die S-Meter-Anzeige Ihres Empfängers steigen, wenn Ihr Partner die Sendeleistung von 100 Watt auf 400 Watt erhöht?',0,1,0,0,'');
INSERT INTO question VALUES(866,'TF310','Welche Funktion haben die beiden Kondensatoren C<sub>3</sub> und C<sub>4</sub> in der folgenden Schaltung?<p><img src=''tf310f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(867,'TF311','Welchem Zweck dient D<sub>1</sub> in der folgenden Schaltung?<p><img src=''tf311f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(868,'TF312','Um eine Rückkopplung der HF-Signale einer Leistungsverstärkerstufe zum VFO zu verhindern, sollte die Gleichstromversorgung des VFO´s',0,1,0,0,'');
INSERT INTO question VALUES(869,'TF313','Wozu dienen P und C<sub>4</sub> bei dieser Schaltung? Sie dienen<p><img src=''tf313f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(870,'TF314','An welchem Punkt wird in der Schaltung der Ausgangspegel entnommen?<p><img src=''tf314f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(871,'TF315','Bei dieser Schaltung handelt es sich um einen<p><img src=''tf315f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(872,'TF316','Welchem Zweck dient TR1 in der Schaltung?<p><img src=''tf315f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(873,'TF317','Bei der Schaltung handelt es sich um einen<p><img src=''tf317f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(874,'TF318','Der Ausgang eines richtig eingestellten Balancemischers enthält',0,1,0,0,'');
INSERT INTO question VALUES(875,'TF319','Welche Konfigurationen wäre für die Unterdrückung unerwünschter Signale am Eingang eines Empfängers hilfreich?',0,1,0,0,'');
INSERT INTO question VALUES(876,'TF320','Welche Baugruppe könnte in einem Empfänger gegebenenfalls dazu verwendet werden, um einen schmalen Frequenzbereich zu unterdrücken, in dem Störungen empfangen werden?',0,1,0,0,'');
INSERT INTO question VALUES(877,'TF321','Die Phasenverschiebung zwischen der Einund Ausgangsspannung einer Verstärkerstufe mit einem Transistor in Kollektorschaltung beträgt',0,1,0,0,'');
INSERT INTO question VALUES(878,'TF322','Die Phasenverschiebung zwischen der Einund Ausgangsspannung einer Verstärkerstufe mit einem Transistor in Basisschaltung beträgt',0,1,0,0,'');
INSERT INTO question VALUES(879,'TF323','Die Phasenverschiebung zwischen der Einund Ausgangsspannung einer Verstärkerstufe mit einem Transistor in Emitterschaltung beträgt',0,1,0,0,'');
INSERT INTO question VALUES(880,'TF324','Wie verhält sich der Kollektorstrom eines NPN-Transistors in einer HF-Verstärkerstufe im B-Betrieb, wenn die Basisspannung erhöht wird?',0,1,0,0,'');
INSERT INTO question VALUES(881,'TF325','Was bedeutet an einem Abstimmelement eines Empfängers die Abkürzung AGC?',0,1,0,0,'');
INSERT INTO question VALUES(882,'TF326','Welches Diagramm stellt den Frequenzverlauf eines Empfänger-Notchfilters dar?',0,1,0,0,'');
INSERT INTO question VALUES(883,'TF327','Bei welchem der folgenden Fälle misst man eine hohe Spannung am Emitterwiderstand einer Empfänger-ZF-Stufe?',0,1,0,0,'');
INSERT INTO question VALUES(884,'TF328','Die Mischstufe eines Überlagerungsempfängers arbeitet',0,1,0,0,'');
INSERT INTO question VALUES(885,'TF329','Der Begrenzerverstärker eines FM-Empfängers ist ein Verstärker,',0,1,0,0,'');
INSERT INTO question VALUES(886,'TF330','Bei welchem der nachfolgenden Fälle misst man nur eine geringe oder gar keine Spannung am Emitterwiderstand einer ZF-Stufe?',0,1,0,0,'');
INSERT INTO question VALUES(887,'TF401','Ein Empfänger hat eine ZF von 10,7 MHz und ist auf 28,5 MHz abgestimmt. Der Oszillator des Empfängers schwingt oberhalb der Empfangsfrequenz. Welches ist die richtige Spiegelfrequenz?',0,1,0,0,'');
INSERT INTO question VALUES(888,'TF402','Wodurch wird beim Überlagerungsempfänger die Spiegelfrequenzdämpfung bestimmt?',0,1,0,0,'');
INSERT INTO question VALUES(889,'TF403','Welche Baugruppe eines Empfängers bestimmt die Trennschärfe?',0,1,0,0,'');
INSERT INTO question VALUES(890,'TF404','Die Spule, die Bestandteil des frequenzbestimmenden Elementes eines VFO ist, sollte',0,1,0,0,'');
INSERT INTO question VALUES(891,'TF405','Welche Stromversorgungsart benötigt ein VFO?',0,1,0,0,'');
INSERT INTO question VALUES(892,'TF406','Welcher der folgenden als Bandpass einsetzbaren Bauteile verfügt am ehesten über die geringste Bandbreite?',0,1,0,0,'');
INSERT INTO question VALUES(893,'TF407','Welche Baugruppe sollte für die Erzeugung eines unterdrückten Zweiseitenband-Trägersignals verwendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(894,'TF408','Um Einrichtungen mit einem Klappdeckel aus Metall möglichst gut abzuschirmen, empfiehlt es sich, das Scharnier',0,1,0,0,'');
INSERT INTO question VALUES(895,'TF409','Eine schmale Empfängerbandbreite führt im allgemeinen zu einer',0,1,0,0,'');
INSERT INTO question VALUES(896,'TF410','Das folgende Bild zeigt die Durchlasskurve eines Empfängerfilters. Es ist besonders für den Empfang von<p><img src=''tf410f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(897,'TF411','In dem dargestellten Diagramm beträgt die Grenzbandbreite bei -60 dB etwa<p><img src=''tf411f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(898,'TF412','Ein Frequenzmarken-Generator in einem Empfänger sollte möglichst',0,1,0,0,'');
INSERT INTO question VALUES(899,'TF413','Für eine optimale Stabilität sollte auch ein bereits temperaturkompensierter VFO',0,1,0,0,'');
INSERT INTO question VALUES(900,'TF414','Für CW-Empfang sollte die Differenz zwischen der BFO-Frequenz und der End-ZF ungefähr',0,1,0,0,'');
INSERT INTO question VALUES(901,'TF415','In einigen NF-Endstufen eines Verstärkers wird der Lautsprecher über einen Abwärtstransformator angesteuert. Dies gewährleistet',0,1,0,0,'');
INSERT INTO question VALUES(902,'TF416','Beim Empfang einer Funkstelle auf 14,24 MHz, bei der sich die erste ZF des Empfängers auf 10,7 MHz befindet, können Spiegelfrequenzstörungen durch Signale auf',0,1,0,0,'');
INSERT INTO question VALUES(903,'TF417','Für die Demodulation von SSB-Signalen wird normalerweise ein Hilfsträgeroszillator verwendet. In hochwertigen Empfängern ist dieser Oszillator',0,1,0,0,'');
INSERT INTO question VALUES(904,'TF418','Ein Empfänger arbeitet mit einer End-ZF von 455 kHz. Welche BFO-Frequenz wäre beim CW-Empfang geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(905,'TF419','Die Stabilität des lokalen Oszillators einer Sende-/Empfangsanlage ist teilweise von',0,1,0,0,'');
INSERT INTO question VALUES(906,'TF420','Welchem Zweck dient ein BFO in einem Empfänger?',0,1,0,0,'');
INSERT INTO question VALUES(907,'TF421','Die Frequenzdifferenz zwischen dem HF-Nutzsignal und dem Spiegelsignal entspricht dem',0,1,0,0,'');
INSERT INTO question VALUES(908,'TF422','Um Schwankungen des NF-Ausgangssignals durch Schwankungen des HF-Eingangssignals zu verringern, wird ein Empfänger mit',0,1,0,0,'');
INSERT INTO question VALUES(909,'TF423','Die Frequenzdifferenz zwischen dem HF-Nutzsignal und dem Spiegelsignal entspricht',0,1,0,0,'');
INSERT INTO question VALUES(910,'TF424','Bei Empfang eines sehr starken Signals verringert die AGC',0,1,0,0,'');
INSERT INTO question VALUES(911,'TF425','Eine hohe erste ZF vereinfacht die Filterung zur Vermeidung von',0,1,0,0,'');
INSERT INTO question VALUES(912,'TF426','Welche Baugruppe erzeugt ein Zweiseitenbandsignal mit unterdrücktem Träger?',0,1,0,0,'');
INSERT INTO question VALUES(913,'TF427','Um unerwünschte Abstrahlungen auf ein Minimum zu beschränken, sollte eine Mischstufe',0,1,0,0,'');
INSERT INTO question VALUES(914,'TF428','Durch welchen Mischer werden unerwünschte Ausgangssignale auf ein Mindestmaß begrenzt?',0,1,0,0,'');
INSERT INTO question VALUES(915,'TF429','Um unerwünschte Abstrahlungen eines Oszillators zu vermeiden, sollte',0,1,0,0,'');
INSERT INTO question VALUES(916,'TF430','Die Ausgangsstufe eines SSB-Senders ist als',0,1,0,0,'');
INSERT INTO question VALUES(917,'TF431','Die Ungenauigkeit der digitalen Anzeige eines Empfängers beträgt 0,01 %. Bei welcher Entfernung zur unteren Bandgrenze ist im 10-m-Bereich noch gewährleistet, dass der Träger sich innerhalb des zugelassenen Bandes befindet?',0,1,0,0,'');
INSERT INTO question VALUES(918,'TF432','Auf welche Frequenz müsste ein Empfänger eingestellt werden, um die dritte Harmonische einer nahen 7,050-MHz-Aussendung erkennen zu können?',0,1,0,0,'');
INSERT INTO question VALUES(919,'TF433','Auf welche Frequenz müsste ein Empfänger eingestellt werden, um die dritte Oberwelle einer 7,20-MHz-Aussendung erkennen zu können?',0,1,0,0,'');
INSERT INTO question VALUES(920,'TF434','Die Empfindlichkeit eines Empfängers kann durch',0,1,0,0,'');
INSERT INTO question VALUES(921,'TF435','Was ist die Hauptursache für Intermodulationsprodukte in einem Empfänger?',0,1,0,0,'');
INSERT INTO question VALUES(922,'TF436','In einem Amateurfunkempfänger werden etwa alle 15625 Hz unerwünschte Signale festgestellt. Dies ist wahrscheinlich zurückzuführen auf',0,1,0,0,'');
INSERT INTO question VALUES(923,'TF437','Welche Empfängereigenschaft beurteilt man mit dem Interception Point IP3?',0,1,0,0,'');
INSERT INTO question VALUES(924,'TF438','Wodurch erreicht man eine Verringerung von Intermodulation und Kreuzmodulation beim Empfang?',0,1,0,0,'');
INSERT INTO question VALUES(925,'TF439','Ein Empfänger liefert bei einem Eingangssignal von 0,25 µV ein Ausgangssignal mit einem Signal-Geräuschabstand von 10 dB. Wie kann diese Eigenschaft angegeben werden?',0,1,0,0,'');
INSERT INTO question VALUES(926,'TF440','Was bedeutet Signal-Rauschabstand (S/N) bei einem VHF-Empfänger?',0,1,0,0,'');
INSERT INTO question VALUES(927,'TF441','Was bedeutet die Rauschzahl F=2 bei einem UHF-Vorverstärker? Das Ausgangssignal des Verstärkers hat ein',0,1,0,0,'');
INSERT INTO question VALUES(928,'TF442','Was bedeutet die Rauschzahl von 1,8 dB bei einem UHF-Vorverstärker? Das Ausgangssignal des Vorverstärkers hat ein',0,1,0,0,'');
INSERT INTO question VALUES(929,'TF501','Folgendes Blockschaltbild stellt das Prinzip einer DSP-Signalverarbeitung dar. Welche Aufgabe haben die beiden Blöcke 1 und 2? (DSP ... Digital Signal Processing)<p><img src=''tf501f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(930,'TF502','Wozu kann eine DSP-Signalverarbeitung bei einem Amateurfunkgerät beispielsweise dienen?',0,1,0,0,'');
INSERT INTO question VALUES(931,'TF503','Wozu eignet sich eine DSP-Signalverarbeitung in einem Empfänger? Sie eignet sich',0,1,0,0,'');
INSERT INTO question VALUES(932,'TF504','Wofür ist die DSP in einem Transceiver geeignet? Eine DSP eignet sich beispielsweise',0,1,0,0,'');
INSERT INTO question VALUES(933,'TF505','Bei einem Transceiver soll für Steuerungszwecke über die CAT-Schnittstelle der hexadezimale Wert „48h“ eingestellt werden. Das dazu verwendete Steuerprogramm erlaubt aber nur eine dezimale Eingabe des Wertes. Welcher dezimale Wert muss eingegeben werden?',0,1,0,0,'');
INSERT INTO question VALUES(934,'TF506','Bei einem Transceiver soll für Steuerungszwecke über die CAT-Schnittstelle der hexadezimale Wert „84h“ eingestellt werden. Das dazu verwendete Steuerprogramm erlaubt aber nur eine dezimale Eingabe des Wertes. Welcher dezimale Wert muss eingegeben werden?',0,1,0,0,'');
INSERT INTO question VALUES(935,'TG101','Dieses Blockschaltbild zeigt einen SSB-Sender. Welche Stufe muss beim " ? " arbeiten?<p><img src=''tg101f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(936,'TG102','Diese Schaltung ermöglicht<p><img src=''tg102f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(937,'TG103','Das Blockschaltbild stellt einen Mehrbandsender dar. Welche Frequenz entsteht am Ausgang X, wenn der VFO auf 3,51 MHz eingestellt ist?<p><img src=''tg103f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(938,'TG104','Am Ausgang X dieser Senderaufbereitung wird eine Frequenz von 21,360 MHz gemessen. Welche Frequenz hat der VFO?<p><img src=''tg104f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(939,'TG105','Welche Schaltungen sind bei den Stufen A und B des dargestellten Senders erforderlich?<p><img src=''tg105f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(940,'TG106','Die folgende Blockschaltung zeigt eine SSB-Aufbereitung mit einem 9-MHz-Quarzfilter. Welche Frequenz wird in der Schalterstellung USB mit der NF gemischt?<p><img src=''tg106f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(941,'TG107','Welches Schaltungsteil ist in der folgenden Blockschaltung am Ausgang des NF-Verstärkers angeschlossen?<p><img src=''tg106f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(942,'TG108','Die typische Bandbreite des in der Blockschaltung dargestellten NF-Verstärkers ist<p><img src=''tg106f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(943,'TG109','Welches Teil eines Senders ist in der Schaltung dargestellt?<p><img src=''tg109f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(944,'TG110','Im folgenden Blockschaltbild ist die Frequenzaufbereitung für einen Amateurfunk-Transceiver dargestellt. Welche Frequenz erzeugt der Sender, wenn VCO<sub>1</sub> auf 2,651 MHz eingestellt und VCO<sub>2</sub> auf 6 MHz eingerastet ist?<p><img src=''tg110f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(945,'TG111','Im folgenden Blockschaltbild ist die Frequenzaufbereitung für einen Amateurfunk-Transceiver dargestellt. Auf welcher Frequenz muss der VCO<sub>2</sub> eingerastet haben, wenn eine Ausgangsfrequenz von 14,351 MHz abgegeben wird?<p><img src=''tg110f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(946,'TG201','Welche Schaltung könnte für die Tiefpassfilterung in einem Mikrofonverstärker eingesetzt werden?',0,1,0,0,'');
INSERT INTO question VALUES(947,'TG202','Welcher Frequenzgang ist am besten für den Mikrofonverstärker eines Sprechfunkgeräts geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(948,'TG203','Um Splatter bei Telefonie auf ein Mindestmaß zu begrenzen, sollte die NF-Bandbreite auf etwa',0,1,0,0,'');
INSERT INTO question VALUES(949,'TG204','Wie können Tastklicks bei einem CW-Sender, die in einem Empfänger zu hören sind, verringert werden? Sie können verringert werden durch',0,1,0,0,'');
INSERT INTO question VALUES(950,'TG205','Welche Tastformung eines CW-Senders vermeidet an wirksamsten die Entstehung von Tastklicks?',0,1,0,0,'');
INSERT INTO question VALUES(951,'TG206','Eine Art der Instabilität eines CW-Senders ist das "Chirpen". Was ist die Ursache dafür?',0,1,0,0,'');
INSERT INTO question VALUES(952,'TG207','Wenn der Stromversorgung einer Endstufe NF-Signale überlagert sind, kann dies unerwünschte Modulation der Sendefrequenz erzeugen. Diese zeigt sich als',0,1,0,0,'');
INSERT INTO question VALUES(953,'TG208','Um Frequenzstabilität in einem Sender zu gewährleisten, sollte der VFO',0,1,0,0,'');
INSERT INTO question VALUES(954,'TG209','Beim Bau eines VFO sollte die Spule',0,1,0,0,'');
INSERT INTO question VALUES(955,'TG210','Der VFO eines Senders ist schwankenden Temperaturen unterworfen. Welche wesentliche Auswirkung könnte dies haben?',0,1,0,0,'');
INSERT INTO question VALUES(956,'TG211','Im Regelfall sollte ein Oszillator zunächst an',0,1,0,0,'');
INSERT INTO question VALUES(957,'TG212','Dieser Schaltungsauszug ist Teil eines Senders. Welche Funktion hat die Diode?<p><img src=''tg212f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(958,'TG213','Wie wird ein SSB-Signal erzeugt?',0,1,0,0,'');
INSERT INTO question VALUES(959,'TG214','Für die Erzeugung eines SSB-Signals wird ein Gegentaktmodulator verwendet. Das zur Unterdrückung eines Seitenbandes nachgeschaltete Filter sollte über',0,1,0,0,'');
INSERT INTO question VALUES(960,'TG215','Wie arbeitet die Frequenzvervielfachung?',0,1,0,0,'');
INSERT INTO question VALUES(961,'TG216','Die Stufen mit Frequenzvervielfachung in einer Sendeeinrichtung sollten idealerweise',0,1,0,0,'');
INSERT INTO question VALUES(962,'TG217','Bei dieser Schaltung handelt es sich um<p><img src=''tg217f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(963,'TG218','Stufen, in denen Harmonische erzeugt werden, sollten',0,1,0,0,'');
INSERT INTO question VALUES(964,'TG219','Die richtige Oberwellenauswahl in einer Vervielfachungsstufe lässt sich am leichtesten mit einem',0,1,0,0,'');
INSERT INTO question VALUES(965,'TG220','Ein quarzgesteuertes Funkgerät mit einer Ausgangsfrequenz von 432,050 MHz verursacht Störungen bei 144,017 MHz. Der Quarzoszillator des Funkgeräts schwingt auf einer Grundfrequenz bei 12 MHz. Mit welcher Vervielfachungskombination wird wahrscheinlich die Ausgangsfrequenz bei 432 MHz erzeugt? Die Abfolge der Vervielfachungsstufen ist',0,1,0,0,'');
INSERT INTO question VALUES(966,'TG221','Auf welcher Frequenz muss der Quarzoszillator schwingen, damit nach dem Blockschaltbild von der PA die Frequenz 145,000 MHz verstärkt wird?<p><img src=''tg221f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(967,'TG222','Bei dieser Schaltung handelt es sich um einen<p><img src=''tg222f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(968,'TG223','Welchem Zweck dient C<sub>5</sub> in der folgenden Schaltung?<p><img src=''tg222f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(969,'TG224','Welchem Zweck dient die Anzapfung an L1 in der folgenden Schaltung?<p><img src=''tg222f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(970,'TG225','Welchem Zweck dient C<sub>2</sub> in der folgenden Schaltung?<p><img src=''tg222f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(971,'TG226','Welche wesentlichen Ausgangsfrequenzen erzeugt die in der Abbildung dargestellte Stufe?<p><img src=''tg226f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(972,'TG227','Welche Mischerschaltung unterdrückt am wirksamsten unerwünschte Mischprodukte und Frequenzen?',0,1,0,0,'');
INSERT INTO question VALUES(973,'TG228','Um zu vermeiden, dass unerwünschte Mischprodukte die Senderausgangsstufe erreichen, sollte das Ausgangssignal des Mischers',0,1,0,0,'');
INSERT INTO question VALUES(974,'TG229','Ein hinter einem VHF-Sender geschalteter Bandpass',0,1,0,0,'');
INSERT INTO question VALUES(975,'TG230','Welches Filter sollte hinter einem VHF-Sender geschaltet werden, um die unerwünschte Aussendung von Subharmonischen und Harmonischen auf ein Mindestmaß zu begrenzen?',0,1,0,0,'');
INSERT INTO question VALUES(976,'TG231','Welche Filtercharakteristik würde sich am besten für einen Kurzwellen-Mehrband-Sender eignen?',0,1,0,0,'');
INSERT INTO question VALUES(977,'TG232','Welche Filtercharakteristik würde sich am besten für einen 10-m-Band-Sender eignen?',0,1,0,0,'');
INSERT INTO question VALUES(978,'TG233','Welche Aufgabe hat diese Schaltung am Senderausgang und was ist bei der Bemessung des Spannungsteilers zu beachten?<p><img src=''tg233f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(979,'TG234','Stromversorgungskabel in einem Sender sollten',0,1,0,0,'');
INSERT INTO question VALUES(980,'TG235','Welche der nachfolgenden Antworten trifft für die Wirkungsweise eines Transverters zu?',0,1,0,0,'');
INSERT INTO question VALUES(981,'TG236','Welche Baugruppen werden benötigt, um aus einem 5,3-MHz-Signal ein 14,3-MHz-Signal erzeugen?',0,1,0,0,'');
INSERT INTO question VALUES(982,'TG237','Bei dieser Schaltung handelt es sich um einen zweistufigen<p><img src=''tg237f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(983,'TG238','Wozu dient der Transformator T1 der folgenden Schaltung? Er dient der Anpassung des Ausgangswiderstandes der<p><img src=''tg238f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(984,'TG239','Weshalb wurden bei C<sub>1</sub>, C<sub>2</sub> und C<sub>3</sub> je zwei Kondensatoren parallel geschaltet?<p><img src=''tg239f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(985,'TG240','Wozu dient der Widerstand R von 180 Ohm parallel zur Trafowicklung?<p><img src=''tg240f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(986,'TG301','Was kann man bezüglich der Ausgangsleistung eines FM-Senders in Abhängigkeit von der Modulation aussagen?',0,1,0,0,'');
INSERT INTO question VALUES(987,'TG302','Was kann man bezüglich der Ausgangsleistung eines SSB-Senders in Abhängigkeit von der Modulation aussagen?',0,1,0,0,'');
INSERT INTO question VALUES(988,'TG303','Ein HF-Leistungsverstärker für einen SSB-Sender kann ein Verstärker im',0,1,0,0,'');
INSERT INTO question VALUES(989,'TG304','Welche Betriebsart der Leistungsverstärkerstufe eines Senders erzeugt grundsätzlich den größten Oberschwingungsanteil?',0,1,0,0,'');
INSERT INTO question VALUES(990,'TG305','Die Ausgangsleistung eines FM-Senders',0,1,0,0,'');
INSERT INTO question VALUES(991,'TG306','Die Ausgangsanpassschaltung und das Filter eines HF-Verstärkers im C-Betrieb sollten',0,1,0,0,'');
INSERT INTO question VALUES(992,'TG307','Wie und wo wird die Ausgangsleistung eines SSB-Senders gemessen?',0,1,0,0,'');
INSERT INTO question VALUES(993,'TG308','Bei einer Senderausgangsimpedanz von 240 &Omega; sollte für eine optimale Leistungsübertragung die Last',0,1,0,0,'');
INSERT INTO question VALUES(994,'TG309','Welche Funktion hat das Ausgangs-Pi-Filter eines HF-Senders?',0,1,0,0,'');
INSERT INTO question VALUES(995,'TG310','LC-Schaltungen unmittelbar vor und hinter einem HF-Leistungsverstärker dienen',0,1,0,0,'');
INSERT INTO question VALUES(996,'TG311','Welche Funktion haben C<sub>1</sub>, C<sub>2</sub> und L<sub>1</sub> in der folgenden Schaltung?<p><img src=''tg311f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(997,'TG312','Welche der nachfolgenden Aussagen trifft nicht für die Schaltung zu?<p><img src=''tg311f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(998,'TG313','Bei dieser Schaltung handelt es sich um<p><img src=''tg313f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(999,'TG314','Bei C<sub>1</sub>, C<sub>2</sub> und L<sub>1</sub> handelt es sich um<p><img src=''tg313f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1000,'TG315','Das folgende Bild zeigt eine HF-Endstufe. Welche Bedeutung und Funktion haben C<sub>1</sub>, C<sub>2</sub> und L<sub>1</sub> ? Wie sind die Bedienknöpfe der beiden Kondensatoren an einer Endstufe wahrscheinlich beschriftet?<p><img src=''tg313f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1001,'TG316','Wie wird die folgende Endstufe richtig auf die Sendefrequenz abgestimmt?<p><img src=''tg313f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1002,'TG317','Welchem Zweck dient R<sub>1</sub> in der folgenden Schaltung? R<sub>1</sub> dient<p><img src=''tg313f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1003,'TG318','Wodurch könnte R<sub>1</sub> in der folgenden Schaltung ersetzt werden, um den Arbeitspunkt der Röhre von der HF-Aussteuerung unabhängig einzustellen?<p><img src=''tg313f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1004,'TG401','Was kann man tun, wenn der Hub bei einem Handfunkgerät oder Mobil-Transceiver zu groß ist?',0,1,0,0,'');
INSERT INTO question VALUES(1005,'TG402','In welcher der folgenden Antworten sind Betriebsarten aufgezählt, die man bei einem üblichen Kurzwellentransceiver einstellen kann?',0,1,0,0,'');
INSERT INTO question VALUES(1006,'TG403','Wenn man beim Funkbetrieb die Empfangsfrequenz gegenüber der Senderfrequenz geringfügig verstellen möchte, kann man',0,1,0,0,'');
INSERT INTO question VALUES(1007,'TG404','Wie wird die Taste am Mikrofon bezeichnet, mit der ein Transceiver auf Sendung geschaltet werden kann?',0,1,0,0,'');
INSERT INTO question VALUES(1008,'TG405','Wie wird der Funkbetrieb bezeichnet, mit der ein Transceiver allein durch die Stimme auf Sendung geschaltet werden kann?',0,1,0,0,'');
INSERT INTO question VALUES(1009,'TG406','Wenn das Grundrauschen auf einer Frequenz im FM-Betrieb ausgeblendet werden soll, verstellt man',0,1,0,0,'');
INSERT INTO question VALUES(1010,'TG501','Wodurch können Tastklicks hervorgerufen werden?',0,1,0,0,'');
INSERT INTO question VALUES(1011,'TG502','Was passiert, wenn bei einem SSB-Sender die Mikrofonverstärkung zu hoch eingestellt wurde?',0,1,0,0,'');
INSERT INTO question VALUES(1012,'TG503','Wie kann man bei einem VHF-Sender mit kleiner Leistung die Entstehung parasitärer Schwingungen wirksam unterdrücken?',0,1,0,0,'');
INSERT INTO question VALUES(1013,'TG504','Wie ist der Wirkungsgrad eines HF-Generators definiert?',0,1,0,0,'');
INSERT INTO question VALUES(1014,'TG505','Wie kann sich die mangelhafte Frequenzstabilität eines Senders bei dessen Betrieb auswirken?',0,1,0,0,'');
INSERT INTO question VALUES(1015,'TG506','Bei digitalen Betriebsarten bis 9600 Bd sollte die Bandbreite der Signale 6 kHz nicht überschreiten. Geben Sie die richtige Begründung für diese Empfehlung an:',0,1,0,0,'');
INSERT INTO question VALUES(1016,'TG507','Wie wird in der Regel die hochfrequente Ausgangsleistung eines SSB-Senders vermindert?',0,1,0,0,'');
INSERT INTO question VALUES(1017,'TG508','Mit welcher Arbeitspunkteinstellung darf die Endstufe eines Einseitenbandsenders im SSB-Betrieb nicht arbeiten, um Verzerrungen (Harmonische und Intermodulationsprodukte), die zu unerwünschten Ausstrahlungen führen, zu vermeiden?',0,1,0,0,'');
INSERT INTO question VALUES(1018,'TG509','Was für ein Filter muss man zwischen Senderausgang und Antenne einschleifen, um die Abstrahlung von Oberwellen zu reduzieren?',0,1,0,0,'');
INSERT INTO question VALUES(1019,'TG510','Was kann man tun, wenn der Hub bei einem Handfunkgerät oder Mobiltransceiver zu groß ist?',0,1,0,0,'');
INSERT INTO question VALUES(1020,'TG511','Um Nachbarkanalstörungen zu minimieren sollte die Übertragungsbandbreite bei SSB',0,1,0,0,'');
INSERT INTO question VALUES(1021,'TG512','Was wird eingesetzt, um die Abstrahlung einer spezifischen Harmonischen wirkungsvoll zu begrenzen?',0,1,0,0,'');
INSERT INTO question VALUES(1022,'TG513','Welche Schaltung wäre zwischen Senderausgang und Antenne eingeschleift am besten zur Verringerung der Oberwellenausstrahlungen geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(1023,'TG514','Um die Gefahr von Eigenschwingungen in HF-Schaltungen zu verringern,',0,1,0,0,'');
INSERT INTO question VALUES(1024,'TG515','Die Ausgangsleistungsanzeige eines HF-Verstärkers zeigt beim Abstimmen geringfügige sprunghafte Schwankungen. Wodurch werden diese Schwankungen möglicherweise hervorgerufen? Sie werden möglicherweise hervorgerufen durch',0,1,0,0,'');
INSERT INTO question VALUES(1025,'TG516','Um die Wahrscheinlichkeit von Eigenschwingungen in einem Leistungsverstärker zu verringern,',0,1,0,0,'');
INSERT INTO question VALUES(1026,'TG517','Welche Harmonische eines 70-cm-Senders führt am ehesten zu Störungen im UHF-Bereich?',0,1,0,0,'');
INSERT INTO question VALUES(1027,'TG518','Bei Aussendungen im Frequenzbereich 1,81 bis 2,0 MHz können Spiegelfrequenzstörungen im',0,1,0,0,'');
INSERT INTO question VALUES(1028,'TG519','Bei der erstmaligen Prüfung eines Senders sollten die Signale zunächst',0,1,0,0,'');
INSERT INTO question VALUES(1029,'TG520','Welches Diagramm stellt den Frequenzgang eines Ausgangsfilters dar, das die Harmonischen eines Einbandsenders wirkungsvoll unterdrückt?',0,1,0,0,'');
INSERT INTO question VALUES(1030,'TG521','Die dritte Harmonische einer 29,5-MHz-Aussendung fällt in',0,1,0,0,'');
INSERT INTO question VALUES(1031,'TG522','Bei der Überprüfung des Ausgangssignals eines Senders sollte die Dämpfung der Oberwellen mindestens',0,1,0,0,'');
INSERT INTO question VALUES(1032,'TG523','Was gilt beim Sendebetrieb für unerwünschte Aussendungen im Frequenzbereich zwischen 1,7 und 35 MHz? Sofern die Leistung einer unerwünschten Aussendung',0,1,0,0,'');
INSERT INTO question VALUES(1033,'TG524','Was gilt beim Sendebetrieb für unerwünschte Aussendungen im Frequenzbereich zwischen 50 und 1000 MHz? Sofern die Leistung einer unerwünschten Aussendung',0,1,0,0,'');
INSERT INTO question VALUES(1034,'TG525','Wie erfolgt die Messung der Leistungen, die zu unerwünschten Aussendungen führen, in Anlehnung an die EU-Normen?',0,1,0,0,'');
INSERT INTO question VALUES(1035,'TH101','Welche elektrische Länge muss eine Dipolantenne haben, damit sie in Resonanz ist?',0,1,0,0,'');
INSERT INTO question VALUES(1036,'TH102','Welche Aussage zur Strom- und Spannungsverteilung auf einem Dipol ist richtig?',0,1,0,0,'');
INSERT INTO question VALUES(1037,'TH103','Ein Dipol wird stromgespeist, wenn an seinem Einspeisepunkt',0,1,0,0,'');
INSERT INTO question VALUES(1038,'TH104','Ein Dipol wird spannungsgespeist, wenn an seinem Einspeisepunkt',0,1,0,0,'');
INSERT INTO question VALUES(1039,'TH105','Ein mittengespeister &lambda;/2-Dipol ist bei seiner Grundfrequenz und deren ungeradzahligen Vielfachen',0,1,0,0,'');
INSERT INTO question VALUES(1040,'TH106','Ein mittengespeister &lambda;/2-Dipol ist bei geradzahligen Vielfachen seiner Grundfrequenz',0,1,0,0,'');
INSERT INTO question VALUES(1041,'TH107','Der Eingangswiderstand eines mittengespeisten &lambda;/2-Dipols zeigt sich bei dessen Resonanzfrequenzen',0,1,0,0,'');
INSERT INTO question VALUES(1042,'TH108','Das folgende Bild zeigt die Stromverteilungen A bis D auf einem Dipol, der auf verschiedenen Resonanzfrequenzen erregt werden kann. Für welche Erregerfrequenz gilt die Stromkurve nach A?<p><img src=''th108f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1043,'TH109','Das folgende Bild zeigt die Stromverteilungen A bis D auf einem Dipol, der auf verschiedenen Resonanzfrequenzen erregt werden kann. Für welche Erregerfrequenz gilt die Stromkurve nach B?<p><img src=''th108f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1044,'TH110','Das folgende Bild zeigt die Stromverteilungen A bis D auf einem Dipol, der auf verschiedenen Resonanzfrequenzen erregt werden kann. Für welche Erregerfrequenz gilt die Stromkurve nach C?<p><img src=''th108f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1045,'TH111','Das folgende Bild zeigt die Stromverteilungen A bis D auf einem Dipol, der auf verschiedenen Resonanzfrequenzen erregt werden kann. Für welche Erregerfrequenz gilt die Stromkurve nach D?<p><img src=''th108f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1046,'TH112','Das folgende Strahlungsdiagramm ist typisch für<p><img src=''th112f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1047,'TH113','Die Impedanz eines Halbwellendipols bei mindestens einer Wellenlänge über dem Boden beträgt ungefähr',0,1,0,0,'');
INSERT INTO question VALUES(1048,'TH114','Ein Faltdipol hat einen Eingangswiderstand von ungefähr',0,1,0,0,'');
INSERT INTO question VALUES(1049,'TH115','Die Länge des Drahtes zur Herstellung eines Faltdipols entspricht',0,1,0,0,'');
INSERT INTO question VALUES(1050,'TH116','Ein Parallelresonanzkreis (Trap) in jeder Dipolhälfte',0,1,0,0,'');
INSERT INTO question VALUES(1051,'TH117','Sie wollen verschiedene Antennen testen, ob sie für den Funkbetrieb auf Kurzwelle für das 80-m-Band geeignet sind. Man stellt Ihnen jeweils drei Antennen zur Verfügung. Welches Angebot wählen sie, um nur die drei besonders gut geeigneten Antennen testen zu müssen?',0,1,0,0,'');
INSERT INTO question VALUES(1052,'TH118','In welcher Zeile sind besonders für den Kurzwellenbereich geeignete Antennen aufgeführt?',0,1,0,0,'');
INSERT INTO question VALUES(1053,'TH119','Was sind typische KW-Amateurfunksendeantennen?',0,1,0,0,'');
INSERT INTO question VALUES(1054,'TH120','Welche Antennenformen werden im VHF-UHF-Bereich bei den Funkamateuren in der Regel nicht verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(1055,'TH121','Welche Antenne gehört nicht zu den symmetrischen Antennen?',0,1,0,0,'');
INSERT INTO question VALUES(1056,'TH122','Eine Marconi-Antenne ist',0,1,0,0,'');
INSERT INTO question VALUES(1057,'TH123','Bei welcher Länge hat eine Vertikalantenne die günstigsten Strahlungseigenschaften?',0,1,0,0,'');
INSERT INTO question VALUES(1058,'TH124','Eine Vertikalantenne erzeugt',0,1,0,0,'');
INSERT INTO question VALUES(1059,'TH125','Welche Antennenart ist hier dargestellt?<p><img src=''th125f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1060,'TH126','Welcher Prozentsatz entspricht dem Korrekturfaktor, der üblicherweise für die Berechnung der Länge einer Drahtantenne verwendet wird?',0,1,0,0,'');
INSERT INTO question VALUES(1061,'TH127','Welches der folgenden Bauteile sollte mit einem 15-m-langen Antennendraht in Reihe geschaltet werden, damit die Resonanz im 3,5-MHz-Bereich erfolgen kann?',0,1,0,0,'');
INSERT INTO question VALUES(1062,'TH128','Wie wird die folgende Antenne in der Amateurfunkliteratur bezeichnet?<p><img src=''th128f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1063,'TH129','Wie wird die folgende Antenne in der Amateurfunkliteratur bezeichnet?<p><img src=''th129f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1064,'TH130','Wie wird die folgende Antenne in der Amateurfunkliteratur bezeichnet?<p><img src=''th130f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1065,'TH131','Wie wird die folgende Antenne in der Amateurfunkliteratur bezeichnet?<p><img src=''th131f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1066,'TH132','Welche Antennenart ist hier dargestellt?<p><img src=''th132f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1067,'TH133','Wenn man diese Mehrband-Antenne auf 7 MHz erregt, dann wirken die LC-Resonanzkreise<p><img src=''th133f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1068,'TH134','Wenn man diese Mehrband-Antenne auf 3,5 MHz erregt, dann wirken die LC-Resonanzkreise<p><img src=''th133f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1069,'TH135','Wenn man diese Mehrband-Antenne auf 14 MHz erregt, dann wirken die LC-Resonanzkreise<p><img src=''th133f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1070,'TH136','Das folgende Bild stellt einen Dreiband-Dipol für die Frequenzbänder 20, 15 und 10 Meter dar. Die mit B gekennzeichneten Schwingkreise sind auf<p><img src=''th136f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1071,'TH137','Das folgende Bild stellt einen Dreiband-Dipol für die Frequenzbänder 20, 15 und 10 Meter dar. Die mit A gekennzeichneten Schwingkreise sind auf<p><img src=''th136f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1072,'TH138','Welche Antenne ist hier dargestellt und wozu dient der Kondensator?<p><img src=''th138f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1073,'TH139','Die Radiale einer Groundplane-Antenne bezeichnet man auch als',0,1,0,0,'');
INSERT INTO question VALUES(1074,'TH140','Jeweils eine Seite einer Quad-Antenne ist in Resonanz mit',0,1,0,0,'');
INSERT INTO question VALUES(1075,'TH141','Das folgende Bild enthält eine einfache Richtantenne. Die Bezeichnungen der Elemente in numerischer Reihenfolge lauten<p><img src=''th141f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1076,'TH142','An welchem Element einer Yagi-Antenne erfolgt die Energieeinspeisung? Sie erfolgt',0,1,0,0,'');
INSERT INTO question VALUES(1077,'TH143','Der Anbau von Reflektoren und einem Direktor an einen Faltdipol',0,1,0,0,'');
INSERT INTO question VALUES(1078,'TH144','Durch den Einbau zusätzlicher Direktoren in eine Richtstrahlantenne wird deren',0,1,0,0,'');
INSERT INTO question VALUES(1079,'TH145','Die Impedanz des Strahlers eines Multibandbeams richtet sich auch nach',0,1,0,0,'');
INSERT INTO question VALUES(1080,'TH146','Wie wirken parasitäre Elemente von Antennen?',0,1,0,0,'');
INSERT INTO question VALUES(1081,'TH147','Dieses Strahlungsdiagramm ist typisch für<p><img src=''th147f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1082,'TH148','Bei einer Yagi-Antenne mit dem folgenden Strahlungsdiagramm beträgt die ERP in Richtung A 0,6 Watt und in Richtung B 15 Watt. Welches Vor-Rück-Verhältnis hat die Antenne?<p><img src=''th148f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1083,'TH149','Eine Richtantenne mit einem Gewinn von 10 dB über dem Halbwellendipol und einem Vor-Rück-Verhältnis von 20 dB wird mit 100 Watt Senderleistung direkt gespeist. Welche ERP strahlt die Antenne entgegengesetzt zur Senderichtung ab?',0,1,0,0,'');
INSERT INTO question VALUES(1084,'TH150','Eine Richtantenne mit einem Gewinn von 15 dB über dem Halbwellendipol und einem Vor-Rück-Verhältnis von 25 dB wird mit 6 Watt Senderleistung direkt gespeist. Welche ERP strahlt die Antenne entgegengesetzt zur Senderichtung ab?',0,1,0,0,'');
INSERT INTO question VALUES(1085,'TH151','Um die Möglichkeit unerwünschter Abstrahlungen mit Hilfe eines angepassten Antennensystems zu verringern, empfiehlt es sich',0,1,0,0,'');
INSERT INTO question VALUES(1086,'TH152','Bei welcher der nachfolgend genannten Antennenkonfigurationen ist eine Abstrahlung von der Speiseleitung am wenigsten wahrscheinlich?',0,1,0,0,'');
INSERT INTO question VALUES(1087,'TH153','Welcher Standort ist für eine HF-Richtantenne am besten geeignet, um mögliche Beeinflussungen bei den Geräten des Nachbarn zu vermeiden?',0,1,0,0,'');
INSERT INTO question VALUES(1088,'TH154','Eine &lambda;/4-Groundplane-Antenne mit vier Radials soll für 7,1 MHz aus Drähten gefertigt werden. Für Strahler und Radials kann mit einem Korrekturfaktor von 0,95 gerechnet werden. Wie lang müssen Strahler und Radials sein?',0,1,0,0,'');
INSERT INTO question VALUES(1089,'TH155','Eine &lambda;/2-Dipol-Antenne soll für 7,1 MHz aus Draht gefertigt werden. Wie lang müssen die beiden Drähte der Dipolantenne sein? Es soll hier mit einem Korrekturfaktor von 0,95 gerechnet werden.',0,1,0,0,'');
INSERT INTO question VALUES(1090,'TH156','Eine &lambda;/2-Dipol-Antenne soll für 14,2 MHz aus Draht gefertigt werden. Es kann mit einem Korrekturfaktor von 0,95 gerechnet werden. Wie lang müssen die beiden Drähte der Dipolantenne sein?',0,1,0,0,'');
INSERT INTO question VALUES(1091,'TH157','Ein Drahtdipol hat eine Gesamtlänge von 20,00 m. Für welche Frequenz ist der Dipol in Resonanz, wenn mit einem Korrekturfaktor von 0,95 gerechnet werden kann.',0,1,0,0,'');
INSERT INTO question VALUES(1092,'TH158','Ein Drahtdipol hat eine Gesamtlänge von 21,00 m. Für welche Frequenz ist der Dipol in Resonanz, wenn mit einem Korrekturfaktor von 0,95 gerechnet werden kann.',0,1,0,0,'');
INSERT INTO question VALUES(1093,'TH159','Eine Delta-Loop-Antenne mit einer vollen Wellenlänge soll für 7,1 MHz aus Draht hergestellt werden. Es kann mit einem Korrekturfaktor von 0,95 gerechnet werden. Wie lang muss der Draht insgesamt sein?',0,1,0,0,'');
INSERT INTO question VALUES(1094,'TH160','Eine &lambda;-5/8-Antenne (gegen Erde) soll für 14,2 MHz aus Draht hergestellt werden. Es soll mit einem Korrekturfaktor von 0,97 gerechnet werden. Wie lang muss der Vertikaldraht insgesamt sein?',0,1,0,0,'');
INSERT INTO question VALUES(1095,'TH201','Der Strahlungswiderstand einer Antenne',0,1,0,0,'');
INSERT INTO question VALUES(1096,'TH202','Welchen Eingangs- bzw. Fußpunktwiderstand hat ein Faltdipol?',0,1,0,0,'');
INSERT INTO question VALUES(1097,'TH203','Welchen Eingangs- bzw. Fußpunktwiderstand hat eine Groundplane?',0,1,0,0,'');
INSERT INTO question VALUES(1098,'TH204','Welchen Eingangs- bzw. Fußpunktwiderstand hat ein &lambda;/2-Dipol bei seiner Grundfrequenz und hinreichender Höhe über dem Boden?',0,1,0,0,'');
INSERT INTO question VALUES(1099,'TH205','Welche Impedanz hat ein &lambda;/2-Dipol unterhalb und oberhalb seiner Grundfrequenz?',0,1,0,0,'');
INSERT INTO question VALUES(1100,'TH206','Das folgende Bild zeigt das Richtdiagramm einer Dipol- und einer Yagi-Antenne. Der Antennengewinn der Yagi-Antenne über dem Dipol ist definiert als<p><img src=''th206f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1101,'TH207','Das folgende Bild zeigt das Richtdiagramm einer Dipol- und einer Yagi-Antenne. Das Vor-/Rück-Verhältnis der Yagi-Antenne ist definiert<p><img src=''th206f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1102,'TH208','Der Gewinn von Antennen wird häufig in dBi angegeben. Auf welche Vergleichsantenne bezieht man sich dabei? Man bezieht sich dabei auf den',0,1,0,0,'');
INSERT INTO question VALUES(1103,'TH209','Ein Antennenhersteller gibt den Gewinn einer Antenne mit 5 dBd an. Wie groß ist der Gewinn der Antenne in dBi?',0,1,0,0,'');
INSERT INTO question VALUES(1104,'TH210','Warum ist eine &lambda;-5/8-Antenne besser als eine &lambda;/4-Antenne für VHF-UHF-Mobilbetrieb geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(1105,'TH211','Die Halbwertsbreite einer Antenne ist der Winkelbereich, innerhalb dem',0,1,0,0,'');
INSERT INTO question VALUES(1106,'TH212','In dem folgenden Richtdiagramm sind auf der Skala der relativen Feldstärke E / E<sub>max</sub> die Punkte A bis D markiert. Durch welchen der Punkte A bis D ziehen sie mit einem Zirkel den Kreisbogen, um die Halbwertsbreite der Antenne an den Schnittpunkten des Kreises mit der Keule ablesen zu können?<p><img src=''th212f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1107,'TH213','Die folgende Skizze zeigt das Horizontaldiagramm der relativen Feldstärke einer horizontalen Yagiantenne. Wie groß ist im vorliegenden Fall die Halbwertsbreite (Öffnungswinkel)?<p><img src=''th213f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1108,'TH214','Warum muss eine Antenne mechanisch immer etwas kürzer als der theoretisch errechnete Wert sein?',0,1,0,0,'');
INSERT INTO question VALUES(1109,'TH215','Bei einer Drahtantenne bewirkt eine Erhöhung der Drahtlänge',0,1,0,0,'');
INSERT INTO question VALUES(1110,'TH216','Die Polarisation einer Antenne',0,1,0,0,'');
INSERT INTO question VALUES(1111,'TH217','Mit welcher Polarisation wird auf den Kurzwellenbändern meistens gesendet?',0,1,0,0,'');
INSERT INTO question VALUES(1112,'TH218','Wie wird die Polarisation einer elektromagnetischen Welle bei der Ausbreitung über die Raumwelle beeinflusst?',0,1,0,0,'');
INSERT INTO question VALUES(1113,'TH219','Für die Erzeugung von zirkularer Polarisation mit Yagi-Antennen wird eine horizontale und eine dazu um 90 Grad um die Strahlungsachse gedrehte Yagi-Antenne zusammengeschaltet. Was ist dabei zu beachten, damit tatsächlich zirkulare Polarisation entsteht?',0,1,0,0,'');
INSERT INTO question VALUES(1114,'TH220','Eine Antenne hat ein Stehwellenverhältnis (VSWR) von 3. Wie viel Prozent der vorlaufenden Leistung werden von der Zuleitung auf die Antenne übertragen?',0,1,0,0,'');
INSERT INTO question VALUES(1115,'TH221','Ein Kabel mit einem Wellenwiderstand von 75 und vernachlässigbarer Dämpfung wird zur Speisung einer Faltdipol-Antenne verwendet. Welches VSWR kann man auf der Leitung erwarten?',0,1,0,0,'');
INSERT INTO question VALUES(1116,'TH222','Welches Strahlungsdiagramm ist der richtigen Antennenbezeichnung zugeordnet?',0,1,0,0,'');
INSERT INTO question VALUES(1117,'TH223','Welches Strahlungsdiagramm ist der richtigen Antennenbezeichnung zugeordnet?',0,1,0,0,'');
INSERT INTO question VALUES(1118,'TH224','Welches Strahlungsdiagramm ist der richtigen Antennenbezeichnung zugeordnet?',0,1,0,0,'');
INSERT INTO question VALUES(1119,'TH225','Ein Sender mit 0,6 Watt Ausgangsleistung ist über eine Antennenleitung, die 1 dB Kabelverluste hat, an eine Richtantenne mit 11 dB Gewinn (auf den Dipol bezogen) angeschlossen. Welche EIRP wird von der Antenne maximal abgestrahlt?',0,1,0,0,'');
INSERT INTO question VALUES(1120,'TH226','Ein Sender mit 5 Watt Ausgangsleistung ist über eine Antennenleitung, die 2 dB Kabelverluste hat, an eine Richtantenne mit 5 dB Gewinn (auf den Dipol bezogen) angeschlossen. Welche EIRP wird von der Antenne maximal abgestrahlt?',0,1,0,0,'');
INSERT INTO question VALUES(1121,'TH227','Ein Sender mit 8,5 Watt Ausgangsleistung ist über eine Antennenleitung, die 1,5 dB Kabelverluste hat, an eine Antenne mit 0 dB Gewinn (auf den Dipol bezogen) angeschlossen. Welche EIRP wird von der Antenne maximal abgestrahlt?',0,1,0,0,'');
INSERT INTO question VALUES(1122,'TH228','An einen Sender mit 100 W Ausgangsleistung ist eine Antenne mit einem Gewinn von 11 dBi angeschlossen. Die Dämpfung des Kabels beträgt 1 dB. Wie hoch ist die äquivalente Strahlungsleistung (EIRP)?',0,1,0,0,'');
INSERT INTO question VALUES(1123,'TH229','An einen Sender mit 100 W Ausgangsleistung ist eine Dipolantenne angeschlossen. Die Dämpfung des Kabels beträgt 10 dB. Wie hoch ist die äquivalente isotrope Strahlungsleistung (EIRP)?',0,1,0,0,'');
INSERT INTO question VALUES(1124,'TH230','Eine im Außenbereich installierte Sendeantenne wird immer bevorzugt, da',0,1,0,0,'');
INSERT INTO question VALUES(1125,'TH231','Eine Langdrahtantenne mit einer senkrechten Speiseleitung in der Nähe eines Hauses',0,1,0,0,'');
INSERT INTO question VALUES(1126,'TH232','Mit einem Feldstärkemessgerät wurden Vergleichsmessungen zwischen Beam und Dipol durchgeführt. In einem Abstand von 32 m wurden folgende Feldstärken gemessen: Beam vorwärts: 300 µV/m, Beam rückwärts: 20 µV/m, Halbwellendipol in Hauptstrahlrichtung: 128 µV/m. Welcher Gewinn und welches Vor-Rück-Verhältnis ergibt sich daraus für den Beam?',0,1,0,0,'');
INSERT INTO question VALUES(1127,'TH301','Der Wellenwiderstand einer Leitung',0,1,0,0,'');
INSERT INTO question VALUES(1128,'TH302','Eine Übertragungsleitung gilt als richtig angepasst, wenn der Widerstand, mit dem sie abgeschlossen ist,',0,1,0,0,'');
INSERT INTO question VALUES(1129,'TH303','Im Amateurfunk übliche Koaxialkabel weisen typischerweise Wellenwiderstände von',0,1,0,0,'');
INSERT INTO question VALUES(1130,'TH304','Welche Dämpfung ergibt sich auf der Grundlage des Kabeldämpfungsdiagramms für ein 15-m-langes Koaxialkabel vom Typ RG58 bei 145 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(1131,'TH305','Welche Dämpfung ergibt sich auf der Grundlage des Kabeldämpfungsdiagramms für ein 15-m-langes Koaxialkabel vom Typ RG58 bei 435 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(1132,'TH306','Welche Dämpfung ergibt sich auf der Grundlage des Kabeldämpfungsdiagramms für ein 25-m-langes Koaxialkabel vom Typ RG213 (MIL) bei 3,5 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(1133,'TH307','Welche Dämpfung ergibt sich auf der Grundlage des Kabeldämpfungsdiagramms für ein 25-m-langes Koaxialkabel vom Typ RG213U-S100 bei 29 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(1134,'TH308','Welche Dämpfung ergibt sich auf der Grundlage des Kabeldämpfungsdiagramms für ein 25-m-langes Koaxialkabel vom Typ RG213 (MIL) bei 145 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(1135,'TH309','Welche Dämpfung ergibt sich auf der Grundlage des Kabeldämpfungsdiagramms für ein 25-m-langes Koaxialkabel vom Typ RG213U-S100 bei 435 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(1136,'TH310','Welche Dämpfung ergibt sich auf der Grundlage des Kabeldämpfungsdiagramms für ein 25-m-langes Koaxialkabel vom Typ RG213U-S100 bei 1296 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(1137,'TH311','Welches der folgenden Kabel weist im Kurzwellenbereich den geringsten Verlust auf?',0,1,0,0,'');
INSERT INTO question VALUES(1138,'TH312','Welche Vorteile hat eine Paralleldraht-Speiseleitung?',0,1,0,0,'');
INSERT INTO question VALUES(1139,'TH313','Wann ist eine Speiseleitung asymmetrisch?',0,1,0,0,'');
INSERT INTO question VALUES(1140,'TH314','Bei einer Leitung mit symmetrischer Übertragung',0,1,0,0,'');
INSERT INTO question VALUES(1141,'TH315','Ein Koaxialkabel hat einen Innenleiterdurchmesser von 0,7 mm. Die Isolierung zwischen Innenleiter und Abschirmgeflecht besteht aus Polyethylen (PE) und sie hat einen Durchmesser von 4,4 mm. Der Außendurchmesser des Kabels ist 7,4 mm. Wie hoch ist der ungefähre Wellenwiderstand des Kabels?',0,1,0,0,'');
INSERT INTO question VALUES(1142,'TH316','Eine offene Paralleldrahtleitung ist aus Draht mit einem Durchmesser d = 2 mm gefertigt. Der Abstand der parallelen Leiter beträgt a = 20 cm. Wie groß ist der Wellenwiderstand Z<sub>0</sub> der Leitung?',0,1,0,0,'');
INSERT INTO question VALUES(1143,'TH317','Ein Koaxialkabel (luftisoliert) hat einen Innendurchmesser der Abschirmung von 5 mm. Der Außendurchmesser des inneren Leiters beträgt 1 mm . Wie groß ist der Wellenwiderstand Z<sub>0</sub> des Kabels?',0,1,0,0,'');
INSERT INTO question VALUES(1144,'TH318','Die Ausbreitungsgeschwindigkeit in einem Koaxialkabel',0,1,0,0,'');
INSERT INTO question VALUES(1145,'TH319','Der Verkürzungsfaktor einer luftisolierten Paralleldrahtleitung ist',0,1,0,0,'');
INSERT INTO question VALUES(1146,'TH320','Der Verkürzungsfaktor eines Koaxialkabels mit einem Dielektrikum aus massivem Polyäthylen beträgt ungefähr',0,1,0,0,'');
INSERT INTO question VALUES(1147,'TH321','Wie lang ist ein Koaxialkabel, das für eine ganze Wellenlänge bei 100 MHz zugeschnitten wurde, wenn der Verkürzungsfaktor 0,6 beträgt?',0,1,0,0,'');
INSERT INTO question VALUES(1148,'TH322','Welche mechanische Länge hat ein &lambda;/4-langes Koaxkabel mit Vollpolyethylenisolierung bei 145 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(1149,'TH323','Wie verhält sich das Stehwellenverhältnis, wenn Wasser in eine genau angepasste Antennenspeiseleitung eindringt?',0,1,0,0,'');
INSERT INTO question VALUES(1150,'TH324','Welche Leitungen sollten für die HF-Verbindungen zwischen Einrichtungen in der Amateurfunkstelle verwendet werden, um unerwünschte Abstrahlungen zu vermeiden?',0,1,0,0,'');
INSERT INTO question VALUES(1151,'TH325','Eine Lecherleitung besteht aus zwei parallelen Leitern. Wovon ist ihre Resonanzfrequenz wesentlich abhängig? Sie ist abhängig',0,1,0,0,'');
INSERT INTO question VALUES(1152,'TH326','Was zeigt diese Darstellung?<p><img src=''th326f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1153,'TH327','Um Ordnung in der Amateurfunkstelle herzustellen, verlegen Sie alle Netzanschlusskabel und HF-Speiseleitungen in einem Kabelkanal. Welche Nachteile kann diese Maßnahme haben?',0,1,0,0,'');
INSERT INTO question VALUES(1154,'TH328','Um die Störwahrscheinlichkeit auf ein Mindestmaß zu begrenzen, sollte die für die Sendeantenne verwendete Speiseleitung',0,1,0,0,'');
INSERT INTO question VALUES(1155,'TH329','Am Eingang einer HF-Übertragungsleitung werden 100 W HF-Leistung bei richtiger Anpassung eingespeist. Die Dämpfung der Leitung beträgt 3 dB. Welche Leistung wird bei Leerlauf oder Kurzschluss am Leitungsende reflektiert, wenn dabei am Leitungsende keine Leistung verbraucht oder abgestrahlt wird?',0,1,0,0,'');
INSERT INTO question VALUES(1156,'TH330','Am Eingang einer Antennenleitung, deren Dämpfung mit 5 dB berechnet wurde, werden 10 Watt HF-Leistung eingespeist. Mit der am Leitungsende angeschlossenen Antenne misst man am Leitungseingang ein VSWR von 1. Welches VSWR ist am Leitungseingang zu erwarten, wenn die Antenne am Leitungsende abgeklemmt wird?',0,1,0,0,'');
INSERT INTO question VALUES(1157,'TH331','Am Eingang einer Antennenleitung, deren Dämpfung mit 3 dB berechnet wurde, werden 10 Watt HF-Leistung eingespeist. Mit der am Leitungsende angeschlossenen Antenne misst man am Leitungseingang ein VSWR von 3. Mit einer künstlichen 50-&Omega;-Antenne am Leitungsende beträgt das VSWR am Leitungseingang etwa 1. Was lässt sich aus diesen Messergebnissen schließen?',0,1,0,0,'');
INSERT INTO question VALUES(1158,'TH401','Was zeigt diese Darstellung?<p><img src=''th401f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1159,'TH402','Zur Anpassung von Antennen werden häufig Umwegleitungen verwendet. Wie arbeitet die folgende Schaltung?<p><img src=''th401f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1160,'TH403','Einem Ganzwellendipol wird die Sendeleistung über eine abgestimmte &lambda;/4-Speiseleitung zugeführt. Wie groß ist die Impedanz Z<sub>1</sub> am Einspeisepunkt des Dipols? Und wie groß ist die Impedanz Z<sub>2</sub> am Anfang der Speiseleitung?<p><img src=''th403f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1161,'TH404','Einem Ganzwellendipol wird die Sendeleistung über eine abgestimmte &lambda;/2-Speiseleitung zugeführt. Wie groß ist die Impedanz Z<sub>1</sub> am Einspeisepunkt des Dipols? Und wie groß ist die Impedanz Z<sub>2</sub> am Anfang der Speiseleitung?<p><img src=''th403f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1162,'TH405','Einem Halbwellendipol wird die Sendeleistung über eine abgestimmte &lambda;/2-Speiseleitung zugeführt. Wie groß ist die Impedanz Z<sub>1</sub> am Einspeisepunkt des Dipols? Und wie groß ist die Impedanz Z<sub>2</sub> am Anfang der Speiseleitung?<p><img src=''th403f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1163,'TH406','Ein Faltdipol mit einem Fußpunktwiderstand von 240 &Omega; soll mit einer Hühnerleiter gespeist werden, deren Wellenwiderstand 600 &Omega; beträgt. Zur Anpassung soll ein &lambda;/4-langes Stück Hühnerleiter mit einem anderem Wellenwiderstand verwendet werden. Welchen Wellenwiderstand muss die Transformationsleitung haben?',0,1,0,0,'');
INSERT INTO question VALUES(1164,'TH407','Ein Dipol mit einem Fußpunktwiderstand von 60 &Omega; soll über eine &lambda;/4-Transformationsleitung mit einem 240-&Omega;-Flachbandkabel gespeist werden. Welchen Wellenwiderstand muss die Transformationsleitung haben?',0,1,0,0,'');
INSERT INTO question VALUES(1165,'TH408','Wie groß ist die Impedanz am Punkt X, wenn die elektrische Länge der abgebildeten Leitung &lambda;/4 beträgt?<p><img src=''th408f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1166,'TH409','Wie groß ist die Impedanz am Punkt X, wenn die elektrische Länge der abgebildeten Leitung &lambda;/4 beträgt?<p><img src=''th409f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1167,'TH410','Eine Viertelwellen-Übertragungsleitung ist an einem Ende offen. Die Impedanz am anderen Ende',0,1,0,0,'');
INSERT INTO question VALUES(1168,'TH411','Welche Phasenverschiebung erhält ein HF-Signal von A nach B, wenn die elektrische Länge der abgebildeten Leitung &lambda;/4 beträgt?<p><img src=''th411f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1169,'TH412','Welche Phasenverschiebung erhält ein HF-Signal von A nach B, wenn die elektrische Länge der abgebildeten Leitung gleich der Wellenlänge ist?<p><img src=''th411f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1170,'TH413','Eine Halbwellen-Übertragungsleitung ist an einem Ende mit 50 &Omega; abgeschlossen. Wie groß ist die Eingangsimpedanz am anderen Ende dieser Leitung?',0,1,0,0,'');
INSERT INTO question VALUES(1171,'TH414','Ein Halbwellendipol hat an seinem Einspeisepunkt eine Impedanz von 70 . Er wird über ein &lambda;/2-langes 300-&Omega;-Flachbandkabel gespeist. Wie groß ist die Impedanz am Eingang der Speiseleitung?',0,1,0,0,'');
INSERT INTO question VALUES(1172,'TH415','Welche Auswirkungen hat es, wenn eine symmetrische Antenne (Dipol) mit einem Koaxkabel gleicher Impedanz gespeist wird?',0,1,0,0,'');
INSERT INTO question VALUES(1173,'TH416','Eine symmetrische Antenne (Dipol) soll mit einem unsymmetrischen Kabel (Koaxkabel) gleicher Impedanz gespeist werden. Dabei erreicht man einen Symmetriereffekt zum Beispiel',0,1,0,0,'');
INSERT INTO question VALUES(1174,'TH417','Auf einem Ferritkern sind etliche Windungen Koaxialkabel aufgewickelt. Diese Anordnung kann dazu dienen<p><img src=''tb401f.jpg''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1175,'TH418','Ein symmetrischer Halbwellendipol wird direkt über ein Koaxialkabel von einem Sender gespeist. Das Kabel ist senkrecht am Haus entlang verlegt und verursacht geringe Störungen. Um das Problem weiter zu verringern, empfiehlt es sich',0,1,0,0,'');
INSERT INTO question VALUES(1176,'TH419','Für welche Antennenimpedanz ist der folgende Balun-Transformator aus zweimal 8 Windungen ausgelegt?<p><img src=''th419f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1177,'TH420','Folgender Balun-Transformator aus zweimal 8 Windungen ist gegeben. Von A nach B wird ein Faltdipol mit 200 Ohm Impedanz angeschlossen. Welche Impedanz misst man zwischen A und M?<p><img src=''th420f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1178,'TH421','Fehlanpassungen, schlecht montierte Steckverbindungen oder Beschädigungen von HF-Übertragungsleitungen',0,1,0,0,'');
INSERT INTO question VALUES(1179,'TH422','Am Eingang einer Antennenleitung misst man ein VSWR von 3. Wie groß ist in etwa die rücklaufende Leistung am Messpunkt, wenn die vorlaufende Leistung dort 100 Watt beträgt?',0,1,0,0,'');
INSERT INTO question VALUES(1180,'TH423','Ein Balun ist',0,1,0,0,'');
INSERT INTO question VALUES(1181,'TI101','Welche ionosphärischen Schichten bestimmen die Fernausbreitung am Tage?',0,1,0,0,'');
INSERT INTO question VALUES(1182,'TI102','Welche ionosphärischen Schichten bestimmen die Fernausbreitung in der Nacht?',0,1,0,0,'');
INSERT INTO question VALUES(1183,'TI103','In welcher Höhe befindet sich die für die Fernausbreitung wichtige F1-Schicht an einem Sommertag? Sie befindet sich in ungefähr',0,1,0,0,'');
INSERT INTO question VALUES(1184,'TI104','In welcher Höhe befindet sich die für die Fernausbreitung wichtige F2-Schicht an einem Sommertag? Sie befindet sich in ungefähr',0,1,0,0,'');
INSERT INTO question VALUES(1185,'TI105','In welcher Höhe befindet sich die für die Fernausbreitung wichtige E-Schicht an einem Sommertag? Sie befindet sich in ungefähr',0,1,0,0,'');
INSERT INTO question VALUES(1186,'TI106','In welcher Höhe befindet sich die für die Fernausbreitung wichtige D-Schicht an einem Sommertag? Sie befindet sich in ungefähr',0,1,0,0,'');
INSERT INTO question VALUES(1187,'TI107','In etwa welcher Höhe über der Erdoberfläche befindet sich die E-Schicht? Sie befindet sich in ungefähr',0,1,0,0,'');
INSERT INTO question VALUES(1188,'TI108','In welcher Höhe über dem Boden befindet sich in etwa die F1-Schicht? Sie befindet sich in ungefähr',0,1,0,0,'');
INSERT INTO question VALUES(1189,'TI109','Zu welcher Jahres- und Tageszeit hat die F2-Schicht ihre größte Höhe? Sie hat ihre größte Höhe',0,1,0,0,'');
INSERT INTO question VALUES(1190,'TI110','Welche ionosphärische Schicht ermöglicht im wesentlichen Weitverkehrsverbindungen im Kurzwellenbereich?',0,1,0,0,'');
INSERT INTO question VALUES(1191,'TI111','Für die Kurzwellenausbreitung über die Raumwelle ist die F1-Schicht',0,1,0,0,'');
INSERT INTO question VALUES(1192,'TI112','Welchen Einfluss hat die D-Schicht auf die Fernausbreitung?',0,1,0,0,'');
INSERT INTO question VALUES(1193,'TI113','Wodurch kommt die Reflexionsfähigkeit der ionosphärischen Schichten im wesentlichen zustande?',0,1,0,0,'');
INSERT INTO question VALUES(1194,'TI114','Wie kommt die Fernausbreitung einer Funkwelle auf den Kurzwellenbändern zustande? Sie kommt zustande',0,1,0,0,'');
INSERT INTO question VALUES(1195,'TI115','Der solare Flux F',0,1,0,0,'');
INSERT INTO question VALUES(1196,'TI201','Unter der "Toten Zone" wird der Bereich verstanden,',0,1,0,0,'');
INSERT INTO question VALUES(1197,'TI202','Welche der folgenden Aussagen trifft für KW-Funkverbindungen zu, die über Bodenwellen erfolgen?',0,1,0,0,'');
INSERT INTO question VALUES(1198,'TI203','Eine Aussendung auf 14,18 MHz kann von der Funkstelle A in einer Entfernung von 1500 km, nicht jedoch von der Funkstelle B in 60 km Entfernung empfangen werden. Der Grund hierfür ist, dass',0,1,0,0,'');
INSERT INTO question VALUES(1199,'TI204','Unter Sprungentfernung versteht man',0,1,0,0,'');
INSERT INTO question VALUES(1200,'TI205','Was wirkt sich nicht auf die Sprungentfernung aus? Keine Auswirkung hat',0,1,0,0,'');
INSERT INTO question VALUES(1201,'TI206','Wie groß ist in etwa die maximale Entfernung, die ein KW-Signal bei Reflexion an der F2-Schicht auf der Erdoberfläche mit einem Sprung (Hop) überbrücken kann?',0,1,0,0,'');
INSERT INTO question VALUES(1202,'TI207','Wie groß ist in etwa die maximale Entfernung, die ein KW-Signal bei Reflexion an der E-Schicht auf der Erdoberfläche mit einem Sprung (Hop) überbrücken kann? Sie beträgt ungefähr',0,1,0,0,'');
INSERT INTO question VALUES(1203,'TI208','Von welchem der genannten Parameter ist die Sprungdistanz abhängig, die ein KW-Signal auf der Erdoberfläche überbrücken kann? Sie ist abhängig',0,1,0,0,'');
INSERT INTO question VALUES(1204,'TI209','Was ist mit der Aussage "Funkverkehr über den langen Weg (long path)" gemeint?',0,1,0,0,'');
INSERT INTO question VALUES(1205,'TI210','Eine Amateurfunkstation in Frankfurt/Main will eine Verbindung nach Buenos Aires auf dem langen Weg herstellen. Auf welchen Winkel gegen Nord (Azimut) muss der Funkamateur seinen Kurzwellenbeam drehen, wenn die Beamrichtung für den kurzen Weg 231° beträgt? Er muss die Antenne drehen auf',0,1,0,0,'');
INSERT INTO question VALUES(1206,'TI211','Eine Amateurfunkstation in Frankfurt/Main will eine Verbindung nach Tokio auf dem langen Weg herstellen. Auf welchen Winkel gegen Nord (Azimut) muss der Funkamateur seinen Kurzwellenbeam drehen, wenn die Beamrichtung für den kurzen Weg 38° beträgt? Er muss die Antenne drehen auf',0,1,0,0,'');
INSERT INTO question VALUES(1207,'TI212','Bei der Ausbreitung auf Kurzwelle spielt die so genannte "Grey Line" eine besondere Rolle. Die "Grey Line" ist',0,1,0,0,'');
INSERT INTO question VALUES(1208,'TI213','Was versteht man unter dem Begriff "Mögel-Dellinger-Effekt"? Man versteht darunter',0,1,0,0,'');
INSERT INTO question VALUES(1209,'TI214','Ein plötzlicher Anstieg der Intensitäten von UV- und Röntgenstrahlung nach einem Flare (Energieausbruch der Sonne) führt zu erhöhter Ionisierung der D-Schicht und damit zu kurzzeitigem Totalausfall der ionosphärischen Kurzwellenausbreitung. Diese Erscheinung wird auch als',0,1,0,0,'');
INSERT INTO question VALUES(1210,'TI215','Ionosphärische Störungen, hervorgerufen durch stark erhöhte Intensität der UV- und Röntgenstrahlung beeinflussen vor allem',0,1,0,0,'');
INSERT INTO question VALUES(1211,'TI216','Ionosphärischer Schwund kann auf',0,1,0,0,'');
INSERT INTO question VALUES(1212,'TI217','Welches Ereignis tritt ein, wenn zwei phasenverschobene Signale an einem Empfangsort zusammentreffen?',0,1,0,0,'');
INSERT INTO question VALUES(1213,'TI218','Backscatter oder Rückstreuung kann auftreten, wenn',0,1,0,0,'');
INSERT INTO question VALUES(1214,'TI219','Was ist für ein "Backscatter-Signal" charakteristisch?',0,1,0,0,'');
INSERT INTO question VALUES(1215,'TI220','Unter dem Begriff "short skip" versteht man Funkverbindungen oberhalb 21 MHz mit Sprungentfernungen unter 1000 km, die',0,1,0,0,'');
INSERT INTO question VALUES(1216,'TI221','Damit ein Signal zur Erde zurückreflektiert wird, müsste bei zunehmender Sendefrequenz die Ionisierung der reflektierenden Schicht',0,1,0,0,'');
INSERT INTO question VALUES(1217,'TI222','Die kritische Grenzfrequenz (F<sub>krit</sub>) ist die',0,1,0,0,'');
INSERT INTO question VALUES(1218,'TI223','Die höchste Frequenz, bei der eine zufrieden stellende Kommunikation zwischen zwei Funkstellen im HF-Bereich gewährleistet ist, wird als',0,1,0,0,'');
INSERT INTO question VALUES(1219,'TI224','Die MUF für eine Funkstrecke ist',0,1,0,0,'');
INSERT INTO question VALUES(1220,'TI225','Eine stärkere Ionisierung der F2-Schicht führt zu',0,1,0,0,'');
INSERT INTO question VALUES(1221,'TI226','Die höchste brauchbare Frequenz (MUF) für eine Funkstrecke',0,1,0,0,'');
INSERT INTO question VALUES(1222,'TI227','Wie groß ist die obere brauchbare Frequenz (MUF) und die optimale Frequenz fopt bei Verwendung einer Antenne, die einen Abstrahlwinkel von 45° hat, wenn die kritische Frequenz fk mit 3 MHz gemessen wurde?',0,1,0,0,'');
INSERT INTO question VALUES(1223,'TI228','Was bedeutet die Aussage: "Die kritische Frequenz liegt bei 22 MHz"?',0,1,0,0,'');
INSERT INTO question VALUES(1224,'TI229','Was bedeutet die Aussage: "Die LUF liegt bei 6 MHz"?',0,1,0,0,'');
INSERT INTO question VALUES(1225,'TI230','Die LUF für eine Funkstrecke ist',0,1,0,0,'');
INSERT INTO question VALUES(1226,'TI231','Die Ausbreitungsbedingungen für ein Amateurfunkband werden folgendermaßen beschrieben: "Das Band ist nur in Zeiten starker Sonnenaktivität für Verbindungen über die Raumwelle brauchbar. Tagsüber bestehen dann hervorragende DX-Möglichkeiten, auch mit sehr kleiner Sendeleistung. Die tote Zone beträgt bis zu 4000 km. Der Ausbreitungsweg muss auf der Tagseite erfolgen." Welches KW-Band wurde hier beschrieben? Beschrieben wurde das',0,1,0,0,'');
INSERT INTO question VALUES(1227,'TI232','Die Ausbreitungsbedingungen für ein Amateurfunkband werden folgendermaßen beschrieben: "Die Ausbreitungsbedingungen auf diesem Band sind stark von den Sonnenfleckenzyklen abhängig. Während des Sonnenfleckenmaximums ist das Band fast durchgehend für den DX-Verkehr geöffnet. Im Sonnenfleckenminimum ist das Band bestenfalls in den Sommermonaten tagsüber und meist nur kurzzeitig für den DX-Verkehr brauchbar." Welches KW-Band wurde hier beschrieben? Beschrieben wurde das',0,1,0,0,'');
INSERT INTO question VALUES(1228,'TI233','Die Ausbreitungsbedingungen für ein Amateurfunkband werden folgendermaßen beschrieben: "Fast zu allen Zeiten lässt sich das Band für den Verkehr mit anderen Kontinenten nutzen. Im Sonnenfleckenminimum ist das Band nur tagsüber und in der Dämmerungsperiode offen. Die Sprungsdistanz liegt zwischen 1000 km im Sonnenfleckenminimum und 400 km im Sonnenfleckenmaximum. Für Europaverbindungen ist das Band nur während des Sonnenfleckenmaximums im Sommer brauchbar, wenn fast keine tote Zone mehr vorhanden ist." Welches KW-Band wurde hier beschrieben? Beschrieben wurde das',0,1,0,0,'');
INSERT INTO question VALUES(1229,'TI234','Die Ausbreitungsbedingungen für ein Amateurfunkband werden folgendermaßen beschrieben: "In diesem Band ist die Tagesdämpfung durch die D-Schicht noch erheblich. Die Tagesreichweite geht bis zu 1000 km. Die tote Zone beträgt am Tage etwa 100 km. Nachts und während der Wintermonate vergrößert sich die Sprungdistanz mit einem Maximum um Mitternacht. Größte Reichweiten treten auf, wenn sich der gesamt Ausbreitungspfad auf der Nachtseite der Erde befindet." Welches KW-Band wurde hier beschrieben? Beschrieben wurde das',0,1,0,0,'');
INSERT INTO question VALUES(1230,'TI235','Die Ausbreitungsbedingungen für ein Amateurfunkband werden folgendermaßen beschrieben: "Während der Tagesstunden können nur relativ geringe Entfernungen überbrückt werden, weil die Wellen von der D-Schicht stark absorbiert werden. Im Winter sind die Tagesreichweiten größer als im Sommer, maximal etwa 400 km. Nach Sonnenuntergang steigen die Reichweiten wegen des Abbaus der dämpfenden D-Schicht an. Während des Sonnenfleckenminimums ist in den Morgenstunden oft interkontinentaler Funkverkehr möglich. Die Sprungsdistanz kann dabei auf bis zu 1000 km ansteigen." Welches KW-Band wurde hier beschrieben? Beschrieben wurde das',0,1,0,0,'');
INSERT INTO question VALUES(1231,'TI236','Die Ausbreitung der Wellen im 160-m-Band erfolgt tagsüber hauptsächlich',0,1,0,0,'');
INSERT INTO question VALUES(1232,'TI237','Warum sind Signale im 160-, 80- und 40-Meter-Band tagsüber nur schwach und nicht für den weltweiten Funkverkehr geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(1233,'TI238','Welches der nachstehend aufgeführten Frequenzbänder ist für Aussendungen zwischen Hamburg und München während des Tages am besten geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(1234,'TI239','Welches dieser Frequenzbänder kann am ehesten bei einem Sonnenfleckenminimum für dauerhafte Weitverkehrsverbindungen verwendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(1235,'TI301','Wie weit etwa reicht der Funkhorizont im UKW-Bereich über den geographischen Horizont hinaus?',0,1,0,0,'');
INSERT INTO question VALUES(1236,'TI302','Überhorizontverbindungen im UHF/VHF-Bereich kommen unter anderem zustande durch',0,1,0,0,'');
INSERT INTO question VALUES(1237,'TI303','Überhorizontverbindungen im UHF/VHF-Bereich kommen u.a. zustande durch',0,1,0,0,'');
INSERT INTO question VALUES(1238,'TI304','Überhorizontverbindungen im UHF/VHF-Bereich kommen unter anderem zustande durch',0,1,0,0,'');
INSERT INTO question VALUES(1239,'TI305','Für VHF-Weitverkehrsverbindungen wird hauptsächlich die',0,1,0,0,'');
INSERT INTO question VALUES(1240,'TI306','Was ist die "Troposphäre"? Die Troposphäre ist',0,1,0,0,'');
INSERT INTO question VALUES(1241,'TI307','Wie wirkt sich die Antennenhöhe auf die Reichweite einer UKW-Verbindung aus?',0,1,0,0,'');
INSERT INTO question VALUES(1242,'TI308','Beim Auftreten von Polarlichtern lassen sich auf den Amateurfunkbändern über 30 MHz beträchtliche Überreichweiten erzielen, weil',0,1,0,0,'');
INSERT INTO question VALUES(1243,'TI309','Was ist die Ursache für Aurora-Erscheinungen?',0,1,0,0,'');
INSERT INTO question VALUES(1244,'TI310','Wie wirkt sich "Aurora" auf die Signalqualität eines Funksignals aus?',0,1,0,0,'');
INSERT INTO question VALUES(1245,'TI311','In welcher ionosphärischen Schicht treten Aurora-Erscheinungen auf? Sie treten auf in der',0,1,0,0,'');
INSERT INTO question VALUES(1246,'TI312','Welche Betriebsart eignet sich am besten für Auroraverbindungen?',0,1,0,0,'');
INSERT INTO question VALUES(1247,'TI313','In welchen Gebieten treten Reflexionen an Nordlicht-Erscheinungen auf? Sie treten auf',0,1,0,0,'');
INSERT INTO question VALUES(1248,'TI314','Was sind sporadische E-Reflexionen? Es sind Reflexionen von Wellen im UKW-Bereich an',0,1,0,0,'');
INSERT INTO question VALUES(1249,'TI315','Was bedeutet der Begriff "Sporadic E"? Es ist',0,1,0,0,'');
INSERT INTO question VALUES(1250,'TI316','In welcher Region der Erde kommt "Sporadic-E" am häufigsten vor? Sie kommt am häufigsten vor',0,1,0,0,'');
INSERT INTO question VALUES(1251,'TI317','Welche Aussage ist für das Sonnenfleckenmaximum richtig?',0,1,0,0,'');
INSERT INTO question VALUES(1252,'TJ101','Das Prinzip eines Drehspulmessgeräts beruht auf',0,1,0,0,'');
INSERT INTO question VALUES(1253,'TJ102','Das Drehspulmesswerk in der folgenden Schaltung hat einen maximalen Messstrom I<sub>M</sub> = 100 µA und einen Messwerkwiderstand R<sub>M</sub> = 1 k&Omega;. R<sub>V</sub> = 499 k&Omega; Welche Gleichspannung muss an die Gesamtschaltung angelegt werden, damit das Messwerk Vollausschlag anzeigt?<p><img src=''tj102f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1254,'TJ103','Das Drehspulmesswerk in der folgenden Schaltung hat einen maximalen Messstrom I<sub>M</sub> = 0,3 mA und einen Messwerkwiderstand R<sub>M</sub> = 300 &Omega;. R<sub>V</sub> = 9,7 k Welche Gleichspannung muss an die Gesamtschaltung angelegt werden, damit das Messwerk Vollausschlag anzeigt?<p><img src=''tj102f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1255,'TJ104','Das Drehspulmesswerk in der folgenden Schaltung hat einen maximalen Messstrom I<sub>M</sub> = 100 µA und einen Messwerkwiderstand R<sub>M</sub> = 1 k&Omega;. Wie groß muss R<sub>P</sub> gewählt werden, damit das Messwerk in der Gesamtschaltung bei I = 100 mA Vollausschlag anzeigt?<p><img src=''tj104f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1256,'TJ105','Wenn bei dieser Messschaltung I = 1 A zu einem Vollausschlag des Instruments führt, beträgt der Strom durch R<sub>P</sub><p><img src=''tj105f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1257,'TJ106','Wie groß muss R<sub>P</sub> bei der folgenden Schaltung gewählt werden, wenn I = 1 A zum Vollausschlag des Instruments mit 300 &Omega; Innenwiderstand führen soll?<p><img src=''tj105f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1258,'TJ107','Durch ein Einbauinstrument mit einem Messbereich von 2 V, fließt bei Vollausschlag ein Strom von 2 mA. Das Instrument soll mit einem Vorwiderstand auf einen Messbereich von 20 V Endausschlag erweitert werden. Wie groß ist der Widerstandswert R<sub>V</sub> und die Belastung P<sub>V</sub> des Vorwiderstandes?<p><img src=''tj107f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1259,'TJ108','Der Messbereich eines Amperemeters mit dem Innenwiderstand R<sub>i</sub> soll um den Faktor 5 erweitert werden. Durch welche Maßnahme ist dies erreichbar?',0,1,0,0,'');
INSERT INTO question VALUES(1260,'TJ109','Der Messbereich eines Voltmeters mit dem Innenwiderstand R<sub>i</sub> soll um den Faktor 8 erweitert werden. Durch welche Maßnahme ist dies erreichbar?',0,1,0,0,'');
INSERT INTO question VALUES(1261,'TJ110','Ein Vielfachmessgerät hat in den Wechselspannungsbereichen die Empfindlichkeit 4 k&Omega;/V. Wie groß ist der Strom durch das Messgerät bei Vollausschlag im 10-V Bereich?',0,1,0,0,'');
INSERT INTO question VALUES(1262,'TJ111','Mit welchem Strom zeigt ein 20-k&Omega;/V-Instrument Vollausschlag?',0,1,0,0,'');
INSERT INTO question VALUES(1263,'TJ112','Ein Messgerät hat einen Kennwiderstand von 10 k&Omega;/V. Für 1 Volt Vollausschlag liegt die Stromaufnahme bei',0,1,0,0,'');
INSERT INTO question VALUES(1264,'TJ113','Die Auflösung eines Messinstruments entspricht',0,1,0,0,'');
INSERT INTO question VALUES(1265,'TJ114','Welches dieser Messgeräte verfügt normalerweise über die höchste Genauigkeit bei Spannungsmessungen?',0,1,0,0,'');
INSERT INTO question VALUES(1266,'TJ115','Ein Drehspulmessgerät hat meistens eine Genauigkeit von',0,1,0,0,'');
INSERT INTO question VALUES(1267,'TJ116','Welche Spannung wird bei dem folgenden Messinstrument angezeigt, wenn dessen Messbereich auf 10 V eingestellt ist?<p><img src=''tj116f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1268,'TJ117','Welche Spannung wird bei dem folgenden Messinstrument angezeigt, wenn dessen Messbereich auf 300 V eingestellt ist?<p><img src=''tj116f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1269,'TJ201','Ein Dipmeter ist beispielsweise',0,1,0,0,'');
INSERT INTO question VALUES(1270,'TJ202','Das Drehspulmesswerk eines Dipmeters',0,1,0,0,'');
INSERT INTO question VALUES(1271,'TJ203','Wozu wird ein Dipmeter beispielsweise verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(1272,'TJ204','Wozu wird ein Dipmeter beispielsweise verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(1273,'TJ205','Wozu wird ein Dipmeter beispielsweise verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(1274,'TJ206','Ein Dipmeter hat normalerweise eine Genauigkeit von etwa',0,1,0,0,'');
INSERT INTO question VALUES(1275,'TJ207','Um wie viele Kilohertz kann die Frequenz abweichen, wenn mit einem Dipmeter eine Resonanzfrequenz von 7,1 MHz gemessen wurde und die Messgenauigkeit mit 3 % angenommen wird?',0,1,0,0,'');
INSERT INTO question VALUES(1276,'TJ208','Um wie viele Kilohertz kann die Frequenz abweichen, wenn mit einem Dipmeter eine Resonanzfrequenz von 4,5 MHz gemessen wurde und die Genauigkeit mit 3 % angenommen wird?',0,1,0,0,'');
INSERT INTO question VALUES(1277,'TJ209','Mit einem Dipmeter soll auf indirektem Wege eine Induktivität gemessen werden. Die Spule wurde zu einem Kondensator von 220 pF parallel geschaltet und bei 4,5 MHz Resonanz festgestellt. Welche Induktivität hat die Spule?',0,1,0,0,'');
INSERT INTO question VALUES(1278,'TJ210','Mit einem Dipmeter soll auf indirektem Wege eine Induktivität gemessen werden. Die Spule wurde zu einem Kondensator von 330 pF parallel geschaltet und bei 5,5 MHz Resonanz festgestellt. Welche Induktivität hat die Spule?',0,1,0,0,'');
INSERT INTO question VALUES(1279,'TJ211','Welches dieser Messgeräte ist für die Ermittlung der Resonanzfrequenz eines Traps, das für einen Dipol genutzt werden soll, am besten geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(1280,'TJ301','Die Zeitbasis eines Oszillografen ist so eingestellt, dass ein Skalenteil 0,5 ms entspricht. Welche Frequenz hat die angelegte Spannung?<p><img src=''tj301f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1281,'TJ302','Die Zeitbasis eines Oszillografen ist so eingestellt, dass ein Skalenteil 0,5 ms entspricht. Welche Periodendauer hat die angelegte Spannung?<p><img src=''tj301f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1282,'TJ303','Um auf dem Bildschirm eines Oszilloskops ein stehendes Bild statt durchlaufender Wellenzüge zu erhalten muss, das Oszilloskop',0,1,0,0,'');
INSERT INTO question VALUES(1283,'TJ304','Welches Gerät kann für die Prüfung einer Signalform verwendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(1284,'TJ305','Welches dieser Geräte wird für die Anzeige von NF-Verzerrungen verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(1285,'TJ401','Bei dieser Schaltung handelt es sich um<p><img src=''tj401f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1286,'TJ402','Für welchen Zweck wird eine Stehwellenmessbrücke verwendet? Sie wird verwendet',0,1,0,0,'');
INSERT INTO question VALUES(1287,'TJ403','Ein Stehwellenmessgerät misst bei einer HF-Leitung im Grunde',0,1,0,0,'');
INSERT INTO question VALUES(1288,'TJ404','Ein Stehwellenmessgerät wird in ein ideal angepasstes Sender-/Antennensystem eingeschleift. Das Messgerät sollte',0,1,0,0,'');
INSERT INTO question VALUES(1289,'TJ405','Welches dieser Instrumente kann für die Anzeige der Anpassung zwischen einem UHF-Sender und der Speiseleitung verwendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(1290,'TJ406','Eine Antenne hat ein Stehwellenverhältnis (VSWR) von 3. Wie viel Prozent der vorlaufenden Leistung wird an der Stoßstelle Kabel-Antenne reflektiert?',0,1,0,0,'');
INSERT INTO question VALUES(1291,'TJ501','Um die Skalenendwerte einer Sende-/Empfangsanlage mit VFO mit hinreichender Genauigkeit zu überprüfen, kann man',0,1,0,0,'');
INSERT INTO question VALUES(1292,'TJ502','Für eine größtmögliche Genauigkeit sollte ein Frequenzzähler',0,1,0,0,'');
INSERT INTO question VALUES(1293,'TJ503','Mit einem genauen Frequenzzähler und einem entsprechenden Dämpfungsglied kann',0,1,0,0,'');
INSERT INTO question VALUES(1294,'TJ504','Ein Frequenzzähler verfügt über eine Genauigkeit von ±1 ppm. Wenn der Zähler auf den 100-MHz-Bereich eingestellt wird, beträgt die Genauigkeit am oberen Ende des 100-MHz-Bereichs plus bzw. minus',0,1,0,0,'');
INSERT INTO question VALUES(1295,'TJ505','Welches der folgenden Messgeräte ist für genaue Frequenzmessungen am besten geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(1296,'TJ506','Welches der folgenden Geräte kann in der Regel nicht für die Prüfung von Harmonischen verwendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(1297,'TJ507','Ein digitaler Frequenzzähler verfügt über eine Genauigkeit von 10 ppm und wird für eine Messung bei 145 MHz verwendet. Welcher der Messwerte weist die richtige Anzahl von genauen Dezimalstellen für die angegebene Genauigkeit auf?',0,1,0,0,'');
INSERT INTO question VALUES(1298,'TJ508','Benutzt man bei einem Frequenzzähler eine Torzeit von 10 s anstelle von 1 s erhöht sich',0,1,0,0,'');
INSERT INTO question VALUES(1299,'TJ509','Was stellt die mit X gekennzeichnete Stelle der folgenden Anzeige eines Frequenzzählers dar?<p><img src=''tj509f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1300,'TJ510','Was stellt die mit X gekennzeichnete Stelle der folgenden Anzeige eines Frequenzzählers dar?<p><img src=''tj510f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1301,'TJ601','Welches Gerät ist hier dargestellt?<p><img src=''tj601f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1302,'TJ602','Ein Absorptionsfrequenzmesser hat normalerweise eine Genauigkeit von etwa',0,1,0,0,'');
INSERT INTO question VALUES(1303,'TJ603','Das einfachste Gerät, mit dem geprüft werden kann, ob ein Quarz mit dem richtigen Oberton arbeitet, ist ein',0,1,0,0,'');
INSERT INTO question VALUES(1304,'TJ604','Mit welchem Messgerät können Harmonische festgestellt werden?',0,1,0,0,'');
INSERT INTO question VALUES(1305,'TJ605','Ein Absorptionsfrequenzmesser ist ein Hilfsmittel zur Prüfung',0,1,0,0,'');
INSERT INTO question VALUES(1306,'TJ606','Ein Absorptionsfrequenzmesser eignet sich zur Prüfung',0,1,0,0,'');
INSERT INTO question VALUES(1307,'TJ701','Was stellt diese Schaltung dar?<p><img src=''tj701f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1308,'TJ702','Wozu dient diese Schaltung? Sie dient<p><img src=''tj701f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1309,'TJ703','Was stellt diese Schaltung dar?<p><img src=''tj703f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1310,'TJ704','Sie wollen mit der folgenden Messschaltung die Ausgangsleistung eines 2-m-Senders überprüfen, der voraussichtlich zirka 15 W HF-Leistung liefert. Was sollte für die Messung vor die dargestellte Messschaltung geschaltet werden?<p><img src=''tj703f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1311,'TJ705','Was muss für die genaue Messung der HF-Ausgangsleistung eines Senders mit einer solchen Schaltung berücksichtigt werden?<p><img src=''tj705f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1312,'TJ706','Was stellt diese Schaltung dar?<p><img src=''tj706f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1313,'TJ707','Mit welchem der folgenden Messinstrumente können die genauen Frequenzen der Harmonischen eines Signals gemessen werden? Sie können gemessen werden',0,1,0,0,'');
INSERT INTO question VALUES(1314,'TJ708','Für den Bau einer Dummy Load wurden Schichtwiderstände von 150 Ohm / 1 Watt verwendet. Jeweils vier Widerstände wurden in Serie geschaltet und durch Parallelschaltung dieser Serienschaltungen wurden zirka 50 Ohm erreicht. Wie viele Widerstände wurden insgesamt benötigt und welche Dauerleistung verträgt die Dummy Load?<p><img src=''tj708f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1315,'TJ801','Wie werden elektrische Spannungsmesser an Messobjekte angeschlossen und welche Anforderungen muss das Messgerät erfüllen, damit der Messfehler möglichst gering bleibt?',0,1,0,0,'');
INSERT INTO question VALUES(1316,'TJ802','Wie sollten Strom- und Spannungsmesser zur Feststellung der Gleichstrom-Eingangsleistung des dargestellten Endverstärkers (PA) angeordnet werden?<p><img src=''tj802f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1317,'TJ803','Für die Messung der Gleichstrom-Eingangsleistung werden verschiedene Messgeräte verwendet. Bei welchen der Instrumente in der Abbildung handelt es sich um Amperemeter?<p><img src=''tj802f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1318,'TJ804','Welches der nachfolgend genannten Messgeräte ermöglicht die genaueste Messung der Spannung zwischen A und B?<p><img src=''tj804f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1319,'TJ805','Mit einem Voltmeter der Klasse 1.5, das einen Skalenendwert von 300 Volt hat, messen Sie an einer Spannungsquelle 230 Volt. In welchem Bereich liegt der wahre Wert?',0,1,0,0,'');
INSERT INTO question VALUES(1320,'TJ806','Mit einem Voltmeter der Klasse 2.5, das einen Skalenendwert von 20 Volt hat, messen Sie an einer Spannungsquelle 12,6 Volt. In welchem Bereich liegt der wahre Wert?',0,1,0,0,'');
INSERT INTO question VALUES(1321,'TJ807','Das an den abgebildeten Spannungsteiler angeschlossene Messgerät ist auf den 10-V-Bereich eingestellt und hat eine Empfindlichkeit von 20 k&Omega;/V. Welcher Spannungswert wird angezeigt?<p><img src=''tj807f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1322,'TJ808','Eine präzise Effektivwertmessung ist mit einem Gleichrichterinstrument',0,1,0,0,'');
INSERT INTO question VALUES(1323,'TJ809','Zur genauen Messung des Effektivwertes eines nicht sinusförmigen Stromes bis in den GHz-Bereich eignet sich',0,1,0,0,'');
INSERT INTO question VALUES(1324,'TJ810','Eine künstliche Antenne von 50 &Omega; verfügt über eine Anzapfung bei 5 &Omega; vom erdnahen Ende. Diese Anzapfung ermöglicht die',0,1,0,0,'');
INSERT INTO question VALUES(1325,'TJ811','Eine künstliche Antenne von 50 &Omega; verfügt über eine Anzapfung bei 5 &Omega; vom erdnahen Ende. Was könnte zur ungefähren Ermittlung der Senderausgangsleistung über diesen Messpunkt eingesetzt werden?',0,1,0,0,'');
INSERT INTO question VALUES(1326,'TJ812','Wie ermittelt man die Resonanzfrequenz eines passiven Schwingkreises?',0,1,0,0,'');
INSERT INTO question VALUES(1327,'TJ813','Die Resonanzfrequenz eines abgestimmten HF-Kreises kann mit einem',0,1,0,0,'');
INSERT INTO question VALUES(1328,'TJ814','Ein abgestimmter Kreis wird mit einem Dipmeter geprüft. Um eine Änderung der Resonanzfrequenz zu vermeiden, ist',0,1,0,0,'');
INSERT INTO question VALUES(1329,'TJ815','Welches Hilfsmittel sollten Sie bei präzisen Frequenzmessungen benutzen?',0,1,0,0,'');
INSERT INTO question VALUES(1330,'TJ816','Wenn ein Frequenzzähler für die Überprüfung der Frequenz eines Senders verwendet wird, ist',0,1,0,0,'');
INSERT INTO question VALUES(1331,'TJ817','Welche Konfiguration gewährleistet die höchste Genauigkeit bei der Prüfung der Trägerfrequenz eines FM-Senders?',0,1,0,0,'');
INSERT INTO question VALUES(1332,'TJ818','Ein RTTY-Signal benötigt eine Bandbreite von 3 kHz. Ein Frequenzzähler mit einer Genauigkeit von 1 ppm wird für die Prüfung der Frequenzanzeige eines 145-MHz-Senders verwendet. Wie klein darf der Mindestabstand zur oberen Bandgrenze sein, damit die Aussendung innerhalb des Bandes stattfindet?',0,1,0,0,'');
INSERT INTO question VALUES(1333,'TJ819','Ein Quarznormal hat einen relativen Fehler von F = +/- 0,001 %. Wie genau können Sie eine Frequenz von f = 14100 kHz bestimmen?',0,1,0,0,'');
INSERT INTO question VALUES(1334,'TJ820','Wenn ein Faktor-10-Frequenzteiler vor einem Frequenzzähler geschaltet wird und der Zähler 14,5625 MHz anzeigt, beträgt die tatsächliche Frequenz',0,1,0,0,'');
INSERT INTO question VALUES(1335,'TJ821','Wie misst man das Stehwellenverhältnis? Man misst es',0,1,0,0,'');
INSERT INTO question VALUES(1336,'TJ822','Ein Stehwellenmessgerät wird bei Sendern zur Messung',0,1,0,0,'');
INSERT INTO question VALUES(1337,'TJ823','An welchem Punkt sollte das Stehwellenmessgerät eingeschleift werden, um zu prüfen, ob der Sender gut an die Antennenanlage angepasst ist?<p><img src=''tj823f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1338,'TJ824','Zur Überprüfung eines Stehwellenmessgerätes wird dessen Ausgang mit einem 150-&Omega;-Widerstand abgeschlossen. Welches Stehwellenverhältnis muss das Messgerät anzeigen, wenn die Impedanz von Messgerät und Sender 50 &Omega; beträgt?',0,1,0,0,'');
INSERT INTO question VALUES(1339,'TJ825','Welches Messgerät könnte für den Nachweis von Harmonischen einer Aussendung verwendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(1340,'TJ826','Wann sollten mögliche Oberwellenausstrahlungen überprüft werden?',0,1,0,0,'');
INSERT INTO question VALUES(1341,'TJ827','Worauf deutet die folgende Wellenform der Ausgangsspannung eines Leistungsverstärkers hin?<p><img src=''tj827f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1342,'TJ828','Womit misst man am einfachsten die Hüllkurvenform eines HF-Signals? Man misst es am einfachsten mit einem',0,1,0,0,'');
INSERT INTO question VALUES(1343,'TJ829','Die Pulsbreite wird mit einem Oszilloskop normalerweise bei',0,1,0,0,'');
INSERT INTO question VALUES(1344,'TJ830','Dem Eingang der folgenden Messschaltung wird eine HF-Leistung von 1 Watt zugeführt. D ist eine Schottkydiode mit U<sub>F</sub> = 0,23V. Welche Spannung U<sub>A</sub> ist am Ausgang A zu erwarten, wenn die Messung mit einem hochohmigen Voltmeter erfolgt?<p><img src=''tj830f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1345,'TJ831','Bei der folgenden Schaltung besteht R<sub>1</sub> aus einer Zusammenschaltung von Widerständen, die einen Gesamtwidersand von 50,77 hat und etwa 200 Watt aufnehmen kann. D ist eine Siliziumdiode mit U<sub>F</sub> = 0,7 V. Am Ausgang wird mit einem Digitalvoltmeter eine Gleichspannung von 14,9 V gemessen. Wie groß ist etwa die HF-Leistung am Eingang der Schaltung?<p><img src=''tj831f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1346,'TJ832','Mit der folgenden Schaltung soll die Ausgangsleistung eines 2-m-Handfunkgerätes gemessen werden. D<sub>1</sub> und D<sub>2</sub> sind Schottkydioden mit U<sub>F</sub> = 0,23 V. Am Ausgang wird mit einem Digitalvoltmeter eine Gleichspannung von 15,3 V gemessen. Wie groß ist etwa die HF-Leistung am Eingang der Schaltung?<p><img src=''tj832f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1347,'TJ833','Die Leistung eines 2-m-Senders soll mit einer künstlichen 50-&Omega;-Antenne bestimmt werden, die über eine Anzapfung bei 5 &Omega; vom erdnahen Ende verfügt. Zur Messung an diesem Punkt wird die folgende Schaltung eingesetzt. D<sub>1</sub> und D<sub>2</sub> sind Schottkydioden mit U<sub>F</sub> = 0,23 V. Am Ausgang der Schaltung wird dabei mit einem Digitalvoltmeter eine Gleichspannung von 15,3 V gemessen. Wie groß ist etwa die HF-Leistung des Senders?<p><img src=''tj833f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1348,'TJ834','Das folgende Bild zeigt das Zweiton-SSB-Ausgangssignal eines KW-Senders, das mit einem Oszilloskop ausreichender Bandbreite über einen 10:1-Tastkopf direkt an der angeschlossenen künstlichen 50-&Omega;-Antenne gemessen wurde. Welche Ausgangsleistung (PEP) liefert der Sender?<p><img src=''tj834f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1349,'TJ835','Das folgende Bild zeigt das Zweiton-SSB-Ausgangssignal eines KW-Senders, das mit einem Oszilloskop ausreichender Bandbreite über einen 2:1-Tastkopf direkt an der angeschlossenen künstlichen 50-&Omega;-Antenne gemessen wurde. Welche Ausgangsleistung (PEP) liefert der Sender?<p><img src=''tj835f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1350,'TJ836','Das folgende Bild zeigt das Zweiton-SSB-Ausgangssignal eines KW-Senders, das mit einem Oszilloskop ausreichender Bandbreite über einen 2:1-Tastkopf direkt an der angeschlossenen künstlichen 50-&Omega;-Antenne gemessen wurde. Welche Ausgangsleistung (PEP) liefert der Sender?<p><img src=''tj836f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1351,'TK101','Wie äußert sich Zustopfen bzw. Blockierung eines Empfängers? Es äußert sich durch',0,1,0,0,'');
INSERT INTO question VALUES(1352,'TK102','Welche Effekte werden durch Intermodulation hervorgerufen?',0,1,0,0,'');
INSERT INTO question VALUES(1353,'TK103','Wie kommen Geräusche aus den Lautsprechern einer abgeschalteten Stereoanlage möglicherweise zustande?',0,1,0,0,'');
INSERT INTO question VALUES(1354,'TK104','Ein Sender sollte so betrieben werden, dass',0,1,0,0,'');
INSERT INTO question VALUES(1355,'TK105','In einem NF-Verstärker erfolgt die unerwünschte Gleichrichtung eines HF-Signals wahrscheinlich',0,1,0,0,'');
INSERT INTO question VALUES(1356,'TK106','Alle Geräte, die HF-Ströme übertragen, sollten',0,1,0,0,'');
INSERT INTO question VALUES(1357,'TK107','Durch eine Mantelwellendrossel in einem Fernseh-Antennenzuführungskabel',0,1,0,0,'');
INSERT INTO question VALUES(1358,'TK108','Ein unselektiver TV-Vorverstärker wird am wahrscheinlichsten',0,1,0,0,'');
INSERT INTO question VALUES(1359,'TK109','HF-Einstrahlung in die ZF-Stufe eines Fernsehempfängers führt in der Regel zu',0,1,0,0,'');
INSERT INTO question VALUES(1360,'TK110','Zur Verbesserung der Störfestigkeit gegenüber HF-Einstrahlungen können in einem NF-Leistungsverstärker',0,1,0,0,'');
INSERT INTO question VALUES(1361,'TK111','Welche sofortige Reaktion ist angebracht, wenn der Nachbar sich über HF-Einströmungen beklagt?',0,1,0,0,'');
INSERT INTO question VALUES(1362,'TK112','Ein Fernsehgerät wird durch das Nutzsignal einer KW-Amateurfunkstelle gestört. Wie kann das Signal in das Fernsehgerät eindringen?',0,1,0,0,'');
INSERT INTO question VALUES(1363,'TK113','Ein Funkamateur wohnt in einem Reihenhaus. An welcher Stelle sollte die KW-Drahtantenne angebracht werden, um die Störwahrscheinlichkeit auf ein Mindestmaß zu begrenzen? Sie sollte möglichst',0,1,0,0,'');
INSERT INTO question VALUES(1364,'TK114','Beim Betrieb Ihres 2-m-Senders wird bei einem Ihrer Nachbarn ein Fernsehempfänger gestört, der mit einer Zimmerantenne betrieben wird. Zur Behebung des Problems schlagen Sie dem Nachbarn vor,',0,1,0,0,'');
INSERT INTO question VALUES(1365,'TK115','Während des Betriebs eines tragbaren KW-Transceivers mit Batterieversorgung treten zu Hause und unter Verwendung der ortsfesten Antenne bei einer elektronischen Orgel Störungen auf. Eine mögliche Ursache hierfür',0,1,0,0,'');
INSERT INTO question VALUES(1366,'TK116','In welcher Entfernung von einer 70-cm-Sendeantenne sollte eine Fernsehantenne installiert werden, um das Störpotenzial möglichst gering zu halten? Sie sollte',0,1,0,0,'');
INSERT INTO question VALUES(1367,'TK117','Ein starkes HF-Signal gelangt in die ZF-Stufe des Rundfunkempfängers des Nachbarn. Dieses Phänomen wird als',0,1,0,0,'');
INSERT INTO question VALUES(1368,'TK118','Die Bemühungen, die durch eine in der Nähe befindliche Amateurfunkstelle hervorgerufenen Fernsehstörungen zu verringern, sind fehlgeschlagen. Als nächster Schritt ist',0,1,0,0,'');
INSERT INTO question VALUES(1369,'TK119','Während einer ATV-Aussendung erscheint das Bild auch auf dem Fernsehgerät der Nachbarn. Eine mögliche Abhilfe der Störung wäre die',0,1,0,0,'');
INSERT INTO question VALUES(1370,'TK120','Bei einem Besuch beim Nachbarn zur Prüfung von Fernsehrundfunkstörungen ist zunächst',0,1,0,0,'');
INSERT INTO question VALUES(1371,'TK201','Die Übersteuerung eines Leistungsverstärkers führt zu',0,1,0,0,'');
INSERT INTO question VALUES(1372,'TK202','In HF-Schaltungen können Nebenresonanzen durch die',0,1,0,0,'');
INSERT INTO question VALUES(1373,'TK203','Diese Modulationshüllkurve eines CW-Senders sollte vermieden werden, da<p><img src=''tk203f.png''></p>',0,1,0,0,'');
INSERT INTO question VALUES(1374,'TK204','Bei einem Sender mit mehr als 2,5 mW Ausgangsleistung sollte die Dämpfung der Oberwellen im Frequenzbereich 1,7-35 MHz mindestens',0,1,0,0,'');
INSERT INTO question VALUES(1375,'TK205','Durch welche Maßnahme können Tastklicks verringert werden? Durch',0,1,0,0,'');
INSERT INTO question VALUES(1376,'TK206','Die gesamte Bandbreite einer FM-Aussendung beträgt 15 kHz. Wie groß ist der Abstand der Mittenfrequenz von der Bandgrenze mindestens zu wählen, damit die Aussendung innerhalb des Bandes bleibt?',0,1,0,0,'');
INSERT INTO question VALUES(1377,'TK207','Durch welche Maßnahme kann die übermäßige Bandbreite einer FM-Aussendung verringert werden? Durch die Verringerung der',0,1,0,0,'');
INSERT INTO question VALUES(1378,'TK208','Parasitäre Schwingungen können Störungen hervorrufen. Man erkennt sie auch daran, dass sie',0,1,0,0,'');
INSERT INTO question VALUES(1379,'TK209','Um Bandbreite einzusparen sollte der Frequenzumfang eines NF-Sprachsignals, das an einen Modulator angelegt wird,',0,1,0,0,'');
INSERT INTO question VALUES(1380,'TK210','Wenn HF-Signale unerwünscht auf einen VFO zurückkoppeln, kann dies zu',0,1,0,0,'');
INSERT INTO question VALUES(1381,'TK211','Das Nutzsignal eines 144-MHz-Senders verursacht die Übersteuerung eines in der Nähe befindlichen UHF-Fernsehempfängers. Das Problem lässt sich durch den Einbau eines',0,1,0,0,'');
INSERT INTO question VALUES(1382,'TK212','Um Oberwellenausstrahlungen eines UHF-Senders zu minimieren, sollte dem Gerät',0,1,0,0,'');
INSERT INTO question VALUES(1383,'TK213','Ein SSB-Sender wird Störungen auf benachbarten Frequenzen hervorrufen, wenn',0,1,0,0,'');
INSERT INTO question VALUES(1384,'TK214','Im 144-MHz-Bereich werden Störungen festgestellt, die von einem quarzgesteuerten 432-MHz-Sender verursacht werden, dessen Quarzoszillator bei etwa 12 MHz schwingt. Die Oszillatorfrequenz wird in mehreren Stufen vervielfacht. Bei welcher Kombination der Vervielfacher tritt die Störung auf? Die Störung tritt auf bei der Kombination',0,1,0,0,'');
INSERT INTO question VALUES(1385,'TK215','Bei der Hi-Fi-Anlage des Nachbarn wird Einströmung in die NF festgestellt. Eine mögliche Abhilfe wäre',0,1,0,0,'');
INSERT INTO question VALUES(1386,'TK216','Bei einem Wohnort in einem Ballungsgebiet empfiehlt es sich, während der abendlichen Fernsehstunden',0,1,0,0,'');
INSERT INTO question VALUES(1387,'TK217','Falls sich eine Sendeantenne in der Nähe und parallel zu einer 230-V-Wechselstrom-Freileitung befindet,',0,1,0,0,'');
INSERT INTO question VALUES(1388,'TK218','Zur Verhinderung von Fernsehstörungen, die durch Mantelwellen hervorgerufen werden, ist anstelle einer Mantelwellendrossel alternativ',0,1,0,0,'');
INSERT INTO question VALUES(1389,'TK219','Eine 435-MHz-Sendeantenne mit hohem Gewinn ist unmittelbar auf eine UHF-Fernseh-Empfangsantenne gerichtet. Dies führt gegebenenfalls zu',0,1,0,0,'');
INSERT INTO question VALUES(1390,'TK220','Im Mittelwellenbereich ergeben sich häufig Spiegelfrequenzstörungen durch',0,1,0,0,'');
INSERT INTO question VALUES(1391,'TK221','Ein korrodierter Anschluss an der Fernseh-Empfangsantenne des Nachbarn',0,1,0,0,'');
INSERT INTO question VALUES(1392,'TK222','Eine 435-MHz-Sendeantenne mit 1 kW ERP ist unmittelbar auf die Fernsehantenne des Nachbarn gerichtet. Dies führt gegebenenfalls',0,1,0,0,'');
INSERT INTO question VALUES(1393,'TK301','Um die Störwahrscheinlichkeit zu verringern, sollte die benutzte Sendeleistung',0,1,0,0,'');
INSERT INTO question VALUES(1394,'TK302','Wie kann man hochfrequente Störungen reduzieren, die durch Harmonische hervorgerufen werden? Sie können reduziert werden durch ein',0,1,0,0,'');
INSERT INTO question VALUES(1395,'TK303','Welchen Frequenzgang sollte ein Filter zur Verringerung der Oberwellenausgangsleistung eines KW-Senders haben?',0,1,0,0,'');
INSERT INTO question VALUES(1396,'TK304','Welches Filter sollte im Störungsfall für die Dämpfung von Kurzwellensignalen in ein Fernsehantennenkabel eingeschleift werden?',0,1,0,0,'');
INSERT INTO question VALUES(1397,'TK305','Was sollte zur Herabsetzung starker Signale eines 21-MHz-Senders in das Fernseh-Antennenzuführungskabel eingeschleift werden?',0,1,0,0,'');
INSERT INTO question VALUES(1398,'TK306','Welches Filter sollte im Störungsfall vor die einzelnen Leitungsanschlüsse eines UKW oder Fernsehrundfunkgeräts oder angeschlossener Geräte eingeschleift werden, um Kurzwellensignale zu dämpfen?',0,1,0,0,'');
INSERT INTO question VALUES(1399,'TK307','Die Signale eines 144-MHz-Senders werden in das Abschirmgeflecht des Antennenkabels eines FM-Rundfunkempfängers induziert und verursachen Störungen. Eine Möglichkeit zur Verringerung der Störungen besteht darin,',0,1,0,0,'');
INSERT INTO question VALUES(1400,'TK308','Um die Störwahrscheinlichkeit im eigenen Haus zu verringern, empfiehlt es sich vorzugsweise',0,1,0,0,'');
INSERT INTO question VALUES(1401,'TK309','Erdleitungen sollten immer',0,1,0,0,'');
INSERT INTO question VALUES(1402,'TK310','Eine KW-Amateurfunkstelle verursacht im Sendebetrieb in einem in der Nähe betriebenen Fernsehempfänger Störungen. Welches Filter sollte man am besten in das Fernsehantennenkabel einschleifen, um die Störwahrscheinlichkeit zu verringern?',0,1,0,0,'');
INSERT INTO question VALUES(1403,'TK311','Die Einfügungsdämpfung im Durchlassbereich eines passiven Hochpassfilters für ein Fernsehantennenkabel sollte',0,1,0,0,'');
INSERT INTO question VALUES(1404,'TK312','Ein Nachbar beschwert sich über Störungen seines Fernsehempfängers, die allerdings auch bei abgeschalteter TV-Antenne auftreten. Die Störungen fallen zeitlich mit den Übertragungszeiten des Funkamateurs zusammen. Als erster Schritt',0,1,0,0,'');
INSERT INTO question VALUES(1405,'TK313','Welches der nachfolgenden Filter könnte vor einem Netzanschlusskabel eingeschleift werden, um darüber fließende HF-Ströme wirksam zu dämpfen?',0,1,0,0,'');
INSERT INTO question VALUES(1406,'TK314','Beim Betrieb eines Funkempfängers mit digitalen Schaltungen auf einer gedruckten Leiterplatte treten erhebliche Störungen auf. Diese könnten verringert werden, indem die Leiterplatte',0,1,0,0,'');
INSERT INTO question VALUES(1407,'TK315','In einer Babyüberwachungsanlage mit zwei Geräten, die über ein langes Zwillingslitzenkabel miteinander verbunden sind, treten Störungen durch den Betrieb eines nahen Senders auf. Eine Möglichkeit zur Verringerung der Beeinflussungen besteht darin,',0,1,0,0,'');
INSERT INTO question VALUES(1408,'TK316','Welche Art von Kondensatoren sollte zum Abblocken von HF-Spannungen vorzugsweise verwendet werden? Am besten verwendet man',0,1,0,0,'');
INSERT INTO question VALUES(1409,'TK317','Um etwaige Funkstörungen auf Nachbarfrequenzen zu begrenzen, sollte bei Telefonie die höchste zu übertragende NF-Frequenz',0,1,0,0,'');
INSERT INTO question VALUES(1410,'TK318','In den nachfolgenden Bildern sind mögliche Signalverläufe des Senderausgangssignals bei der CW-Tastung dargestellt. Welcher Signalverlauf führt zu den geringsten Störungen?',0,1,0,0,'');
INSERT INTO question VALUES(1411,'TL101','In Bezug auf EMV sollten Vervielfacherstufen',0,1,0,0,'');
INSERT INTO question VALUES(1412,'TL102','Um eine Amateurfunkstelle in Bezug auf EMV zu optimieren',0,1,0,0,'');
INSERT INTO question VALUES(1413,'TL103','Ein Sender ist mittels eines kurzen Koaxialkabels an eine Kollinearantenne mit 6 dB Gewinn angeschlossen. Wenn die der Antenne zugeführte Ausgangsleistung auf 5 W verringert wird, treten keine Störungen der Hi-Fi-Anlage des Nachbarn auf. Die Strahlungsleistung entspricht dabei einer ERP von',0,1,0,0,'');
INSERT INTO question VALUES(1414,'TL201','Sie besitzen eine &lambda;/4-Vertikalantenne. Da Sie für diese Antenne keine Selbsterklärung abgeben möchten und somit nur eine Strahlungsleistung von weniger als 10 W EIRP verwenden dürfen, müssen Sie die Sendeleistung soweit reduzieren, dass Sie unter diesem Wert bleiben. Wie groß darf die Sendeleistung ohne Berücksichtigung der Kabelverluste dabei sein?',0,1,0,0,'');
INSERT INTO question VALUES(1415,'TL202','Eine Amateurfunkstelle sendet in FM mit einer äquivalenten Strahlungsleistung (ERP) von 100 W. Wie groß ist die Feldstärke im freien Raum in einer Entfernung von 100 m?',0,1,0,0,'');
INSERT INTO question VALUES(1416,'TL203','Sie möchten den Personenschutz-Sicherheitsabstand für die Antenne Ihrer Amateurfunkstelle für das 20-m-Band und die Betriebsart RTTY berechnen. Der Grenzwert im Fall des Personenschutzes beträgt 28 V/m. Sie betreiben einen Dipol, der von einem Sender mit einer Leistung von 700 W über ein Koaxialkabel gespeist wird. Die Kabeldämpfung beträgt 0,5 dB. Wie groß ist der Sicherheitsabstand?',0,1,0,0,'');
INSERT INTO question VALUES(1417,'TL204','Sie möchten den Personenschutz-Sicherheitsabstand für die Antenne Ihrer Amateurfunkstelle für das 2-m-Band und die Betriebsart FM berechnen. Der Grenzwert im Fall des Personenschutzes beträgt 28 V/m. Sie betreiben eine Yagi-Antenne mit einem Gewinn von 10,5 dBd. Die Antenne wird von einem Sender mit einer Leistung von 100 W über ein Koaxialkabel gespeist. Die Kabeldämpfung beträgt 1,5 dB. Wie groß ist der Sicherheitsabstand?',0,1,0,0,'');
INSERT INTO question VALUES(1418,'TL205','Sie möchten den Personenschutz-Sicherheitsabstand für die Antenne Ihrer Amateurfunkstelle für das 20-m-Band und die Betriebsart RTTY berechnen. Der Grenzwert im Fall des Personenschutzes beträgt 28 V/m. Sie betreiben einen Dipol, der von einem Sender mit einer Leistung von 300 W über ein Koaxialkabel gespeist wird. Die Kabeldämpfung beträgt 0,5 dB. Wie groß ist der Sicherheitsabstand?',0,1,0,0,'');
INSERT INTO question VALUES(1419,'TL206','Sie möchten den Personenschutz-Sicherheitsabstand für die Antenne Ihrer Amateurfunkstelle für das 10-m-Band und die Betriebsart RTTY berechnen. Der Grenzwert im Fall des Personenschutzes beträgt 28 V/m. Sie betreiben einen Dipol, der von einem Sender mit einer Leistung von 100 W über ein Koaxialkabel gespeist wird. Die Kabeldämpfung sei vernachlässigbar. Wie groß muss der Sicherheitsabstand sein?',0,1,0,0,'');
INSERT INTO question VALUES(1420,'TL207','Sie möchten den Personenschutz-Sicherheitsabstand für die Antenne Ihrer Amateurfunkstelle für das 10-m-Band und die Betriebsart FM berechnen. Der Grenzwert im Fall des Personenschutzes beträgt 28 V/m. Sie betreiben eine Yagi-Antenne mit einem Gewinn von 7,5 dBd. Die Antenne wird von einem Sender mit einer Leistung von 100 W über ein langes Koaxialkabel gespeist. Die Kabeldämpfung beträgt 1,5 dB. Wie groß muss der Sicherheitsabstand sein?',0,1,0,0,'');
INSERT INTO question VALUES(1421,'TL208','Sie möchten den Personenschutz-Sicherheitsabstand für die Antenne Ihrer Amateurfunkstelle in Hauptstrahlrichtung für das 2-m-Band und die Betriebsart FM berechnen. Der Grenzwert im Fall des Personenschutzes beträgt 28 V/m. Sie betreiben eine Yagi-Antenne mit einem Gewinn von 11,5 dBd. Die Antenne wird von einem Sender mit einer Leistung von 75 W über ein Koaxialkabel gespeist. Die Kabeldämpfung beträgt 1,5 dB. Wie groß muss der Sicherheitsabstand sein?',0,1,0,0,'');
INSERT INTO question VALUES(1422,'TL209','Warum ist im Nahfeld einer Strahlungsquelle keine einfache Umrechnung zwischen den Feldgrößen E, H und S und damit auch keine vereinfachte Berechnung des Schutzabstandes möglich?',0,1,0,0,'');
INSERT INTO question VALUES(1423,'TL210','Sie errechnen einen Sicherheitsabstand für Ihre Antenne. Von welchem Punkt aus muss dieser Sicherheitsabstand eingehalten werden, wenn Sie bei der Berechnung die Fernfeldnäherung verwendet haben? Er muss eingehalten werden',0,1,0,0,'');
INSERT INTO question VALUES(1424,'TL211','Wie errechnen Sie die Leistung am Einspeisepunkt der Antenne (Antenneneingangsleistung) bei bekannter Senderausgangsleistung?',0,1,0,0,'');
INSERT INTO question VALUES(1425,'TL212','Für Ihre Yagi-Antenne, die an einem hohen Mast befestigt ist, beträgt der Sicherheitsabstand in Hauptstrahlrichtung 20 m. Da die Antenne jedoch über gefährdete Orte hinweg strahlt, dringt nur ein Teil des Feldes in den Bereich unterhalb der Antenne. Sie ermitteln einen kritischen Winkel von 40° und ersehen im Strahlungsdiagramm der Antenne eine Winkeldämpfung von 6 dB. Auf welchen Wert verringert sich dann der Sicherheitsabstand?',0,1,0,0,'');
INSERT INTO question VALUES(1426,'TL213','Wann hat die folgende Formel zur Berechnung des Sicherheitsabstandes Gültigkeit und was sollten Sie tun, wenn die Gültigkeit nicht mehr sichergestellt ist?<br> d = sqrt(30 &Omega; * P<sub>EIRP</sub>) / E',0,1,0,0,'');
INSERT INTO question VALUES(1427,'TL214','Mit welcher Ausgangsleistung rechnen Sie im Fall des Personenschutzes, um den Sicherheitsabstand zu ermitteln?',0,1,0,0,'');
INSERT INTO question VALUES(1428,'TL215','Sie betreiben eine Amateurfunkstelle auf dem 2-m-Band mit einer Rundstrahlantenne mit 6 dB Gewinn über dem Dipol. Wie hoch darf die maximale Ausgangsleistung Ihres Senders unter Vernachlässigung der Kabeldämpfung sein, wenn der Grenzwert für den Personenschutz 28 V/m und der zur Verfügung stehende Sicherheitsabstand 5 m beträgt.',0,1,0,0,'');
INSERT INTO question VALUES(1429,'TL216','Muss ein Funkamateur als Betreiber einer ortsfesten 2-m-Amateurfunkstelle bei der Sendeart F3E und einer Senderleistung von 6 Watt an einer 15-Element-Yagiantenne mit 13 dB Gewinn und vernachlässigbaren Kabelverlusten die Einhaltung der Personenschutzgrenzwerte nachweisen?',0,1,0,0,'');
INSERT INTO question VALUES(1430,'TL217','Für den Schutz von Trägern aktiver medizinischer Implantate sind auch die Grenzwerte zum Schutz von Herzschrittmacherträgern zu beachten. Welcher Wert der Feldstärke einer Amateurfunkstelle ist mit diesem Grenzwert direkt vergleichbar?',0,1,0,0,'');
INSERT INTO question VALUES(1431,'TL218','Herzschrittmacher können auch durch die Aussendung einer Amateurfunkstelle beeinflusst werden. Gibt es einen zeitlichen Grenzwert für die Einwirkdauer?',0,1,0,0,'');
INSERT INTO question VALUES(1432,'TL301','Unter welchen Bedingungen darf das Standrohr einer Amateurfunkantenne auf einem Gebäude mit einer vorhandenen Blitzschutzanlage verbunden werden?',0,1,0,0,'');
INSERT INTO question VALUES(1433,'TL302','Welches Material und welcher Mindestquerschnitt ist bei einer Erdungsleitung zwischen einem Antennenstandrohr und einer Erdungsanlage nach DIN VDE 0855 Teil 300 für Funksender bis 1 kW zu verwenden?',0,1,0,0,'');
INSERT INTO question VALUES(1434,'TL303','Unter welchen Bedingungen darf ein Fundamenterder als Blitzschutzerder verwendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(1435,'TL304','Welche Sicherheitsmaßnahmen müssen zum Schutz gegen atmosphärische Überspannungen und zur Verhinderung von Spannungsunterschieden bei Koaxialkabel-Niederführungen ergriffen werden?',0,1,0,0,'');
INSERT INTO question VALUES(1436,'TL305','Welche der Antworten a bis d enthält die heutzutage normgerechten Adern-Kennfarben von 3-adrigen, isolierten Energieleitungen und -kabeln in der Abfolge: Schutzleiter, Außenleiter, Neutralleiter?',0,1,0,0,'');
INSERT INTO question VALUES(1437,'TL306','Damit die Zulassung eines Kraftfahrzeugs nicht ungültig wird, sind vor dem Einbau einer mobilen Sende-/Empfangseinrichtung grundsätzlich',0,1,0,0,'');
INSERT INTO question VALUES(1438,'TL307','Um ein Zusammenwirken mit der Elektronik des Kraftfahrzeugs zu verhindern, sollte das Antennenkabel',0,1,0,0,'');
INSERT INTO question VALUES(1439,'BA101','Wie soll im Telefoniefunkverkehr verhindert werden, dass ähnlich lautende Rufzeichen verwechselt oder missverstanden werden können? Dies wird verhindert durch',0,1,0,0,'');
INSERT INTO question VALUES(1440,'BA102','Wie ist das Wort "München" mit dem internationalen Buchstabieralphabet richtig zu buchstabieren?',0,1,0,0,'');
INSERT INTO question VALUES(1441,'BA103','Wie ist das Wort "Travemünde" mit dem internationalen Buchstabieralphabet richtig zu buchstabieren?',0,1,0,0,'');
INSERT INTO question VALUES(1442,'BA104','Wie ist das Rufzeichen DO9XYZ unter Zuhilfenahme des Internationalen Buchstabieralphabetes richtig buchstabiert?',0,1,0,0,'');
INSERT INTO question VALUES(1443,'BA105','Wie ist das Rufzeichen DH8DAP unter Zuhilfenahme des Internationalen Buchstabieralphabetes richtig buchstabiert?',0,1,0,0,'');
INSERT INTO question VALUES(1444,'BA106','Wie wird das Rufzeichen DL2KCI mit dem internationalen Buchstabieralphabet richtig buchstabiert?',0,1,0,0,'');
INSERT INTO question VALUES(1445,'BA107','Wie ist das Rufzeichen DF3DCB mit dem internationalen Buchstabieralphabet zu buchstabieren?',0,1,0,0,'');
INSERT INTO question VALUES(1446,'BA108','Wie ist das Rufzeichen "EA5/DJ4UF" mit dem internationalen Buchstabieralphabet richtig zu buchstabieren?',0,1,0,0,'');
INSERT INTO question VALUES(1447,'BA109','Wie ist das Rufzeichen "PY8JW" mit dem internationalen Buchstabieralphabet richtig zu buchstabieren?',0,1,0,0,'');
INSERT INTO question VALUES(1448,'BA110','Wie ist das Rufzeichen "YO9XH" mit dem internationalen Buchstabieralphabet richtig zu buchstabieren?',0,1,0,0,'');
INSERT INTO question VALUES(1449,'BA111','Wie ist das Rufzeichen "HB0/DK1DN/p" mit dem internationalen Buchstabieralphabet richtig zu buchstabieren?',0,1,0,0,'');
INSERT INTO question VALUES(1450,'BB101','Warum werden in Telegrafie- und Fernschreib-Betriebsarten Betriebsabkürzungen und Q-Gruppen verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(1451,'BB102','Welche Bedeutung hat für Sie als deutsche Amateurfunkstelle auf Kurzwelle die Abkürzung "DX"?',0,1,0,0,'');
INSERT INTO question VALUES(1452,'BB103','Was bedeuten die gebräuchlichen Abkürzungen "TX", "RX" in dieser Reihenfolge?',0,1,0,0,'');
INSERT INTO question VALUES(1453,'BB104','Was bedeutet die Betriebsabkürzung CQ?',0,1,0,0,'');
INSERT INTO question VALUES(1454,'BB105','Was bedeutet die Betriebsabkürzung CW?',0,1,0,0,'');
INSERT INTO question VALUES(1455,'BB106','Sie hören KA2WEU in Morsetelegrafie rufen: „CQ DL CQ DL DE KA2WEU PSE K“. Was beabsichtigt er damit?',0,1,0,0,'');
INSERT INTO question VALUES(1456,'BB107','Was bedeutet die Betriebsabkürzung „R“ am Anfang eines Durchgangs?',0,1,0,0,'');
INSERT INTO question VALUES(1457,'BB108','Was bedeutet die Betriebsabkürzung „K“ am Ende eines Durchgangs in Telegrafie?',0,1,0,0,'');
INSERT INTO question VALUES(1458,'BB109','Was bedeutet die Betriebsabkürzung „BK“ in Telegrafie?',0,1,0,0,'');
INSERT INTO question VALUES(1459,'BB110','Wie gestalten Sie als DO1LEN einen allgemeinen Anruf in Telegrafie?',0,1,0,0,'');
INSERT INTO question VALUES(1460,'BB111','Was bedeutet die Betriebsabkürzung „MSG“?',0,1,0,0,'');
INSERT INTO question VALUES(1461,'BB201','Warum wurden die Q-Gruppen im Funkverkehr eingeführt? Sie wurden eingeführt',0,1,0,0,'');
INSERT INTO question VALUES(1462,'BB202','Sollen Sie im Sprechfunkverkehr Abkürzungen aus den Q-Gruppen oder aus den anderen Abkürzungen im Funkverkehr verwenden?',0,1,0,0,'');
INSERT INTO question VALUES(1463,'BB203','Welche Bedeutung haben in der gleichen Reihenfolge gelesen die Q-Gruppen "QRV" , "QRM?" und "QTH" ?',0,1,0,0,'');
INSERT INTO question VALUES(1464,'BB204','Was bedeutet es, wenn Ihr Funkpartner meldet: „QRK 1“? Er meint damit, dass',0,1,0,0,'');
INSERT INTO question VALUES(1465,'BB205','Was bedeuten die Q-Gruppen "QRT" , "QRZ?" und "QSL?" ?',0,1,0,0,'');
INSERT INTO question VALUES(1466,'BB206','Welche Bedeutung haben in der gleichen Reihenfolge gelesen die Q-Gruppen "QRO?" , "QSO?" und "QRX?" ?',0,1,0,0,'');
INSERT INTO question VALUES(1467,'BB207','Welche Bedeutung haben in der gleichen Reihenfolge gelesen die Q-Gruppen "QRM" , "QRN" und "QSB?" ?',0,1,0,0,'');
INSERT INTO question VALUES(1468,'BB208','Wie verhalten Sie sich, wenn Sie von der Gegenstation aufgefordert werden: "pse qsy"?',0,1,0,0,'');
INSERT INTO question VALUES(1469,'BB209','Wie verhalten Sie sich, wenn Sie von der Gegenstation aufgefordert werden: "pse qrp"?',0,1,0,0,'');
INSERT INTO question VALUES(1470,'BB301','Was versteht man unter dem RST-Rapport? Es ist eine Kurzformel,',0,1,0,0,'');
INSERT INTO question VALUES(1471,'BB302','Was bedeuten die Buchstaben RST, mit denen Sie die Sendung Ihrer Gegenstation beurteilen können?',0,1,0,0,'');
INSERT INTO question VALUES(1472,'BB303','Um wie viel S-Stufen müsste die S-Meter- Anzeige Ihres Empfängers steigen, wenn Ihr Partner die Sendeleistung von 100 Watt auf 400 Watt erhöht?',0,1,0,0,'');
INSERT INTO question VALUES(1473,'BB304','Wie groß ist der Unterschied zwischen S4 und S7 in Dezibel?',0,1,0,0,'');
INSERT INTO question VALUES(1474,'BB305','In welcher Weise werden nach dem RST-System die Aussendungen einer Amateurfunkstelle beurteilt?',0,1,0,0,'');
INSERT INTO question VALUES(1475,'BB306','Um wie viel dB ist die Empfängereingangsspannung abgesunken, wenn die S-Meter- Anzeige durch Änderung der Ausbreitungsbedingungen von S9+20 dB auf S8 zurückgeht? Die Empfängereingangsspannung sinkt um',0,1,0,0,'');
INSERT INTO question VALUES(1476,'BB307','Durch "Fading" sinkt die S-Meter-Anzeige von S9 auf S8. Auf welchen Wert sinkt dabei die Empfänger-Eingangsspannung ab, wenn bei S9 am Empfängereingang 50µV anliegen? Die Empfänger-Eingangsspannung sinkt auf',0,1,0,0,'');
INSERT INTO question VALUES(1477,'BB308','Bei einer SSB-Verbindung auf VHF/UHF sagt Ihnen Ihr Gesprächspartner: "Ich empfange Sie mit R5 und 30 dB über Rauschen". Was meint er damit?',0,1,0,0,'');
INSERT INTO question VALUES(1478,'BB309','Sie bekommen von Ihrer Gegenstation den Rapport „4 und 8“. Was sagt Ihnen der Rapport?',0,1,0,0,'');
INSERT INTO question VALUES(1479,'BB310','Eine Station kommt mit einem schwachen, störungsbehafteten Signal bei Ihnen an. Welchen Rapport geben Sie?',0,1,0,0,'');
INSERT INTO question VALUES(1480,'BB311','Wie wird ein Aurora-Signal in Telegrafie beurteilt? Es wird beurteilt mit',0,1,0,0,'');
INSERT INTO question VALUES(1481,'BB312','Wie wird ein SSTV-Signal beurteilt? Es wird beurteilt mit',0,1,0,0,'');
INSERT INTO question VALUES(1482,'BB401','Wie wird "Morsetelegrafie, Zweiseitenband, ein einziger Kanal, der quantisierte oder digitale Information enthält, ohne Verwendung eines modulierten Hilfsträgers", bezeichnet?',0,1,0,0,'');
INSERT INTO question VALUES(1483,'BB402','Wie wird "Frequenzmodulation mit analogen Signalen, für Sprachübertragung" bezeichnet?',0,1,0,0,'');
INSERT INTO question VALUES(1484,'BB403','Wie wird "Einseitenbandmodulation mit analogen Signalen für Sprachübertragung" (SSB) bezeichnet?',0,1,0,0,'');
INSERT INTO question VALUES(1485,'BB404','Wie wird "Morsetelegrafie unter Verwendung eines modulierenden Hilfsträgers" bezeichnet?',0,1,0,0,'');
INSERT INTO question VALUES(1486,'BB405','Wie wird "Fernschreibtelegrafie unter Verwendung eines modulierenden Hilfsträgers" (RTTY) bezeichnet?',0,1,0,0,'');
INSERT INTO question VALUES(1487,'BB406','Wie wird "Fernsehen (Video), Restseitenbandübertragung mit analogen Signalen" bezeichnet?',0,1,0,0,'');
INSERT INTO question VALUES(1488,'BB407','Wie wird die im Amateurfunk verwendete Betriebsart "PACTOR" nach den Vorgaben der Radio Regulations (VO Funk) bezeichnet?',0,1,0,0,'');
INSERT INTO question VALUES(1489,'BC101','Welchen Frequenzbereich umfasst das 13-cm-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(1490,'BC102','Welchen Frequenzbereich umfasst das 23-cm-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(1491,'BC103','Welchen Frequenzbereich umfasst das 70-cm-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(1492,'BC104','Welchen Frequenzbereich umfasst das 2-m-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(1493,'BC105','Welchen Frequenzbereich umfasst das 6-m-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(1494,'BC106','Welchen Frequenzbereich umfasst das 10-m-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(1495,'BC107','Welchen Frequenzbereich umfasst das 12-m-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(1496,'BC108','Welchen Frequenzbereich umfasst das 15-m-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(1497,'BC109','Welchen Frequenzbereich umfasst das 17-m-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(1498,'BC110','Welchen Frequenzbereich umfasst das 20-m-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(1499,'BC111','Welchen Frequenzbereich umfasst das 30-m-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(1500,'BC112','Welchen Frequenzbereich umfasst das 40-m-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(1501,'BC113','Welchen Frequenzbereich umfasst das 80-m-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(1502,'BC114','Welchen Frequenzbereich umfasst das 160-m-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(1503,'BC201','Welchen Verbindlichkeitsgrad haben die von der IARU (Internationale Amateur Radio Union) aufgestellten Bandpläne?',0,1,0,0,'');
INSERT INTO question VALUES(1504,'BC202','Dürfen Sie im Bereich 145,800 - 146,000 MHz lokalen Funkverkehr abwickeln?',0,1,0,0,'');
INSERT INTO question VALUES(1505,'BC203','Auf welcher Frequenz würden Sie im 2-Meter-Band ein Telefonie QSO führen und zwar 1. in SSB und 2. in FM?',0,1,0,0,'');
INSERT INTO question VALUES(1506,'BC204','Sie rufen auf der Frequenz 144,300 MHz CQ und erhalten einen Anruf. Was tun Sie als nächstes?',0,1,0,0,'');
INSERT INTO question VALUES(1507,'BC205','Welches ist die internationale Anruffrequenz für SSB im 2-m-Band?',0,1,0,0,'');
INSERT INTO question VALUES(1508,'BC206','Sie hören eine französische Station auf 10,143 MHz in SSB CQ rufen. Dürfen Sie in SSB antworten?',0,1,0,0,'');
INSERT INTO question VALUES(1509,'BC207','Sie möchten im 2-m-Band ein SSB-QSO führen. Wie verhalten Sie sich?',0,1,0,0,'');
INSERT INTO question VALUES(1510,'BC208','Ist die Annahme richtig, dass man in den Satellitenbereichen z.B. des 2-m- oder 70- cm-Bandes mit einem Handfunkgerät lokalen Funkverkehr in F3E (FM) abwickeln kann, weil die Reichweite zu gering ist, einen Satelliten zu stören?',0,1,0,0,'');
INSERT INTO question VALUES(1511,'BC209','Welches Seitenband wird bei SSB-Betrieb im 80-m-Band in der Regel benutzt?',0,1,0,0,'');
INSERT INTO question VALUES(1512,'BC210','Welches Seitenband wird bei SSB-Betrieb im 20-m-Band in der Regel benutzt?',0,1,0,0,'');
INSERT INTO question VALUES(1513,'BC211','Welche nachstehend aufgeführten Frequenzbereiche des 80-m- und des 15-m- Bandes sollen auf Empfehlung der Internationalen Amateur Radio Union bevorzugt nur für Morsetelegrafie genutzt werden?',0,1,0,0,'');
INSERT INTO question VALUES(1514,'BC212','Welcher Frequenzbereich soll im 20-m-Band auf Empfehlung der Internationalen Amateur Radio Union bevorzugt für SSB genutzt werden?',0,1,0,0,'');
INSERT INTO question VALUES(1515,'BC213','Wie gehen Sie vor, wenn Sie auf Kurzwelle Funkbetrieb in einer neuen digitalen Betriebsart machen wollen?',0,1,0,0,'');
INSERT INTO question VALUES(1516,'BC214','Aus welchem Grund sollten Sie in der Dunkelheit und im Winter auch tagsüber im Bereich von 3500-3510 kHz keine innerdeutschen oder innereuropäischen Telegrafie- QSOs durchführen?',0,1,0,0,'');
INSERT INTO question VALUES(1517,'BC215','Aus welchem Grund sollten Sie in der Dunkelheit und im Winter auch tagsüber im Bereich von 3775-3800 kHz keine innerdeutschen oder innereuropäischen SSB-QSOs durchführen?',0,1,0,0,'');
INSERT INTO question VALUES(1518,'BC216','Welche Bereiche des 10-m- und des 40-m- Bandes stehen nach den Empfehlungen der International Amateur Radio Union ausschließlich für die Betriebsart Telegrafie zur Verfügung?',0,1,0,0,'');
INSERT INTO question VALUES(1519,'BC217','Welche Bereiche des 15-m-, des 20-m- und des 80-m-Bandes stehen nach den Empfehlungen der International Amateur Radio Union ausschließlich für die Betriebsart Telegrafie zur Verfügung?',0,1,0,0,'');
INSERT INTO question VALUES(1520,'BC218','In welchen Bereichen des 2-m- und 70-cm- Bandes arbeiten Amateurfunksatelliten?',0,1,0,0,'');
INSERT INTO question VALUES(1521,'BC219','In welchem Bereich des 2-m-Bandes dürfen Sie keinen Sendebetrieb machen, weil dort Funkbaken senden? Es ist der Frequenzbereich',0,1,0,0,'');
INSERT INTO question VALUES(1522,'BC220','Welche Frequenzen sind wegen des Betriebs der Funkbaken des internationalen Bakenprojektes (IBP) freizuhalten?',0,1,0,0,'');
INSERT INTO question VALUES(1523,'BD101','Was erkennen Sie aus dem Rufzeichen DO9RST/MM?',0,1,0,0,'');
INSERT INTO question VALUES(1524,'BD102','Was erkennen Sie aus dem Rufzeichen DA5XX?',0,1,0,0,'');
INSERT INTO question VALUES(1525,'BD103','Was erkennen Sie aus dem Rufzeichen DAØXX?',0,1,0,0,'');
INSERT INTO question VALUES(1526,'BD104','Was erkennen Sie aus dem Rufzeichen DPØXX?',0,1,0,0,'');
INSERT INTO question VALUES(1527,'BD105','Was erkennen Sie aus dem Rufzeichen DP1XX?',0,1,0,0,'');
INSERT INTO question VALUES(1528,'BD106','Was bedeuten die Rufzeichenzusätze "/p" und "/m" bei einer Amateurfunkstelle?',0,1,0,0,'');
INSERT INTO question VALUES(1529,'BD107','In welcher Form muss ein Funkamateur aus einem Land, das die CEPT-Empfehlung T/R 61-01 anwendet, sein Heimatrufzeichen beim Betrieb einer Amateurfunkstelle in Deutschland ergänzen?',0,1,0,0,'');
INSERT INTO question VALUES(1530,'BD108','In welcher Form muss ein Funkamateur aus einem Land, das die ECC-Empfehlung (05)06 anwendet, sein Heimatrufzeichen beim Betrieb einer Amateurfunkstelle in Deutschland ergänzen?',0,1,0,0,'');
INSERT INTO question VALUES(1531,'BD109','Muss beim Betrieb einer tragbaren oder vorübergehend ortsfest betriebenen Amateurfunkstelle in Deutschland dem Rufzeichen der Zusatz "/p" hinzugefügt werden?',0,1,0,0,'');
INSERT INTO question VALUES(1532,'BD110','Was bedeutet der Rufzeichenzusatz "/am"?',0,1,0,0,'');
INSERT INTO question VALUES(1533,'BD111','Ein Rufzeichen mit dem Zusatz "/m" kann bei einer Amateurfunkstelle bedeuten,',0,1,0,0,'');
INSERT INTO question VALUES(1534,'BD112','Zu welcher Rufzeichenart gehören Rufzeichen mit dem Präfix DN1 bis DN8 und zwei bis drei Buchstaben im Suffix?',0,1,0,0,'');
INSERT INTO question VALUES(1535,'BD113','Rufzeichen, die mit DFØ, DKØ oder DLØ beginnen, sind zumeist',0,1,0,0,'');
INSERT INTO question VALUES(1536,'BD114','Zu welcher Rufzeichenart und Klasse gehören Rufzeichen, die mit DO1 bis DO9 beginnen?',0,1,0,0,'');
INSERT INTO question VALUES(1537,'BD115','Woraus setzen sich die personengebundenen Rufzeichen deutscher Funkamateure zusammen? Sie setzen sich zusammen aus',0,1,0,0,'');
INSERT INTO question VALUES(1538,'BD201','Wo können Sie nachschlagen, in welchem Land sich eine Amateurfunkstelle mit einem Ihnen bislang unbekannten Landeskenner befindet?',0,1,0,0,'');
INSERT INTO question VALUES(1539,'BD202','Welche Antwort enthält nur Landeskenner von Ländern, die an die Bundesrepublik Deutschland grenzen?',0,1,0,0,'');
INSERT INTO question VALUES(1540,'BD203','Welche Gruppe gibt die Landeskenner der Länder Rumänien, Bulgarien, Spanien, Norwegen, Polen für ihre Amateurfunkstellen richtig wieder?',0,1,0,0,'');
INSERT INTO question VALUES(1541,'BD204','Welche Länder sind der Reihe nach den folgenden Ländern zugeordnet? Die Landeskenner OE, PA, HBØ, YL, LX entsprechen den Ländern',0,1,0,0,'');
INSERT INTO question VALUES(1542,'BD205','Welche Länder (Gebiete) sind der Reihe nach den folgenden Landeskennern zugeordnet? Die Landeskenner 3A, 4U, 9A, 9H entsprechen den Ländern (Gebieten)',0,1,0,0,'');
INSERT INTO question VALUES(1543,'BD206','Welche Länder sind der Reihe nach den folgenden Landeskennern zugeordnet? Die Landeskenner OE, OH, OK, OM, ON, OZ entsprechen den Ländern',0,1,0,0,'');
INSERT INTO question VALUES(1544,'BD207','Welche Länder sind der Reihe nach den folgenden Landeskennern zugeordnet? Die Landeskenner LA, LY, LZ, YL entsprechen den Ländern',0,1,0,0,'');
INSERT INTO question VALUES(1545,'BD208','Welche Länder sind der Reihe nach den folgenden Landeskennern zugeordnet? Die Landeskenner SM, S5, SP, SV entsprechen den Ländern',0,1,0,0,'');
INSERT INTO question VALUES(1546,'BD209','Welche Länder sind der Reihe nach den folgenden Landeskennern zugeordnet? Die Landeskenner EA, EI, EM, ES entsprechen den Ländern',0,1,0,0,'');
INSERT INTO question VALUES(1547,'BD210','Welche Gruppe gibt die Landeskennern der Länder Portugal, Schweiz, Spanien, Belgien, Polen und Irland für ihre Amateurfunkstellen richtig wieder?',0,1,0,0,'');
INSERT INTO question VALUES(1548,'BD301','Welchem Land bzw. welchen Ländern sind die Landeskenner DA bis DZ zugeordnet?',0,1,0,0,'');
INSERT INTO question VALUES(1549,'BD302','Welche Gruppe gibt Landeskenner der Länder USA, Syrien, Südafrika, Neuseeland, Argentinien und Chile für ihre Amateurfunkstellen richtig wieder?',0,1,0,0,'');
INSERT INTO question VALUES(1550,'BD303','Welche Gruppe gibt Landeskenner der Länder China, Japan, Kanada, Australien, Mexiko und USA für ihre Amateurfunkstellen richtig wieder?',0,1,0,0,'');
INSERT INTO question VALUES(1551,'BD304','Welche fünf Landeskenner sind einem einzigen Kontinent zuzuordnen?',0,1,0,0,'');
INSERT INTO question VALUES(1552,'BD305','Welche Landeskenner sind afrikanischen Ländern zugewiesen?',0,1,0,0,'');
INSERT INTO question VALUES(1553,'BD306','Welche Landeskenner sind südamerikanischen Ländern zugewiesen?',0,1,0,0,'');
INSERT INTO question VALUES(1554,'BD307','Welche Bedeutung hat das Rufzeichen VE8ZZ/AM?',0,1,0,0,'');
INSERT INTO question VALUES(1555,'BD308','Welche Länder sind der Reihe nach den folgenden Landeskennern zugeordnet? Die Landeskenner VE, VK, PY, JA, W entsprechen den Ländern',0,1,0,0,'');
INSERT INTO question VALUES(1556,'BD309','In welcher Zeile stehen nur Rufzeichen aus den Vereinigten Staaten von Amerika (USA)?',0,1,0,0,'');
INSERT INTO question VALUES(1557,'BE101','Wie würden Sie antworten, wenn jemand "CQ" ruft?',0,1,0,0,'');
INSERT INTO question VALUES(1558,'BE102','Ein Funkamateur möchte eine verschlüsselte Nachricht an seinen Funkfreund senden. In welcher Sprache ist dies statthaft?',0,1,0,0,'');
INSERT INTO question VALUES(1559,'BE103','Auf welche Arten können Sie eine Amateurfunkverbindung zum Beispiel beginnen?',0,1,0,0,'');
INSERT INTO question VALUES(1560,'BE104','Die deutsche Amateurfunkstelle DC8WV ruft auf dem 80-m-Band oberhalb 3700 kHz in Morsetelegrafie "CQ de DC8WV pse k". Dürfen Sie auf diesen allgemeinen Anruf auch in der Betriebsart SSB-Telefonie antworten?',0,1,0,0,'');
INSERT INTO question VALUES(1561,'BE105','Sollten Sie einen allgemeinen Anruf mit QRZ beginnen?',0,1,0,0,'');
INSERT INTO question VALUES(1562,'BE106','Wie gestalten Sie Ihren allgemeinen Anruf in Telefonie, wenn Sie eine Verbindung mit einer australischen Amateurfunkstelle suchen?',0,1,0,0,'');
INSERT INTO question VALUES(1563,'BE107','Sie hören DH8DAP/p in Morsetelegrafie rufen: "CQ FD CQ FD de DH8DAP/p". Was bedeutet das?',0,1,0,0,'');
INSERT INTO question VALUES(1564,'BE108','Sie hören KA2WEU in Morsetelegrafie rufen: "CQ DL CQ DL de KA2WEU pse k". Was beabsichtigt KA2WEU mit diesem Anruf?',0,1,0,0,'');
INSERT INTO question VALUES(1565,'BE109','Ihr Rufzeichen sei DH7RW. Sie hören in Telefonie unvollständig "... 7 Romeo Whiskey". Wie reagieren Sie?',0,1,0,0,'');
INSERT INTO question VALUES(1566,'BE110','Sie hören 4U1ITU in Telefonie rufen: "CQ VK/ZL this is 4U1ITU". Sollten Sie 4U1ITU anrufen, wenn Sie gerne ein QSO mit ihm führen würden?',0,1,0,0,'');
INSERT INTO question VALUES(1567,'BE111','Was bedeutet der im 20-m-Band gesendete Anruf "CQ CQ CQ DX de HB9AFN"?',0,1,0,0,'');
INSERT INTO question VALUES(1568,'BE112','Was ist beim Morsetelegrafie-Funkverkehr mit einem offensichtlichen Anfänger zu beachten?',0,1,0,0,'');
INSERT INTO question VALUES(1569,'BE113','Eine Station ruft auf VHF/UHF "CQ" mit dem Zusatz "DX". Wann sollten Sie antworten?',0,1,0,0,'');
INSERT INTO question VALUES(1570,'BE114','Sie haben eine Funkverbindung mit einer vorher "CQ" rufenden Station beendet. Anschließend werden Sie von einer anderen Station gerufen. Wie verhalten Sie sich?',0,1,0,0,'');
INSERT INTO question VALUES(1571,'BE115','Sie möchten im 20-m-Band einen allgemeinen Anruf starten. Sie finden eine Frequenz die offensichtlich nicht belegt ist. Wie gehen Sie vor?',0,1,0,0,'');
INSERT INTO question VALUES(1572,'BE116','Warum erscheint Ihnen auf den höheren Frequenzbändern der Kurzwelle eine Frequenz als frei, obwohl sie sich anschließend als besetzt herausstellt?',0,1,0,0,'');
INSERT INTO question VALUES(1573,'BE117','Welche Betriebsbedingungen sollten Sie für die Teilnahme an einem internationalen KW-Wettbewerb unbedingt einhalten?',0,1,0,0,'');
INSERT INTO question VALUES(1574,'BE118','EA3JQ ruft in englischer Sprache CQ. Wie gestalten Sie Ihren Anruf, wenn Sie mit ihm ein QSO führen möchten?',0,1,0,0,'');
INSERT INTO question VALUES(1575,'BE119','Mit welcher Tastgeschwindigkeit würden Sie einen CQ-Ruf in Telegrafie beantworten? Ich würde',0,1,0,0,'');
INSERT INTO question VALUES(1576,'BE201','Was verstehen Sie unter dem Begriff "DX-Pedition"? Es ist',0,1,0,0,'');
INSERT INTO question VALUES(1577,'BE202','Was ist mit dem Begriff "pile up" gemeint? Man meint damit das gleichzeitige',0,1,0,0,'');
INSERT INTO question VALUES(1578,'BE203','Was verstehen Sie bei einer seltenen Station unter der Aufforderung zu "Listenbetrieb"?',0,1,0,0,'');
INSERT INTO question VALUES(1579,'BE204','Was ist gemeint, wenn die Gegenstation sagt: "split up 14250 to 14280"?',0,1,0,0,'');
INSERT INTO question VALUES(1580,'BE205','Eine "seltene" Station, die auf 14205 kHz "CQ" gerufen hat, sagt am Ende ihres CQRufes "tuning 290-300 up". Was tun Sie, wenn Sie diese Station anrufen wollen?',0,1,0,0,'');
INSERT INTO question VALUES(1581,'BE206','Eine Station gibt am Ende ihres CQ-Rufes "5 up". Was bedeutet diese Angabe und was ist zu beachten?',0,1,0,0,'');
INSERT INTO question VALUES(1582,'BE207','Eine seltene Station ruft in SSB "only number 3, only suffix". Was ist damit gemeint?',0,1,0,0,'');
INSERT INTO question VALUES(1583,'BE208','Was versteht man unter "Split-Verkehr"?',0,1,0,0,'');
INSERT INTO question VALUES(1584,'BE209','Was bedeutet die Aussage, dass ein Funkamateur in Deutschland mit "VK" auf dem "langen Weg" gearbeitet hat?',0,1,0,0,'');
INSERT INTO question VALUES(1585,'BE210','Was meint ein Funkamateur damit, wenn er angibt, dass er auf dem 2-m-Band eine Aurora- Verbindung mit Schottland gehabt hat?',0,1,0,0,'');
INSERT INTO question VALUES(1586,'BE211','Was meint ein Funkamateur damit, wenn er angibt, dass auf dem 2-m-Band „Sporadic-E-Bedingungen“ herrschen? Er meint damit, dass derzeit',0,1,0,0,'');
INSERT INTO question VALUES(1587,'BE212','Woran können Sie als Funkamateur eine Aurora-Verbindung erkennen?',0,1,0,0,'');
INSERT INTO question VALUES(1588,'BE213','Wie erkennt ein Funkamateur in der Regel, dass er mit "PY" auf dem "indirekten" und somit längeren Weg gearbeitet hat?',0,1,0,0,'');
INSERT INTO question VALUES(1589,'BE214','Was versteht man unter dem von Funkamateuren benutzten „Locator“ (Standortkenner)?',0,1,0,0,'');
INSERT INTO question VALUES(1590,'BE215','Was verstehen Funkamateure unter einer "Fuchsjagd" (ARDF = Amateur Radio Direction Finding)?',0,1,0,0,'');
INSERT INTO question VALUES(1591,'BE216','Was versteht man im Amateurfunk unter „Ham-Spirit"?',0,1,0,0,'');
INSERT INTO question VALUES(1592,'BE301','Welche Betriebsarten sind für QRP-DX-Betrieb auf Kurzwelle am besten geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(1593,'BE302','Welche Betriebsarten sind für QRP-DX-Betrieb auf Kurzwelle am besten geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(1594,'BE303','Wie teilen Sie Ihrem Funkpartner in der Betriebsart SSTV seinen „Rapport“ mit?',0,1,0,0,'');
INSERT INTO question VALUES(1595,'BE304','Was ist mit dem Begriff "monitoring" in Packet Radio (PR) gemeint?',0,1,0,0,'');
INSERT INTO question VALUES(1596,'BE305','Wozu dient ein "Auto-Router" im Packet- Radio-Betrieb?',0,1,0,0,'');
INSERT INTO question VALUES(1597,'BE306','Was versteht man unter "Forwarding" im Packet-Radio-Betrieb?',0,1,0,0,'');
INSERT INTO question VALUES(1598,'BE307','Warum soll das "TX-Delay" beim Packet- Radio-Betrieb so kurz wie möglich eingestellt sein?',0,1,0,0,'');
INSERT INTO question VALUES(1599,'BE308','Was versteht man unter APRS im Amateurfunk?',0,1,0,0,'');
INSERT INTO question VALUES(1600,'BE309','Was sind "Linkstrecken" und wozu dienen sie?',0,1,0,0,'');
INSERT INTO question VALUES(1601,'BE310','Was ist Simplexbetrieb?',0,1,0,0,'');
INSERT INTO question VALUES(1602,'BE401','Was ist damit gemeint, wenn man sagt, die Relaisfunkstelle hat eine Eingabe- und eine Ausgabefrequenz? Die Relaisfunkstelle',0,1,0,0,'');
INSERT INTO question VALUES(1603,'BE402','Wie wird eine Funkverbindung beurteilt, wenn über eine F3E-Relaisfunkstelle gearbeitet wird?',0,1,0,0,'');
INSERT INTO question VALUES(1604,'BE403','Geben Sie die richtige Weiterführung an: Eine Amateurfunkbake ist eine Amateurfunkstelle',0,1,0,0,'');
INSERT INTO question VALUES(1605,'BE404','Warum sollten bei Relaisfunkbetrieb die Durchgänge möglichst kurz gehalten werden?',0,1,0,0,'');
INSERT INTO question VALUES(1606,'BE405','Bei deutschen 2-m-Relaisfunkstellen liegt die Ausgabefrequenz üblicherweise',0,1,0,0,'');
INSERT INTO question VALUES(1607,'BE406','Bei deutschen 70-cm-Relaisfunkstellen liegt die Ausgabefrequenz üblicherweise',0,1,0,0,'');
INSERT INTO question VALUES(1608,'BE407','Was versteht man unter dem Transponder eines "OSCAR" und wie arbeitet er?',0,1,0,0,'');
INSERT INTO question VALUES(1609,'BE408','Was versteht man unter einem "Transponderfahrplan"?',0,1,0,0,'');
INSERT INTO question VALUES(1610,'BE409','Weshalb sind die Frequenzen 14099-14101, 18109-18111, 21149-21151, 24929-24931 und 28190-28225 kHz freizuhalten?',0,1,0,0,'');
INSERT INTO question VALUES(1611,'BE410','Welche Gruppe enthält die richtig dargestellte Bedeutung der nachfolgend genannten Begriffe in der richtigen Reihenfolge? 1) Repeater, 2) Digipeater, 3) Mailbox',0,1,0,0,'');
INSERT INTO question VALUES(1612,'BE411','Die Begriffe 1) OSCAR, 2) Uplink, 3) Downlink, 4) Azimut/Elevation bedeuten in der angegebenen Reihenfolge:',0,1,0,0,'');
INSERT INTO question VALUES(1613,'BF101','Das 80-m-Amateurfunkband ist unter anderem dem Amateurfunkdienst und dem Seefunkdienst auf primärer Basis zugewiesen. Unter welchen Umständen dürfen Sie in einer Amateurfunkverbindung fortfahren, wenn Sie erst nach Betriebsaufnahme bemerken, dass Ihre benutzte Frequenz auch von einer Küstenfunkstelle benutzt wird?',0,1,0,0,'');
INSERT INTO question VALUES(1614,'BF102','Wie heißt das internationale Notzeichen im Sprechfunk?',0,1,0,0,'');
INSERT INTO question VALUES(1615,'BF103','Welche Notzeichen werden in der Telefonie verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(1616,'BF104','Dürfen Sie im Notfall eines der Notzeichen SOS oder Mayday gebrauchen?',0,1,0,0,'');
INSERT INTO question VALUES(1617,'BF105','Sie haben am 16. August (Ortsdatum) um 20:00 Uhr mitteleuropäischer Sommerzeit (MESZ) von 9J2NG eine Notfunkmeldung aufgenommen und an eine Hilfeleistungsorganisation per Telefon weitergemeldet. Die Amateurfunkstelle 9J2NG hat Sie gebeten, um 23:00 Uhr UTC erneut mit ihr in Verbindung zu treten. Welcher Zeitpunkt ist dies in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(1618,'BF106','Sie haben auf einer Amateurfunkfrequenz eine Notmeldung von einem Schiff in Seenot empfangen. Wie verhalten Sie sich?',0,1,0,0,'');
INSERT INTO question VALUES(1619,'BF107','Sie empfangen einen Notruf einer havarierten privaten Segelyacht auf 14320 kHz. Wie verhalten Sie sich?',0,1,0,0,'');
INSERT INTO question VALUES(1620,'BF108','Sie haben auf der Ausgabefrequenz einer Relaisfunkstelle eine Notmeldung von einem Fahrzeug empfangen. Wie verhalten Sie sich?',0,1,0,0,'');
INSERT INTO question VALUES(1621,'BF109','In den Bandplan-Empfehlungen der IARU sind so genannte Aktivitätszentren für den Notfunkverkehr innerhalb der IARU-Region 1 eingerichtet worden. Bei welchen Frequenzen liegen diese Zentren?',0,1,0,0,'');
INSERT INTO question VALUES(1622,'BF110','Nach den Empfehlungen der International Amateur Radio Union gibt es bei 14300, 18160 und 21360 kHz so genannte Aktivitätszentren für Notfunkverkehr. Was ist das besondere an diesen Frequenzen?',0,1,0,0,'');
INSERT INTO question VALUES(1623,'BG101','Welche Uhrzeit tragen Sie in die QSL Karte an XE2AS ein, mit dem Sie um 13:30 MESZ eine Funkverbindung hatten?',0,1,0,0,'');
INSERT INTO question VALUES(1624,'BG102','Was sollten sie bei der Eintragung der Uhrzeit in das Funktagebuch beachten?',0,1,0,0,'');
INSERT INTO question VALUES(1625,'BG103','Was verstehen Funkamateure unter einem Logbuch (logbook)?',0,1,0,0,'');
INSERT INTO question VALUES(1626,'BG104','In welchen Fällen muss ein Stationstagebuch geführt werden? Es muss geführt werden',0,1,0,0,'');
INSERT INTO question VALUES(1627,'BG105','Welche Uhrzeit tragen Sie in die QSL-Karte an die Funkstation DH4KYL ein, mit der Sie um 15:30 MEZ ein QSO hatten?',0,1,0,0,'');
INSERT INTO question VALUES(1628,'BG106','Was wird im Amateurfunk unter "SASE" verstanden?',0,1,0,0,'');
INSERT INTO question VALUES(1629,'BG107','Was wird im Amateurfunk unter "IRC" verstanden? IRC ist',0,1,0,0,'');
INSERT INTO question VALUES(1630,'BG108','Was ist bei der Erstellung eines "Computer-Logbuchs" bei angeordneter Logbuchführung zu beachten?',0,1,0,0,'');
INSERT INTO question VALUES(1631,'BG109','Was ist bei angeordneter Logbuchführung bei einem Wechsel der "Logbuchsoftware" zu berücksichtigen?',0,1,0,0,'');
INSERT INTO question VALUES(1632,'BG110','Welches ist der Sinn der QSL-Karte und wozu kann sie dienen?',0,1,0,0,'');
INSERT INTO question VALUES(1633,'BG111','Welche Angaben sollten QSL-Karten mindestens enthalten?',0,1,0,0,'');
INSERT INTO question VALUES(1634,'BG112','HZ1AB sagte Ihnen "QSL via K8PYD". Was würden Sie tun, um die QSL-Karte von HZ1AB zu erhalten?',0,1,0,0,'');
INSERT INTO question VALUES(1635,'BG113','Was können Sie tun, wenn Sie von einer seltenen DX-Station möglichst schnell eine QSL-Karte erhalten möchten?',0,1,0,0,'');
INSERT INTO question VALUES(1636,'BG114','Was sollten Sie bei der Eintragung von Uhrzeiten in Stationstagebuch und QSL-Karten beachten?',0,1,0,0,'');
INSERT INTO question VALUES(1637,'BG115','Wo können Sie die Anschriften von ausländischen Funkamateuren finden, denen Sie die QSL-Karte direkt zusenden möchten? Ich finde diese',0,1,0,0,'');
INSERT INTO question VALUES(1638,'VA101','In welchem zum Internationalen Fernmeldevertrag gehörenden Regelungswerk ist der Begriff "Amateurfunkdienst" definiert?',0,1,0,0,'');
INSERT INTO question VALUES(1639,'VA102','Wozu dient der Amateurfunkdienst nach dem Wortlaut seiner internationalen Begriffsbestimmung in den Radio Regulations (VO Funk)?',0,1,0,0,'');
INSERT INTO question VALUES(1640,'VA103','Wozu dient der Amateurfunkdienst über Satelliten nach dem Wortlaut seiner internationalen Begriffsbestimmung in den Radio Regulations (VO Funk)?',0,1,0,0,'');
INSERT INTO question VALUES(1641,'VA104','Welche Aussage über Funkamateure enthält die Begriffsbestimmung des Amateurfunkdienstes in den Radio Regulations (VO Funk)?',0,1,0,0,'');
INSERT INTO question VALUES(1642,'VA201','Wie ist die Amateurfunkstelle in den Radio Regulations (VO Funk) definiert?',0,1,0,0,'');
INSERT INTO question VALUES(1643,'VA202','Wie ist die Funkstelle in den Radio Regulations (VO Funk) definiert?',0,1,0,0,'');
INSERT INTO question VALUES(1644,'VA203','Was ist eine Amateurfunkstelle im Sinne der Radio Regulations (VO Funk)?',0,1,0,0,'');
INSERT INTO question VALUES(1645,'VA204','Bei welcher der genannten Einrichtungen handelt es sich um keine Amateurfunkstelle nach der Definition der Radio Regulations (VO Funk) und des AFuG?',0,1,0,0,'');
INSERT INTO question VALUES(1646,'VA205','Bei welcher der genannten Einrichtungen handelt es sich um eine Amateurfunkstelle nach der Definition der Radio Regulations (VO Funk) und des AFuG?',0,1,0,0,'');
INSERT INTO question VALUES(1647,'VA301','Was ist in den Radio Regulations (VO Funk) bezüglich der Morsequalifikation für Funkamateure festgelegt?',0,1,0,0,'');
INSERT INTO question VALUES(1648,'VA302','Was ist in den Radio Regulations (VO Funk) hinsichtlich dem Amateurfunkverkehr festgelegt?',0,1,0,0,'');
INSERT INTO question VALUES(1649,'VA303','Gelten die allgemeinen Regelungen der Radio Regulations (VO Funk) auch für den Amateurfunkdienst?',0,1,0,0,'');
INSERT INTO question VALUES(1650,'VA304','Was gilt hinsichtlich der Anwendung von Kodes und Verschlüsselungen im internationalen Amateurfunkverkehr zwischen Funkamateuren?',0,1,0,0,'');
INSERT INTO question VALUES(1651,'VA401','Nach den Radio Regulations (VO Funk) ist die Erde in verschiedene Funkregionen unterteilt. Wie viele Funkregionen gibt es und zu welcher davon gehört Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(1652,'VA402','Nach den Radio Regulations (VO Funk) ist die Erde in verschiedene Funkregionen unterteilt. Wie viele Funkregionen gibt es und zu welcher davon gehört Kanada?',0,1,0,0,'');
INSERT INTO question VALUES(1653,'VA403','Nach den Radio Regulations (VO Funk) ist die Erde in verschiedene Funkregionen unterteilt. Wie viele Funkregionen gibt es und zu welcher davon gehört Australien?',0,1,0,0,'');
INSERT INTO question VALUES(1654,'VA404','Weshalb wird in den Radio Regulations (VO Funk) die Erde in verschiedene Funkregionen eingeteilt?',0,1,0,0,'');
INSERT INTO question VALUES(1655,'VA405','Was enthält der "Internationale Frequenzbereichszuweisungsplan"?',0,1,0,0,'');
INSERT INTO question VALUES(1656,'VA406','In welchem Regelungswerk ist die Bedeutung der "Q-Gruppen" festgelegt?',0,1,0,0,'');
INSERT INTO question VALUES(1657,'VA407','Was bedeuten im Funk die Zeichen "SOS" und "MAYDAY"?',0,1,0,0,'');
INSERT INTO question VALUES(1658,'VA408','Wo sind die Amateurfunkrufzeichen international geregelt?',0,1,0,0,'');
INSERT INTO question VALUES(1659,'VA409','Darf ein Funkamateur in Deutschland alle in den Radio Regulations (VO Funk) für den Amateurfunkdienst zugewiesenen Frequenzbereiche benutzen?',0,1,0,0,'');
INSERT INTO question VALUES(1660,'VB101','Welche Bedeutung haben die CEPT-Empfehlungen T/R 61-01 und 05(06) für den Amateurfunkdienst?',0,1,0,0,'');
INSERT INTO question VALUES(1661,'VB102','Was beinhalten die CEPT-Empfehlungen T/R 61-01 und (05)06?',0,1,0,0,'');
INSERT INTO question VALUES(1662,'VB103','Die deutsche Amateurfunkzulassung der Klasse A entspricht der',0,1,0,0,'');
INSERT INTO question VALUES(1663,'VB104','Die deutsche Amateurfunkzulassung der Klasse E entspricht der',0,1,0,0,'');
INSERT INTO question VALUES(1664,'VB105','Mit einer gültigen deutschen Amateurfunkzulassung der Klasse A, die als „CEPT-Amateurfunkgenehmigung“ gekennzeichnet ist, dürfen die Betriebsrechte der entsprechenden ausländischen Genehmigung im jeweiligen Beitrittsland gemäß der CEPT-Empfehlung T/R 61-01 wahrgenommen werden,',0,1,0,0,'');
INSERT INTO question VALUES(1665,'VB106','Mit einer gültigen deutschen Amateurfunkzulassung der Klasse E, die als „CEPT-Novice- Amateurfunkgenehmigung“ gekennzeichnet ist, dürfen die Betriebsrechte der entsprechenden ausländischen Genehmigung im jeweiligen Beitrittsland gemäß der ECC-Empfehlung (05)06 wahrgenommen werden,',0,1,0,0,'');
INSERT INTO question VALUES(1666,'VB107','Wie lange darf ein Funkamateur im Rahmen einer der CEPT-Empfehlungen T/R 61-01 oder (05)06 Amateurfunkverkehr in einem Land durchführen?',0,1,0,0,'');
INSERT INTO question VALUES(1667,'VB108','Wie muss die Rufzeichennennung von DO1XYZ bei der Nutzung der CEPT-Novice- Amateurfunkgenehmigung in der Schweiz erfolgen?',0,1,0,0,'');
INSERT INTO question VALUES(1668,'VB109','Wie muss die Rufzeichennennung von DL1ER bei der Nutzung der CEPT-Amateurfunkgenehmigung in der Schweiz erfolgen?',0,1,0,0,'');
INSERT INTO question VALUES(1669,'VB110','Sie hören die Amateurfunkstation mit dem Rufzeichen DL/G3MM. Welcher der nachfolgenden Sachverhalte trifft zu?',0,1,0,0,'');
INSERT INTO question VALUES(1670,'VB111','Darf ein Funkamateur mit einer CEPT-Amateurfunkgenehmigung in allen CEPT-Ländern Amateurfunkverkehr abwickeln?',0,1,0,0,'');
INSERT INTO question VALUES(1671,'VB112','Darf ein Funkamateur mit einer CEPT-Novice- Amateurfunkgenehmigung in allen CEPT-Ländern Amateurfunkverkehr abwickeln?',0,1,0,0,'');
INSERT INTO question VALUES(1672,'VB113','Wo sind die Informationen und Bedingungen für die Ausstellung und die Nutzung der CEPT-Amateurfunkgenehmigung zu finden?',0,1,0,0,'');
INSERT INTO question VALUES(1673,'VB114','Wo sind die Informationen und Bedingungen für die Ausstellung und die Nutzung der CEPT-Novice-Amateurfunkgenehmigung zu finden?',0,1,0,0,'');
INSERT INTO question VALUES(1674,'VB115','Aufgrund welcher Regelungen dürfen Funkamateure aus bestimmten Ländern ohne individuelle Gastzulassung vorübergehend in Deutschland Amateurfunk ausüben?',0,1,0,0,'');
INSERT INTO question VALUES(1675,'VB116','Entsprechend welcher internationalen Regelungen dürfen Inhaber eines deutschen Amateurfunkrufzeichens auch in anderen Ländern vorübergehend am Amateurfunkverkehr teilnehmen, ohne dass sie dort vorher eine besondere Zulassung beantragen müssen?',0,1,0,0,'');
INSERT INTO question VALUES(1676,'VB117','Welche der folgenden Aussagen ist richtig?',0,1,0,0,'');
INSERT INTO question VALUES(1677,'VB118','Welche Regelungen sind beim Betrieb einer Amateurfunkstelle in einem ausländischen Land zu beachten, das die CEPT-Empfehlungen T/R 61-01 und (05)06 umgesetzt hat?',0,1,0,0,'');
INSERT INTO question VALUES(1678,'VB119','Darf ein Funkamateur mit einer gültigen deutschen Amateurfunkzulassung der Klasse A auch im Gastland Amateurfunkverkehr auf dem 6-m-Band durchführen?',0,1,0,0,'');
INSERT INTO question VALUES(1679,'VB120','Ist der vorübergehende Betrieb einer Klubstation nach CEPT-Empfehlung T/R 61-01 in einem Land erlaubt, welches diese Empfehlung anwendet?',0,1,0,0,'');
INSERT INTO question VALUES(1680,'VB121','Was hat ein Funkamateur zu veranlassen, wenn er eine Amateurfunkstelle anlässlich einer Urlaubsreise in einem Land betreiben will, das die in seiner Amateurfunkzulassung eingetragene CEPT-Empfehlung nicht anwendet?',0,1,0,0,'');
INSERT INTO question VALUES(1681,'VB122','Was ist eine HAREC?',0,1,0,0,'');
INSERT INTO question VALUES(1682,'VB123','Wozu dient eine HAREC?',0,1,0,0,'');
INSERT INTO question VALUES(1683,'VB124','Die CEPT-Empfehlung T/R 61-02 beinhaltet Regelungen für',0,1,0,0,'');
INSERT INTO question VALUES(1684,'VB125','Welche der folgenden Aussagen ist richtig?',0,1,0,0,'');
INSERT INTO question VALUES(1685,'VC101','Welches Gesetz bildet die Rechtsgrundlage für den Amateurfunkdienst in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(1686,'VC102','Welches Gesetz regelt die Voraussetzungen und die Bedingungen für die Teilnahme am Amateurfunkdienst?',0,1,0,0,'');
INSERT INTO question VALUES(1687,'VC103','Welche Behörde nimmt die Aufgaben und Befugnisse in Deutschland wahr, die sich aus dem Amateurfunkgesetz (AFuG) und der Amateurfunkverordnung (AFuV) ergeben?',0,1,0,0,'');
INSERT INTO question VALUES(1688,'VC104','Wie ist der Begriff "Funkamateur" nach dem AFuG zu verstehen?',0,1,0,0,'');
INSERT INTO question VALUES(1689,'VC105','Nach dem Amateurfunkgesetz ist ein Funkamateur der Inhaber eines Amateurfunkzeugnisses oder einer harmonisierten Prüfungsbescheinigung der sich',0,1,0,0,'');
INSERT INTO question VALUES(1690,'VC106','Nach dem Amateurfunkgesetz ist eine Amateurfunkstelle eine Funkstelle,',0,1,0,0,'');
INSERT INTO question VALUES(1691,'VC107','Mit welchen anderen Funkstellen darf der Funkamateur Funkverkehr abwickeln?',0,1,0,0,'');
INSERT INTO question VALUES(1692,'VC108','Darf der Funkamateur mit anderen Funkstellen, die keine Amateurfunkstellen sind, Funkverkehr abwickeln?',0,1,0,0,'');
INSERT INTO question VALUES(1693,'VC109','Dürfen Sie mit Ihrem Amateurfunktransceiver im 70-cm-Band am LPD-Funkverkehr (LPD = Low Power Devices) teilnehmen?',0,1,0,0,'');
INSERT INTO question VALUES(1694,'VC110','Darf ein Funkamateur Nachrichten, die nicht den Amateurfunkdienst betreffen, für und an Dritte übermitteln?',0,1,0,0,'');
INSERT INTO question VALUES(1695,'VC111','Der Amateurfunkdienst ist',0,1,0,0,'');
INSERT INTO question VALUES(1696,'VC112','Wozu dient der Amateurfunkdienst nach dem AFuG?',0,1,0,0,'');
INSERT INTO question VALUES(1697,'VC113','Welchen Zwecken dient der Amateurfunkdienst nach dem AFuG?',0,1,0,0,'');
INSERT INTO question VALUES(1698,'VC114','Welchen Zwecken dient der Amateurfunkdienst nach dem AFuG?',0,1,0,0,'');
INSERT INTO question VALUES(1699,'VC115','Welches der nachfolgend genannten Dokumente benötigt man, um ein Funkamateur im Sinne des AFuG zu sein?',0,1,0,0,'');
INSERT INTO question VALUES(1700,'VC116','Was ist neben einer erfolgreich abgelegten Amateurfunkprüfung unbedingt erforderlich, damit Sie eine Amateurfunkstelle betreiben dürfen?',0,1,0,0,'');
INSERT INTO question VALUES(1701,'VC117','Was ist erforderlich, um den Amateurfunkbetrieb ausüben zu dürfen?',0,1,0,0,'');
INSERT INTO question VALUES(1702,'VC118','Ab wann dürfen Sie eine Amateurfunkstelle betreiben?',0,1,0,0,'');
INSERT INTO question VALUES(1703,'VC119','Ist die Erteilung einer Amateurfunkzulassung von einem Mindestalter abhängig?',0,1,0,0,'');
INSERT INTO question VALUES(1704,'VC120','Welche Rufzeichenzuteilungsarten gibt es im Amateurfunk?',0,1,0,0,'');
INSERT INTO question VALUES(1705,'VC121','Unter welchen Voraussetzungen darf ein Funkamateur eine Amateurfunkstelle als Relaisfunkstelle betreiben?',0,1,0,0,'');
INSERT INTO question VALUES(1706,'VC122','Unter welchen Voraussetzungen darf ein Funkamateur Ausbildungsfunkbetrieb durchführen?',0,1,0,0,'');
INSERT INTO question VALUES(1707,'VC123','Unter welchen Voraussetzungen darf ein Funkamateur eine Amateurfunkstelle als Klubstation betreiben?',0,1,0,0,'');
INSERT INTO question VALUES(1708,'VC124','Darf ein Funkamateur seine Amateurfunkzulassung oder das damit zugeteilte Rufzeichen unter besonderen Umständen vorübergehend einer anderen Person übertragen?',0,1,0,0,'');
INSERT INTO question VALUES(1709,'VC125','Kann ein zugeteiltes Rufzeichen durch die Bundesnetzagentur geändert werden?',0,1,0,0,'');
INSERT INTO question VALUES(1710,'VC126','Darf die Amateurfunkstelle zu gewerblich-wirtschaftlichen Zwecken in kleinem Rahmen mitbenutzt werden?',0,1,0,0,'');
INSERT INTO question VALUES(1711,'VC127','Welche der nachfolgenden Aussagen ist zutreffend?',0,1,0,0,'');
INSERT INTO question VALUES(1712,'VC128','Welche der nachfolgenden Aussagen ist zutreffend?',0,1,0,0,'');
INSERT INTO question VALUES(1713,'VC129','Welche der nachfolgenden Aussagen ist zutreffend?',0,1,0,0,'');
INSERT INTO question VALUES(1714,'VC130','Welche der nachfolgenden Aussagen ist zutreffend?',0,1,0,0,'');
INSERT INTO question VALUES(1715,'VC131','Welche der nachfolgenden Aussagen ist zutreffend?',0,1,0,0,'');
INSERT INTO question VALUES(1716,'VC132','Welche der nachfolgenden Aussagen ist zutreffend?',0,1,0,0,'');
INSERT INTO question VALUES(1717,'VC133','Welche der nachfolgenden Aussagen ist zutreffend?',0,1,0,0,'');
INSERT INTO question VALUES(1718,'VC134','Welche der nachfolgenden Aussagen ist zutreffend?',0,1,0,0,'');
INSERT INTO question VALUES(1719,'VC135','Welche der nachfolgenden Aussagen ist zutreffend?',0,1,0,0,'');
INSERT INTO question VALUES(1720,'VC136','Aus welcher Vorschrift ergibt sich die Pflicht, die Einhaltung der Personenschutzgrenzwerte zu dokumentieren?',0,1,0,0,'');
INSERT INTO question VALUES(1721,'VC137','Kann der Funkamateur eine Standortbescheinigung erhalten?',0,1,0,0,'');
INSERT INTO question VALUES(1722,'VC138','Die Bundesnetzagentur kann bei Verstößen gegen AFuG oder AFuV',0,1,0,0,'');
INSERT INTO question VALUES(1723,'VC139','Was hat ein Funkamateur zu erwarten, der seine Amateurfunkstelle entgegen den Bestimmungen über den Amateurfunkdienst betreibt?',0,1,0,0,'');
INSERT INTO question VALUES(1724,'VC140','Unter welchen Voraussetzungen kann einem Funkamateur die Zulassung zur Teilnahme am Amateurfunkdienst widerrufen werden?',0,1,0,0,'');
INSERT INTO question VALUES(1725,'VC141','Was hat ein Funkamateur mit zugeteiltem Rufzeichen zu erwarten, wenn er fortgesetzt gegen AFuG oder AFuV verstößt?',0,1,0,0,'');
INSERT INTO question VALUES(1726,'VC142','Wann handelt ein Funkamateur ordnungswidrig im Sinne des Amateurfunkgesetzes?',0,1,0,0,'');
INSERT INTO question VALUES(1727,'VC143','Welche der nachfolgenden Handlungen stellt eine Ordnungswidrigkeit im Sinne des Amateurfunkgesetzes dar?',0,1,0,0,'');
INSERT INTO question VALUES(1728,'VC144','Welche der nachfolgenden Handlungen stellt eine Ordnungswidrigkeit im Sinne des Amateurfunkgesetzes dar?',0,1,0,0,'');
INSERT INTO question VALUES(1729,'VC145','Ein Funkamateur übermittelt unter Benutzung seiner Amateurfunkstelle rechtswidrig Nachrichten an Dritte. Wie hoch kann das Bußgeld für diese Ordnungswidrigkeit sein?',0,1,0,0,'');
INSERT INTO question VALUES(1730,'VC146','Was hat ein Funkamateur zu erwarten, der seine Amateurfunkstelle entgegen den Bestimmungen über den Amateurfunkdienst betreibt?',0,1,0,0,'');
INSERT INTO question VALUES(1731,'VD101','Welche der folgenden Begriffsbestimmungen ist gemäß AFuV richtig wiedergegeben?',0,1,0,0,'');
INSERT INTO question VALUES(1732,'VD102','Welche der folgenden Begriffsbestimmungen ist entsprechend der AFuV richtig wiedergegeben?',0,1,0,0,'');
INSERT INTO question VALUES(1733,'VD103','Welche der folgenden Begriffsbestimmungen ist entsprechend der AFuV richtig wiedergegeben?',0,1,0,0,'');
INSERT INTO question VALUES(1734,'VD104','Wo sind die Nutzungsbestimmungen, die maximal zulässigen Sender- bzw. Strahlungsleistungen und die erlaubten Frequenzbereiche für den Amateurfunkdienst und den Amateurfunkdienst über Satelliten zu finden?',0,1,0,0,'');
INSERT INTO question VALUES(1735,'VD105','Welche der genannten Bestimmungen enthält Regelungen darüber, welche Frequenzbereiche der Inhaber einer Amateurfunkzulassung entsprechend seiner Zeugnisklasse benutzen darf?',0,1,0,0,'');
INSERT INTO question VALUES(1736,'VD106','Wo ist die Einteilung der deutschen Amateurfunkrufzeichen geregelt?',0,1,0,0,'');
INSERT INTO question VALUES(1737,'VD107','Hat ein Funkamateur Anspruch auf Zuteilung eines bestimmten Rufzeichens?',0,1,0,0,'');
INSERT INTO question VALUES(1738,'VD108','Wann und wie oft hat der Funkamateur sein Rufzeichen zu nennen?',0,1,0,0,'');
INSERT INTO question VALUES(1739,'VD109','Welche Pflichten hat der Inhaber einer Amateurfunkzulassung im Fall der Änderung seiner Anschrift oder bei der Neuerrichtung einer ortsfesten Amateurfunkstelle?',0,1,0,0,'');
INSERT INTO question VALUES(1740,'VD110','Was muss der Inhaber einer Amateurfunkzulassung bei der Änderung seines Namens oder seiner Anschrift veranlassen?',0,1,0,0,'');
INSERT INTO question VALUES(1741,'VD111','Ein Funkamateur verzichtet auf seine Zulassung und damit auf die Zuteilung seines personengebundenen Rufzeichens. Kann er damit rechnen, dass er auf Antrag dieses Rufzeichen nach 2 Jahren erneut zugeteilt bekommt?',0,1,0,0,'');
INSERT INTO question VALUES(1742,'VD112','Was gilt in Bezug auf den Empfang von Amateurfunkaussendungen?',0,1,0,0,'');
INSERT INTO question VALUES(1743,'VD113','Zu welchen Zwecken kann die Bundesnetzagentur schriftliche Nachweise über den Funkbetrieb verlangen?',0,1,0,0,'');
INSERT INTO question VALUES(1744,'VD114','Dürfen im Amateurfunkverkehr internationale Not-, Dringlichkeits- und Sicherheitszeichen (z. B. SOS, MAYDAY) ausgesendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(1745,'VD115','Darf ein Funkamateur verdeckte bzw. geheime Nachrichten an seinen Funkfreund senden?',0,1,0,0,'');
INSERT INTO question VALUES(1746,'VD116','Offene Sprache im Funkverkehr bedeutet, dass der Funkverkehr',0,1,0,0,'');
INSERT INTO question VALUES(1747,'VD117','Welche der folgenden Aussagen ist richtig?',0,1,0,0,'');
INSERT INTO question VALUES(1748,'VD118','Welche technischen Anforderungen stellt die Amateurfunkverordnung u. a. an eine Amateurfunksendeanlage?',0,1,0,0,'');
INSERT INTO question VALUES(1749,'VD119','Welche technischen Anforderungen stellt die Amateurfunkverordnung u. a. an eine Amateurfunksendeanlage?',0,1,0,0,'');
INSERT INTO question VALUES(1750,'VD120','Was ist bei Abgleicharbeiten und Messungen an Sendern im Hinblick auf die Aussendung zu beachten?',0,1,0,0,'');
INSERT INTO question VALUES(1751,'VD121','Ist das Aussenden des unmodulierten oder ungetasteten Trägers zulässig?',0,1,0,0,'');
INSERT INTO question VALUES(1752,'VD122','Bei der Überprüfung des Ausgangssignals eines Senders sollte die Dämpfung der Oberwellen mindestens',0,1,0,0,'');
INSERT INTO question VALUES(1753,'VD123','Welche Daten sind in der offiziellen Rufzeichenliste der Bundesnetzagentur immer enthalten?',0,1,0,0,'');
INSERT INTO question VALUES(1754,'VD124','Wozu können Aufzeichnungen der Sendetätigkeit (z.B. Stationstagebuch) dienen?',0,1,0,0,'');
INSERT INTO question VALUES(1755,'VD125','Wann muss der Funkamateur ein Logbuch führen?',0,1,0,0,'');
INSERT INTO question VALUES(1756,'VD126','Wann hat ein Funkamateur der Bundesnetzagentur gemäß AFuV technische Unterlagen über seine Sendeanlage vorzulegen?',0,1,0,0,'');
INSERT INTO question VALUES(1757,'VD127','Für welche Zwecke sind Zuteilungen mit Ausnahmen von den technischen und betrieblichen Rahmenbedingungen der AFuV möglich?',0,1,0,0,'');
INSERT INTO question VALUES(1758,'VD128','Rufzeichenzuteilungen für besondere experimentelle und technisch-wissenschaftliche Studien gemäß § 16 Abs. 2 der AFuV sind Zuteilungen,',0,1,0,0,'');
INSERT INTO question VALUES(1759,'VD129','Ist für den Betrieb einer Amateurfunkstelle auf Wasser beziehungsweise in der Luft eine Sondergenehmigung der Bundesnetzagentur erforderlich?',0,1,0,0,'');
INSERT INTO question VALUES(1760,'VD201','Welche Rückschlüsse lässt das Rufzeichen DP1ZZZ zu?',0,1,0,0,'');
INSERT INTO question VALUES(1761,'VD202','Zu welchem Verwendungszweck und welcher Klasse gehört das Rufzeichen DO3ZZZ? Es ist ein',0,1,0,0,'');
INSERT INTO question VALUES(1762,'VD203','Zu welchem Verwendungszweck und welcher Klasse gehört das Rufzeichen DJ7ZZZ? Es ist ein',0,1,0,0,'');
INSERT INTO question VALUES(1763,'VD204','Zu welchem Verwendungszweck und welcher Klasse gehört das Rufzeichen DF9ZZZ? Es ist ein',0,1,0,0,'');
INSERT INTO question VALUES(1764,'VD205','Zu welchem Verwendungszweck und welcher Klasse gehört das Rufzeichen DGØZZZ? Es ist ein',0,1,0,0,'');
INSERT INTO question VALUES(1765,'VD206','Zu welchem Verwendungszweck und welcher Klasse gehört das Rufzeichen DLØZZZ? Es ist ein',0,1,0,0,'');
INSERT INTO question VALUES(1766,'VD207','Zu welchem Verwendungszweck und welcher Klasse gehört das Rufzeichen DB5ZZZ? Es ist ein',0,1,0,0,'');
INSERT INTO question VALUES(1767,'VD208','Zu welchem Verwendungszweck und welcher Klasse gehört das Rufzeichen DM1ZZZ? Es ist ein',0,1,0,0,'');
INSERT INTO question VALUES(1768,'VD209','Wie werden deutsche Amateurfunkrufzeichen meistens gebildet?',0,1,0,0,'');
INSERT INTO question VALUES(1769,'VD210','Welche der folgenden Amateurfunkrufzeichen werden in Deutschland auch zugeteilt?',0,1,0,0,'');
INSERT INTO question VALUES(1770,'VD211','Wann muss beim Amateurfunkverkehr das zugeteilte Rufzeichen übermittelt werden?',0,1,0,0,'');
INSERT INTO question VALUES(1771,'VD212','DL5XYZ benutzt sein im Kraftfahrzeug eingebautes Funkgerät für Sprechfunkverkehr. Wie kann der Zusatz zu seinem Rufzeichen lauten?',0,1,0,0,'');
INSERT INTO question VALUES(1772,'VD213','Was trifft für die Rufzeichenreihe "DN1AA - DN8ZZZ" zu?',0,1,0,0,'');
INSERT INTO question VALUES(1773,'VD214','Was trifft für die Rufzeichenreihe "DJ1AA - DJ9ZZZ" zu?',0,1,0,0,'');
INSERT INTO question VALUES(1774,'VD215','Was trifft für die Rufzeichenreihe "DL1AA - DL9ZZZ" zu?',0,1,0,0,'');
INSERT INTO question VALUES(1775,'VD216','Was trifft für die Rufzeichenreihe "DB1AA - DB9ZZZ" zu?',0,1,0,0,'');
INSERT INTO question VALUES(1776,'VD217','Was trifft für die Rufzeichenreihe "DO1AA - DO9ZZZ" zu?',0,1,0,0,'');
INSERT INTO question VALUES(1777,'VD218','Woran erkennt man eine Amateurfunkstelle im Funkbetrieb?',0,1,0,0,'');
INSERT INTO question VALUES(1778,'VD219','Was trifft für die Rufzeichenreihe "DBØAA - DBØZZZ" zu?',0,1,0,0,'');
INSERT INTO question VALUES(1779,'VD220','Was trifft für die Rufzeichenreihe "DFØAA - DFØZZZ" zu?',0,1,0,0,'');
INSERT INTO question VALUES(1780,'VD221','Was trifft für die Rufzeichenreihe "DAØAA - DAØZZZ" zu?',0,1,0,0,'');
INSERT INTO question VALUES(1781,'VD222','Was trifft für das Rufzeichen "DA5AA" zu?',0,1,0,0,'');
INSERT INTO question VALUES(1782,'VD223','Werden von der Bundesnetzagentur Ausbildungsrufzeichen für Klubstationen vergeben?',0,1,0,0,'');
INSERT INTO question VALUES(1783,'VD301','Von wem ist während des Ausbildungsfunkbetriebs das zugeteilte Ausbildungsrufzeichen zu benutzen?',0,1,0,0,'');
INSERT INTO question VALUES(1784,'VD302','Was ist bei der Durchführung von Ausbildungsfunkverkehr zu beachten?',0,1,0,0,'');
INSERT INTO question VALUES(1785,'VD303','Was ist u.a. im Zusammenhang mit der Durchführung von Ausbildungsfunkverkehr zu beachten?',0,1,0,0,'');
INSERT INTO question VALUES(1786,'VD304','Wann ist mit dem Entzug eines Ausbildungsrufzeichens zu rechnen?',0,1,0,0,'');
INSERT INTO question VALUES(1787,'VD305','Nicht-Funkamateure dürfen am Ausbildungsfunkbetrieb',0,1,0,0,'');
INSERT INTO question VALUES(1788,'VD306','Beim Ausbildungsfunkbetrieb sind',0,1,0,0,'');
INSERT INTO question VALUES(1789,'VD307','Kann der Inhaber einer Amateurfunkzulassung der Klasse E ein Ausbildungsrufzeichen zugeteilt bekommen?',0,1,0,0,'');
INSERT INTO question VALUES(1790,'VD308','Wird das Ausbildungsrufzeichen auf unbegrenzte Zeit erteilt?',0,1,0,0,'');
INSERT INTO question VALUES(1791,'VD309','Welche der nachfolgenden Tätigkeiten fällt nicht unter die Ziel- und Zweckbestimmung des Ausbildungsfunkbetriebs?',0,1,0,0,'');
INSERT INTO question VALUES(1792,'VD401','Welche Voraussetzungen müssen für die Erteilung eines Rufzeichens für den Betrieb einer Klubstation erfüllt sein?',0,1,0,0,'');
INSERT INTO question VALUES(1793,'VD402','Welche Voraussetzung muss für die Erteilung eines Rufzeichens für den Betrieb einer Klubstation erfüllt sein?',0,1,0,0,'');
INSERT INTO question VALUES(1794,'VD403','Was ist nötig, damit ein Funkamateur das Rufzeichen einer Klubstation mitbenutzen darf?',0,1,0,0,'');
INSERT INTO question VALUES(1795,'VD404','Wovon sind die Betriebsrechte eines Funkamateurs bei der Mitbenutzung eines Klubstationsrufzeichens abhängig?',0,1,0,0,'');
INSERT INTO question VALUES(1796,'VD405','Wovon sind die Betriebsrechte eines Funkamateurs bei der Mitbenutzung eines Klubstationsrufzeichens abhängig?',0,1,0,0,'');
INSERT INTO question VALUES(1797,'VD406','Welche der genannten Funkamateure dürfen an einer Klubstation der Klasse A Funkbetrieb im 40-m-Amateurfunkband durchführen?',0,1,0,0,'');
INSERT INTO question VALUES(1798,'VD407','Darf ein Funkamateur mit Ausbildungsrufzeichen der Klasse E an einer Klubstation, für deren Betrieb ein Rufzeichen der Klasse A zugeteilt wurde, ausbilden?',0,1,0,0,'');
INSERT INTO question VALUES(1799,'VD408','Welche der folgenden Aussagen ist richtig?',0,1,0,0,'');
INSERT INTO question VALUES(1800,'VD409','Welche der folgenden Aussagen ist richtig?',0,1,0,0,'');
INSERT INTO question VALUES(1801,'VD410','Welche der folgenden Aussagen ist richtig?',0,1,0,0,'');
INSERT INTO question VALUES(1802,'VD411','Welche der folgenden Aussagen ist richtig?',0,1,0,0,'');
INSERT INTO question VALUES(1803,'VD501','Welche der folgenden Begriffsbestimmungen ist gemäß AFuV richtig wiedergegeben?',0,1,0,0,'');
INSERT INTO question VALUES(1804,'VD502','Welche der folgenden Begriffsbestimmungen ist gemäß AFuV richtig wiedergegeben?',0,1,0,0,'');
INSERT INTO question VALUES(1805,'VD503','Welche der folgenden Begriffsbestimmungen ist gemäß AFuV richtig wiedergegeben?',0,1,0,0,'');
INSERT INTO question VALUES(1806,'VD504','Was ist notwendig, damit ein Funkamateur eine Amateurfunkstelle als Relaisfunkstelle oder Funkbake betreiben darf?',0,1,0,0,'');
INSERT INTO question VALUES(1807,'VD505','Was ist notwendig, damit ein Funkamateur eine Rufzeichenzuteilung für den Betrieb einer fernbedienten oder automatisch arbeitenden Amateurfunkstelle erhalten kann?',0,1,0,0,'');
INSERT INTO question VALUES(1808,'VD506','Wie hoch ist die maximal zulässige Strahlungsleistung einer Relaisfunkstelle oberhalb 30 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(1809,'VD507','Was gilt gemäß AFuV bei Relaisfunkstellen?',0,1,0,0,'');
INSERT INTO question VALUES(1810,'VD508','Was gilt gemäß AFuV bei Relaisfunkstellen und Funkbaken?',0,1,0,0,'');
INSERT INTO question VALUES(1811,'VD509','Was gilt gemäß AFuV bei Relaisfunkstellen und Funkbaken?',0,1,0,0,'');
INSERT INTO question VALUES(1812,'VD510','Wann kann ein verantwortlicher Funkamateur einen bestimmten Funkamateur vorübergehend vom Betrieb über die von ihm betreute Relaisfunkstelle ausschließen?',0,1,0,0,'');
INSERT INTO question VALUES(1813,'VD511','Welcher Fall ist als störungsfreier Betrieb einer Relaisfunkstelle im Sinne des § 13 Abs. 4 AFuV anzusehen?',0,1,0,0,'');
INSERT INTO question VALUES(1814,'VE101','Wo sind die ausführlichen Nutzungsbedingungen und die ausgewiesenen Frequenzbereiche für den Amateurfunkdienst in Deutschland zu finden?',0,1,0,0,'');
INSERT INTO question VALUES(1815,'VE102','Wo sind Einzelheiten über die Aufteilung und Nutzung der Frequenzbereiche in Deutschland zu finden?',0,1,0,0,'');
INSERT INTO question VALUES(1816,'VE103','Darf ein Funkamateur in Deutschland alle in der VO Funk für den Amateurfunkdienst zugewiesenen Frequenzbereiche benutzen?',0,1,0,0,'');
INSERT INTO question VALUES(1817,'VE104','Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (160-m-Amateurfunkband)?',0,1,0,0,'');
INSERT INTO question VALUES(1818,'VE105','Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (80-m-Amateurfunkband)?',0,1,0,0,'');
INSERT INTO question VALUES(1819,'VE106','Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (40-m-Amateurfunkband)?',0,1,0,0,'');
INSERT INTO question VALUES(1820,'VE107','Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (30-m-Amateurfunkband)?',0,1,0,0,'');
INSERT INTO question VALUES(1821,'VE108','Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (20-m-Amateurfunkband)?',0,1,0,0,'');
INSERT INTO question VALUES(1822,'VE109','Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (17-m-Amateurfunkband)?',0,1,0,0,'');
INSERT INTO question VALUES(1823,'VE110','Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (15-m-Amateurfunkband)?',0,1,0,0,'');
INSERT INTO question VALUES(1824,'VE111','Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (12-m-Amateurfunkband)?',0,1,0,0,'');
INSERT INTO question VALUES(1825,'VE112','Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (10-m-Amateurfunkband)?',0,1,0,0,'');
INSERT INTO question VALUES(1826,'VE113','Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (6-m-Amateurfunkband)?',0,1,0,0,'');
INSERT INTO question VALUES(1827,'VE114','Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (2-m-Amateurfunkband)?',0,1,0,0,'');
INSERT INTO question VALUES(1828,'VE115','Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (70-cm-Amateurfunkband)?',0,1,0,0,'');
INSERT INTO question VALUES(1829,'VE116','Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (23-cm-Amateurfunkband)?',0,1,0,0,'');
INSERT INTO question VALUES(1830,'VE117','Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (13-cm-Amateurfunkband)?',0,1,0,0,'');
INSERT INTO question VALUES(1831,'VE118','Welche Antwort enthält nur Frequenzbereiche, die auch von Rufzeicheninhabern der Klasse E genutzt werden dürfen?',0,1,0,0,'');
INSERT INTO question VALUES(1832,'VE119','Welche Antwort enthält nur Frequenzbereiche, die auch von Rufzeicheninhabern der Klasse E genutzt werden dürfen?',0,1,0,0,'');
INSERT INTO question VALUES(1833,'VE120','In welchem der genannten Frequenzbereiche hat der Amateurfunkdienst primären Status?',0,1,0,0,'');
INSERT INTO question VALUES(1834,'VE121','In welchem der genannten Frequenzbereiche hat der Amateurfunkdienst primären Status?',0,1,0,0,'');
INSERT INTO question VALUES(1835,'VE122','In welchem der genannten Frequenzbereiche hat der Amateurfunkdienst primären Status?',0,1,0,0,'');
INSERT INTO question VALUES(1836,'VE123','In welchem der genannten Frequenzbereiche hat der Amateurfunkdienst primären Status?',0,1,0,0,'');
INSERT INTO question VALUES(1837,'VE124','In welchem der genannten Frequenzbereiche hat der Amateurfunkdienst primären Status?',0,1,0,0,'');
INSERT INTO question VALUES(1838,'VE125','In welchem der genannten Frequenzbereiche hat der Amateurfunkdienst primären Status?',0,1,0,0,'');
INSERT INTO question VALUES(1839,'VE126','Was gilt für die Rufzeicheninhaber der Klassen A und E im Frequenzbereich 1810 - 1850 kHz?',0,1,0,0,'');
INSERT INTO question VALUES(1840,'VE127','Was gilt für die Rufzeicheninhaber der Klassen A und E im Frequenzbereich 1850 - 1890 kHz?',0,1,0,0,'');
INSERT INTO question VALUES(1841,'VE128','Was gilt für die Rufzeicheninhaber der Klassen A und E im Frequenzbereich 1890 - 2000 kHz?',0,1,0,0,'');
INSERT INTO question VALUES(1842,'VE129','Was gilt für die Rufzeicheninhaber der Klassen A und E im Frequenzbereich 3,5 - 3,8 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(1843,'VE130','Wie hoch ist die maximal zulässige Senderausgangsleistung für Rufzeicheninhaber der Klasse A in den Frequenzbereichen 3,5 - 3,8 MHz und 7,0 - 7,1 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(1844,'VE131','Wie hoch ist die maximal zulässige Senderausgangsleistung für Rufzeicheninhaber der Klasse A im Frequenzbereich 7,1 - 7,2 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(1845,'VE132','Wie hoch ist die maximal zulässige Senderausgangsleistung für Rufzeicheninhaber der Klasse A im Frequenzbereich 10,1 - 10,15 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(1846,'VE133','Wie hoch ist die maximal zulässige Senderausgangsleistung für Rufzeicheninhaber der Klasse A in den Frequenzbereichen 14 - 14,35 MHz und 18,068 - 18,168 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(1847,'VE134','Wie hoch ist die maximal zulässige Senderausgangsleistung für Rufzeicheninhaber der Klasse A in den Frequenzbereichen 21 - 21,45 MHz und 24,89 - 24,99 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(1848,'VE135','Welche Leistungsgrenzen gelten für die Rufzeicheninhaber der Klassen A und E in den Frequenzbereichen 21 - 21,45 MHz und 28 - 29,7 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(1849,'VE136','Wie hoch ist die maximal zulässige Strahlungsleistung für die Rufzeicheninhaber der Klassen A und E im Frequenzbereich 50,08 - 51 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(1850,'VE137','Was gilt für die Nutzung des Frequenzbereichs 50,08 - 51 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(1851,'VE138','Was gilt für die Rufzeicheninhaber der Klassen A und E in den Frequenzbereichen 144 - 146 MHz und 430 - 440 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(1852,'VE139','Wie hoch ist die maximal zulässige Sendeleistung für Rufzeicheninhaber der Klasse A im Frequenzbereich 1240 - 1300 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(1853,'VE140','Wie hoch ist die maximal zulässige Senderausgangsleistung für Rufzeicheninhaber der Klasse A in den Amateurfunkbändern zwischen 1300 MHz und 250 GHz?',0,1,0,0,'');
INSERT INTO question VALUES(1854,'VE141','Was gilt für die Rufzeicheninhaber der Klassen A und E im Frequenzbereich 10 - 10,5 GHz?',0,1,0,0,'');
INSERT INTO question VALUES(1855,'VE142','In welchen Amateurfunkfrequenzbereichen beträgt die maximal zulässige belegte Bandbreite einer Aussendung 800 Hz?',0,1,0,0,'');
INSERT INTO question VALUES(1856,'VE143','In welchen Amateurfunkfrequenzbereichen beträgt die maximal zulässige belegte Bandbreite einer Aussendung 2,7 kHz?',0,1,0,0,'');
INSERT INTO question VALUES(1857,'VE144','In welchen Amateurfunkfrequenzbereichen beträgt die maximal zulässige belegte Bandbreite einer Aussendung 2,7 kHz?',0,1,0,0,'');
INSERT INTO question VALUES(1858,'VE145','In welchem Amateurfunkfrequenzbereich beträgt die maximal zulässige belegte Bandbreite einer Aussendung 7 kHz?',0,1,0,0,'');
INSERT INTO question VALUES(1859,'VE146','In welchem Amateurfunkfrequenzbereich beträgt die maximal zulässige belegte Bandbreite einer Aussendung 40 kHz?',0,1,0,0,'');
INSERT INTO question VALUES(1860,'VE147','In welchem Amateurfunkfrequenzbereich beträgt die maximal zulässige belegte Bandbreite einer Aussendung 2 MHz bzw. für amplitudenmodulierte Fernsehaussendungen 7 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(1861,'VE148','Ist die Betriebsart "Packet-Radio" mit einer Senderausgangsleistung von 20 Watt im 160-m-Amateurfunkband zulässig?',0,1,0,0,'');
INSERT INTO question VALUES(1862,'VE149','Welche Aussage ist richtig?',0,1,0,0,'');
INSERT INTO question VALUES(1863,'VE150','Wer legt in Deutschland die Bereiche für die unterschiedlichen Betriebsarten in den Amateurfunkbändern verbindlich fest?',0,1,0,0,'');
INSERT INTO question VALUES(1864,'VE151','Was besagt der Hinweis, dass der Frequenzbereich 433,05 - 434,79 MHz als ISM-Frequenzbereich zugewiesen ist?',0,1,0,0,'');
INSERT INTO question VALUES(1865,'VE152','Darf ein Funkamateur mit seinem Amateurfunkgerät Funkverkehr im CB-Funk-Bereich durchführen?',0,1,0,0,'');
INSERT INTO question VALUES(1866,'VE153','Ein Funkamateur ist auch Inhaber einer Frequenzzuteilung für den Betriebsfunk. Darf er anstatt eines zugelassenen Betriebsfunkgerätes auch ein Amateurfunkgerät auf der Betriebsfunkfrequenz betreiben?',0,1,0,0,'');
INSERT INTO question VALUES(1867,'VF101','Enthält das TKG für den Funkamateur anwendbare Regelungen?',0,1,0,0,'');
INSERT INTO question VALUES(1868,'VF102','Bei welcher Handlung verletzt ein Funkamateur das Fernmeldegeheimnis?',0,1,0,0,'');
INSERT INTO question VALUES(1869,'VF103','Wie hat sich ein Funkamateur zu verhalten, der unbeabsichtigt Nachrichten empfängt, die nicht für Funkamateure, die Allgemeinheit oder einen unbestimmten Personenkreis bestimmt sind?',0,1,0,0,'');
INSERT INTO question VALUES(1870,'VF104','Wie hat sich ein Funkamateur zu verhalten, wenn er Sendungen empfängt, die nicht für Funkamateure, die Allgemeinheit oder einen unbestimmten Personenkreis bestimmt sind?',0,1,0,0,'');
INSERT INTO question VALUES(1871,'VF105','Dürfen Sendefunkanlagen ohne Frequenzzuteilung betrieben werden?',0,1,0,0,'');
INSERT INTO question VALUES(1872,'VF106','Welcher der nachfolgend genannten Tatbestände ist eine Ordnungswidrigkeit gemäß TKG?',0,1,0,0,'');
INSERT INTO question VALUES(1873,'VF107','Bei welcher der genannten Apparaturen sind nach dem TKG auch der Besitz und die Herstellung verboten und mit erheblichen Strafen bewehrt?',0,1,0,0,'');
INSERT INTO question VALUES(1874,'VF108','Darf ein Funkamateur eine Sendeanlage betreiben oder besitzen, die Ihrer Form oder Verkleidung nach einen anderen Gegenstand vortäuscht und somit geeignet ist, das nicht öffentlich gesprochene Wort eines anderen unbemerkt abzuhören, oder das Bild eines anderen unbemerkt aufzunehmen?',0,1,0,0,'');
INSERT INTO question VALUES(1875,'VF109','Darf ein Funkamateur eine Funkanlage seiner Amateurfunkstelle zum Abhören des nicht öffentlich gesprochenen Wortes verwenden?',0,1,0,0,'');
INSERT INTO question VALUES(1876,'VG101','Was hat der Funkamateur zu veranlassen, wenn bei ihm der Empfang auf Grund mangelnder Empfängerstörfestigkeit stark beeinträchtigt wird?',0,1,0,0,'');
INSERT INTO question VALUES(1877,'VG102','Darf der Funkamateur von den grundlegenden Anforderungen zur Störfestigkeit im Sinne des Gesetzes über die elektromagnetische Verträglichkeit von Geräten abweichen?',0,1,0,0,'');
INSERT INTO question VALUES(1878,'VG103','Der Empfang einer Amateurfunkaussendung wird auf der Frequenz 145,5 MHz durch einen PC aus der Nachbarschaft elektromagnetisch gestört. Was trifft für diesen Fall nach den Regelungen des EMVG bzw. AFuG zu?',0,1,0,0,'');
INSERT INTO question VALUES(1879,'VG104','Der Empfang einer Amateurfunkaussendung wird auf der Frequenz 7,05 MHz durch eine Alarmanlage aus der Nachbarschaft elektromagnetisch gestört. Was trifft für diesen Fall nach den Regelungen des EMVG bzw. AFuG zu?',0,1,0,0,'');
INSERT INTO question VALUES(1880,'VG105','Eine Zusatzeinrichtung eines Funkamateurs verursacht eine elektromagnetische Störung im Sinne des EMVG bei einer Betriebsfunkanlage in der Nachbarschaft. Welche Maßnahmen sind entsprechend den Regelungen des EMVG zu treffen?',0,1,0,0,'');
INSERT INTO question VALUES(1881,'VG106','Der Empfang einer Amateurfunkaussendung wird auf der dem Amateurfunk sekundär zugewiesenen Frequenz 10,120 MHz durch den Schaltkontakt einer Heizungssteuerung aus der Nachbarschaft gestört. Was trifft für diesen Fall nach den Regelungen des EMVG bzw. AFuG zu?',0,1,0,0,'');
INSERT INTO question VALUES(1882,'VG107','Der Empfang einer Amateurfunkaussendung wird auf der dem Amateurfunk "primär" zugewiesenen Frequenz 7,05 MHz durch den Schaltkontakt einer Heizungssteuerung aus der Nachbarschaft gestört. Was trifft für diesen Fall nach den Regelungen des EMVG bzw. AFuG zu?',0,1,0,0,'');
INSERT INTO question VALUES(1883,'VG108','Durch den Betrieb einer Amateurfunkstelle auf 145,550 MHz wird der UKW-Rundfunkempfang eines Nachbarn gestört. Eine Überprüfung ergibt, dass die Amateurfunkstelle und die Rundfunkempfangsanlage vorschriftsmäßig betrieben werden. Das gestörte Rundfunkgerät hält die nach Norm empfohlene Störfestigkeit ein, der Funkamateur erzeugt jedoch am Ort des gestörten Empfängers eine höhere Feldstärke. Womit muss der Funkamateur rechnen, wenn er seinen Funkbetrieb uneingeschränkt fortsetzt?',0,1,0,0,'');
INSERT INTO question VALUES(1884,'VG109','Durch den Betrieb einer Amateurfunkstelle auf 145,550 MHz wird der Rundfunkempfänger eines Nachbarn auf 100,6 MHz durch Direkteinstrahlung gestört. Eine Überprüfung ergibt, dass der Funkamateur am Ort des gestörten Empfängers eine Feldstärke erzeugt, die den in der Norm empfohlenen Grenzwert für die Störfestigkeit von Geräten nicht erreicht. Was hat der Funkamateur zu tun?',0,1,0,0,'');
INSERT INTO question VALUES(1885,'VG110','Durch den Betrieb einer Amateurfunkstelle auf 144,250 MHz wird der Fernsehempfang eines Nachbarn im Sonderkanal S6 gestört. Eine Überprüfung ergibt, dass der Funkamateur am Ort der gestörten Empfangsanlage eine Feldstärke erzeugt, die den, in der Norm empfohlenen Grenzwert für die Störfestigkeit von Kabelverteilanlagen, nicht erreicht. Was hat der Funkamateur zu tun?',0,1,0,0,'');
INSERT INTO question VALUES(1886,'VG111','Durch den Betrieb einer Amateurfunkstelle wird der Rundfunkempfang eines Nachbarn gestört. Eine Überprüfung ergibt, dass sowohl das gestörte Rundfunkgerät, wie auch die störende Amateurfunkstelle die Vorschriften einhalten und Nachbesserungen nicht mehr möglich sind. Was hat der Funkamateur in diesem Fall zu tun?',0,1,0,0,'');
INSERT INTO question VALUES(1887,'VG112','Durch den Betrieb einer Amateurfunkstelle wird der Fernsehempfang im TV Kanal 10 eines Nachbarn gestört. Eine Überprüfung ergibt, dass sowohl das gestörte Fernsehgerät wie auch die störende Amateurfunkstelle die Vorschriften einhalten und Nachbesserungen nicht mehr möglich sind. Was kann der Funkamateur erwarten, wenn er den störenden Betrieb fortsetzt?',0,1,0,0,'');
INSERT INTO question VALUES(1888,'VG113','Durch den Betrieb einer Amateurfunkstelle wird der Fernsehempfang im TV-Kanal S6 eines Nachbarn gestört. Eine Überprüfung ergibt, dass sowohl das gestörte Fernsehgerät wie auch die störende Amateurfunkstelle die Vorschriften einhalten und Nachbesserungen nicht mehr möglich sind. Was kann der Funkamateur erwarten, wenn er den störenden Betrieb fortsetzt?',0,1,0,0,'');
INSERT INTO question VALUES(1889,'VH101','Welches Gesetz bzw. welche Vorschrift beinhaltet Regelungen für das Inverkehrbringen, den freien Warenverkehr und die Inbetriebnahme, die auch für serienmäßig hergestellte Amateurfunkgeräte gelten?',0,1,0,0,'');
INSERT INTO question VALUES(1890,'VH102','Welche grundlegenden Anforderungen werden entsprechend dem FTEG an Amateurfunkgeräte gestellt?',0,1,0,0,'');
INSERT INTO question VALUES(1891,'VH103','Welche Vorschriften müssen im Handel erhältliche Empfangsfunkanlagen einhalten, die dem Amateurfunk zugewiesene Frequenzen empfangen können?',0,1,0,0,'');
INSERT INTO question VALUES(1892,'VH104','Welche Geräte fallen nicht in den Anwendungsbereich des FTEG?',0,1,0,0,'');
INSERT INTO question VALUES(1893,'VH105','Wird für selbstgefertigte Amateurfunkgeräte der Nachweis auf Einhaltung der technischen Vorschriften verlangt?',0,1,0,0,'');
INSERT INTO question VALUES(1894,'VI101','Wer ist für die Sicherstellung der elektromagnetischen Umweltverträglichkeit verantwortlich?',0,1,0,0,'');
INSERT INTO question VALUES(1895,'VI102','Was müssen Zulassungsinhaber in Bezug auf den Personenschutz einhalten?',0,1,0,0,'');
INSERT INTO question VALUES(1896,'VI103','Was bedeutet die Abkürzung EMVU?',0,1,0,0,'');
INSERT INTO question VALUES(1897,'VI104','In welchem Regelungswerk ist der Schutz von Personen bei der Einwirkung elektromagnetischer Felder auch ausführlich für den Amateurfunk geregelt?',0,1,0,0,'');
INSERT INTO question VALUES(1898,'VI105','In welcher gesetzlichen Regelung ist das Verfahren zum Schutz von Personen in elektromagnetischen Feldern ortsfester Amateurfunkstellen festgelegt?',0,1,0,0,'');
INSERT INTO question VALUES(1899,'VI106','Die Feldstärkegrenzwerte für den Schutz von Personen in elektromagnetischen Feldern sind von der Frequenz abhängig, weil',0,1,0,0,'');
INSERT INTO question VALUES(1900,'VI107','Was versteht man nach der Verordnung über das Nachweisverfahren zur Begrenzung elektromagnetischer Felder (BEMFV) unter dem "Anzeigeverfahren ortsfester Amateurfunkanlagen"?',0,1,0,0,'');
INSERT INTO question VALUES(1901,'VI108','Welchen Status hat im Rahmen der EMVU die Anzeige einer ortsfesten Amateurfunkanlage?',0,1,0,0,'');
INSERT INTO question VALUES(1902,'VI109','Für welche Amateurfunkstellen muss der Schutz von Personen in elektromagnetischen Feldern vom Funkamateur dokumentiert werden?',0,1,0,0,'');
INSERT INTO question VALUES(1903,'VI110','Kann die Bundesnetzagentur für den Betrieb einer ortsfesten Amateurfunkstelle eine Standortbescheinigung fordern?',0,1,0,0,'');
INSERT INTO question VALUES(1904,'VI111','Bis zu welchem Bereich darf der in der Anzeige der ortsfesten Amateurfunkanlage angegebene standortbezogene Sicherheitsabstand höchstens reichen?',0,1,0,0,'');
INSERT INTO question VALUES(1905,'VI112','Welche physikalischen Größen werden für die Angabe der Konfiguration im Rahmen des Anzeigeverfahrens benötigt?',0,1,0,0,'');
INSERT INTO question VALUES(1906,'VI113','Welche der nachfolgenden Aussagen in Bezug auf die Herzschrittmachergrenzwerte ist richtig?',0,1,0,0,'');
INSERT INTO question VALUES(1907,'VI114','Wo sind die im Rahmen des Nachweisverfahrens zur Begrenzung elektromagnetischer Felder die anzuwendenden Grenzwerte zu finden?',0,1,0,0,'');
INSERT INTO question VALUES(1908,'VI115','Wo sind die DIN-Normen mit den Herzschrittmachergrenzwerten zu finden?',0,1,0,0,'');
INSERT INTO question VALUES(1909,'VI116','Wo und wann ist die Anzeige einer ortsfesten Amateurfunkstelle mit einer EIRP von mehr als 10 Watt einzureichen?',0,1,0,0,'');
INSERT INTO question VALUES(1910,'VI117','Was hat ein Funkamateur zu beachten, nachdem er seine ortsfeste Amateurfunkstelle bei der Bundesnetzagentur gemäß BEMFV angezeigt hat?',0,1,0,0,'');
INSERT INTO question VALUES(1911,'VI118','Wo und wann hat der Funkamateur die Dokumentation über die Einhaltung der Anforderungen mit allen erforderlichen Unterlagen gemäß BEMFV einzureichen?',0,1,0,0,'');
INSERT INTO question VALUES(1912,'VI119','Welche Aussendungen von Amateurfunkanlagen müssen bei der Ermittlung des standortbezogenen Sicherheitsabstandes berücksichtigt werden?',0,1,0,0,'');
INSERT INTO question VALUES(1913,'VI120','Für die Berechnung des Sicherheitsabstandes wird in der Regel der Antennengewinnfaktor (G) verwendet. Der Antennengewinnfaktor G ist',0,1,0,0,'');
INSERT INTO question VALUES(1914,'VI121','Wer muss seine Amateurfunkstelle bei der Bundesnetzagentur anzeigen?',0,1,0,0,'');
INSERT INTO question VALUES(1915,'VI122','Von wem müssen die Herzschrittmachergrenzwerte eingehalten werden?',0,1,0,0,'');
INSERT INTO question VALUES(1916,'VI123','Wenn die Herzschrittmachergrenzwerte außerhalb des kontrollierbaren Bereiches überschritten werden, hat der Funkamateur',0,1,0,0,'');
INSERT INTO question VALUES(1917,'VJ101','Nach welchen Vorschriften müssen Außenantennenanlagen errichtet werden?',0,1,0,0,'');
INSERT INTO question VALUES(1918,'VJ102','Welche Vorschriften bezüglich Blitzschutz gelten für Amateurfunkantennenanlagen?',0,1,0,0,'');
INSERT INTO question VALUES(1919,'VJ103','Wie ist die Stromversorgung von Eigenbaugeräten elektrotechnisch sicher aufzubauen?',0,1,0,0,'');
INSERT INTO question VALUES(1920,'VK101','Wer haftet für Schäden, die durch die Antennenanlage einer Amateurfunkstelle entstehen können?',0,1,0,0,'');
INSERT INTO question VALUES(1921,'VK102','Welche regelmäßigen Beiträge hat der Funkamateur zu entrichten?',0,1,0,0,'');
INSERT INTO question VALUES(1922,'VK103','Mit welchen Folgen muss der Funkamateur rechnen, wenn er die zu entrichtenden Gebühren und Beiträge nicht zahlt?',0,1,0,0,'');
INSERT INTO question VALUES(1923,'VK104','Welches Ministerium ist für die Angelegenheiten des Amateurfunkdienstes in Deutschland federführend zuständig?',0,1,0,0,'');
INSERT INTO question VALUES(1924,'VK105','Darf eine Amateurfunkstelle auch an Bord eines Luftfahrzeuges betrieben werden?',0,1,0,0,'');
INSERT INTO question VALUES(1925,'NA103','Laut Datenblatt wiegen 100 m eines bestimmten Drahtes 210 g. Ein vorliegendes Drahtstück desselben Materials wiegt 55 g. Wie lang ist das Drahtstück in etwa?',0,1,0,0,'');
INSERT INTO question VALUES(1926,'NA102','Aus 250 m Draht sollen Antennen hergestellt werden. Pro Antenne werden 18,5 m benötigt. Wie viele Antennen können maximal aus dem vorhandenen Draht hergestellt werden?',0,1,0,0,'');
INSERT INTO question VALUES(1927,'NA101','Ein 20 m langer Draht wird bei 2/3 seiner Länge zertrennt. Wie lang sind die resultierenden Stücke in etwa?',0,1,0,0,'');
INSERT INTO question VALUES(1960,'NA213','Welche Aussage ist für eine Schwingung von 145000000 Perioden pro Sekunde richtig?',0,1,0,0,'');
INSERT INTO question VALUES(1961,'NA212','144000000 Hz entspricht ...',0,1,0,0,'');
INSERT INTO question VALUES(1962,'NA211','0,010 W entspricht ...',0,1,0,0,'');
INSERT INTO question VALUES(1963,'NA210','1 W entspricht ...',0,1,0,0,'');
INSERT INTO question VALUES(1964,'NA209','42 mA entspricht ...',0,1,0,0,'');
INSERT INTO question VALUES(1965,'NA208','4,2 V entspricht ...',0,1,0,0,'');
INSERT INTO question VALUES(1966,'NA207','Wenn s für Sekunde steht, gilt für die Einheit der Frequenz ...',0,1,0,0,'');
INSERT INTO question VALUES(1967,'NA206','Welche Einheit wird üblicherweise für die Frequenz einer elektrischen Schwingung verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(1968,'NA205','Welche Einheit wird üblicherweise für die Wellenlänge verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(1969,'NA204','Welche Einheit wird üblicherweise für die elektrische Leistung verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(1970,'NA203','Welche Einheit wird üblicherweise für den elektrische Widerstand verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(1971,'NA202','Welche Einheit wird üblicherweise für die elektrische Stromstärke verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(1972,'NA201','Welche Einheit wird üblicherweise für die elektrische Spannung verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(1990,'NB104','Die Materialien welcher Gruppe sind bei Raumtemperatur alle Nichtleiter (Isolatoren)?',0,1,0,0,'');
INSERT INTO question VALUES(1991,'NB103','Welches der genannten Metalle hat bei Raumtemperatur die schlechteste elektrische Leitfähigkeit?',0,1,0,0,'');
INSERT INTO question VALUES(1992,'NB102','Welches der genannten Metalle hat bei Raumtemperatur die höchste elektrische Leitfähigkeit?',0,1,0,0,'');
INSERT INTO question VALUES(1993,'NB101','Welches der genannten Metalle hat bei Raumtemperatur die höchste elektrische Leitfähigkeit?',0,1,0,0,'');
INSERT INTO question VALUES(2008,'NB207','Kann in folgender Schaltung von zwei gleichen Spannungsquellen Strom fließen? Welche Begründung ist richtig?<p><img src=''NB207_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2009,'NB206','Welche Spannung zeigt das Spannungsmessgerät in folgender Schaltung? <p><img src=''NB206_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2010,'NB205','Welchen Betrag zeigt das Spannungsmessgerät in folgender Schaltung? <p><img src=''NB205_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2011,'NB204','Folgende Schaltung besteht aus Spannungsquellen von je 1,5 V. Welche Spannung misst man zwischen den Kontakten, die mit "+" und "-" gekennzeichnet sind?<p><img src=''NB204_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2012,'NB203','Wie lauten die Bezeichnungen für die Anschlüsse 1 und 2 im Schaltsymbol?<p><img src=''NB203_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2013,'NB202','Was wird durch dieses Schaltzeichen symbolisiert?<p><img src=''NB202_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2014,'NB201','Welches Bauteil wird durch das Schaltzeichen symbolisiert?<p><img src=''NB201_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2042,'NB304','Welche Polarisationen unterscheidet man üblicherweise bei der Funkwellenausbreitung im Amateurfunk und wieso sollte man diese beachten?',0,1,0,0,'');
INSERT INTO question VALUES(2043,'NB303','Welcher Wellenlänge <img src=''texrender_question_2043_NB303_0.svg''> entspricht in etwa eine Frequenz von 433,500 MHz im Freiraum?',0,1,0,0,'');
INSERT INTO question VALUES(2044,'NB302','Welcher Frequenz <img src=''texrender_question_2044_NB302_0.svg''> entspricht in etwa eine Wellenlänge von 2,08 m im Freiraum?',0,1,0,0,'');
INSERT INTO question VALUES(2045,'NB301','Die Ausbreitungsgeschwindigkeit elektromagnetischer Wellen beträgt im Freiraum etwa ...',0,1,0,0,'');
INSERT INTO question VALUES(2060,'NB405','Was ist im Oszillogramm mit 2 markiert?<p><img src=''NB405_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2061,'NB404','Was ist im Oszillogramm mit 1 markiert?<p><img src=''NB404_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2062,'NB403','Was ist in der dargestellten Momentaufnahme einer Welle mit 2 markiert?<p><img src=''NB403_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2063,'NB402','Was ist in der dargestellten Momentaufnahme einer Welle mit 1 markiert?<p><img src=''NB402_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2064,'NB401','Welches Bild zeigt eine sinusförmige Wechselspannung?',0,1,0,0,'');
INSERT INTO question VALUES(2074,'NB505','Welcher Widerstandswert liegt vor?<p><img src=''NB505_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2075,'NB504','Welche Spannung lässt einen Strom von 90 mA durch den Widerstand fließen?<p><img src=''NB504_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2076,'NB503','Welcher der nachfolgenden Ausdrücke stellt den Zusammenhang zwischen Strom, Spannung und Widerstand korrekt dar?',0,1,0,0,'');
INSERT INTO question VALUES(2077,'NB502','Welcher der nachfolgenden Ausdrücke stellt den Zusammenhang zwischen Strom, Spannung und Widerstand korrekt dar?',0,1,0,0,'');
INSERT INTO question VALUES(2078,'NB501','Welcher der nachfolgenden Ausdrücke stellt den Zusammenhang zwischen Strom, Spannung und Widerstand korrekt dar?',0,1,0,0,'');
INSERT INTO question VALUES(2093,'NB606','Ein gleichspannungsbetriebenes Leuchtmittel ist mit der Angabe 12 V / 48 W bedruckt.  Bei einer 12 V-Versorgung beträgt die Stromentnahme ...',0,1,0,0,'');
INSERT INTO question VALUES(2094,'NB605','Ein Leuchtmittel hat einen Nennwert von 12 V und 3 W. Wie viel Strom fließt beim Anschluss an 12 V?',0,1,0,0,'');
INSERT INTO question VALUES(2095,'NB604','Ein Mobil-Transceiver (Sendeempfänger) wird aus dem Bordnetz eines Kraftfahrzeuges mit 12 V Nennspannung betrieben und hat bei Sendebetrieb eine Leistungsaufnahme von 100 W. Wie groß ist dann die Stromaufnahme?',0,1,0,0,'');
INSERT INTO question VALUES(2096,'NB603','An einem Vorwiderstand fällt bei einem Strom von 20 mA eine Spannung von 3,2 V ab. Wieviel Leistung wird an diesem in Wärme umgesetzt?',0,1,0,0,'');
INSERT INTO question VALUES(2097,'NB602','An einem Vorwiderstand fällt bei einem Strom von 50 mA eine Spannung von 50 V ab. Wieviel Leistung wird an diesem in Wärme umgesetzt?',0,1,0,0,'');
INSERT INTO question VALUES(2098,'NB601','Welche Leistung nimmt ein Transceiver bei 13,8 V Gleichspannung auf, wenn das Strommessgerät im Netzteil 1,5 A anzeigt?',0,1,0,0,'');
INSERT INTO question VALUES(2103,'NB703','Bei welchem der abgebildeten Stromkreise leuchtet die LED?',0,1,0,0,'');
INSERT INTO question VALUES(2104,'NB702','Welches Bild zeigt die technische Stromrichtung korrekt an?',0,1,0,0,'');
INSERT INTO question VALUES(2105,'NB701','Welches Bauteil wird durch das Schaltzeichen symbolisiert?<p><img src=''NB701_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2123,'NC110','Welche Toleranz weist ein Widerstand mit 4 Farbcodes auf, wenn der vierte Farbring braun ist?',0,1,0,0,'');
INSERT INTO question VALUES(2124,'NC109','Welche Toleranz weist ein Widerstand mit 4 Farbcodes auf, wenn der vierte Farbring ein goldener Farbring ist?',0,1,0,0,'');
INSERT INTO question VALUES(2125,'NC108','Welche Toleranz weist ein Widerstand mit 4 Farbcodes auf, wenn der vierte Farbring ein silberner Farbring ist?',0,1,0,0,'');
INSERT INTO question VALUES(2126,'NC107','Die Farbringe gelb, violett und orange auf einem Widerstand mit 4 Farbringen bedeuten einen Widerstandswert von ...',0,1,0,0,'');
INSERT INTO question VALUES(2127,'NC106','Die Farbringe rot, violett und orange auf einem Widerstand mit 4 Farbringen bedeuten einen Widerstandswert von ...',0,1,0,0,'');
INSERT INTO question VALUES(2128,'NC105','Die Farbringe gelb, violett und rot auf einem Widerstand mit 4 Farbringen bedeuten einen Widerstandswert von ...',0,1,0,0,'');
INSERT INTO question VALUES(2129,'NC104','Die Farbringe rot, violett und rot auf einem Widerstand mit 4 Farbringen bedeuten einen Widerstandswert von ...',0,1,0,0,'');
INSERT INTO question VALUES(2130,'NC103','Welche drei Farbringe hat ein 1,2 kOhm Widerstand am Anfang, wenn vier Farbringe verwendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(2131,'NC102','Welchem Multiplikator entspricht ein grüner Farbring auf einem Widerstand mit 4 Farbringen?',0,1,0,0,'');
INSERT INTO question VALUES(2132,'NC101','Welches Bauteil wird durch das Schaltzeichen symbolisiert?<p><img src=''NC101_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2151,'NC201','Welches Bauteil wird durch das Schaltzeichen symbolisiert?<p><img src=''NC201_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2170,'NC301','Welches Bauteil wird durch das Schaltzeichen symbolisiert?<p><img src=''NC301_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2212,'NC404','In welchem der abgebildeten Stromkreise fließt Strom?',0,1,0,0,'');
INSERT INTO question VALUES(2213,'NC403','Wie lauten die Bezeichnungen für die Anschlüsse 1 und 2 im Schaltsymbol?<p><img src=''NC403_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2214,'NC402','Welches Bauteil wird durch das Schaltzeichen symbolisiert?<p><img src=''NC402_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2215,'NC401','Welches Bauteil wird durch das Schaltzeichen symbolisiert?<p><img src=''NC401_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2255,'NC501','Welches Bauteil wird durch das Schaltzeichen symbolisiert?<p><img src=''NC501_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2373,'ND110','Was ist bei der Verwendung von Akkus und Batterien zu beachten?',0,1,0,0,'');
INSERT INTO question VALUES(2374,'ND109','Welche Verbindung stellt der Schutzkontakt in einem Schutzkontakt-Stecker (Schuko-Stecker) her?',0,1,0,0,'');
INSERT INTO question VALUES(2375,'ND108','Welche Sicherheitseinrichtungen werden in hochwertigen Gleichspannungsnetzgeräten vorgehalten?',0,1,0,0,'');
INSERT INTO question VALUES(2376,'ND107','Welche Folge kann eine Verpolung der Leitung vom Netzteil zum Transceiver nach sich ziehen?',0,1,0,0,'');
INSERT INTO question VALUES(2377,'ND106','Worauf ist beim Anschluss eines Gleichspannungsnetzteils an einen Transceiver  besonders zu achten?',0,1,0,0,'');
INSERT INTO question VALUES(2378,'ND105','Wie sind die Klemmen einer 13,8 V Gleichspannungsversorgung gekennzeichnet?',0,1,0,0,'');
INSERT INTO question VALUES(2379,'ND104','Warum ist die Spannungsversorgungsleitung vom externen Netzteil zum Transceiver zweipolig ausgeführt?',0,1,0,0,'');
INSERT INTO question VALUES(2380,'ND103','Warum ist die Spannungsversorgungsleitung vom Gleichspannungsnetzteil zum Transceiver zweipolig ausgeführt?',0,1,0,0,'');
INSERT INTO question VALUES(2381,'ND102','Welche Spannung liefert ein Netzgerät für einen Mobilfunk-Transceiver üblicherweise?',0,1,0,0,'');
INSERT INTO question VALUES(2382,'ND101','Ein Mobilfunktransceiver ist an ein Netzgerät angeschlossen. Welche Aufgabe hat das Netzgerät?',0,1,0,0,'');
INSERT INTO question VALUES(2456,'ND201','Was verstehen Sie unter einem "Oszillator"?',0,1,0,0,'');
INSERT INTO question VALUES(2470,'NE102','In welcher der folgenden Antwortmöglichkeiten sind ausschließlich Modulationsarten enthalten? ',0,1,0,0,'');
INSERT INTO question VALUES(2471,'NE101','Durch Modulation ...',0,1,0,0,'');
INSERT INTO question VALUES(2493,'NE212','Sie können die Sprache beim SSB-Empfang nicht verstehen. Welche Vorgehensweise führt zum Ziel?',0,1,0,0,'');
INSERT INTO question VALUES(2494,'NE211','Im 80 m-Band wird bei Sprechfunk das Modulationsverfahren SSB "Unteres Seitenband" verwendet. Auf welchen "MODE" stellen Sie den Amateurfunk-Empfänger ein?',0,1,0,0,'');
INSERT INTO question VALUES(2495,'NE210','Im 2 m-Band wird das "obere Seitenband" verwendet. Auf welchen "MODE" stellen Sie den Amateurfunk-Transceiver ein?',0,1,0,0,'');
INSERT INTO question VALUES(2496,'NE209','Die Darstellung zeigt das Display eines Transceivers. Was bedeutet die Anzeige "USB"?<p><img src=''NE209_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2497,'NE208','Welche spektrale Darstellung ergibt sich für Einseitenbandmodulation in LSB bei diesem Audiospektrum?<p><img src=''NE208_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2498,'NE207','Welche spektrale Darstellung ergibt sich für Einseitenbandmodulation in USB bei diesem Audiospektrum?<p><img src=''NE207_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2499,'NE206','Welche spektrale Darstellung ergibt sich für die Modulationsart AM bei diesem  Audiospektrum?<p><img src=''NE206_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2500,'NE205','Welche Begriffe sind den Bereichen a und b des Modulationsverfahrens AM zuzuordnen?<p><img src=''NE205_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2501,'NE204','Was ist der Unterschied zwischen LSB und USB?',0,1,0,0,'');
INSERT INTO question VALUES(2502,'NE203','Was ist der Unterschied zwischen AM und SSB?',0,1,0,0,'');
INSERT INTO question VALUES(2503,'NE202','Welche Aussage zur Amplitudenmodulation ist richtig? Durch das Informationssignal ...',0,1,0,0,'');
INSERT INTO question VALUES(2504,'NE201','Wie werden bei "CW" (Continuous Wave) Informationen übertragen?',0,1,0,0,'');
INSERT INTO question VALUES(2524,'NE310','Wie sind zwei FM-Stationen auf der Relaisausgabe zu hören, wenn sie gleich stark und gleichzeitig auf der Relaiseingabe empfangen werden?',0,1,0,0,'');
INSERT INTO question VALUES(2525,'NE309','Welche Modulationsart wird üblicherweise bei analogen VHF/UHF-Relaisfunkstellen für Sprache verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(2526,'NE308','Welche Übertragungsverfahren werden bei VHF/UHF-Relaisfunkstellen für Sprache benutzt?',0,1,0,0,'');
INSERT INTO question VALUES(2527,'NE307','Welche Übertragungsverfahren werden bei VHF/UHF-Handfunkgeräten üblicherweise verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(2528,'NE306','Was kann man tun, wenn der Hub bei einem Handfunkgerät oder Mobil-Transceiver zu groß ist?',0,1,0,0,'');
INSERT INTO question VALUES(2529,'NE305','Die gesamte Bandbreite einer FM-Übertragung beträgt 15 kHz. Wie weit muss die am Transceiver eingestellte Sendefrequenz von einer Bandgrenze mindestens entfernt sein, damit die Aussendung innerhalb des Bandes bleibt?',0,1,0,0,'');
INSERT INTO question VALUES(2530,'NE304','Sie senden mit 2 W in FM auf dem 70 cm-Band. Wie groß ist die angezeigte Sendeleistung, wenn Sie zuerst laut, danach leise und dann nicht mehr in das Mikrofon sprechen?',0,1,0,0,'');
INSERT INTO question VALUES(2531,'NE303','Welche Auswirkung hat Frequenzmodulation (FM) auf die Amplitude des Sendesignals?',0,1,0,0,'');
INSERT INTO question VALUES(2532,'NE302','Welche Antwort beschreibt die Modulationsart "FM"?',0,1,0,0,'');
INSERT INTO question VALUES(2533,'NE301','Welche Aussage zur Frequenzmodulation ist richtig? Durch das Informationssignal ...',0,1,0,0,'');
INSERT INTO question VALUES(2571,'NE405','Was sind "Linkstrecken" und wozu dienen sie im Amateurfunk?',0,1,0,0,'');
INSERT INTO question VALUES(2572,'NE404','Welche Übertragungsverfahren für digitalen Sprechfunk sind im Amateurfunk gebräuchlich?',0,1,0,0,'');
INSERT INTO question VALUES(2573,'NE403','Ist es bei bestimmten digitalen Verfahren zur Sprachübertragung (z. B. DMR oder TETRA) möglich, mehrere Sprechverbindungen gleichzeitig auf derselben Frequenz innerhalb eines Empfangsgebiets abzuwickeln?',0,1,0,0,'');
INSERT INTO question VALUES(2574,'NE402','Sie möchten an einer Funkrunde mittels digitaler Sprachübertragung (z. B. C4FM, DMR oder D-Star) über ein Repeaternetzwerk teilnehmen. Worauf müssen Sie neben der Wahl des Übertragungsverfahrens, der Frequenz und der Modulation achten?',0,1,0,0,'');
INSERT INTO question VALUES(2575,'NE401','Was sollten Sie bei der Übertragung eines Textes per Funkfernschreiben beachten?',0,1,0,0,'');
INSERT INTO question VALUES(2576,'NF118','Was wird unter einem Digipeater verstanden?',0,1,0,0,'');
INSERT INTO question VALUES(2577,'NF117','Welcher unerwünschte Effekt kann eintreten, wenn ein Funkgerät mittels Computer gesteuert wird?',0,1,0,0,'');
INSERT INTO question VALUES(2578,'NF116','Manche Transceiver verfügen über eine sogenannte CAT-Schnittstelle. Dieser Anschluss dient dazu, ...',0,1,0,0,'');
INSERT INTO question VALUES(2579,'NF115','Manche FM-Transceiver verfügen über einen analogen Datenanschluss (z. B. mit DATA beschriftet oder als 9600-Port bezeichnet). Dieser dient im Wesentlichen dazu, ...',0,1,0,0,'');
INSERT INTO question VALUES(2580,'NF114','Wie kann eine Verbindung zwischen Funkgerät und Computer für digitale Übertragungsverfahren (z. B. FT8 oder WSPR) hergestellt werden?',0,1,0,0,'');
INSERT INTO question VALUES(2581,'NF113','Warum befinden sich bei Satellitenbetrieb Up- und Downlink in der Regel nicht im gleichen Frequenzband? Man benutzt unterschiedliche Frequenzbänder, weil ...',0,1,0,0,'');
INSERT INTO question VALUES(2582,'NF112','Ihr QSO-Partner meldet bei einem SSB-QSO im 2 m-Band: "Sie senden nicht exakt auf meiner Frequenz". Was könnte die Ursache sein?',0,1,0,0,'');
INSERT INTO question VALUES(2583,'NF111','Die Gegenstation antwortet Ihrem Anruf in SSB-Sprechfunk auf einer geringfügig abweichenden Frequenz. Was sollten Sie tun, um die Empfangsfrequenz Ihres Transceivers anzupassen, ohne dabei die Sendefrequenz zu verstellen?',0,1,0,0,'');
INSERT INTO question VALUES(2584,'NF110','Ihr Transceiver schaltet automatisch auf Sendung. Was kann die Ursache sein?',0,1,0,0,'');
INSERT INTO question VALUES(2585,'NF109','Wie wird die Einstellung bezeichnet, bei der man einen Transceiver durch die Stimme auf Sendung schalten kann?',0,1,0,0,'');
INSERT INTO question VALUES(2586,'NF108','Wie wird die Taste am Mikrofon bezeichnet, mit der man einen Transceiver auf Sendung schalten kann?',0,1,0,0,'');
INSERT INTO question VALUES(2587,'NF107','Warum sollte ein Sender nie ohne angepasste Antenne oder Dummy Load betrieben werden?',0,1,0,0,'');
INSERT INTO question VALUES(2588,'NF106','Die Darstellung zeigt das Display eines Transceivers. Was wird im Wasserfalldiagramm dargestellt und wie erfolgt die Darstellung?<p><img src=''NF106_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2589,'NF105','Die Darstellung zeigt das Display eines Transceivers. Wie wird die Anzeige 4 bezeichnet?<p><img src=''NF105_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2590,'NF104','Die Darstellung zeigt das Display eines Transceivers. Wie wird die Anzeige 3 bezeichnet?<p><img src=''NF104_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2591,'NF103','Die Darstellung zeigt das Display eines Transceivers im Empfangsbetrieb. Wie wird die Anzeige 2 bezeichnet?<p><img src=''NF103_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2592,'NF102','Die Darstellung zeigt das Display eines Transceivers. Wie wird die Anzeige 2 im Sendebetrieb bezeichnet?<p><img src=''NF102_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2593,'NF101','Die Darstellung zeigt das Display eines Transceivers im Sendebetrieb. Wie wird die Anzeige 1 bezeichnet?<p><img src=''NF101_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2616,'NF201','Was stellt folgendes Blockdiagramm dar?<p><img src=''NF201_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2667,'NF303','Worauf bezieht sich die Empfindlichkeit eines Empfängers?',0,1,0,0,'');
INSERT INTO question VALUES(2668,'NF302','Was muss am Empfänger eingestellt werden, um bei FM das Grundrauschen auszublenden, wenn kein Nutzsignal empfangen wird?',0,1,0,0,'');
INSERT INTO question VALUES(2669,'NF301','Zu welchem Zweck dient das S-Meter in einem Transceiver?',0,1,0,0,'');
INSERT INTO question VALUES(2694,'NF404','Welche Eigenschaft sollte ein hinter einem VHF-Sender geschaltetes Filter haben? Dieses sollte...',0,1,0,0,'');
INSERT INTO question VALUES(2695,'NF403','Das nachfolgende Blockschaltbild zeigt einen einfachen Sender. An welcher Stelle befindet sich welche Stufe?<p><img src=''NF403_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2696,'NF402','Aus welchen Stufen besteht ein einfacher Sender?',0,1,0,0,'');
INSERT INTO question VALUES(2697,'NF401','Was stellt folgendes Blockdiagramm dar?<p><img src=''NF401_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2829,'NG111','Welche Antennenkonfiguration ist zu wählen, wenn möglichst viele umliegende Relaisstationen im 2 m- oder im 70 cm-Band erreicht werden sollen?',0,1,0,0,'');
INSERT INTO question VALUES(2830,'NG110','Welche Antenne ist für eine 2 m-QSO-Runde mit im Umkreis verteilten Funkamateuren am besten geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(2831,'NG109','Welche Antennenform wird von Funkamateuren in der Regel nur im Kurzwellenbereich und <u>nicht</u> im VHF/UHF-Bereich verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(2832,'NG108','Wie wird die dargestellte Antenne bezeichnet?<p><img src=''NG108_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2833,'NG107','Wie wird die dargestellte Antenne bezeichnet?<p><img src=''NG107_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2834,'NG106','Die elektrischen Gegengewichte einer Groundplane-Antenne bezeichnet man auch als ...',0,1,0,0,'');
INSERT INTO question VALUES(2835,'NG105','Wie wird die dargestellte Antenne bezeichnet?<p><img src=''NG105_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2836,'NG104','Eine Marconi-Antenne ist ...',0,1,0,0,'');
INSERT INTO question VALUES(2837,'NG103','Wie wird die dargestellte Antenne bezeichnet?<p><img src=''NG103_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2838,'NG102','Was wird durch dieses Schaltzeichen symbolisiert?<p><img src=''NG102_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2839,'NG101','Welches Bauteil wird durch das Schaltzeichen symbolisiert?<p><img src=''NG101_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2928,'NG208','Das koaxiale 50 Ohm-Antennenkabel der 2 m-Amateurfunkstation wird mit einem gleichwertigen Koaxialkabel verlängert. Die Messung des SWR ergibt nach der Verlängerung einen besseren Wert. Was schließen Sie daraus? Durch die Verlängerung wird...',0,1,0,0,'');
INSERT INTO question VALUES(2929,'NG207','Zwischen VHF/UHF-Transceiver und Antenne soll ein Koaxialkabel verwendet werden. Welche Aspekte sind neben dem richtigen Wellenwiderstand bei der Kabelauswahl zu beachten?',0,1,0,0,'');
INSERT INTO question VALUES(2930,'NG206','Welche der folgenden HF-Steckverbindungs-Systeme sind für hohe Frequenzen (oberhalb 300 MHz) am besten geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(2931,'NG205','Welches HF-Steckverbindungs-System wird in der folgenden Darstellung gezeigt? <p><img src=''NG205_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2932,'NG204','Welches HF-Steckverbindungs-System wird in der folgenden Darstellung gezeigt? <p><img src=''NG204_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2933,'NG203','Welches HF-Steckverbindungs-System wird in der folgenden Darstellung gezeigt? <p><img src=''NG203_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2934,'NG202','Welches HF-Steckverbindungs-System wird in der folgenden Darstellung gezeigt?<p><img src=''NG202_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2935,'NG201','Koaxialkabel weisen typischerweise Wellenwiderstände von ...',0,1,0,0,'');
INSERT INTO question VALUES(2973,'NG305','Ihre selbstgebaute Dipol-Antenne ist oberhalb der gewünschten Frequenz resonant. Welche Änderung können Sie vornehmen, um die Resonanz in den gewünschten Bereich zu bringen?',0,1,0,0,'');
INSERT INTO question VALUES(2974,'NG304','Ihre selbstgebaute Dipol-Antenne ist unterhalb der gewünschten Frequenz resonant. Welche Änderung können Sie vornehmen, um die Resonanz in den gewünschten Bereich zu bringen?',0,1,0,0,'');
INSERT INTO question VALUES(2975,'NG303','Fehlanpassungen oder Beschädigungen von HF-Übertragungsleitungen führen ...',0,1,0,0,'');
INSERT INTO question VALUES(2976,'NG302','Worauf deutet die dargestellte Anzeige des SWR-Meters hin?<p><img src=''NG302_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2977,'NG301','Bei welchem Stehwellenverhältnis (SWR) ist eine Antenne am besten an die Speiseleitung angepasst?',0,1,0,0,'');
INSERT INTO question VALUES(2992,'NG402','Die gleichwertige isotrope Strahlungsleistung EIRP (Equivalent Isotropic Radiated Power) ist die von ...',0,1,0,0,'');
INSERT INTO question VALUES(2993,'NG401','Die effektive Strahlungsleistung ERP (Effective Radiated Power) ist die von ...',0,1,0,0,'');
INSERT INTO question VALUES(3009,'NH102','Warum ist die Ionosphäre ausschlaggebend für die Kurzwellenausbreitung? In der Ionosphäre werden elektromagnetische Wellen durch ...',0,1,0,0,'');
INSERT INTO question VALUES(3010,'NH101','Wie nennt sich der Bereich in der Atmosphäre, in dem die Kurzwellenausbreitung durch Brechung (Refraktion) ermöglicht wird?',0,1,0,0,'');
INSERT INTO question VALUES(3053,'NH201','Was ist ein wesentlicher Faktor für die Ausbreitung von Kurzwellen über die Ionosphäre?',0,1,0,0,'');
INSERT INTO question VALUES(3070,'NH306','Ein Funkamateur sagt, dass auf dem 2 m-Band "Sporadic-E-Bedingungen" herrschen. Er meint damit, dass derzeit ...',0,1,0,0,'');
INSERT INTO question VALUES(3071,'NH305','Bei welcher Ausbreitungsart wird über stark ionisierte Bereiche gearbeitet, die sich vor allem in den Sommermonaten in etwa 100 bis 110 Kilometer Höhe bilden?',0,1,0,0,'');
INSERT INTO question VALUES(3072,'NH304','Welcher Effekt ist normalerweise für die Ausbreitung eines VHF-Signals über 800 bis 1 000 km verantwortlich?',0,1,0,0,'');
INSERT INTO question VALUES(3073,'NH303','In dem folgenden Geländeprofil sei S ein Sender im 2 m-Band. Welche der Empfangsstationen E1 bis E4 wird das Signal des Senders wahrscheinlich am besten empfangen?<p><img src=''NH303_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3074,'NH302','Wie wirkt sich die Antennenhöhe auf die Reichweite einer UKW-Verbindung aus? Die Reichweite steigt mit zunehmender Antennenhöhe, weil ...',0,1,0,0,'');
INSERT INTO question VALUES(3075,'NH301','Wie weit etwa reicht der Funkhorizont im UKW-Bereich über den geografischen Horizont hinaus? Er reicht etwa ...',0,1,0,0,'');
INSERT INTO question VALUES(3085,'NI104','In welcher Schaltung ist ein Multimeter richtig eingesetzt, um den Strom durch den Widerstand und die LED zu messen? ',0,1,0,0,'');
INSERT INTO question VALUES(3086,'NI103','In welcher Schaltung ist ein Multimeter richtig eingesetzt, um die Spannung der Batterie im laufenden Betrieb zu messen?',0,1,0,0,'');
INSERT INTO question VALUES(3087,'NI102','Was wird durch dieses Schaltzeichen symbolisiert?<p><img src=''NI102_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3088,'NI101','Was wird durch dieses Schaltzeichen symbolisiert?<p><img src=''NI101_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3121,'NI203','Ein Stehwellenmessgerät wird in ein ideal angepasstes Sender-/Antennensystem eingeschleift. Das Messgerät sollte ...',0,1,0,0,'');
INSERT INTO question VALUES(3122,'NI202','Wenn das SWR-Meter auf der einen Seite mit der Antenne verbunden ist, was muss dann auf der anderen Seite angeschlossen werden, um Reflexionen zu messen?',0,1,0,0,'');
INSERT INTO question VALUES(3123,'NI201','Mit welchem Messgerät lässt sich die Antennenanpassung bestimmen?',0,1,0,0,'');
INSERT INTO question VALUES(3139,'NI301','Mit welchem Gerät kann die Sendefrequenz eines Senders gemessen werden?  ',0,1,0,0,'');
INSERT INTO question VALUES(3155,'NI401','Was ist der Unterschied zwischen einem Oszillogramm und einem Amplitudenspektrum?',0,1,0,0,'');
INSERT INTO question VALUES(3199,'NJ102','Welche Reaktion ist angebracht, wenn ihr Nachbar sich über Störungen beklagt?',0,1,0,0,'');
INSERT INTO question VALUES(3200,'NJ101','Alle Geräte, die HF-Ströme übertragen, sollten ...',0,1,0,0,'');
INSERT INTO question VALUES(3245,'NJ202','Wie verhindern Sie beim Abgleichen Ihres selbstgebauten Senders Störungen anderer Funkverbindungen?',0,1,0,0,'');
INSERT INTO question VALUES(3246,'NJ201','Ein Sender sollte so betrieben werden, dass ...',0,1,0,0,'');
INSERT INTO question VALUES(3247,'NK102','Um eine Amateurfunkstelle in Bezug auf EMV zu optimieren, ...',0,1,0,0,'');
INSERT INTO question VALUES(3248,'NK101','In Bezug auf EMV sollten HF-Stufen ...',0,1,0,0,'');
INSERT INTO question VALUES(3272,'NK201','Warum muss ein Funkamateur Kenntnisse zum Personenschutz in elektromagnetischen Feldern haben?',0,1,0,0,'');
INSERT INTO question VALUES(3288,'NK311','Was ist bei der Installation von Außenantennen insbesondere zu beachten?',0,1,0,0,'');
INSERT INTO question VALUES(3289,'NK310','Wo sollte aus funktechnischer Sicht eine mobile VHF-Antenne an einem PKW vorzugsweise installiert werden?',0,1,0,0,'');
INSERT INTO question VALUES(3290,'NK309','Um eine Beeinflussung der Elektronik des Kraftfahrzeugs zu verhindern, sollte das Antennenkabel ...',0,1,0,0,'');
INSERT INTO question VALUES(3291,'NK308','Damit die Zulassung eines Kraftfahrzeugs nicht ungültig wird, sind vor dem Einbau einer mobilen Sende-/Empfangseinrichtung grundsätzlich die Anweisungen ...',0,1,0,0,'');
INSERT INTO question VALUES(3292,'NK307','Welche Gefahren können beim unsachgemäßen Anschließen eines Funkgerätes an die 12 V-Batterie in einem Kraftfahrzeug entstehen?',0,1,0,0,'');
INSERT INTO question VALUES(3293,'NK306','Welche Gefahren drohen dem Anwender bei unsachgemäßem Umgang mit wiederaufladbaren Batterien?',0,1,0,0,'');
INSERT INTO question VALUES(3294,'NK305','Feinsicherungen in den Versorgungszuleitungen elektrischer Geräte dienen dem Schutz des jeweiligen Gerätes oder Stromkreises bei Kurzschlüssen. Beim Ersatz einer durchgebrannten Sicherung ...',0,1,0,0,'');
INSERT INTO question VALUES(3295,'NK304','Welche Maßnahme ist nach einem Elektrounfall mit Körperdurchströmung (Stromschlag) zu ergreifen?',0,1,0,0,'');
INSERT INTO question VALUES(3296,'NK303','Welche gefährlichen Folgen kann eine Körperdurchströmung mit elektrischem Strom verursachen?',0,1,0,0,'');
INSERT INTO question VALUES(3297,'NK302','Die größten Gefährdungen durch elektrischen Strom sind insbesondere ...',0,1,0,0,'');
INSERT INTO question VALUES(3298,'NK301','Ab welcher Höhe kann das Berühren elektrischer Wechselspannung (AC) und elektrischer Gleichspannung (DC) für den erwachsenen Menschen lebensgefährlich sein?',0,1,0,0,'');
INSERT INTO question VALUES(1944,'EA116','3750 kHz entspricht ...',0,1,0,0,'');
INSERT INTO question VALUES(1945,'EA115','0,22 μF entspricht ...',0,1,0,0,'');
INSERT INTO question VALUES(1946,'EA114','<img src=''texrender_question_1946_EA114_0.svg''> W entspricht ...',0,1,0,0,'');
INSERT INTO question VALUES(1947,'EA113','<img src=''texrender_question_1947_EA113_0.svg''> W entspricht ...',0,1,0,0,'');
INSERT INTO question VALUES(1948,'EA112','0,002 MOhm entspricht ...',0,1,0,0,'');
INSERT INTO question VALUES(1949,'EA111','0,01 mV entspricht ...',0,1,0,0,'');
INSERT INTO question VALUES(1950,'EA110','4200000 Hz entspricht ...',0,1,0,0,'');
INSERT INTO question VALUES(1951,'EA109','0,042 A entspricht ...',0,1,0,0,'');
INSERT INTO question VALUES(1952,'EA108','0,00042 A entspricht ...',0,1,0,0,'');
INSERT INTO question VALUES(1953,'EA107','Um wie viel Dezibel verändert sich der Leistungspegel, wenn die Leistung verdoppelt wird?',0,1,0,0,'');
INSERT INTO question VALUES(1954,'EA106','Welche Einheit wird üblicherweise für die Datenübertragungsrate verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(1955,'EA105','Welche Einheit wird üblicherweise für die Bandbreite verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(1956,'EA104','Welche Einheit wird üblicherweise für die magnetische Feldstärke verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(1957,'EA103','Welche Einheit wird üblicherweise für die elektrische Feldstärke verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(1958,'EA102','Welche Einheit wird üblicherweise für die Induktivität verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(1959,'EA101','Welche Einheit wird üblicherweise für die Kapazität verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(1973,'EA208','Berechnen Sie den dezimalen Wert der Dualzahl 11111000. Die Dezimalzahl lautet:',0,1,0,0,'');
INSERT INTO question VALUES(1974,'EA207','Berechnen Sie den dezimalen Wert der Dualzahl 10011100. Die Dezimalzahl lautet:',0,1,0,0,'');
INSERT INTO question VALUES(1975,'EA206','Berechnen Sie den dezimalen Wert der Dualzahl 10001110. Die Dezimalzahl lautet:',0,1,0,0,'');
INSERT INTO question VALUES(1976,'EA205','Berechnen Sie den dezimalen Wert der Dualzahl 01001110. Die Dezimalzahl lautet:',0,1,0,0,'');
INSERT INTO question VALUES(1977,'EA204','Wie viele unterschiedliche Werte können mit einer fünfstelligen Dualzahl dargestellt werden?',0,1,0,0,'');
INSERT INTO question VALUES(1978,'EA203','Wie viele unterschiedliche Zustände können mit einer Dualzahl dargestellt werden, die aus einer Folge von 4 Bit besteht?',0,1,0,0,'');
INSERT INTO question VALUES(1979,'EA202','Wie viele unterschiedliche Zustände können mit einer Dualzahl dargestellt werden, die aus einer Folge von 3 Bit besteht?',0,1,0,0,'');
INSERT INTO question VALUES(1980,'EA201','Was ist der Vorteil des binären Zahlensystems gegenüber dem dezimalen Zahlensystem in elektronischen Schaltungen?',0,1,0,0,'');
INSERT INTO question VALUES(2015,'EB105','Wie werden die mit X gekennzeichneten Feldlinien einer Vertikalantenne bezeichnet?<p><img src=''EB105_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2016,'EB104','Ein Kondensator in einer Senderendstufe hat eine 0,15 mm starke PTFE-Folie als Dielektrikum. Die Durchschlagsfestigkeit von PTFE beträgt ca. 400 kV/cm. Wie groß wäre die maximale Spannung, die an den Kondensator angelegt werden kann, ohne dass die Folie durchschlagen wird?',0,1,0,0,'');
INSERT INTO question VALUES(2017,'EB103','An den Metallbelägen eines Wickelkondensators mit 0,15 mm starkem Kunststoff-Dielektrikum liegt eine Spannung von 300 V. Wie hoch ist die elektrische Feldstärke zwischen den Metallbelägen ungefähr?<p><img src=''EB103_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2018,'EB102','An einem Plattenkondensator mit 0,6 cm Plattenabstand werden 9 V angelegt. Wie groß ist die elektrische Feldstärke zwischen den beiden Platten näherungsweise?',0,1,0,0,'');
INSERT INTO question VALUES(2019,'EB101','Welches Feld stellt sich zwischen zwei parallelen Kondensatorplatten bei Anliegen einer Gleichspannung in Näherung ein?<p><img src=''EB101_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2020,'EB206','Wie werden die mit X gekennzeichneten Feldlinien einer Vertikalantenne bezeichnet?<p><img src=''EB206_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2021,'EB205','Welcher Effekt verringert die Induktivität einer von hochfrequentem Strom durchflossenen Spule beim Einführen eines Kupfer- oder Aluminiumkerns?',0,1,0,0,'');
INSERT INTO question VALUES(2022,'EB204','Welcher der nachfolgenden Werkstoffe ist bei Raumtemperatur ein ferromagnetischer Stoff?',0,1,0,0,'');
INSERT INTO question VALUES(2023,'EB203','Ein Ringkern hat einen mittleren Durchmesser von 2,6 cm und trägt 6 Windungen Kupferdraht. Wie groß ist die mittlere magnetische Feldstärke im Ringkern, wenn der Strom 2,5 A beträgt?<p><img src=''EB203_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2024,'EB202','Welches Feld stellt sich im Inneren einer langen Zylinderspule bei Fließen eines Gleichstroms näherungsweise ein?<p><img src=''EB202_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2025,'EB201','Wenn ein konstanter Gleichstrom durch einen gestreckten Leiter fließt, sind die ...',0,1,0,0,'');
INSERT INTO question VALUES(2026,'EB316','Eine Wellenlänge <img src=''texrender_question_2026_EB316_0.svg''> von 10 cm im Freiraum entspricht in etwa einer Frequenz von ...',0,1,0,0,'');
INSERT INTO question VALUES(2027,'EB315','Welche Frequenz entspricht in etwa einer Wellenlänge <img src=''texrender_question_2027_EB315_0.svg''> von 30 mm im Freiraum?',0,1,0,0,'');
INSERT INTO question VALUES(2028,'EB314','Welcher Frequenz <img src=''texrender_question_2028_EB314_0.svg''> entspricht in etwa eine Wellenlänge von 80,0 m im Freiraum?',0,1,0,0,'');
INSERT INTO question VALUES(2029,'EB313','Welcher Wellenlänge <img src=''texrender_question_2029_EB313_0.svg''> entspricht in etwa die Frequenz 28,5 MHz im Freiraum? ',0,1,0,0,'');
INSERT INTO question VALUES(2030,'EB312','Welcher Wellenlänge <img src=''texrender_question_2030_EB312_0.svg''> entspricht in etwa die Frequenz <img src=''texrender_question_2030_EB312_1.svg''> = 21 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(2031,'EB311','Welcher Wellenlänge <img src=''texrender_question_2031_EB311_0.svg''> entspricht in etwa die Frequenz 1,84 MHz im Freiraum?',0,1,0,0,'');
INSERT INTO question VALUES(2032,'EB310','Die Polarisation des Sendesignals in der Hauptstrahlrichtung dieser Richtantenne ist ...<p><img src=''EB310_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2033,'EB309','Die Polarisation des Sendesignals in der Hauptstrahlrichtung dieser Richtantenne ist ...<p><img src=''EB309_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2034,'EB308','Das folgende Bild zeigt eine Momentaufnahme eines elektromagnetischen Feldes. Welche Polarisation hat die skizzierte Welle?<p><img src=''EB308_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2035,'EB307','Das folgende Bild zeigt eine Momentaufnahme eines elektromagnetischen Feldes. Welche Polarisation hat die skizzierte Welle?<p><img src=''EB307_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2036,'EB306','Das folgende Bild zeigt eine Momentaufnahme eines elektromagnetischen Feldes. Welche Polarisation hat die skizzierte Welle?<p><img src=''EB306_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2037,'EB305','Die Polarisation einer elektromagnetischen Welle ist durch die Richtung ...',0,1,0,0,'');
INSERT INTO question VALUES(2038,'EB304','Welche Aussage trifft auf die elektromagnetische Ausstrahlung im ungestörten Fernfeld zu?',0,1,0,0,'');
INSERT INTO question VALUES(2039,'EB303','Der Winkel zwischen den elektrischen und magnetischen Feldkomponenten eines elektromagnetischen Feldes beträgt bei Freiraumausbreitung im Fernfeld ...',0,1,0,0,'');
INSERT INTO question VALUES(2040,'EB302','Wie erfolgt die Ausbreitung einer elektromagnetischen Welle? Die Ausbreitung erfolgt ...',0,1,0,0,'');
INSERT INTO question VALUES(2041,'EB301','Wodurch entsteht ein elektromagnetisches Feld beispielsweise?',0,1,0,0,'');
INSERT INTO question VALUES(2049,'EB411','Welche Frequenz hat das in diesem Schirmbild dargestellte Signal?<p><img src=''EB411_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2050,'EB410','Welche Frequenz hat die in diesem Oszillogramm dargestellte Spannung?<p><img src=''EB410_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2051,'EB409','Welche Frequenz hat die in diesem Oszillogramm dargestellte Spannung in etwa?<p><img src=''EB409_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2052,'EB408','Die Periodendauer von 50 μs entspricht einer Frequenz von ...',0,1,0,0,'');
INSERT INTO question VALUES(2053,'EB407','Wie groß ist der Spitzen-Spitzen-Wert (<img src=''texrender_question_2053_EB407_0.svg''>) der in der Abbildung dargestellten Spannung?<p><img src=''EB407_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2054,'EB406','Wie groß ist der Spitzen-Spitzen-Wert der in diesem Schirmbild dargestellten Spannung?<p><img src=''EB406_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2055,'EB405','Welche der im folgenden Diagramm eingezeichneten Gleichspannungen setzen an einem Wirkwiderstand etwa die gleiche Leistung um wie die dargestellte sinusförmige Wechselspannung?<p><img src=''EB405_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2056,'EB404','Eine sinusförmige Wechselspannung hat einen Spitzenwert von 12 V. Wie groß ist in etwa der Effektivwert der Wechselspannung?',0,1,0,0,'');
INSERT INTO question VALUES(2057,'EB403','Ein sinusförmiges Signal hat einen Effektivwert von 12 V. Wie groß ist in etwa der Spitzen-Spitzen-Wert?',0,1,0,0,'');
INSERT INTO question VALUES(2058,'EB402','Der Spitze-Spitze-Wert der häuslichen 230 V-Spannungsversorgung beträgt ...',0,1,0,0,'');
INSERT INTO question VALUES(2059,'EB401','Der Spitzenwert an einer häuslichen, einphasigen 230 V-Stromversorgung beträgt ...',0,1,0,0,'');
INSERT INTO question VALUES(2079,'EB514','Eine künstliche 50 Ohm-Antenne (Dummy Load) besteht aus 11 parallel geschalteten 560 Ohm-Kohleschichtwiderständen mit einem Belastungsnennwert von jeweils 5 W. Welcher Belastungsnennwert ergibt sich für die künstliche Antenne?',0,1,0,0,'');
INSERT INTO question VALUES(2080,'EB513','Ein Oszilloskop zeigt einen sinusförmigen Spitze-Spitze-Wert von 25 V an einem 1000 Ohm Widerstand an. Der Effektivstrom durch den Widerstand beträgt ...',0,1,0,0,'');
INSERT INTO question VALUES(2081,'EB512','Ein Widerstand von 120 Ohm hat eine Belastbarkeit von 23,0 W. Welcher Strom darf höchstens durch den Widerstand fließen, damit er nicht überlastet wird?',0,1,0,0,'');
INSERT INTO question VALUES(2082,'EB511','Ein Widerstand von 100 kOhm hat eine maximale Spannungsfestigkeit von 1000 V und eine maximale Belastbarkeit von 6 W. Welche Gleichspannung darf höchstens an den Widerstand angelegt werden ohne ihn zu überlasten?',0,1,0,0,'');
INSERT INTO question VALUES(2083,'EB510','Ein Widerstand von 10 kOhm hat eine maximale Spannungsfestigkeit von 700 V und eine maximale Belastbarkeit von 1 W. Welche Gleichspannung darf höchstens an den Widerstand angelegt werden, um ihn im spezifizierten Bereich zu betreiben?',0,1,0,0,'');
INSERT INTO question VALUES(2084,'EB509','Für welche Leistung muss ein 100 Ohm-Widerstand mindestens ausgelegt sein, wenn an ihm 10 V abfallen sollen?',0,1,0,0,'');
INSERT INTO question VALUES(2085,'EB508','Wieviel Leistung wird an einer künstlichen 50 Ohm-Antenne umgesetzt, wenn ein effektiver Strom von 2 A fließt?',0,1,0,0,'');
INSERT INTO question VALUES(2086,'EB507','Der Effektivwert der Spannung an einer künstlichen 50 Ohm-Antenne wird mit 100 V gemessen. Die Leistung an der Last beträgt ...',0,1,0,0,'');
INSERT INTO question VALUES(2087,'EB506','In welcher Antwort sind alle dargestellten Zusammenhänge zwischen Widerstand, Leistung, Spannung und Strom richtig?',0,1,0,0,'');
INSERT INTO question VALUES(2088,'EB505','In welcher Antwort sind alle dargestellten Zusammenhänge zwischen Strom, Spannung, Widerstand und Leistung richtig?',0,1,0,0,'');
INSERT INTO question VALUES(2089,'EB504','An einem Widerstand <img src=''texrender_question_2089_EB504_0.svg''> wird die elektrische Leistung <img src=''texrender_question_2089_EB504_1.svg''> in Wärme umgesetzt. Sie kennen die Größen <img src=''texrender_question_2089_EB504_2.svg''> und <img src=''texrender_question_2089_EB504_3.svg''>. Nach welcher der Formeln können Sie die Spannung ermitteln, die an dem Widerstand <img src=''texrender_question_2089_EB504_4.svg''> anliegt?',0,1,0,0,'');
INSERT INTO question VALUES(2090,'EB503','Gelten die Formeln für die Leistung an einem rein ohmschen Widerstand auch bei Wechselspannung?',0,1,0,0,'');
INSERT INTO question VALUES(2091,'EB502','Die mittlere Leistung eines Senders ist ...',0,1,0,0,'');
INSERT INTO question VALUES(2092,'EB501','Die Spitzenleistung eines Senders (PEP) ist ...',0,1,0,0,'');
INSERT INTO question VALUES(2106,'EC117','Welchen Wert hat ein SMD-Widerstand mit der Kennzeichnung 223?',0,1,0,0,'');
INSERT INTO question VALUES(2107,'EC116','Welchen Wert hat ein SMD-Widerstand mit der Kennzeichnung 221?',0,1,0,0,'');
INSERT INTO question VALUES(2108,'EC115','Welchen Wert hat der dargestellte SMD-Widerstand?<p><img src=''EC115_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2109,'EC114','Wie wird in der Regel bei SMD-Widerständen der Widerstandswert angegeben?',0,1,0,0,'');
INSERT INTO question VALUES(2110,'EC113','Die Farbringe grün, blau und rot sowie ein silberner auf einem Widerstand mit 4 Farbringen bedeuten einen Widerstandswert zwischen ...',0,1,0,0,'');
INSERT INTO question VALUES(2111,'EC112','Ein Widerstand hat eine Toleranz von 10 %. Bei einem nominalen Widerstandswert von 5,6 kOhm liegt der tatsächliche Wert zwischen ...',0,1,0,0,'');
INSERT INTO question VALUES(2112,'EC111','Welches der folgenden Schaltsymbole stellt einen PTC-Widerstand dar?',0,1,0,0,'');
INSERT INTO question VALUES(2113,'EC110','Welches der folgenden Bauteile ist ein NTC-Widerstand?',0,1,0,0,'');
INSERT INTO question VALUES(2114,'EC109','Welches Bauteil hat folgendes Schaltzeichen?<p><img src=''EC109_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2115,'EC108','Welche Widerstände haben eine charakteristische Temperaturabhängigkeit und eignen sich daher besonders zur Temperaturmessung?',0,1,0,0,'');
INSERT INTO question VALUES(2116,'EC107','Eine künstliche Antenne (Dummy Load) für den VHF-Bereich sollte für beste Eigenschaften beispielsweise aus ...',0,1,0,0,'');
INSERT INTO question VALUES(2117,'EC106','Welche der folgenden Bauteile könnten für eine genaue künstliche Antenne (Dummy Load), die bei 50 MHz eingesetzt werden soll, verwendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(2118,'EC105','Welche der folgenden Bauteile könnten für eine gut funktionierende künstliche Antenne (Dummy Load), die bei 28 MHz eingesetzt werden soll, verwendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(2119,'EC104','Welche Eigenschaft sollten Bauteile aufweisen, welche für den Bau von künstlichen Antennen (Dummy Load) zum Einsatz im VHF- und UHF-Bereich verwendet werden.',0,1,0,0,'');
INSERT INTO question VALUES(2120,'EC103','Welche Widerstände sind induktionsarm und eignen sich besonders für den Einsatz bei Frequenzen oberhalb von 30 MHz.',0,1,0,0,'');
INSERT INTO question VALUES(2121,'EC102','Welche Widerstände haben geringe Fertigungstoleranzen und Temperaturabhängigkeit und sind besonders als Präzisionswiderstände geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(2122,'EC101','Welche Widerstände sind besonders als Hochlastwiderstände bei niedrigen Frequenzen geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(2144,'EC207','Bei welcher der folgenden Bauformen von Kondensatoren muss beim Einbau auf die Polarität geachtet werden?',0,1,0,0,'');
INSERT INTO question VALUES(2145,'EC206','Wie nennt man ein Bauelement, bei dem sich Platten auf einer isolierten Achse befinden, die zwischen fest stehenden Platten rotiert werden können?',0,1,0,0,'');
INSERT INTO question VALUES(2146,'EC205','Von welcher der nachfolgenden Größen ist die Kapazität eines Plattenkondensators <u>nicht</u> abhängig?',0,1,0,0,'');
INSERT INTO question VALUES(2147,'EC204','In welchem Fall sinkt die Kapazität eines Plattenkondensators?',0,1,0,0,'');
INSERT INTO question VALUES(2148,'EC203','Wodurch verringert sich die Kapazität eines Plattenkondensators? Durch ...',0,1,0,0,'');
INSERT INTO question VALUES(2149,'EC202','Welches Verhalten zeigt der Wechselstromwiderstand eines idealen Kondensators mit zunehmender Frequenz?',0,1,0,0,'');
INSERT INTO question VALUES(2150,'EC201','Welchen zeitlichen Verlauf hat die Spannung an einem entladenen Kondensator, wenn dieser über einen Widerstand an eine Gleichspannungsquelle angeschlossen wird?',0,1,0,0,'');
INSERT INTO question VALUES(2163,'EC307','Wie ändert sich die Induktivität einer Spule von 12 μH, wenn die Windungszahl bei gleicher Wickellänge verdoppelt wird?<p><img src=''EC307_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2164,'EC306','Vorausgesetzt sind zwei Spulen in gleicher Umgebung, mit gleicher Windungszahl und mit gleicher Querschnittsfläche. Die erste Spule hat eine Induktivität von 12 μH. Die zweite Spule hat die doppelte Länge der ersten Spule. Wie hoch ist die Induktivität der zweiten Spule?<p><img src=''EC306_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2165,'EC305','Wie kann man die Induktivität einer zylindrischen Spule vergrößern?',0,1,0,0,'');
INSERT INTO question VALUES(2166,'EC304','Hat ein gerades Leiterstück eine Induktivität?',0,1,0,0,'');
INSERT INTO question VALUES(2167,'EC303','Welches Verhalten zeigt der Wechselstromwiderstand einer idealen Spule mit zunehmender Frequenz?',0,1,0,0,'');
INSERT INTO question VALUES(2168,'EC302','Schaltet man zwei Leuchtmittel gleichzeitig an eine Gleichspannungsquelle, wobei ein Leuchtmittel, Lampe 1, zum Helligkeitsausgleich über einen Widerstand und das andere, Lampe 2, über eine Spule mit vielen Windungen und Eisenkern angeschlossen ist, so ...<p><img src=''EC302_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2169,'EC301','An eine Spule wird über einen Widerstand eine Gleichspannung angelegt. Welches der nachfolgenden Diagramme zeigt den zeitlichen Verlauf der Spannung über der Spule?',0,1,0,0,'');
INSERT INTO question VALUES(2178,'EC404','An der Primärwicklung eines Transformators mit 150 Windungen liegt eine Spannung von 45 V an. Die Sekundärspannung beträgt 180 V. Wie groß ist die Sekundärwindungszahl?',0,1,0,0,'');
INSERT INTO question VALUES(2179,'EC403','An der Primärwicklung eines Transformators mit 600 Windungen liegt eine Spannung von 230 V an. Die Sekundärspannung beträgt 11,5 V. Wie groß ist die Sekundärwindungszahl?',0,1,0,0,'');
INSERT INTO question VALUES(2180,'EC402','Die Primärspule eines Übertragers hat die fünffache Anzahl von Windungen der Sekundärspule. Wie hoch ist die erwartete Sekundärspannung, wenn die Primärspule an eine 230 V Spannungsversorgung angeschlossen wird?',0,1,0,0,'');
INSERT INTO question VALUES(2181,'EC401','Wie hoch ist die Spannung zwischen den Punkten a und b in dieser Schaltung für ein Transformationsverhältnis von 15:1?<p><img src=''EC401_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2190,'EC522','Folgende Schaltung einer Stabilisierungsschaltung mit Z-Diode ist gegeben. Der Strom durch die Z-Diode soll 25 mA betragen und der Laststrom ist 20 mA. Der Wert des notwendigen Vorwiderstandes beträgt ...<p><img src=''EC522_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2191,'EC521','Eine unbelastete Z-Diode soll eine 13,8 V Betriebsspannung auf 5 V stabilisieren. Dabei soll ein Strom von 30 mA durch die Z-Diode fließen. Der Ausgang der Schaltung soll nicht belastet werden. Berechnen Sie den Wert des Vorwiderstands.<p><img src=''EC521_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2192,'EC520','In welcher der folgenden Schaltungen ist die Z-Diode zur Spannungsstabilisierung richtig eingesetzt?',0,1,0,0,'');
INSERT INTO question VALUES(2193,'EC519','Wozu dient folgende Schaltung?<p><img src=''EC519_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2194,'EC518','Für welchen Zweck werden Z-Dioden primär eingesetzt?',0,1,0,0,'');
INSERT INTO question VALUES(2195,'EC517','Welches Bauteil wird durch das Schaltzeichen symbolisiert?<p><img src=''EC517_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2196,'EC516','Folgende Schaltung einer Leuchtdiode wird an einer Betriebsspannung von 5,5 V betrieben. Der Strom durch die Leuchtdiode soll 25 mA betragen, wobei die Durchlassspannung 1,75 V beträgt. Der notwendige Vorwiderstand muss folgende Werte haben:<p><img src=''EC516_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2197,'EC515','Eine Leuchtdiode mit einer Durchlassspannung von 1,4 V und einem Durchlassstrom von 20 mA soll an eine Spannungsquelle von 5,0 V angeschlossen werden. Berechnen Sie den Vorwiderstand. Die Größe des benötigten Vorwiderstandes beträgt ...',0,1,0,0,'');
INSERT INTO question VALUES(2198,'EC514','Wozu dient die folgende Schaltung?<p><img src=''EC514_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2199,'EC513','Bei welcher Bedingung wird eine Siliziumdiode leitend?',0,1,0,0,'');
INSERT INTO question VALUES(2200,'EC512','Die Auswahlantworten enthalten Siliziumdioden mit unterschiedlichen Arbeitspunkten. Bei welcher Antwort befindet sich die Diode in leitendem Zustand?',0,1,0,0,'');
INSERT INTO question VALUES(2201,'EC511','Die Auswahlantworten enthalten Siliziumdioden mit unterschiedlichen Arbeitspunkten. Bei welcher Antwort befindet sich die Diode in leitendem Zustand?',0,1,0,0,'');
INSERT INTO question VALUES(2202,'EC510','Die Auswahlantworten enthalten Siliziumdioden mit unterschiedlichen Arbeitspunkten. Bei welcher Antwort befindet sich die Diode in leitendem Zustand?',0,1,0,0,'');
INSERT INTO question VALUES(2203,'EC509','Die Auswahlantworten enthalten Siliziumdioden mit unterschiedlichen Arbeitspunkten. Bei welcher Antwort befindet sich die Diode in leitendem Zustand?',0,1,0,0,'');
INSERT INTO question VALUES(2204,'EC508','Welche Diode wird durch Kennlinie 4 charakterisiert?<p><img src=''EC508_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2205,'EC507','Welche Diode wird durch Kennlinie 3 charakterisiert?<p><img src=''EC507_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2206,'EC506','Welche Diode wird durch Kennlinie 2 charakterisiert?<p><img src=''EC506_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2207,'EC505','Welche Diode wird durch Kennlinie 1 charakterisiert?<p><img src=''EC505_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2208,'EC504','Welches sind die Haupteigenschaften einer Schottkydiode?',0,1,0,0,'');
INSERT INTO question VALUES(2209,'EC503','Welche typischen Schwellspannungen haben Germanium- und Siliziumdioden? Sie liegen bei ...',0,1,0,0,'');
INSERT INTO question VALUES(2210,'EC502','Wofür können Halbleiterdioden beispielsweise verwendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(2211,'EC501','Eine in Sperrrichtung betriebene Diode zeichnet sich insbesondere aus durch ...',0,1,0,0,'');
INSERT INTO question VALUES(2240,'EC615','In einer Schaltung wurden die Spannungen der Transistoranschlüsse gegenüber Massepotential gemessen. Bei welchem der folgenden Transistoren fließt Kollektorstrom?',0,1,0,0,'');
INSERT INTO question VALUES(2241,'EC614','In einer Schaltung wurden die Spannungen der Transistoranschlüsse gegenüber Massepotential gemessen. Bei welchem der folgenden Transistoren fließt Kollektorstrom?',0,1,0,0,'');
INSERT INTO question VALUES(2242,'EC613','In einer Schaltung wurden die Spannungen der Transistoranschlüsse gegenüber Massepotential gemessen. Bei welchem der folgenden Transistoren fließt Kollektorstrom?',0,1,0,0,'');
INSERT INTO question VALUES(2243,'EC612','In einer Schaltung wurden die Spannungen der Transistoranschlüsse gegenüber Massepotential gemessen. Bei welchem der folgenden Transistoren fließt Kollektorstrom?',0,1,0,0,'');
INSERT INTO question VALUES(2244,'EC611','Durch welchen Transistoranschluss fliesst im leitenden Zustand der größte Strom?',0,1,0,0,'');
INSERT INTO question VALUES(2245,'EC610','Wie groß muss die Spannung <img src=''texrender_question_2245_EC610_0.svg''> in etwa sein, sodass sich der Transistor im leitenden Betriebszustand befindet?<p><img src=''EC610_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2246,'EC609','Wie bezeichnet man die Anschlüsse des abgebildeten Transistors?<p><img src=''EC609_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2247,'EC608','Wie lauten die Bezeichnungen der Anschlüsse eines bipolaren Transistors?',0,1,0,0,'');
INSERT INTO question VALUES(2248,'EC607','Bei diesem Bauelement handelt es sich um einen <p><img src=''EC607_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2249,'EC606','Bei diesem Bauelement handelt es sich um einen <p><img src=''EC606_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2250,'EC605','Welches Schaltzeichen stellt einen bipolaren Transistor dar?',0,1,0,0,'');
INSERT INTO question VALUES(2251,'EC604','Welche Transistortypen sind bipolare Transistoren?',0,1,0,0,'');
INSERT INTO question VALUES(2252,'EC603','Was versteht man unter Stromverstärkung beim Transistor?',0,1,0,0,'');
INSERT INTO question VALUES(2253,'EC602','Ein Transistor ist ...',0,1,0,0,'');
INSERT INTO question VALUES(2254,'EC601','Welches Bauteil kann als Schalter, Verstärker oder Widerstand eingesetzt werden?',0,1,0,0,'');
INSERT INTO question VALUES(2275,'ED124','Welche Gesamtkapazität hat diese Schaltung, wenn <img src=''texrender_question_2275_ED124_0.svg''> = 200 nF, <img src=''texrender_question_2275_ED124_1.svg''> = 100 nF und <img src=''texrender_question_2275_ED124_2.svg''> = 100000 pF betragen?<p><img src=''ED124_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2276,'ED123','Welche Gesamtkapazität hat die folgende Schaltung? Gegeben: <img src=''texrender_question_2276_ED123_0.svg''> = 8 nF; <img src=''texrender_question_2276_ED123_1.svg''> = 4 nF; <img src=''texrender_question_2276_ED123_2.svg''> = 4 nF<p><img src=''ED123_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2277,'ED122','Welche Gesamtkapazität hat diese Schaltung, wenn <img src=''texrender_question_2277_ED122_0.svg''> = 2 μF, <img src=''texrender_question_2277_ED122_1.svg''> = 1 μF und <img src=''texrender_question_2277_ED122_2.svg''> = 1 μF betragen? <p><img src=''ED122_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2278,'ED121','Welche Gesamtkapazität hat die folgende Schaltung? Gegeben: <img src=''texrender_question_2278_ED121_0.svg''> = 10 nF; <img src=''texrender_question_2278_ED121_1.svg''> = 10 nF; <img src=''texrender_question_2278_ED121_2.svg''> = 5 nF<p><img src=''ED121_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2279,'ED120','Welche Gesamtkapazität ergibt sich bei einer Reihenschaltung der Kondensatoren 100 μF, 200000 nF und 200 μF?',0,1,0,0,'');
INSERT INTO question VALUES(2280,'ED119','Eine Reihenschaltung besteht aus drei Kondensatoren von je 0,33 μF. Wie groß ist die Gesamtkapazität dieser Schaltung?',0,1,0,0,'');
INSERT INTO question VALUES(2281,'ED118','Wie groß ist die Gesamtkapazität von drei parallel geschalteten Kondensatoren von 22 nF, 0,033 μF und 15000 pF?',0,1,0,0,'');
INSERT INTO question VALUES(2282,'ED117','Drei Kondensatoren mit den Kapazitäten <img src=''texrender_question_2282_ED117_0.svg''> = 0,1 μF, <img src=''texrender_question_2282_ED117_1.svg''> = 150 nF und <img src=''texrender_question_2282_ED117_2.svg''> = 50000 pF werden parallel geschaltet. Wie groß ist die Gesamtkapazität?',0,1,0,0,'');
INSERT INTO question VALUES(2283,'ED116','Wie groß ist der Gesamtwiderstand der dargestellten Schaltung?<p><img src=''ED116_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2284,'ED115','Wie groß ist der Gesamtwiderstand der dargestellten Schaltung?<p><img src=''ED115_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2285,'ED114','Wie groß ist der Gesamtwiderstand der dargestellten Schaltung?<p><img src=''ED114_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2286,'ED113','Wie groß ist der Gesamtwiderstand dieser Schaltung, wenn <img src=''texrender_question_2286_ED113_0.svg''> = 10 kOhm, <img src=''texrender_question_2286_ED113_1.svg''> = 2,5 kOhm, <img src=''texrender_question_2286_ED113_2.svg''> = 500 Ohm und <img src=''texrender_question_2286_ED113_3.svg''> = 600 Ohm betragen? <p><img src=''ED113_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2287,'ED112','Wie groß ist der Gesamtwiderstand dieser Schaltung, wenn <img src=''texrender_question_2287_ED112_0.svg''> = 1 kOhm, <img src=''texrender_question_2287_ED112_1.svg''> = 3 kOhm und <img src=''texrender_question_2287_ED112_2.svg''> = 1500 Ohm betragen?<p><img src=''ED112_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2288,'ED111','Wie groß ist der Gesamtwiderstand der Schaltung? Gegeben: <img src=''texrender_question_2288_ED111_0.svg''> = 1 kOhm, <img src=''texrender_question_2288_ED111_1.svg''> = 2000 Ohm und <img src=''texrender_question_2288_ED111_2.svg''> = 2 kOhm<p><img src=''ED111_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2289,'ED110','Wie groß ist der Gesamtwiderstand der Schaltung? Gegeben: <img src=''texrender_question_2289_ED110_0.svg''> = 500 Ohm, <img src=''texrender_question_2289_ED110_1.svg''> = 1000 Ohm und <img src=''texrender_question_2289_ED110_2.svg''> = 1 kOhm<p><img src=''ED110_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2290,'ED109','Wie groß ist der Gesamtwiderstand der Schaltung? Gegeben: <img src=''texrender_question_2290_ED109_0.svg''> = 500 Ohm, <img src=''texrender_question_2290_ED109_1.svg''> = 1,5 kOhm und <img src=''texrender_question_2290_ED109_2.svg''> = 2 kOhm<p><img src=''ED109_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2291,'ED108','Wie groß ist der Gesamtwiderstand der Schaltung? Gegeben: <img src=''texrender_question_2291_ED108_0.svg''> = 500 Ohm, <img src=''texrender_question_2291_ED108_1.svg''> = 500 Ohm und <img src=''texrender_question_2291_ED108_2.svg''> = 1 kOhm<p><img src=''ED108_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2292,'ED107','Welche Belastbarkeit kann die Zusammenschaltung von drei gleich großen Widerständen mit einer Einzelbelastbarkeit von je 1 W erreichen, wenn alle 3 Widerstände entweder parallel oder in Reihe geschaltet werden?',0,1,0,0,'');
INSERT INTO question VALUES(2293,'ED106','Drei gleich große parallel geschaltete Widerstände haben einen Gesamtwiderstand von 1,7 kOhm. Welchen Wert hat jeder Einzelwiderstand?',0,1,0,0,'');
INSERT INTO question VALUES(2294,'ED105','Zwei Widerstände mit <img src=''texrender_question_2294_ED105_0.svg''> = 50 Ohm und <img src=''texrender_question_2294_ED105_1.svg''> = 200 Ohm sind parallel geschaltet. Wie groß ist der Gesamtwiderstand?',0,1,0,0,'');
INSERT INTO question VALUES(2295,'ED104','Zwei Widerstände mit <img src=''texrender_question_2295_ED104_0.svg''> und <img src=''texrender_question_2295_ED104_1.svg''> sind parallel geschaltet. Wie groß ist der Gesamtwiderstand?',0,1,0,0,'');
INSERT INTO question VALUES(2296,'ED103','Die Gesamtspannung <img src=''texrender_question_2296_ED103_0.svg''> an folgendem Spannungsteiler beträgt 9 V. Die Widerstände haben die Werte <img src=''texrender_question_2296_ED103_1.svg''> = 10 kOhm und <img src=''texrender_question_2296_ED103_2.svg''> = 20 kOhm. Wie groß ist die Teilspannung <img src=''texrender_question_2296_ED103_3.svg''>?<p><img src=''ED103_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2297,'ED102','Wie teilt sich die Spannung an zwei in Reihe geschalteten Widerständen auf, wenn <img src=''texrender_question_2297_ED102_0.svg''> von <img src=''texrender_question_2297_ED102_1.svg''> ist? <p><img src=''ED102_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2298,'ED101','Wie teilt sich die Spannung an zwei in Reihe geschalteten Widerständen auf, wenn <img src=''texrender_question_2298_ED101_0.svg''> = 5-mal so groß ist wie <img src=''texrender_question_2298_ED101_1.svg''>?<p><img src=''ED101_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2328,'ED216','Welche Kondensatoren sollen vorzugsweise für HF-Filter verwendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(2329,'ED215','Was stellt die folgende Schaltung dar? <p><img src=''ED215_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2330,'ED214','Was stellt die folgende Schaltung dar? <p><img src=''ED214_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2331,'ED213','Welche Schaltung stellt ein Hochpassfilter dar?',0,1,0,0,'');
INSERT INTO question VALUES(2332,'ED212','Was stellt die folgende Schaltung dar? <p><img src=''ED212_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2333,'ED211','Was stellt die folgende Schaltung dar? <p><img src=''ED211_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2334,'ED210','Welche Schaltung könnte für die Tiefpassfilterung in einem Mikrofonverstärker eingesetzt werden?',0,1,0,0,'');
INSERT INTO question VALUES(2335,'ED209','Was stellt die folgende Schaltung dar? <p><img src=''ED209_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2336,'ED208','Was stellt die folgende Schaltung dar? <p><img src=''ED208_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2337,'ED207','Wie verhält sich ein Parallelschwingkreis bei der Resonanzfrequenz?',0,1,0,0,'');
INSERT INTO question VALUES(2338,'ED206','Der im folgenden Bild dargestellte Impedanzfrequenzgang ist typisch für ...<p><img src=''ED206_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2339,'ED205','Der im folgenden Bild dargestellte Impedanzfrequenzgang ist typisch für ...<p><img src=''ED205_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2340,'ED204','Wie wird die dargestellte Filtercharakteristik bezeichnet?<p><img src=''ED204_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2341,'ED203','Wie wird die dargestellte Filtercharakteristik bezeichnet?<p><img src=''ED203_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2342,'ED202','Wie wird die dargestellte Filtercharakteristik bezeichnet?<p><img src=''ED202_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2343,'ED201','Wie wird die dargestellte Filtercharakteristik bezeichnet?<p><img src=''ED201_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2369,'ED304','Welchen Verlauf hat die Spannung <img src=''texrender_question_2369_ED304_0.svg''>?<p><img src=''ED304_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2370,'ED303','Welches ist der Hauptnachteil eines Schaltnetzteils ?',0,1,0,0,'');
INSERT INTO question VALUES(2371,'ED302','Welche Eigenschaften hat ein Schaltnetzteil?',0,1,0,0,'');
INSERT INTO question VALUES(2372,'ED301','Welche Eigenschaften sollten Gleichspannungsquellen aufweisen?',0,1,0,0,'');
INSERT INTO question VALUES(2416,'ED403','Für welchen Zweck werden HF-Leistungsverstärker eingesetzt?',0,1,0,0,'');
INSERT INTO question VALUES(2417,'ED402','Worum handelt es sich bei dieser Schaltung?<p><img src=''ED402_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2418,'ED401','Was versteht man in der Elektronik unter Leistungsverstärkung?',0,1,0,0,'');
INSERT INTO question VALUES(2449,'ED507','Der Vorteil von Quarzoszillatoren gegenüber LC-Oszillatoren liegt darin, dass sie ...',0,1,0,0,'');
INSERT INTO question VALUES(2450,'ED506','Bei einem Quarz-Oszillator handelt es sich um einen Schwingungserzeuger, bei dem die Frequenz ...',0,1,0,0,'');
INSERT INTO question VALUES(2451,'ED505','Wie verhält sich die Frequenz eines LC-Oszillators, wenn bei zunehmender Temperatur die Induktivität der Spule kleiner wird?',0,1,0,0,'');
INSERT INTO question VALUES(2452,'ED504','Wie verhält sich die Frequenz eines LC-Oszillators, wenn bei zunehmender Temperatur die Induktivität der Spule größer wird?',0,1,0,0,'');
INSERT INTO question VALUES(2453,'ED503','Wie verhält sich die Frequenz eines LC-Oszillators, wenn bei zunehmender Temperatur die Kapazität des Kondensators kleiner wird?',0,1,0,0,'');
INSERT INTO question VALUES(2454,'ED502','Wie verhält sich die Frequenz eines LC-Oszillators, wenn bei zunehmender Temperatur die Kapazität des Kondensators größer wird?',0,1,0,0,'');
INSERT INTO question VALUES(2455,'ED501','Was ist ein LC-Oszillator? Es ist ein Schwingungserzeuger, wobei die Frequenz ...',0,1,0,0,'');
INSERT INTO question VALUES(2469,'EE101','Welches der folgenden Diagramme zeigt einen unmodulierten Träger?',0,1,0,0,'');
INSERT INTO question VALUES(2486,'EE207','Wie groß ist die Bandbreite von CW im Vergleich zu einem Sprachsignal in SSB oder AM?',0,1,0,0,'');
INSERT INTO question VALUES(2487,'EE206','Was bewirkt eine zu geringe Mikrofonverstärkung bei einem SSB-Transceiver?',0,1,0,0,'');
INSERT INTO question VALUES(2488,'EE205','Welche der aufgeführten Maßnahmen verringert die Ausgangsleistung eines SSB-Senders?',0,1,0,0,'');
INSERT INTO question VALUES(2489,'EE204','Ein Träger von 3,65 MHz wird mit der NF-Frequenz von 2 kHz in SSB (LSB) moduliert. Welche Frequenz/Frequenzen treten im modulierten HF-Signal hauptsächlich auf?',0,1,0,0,'');
INSERT INTO question VALUES(2490,'EE203','Ein Träger von 21,250 MHz wird mit der NF-Frequenz von 1 kHz in SSB (USB) moduliert. Welche Frequenz tritt im ideal modulierten HF-Signal auf?',0,1,0,0,'');
INSERT INTO question VALUES(2491,'EE202','Wie groß ist in etwa die HF-Bandbreite, die für die Übertragung eines SSB-Signals erforderlich ist?',0,1,0,0,'');
INSERT INTO question VALUES(2492,'EE201','Wie unterscheidet sich SSB von AM in Bezug auf die Bandbreite?',0,1,0,0,'');
INSERT INTO question VALUES(2518,'EE306','Wodurch wird bei Frequenzmodulation die Lautstärke-Information übertragen?',0,1,0,0,'');
INSERT INTO question VALUES(2519,'EE305','Durch welche Maßnahme kann eine zu große Bandbreite einer FM-Aussendung verringert werden? Durch die Verringerung der ...',0,1,0,0,'');
INSERT INTO question VALUES(2520,'EE304','Größerer Frequenzhub führt bei einem FM-Sender zu ...',0,1,0,0,'');
INSERT INTO question VALUES(2521,'EE303','Welches der nachfolgenden Modulationsverfahren wird am wenigsten durch Amplitudenstörungen in Kraftfahrzeugen beeinträchtigt?',0,1,0,0,'');
INSERT INTO question VALUES(2522,'EE302','FM hat gegenüber SSB den Vorteil der ...',0,1,0,0,'');
INSERT INTO question VALUES(2523,'EE301','Welches Modulationsverfahren zeigt das Bild?<p><img src=''EE301_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2556,'EE415','Welcher Unterschied zwischen ATV und SSTV ist richtig?',0,1,0,0,'');
INSERT INTO question VALUES(2557,'EE414','Kann das Internetprotokoll (IP) im Amateurfunk verwendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(2558,'EE413','Was ergibt sich aus der eingestellten IP-Adresse und Subnetzmaske einer Kommunikationsschnittstelle beim Internetprotokoll (IP)?',0,1,0,0,'');
INSERT INTO question VALUES(2559,'EE412','Wie können Informationen innerhalb eines paketvermittelten Netzes zwischen zwei Stationen ausgetauscht werden, die sich nicht direkt erreichen können?',0,1,0,0,'');
INSERT INTO question VALUES(2560,'EE411','Wie werden bei Codemultiplexverfahren (CDMA) mehrere Signale gleichzeitig übertragen?',0,1,0,0,'');
INSERT INTO question VALUES(2561,'EE410','Wie werden bei Frequenzmultiplexverfahren (FDMA) mehrere Signale gleichzeitig übertragen?',0,1,0,0,'');
INSERT INTO question VALUES(2562,'EE409','Wie werden bei Zeitmultiplexverfahren (TDMA) mehrere Signale gleichzeitig übertragen?',0,1,0,0,'');
INSERT INTO question VALUES(2563,'EE408','Was ist Audio Frequency Shift Keying (AFSK)?',0,1,0,0,'');
INSERT INTO question VALUES(2564,'EE407','Welches der folgenden Diagramme zeigt einen erkennbar durch Frequenzumtastung (FSK) modulierten Träger?',0,1,0,0,'');
INSERT INTO question VALUES(2565,'EE406','Welches der folgenden Diagramme zeigt einen erkennbar durch Amplitudenumtastung (ASK) modulierten Träger?',0,1,0,0,'');
INSERT INTO question VALUES(2566,'EE405','Wie können Sie automatische Empfangsberichte zu Aussendungen erhalten, z. B. um die Reichweite ihrer Sendeanlage zu testen?',0,1,0,0,'');
INSERT INTO question VALUES(2567,'EE404','Wie viele digitale Signale unterschiedlicher Stationen können mit einem analogen Funkgerät (2,4 kHz SSB-Bandbreite) und einem über die Audio-Schnittstelle angeschlossenen Computer gleichzeitig empfangen und dekodiert werden?',0,1,0,0,'');
INSERT INTO question VALUES(2568,'EE403','Bei der Aussendung eines digitalen Signals mittels eines Funkgerätes in SSB-Einstellung beträgt die NF-Bandbreite des in das Funkgerät eingespeisten Signals 50 Hz. Wie groß ist die HF-Bandbreite?',0,1,0,0,'');
INSERT INTO question VALUES(2569,'EE402','Welche Modulation wird am Transceiver eingestellt, um ein schmalbandiges digitales Signal (z. B. BPSK31 oder FT8), das per Audiosignal als NF eingespeist wird, unter Beibehaltung der Bandbreite in HF umzusetzen?',0,1,0,0,'');
INSERT INTO question VALUES(2570,'EE401','Welcher Unterschied besteht zwischen der Bandbreite und der Datenübertragungsrate?',0,1,0,0,'');
INSERT INTO question VALUES(2614,'EF102','Welchen Vorteil bietet ein Überlagerungsempfänger gegenüber einem Geradeaus-Empfänger?',0,1,0,0,'');
INSERT INTO question VALUES(2615,'EF101','Was stellt nachfolgende Schaltung dar?<p><img src=''EF101_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2648,'EF219','Manche FM-Transceiver verfügen über einen analogen Datenanschluss (z. B. mit DATA beschriftet oder als 9600-Port bezeichnet). Welcher Punkt im dargestellten Empfangszweig wird über diesen Anschluss üblicherweise herausgeführt?<p><img src=''EF219_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2649,'EF218','An welcher Stelle einer Amateurfunkanlage sollte ein UHF-Vorverstärker eingefügt werden?',0,1,0,0,'');
INSERT INTO question VALUES(2650,'EF217','Welche Baugruppe vermindert die Übersteuerung eines Empfängereingangs?',0,1,0,0,'');
INSERT INTO question VALUES(2651,'EF216','Welches Diagramm stellt den Frequenzverlauf eines Empfänger-Notchfilters dar?',0,1,0,0,'');
INSERT INTO question VALUES(2652,'EF215','Welche Baugruppe kann empfangsseitig Störungen in einem schmalen Frequenzbereich unterdrücken?',0,1,0,0,'');
INSERT INTO question VALUES(2653,'EF214','Welche Baugruppe könnte in einem Empfänger gegebenenfalls dazu verwendet werden, impulsförmige Störungen auszublenden?',0,1,0,0,'');
INSERT INTO question VALUES(2654,'EF213','Welche Aufgabe hat das Rauschunterdrückungsverfahren (Noise Reduction) in einem Empfänger?',0,1,0,0,'');
INSERT INTO question VALUES(2655,'EF212','Was bedeutet an einem Schalter eines Empfängers die Abkürzung AGC?',0,1,0,0,'');
INSERT INTO question VALUES(2656,'EF211','Womit werden Pegelschwankungen des NF-Ausgangssignals verringert, die durch Schwankungen im HF-Eingangssignal hervorgerufen werden?',0,1,0,0,'');
INSERT INTO question VALUES(2657,'EF210','Wozu führt eine schmale Empfängerbandbreite?',0,1,0,0,'');
INSERT INTO question VALUES(2658,'EF209','Welchem Zweck dient ein BFO in einem Empfänger?<p><img src=''EF209_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2659,'EF208','Wo liegt bei einem Direktüberlagerungsempfänger üblicherweise die Oszillatorfrequenz für den Mischer?',0,1,0,0,'');
INSERT INTO question VALUES(2660,'EF207','Wie sollte ein Oszillator aufgebaut werden, um unerwünschte Abstrahlungen zu vermeiden?',0,1,0,0,'');
INSERT INTO question VALUES(2661,'EF206','Wie sollte eine Mischstufe beschaffen sein, um unerwünschte Abstrahlungen zu vermeiden?',0,1,0,0,'');
INSERT INTO question VALUES(2662,'EF205','Welches sind die erwünschten Produkte, die bei der Mischung der Frequenzen 136 MHz und 145 MHz am Ausgang des Mischers entstehen?',0,1,0,0,'');
INSERT INTO question VALUES(2663,'EF204','Einem Mischer werden die Frequenzen 136 MHz und 145 MHz zugeführt. Welche Mischfrequenzen werden hauptsächlich erzeugt?',0,1,0,0,'');
INSERT INTO question VALUES(2664,'EF203','Welches sind die erwünschten Produkte, die bei der Mischung der Frequenzen 30 MHz und 39 MHz am Ausgang des Mischers entstehen?',0,1,0,0,'');
INSERT INTO question VALUES(2665,'EF202','Einem Mischer werden die Frequenzen 28 MHz und 38,7 MHz zugeführt. Welche Mischfrequenzen werden hauptsächlich erzeugt?',0,1,0,0,'');
INSERT INTO question VALUES(2666,'EF201','Welche wesentlichen Ausgangsfrequenzen erzeugt die in der Abbildung dargestellte Stufe?<p><img src=''EF201_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2684,'EF310','Welche Bandbreite sollte das nachgeschaltete Filter zur Unterdrückung eines Seitenbandes bei der Erzeugung eines SSB-Telefoniesignals haben?',0,1,0,0,'');
INSERT INTO question VALUES(2685,'EF309','Welcher der eingezeichneten Punkte in einem FM-Sender ist für die Zuführung eines 9600-Baud-Datensignals am besten geeignet?<p><img src=''EF309_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2686,'EF308','Über welche Bandbreite sollte der in der Blockschaltung dargestellte NF-Verstärker für eine gute Sprachverständlichkeit mindestens verfügen?<p><img src=''EF308_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2687,'EF307','Welcher Frequenzgang ist am besten für den Mikrofonverstärker eines Sprechfunkgeräts geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(2688,'EF306','Wie heißt die Stufe in einem Sender, welche die Eigenschaft hat, leise Anteile eines Sprachsignale gegenüber den lauten etwas anzuheben?',0,1,0,0,'');
INSERT INTO question VALUES(2689,'EF305','Was bewirkt die ALC (Automatic Level Control) bei zu starkem NF-Signal in einem Transceiver?',0,1,0,0,'');
INSERT INTO question VALUES(2690,'EF304','Der VFO eines Senders ist schwankenden Temperaturen unterworfen. Welche wesentliche Auswirkung könnte dies haben?',0,1,0,0,'');
INSERT INTO question VALUES(2691,'EF303','Das Blockschaltbild stellt die Frequenzaufbereitung eines Mehrbandsenders dar. Welche Frequenz entsteht am Ausgang a, wenn der VFO auf 3,51 MHz eingestellt ist?<p><img src=''EF303_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2692,'EF302','Am Ausgang a dieser Frequenzaufbereitung wird eine Frequenz von 21,360 MHz gemessen. Welche Frequenz hat der VFO?<p><img src=''EF302_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2693,'EF301','Auf welcher Frequenz muss der Quarzoszillator schwingen, damit nach dem Blockschaltbild von der PA die Frequenz 145,200 MHz verstärkt wird?<p><img src=''EF301_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2726,'EF405','Wie sollte die Stromzufuhr in einem Sender beschaffen sein?',0,1,0,0,'');
INSERT INTO question VALUES(2727,'EF404','Wann sollte ein Sender auf mögliche Oberwellenaussendungen überprüft werden?',0,1,0,0,'');
INSERT INTO question VALUES(2728,'EF403','Wie ist die Ausgangsstufe eines SSB-Senders aufgebaut?  ',0,1,0,0,'');
INSERT INTO question VALUES(2729,'EF402','Wie und wo wird die Ausgangsleistung eines SSB-Senders gemessen? Die maximale Hüllkurvenleistung (PEP) wird gemessen...',0,1,0,0,'');
INSERT INTO question VALUES(2730,'EF401','Die Ausgangsleistung eines Senders ist die unmittelbar nach ...',0,1,0,0,'');
INSERT INTO question VALUES(2733,'EF505','Warum soll der Lokaloszillator (XO) in einem Transverter für Satellitenbetrieb mit einer Uplinkfrequenz von 2,4 GHz temperaturstabilisiert oder durch ein höherwertiges Frequenznormal synchronisiert sein?',0,1,0,0,'');
INSERT INTO question VALUES(2734,'EF504','Was stellt die nachfolgende Schaltung dar?<p><img src=''EF504_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2735,'EF503','Was stellt folgendes Blockschaltbild dar?<p><img src=''EF503_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2736,'EF502','Durch welchen Vorgang setzt ein Transverter einen Frequenzbereich in einen anderen um?',0,1,0,0,'');
INSERT INTO question VALUES(2737,'EF501','Welche der nachfolgenden Antworten trifft für die Wirkungsweise eines Transverters zu? Ein Transverter setzt...',0,1,0,0,'');
INSERT INTO question VALUES(2775,'EF603','Worauf deutet die Bezeichnung SDR bei einem Transceiver oder Empfänger hin?',0,1,0,0,'');
INSERT INTO question VALUES(2776,'EF602','Was ist die Voraussetzung, um ein analoges Signal mit digitaler Signalverarbeitung zu filtern? Das Eingangssignal muss zunächst ...',0,1,0,0,'');
INSERT INTO question VALUES(2777,'EF601','Folgendes Blockschaltbild stellt das Prinzip einer digitalen Signalverarbeitung dar. Welche Aufgaben haben die beiden Blöcke 1 und 2?<p><img src=''EF601_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2815,'EG114','Welcher Durchmesser sollte für eine Parabolspiegelantenne im Hinblick auf möglichst hohen Gewinn gewählt werden?',0,1,0,0,'');
INSERT INTO question VALUES(2816,'EG113','Eine scharf bündelnde Antenne für den Mikrowellenbereich besteht häufig aus einem ...',0,1,0,0,'');
INSERT INTO question VALUES(2817,'EG112','Welcher Standort ist für eine HF-Richtantenne am besten geeignet, um mögliche Beeinflussungen bei den Geräten des Nachbarn zu vermeiden?',0,1,0,0,'');
INSERT INTO question VALUES(2818,'EG111','Das folgende Bild enthält eine einfache Richtantenne. Die Bezeichnungen der Elemente in numerischer Reihenfolge lauten ...<p><img src=''EG111_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2819,'EG110','Die Länge des Drahtes zur Herstellung eines Faltdipols entspricht ...',0,1,0,0,'');
INSERT INTO question VALUES(2820,'EG109','Berechnen Sie die elektrische Länge eines 5/8 <img src=''texrender_question_2820_EG109_0.svg''> langen Vertikalstrahlers für das 10 m-Band (28,5 MHz).',0,1,0,0,'');
INSERT INTO question VALUES(2821,'EG108','Warum ist eine 5/8-<img src=''texrender_question_2821_EG108_0.svg''>-Antenne besser als eine <img src=''texrender_question_2821_EG108_1.svg''>/4-Antenne für VHF-UHF-Mobilbetrieb geeignet? Sie ...',0,1,0,0,'');
INSERT INTO question VALUES(2822,'EG107','Sie wollen verschiedene Antennen für den Funkbetrieb auf Kurzwelle für das 80 m-Band testen. Welche drei Antennen sind besonders geeignet?  ',0,1,0,0,'');
INSERT INTO question VALUES(2823,'EG106','Was sind gebräuchliche Kurzwellen-Amateurfunksendeantennen?',0,1,0,0,'');
INSERT INTO question VALUES(2824,'EG105','Welche Antennenform eignet sich für Sendebetrieb und weist dabei im Nahfeld ein starkes magnetisches Feld auf?',0,1,0,0,'');
INSERT INTO question VALUES(2825,'EG104','Welche Antennenart ist hier dargestellt?  <p><img src=''EG104_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2826,'EG103','Welche Antenne ist hier dargestellt?<p><img src=''EG103_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2827,'EG102','Eine Drahtantenne für den Amateurfunk im KW-Bereich ...',0,1,0,0,'');
INSERT INTO question VALUES(2828,'EG101','Wie nennt man eine Schleifenantenne, die aus drei gleich langen Drahtstücken besteht?',0,1,0,0,'');
INSERT INTO question VALUES(2869,'EG223','Eine im Außenbereich installierte Sendeantenne hat den Vorteil, dass ...',0,1,0,0,'');
INSERT INTO question VALUES(2870,'EG222','Die Polarisation einer Antenne ...',0,1,0,0,'');
INSERT INTO question VALUES(2871,'EG221','Ein Antennenhersteller gibt den Gewinn einer Antenne mit 5 dBd an. Wie groß ist der Gewinn der Antenne in dBi?',0,1,0,0,'');
INSERT INTO question VALUES(2872,'EG220','Der Gewinn von Antennen wird häufig in dBi angegeben. Auf welche Vergleichsantenne bezieht man sich dabei? Man bezieht sich dabei auf den ...',0,1,0,0,'');
INSERT INTO question VALUES(2873,'EG219','Eine <img src=''texrender_question_2873_EG219_0.svg''>/2-Vertikalantenne erzeugt ...',0,1,0,0,'');
INSERT INTO question VALUES(2874,'EG218','Für welche Antenne ist dieses Strahlungsdiagramm typisch?<p><img src=''EG218_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2875,'EG217','Dieses Strahlungsdiagramm ist typisch für ...<p><img src=''EG217_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2876,'EG216','Für welche Antenne ist dieses Strahlungsdiagramm typisch?<p><img src=''EG216_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2877,'EG215','Für welche Antenne ist dieses Strahlungsdiagramm typisch?<p><img src=''EG215_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2878,'EG214','Welches der Bilder zeigt das Strahlungsdiagramm eines Halbwellendipols?',0,1,0,0,'');
INSERT INTO question VALUES(2879,'EG213','Welche Antenne gehört <u>nicht</u> zu den symmetrischen Antennen?',0,1,0,0,'');
INSERT INTO question VALUES(2880,'EG212','An welchem Element einer Yagi-Uda-Antenne erfolgt die Energieeinspeisung? Sie erfolgt am ...',0,1,0,0,'');
INSERT INTO question VALUES(2881,'EG211','Welchen Eingangswiderstand hat eine Groundplane-Antenne?',0,1,0,0,'');
INSERT INTO question VALUES(2882,'EG210','Welchen Eingangs- bzw. Fußpunktwiderstand hat ein Faltdipol?',0,1,0,0,'');
INSERT INTO question VALUES(2883,'EG209','Welchen Eingangswiderstand hat ein gestreckter mittengespeister Halbwellendipol?',0,1,0,0,'');
INSERT INTO question VALUES(2884,'EG208','Der Fußpunktwiderstand in der Mitte eines Halbwellendipols beträgt je nach Aufbauhöhe ungefähr ...',0,1,0,0,'');
INSERT INTO question VALUES(2885,'EG207','Die Fußpunktimpedanz eines mittengespeisten Halbwellendipols in einer Höhe von mindestens einer Wellenlänge über dem Boden beträgt ungefähr ...',0,1,0,0,'');
INSERT INTO question VALUES(2886,'EG206','Ein Halbwellendipol wird auf der Grundfrequenz in der Mitte ...',0,1,0,0,'');
INSERT INTO question VALUES(2887,'EG205','Ein Dipol wird spannungsgespeist, wenn an seinem Einspeisepunkt ...',0,1,0,0,'');
INSERT INTO question VALUES(2888,'EG204','Ein Dipol wird stromgespeist, wenn an seinem Einspeisepunkt ...',0,1,0,0,'');
INSERT INTO question VALUES(2889,'EG203','Welche Aussage zur Strom- und Spannungsverteilung auf einem Dipol ist richtig?',0,1,0,0,'');
INSERT INTO question VALUES(2890,'EG202','Welcher Prozentsatz entspricht dem Verkürzungsfaktor (Korrekturfaktor), der üblicherweise für die Berechnung der Länge einer Drahtantenne verwendet wird?',0,1,0,0,'');
INSERT INTO question VALUES(2891,'EG201','Der Verkürzungsfaktor ist ...',0,1,0,0,'');
INSERT INTO question VALUES(2912,'EG316','Welche Dämpfung ergibt sich auf der Grundlage des Kabeldämpfungsdiagramms für ein 40 m langes Koaxialkabel mit PE-Schaum-Dielektrikum und 10,3 mm Durchmesser im 23 cm-Band (1296 MHz)?',0,1,0,0,'');
INSERT INTO question VALUES(2913,'EG315','Welche Dämpfung ergibt sich auf der Grundlage des Kabeldämpfungsdiagramms für ein 40 m langes Koaxialkabel, PE-Schaum-Dielektrikum mit 12,7 mm Durchmesser, bei 435 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(2914,'EG314','Welche Dämpfung ergibt sich auf der Grundlage des Kabeldämpfungsdiagramms für ein 50 m langes Koaxialkabel mit Voll-PE-Dielektrikum, 2,8 mm Durchmesser (Typ RG174), bei 145 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(2915,'EG313','Welche Dämpfung ergibt sich auf der Grundlage des Kabeldämpfungsdiagramms für ein 15 m langes Koaxialkabel mit Voll-PE-Dielektrikum, 4,95 mm Durchmesser (Typ RG58), bei 145 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(2916,'EG312','Welche Dämpfung ergibt sich auf der Grundlage des Kabeldämpfungsdiagramms für ein 100 m langes Koaxialkabel mit Voll-PE-Dielektrikum, 4,95 mm Durchmesser (Typ RG58), bei 145 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(2917,'EG311','Ein 100 m langes Koaxialkabel hat eine Dämpfung von 20 dB bei 145 MHz. Wie hoch ist die Dämpfung bei einer Länge von 20 m?',0,1,0,0,'');
INSERT INTO question VALUES(2918,'EG310','Am Ende einer Antennenleitung ist nur noch ein Zehntel der Leistung vorhanden. Wie groß ist das Dämpfungsmaß des Kabels?',0,1,0,0,'');
INSERT INTO question VALUES(2919,'EG309','Am Ende einer Antennenleitung ist nur noch ein Viertel der Leistung vorhanden. Wie groß ist das Dämpfungsmaß des Kabels?',0,1,0,0,'');
INSERT INTO question VALUES(2920,'EG308','Eine HF-Ausgangsleistung von 100 W wird in eine angepasste Übertragungsleitung eingespeist. Am antennenseitigen Ende der Leitung beträgt die Leistung 50 W bei einem SWR von 1. Wie hoch ist die Leitungsdämpfung?',0,1,0,0,'');
INSERT INTO question VALUES(2921,'EG307','Die Skizze zeigt den Aufbau einer Amateurfunkstelle. Die Summe aller Kabelverluste in Dezibel betragen ...<p><img src=''EG307_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2922,'EG306','Um Ordnung in der Amateurfunkstelle herzustellen, verlegen Sie alle Netzanschlusskabel und HF-Speiseleitungen in einem Kabelkanal. Welchen Nachteil kann diese Maßnahme haben?',0,1,0,0,'');
INSERT INTO question VALUES(2923,'EG305','Welche Vorteile hat eine Paralleldraht-Speiseleitung gegenüber der Speisung über ein Koaxialkabel?',0,1,0,0,'');
INSERT INTO question VALUES(2924,'EG304','Wann ist eine Speiseleitung unsymmetrisch?',0,1,0,0,'');
INSERT INTO question VALUES(2925,'EG303','Welcher der folgenden Koaxialstecker besitzt einen definierten Wellenwiderstand von 50 Ohm bis in den GHz-Bereich und hat die höchste Spannungsfestigkeit für die Übertragung hoher Leistungen?',0,1,0,0,'');
INSERT INTO question VALUES(2926,'EG302','Welche Leitungen sollten für die HF-Verbindungen zwischen Einrichtungen in der Amateurfunkstelle verwendet werden, um unerwünschte Abstrahlungen zu vermeiden?',0,1,0,0,'');
INSERT INTO question VALUES(2927,'EG301','Der Wellenwiderstand einer Leitung ...',0,1,0,0,'');
INSERT INTO question VALUES(2965,'EG408','Auf einem Ferritkern sind einige Windungen Koaxialkabel aufgewickelt. Mit diesem Aufbau ...<p><img src=''EG408_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2966,'EG407','Wozu wird ein Symmetrierglied (Balun) beispielsweise verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(2967,'EG406','Welche Effekte treten auf, wenn ein Halbwellendipol mit einem Koaxkabel gleicher Impedanz mittig gespeist wird?',0,1,0,0,'');
INSERT INTO question VALUES(2968,'EG405','Mantelwellen auf dem Koaxialkabel zur Antenne ...',0,1,0,0,'');
INSERT INTO question VALUES(2969,'EG404','Die Darstellung zeigt die bei Ankopplung eines Koaxialkabels an eine Antenne auftretenden Ströme. Wie wird der mit <img src=''texrender_question_2969_EG404_0.svg''> bezeichnete Strom genannt?<p><img src=''EG404_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2970,'EG403','Sie messen ein Stehwellenverhältnis (SWR) von 3. Wieviel Prozent der vorlaufenden Leistung werden abgegeben?',0,1,0,0,'');
INSERT INTO question VALUES(2971,'EG402','Sie messen ein Stehwellenverhältnis (SWR) von 3. Wieviel Prozent der vorlaufenden Leistung werden reflektiert?',0,1,0,0,'');
INSERT INTO question VALUES(2972,'EG401','Am Eingang einer Antennenleitung misst man ein SWR von 3. Wie groß ist dort in etwa die rücklaufende Leistung, wenn die vorlaufende Leistung 100 W beträgt?',0,1,0,0,'');
INSERT INTO question VALUES(2981,'EG511','Sie möchten für Ihre Sendeanlage keine Anzeige einer ortsfesten Amateurfunkanlage nach § 9 BEMFV abgeben. Wie hoch darf die Sendeleistung für ihre Vertikalantenne mit 5,15 dBi Gewinn ohne Berücksichtigung der Kabelverluste maximal sein, damit die Strahlungsleistung von 10 W EIRP nicht überschritten wird?',0,1,0,0,'');
INSERT INTO question VALUES(2982,'EG510','Ein Sender mit 8,5 W Ausgangsleistung ist über eine Antennenleitung, die 1,5 dB Kabelverluste hat, an eine Antenne mit 0 dB Gewinn (auf den Dipol bezogen) angeschlossen. Welche EIRP wird von der Antenne abgestrahlt?',0,1,0,0,'');
INSERT INTO question VALUES(2983,'EG509','Ein Sender mit 0,6 W Ausgangsleistung ist über eine Antennenleitung, die 1 dB Kabelverluste hat, an eine Richtantenne mit 11 dB Gewinn (auf Dipol bezogen) angeschlossen. Welche EIRP wird von der Antenne maximal abgestrahlt?',0,1,0,0,'');
INSERT INTO question VALUES(2984,'EG508','Ein Sender mit 5 W Ausgangsleistung ist über eine Antennenleitung, die 2 dB Kabelverluste hat, an eine Richtantenne mit 5 dB Gewinn (auf den Dipol bezogen) angeschlossen. Welche EIRP wird von der Antenne abgestrahlt?',0,1,0,0,'');
INSERT INTO question VALUES(2985,'EG507','An einen Sender mit 100 W Ausgangsleistung ist eine Dipol-Antenne angeschlossen. Die Dämpfung des Kabels beträgt 10 dB. Wie hoch ist die äquivalente isotrope Strahlungsleistung (EIRP)?',0,1,0,0,'');
INSERT INTO question VALUES(2986,'EG506','Ein Sender mit 75 W Ausgangsleistung ist über eine Antennenleitung, die 2,15 dB (Faktor <img src=''texrender_question_2986_EG506_0.svg''>) Kabelverluste hat, an eine Dipol-Antenne angeschlossen. Welche EIRP wird von der Antenne maximal abgestrahlt?',0,1,0,0,'');
INSERT INTO question VALUES(2987,'EG505','An einen Sender mit 100 W Ausgangsleistung ist eine Antenne mit einem Gewinn von 11 dBi angeschlossen. Die Dämpfung des Kabels beträgt 1 dB. Wie hoch ist die äquivalente Strahlungsleistung (EIRP)?',0,1,0,0,'');
INSERT INTO question VALUES(2988,'EG504','Ein HF-Verstärker für 10,4 GHz speist eine Ausgangsleistung von 5 W direkt in einen Parabolspiegel mit einem Gewinn von 36 dBi ein. Wie hoch ist die äquivalente Strahlungsleistung (EIRP)?',0,1,0,0,'');
INSERT INTO question VALUES(2989,'EG503','Ein HF-Verstärker für 5,7 GHz speist eine Ausgangsleistung von 250 mW ohne Leitungsverluste direkt in einen Parabolspiegel mit einem Gewinn von 26 dBi ein. Wie hoch ist die äquivalente Strahlungsleistung (EIRP)?',0,1,0,0,'');
INSERT INTO question VALUES(2990,'EG502','Nach welcher der Antworten kann die EIRP berechnet werden?',0,1,0,0,'');
INSERT INTO question VALUES(2991,'EG501','Die äquivalente isotrope Strahlungsleistung (EIRP) ist ...',0,1,0,0,'');
INSERT INTO question VALUES(3002,'EH107','Die Sonnenaktivität ist einem regelmäßigen Zyklus unterworfen. Welchen Zeitraum hat dieser Zyklus ungefähr?',0,1,0,0,'');
INSERT INTO question VALUES(3003,'EH106','Welche ionosphärische Region sorgt während der Sommermonate für gelegentliche gute Ausbreitung vom oberen Kurzwellenbereich bis in den UKW-Bereich?',0,1,0,0,'');
INSERT INTO question VALUES(3004,'EH105','Welchen Einfluss hat die D-Region auf die Fernausbreitung?',0,1,0,0,'');
INSERT INTO question VALUES(3005,'EH104','Welche ionosphärische Region ermöglicht DX-Verbindungen im 80 m-Band in der Nacht?',0,1,0,0,'');
INSERT INTO question VALUES(3006,'EH103','Welche ionosphärische Region ermöglicht im wesentlichen Weitverkehrsverbindungen im Kurzwellenbereich?',0,1,0,0,'');
INSERT INTO question VALUES(3007,'EH102','In welcher Höhe befinden sich für die Kurzwellen-Fernausbreitung (DX) wichtige ionosphärische Regionen? Sie befinden sich in ungefähr ...',0,1,0,0,'');
INSERT INTO question VALUES(3008,'EH101','Wie kommt die Fernausbreitung einer Funkwelle auf den Kurzwellenbändern zustande? Sie kommt zustande durch die Refraktion (Brechung) an ...',0,1,0,0,'');
INSERT INTO question VALUES(3034,'EH219','Welches Frequenzband kann im Sonnenfleckenmaximum tagsüber auch mit kleiner Leistung für weltweite Funkverbindungen verwendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(3035,'EH218','Unter dem Begriff "Short Skip" versteht man Funkverbindungen besonders im 10 m-Band mit Sprungentfernungen unter 1000 km, die ...',0,1,0,0,'');
INSERT INTO question VALUES(3036,'EH217','Was bedeutet die Aussage, dass ein Funkamateur in Deutschland mit "VK" auf dem "langen Weg" gearbeitet hat?',0,1,0,0,'');
INSERT INTO question VALUES(3037,'EH216','Was ist mit der Aussage "Funkverkehr über den langen Weg (long path)" gemeint?',0,1,0,0,'');
INSERT INTO question VALUES(3038,'EH215','Welche Auswirkung hat der Mögel-Dellinger-Effekt auf die Ausbreitung von Kurzwellen?',0,1,0,0,'');
INSERT INTO question VALUES(3039,'EH214','Ein plötzlicher Anstieg der Intensitäten von UV- und Röntgenstrahlung nach einem Flare (Energieausbruch auf der Sonne) führt zu erhöhter Ionisierung der D-Region und damit zu zeitweiligem Ausfall der Raumwellenausbreitung auf der Kurzwelle. Diese Erscheinung bezeichnet man als ...',0,1,0,0,'');
INSERT INTO question VALUES(3040,'EH213','Bei der Ausbreitung auf Kurzwelle spielt die so genannte "Greyline" eine besondere Rolle. Was ist die "Greyline"?',0,1,0,0,'');
INSERT INTO question VALUES(3041,'EH212','Welche der folgenden Aussagen trifft für KW-Funkverbindungen zu, die über Bodenwellen erfolgen?',0,1,0,0,'');
INSERT INTO question VALUES(3042,'EH211','Die Ausbreitung der Wellen im 160 m-Band erfolgt tagsüber hauptsächlich ...',0,1,0,0,'');
INSERT INTO question VALUES(3043,'EH210','Warum sind Signale im 160- und 80 m-Band tagsüber nur schwach und nicht für den weltweiten Funkverkehr geeignet? Sie sind ungeeignet wegen der Tagesdämpfung in der ...',0,1,0,0,'');
INSERT INTO question VALUES(3044,'EH209','Die niedrigste brauchbare Frequenz (LUF) bei Raumwellenausbreitung zwischen zwei Orten hängt ab ...',0,1,0,0,'');
INSERT INTO question VALUES(3045,'EH208','Von welchem der genannten Parameter ist die Sprungdistanz abhängig, die ein KW-Signal auf der Erdoberfläche überbrücken kann? Sie ist abhängig ...',0,1,0,0,'');
INSERT INTO question VALUES(3046,'EH207','Sie führen Funkbetrieb nahe der aktuell höchstmöglichen Frequenz (MUF) durch. Um den Funkbetrieb auf noch höheren Frequenzen fortsetzen zu können, muss die Ionisation der brechenden Region ...',0,1,0,0,'');
INSERT INTO question VALUES(3047,'EH206','Eine stärkere Ionisierung der F2-Region führt zu ...',0,1,0,0,'');
INSERT INTO question VALUES(3048,'EH205','Welche Aussage ist für das Sonnenfleckenmaximum richtig?',0,1,0,0,'');
INSERT INTO question VALUES(3049,'EH204','Was bedeutet die "MUF" bei der Kurzwellenausbreitung?',0,1,0,0,'');
INSERT INTO question VALUES(3050,'EH203','Wie nennt man den Feldstärkeschwund durch Überlagerung von Boden- und Raumwelle?',0,1,0,0,'');
INSERT INTO question VALUES(3051,'EH202','Was kann durch das Zusammenwirken von Raum- und Bodenwelle verursacht werden?',0,1,0,0,'');
INSERT INTO question VALUES(3052,'EH201','Unter der "Toten Zone" wird der Bereich verstanden, ...',0,1,0,0,'');
INSERT INTO question VALUES(3065,'EH305','Wie wird ein Aurora-Signal in Morsetelegrafie beurteilt?',0,1,0,0,'');
INSERT INTO question VALUES(3066,'EH304','Was verstehen Sie unter dem Begriff "Sporadic-E"?',0,1,0,0,'');
INSERT INTO question VALUES(3067,'EH303','Für VHF-Weitverkehrsverbindungen wird hauptsächlich die ...',0,1,0,0,'');
INSERT INTO question VALUES(3068,'EH302','Überhorizontverbindungen im VHF/UHF-Bereich kommen u. a. zustande durch ...',0,1,0,0,'');
INSERT INTO question VALUES(3069,'EH301','Was ist die "Troposphäre"? Die Troposphäre ist der Teil der Atmosphäre, ...',0,1,0,0,'');
INSERT INTO question VALUES(3081,'EI104','Welche Spannung wird bei dem folgenden Messinstrument angezeigt, wenn dessen Messbereich auf 300 V eingestellt ist?<p><img src=''EI104_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3082,'EI103','Welche Spannung wird bei dem folgenden Messinstrument angezeigt, wenn dessen Messbereich auf 10 V eingestellt ist? <p><img src=''EI103_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3083,'EI102','Welche Schaltung mit idealen Messgeräten könnte dazu verwendet werden, den Wert eines Widerstandes anhand des ohmschen Gesetzes zu ermitteln?',0,1,0,0,'');
INSERT INTO question VALUES(3084,'EI101','Wie werden elektrische Spannungsmessgeräte an Messobjekte angeschlossen und welche Anforderungen muss das Messgerät erfüllen, damit der Messfehler möglichst gering bleibt? Das Spannungsmessgerät ist ...',0,1,0,0,'');
INSERT INTO question VALUES(3097,'EI206','Sie ermitteln die Resonanzfrequenz und die Impedanz ihrer selbstgebauten Antennen mit Hilfe eines vektoriellen Netzwerkanalysators (VNA). Wie könnten Sie die Funktion des Gerätes vorher prüfen?',0,1,0,0,'');
INSERT INTO question VALUES(3098,'EI205','Welche Maßnahme ist vor Gebrauch eines vektoriellen Netzwerkanalysators (VNA) zusammen mit dem Messaufbau durchzuführen?',0,1,0,0,'');
INSERT INTO question VALUES(3099,'EI204','Wozu ist ein vektorieller Netzwerkanalysator (VNA) beispielsweise geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(3100,'EI203','Mit welchem Messgerät können Impedanzen, Blindwiderstände und Stehwellenverhältnisse direkt gemessen werden?',0,1,0,0,'');
INSERT INTO question VALUES(3101,'EI202','Wie ermittelt man die Resonanzfrequenz eines Schwingkreises? Man ermittelt sie ...',0,1,0,0,'');
INSERT INTO question VALUES(3102,'EI201','Wozu wird ein "vektorieller Netzwerkanalysator" (VNA) beispielsweise verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(3109,'EI304','Welches dieser Geräte wird für die Anzeige von NF-Verzerrungen verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(3110,'EI303','Die Impulsdauer beträgt hier ...<p><img src=''EI303_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3111,'EI302','Die Zeitbasis eines Oszilloskops ist so eingestellt, dass ein Skalenteil 0,5 ms entspricht. Welche Frequenz hat die angelegte Spannung? <p><img src=''EI302_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3112,'EI301','Die Zeitbasis eines Oszilloskop ist so eingestellt, dass ein Skalenteil 0,5 ms entspricht. Welche Periodendauer hat die angelegte Spannung?<p><img src=''EI301_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3116,'EI405','An welchem Punkt sollte das Stehwellenmessgerät eingeschleift werden, um zu prüfen, ob die Antennenanlage gut an den Sender angepasst ist? <p><img src=''EI405_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3117,'EI404','An welcher Stelle muss ein SWR-Meter eingeschleift werden, um möglichst genaue Aussagen über die Antenne machen zu können? Das SWR-Meter muss eingeschleift werden zwischen ...',0,1,0,0,'');
INSERT INTO question VALUES(3118,'EI403','Wie misst man das Stehwellenverhältnis im Sendebetrieb? Man misst es ...',0,1,0,0,'');
INSERT INTO question VALUES(3119,'EI402','Mit welchem Instrument kann die Anpassung zwischen einem UHF-Sender und der Speiseleitung zur Antenne angezeigt werden?',0,1,0,0,'');
INSERT INTO question VALUES(3120,'EI401','Ein Stehwellenmessgerät wird eingesetzt bei Sendern zur Messung ...',0,1,0,0,'');
INSERT INTO question VALUES(3135,'EI504','Wenn ein 10:1-Frequenzteiler vor einem Frequenzzähler geschaltet wird und der Zähler 14,5625 MHz anzeigt, beträgt die tatsächliche Frequenz ...',0,1,0,0,'');
INSERT INTO question VALUES(3136,'EI503','Das Bild stellt die Anzeige eines Frequenzzählers dar. Welchen Stellenwert hat die mit X gekennzeichnete Ziffer?<p><img src=''EI503_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3137,'EI502','Das Bild stellt die Anzeige eines Frequenzzählers dar. Welchen Stellenwert hat die mit X gekennzeichnete Ziffer?<p><img src=''EI502_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3138,'EI501','Womit kann die Frequenz eines unmodulierten Hochfrequenzsignals gemessen werden? Mit einem ...',0,1,0,0,'');
INSERT INTO question VALUES(3175,'EJ124','Die Bemühungen, die durch eine in der Nähe befindliche Amateurfunkstelle hervorgerufenen Fernsehstörungen zu verringern, sind fehlgeschlagen. Als nächster Schritt ist ...',0,1,0,0,'');
INSERT INTO question VALUES(3176,'EJ123','Beim Betrieb eines 2 m-Senders wird bei einem Nachbarn ein Fernsehempfänger gestört, der mit einer Zimmerantenne betrieben wird. Zur Behebung des Problems ...',0,1,0,0,'');
INSERT INTO question VALUES(3177,'EJ122','Ihr Nachbar beklagt sich über Störungen seines Fernsehempfangs und vermutet ihre Amateurfunkaussendungen als Ursache. Welcher erste Schritt bietet sich an?',0,1,0,0,'');
INSERT INTO question VALUES(3178,'EJ121','Ein korrodierter Anschluss an der Fernseh-Empfangsantenne des Nachbarn kann in Verbindung mit ...',0,1,0,0,'');
INSERT INTO question VALUES(3179,'EJ120','Welche Empfangs-Effekte werden durch Intermodulation hervorgerufen?',0,1,0,0,'');
INSERT INTO question VALUES(3180,'EJ119','Die Signale eines 144 MHz-Senders werden in das Koax-Antennenkabel eines UKW-/DAB-Rundfunkempfängers induziert und verursachen Störungen. Eine Möglichkeit zur Verringerung der Störungen besteht darin, ...',0,1,0,0,'');
INSERT INTO question VALUES(3181,'EJ118','Durch eine Mantelwellendrossel in einem Fernseh-Antennenzuführungskabel ...',0,1,0,0,'');
INSERT INTO question VALUES(3182,'EJ117','Eine KW-Amateurfunkstelle verursacht im Sendebetrieb in einem in der Nähe betriebenen Fernsehempfänger Störungen. Welches Filter schleifen Sie in das Fernsehantennenkabel ein, um die Störwahrscheinlichkeit zu verringern?',0,1,0,0,'');
INSERT INTO question VALUES(3183,'EJ116','Ein 28 MHz-Sender beeinflusst den Empfänger eines DVB-T2-Fernsehgerätes über dessen Antenneneingang. Was sollte zur Abhilfe vor den Antenneneingang des Fernsehgerätes eingeschleift werden?',0,1,0,0,'');
INSERT INTO question VALUES(3184,'EJ115','In einem Einfamilienhaus wird die Türsprechanlage durch den Betrieb eines nahen Senders gestört. Eine Möglichkeit zur Verringerung der Beeinflussungen besteht darin, ...',0,1,0,0,'');
INSERT INTO question VALUES(3185,'EJ114','Bei der Musik-Anlage des Nachbarn wird Einströmung in die NF-Endstufe festgestellt. Eine mögliche Abhilfe wäre ...',0,1,0,0,'');
INSERT INTO question VALUES(3186,'EJ113','Wie kommen Geräusche aus den Lautsprechern einer abgeschalteten Stereoanlage möglicherweise zustande?',0,1,0,0,'');
INSERT INTO question VALUES(3187,'EJ112','Welches Gerät kann durch Aussendungen eines Amateurfunksenders störende Beeinflussungen zeigen?',0,1,0,0,'');
INSERT INTO question VALUES(3188,'EJ111','Um die Störwahrscheinlichkeit im eigenen Haus zu verringern, empfiehlt es sich vorzugsweise ...',0,1,0,0,'');
INSERT INTO question VALUES(3189,'EJ110','Ein Funkamateur wohnt in einem Reihenhaus. An welcher Stelle sollte eine Drahtantenne für den Sendebetrieb auf dem 80 m-Band angebracht werden, um störende Beeinflussungen möglichst zu vermeiden?',0,1,0,0,'');
INSERT INTO question VALUES(3190,'EJ109','Falls sich eine Kurzwellen-Sendeantenne in der Nähe und parallel zu einer 230 V-Wechselstromleitung befindet, ...',0,1,0,0,'');
INSERT INTO question VALUES(3191,'EJ108','Wie sollte ein Abschirmgehäuse für HF-Baugruppen beschaffen sein?',0,1,0,0,'');
INSERT INTO question VALUES(3192,'EJ107','Wodurch können Sie die Übersteuerung eines Empfängers erkennen?',0,1,0,0,'');
INSERT INTO question VALUES(3193,'EJ106','Eine 432 MHz-Sendeantenne mit hohem Gewinn ist unmittelbar auf eine Fernseh-Empfangsantenne gerichtet. Dies führt ggf. zu ...',0,1,0,0,'');
INSERT INTO question VALUES(3194,'EJ105','Bei einem Wohnort in einem Ballungsgebiet empfiehlt es sich, während der abendlichen Fernsehstunden ...',0,1,0,0,'');
INSERT INTO question VALUES(3195,'EJ104','Um die Störwahrscheinlichkeit zu verringern, sollte die benutzte Sendeleistung ...',0,1,0,0,'');
INSERT INTO question VALUES(3196,'EJ103','Bereits durch die Aussendung des reinen Nutzsignals können in benachbarten Empfängern Störungen beim Empfang anderer Frequenzen auftreten. Dabei handelt es sich um eine ...',0,1,0,0,'');
INSERT INTO question VALUES(3197,'EJ102','In welchem Fall spricht man von Einstrahlungen bei EMV? Einstrahlungen liegen dann vor, wenn die Hochfrequenz ...',0,1,0,0,'');
INSERT INTO question VALUES(3198,'EJ101','In welchem Fall spricht man von Einströmungen? Einströmungen liegen dann vor, wenn Hochfrequenz ...',0,1,0,0,'');
INSERT INTO question VALUES(3226,'EJ219','Was ist zu tun, wenn es bei digitalen Übertragungsverfahren zu Störungen kommt, weil die automatische Pegelregelung (ALC) eines Funkgerätes im SSB-Betrieb eingreift?',0,1,0,0,'');
INSERT INTO question VALUES(3227,'EJ218','Wie sollte bei digitalen Übertragungsverfahren (z. B. FT8, JS8, PSK31) der NF-Pegel am Eingang eines Funkgerätes mit automatischer Pegelregelung (ALC) im SSB-Betrieb eingestellt sein, um Störungen zu vermeiden?',0,1,0,0,'');
INSERT INTO question VALUES(3228,'EJ217','Was kann auftreten, wenn bei digitalen Übertragungsverfahren (z. B. RTTY, FT8, Olivia) die automatische Pegelregelung (ALC) eines Funkgerätes im SSB-Betrieb eingreift?',0,1,0,0,'');
INSERT INTO question VALUES(3229,'EJ216','Welche unerwünschte Auswirkung kann mangelhafte Frequenzstabilität eines Senders haben?',0,1,0,0,'');
INSERT INTO question VALUES(3230,'EJ215','Was bewirkt in der Regel eine zu hohe Mikrofonverstärkung bei einem SSB-Transceiver?',0,1,0,0,'');
INSERT INTO question VALUES(3231,'EJ214','Ein SSB-Sender wird Störungen auf benachbarten Frequenzen hervorrufen, wenn ...',0,1,0,0,'');
INSERT INTO question VALUES(3232,'EJ213','Die Übersteuerung eines Leistungsverstärkers führt zu ...',0,1,0,0,'');
INSERT INTO question VALUES(3233,'EJ212','Sie modulieren Ihren FM-Sender mit einem AFSK-Signal (Niederfrequenzumtastung). Wie können Sie die Bandbreite der Aussendung reduzieren? Durch ...',0,1,0,0,'');
INSERT INTO question VALUES(3234,'EJ211','Um etwaige Funkstörungen auf Nachbarfrequenzen zu begrenzen, sollte bei SSB-Telefonie die höchste zu übertragende NF-Frequenz ...',0,1,0,0,'');
INSERT INTO question VALUES(3235,'EJ210','Um Störungen auf benachbarten Frequenzen zu minimieren, sollte die Übertragungsbandbreite bei SSB ...',0,1,0,0,'');
INSERT INTO question VALUES(3236,'EJ209','Wie erfolgt die Messung der Leistungen, die zu unerwünschten Aussendungen führen?',0,1,0,0,'');
INSERT INTO question VALUES(3237,'EJ208','Welche Filtercharakteristik würde sich am besten für den Ausgang eines KW-Mehrband-Senders eignen?',0,1,0,0,'');
INSERT INTO question VALUES(3238,'EJ207','Welche Charakteristik sollte ein Filter zur Verringerung der Oberwellen eines KW-Senders haben?',0,1,0,0,'');
INSERT INTO question VALUES(3239,'EJ206','Welche Schaltung wäre, zwischen Senderausgang und Antenne eingeschleift, am besten zur Verringerung der Oberwellenausstrahlungen geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(3240,'EJ205','Um Oberwellenaussendungen eines UHF-Senders zu minimieren, sollte dem Gerät ...',0,1,0,0,'');
INSERT INTO question VALUES(3241,'EJ204','Welches Filter wäre zwischen Senderausgang und Antenne eingeschleift am besten zur Verringerung der Oberwellenausstrahlungen geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(3242,'EJ203','Was für ein Filter muss zwischen Transceiver und Antennenzuleitung eingefügt werden, um Oberwellen zu reduzieren?',0,1,0,0,'');
INSERT INTO question VALUES(3243,'EJ202','Wie kann man hochfrequente Störungen reduzieren, die durch Harmonische hervorgerufen werden? Sie können reduziert werden durch ein ...',0,1,0,0,'');
INSERT INTO question VALUES(3244,'EJ201','Welche Signalform sollte der Träger einer hochfrequenten Schwingung haben, um Störungen durch Oberwellen zu vermeiden?',0,1,0,0,'');
INSERT INTO question VALUES(3264,'EK108','Sie möchten den Personenschutz-Sicherheitsabstand für die Antenne Ihrer Amateurfunkstelle für das 10 m-Band und das Modulationsverfahren FM berechnen. Der Grenzwert im Fall des Personenschutzes beträgt 28 V/m. Sie betreiben eine Yagi-Uda-Antenne mit einem Gewinn von <img src=''texrender_question_3264_EK108_0.svg''>dBd. Die Antenne wird von einem Sender mit einer Leistung von 100 W über ein langes Koaxialkabel gespeist. Die Kabeldämpfung beträgt 1,5 dB. Wie groß muss der Sicherheitsabstand sein?',0,1,0,0,'');
INSERT INTO question VALUES(3265,'EK107','Sie errechnen einen Sicherheitsabstand für Ihre Antenne. Von welchem Punkt aus muss dieser Sicherheitsabstand eingehalten werden, wenn Sie bei der Berechnung die Fernfeldnäherung verwendet haben? Er muss eingehalten werden ...',0,1,0,0,'');
INSERT INTO question VALUES(3266,'EK106','Wann ist die Berechnung des Personenschutz-Sicherheitsabstands mit der Näherungsformel für die Fernfeldberechnung auf den Bändern 160 m und 80 m ungültig? Die Berechnung ist ungültig, wenn das Ergebnis kleiner ist als ...',0,1,0,0,'');
INSERT INTO question VALUES(3267,'EK105','Sie möchten den Personenschutz-Sicherheitsabstand für ihren neuen, fest aufgebauten Halbwellendipol für das 80 m-Band (3,5 - 3,8 MHz) bestimmen. Bei 100 W Sendeleistung errechnen Sie mit Hilfe der Näherungsformel für die Fernfeldberechnung einen erforderlichen Abstand von 3,65 m. Ist dieser Sicherheitsabstand gültig?',0,1,0,0,'');
INSERT INTO question VALUES(3268,'EK104','Muss ein Funkamateur als Betreiber einer ortsfesten Amateurfunkstelle bei FM-Telefonie und einer Sendeleistung von 6 W an einer 15-Element-Yagi-Uda-Antenne mit 13 dBd Gewinn im 2 m-Band die Einhaltung der Personenschutzgrenzwerte nachweisen?',0,1,0,0,'');
INSERT INTO question VALUES(3269,'EK103','Zum Schutz von Personen in elektromagnetischen Feldern sind in bestimmten Fällen auch Grenzwerte für aktive Körperhilfen einzuhalten. Mit welchem zeitlichen Bezug ist die Feldstärke hierbei zu betrachten?',0,1,0,0,'');
INSERT INTO question VALUES(3270,'EK102','Mit welchem zeitlichen Bezug ist die Feldstärke für die Einhaltung der Grenzwerte der 26. Verordnung zur Durchführung des Bundes-Immissionsschutzgesetzes (Verordnung über elektromagnetische Felder - 26. BImSchV) zu betrachten?',0,1,0,0,'');
INSERT INTO question VALUES(3271,'EK101','Die Feldstärkegrenzwerte für den Schutz von Personen in elektromagnetischen Feldern sind von der Frequenz abhängig, weil ...',0,1,0,0,'');
INSERT INTO question VALUES(3277,'EK211','Unter welchen Bedingungen darf das Standrohr einer Amateurfunkantenne auf einem Gebäude mit dem gebäudeeigenen Blitzschutzsystem verbunden werden?',0,1,0,0,'');
INSERT INTO question VALUES(3278,'EK210','Welches Material und welcher Mindestquerschnitt kann für eine Erdungsleitung zwischen einem Antennenstandrohr und einer Erdungsanlage nach VDE 0855-300 beispielsweise verwendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(3279,'EK209','Unter welchen Bedingungen darf eine Gebäudeerdungsanlage für die Antennenerdung verwendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(3280,'EK208','Welche Maßnahmen müssen zum Personenschutz bei Koaxialkabeln zur Verhinderung von Spannungsunterschieden ergriffen werden?',0,1,0,0,'');
INSERT INTO question VALUES(3281,'EK207','Wie lassen sich elektrostatische Aufladungen, die insbesondere bei ungeerdeten Drahtantennen auftreten können, wirkungsvoll vermeiden, ohne die Funktion der Funkanlage zu beeinträchtigen?',0,1,0,0,'');
INSERT INTO question VALUES(3282,'EK206','Auf welchen besonderen Sicherheitsaspekt ist speziell bei ungeerdeten Drahtantennen zu achten?',0,1,0,0,'');
INSERT INTO question VALUES(3283,'EK205','Wählen Sie die normgerechten Adernkennfarben von 3-adrigen, isolierten Energieleitungen und -kabeln in der Reihenfolge: Schutzleiter, Außenleiter, Neutralleiter!',0,1,0,0,'');
INSERT INTO question VALUES(3284,'EK204','Sie haben in ihren Kurzwellensender soeben einen Kurzschluss im Netzteil erfolgreich repariert. Durch den Fehler wurde auch die Feinsicherung für die Stromversorgung mit der Aufschrift 20 A "Flink" zerstört. Beim Austausch dieser Sicherung ...',0,1,0,0,'');
INSERT INTO question VALUES(3285,'EK203','Mit welchen Gefahren muss beim Öffnen eines vom Netz getrennten Funk- oder anderen elektrisch betriebenen Gerätes gerechnet werden?',0,1,0,0,'');
INSERT INTO question VALUES(3286,'EK202','Welche möglichen Gefahren bestehen beim Berühren von im Sendebetrieb befindlichen Antennen?',0,1,0,0,'');
INSERT INTO question VALUES(3287,'EK201','Was ist aus Sicherheitsgründen besonders beim Umgang mit Mikrowellen zu beachten?',0,1,0,0,'');
INSERT INTO question VALUES(1928,'AA116','Die Frequenzerzeugung eines Senders hat eine Genauigkeit von 10 ppm. Die digitale Anzeige zeigt eine Sendefrequenz von 14,200.000 MHz an. In welchen Grenzen kann sich die tatsächliche Frequenz bewegen?',0,1,0,0,'');
INSERT INTO question VALUES(1929,'AA115','Eine Genauigkeit von 1 ppm bei einer Frequenz von 435 MHz entspricht ...',0,1,0,0,'');
INSERT INTO question VALUES(1930,'AA114','Wie stark ist die Empfängereingangsspannung abgesunken, wenn die S-Meter-Anzeige durch Änderung der Ausbreitungsbedingungen von S9+20 dB auf S8 zurückgeht? Die Empfängereingangsspannung sinkt um ...',0,1,0,0,'');
INSERT INTO question VALUES(1931,'AA113','Wie groß ist der Unterschied zwischen den S-Stufen S4 und S7 in dB?',0,1,0,0,'');
INSERT INTO question VALUES(1932,'AA112','Der Pegelwert 120 dB<img src=''texrender_question_1932_AA112_0.svg''>V/m entspricht einer elektrischen Feldstärke von ...',0,1,0,0,'');
INSERT INTO question VALUES(1933,'AA111','Einem Spannungsverhältnis von 15 entsprechen ...',0,1,0,0,'');
INSERT INTO question VALUES(1934,'AA110','Welcher Leistung entsprechen die Pegel 0 dBm, 3 dBm und 20 dBm?',0,1,0,0,'');
INSERT INTO question VALUES(1935,'AA109','Ein Sender mit 1 W Ausgangsleistung ist an eine Endstufe mit einer Verstärkung von 10 dB angeschlossen. Wie groß ist der Ausgangspegel der Endstufe?',0,1,0,0,'');
INSERT INTO question VALUES(1936,'AA108','Der Ausgangspegel eines Senders beträgt 20 dBW. Dies entspricht einer Ausgangsleistung von ...',0,1,0,0,'');
INSERT INTO question VALUES(1937,'AA107','Ein Sender mit 1 W Ausgangsleistung ist an eine Endstufe mit einer Verstärkung von 10 dB angeschlossen. Wie groß ist der Ausgangspegel der Endstufe?',0,1,0,0,'');
INSERT INTO question VALUES(1938,'AA106','Ein HF-Leistungsverstärker hat eine Verstärkung von 16 dB mit maximal 100 W Ausgangsleistung. Welche HF-Ausgangsleistung ist zu erwarten, wenn der Verstärker mit 1 W HF-Eingangsleistung angesteuert wird?',0,1,0,0,'');
INSERT INTO question VALUES(1939,'AA105','Einer Leistungsverstärkung von 40 entsprechen ...',0,1,0,0,'');
INSERT INTO question VALUES(1940,'AA104','Welche Einheit wird üblicherweise für die Symbolrate verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(1941,'AA103','Welche Einheit wird üblicherweise für die Energie verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(1942,'AA102','Welche Einheit wird üblicherweise für die elektrische Ladung verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(1943,'AA101','Welche Einheit wird üblicherweise für die Impedanz verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(1981,'AB109','Wie verhält sich die Verarmungszone in der hier dargestellten Halbleiterdiode?<p><img src=''AB109_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(1982,'AB108','Das folgende Bild zeigt den prinzipiellen Aufbau einer Halbleiterdiode. Wie entsteht die Sperrschicht?<p><img src=''AB108_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(1983,'AB107','P-leitendes Halbleitermaterial ist gekennzeichnet durch ...',0,1,0,0,'');
INSERT INTO question VALUES(1984,'AB106','N-leitendes Halbleitermaterial ist gekennzeichnet durch ...',0,1,0,0,'');
INSERT INTO question VALUES(1985,'AB105','Was versteht man unter Dotierung?',0,1,0,0,'');
INSERT INTO question VALUES(1986,'AB104','Was versteht man unter Halbleitermaterialien?',0,1,0,0,'');
INSERT INTO question VALUES(1987,'AB103','Wie ändert sich der Widerstand eines Metalls mit der Temperatur im Regelfall?',0,1,0,0,'');
INSERT INTO question VALUES(1988,'AB102','Zwischen den Enden eines Kupferdrahtes mit einem Querschnitt von 0,5 mm² messen Sie einen Widerstand von 1,5 Ohm. Wie lang ist der Draht etwa?',0,1,0,0,'');
INSERT INTO question VALUES(1989,'AB101','Welchen Widerstand hat ein Kupferdraht etwa, wenn der verwendete Draht eine Länge von 1,8 m und einen Durchmesser von 0,2 mm hat?',0,1,0,0,'');
INSERT INTO question VALUES(1994,'AB214','Ein Spannungswandler wandelt 5 V in 12 V um. Dabei nimmt er 3 A auf und gibt 1 A ab. Wie groß ist sein Wirkungsgrad?',0,1,0,0,'');
INSERT INTO question VALUES(1995,'AB213','Ein Spannungswandler setzt 12 V auf 5 V um. Er nimmt 2 A auf und gibt 3 A ab. Wie groß ist sein Wirkungsgrad?',0,1,0,0,'');
INSERT INTO question VALUES(1996,'AB212','Was ist die primäre Aufgabe einer Solarzelle?',0,1,0,0,'');
INSERT INTO question VALUES(1997,'AB211','Wie lange könnte man idealerweise mit einem voll geladenen Akku mit 60 Ah einen Amateurfunkempfänger betreiben, bis dieser auf 10 % seiner Kapazität entladen ist und einen Strom von 0,8 A aufnimmt?',0,1,0,0,'');
INSERT INTO question VALUES(1998,'AB210','Auf dem Akku-Pack eines Handfunksprechgerätes stehen folgende Angaben: 7,4 V - 2200 mAh - 16,28 Wh. Welcher Begriff ist für die Angabe 2200 mAh zutreffend.',0,1,0,0,'');
INSERT INTO question VALUES(1999,'AB209','Folgende Schaltung eines Akkus besteht aus Zellen von je 2 V. Jede Zelle kann 10 Ah Ladung liefern. Welche Daten hat der Akku?<p><img src=''AB209_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2000,'AB208','Die Leerlaufspannung einer Gleichspannungsquelle beträgt 13,8 V. Wenn die Spannungsquelle einen Strom von 20 A abgibt, bleibt die Klemmenspannung auf 13,6 V. Wie groß ist der Innenwiderstand der Spannungsquelle?',0,1,0,0,'');
INSERT INTO question VALUES(2001,'AB207','Die Leerlaufspannung einer Gleichspannungsquelle beträgt 13,5 V. Wenn die Spannungsquelle einen Strom von 2 A abgibt, sinkt die Klemmenspannung auf 13 V. Wie groß ist der Innenwiderstand der Spannungsquelle?',0,1,0,0,'');
INSERT INTO question VALUES(2002,'AB206','Die Leerlaufspannung einer Gleichspannungsquelle beträgt 13,5 V. Wenn die Spannungsquelle einen Strom von 0,9 A abgibt, sinkt die Klemmenspannung auf 12,4 V. Wie groß ist der Innenwiderstand der Spannungsquelle?',0,1,0,0,'');
INSERT INTO question VALUES(2003,'AB205','Die Leerlaufspannung einer Spannungsquelle beträgt 5,0 V. Schließt man einen Belastungswiderstand mit 1,2 Ohm an, so geht die Klemmenspannung der Spannungsquelle auf 4,8 V zurück. Wie hoch ist der Innenwiderstand der Spannungsquelle?',0,1,0,0,'');
INSERT INTO question VALUES(2004,'AB204','In welchem Zusammenhang müssen der Innenwiderstand <img src=''texrender_question_2004_AB204_0.svg''> einer Stromquelle und ein direkt daran angeschlossener Lastwiderstand <img src=''texrender_question_2004_AB204_1.svg''> stehen, damit Stromanpassung vorliegt?',0,1,0,0,'');
INSERT INTO question VALUES(2005,'AB203','In welchem Zusammenhang müssen der Innenwiderstand <img src=''texrender_question_2005_AB203_0.svg''> einer Spannungsquelle und ein direkt daran angeschlossener Lastwiderstand <img src=''texrender_question_2005_AB203_1.svg''> stehen, damit Spannungsanpassung vorliegt?',0,1,0,0,'');
INSERT INTO question VALUES(2006,'AB202','In welchem Zusammenhang müssen der Innenwiderstand <img src=''texrender_question_2006_AB202_0.svg''> einer Strom- oder Spannungsquelle und ein direkt daran angeschlossener Lastwiderstand <img src=''texrender_question_2006_AB202_1.svg''> stehen, damit Leistungsanpassung vorliegt?',0,1,0,0,'');
INSERT INTO question VALUES(2007,'AB201','Welche Eigenschaften sollten Strom- und Spannungsquellen nach Möglichkeit aufweisen?',0,1,0,0,'');
INSERT INTO question VALUES(2046,'AB303','Der Betrag der Phasendifferenz zwischen den beiden in der Abbildung dargestellten Sinussignalen ist ...<p><img src=''AB303_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2047,'AB302','Welche Antwort enthält die richtigen Phasenwinkel der dargestellten sinusförmigen Wechselspannung an der mit X<img src=''texrender_question_2047_AB302_0.svg''> bezeichneten Stelle?<p><img src=''AB302_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2048,'AB301','Ein sinusförmiger Wechselstrom mit einer Amplitude <img src=''texrender_question_2048_AB301_0.svg''> von 0,5 Ampere fließt durch einen Widerstand von 20 Ohm. Wieviel Leistung wird in Wärme umgesetzt?',0,1,0,0,'');
INSERT INTO question VALUES(2065,'AB409','Wie verhält sich der Pegel des thermischen Rauschens am Empfängerausgang, wenn von einem Quarzfilter mit einer Bandbreite von 2,5 kHz auf ein Quarzfilter mit einer Bandbreite von 0,5 kHz mit gleicher Durchlassdämpfung und Flankensteilheit umgeschaltet wird? Der Rauschleistungspegel ...',0,1,0,0,'');
INSERT INTO question VALUES(2066,'AB408','Für Messzwecke speisen Sie in den Antenneneingang Ihres Empfängers ein gleichmäßig über alle Frequenzen verteiltes Rauschsignal aus einem Messender ein (weißes Rauschen). Welche Aussage über die Leistung, die man beim Empfang dieses Signals misst, stimmt?',0,1,0,0,'');
INSERT INTO question VALUES(2067,'AB407','Welches Signal passt zu folgendem Frequenzspektrum?<p><img src=''AB407_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2068,'AB406','Welches Signal passt zu folgendem Frequenzspektrum?<p><img src=''AB406_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2069,'AB405','Welches Frequenzspektrum passt zu folgendem periodischen Signal?<p><img src=''AB405_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2070,'AB404','Welches Frequenzspektrum passt zu folgendem sinusförmigen Signal?<p><img src=''AB404_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2071,'AB403','Eine periodische Schwingung, die wie das folgende Signal aussieht, besteht ...<p><img src=''AB403_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2072,'AB402','Die dritte Oberwelle entspricht ...',0,1,0,0,'');
INSERT INTO question VALUES(2073,'AB401','Was sind Harmonische?',0,1,0,0,'');
INSERT INTO question VALUES(2099,'AB503','Wie viel Energie wird vom Widerstand innerhalb einer Stunde in Wärme umgewandelt?<p><img src=''AB503_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2100,'AB502','Eine Stromversorgung nimmt bei einer Spannung von 230 V einen Strom von 0,63 A auf. Wieviel Energie wird bei einer Betriebsdauer von 7 Stunden umgesetzt?',0,1,0,0,'');
INSERT INTO question VALUES(2101,'AB501','Ein 12 V Akku hat eine Kapazität von 5 Ah. Welcher speicherbaren Energie entspricht das?',0,1,0,0,'');
INSERT INTO question VALUES(2102,'AB601','Welches Bild zeigt die physikalische Stromrichtung korrekt an?',0,1,0,0,'');
INSERT INTO question VALUES(2133,'AC111','An einem Kondensator mit einer Kapazität von 1 μF wird ein NF-Signal mit 10 kHz und 12 V<img src=''texrender_question_2133_AC111_0.svg''> angelegt. Wie groß ist die aufgenommene Wirkleistung im eingeschwungenen Zustand?',0,1,0,0,'');
INSERT INTO question VALUES(2134,'AC110','Neben dem kapazitiven Blindwiderstand treten im von Wechselstrom durchflossenen Kondensator auch Verluste auf, die rechnerisch in einem parallelgeschalteten Verlustwiderstand zusammengefasst werden können. Die Kondensatorverluste werden oft durch ...',0,1,0,0,'');
INSERT INTO question VALUES(2135,'AC109','Kommt es in einem von Wechselstrom durchflossenen realen Kondensator zu Verlusten?',0,1,0,0,'');
INSERT INTO question VALUES(2136,'AC108','An einem unbekannten Kondensator liegt eine Wechselspannung mit 16 V und 50 Hz. Es wird ein Strom von 32 mA gemessen. Welche Kapazität hat der Kondensator?',0,1,0,0,'');
INSERT INTO question VALUES(2137,'AC107','Wie groß ist der Betrag des kapazitiven Blindwiderstands eines Kondensators mit 100 pF bei einer Frequenz von 435 MHz ?',0,1,0,0,'');
INSERT INTO question VALUES(2138,'AC106','Wie groß ist der Betrag des kapazitiven Blindwiderstands eines Kondensators mit 100 pF bei einer Frequenz von 100 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(2139,'AC105','Wie groß ist der Betrag des kapazitiven Blindwiderstands eines Kondensators mit 50 pF bei einer Frequenz von 145 MHz ?',0,1,0,0,'');
INSERT INTO question VALUES(2140,'AC104','Wie groß ist der Betrag des kapazitiven Blindwiderstands eines Kondensators mit 10 pF bei einer Frequenz von 100 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(2141,'AC103','Welcher der folgenden Widerstände hat keine Wärmeverluste?',0,1,0,0,'');
INSERT INTO question VALUES(2142,'AC102','Welches Vorzeichen hat der Blindwiderstand eines idealen Kondensators und von welchen physikalischen Größen hängt er ab? Der Blindwiderstand ist ...',0,1,0,0,'');
INSERT INTO question VALUES(2143,'AC101','Ein verlustloser Kondensator wird an eine Wechselspannungsquelle angeschlossen. Welche Phasenverschiebung zwischen Spannung und Strom stellt sich ein?',0,1,0,0,'');
INSERT INTO question VALUES(2152,'AC211','Das folgende Bild zeigt einen Kern, um den ein Kabel für den Bau einer Drossel gewickelt ist. Der Kern sollte üblicherweise aus ...<p><img src=''AC211_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2153,'AC210','Um die Abstrahlungen der Spule eines abgestimmten Schwingkreises zu verringern, sollte die Spule ...',0,1,0,0,'');
INSERT INTO question VALUES(2154,'AC209','Neben dem induktiven Blindwiderstand treten in der mit Wechselstrom durchflossenen Spule auch Verluste auf, die rechnerisch in einem seriellen Verlustwiderstand zusammengefasst werden können. Als Maß für die Verluste in einer Spule wird auch ...',0,1,0,0,'');
INSERT INTO question VALUES(2155,'AC208','Ein Spulenkern hat eine Induktivitätskonstante (<img src=''texrender_question_2155_AC208_0.svg''>-Wert) von 30 nH. Wie groß ist die erforderliche Windungszahl zur Herstellung einer Induktivität von 12 μH in etwa?',0,1,0,0,'');
INSERT INTO question VALUES(2156,'AC207','Mit einem Ringkern, dessen Induktivitätskonstante (<img src=''texrender_question_2156_AC207_0.svg''>-Wert) mit 250 nH angegeben ist, soll eine Spule mit einer Induktivität von 2 mH hergestellt werden. Wie groß ist die erforderliche Windungszahl etwa?',0,1,0,0,'');
INSERT INTO question VALUES(2157,'AC206','Wie groß ist die Induktivität einer Spule mit 300 Windungen, die auf einen Kern mit einer Induktivitätskonstante (<img src=''texrender_question_2157_AC206_0.svg''>-Wert) von 1250 nH gewickelt ist?',0,1,0,0,'');
INSERT INTO question VALUES(2158,'AC205','Wie groß ist die Induktivität einer Spule mit 14 Windungen, die auf einen Kern mit einer Induktivitätskonstante (<img src=''texrender_question_2158_AC205_0.svg''>-Wert) von 1,5 nH gewickelt ist?',0,1,0,0,'');
INSERT INTO question VALUES(2159,'AC204','Wie groß ist der Betrag des induktiven Blindwiderstands einer Spule mit 3 μH Induktivität bei einer Frequenz von 100 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(2160,'AC203','Beim Anlegen einer Gleichspannung <img src=''texrender_question_2160_AC203_0.svg''> = 1 V an eine Spule messen Sie einen Strom. Wird der Strom beim Anlegen von einer Wechselspannung mit <img src=''texrender_question_2160_AC203_1.svg''> = 1 V größer oder kleiner?',0,1,0,0,'');
INSERT INTO question VALUES(2161,'AC202','Welches Vorzeichen hat der Blindwiderstand einer idealen Spule und von welchen physikalischen Größen hängt er ab? Der Blindwiderstand ist ...',0,1,0,0,'');
INSERT INTO question VALUES(2162,'AC201','In einer idealen Induktivität, die an einer Wechselspannungsquelle angeschlossen ist, eilt der Strom der angelegten Spannung ...',0,1,0,0,'');
INSERT INTO question VALUES(2171,'AC307','Eine Transformatorwicklung hat einen Drahtdurchmesser von 0,5 mm. Die zulässige Stromdichte beträgt 2,5 A/mm². Wie groß ist der zulässige Strom?',0,1,0,0,'');
INSERT INTO question VALUES(2172,'AC306','Für die Anpassung einer 50 Ohm Übertragungsleitung an eine endgespeiste Halbwellenantenne mit einem Fußpunktwiderstand von 2,5 kOhm wird ein Übertrager verwendet. Er sollte in etwa ein Windungverhältnis von ...',0,1,0,0,'');
INSERT INTO question VALUES(2173,'AC305','Für die Anpassung einer Antenne mit einem Fußpunktwiderstand von 450 Ohm an eine 50 Ohm-Übertragungsleitung sollte ein Übertrager mit einem Windungsverhältnis von ...',0,1,0,0,'');
INSERT INTO question VALUES(2174,'AC304','In dieser Schaltung beträgt <img src=''texrender_question_2174_AC304_0.svg''>=6,4 kOhm. Die Impedanz zwischen den Anschlüssen a und b beträgt im Idealfall ...<p><img src=''AC304_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2175,'AC303','In dieser Schaltung beträgt <img src=''texrender_question_2175_AC303_0.svg''>=16 kOhm. Die Impedanz zwischen den Anschlüssen a und b beträgt im Idealfall ...<p><img src=''AC303_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2176,'AC302','Ein Transformator setzt die Spannung von 230 V auf 6 V herunter und liefert dabei einen Strom von 1,15 A. Wie groß ist der dadurch in der Primärwicklung zu erwartende Strom bei Vernachlässigung der Verluste?',0,1,0,0,'');
INSERT INTO question VALUES(2177,'AC301','Durch Gegeninduktion wird in einer Spule eine Spannung erzeugt, wenn ...',0,1,0,0,'');
INSERT INTO question VALUES(2182,'AC408','Die Hauptfunktion eines Optokopplers ist ...',0,1,0,0,'');
INSERT INTO question VALUES(2183,'AC407','Welches Bauteil kann durch Lichteinfall elektrischen Strom erzeugen?',0,1,0,0,'');
INSERT INTO question VALUES(2184,'AC406','Das folgende Signal wird als <img src=''texrender_question_2184_AC406_0.svg''> an den Eingang der Schaltung mit Germaniumdioden gelegt. Wie sieht das zugehörige Ausgangssignal <img src=''texrender_question_2184_AC406_1.svg''> aus?<p><img src=''AC406_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2185,'AC405','Das folgende Signal wird als <img src=''texrender_question_2185_AC405_0.svg''> an den Eingang der Schaltung mit Siliziumdioden gelegt. Wie sieht das zugehörige Ausgangssignal <img src=''texrender_question_2185_AC405_1.svg''> aus?<p><img src=''AC405_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2186,'AC404','Wie verhält sich die Kapazität einer Kapazitätsdiode (Varicap)?',0,1,0,0,'');
INSERT INTO question VALUES(2187,'AC403','Wie verhält sich die Durchlassspannung einer Diode in Abhängigkeit von der Temperatur?',0,1,0,0,'');
INSERT INTO question VALUES(2188,'AC402','Wie verhalten sich die Elektronen in einem in Durchlassrichtung betriebenen PN-Übergang?',0,1,0,0,'');
INSERT INTO question VALUES(2189,'AC401','Ein in Durchlassrichtung betriebener PN-Übergang ermöglicht ...',0,1,0,0,'');
INSERT INTO question VALUES(2216,'AC524','In welcher der folgenden Schaltungen ist die Freilaufdiode richtig eingesetzt?',0,1,0,0,'');
INSERT INTO question VALUES(2217,'AC523','Welche Verlustleistung erzeugt ein Power-MOS-FET mit <img src=''texrender_question_2217_AC523_0.svg''> = 4 \mOhm bei einem Strom von 25 A?',0,1,0,0,'');
INSERT INTO question VALUES(2218,'AC522','Wie groß muss <img src=''texrender_question_2218_AC522_0.svg''> gewählt werden, damit sich eine Spannung von 2,8 V zwischen Gate und Source einstellt? <img src=''texrender_question_2218_AC522_1.svg''>=44 V; <img src=''texrender_question_2218_AC522_2.svg''>=10 kOhm; <img src=''texrender_question_2218_AC522_3.svg''>=2,2 kOhm ...<p><img src=''AC522_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2219,'AC521','Wie groß ist die Gate-Source-Spannung in der gezeichneten Schaltung? <img src=''texrender_question_2219_AC521_0.svg''>; <img src=''texrender_question_2219_AC521_1.svg''>; <img src=''texrender_question_2219_AC521_2.svg''>; <img src=''texrender_question_2219_AC521_3.svg''> ...<p><img src=''AC521_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2220,'AC520','Was passiert, wenn der Widerstand <img src=''texrender_question_2220_AC520_0.svg''> durch eine fehlerhafte Lötstelle an einer Seite keinen Kontakt mehr zur Schaltung hat? In welcher Antwort sind beide Aussagen richtig?<p><img src=''AC520_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2221,'AC519','Was passiert, wenn der Widerstand <img src=''texrender_question_2221_AC519_0.svg''> durch eine fehlerhafte Lötstelle an einer Seite keinen Kontakt mehr zur Schaltung hat? Welche Beschreibung trifft zu?<p><img src=''AC519_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2222,'AC518','Die Betriebsspannung beträgt 10 V, der Kollektorstrom soll 2 mA betragen, die Gleichstromverstärkung des Transistors beträgt 200. Durch den Querwiderstand <img src=''texrender_question_2222_AC518_0.svg''> soll der zehnfache Basisstrom fließen. Berechnen Sie den Vorwiderstand <img src=''texrender_question_2222_AC518_1.svg''>.<p><img src=''AC518_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2223,'AC517','Die Betriebsspannung beträgt 10 V, der Kollektorstrom soll 2 mA betragen, die Gleichstromverstärkung des Transistors beträgt 200. Durch den Querwiderstand <img src=''texrender_question_2223_AC517_0.svg''> soll der zehnfache Basisstrom fließen. Am Emitterwiderstand soll 1 V abfallen. Berechnen Sie den Vorwiderstand <img src=''texrender_question_2223_AC517_1.svg''>.<p><img src=''AC517_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2224,'AC516','Warum soll bei dem gezeigten Basisspannungsteiler der Strom durch <img src=''texrender_question_2224_AC516_0.svg''> etwa 10-mal größer als der Basisstrom sein?<p><img src=''AC516_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2225,'AC515','Die Betriebsspannung beträgt 12 V, der Kollektorstrom soll 5 mA betragen, die Gleichstromverstärkung des Transistors beträgt 298. Berechnen Sie den Vorwiderstand <img src=''texrender_question_2225_AC515_0.svg''>.<p><img src=''AC515_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2226,'AC514','Wie erfolgt die Steuerung des Stroms im Feldeffekttransistor (FET)?',0,1,0,0,'');
INSERT INTO question VALUES(2227,'AC513','Wie bezeichnet man die Anschlüsse des abgebildeten Transistors?<p><img src=''AC513_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2228,'AC512','Wie lauten die Bezeichnungen der Anschlüsse eines Feldeffekttransistors?',0,1,0,0,'');
INSERT INTO question VALUES(2229,'AC511','Welcher der folgenden Transistoren ist ein selbstleitender P-Kanal-MOSFET?',0,1,0,0,'');
INSERT INTO question VALUES(2230,'AC510','Welcher der folgenden Transistoren ist ein selbstleitender N-Kanal-MOSFET?',0,1,0,0,'');
INSERT INTO question VALUES(2231,'AC509','Welcher der folgenden Transistoren ist ein selbstsperrender N-Kanal-MOSFET?',0,1,0,0,'');
INSERT INTO question VALUES(2232,'AC508','Der folgende Transistor ist ein ...<p><img src=''AC508_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2233,'AC507','Welche Bezeichnungen für die Bauelemente sind richtig?<p><img src=''AC507_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2234,'AC506','Welches Bauteil wird durch das Schaltzeichen symbolisiert?<p><img src=''AC506_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2235,'AC505','Bei einem bipolaren Transistor in leitendem Zustand befindet sich der Basis-Emitter-PN-Übergang ...',0,1,0,0,'');
INSERT INTO question VALUES(2236,'AC504','Mit welchem Anschluss ist der n-dotierte Bereich eines PNP-Transistors verbunden?',0,1,0,0,'');
INSERT INTO question VALUES(2237,'AC503','Mit welchem Anschluss ist der p-dotierte Bereich eines NPN-Transistors verbunden?',0,1,0,0,'');
INSERT INTO question VALUES(2238,'AC502','Ein Feldeffekttransistor ist ...',0,1,0,0,'');
INSERT INTO question VALUES(2239,'AC501','Ein bipolarer Transistor ist ...',0,1,0,0,'');
INSERT INTO question VALUES(2256,'AC604','Was ist typisch für einen Monolithic Microwave Integrated Circuit (MMIC)?',0,1,0,0,'');
INSERT INTO question VALUES(2257,'AC603','Welchen Vorteil hat ein Monolithic Microwave Integrated Circuit (MMIC) gegenüber einem diskreten Transistorverstärker?',0,1,0,0,'');
INSERT INTO question VALUES(2258,'AC602','Welche Bauteile sind in einem Monolithic Microwave Integrated Circuit (MMIC) enthalten?',0,1,0,0,'');
INSERT INTO question VALUES(2259,'AC601','Eine integrierte Schaltung ist ...',0,1,0,0,'');
INSERT INTO question VALUES(2260,'AD115','Wenn der dargestellte Spannungsteiler mit <img src=''texrender_question_2260_AD115_0.svg''> belastet wird, dann ergibt sich folgender Zusammenhang:<p><img src=''AD115_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2261,'AD114','Wie groß ist die Spannung <img src=''texrender_question_2261_AD114_0.svg''> in der Schaltung mit folgenden Werten: <img src=''texrender_question_2261_AD114_1.svg''>, <img src=''texrender_question_2261_AD114_2.svg''>, <img src=''texrender_question_2261_AD114_3.svg''>, <img src=''texrender_question_2261_AD114_4.svg''><p><img src=''AD114_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2262,'AD113','Die Spannung an der Brückenschaltung beträgt 11 V. Die Widerstände haben folgende Werte: <img src=''texrender_question_2262_AD113_0.svg''> = 1 kOhm; <img src=''texrender_question_2262_AD113_1.svg''> = 10 kOhm; <img src=''texrender_question_2262_AD113_2.svg''> = 10 kOhm; <img src=''texrender_question_2262_AD113_3.svg''> = 1 kOhm. Wie groß ist die Spannung zwischen A und B im Brückenzweig (gemessen von A nach B)?<p><img src=''AD113_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2263,'AD112','Die Spannung an der Brückenschaltung beträgt 10 V. Alle Widerstände haben einen Wert von 50 Ohm. Wie groß ist die Spannung zwischen A und B im Brückenzweig (gemessen von A nach B)?<p><img src=''AD112_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2264,'AD111','In welchem Verhältnis müssen die Widerstände <img src=''texrender_question_2264_AD111_0.svg''> bis <img src=''texrender_question_2264_AD111_1.svg''> zueinander stehen, damit das Messinstrument im Brückenzweig keine Spannung anzeigt?<p><img src=''AD111_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2265,'AD110','Wenn <img src=''texrender_question_2265_AD110_0.svg''> und <img src=''texrender_question_2265_AD110_1.svg''> je 2,2 kOhm haben und <img src=''texrender_question_2265_AD110_2.svg''> und <img src=''texrender_question_2265_AD110_3.svg''> je 220 Ohm betragen, hat die Schaltung zwischen den Punkten a und b einen Gesamtwiderstand von ...<p><img src=''AD110_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2266,'AD109','In welchem Bereich liegt der Eingangswiderstand der folgenden Schaltung, wenn <img src=''texrender_question_2266_AD109_0.svg''> alle Werte von 0 Ohm bis 1 kOhm annehmen kann? <p><img src=''AD109_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2267,'AD108','Welche Leistung tritt in <img src=''texrender_question_2267_AD108_0.svg''> auf, wenn <img src=''texrender_question_2267_AD108_1.svg''> = 15 V und alle Widerstände <img src=''texrender_question_2267_AD108_2.svg''> bis <img src=''texrender_question_2267_AD108_3.svg''> je 10 kOhm betragen? <p><img src=''AD108_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2268,'AD107','Wie groß ist der Strom durch <img src=''texrender_question_2268_AD107_0.svg''>, wenn <img src=''texrender_question_2268_AD107_1.svg''> = 15 V und alle Widerstände <img src=''texrender_question_2268_AD107_2.svg''> bis <img src=''texrender_question_2268_AD107_3.svg''> je 10 kOhm betragen?<p><img src=''AD107_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2269,'AD106','Wie groß ist die Spannung <img src=''texrender_question_2269_AD106_0.svg''>, wenn durch <img src=''texrender_question_2269_AD106_1.svg''> ein Strom von 1 mA fließt und alle Widerstände <img src=''texrender_question_2269_AD106_2.svg''> bis <img src=''texrender_question_2269_AD106_3.svg''> je 10 kOhm betragen? <p><img src=''AD106_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2270,'AD105','Berechne den Betrag des Scheinwiderstands <img src=''texrender_question_2270_AD105_0.svg''> für eine Reihenschaltung aus <img src=''texrender_question_2270_AD105_1.svg''> = 100 Ohm und <img src=''texrender_question_2270_AD105_2.svg''> = 100 μH bei 1 MHz.',0,1,0,0,'');
INSERT INTO question VALUES(2271,'AD104','Berechne den Betrag des Scheinwiderstands <img src=''texrender_question_2271_AD104_0.svg''> für eine Reihenschaltung aus <img src=''texrender_question_2271_AD104_1.svg''> = 100 Ohm und <img src=''texrender_question_2271_AD104_2.svg''> = 1 nF bei 1 MHz.',0,1,0,0,'');
INSERT INTO question VALUES(2272,'AD103','Wie groß ist die Gesamtkapazität dieser Schaltung, wenn <img src=''texrender_question_2272_AD103_0.svg''> = 0,1 nF, <img src=''texrender_question_2272_AD103_1.svg''> = 1,5 nF, <img src=''texrender_question_2272_AD103_2.svg''> = 220 pF und die Eigenkapazität der Spule 1 pF beträgt?<p><img src=''AD103_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2273,'AD102','Wie groß ist die Gesamtinduktivität von drei in Reihe geschalteten Spulen von 2200 nH, 0,033 mH und 150 μH?',0,1,0,0,'');
INSERT INTO question VALUES(2274,'AD101','Wie groß ist die Gesamtkapazität, wenn drei Kondensatoren <img src=''texrender_question_2274_AD101_0.svg''> = 0,10 nF, <img src=''texrender_question_2274_AD101_1.svg''> = 47 pF und <img src=''texrender_question_2274_AD101_2.svg''> = 22 pF in Reihe geschaltet werden?',0,1,0,0,'');
INSERT INTO question VALUES(2299,'AD229','Welche Kopplung eines Bandfilters wird "kritische Kopplung" genannt?',0,1,0,0,'');
INSERT INTO question VALUES(2300,'AD228','Das folgende Bild zeigt ein typisches ZF-Filter und vier seiner möglichen Übertragungskurven (a bis d). Welche Kurve ergibt sich bei kritischer Kopplung und welche bei überkritischer Kopplung?<p><img src=''AD228_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2301,'AD227','Das folgende Bild zeigt ein induktiv gekoppeltes Bandfilter und vier seiner möglichen Übertragungskurven (a bis d). Welche der folgenden Aussagen ist richtig?<p><img src=''AD227_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2302,'AD226','Welchen Gütefaktor <img src=''texrender_question_2302_AD226_0.svg''> hat die Parallelschaltung einer Spule von 2,2 μH mit einem Kondensator von 56 pF und einem Widerstand von 1 kOhm?',0,1,0,0,'');
INSERT INTO question VALUES(2303,'AD225','Welchen Gütefaktor <img src=''texrender_question_2303_AD225_0.svg''> hat die Reihenschaltung einer Spule von 100 μH mit einem Kondensator von 0,01 μF und einem Widerstand von 10 Ohm?',0,1,0,0,'');
INSERT INTO question VALUES(2304,'AD224','Welche Bandbreite <img src=''texrender_question_2304_AD224_0.svg''> hat die Parallelschaltung einer Spule von 2,2 μH mit einem Kondensator von 56 pF und einem Widerstand von 1 kOhm?',0,1,0,0,'');
INSERT INTO question VALUES(2305,'AD223','Welche Bandbreite <img src=''texrender_question_2305_AD223_0.svg''> hat die Reihenschaltung einer Spule von 100 μH mit einem Kondensator von 0,01 μF und einem Widerstand von 10 Ohm?',0,1,0,0,'');
INSERT INTO question VALUES(2306,'AD222','Ein Quarzfilter mit einer 3 dB-Bandbreite von 500 Hz eignet sich besonders zur Verwendung in einem Sendeempfänger für ...',0,1,0,0,'');
INSERT INTO question VALUES(2307,'AD221','Ein Quarzfilter mit einer 3 dB-Bandbreite von 2,7 kHz eignet sich besonders zur Verwendung in einem Sendeempfänger für ...',0,1,0,0,'');
INSERT INTO question VALUES(2308,'AD220','Wie ergibt sich die Bandbreite <img src=''texrender_question_2308_AD220_0.svg''> eines Parallelschwingkreises aus der Resonanzkurve?',0,1,0,0,'');
INSERT INTO question VALUES(2309,'AD219','Wie groß ist die Bandbreite in dem dargestellten Diagramm bei -60 dB?<p><img src=''AD219_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2310,'AD218','Wie verändert sich die Frequenz des Schwingkreises in der folgenden Schaltung, wenn das Potentiometer mehr in Richtung X gedreht wird?<p><img src=''AD218_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2311,'AD217','Sie wollen die Resonanzfrequenz eines Schwingkreises verringern. Welche der folgenden Maßnahmen ist geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(2312,'AD216','Sie wollen die Resonanzfrequenz eines Schwingkreises verringern. Welche der folgenden Maßnahmen ist geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(2313,'AD215','Sie wollen die Resonanzfrequenz eines Schwingkreises verringern. Welche der folgenden Maßnahmen ist geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(2314,'AD214','Sie wollen die Resonanzfrequenz eines Schwingkreises vergrößern. Welche der folgenden Maßnahmen ist geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(2315,'AD213','Sie wollen die Resonanzfrequenz eines Schwingkreises vergrößern. Welche der folgenden Maßnahmen ist geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(2316,'AD212','Wie groß ist die Resonanzfrequenz dieser Schaltung, wenn die Kapazitäten <img src=''texrender_question_2316_AD212_0.svg''> = 0,1 nF, <img src=''texrender_question_2316_AD212_1.svg''> = 1,5 nF, <img src=''texrender_question_2316_AD212_2.svg''> = 220 pF und die Induktivität der Spule 1,2 mH betragen?<p><img src=''AD212_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2317,'AD211','Welche Resonanzfrequenz <img src=''texrender_question_2317_AD211_0.svg''> hat die Parallelschaltung einer Spule von 2,2 μH mit einem Kondensator von 56 pF und einem Widerstand von 10 kOhm?<p><img src=''AD211_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2318,'AD210','Welche Resonanzfrequenz <img src=''texrender_question_2318_AD210_0.svg''> hat die Reihenschaltung einer Spule von 100 μH mit einem Kondensator von 0,01 μF und einem Widerstand von 100 Ohm?<p><img src=''AD210_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2319,'AD209','Welche Resonanzfrequenz <img src=''texrender_question_2319_AD209_0.svg''> hat die Reihenschaltung einer Spule von 10 μH mit einem Kondensator von 1 nF und einem Widerstand von 0,1 kOhm?<p><img src=''AD209_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2320,'AD208','Welche Resonanzfrequenz <img src=''texrender_question_2320_AD208_0.svg''> hat die Reihenschaltung einer Spule von 1,2 μH mit einem Kondensator von 6,8 pF und einem Widerstand von 10 Ohm?<p><img src=''AD208_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2321,'AD207','Bei der Resonanzfrequenz ist die Impedanz dieser Schaltung ...<p><img src=''AD207_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2322,'AD206','Was ist im Resonanzfall bei der Reihenschaltung einer Induktivität mit einer Kapazität erfüllt?',0,1,0,0,'');
INSERT INTO question VALUES(2323,'AD205','Welche der nachfolgenden Beschreibungen trifft auf diese Schaltung zu und wie nennt man sie? <p><img src=''AD205_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2324,'AD204','Welcher Schwingkreis passt zu dem neben der jeweiligen Schaltung dargestellten Verlauf der Impedanz?',0,1,0,0,'');
INSERT INTO question VALUES(2325,'AD203','Wo liegt die Grenzfrequenz des Audio-Verstärkers, wenn <img src=''texrender_question_2325_AD203_0.svg''> = 4,7 \kiloOhm, <img src=''texrender_question_2325_AD203_1.svg''> = 6,8 nF und <img src=''texrender_question_2325_AD203_2.svg''> = 47 nF betragen? Der Verstärker hat eine Grenzfrequenz von 1 MHz und die Impedanz des Eingangs PIN 2 ist mit 1 MOhm sehr hochohmig.<p><img src=''AD203_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2326,'AD202','Welche Grenzfrequenz ergibt sich bei einem Tiefpass mit einem Widerstand von 10 kOhm und einem Kondensator von 47 nF?<p><img src=''AD202_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2327,'AD201','Welche Grenzfrequenz ergibt sich bei einem Hochpass mit einem Widerstand von 4,7 kOhm und einem Kondensator von 2,2 nF?<p><img src=''AD201_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2344,'AD325','Was ist bei der Dimensionierung der Spule in dem dargestellten Bias-T zu beachten?<p><img src=''AD325_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2345,'AD324','Zu welchem Zweck dient <img src=''texrender_question_2345_AD324_0.svg''> in dem dargestellten Bias-T?<p><img src=''AD324_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2346,'AD323','Was stellt die folgende Schaltung dar? <p><img src=''AD323_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2347,'AD322','Zu welchem Zweck wird ein Bias-T (Fernspeiseweiche) eingesetzt?',0,1,0,0,'');
INSERT INTO question VALUES(2348,'AD321','Wie groß ist der Wirkungsgrad <img src=''texrender_question_2348_AD321_0.svg''> der dargestellten Spannungsstabilisierung, wenn durch den Lastwiderstand <img src=''texrender_question_2348_AD321_1.svg''> = 470 Ohm ein Strom von <img src=''texrender_question_2348_AD321_2.svg''> = 10 mA und durch die Z-Diode ein Strom <img src=''texrender_question_2348_AD321_3.svg''> = 15 mA fließt.<p><img src=''AD321_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2349,'AD320','Ein linearer Spannungsregler stabilisiert eine Eingangsspannung von 13,8 V auf eine Ausgangsspannung von 5 V. Es fließt ein Eingangsstrom von 455 mA und ein Ausgangsstrom von 450 mA. Wie groß ist der Wirkungsgrad?',0,1,0,0,'');
INSERT INTO question VALUES(2350,'AD319','Ein linearer Spannungsregler stabilisiert eine Eingangsspannung von 13,8 V auf eine Ausgangsspannung von 9 V. Es fließt ein Ausgangsstrom von 900 mA. Wie groß ist die Verlustleistung im Spannungsregler?',0,1,0,0,'');
INSERT INTO question VALUES(2351,'AD318','Wie groß ist die Verlustleistung im Linearspannungsregler IC1?<p><img src=''AD318_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2352,'AD317','Bei dieser Schaltung mit einem 12 V-Festspannungsregler schwankt die Eingangsspannung zwischen 15 V und 18 V. Wie groß ist die Spannungsschwankung am Ausgang?<p><img src=''AD317_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2353,'AD316','Welche Beziehung muss zwischen der Eingangsspannung und der Ausgangsspannung der folgenden Schaltung bestehen, damit der Linearspannungsregler IC1 eine stabilisierte Ausgangsspannung erzeugt?<p><img src=''AD316_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2354,'AD315','Wenn man folgendes Signal an den Eingang der gezeigten Schaltung anlegt, beträgt die Ausgangsspannung zwischen A und B ungefähr ...<p><img src=''AD315_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2355,'AD314','Welche der dargestellten Schaltungen könnte in den Netzeingang eines Schaltnetzteils eingebaut werden, um eine Verbreitung von Störungen in das Stromversorgungsnetz zu verringern?',0,1,0,0,'');
INSERT INTO question VALUES(2356,'AD313','In einem Amateurfunkempfänger werden etwa alle 120 kHz unerwünschte Signale festgestellt. Dies ist wahrscheinlich zurückzuführen auf ...',0,1,0,0,'');
INSERT INTO question VALUES(2357,'AD312','Was ist der Hauptnachteil des dargestellten Schaltnetzteils?<p><img src=''AD312_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2358,'AD311','Welche Funktion übernimmt der elektronische Schalter (Block E) des Schaltnetzteils?<p><img src=''AD311_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2359,'AD310','Welche Grundfrequenz hat die Ausgangsspannung eines Vollweggleichrichters, der an eine 50 Hz-Versorgung angeschlossen ist?',0,1,0,0,'');
INSERT INTO question VALUES(2360,'AD309','Im folgenden Bild ist die Spannung am Ausgang einer Stromversorgung dargestellt. Die Restwelligkeit und die Brummfrequenz betragen ...<p><img src=''AD309_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2361,'AD308','Welche Form hat die Ausgangsspannung der dargestellten Schaltung?<p><img src=''AD308_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2362,'AD307','Welche Gleichrichterschaltung erzeugt eine Vollweg-Gleichrichtung mit der angezeigten Polarität?',0,1,0,0,'');
INSERT INTO question VALUES(2363,'AD306','Wie groß ist die Spannung am Siebkondensator <img src=''texrender_question_2363_AD306_0.svg''> im Leerlauf, wenn die Netzwechselspannung von 230 V anliegt und das Windungsverhältnis 8:1 beträgt?<p><img src=''AD306_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2364,'AD305','Welche der folgenden Auswahlantworten enthält die richtige Diodenanordnung und Polarität eines Brückengleichrichters?',0,1,0,0,'');
INSERT INTO question VALUES(2365,'AD304','Bei einem Transformationsverhältnis von 5:1 sollte die Spannungsfestigkeit der Diode (max. Spannung plus 20 % Sicherheitsaufschlag) in dieser Schaltung nicht weniger als ...<p><img src=''AD304_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2366,'AD303','Welche Spannungsfestigkeit des Kondensators sollte mindestens gewählt werden, wenn das Transformationsverhältnis 20:1 beträgt und ein Sicherheitsaufschlag auf die Spannungsfestigkeit von 50 % berücksichtigt werden soll?<p><img src=''AD303_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2367,'AD302','Berechnen Sie für diese Schaltung die Leerlaufspannung an den Klemmen A - B.<p><img src=''AD302_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2368,'AD301','Ein Photovoltaikmodul besteht aus vier parallel geschalteten Reihen von je 30 Solarzellen mit je Zelle 0,6 V Leerlaufspannung und 1 A Kurzschlussstrom. Welche Leerlaufspannung und welchen Kurzschlussstrom liefert das Modul?<p><img src=''AD301_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2383,'AD433','Welche Baugruppe sollte für die Begrenzung der NF-Bandbreite eines Mikrofonverstärkers verwendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(2384,'AD432','Was ist die Ursache für Eigenschwingungen eines Verstärkers?',0,1,0,0,'');
INSERT INTO question VALUES(2385,'AD431','Welche Eigenschaft besitzt ein Linearverstärker?',0,1,0,0,'');
INSERT INTO question VALUES(2386,'AD430','Ein HF-Verstärker ist an eine 12,5 V-Gleichstrom-Versorgung angeschlossen. Wenn die HF-Ausgangsleistung des Verstärkers 90 W beträgt, zeigt das an die Stromversorgung angeschlossene Strommessgerät 16 A an. Der Wirkungsgrad des Verstärkers beträgt ...',0,1,0,0,'');
INSERT INTO question VALUES(2387,'AD429','Eine Treiberstufe eines HF-Verstärkers braucht am Eingang eine Leistung von 1 W, um am Ausgang 10 W an die Endstufe abgeben zu können. Sie benötigt dazu eine Gleichstromleistung von 25 W. Wie hoch ist der Wirkungsgrad der Treiberstufe?',0,1,0,0,'');
INSERT INTO question VALUES(2388,'AD428','Ein Leistungsverstärker hebt die Eingangsleistung von 2,5 W auf 38 W Ausgangsleistung an. Dem entspricht eine Leistungsverstärkung von ...',0,1,0,0,'');
INSERT INTO question VALUES(2389,'AD427','Ein NF-Verstärker hebt die Eingangsspannung von 1 mV auf 4 mV Ausgangsspannung an. Eingangs- und Ausgangswiderstand sind gleich. Wie groß ist die Spannungsverstärkung des Verstärkers?',0,1,0,0,'');
INSERT INTO question VALUES(2390,'AD426','Ein HF-Leistungsverstärker hat eine Verstärkung von 16 dB. Welche HF-Ausgangsleistung ist zu erwarten, wenn der Verstärker mit 1 W HF-Eingangsleistung angesteuert wird?',0,1,0,0,'');
INSERT INTO question VALUES(2391,'AD425','Ein HF-Leistungsverstärker im C-Betrieb wird mit einer Drainspannung von 50 V und einem Drainstrom von 2 A betrieben. Wie hoch ist die zu erwartende Ausgangsleistung des Verstärkers?',0,1,0,0,'');
INSERT INTO question VALUES(2392,'AD424','Ein HF-Leistungsverstärker im A-Betrieb wird mit einer Drainspannung von 50 V und einem Drainstrom von 2 A betrieben. Wie hoch ist die zu erwartende Ausgangsleistung des Verstärkers?',0,1,0,0,'');
INSERT INTO question VALUES(2393,'AD423','Wenn ein linearer HF-Leistungsverstärker im AB-Betrieb durch ein SSB-Signal übersteuert wird, führt dies zu ...',0,1,0,0,'');
INSERT INTO question VALUES(2394,'AD422','In welchem Arbeitspunkt kann ein HF-Leistungsverstärker für einen SSB-Sender betrieben werden?',0,1,0,0,'');
INSERT INTO question VALUES(2395,'AD421','Welche Merkmale hat ein HF-Leistungsverstärker im C-Betrieb?',0,1,0,0,'');
INSERT INTO question VALUES(2396,'AD420','Welche Merkmale hat ein HF-Leistungsverstärker im B-Betrieb?',0,1,0,0,'');
INSERT INTO question VALUES(2397,'AD419','Welche Merkmale hat ein HF-Leistungsverstärker im A-Betrieb?',0,1,0,0,'');
INSERT INTO question VALUES(2398,'AD418','In welcher Größenordnung liegt der Ruhestrom eines HF-Leistungsverstärkers im C-Betrieb?',0,1,0,0,'');
INSERT INTO question VALUES(2399,'AD417','Wie verhält sich der Kollektorstrom eines NPN-Transistors in einer HF-Verstärkerstufe im B-Betrieb, wenn die Basis-Emitterspannung erhöht wird?',0,1,0,0,'');
INSERT INTO question VALUES(2400,'AD416','Das folgende Bild zeigt eine idealisierte Steuerkennlinie eines Transistors mit vier eingezeichneten Arbeitspunkten <img src=''texrender_question_2400_AD416_0.svg''> bis <img src=''texrender_question_2400_AD416_1.svg''>.  Welcher Arbeitspunkt ist welcher Verstärkerbetriebsart zuzuordnen?<p><img src=''AD416_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2401,'AD415','Bei folgender Emitterschaltung wird die Schaltung ohne den Emitterkondensator betrieben. Auf welchen Betrag sinkt die Spannungsverstärkung ungefähr?<p><img src=''AD415_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2402,'AD414','Wie verhält sich die Spannungsverstärkung bei der folgenden Schaltung, wenn der Kondensator <img src=''texrender_question_2402_AD414_0.svg''> entfernt wird?<p><img src=''AD414_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2403,'AD413','Welche Funktion hat der Kondensator <img src=''texrender_question_2403_AD413_0.svg''> in der folgenden Schaltung? Er dient zur ...<p><img src=''AD413_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2404,'AD412','Welche Funktion haben die Kondensatoren <img src=''texrender_question_2404_AD412_0.svg''> und <img src=''texrender_question_2404_AD412_1.svg''> in der folgenden Schaltung? Sie dienen zur ...<p><img src=''AD412_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2405,'AD411','Welche Funktion haben die Widerstände <img src=''texrender_question_2405_AD411_0.svg''> und <img src=''texrender_question_2405_AD411_1.svg''> in der folgenden Schaltung? Sie dienen zur ...<p><img src=''AD411_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2406,'AD410','Was lässt sich über die Wechselspannungsverstärkung <img src=''texrender_question_2406_AD410_0.svg''> und die Phasenverschiebung <img src=''texrender_question_2406_AD410_1.svg''> zwischen Ausgangs- und Eingangsspannung dieser Schaltung aussagen?<p><img src=''AD410_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2407,'AD409','Bei dieser Schaltung handelt es sich um ...<p><img src=''AD409_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2408,'AD408','Das Signal <img src=''texrender_question_2408_AD408_0.svg''> wird auf den Eingang folgender Schaltung gegeben. In welcher Antwort sind alle dargestellten Signale phasenrichtig zugeordnet?<p><img src=''AD408_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2409,'AD407','Welche Phasenverschiebung tritt zwischen den sinusförmigen Ein- und Ausgangsspannungen eines Transistorverstärkers in Emitterschaltung auf?',0,1,0,0,'');
INSERT INTO question VALUES(2410,'AD406','An den Eingang dieser Schaltung wird das folgende Signal gelegt. Welches ist ein mögliches Ausgangssignal <img src=''texrender_question_2410_AD406_0.svg''>?<p><img src=''AD406_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2411,'AD405','Welche Phasenverschiebung tritt zwischen den sinusförmigen Ein- und Ausgangsspannungen eines Transistorverstärkers in Kollektorschaltung auf?',0,1,0,0,'');
INSERT INTO question VALUES(2412,'AD404','Diese Schaltung kann unter anderem als ...<p><img src=''AD404_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2413,'AD403','Die Ausgangsimpedanz dieser Schaltung ist ...<p><img src=''AD403_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2414,'AD402','Was lässt sich über die Wechselspannungsverstärkung <img src=''texrender_question_2414_AD402_0.svg''> und die Phasenverschiebung <img src=''texrender_question_2414_AD402_1.svg''> zwischen Ausgangs- und Eingangsspannung dieser Schaltung aussagen?<p><img src=''AD402_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2415,'AD401','Bei dieser Schaltung handelt es sich um ...<p><img src=''AD401_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2419,'AD510','Welche Signale stehen am Ausgang eines symmetrisch eingestellten Balancemischers an?',0,1,0,0,'');
INSERT INTO question VALUES(2420,'AD509','Was ermöglicht die abgebildete Schaltung?<p><img src=''AD509_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2421,'AD508','Bei dieser Schaltung handelt es sich um einen Modulator zur Erzeugung von ...<p><img src=''AD508_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2422,'AD507','Bei dieser Schaltung handelt es sich um einen ...<p><img src=''AD507_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2423,'AD506','Bei dieser Schaltung handelt es sich um einen ...<p><img src=''AD506_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2424,'AD505','Bei dieser Schaltung handelt es sich um einen ...<p><img src=''AD505_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2425,'AD504','Bei dieser Schaltung handelt es sich um einen ...<p><img src=''AD504_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2426,'AD503','Bei dieser Schaltung ist der mit X bezeichnete Anschluss ...<p><img src=''AD503_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2427,'AD502','Am ZF-Eingang des Hüllkurvendemodulators liegt das dargestellte Signal an. Welches der folgenden Signale zeigt sich an dem mit X bezeichneten Punkt der Schaltung?<p><img src=''AD502_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2428,'AD501','Bei dieser Schaltung handelt es sich um einen ...<p><img src=''AD501_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2429,'AD620','Um welche Art von Frequenzaufbereitung handelt es sich bei der dargestellten Schaltung?<p><img src=''AD620_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2430,'AD619','Für die Messung der Oszillatorfrequenz sollte der Tastkopf hier vorzugsweise am Punkt ...<p><img src=''AD619_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2431,'AD618','Welche Auswirkung hat die Messung der Oszillatorfrequenz mit einem Tastkopf an Punkt 3?<p><img src=''AD618_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2432,'AD617',' Bei dieser Oszillatorschaltung handelt es sich um einen kapazitiv rückgekoppelten Quarz-Oszillator in ...<p><img src=''AD617_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2433,'AD616','Welche Funktion haben die beiden Kondensatoren <img src=''texrender_question_2433_AD616_0.svg''> und <img src=''texrender_question_2433_AD616_1.svg''> in der folgenden Schaltung?<p><img src=''AD616_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2434,'AD615','An welchem Punkt der Schaltung sollte die HF-Ausgangsleistung ausgekoppelt werden?<p><img src=''AD615_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2435,'AD614',' Bei dieser Schaltung handelt es sich um ...<p><img src=''AD614_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2436,'AD613','Welche Bedingungen müssen zur Erzeugung ungedämpfter Schwingungen in Oszillatoren erfüllt sein?',0,1,0,0,'');
INSERT INTO question VALUES(2437,'AD612','Wie sollte die Gleichspannungsversorgung eines VFOs beschaffen sein, um Rückwirkungen nachfolgender HF-Leistungsverstärkerstufen zu verhindern?',0,1,0,0,'');
INSERT INTO question VALUES(2438,'AD611','Wenn HF-Signale unerwünscht auf einen VFO zurückkoppeln, kann dies zu ...',0,1,0,0,'');
INSERT INTO question VALUES(2439,'AD610','Wie sollte ein Oszillator im Regelfall ausgangsseitig betrieben werden?',0,1,0,0,'');
INSERT INTO question VALUES(2440,'AD609','Wodurch wird "Chirp" bei Morsetelegrafie hervorgerufen?',0,1,0,0,'');
INSERT INTO question VALUES(2441,'AD608','Worauf ist bei der Spannungsversorgung eines VFO zu achten?',0,1,0,0,'');
INSERT INTO question VALUES(2442,'AD607','Wie sollte der VFO in einem Sender betrieben werden, damit seine Frequenz stabil bleibt?',0,1,0,0,'');
INSERT INTO question VALUES(2443,'AD606','Welche Eigenschaften besitzt ein GPSDO?',0,1,0,0,'');
INSERT INTO question VALUES(2444,'AD605','Welcher der angegebenen Oszillatoren hat die größte Frequenzstabilität?',0,1,0,0,'');
INSERT INTO question VALUES(2445,'AD604','Welcher Oszillator ist für einen SSB-SDR-Sender im 3 cm Band geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(2446,'AD603','Wie nennt man einen temperaturkompensierten Quarzoszillator?',0,1,0,0,'');
INSERT INTO question VALUES(2447,'AD602','Unter einem TCXO versteht man einen ...',0,1,0,0,'');
INSERT INTO question VALUES(2448,'AD601','Was versteht man unter einem VCO? Ein VCO ist ein ...',0,1,0,0,'');
INSERT INTO question VALUES(2457,'AD705','Ein Frequenzsynthesizer soll eine einstellbare Frequenz mit hoher Frequenzgenauigkeit erzeugen. Die Genauigkeit und Stabilität der Ausgangsfrequenz eines Frequenzsynthesizers wird hauptsächlich bestimmt von ...',0,1,0,0,'');
INSERT INTO question VALUES(2458,'AD704','Die Frequenz an Punkt A beträgt 12,5 kHz. Es sollen Ausgangsfrequenzen im Bereich von 12,000 MHz bis 14,000 MHz erzeugt werden. In welchem Bereich bewegt sich dabei das Teilerverhältnis n?<p><img src=''AD704_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2459,'AD703','Wie groß muss bei der folgenden Schaltung die Frequenz an Punkt A sein, wenn ein Kanalabstand von 12,5 kHz benötigt wird?<p><img src=''AD703_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2460,'AD702','Welche der nachfolgenden Aussagen ist richtig, wenn die im Bild dargestellte Regelschleife in stabilem Zustand ist?<p><img src=''AD702_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2461,'AD701','Welche Baugruppen muss eine Phasenregelschleife (PLL) mindestens enthalten?',0,1,0,0,'');
INSERT INTO question VALUES(2462,'AD806','In einem 50 Ohm System wird in ein symmetrisches 20 dB Dämpfungsglied die Leistung von 100 W eingespeist. Der Widerstand <img src=''texrender_question_2462_AD806_0.svg''> = 50 Ohm ist an das Dämpfungsglied angepasst. Welche Leistung wird insgesamt im Dämpfungsglied in Wärme umgesetzt?<p><img src=''AD806_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2463,'AD805','Dargestellt ist ein symmetrisches 50 Ohm Dämpfungsglied. Welche Impedanz ist zwischen <img src=''texrender_question_2463_AD805_0.svg''> und <img src=''texrender_question_2463_AD805_1.svg''> messbar, wenn <img src=''texrender_question_2463_AD805_2.svg''> = 50 Ohm beträgt?<p><img src=''AD805_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2464,'AD804','Dargestellt ist ein 6 dB Dämpfungsglied. Wie groß ist das Leistungsverhältnis zwischen der Eingangsleistung <img src=''texrender_question_2464_AD804_0.svg''> und der Leistung am Lastwiderstand <img src=''texrender_question_2464_AD804_1.svg''>?<p><img src=''AD804_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2465,'AD803','Dargestellt ist ein 20 dB Dämpfungsglied. Wie groß ist das Leistungsverhältnis zwischen der Eingangsleistung <img src=''texrender_question_2465_AD803_0.svg''> und der Leistung am Lastwiderstand <img src=''texrender_question_2465_AD803_1.svg''>?<p><img src=''AD803_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2466,'AD802','Was zeigt diese Schaltung?<p><img src=''AD802_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2467,'AD801','Was zeigt diese Schaltung?<p><img src=''AD801_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2468,'AE101','Welcher Wert ist in folgender Aussage für X einzusetzen? Die "belegte Bandbreite" ist gemäß der Amateurfunkverordnung die Frequenzbandbreite, bei der die unterhalb ihrer unteren und oberhalb ihrer oberen Frequenzgrenzen ausgesendeten mittleren Leistungen jeweils X an der gesamten mittleren Leistung betragen.<p><img src=''AE101_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2472,'AE214','Welches dieser amplitudenmodulierten Signale belegt die geringste Bandbreite?',0,1,0,0,'');
INSERT INTO question VALUES(2473,'AE213','Welche Aufgabe hat der Equalizer in einem SSB-Sender?',0,1,0,0,'');
INSERT INTO question VALUES(2474,'AE212','Welche Folge hat eine zu hohe Kompressionseinstellung des Dynamik-Kompressors im SSB-Sender?',0,1,0,0,'');
INSERT INTO question VALUES(2475,'AE211','Welche Aufgabe hat der Dynamik-Kompressor in einem SSB-Sender?',0,1,0,0,'');
INSERT INTO question VALUES(2476,'AE210','Was versteht man unter einem NF-Dynamik-Kompressor?',0,1,0,0,'');
INSERT INTO question VALUES(2477,'AE209','Wie groß sollte der Abstand der Sendefrequenz zwischen zwei SSB-Signalen sein, um gegenseitige Störungen in SSB-Telefonie auf ein Mindestmaß zu begrenzen?',0,1,0,0,'');
INSERT INTO question VALUES(2478,'AE208','Um Bandbreite einzusparen, sollte der Frequenzumfang eines NF-Sprachsignals, das an einen SSB-Modulator angelegt wird, ...',0,1,0,0,'');
INSERT INTO question VALUES(2479,'AE207','Das folgende Oszillogramm zeigt ...<p><img src=''AE207_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2480,'AE206','Welche Baugruppe sollte für die analoge Erzeugung eines unterdrückten Zweiseitenband-Trägersignals verwendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(2481,'AE205','Ein übermoduliertes SSB-Sendesignal führt zu ...',0,1,0,0,'');
INSERT INTO question VALUES(2482,'AE204','Um Seitenband-Splatter zu vermeiden, sollte der Modulationsgrad eines AM-Signals unter ...',0,1,0,0,'');
INSERT INTO question VALUES(2483,'AE203','Welches Bild stellt die Übermodulation eines AM-Signals dar?',0,1,0,0,'');
INSERT INTO question VALUES(2484,'AE202','Das folgende Oszillogramm zeigt ein AM-Signal. Der Modulationsgrad beträgt hier ca.<p><img src=''AE202_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2485,'AE201','In welcher Abbildung ist AM mit einem Modulationsgrad von 100 % dargestellt?',0,1,0,0,'');
INSERT INTO question VALUES(2505,'AE313','Welche Antwort beschreibt die Modulationsart "PM"?',0,1,0,0,'');
INSERT INTO question VALUES(2506,'AE312','Die Bandbreite eines FM-Senders soll 10 kHz nicht überschreiten. Wie hoch darf der Frequenzhub bei einer Modulationsfrequenz von 2,7 kHz maximal sein?',0,1,0,0,'');
INSERT INTO question VALUES(2507,'AE311','Die Bandbreite eines FM-Signals soll 10 kHz nicht überschreiten. Der Hub beträgt 2,5 kHz. Wie groß ist dabei die höchste Modulationsfrequenz?',0,1,0,0,'');
INSERT INTO question VALUES(2508,'AE310','Der typische Spitzenhub eines NBFM-Signals im 12,5 kHz Kanalraster beträgt ...',0,1,0,0,'');
INSERT INTO question VALUES(2509,'AE309','Ein Träger von 145 MHz wird mit der NF-Frequenz von 2 kHz und einem Hub von 1,8 kHz frequenzmoduliert. Welche Bandbreite hat das modulierte Signal ungefähr? Die Bandbreite beträgt ungefähr ...',0,1,0,0,'');
INSERT INTO question VALUES(2510,'AE308','Wie groß ist die Bandbreite eines FM-Signals bei einer Modulationsfrequenz von 2,7 kHz und einem Hub von 2,5 kHz nach der Carson-Formel?',0,1,0,0,'');
INSERT INTO question VALUES(2511,'AE307','Zu starke Ansteuerung des Modulators führt bei Frequenzmodulation zur ...',0,1,0,0,'');
INSERT INTO question VALUES(2512,'AE306','Eine FM-Telefonie-Aussendung mit zu großem Hub führt möglicherweise ...',0,1,0,0,'');
INSERT INTO question VALUES(2513,'AE305','Was bewirkt die Erhöhung des Hubes eines frequenzmodulierten Senders im Empfänger?',0,1,0,0,'');
INSERT INTO question VALUES(2514,'AE304','Eine zu hohe Modulationsfrequenz eines FM-Senders führt dazu, ...',0,1,0,0,'');
INSERT INTO question VALUES(2515,'AE303','Eine Quarzoszillator-Schaltung mit Kapazitätsdiode ermöglicht es ...',0,1,0,0,'');
INSERT INTO question VALUES(2516,'AE302','Welches der nachfolgenden Übertragungsverfahren weist die geringste Störanfälligkeit gegenüber Impulsstörungen durch Funkenbildung in Elektromotoren auf?',0,1,0,0,'');
INSERT INTO question VALUES(2517,'AE301','Wie beeinflusst die Frequenz eines sinusförmigen Modulationssignals den HF-Träger bei Frequenzmodulation?',0,1,0,0,'');
INSERT INTO question VALUES(2534,'AE422','Bei welcher Art von Kanalstörung sind Orthogonale Frequenzmultiplexverfahren (OFDM) mit redundanter Übertragung besonders vorteilhaft?',0,1,0,0,'');
INSERT INTO question VALUES(2535,'AE421','Orthogonale Frequenzmultiplexverfahren (OFDM) mit redundanter Übertragung sind besonders unempfindlich gegen ...',0,1,0,0,'');
INSERT INTO question VALUES(2536,'AE420','Ein Übertragungskanal mit einer Bandbreite von 2,7 kHz wird durch additives weißes Gaußsches Rauschen (AWGN) gestört. Das Signal-Rausch-Verhältnis (SNR) beträgt -20 dB. Welche Bitrate kann nach dem Shannon-Hartley-Gesetz etwa maximal fehlerfrei übertragen werden?',0,1,0,0,'');
INSERT INTO question VALUES(2537,'AE419','Ein Übertragungskanal mit einer Bandbreite von 10 MHz wird durch additives weißes Gaußsches Rauschen (AWGN) gestört. Das Signal-Rausch-Verhältnis (SNR) beträgt 30 dB. Welche Bitrate kann nach dem Shannon-Hartley-Gesetz etwa maximal fehlerfrei übertragen werden?',0,1,0,0,'');
INSERT INTO question VALUES(2538,'AE418','Ein Übertragungskanal mit einer Bandbreite von 10 MHz wird durch additives weißes Gaußsches Rauschen (AWGN) gestört. Das Signal-Rausch-Verhältnis (SNR) beträgt 0 dB. Welche Bitrate kann nach dem Shannon-Hartley-Gesetz etwa maximal fehlerfrei übertragen werden?',0,1,0,0,'');
INSERT INTO question VALUES(2539,'AE417','Ein Übertragungskanal mit einer Bandbreite von 2,7 kHz wird durch additives weißes Gaußsches Rauschen (AWGN) gestört. Das Signal-Rausch-Verhältnis (SNR) beträgt 0 dB. Welche Bitrate kann nach dem Shannon-Hartley-Gesetz etwa maximal fehlerfrei übertragen werden?',0,1,0,0,'');
INSERT INTO question VALUES(2540,'AE416','Welche Aussage trifft auf das Shannon-Hartley-Gesetz zu? Das Gesetz ...',0,1,0,0,'');
INSERT INTO question VALUES(2541,'AE415','Welche Auswirkung hat eine Erhöhung der Umschaltgeschwindigkeit zwischen verschiedenen Symbolen bei digitalen Übertragungsverfahren auf die benötigte Bandbreite? Die Bandbreite ...',0,1,0,0,'');
INSERT INTO question VALUES(2542,'AE414','Was ist die Voraussetzung für Vorwärtsfehlerkorrektur (FEC)?',0,1,0,0,'');
INSERT INTO question VALUES(2543,'AE413','Sie verwenden ein Datenübertragungsverfahren <u>ohne</u> Vorwärtsfehlerkorrektur. Wodurch können Datenpakete trotz Prüfsummenfehlern korrigiert werden?',0,1,0,0,'');
INSERT INTO question VALUES(2544,'AE412','Eine digitale Übertragung wird durch ein einzelnes Prüfbit (Parity Bit) abgesichert. Der Empfänger stellt bei der Paritätsprüfung <u>keinen</u> Übertragungsfehler fest. Was sagt dies über die Fehlerfreiheit der übertragenen Nutzdaten und des Prüfbits aus?',0,1,0,0,'');
INSERT INTO question VALUES(2545,'AE411','Eine digitale Übertragung wird durch ein einzelnes Prüfbit (Parity Bit) abgesichert. Der Empfänger stellt bei der Paritätsprüfung einen Übertragungsfehler fest. Wie viele Bits einschließlich des Prüfbits wurden fehlerhaft übertragen?',0,1,0,0,'');
INSERT INTO question VALUES(2546,'AE410','Was wird unter zyklischer Redundanzprüfung (CRC) verstanden?',0,1,0,0,'');
INSERT INTO question VALUES(2547,'AE409','Was wird unter Kanalcodierung verstanden?',0,1,0,0,'');
INSERT INTO question VALUES(2548,'AE408','Wodurch kann die Datenmenge einer zu übertragenden Nachricht reduziert werden?',0,1,0,0,'');
INSERT INTO question VALUES(2549,'AE407','Was versteht man bei der Übertragung von Daten unter Synchronisation?',0,1,0,0,'');
INSERT INTO question VALUES(2550,'AE406','Bei einem digitalen Übertragungsverfahren (z. B. FT4) wird die Frequenz eines Senders zwischen vier Symbolfrequenzen (z. B. 14081,20 kHz, 14081,40 kHz, 14081,61 kHz und 14081,83 kHz) umgetastet, so dass pro Symbol zwei Bit (00, 01, 10 oder 11) übertragen werden können. Die Symbolrate beträgt 23,4 baud. Welcher Datenrate entspricht das?',0,1,0,0,'');
INSERT INTO question VALUES(2551,'AE405','Bei einem digitalen Übertragungsverfahren (z. B. RTTY) wird die Frequenz eines Senders zwischen zwei Symbolfrequenzen (z. B. 14072,43 kHz und 14072,60 kHz) umgetastet, so dass pro Symbol ein Bit (0 oder 1) übertragen werden kann. Die Symbolrate beträgt 45,45 baud. Welcher Datenrate entspricht das?',0,1,0,0,'');
INSERT INTO question VALUES(2552,'AE404','Wie wird Quadraturamplitudenmodulation (QAM) üblicherweise erzeugt? Durch ...',0,1,0,0,'');
INSERT INTO question VALUES(2553,'AE403','Wie werden Informationen bei der Quadraturamplitudenmodulation (QAM) mittels eines Trägers übertragen? Durch ...',0,1,0,0,'');
INSERT INTO question VALUES(2554,'AE402','Was unterscheidet BPSK- und QPSK-Modulation?',0,1,0,0,'');
INSERT INTO question VALUES(2555,'AE401','Welches der folgenden Diagramme zeigt einen erkennbar durch Phasenumtastung (PSK) modulierten Träger?',0,1,0,0,'');
INSERT INTO question VALUES(2594,'AF120','Welche Frequenzen können die drei Oszillatoren des im folgenden Blockschaltbild gezeichneten Empfängers haben, wenn eine Frequenz von 3,65 MHz empfangen wird? Bei welcher Antwort sind alle drei Frequenzen richtig?<p><img src=''AF120_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2595,'AF119','Ein Doppelsuper hat eine erste ZF von 10,7 MHz und eine zweite ZF von 460 kHz. Die Empfangsfrequenz soll 28 MHz sein. Welche Frequenzen sind für den VFO und den CO erforderlich, wenn die Oszillatoren oberhalb der Mischer-Eingangssignale schwingen sollen?<p><img src=''AF119_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2596,'AF118','Ein Doppelsuper hat eine erste ZF von 9 MHz und eine zweite ZF von 460 kHz. Die Empfangsfrequenz soll 21,1 MHz sein. Welche Frequenzen sind für den VFO und den CO erforderlich, wenn der VFO oberhalb und der CO unterhalb des jeweiligen Mischer-Eingangssignals schwingen sollen?<p><img src=''AF118_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2597,'AF117','Folgende Schaltung stellt einen Doppelsuper dar. Welche Funktion haben die drei mit X, Y und Z gekennzeichneten Blöcke?<p><img src=''AF117_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2598,'AF116','Wie groß sollte die Bandbreite des Filters für die 1. ZF in einem Doppelsuper sein?',0,1,0,0,'');
INSERT INTO question VALUES(2599,'AF115','Wodurch wird die Nahselektion eines Superhet-Empfängers bestimmt?',0,1,0,0,'');
INSERT INTO question VALUES(2600,'AF114','Welche Beziehungen der Zwischenfrequenzen zueinander sind für einen Kurzwellen-Doppelsuper vorteilhaft?',0,1,0,0,'');
INSERT INTO question VALUES(2601,'AF113','Welche Aussage ist für einen Doppelsuper richtig?',0,1,0,0,'');
INSERT INTO question VALUES(2602,'AF112','Welche Aussage ist für einen Doppelsuper richtig?',0,1,0,0,'');
INSERT INTO question VALUES(2603,'AF111','Welchen Vorteil bietet eine hohe erste Zwischenfrequenz bei Überlagerungsempfängern?',0,1,0,0,'');
INSERT INTO question VALUES(2604,'AF110','Wodurch wird beim Überlagerungsempfänger mit einer ZF die Spiegelfrequenzunterdrückung hauptsächlich bestimmt?',0,1,0,0,'');
INSERT INTO question VALUES(2605,'AF109','Welchen Vorteil haben Kurzwellenempfänger mit einer sehr hohen ersten ZF-Frequenz (z. B. 50 MHz)?',0,1,0,0,'');
INSERT INTO question VALUES(2606,'AF108','Ein Einfachsuper hat eine ZF von 10,7 MHz und ist auf 28,5 MHz abgestimmt. Der Oszillator des Empfängers schwingt oberhalb der Empfangsfrequenz. Welche Frequenz hat die Spiegelfrequenz?<p><img src=''AF108_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2607,'AF107','Ein Einfachsuperhet-Empfänger ist auf 14,24 MHz eingestellt. Der Lokaloszillator schwingt mit 24,94 MHz und liegt mit dieser Frequenz über der ZF. Wo können Spiegelfrequenzstörungen auftreten?<p><img src=''AF107_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2608,'AF106','Welche Frequenzdifferenz besteht bei einem Einfachsuper immer zwischen der Empfangsfrequenz und der Spiegelfrequenz?',0,1,0,0,'');
INSERT INTO question VALUES(2609,'AF105','Durch "Fading" sinkt die S-Meter-Anzeige von S9 auf S8. Auf welchen Wert sinkt dabei die Empfänger-Eingangsspannung ab, wenn bei S9 am Empfängereingang 50 μV anliegen? Die Empfänger-Eingangsspannung sinkt auf',0,1,0,0,'');
INSERT INTO question VALUES(2610,'AF104','Ein Funkamateur kommt laut S-Meter mit S7 an. Dann schaltet dieser seine Endstufe ein und bittet um einen erneuten Rapport. Das S-Meter zeigt nun S9+8 dB an. Um welchen Faktor hat der Funkamateur seine Leistung erhöht?',0,1,0,0,'');
INSERT INTO question VALUES(2611,'AF103','Ein Funkamateur erhöht seine Sendeleistung von 10 auf 100 W. Vor der Leistungserhöhung zeigte Ihr S-Meter genau S8. Auf welchen Wert müsste die Anzeige Ihres S-Meters nach der Leistungserhöhung ansteigen?',0,1,0,0,'');
INSERT INTO question VALUES(2612,'AF102','Um wie viel S-Stufen müsste die S-Meter-Anzeige Ihres Empfängers steigen, wenn Ihr Funkpartner die Sendeleistung von 100 W auf 400 W erhöht?',0,1,0,0,'');
INSERT INTO question VALUES(2613,'AF101','Um wie viele S-Stufen müsste die S-Meter-Anzeige Ihres Empfängers steigen, wenn Ihr Partner die Sendeleistung von 25 W auf 100 W erhöht?',0,1,0,0,'');
INSERT INTO question VALUES(2617,'AF231','Der LNB einer Satellitenempfangsanlage kann mit zwei unterschiedlichen Betriebsspannungen arbeiten. Was passiert, wenn die Versorgungsspannung am Bias-T im dargestellten Blockschaltbild auf 18 V erhöht wird?<p><img src=''AF231_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2618,'AF230','Sie empfangen das Signal eines Satelliten auf 10 GHz. Die Kabellänge zwischen LNB und Empfänger beträgt 20 m. Warum ist die Kabeldämpfung trotz der hohen Empfangsfrequenz eher vernachlässigbar? <p><img src=''AF230_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2619,'AF229','Was bedeutet die Rauschzahl F = 2 bei einem UHF-Vorverstärker?',0,1,0,0,'');
INSERT INTO question VALUES(2620,'AF228','Was bedeutet die Rauschzahl von 1,8 dB bei einem UHF-Vorverstärker?',0,1,0,0,'');
INSERT INTO question VALUES(2621,'AF227','Was bedeutet Signal-Rausch-Abstand (SNR) bei einem Empfänger?',0,1,0,0,'');
INSERT INTO question VALUES(2622,'AF226','Welche Aufgabe hat der Begrenzerverstärker in einem FM-Empfänger?',0,1,0,0,'');
INSERT INTO question VALUES(2623,'AF225','Welche Signale steuern gewöhnlich die Empfängerstummschaltung (Squelch)?',0,1,0,0,'');
INSERT INTO question VALUES(2624,'AF224','Was bewirkt die AGC (Automatic Gain Control) bei einem starken Eingangssignal?',0,1,0,0,'');
INSERT INTO question VALUES(2625,'AF223','Welche Konfiguration wäre für die Unterdrückung eines unerwünschten Störsignals am Eingang eines Empfängers hilfreich?',0,1,0,0,'');
INSERT INTO question VALUES(2626,'AF222','Wodurch kann die Qualität eines empfangenen Signals beispielsweise verringert werden?  ',0,1,0,0,'');
INSERT INTO question VALUES(2627,'AF221','Welche Empfängereigenschaft beurteilt man mit dem Interception Point IP<img src=''texrender_question_2627_AF221_0.svg''>?',0,1,0,0,'');
INSERT INTO question VALUES(2628,'AF220','Wodurch erreicht man eine Verringerung von Intermodulation und Kreuzmodulation beim Empfang?',0,1,0,0,'');
INSERT INTO question VALUES(2629,'AF219','Wodurch wird Kreuzmodulation verursacht?',0,1,0,0,'');
INSERT INTO question VALUES(2630,'AF218','Was ist die Hauptursache für Intermodulationsprodukte in einem Empfänger?',0,1,0,0,'');
INSERT INTO question VALUES(2631,'AF217','Welches Phänomen tritt bei einem gleichzeitigen Empfang zweier Signale an einer nicht linear arbeitenden Empfängerstufe auf?',0,1,0,0,'');
INSERT INTO question VALUES(2632,'AF216','Für die Demodulation von SSB-Signalen im Kurzwellenbereich wird ein Hilfsträgeroszillator verwendet. Welcher der folgenden Oszillatoren ist hierfür am besten geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(2633,'AF215','Wie sollte ein bereits temperaturkompensierter VFO innerhalb eines Gerätes verbaut werden, um eine möglichst optimale Frequenzstabilität zu gewährleisten?',0,1,0,0,'');
INSERT INTO question VALUES(2634,'AF214','Welche Mischerschaltung unterdrückt am wirksamsten unerwünschte Mischprodukte und Frequenzen?',0,1,0,0,'');
INSERT INTO question VALUES(2635,'AF213','Durch welchen Mischer werden unerwünschte Ausgangssignale am stärksten unterdrückt?',0,1,0,0,'');
INSERT INTO question VALUES(2636,'AF212','In welchem Bereich der Steuerkennlinie arbeitet die Mischstufe eines Überlagerungsempfängers? ',0,1,0,0,'');
INSERT INTO question VALUES(2637,'AF211','Wie groß sollte die Differenz zwischen der BFO-Frequenz und der letzten ZF für den Empfang von CW-Signalen ungefähr sein?',0,1,0,0,'');
INSERT INTO question VALUES(2638,'AF210','Welchen Frequenzbereich kann der VFO des im folgenden Blockschaltbild gezeichneten HF-Teils eines Empfängers haben?<p><img src=''AF210_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2639,'AF209','Folgende Schaltung stellt einen Doppelsuper dar. Welche Funktion haben die drei mit X, Y und Z gekennzeichneten Blöcke?<p><img src=''AF209_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2640,'AF208','Welches der folgenden Bandpassfilter verfügt bei jeweils gleicher Mittenfrequenz am ehesten über die geringste Bandbreite und höchste Flankensteilheit?',0,1,0,0,'');
INSERT INTO question VALUES(2641,'AF207','Für welche Signale ist die untenstehende Durchlasskurve eines Empfängerfilters geeignet?<p><img src=''AF207_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2642,'AF206','Welche ungefähren Werte sollte die Bandbreite der ZF-Verstärker eines Amateurfunkempfängers für folgende Übertragungsverfahren aufweisen: SSB-Sprechfunk, RTTY (Shift 170 Hz), FM-Sprechfunk?',0,1,0,0,'');
INSERT INTO question VALUES(2643,'AF205','Welche Baugruppe eines Empfängers bestimmt die Trennschärfe?',0,1,0,0,'');
INSERT INTO question VALUES(2644,'AF204','Wodurch wird beim Überlagerungsempfänger die Spiegelfrequenzdämpfung bestimmt?',0,1,0,0,'');
INSERT INTO question VALUES(2645,'AF203','Der Quarzoszillator schwingt auf 39 MHz. Die Empfangsfrequenz soll 28,3 MHz betragen. Auf welcher Frequenz ist mit Spiegelfrequenzstörungen zu rechnen?',0,1,0,0,'');
INSERT INTO question VALUES(2646,'AF202','Der VCO schwingt auf 134,9 MHz. Die Empfangsfrequenz soll 145,6 MHz betragen. Welche Spiegelfrequenz kann Störungen beim Empfang verursachen?<p><img src=''AF202_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2647,'AF201','Welche Differenz liegt zwischen der HF-Nutzfrequenz und der Spiegelfrequenz?<p><img src=''AF201_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2670,'AF314','Ein quarzgesteuertes Funkgerät mit einer Ausgangsfrequenz von 432 MHz verursacht Störungen bei 144 MHz. Der Quarzoszillator des Funkgeräts schwingt auf einer Grundfrequenz bei 12 MHz.  Bei welcher Vervielfachungskombination kann die Störfrequenz von 144 MHz auftreten?  ',0,1,0,0,'');
INSERT INTO question VALUES(2671,'AF313','Wie sollten Frequenzvervielfacher in einer Sendeeinrichtung aufgebaut und betrieben werden?',0,1,0,0,'');
INSERT INTO question VALUES(2672,'AF312','Worum handelt es sich bei dieser Schaltung?<p><img src=''AF312_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2673,'AF311','Nach welchem Prinzip arbeitet die analoge Frequenzvervielfachung?',0,1,0,0,'');
INSERT INTO question VALUES(2674,'AF310','Dieser Schaltungsauszug ist Teil eines Senders. Welche Funktion hat die Diode?<p><img src=''AF310_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2675,'AF309','Wozu dienen <img src=''texrender_question_2675_AF309_0.svg''> und <img src=''texrender_question_2675_AF309_1.svg''> bei dieser Schaltung?  <p><img src=''AF309_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2676,'AF308','Bei dieser Schaltung handelt es sich um einen Modulator zur Erzeugung von ...<p><img src=''AF308_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2677,'AF307','Die folgende Blockschaltung zeigt eine SSB-Aufbereitung mit einem 9 MHz-Quarzfilter. Welche Frequenz wird in der Schalterstellung USB mit der NF gemischt?<p><img src=''AF307_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2678,'AF306','Welches Schaltungsteil ist in der folgenden Blockschaltung am Ausgang des NF-Verstärkers angeschlossen?<p><img src=''AF306_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2679,'AF305','Dieses Blockschaltbild zeigt einen SSB-Sender. Die Stufe bei \glqq?" ist ein...<p><img src=''AF305_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2680,'AF304','Bei üblichen analogen Methoden zur Aufbereitung eines SSB-Signals werden ...',0,1,0,0,'');
INSERT INTO question VALUES(2681,'AF303','Wie kann mit analoger Technologie ein SSB-Signal erzeugt werden?',0,1,0,0,'');
INSERT INTO question VALUES(2682,'AF302','Welcher Mischertyp ist am besten geeignet, um ein Doppelseitenbandsignal mit unterdrücktem Träger zu erzeugen?',0,1,0,0,'');
INSERT INTO question VALUES(2683,'AF301','Mit welchen der folgenden Baugruppen kann aus einem 5,3 MHz-Signal ein 14,3 MHz-Signal erzeugt werden?',0,1,0,0,'');
INSERT INTO question VALUES(2698,'AF428','Wie groß ist die Gesamtverstärkung des gesamten Sendezweigs ohne Berücksichtigung möglicher Kabelverluste?<p><img src=''AF428_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2699,'AF427','Wieviel Wärmeleistung wird im MMIC in Wärme umgesetzt, wenn die Betriebsspannung 9 V beträgt und <img src=''texrender_question_2699_AF427_0.svg''> einen Wert von 470 Ohm hat?<p><img src=''AF427_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2700,'AF426','Berechnen Sie <img src=''texrender_question_2700_AF426_0.svg''> für die dargestellte MMIC-Schaltung und wählen Sie den nächsten Normwert. <img src=''texrender_question_2700_AF426_1.svg''> = 13,8 V; <img src=''texrender_question_2700_AF426_2.svg''> = 4 V; <img src=''texrender_question_2700_AF426_3.svg''> = 15 mA<p><img src=''AF426_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2701,'AF425','Der optimale Arbeitspunkt des dargestellten MMIC ist mit 4 V und 10 mA angegeben. Die Betriebsspannung beträgt 13,5 V. Berechnen Sie den Vorwiderstand (<img src=''texrender_question_2701_AF425_0.svg''>).<p><img src=''AF425_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2702,'AF424','Wie verändern sich die Drainströme in den beiden Endstufen-Transistoren, wenn der Schleifer von <img src=''texrender_question_2702_AF424_0.svg''> in Richtung <img src=''texrender_question_2702_AF424_1.svg''> verstellt wird?<p><img src=''AF424_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2703,'AF423','Der Ruhestrom in der dargestellten VHF-LDMOS-PA soll erhöht werden. Welche Einstellungen sind vorzunehmen?<p><img src=''AF423_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2704,'AF422','Wozu dienen die mit X gekennzeichneten Spulen in der Schaltung?<p><img src=''AF422_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2705,'AF421','Wie groß ist die Gate-Source-Spannung, wenn sich der Schleifer von <img src=''texrender_question_2705_AF421_0.svg''> am Anschlag 1 befindet?<p><img src=''AF421_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2706,'AF420','Die Arbeitspunkteinstellung der LDMOS-Kurzwellen-PA erfolgt mit <img src=''texrender_question_2706_AF420_0.svg''>. Wie verändert sich der Drainstrom, wenn <img src=''texrender_question_2706_AF420_1.svg''> in Richtung 3 verstellt wird?<p><img src=''AF420_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2707,'AF419','Zu welchem Zweck dient die Schaltung der Spule, <img src=''texrender_question_2707_AF419_0.svg''> und <img src=''texrender_question_2707_AF419_1.svg''>?<p><img src=''AF419_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2708,'AF418','Welche Funktion trifft für die Spule, <img src=''texrender_question_2708_AF418_0.svg''> und <img src=''texrender_question_2708_AF418_1.svg''> in der Schaltung zu?<p><img src=''AF418_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2709,'AF417','Zu welchem Zweck dienen <img src=''texrender_question_2709_AF417_0.svg''> und <img src=''texrender_question_2709_AF417_1.svg''> in diesem HF-Leistungsverstärker?<p><img src=''AF417_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2710,'AF416','Wozu dient der Widerstand <img src=''texrender_question_2710_AF416_0.svg''> parallel zur Trafowicklung <img src=''texrender_question_2710_AF416_1.svg''>?<p><img src=''AF416_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2711,'AF415','Weshalb wurden jeweils <img src=''texrender_question_2711_AF415_0.svg''> und <img src=''texrender_question_2711_AF415_1.svg''>, <img src=''texrender_question_2711_AF415_2.svg''> und <img src=''texrender_question_2711_AF415_3.svg''> sowie <img src=''texrender_question_2711_AF415_4.svg''> und <img src=''texrender_question_2711_AF415_5.svg''> parallel geschaltet?<p><img src=''AF415_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2712,'AF414','Wozu dient der Transformator <img src=''texrender_question_2712_AF414_0.svg''> der folgenden Schaltung?<p><img src=''AF414_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2713,'AF413','Worum handelt es sich bei dieser Schaltung? Es handelt sich um einen...<p><img src=''AF413_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2714,'AF412','Welche Art von Schaltung wird im folgenden Bild dargestellt? Es handelt sich um einen ...<p><img src=''AF412_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2715,'AF411','Welchem Zweck dient X in der folgenden Schaltung?<p><img src=''AF411_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2716,'AF410','Welchem Zweck dienen <img src=''texrender_question_2716_AF410_0.svg''> und <img src=''texrender_question_2716_AF410_1.svg''> in der folgenden Schaltung? Sie dienen zur...<p><img src=''AF410_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2717,'AF409','Welchem Zweck dient die Anzapfung an X in der folgenden Schaltung?<p><img src=''AF409_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2718,'AF408','Worum handelt es sich bei dieser Schaltung?<p><img src=''AF408_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2719,'AF407','Welche Funktion haben die mit X gekennzeichneten Bauteile in der folgenden Schaltung?<p><img src=''AF407_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2720,'AF406','Welche Funktion haben die mit X gekennzeichneten Bauteile in der folgenden Schaltung? Sie  ...<p><img src=''AF406_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2721,'AF405','Welche Funktion hat das Ausgangs-Pi-Filter eines HF-Senders?',0,1,0,0,'');
INSERT INTO question VALUES(2722,'AF404','Wozu dienen LC-Schaltungen unmittelbar hinter einem HF-Leistungsverstärker? Sie dienen zur...',0,1,0,0,'');
INSERT INTO question VALUES(2723,'AF403','Welche Maßnahmen sind für Ausgangsanpassschaltung und Ausgangsfilter eines HF-Verstärkers im C-Betrieb vorzunehmen? Beide müssen...',0,1,0,0,'');
INSERT INTO question VALUES(2724,'AF402','Welcher Arbeitspunkt der Leistungsverstärkerstufe eines Senders erzeugt grundsätzlich den größten Oberschwingungsanteil?',0,1,0,0,'');
INSERT INTO question VALUES(2725,'AF401','Wie ist der Wirkungsgrad eines HF-Verstärkers definiert?',0,1,0,0,'');
INSERT INTO question VALUES(2731,'AF502','Zwischen welchen Frequenzen muss der Quarzoszillator umschaltbar sein, damit im 70 cm-Bereich die unteren 4 MHz durch diesen Konverter empfangen werden können? Die Oszillatorfrequenz <img src=''texrender_question_2731_AF502_0.svg''> soll jeweils unterhalb des Nutzsignals liegen.<p><img src=''AF502_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2732,'AF501','Zwischen welchen Frequenzen muss der Quarzoszillator umschaltbar sein, damit im 70 cm-Bereich die oberen 4 MHz durch diesen Konverter empfangen werden können? Die Oszillatorfrequenz <img src=''texrender_question_2732_AF501_0.svg''> soll jeweils unterhalb des Nutzsignals liegen.<p><img src=''AF501_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2738,'AF637','Was wird in der digitalen Signalverarbeitung unter Latenz verstanden und in welcher Einheit kann sie angegeben werden?',0,1,0,0,'');
INSERT INTO question VALUES(2739,'AF636','Welchen Frequenzbereich (z. B. in Bezug auf eine Mitten- oder Trägerfrequenz) kann ein digitaler Datenstrom entsprechend dem Abtasttheorem maximal eindeutig abbilden, der aus einem I- und einem Q-Anteil mit einer Abtastrate von <u>jeweils</u> 10 Millionen Samples pro Sekunde besteht? Den Bereich zwischen ...',0,1,0,0,'');
INSERT INTO question VALUES(2740,'AF635','Welchen Frequenzbereich (z. B. in Bezug auf eine Mitten- oder Trägerfrequenz) kann ein digitaler Datenstrom entsprechend dem Abtasttheorem maximal eindeutig abbilden, der aus einem I- und einem Q-Anteil mit einer Abtastrate von <u>jeweils</u> 96000 Samples pro Sekunde besteht? Den Bereich zwischen ...',0,1,0,0,'');
INSERT INTO question VALUES(2741,'AF634','Welchen Frequenzbereich (z. B. in Bezug auf eine Mitten- oder Trägerfrequenz) kann ein digitaler Datenstrom entsprechend dem Abtasttheorem maximal eindeutig abbilden, der aus einem I- und einem Q-Anteil mit einer Abtastrate von <u>jeweils</u> 48000 Samples pro Sekunde besteht? Den Bereich zwischen ...',0,1,0,0,'');
INSERT INTO question VALUES(2742,'AF633','Was bildet der I- bzw. der Q-Anteil eines I/Q-Signals ab?',0,1,0,0,'');
INSERT INTO question VALUES(2743,'AF632','Wie groß muss die Phasenverschiebung <img src=''texrender_question_2743_AF632_0.svg''> in der dargestellten Modulatorschaltung sein, damit eine korrekte Quadraturmodulation vorliegt?<p><img src=''AF632_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2744,'AF631','Welche der folgenden Aussagen zu digitalen Filtern ist richtig? Digitale Filter können ...',0,1,0,0,'');
INSERT INTO question VALUES(2745,'AF630','Wozu dient die diskrete Fouriertransformation mittels FFT? Es ist eine schnelle mathematische Methode zur Umwandlung ...',0,1,0,0,'');
INSERT INTO question VALUES(2746,'AF629','Welcher der nachfolgenden Blöcke vervollständigt den dargestellten, stark vereinfachten Empfangszweig für digitales Amateurfunkfernsehen (DATV) korrekt?<p><img src=''AF629_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2747,'AF628','Welcher der nachfolgenden Blöcke vervollständigt den dargestellten, stark vereinfachten Empfangszweig eines Funkgeräts für digitalen Sprechfunk korrekt?<p><img src=''AF628_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2748,'AF627','Welcher der nachfolgenden Blöcke vervollständigt den dargestellten, stark vereinfachten Sendezweig für digitales Amateurfunkfernsehen (DATV) korrekt?<p><img src=''AF627_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2749,'AF626','Welcher der nachfolgenden Blöcke vervollständigt den dargestellten, stark vereinfachten Sendezweig eines Funkgeräts für digitalen Sprechfunk korrekt?<p><img src=''AF626_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2750,'AF625','Sie wollen ein Sprachsignal mit einer Abtastrate von <img src=''texrender_question_2750_AF625_0.svg''> = 8000 Samples je Sekunde rekonstruieren. Nach dem D/A-Umsetzer soll ein Rekonstruktionsfilter eingesetzt werden. Welcher Amplitudengang ist für das Filter am besten geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(2751,'AF624','Welcher Filtertyp ist als Rekonstruktionsfilter geeignet und wo ist das Filter zu platzieren?',0,1,0,0,'');
INSERT INTO question VALUES(2752,'AF623','Sie wollen ein Sprachsignal mit einer Abtastrate von <img src=''texrender_question_2752_AF623_0.svg''> = 8000 Samples je Sekunde digitalisieren. Vor dem A/D-Umsetzer soll ein Anti-Alias-Filter eingesetzt werden. Welcher Amplitudengang ist für das Filter am besten geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(2753,'AF622','Welcher Filtertyp ist geeignet, um Alias-Effekte zu vermeiden, und wo ist das Filter zu platzieren?',0,1,0,0,'');
INSERT INTO question VALUES(2754,'AF621','Bei einer Abtastung mit einem A/D-Umsetzer mit 24 Bit Auflösung wird ein Oszillator mit starkem Taktzittern (Jitter) eingesetzt. Welche Auswirkung wird das Zittern haben?',0,1,0,0,'');
INSERT INTO question VALUES(2755,'AF620','Welche Funktionen haben die einzelnen Blöcke im dargestellten Blockschaltbild eines digitalen Direktempfängers?<p><img src=''AF620_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2756,'AF619','Ein analoges Sprachsignal mit 4 kHz Bandbreite soll digital verarbeitet werden. Welche der folgenden Abtastraten ist die kleinste, die Alias-Effekte vermeidet?',0,1,0,0,'');
INSERT INTO question VALUES(2757,'AF618','Ein analoges Signal mit einer Bandbreite von <img src=''texrender_question_2757_AF618_0.svg''> soll digital verarbeitet werden. Welche der folgenden Abtastraten ist die kleinste, die Alias-Effekte vermeidet?',0,1,0,0,'');
INSERT INTO question VALUES(2758,'AF617','Unter dem Alias-Effekt werden Fehler verstanden, die ...',0,1,0,0,'');
INSERT INTO question VALUES(2759,'AF616','Welche Aussage trifft auf das Abtasttheorem zu? Das Theorem ...',0,1,0,0,'');
INSERT INTO question VALUES(2760,'AF615','Wie ist die Abtastrate (Samplingrate) eines A/D-Umsetzers definiert?',0,1,0,0,'');
INSERT INTO question VALUES(2761,'AF614','Eine Sinusschwingung mit einem Spitzenwert von 1,5 V wird in einen A/D-Umsetzer eingegeben, dessen Ausgang direkt mit einem D/A-Umsetzer verbunden ist. Beide Umsetzer arbeiten linear mit einer Auflösung von 12 Bit und einem Wertebereich von -1 V bis 1 V. Welches Signal ist am Ausgang des D/A-Umsetzers zu erwarten?',0,1,0,0,'');
INSERT INTO question VALUES(2762,'AF613','Eine Sinusschwingung mit einem Spitzenwert von 1,5 V wird in einen A/D-Umsetzer eingegeben, dessen Ausgang direkt mit einem D/A-Umsetzer verbunden ist. Beide Umsetzer arbeiten linear mit einer Auflösung von 12 Bit und einem Wertebereich von -2 V bis 2 V. Welches Signal ist am Ausgang des D/A-Umsetzers zu erwarten?',0,1,0,0,'');
INSERT INTO question VALUES(2763,'AF612','Eine Sinusschwingung mit einem Spitzenwert von 1,5 V wird in einen A/D-Umsetzer eingegeben, dessen Ausgang direkt mit einem D/A-Umsetzer verbunden ist. Beide Umsetzer arbeiten linear mit einer Auflösung von 4 Bit und einem Wertebereich von -2 V bis 2 V. Welches Signal ist am Ausgang des D/A-Umsetzers zu erwarten?',0,1,0,0,'');
INSERT INTO question VALUES(2764,'AF611','Wie groß ist die Schrittweite zwischen den Spannungsstufen eines linear arbeitenden D/A-Umsetzers mit 10 Bit Auflösung und einem Wertebereich von 0 bis 1 V?',0,1,0,0,'');
INSERT INTO question VALUES(2765,'AF610','Wie groß ist die Schrittweite zwischen den Spannungsstufen eines linear arbeitenden D/A-Umsetzers mit 8 Bit Auflösung und einem Wertebereich von 0 bis 1 V?',0,1,0,0,'');
INSERT INTO question VALUES(2766,'AF609','Wie viele verschiedene Ausgangswerte, z. B. Spannungen, kann ein idealer D/A-Umsetzer mit 10 Bit Auflösung erzeugen?',0,1,0,0,'');
INSERT INTO question VALUES(2767,'AF608','Wie viele Bereiche von Eingangswerten, z. B. Spannungen, kann ein A/D-Umsetzer mit 8 Bit Auflösung maximal trennen?',0,1,0,0,'');
INSERT INTO question VALUES(2768,'AF607','Warum kommt es in einem A/D-Umsetzer zu Quantisierungsfehlern?',0,1,0,0,'');
INSERT INTO question VALUES(2769,'AF606','Wie wird die Umwandlung eines zeitkontinuierlichen in ein zeitdiskretes Signal bezeichnet?',0,1,0,0,'');
INSERT INTO question VALUES(2770,'AF605','Wie wird die Umwandlung eines wertkontinuierlichen in ein wertdiskretes Signal bezeichnet?',0,1,0,0,'');
INSERT INTO question VALUES(2771,'AF604','Welche der folgenden Abbildungen symbolisiert ein zeitdiskretes und wertdiskretes Signal am besten?',0,1,0,0,'');
INSERT INTO question VALUES(2772,'AF603','Welche der folgenden Abbildungen symbolisiert ein zeitdiskretes und wertkontinuierliches Signal am besten?',0,1,0,0,'');
INSERT INTO question VALUES(2773,'AF602','Welche der folgenden Abbildungen symbolisiert ein zeitkontinuierliches und wertdiskretes Signal am besten?',0,1,0,0,'');
INSERT INTO question VALUES(2774,'AF601','Welche der folgenden Abbildungen symbolisiert ein zeitkontinuierliches und wertkontinuierliches Signal am besten?',0,1,0,0,'');
INSERT INTO question VALUES(2778,'AF710','Was bedeutet Latenz im Zusammenhang mit Remote-Betrieb?',0,1,0,0,'');
INSERT INTO question VALUES(2779,'AF709','Welche technische Besonderheit bei der Nutzung einer Remote-Station wirkt sich auf den Funkbetrieb aus?',0,1,0,0,'');
INSERT INTO question VALUES(2780,'AF708','Wodurch kann bei Remote-Betrieb verhindert werden, dass der Sender trotz Ausfall der Verbindung zwischen Operator und Remote-Station dauerhaft auf Sendung bleibt?',0,1,0,0,'');
INSERT INTO question VALUES(2781,'AF707','Sie führen FM-Sprechfunk über Ihre Remote-Station durch. Aufgrund einer Fehlfunktion des Transceivers reagiert dieser nicht mehr auf Steuersignale. Wie können Sie die Sendung sofort beenden?',0,1,0,0,'');
INSERT INTO question VALUES(2782,'AF706','Sie nutzen Ihre weit entfernte Remote-Station. Es kommt zu problematischer Einstrahlung oder Einströmung durch ihre eigene Aussendung. Was kann dadurch beeinträchtigt werden?',0,1,0,0,'');
INSERT INTO question VALUES(2783,'AF705','Sie führen Telefonie im Remote-Betrieb mit dem dargestellten Aufbau durch. Welche Komponente erzeugt den auszusendenden Hochfrequenzträger?<p><img src=''AF705_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2784,'AF704','Sie führen Telefonie im Remote-Betrieb mit dem dargestellten Aufbau durch. Welche Komponente wandelt Datenpakete aus dem Netzwerk in Audio- und Steuersignale für die Aussendung um?<p><img src=''AF704_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2785,'AF703','Sie führen Telefonie im Remote-Betrieb mit dem dargestellten Aufbau durch. Welche Komponente wandelt Audio- und Steuersignale des Operators in Datenpakete für die Übertragung im Netzwerk um?<p><img src=''AF703_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2786,'AF702','Sie wollen Remote-Betrieb mit dem im Blockdiagramm dargestellten Aufbau durchführen. Welche Geräte könnten Sie als Block 2 verwenden?<p><img src=''AF702_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2787,'AF701','Sie wollen Remote-Betrieb mit dem im Blockdiagramm dargestellten Aufbau durchführen. Welche Geräte könnten Sie als Block 1 verwenden?<p><img src=''AF701_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2788,'AG127','Welchen Vorteil bietet im Mikrowellenbereich ein Offsetspiegel gegenüber einem rotationssymmetrischen Parabolspiegel?',0,1,0,0,'');
INSERT INTO question VALUES(2789,'AG126','Für die Erzeugung von zirkularer Polarisation mit Yagi-Uda-Antennen wird eine horizontale und eine dazu um 90 ° um die Strahlungsachse gedrehte Yagi-Uda-Antenne zusammengeschaltet. Was ist dabei zu beachten, damit tatsächlich zirkulare Polarisation entsteht?',0,1,0,0,'');
INSERT INTO question VALUES(2790,'AG125','Welche Antennen sind für NVIS-Ausbreitung (Near Vertical Incident Skywave), wie sie für Notfunk-Verbindungen im KW-Bereich benutzt werden, gut geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(2791,'AG124','Wie wird die in der nachfolgenden Skizze dargestellte Antenne bezeichnet (MWS = Mantelwellensperre)? Es handelt sich um eine ...<p><img src=''AG124_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2792,'AG123','Wie wird die dargestellte Antenne bezeichnet (MWS = Mantelwellensperre)?<p><img src=''AG123_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2793,'AG122','Wie wird die folgende Antenne in der Amateurfunkliteratur bezeichnet?  <p><img src=''AG122_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2794,'AG121','Wie wird die folgende Antenne in der Amateurfunkliteratur bezeichnet?  <p><img src=''AG121_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2795,'AG120','Wie wird die folgende Antenne in der Amateurfunkliteratur bezeichnet?  <p><img src=''AG120_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2796,'AG119','Bei einer Quad-Antenne beträgt die elektrische Länge jeder Seite ...',0,1,0,0,'');
INSERT INTO question VALUES(2797,'AG118','Eine Delta-Loop-Antenne mit einer vollen Wellenlänge soll für 7,1 MHz aus Draht hergestellt werden. Es soll mit einem Korrekturfaktor von 1,02 gerechnet werden. Wie lang muss der Draht insgesamt sein?',0,1,0,0,'');
INSERT INTO question VALUES(2798,'AG117','Wie wird die folgende Antenne in der Amateurfunkliteratur üblicherweise bezeichnet?<p><img src=''AG117_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2799,'AG116','Sie wollen eine Zweibandantenne für 160 m und 80 m selbst bauen. Welche der folgenden Antworten enthält die richtige Drahtlänge <img src=''texrender_question_2799_AG116_0.svg''> zwischen den Traps und die richtige Resonanzfrequenz <img src=''texrender_question_2799_AG116_1.svg''> der Schwingkreise?<p><img src=''AG116_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2800,'AG115','Das folgende Bild stellt einen Dreiband-Dipol für die Frequenzbänder 20, 15 und 10 m dar. Die mit b gekennzeichneten Schwingkreise sind abgestimmt auf:<p><img src=''AG115_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2801,'AG114','Das folgende Bild stellt einen Dreiband-Dipol für die Frequenzbänder 20, 15 und 10 m dar. Die mit a gekennzeichneten Schwingkreise sind abgestimmt auf:<p><img src=''AG114_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2802,'AG113','Wenn man diese Mehrband-Antenne auf 14 MHz erregt, dann wirken die LC-Resonanzkreise ...<p><img src=''AG113_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2803,'AG112','Wenn man diese Mehrband-Antenne auf 7 MHz erregt, dann wirken die LC-Resonanzkreise ...<p><img src=''AG112_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2804,'AG111','Wenn man diese Mehrband-Antenne auf 3,5 MHz erregt, dann wirken die LC-Resonanzkreise ...<p><img src=''AG111_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2805,'AG110','Ein Parallelresonanzkreis (Trap) in jeder Dipolhälfte ...',0,1,0,0,'');
INSERT INTO question VALUES(2806,'AG109','Welche Antennenart ist hier dargestellt?  <p><img src=''AG109_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2807,'AG108','Was sollte in jeden Schenkel einer symmetrischen, zweimal 15 m langen Dipol-Antenne eingefügt werden, damit die Antenne im Bereich um 3,6 MHz resonant wird?',0,1,0,0,'');
INSERT INTO question VALUES(2808,'AG107','Wozu dient der Kondensator in dieser Antenne?<p><img src=''AG107_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2809,'AG106','Wozu dient die Spule in dieser Antenne?<p><img src=''AG106_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2810,'AG105','Eine 5/8-<img src=''texrender_question_2810_AG105_0.svg''>-Vertikalantenne soll für 14,2 MHz aus Draht hergestellt werden. Es soll mit einem Verkürzungsfaktor von 0,97 gerechnet werden. Wie lang muss der Draht insgesamt sein?',0,1,0,0,'');
INSERT INTO question VALUES(2811,'AG104','Eine <img src=''texrender_question_2811_AG104_0.svg''>/4-Groundplane-Antenne mit vier Radials soll für 7,1 MHz aus Drähten gefertigt werden. Für Strahlerelement und Radials kann mit einem Verkürzungsfaktor von 0,95 gerechnet werden. Wie lang müssen Strahlerelement und Radials jeweils sein?',0,1,0,0,'');
INSERT INTO question VALUES(2812,'AG103','Ein Drahtdipol hat eine Gesamtlänge von 20 m. Für welche Frequenz ist der Dipol in Resonanz, wenn mit einem Verkürzungsfaktor von 0,95 gerechnet wird?',0,1,0,0,'');
INSERT INTO question VALUES(2813,'AG102','Eine <img src=''texrender_question_2813_AG102_0.svg''>/2-Dipol-Antenne soll für 7,1 MHz aus Draht gefertigt werden. Wie lang müssen die beiden Drähte der Dipol-Antenne jeweils sein? Es soll hier mit einem Verkürzungsfaktor von 0,95 gerechnet werden.',0,1,0,0,'');
INSERT INTO question VALUES(2814,'AG101','Eine <img src=''texrender_question_2814_AG101_0.svg''>/2-Dipol-Antenne soll für 14,2 MHz aus Draht gefertigt werden. Es soll mit einem Verkürzungsfaktor von 0,95 gerechnet werden. Wie lang müssen die beiden Drähte der Dipol-Antenne jeweils sein?',0,1,0,0,'');
INSERT INTO question VALUES(2840,'AG229','Wie hoch ist der Gewinn eines Parabolspiegels mit einem Durchmesser von 120 cm und mit einem Wirkungsgrad von <img src=''texrender_question_2840_AG229_0.svg''> = 1 bei einer Arbeitsfrequenz von 10,4 GHz?',0,1,0,0,'');
INSERT INTO question VALUES(2841,'AG228','Wie hoch ist der Gewinn eines Parabolspiegels mit einem Durchmesser von 80 cm und mit einem Wirkungsgrad von <img src=''texrender_question_2841_AG228_0.svg''> = 1 bei einer Arbeitsfrequenz von 10,4 GHz?',0,1,0,0,'');
INSERT INTO question VALUES(2842,'AG227','Wie hoch ist der Gewinn eines Parabolspiegels mit einem Durchmesser von 80 cm und mit einem Wirkungsgrad von <img src=''texrender_question_2842_AG227_0.svg''> = 1 bei einer Arbeitsfrequenz von 5,7 GHz?',0,1,0,0,'');
INSERT INTO question VALUES(2843,'AG226','Wie hoch ist der Gewinn eines Parabolspiegels mit einem Durchmesser von 30 cm und mit einem Wirkungsgrad von <img src=''texrender_question_2843_AG226_0.svg''> = 1 bei einer Arbeitsfrequenz von 5,7 GHz?',0,1,0,0,'');
INSERT INTO question VALUES(2844,'AG225','Welche Antennentypen kommen üblicherweise als Erregerantennen (Feed) in Parabolspiegeln für den Mikrowellenbereich zum Einsatz?',0,1,0,0,'');
INSERT INTO question VALUES(2845,'AG224','Welche Eigenschaften besitzt eine in geringer Höhe aufgebaute, auf Kurzwelle betriebene NVIS-Antenne (Near Vertical Incident Skywave)?',0,1,0,0,'');
INSERT INTO question VALUES(2846,'AG223','Bei welcher Länge erreicht eine Vertikalantenne für den Kurzwellenbereich über einer Erdoberfläche mittlerer Leitfähigkeit eine möglichst flache Abstrahlung?',0,1,0,0,'');
INSERT INTO question VALUES(2847,'AG222','Worin unterscheidet sich eine Yagi-Uda-Antenne mit 11 Elementen von einer mit 3 Elementen? Bei der Antenne mit 11 Elementen ist ...',0,1,0,0,'');
INSERT INTO question VALUES(2848,'AG221','Die folgende Skizze zeigt das Horizontaldiagramm der relativen Feldstärke einer Yagi-Uda-Antenne. Wie groß ist im vorliegenden Fall die Halbwertsbreite (Öffnungswinkel)?<p><img src=''AG221_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2849,'AG220','In dem folgenden Richtdiagramm sind auf der Skala der relativen Feldstärke <img src=''texrender_question_2849_AG220_0.svg''> die Punkte a bis d markiert. Durch welchen der Punkte a bis d ziehen Sie den Kreisbogen, um die Halbwertsbreite der Antenne an den Schnittpunkten des Kreises mit der Richtkeule ablesen zu können?<p><img src=''AG220_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2850,'AG219','Die Halbwertsbreite einer Antenne ist der Winkelbereich, innerhalb dessen ...',0,1,0,0,'');
INSERT INTO question VALUES(2851,'AG218','Mit einem Feldstärkemessgerät wurden Vergleichsmessungen zwischen Beam und Dipol durchgeführt. In einem Abstand von 32 m wurden folgende Feldstärken gemessen: Beam vorwärts: 300 μV/m, Beam rückwärts: 20 μV/m, Halbwellendipol in Hauptstrahlrichtung: 128 μV/m. Welcher Gewinn und welches Vor-Rück-Verhältnis ergibt sich daraus für den Beam?',0,1,0,0,'');
INSERT INTO question VALUES(2852,'AG217','Bei einer Yagi-Uda-Antenne mit dem folgenden Strahlungsdiagramm beträgt die ERP in Richtung a 0,6 W und in Richtung b 15 W. Welches Vor-Rück-Verhältnis hat die Antenne?<p><img src=''AG217_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2853,'AG216','Eine Richtantenne mit einem Gewinn von 15 dB über dem Halbwellendipol und einem Vor-Rück-Verhältnis von 25 dB wird mit 6 W Sendeleistung direkt gespeist. Welche ERP strahlt die Antenne entgegengesetzt zur Senderichtung ab?',0,1,0,0,'');
INSERT INTO question VALUES(2854,'AG215','Eine Richtantenne mit einem Gewinn von 10 dB über dem Halbwellendipol und einem Vor-Rück-Verhältnis von 20 dB wird mit 100 W Sendeleistung direkt gespeist. Welche ERP strahlt die Antenne entgegengesetzt zur Senderichtung ab?',0,1,0,0,'');
INSERT INTO question VALUES(2855,'AG214','Das folgende Bild zeigt die Strahlungscharakteristik eines Dipols und einer Richtantenne. Das Vor-/Rück-Verhältnis der Richtantenne ist definiert als das Verhältnis ...<p><img src=''AG214_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2856,'AG213','Das folgende Bild zeigt die Strahlungscharakteristik eines Dipols und einer Richtantenne. Der Antennengewinn der Richtantenne über dem Dipol ist definiert als das Verhältnis ...<p><img src=''AG213_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2857,'AG212','Die Impedanz des Strahlers eines Kurzwellenbeams richtet sich auch nach ...',0,1,0,0,'');
INSERT INTO question VALUES(2858,'AG211','Welchen Eingangs- bzw. Fußpunktwiderstand hat ein <img src=''texrender_question_2858_AG211_0.svg''>/2-Dipol in ungefähr einer Wellenlänge Höhe über dem Boden bei seiner Grundfrequenz?',0,1,0,0,'');
INSERT INTO question VALUES(2859,'AG210','Welche Fußpunktimpedanz hat ein <img src=''texrender_question_2859_AG210_0.svg''>/2-Dipol unterhalb und oberhalb seiner Grundfrequenz?',0,1,0,0,'');
INSERT INTO question VALUES(2860,'AG209','Der Fusspunktwiderstand eines mittengespeisten <img src=''texrender_question_2860_AG209_0.svg''>/2-Dipols zeigt sich bei dessen Resonanzfrequenzen ...',0,1,0,0,'');
INSERT INTO question VALUES(2861,'AG208','Ein mittengespeister <img src=''texrender_question_2861_AG208_0.svg''>/2-Dipol ist bei geradzahligen Vielfachen seiner Grundfrequenz ...',0,1,0,0,'');
INSERT INTO question VALUES(2862,'AG207','Ein mittengespeister <img src=''texrender_question_2862_AG207_0.svg''>/2-Dipol ist bei seiner Grundfrequenz und deren ungeradzahligen Vielfachen ...',0,1,0,0,'');
INSERT INTO question VALUES(2863,'AG206','Das folgende Bild zeigt die Stromverteilungen a bis d auf einem Dipol, der auf verschiedenen Resonanzfrequenzen erregt werden kann. Für welche Erregerfrequenz gilt die Stromkurve nach d?<p><img src=''AG206_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2864,'AG205','Das folgende Bild zeigt die Stromverteilungen a bis d auf einem Dipol, der auf verschiedenen Resonanzfrequenzen erregt werden kann. Für welche Erregerfrequenz gilt die Stromkurve nach c?<p><img src=''AG205_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2865,'AG204','Das folgende Bild zeigt die Stromverteilungen a bis d auf einem Dipol, der auf verschiedenen Resonanzfrequenzen erregt werden kann. Für welche Erregerfrequenz gilt die Stromkurve nach b?<p><img src=''AG204_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2866,'AG203','Das folgende Bild zeigt die Stromverteilungen a bis d auf einem Dipol, der auf verschiedenen Resonanzfrequenzen erregt werden kann. Für welche Erregerfrequenz gilt die Stromkurve nach a?<p><img src=''AG203_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2867,'AG202','Warum muss eine Antenne mechanisch etwas kürzer als der theoretisch errechnete Wert sein?',0,1,0,0,'');
INSERT INTO question VALUES(2868,'AG201','Mit welcher Polarisation wird auf den Kurzwellenbändern meistens gesendet?',0,1,0,0,'');
INSERT INTO question VALUES(2892,'AG320','Eine Lecherleitung besteht aus zwei parallelen Leitern. Wovon ist ihre Resonanzfrequenz wesentlich abhängig? Sie ist abhängig ...',0,1,0,0,'');
INSERT INTO question VALUES(2893,'AG319','Welche Folgen hat der Skin-Effekt bei steigender Frequenz? Der stromdurchflossene Querschnitt des Leiters ...',0,1,0,0,'');
INSERT INTO question VALUES(2894,'AG318','Wie bezeichnet man den Effekt, dass sich mit steigender Frequenz der Elektronenstrom mehr und mehr zur Oberfläche eines Leiters hin verlagert, so dass sich mit steigender Frequenz der ohmsche Verlustwiderstand des Leiters erhöht?',0,1,0,0,'');
INSERT INTO question VALUES(2895,'AG317','Welche mechanische Länge hat ein elektrisch <img src=''texrender_question_2895_AG317_0.svg''>/4 langes Koaxkabel mit Vollpolyethylenisolierung bei 145 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(2896,'AG316','Wie lang ist ein Koaxialkabel, das für eine ganze Wellenlänge bei 145 MHz zugeschnitten wurde, wenn der Verkürzungsfaktor 0,66 beträgt?',0,1,0,0,'');
INSERT INTO question VALUES(2897,'AG315','Der Verkürzungsfaktor eines Koaxialkabels mit einem Dielektrikum aus massivem Polyethylen beträgt ungefähr ...',0,1,0,0,'');
INSERT INTO question VALUES(2898,'AG314','Die Ausbreitungsgeschwindigkeit in einem Koaxialkabel ...',0,1,0,0,'');
INSERT INTO question VALUES(2899,'AG313','Der Verkürzungsfaktor einer luftisolierten Paralleldrahtleitung ist ...',0,1,0,0,'');
INSERT INTO question VALUES(2900,'AG312','Bei einer symmetrischen Zweidrahtleitung ohne Gleichtaktanteil ...',0,1,0,0,'');
INSERT INTO question VALUES(2901,'AG311','Welche der folgenden Leitungen weist bei gleichem Leiterquerschnitt im Kurzwellenbereich den geringsten Verlust auf?',0,1,0,0,'');
INSERT INTO question VALUES(2902,'AG310','Zur Verbindung Ihres 5,700 GHz-Senders (6 cm-Band) mit dem Feed eines Parabolspiegels benötigen Sie ein 8 m langes und möglichst dünnes Koaxialkabel, das nicht mehr als 3 dB Dämpfung haben soll. Welches der Koaxialkabel aus dem Kabeldämpfungsdiagramm erfüllt diese Anforderung?',0,1,0,0,'');
INSERT INTO question VALUES(2903,'AG309','Welches Koaxkabel ist nach dem zur Verfügung gestellten Kabeldämpfungsdiagramm für eine 20 m lange Verbindung zwischen Senderausgang und Antenne geeignet, wenn die Kabeldämpfung im 13 cm-Band bei 2,350 GHz nicht mehr als 4 dB betragen soll?',0,1,0,0,'');
INSERT INTO question VALUES(2904,'AG308','Welcher Typ Koaxialkabel ist laut zur Verfügung gestelltem Kabeldämpfungsdiagramm für eine 60 m lange Verbindung zwischen Senderausgang und einem Multiband-Kurzwellenbeam für die Bänder 20 m, 15 m und 10 m geeignet, wenn die Kabeldämpfung bei 29 MHz nicht mehr als 2 dB betragen soll?',0,1,0,0,'');
INSERT INTO question VALUES(2905,'AG307','Ein Koaxialkabel hat einen Innenleiterdurchmesser von 0,7 mm. Die Isolierung zwischen Innenleiter und Abschirmgeflecht besteht aus Polyethylen (PE) und sie hat einen Durchmesser von 4,4 mm. Der Außendurchmesser des Kabels ist 7,4 mm. Wie hoch ist der ungefähre Wellenwiderstand des Kabels?',0,1,0,0,'');
INSERT INTO question VALUES(2906,'AG306','Ein Koaxialkabel (luftisoliert) hat einen Innendurchmesser der Abschirmung von 5 mm. Der Außendurchmesser des inneren Leiters beträgt 1 mm. Wie groß ist der Wellenwiderstand <img src=''texrender_question_2906_AG306_0.svg''> des Kabels?',0,1,0,0,'');
INSERT INTO question VALUES(2907,'AG305','Eine offene Paralleldrahtleitung ist aus Draht mit einem Durchmesser d = 2 mm gefertigt. Der Abstand der parallelen Leiter beträgt a = 20 cm. Wie groß ist der Wellenwiderstand <img src=''texrender_question_2907_AG305_0.svg''> der Leitung?',0,1,0,0,'');
INSERT INTO question VALUES(2908,'AG304','Eine Übertragungsleitung wird angepasst betrieben, wenn der Widerstand, mit dem sie abgeschlossen ist, ...',0,1,0,0,'');
INSERT INTO question VALUES(2909,'AG303','Welche Parameter beschreiben charakteristische Hochfrequenzeigenschaften eines Koaxialkabels?',0,1,0,0,'');
INSERT INTO question VALUES(2910,'AG302','Welche Materialien werden für die Dielektriken gebräuchlicher Koaxkabel üblicherweise verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(2911,'AG301','Um bei hohen Sendeleistungen auf den Kurzwellenbändern die Störwahrscheinlichkeit auf ein Mindestmaß zu begrenzen, sollte die für die Sendeantenne verwendete Speiseleitung innerhalb von Gebäuden ...',0,1,0,0,'');
INSERT INTO question VALUES(2936,'AG429','Wodurch können Mantelwellen im Falle einer koax-gespeisten symmetrischen Antenne auftreten, obwohl ein Spannungs-Balun verwendet wird?',0,1,0,0,'');
INSERT INTO question VALUES(2937,'AG428','Die Darstellung zeigt die bei Ankopplung eines Koaxialkabels an eine Antenne auftretenden Ströme. Wie kann man den als <img src=''texrender_question_2937_AG428_0.svg''> bezeichneten, unerwünschten Mantelstrom reduzieren?<p><img src=''AG428_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2938,'AG427','Wodurch können Mantelwellen auf Koaxialkabeln verursacht werden?',0,1,0,0,'');
INSERT INTO question VALUES(2939,'AG426','Wie wirkt eine stromkompensierte Drossel (z. B. Koaxialkabel um einen Ferritkern gewickelt) Mantelwellen entgegen? Sie wirkt ...',0,1,0,0,'');
INSERT INTO question VALUES(2940,'AG425','Wann liegen Mantelwellen auf einem Koaxialkabel vor? Wenn ...',0,1,0,0,'');
INSERT INTO question VALUES(2941,'AG424','Zur Anpassung von Antennen werden häufig Umwegleitungen verwendet. Wie arbeitet die folgende Schaltung?<p><img src=''AG424_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2942,'AG423','Was zeigt diese Darstellung?<p><img src=''AG423_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2943,'AG422','Dargestellt ist ein HF-Übertrager (Balun). An den Anschlüssen a und b wird ein Faltdipol mit 200 Ohm Impedanz angeschlossen. Welche Impedanz misst man zwischen den Anschlüssen a und m?<p><img src=''AG422_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2944,'AG421','Für welche Antennenimpedanz ist der folgende Balun-Transformator aus zweimal acht Windungen ausgelegt?<p><img src=''AG421_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2945,'AG420','Ein Dipol soll mit einem Koaxkabel gleicher Impedanz gespeist werden. Dabei erreicht man einen Symmetriereffekt zum Beispiel durch ...',0,1,0,0,'');
INSERT INTO question VALUES(2946,'AG419','Was ist beim Aufbau des dargestellten Drahtantennensystems zu beachten? Die Drahtlänge des Strahlers sollte ...<p><img src=''AG419_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2947,'AG418','Ein Faltdipol mit einem Fußpunktwiderstand von 240 Ohm soll mit einer Hühnerleiter gespeist werden, deren Wellenwiderstand 600 Ohm beträgt. Zur Anpassung soll ein <img src=''texrender_question_2947_AG418_0.svg''>/4 langes Stück Hühnerleiter mit einem anderen Wellenwiderstand verwendet werden. Welchen Wellenwiderstand muss die Transformationsleitung haben?',0,1,0,0,'');
INSERT INTO question VALUES(2948,'AG417','Ein Dipol mit einem Fußpunktwiderstand von 60 Ohm soll über eine <img src=''texrender_question_2948_AG417_0.svg''>/4-Transformationsleitung mit einem 240 Ohm-Flachbandkabel gespeist werden. Welchen Wellenwiderstand muss die Transformationsleitung haben?',0,1,0,0,'');
INSERT INTO question VALUES(2949,'AG416','Ein Halbwellendipol hat bei seiner Resonanzfrequenz am Einspeisepunkt eine Impedanz von 70 Ohm. Er wird über ein <img src=''texrender_question_2949_AG416_0.svg''>/2-langes 300 Ohm-Flachbandkabel gespeist. Wie groß ist die Impedanz am Eingang der Speiseleitung?',0,1,0,0,'');
INSERT INTO question VALUES(2950,'AG415','Einem Ganzwellendipol wird die Sendeleistung über eine abgestimmte <img src=''texrender_question_2950_AG415_0.svg''>/4-Speiseleitung zugeführt. Wie hoch ist die Impedanz <img src=''texrender_question_2950_AG415_1.svg''> am Einspeisepunkt des Dipols und wie hoch ist die Impedanz <img src=''texrender_question_2950_AG415_2.svg''> am Anfang der Speiseleitung?<p><img src=''AG415_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2951,'AG414','Einem Ganzwellendipol wird die Sendeleistung über eine abgestimmte <img src=''texrender_question_2951_AG414_0.svg''>/2-Speiseleitung zugeführt. Wie hoch ist die Impedanz <img src=''texrender_question_2951_AG414_1.svg''> am Einspeisepunkt des Dipols und wie hoch ist die Impedanz <img src=''texrender_question_2951_AG414_2.svg''> am Anfang der Speiseleitung?<p><img src=''AG414_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2952,'AG413','Einem Halbwellendipol wird die Sendeleistung über eine abgestimmte <img src=''texrender_question_2952_AG413_0.svg''>/2-Speiseleitung zugeführt. Wie hoch ist die Impedanz <img src=''texrender_question_2952_AG413_1.svg''> am Einspeisepunkt des Dipols? Und wie hoch ist die Impedanz <img src=''texrender_question_2952_AG413_2.svg''> am Anfang der Speiseleitung?<p><img src=''AG413_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2953,'AG412','Eine Halbwellen-Übertragungsleitung ist an einem Ende mit 50 Ohm abgeschlossen. Wie groß ist die Eingangsimpedanz am anderen Ende dieser Leitung?',0,1,0,0,'');
INSERT INTO question VALUES(2954,'AG411','Eine Viertelwellen-Übertragungsleitung ist an einem Ende offen. Die Impedanz am anderen Ende ...',0,1,0,0,'');
INSERT INTO question VALUES(2955,'AG410','Wie groß ist die Impedanz am Punkt X, wenn die elektrische Länge der abgebildeten Koaxialleitung <img src=''texrender_question_2955_AG410_0.svg''>/4 beträgt?<p><img src=''AG410_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2956,'AG409','Wie groß ist die Impedanz am Punkt a, wenn die elektrische Länge der abgebildeten Koaxialleitung <img src=''texrender_question_2956_AG409_0.svg''>/4 beträgt?<p><img src=''AG409_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2957,'AG408','Welche Phasenverschiebung erhält ein HF-Signal von a nach b, wenn die elektrische Länge der abgebildeten Koaxialleitung gleich der Wellenlänge ist?  <p><img src=''AG408_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2958,'AG407','Welche Phasenverschiebung erhält ein HF-Signal von a nach b, wenn die elektrische Länge der abgebildeten Koaxialleitung <img src=''texrender_question_2958_AG407_0.svg''>/4 beträgt?<p><img src=''AG407_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2959,'AG406','Worum handelt es sich bei dieser Schaltung? Es handelt sich um ...<p><img src=''AG406_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(2960,'AG405','Ein Kabel mit einem Wellenwiderstand von 75 Ohm und vernachlässigbarer Dämpfung wird zur Speisung einer Faltdipol-Antenne verwendet. Welches SWR kann man auf der Leitung erwarten?',0,1,0,0,'');
INSERT INTO question VALUES(2961,'AG404','Am Eingang einer Antennenleitung mit einer Dämpfung von 5 dB werden 10 W HF-Leistung eingespeist. Mit der am Leitungsende angeschlossenen Antenne misst man am Leitungseingang ein SWR von 1. Welches SWR ist am Leitungseingang zu erwarten, wenn die Antenne abgeklemmt wird?',0,1,0,0,'');
INSERT INTO question VALUES(2962,'AG403','In den Eingang einer Antennenleitung mit einer Dämpfung von 3 dB werden 10 W HF-Leistung eingespeist. Mit der am Leitungsende angeschlossenen Antenne misst man am Leitungseingang ein SWR von 3. Mit einer künstlichen 50 Ohm-Antenne am Leitungsende beträgt das SWR am Leitungseingang etwa 1. Was lässt sich aus diesen Messergebnissen schließen?',0,1,0,0,'');
INSERT INTO question VALUES(2963,'AG402','Am Eingang einer angepassten HF-Übertragungsleitung werden 100 W HF-Leistung eingespeist. Die Dämpfung der Leitung beträgt 3 dB. Welche Leistung wird bei Leerlauf oder Kurzschluss am Leitungsende reflektiert?',0,1,0,0,'');
INSERT INTO question VALUES(2964,'AG401','Welche Lastimpedanz ist für eine Leistungsanpassung erforderlich, wenn die Signalquelle eine Ausgangsimpedanz von 50 Ohm hat? ',0,1,0,0,'');
INSERT INTO question VALUES(2978,'AG503','Ein Sender für das 630 m-Band mit 50 W Ausgangsleistung ist mittels eines kurzen Koaxialkabels an eine Antenne mit 20 dBd Verlust angeschlossen. Welche ERP wird von der Antenne abgestrahlt?',0,1,0,0,'');
INSERT INTO question VALUES(2979,'AG502','Nach welcher der Antworten kann die ERP (Effective Radiated Power) berechnet werden?',0,1,0,0,'');
INSERT INTO question VALUES(2980,'AG501','Die äquivalente (effektive) Strahlungsleistung (ERP) ist ...',0,1,0,0,'');
INSERT INTO question VALUES(2994,'AH108','Zu welcher Jahres- und Tageszeit hat die F2-Region ihre größte Höhe? Sie hat ihre größte Höhe ...',0,1,0,0,'');
INSERT INTO question VALUES(2995,'AH107','Für die DX-Kurzwellenausbreitung über die Raumwelle ist die F1-Region ...',0,1,0,0,'');
INSERT INTO question VALUES(2996,'AH106','In welcher Höhe befindet sich die für die Fernausbreitung (DX) wichtige F2-Region während der Tagesstunden an einem Sommertag? Sie befindet sich in ungefähr ...',0,1,0,0,'');
INSERT INTO question VALUES(2997,'AH105','In welcher Höhe befindet sich die für die Fernausbreitung (DX) wichtige F1-Region während der Tagesstunden? Sie befindet sich in ungefähr ...',0,1,0,0,'');
INSERT INTO question VALUES(2998,'AH104','In welcher Höhe befindet sich die für die Fernausbreitung wichtige E-Region? Sie befindet sich in ungefähr ...',0,1,0,0,'');
INSERT INTO question VALUES(2999,'AH103','In welcher Höhe befindet sich die für die Fernausbreitung wichtige D-Region? Sie befindet sich in ungefähr ...',0,1,0,0,'');
INSERT INTO question VALUES(3000,'AH102','Der solare Flux F ...',0,1,0,0,'');
INSERT INTO question VALUES(3001,'AH101','Welcher Effekt sorgt hauptsächlich dafür, dass ionosphärische Regionen Funkwellen zur Erde ablenken können?',0,1,0,0,'');
INSERT INTO question VALUES(3011,'AH223','Was ist für ein "Backscatter-Signal" charakteristisch?',0,1,0,0,'');
INSERT INTO question VALUES(3012,'AH222','Welcher Effekt tritt ein, wenn das Signal eines Senders auf zwei unterschiedlichen Wegen zum Empfänger gelangt?',0,1,0,0,'');
INSERT INTO question VALUES(3013,'AH221','Massiv erhöhte UV- und Röntgenstrahlung, wie sie vor allem durch starke Sonneneruptionen hervorgerufen wird, beeinflusst in der Ionosphäre vor allem ...',0,1,0,0,'');
INSERT INTO question VALUES(3014,'AH220','Wie wirkt sich "Sporadic E" auf die höheren Kurzwellenbänder aus?',0,1,0,0,'');
INSERT INTO question VALUES(3015,'AH219','Wie wird die Polarisation einer elektromagnetischen Welle bei der Ausbreitung über die Raumwelle beeinflusst?',0,1,0,0,'');
INSERT INTO question VALUES(3016,'AH218','Eine Amateurfunkstation in Frankfurt/Main will eine Verbindung nach Buenos Aires auf dem langen Weg herstellen. Auf welchen Winkel gegen Nord (Azimut) muss der Funkamateur seinen Kurzwellenbeam drehen, wenn die Beamrichtung für den kurzen Weg 231 ° beträgt? Er muss die Antenne drehen auf ...',0,1,0,0,'');
INSERT INTO question VALUES(3017,'AH217','Eine Amateurfunkstation in Frankfurt/Main will eine Verbindung nach Tokio auf dem langen Weg herstellen. Auf welchen Winkel gegen Nord (Azimut) muss der Funkamateur seinen Kurzwellenbeam drehen, wenn die Beamrichtung für den kurzen Weg 38 ° beträgt? Er muss die Antenne drehen auf ...',0,1,0,0,'');
INSERT INTO question VALUES(3018,'AH216','Wie erkennt ein Funkamateur in der Regel, dass er mit "PY" auf dem indirekten und somit längeren Weg gearbeitet hat?',0,1,0,0,'');
INSERT INTO question VALUES(3019,'AH215','Eine Aussendung auf dem 20 m-Band kann von der Funkstelle A in einer Entfernung von 1500 km, nicht jedoch von der Funkstelle B in 60 km Entfernung empfangen werden. Der Grund hierfür ist, dass ...',0,1,0,0,'');
INSERT INTO question VALUES(3020,'AH214','Wie groß ist in etwa die maximale Entfernung, die ein KW-Signal bei Refraktion (Brechung) in der E-Region auf der Erdoberfläche mit einem Sprung (Hop) überbrücken kann? Sie beträgt etwa ...',0,1,0,0,'');
INSERT INTO question VALUES(3021,'AH213','Wie groß ist in etwa die maximale Entfernung, die ein KW-Signal bei Refraktion (Brechung) an der F2-Region auf der Erdoberfläche mit einem Sprung (Hop) überbrücken kann?',0,1,0,0,'');
INSERT INTO question VALUES(3022,'AH212','Was hat <u>keine</u> Auswirkungen auf die Sprungentfernung?',0,1,0,0,'');
INSERT INTO question VALUES(3023,'AH211','Was bedeutet die Aussage: "Die LUF für eine Funkstrecke liegt bei 6 MHz"?',0,1,0,0,'');
INSERT INTO question VALUES(3024,'AH210','Die LUF für eine Funkstrecke ist ...',0,1,0,0,'');
INSERT INTO question VALUES(3025,'AH209','Wie groß ist die höchste nutzbare Frequenz (MUF) und die optimale Frequenz <img src=''texrender_question_3025_AH209_0.svg''>, wenn die Antenne in einem Winkel von <img src=''texrender_question_3025_AH209_1.svg''> schräg nach oben strahlt und die kritische Frequenz <img src=''texrender_question_3025_AH209_2.svg''> 3 MHz beträgt?',0,1,0,0,'');
INSERT INTO question VALUES(3026,'AH208','Die höchste brauchbare Frequenz (MUF) für eine Funkstrecke ...',0,1,0,0,'');
INSERT INTO question VALUES(3027,'AH207','Wenn sich elektromagnetische Wellen zwischen zwei Orten durch ionosphärische Brechung ausbreiten, dann ist die MUF ...',0,1,0,0,'');
INSERT INTO question VALUES(3028,'AH206','Die höchste Frequenz, bei der eine Kommunikation zwischen zwei Funkstellen über Raumwelle möglich ist, wird als ...',0,1,0,0,'');
INSERT INTO question VALUES(3029,'AH205','Angenommen, die kritische Frequenz der F2-Region (foF2) liegt bei 12 MHz. Welche Aussage ist dann richtig? Bei Einstrahlung in die Ionosphäre unter einem Winkel von ...',0,1,0,0,'');
INSERT INTO question VALUES(3030,'AH204','Die kritische Frequenz der F2-Region (foF2) ist die ...',0,1,0,0,'');
INSERT INTO question VALUES(3031,'AH203','Welche der folgenden Frequenzbänder können in den Nachtstunden am ehesten für weltweite Funkverbindungen genutzt werden?',0,1,0,0,'');
INSERT INTO question VALUES(3032,'AH202','Welches dieser Frequenzbänder kann im Sonnenfleckenminimum am ehesten für tägliche Weitverkehrsverbindungen verwendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(3033,'AH201','Welches der nachstehend aufgeführten Bänder ist für KW-Verbindungen zwischen Hamburg und München um die Mittagszeit herum üblicherweise gut geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(3054,'AH311','Um welche Art von Überreichweiten handelt es sich bei Regenscatter (Rainscatter)?',0,1,0,0,'');
INSERT INTO question VALUES(3055,'AH310','Was versteht man unter Aircraft-Scatter (AS)?',0,1,0,0,'');
INSERT INTO question VALUES(3056,'AH309','Überhorizontverbindungen im VHF/UHF-Bereich kommen unter anderem zustande durch ...',0,1,0,0,'');
INSERT INTO question VALUES(3057,'AH308','Wie wirkt sich "Aurora" auf die Signalqualität eines Funksignals aus?',0,1,0,0,'');
INSERT INTO question VALUES(3058,'AH307','Welches der folgenden Übertragungsverfahren eignet sich am besten für Auroraverbindungen?',0,1,0,0,'');
INSERT INTO question VALUES(3059,'AH306','In welche Himmelsrichtung muss eine Funkstation in Europa ihre VHF-Antenne drehen, um eine Verbindung über "Aurora" abzuwickeln?',0,1,0,0,'');
INSERT INTO question VALUES(3060,'AH305','Was meint ein Funkamateur damit, wenn er angibt, dass er auf dem 2 m-Band eine Aurora-Verbindung mit Schottland gehabt hat?',0,1,0,0,'');
INSERT INTO question VALUES(3061,'AH304','Beim Auftreten von Polarlichtern lassen sich auf den Amateurfunkbändern über 30 MHz beträchtliche Überreichweiten erzielen, weil ...',0,1,0,0,'');
INSERT INTO question VALUES(3062,'AH303','Was ist die Ursache für Aurora-Erscheinungen?',0,1,0,0,'');
INSERT INTO question VALUES(3063,'AH302','In welchem ionosphärischen Bereich treten gelegentlich Aurora-Erscheinungen auf?',0,1,0,0,'');
INSERT INTO question VALUES(3064,'AH301','Bei "Sporadic E"-Ausbreitung werden Wellen im VHF-Bereich gebrochen an ...',0,1,0,0,'');
INSERT INTO question VALUES(3076,'AI105','Zur genauen Messung der effektiven Leistung eines modulierten Signals bis in den oberen GHz-Bereich eignet sich ...',0,1,0,0,'');
INSERT INTO question VALUES(3077,'AI104','Für ein digitales Multimeter ist folgende Angabe im Datenblatt zu finden: Kleinste Auflösung 100 μV, Innenwiderstand 10 MOhm in allen Messbereichen. Sie messen eine Spannung von 0,5 V. Welcher Strom fließt dabei durch das Multimeter?',0,1,0,0,'');
INSERT INTO question VALUES(3078,'AI103','Ein Spannungs- und ein Strommessgerät werden für die Ermittlung der Gleichstromeingangsleistung einer Schaltung verwendet. Das Spannungsmessgerät zeigt 10 V, das Strommessgerät 10 A an. Falls beide dabei im Rahmen ihrer Messgenauigkeit jeweils einen um 5 % zu geringen Wert anzeigen würden, würde man die elektrische Leistung um ...',0,1,0,0,'');
INSERT INTO question VALUES(3079,'AI102','Für die Messung der Gleichstrom-Eingangsleistung werden verschiedene Messgeräte verwendet. Bei welchen der Instrumente in der Abbildung handelt es sich um Strommessgeräte?<p><img src=''AI102_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3080,'AI101','Wie sollten Strom- und Spannungsmessgeräte zur Feststellung der Gleichstrom-Eingangsleistung des dargestellten Endverstärkers (PA) angeordnet werden?<p><img src=''AI101_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3089,'AI208','Sie haben einen vektoriellen Netzwerkanalysator (VNA) an einen selbstgebauten Halbwellendipol angeschlossen und messen den dargestellten Resonanzverlauf. Was müssen Sie tun, um diese Antenne auf das 80 m-Band abzustimmen? <p><img src=''AI208_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3090,'AI207','Sie haben einen vektoriellen Netzwerkanalysator (VNA) an einen selbstgebauten Halbwellendipol angeschlossen und messen den dargestellten Resonanzverlauf. Was müssen Sie tun, um diese Antenne auf das 80 m-Band abzustimmen? <p><img src=''AI207_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3091,'AI206','Sie haben einen vektoriellen Netzwerkanalysator (VNA) an den Speisepunkt Ihrer Kurzwellenantenne angeschlossen. Das Gerät zeigt R = 54 Ohm und jX = +12 Ohm an. Was bedeutet das Messergebnis?',0,1,0,0,'');
INSERT INTO question VALUES(3092,'AI205','Sie haben einen vektoriellen Netzwerkanalysator (VNA), der auf den VHF-Bereich eingestellt ist, an den Speisepunkt ihrer VHF-Antenne angeschlossen. Das Gerät zeigt R = 50 Ohm und jX = 0 Ohm an. Was erkennen Sie aus diesen Werten?',0,1,0,0,'');
INSERT INTO question VALUES(3093,'AI204','Sie haben einen vektoriellen Netzwerkanalysator (VNA) an den Speisepunkt ihrer Kurzwellenantenne angeschlossen. Das Gerät zeigt R = 54 Ohm und jX = -12 Ohm an. Was bedeutet das Messergebnis?',0,1,0,0,'');
INSERT INTO question VALUES(3094,'AI203','Die Resonanzfrequenz eines abgestimmten HF-Kreises kann mit einem ...',0,1,0,0,'');
INSERT INTO question VALUES(3095,'AI202','Welches dieser Messgeräte ist für die Ermittlung der Resonanzfrequenz eines Traps, der für einen Dipol genutzt werden soll, am besten geeignet?',0,1,0,0,'');
INSERT INTO question VALUES(3096,'AI201','Wie funktioniert ein vektorieller Netzwerkanalysator (VNA)? Ein HF-Generator erzeugt ein ...',0,1,0,0,'');
INSERT INTO question VALUES(3103,'AI306','Das folgende Bild zeigt das Zweiton-SSB-Ausgangssignal eines KW-Senders, das mit einem Oszilloskop ausreichender Bandbreite über einen 10:1-Tastkopf direkt an der angeschlossenen künstlichen 50 Ohm-Antenne gemessen wurde. Welche Ausgangsleistung (PEP) liefert der Sender?<p><img src=''AI306_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3104,'AI305','Das folgende Bild zeigt das Zweiton-SSB-Ausgangssignal eines KW-Senders, das mit einem Oszilloskop ausreichender Bandbreite über einen 1:1-Tastkopf direkt an der angeschlossenen künstlichen 50 Ohm-Antenne gemessen wurde. Welche Ausgangsleistung (PEP) liefert der Sender?<p><img src=''AI305_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3105,'AI304','Womit misst man am einfachsten die Hüllkurvenform eines HF-Signals? Mit einem ...',0,1,0,0,'');
INSERT INTO question VALUES(3106,'AI303','Die Pulsbreite wird mit einem Oszilloskop bei ...',0,1,0,0,'');
INSERT INTO question VALUES(3107,'AI302','Was benötigt ein Oszilloskop zur Darstellung stehender Bilder?',0,1,0,0,'');
INSERT INTO question VALUES(3108,'AI301','Welches Gerät kann für die Prüfung von Signalverläufen verwendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(3113,'AI403','Zur Überprüfung eines Stehwellenmessgerätes wird dessen Ausgang mit einem HF-geeigneten 150 Ohm-Lastwiderstand abgeschlossen. Welches Stehwellenverhältnis muss das Messgerät anzeigen, wenn die Impedanz von Messgerät und Sender 50 Ohm beträgt?',0,1,0,0,'');
INSERT INTO question VALUES(3114,'AI402','Bei dieser Schaltung handelt es sich um ...<p><img src=''AI402_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3115,'AI401','Ein Stehwellenmessgerät misst und vergleicht bei einer HF-Leitung im Sendebetrieb ...',0,1,0,0,'');
INSERT INTO question VALUES(3124,'AI511','Womit kann die Frequenzanzeige eines durchstimmbaren Empfängers möglichst genau geprüft werden?',0,1,0,0,'');
INSERT INTO question VALUES(3125,'AI510','Ein Transceivers zeigt Frequenzen im 2 m-Band auf 1 ppm genau an. Um wie viel kHz muss die an diesem Transceiver bei SSB-Betrieb (USB) eingestellte Sendefrequenz (Frequenz des unterdrückten Trägers) unterhalb von 144,400 MHz liegen, um das dort beginnende Bakensegment zu schützen, wenn die übertragene NF auf den Bereich 300 Hz bis 2,7 kHz beschränkt ist?',0,1,0,0,'');
INSERT INTO question VALUES(3126,'AI509','Mit einem auf 10 ppm genauen digitalen Frequenzzähler wird eine Frequenz von 145 MHz gemessen. In welchem Bereich liegt der vom Zähler angezeigte Frequenzwert?',0,1,0,0,'');
INSERT INTO question VALUES(3127,'AI508','Ein Frequenzzähler misst auf <img src=''texrender_question_3127_AI508_0.svg''>1 ppm genau. Ist der Zähler auf den 100 MHz-Bereich eingestellt, so ist am oberen Ende dieses Bereiches eine Ungenauigkeit zu erwarten von ...',0,1,0,0,'');
INSERT INTO question VALUES(3128,'AI507','Ein TRX mit einem eingebauten OCXO besitzt eine Anzeigegenauigkeit von <img src=''texrender_question_3128_AI507_0.svg''>0,00001 %. Wie groß ist die maximale Abweichung, wenn eine Frequenz von 14100 kHz angezeigt wird?',0,1,0,0,'');
INSERT INTO question VALUES(3129,'AI506','Die relative Ungenauigkeit der digitalen Anzeige eines Empfängers beträgt 0,01 %. Um wieviel Hertz kann die angezeigte Frequenz bei 29 MHz maximal abweichen?',0,1,0,0,'');
INSERT INTO question VALUES(3130,'AI505','Benutzt man bei einem Frequenzzähler eine Torzeit von 10 s anstelle von 1 s erhöht sich ...',0,1,0,0,'');
INSERT INTO question VALUES(3131,'AI504','Eine Frequenzmessung wird genauer, wenn bei einem Frequenzzähler ...',0,1,0,0,'');
INSERT INTO question VALUES(3132,'AI503','Welche Konfiguration gewährleistet die höchste Genauigkeit bei der Prüfung der Trägerfrequenz eines FM-Senders?',0,1,0,0,'');
INSERT INTO question VALUES(3133,'AI502','Was kann man mit einem passenden Dämpfungsglied und einem Frequenzzähler messen?',0,1,0,0,'');
INSERT INTO question VALUES(3134,'AI501','Wenn die Frequenz eines Senders mit einem Frequenzzähler überprüft wird, ist ...',0,1,0,0,'');
INSERT INTO question VALUES(3140,'AI615','Mit welchem Messgerät kann man das Vorhandensein von Harmonischen nachweisen?',0,1,0,0,'');
INSERT INTO question VALUES(3141,'AI614','Mit welchem der folgenden Messinstrumente können die Amplituden der Harmonischen eines Signals gemessen werden? Sie können gemessen werden mit einem ...',0,1,0,0,'');
INSERT INTO question VALUES(3142,'AI613','Was stellt die folgende Schaltung dar? <p><img src=''AI613_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3143,'AI612','Was muss für die genaue Messung der HF-Ausgangsleistung eines Senders mit einer solchen Schaltung berücksichtigt werden?<p><img src=''AI612_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3144,'AI611','Bei der folgenden Schaltung besteht <img src=''texrender_question_3144_AI611_0.svg''> aus einer Zusammenschaltung von Widerständen, die einen Gesamtwiderstand von 54,1 Ohm hat und etwa 200 W aufnehmen kann. Die Diode ist eine Siliziumdiode mit <img src=''texrender_question_3144_AI611_1.svg''> = 0,7 V. Am Ausgang wird mit einem digitalen Spannungsmessgerät eine Gleichspannung von 14,9 V gemessen. Wie groß ist etwa die HF-Leistung am Eingang der Schaltung?<p><img src=''AI611_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3145,'AI610','Dem Eingang der folgenden Messschaltung wird eine HF-Leistung von 1 W zugeführt. D ist eine Schottkydiode mit <img src=''texrender_question_3145_AI610_0.svg''> = 0,23 V. Welche Spannung <img src=''texrender_question_3145_AI610_1.svg''> ist am Ausgang A zu erwarten, wenn die Messung mit einem hochohmigen Spannungsmessgerät erfolgt?<p><img src=''AI610_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3146,'AI609','Sie wollen mit der folgenden Messschaltung die Ausgangsleistung eines 2 m-Senders überprüfen, der voraussichtlich ca. 15 W HF-Leistung liefert. Was sollte für die Messung vor die dargestellte Messschaltung geschaltet werden?<p><img src=''AI609_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3147,'AI608','Was stellt die folgende Schaltung dar? <p><img src=''AI608_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3148,'AI607','Mit der folgenden Schaltung soll die Ausgangsleistung eines 2 m-FM-Handfunkgerätes gemessen werden. Die Dioden sind Schottkydioden mit <img src=''texrender_question_3148_AI607_0.svg''> = 0,23 V. Am Ausgang wird mit einem digitalen Spannungsmessgerät eine Gleichspannung von 15,3 V gemessen. Wie groß ist etwa die HF-Leistung am Eingang der Schaltung?<p><img src=''AI607_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3149,'AI606','Die Leistung eines 2 m-Senders soll mit einer künstlichen 50 Ohm-Antenne bestimmt werden, die über eine Anzapfung bei 5 Ohm vom erdnahen Ende verfügt. Zur Messung an diesem Punkt wird die folgende Schaltung eingesetzt. Die Dioden sind Schottkydioden mit <img src=''texrender_question_3149_AI606_0.svg''> 0,23 V. Am Ausgang der Schaltung wird dabei mit einem digitalen Spannungsmessgerät eine Gleichspannung von 15,3 V gemessen. Wie groß ist etwa die HF-Leistung des Senders?<p><img src=''AI606_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3150,'AI605','Was stellt die folgende Schaltung dar? <p><img src=''AI605_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3151,'AI604','Wozu dient diese Schaltung? Sie dient ...<p><img src=''AI604_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3152,'AI603','Eine künstliche Antenne (Dummy Load) von 50 Ohm verfügt über eine Anzapfung bei 5 Ohm vom erdnahen Ende. Was könnte zur ungefähren Ermittlung der Senderausgangsleistung über diesen Messpunkt eingesetzt werden?',0,1,0,0,'');
INSERT INTO question VALUES(3153,'AI602','Eine künstliche Antenne (Dummy Load) verfügt über einen Messausgang, der intern an einen Spitzenwertgleichrichter angeschlossen ist. Wozu dient dieser Messausgang? Er dient ...',0,1,0,0,'');
INSERT INTO question VALUES(3154,'AI601','Die Darstellung zeigt eine aus 150 Ohm / 1 W-Widerständen aufgebaute künstliche Antenne (Dummy Load). Mit dieser Kombination aus Reihen- und Parallelschaltung werden ca. 50 Ohm erreicht. Wie viele Widerstände werden für diesen Aufbau benötigt und welche Dauerleistung verträgt diese künstliche Antenne?<p><img src=''AI601_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3156,'AJ119','Welche Art von Kondensatoren sollte zum Abblocken von HF-Spannungen vorzugsweise verwendet werden? Am besten verwendet man ...',0,1,0,0,'');
INSERT INTO question VALUES(3157,'AJ118','Welches der nachfolgenden Filter könnte vor einem Netzanschlusskabel eingeschleift werden, um darüber fließende HF-Ströme wirksam zu dämpfen?',0,1,0,0,'');
INSERT INTO question VALUES(3158,'AJ117','Falls nachgewiesen wird, dass Störungen über das Stromversorgungsnetz in Geräte eindringen, ist wahrscheinlich ...',0,1,0,0,'');
INSERT INTO question VALUES(3159,'AJ116','Ein Nachbar beschwert sich über Störungen seines Fernsehempfängers, die allerdings auch bei abgezogener TV-Antenne auftreten. Die Störungen fallen zeitlich mit den Übertragungszeiten des Funkamateurs zusammen. Als erster Schritt ...',0,1,0,0,'');
INSERT INTO question VALUES(3160,'AJ115','Zur Verhinderung von Rundfunk-Empfangsstörungen (z. B. UKW, DAB, DVB-T), die durch Mantelwellen hervorgerufen werden, ist anstelle einer Mantelwellendrossel alternativ ...',0,1,0,0,'');
INSERT INTO question VALUES(3161,'AJ114','Die Einfügedämpfung im Durchlassbereich eines passiven Hochpassfilters für ein Fernsehantennenkabel sollte ...',0,1,0,0,'');
INSERT INTO question VALUES(3162,'AJ113','In der Nähe eines 144 MHz-Senders befindet sich die passive Antenne eines DVB-T2-Fernsehempfängers. Es kommt zu einer Übersteuerung des Empfängers. Das Problem lässt sich durch den Einbau eines ...',0,1,0,0,'');
INSERT INTO question VALUES(3163,'AJ112','Welche Filter sollten im Störungsfall vor die einzelnen Leitungsanschlüsse eines UKW-, DAB- und TV-Empfängers oder anderer angeschlossener Geräte eingeschleift werden, um Kurzwellensignale zu dämpfen?',0,1,0,0,'');
INSERT INTO question VALUES(3164,'AJ111','Wie können sich störende Beeinflussungen in digitalen Rundfunkempfängern (DAB+) äußern?',0,1,0,0,'');
INSERT INTO question VALUES(3165,'AJ110','Das Sendesignal eines VHF-Senders verursacht Empfangsstörungen in einem benachbarten DAB-Radio. Ein möglicher Grund hierfür ist ...',0,1,0,0,'');
INSERT INTO question VALUES(3166,'AJ109','Ein SSB-Sender bei 432,2 MHz erzeugt an einer Richtantenne, welche unmittelbar auf die DVB-T2-Fernsehantenne des Nachbarn gerichtet ist, eine effektive Strahlungsleistung von 1,8 kW ERP. Dies führt gegebenenfalls ...',0,1,0,0,'');
INSERT INTO question VALUES(3167,'AJ108','Ein unselektiver TV-Antennen-Verstärker wird am wahrscheinlichsten ...',0,1,0,0,'');
INSERT INTO question VALUES(3168,'AJ107','Welche Modulationsverfahren haben das größte Potenzial, einen NF-Verstärker zu beeinflussen, der eine unzureichende Störfestigkeit aufweist?',0,1,0,0,'');
INSERT INTO question VALUES(3169,'AJ106','In einem NF-Verstärker erfolgt die unerwünschte Gleichrichtung eines HF-Signals überwiegend ...',0,1,0,0,'');
INSERT INTO question VALUES(3170,'AJ105','Ein starkes HF-Signal gelangt unmittelbar in die ZF-Stufe des Rundfunkempfängers des Nachbarn. Dieses Phänomen wird als ...',0,1,0,0,'');
INSERT INTO question VALUES(3171,'AJ104','Um die Möglichkeit unerwünschter Abstrahlungen mit Hilfe eines angepassten Antennensystems zu verringern, empfiehlt es sich ...',0,1,0,0,'');
INSERT INTO question VALUES(3172,'AJ103','Beim Betrieb eines digitalen Eigenbau-Funkempfängers ist dessen Empfang erheblich beeinträchtigt. Dies kann verbessert werden, indem die Leiterplatte ...',0,1,0,0,'');
INSERT INTO question VALUES(3173,'AJ102','Eine wirksame HF-Erdung sollte im genutzten Frequenzbereich ...',0,1,0,0,'');
INSERT INTO question VALUES(3174,'AJ101','Um die Wahrscheinlichkeit zu verringern, andere Stationen zu stören, sollte die benutzte Sendeleistung ...',0,1,0,0,'');
INSERT INTO question VALUES(3201,'AJ225','Was gilt beim Sendebetrieb für unerwünschte Aussendungen im Frequenzbereich zwischen 50 und 1000 MHz? Sofern die Leistung einer unerwünschten Aussendung ...',0,1,0,0,'');
INSERT INTO question VALUES(3202,'AJ224','Was gilt beim Sendebetrieb für unerwünschte Aussendungen im Frequenzbereich zwischen 1,7 und 35 MHz? Sofern die Leistung einer unerwünschten Aussendung ...',0,1,0,0,'');
INSERT INTO question VALUES(3203,'AJ223','Wenn der Stromversorgung einer HF-Endstufe NF-Signale überlagert sind, kann dies eine (zusätzliche) unerwünschte Modulation der Sendefrequenz erzeugen. Um welche unerwünschte Modulation handelt es sich?',0,1,0,0,'');
INSERT INTO question VALUES(3204,'AJ222','Durch Addition eines Störsignals zur Versorgungsspannung der Senderendstufe wird ...',0,1,0,0,'');
INSERT INTO question VALUES(3205,'AJ221','In den nachfolgenden Bildern sind mögliche Signalverläufe des Senderausgangssignals bei der CW-Tastung dargestellt. Welcher Signalverlauf führt zu den geringsten Störungen?',0,1,0,0,'');
INSERT INTO question VALUES(3206,'AJ220','Diese Modulationshüllkurve eines CW-Senders sollte vermieden werden, da ...<p><img src=''AJ220_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3207,'AJ219','Was passiert, wenn bei einem SSB-Sender die Mikrofonverstärkung zu hoch eingestellt wurde?',0,1,0,0,'');
INSERT INTO question VALUES(3208,'AJ218','In welcher Arbeitspunkteinstellung darf die Endstufe eines SSB-Senders <u>nicht</u> betrieben werden?',0,1,0,0,'');
INSERT INTO question VALUES(3209,'AJ217','Wie kann man bei einem VHF-Sender mit kleiner Leistung die Entstehung parasitärer Schwingungen wirksam unterdrücken?',0,1,0,0,'');
INSERT INTO question VALUES(3210,'AJ216','Um die Gefahr von unerwünschten Eigenschwingungen in HF-Schaltungen zu verringern, ...',0,1,0,0,'');
INSERT INTO question VALUES(3211,'AJ215','Um die Wahrscheinlichkeit von Eigenschwingungen in einem Leistungsverstärker zu verringern, ...',0,1,0,0,'');
INSERT INTO question VALUES(3212,'AJ214','In HF-Schaltungen können Nebenresonanzen durch die ...',0,1,0,0,'');
INSERT INTO question VALUES(3213,'AJ213','Die Ausgangsleistungsanzeige eines HF-Verstärkers zeigt beim Abstimmen geringfügige sprunghafte Schwankungen. Sie werden möglicherweise hervorgerufen durch ...',0,1,0,0,'');
INSERT INTO question VALUES(3214,'AJ212','Parasitäre Schwingungen können Störungen hervorrufen. Man erkennt diese Schwingungen unter anderem daran, dass sie ...',0,1,0,0,'');
INSERT INTO question VALUES(3215,'AJ211','Wie wird vermieden, dass unerwünschte Mischprodukte aus dem Mischer in die Senderausgangsstufe gelangen?',0,1,0,0,'');
INSERT INTO question VALUES(3216,'AJ210','Was wird eingesetzt, um die Abstrahlung einer spezifischen Harmonischen wirkungsvoll zu begrenzen?',0,1,0,0,'');
INSERT INTO question VALUES(3217,'AJ209','Welches Filter sollte hinter einen VHF-Sender geschaltet werden, um die unerwünschte Aussendung von Subharmonischen und Harmonischen auf ein Mindestmaß zu begrenzen? ',0,1,0,0,'');
INSERT INTO question VALUES(3218,'AJ208','Die Oberschwingungen eines Einbandsenders sollen mit einem Ausgangsfilter ünterdrückt werden. Welcher Filterkurventyp wird benötigt?',0,1,0,0,'');
INSERT INTO question VALUES(3219,'AJ207','Worauf deutet die folgende Wellenform der Ausgangsspannung eines Leistungsverstärkers hin?<p><img src=''AJ207_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3220,'AJ206','Auf welchen Frequenzen kann ein 144,300 MHz SSB-Sendesignal Störungen verursachen?',0,1,0,0,'');
INSERT INTO question VALUES(3221,'AJ205','Die zweite ungeradzahlige Harmonische der Frequenz 144,690 MHz ist ...',0,1,0,0,'');
INSERT INTO question VALUES(3222,'AJ204','Die dritte Harmonische einer 29,5 MHz-Aussendung fällt in ...',0,1,0,0,'');
INSERT INTO question VALUES(3223,'AJ203','Auf welche Frequenz müsste ein Empfänger eingestellt werden, um die dritte Oberwelle einer 7,20 MHz-Aussendung erkennen zu können?',0,1,0,0,'');
INSERT INTO question VALUES(3224,'AJ202','Auf welche Frequenz müsste ein Empfänger eingestellt werden, um die dritte Harmonische einer nahen 7,050 MHz-Aussendung erkennen zu können?',0,1,0,0,'');
INSERT INTO question VALUES(3225,'AJ201','Die zweite Harmonische der Frequenz 3,730 MHz befindet sich auf ...',0,1,0,0,'');
INSERT INTO question VALUES(3249,'AK115','Eine Amateurfunkstelle sendet in FM mit einer äquivalenten Strahlungsleistung (ERP) von 100 W. Wie groß ist die Feldstärke im freien Raum in einer Entfernung von 100 m?',0,1,0,0,'');
INSERT INTO question VALUES(3250,'AK114','Eine vertikale Dipol-Antenne wird mit 10 W Sendeleistung im 70 cm-Band direkt gespeist. Welche elektrische Feldstärke ergibt sich bei Freiraumausbreitung in 10 m Entfernung in etwa?',0,1,0,0,'');
INSERT INTO question VALUES(3251,'AK113','Eine Yagi-Uda-Antenne mit 12,15 dBi Antennengewinn wird mit 250 W Sendeleistung im 2 m-Band direkt gespeist. Welche elektrische Feldstärke ergibt sich bei Freiraumausbreitung in 30 m Entfernung in etwa?',0,1,0,0,'');
INSERT INTO question VALUES(3252,'AK112','Sie möchten den Personenschutz-Sicherheitsabstand für das 13 cm-Band und das Modulationsverfahren FM berechnen. Der Grenzwert im Fall des Personenschutzes beträgt 61 V/m. Sie betreiben einen Parabolspiegel mit einem Gewinn von 18 dBd. Die Antenne wird von einem Sender mit einer Leistung von 40 W über ein PE-Schaum-Massivschirm-Kabel mit einer Dämpfung von 2 dB gespeist. Wie groß muss der Personenschutz-Sicherheitsabstand in Hauptstrahlrichtung sein?',0,1,0,0,'');
INSERT INTO question VALUES(3253,'AK111','Sie möchten den Personenschutz-Sicherheitsabstand für die Antenne Ihrer Amateurfunkstelle für das 2 m-Band und das Modulationsverfahren FM berechnen. Der Grenzwert im Fall des Personenschutzes beträgt 28 V/m. Sie betreiben eine Yagi-Uda-Antenne mit einem Gewinn von 10,5 dBd. Die Antenne wird von einem Sender mit einer Leistung von 100 W über ein Koaxialkabel gespeist. Die Kabeldämpfung beträgt 1,5 dB. Wie groß ist der Sicherheitsabstand?',0,1,0,0,'');
INSERT INTO question VALUES(3254,'AK110','Sie möchten den Personenschutz-Sicherheitsabstand für die Antenne Ihrer Amateurfunkstelle in Hauptstrahlrichtung für das 2 m-Band und die Modulationsverfahren FM berechnen. Der Grenzwert im Fall des Personenschutzes beträgt 28 V/m. Sie betreiben eine Yagi-Uda-Antenne mit einem Gewinn von <img src=''texrender_question_3254_AK110_0.svg''>dBd. Die Antenne wird von einem Sender mit einer Leistung von 75 W über ein Koaxialkabel gespeist. Die Kabeldämpfung beträgt 1,5 dB. Wie groß muss der Sicherheitsabstand sein?',0,1,0,0,'');
INSERT INTO question VALUES(3255,'AK109','Sie möchten den Personenschutz-Sicherheitsabstand für die Antenne Ihrer Amateurfunkstelle für das 20 m-Band und das Übertragungsverfahren RTTY berechnen. Der Grenzwert im Fall des Personenschutzes beträgt 28 V/m. Sie betreiben einen Dipol, der von einem Sender mit einer Leistung von 700 W über ein Koaxialkabel gespeist wird. Die Kabeldämpfung beträgt 0,5 dB. Wie groß ist der Sicherheitsabstand?',0,1,0,0,'');
INSERT INTO question VALUES(3256,'AK108','Sie möchten den Personenschutz-Sicherheitsabstand für die Antenne Ihrer Amateurfunkstelle für das 20 m-Band und das Übertragungsverfahren RTTY berechnen. Der Grenzwert im Fall des Personenschutzes beträgt 28 V/m. Sie betreiben einen Dipol, der von einem Sender mit einer Leistung von 300 W über ein Koaxialkabel gespeist wird. Die Kabeldämpfung beträgt 0,5 dB. Wie groß ist der Sicherheitsabstand?',0,1,0,0,'');
INSERT INTO question VALUES(3257,'AK107','Sie betreiben eine Amateurfunkstelle auf dem 2 m-Band im Modulationsverfahren FM mit einer Rundstrahlantenne mit 6 dB Gewinn bezogen auf einen Dipol. Wie hoch darf die maximale Ausgangsleistung Ihres Senders unter Vernachlässigung der Kabeldämpfung sein, wenn der Grenzwert für den Personenschutz 28 Volt/m und der zur Verfügung stehende Sicherheitsabstand 5 m beträgt?',0,1,0,0,'');
INSERT INTO question VALUES(3258,'AK106','Sie möchten den Personenschutz-Sicherheitsabstand für die Antenne Ihrer Amateurfunkstelle für das 10 m-Band und das Übertragungsverfahren RTTY berechnen. Der Grenzwert im Fall des Personenschutzes beträgt 28 V/m. Sie betreiben einen Dipol, der von einem Sender mit einer Leistung von 100 W über ein Koaxialkabel gespeist wird. Die Kabeldämpfung sei vernachlässigbar. Wie groß muss der Sicherheitsabstand sein?',0,1,0,0,'');
INSERT INTO question VALUES(3259,'AK105','An der Spitze Ihres Antennenmastes befindet sich eine Yagi-Uda-Antenne, deren Sicherheitsabstand in Hauptstrahlrichtung 20 m beträgt. Schräg unterhalb dieser Antenne befindet sich ein nicht kontrollierbarer Bereich. Sie ermitteln einen kritischen Winkel von 40 °. Das vertikale Strahlungsdiagramm der Antenne weist bei diesem Winkel eine Dämpfung von 6 dB auf. Auf welchen Wert verringert sich dann rechnerisch der Sicherheitsabstand bei 40 °?',0,1,0,0,'');
INSERT INTO question VALUES(3260,'AK104','Wie errechnen Sie die Leistung am Einspeisepunkt der Antenne (Antenneneingangsleistung) bei bekannter Senderausgangsleistung?',0,1,0,0,'');
INSERT INTO question VALUES(3261,'AK103','In welchem Fall hat die folgende Formel zur Berechnung des Sicherheitsabstandes Gültigkeit und was sollten Sie tun, wenn die Gültigkeit nicht mehr sichergestellt ist? \[d = \frac{\sqrt{30 Ohm\cdot P_{\textrm{EIRP}}}}{E}\]',0,1,0,0,'');
INSERT INTO question VALUES(3262,'AK102','Durch welche Größe sind Beträge der elektrischen und magnetischen Feldstärke eines elektromagnetischen Feldes im Fernfeld miteinander verknüpft?',0,1,0,0,'');
INSERT INTO question VALUES(3263,'AK101','Warum ist im Nahfeld einer Strahlungsquelle keine einfache Umrechnung zwischen den Feldgrößen E und H und damit auch keine vereinfachte Berechnung des Schutzabstandes möglich?',0,1,0,0,'');
INSERT INTO question VALUES(3273,'AK204','Ab welchen Sendeleistungen kann an Sendeantennen Verletzungsgefahr durch hochfrequente Spannungen bestehen?',0,1,0,0,'');
INSERT INTO question VALUES(3274,'AK203','Ihr 400 W-Kurzwellensender ist über eine separate Erdungsleitung mit dem Potentialausgleich Ihres Hauses verbunden. Im Sendebetrieb stellen Sie fest, dass auf bestimmten Bändern das Gehäuse des Senders "heiß" ist, d. h. Hochfrequenzspannung merklicher Amplitude auf dem Gerätegehäuse liegt. Was kann die Ursache hierfür sein?',0,1,0,0,'');
INSERT INTO question VALUES(3275,'AK202','Warum ist eine möglichst niederohmige Verbindung aller Potentialausgleichsanschlüsse der Geräte einer Amateurfunkstelle anzustreben?',0,1,0,0,'');
INSERT INTO question VALUES(3276,'AK201','Bei der Fehlersuche in einer defekten Senderendstufe sollte vor Beginn von Reparaturarbeiten aus Sicherheitsgründen das Gerät vom Netz getrennt werden und die Netzteilkondensatoren ...',0,1,0,0,'');
INSERT INTO question VALUES(3299,'BA110','Wie wird das Rufzeichen "IG9/DL4HR" mit dem internationalen Buchstabieralphabet  buchstabiert?',0,1,0,0,'');
INSERT INTO question VALUES(3300,'BA109','Wie wird das Rufzeichen "DO9XJZ" mit dem internationalen Buchstabieralphabet  buchstabiert?',0,1,0,0,'');
INSERT INTO question VALUES(3301,'BA108','Wie wird das Rufzeichen "DN9STV" mit dem internationalen Buchstabieralphabet  buchstabiert?',0,1,0,0,'');
INSERT INTO question VALUES(3302,'BA107','Wie wird das Rufzeichen "DN9RO/p" mit dem internationalen Buchstabieralphabet  buchstabiert?',0,1,0,0,'');
INSERT INTO question VALUES(3303,'BA106','Wie wird das Rufzeichen "DM4EAX" mit dem internationalen Buchstabieralphabet  buchstabiert?',0,1,0,0,'');
INSERT INTO question VALUES(3304,'BA105','Wie wird das Rufzeichen "DL4YBZ" mit dem internationalen Buchstabieralphabet  buchstabiert?',0,1,0,0,'');
INSERT INTO question VALUES(3305,'BA104','Wie wird das Rufzeichen "DL1FLO" mit dem internationalen Buchstabieralphabet  buchstabiert?',0,1,0,0,'');
INSERT INTO question VALUES(3306,'BA103','Wie wird das Rufzeichen "DK5WP" mit dem internationalen Buchstabieralphabet  buchstabiert?',0,1,0,0,'');
INSERT INTO question VALUES(3307,'BA102','Wie wird das Rufzeichen "DK1KC" mit dem internationalen Buchstabieralphabet  buchstabiert?',0,1,0,0,'');
INSERT INTO question VALUES(3308,'BA101','Wie wird das Rufzeichen "DD4UQ" mit dem internationalen Buchstabieralphabet  buchstabiert?',0,1,0,0,'');
INSERT INTO question VALUES(3309,'BB110','Was bedeutet "R" am Anfang eines Durchgangs in Telegrafie?',0,1,0,0,'');
INSERT INTO question VALUES(3310,'BB109','Was bedeutet "K" am Ende eines Durchgangs in Telegrafie?',0,1,0,0,'');
INSERT INTO question VALUES(3311,'BB108','Was bedeutet die Betriebsabkürzung "BK" in Telegrafie?',0,1,0,0,'');
INSERT INTO question VALUES(3312,'BB107','Was bedeutet die Abkürzung "CW" im Amateurfunk?',0,1,0,0,'');
INSERT INTO question VALUES(3313,'BB106','Was bedeuten die Abkürzungen "TX", "RX", "TRX" in dieser Reihenfolge?',0,1,0,0,'');
INSERT INTO question VALUES(3314,'BB105','Eine Station ruft in der Nacht auf 3790 kHz "CQ DX". Wer soll antworten? Nur Stationen ...',0,1,0,0,'');
INSERT INTO question VALUES(3315,'BB104','Eine Station ruft auf VHF/UHF "CQ DX". Wer soll antworten?',0,1,0,0,'');
INSERT INTO question VALUES(3316,'BB103','Was bedeutet die betriebliche Abkürzung DX?',0,1,0,0,'');
INSERT INTO question VALUES(3317,'BB102','Was bedeutet die betriebliche Abkürzung "CQ" im Amateurfunk?',0,1,0,0,'');
INSERT INTO question VALUES(3318,'BB101','Warum werden insbesondere in der Telegrafie (z. B. CW, JS8, RTTY) betriebliche Abkürzungen und Q-Gruppen verwendet?',0,1,0,0,'');
INSERT INTO question VALUES(3319,'BB206','Wie verhalten Sie sich, wenn Sie "PSE QSY ..." aufnehmen?',0,1,0,0,'');
INSERT INTO question VALUES(3320,'BB205','Wie verhalten Sie sich, wenn Sie "PSE QRP" aufnehmen?',0,1,0,0,'');
INSERT INTO question VALUES(3321,'BB204','Was bedeuten die Q-Gruppen "QRV", "QRM?" und "QTH"?',0,1,0,0,'');
INSERT INTO question VALUES(3322,'BB203','Was bedeuten die Q-Gruppen "QRT", "QRZ?" und "QSL?"?',0,1,0,0,'');
INSERT INTO question VALUES(3323,'BB202','Was bedeuten die Q-Gruppen "QRO?", "QSO?" und "QRX?"?',0,1,0,0,'');
INSERT INTO question VALUES(3324,'BB201','Was bedeuten die Q-Gruppen "QRM", "QRN" und "QSB?"?',0,1,0,0,'');
INSERT INTO question VALUES(3325,'BC106','Wie wird der Frequenzbereich zwischen 300 bis 3000 MHz bezeichnet?',0,1,0,0,'');
INSERT INTO question VALUES(3326,'BC105','Wie wird der Frequenzbereich zwischen 30 bis 300 MHz bezeichnet?',0,1,0,0,'');
INSERT INTO question VALUES(3327,'BC104','Wie wird der Frequenzbereich von 3 bis 30 MHz bezeichnet?',0,1,0,0,'');
INSERT INTO question VALUES(3328,'BC103','Wie wird der Frequenzbereich bezeichnet, in dem sich das 70 cm-Band befindet?',0,1,0,0,'');
INSERT INTO question VALUES(3329,'BC102','Wie wird der Frequenzbereich bezeichnet, in dem sich das 2 m-Band befindet?',0,1,0,0,'');
INSERT INTO question VALUES(3330,'BC101','Wie wird der Frequenzbereich bezeichnet, in dem sich das 10 m-Band befindet?',0,1,0,0,'');
INSERT INTO question VALUES(3331,'BC222','Warum sollten Sie auf 439,200 MHz <u>keine</u> Direktverbindung in FM-Telefonie zu einem Funkamateur aufnehmen, der sich im Nachbarort befindet? Der IARU-Bandplan empfiehlt diesen Bereich für die Nutzung durch ...',0,1,0,0,'');
INSERT INTO question VALUES(3332,'BC221','Warum sollten Sie auf 435,500 MHz <u>keine</u> Direktverbindung in FM-Telefonie zu einem Funkamateur aufnehmen, der sich im Nachbarort befindet? Der IARU-Bandplan empfiehlt diesen Bereich für die Nutzung durch ...',0,1,0,0,'');
INSERT INTO question VALUES(3333,'BC220','Warum sollten Sie auf 432,450 MHz <u>keine</u> Direktverbindung in FM-Telefonie zu einem Funkamateur aufnehmen, der sich im Nachbarort befindet? Der IARU-Bandplan empfiehlt diesen Bereich exklusiv für die Nutzung durch ...',0,1,0,0,'');
INSERT INTO question VALUES(3334,'BC219','Warum sollten Sie auf 432,040 MHz <u>keine</u> Direktverbindung in FM-Telefonie zu einem Funkamateur aufnehmen, der sich im Nachbarort befindet? Der IARU-Bandplan empfiehlt diesen Bereich für die Nutzung durch ...',0,1,0,0,'');
INSERT INTO question VALUES(3335,'BC218','Warum sollten Sie auf 145,800 MHz <u>keine</u> Direktverbindung in FM-Telefonie zu einem Funkamateur aufnehmen, der sich im Nachbarort befindet? Der IARU-Bandplan empfiehlt diesen Bereich für die Nutzung durch ...',0,1,0,0,'');
INSERT INTO question VALUES(3336,'BC217','Warum sollten Sie auf 145,600 MHz <u>keine</u> Direktverbindung in FM-Telefonie zu einem Funkamateur aufnehmen, der sich im Nachbarort befindet? Der IARU-Bandplan empfiehlt diesen Bereich für die Nutzung durch ...',0,1,0,0,'');
INSERT INTO question VALUES(3337,'BC216','Warum sollten Sie bei FM-Telefonie auf 145,525 MHz darauf achten, ihr Funkgerät auf Schmalband-FM (Narrow FM) einzustellen? Der IARU-Bandplan empfiehlt ...',0,1,0,0,'');
INSERT INTO question VALUES(3338,'BC215','Warum sollten Sie auf 144,450 MHz <u>keine</u> Direktverbindung in FM-Telefonie zu einem Funkamateur aufnehmen, der sich im Nachbarort befindet? Der IARU-Bandplan sieht diesen Bereich exklusiv für die Nutzung durch ...',0,1,0,0,'');
INSERT INTO question VALUES(3339,'BC214','Warum sollten Sie auf 144,125 MHz <u>keine</u> Direktverbindung in FM-Telefonie zu einem Funkamateur aufnehmen, der sich im Nachbarort befindet? Der IARU-Bandplan empfiehlt diesen Bereich für die Nutzung durch ...',0,1,0,0,'');
INSERT INTO question VALUES(3340,'BC213','Warum sollten Sie RTTY, PSK31 oder FT8 <u>nicht</u> auf 144,075 MHz  verwenden? Der IARU-Bandplan empfiehlt ...',0,1,0,0,'');
INSERT INTO question VALUES(3341,'BC212','Welche Frequenz bzw. welchen Frequenzbereich sieht der IARU-Bandplan als Aktivitätszentrum für SSB-Telefonie im 70 cm-Band vor?',0,1,0,0,'');
INSERT INTO question VALUES(3342,'BC211','Welche Frequenz bzw. welchen Frequenzbereich sieht der IARU-Bandplan als Aktivitätszentrum für SSB-Telefonie im 2 m-Band vor?',0,1,0,0,'');
INSERT INTO question VALUES(3343,'BC210','Auf welcher der folgenden Frequenzen könnten Sie unter Berücksichtigung des IARU-Bandplans im 2 m-Band eine SSB-Telefonieverbindung beispielsweise durchführen?',0,1,0,0,'');
INSERT INTO question VALUES(3344,'BC209','Auf welcher der folgenden Frequenzen könnten Sie beispielsweise unter Berücksichtigung des IARU-Bandplans im 2 m-Band eine FM-Telefonieverbindung durchführen?',0,1,0,0,'');
INSERT INTO question VALUES(3345,'BC208','Welche Frequenz empfiehlt der IARU-Bandplan für einen allgemeinen Anruf mit digitaler Telefonie im 70 cm-Band?',0,1,0,0,'');
INSERT INTO question VALUES(3346,'BC207','Welche Frequenz empfiehlt der IARU-Bandplan für einen allgemeinen Anruf mit digitaler Telefonie im 2 m-Band?',0,1,0,0,'');
INSERT INTO question VALUES(3347,'BC206','Welche Frequenz empfiehlt der IARU-Bandplan für einen allgemeinen Anruf mit analoger FM-Telefonie im 70 cm-Band?',0,1,0,0,'');
INSERT INTO question VALUES(3348,'BC205','Welche Frequenz empfiehlt der IARU-Bandplan für einen allgemeinen Anruf mit analoger FM-Telefonie im 2 m-Band?',0,1,0,0,'');
INSERT INTO question VALUES(3349,'BC204','In welchem Bereich der Amateurfunkbänder empfiehlt der IARU-Bandplan üblicherweise die Nutzung von Morsetelegrafie?',0,1,0,0,'');
INSERT INTO question VALUES(3350,'BC203','Welches Seitenband wird bei SSB-Telefonie nach Empfehlung der IARU im 20 m-Band in der Regel benutzt?',0,1,0,0,'');
INSERT INTO question VALUES(3351,'BC202','Welches Seitenband wird bei SSB-Telefonie nach IARU-Empfehlung im 80 m-Band in der Regel benutzt?',0,1,0,0,'');
INSERT INTO question VALUES(3352,'BC201','Wie verbindlich sind die Bandpläne der IARU?',0,1,0,0,'');
INSERT INTO question VALUES(3353,'BD109','Welche Kennungen werden von leistungsschwachen Amateurfunksendern zu Peilzwecken ausgesendet?',0,1,0,0,'');
INSERT INTO question VALUES(3354,'BD108','Sie hören die Station DP0POL. Um welche Art von Amateurfunkstelle handelt es sich? Es handelt sich um eine Amateurfunkstelle ...',0,1,0,0,'');
INSERT INTO question VALUES(3355,'BD107','Sie hören die Station DP0GVN. Um welche Art von Amateurfunkstelle handelt es sich? Es handelt sich um eine ...',0,1,0,0,'');
INSERT INTO question VALUES(3356,'BD106','Zu welcher Rufzeichenart gehören Rufzeichen, die mit DO1 bis DO9 beginnen und ein zwei- oder dreistelliges Suffix haben? Personengebundene Rufzeichen der ...',0,1,0,0,'');
INSERT INTO question VALUES(3357,'BD105','Zu welcher Rufzeichenart gehören Rufzeichen, die mit DN9 beginnen?',0,1,0,0,'');
INSERT INTO question VALUES(3358,'BD104','Zu welcher Rufzeichenart gehören Rufzeichen, die mit DL1 bis DL9 beginnen und ein zwei- oder dreistelliges Suffix haben? Personengebundene Rufzeichen der ...',0,1,0,0,'');
INSERT INTO question VALUES(3359,'BD103','Sie hören in einem Contest die Station DL0XK. Um welche Art von Amateurfunkstelle handelt es sich? Es handelt sich um eine Amateurfunkstelle ...',0,1,0,0,'');
INSERT INTO question VALUES(3360,'BD102','Sie hören die Station DA5XX. Um welche Art von Amateurfunkstelle handelt es sich? Es handelt sich um eine ...',0,1,0,0,'');
INSERT INTO question VALUES(3361,'BD101','Sie hören die Station DA0ABC. Um welche Art von Amateurfunkstelle handelt es sich? Es handelt sich um eine ...',0,1,0,0,'');
INSERT INTO question VALUES(3362,'BD214','Wie muss die Rufzeichennennung von DL9MJ bei der Nutzung der "CEPT-Amateurfunkgenehmigung" in der Schweiz erfolgen?',0,1,0,0,'');
INSERT INTO question VALUES(3363,'BD213','Wie muss die Rufzeichennennung von DO7PR bei der Nutzung der "CEPT-Novice-Amateurfunkgenehmigung" in der Schweiz erfolgen?',0,1,0,0,'');
INSERT INTO question VALUES(3364,'BD212','Sie hören die Amateurfunkstation mit dem Rufzeichen DL/G3MM. Welcher der nachfolgenden Sachverhalte trifft zu?',0,1,0,0,'');
INSERT INTO question VALUES(3365,'BD211','DG2RON führt Ausbildungsfunkbetrieb in Morsetelegrafie oder mit digitalen Übertragungsverfahren durch. Welches Rufzeichen hat der Auzubildende zu verwenden?',0,1,0,0,'');
INSERT INTO question VALUES(3366,'BD210','An der Klubstation DL0MOL soll Ausbildungsfunkbetrieb stattfinden. Darf der Auszubildende das Rufzeichen der Klubstation verwenden?',0,1,0,0,'');
INSERT INTO question VALUES(3367,'BD209','Der Funkamateur mit dem Rufzeichen DL1PZ möchte Ausbildungsfunkbetrieb im Sprechfunk durchführen. Welches Rufzeichen darf der Auszubildende verwenden?',0,1,0,0,'');
INSERT INTO question VALUES(3368,'BD208','Welcher Rufzeichenzusatz kann verwendet werden, um "Remote-Betrieb" zu kennzeichnen?',0,1,0,0,'');
INSERT INTO question VALUES(3369,'BD207','Muss beim Betrieb einer tragbaren oder vorübergehend ortsfest betriebenen Amateurfunkstelle in Deutschland dem Rufzeichen der Zusatz "/p" hinzugefügt werden?',0,1,0,0,'');
INSERT INTO question VALUES(3370,'BD206','Was bedeutet der Rufzeichenzusatz "/p"? Es bedeutet, dass die Amateurfunkstelle ...',0,1,0,0,'');
INSERT INTO question VALUES(3371,'BD205','Was ist aus dem Rufzeichen DC4LW/mm hinsichtlich des Betriebsortes zu erkennen? Die deutsche Amateurfunkstelle DC4LW ...',0,1,0,0,'');
INSERT INTO question VALUES(3372,'BD204','Ein Rufzeichen mit dem Zusatz "/m" kann bei einer Amateurfunkstelle bedeuten, dass sie ...',0,1,0,0,'');
INSERT INTO question VALUES(3373,'BD203','Ein Rufzeichen mit dem Zusatz "/m" kann bei einer Amateurfunkstelle bedeuten, dass sie ...',0,1,0,0,'');
INSERT INTO question VALUES(3374,'BD202','Welche Bedeutung hat das Rufzeichen VE8ZZ/am?',0,1,0,0,'');
INSERT INTO question VALUES(3375,'BD201','Was bedeutet der Rufzeichenzusatz "/am"? Die Amateurfunkstelle ...',0,1,0,0,'');
INSERT INTO question VALUES(3376,'BD318','Welche Landeskenner sind asiatischen Ländern zugewiesen?',0,1,0,0,'');
INSERT INTO question VALUES(3377,'BD317','Welche Landeskenner sind südamerikanischen Ländern zugewiesen?',0,1,0,0,'');
INSERT INTO question VALUES(3378,'BD316','Welche drei Landeskenner sind einem einzigen Kontinent zuzuordnen?',0,1,0,0,'');
INSERT INTO question VALUES(3379,'BD315','Welche Antwort gibt ausschließlich Rufzeichen aus den Vereinigten Staaten (USA) wieder?',0,1,0,0,'');
INSERT INTO question VALUES(3380,'BD314','Welche Antwort enthält nur Landeskenner von Ländern, die an die Bundesrepublik Deutschland grenzen?',0,1,0,0,'');
INSERT INTO question VALUES(3381,'BD313','Welche Gruppe gibt Landeskenner der Länder China, Kanada und Australien für ihre Amateurfunkstellen richtig wieder?',0,1,0,0,'');
INSERT INTO question VALUES(3382,'BD312','Welche Gruppe gibt Landeskenner der Länder USA, Neuseeland und Argentinien für ihre Amateurfunkstellen richtig wieder?',0,1,0,0,'');
INSERT INTO question VALUES(3383,'BD311','Welche Gruppe gibt die Landeskenner der Länder Spanien, Luxemburg und Polen für ihre Amateurfunkstellen richtig wieder?',0,1,0,0,'');
INSERT INTO question VALUES(3384,'BD310','Welche Gruppe gibt die Landeskenner der Länder Schweiz, Spanien und Belgien für ihre Amateurfunkstellen richtig wieder?',0,1,0,0,'');
INSERT INTO question VALUES(3385,'BD309','Welche Länder sind der Reihe nach den folgenden Landeskennern zugeordnet? Die Landeskenner VE, VK und PY entsprechen den Ländern ...',0,1,0,0,'');
INSERT INTO question VALUES(3386,'BD308','Welche Länder sind der Reihe nach den folgenden Landeskennern zugeordnet? Die Landeskenner EA, EI, EK, EM, ES entsprechen den Ländern ...',0,1,0,0,'');
INSERT INTO question VALUES(3387,'BD307','Welche Länder (Gebiete) sind der Reihe nach den folgenden Landeskennern zugeordnet? Die Landeskenner 4X, F und OZ entsprechen den Ländern (Gebieten) ...',0,1,0,0,'');
INSERT INTO question VALUES(3388,'BD306','Welche Länder sind der Reihe nach den folgenden Landeskennern zugeordnet? Die Landeskenner SM, SP und ZS entsprechen den Ländern ...',0,1,0,0,'');
INSERT INTO question VALUES(3389,'BD305','Welche Länder sind der Reihe nach den folgenden Landeskennern zugeordnet? Die Landeskenner F, PA und SP entsprechen den Ländern ...',0,1,0,0,'');
INSERT INTO question VALUES(3390,'BD304','Welche Landeskenner sind der Reihe nach den folgenden Ländern zugeordnet? Die Landeskenner OE, PA, und SM entsprechen den Ländern ...',0,1,0,0,'');
INSERT INTO question VALUES(3391,'BD303','Welche Länder sind der Reihe nach den folgenden Landeskennern zugeordnet? Die Landeskenner OE, ON und OK entsprechen den Ländern ...',0,1,0,0,'');
INSERT INTO question VALUES(3392,'BD302','Welchem Land bzw. welchen Ländern sind die Landeskenner DA bis DZ zugeordnet?',0,1,0,0,'');
INSERT INTO question VALUES(3393,'BD301','Wo können Sie nachschlagen, in welchem Land sich eine Amateurfunkstelle mit einem Ihnen bislang unbekannten Landeskenner befindet?',0,1,0,0,'');
INSERT INTO question VALUES(3394,'BE118','Was sollten Sie hinsichtlich der Geschwindigkeit bei Morsetelegrafie beachten? Ich gebe in der Regel ...',0,1,0,0,'');
INSERT INTO question VALUES(3395,'BE117','Mit welcher Geschwindigkeit sollten Sie einen Anruf in Morsetelegrafie beantworten? In der Regel antworte ich ...',0,1,0,0,'');
INSERT INTO question VALUES(3396,'BE116','Sie hören in Telegrafie "CQ FD DD4UQ/P TEST". Was bedeutet das? Die Station DD4UQ ...',0,1,0,0,'');
INSERT INTO question VALUES(3397,'BE115','Was bedeutet die Betriebsabkürzung "QRZ?" im Amateurfunk?',0,1,0,0,'');
INSERT INTO question VALUES(3398,'BE114','Was bedeutet der im 20 m-Band gesendete Anruf "CQ DX CQ DX DE HB9AFN HB9AFN K"? HB9AFN sucht eine Verbindung mit ...',0,1,0,0,'');
INSERT INTO question VALUES(3399,'BE113','N4EAX ruft in Telegrafie: "CQ DL CQ DL DE N4EAX N4EAX PSE K". Was beabsichtigt die Amateurfunkstelle damit?',0,1,0,0,'');
INSERT INTO question VALUES(3400,'BE112','Wie gestalten Sie beispielsweise als "DL2AB" einen allgemeinen Anruf in Telegrafie?',0,1,0,0,'');
INSERT INTO question VALUES(3401,'BE111','Was ist der Maidenhead-Locator (auch: QTH-Locator oder Standortkenner)?',0,1,0,0,'');
INSERT INTO question VALUES(3402,'BE110','Sie hören 4U1ITU in Telefonie rufen: "CQ VK/ZL this is 4U1ITU". Sollten Sie 4U1ITU anrufen, wenn Sie gerne ein QSO mit der Station führen würden?',0,1,0,0,'');
INSERT INTO question VALUES(3403,'BE109','Eine Station ruft auf dem 2 m- oder dem 70 cm-Band "CQ" mit dem Zusatz "DX". Wann sollten Sie antworten?',0,1,0,0,'');
INSERT INTO question VALUES(3404,'BE108','Sie haben eine Funkverbindung mit einer vorher "CQ" rufenden Station beendet. Anschließend werden Sie von einer anderen Station gerufen. Wie verhalten Sie sich?',0,1,0,0,'');
INSERT INTO question VALUES(3405,'BE107','Sie tätigen einen allgemeinen Anruf in Telefonie auf 145,500 MHz. Dieser wird von einer Gegenstation beantwortet. Wie sollten Sie das darauffolgende Funkgespräch fortsetzen? Ich fasse mich kurz und schlage ...',0,1,0,0,'');
INSERT INTO question VALUES(3406,'BE106','Eine Frequenz auf einem höheren Kurzwellenband erscheint zunächst frei, stellt sich aber anschließend als besetzt heraus. Was ist die häufigste Ursache dafür?',0,1,0,0,'');
INSERT INTO question VALUES(3407,'BE105','Sie möchten einen Allgemeinen Anruf in Telefonie im 10 m-Band beginnen. Sie finden eine Frequenz, auf der Sie keine Signale hören. Wie gehen Sie vor?',0,1,0,0,'');
INSERT INTO question VALUES(3408,'BE104','EA6VQ ruft in Telefonie in englischer Sprache CQ. Ihr Rufzeichen ist DF1KW. Wie könnten Sie antworten?',0,1,0,0,'');
INSERT INTO question VALUES(3409,'BE103','Ihr Rufzeichen ist DH7RW. Sie hören unvollständig "... 7 Romeo Whiskey". Wie reagieren Sie?',0,1,0,0,'');
INSERT INTO question VALUES(3410,'BE102','Wie sollten Sie antworten, wenn jemand in Telefonie CQ ruft?',0,1,0,0,'');
INSERT INTO question VALUES(3411,'BE101','Wie können Sie eine Amateurfunkverbindung zum Beispiel beginnen?',0,1,0,0,'');
INSERT INTO question VALUES(3412,'BE210','Wie teilen Sie Ihrem Funkpartner in SSTV seinen "Rapport" mit?',0,1,0,0,'');
INSERT INTO question VALUES(3413,'BE209','Sie hören in einem Funkgespräch in SSB-Telefonie die Gegenstation einwandfrei. Das Display Ihres Funkgerätes zeigt die abgebildeten Informationen an. Welchen Empfangsrapport nach dem RST-System geben Sie?<p><img src=''BE209_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3414,'BE208','Sie hören in einem Funkgespräch in SSB-Telefonie die Gegenstation einwandfrei. Das Display Ihres Funkgerätes zeigt die abgebildeten Informationen an. Welchen Empfangsrapport nach dem RST-System geben Sie?<p><img src=''BE208_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3415,'BE207','Sie hören in einem Funkgespräch in SSB-Telefonie die Gegenstation einwandfrei. Das Display Ihres Funkgerätes zeigt die abgebildeten Informationen an. Welchen Empfangsrapport nach dem RST-System geben Sie?<p><img src=''BE207_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3416,'BE206','Sie hören die Gegenstation in SSB-Telefonie einwandfrei. Das Anzeigeinstrument Ihres Funkgerätes zeigt den dargestellten Zeigerausschlag. Welchen Rapport nach dem RST-System geben Sie?<p><img src=''BE206_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3417,'BE205','Sie hören die Gegenstation in SSB-Telefonie einwandfrei. Das Anzeigeinstrument Ihres Funkgerätes zeigt den dargestellten Zeigerausschlag. Welchen Rapport nach dem RST-System geben Sie?<p><img src=''BE205_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3418,'BE204','Sie hören die Gegenstation in SSB-Telefonie einwandfrei. Das Anzeigeinstrument Ihres Funkgerätes zeigt den dargestellten Zeigerausschlag. Welchen Rapport nach dem RST-System geben Sie?<p><img src=''BE204_q.svg''>',0,1,0,0,'');
INSERT INTO question VALUES(3419,'BE203','In welcher Weise wird nach dem RST-System die Empfangsqualität einer Amateurfunkaussendung beurteilt?',0,1,0,0,'');
INSERT INTO question VALUES(3420,'BE202','Was bedeuten die Buchstaben RST, mit denen Sie die Empfangsqualität einer Sendung beurteilen können?',0,1,0,0,'');
INSERT INTO question VALUES(3421,'BE201','Was versteht man unter dem RST-Rapport? Es ist eine Kurzformel, ...',0,1,0,0,'');
INSERT INTO question VALUES(3422,'BE313','Was verstehen Funkamateure unter einer "Fuchsjagd" (ARDF = Amateur Radio Direction Finding)?',0,1,0,0,'');
INSERT INTO question VALUES(3423,'BE312','Was versteht man im Amateurfunk unter einer "DX-Pedition"?',0,1,0,0,'');
INSERT INTO question VALUES(3424,'BE311','Eine Station, die auf 14205 kHz CQ gerufen hat, sagt am Ende ihres Rufes "tuning 290 to 300 up". Welche Frequenzen nutzen Sie, wenn Sie diese Station anrufen wollen?',0,1,0,0,'');
INSERT INTO question VALUES(3425,'BE310','Eine Station gibt am Ende ihres CQ-Rufes "5 up". Was bedeutet diese Angabe und was ist zu beachten?',0,1,0,0,'');
INSERT INTO question VALUES(3426,'BE309','Was bedeutet es, wenn eine begehrte Station CQ ruft und den Anruf mit "split up 14270 to 14280" beendet? Die Station ...',0,1,0,0,'');
INSERT INTO question VALUES(3427,'BE308','Was ist "Split-Verkehr"?',0,1,0,0,'');
INSERT INTO question VALUES(3428,'BE307','Was verstehen Sie bei einer seltenen Station unter der Aufforderung zu "Listenbetrieb"?',0,1,0,0,'');
INSERT INTO question VALUES(3429,'BE306','Eine begehrte Station ruft in Telefonie "only number 3". Was ist damit gemeint? Die Station ...',0,1,0,0,'');
INSERT INTO question VALUES(3430,'BE305','Was ist mit dem Begriff "pile up" gemeint? Im Amateurfunk meint man damit das gleichzeitige ...',0,1,0,0,'');
INSERT INTO question VALUES(3431,'BE304','Welche besondere Regelung gilt in einem "Sprint-Contest"?',0,1,0,0,'');
INSERT INTO question VALUES(3432,'BE303','Sie nehmen an einem Amateurfunkwettbewerb (Contest) teil. Welche Informationen sollten Sie in einem QSO austauschen?',0,1,0,0,'');
INSERT INTO question VALUES(3433,'BE302','Warum ist der Informationsaustausch bei Verbindungen in einem Amateurfunkwettbewerb (Contest) besonders kurz?',0,1,0,0,'');
INSERT INTO question VALUES(3434,'BE301','Was ist der Zweck eines Amateurfunkwettbewerbs (Contest)? Er dient dem Wettkampf und ...',0,1,0,0,'');
INSERT INTO question VALUES(3435,'BE416','Was versteht man unter dem Transponder eines "OSCAR" und wie arbeitet er?',0,1,0,0,'');
INSERT INTO question VALUES(3436,'BE415','Wofür steht die Abkürzung OSCAR im Amateurfunk?',0,1,0,0,'');
INSERT INTO question VALUES(3437,'BE414','Was bedeutet der Begriff Elevation im Bereich der Satellitenkommunikation?',0,1,0,0,'');
INSERT INTO question VALUES(3438,'BE413','Was bedeutet der Begriff Azimut im Bereich der Satellitenkommunikation?',0,1,0,0,'');
INSERT INTO question VALUES(3439,'BE412','Was bedeutet der Begriff Downlink im Bereich der Satellitenkommunikation?',0,1,0,0,'');
INSERT INTO question VALUES(3440,'BE411','Was bedeutet der Begriff Uplink im Bereich der Satellitenkommunikation?',0,1,0,0,'');
INSERT INTO question VALUES(3441,'BE410','Weshalb sind die Frequenzen 14099 bis 14101 kHz, 18109 bis 18111 kHz, 21149 bis 21151 kHz, 24929 bis 24931 kHz und 28190 bis 28225 kHz freizuhalten?',0,1,0,0,'');
INSERT INTO question VALUES(3442,'BE409','Was ist eine häufige Anwendung von Amateurfunkbaken? Sie ...',0,1,0,0,'');
INSERT INTO question VALUES(3443,'BE408','Wie wird eine Funkverbindung beurteilt, wenn über eine Relaisfunkstelle gearbeitet wird?',0,1,0,0,'');
INSERT INTO question VALUES(3444,'BE407','Warum sollten Sie bei Nutzung eines FM-Repeaters darauf achten, Schmalband-FM (Narrow-FM) an Ihrem Handfunkgerät einzustellen? Da ansonsten ...',0,1,0,0,'');
INSERT INTO question VALUES(3445,'BE406','Warum sollten bei Relaisfunkbetrieb die Durchgänge möglichst kurz gehalten werden?',0,1,0,0,'');
INSERT INTO question VALUES(3446,'BE405','Wodurch sollte gleichzeitiges Sprechen (Doppeln) bei Nutzung eines Repeaters und in Funkrunden vermieden werden?',0,1,0,0,'');
INSERT INTO question VALUES(3447,'BE404','Wodurch sollte es Stationen erleichtert werden, sich in eine laufende Funkrunde oder ein Gespräch auf einem Repeater hereinzumelden?',0,1,0,0,'');
INSERT INTO question VALUES(3448,'BE403','Bei deutschen 70 cm-Relaisfunkstellen liegt die Eingabefrequenz üblicherweise ...',0,1,0,0,'');
INSERT INTO question VALUES(3449,'BE402','Bei deutschen 2 m-Relaisfunkstellen liegt die Eingabefrequenz üblicherweise ...',0,1,0,0,'');
INSERT INTO question VALUES(3450,'BE401','Was ist damit gemeint, wenn man sagt, die Relaisfunkstelle hat eine Eingabe- und eine Ausgabefrequenz?',0,1,0,0,'');
INSERT INTO question VALUES(3451,'BF109','Nach den Empfehlungen der International Amateur Radio Union (IARU) gibt es bei 3760, 7110, 14300, 18160 und 21360 kHz so genannte Aktivitätszentren für Notfunkverkehr. Was ist das Besondere an diesen Frequenzen? Sie sollen ...',0,1,0,0,'');
INSERT INTO question VALUES(3452,'BF108','Sie haben am 16. August (Ortsdatum) um 20:00 Uhr mitteleuropäischer Sommerzeit (MESZ) von 9J2NG eine Notfunkmeldung aufgenommen und an eine Hilfeleistungsorganisation per Telefon weitergemeldet. Die Amateurfunkstelle 9J2NG hat Sie gebeten, um 23:00 Uhr UTC erneut mit ihr in Verbindung zu treten. Welcher Zeitpunkt ist dies in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(3453,'BF107','Sie haben eine Notmeldung beantwortet und die Polizei oder Rettungsleitstelle informiert. Welches Verhalten ist im Anschluss vorbildlich?',0,1,0,0,'');
INSERT INTO question VALUES(3454,'BF106','Sie haben eine Notmeldung aufgenommen. Keine andere Funkstelle reagiert und Sie könnten helfen. Wie verhalten Sie sich?',0,1,0,0,'');
INSERT INTO question VALUES(3455,'BF105','Sie haben eine Notmeldung aufgenommen, die nach kurzer Zeit von einer Rettungsorganisation beantwortet wird. Wie verhalten Sie sich?',0,1,0,0,'');
INSERT INTO question VALUES(3456,'BF104','Sie hören eine Notmeldung. Was tun Sie als Erstes?',0,1,0,0,'');
INSERT INTO question VALUES(3457,'BF103','Sie erreichen eine Unfallstelle. Der Ersthelfer bittet Sie, über Ihre mobile Amateurfunkstelle Hilfe zu holen, da das Mobiltelefonnetz nicht verfügbar ist. Wie verhalten Sie sich?',0,1,0,0,'');
INSERT INTO question VALUES(3458,'BF102','Dürfen Sie im Notfall SOS oder Mayday innerhalb des Amateurfunks gebrauchen?',0,1,0,0,'');
INSERT INTO question VALUES(3459,'BF101','Wie heißen die internationalen Notzeichen außerhalb des Amateurfunks?',0,1,0,0,'');
INSERT INTO question VALUES(3460,'BG111','Welche Alternativen zur QSL-Karte sind üblich? Bestätigung von Funkverbindungen durch ...',0,1,0,0,'');
INSERT INTO question VALUES(3461,'BG110','Wo können Sie die Anschriften von ausländischen Funkamateuren finden, denen Sie die QSL-Karte direkt zusenden möchten?',0,1,0,0,'');
INSERT INTO question VALUES(3462,'BG109','HZ1HZ sagte Ihnen "QSL via K8PYD". Was würden Sie tun, um die QSL-Karte von HZ1HZ zu erhalten?',0,1,0,0,'');
INSERT INTO question VALUES(3463,'BG108','Welche Uhrzeit tragen Sie in die QSL-Karte ein, wenn Sie um 13:30 MESZ eine Funkverbindung hatten?',0,1,0,0,'');
INSERT INTO question VALUES(3464,'BG107','Welche Uhrzeit tragen Sie in die QSL-Karte ein, wenn Sie um 15:30 MEZ ein QSO hatten?',0,1,0,0,'');
INSERT INTO question VALUES(3465,'BG106','Was sollten Sie bei der Eintragung von Uhrzeiten in QSL-Karten beachten? Sie sollten in ...',0,1,0,0,'');
INSERT INTO question VALUES(3466,'BG105','Welche Angaben sollten QSL-Karten <u>mindestens</u> enthalten?',0,1,0,0,'');
INSERT INTO question VALUES(3467,'BG104','Eine QSL-Karte ist ...',0,1,0,0,'');
INSERT INTO question VALUES(3468,'BG103','Was ist bei angeordneter Logbuchführung bei einem Wechsel der "Logbuchsoftware" zu berücksichtigen?',0,1,0,0,'');
INSERT INTO question VALUES(3469,'BG102','Was ist bei der Erstellung eines "Computer-Logbuchs" bei angeordneter Logbuchführung zu beachten?',0,1,0,0,'');
INSERT INTO question VALUES(3470,'BG101','Was verstehen Funkamateure unter einem Logbuch?',0,1,0,0,'');
INSERT INTO question VALUES(3471,'VA104','Welche Aussage über Funkamateure enthält die Begriffsbestimmung des Amateurfunkdienstes in den Radio Regulations (RR)?',0,1,0,0,'');
INSERT INTO question VALUES(3472,'VA103','Wozu dient der Amateurfunkdienst über Satelliten nach den Begriffsbestimmung in den Radio Regulations (RR)?',0,1,0,0,'');
INSERT INTO question VALUES(3473,'VA102','Wozu dient der Amateurfunkdienst nach der Begriffsbestimmung in den Radio Regulations (RR)?',0,1,0,0,'');
INSERT INTO question VALUES(3474,'VA101','In welchem internationalen Regelwerk ist der Begriff "Amateurfunkdienst" definiert?',0,1,0,0,'');
INSERT INTO question VALUES(3475,'VA202','Wie ist die "Amateurfunkstelle" in den Radio Regulations (RR) definiert? Eine Amateurfunkstelle ist ...',0,1,0,0,'');
INSERT INTO question VALUES(3476,'VA201','Wie ist die Funkstelle in den Radio Regulations (RR) sinngemäß definiert?',0,1,0,0,'');
INSERT INTO question VALUES(3477,'VA304','Was ist in den Radio Regulations (RR) bezüglich der Morsequalifikation für Funkamateure festgelegt?',0,1,0,0,'');
INSERT INTO question VALUES(3478,'VA303','Welche Kommunikationsinhalte dürfen im internationalen Amateurfunkverkehr laut Radio Regulations (RR) zum Zwecke der Verschleierung verschlüsselt werden?',0,1,0,0,'');
INSERT INTO question VALUES(3479,'VA302','Was ist in den Radio Regulations (RR) hinsichtlich des Amateurfunkverkehrs festgelegt?',0,1,0,0,'');
INSERT INTO question VALUES(3480,'VA301','Die allgemeinen Regelungen der Radio Regulations (RR) gelten ...',0,1,0,0,'');
INSERT INTO question VALUES(3481,'VA407','In welchem internationalen Regelwerk können die Bedeutungen der im Amateurfunk gebräuchlichen Q-Gruppen nachgeschlagen werden? In den ...',0,1,0,0,'');
INSERT INTO question VALUES(3482,'VA406','Wo sind die Präfixe für Amateurfunkrufzeichen international geregelt?',0,1,0,0,'');
INSERT INTO question VALUES(3483,'VA405','Zu welcher Region nach den Radio Regulations (RR) gehört Australien?',0,1,0,0,'');
INSERT INTO question VALUES(3484,'VA404','Zu welcher Region nach den Radio Regulations (RR) gehört Kanada?',0,1,0,0,'');
INSERT INTO question VALUES(3485,'VA403','Zu welcher Region nach den Radio Regulations (RR) gehört Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(3486,'VA402','Nach den Radio Regulations (RR) ist die Welt für die Zuweisung von Frequenzbereichen an Funkdienste in Regionen aufgeteilt. Wie viele Regionen gibt es?',0,1,0,0,'');
INSERT INTO question VALUES(3487,'VA401','Weshalb wird in den Radio Regulations (RR) die Erde in verschiedene Regionen eingeteilt?',0,1,0,0,'');
INSERT INTO question VALUES(3488,'VB114','Ist der vorübergehende Betrieb einer deutschen Klubstation nach CEPT-Empfehlung T/R  61-01 in einem Land erlaubt, welches diese Empfehlung anwendet?',0,1,0,0,'');
INSERT INTO question VALUES(3489,'VB113','Was hat ein Funkamateur zu veranlassen, wenn er eine Amateurfunkstelle in einem Land betreiben will, das die CEPT-Empfehlung nicht anwendet?',0,1,0,0,'');
INSERT INTO question VALUES(3490,'VB112','Darf ein Funkamateur mit einer deutschen Amateurfunkzulassung auch im Ausland Amateurfunkverkehr auf dem 6 m-Band durchführen?',0,1,0,0,'');
INSERT INTO question VALUES(3491,'VB111','Welche Regelungen sind beim Betrieb einer Amateurfunkstelle im Ausland zu beachten, wenn das besuchte Land die CEPT-Empfehlungen T/R 61-01 und (05)06 umgesetzt hat?',0,1,0,0,'');
INSERT INTO question VALUES(3492,'VB110','Wie muss ein Funkamateur aus einem Land, das die CEPT-Empfehlung T/R 61-01 oder die ECC-Empfehlung (05)06 anwendet, sein Heimatrufzeichen beim Betrieb einer Amateurfunkstelle in Deutschland ergänzen? Je nach Klasse des Funkamateurs wird ...',0,1,0,0,'');
INSERT INTO question VALUES(3493,'VB109','Wie lange darf ein Funkamateur vorübergehend Amateurfunkverkehr im Ausland je Aufenthalt durchführen, wenn die CEPT-Regelung Anwendung findet?',0,1,0,0,'');
INSERT INTO question VALUES(3494,'VB108','Darf ein Funkamateur mit einer deutschen Zulassung zur Teilnahme am Amateurfunkdienst der Klasse A oder E auch in Nicht-CEPT-Ländern auf Grundlage der CEPT-Empfehlungen T/R 61-01 bzw. ECC (05)06 Amateurfunkverkehr abwickeln?',0,1,0,0,'');
INSERT INTO question VALUES(3495,'VB107','Darf ein deutscher Funkamateur mit einer Amateurfunkzulassung der Klasse A in allen CEPT-Ländern Amateurfunkverkehr abwickeln?',0,1,0,0,'');
INSERT INTO question VALUES(3496,'VB106','Darf ein Funkamateur mit einer "CEPT-Novice-Amateurfunkgenehmigung" in allen CEPT-Ländern Amateurfunkverkehr abwickeln?',0,1,0,0,'');
INSERT INTO question VALUES(3497,'VB105','Darf ein Funkamateur mit einer Amateurfunkzulassung der Klasse N in allen CEPT-Ländern Amateurfunkverkehr abwickeln?',0,1,0,0,'');
INSERT INTO question VALUES(3498,'VB104','Welche Bedeutung haben die CEPT-Empfehlungen T/R 61-01 und T/R 61-02 sowie der ERC-Report 32 und die ECC-Empfehlung (05)06 für den Amateurfunk? Sie bilden die Grundlage für...',0,1,0,0,'');
INSERT INTO question VALUES(3499,'VB103','Was ist eine HAREC-Bescheinigung? Das Dokument ...',0,1,0,0,'');
INSERT INTO question VALUES(3500,'VB102','Was versteht man unter dem Begriff HAREC (Harmonized Amateur Radio Examination Certificate)?',0,1,0,0,'');
INSERT INTO question VALUES(3501,'VB101','Welche der folgenden Aussagen zur "CEPT-Novice-Amateurfunk-Prüfungsbescheinigung" ist richtig?',0,1,0,0,'');
INSERT INTO question VALUES(3502,'VC125','Was hat ein Funkamateur zu erwarten, der seine Amateurfunkstelle ordnungswidrig betreibt?',0,1,0,0,'');
INSERT INTO question VALUES(3503,'VC124','Welche der folgenden Handlungen sind Ordnungswidrigkeiten im Sinne des Amateurfunkgesetzes (AFuG) und können mit Bußgeldern von bis zu 5000 bzw. 10000 Euro geahndet werden?',0,1,0,0,'');
INSERT INTO question VALUES(3504,'VC123','Was hat ein Funkamateur mit zugeteiltem Rufzeichen zu erwarten, wenn er fortgesetzt gegen AFuG oder AFuV verstößt?',0,1,0,0,'');
INSERT INTO question VALUES(3505,'VC122','Die Bundesnetzagentur kann bei Verstößen gegen AFuG oder AFuV ...',0,1,0,0,'');
INSERT INTO question VALUES(3506,'VC121','Kann der Funkamateur laut Amateurfunkgesetz (AFuG) eine Standortbescheinigung erhalten?',0,1,0,0,'');
INSERT INTO question VALUES(3507,'VC120','Darf der Funkamateur bei Selbstbaugeräten von den grundlegenden Anforderungen zur Störfestigkeit im Sinne des Gesetzes über die elektromagnetische Verträglichkeit von Betriebsmitteln (EMVG) abweichen?',0,1,0,0,'');
INSERT INTO question VALUES(3508,'VC119','Was gilt hinsichtlich der Störfestigkeit der Amateurfunkstelle nach dem Wortlaut des Amateurfunkgesetzes (AFuG)? ',0,1,0,0,'');
INSERT INTO question VALUES(3509,'VC118','Was muss ein Funkamateur beim Betrieb seiner Amateurfunkstelle in Bezug auf die elektromagnetische Verträglichkeit beachten?',0,1,0,0,'');
INSERT INTO question VALUES(3510,'VC117','Kann ein zugeteiltes Rufzeichen durch die Bundesnetzagentur geändert werden?',0,1,0,0,'');
INSERT INTO question VALUES(3511,'VC116','Welche personengebundenen Rufzeichen darf ein Funkamateur benutzen?',0,1,0,0,'');
INSERT INTO question VALUES(3512,'VC115','Zu welchem Zweck darf eine Amateurfunkstelle laut Amateurfunkgesetz (AFuG) <u>nicht</u> betrieben werden?',0,1,0,0,'');
INSERT INTO question VALUES(3513,'VC114','Darf die Amateurfunkstelle zu gewerblich-wirtschaftlichen Zwecken betrieben werden? Eine Amateurfunkstelle darf ...',0,1,0,0,'');
INSERT INTO question VALUES(3514,'VC113','Nach dem Amateurfunkgesetz ist ein Funkamateur der Inhaber eines Amateurfunkzeugnisses oder einer harmonisierten Prüfungsbescheinigung, der sich aus persönlicher Neigung und <u>nicht</u> ...',0,1,0,0,'');
INSERT INTO question VALUES(3515,'VC112','Darf ein Funkamateur Nachrichten, die nicht den Amateurfunkdienst betreffen, für und an Dritte übermitteln?',0,1,0,0,'');
INSERT INTO question VALUES(3516,'VC111','Mit welchen Funkstellen darf der Funkamateur Funkverkehr abwickeln?',0,1,0,0,'');
INSERT INTO question VALUES(3517,'VC110','Was gilt für Funkamateure hinsichtlich der Frequenznutzung? Ein Funkamateur darf mit seiner Amateurfunkstelle ...',0,1,0,0,'');
INSERT INTO question VALUES(3518,'VC109','Welches Recht haben Funkamateure in Bezug auf den Betrieb von Sendeanlagen? Ein Funkamateur ...',0,1,0,0,'');
INSERT INTO question VALUES(3519,'VC108','Ist nach dem Amateurfunkgesetz (AFuG) für die Erteilung einer Amateurfunkzulassung ein Mindestalter erforderlich?',0,1,0,0,'');
INSERT INTO question VALUES(3520,'VC107','Darf ein Funkamateur seine Amateurfunkzulassung vorübergehend einer anderen Person übertragen? Die Amateurfunkzulassung ist ...',0,1,0,0,'');
INSERT INTO question VALUES(3521,'VC106','Was ist neben einer erfolgreich abgelegten Amateurfunkprüfung unbedingt erforderlich, damit Sie eine Amateurfunkstelle betreiben dürfen?',0,1,0,0,'');
INSERT INTO question VALUES(3522,'VC105','Welches der nachfolgend genannten Dokumente benötigt man, um Funkamateur im Sinne des Amateurfunkgesetzes (AFuG) zu sein?',0,1,0,0,'');
INSERT INTO question VALUES(3523,'VC104','Welche deutsche Behörde nimmt die Aufgaben und Befugnisse wahr, die sich aus dem Amateurfunkgesetz (AFuG) und der Amateurfunkverordnung (AFuV) ergeben?',0,1,0,0,'');
INSERT INTO question VALUES(3524,'VC103','Nach dem Amateurfunkgesetz (AFuG) ist eine Amateurfunkstelle eine Funkstelle, die aus ...',0,1,0,0,'');
INSERT INTO question VALUES(3525,'VC102','Im Sinne des Amateurfunkgesetzes ist der Amateurfunkdienst ein Funkdienst, der ...',0,1,0,0,'');
INSERT INTO question VALUES(3526,'VC101','Welches Gesetz bildet die Rechtsgrundlage und regelt die Voraussetzungen und die Bedingungen für die Teilnahme am Amateurfunkdienst in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(3527,'VD119','Wie ist der Begriff "Funkbake" nach dem Wortlaut der Amateurfunkverordnung (AFuV) definiert?',0,1,0,0,'');
INSERT INTO question VALUES(3528,'VD118','Wie ist der Begriff "Relaisfunkstelle" nach dem Wortlaut der Amateurfunkverordnung (AFuV) definiert?',0,1,0,0,'');
INSERT INTO question VALUES(3529,'VD117','Wie ist der Begriff "Klubstation" nach dem Wortlaut der Amateurfunkverordnung (AFuV) definiert?',0,1,0,0,'');
INSERT INTO question VALUES(3530,'VD116','Für welche Zwecke sind Zuteilungen mit Ausnahmen von den technischen und betrieblichen Rahmenbedingungen der Amateurfunkverordnung (AFuV) möglich?',0,1,0,0,'');
INSERT INTO question VALUES(3531,'VD115','Ist für den Betrieb einer Amateurfunkstelle in einem Wasser- oder Luftfahrzeug eine Sondergenehmigung der Bundesnetzagentur erforderlich?',0,1,0,0,'');
INSERT INTO question VALUES(3532,'VD114','Welche Daten zum Inhaber eines personengebundenen Rufzeichens sind in der von der Bundesnetzagentur veröffentlichten Rufzeichenliste enthalten?',0,1,0,0,'');
INSERT INTO question VALUES(3533,'VD113','Innerhalb welcher Frist muss der Inhaber einer Amateurfunkzulassung eine Änderung seines Namens oder seiner Anschrift bei der BNetzA schriftlich oder elektronisch anzeigen, auch wenn er keine Amateurfunkstelle besitzt, errichtet oder betreibt?',0,1,0,0,'');
INSERT INTO question VALUES(3534,'VD112','Unter welcher Bedingung ist das Aussenden eines unmodulierten oder ungetasteten Trägers zulässig?',0,1,0,0,'');
INSERT INTO question VALUES(3535,'VD111','Was ist bei Abgleicharbeiten und Messungen an Sendern im Hinblick auf die Aussendung zu beachten?',0,1,0,0,'');
INSERT INTO question VALUES(3536,'VD110','Welche Aussage trifft die Amateurfunkverordnung (AFuV) hinsichtlich unerwünschter Aussendungen?',0,1,0,0,'');
INSERT INTO question VALUES(3537,'VD109','Wann muss der Funkamateur Angaben über den Betrieb seiner Amateurfunkstelle schriftlich festhalten, z. B. als Logbuch?',0,1,0,0,'');
INSERT INTO question VALUES(3538,'VD108','Zu welchen Zwecken kann die Bundesnetzagentur schriftliche Nachweise über den Funkbetrieb verlangen?',0,1,0,0,'');
INSERT INTO question VALUES(3539,'VD107','In welchem Fall hat ein Funkamateur der Bundesnetzagentur gemäß Amateurfunkverordnung (AFuV) technische Unterlagen über seine Sendeanlage vorzulegen?',0,1,0,0,'');
INSERT INTO question VALUES(3540,'VD106','Welche technischen Anforderungen stellt die Amateurfunkverordnung u. a. an eine Amateurfunkstelle?',0,1,0,0,'');
INSERT INTO question VALUES(3541,'VD105','Dürfen im Amateurfunkverkehr internationale Not-, Dringlichkeits- und Sicherheitszeichen (z. B. MAYDAY, PAN PAN, SÉCURITÉ) ausgesendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(3542,'VD104','Welche Kommunikationsinhalte dürfen im Amateurfunkverkehr laut AFuV zum Zwecke der Verschleierung verschlüsselt werden?',0,1,0,0,'');
INSERT INTO question VALUES(3543,'VD103','Im Amateurfunkverkehr darf nur offene Sprache verwendet werden. Was gilt <u>nicht</u> als offene Sprache und ist daher unzulässig?',0,1,0,0,'');
INSERT INTO question VALUES(3544,'VD102','Was gilt in Bezug auf den Empfang von Amateurfunkaussendungen?',0,1,0,0,'');
INSERT INTO question VALUES(3545,'VD101','Wo kann der Funkamateur nachschlagen, welche Frequenzbereiche er entsprechend seiner Zeugnisklasse in Deutschland nutzen darf?',0,1,0,0,'');
INSERT INTO question VALUES(3546,'VD208','Hat ein Funkamateur Anspruch auf Zuteilung eines bestimmten Rufzeichens?',0,1,0,0,'');
INSERT INTO question VALUES(3547,'VD207','Woran erkennt man eine Amateurfunkstelle im Funkbetrieb?',0,1,0,0,'');
INSERT INTO question VALUES(3548,'VD206','Welches Buchstabieralphabet ist nach der Verfügung 13/2005 bei der Nennung des Rufzeichens zur Identifikation einer Amateurfunkstation zu verwenden?',0,1,0,0,'');
INSERT INTO question VALUES(3549,'VD205','Wann muss der Funkamateur sein Rufzeichen nennen?',0,1,0,0,'');
INSERT INTO question VALUES(3550,'VD204','Warum ist "DL250BTHVN" ein zulässiges deutsches Amateurfunkrufzeichen?',0,1,0,0,'');
INSERT INTO question VALUES(3551,'VD203','Wie werden personengebundene deutsche Amateurfunkrufzeichen gebildet? Sie bestehen aus ...',0,1,0,0,'');
INSERT INTO question VALUES(3552,'VD202','Welche Rufzeichenzuteilungsarten gibt es im Amateurfunk unter anderem?',0,1,0,0,'');
INSERT INTO question VALUES(3553,'VD201','In welchem Regelwerk sind die Vorgaben für die Bildung von Rufzeichen für den Amateurfunkdienst in Deutschland zu finden?',0,1,0,0,'');
INSERT INTO question VALUES(3554,'VD306','Von wem ist während des Ausbildungsfunkbetriebs der Rufzeichenzusatz "/T" bzw. "/Trainee" zu benutzen?',0,1,0,0,'');
INSERT INTO question VALUES(3555,'VD305','Was ist bei der Durchführung von Ausbildungsfunkverkehr zu beachten?',0,1,0,0,'');
INSERT INTO question VALUES(3556,'VD304','Was ist unter anderem im Zusammenhang mit der Durchführung von Ausbildungsfunkverkehr zu beachten? Der Ausbildungsfunkbetrieb darf ...',0,1,0,0,'');
INSERT INTO question VALUES(3557,'VD303','Nicht-Funkamateure dürfen am Ausbildungsfunkbetrieb ...',0,1,0,0,'');
INSERT INTO question VALUES(3558,'VD302','Unter welcher Voraussetzung nach der Amateurfunkverordnung (AFuV) darf ein Funkamateur Ausbildungsfunkbetrieb durchführen?',0,1,0,0,'');
INSERT INTO question VALUES(3559,'VD301','Wozu dient der Ausbildungsfunkbetrieb gemäß Amateurfunkverordnung (AFuV)? Er dient ...',0,1,0,0,'');
INSERT INTO question VALUES(3560,'VD408','Welche Aussage ist hinsichtlich der Standortänderung einer Klubstation zutreffend?',0,1,0,0,'');
INSERT INTO question VALUES(3561,'VD407','Welche der genannten Funkamateure dürfen an einer Klubstation der Klasse A Funkbetrieb im 40 m-Amateurfunkband durchführen?',0,1,0,0,'');
INSERT INTO question VALUES(3562,'VD406','Sie nutzen ein Klubstationsrufzeichen und verfügen über eine andere Amateurfunkzeugnis-Klasse als die Zuteilung der Klubstation. In welchen Frequenzbereichen und mit welchen Leistungen dürfen Sie senden? Entsprechend des Berechtigungsumfangs ...',0,1,0,0,'');
INSERT INTO question VALUES(3563,'VD405','Darf ein Funkamateur mit Zulassung zur Teilnahme am Amateurfunkdienst nach den Bestimmungen der Amateurfunkverordnung (AFuV) mit dem Rufzeichen der Klubstation Funkbetrieb durchführen, auch wenn er nicht Mitglied der betreibenden Gruppe ist?',0,1,0,0,'');
INSERT INTO question VALUES(3564,'VD404','Was ist nötig, damit ein Funkamateur das Rufzeichen einer Klubstation mitbenutzen darf?',0,1,0,0,'');
INSERT INTO question VALUES(3565,'VD403','Ab wann darf ein Funkamateur laut Amateurfunkgesetz (AFuG) eine Klubstation betreiben?',0,1,0,0,'');
INSERT INTO question VALUES(3566,'VD402','Welche Voraussetzung muss für die Erteilung eines Rufzeichens für den Betrieb einer Klubstation erfüllt sein?',0,1,0,0,'');
INSERT INTO question VALUES(3567,'VD401','Welche Voraussetzungen müssen für die Erteilung eines Rufzeichens für den Betrieb einer Klubstation erfüllt sein?',0,1,0,0,'');
INSERT INTO question VALUES(3568,'VD504','Wann kann ein verantwortlicher Funkamateur einen bestimmten Funkamateur vom Betrieb über die von ihm betreute Relaisfunkstelle ausschließen?',0,1,0,0,'');
INSERT INTO question VALUES(3569,'VD503','Wie hoch ist die maximal zulässige Strahlungsleistung einer Relaisfunkstelle oberhalb 30 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(3570,'VD502','Unter welchen Voraussetzungen darf ein Funkamateur eine Amateurfunkstelle als Relaisfunkstelle betreiben?',0,1,0,0,'');
INSERT INTO question VALUES(3571,'VD501','Was ist notwendig, damit ein Funkamateur eine Amateurfunkstelle als Relaisfunkstelle oder Funkbake betreiben darf?',0,1,0,0,'');
INSERT INTO question VALUES(3572,'VD609','Wem darf Zugriff auf eine Klubstation im Remote-Betrieb eingeräumt werden?',0,1,0,0,'');
INSERT INTO question VALUES(3573,'VD608','Warum muss der Betreiber der "Remote-Station" seine Kontaktdaten bei der BNetzA angeben?',0,1,0,0,'');
INSERT INTO question VALUES(3574,'VD607','Wer darf mit einer Amateurfunkstelle im "Remote-Betrieb" senden? Vom Betreiber der Amateurfunkstelle berechtigte Funkamateure, die ...',0,1,0,0,'');
INSERT INTO question VALUES(3575,'VD606','Was ist bei der Übertragung des Nutzungsrechts an einer "Remote-Station" auf andere Funkamateure zu beachten?',0,1,0,0,'');
INSERT INTO question VALUES(3576,'VD605','Wie muss der Betreiber die Betriebssicherheit seiner "Remote-Station" gewährleisten? Der Betreiber muss sicherstellen, dass ...',0,1,0,0,'');
INSERT INTO question VALUES(3577,'VD604','Welche der folgenden Amateurfunkstellen darf als "Remote-Station" verwendet werden?',0,1,0,0,'');
INSERT INTO question VALUES(3578,'VD603','Wer darf eine "Remote-Station" betreiben?',0,1,0,0,'');
INSERT INTO question VALUES(3579,'VD602','Ist für "Remote-Betrieb" bei der BNetzA eine Betriebsmeldung erforderlich?',0,1,0,0,'');
INSERT INTO question VALUES(3580,'VD601','Was versteht der Funkamateur unter "Remote-Betrieb"?',0,1,0,0,'');
INSERT INTO question VALUES(3581,'VD743','Wie hoch ist die maximal zulässige effektive Strahlungsleistung (ERP) für Funkamateure mit der Zulassungsklasse N im 10 m-Band?',0,1,0,0,'');
INSERT INTO question VALUES(3582,'VD742','In welchem der folgenden Amateurfunkfrequenzbereiche beträgt die maximal zulässige belegte Bandbreite einer Aussendung 2 MHz bzw. für amplitudenmodulierte Fernsehaussendungen 7 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(3583,'VD741','In welchem der folgenden Amateurfunkfrequenzbereiche beträgt die maximal zulässige belegte Bandbreite einer Aussendung 40 kHz?',0,1,0,0,'');
INSERT INTO question VALUES(3584,'VD740','In welchem der folgenden Amateurfunkfrequenzbereiche beträgt die maximal zulässige belegte Bandbreite einer Aussendung 7 kHz?',0,1,0,0,'');
INSERT INTO question VALUES(3585,'VD739','In welchem der folgenden Amateurfunkfrequenzbereiche beträgt die maximal zulässige belegte Bandbreite einer Aussendung 2,7 kHz?',0,1,0,0,'');
INSERT INTO question VALUES(3586,'VD738','In welchen Amateurfunkfrequenzbereichen beträgt die maximal zulässige belegte Bandbreite einer Aussendung 800 Hz?',0,1,0,0,'');
INSERT INTO question VALUES(3587,'VD737',replace('Wie hoch ist die maximal zulässige Senderausgangsleistung für Rufzeicheninhaber der\nKlasse E in den Amateurfunkbändern zwischen 1300 MHz und 250 GHz?','\n',char(10)),0,1,0,0,'');
INSERT INTO question VALUES(3588,'VD736','Wie hoch ist die maximal zulässige Senderausgangsleistung für Rufzeicheninhaber der Klasse A in den Amateurfunkbändern zwischen 1300 MHz und 250 GHz?',0,1,0,0,'');
INSERT INTO question VALUES(3589,'VD735','Wie hoch ist die maximal zulässige Sendeleistung für Rufzeicheninhaber der Klasse A im Frequenzbereich 1240 bis 1300 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(3590,'VD734','Welche Leistungsgrenzen gelten für die Rufzeicheninhaber der Klasse A und E in den Frequenzbereichen 144 bis 146 MHz und 430 bis 440 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(3591,'VD733','Welche Leistungsgrenzen gelten für die Rufzeicheninhaber der Klassen A und E in den Frequenzbereichen 21,000 bis 21,450 MHz und 28,000 bis 29,700 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(3592,'VD732','Wie hoch ist die maximal zulässige Senderausgangsleistung für Rufzeicheninhaber der Klasse A in den Frequenzbereichen 21,000 bis 21,450 MHz und 24,890 bis 24,990 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(3593,'VD731','Wie hoch ist die maximal zulässige Senderausgangsleistung für Rufzeicheninhaber der Klasse A in den Frequenzbereichen 14,000 bis 14,350 MHz und 18,068 bis 18,168 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(3594,'VD730','Wie hoch ist die maximal zulässige Senderausgangsleistung für Rufzeicheninhaber der Klasse A im Frequenzbereich 10,1 bis 10,15 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(3595,'VD729','Was gilt für die Rufzeicheninhaber der Klassen A und E im Frequenzbereich 3,5 bis 3,8 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(3596,'VD728','Wie hoch ist die maximal zulässige Senderausgangsleistung für Rufzeicheninhaber der Klasse A im Frequenzbereich 3,5 bis 3,8 MHz?',0,1,0,0,'');
INSERT INTO question VALUES(3597,'VD727','Was gilt für die Rufzeicheninhaber der Klasse E im Frequenzbereich 1810 bis 1850 kHz?',0,1,0,0,'');
INSERT INTO question VALUES(3598,'VD726','Sie sind Inhaber einer Zulassung für den Amateurfunkdienst der Klasse N und nutzen ein Funkgerät mit 5 W Senderausgangsleistung. Dürfen Sie bei Sendebetrieb im 2 m-Band eine direkt angeschlossene Antenne mit Gewinnfaktor 1,8 bezogen auf den isotropen Kugelstrahler (entspricht 2,6 dBi Gewinn) verwenden?',0,1,0,0,'');
INSERT INTO question VALUES(3599,'VD725','Sie sind Inhaber einer Zulassung für den Amateurfunkdienst der Klasse N und nutzen ein Funkgerät mit 5 W Senderausgangsleistung. Dürfen Sie bei Sendebetrieb im 2 m-Band eine direkt angeschlossene Antenne mit Gewinnfaktor 2,5 bezogen auf den isotropen Kugelstrahler (entspricht 4,0 dBi Gewinn) verwenden?',0,1,0,0,'');
INSERT INTO question VALUES(3600,'VD724','Wie hoch ist die maximal zulässige isotrope Strahlungsleistung (EIRP) für Funkamateure mit der Zulassungsklasse N im 2 m- und 70 cm-Band?',0,1,0,0,'');
INSERT INTO question VALUES(3601,'VD723','In welchen Frequenzbereichen ist für Funkamateure mit Zulassung für die Klasse N Sendebetrieb erlaubt?',0,1,0,0,'');
INSERT INTO question VALUES(3602,'VD722','Welche Antwort enthält die richtige Anfangs- und Endfrequenz für das 13 cm-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(3603,'VD721','Welche Antwort enthält die richtige Anfangs- und Endfrequenz für das 23 cm-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(3604,'VD720','Welche Antwort enthält die richtige Anfangs- und Endfrequenz für das 70 cm-Amateurfunkband in Deutschland? ',0,1,0,0,'');
INSERT INTO question VALUES(3605,'VD719','Welche Antwort enthält die richtige Anfangs- und Endfrequenz für das 2 m-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(3606,'VD718','Welche Antwort enthält die richtige Anfangs- und Endfrequenz für das 6 m-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(3607,'VD717','Welche Antwort enthält die richtige Anfangs- und Endfrequenz für das 10 m-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(3608,'VD716','Welche Antwort enthält die richtige Anfangs- und Endfrequenz für das 12 m-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(3609,'VD715','Welche Antwort enthält die richtige Anfangs- und Endfrequenz für das 15 m-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(3610,'VD714','Welche Antwort enthält die richtige Anfangs- und Endfrequenz für das 17 m-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(3611,'VD713','Welche Antwort enthält die richtige Anfangs- und Endfrequenz für das 20 m-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(3612,'VD712','Welche Antwort enthält die richtige Anfangs- und Endfrequenz für das 30 m-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(3613,'VD711','Welche Antwort enthält die richtige Anfangs- und Endfrequenz für das 40 m-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(3614,'VD710','Welche Antwort enthält die richtige Anfangs- und Endfrequenz für das 80 m-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(3615,'VD709','Welche Antwort enthält die richtige Anfangs- und Endfrequenz für das 160 m-Amateurfunkband in Deutschland?',0,1,0,0,'');
INSERT INTO question VALUES(3616,'VD708','Was besagt der Hinweis, dass der Frequenzbereich 433,05 bis 434,79 MHz als ISM-Frequenzbereich zugewiesen ist?',0,1,0,0,'');
INSERT INTO question VALUES(3617,'VD707','Das 80 m-Amateurfunkband ist unter anderem dem Amateurfunkdienst und dem Seefunkdienst auf primärer Basis zugewiesen. Unter welchen Umständen dürfen Sie in einer Amateurfunkverbindung fortfahren, wenn Sie erst nach Betriebsaufnahme bemerken, dass Ihre benutzte Frequenz auch von einer Küstenfunkstelle benutzt wird?',0,1,0,0,'');
INSERT INTO question VALUES(3618,'VD706','In welchem der genannten Frequenzbereiche hat der Amateurfunkdienst primären Status?',0,1,0,0,'');
INSERT INTO question VALUES(3619,'VD705','Wie ist ein sekundärer Funkdienst laut Amateurfunkverordnung (AFuV) definiert?',0,1,0,0,'');
INSERT INTO question VALUES(3620,'VD704','Wie ist ein primärer Funkdienst laut Amateurfunkverordnung (AFuV) definiert?',0,1,0,0,'');
INSERT INTO question VALUES(3621,'VD703','Unter welchen Voraussetzungen darf ein Funkamateur mit seinem Amateurfunkgerät Funkverkehr im CB-Funk-Bereich durchführen?',0,1,0,0,'');
INSERT INTO question VALUES(3622,'VD702','Wo sind die für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereiche und die zugehörigen ausführlichen Nutzungsbedingungen zu finden?',0,1,0,0,'');
INSERT INTO question VALUES(3623,'VD701','Darf ein Funkamateur in Deutschland alle in den Radio Regulations (RR) für den Amateurfunkdienst zugewiesenen Frequenzbereiche benutzen?',0,1,0,0,'');
INSERT INTO question VALUES(3624,'VE103','Welcher der nachfolgend genannten Tatbestände ist eine Ordnungswidrigkeit gemäß Telekommunikationsgesetz (TKG)?',0,1,0,0,'');
INSERT INTO question VALUES(3625,'VE102','Bedarf jede Frequenznutzung einer Frequenzzuteilung?',0,1,0,0,'');
INSERT INTO question VALUES(3626,'VE101','Enthält das Telekommunikationsgesetz (TKG) Regelungen, die auf den Amateurfunkdienst anwendbar sind?',0,1,0,0,'');
INSERT INTO question VALUES(3627,'VE204','Bei welchen der genannten Geräte sind nach dem Telekommunikation-Telemedien-Datenschutz-Gesetz (TTDSG) sowohl die Herstellung als auch der Besitz verboten? Bei ...',0,1,0,0,'');
INSERT INTO question VALUES(3628,'VE203','Wie hat sich ein Funkamateur zu verhalten, der Nachrichten empfängt, die <u>nicht</u> für Funkamateure, die Allgemeinheit oder einen unbestimmten Personenkreis bestimmt sind?',0,1,0,0,'');
INSERT INTO question VALUES(3629,'VE202','Bei welcher Handlung verletzt ein Funkamateur das Fernmeldegeheimnis?',0,1,0,0,'');
INSERT INTO question VALUES(3630,'VE201','Darf ein Funkamateur seine Amateurfunkstelle zum Abhören des nichtöffentlich gesprochenen Wortes verwenden?',0,1,0,0,'');
INSERT INTO question VALUES(3631,'VE309','Der Empfang Ihrer Amateurfunkstation ist wiederkehrend gestört. Die Ursache liegt nicht in Ihrem Haushalt. Sie wollen die Funkstörungsannahme der Bundesnetzagentur informieren. Wie sollten Sie die Bearbeitung durch die Behörde unterstützen?',0,1,0,0,'');
INSERT INTO question VALUES(3632,'VE308','Muss ein Funkamateur eine Störung seines Empfangs durch andere Geräte hinnehmen?',0,1,0,0,'');
INSERT INTO question VALUES(3633,'VE307','Der Empfang Ihrer Amateurfunkstation ist auf allen Bändern gestört. Welche Maßnahme sollten Sie als erstes ergreifen?',0,1,0,0,'');
INSERT INTO question VALUES(3634,'VE306','Durch den Betrieb einer Amateurfunkstelle auf 144,250 MHz wird der Kabelfernsehempfang eines Nachbarn beeinträchtigt. Eine Überprüfung ergibt, dass der Funkamateur am Ort der beeinträchtigten Empfangsanlage eine Feldstärke erzeugt, die den in der Norm empfohlenen Grenzwert für die Störfestigkeit von Kabelverteilanlagen nicht erreicht. Was folgt daraus für den Funkamateur?',0,1,0,0,'');
INSERT INTO question VALUES(3635,'VE305','Durch den Betrieb einer Amateurfunkstelle auf 145,550 MHz wird der UKW-Rundfunkempfänger eines Nachbarn durch Direkteinstrahlung beeinträchtigt. Eine Überprüfung ergibt, dass der Funkamateur am Ort des beeinträchtigten Empfängers eine Feldstärke erzeugt, die den in der Norm empfohlenen Grenzwert für die Störfestigkeit von Geräten nicht erreicht. Was folgt daraus für den Funkamateur?',0,1,0,0,'');
INSERT INTO question VALUES(3636,'VE304','Durch den Betrieb einer Amateurfunkstelle wird der Fernsehempfang eines Nachbarn beeinträchtigt. Eine Überprüfung ergibt, dass sowohl das Fernsehgerät als auch die Amateurfunkstelle die Vorschriften einhalten und Nachbesserungen nicht mehr möglich sind. Wozu ist die BNetzA in diesem Fall befugt?',0,1,0,0,'');
INSERT INTO question VALUES(3637,'VE303','Durch den Betrieb einer Amateurfunkstelle auf 145,550 MHz wird der UKW-Rundfunkempfang eines Nachbarn beeinträchtigt. Eine Überprüfung ergibt, dass sowohl die Amateurfunkstelle als auch die Rundfunkempfangsanlage vorschriftsmäßig betrieben werden. Womit muss der Funkamateur rechnen?',0,1,0,0,'');
INSERT INTO question VALUES(3638,'VE302','Welche Reaktion ist angebracht, wenn Störungen im Fernseh- oder Rundfunkempfang beim Nachbarn nicht mit den zur Verfügung stehenden Mitteln beseitigt werden können?',0,1,0,0,'');
INSERT INTO question VALUES(3639,'VE301','Durch den Betrieb einer Amateurfunkstelle wird der Rundfunkempfang eines Nachbarn gestört. Welche Maßnahme kann der Funkamateur zur Wahrung des nachbarschaftlichen Friedens noch vor Einschaltung der Bundesnetzagentur durchführen?',0,1,0,0,'');
INSERT INTO question VALUES(3640,'VE405','Wird für von Funkamateuren zusammengebaute Funkanlagen der Nachweis auf Einhaltung der technischen Vorschriften nach den Bestimmungen des Funkanlagengesetzes (FuAG) verlangt?',0,1,0,0,'');
INSERT INTO question VALUES(3641,'VE404','Welche Vorschriften müssen im Handel erhältliche Empfangsfunkanlagen einhalten, die dem Amateurfunk zugewiesene Frequenzen empfangen können?',0,1,0,0,'');
INSERT INTO question VALUES(3642,'VE403','Welche grundlegenden Anforderungen werden nach dem Funkanlagengesetz (FuAG) an Amateurfunkgeräte gestellt?',0,1,0,0,'');
INSERT INTO question VALUES(3643,'VE402','Welche Geräte fallen in den Anwendungsbereich des Funkanlagengesetzes (FuAG)?',0,1,0,0,'');
INSERT INTO question VALUES(3644,'VE401','Welches Gesetz regelt unter anderem das Inverkehrbringen, den freien Warenverkehr und die Inbetriebnahme von auf dem Markt bereitgestellten Amateurfunkanlagen?',0,1,0,0,'');
INSERT INTO question VALUES(3645,'VE519','Kann die Bundesnetzagentur für den Betrieb einer ortsfesten Amateurfunkstelle eine Standortbescheinigung fordern?',0,1,0,0,'');
INSERT INTO question VALUES(3646,'VE518','Sie wollen eine Amateurfunkstelle an einem Standort errichten, an dem sich bereits andere ortsfeste Funkanlagen befinden. Welche Besonderheit müssen Sie in Bezug auf den Schutz von Personen in elektromagnetischen Feldern beachten?',0,1,0,0,'');
INSERT INTO question VALUES(3647,'VE517','Sie wollen eine Amateurfunkstelle mit mehreren Sendeantennen betreiben und die Personenschutz-Sicherheitsabstände ermitteln. Dabei ergibt sich, dass der Sicherheitsabstand mehrerer Antennen überlappt. Was müssen Sie nun beachten?',0,1,0,0,'');
INSERT INTO question VALUES(3648,'VE516','Welche Aussendungen von Amateurfunkanlagen müssen bei der Ermittlung des standortbezogenen Sicherheitsabstandes berücksichtigt werden?',0,1,0,0,'');
INSERT INTO question VALUES(3649,'VE515','Welche Verfahren können Funkamateure nutzen, um den Nachweis zur Begrenzung von elektromagnetischen Feldern zu erstellen?',0,1,0,0,'');
INSERT INTO question VALUES(3650,'VE514','Was hat ein Funkamateur zu beachten, nachdem er seine ortsfeste Amateurfunkstelle bei der Bundesnetzagentur gemäß BEMFV angezeigt hat?',0,1,0,0,'');
INSERT INTO question VALUES(3651,'VE513','Welche Unterlagen hat der Funkamateur ergänzend zur Anzeige einer ortsfesten Amateurfunkanlage gemäß der Verordnung über das Nachweisverfahren zur Begrenzung elektromagnetischer Felder (BEMFV) ab dem Zeitpunkt der Inbetriebnahme bereitzuhalten und der Bundesnetzagentur nach Aufforderung vorzulegen?',0,1,0,0,'');
INSERT INTO question VALUES(3652,'VE512','Welche Unterlagen sind ergänzend zur Anzeige gemäß der Verordnung über das Nachweisverfahren zur Begrenzung elektromagnetischer Felder (BEMFV) einer ortsfesten Amateurfunkanlage bei der zuständigen Außenstelle der BNetzA einzureichen?',0,1,0,0,'');
INSERT INTO question VALUES(3653,'VE511','Welchen Status hat im Rahmen der EMVU die Anzeige einer ortsfesten Amateurfunkanlage?',0,1,0,0,'');
INSERT INTO question VALUES(3654,'VE510','Wann ist erneut eine Anzeige einer ortsfesten Amateurfunkanlage gemäß der Verordnung über das Nachweisverfahren zur Begrenzung elektromagnetischer Felder (BEMFV) bei der zuständigen Stelle der BNetzA einzureichen?',0,1,0,0,'');
INSERT INTO question VALUES(3655,'VE509','Bei welcher Stelle und zu welchem Zeitpunkt ist die Anzeige gemäß der Verordnung über das Nachweisverfahren zur Begrenzung elektromagnetischer Felder (BEMFV) für eine ortsfeste Amateurfunkanlage mit einer EIRP ab 10 W einzureichen?',0,1,0,0,'');
INSERT INTO question VALUES(3656,'VE508','Wer muss seine Amateurfunkstelle bei der BNetzA gemäß der Verordnung über das Nachweisverfahren zur Begrenzung elektromagnetischer Felder (BEMFV) anzeigen?',0,1,0,0,'');
INSERT INTO question VALUES(3657,'VE507','Für welche Amateurfunkstellen muss der Schutz von Personen in elektromagnetischen Feldern vom Funkamateur dokumentiert werden?',0,1,0,0,'');
INSERT INTO question VALUES(3658,'VE506','Was muss ein Funkamateur zum Schutz von Personen bei dem Betrieb von ortsfesten Amateurfunkanlagen gemäß der Verordnung über das Nachweisverfahren zur Begrenzung elektromagnetischer Felder (BEMFV) vornehmen?',0,1,0,0,'');
INSERT INTO question VALUES(3659,'VE505','Wo sind die Grenzwerte zum Schutz von Personen und aktiven Körperhilfen in elektromagnetischen Feldern festgelegt?',0,1,0,0,'');
INSERT INTO question VALUES(3660,'VE504','Was versteht man nach der Verordnung über das Nachweisverfahren zur Begrenzung elektromagnetischer Felder (BEMFV) unter dem "Anzeigeverfahren ortsfester Amateurfunkanlagen"?',0,1,0,0,'');
INSERT INTO question VALUES(3661,'VE503','In welcher gesetzlichen Regelung ist das Verfahren zum Schutz von Personen in elektromagnetischen Feldern ortsfester Amateurfunkstellen festgelegt?',0,1,0,0,'');
INSERT INTO question VALUES(3662,'VE502','Wer ist für die Sicherstellung der elektromagnetischen Umweltverträglichkeit verantwortlich?',0,1,0,0,'');
INSERT INTO question VALUES(3663,'VE501','Was bedeutet die Abkürzung EMVU?',0,1,0,0,'');
INSERT INTO question VALUES(3664,'VE604','Unter welchen Bedingungen ist die Norm VDE 0855-300 für den Potentialausgleich und die Erdung von Funkanlagen bzw. die Normenreihe VDE 0185-305 zum Blitzschutz heranzuziehen?',0,1,0,0,'');
INSERT INTO question VALUES(3665,'VE603','In welchem Regelwerk finden sich anerkannte Regeln der Technik über den Blitzschutz von Amateurfunkantennenanlagen?',0,1,0,0,'');
INSERT INTO question VALUES(3666,'VE602','Nach welchen Bauvorschriften müssen Außenantennenanlagen errichtet werden?',0,1,0,0,'');
INSERT INTO question VALUES(3667,'VE601','Wie ist die Stromversorgung von Eigenbaugeräten elektrotechnisch sicher aufzubauen?',0,1,0,0,'');
INSERT INTO question VALUES(3668,'VE707','Wer haftet für Schäden gegenüber Dritten, die durch die Antennenanlage einer Amateurfunkstelle entstehen können?',0,1,0,0,'');
INSERT INTO question VALUES(3669,'VE706','Darf eine Amateurfunkstelle auch an Bord eines Schiffes, welches sich in internationalen Gewässern befindet, betrieben werden?',0,1,0,0,'');
INSERT INTO question VALUES(3670,'VE705','Welche Voraussetzung muss erfüllt sein, damit Sie Amateurfunk an Bord eines Luftfahrzeugs betreiben dürfen?',0,1,0,0,'');
INSERT INTO question VALUES(3671,'VE704','Mit welchen Folgen muss der Funkamateur rechnen, wenn er die zu entrichtenden Gebühren und Beiträge nicht zahlt?',0,1,0,0,'');
INSERT INTO question VALUES(3672,'VE703','In welchem Fall sind vom Funkamateur Gebühren nach der Besonderen Gebührenverordnung BNetzA (BNetzABGebV) zu entrichten? Bei der ...',0,1,0,0,'');
INSERT INTO question VALUES(3673,'VE702','In welchem Fall sind vom Funkamateur jährliche Beiträge nach der Frequenzschutzbeitragsverordnung (FSBeitrV) zu entrichten? Immer, wenn der Funkamateur...',0,1,0,0,'');
INSERT INTO question VALUES(3674,'VE701','Welche regelmäßigen Beiträge hat der Funkamateur mit Rufzeichenzuteilung zu entrichten?',0,1,0,0,'');
CREATE TABLE answer (_id INT NOT NULL PRIMARY KEY, question_id INT NOT NULL REFERENCES question(_id), order_index INT, answer TEXT NOT NULL, help TEXT);
INSERT INTO answer VALUES(1,1,0,'42*10<sup>-3</sup> A.',' ');
INSERT INTO answer VALUES(2,1,1,'42*10<sup>3</sup> A.',' ');
INSERT INTO answer VALUES(3,1,2,'42*10<sup>-2</sup> A.',' ');
INSERT INTO answer VALUES(4,1,3,'42*10<sup>-1</sup> A.',' ');
INSERT INTO answer VALUES(5,2,0,'420*10<sup>-6</sup> A.',' ');
INSERT INTO answer VALUES(6,2,1,'420*10<sup>6</sup> A.',' ');
INSERT INTO answer VALUES(7,2,2,'420*10<sup>-5</sup> A.',' ');
INSERT INTO answer VALUES(8,2,3,'42*10<sup>-6</sup> A.',' ');
INSERT INTO answer VALUES(9,3,0,'10<sup>-1</sup> W.',' ');
INSERT INTO answer VALUES(10,3,1,'0,001 W.',' ');
INSERT INTO answer VALUES(11,3,2,'0,01 W.',' ');
INSERT INTO answer VALUES(12,3,3,'10<sup>-2</sup> W.',' ');
INSERT INTO answer VALUES(13,4,0,'4,2*10<sup>6</sup> Hz.',' ');
INSERT INTO answer VALUES(14,4,1,'4,2*10<sup>5</sup> Hz.',' ');
INSERT INTO answer VALUES(15,4,2,'42*10<sup>6</sup> Hz.',' ');
INSERT INTO answer VALUES(16,4,3,'42*10<sup>-5</sup> Hz.',' ');
INSERT INTO answer VALUES(17,5,0,'Volt (V)',' ');
INSERT INTO answer VALUES(18,5,1,'Ampere (A)',' ');
INSERT INTO answer VALUES(19,5,2,'Ohm (&Omega;)',' ');
INSERT INTO answer VALUES(20,5,3,'Amperestunden (Ah)',' ');
INSERT INTO answer VALUES(21,6,0,'Amperesekunde (As)',' ');
INSERT INTO answer VALUES(22,6,1,'Kilowatt (kW)',' ');
INSERT INTO answer VALUES(23,6,2,'Joule (J)',' ');
INSERT INTO answer VALUES(24,6,3,'Ampere (A)',' ');
INSERT INTO answer VALUES(25,7,0,'Watt (W)',' ');
INSERT INTO answer VALUES(26,7,1,'Kilowattstunden (kWh)',' ');
INSERT INTO answer VALUES(27,7,2,'Joule (J)',' ');
INSERT INTO answer VALUES(28,7,3,'Amperestunden (Ah)',' ');
INSERT INTO answer VALUES(29,8,0,'Ohm',' ');
INSERT INTO answer VALUES(30,8,1,'Farad',' ');
INSERT INTO answer VALUES(31,8,2,'Siemens',' ');
INSERT INTO answer VALUES(32,8,3,'Henry',' ');
INSERT INTO answer VALUES(33,9,0,'Ampere, Kelvin, Meter, Sekunde',' ');
INSERT INTO answer VALUES(34,9,1,'Sekunde, Meter, Volt, Watt',' ');
INSERT INTO answer VALUES(35,9,2,'Farad, Henry, Ohm, Sekunde',' ');
INSERT INTO answer VALUES(36,9,3,'Grad, Hertz, Ohm, Sekunde',' ');
INSERT INTO answer VALUES(37,10,0,'220 nF.',' ');
INSERT INTO answer VALUES(38,10,1,'22 nF.',' ');
INSERT INTO answer VALUES(39,10,2,'220 pF.',' ');
INSERT INTO answer VALUES(40,10,3,'22 pF.',' ');
INSERT INTO answer VALUES(41,11,0,'3750 kHz.',' ');
INSERT INTO answer VALUES(42,11,1,'375 kHz.',' ');
INSERT INTO answer VALUES(43,11,2,'0,0375 GHz.',' ');
INSERT INTO answer VALUES(44,11,3,'0,375 GHz.',' ');
INSERT INTO answer VALUES(45,12,0,'Farad (F)',' ');
INSERT INTO answer VALUES(46,12,1,'Ohm (&Omega;)',' ');
INSERT INTO answer VALUES(47,12,2,'Siemens (S)',' ');
INSERT INTO answer VALUES(48,12,3,'Henry (H)',' ');
INSERT INTO answer VALUES(49,13,0,'Silber, Kupfer, Aluminium',' ');
INSERT INTO answer VALUES(50,13,1,'Silber, Kupfer, Blei',' ');
INSERT INTO answer VALUES(51,13,2,'Kupfer, Eisen, Zinn',' ');
INSERT INTO answer VALUES(52,13,3,'Aluminium, Kupfer, Quecksilber',' ');
INSERT INTO answer VALUES(53,14,0,'Silber',' ');
INSERT INTO answer VALUES(54,14,1,'Kupfer',' ');
INSERT INTO answer VALUES(55,14,2,'Gold',' ');
INSERT INTO answer VALUES(56,14,3,'Zinn',' ');
INSERT INTO answer VALUES(57,15,0,'Zinn',' ');
INSERT INTO answer VALUES(58,15,1,'Kupfer',' ');
INSERT INTO answer VALUES(59,15,2,'Gold',' ');
INSERT INTO answer VALUES(60,15,3,'Aluminium',' ');
INSERT INTO answer VALUES(61,16,0,'Epoxid, Polyethylen (PE), Polystyrol (PS)',' ');
INSERT INTO answer VALUES(62,16,1,'Pertinax, Polyvinylchlorid (PVC), Graphit',' ');
INSERT INTO answer VALUES(63,16,2,'Polyethylen (PE), Messing, Konstantan',' ');
INSERT INTO answer VALUES(64,16,3,'Teflon, Pertinax, Bronze',' ');
INSERT INTO answer VALUES(65,17,0,'Einige Stoffe (z.B. Silizium, Germanium) sind in reinem Zustand bei Raumtemperatur gute Isolatoren. Durch geringfügige Zusätze von geeigneten anderen Stoffen oder bei hohen Temperaturen werden sie jedoch zu Leitern.',' ');
INSERT INTO answer VALUES(66,17,1,'Einige Stoffe (z.B. Silizium, Germanium) sind in reinem Zustand bei Raumtemperatur gute Leiter. Durch geringfügige Zusätze von geeigneten anderen Stoffen oder bei hohen Temperaturen nimmt jedoch ihre Leitfähigkeit ab.',' ');
INSERT INTO answer VALUES(67,17,2,'Einige Stoffe wie z.B. Indium oder Magnesium sind in reinem Zustand gute Isolatoren. Durch geringfügige Zusätze von Silizium, Germanium oder geeigneten anderen Stoffen werden sie jedoch zu Leitern.',' ');
INSERT INTO answer VALUES(68,17,3,'Einige Stoffe (z.B. Silizium, Germanium) sind in trockenem Zustand gute Elektrolyten. Durch geringfügige Zusätze von Wismut oder Tellur kann man daraus entweder N-leitendes- oder P-leitendes Material für Anoden bzw. Kathoden von Halbleiterbauelementen herstellen.',' ');
INSERT INTO answer VALUES(69,18,0,'0 V',' ');
INSERT INTO answer VALUES(70,18,1,'3 V',' ');
INSERT INTO answer VALUES(71,18,2,'-3 V',' ');
INSERT INTO answer VALUES(72,18,3,'1,5 V',' ');
INSERT INTO answer VALUES(73,19,0,'12 V / 10 Ah',' ');
INSERT INTO answer VALUES(74,19,1,'12 V / 60 Ah',' ');
INSERT INTO answer VALUES(75,19,2,'2 V / 10 Ah',' ');
INSERT INTO answer VALUES(76,19,3,'2 V / 60 Ah',' ');
INSERT INTO answer VALUES(77,20,0,'Man nimmt an, dass der Strom vom Pluspol zum Minuspol fließt.',' ');
INSERT INTO answer VALUES(78,20,1,'Man nimmt an, dass der Strom vom Minuspol zum Pluspol fließt.',' ');
INSERT INTO answer VALUES(79,20,2,'Es ist die Flussrichtung der Elektronen vom Minuspol zum Pluspol.',' ');
INSERT INTO answer VALUES(80,20,3,'Es ist die Flussrichtung der Elektronen vom Pluspol zum Minuspol.',' ');
INSERT INTO answer VALUES(81,21,0,'Nein, weil kein geschlossener Stromkreis vorhanden ist.',' ');
INSERT INTO answer VALUES(82,21,1,'Nein, weil der Pluspol mit dem Minuspol verbunden ist.',' ');
INSERT INTO answer VALUES(83,21,2,'Ja, sogar Kurzschlussstrom, weil der Pluspol mit dem Minuspol verbunden ist.',' ');
INSERT INTO answer VALUES(84,21,3,'Ja. Der Strom hängt vom Innenwiderstand der Batterien ab.',' ');
INSERT INTO answer VALUES(85,22,0,'68 Stunden und 45 Minuten',' ');
INSERT INTO answer VALUES(86,22,1,'Genau 44 Stunden',' ');
INSERT INTO answer VALUES(87,22,2,'6 Stunden 52 Minuten und 30 Sekunden',' ');
INSERT INTO answer VALUES(88,22,3,'69 Stunden und 15 Minuten',' ');
INSERT INTO answer VALUES(89,23,0,'Volt pro Meter (V/m)',' ');
INSERT INTO answer VALUES(90,23,1,'Watt pro Quadratmeter (W/m<sup>2</sup>)',' ');
INSERT INTO answer VALUES(91,23,2,'Ampere pro Meter (A/m)',' ');
INSERT INTO answer VALUES(92,23,3,'Henry pro Meter (H/m)',' ');
INSERT INTO answer VALUES(93,24,0,'Homogenes elektrisches Feld',' ');
INSERT INTO answer VALUES(94,24,1,'Homogenes magnetisches Feld',' ');
INSERT INTO answer VALUES(95,24,2,'Polarisiertes elektrisches Feld',' ');
INSERT INTO answer VALUES(96,24,3,'Polarisiertes magnetisches Feld',' ');
INSERT INTO answer VALUES(97,25,0,'Elektrische Feldlinien',' ');
INSERT INTO answer VALUES(98,25,1,'Magnetische Feldlinien',' ');
INSERT INTO answer VALUES(99,25,2,'Polarisierte Feldlinien',' ');
INSERT INTO answer VALUES(100,25,3,'Horizontale Feldlinien',' ');
INSERT INTO answer VALUES(101,26,0,'Ampere pro Meter (A/m)',' ');
INSERT INTO answer VALUES(102,26,1,'Watt pro Quadratmeter (W/m<sup>2</sup>)',' ');
INSERT INTO answer VALUES(103,26,2,'Volt pro Meter (V/m)',' ');
INSERT INTO answer VALUES(104,26,3,'Henry pro Meter (H/m)',' ');
INSERT INTO answer VALUES(105,27,0,'Homogenes magnetisches Feld',' ');
INSERT INTO answer VALUES(106,27,1,'Homogenes elektrisches Feld',' ');
INSERT INTO answer VALUES(107,27,2,'Konzentrisches magnetisches Feld',' ');
INSERT INTO answer VALUES(108,27,3,'Zentriertes magnetisches Feld',' ');
INSERT INTO answer VALUES(109,28,0,'Magnetfeld aus konzentrischen Kreisen um den Leiter.',' ');
INSERT INTO answer VALUES(110,28,1,'elektrisches Feld aus konzentrischen Kreisen um den Leiter.',' ');
INSERT INTO answer VALUES(111,28,2,'homogenes Magnetfeld um den Leiter.',' ');
INSERT INTO answer VALUES(112,28,3,'homogenes elektrisches Feld um den Leiter.',' ');
INSERT INTO answer VALUES(113,29,0,'Magnetische Feldlinien',' ');
INSERT INTO answer VALUES(114,29,1,'Elektrische Feldlinien',' ');
INSERT INTO answer VALUES(115,29,2,'Radiale Feldlinien',' ');
INSERT INTO answer VALUES(116,29,3,'Vertikale Feldlinien',' ');
INSERT INTO answer VALUES(117,30,0,'Eisen',' ');
INSERT INTO answer VALUES(118,30,1,'Chrom',' ');
INSERT INTO answer VALUES(119,30,2,'Kupfer',' ');
INSERT INTO answer VALUES(120,30,3,'Aluminium',' ');
INSERT INTO answer VALUES(121,31,0,'wenn ein zeitlich schnell veränderlicher Strom durch einen elektrischen Leiter fließt, dessen Länge mindestens 1/100 der Wellenlänge ist.',' ');
INSERT INTO answer VALUES(122,31,1,'wenn durch einen elektrischen Leiter, dessen Länge mindestens 1/100 der Wellenlänge ist, ein konstanter Strom fließt.',' ');
INSERT INTO answer VALUES(123,31,2,'wenn sich elektrische Ladungen in einem Leiter befinden, dessen Länge mindestens 1/100 der Wellenlänge ist.',' ');
INSERT INTO answer VALUES(124,31,3,'wenn an einem elektrischen Leiter, dessen Länge mindestens 1/100 der Wellenlänge ist, eine konstante Spannung angelegt wird.',' ');
INSERT INTO answer VALUES(125,32,0,'durch eine Wechselwirkung zwischen elektrischem und magnetischem Feld.',' ');
INSERT INTO answer VALUES(126,32,1,'nur über das elektrische Feld. Das magnetische Feld ist nur im Nahfeld vorhanden.',' ');
INSERT INTO answer VALUES(127,32,2,'nur über das magnetische Feld. Das elektrische Feld ist nur im Nahfeld vorhanden.',' ');
INSERT INTO answer VALUES(128,32,3,'über die sich unabhängig voneinander ausbreitenden und senkrecht zueinander stehenden elektrischen und magnetischen Felder.',' ');
INSERT INTO answer VALUES(129,33,0,'Horizontale Polarisation',' ');
INSERT INTO answer VALUES(130,33,1,'Vertikale Polarisation',' ');
INSERT INTO answer VALUES(131,33,2,'Rechtsdrehende Polarisation',' ');
INSERT INTO answer VALUES(132,33,3,'Zirkulare Polarisation',' ');
INSERT INTO answer VALUES(133,34,0,'90°.',' ');
INSERT INTO answer VALUES(134,34,1,'45°.',' ');
INSERT INTO answer VALUES(135,34,2,'180°.',' ');
INSERT INTO answer VALUES(136,34,3,'360°.',' ');
INSERT INTO answer VALUES(137,35,0,'vertikal.',' ');
INSERT INTO answer VALUES(138,35,1,'horizontal.',' ');
INSERT INTO answer VALUES(139,35,2,'rechtsdrehend.',' ');
INSERT INTO answer VALUES(140,35,3,'linksdrehend.',' ');
INSERT INTO answer VALUES(141,36,0,'m',' ');
INSERT INTO answer VALUES(142,36,1,'m/s',' ');
INSERT INTO answer VALUES(143,36,2,'Hz',' ');
INSERT INTO answer VALUES(144,36,3,'s/m',' ');
INSERT INTO answer VALUES(145,37,0,'163 m',' ');
INSERT INTO answer VALUES(146,37,1,'16,3 m',' ');
INSERT INTO answer VALUES(147,37,2,'10,5 m',' ');
INSERT INTO answer VALUES(148,37,3,'61,3 m',' ');
INSERT INTO answer VALUES(149,38,0,'10,5 m',' ');
INSERT INTO answer VALUES(150,38,1,'163 m',' ');
INSERT INTO answer VALUES(151,38,2,'9,49 m',' ');
INSERT INTO answer VALUES(152,38,3,'61,3 m',' ');
INSERT INTO answer VALUES(153,39,0,'145,631 MHz',' ');
INSERT INTO answer VALUES(154,39,1,'148,927 MHz',' ');
INSERT INTO answer VALUES(155,39,2,'150,247 MHz',' ');
INSERT INTO answer VALUES(156,39,3,'135,754 MHz',' ');
INSERT INTO answer VALUES(157,40,0,'3,75 MHz',' ');
INSERT INTO answer VALUES(158,40,1,'3,65 MHz',' ');
INSERT INTO answer VALUES(159,40,2,'3,56 MHz',' ');
INSERT INTO answer VALUES(160,40,3,'3,57 MHz',' ');
INSERT INTO answer VALUES(161,41,0,'145 MHz',' ');
INSERT INTO answer VALUES(162,41,1,'145 µs',' ');
INSERT INTO answer VALUES(163,41,2,'145 kHz',' ');
INSERT INTO answer VALUES(164,41,3,'145 km/s',' ');
INSERT INTO answer VALUES(165,42,0,'20 kHz',' ');
INSERT INTO answer VALUES(166,42,1,'2 MHz',' ');
INSERT INTO answer VALUES(167,42,2,'200 kHz',' ');
INSERT INTO answer VALUES(168,42,3,'20 MHz',' ');
INSERT INTO answer VALUES(169,43,0,'VHF (very high frequency)',' ');
INSERT INTO answer VALUES(170,43,1,'UHF (ultra high frequency)',' ');
INSERT INTO answer VALUES(171,43,2,'MF (medium frequency)',' ');
INSERT INTO answer VALUES(172,43,3,'SHF (super high frequency)',' ');
INSERT INTO answer VALUES(173,44,0,'UHF-Bereich.',' ');
INSERT INTO answer VALUES(174,44,1,'VHF-Bereich.',' ');
INSERT INTO answer VALUES(175,44,2,'SHF-Bereich.',' ');
INSERT INTO answer VALUES(176,44,3,'EHF-Bereich.',' ');
INSERT INTO answer VALUES(177,45,0,'83,3 kHz',' ');
INSERT INTO answer VALUES(178,45,1,'833,3 kHz',' ');
INSERT INTO answer VALUES(179,45,2,'8,3 MHz',' ');
INSERT INTO answer VALUES(180,45,3,'83,3 MHz',' ');
INSERT INTO answer VALUES(181,46,0,'8,33 MHz',' ');
INSERT INTO answer VALUES(182,46,1,'16,7 MHz',' ');
INSERT INTO answer VALUES(183,46,2,'8,33 kHz',' ');
INSERT INTO answer VALUES(184,46,3,'833 kHz',' ');
INSERT INTO answer VALUES(185,47,0,'8,5 V',' ');
INSERT INTO answer VALUES(186,47,1,'6,0 V',' ');
INSERT INTO answer VALUES(187,47,2,'17 V',' ');
INSERT INTO answer VALUES(188,47,3,'24 V',' ');
INSERT INTO answer VALUES(189,48,0,'33,9 V',' ');
INSERT INTO answer VALUES(190,48,1,'24 V',' ');
INSERT INTO answer VALUES(191,48,2,'16,97 V',' ');
INSERT INTO answer VALUES(192,48,3,'36,4 V',' ');
INSERT INTO answer VALUES(193,49,0,'sinusförmig',' ');
INSERT INTO answer VALUES(194,49,1,'rechteckförmig',' ');
INSERT INTO answer VALUES(195,49,2,'dreieckförmig',' ');
INSERT INTO answer VALUES(196,49,3,'kreisförmig',' ');
INSERT INTO answer VALUES(197,50,0,'aus der Grundwelle mit ganzzahligen Vielfachen dieser Frequenz (Oberwellen).',' ');
INSERT INTO answer VALUES(198,50,1,'aus der Grundwelle und Teilen dieser Frequenz (Unterwellen).',' ');
INSERT INTO answer VALUES(199,50,2,'aus nur einer einzigen Frequenz.',' ');
INSERT INTO answer VALUES(200,50,3,'aus der Grundwelle mit vielen Nebenfrequenzen.',' ');
INSERT INTO answer VALUES(201,51,0,'AM hat einen Träger und zwei Seitenbänder, SSB arbeitet mit Trägerunterdrückung und einem Seitenband.',' ');
INSERT INTO answer VALUES(202,51,1,'AM hat einen Träger und ein Seitenband, SSB arbeitet mit Trägerunterdrückung und hat zwei Seitenbänder.',' ');
INSERT INTO answer VALUES(203,51,2,'AM hat keinen Träger und zwei Seitenbänder, SSB arbeitet mit Trägerunterdrückung und einem Seitenband.',' ');
INSERT INTO answer VALUES(204,51,3,'AM hat keinen Träger und zwei Seitenbänder, SSB arbeitet mit Träger und einem Seitenband.',' ');
INSERT INTO answer VALUES(205,52,0,'LSB arbeitet mit Trägerunterdrückung und dem unteren Seitenband, USB arbeitet mit Trägerunterdrückung und dem oberen Seitenband.',' ');
INSERT INTO answer VALUES(206,52,1,'LSB arbeitet mit Träger und zwei Seitenbändern, USB arbeitet mit Trägerunterdrückung und einem Seitenband.',' ');
INSERT INTO answer VALUES(207,52,2,'LSB arbeitet mit Träger und einem Seitenband, USB arbeitet mit Trägerunterdrückung und beiden Seitenbändern.',' ');
INSERT INTO answer VALUES(208,52,3,'LSB arbeitet mit Trägerunterdrückung und dem oberen Seitenband, USB arbeitet mit Trägerunterdrückung und dem unteren Seitenband.',' ');
INSERT INTO answer VALUES(209,53,0,'Bei FM ändert sich die Amplitude des Sendesignals bei Modulation nicht.',' ');
INSERT INTO answer VALUES(210,53,1,'Bei SSB ändert sich die Amplitude des Sendesignals bei Modulation nicht.',' ');
INSERT INTO answer VALUES(211,53,2,'Bei FM ändert sich die Amplitude des Sendesignals bei Modulation im Rhythmus der Sprache.',' ');
INSERT INTO answer VALUES(212,53,3,'Bei AM ändert sich die Amplitude des Sendesignals bei Modulation nicht.',' ');
INSERT INTO answer VALUES(213,54,0,'Bei FSK wird der Träger direkt und bei AFSK mit Hilfe des Audiosignals moduliert.',' ');
INSERT INTO answer VALUES(214,54,1,'Bei FSK wird der Träger frequenzmoduliert und bei AFSK amplitudenmoduliert.',' ');
INSERT INTO answer VALUES(215,54,2,'Bei FSK wird der Träger frequenzmoduliert und bei AFSK wird der Träger unterdrückt.',' ');
INSERT INTO answer VALUES(216,54,3,'Bei FSK wird der Träger amplitudenmoduliert und bei AFSK frequenzmoduliert.',' ');
INSERT INTO answer VALUES(217,55,0,'Sie entspricht genau der Bandbreite des NF-Signals.',' ');
INSERT INTO answer VALUES(218,55,1,'Sie entspricht der Hälfte der Bandbreite des NF-Signals.',' ');
INSERT INTO answer VALUES(219,55,2,'Sie entspricht der doppelten Bandbreite des NF-Signals.',' ');
INSERT INTO answer VALUES(220,55,3,'Sie ist Null, weil bei SSB-Modulation der HF-Träger unterdrückt wird.',' ');
INSERT INTO answer VALUES(221,56,0,'3,648 MHz',' ');
INSERT INTO answer VALUES(222,56,1,'3,650 MHz',' ');
INSERT INTO answer VALUES(223,56,2,'3,652 MHz',' ');
INSERT INTO answer VALUES(224,56,3,'3,648 MHz und 3,652 MHz',' ');
INSERT INTO answer VALUES(225,57,0,'Watt',' ');
INSERT INTO answer VALUES(226,57,1,'Joule',' ');
INSERT INTO answer VALUES(227,57,2,'Kilowattstunden',' ');
INSERT INTO answer VALUES(228,57,3,'Amperestunden',' ');
INSERT INTO answer VALUES(229,58,0,'U = R * I',' ');
INSERT INTO answer VALUES(230,58,1,'R = U * I',' ');
INSERT INTO answer VALUES(231,58,2,'R = I / U',' ');
INSERT INTO answer VALUES(232,58,3,'I = R / U',' ');
INSERT INTO answer VALUES(233,59,0,'100 Volt',' ');
INSERT INTO answer VALUES(234,59,1,'200 Volt',' ');
INSERT INTO answer VALUES(235,59,2,'25 Volt',' ');
INSERT INTO answer VALUES(236,59,3,'52 Volt',' ');
INSERT INTO answer VALUES(237,60,0,'30 &Omega;',' ');
INSERT INTO answer VALUES(238,60,1,'1/30 &Omega;',' ');
INSERT INTO answer VALUES(239,60,2,'270 &Omega;',' ');
INSERT INTO answer VALUES(240,60,3,'93 &Omega;',' ');
INSERT INTO answer VALUES(241,61,0,'1,01 kWh',' ');
INSERT INTO answer VALUES(242,61,1,'0,1 kWh',' ');
INSERT INTO answer VALUES(243,61,2,'2,56 kWh',' ');
INSERT INTO answer VALUES(244,61,3,'20,7 kWh',' ');
INSERT INTO answer VALUES(245,62,0,'4 A.',' ');
INSERT INTO answer VALUES(246,62,1,'250 mA.',' ');
INSERT INTO answer VALUES(247,62,2,'750 mA.',' ');
INSERT INTO answer VALUES(248,62,3,'36 A.',' ');
INSERT INTO answer VALUES(249,63,0,'200 W.',' ');
INSERT INTO answer VALUES(250,63,1,'141 W.',' ');
INSERT INTO answer VALUES(251,63,2,'100 W.',' ');
INSERT INTO answer VALUES(252,63,3,'283 W.',' ');
INSERT INTO answer VALUES(253,64,0,'200 W.',' ');
INSERT INTO answer VALUES(254,64,1,'100 W.',' ');
INSERT INTO answer VALUES(255,64,2,'25 W.',' ');
INSERT INTO answer VALUES(256,64,3,'250 W.',' ');
INSERT INTO answer VALUES(257,65,0,'8,33 A',' ');
INSERT INTO answer VALUES(258,65,1,'16,6 A',' ');
INSERT INTO answer VALUES(259,65,2,'1200 A',' ');
INSERT INTO answer VALUES(260,65,3,'0,12 A',' ');
INSERT INTO answer VALUES(261,66,0,'1 W.',' ');
INSERT INTO answer VALUES(262,66,1,'10 W.',' ');
INSERT INTO answer VALUES(263,66,2,'0,01 W.',' ');
INSERT INTO answer VALUES(264,66,3,'100 mW.',' ');
INSERT INTO answer VALUES(265,67,0,'2,5 W',' ');
INSERT INTO answer VALUES(266,67,1,'1 W',' ');
INSERT INTO answer VALUES(267,67,2,'25 W',' ');
INSERT INTO answer VALUES(268,67,3,'250 mW',' ');
INSERT INTO answer VALUES(269,68,0,'47 k&Omega;',' ');
INSERT INTO answer VALUES(270,68,1,'4,7 k&Omega;',' ');
INSERT INTO answer VALUES(271,68,2,'470 k&Omega;',' ');
INSERT INTO answer VALUES(272,68,3,'4,7 M&Omega;',' ');
INSERT INTO answer VALUES(273,69,0,'4,7 k&Omega;',' ');
INSERT INTO answer VALUES(274,69,1,'47 k&Omega;',' ');
INSERT INTO answer VALUES(275,69,2,'470 k&Omega;',' ');
INSERT INTO answer VALUES(276,69,3,'4,7 M&Omega;',' ');
INSERT INTO answer VALUES(277,70,0,'27 k&Omega;',' ');
INSERT INTO answer VALUES(278,70,1,'2,7 k&Omega;',' ');
INSERT INTO answer VALUES(279,70,2,'270 k&Omega;',' ');
INSERT INTO answer VALUES(280,70,3,'2,7 M&Omega;',' ');
INSERT INTO answer VALUES(281,71,0,'2,7 k&Omega;',' ');
INSERT INTO answer VALUES(282,71,1,'27 k&Omega;',' ');
INSERT INTO answer VALUES(283,71,2,'270 k&Omega;',' ');
INSERT INTO answer VALUES(284,71,3,'2,7 M&Omega;',' ');
INSERT INTO answer VALUES(285,72,0,'NTC',' ');
INSERT INTO answer VALUES(286,72,1,'PTC',' ');
INSERT INTO answer VALUES(287,72,2,'LDR',' ');
INSERT INTO answer VALUES(288,72,3,'VDR',' ');
INSERT INTO answer VALUES(289,73,0,'<img src=''etc106a.png''>',' ');
INSERT INTO answer VALUES(290,73,1,'<img src=''etc106b.png''>',' ');
INSERT INTO answer VALUES(291,73,2,'<img src=''etc106c.png''>',' ');
INSERT INTO answer VALUES(292,73,3,'<img src=''etc106d.png''>',' ');
INSERT INTO answer VALUES(293,74,0,'<img src=''etc107a.png''>',' ');
INSERT INTO answer VALUES(294,74,1,'<img src=''etc107b.png''>',' ');
INSERT INTO answer VALUES(295,74,2,'<img src=''etc107c.png''>',' ');
INSERT INTO answer VALUES(296,74,3,'<img src=''etc107d.png''>',' ');
INSERT INTO answer VALUES(297,75,0,'5040 und 6160 &Omega;.',' ');
INSERT INTO answer VALUES(298,75,1,'4760 und 6440 &Omega;.',' ');
INSERT INTO answer VALUES(299,75,2,'4,7 und 6,8 k&Omega;.',' ');
INSERT INTO answer VALUES(300,75,3,'5,2 und 6,3 k&Omega;.',' ');
INSERT INTO answer VALUES(301,76,0,'Ein Metalloxidwiderstand',' ');
INSERT INTO answer VALUES(302,76,1,'Ein Kohleschichtwiderstand',' ');
INSERT INTO answer VALUES(303,76,2,'Ein keramischer Drahtwiderstand',' ');
INSERT INTO answer VALUES(304,76,3,'Ein frei gewickelter Drahtwiderstand aus Kupferdraht',' ');
INSERT INTO answer VALUES(305,77,0,'220 &Omega;',' ');
INSERT INTO answer VALUES(306,77,1,'221 &Omega;',' ');
INSERT INTO answer VALUES(307,77,2,'22 &Omega;',' ');
INSERT INTO answer VALUES(308,77,3,'22 k&Omega;',' ');
INSERT INTO answer VALUES(309,78,0,'22 k&Omega;',' ');
INSERT INTO answer VALUES(310,78,1,'221 &Omega;',' ');
INSERT INTO answer VALUES(311,78,2,'22 &Omega;',' ');
INSERT INTO answer VALUES(312,78,3,'220 &Omega;',' ');
INSERT INTO answer VALUES(313,79,0,'Je größer der Plattenabstand ist, desto kleiner ist die Kapazität.',' ');
INSERT INTO answer VALUES(314,79,1,'Je größer die angelegte Spannung ist, desto kleiner ist die Kapazität.',' ');
INSERT INTO answer VALUES(315,79,2,'Je größer die Plattenoberfläche ist, desto kleiner ist die Kapazität.',' ');
INSERT INTO answer VALUES(316,79,3,'Je größer die Dielektrizitätszahl ist, desto kleiner ist die Kapazität.',' ');
INSERT INTO answer VALUES(317,80,0,'Drehkondensator.',' ');
INSERT INTO answer VALUES(318,80,1,'Tauchkondensator.',' ');
INSERT INTO answer VALUES(319,80,2,'Keramischer Kondensator.',' ');
INSERT INTO answer VALUES(320,80,3,'Rotorkondensator.',' ');
INSERT INTO answer VALUES(321,81,0,'330 µF',' ');
INSERT INTO answer VALUES(322,81,1,'3,3 µF',' ');
INSERT INTO answer VALUES(323,81,2,'33 µF',' ');
INSERT INTO answer VALUES(324,81,3,'33000 µF',' ');
INSERT INTO answer VALUES(325,82,0,'470 pF',' ');
INSERT INTO answer VALUES(326,82,1,'4,7 pF',' ');
INSERT INTO answer VALUES(327,82,2,'47 pF',' ');
INSERT INTO answer VALUES(328,82,3,'47000 pF',' ');
INSERT INTO answer VALUES(329,83,0,'8,2 pF',' ');
INSERT INTO answer VALUES(330,83,1,'820 pF',' ');
INSERT INTO answer VALUES(331,83,2,'82 pF',' ');
INSERT INTO answer VALUES(332,83,3,'0,82 pF',' ');
INSERT INTO answer VALUES(333,84,0,'0,3 µF',' ');
INSERT INTO answer VALUES(334,84,1,'2,73 nF',' ');
INSERT INTO answer VALUES(335,84,2,'0,027 µF',' ');
INSERT INTO answer VALUES(336,84,3,'0,255 µF',' ');
INSERT INTO answer VALUES(337,85,0,'Elektrolytkondensator',' ');
INSERT INTO answer VALUES(338,85,1,'Keramischer Kondensator',' ');
INSERT INTO answer VALUES(339,85,2,'Styroflexkondensator',' ');
INSERT INTO answer VALUES(340,85,3,'Plattenkondensator',' ');
INSERT INTO answer VALUES(341,86,0,'sinkt der Wechselstromwiderstand von Kondensatoren.',' ');
INSERT INTO answer VALUES(342,86,1,'sinkt der Wechselstromwiderstand von Kondensatoren bis zu einem Minimum und steigt dann wieder.',' ');
INSERT INTO answer VALUES(343,86,2,'steigt der Wechselstromwiderstand von Kondensatoren.',' ');
INSERT INTO answer VALUES(344,86,3,'steigt der Wechselstromwiderstand von Kondensatoren bis zu einem Maximum und sinkt dann wieder.',' ');
INSERT INTO answer VALUES(345,87,0,'Die Induktivität steigt auf 48 µH.',' ');
INSERT INTO answer VALUES(346,87,1,'Die Induktivität steigt auf 24 µH.',' ');
INSERT INTO answer VALUES(347,87,2,'Die Induktivität sinkt auf 6 µH.',' ');
INSERT INTO answer VALUES(348,87,3,'Die Induktivität sinkt auf 3 µH.',' ');
INSERT INTO answer VALUES(349,88,0,'Die Induktivität sinkt auf 6 µH.',' ');
INSERT INTO answer VALUES(350,88,1,'Die Induktivität steigt auf 24 µH.',' ');
INSERT INTO answer VALUES(351,88,2,'Die Induktivität steigt auf 48 µH.',' ');
INSERT INTO answer VALUES(352,88,3,'Die Induktivität sinkt auf 3 µH.',' ');
INSERT INTO answer VALUES(353,89,0,'Durch Stauchen der Spule (Verkürzen der Spulenlänge).',' ');
INSERT INTO answer VALUES(354,89,1,'Durch Auseinanderziehen der Spule (Vergrößerung der Spulenlänge).',' ');
INSERT INTO answer VALUES(355,89,2,'Durch Einführen eines Kupferkerns in die Spule.',' ');
INSERT INTO answer VALUES(356,89,3,'Durch Einbau der Spule in einen Abschirmbecher.',' ');
INSERT INTO answer VALUES(357,90,0,'Ferrit bestehen.',' ');
INSERT INTO answer VALUES(358,90,1,'Kunststoff bestehen.',' ');
INSERT INTO answer VALUES(359,90,2,'Stahl bestehen.',' ');
INSERT INTO answer VALUES(360,90,3,'aus gut leitendem Material bestehen.',' ');
INSERT INTO answer VALUES(361,91,0,'leuchtet H1 zuerst.',' ');
INSERT INTO answer VALUES(362,91,1,'leuchtet H2 zuerst.',' ');
INSERT INTO answer VALUES(363,91,2,'leuchten H1 und H2 genau gleich schnell.',' ');
INSERT INTO answer VALUES(364,91,3,'leuchtet H2 kurz auf und geht wieder aus. H1 leuchtet.',' ');
INSERT INTO answer VALUES(365,92,0,'steigt der Wechselstromwiderstand einer Spule.',' ');
INSERT INTO answer VALUES(366,92,1,'sinkt der Wechselstromwiderstand einer Spule.',' ');
INSERT INTO answer VALUES(367,92,2,'sinkt der Wechselstromwiderstand einer Spule bis zu einem Minimum und steigt dann wieder.',' ');
INSERT INTO answer VALUES(368,92,3,'steigt der Wechselstromwiderstand einer Spule bis zu einem Maximum und sinkt dann wieder.',' ');
INSERT INTO answer VALUES(369,93,0,'30 Windungen',' ');
INSERT INTO answer VALUES(370,93,1,'20 Windungen',' ');
INSERT INTO answer VALUES(371,93,2,'52 Windungen',' ');
INSERT INTO answer VALUES(372,93,3,'180 Windungen',' ');
INSERT INTO answer VALUES(373,94,0,'600 Windungen',' ');
INSERT INTO answer VALUES(374,94,1,'850 Windungen',' ');
INSERT INTO answer VALUES(375,94,2,'46 Windungen',' ');
INSERT INTO answer VALUES(376,94,3,'30 Windungen',' ');
INSERT INTO answer VALUES(377,95,0,'46 Volt',' ');
INSERT INTO answer VALUES(378,95,1,'9,2 Volt',' ');
INSERT INTO answer VALUES(379,95,2,'23 Volt',' ');
INSERT INTO answer VALUES(380,95,3,'1150 Volt',' ');
INSERT INTO answer VALUES(381,96,0,'weniger als vier Valenzelektronen enthält.',' ');
INSERT INTO answer VALUES(382,96,1,'mehr als vier Valenzelektronen enthält.',' ');
INSERT INTO answer VALUES(383,96,2,'genau vier Valenzelektronen enthält.',' ');
INSERT INTO answer VALUES(384,96,3,'keine Valenzelektronen enthält.',' ');
INSERT INTO answer VALUES(385,97,0,'Überschuss an freien Elektronen.',' ');
INSERT INTO answer VALUES(386,97,1,'das Fehlen von Dotierungsatomen.',' ');
INSERT INTO answer VALUES(387,97,2,'das Fehlen von Atomen im Gitter des Halbleiterkristalls.',' ');
INSERT INTO answer VALUES(388,97,3,'bewegliche Elektronenlücken.',' ');
INSERT INTO answer VALUES(389,98,0,'den Stromfluss von P nach N.',' ');
INSERT INTO answer VALUES(390,98,1,'den Stromfluss von N nach P.',' ');
INSERT INTO answer VALUES(391,98,2,'keinen Stromfluss.',' ');
INSERT INTO answer VALUES(392,98,3,'den Elektronenfluss von P nach N.',' ');
INSERT INTO answer VALUES(393,99,0,'einen hohen Widerstand.',' ');
INSERT INTO answer VALUES(394,99,1,'eine hohe Kapazität.',' ');
INSERT INTO answer VALUES(395,99,2,'eine geringe Impedanz.',' ');
INSERT INTO answer VALUES(396,99,3,'eine hohe Induktivität.',' ');
INSERT INTO answer VALUES(397,100,0,'0,7 V <img src=''etc505a.png''>1,3 V',' ');
INSERT INTO answer VALUES(398,100,1,'-2,6 V <img src=''etc505b.png''> -2,0 V',' ');
INSERT INTO answer VALUES(399,100,2,'15 V <img src=''etc505a.png''> 9 V',' ');
INSERT INTO answer VALUES(400,100,3,'3,4 V <img src=''etc505b.png''> 4,0 V',' ');
INSERT INTO answer VALUES(401,101,0,'-2 V <img src=''etc505b.png''> -2,6 V',' ');
INSERT INTO answer VALUES(402,101,1,'5,3 V <img src=''etc505a.png''> 4,7 V',' ');
INSERT INTO answer VALUES(403,101,2,'15 V <img src=''etc505b.png''> 18 V',' ');
INSERT INTO answer VALUES(404,101,3,'3,9 V <img src=''etc505a.png''> 3,2 V',' ');
INSERT INTO answer VALUES(405,102,0,'Sie nimmt mit abnehmender Sperrspannung zu.',' ');
INSERT INTO answer VALUES(406,102,1,'Sie erhöht sich mit zunehmender Durchlassspannung.',' ');
INSERT INTO answer VALUES(407,102,2,'Sie nimmt mit zunehmender Sperrspannung zu.',' ');
INSERT INTO answer VALUES(408,102,3,'Sie erhöht sich mit zunehmendem Durchlassstrom.',' ');
INSERT INTO answer VALUES(409,103,0,'zur Spannungsstabilisierung.',' ');
INSERT INTO answer VALUES(410,103,1,'zur Signalbegrenzung.',' ');
INSERT INTO answer VALUES(411,103,2,'als Leuchtanzeige.',' ');
INSERT INTO answer VALUES(412,103,3,'zur Stromgewinnung.',' ');
INSERT INTO answer VALUES(413,104,0,'als Leuchtanzeige.',' ');
INSERT INTO answer VALUES(414,104,1,'zur Signalbegrenzung.',' ');
INSERT INTO answer VALUES(415,104,2,'zur Spannungsstabilisierung.',' ');
INSERT INTO answer VALUES(416,104,3,'zur Stromgewinnung.',' ');
INSERT INTO answer VALUES(417,105,0,'Mit einem geringen Strom (Basisstrom) wird ein großer Strom (Kollektorstrom) gesteuert.',' ');
INSERT INTO answer VALUES(418,105,1,'Mit einem geringen Strom (Emitterstrom) wird ein großer Strom (Kollektorstrom) gesteuert.',' ');
INSERT INTO answer VALUES(419,105,2,'Mit einem geringen Strom (Emitterstrom) wird ein großer Strom (Basisstrom) gesteuert.',' ');
INSERT INTO answer VALUES(420,105,3,'Mit einem geringen Strom (Kollektorstrom) wird ein großer Strom (Emitterstrom) gesteuert.',' ');
INSERT INTO answer VALUES(421,106,0,'10 zu 1 bis 900 zu 1.',' ');
INSERT INTO answer VALUES(422,106,1,'1 zu 50 bis 1 zu 100.',' ');
INSERT INTO answer VALUES(423,106,2,'1000 zu 1 bis 5000 zu 1.',' ');
INSERT INTO answer VALUES(424,106,3,'1 zu 100 bis 1 zu 500.',' ');
INSERT INTO answer VALUES(425,107,0,'NPN-Transistor.',' ');
INSERT INTO answer VALUES(426,107,1,'PNP-Transistor.',' ');
INSERT INTO answer VALUES(427,107,2,'Sperrschicht-FET.',' ');
INSERT INTO answer VALUES(428,107,3,'MOSFET.',' ');
INSERT INTO answer VALUES(429,108,0,'PNP-Transistor.',' ');
INSERT INTO answer VALUES(430,108,1,'NPN-Transistor.',' ');
INSERT INTO answer VALUES(431,108,2,'P-Kanal-FET.',' ');
INSERT INTO answer VALUES(432,108,3,'N-Kanal-FET.',' ');
INSERT INTO answer VALUES(433,109,0,'NPN-Transistoren benötigen positive, PNP-Transistoren negative Kollektorspannungen.',' ');
INSERT INTO answer VALUES(434,109,1,'NPN- und PNP-Transistoren benötigen negative Kollektorspannungen.',' ');
INSERT INTO answer VALUES(435,109,2,'PNP-Transistoren benötigen positive, NPN-Transistoren negative Kollektorspannung.',' ');
INSERT INTO answer VALUES(436,109,3,'PNP- und NPN-Transistoren benötigen positive Kollektorspannungen.',' ');
INSERT INTO answer VALUES(437,110,0,'in Durchlassrichtung.',' ');
INSERT INTO answer VALUES(438,110,1,'im Leerlauf.',' ');
INSERT INTO answer VALUES(439,110,2,'im Kurzschluss.',' ');
INSERT INTO answer VALUES(440,110,3,'in Sperrrichtung.',' ');
INSERT INTO answer VALUES(441,111,0,'NPN- und PNP-Transistoren',' ');
INSERT INTO answer VALUES(442,111,1,'Dual-Gate-MOS-FETs',' ');
INSERT INTO answer VALUES(443,111,2,'Isolierschicht-FETs',' ');
INSERT INTO answer VALUES(444,111,3,'Sperrschicht-FETs',' ');
INSERT INTO answer VALUES(445,112,0,'Emitter, Basis, Kollektor',' ');
INSERT INTO answer VALUES(446,112,1,'Emitter, Drain, Source',' ');
INSERT INTO answer VALUES(447,112,2,'Drain, Source, Kollektor',' ');
INSERT INTO answer VALUES(448,112,3,'Drain, Gate, Source',' ');
INSERT INTO answer VALUES(449,113,0,'stromgesteuert.',' ');
INSERT INTO answer VALUES(450,113,1,'spannungsgesteuert.',' ');
INSERT INTO answer VALUES(451,113,2,'thermisch gesteuert.',' ');
INSERT INTO answer VALUES(452,113,3,'ein Gleichspannungsverstärker.',' ');
INSERT INTO answer VALUES(453,114,0,'fließt kein Kollektorstrom.',' ');
INSERT INTO answer VALUES(454,114,1,'fließt ein Kollektorstrom von etwa 0,6 A.',' ');
INSERT INTO answer VALUES(455,114,2,'liegt der Kollektorstrom zwischen 10 mA und 2 A.',' ');
INSERT INTO answer VALUES(456,114,3,'fließt ein sehr hoher Kollektor-Kurzschlussstrom.',' ');
INSERT INTO answer VALUES(457,115,0,'Die Gatespannung steuert den Widerstand des Kanals zwischen Source und Drain.',' ');
INSERT INTO answer VALUES(458,115,1,'Die Gatespannung ist allein verantwortlich für den Drainstrom.',' ');
INSERT INTO answer VALUES(459,115,2,'Der Gatestrom ist allein verantwortlich für den Drainstrom.',' ');
INSERT INTO answer VALUES(460,115,3,'Der Gatestrom steuert den Widerstand des Kanals zwischen Source und Drain.',' ');
INSERT INTO answer VALUES(461,116,0,'1 ... Drain, 2 … Source, 3 … Gate.',' ');
INSERT INTO answer VALUES(462,116,1,'1 ... Source, 2 … Drain, 3 … Gate.',' ');
INSERT INTO answer VALUES(463,116,2,'1 ... Anode, 2 … Katode, 3 … Gate.',' ');
INSERT INTO answer VALUES(464,116,3,'1 ... Kollektor, 2 … Emitter, 3 … Basis.',' ');
INSERT INTO answer VALUES(465,117,0,'1 k&Omega;',' ');
INSERT INTO answer VALUES(466,117,1,'2,5 k&Omega;',' ');
INSERT INTO answer VALUES(467,117,2,'501 &Omega;',' ');
INSERT INTO answer VALUES(468,117,3,'5,1 k&Omega;',' ');
INSERT INTO answer VALUES(469,118,0,'2 k&Omega;',' ');
INSERT INTO answer VALUES(470,118,1,'2,5 k&Omega;',' ');
INSERT INTO answer VALUES(471,118,2,'501 &Omega;',' ');
INSERT INTO answer VALUES(472,118,3,'5,1 k&Omega;',' ');
INSERT INTO answer VALUES(473,119,0,'500 &Omega;',' ');
INSERT INTO answer VALUES(474,119,1,'250 &Omega;',' ');
INSERT INTO answer VALUES(475,119,2,'1 k&Omega;',' ');
INSERT INTO answer VALUES(476,119,3,'2 k&Omega;',' ');
INSERT INTO answer VALUES(477,120,0,'1 k&Omega;',' ');
INSERT INTO answer VALUES(478,120,1,'4 k&Omega;',' ');
INSERT INTO answer VALUES(479,120,2,'500 &Omega;',' ');
INSERT INTO answer VALUES(480,120,3,'2 k&Omega;',' ');
INSERT INTO answer VALUES(481,121,0,'5 nF',' ');
INSERT INTO answer VALUES(482,121,1,'0,015 nF',' ');
INSERT INTO answer VALUES(483,121,2,'7,5 nF',' ');
INSERT INTO answer VALUES(484,121,3,'10 nF',' ');
INSERT INTO answer VALUES(485,122,0,'10 nF',' ');
INSERT INTO answer VALUES(486,122,1,'5 nF',' ');
INSERT INTO answer VALUES(487,122,2,'2,5 nF',' ');
INSERT INTO answer VALUES(488,122,3,'40 nF',' ');
INSERT INTO answer VALUES(489,123,0,'10 nF',' ');
INSERT INTO answer VALUES(490,123,1,'5 nF',' ');
INSERT INTO answer VALUES(491,123,2,'2,5 nF',' ');
INSERT INTO answer VALUES(492,123,3,'0,015 nF',' ');
INSERT INTO answer VALUES(493,124,0,'2,20 V',' ');
INSERT INTO answer VALUES(494,124,1,'2,64 V',' ');
INSERT INTO answer VALUES(495,124,2,'10,0 V',' ');
INSERT INTO answer VALUES(496,124,3,'1,22 V',' ');
INSERT INTO answer VALUES(497,125,0,'12 &Omega;',' ');
INSERT INTO answer VALUES(498,125,1,'50 &Omega;',' ');
INSERT INTO answer VALUES(499,125,2,'15 &Omega;',' ');
INSERT INTO answer VALUES(500,125,3,'3,5 &Omega;',' ');
INSERT INTO answer VALUES(501,126,0,'60 &Omega;',' ');
INSERT INTO answer VALUES(502,126,1,'250 &Omega;',' ');
INSERT INTO answer VALUES(503,126,2,'75 &Omega;',' ');
INSERT INTO answer VALUES(504,126,3,'17,5 &Omega;',' ');
INSERT INTO answer VALUES(505,127,0,'eines Serienschwingkreises.',' ');
INSERT INTO answer VALUES(506,127,1,'eines Parallelschwingkreises.',' ');
INSERT INTO answer VALUES(507,127,2,'einer Induktivität.',' ');
INSERT INTO answer VALUES(508,127,3,'einer Kapazität.',' ');
INSERT INTO answer VALUES(509,128,0,'einen Parallelschwingkreis.',' ');
INSERT INTO answer VALUES(510,128,1,'einen Kondensator.',' ');
INSERT INTO answer VALUES(511,128,2,'eine Spule.',' ');
INSERT INTO answer VALUES(512,128,3,'einen Serienschwingkreis.',' ');
INSERT INTO answer VALUES(513,129,0,'<img src=''etd203a.png''>',' ');
INSERT INTO answer VALUES(514,129,1,'<img src=''etd203b.png''>',' ');
INSERT INTO answer VALUES(515,129,2,'<img src=''etd203c.png''>',' ');
INSERT INTO answer VALUES(516,129,3,'<img src=''etd203d.png''>',' ');
INSERT INTO answer VALUES(517,130,0,'Die Resonanzfrequenz wird bei 1. größer und bei 2. und 3. kleiner.',' ');
INSERT INTO answer VALUES(518,130,1,'Die Resonanzfrequenz wird bei 1. und 2. kleiner und bei 3. größer.',' ');
INSERT INTO answer VALUES(519,130,2,'Die Resonanzfrequenz wird bei 1. kleiner und bei 2. und 3. größer.',' ');
INSERT INTO answer VALUES(520,130,3,'Die Resonanzfrequenz wird bei 1. und 2. größer und bei 3. kleiner.',' ');
INSERT INTO answer VALUES(521,131,0,'Wie ein hochohmiger Widerstand.',' ');
INSERT INTO answer VALUES(522,131,1,'Wie ein niederohmiger Widerstand.',' ');
INSERT INTO answer VALUES(523,131,2,'Wie ein Kondensator mit sehr kleiner Kapazität.',' ');
INSERT INTO answer VALUES(524,131,3,'Wie eine Spule mit sehr großer Induktivität.',' ');
INSERT INTO answer VALUES(525,132,0,'Hochpass',' ');
INSERT INTO answer VALUES(526,132,1,'Sperrkreis',' ');
INSERT INTO answer VALUES(527,132,2,'Bandpass',' ');
INSERT INTO answer VALUES(528,132,3,'Tiefpass',' ');
INSERT INTO answer VALUES(529,133,0,'Sperrkreis',' ');
INSERT INTO answer VALUES(530,133,1,'Saugkreis',' ');
INSERT INTO answer VALUES(531,133,2,'Bandpass',' ');
INSERT INTO answer VALUES(532,133,3,'Tiefpass',' ');
INSERT INTO answer VALUES(533,134,0,'Tiefpass',' ');
INSERT INTO answer VALUES(534,134,1,'Sperrkreis',' ');
INSERT INTO answer VALUES(535,134,2,'Bandpass',' ');
INSERT INTO answer VALUES(536,134,3,'Hochpass',' ');
INSERT INTO answer VALUES(537,135,0,'Saugkreis',' ');
INSERT INTO answer VALUES(538,135,1,'Sperrkreis',' ');
INSERT INTO answer VALUES(539,135,2,'Bandpass',' ');
INSERT INTO answer VALUES(540,135,3,'Tiefpass',' ');
INSERT INTO answer VALUES(541,136,0,'Frequenzen oberhalb der Grenzfrequenz werden durchgelassen.',' ');
INSERT INTO answer VALUES(542,136,1,'Frequenzen unterhalb der Grenzfrequenz werden verstärkt.',' ');
INSERT INTO answer VALUES(543,136,2,'Frequenzen oberhalb der Grenzfrequenz werden stark bedämpft.',' ');
INSERT INTO answer VALUES(544,136,3,'Frequenzen unterhalb der Grenzfrequenz werden ungedämpft durchgelassen.',' ');
INSERT INTO answer VALUES(545,137,0,'Spannungsquellen sollten einen möglichst niedrigen Innenwiderstand und Stromquellen einen möglichst hohen Innenwiderstand haben.',' ');
INSERT INTO answer VALUES(546,137,1,'Strom- und Spannungsquellen sollten einen möglichst niedrigen Innenwiderstand haben.',' ');
INSERT INTO answer VALUES(547,137,2,'Strom- und Spannungsquellen sollten einen möglichst hohen Innenwiderstand haben.',' ');
INSERT INTO answer VALUES(548,137,3,'Spannungsquellen sollten einen möglichst hohen Innenwiderstand und Stromquellen einen möglichst niedrigen Innenwiderstand haben.',' ');
INSERT INTO answer VALUES(549,138,0,'1,1 &Omega;',' ');
INSERT INTO answer VALUES(550,138,1,'13,5 &Omega;',' ');
INSERT INTO answer VALUES(551,138,2,'12,4 &Omega;',' ');
INSERT INTO answer VALUES(552,138,3,'1,2 &Omega;',' ');
INSERT INTO answer VALUES(553,139,0,'0,25 &Omega;',' ');
INSERT INTO answer VALUES(554,139,1,'6,75 &Omega;',' ');
INSERT INTO answer VALUES(555,139,2,'13 &Omega;',' ');
INSERT INTO answer VALUES(556,139,3,'6,5 &Omega;',' ');
INSERT INTO answer VALUES(557,140,0,'Zirka 65 Volt',' ');
INSERT INTO answer VALUES(558,140,1,'Zirka 46 Volt',' ');
INSERT INTO answer VALUES(559,140,2,'Zirka 40 Volt',' ');
INSERT INTO answer VALUES(560,140,3,'Zirka 28 Volt',' ');
INSERT INTO answer VALUES(561,141,0,'Zirka 40 Volt',' ');
INSERT INTO answer VALUES(562,141,1,'Zirka 46 Volt',' ');
INSERT INTO answer VALUES(563,141,2,'Zirka 65 Volt',' ');
INSERT INTO answer VALUES(564,141,3,'Zirka 28 Volt',' ');
INSERT INTO answer VALUES(565,142,0,'Ein Schaltnetzteil erzeugt Oberwellen seiner Taktfrequenz, die beim Empfang zu Störungen führen können.',' ');
INSERT INTO answer VALUES(566,142,1,'Ein Schaltnetzteil benötigt einen größeren Transformator.',' ');
INSERT INTO answer VALUES(567,142,2,'Ein Schaltnetzteil kann keine so hohen Ströme abgeben.',' ');
INSERT INTO answer VALUES(568,142,3,'Ein Schaltnetzteil hat höhere Verluste.',' ');
INSERT INTO answer VALUES(569,143,0,'Transistor, MOSFET, Operationsverstärker, Röhre',' ');
INSERT INTO answer VALUES(570,143,1,'Transistor, Halbleiterdiode, Operationsverstärker, Röhre',' ');
INSERT INTO answer VALUES(571,143,2,'Transistor, Varicap-Diode, Operationsverstärker, Röhre',' ');
INSERT INTO answer VALUES(572,143,3,'Transistor, MOSFET, Halbleiterdiode, Röhre',' ');
INSERT INTO answer VALUES(573,144,0,'das Ausgangssignal gegenüber dem Eingangssignal in der Leistung größer ist.',' ');
INSERT INTO answer VALUES(574,144,1,'das Eingangssignal gegenüber dem Ausgangssignal in der Leistung größer ist.',' ');
INSERT INTO answer VALUES(575,144,2,'z.B. bei einem Transformator die Ausgangsspannung größer ist als die Eingangsspannung.',' ');
INSERT INTO answer VALUES(576,144,3,'das Eingangssignal gegenüber dem Ausgangssignal in der Spannung größer ist.',' ');
INSERT INTO answer VALUES(577,145,0,'Operationsverstärker sind Gleichstrom gekoppelte Verstärker mit sehr hohem Verstärkungsfaktor und großer Linearität.',' ');
INSERT INTO answer VALUES(578,145,1,'Operationsverstärker sind Wechselstrom gekoppelte Verstärker mit niedrigem Eingangswiderstand und großer Linearität.',' ');
INSERT INTO answer VALUES(579,145,2,'Operationsverstärker sind in Empfängerstufen eingebaute Analogverstärker mit sehr niedrigem Verstärkungsfaktor aber großer Linearität.',' ');
INSERT INTO answer VALUES(580,145,3,'Operationsverstärker sind digitale Schaltkreise mit hohem Verstärkungsfaktor.',' ');
INSERT INTO answer VALUES(581,146,0,'eine komplexe Schaltung auf einem Halbleiterkristallplättchen.',' ');
INSERT INTO answer VALUES(582,146,1,'eine aus vielen einzelnen Bauteilen aufgebaute Schaltung auf einer Platine.',' ');
INSERT INTO answer VALUES(583,146,2,'eine miniaturisierte, aus SMD-Bauteilen aufgebaute Schaltung.',' ');
INSERT INTO answer VALUES(584,146,3,'eine Zusammenschaltung verschiedener Baugruppen zu einer Funktionseinheit.',' ');
INSERT INTO answer VALUES(585,147,0,'Das von der Gitterspannung hervorgerufene elektrische Feld steuert den Anodenstrom.',' ');
INSERT INTO answer VALUES(586,147,1,'Die Anodenspannung steuert das magnetische Feld an der Anode und damit den Anodenstrom.',' ');
INSERT INTO answer VALUES(587,147,2,'Die Heizspannung steuert das elektrische Feld an der Kathode und damit den Anodenstrom.',' ');
INSERT INTO answer VALUES(588,147,3,'Die Katodenvorspannung steuert das magnetische Feld an der Kathode und damit den Gitterstrom.',' ');
INSERT INTO answer VALUES(589,148,0,'werden Informationen auf einen oder mehrere Träger übertragen.',' ');
INSERT INTO answer VALUES(590,148,1,'wird einem oder mehreren Trägern Informationen entnommen.',' ');
INSERT INTO answer VALUES(591,148,2,'werden Sprach- und CW-Signale kombiniert.',' ');
INSERT INTO answer VALUES(592,148,3,'werden dem Signal NF-Komponenten entnommen.',' ');
INSERT INTO answer VALUES(593,149,0,'wird die Frequenz des Trägers beeinflusst. Die Amplitude des Trägers bleibt dabei konstant.',' ');
INSERT INTO answer VALUES(594,149,1,'wird die Amplitude des Trägers beeinflusst. Die Frequenz des Trägers bleibt dabei konstant.',' ');
INSERT INTO answer VALUES(595,149,2,'werden gleichzeitig Frequenz und Amplitude des Trägers beeinflusst.',' ');
INSERT INTO answer VALUES(596,149,3,'findet keinerlei Beeinflussung von Trägerfrequenz oder Trägeramplitude statt. Die Information steuert nur die Kapazität des Oszillators.',' ');
INSERT INTO answer VALUES(597,150,0,'der Träger und ein Seitenband unterdrückt oder ausgefiltert werden.',' ');
INSERT INTO answer VALUES(598,150,1,'der Träger hinzugesetzt und ein Seitenband ausgefiltert werden.',' ');
INSERT INTO answer VALUES(599,150,2,'der Träger unterdrückt und ein Seitenband hinzugesetzt werden.',' ');
INSERT INTO answer VALUES(600,150,3,'der Träger unterdrückt und beide Seitenbänder ausgefiltert werden.',' ');
INSERT INTO answer VALUES(601,151,0,'Im Balancemodulator wird ein Zweiseitenband- Signal erzeugt. Das Seitenbandfilter selektiert ein Seitenband heraus.',' ');
INSERT INTO answer VALUES(602,151,1,'Im Balancemodulator wird ein Zweiseitenband- Signal erzeugt. Ein auf die Trägerfrequenz abgestimmter Saugkreis filtert den Träger aus.',' ');
INSERT INTO answer VALUES(603,151,2,'Im Balancemodulator wird ein Einseitenband- Signal erzeugt. Ein auf die Trägerfrequenz abgestimmter Sperrkreis filtert den Träger aus.',' ');
INSERT INTO answer VALUES(604,151,3,'Im Balancemodulator wird ein Zweiseitenband- Signal erzeugt. In einem Frequenzteiler wird ein Seitenband abgespalten.',' ');
INSERT INTO answer VALUES(605,152,0,'Es ist ein Schwingungserzeuger.',' ');
INSERT INTO answer VALUES(606,152,1,'Es ist ein sehr schmales Filter.',' ');
INSERT INTO answer VALUES(607,152,2,'Es ist ein Messgerät zur Anzeige von Schwingungen.',' ');
INSERT INTO answer VALUES(608,152,3,'Es ist ein FM-Modulator.',' ');
INSERT INTO answer VALUES(609,153,0,'von einer Spule und einem Kondensator (LC-Schwingkreis) bestimmt wird.',' ');
INSERT INTO answer VALUES(610,153,1,'durch einen hochstabilen Quarz bestimmt wird.',' ');
INSERT INTO answer VALUES(611,153,2,'mittels LC-Tiefpass gefiltert wird.',' ');
INSERT INTO answer VALUES(612,153,3,'mittels LC-Hochpass gefiltert wird.',' ');
INSERT INTO answer VALUES(613,154,0,'durch einen hochstabilen Quarz bestimmt wird.',' ');
INSERT INTO answer VALUES(614,154,1,'allein durch einen Quarz erzeugt wird.',' ');
INSERT INTO answer VALUES(615,154,2,'mittels Quarz-Tiefpass gefiltert wird.',' ');
INSERT INTO answer VALUES(616,154,3,'mittels Quarz-Hochpass gefiltert wird.',' ');
INSERT INTO answer VALUES(617,155,0,'Die Frequenz wird erhöht.',' ');
INSERT INTO answer VALUES(618,155,1,'Die Schwingungen reißen ab (Aussetzer).',' ');
INSERT INTO answer VALUES(619,155,2,'Die Frequenz wird niedriger.',' ');
INSERT INTO answer VALUES(620,155,3,'Die Frequenz bleibt stabil.',' ');
INSERT INTO answer VALUES(621,156,0,'Die VFO-Frequenz wandert nach unten.',' ');
INSERT INTO answer VALUES(622,156,1,'Die VFO-Frequenz wandert nach oben.',' ');
INSERT INTO answer VALUES(623,156,2,'Die VFO-Ausgangsspannung nimmt zu.',' ');
INSERT INTO answer VALUES(624,156,3,'Die VFO-Ausgangsspannung nimmt ab.',' ');
INSERT INTO answer VALUES(625,157,0,'eine bessere Frequenzstabilität aufweisen.',' ');
INSERT INTO answer VALUES(626,157,1,'eine breitere Resonanzkurve haben.',' ');
INSERT INTO answer VALUES(627,157,2,'einen geringeren Anteil an Oberwellen erzeugen.',' ');
INSERT INTO answer VALUES(628,157,3,'ein sehr viel geringes Seitenbandrauschen erzeugen.',' ');
INSERT INTO answer VALUES(629,158,0,'Die Sendeart J3E beansprucht weniger als die halbe Bandbreite der Sendeart A3E.',' ');
INSERT INTO answer VALUES(630,158,1,'Die Sendeart J3E beansprucht etwas mehr als die halbe Bandbreite der Sendeart A3E.',' ');
INSERT INTO answer VALUES(631,158,2,'Die Sendeart J3E beansprucht etwa 1/4 Bandbreite der Sendeart A3E.',' ');
INSERT INTO answer VALUES(632,158,3,'Die unterschiedlichen Modulationsarten lassen keinen Vergleich zu, da sie grundverschieden erzeugt werden.',' ');
INSERT INTO answer VALUES(633,159,0,'FM',' ');
INSERT INTO answer VALUES(634,159,1,'SSB',' ');
INSERT INTO answer VALUES(635,159,2,'DSB',' ');
INSERT INTO answer VALUES(636,159,3,'AM',' ');
INSERT INTO answer VALUES(637,160,0,'50 %.',' ');
INSERT INTO answer VALUES(638,160,1,'33 %.',' ');
INSERT INTO answer VALUES(639,160,2,'67 %.',' ');
INSERT INTO answer VALUES(640,160,3,'75 %.',' ');
INSERT INTO answer VALUES(641,161,0,'45 %.',' ');
INSERT INTO answer VALUES(642,161,1,'55 %.',' ');
INSERT INTO answer VALUES(643,161,2,'30 %.',' ');
INSERT INTO answer VALUES(644,161,3,'75 %.',' ');
INSERT INTO answer VALUES(645,162,0,'ein typisches Zweiton-SSB-Testsignal.',' ');
INSERT INTO answer VALUES(646,162,1,'ein typisches Einton-FM-Testsignal.',' ');
INSERT INTO answer VALUES(647,162,2,'ein typisches 100%-AM-Signal.',' ');
INSERT INTO answer VALUES(648,162,3,'ein typisches CW-Signal.',' ');
INSERT INTO answer VALUES(649,163,0,'Man kann keinen Modulationsgrad bestimmen, da es keinen Träger gibt.',' ');
INSERT INTO answer VALUES(650,163,1,'Er beträgt 100 %.',' ');
INSERT INTO answer VALUES(651,163,2,'Er beträgt 0 %.',' ');
INSERT INTO answer VALUES(652,163,3,'Er beträgt ca. 50 %.',' ');
INSERT INTO answer VALUES(653,164,0,'Durch die Größe der Trägerfrequenzauslenkung.',' ');
INSERT INTO answer VALUES(654,164,1,'Durch die Geschwindigkeit der Trägerfrequenzänderung.',' ');
INSERT INTO answer VALUES(655,164,2,'Durch die Änderung der Geschwindigkeit des Frequenzhubes.',' ');
INSERT INTO answer VALUES(656,164,3,'Durch die Größe der Amplitude des HF-Signals.',' ');
INSERT INTO answer VALUES(657,165,0,'geringeren Beeinflussung durch Störquellen.',' ');
INSERT INTO answer VALUES(658,165,1,'geringen Anforderungen an die Bandbreite.',' ');
INSERT INTO answer VALUES(659,165,2,'größeren Entfernungsüberbrückung.',' ');
INSERT INTO answer VALUES(660,165,3,'besseren Kreisgüte.',' ');
INSERT INTO answer VALUES(661,166,0,'dass die HF-Bandbreite zu groß wird.',' ');
INSERT INTO answer VALUES(662,166,1,'dass die Sendeendstufe übersteuert wird.',' ');
INSERT INTO answer VALUES(663,166,2,'dass Verzerrungen auf Grund unerwünschter Unterdrückung der Trägerfrequenz auftreten.',' ');
INSERT INTO answer VALUES(664,166,3,'dass Verzerrungen auf Grund gegenseitiger Auslöschung der Seitenbänder auftreten.',' ');
INSERT INTO answer VALUES(665,167,0,'einer größeren HF-Bandbreite.',' ');
INSERT INTO answer VALUES(666,167,1,'einer Erhöhung der Senderausgangsleistung.',' ');
INSERT INTO answer VALUES(667,167,2,'einer Erhöhung der Amplitude der Trägerfrequenz.',' ');
INSERT INTO answer VALUES(668,167,3,'einer Reduktion der Amplituden der Seitenbänder.',' ');
INSERT INTO answer VALUES(669,168,0,'12 kHz',' ');
INSERT INTO answer VALUES(670,168,1,'25 kHz',' ');
INSERT INTO answer VALUES(671,168,2,'ca. 6,6 kHz',' ');
INSERT INTO answer VALUES(672,168,3,'ca. 3 kHz',' ');
INSERT INTO answer VALUES(673,169,0,'20 kHz',' ');
INSERT INTO answer VALUES(674,169,1,'12,5 kHz',' ');
INSERT INTO answer VALUES(675,169,2,'ca. 6,6 kHz',' ');
INSERT INTO answer VALUES(676,169,3,'ca. 3 kHz',' ');
INSERT INTO answer VALUES(677,170,0,'1200 / 2200 Hz',' ');
INSERT INTO answer VALUES(678,170,1,'850 / 1200 kHz',' ');
INSERT INTO answer VALUES(679,170,2,'500 / 1750 Hz',' ');
INSERT INTO answer VALUES(680,170,3,'300 / 2700 Hz',' ');
INSERT INTO answer VALUES(681,171,0,'besteht aus einem Modem und dem Controller für die digitale Aufbereitung der Daten.',' ');
INSERT INTO answer VALUES(682,171,1,'wandelt nur die Töne in digitale Daten und schickt diese an den PC.',' ');
INSERT INTO answer VALUES(683,171,2,'wandelt nur die Töne in digitale Daten und schickt diese an den Sender.',' ');
INSERT INTO answer VALUES(684,171,3,'ist ein Modem (Modulator und Demodulator) für digitale Signale.',' ');
INSERT INTO answer VALUES(685,172,0,'paketweise (stoßweise) gesendet.',' ');
INSERT INTO answer VALUES(686,172,1,'in der Mailbox in Paketen aufbewahrt.',' ');
INSERT INTO answer VALUES(687,172,2,'8-Bit-weise parallel gepackt gesendet.',' ');
INSERT INTO answer VALUES(688,172,3,'zu 8 Bit gepackt und dann gesendet.',' ');
INSERT INTO answer VALUES(689,173,0,'Die Übertragung erfolgt mit 1200 Baud.',' ');
INSERT INTO answer VALUES(690,173,1,'Man arbeitet mit einem einzelnen Ton von 1200 Hz.',' ');
INSERT INTO answer VALUES(691,173,2,'Die Frequenz am Packet-Radio-Eingang beträgt 1200 Hertz.',' ');
INSERT INTO answer VALUES(692,173,3,'Die Daten werden in Paketen von 1200 Bits übertragen.',' ');
INSERT INTO answer VALUES(693,174,0,'9600 Baud',' ');
INSERT INTO answer VALUES(694,174,1,'12000 Baud',' ');
INSERT INTO answer VALUES(695,174,2,'2700 Baud',' ');
INSERT INTO answer VALUES(696,174,3,'6400 Baud',' ');
INSERT INTO answer VALUES(697,175,0,'ein Rechnersystem bei dem Texte und Daten über Funk eingespeichert und abgerufen werden können.',' ');
INSERT INTO answer VALUES(698,175,1,'die Softwaresteuerung einer automatischen Funkstelle.',' ');
INSERT INTO answer VALUES(699,175,2,'eine fernbedient oder automatisch arbeitende Funkstelle die Internetnachrichten zwischenspeichert.',' ');
INSERT INTO answer VALUES(700,175,3,'eine Zusatzeinrichtung die E-Mails umwandelt und anschließend zwischenspeichert.',' ');
INSERT INTO answer VALUES(701,176,0,'einen PC mit Soundkarte und entsprechender Software.',' ');
INSERT INTO answer VALUES(702,176,1,'einen Fernschreiber.',' ');
INSERT INTO answer VALUES(703,176,2,'einen RTTY-Microcontroller.',' ');
INSERT INTO answer VALUES(704,176,3,'eine Zusatzeinrichtung, die RTTY-Signale umwandelt und anschließend zwischenspeichert.',' ');
INSERT INTO answer VALUES(705,177,0,'SSTV überträgt Standbilder, ATV bewegte Bilder.',' ');
INSERT INTO answer VALUES(706,177,1,'SSTV wird nur auf Kurzwelle, ATV auf UKW verwendet.',' ');
INSERT INTO answer VALUES(707,177,2,'SSTV belegt eine größere Bandbreite als ATV.',' ');
INSERT INTO answer VALUES(708,177,3,'SSTV ist schwarzweiß, ATV in Farbe.',' ');
INSERT INTO answer VALUES(709,178,0,'PSK31',' ');
INSERT INTO answer VALUES(710,178,1,'RTTY',' ');
INSERT INTO answer VALUES(711,178,2,'Pactor',' ');
INSERT INTO answer VALUES(712,178,3,'Packet Radio',' ');
INSERT INTO answer VALUES(713,179,0,'Halbduplex',' ');
INSERT INTO answer VALUES(714,179,1,'Simplex',' ');
INSERT INTO answer VALUES(715,179,2,'Duplex',' ');
INSERT INTO answer VALUES(716,179,3,'Vollduplex',' ');
INSERT INTO answer VALUES(717,180,0,'Spiegelfrequenzstörungen.',' ');
INSERT INTO answer VALUES(718,180,1,'Beeinflussung des lokalen Oszillators.',' ');
INSERT INTO answer VALUES(719,180,2,'Nebenaussendungen.',' ');
INSERT INTO answer VALUES(720,180,3,'Störungen der zweiten ZF.',' ');
INSERT INTO answer VALUES(721,181,0,'ermöglicht bei großem Abstand zur Empfangsfrequenz eine hohe Spiegelfrequenzunterdrückung.',' ');
INSERT INTO answer VALUES(722,181,1,'trägt dazu bei, mögliche Beeinflussungen des lokalen Oszillators durch Empfangssignale zu reduzieren.',' ');
INSERT INTO answer VALUES(723,181,2,'sollte möglichst nahe an der Empfangsfrequenz liegen, um eine gute Spiegelfrequenzunterdrückung zu erreichen.',' ');
INSERT INTO answer VALUES(724,181,3,'verhindert auf Grund ihrer Höhe, dass durch die Umsetzung auf die zweite Zwischenfrequenz Spiegelfrequenzen auftreten.',' ');
INSERT INTO answer VALUES(725,182,0,'Mit einer niedrigen zweiten ZF erreicht man leicht eine gute Trennschärfe.',' ');
INSERT INTO answer VALUES(726,182,1,'Das von der Antenne aufgenommene Signal bleibt bis zum Demodulator in seiner Frequenz erhalten.',' ');
INSERT INTO answer VALUES(727,182,2,'Durch eine hohe erste ZF erreicht man leicht eine gute Trennschärfe.',' ');
INSERT INTO answer VALUES(728,182,3,'Durch eine niedrige zweite ZF erreicht man leicht eine gute Spiegelselektion.',' ');
INSERT INTO answer VALUES(729,183,0,'49,9 MHz',' ');
INSERT INTO answer VALUES(730,183,1,'48,9 MHz',' ');
INSERT INTO answer VALUES(731,183,2,'39,2 MHz',' ');
INSERT INTO answer VALUES(732,183,3,'17,8 MHz',' ');
INSERT INTO answer VALUES(733,184,0,'die Höhe der ersten ZF.',' ');
INSERT INTO answer VALUES(734,184,1,'die Höhe der zweiten ZF bei einem Doppelüberlagerungsempfänger.',' ');
INSERT INTO answer VALUES(735,184,2,'die Bandbreite der ZF-Stufen.',' ');
INSERT INTO answer VALUES(736,184,3,'die NF-Bandbreite.',' ');
INSERT INTO answer VALUES(737,185,0,'9 MHz und 281 MHz',' ');
INSERT INTO answer VALUES(738,185,1,'127 MHz und 154 MHz',' ');
INSERT INTO answer VALUES(739,185,2,'272 MHz und 290 MHz',' ');
INSERT INTO answer VALUES(740,185,3,'140,5 MHz und 281 MHz',' ');
INSERT INTO answer VALUES(741,186,0,'10,7 MHz und 66,7 MHz',' ');
INSERT INTO answer VALUES(742,186,1,'nur 10,7 MHz',' ');
INSERT INTO answer VALUES(743,186,2,'56 MHz und 66,7 MHz',' ');
INSERT INTO answer VALUES(744,186,3,'10,7 MHz und 56 MHz',' ');
INSERT INTO answer VALUES(745,187,0,'hohen Trennschärfe.',' ');
INSERT INTO answer VALUES(746,187,1,'fehlenden Trennschärfe.',' ');
INSERT INTO answer VALUES(747,187,2,'unzulänglichen Trennschärfe.',' ');
INSERT INTO answer VALUES(748,187,3,'schlechten Demodulation.',' ');
INSERT INTO answer VALUES(749,188,0,'dem zweifachen der ersten ZF.',' ');
INSERT INTO answer VALUES(750,188,1,'der Frequenz des lokalen Oszillators.',' ');
INSERT INTO answer VALUES(751,188,2,'der HF-Eingangsfrequenz.',' ');
INSERT INTO answer VALUES(752,188,3,'der Frequenz des Preselektors.',' ');
INSERT INTO answer VALUES(753,189,0,'Durch Mischung.',' ');
INSERT INTO answer VALUES(754,189,1,'Durch Vervielfachung.',' ');
INSERT INTO answer VALUES(755,189,2,'Durch Frequenzteilung.',' ');
INSERT INTO answer VALUES(756,189,3,'Durch Rückkopplung.',' ');
INSERT INTO answer VALUES(757,190,0,'einer automatischen Verstärkungsregelung ausgestattet.',' ');
INSERT INTO answer VALUES(758,190,1,'einer NF-Pegelbegrenzung ausgestattet.',' ');
INSERT INTO answer VALUES(759,190,2,'NF-Filtern ausgestattet.',' ');
INSERT INTO answer VALUES(760,190,3,'einer NF-Vorspannungsregelung ausgestattet.',' ');
INSERT INTO answer VALUES(761,191,0,'die Verstärkung der HF- und ZF-Stufen.',' ');
INSERT INTO answer VALUES(762,191,1,'die Versorgungsspannung des VFO.',' ');
INSERT INTO answer VALUES(763,191,2,'eine Verstärkung der NF-Stufen.',' ');
INSERT INTO answer VALUES(764,191,3,'eine Filterreaktion.',' ');
INSERT INTO answer VALUES(765,192,0,'Sie reduziert die Verstärkung der HF-und ZF-Stufen.',' ');
INSERT INTO answer VALUES(766,192,1,'Sie reduziert die Amplitude des VFO.',' ');
INSERT INTO answer VALUES(767,192,2,'Sie reduziert die Amplitude des BFO.',' ');
INSERT INTO answer VALUES(768,192,3,'Sie reduziert die Höhe der Versorgungsspannungen.',' ');
INSERT INTO answer VALUES(769,193,0,'Der VFO muss bei 38,70 MHz und der CO bei 11,16 MHz schwingen.',' ');
INSERT INTO answer VALUES(770,193,1,'Der VFO muss bei 10,26 MHz und der CO bei 17,30 MHz schwingen.',' ');
INSERT INTO answer VALUES(771,193,2,'Der VFO muss bei 11,16 MHz und der CO bei 38,70 MHz schwingen.',' ');
INSERT INTO answer VALUES(772,193,3,'Der VFO muss bei 28,460 MHz und der CO bei 38,26 MHz schwingen.',' ');
INSERT INTO answer VALUES(773,194,0,'Der VFO muss bei 30,1 MHz und der CO bei 9,46 MHz schwingen.',' ');
INSERT INTO answer VALUES(774,194,1,'Der VFO muss bei 9,46 MHz und der CO bei 8,54 MHz schwingen.',' ');
INSERT INTO answer VALUES(775,194,2,'Der VFO muss bei 30,1 MHz und der CO bei 8,54 MHz schwingen.',' ');
INSERT INTO answer VALUES(776,194,3,'Der VFO muss bei 21,56 MHz und der CO bei 12,1 MHz schwingen.',' ');
INSERT INTO answer VALUES(777,195,0,'49,7 MHz auftreten.',' ');
INSERT INTO answer VALUES(778,195,1,'39 MHz auftreten.',' ');
INSERT INTO answer VALUES(779,195,2,'67,3 MHz auftreten.',' ');
INSERT INTO answer VALUES(780,195,3,'17,6 MHz auftreten.',' ');
INSERT INTO answer VALUES(781,196,0,'der sein Ausgangssignal ab einem bestimmten Eingangspegel begrenzt.',' ');
INSERT INTO answer VALUES(782,196,1,'der zur Verringerung des Vorstufenrauschens dient.',' ');
INSERT INTO answer VALUES(783,196,2,'der zur Begrenzung des Hubes für den FM-Demodulator dient.',' ');
INSERT INTO answer VALUES(784,196,3,'der den ZF-Träger unabhängig vom Eingangssignal auf niedrigem Pegel konstant hält.',' ');
INSERT INTO answer VALUES(785,197,0,'Ein Quarzkristall',' ');
INSERT INTO answer VALUES(786,197,1,'Ein LC-Bandpass',' ');
INSERT INTO answer VALUES(787,197,2,'Ein Keramikresonator',' ');
INSERT INTO answer VALUES(788,197,3,'Ein RC-Bandpass',' ');
INSERT INTO answer VALUES(789,198,0,'Fähigkeit des Empfängers, schwache Signale zu empfangen.',' ');
INSERT INTO answer VALUES(790,198,1,'Stabilität des VFO.',' ');
INSERT INTO answer VALUES(791,198,2,'Bandbreite des HF-Vorverstärkers.',' ');
INSERT INTO answer VALUES(792,198,3,'Fähigkeit des Empfängers, starke Signale zu unterdrücken.',' ');
INSERT INTO answer VALUES(793,199,0,'Bessere Trennschärfe',' ');
INSERT INTO answer VALUES(794,199,1,'Höhere Bandbreiten',' ');
INSERT INTO answer VALUES(795,199,2,'Geringere Anforderungen an die VFO-Stabilität',' ');
INSERT INTO answer VALUES(796,199,3,'Wesentlich einfachere Konstruktion',' ');
INSERT INTO answer VALUES(797,200,0,'Um eine S-Stufe',' ');
INSERT INTO answer VALUES(798,200,1,'Um zwei S-Stufen',' ');
INSERT INTO answer VALUES(799,200,2,'Um vier S-Stufen',' ');
INSERT INTO answer VALUES(800,200,3,'Um acht S-Stufen',' ');
INSERT INTO answer VALUES(801,201,0,'100-fach',' ');
INSERT INTO answer VALUES(802,201,1,'20-fach',' ');
INSERT INTO answer VALUES(803,201,2,'10-fach',' ');
INSERT INTO answer VALUES(804,201,3,'120-fach',' ');
INSERT INTO answer VALUES(805,202,0,'S9+4dB',' ');
INSERT INTO answer VALUES(806,202,1,'S18',' ');
INSERT INTO answer VALUES(807,202,2,'S10+10 dB',' ');
INSERT INTO answer VALUES(808,202,3,'S9+9 dB',' ');
INSERT INTO answer VALUES(809,203,0,'18 dB',' ');
INSERT INTO answer VALUES(810,203,1,'9 dB',' ');
INSERT INTO answer VALUES(811,203,2,'3 dB',' ');
INSERT INTO answer VALUES(812,203,3,'24 dB',' ');
INSERT INTO answer VALUES(813,204,0,'Notchfilter',' ');
INSERT INTO answer VALUES(814,204,1,'Noise Filter',' ');
INSERT INTO answer VALUES(815,204,2,'Störaustaster',' ');
INSERT INTO answer VALUES(816,204,3,'Die AGC',' ');
INSERT INTO answer VALUES(817,205,0,'Automatische Verstärkungsregelung',' ');
INSERT INTO answer VALUES(818,205,1,'Automatische Frequenzregelung',' ');
INSERT INTO answer VALUES(819,205,2,'Automatische Gleichlaufsteuerung',' ');
INSERT INTO answer VALUES(820,205,3,'Automatische Antennenabstimmung',' ');
INSERT INTO answer VALUES(821,206,0,'Noise Blanker',' ');
INSERT INTO answer VALUES(822,206,1,'Notchfilter',' ');
INSERT INTO answer VALUES(823,206,2,'Passband-Tuning',' ');
INSERT INTO answer VALUES(824,206,3,'Die AGC',' ');
INSERT INTO answer VALUES(825,207,0,'Durch die Verringerung der NF-Ansteuerung und/oder durch Einfügung eines Dämpfungsgliedes zwischen Steuersender und Endstufe.',' ');
INSERT INTO answer VALUES(826,207,1,'Durch die Veränderung des Arbeitspunktes der Endstufe.',' ');
INSERT INTO answer VALUES(827,207,2,'Durch die Verringerung des Hubes und/oder durch Einfügung eines Dämpfungsgliedes zwischen Steuersender und Endstufe.',' ');
INSERT INTO answer VALUES(828,207,3,'Nur durch Verringerung des Hubes allein.',' ');
INSERT INTO answer VALUES(829,208,0,'Ein Transverter setzt beim Empfangen z.B. ein 70-cm-Signal in das 10-m-Band und beim Senden das 10-m-Sendesignal auf das 70-cm-Band um.',' ');
INSERT INTO answer VALUES(830,208,1,'Ein Transverter setzt beim Senden als auch beim Empfangen z.B. ein 70-cm-Signal in das 10-m-Band um.',' ');
INSERT INTO answer VALUES(831,208,2,'Ein Transverter setzt beim Senden als auch beim Empfangen z.B. ein frequenzmoduliertes Signal in ein amplitudenmoduliertes Signal um.',' ');
INSERT INTO answer VALUES(832,208,3,'Ein Transverter setzt nur den zu empfangenden Frequenzbereich in einen anderen Frequenzbereich um, z.B. das 70-cm-Band in das 10-m- Band.',' ');
INSERT INTO answer VALUES(833,209,0,'Leiser ins Mikrofon sprechen.',' ');
INSERT INTO answer VALUES(834,209,1,'Lauter ins Mikrofon sprechen.',' ');
INSERT INTO answer VALUES(835,209,2,'Weniger Leistung verwenden.',' ');
INSERT INTO answer VALUES(836,209,3,'Mehr Leistung verwenden.',' ');
INSERT INTO answer VALUES(837,210,0,'Splatter bei Stationen, die auf dem Nachbarkanal arbeiten.',' ');
INSERT INTO answer VALUES(838,210,1,'Störungen von Stationen, die auf einem anderen Frequenzband arbeiten.',' ');
INSERT INTO answer VALUES(839,210,2,'Störungen der Stromversorgung des Transceivers.',' ');
INSERT INTO answer VALUES(840,210,3,'Störungen von Computern.',' ');
INSERT INTO answer VALUES(841,211,0,'geringe Ausgangsleistung',' ');
INSERT INTO answer VALUES(842,211,1,'Störungen von Stationen, die auf einem anderen Frequenzband arbeiten',' ');
INSERT INTO answer VALUES(843,211,2,'Verringerung der Modulationsqualität',' ');
INSERT INTO answer VALUES(844,211,3,'Splatter bei Stationen, die auf dem Nachbarkanal arbeiten',' ');
INSERT INTO answer VALUES(845,212,0,'Speech Processor',' ');
INSERT INTO answer VALUES(846,212,1,'Noise Blanker',' ');
INSERT INTO answer VALUES(847,212,2,'Clarifier',' ');
INSERT INTO answer VALUES(848,212,3,'Notchfilter',' ');
INSERT INTO answer VALUES(849,213,0,'VOX',' ');
INSERT INTO answer VALUES(850,213,1,'PTT',' ');
INSERT INTO answer VALUES(851,213,2,'RIT',' ');
INSERT INTO answer VALUES(852,213,3,'PSK',' ');
INSERT INTO answer VALUES(853,214,0,'Es muss sende- und empfangsseitig den Frequenzbereich von 20 Hz bis 6 kHz möglichst linear übertragen können und die Zeit für die Sende-Empfangsumschaltung muss so kurz wie möglich sein z.B. &lt; 10...100 ms.',' ');
INSERT INTO answer VALUES(854,214,1,'Es muss sende- und empfangsseitig den Frequenzbereich von 300 Hz bis 3,4 kHz möglichst linear übertragen können und die Zeit für die Sende-Empfangsumschaltung muss zwischen 100...300 ms liegen.',' ');
INSERT INTO answer VALUES(855,214,2,'Es muss über einen Anschluss für Mikrofon und Lautsprecher verfügen, an dem ein TNC oder Modem angeschlossen werden kann.',' ');
INSERT INTO answer VALUES(856,214,3,'Es muss den Frequenzbereich von 300 Hz bis 10 kHz linear übertragen können und ein TX-Delay von kleiner 1 ms haben.',' ');
INSERT INTO answer VALUES(857,215,0,'10 dBW',' ');
INSERT INTO answer VALUES(858,215,1,'1 dBW',' ');
INSERT INTO answer VALUES(859,215,2,'3 dBW',' ');
INSERT INTO answer VALUES(860,215,3,'20 dBW',' ');
INSERT INTO answer VALUES(861,216,0,'40 W',' ');
INSERT INTO answer VALUES(862,216,1,'4 W',' ');
INSERT INTO answer VALUES(863,216,2,'16 W',' ');
INSERT INTO answer VALUES(864,216,3,'20 W',' ');
INSERT INTO answer VALUES(865,217,0,'die unmittelbar nach dem Senderausgang messbare Leistung, bevor sie Zusatzgeräte (z.B. Anpassgeräte) durchläuft.',' ');
INSERT INTO answer VALUES(866,217,1,'die unmittelbar nach dem Senderausgang gemessene Differenz aus vorlaufender und rücklaufender Leistung.',' ');
INSERT INTO answer VALUES(867,217,2,'die unmittelbar nach den erforderlichen Zusatzgeräten (z.B. Anpassgeräte) messbare Leistung.',' ');
INSERT INTO answer VALUES(868,217,3,'die unmittelbar nach dem Senderausgang gemessene Summe aus vorlaufender und rücklaufender Leistung.',' ');
INSERT INTO answer VALUES(869,218,0,'HF-Leistung bei der höchsten Spitze der Hüllkurve.',' ');
INSERT INTO answer VALUES(870,218,1,'Durchschnittsleistung einer SSB-Übertragung.',' ');
INSERT INTO answer VALUES(871,218,2,'Spitzen-Spitzen-Leistung bei den höchsten Spitzen der Modulationshüllkurve.',' ');
INSERT INTO answer VALUES(872,218,3,'Mindestleistung bei der Modulationsspitze.',' ');
INSERT INTO answer VALUES(873,219,0,'3 dB',' ');
INSERT INTO answer VALUES(874,219,1,'6 dB',' ');
INSERT INTO answer VALUES(875,219,2,'1,5 dB',' ');
INSERT INTO answer VALUES(876,219,3,'12 dB',' ');
INSERT INTO answer VALUES(877,220,0,'wird nicht durch die Modulation beeinflusst.',' ');
INSERT INTO answer VALUES(878,220,1,'ändert sich durch die Modulation.',' ');
INSERT INTO answer VALUES(879,220,2,'beträgt bei fehlender Modulation Null.',' ');
INSERT INTO answer VALUES(880,220,3,'verringert sich durch Modulation auf 70 %.',' ');
INSERT INTO answer VALUES(881,221,0,'Durch die Verringerung der NF- Ansteuerung und/oder durch Einfügung eines Dämpfungsgliedes zwischen Steuersender und Endstufe.',' ');
INSERT INTO answer VALUES(882,221,1,'Durch die Veränderung des Arbeitspunktes der Endstufe.',' ');
INSERT INTO answer VALUES(883,221,2,'Durch die Verringerung des Hubes und/oder durch Einfügung eines Dämpfungsgliedes zwischen Steuersender und Endstufe.',' ');
INSERT INTO answer VALUES(884,221,3,'Nur durch Verringerung des Hubes allein.',' ');
INSERT INTO answer VALUES(885,222,0,'Leiser ins Mikrofon sprechen',' ');
INSERT INTO answer VALUES(886,222,1,'Mehr Leistung verwenden',' ');
INSERT INTO answer VALUES(887,222,2,'Weniger Leistung verwenden',' ');
INSERT INTO answer VALUES(888,222,3,'Lauter ins Mikrofon sprechen',' ');
INSERT INTO answer VALUES(889,223,0,'USB, LSB, FM, AM, CW',' ');
INSERT INTO answer VALUES(890,223,1,'USB, PSK31, FM, SSTV, CW',' ');
INSERT INTO answer VALUES(891,223,2,'USB, LSB, FM, SSTV, CW',' ');
INSERT INTO answer VALUES(892,223,3,'USB, LSB, Amtor, Pactor, CW',' ');
INSERT INTO answer VALUES(893,224,0,'die RIT bedienen.',' ');
INSERT INTO answer VALUES(894,224,1,'das Notchfilter einschalten.',' ');
INSERT INTO answer VALUES(895,224,2,'die Passband-Tuning verstellen.',' ');
INSERT INTO answer VALUES(896,224,3,'die PTT einschalten.',' ');
INSERT INTO answer VALUES(897,225,0,'PTT',' ');
INSERT INTO answer VALUES(898,225,1,'VOX',' ');
INSERT INTO answer VALUES(899,225,2,'RIT',' ');
INSERT INTO answer VALUES(900,225,3,'SSB',' ');
INSERT INTO answer VALUES(901,226,0,'VOX-Betrieb',' ');
INSERT INTO answer VALUES(902,226,1,'PTT-Betrieb',' ');
INSERT INTO answer VALUES(903,226,2,'RIT-Betrieb',' ');
INSERT INTO answer VALUES(904,226,3,'SSB-Betrieb',' ');
INSERT INTO answer VALUES(905,227,0,'Durch zu steile Flanken der Tastimpulse',' ');
INSERT INTO answer VALUES(906,227,1,'Durch prellende Kontakte der verwendeten Taste',' ');
INSERT INTO answer VALUES(907,227,2,'Durch direkte Tastung der Oszillatorstufe',' ');
INSERT INTO answer VALUES(908,227,3,'Durch ein unterdimensioniertes Netzteil, dessen Spannung beim Auftasten kurzzeitig zusammenbricht',' ');
INSERT INTO answer VALUES(909,228,0,'Ein Tiefpassfilter',' ');
INSERT INTO answer VALUES(910,228,1,'Ein Hochpassfilter',' ');
INSERT INTO answer VALUES(911,228,2,'Ein Antennenfilter',' ');
INSERT INTO answer VALUES(912,228,3,'Ein Sperrkreisfilter',' ');
INSERT INTO answer VALUES(913,229,0,'höchstens 3 kHz betragen.',' ');
INSERT INTO answer VALUES(914,229,1,'höchstens 5 kHz betragen.',' ');
INSERT INTO answer VALUES(915,229,2,'höchstens 10 kHz betragen.',' ');
INSERT INTO answer VALUES(916,229,3,'höchstens 15 kHz betragen.',' ');
INSERT INTO answer VALUES(917,230,0,'<img src=''etg504a.png''>',' ');
INSERT INTO answer VALUES(918,230,1,'<img src=''etg504b.png''>',' ');
INSERT INTO answer VALUES(919,230,2,'<img src=''etg504c.png''>',' ');
INSERT INTO answer VALUES(920,230,3,'<img src=''etg504d.png''>',' ');
INSERT INTO answer VALUES(921,231,0,'in eine künstliche 50-&Omega;-Antenne eingespeist werden.',' ');
INSERT INTO answer VALUES(922,231,1,'in eine Antenne eingespeist werden.',' ');
INSERT INTO answer VALUES(923,231,2,'in einen Kondensator mit einem Blindwiderstand von 50 &Omega; eingespeist werden.',' ');
INSERT INTO answer VALUES(924,231,3,'in einen 50-&Omega;-Drahtwiderstand eingespeist werden.',' ');
INSERT INTO answer VALUES(925,232,0,'<img src=''etg506a.png''>',' ');
INSERT INTO answer VALUES(926,232,1,'<img src=''etg506b.png''>',' ');
INSERT INTO answer VALUES(927,232,2,'<img src=''etg506c.png''>',' ');
INSERT INTO answer VALUES(928,232,3,'<img src=''etg506d.png''>',' ');
INSERT INTO answer VALUES(929,233,0,'Langdraht-Antenne, Groundplane-Antenne, Yagiantenne, Dipolantenne, Windom-Antenne, Delta-Loop-Antenne',' ');
INSERT INTO answer VALUES(930,233,1,'Langdraht-Antenne, Groundplane-Antenne, Gestockte Yagiantenne, Dipolantenne, Windom- Antenne, Delta-Loop-Antenne',' ');
INSERT INTO answer VALUES(931,233,2,'Langdraht-Antenne, Groundplane-Antenne, Gruppenantenne, Dipolantenne, Windom- Antenne, Delta-Loop-Antenne',' ');
INSERT INTO answer VALUES(932,233,3,'Langdraht-Antenne, Groundplane-Antenne, Kreuzyagi-Antenne, Dipolantenne, Windom- Antenne, Delta-Loop-Antenne',' ');
INSERT INTO answer VALUES(933,234,0,'Langdraht-Antennen',' ');
INSERT INTO answer VALUES(934,234,1,'Yagi-Antennen',' ');
INSERT INTO answer VALUES(935,234,2,'Quad-Antennen',' ');
INSERT INTO answer VALUES(936,234,3,'Groundplane-Antennen',' ');
INSERT INTO answer VALUES(937,235,0,'Magnetische Ringantennen mit einem Umfang von etwa &lambda;/10.',' ');
INSERT INTO answer VALUES(938,235,1,'Ferritstabantennen und magnetische Ringantennen.',' ');
INSERT INTO answer VALUES(939,235,2,'Rahmenantennen mit mehreren Drahtwindungen.',' ');
INSERT INTO answer VALUES(940,235,3,'Ferritstabantennen und Rahmenantennen mit mehreren Drahtwindungen.',' ');
INSERT INTO answer VALUES(941,236,0,'6,58 m',' ');
INSERT INTO answer VALUES(942,236,1,'3,29 m',' ');
INSERT INTO answer VALUES(943,236,2,'2,08 m',' ');
INSERT INTO answer VALUES(944,236,3,'5,26 m',' ');
INSERT INTO answer VALUES(945,237,0,'Dipol, Delta-Loop, W3DZZ-Antenne',' ');
INSERT INTO answer VALUES(946,237,1,'Beam, Groundplane-Antenne, Dipol',' ');
INSERT INTO answer VALUES(947,237,2,'Dipol, W3DZZ-Antenne, Beam',' ');
INSERT INTO answer VALUES(948,237,3,'Dipol, Delta-Loop, Langyagi',' ');
INSERT INTO answer VALUES(949,238,0,'Groundplane',' ');
INSERT INTO answer VALUES(950,238,1,'Faltdipol',' ');
INSERT INTO answer VALUES(951,238,2,'Yagi',' ');
INSERT INTO answer VALUES(952,238,3,'&lambda;/2-Dipol',' ');
INSERT INTO answer VALUES(953,239,0,'Delta-Loop-Antenne',' ');
INSERT INTO answer VALUES(954,239,1,'3-Element Quad-Loop-Antenne',' ');
INSERT INTO answer VALUES(955,239,2,'W3DZZ Antenne',' ');
INSERT INTO answer VALUES(956,239,3,'3-Element-Beam',' ');
INSERT INTO answer VALUES(957,240,0,'5&lambda;/8',' ');
INSERT INTO answer VALUES(958,240,1,'&lambda;/4',' ');
INSERT INTO answer VALUES(959,240,2,'&lambda;/2',' ');
INSERT INTO answer VALUES(960,240,3,'3&lambda;/4',' ');
INSERT INTO answer VALUES(961,241,0,'einen flachen Abstrahlwinkel.',' ');
INSERT INTO answer VALUES(962,241,1,'zirkulare Polarisation.',' ');
INSERT INTO answer VALUES(963,241,2,'einen hohen Abstrahlwinkel.',' ');
INSERT INTO answer VALUES(964,241,3,'elliptische Polarisation.',' ');
INSERT INTO answer VALUES(965,242,0,'l beträgt zirka 40 m, f<sub>res</sub> liegt bei zirka 3,65 MHz.',' ');
INSERT INTO answer VALUES(966,242,1,'l beträgt zirka 80 m, f<sub>res</sub> liegt bei zirka 3,65 MHz.',' ');
INSERT INTO answer VALUES(967,242,2,'l beträgt zirka 40 m, f<sub>res</sub> liegt bei zirka 1,85 MHz.',' ');
INSERT INTO answer VALUES(968,242,3,'l beträgt zirka 80 m, f<sub>res</sub> liegt bei zirka 1,85 MHz.',' ');
INSERT INTO answer VALUES(969,243,0,'Radiale.',' ');
INSERT INTO answer VALUES(970,243,1,'Reflektoren.',' ');
INSERT INTO answer VALUES(971,243,2,'Parasitärstrahler.',' ');
INSERT INTO answer VALUES(972,243,3,'Erdelemente.',' ');
INSERT INTO answer VALUES(973,244,0,'1 Reflektor, 2 Strahler und 3 Direktor.',' ');
INSERT INTO answer VALUES(974,244,1,'1 Strahler, 2 Direktor und 3 Reflektor.',' ');
INSERT INTO answer VALUES(975,244,2,'1 Direktor, 2 Strahler und 3 Reflektor.',' ');
INSERT INTO answer VALUES(976,244,3,'1 Direktor, 2 Reflektor und 3 Strahler.',' ');
INSERT INTO answer VALUES(977,245,0,'Strahler',' ');
INSERT INTO answer VALUES(978,245,1,'Direktor',' ');
INSERT INTO answer VALUES(979,245,2,'Reflektor',' ');
INSERT INTO answer VALUES(980,245,3,'Strahler und am Reflektor gleichzeitig',' ');
INSERT INTO answer VALUES(981,246,0,'Sie muss ein ganzzahliges Vielfaches von &lambda;/2 betragen. (n * &lambda;/2, n=1, 2, 3...)',' ');
INSERT INTO answer VALUES(982,246,1,'Sie muss ein ungeradzahliges Vielfaches von &lambda;/4 betragen. (n * &lambda;/4, n=1, 3, 5...)',' ');
INSERT INTO answer VALUES(983,246,2,'Sie muss 5/8 &lambda;, &lambda;/4 oder deren geradzahlige Vielfache (n * &lambda;/4, n=2, 4, 6...) betragen.',' ');
INSERT INTO answer VALUES(984,246,3,'Sie darf kein ganzzahliges Vielfaches von &lambda; betragen.',' ');
INSERT INTO answer VALUES(985,247,0,'Dipol<p><img src=''eth202a.png''>',' ');
INSERT INTO answer VALUES(986,247,1,'Groundplane<p><img src=''eth202b.png''>',' ');
INSERT INTO answer VALUES(987,247,2,'Yagiantenne<p><img src=''eth202c.png''>',' ');
INSERT INTO answer VALUES(988,247,3,'Faltdipol<p><img src=''eth202d.png''>',' ');
INSERT INTO answer VALUES(989,248,0,'ca. 30 ... 50 &Omega;',' ');
INSERT INTO answer VALUES(990,248,1,'ca. 60 ... 120 &Omega;',' ');
INSERT INTO answer VALUES(991,248,2,'ca. 600 &Omega;',' ');
INSERT INTO answer VALUES(992,248,3,'ca. 240 &Omega;',' ');
INSERT INTO answer VALUES(993,249,0,'40 bis 80 &Omega;.',' ');
INSERT INTO answer VALUES(994,249,1,'60 bis 120 &Omega;.',' ');
INSERT INTO answer VALUES(995,249,2,'120 bis 240 &Omega;.',' ');
INSERT INTO answer VALUES(996,249,3,'240 bis 600 &Omega;.',' ');
INSERT INTO answer VALUES(997,250,0,'240 &Omega;.',' ');
INSERT INTO answer VALUES(998,250,1,'600 &Omega;.',' ');
INSERT INTO answer VALUES(999,250,2,'50 &Omega;.',' ');
INSERT INTO answer VALUES(1000,250,3,'30-60 &Omega;.',' ');
INSERT INTO answer VALUES(1001,251,0,'stromgespeist.',' ');
INSERT INTO answer VALUES(1002,251,1,'spannungsgespeist.',' ');
INSERT INTO answer VALUES(1003,251,2,'endgespeist.',' ');
INSERT INTO answer VALUES(1004,251,3,'parallel gespeist.',' ');
INSERT INTO answer VALUES(1005,252,0,'95 %',' ');
INSERT INTO answer VALUES(1006,252,1,'75 %',' ');
INSERT INTO answer VALUES(1007,252,2,'66 %',' ');
INSERT INTO answer VALUES(1008,252,3,'100 %',' ');
INSERT INTO answer VALUES(1009,253,0,'Bild 1 zeigt einen &lambda;/4-Vertikalstrahler (Viertelwellenstab).',' ');
INSERT INTO answer VALUES(1010,253,1,'Bild 2 zeigt eine Sperrtopf-Antenne.',' ');
INSERT INTO answer VALUES(1011,253,2,'Bild 3 zeigt eine &lambda;/2-Antenne mit Fuchskreis.',' ');
INSERT INTO answer VALUES(1012,253,3,'Bild 4 zeigt eine 5/8-&lambda;-Antenne.',' ');
INSERT INTO answer VALUES(1013,254,0,'Bild 1 zeigt eine horizontal polarisierte Yagi-Antenne.',' ');
INSERT INTO answer VALUES(1014,254,1,'Bild 2 zeigt eine Kreuz-Yagi-Antenne.',' ');
INSERT INTO answer VALUES(1015,254,2,'Bild 3 zeigt eine gestockte X-Yagi-Antenne.',' ');
INSERT INTO answer VALUES(1016,254,3,'Bild 4 zeigt eine vertikal polarisierte Yagi-Antenne.',' ');
INSERT INTO answer VALUES(1017,255,0,'kann eine beliebige Länge haben.',' ');
INSERT INTO answer VALUES(1018,255,1,'muss unbedingt lambda-halbe lang sein.',' ');
INSERT INTO answer VALUES(1019,255,2,'muss genau lambda-viertel lang sein.',' ');
INSERT INTO answer VALUES(1020,255,3,'muss eine Länge von dreiviertel Lambda haben.',' ');
INSERT INTO answer VALUES(1021,256,0,'6 dB',' ');
INSERT INTO answer VALUES(1022,256,1,'3 dB',' ');
INSERT INTO answer VALUES(1023,256,2,'10 dB',' ');
INSERT INTO answer VALUES(1024,256,3,'16 dB',' ');
INSERT INTO answer VALUES(1025,257,0,'10 dB',' ');
INSERT INTO answer VALUES(1026,257,1,'3 dB',' ');
INSERT INTO answer VALUES(1027,257,2,'6 dB',' ');
INSERT INTO answer VALUES(1028,257,3,'16 dB',' ');
INSERT INTO answer VALUES(1029,258,0,'3 dB',' ');
INSERT INTO answer VALUES(1030,258,1,'-6 dB',' ');
INSERT INTO answer VALUES(1031,258,2,'-3 dB',' ');
INSERT INTO answer VALUES(1032,258,3,'6 dBm',' ');
INSERT INTO answer VALUES(1033,259,0,'0 dBm entspricht 1 mW; 3 dBm entspricht 2 mW; 20 dBm entspricht 100 mW',' ');
INSERT INTO answer VALUES(1034,259,1,'0 dBm entspricht 1 mW; 3 dBm entspricht 1,4 mW; 20 dBm entspricht 10 mW',' ');
INSERT INTO answer VALUES(1035,259,2,'0 dBm entspricht 0 mW; 3 dBm entspricht 30 mW; 20 dBm entspricht 200 mW',' ');
INSERT INTO answer VALUES(1036,259,3,'1 dBm entspricht 0 mW; 2 dBm entspricht 3 mW; 100 dBm entspricht 20 mW',' ');
INSERT INTO answer VALUES(1037,260,0,'1,9 dB',' ');
INSERT INTO answer VALUES(1038,260,1,'7,5 dB',' ');
INSERT INTO answer VALUES(1039,260,2,'3,75 dB',' ');
INSERT INTO answer VALUES(1040,260,3,'1,5 dB',' ');
INSERT INTO answer VALUES(1041,261,0,'1,8 dB',' ');
INSERT INTO answer VALUES(1042,261,1,'4,5 dB',' ');
INSERT INTO answer VALUES(1043,261,2,'3,75 dB',' ');
INSERT INTO answer VALUES(1044,261,3,'1,5 dB',' ');
INSERT INTO answer VALUES(1045,262,0,'ist im HF-Bereich in etwa konstant und unabhängig vom Leitungsabschluss.',' ');
INSERT INTO answer VALUES(1046,262,1,'ist völlig frequenzunabhängig.',' ');
INSERT INTO answer VALUES(1047,262,2,'hängt von der Beschaltung am Leitungsende ab.',' ');
INSERT INTO answer VALUES(1048,262,3,'hängt von der Leitungslänge und der Beschaltung am Leitungsende ab.',' ');
INSERT INTO answer VALUES(1049,263,0,'50, 60 und 75 &Omega; auf.',' ');
INSERT INTO answer VALUES(1050,263,1,'50, 300 und 600 &Omega; auf.',' ');
INSERT INTO answer VALUES(1051,263,2,'60, 120 und 240 &Omega; auf.',' ');
INSERT INTO answer VALUES(1052,263,3,'50, 75 und 240 &Omega; auf.',' ');
INSERT INTO answer VALUES(1053,264,0,'Sie hat geringere Dämpfung und hohe Spannungsfestigkeit.',' ');
INSERT INTO answer VALUES(1054,264,1,'Sie vermeidet Mantelwellen durch Wegfall der Abschirmung.',' ');
INSERT INTO answer VALUES(1055,264,2,'Sie erlaubt leichtere Kontrolle des Wellenwiderstandes durch Verschieben der Spreizer.',' ');
INSERT INTO answer VALUES(1056,264,3,'Sie bietet guten Blitzschutz durch niederohmige Drähte.',' ');
INSERT INTO answer VALUES(1057,265,0,'Wenn die beiden Leiter unterschiedlich geformt sind, z.B. Koaxialkabel.',' ');
INSERT INTO answer VALUES(1058,265,1,'Wenn die hin- und zurücklaufende Leistung verschieden sind.',' ');
INSERT INTO answer VALUES(1059,265,2,'Wenn sie außerhalb ihrer Resonanzfrequenz betrieben wird.',' ');
INSERT INTO answer VALUES(1060,265,3,'Wenn die Koaxial-Leitung Spannung gegen Erde führt.',' ');
INSERT INTO answer VALUES(1061,266,0,'Hochwertige Koaxialkabel.',' ');
INSERT INTO answer VALUES(1062,266,1,'Symmetrische Feederleitungen.',' ');
INSERT INTO answer VALUES(1063,266,2,'Unabgestimmte Speiseleitungen.',' ');
INSERT INTO answer VALUES(1064,266,3,'Hochwertige abgeschirmte Netzanschlusskabel.',' ');
INSERT INTO answer VALUES(1065,267,0,'N',' ');
INSERT INTO answer VALUES(1066,267,1,'SMA',' ');
INSERT INTO answer VALUES(1067,267,2,'UHF',' ');
INSERT INTO answer VALUES(1068,267,3,'BNC',' ');
INSERT INTO answer VALUES(1069,268,0,'1',' ');
INSERT INTO answer VALUES(1070,268,1,'0',' ');
INSERT INTO answer VALUES(1071,268,2,'3',' ');
INSERT INTO answer VALUES(1072,268,3,'unendlich',' ');
INSERT INTO answer VALUES(1073,269,0,'führen zu Reflektionen des übertragenen HF-Signals und einem erhöhten VSWR.',' ');
INSERT INTO answer VALUES(1074,269,1,'führen zur einer Überbeanspruchung der angeschlossenen Antenne.',' ');
INSERT INTO answer VALUES(1075,269,2,'führen zu einem VSWR von kleiner oder gleich 1.',' ');
INSERT INTO answer VALUES(1076,269,3,'führen zur Erzeugung unerwünschter Aussendungen, da innerhalb der erforderlichen Bandbreite keine Anpassung gegeben ist.',' ');
INSERT INTO answer VALUES(1077,270,0,'Die Richtcharakteristik der Antenne wird verformt und es können Mantelwellen auftreten.',' ');
INSERT INTO answer VALUES(1078,270,1,'Es treten keine nennenswerten Auswirkungen auf, da die Antenne angepasst ist und die Speisung über ein Koaxkabel erfolgt, dessen Außenleiter Erdpotential hat.',' ');
INSERT INTO answer VALUES(1079,270,2,'Am Speisepunkt der Antenne treten gegenphasige Spannungen und Ströme gleicher Größe auf, die eine Fehlanpassung hervorrufen.',' ');
INSERT INTO answer VALUES(1080,270,3,'Es treten Polarisationsdrehungen auf, die von der Kabellänge abhängig sind.',' ');
INSERT INTO answer VALUES(1081,271,0,'den Dipol über ein Symmetrierglied zu speisen.',' ');
INSERT INTO answer VALUES(1082,271,1,'das Koaxialkabel durch eine Eindrahtspeiseleitung zu ersetzen.',' ');
INSERT INTO answer VALUES(1083,271,2,'beim Koaxialkabel alle 5 m eine Schleife mit 3 Windungen einzulegen.',' ');
INSERT INTO answer VALUES(1084,271,3,'das Koaxialkabel in einem Kunststoffrohr zur mechanischen Schirmung unterzubringen.',' ');
INSERT INTO answer VALUES(1085,272,0,'Mantelwellen zu dämpfen.',' ');
INSERT INTO answer VALUES(1086,272,1,'statische Aufladungen zu verhindern.',' ');
INSERT INTO answer VALUES(1087,272,2,'eine Antennenleitung abzustimmen.',' ');
INSERT INTO answer VALUES(1088,272,3,'Oberwellen zu unterdrücken.',' ');
INSERT INTO answer VALUES(1089,273,0,'25 W',' ');
INSERT INTO answer VALUES(1090,273,1,'12,5 W',' ');
INSERT INTO answer VALUES(1091,273,2,'50 W',' ');
INSERT INTO answer VALUES(1092,273,3,'75 W',' ');
INSERT INTO answer VALUES(1093,274,0,'Die D-, E-, F1- und F2-Schicht',' ');
INSERT INTO answer VALUES(1094,274,1,'Die E- und F-Schicht',' ');
INSERT INTO answer VALUES(1095,274,2,'Die F1- und F2-Schicht',' ');
INSERT INTO answer VALUES(1096,274,3,'Die E- und D-Schicht',' ');
INSERT INTO answer VALUES(1097,275,0,'Die F2-Schicht',' ');
INSERT INTO answer VALUES(1098,275,1,'Die D-, E- und F2-Schicht',' ');
INSERT INTO answer VALUES(1099,275,2,'Die F1- und F2-Schicht',' ');
INSERT INTO answer VALUES(1100,275,3,'Die D- und E-Schicht',' ');
INSERT INTO answer VALUES(1101,276,0,'200 bis 500 km Höhe.',' ');
INSERT INTO answer VALUES(1102,276,1,'2 bis 5 km Höhe.',' ');
INSERT INTO answer VALUES(1103,276,2,'20 bis 50 km Höhe.',' ');
INSERT INTO answer VALUES(1104,276,3,'2000 bis 5000 km Höhe.',' ');
INSERT INTO answer VALUES(1105,277,0,'Die D-Schicht führt tagsüber zu starker Dämpfung im 80- und 160-m-Band.',' ');
INSERT INTO answer VALUES(1106,277,1,'Die D-Schicht reflektiert tagsüber die Wellen im 80- und 160-m-Band.',' ');
INSERT INTO answer VALUES(1107,277,2,'Die D-Schicht absorbiert tagsüber die Wellen im 10-m-Band.',' ');
INSERT INTO answer VALUES(1108,277,3,'Die D-Schicht ist im Sonnenfleckenmaximum am wenigsten ausgeprägt.',' ');
INSERT INTO answer VALUES(1109,278,0,'elektrisch aufgeladenen Luftschichten in der Ionosphäre.',' ');
INSERT INTO answer VALUES(1110,278,1,'Hoch- und Tiefdruckgebieten der hohen Atmosphäre.',' ');
INSERT INTO answer VALUES(1111,278,2,'den Wolken in der niedrigen Atmosphäre.',' ');
INSERT INTO answer VALUES(1112,278,3,'den parasitären Elementen einer Richtantenne.',' ');
INSERT INTO answer VALUES(1113,279,0,'Die E-Schicht',' ');
INSERT INTO answer VALUES(1114,279,1,'Die D-Schicht',' ');
INSERT INTO answer VALUES(1115,279,2,'Die F1-Schicht',' ');
INSERT INTO answer VALUES(1116,279,3,'Die F2-Schicht',' ');
INSERT INTO answer VALUES(1117,280,0,'11 Jahre',' ');
INSERT INTO answer VALUES(1118,280,1,'6 Monate',' ');
INSERT INTO answer VALUES(1119,280,2,'12 Monate',' ');
INSERT INTO answer VALUES(1120,280,3,'100 Jahre',' ');
INSERT INTO answer VALUES(1121,281,0,'300 000 km/s.',' ');
INSERT INTO answer VALUES(1122,281,1,'3 000 000 km/s.',' ');
INSERT INTO answer VALUES(1123,281,2,'30 000 km/s.',' ');
INSERT INTO answer VALUES(1124,281,3,'3 000 km/s.',' ');
INSERT INTO answer VALUES(1125,282,0,'der durch die Bodenwelle nicht mehr erreicht wird und durch die reflektierte Raumwelle noch nicht erreicht wird.',' ');
INSERT INTO answer VALUES(1126,282,1,'der durch die Bodenwelle überdeckt wird, so dass schwächere DX-Stationen zugedeckt werden.',' ');
INSERT INTO answer VALUES(1127,282,2,'der durch die Bodenwelle erreicht wird und für die Raumwelle nicht zugänglich ist.',' ');
INSERT INTO answer VALUES(1128,282,3,'der durch die Interferenz der Bodenwelle mit der Raumwelle in einer Zone der gegenseitigen Auslöschung liegt.',' ');
INSERT INTO answer VALUES(1129,283,0,'Die Bodenwelle folgt der Erdkrümmung und geht über den geografischen Horizont hinaus. Sie wird in höheren Frequenzbereichen stärker gedämpft als in niedrigeren Frequenzbereichen.',' ');
INSERT INTO answer VALUES(1130,283,1,'Die Bodenwelle folgt der Erdkrümmung und geht nicht über den geografischen Horizont hinaus. Sie wird in höheren Frequenzbereichen stärker gedämpft als in niedrigeren Frequenzbereichen.',' ');
INSERT INTO answer VALUES(1131,283,2,'Die Bodenwelle folgt der Erdkrümmung und geht über den geografischen Horizont hinaus. Sie wird in niedrigeren Frequenzbereichen stärker gedämpft als in höheren Frequenzbereichen.',' ');
INSERT INTO answer VALUES(1132,283,3,'Die Bodenwelle folgt der Erdkrümmung und geht nicht über den geografischen Horizont hinaus. Sie wird in niedrigeren Frequenzbereichen stärker gedämpft als in höheren Frequenzbereichen.',' ');
INSERT INTO answer VALUES(1133,284,0,'Etwa 2200 km',' ');
INSERT INTO answer VALUES(1134,284,1,'Etwa 1100 km',' ');
INSERT INTO answer VALUES(1135,284,2,'Etwa 4500 km',' ');
INSERT INTO answer VALUES(1136,284,3,'Etwa 9000 km',' ');
INSERT INTO answer VALUES(1137,285,0,'vom Abstrahlwinkel der Antenne.',' ');
INSERT INTO answer VALUES(1138,285,1,'von der Polarisation der Antenne.',' ');
INSERT INTO answer VALUES(1139,285,2,'von der Sendeleistung.',' ');
INSERT INTO answer VALUES(1140,285,3,'vom Antennengewinn.',' ');
INSERT INTO answer VALUES(1141,286,0,'Der Streifen der Dämmerungsphase vor Sonnenaufgang oder nach Sonnenuntergang.',' ');
INSERT INTO answer VALUES(1142,286,1,'Die instabilen Ausbreitungsbedingungen in der Äquatorialzone.',' ');
INSERT INTO answer VALUES(1143,286,2,'Die Zeit mit den besten Möglichkeiten für "Short Skip" Ausbreitung.',' ');
INSERT INTO answer VALUES(1144,286,3,'Die Übergangszeit vor und nach dem Winter, in der sich die D-Schicht ab- und wieder aufbaut.',' ');
INSERT INTO answer VALUES(1145,287,0,'Den totalen, zeitlich begrenzten Ausfall der Reflexion in der Ionosphäre.',' ');
INSERT INTO answer VALUES(1146,287,1,'Den zeitlich begrenzten Schwund durch Mehrwegeausbreitung in der Ionosphäre.',' ');
INSERT INTO answer VALUES(1147,287,2,'Die zeitlich begrenzt auftretende Verzerrung der Modulation.',' ');
INSERT INTO answer VALUES(1148,287,3,'Das Übersprechen der Modulation eines starken Senders auf andere, über die Ionosphäre übertragene HF-Signale.',' ');
INSERT INTO answer VALUES(1149,288,0,'Mögel-Dellinger-Effekt bezeichnet.',' ');
INSERT INTO answer VALUES(1150,288,1,'sporadische E-Ausbreitung bezeichnet.',' ');
INSERT INTO answer VALUES(1151,288,2,'kritischer Schwund bezeichnet.',' ');
INSERT INTO answer VALUES(1152,288,3,'Aurora-Effekt bezeichnet.',' ');
INSERT INTO answer VALUES(1153,289,0,'durch Reflexion an sporadischen E-Schichten ermöglicht werden.',' ');
INSERT INTO answer VALUES(1154,289,1,'bei entsprechendem Abstrahlwinkel durch Reflexion an der F1-Schicht ermöglicht werden.',' ');
INSERT INTO answer VALUES(1155,289,2,'bei entsprechendem Abstrahlwinkel durch Reflexion an der F2-Schicht ermöglicht werden.',' ');
INSERT INTO answer VALUES(1156,289,3,'durch Reflexion an hochionisierten D-Schichten ermöglicht werden.',' ');
INSERT INTO answer VALUES(1157,290,0,'D-Schicht',' ');
INSERT INTO answer VALUES(1158,290,1,'F1-Schicht',' ');
INSERT INTO answer VALUES(1159,290,2,'F2-Schicht',' ');
INSERT INTO answer VALUES(1160,290,3,'A-Schicht',' ');
INSERT INTO answer VALUES(1161,291,0,'In der E-Schicht',' ');
INSERT INTO answer VALUES(1162,291,1,'In der F-Schicht',' ');
INSERT INTO answer VALUES(1163,291,2,'In der E-Schicht in der Nähe des Äquators',' ');
INSERT INTO answer VALUES(1164,291,3,'In der D-Schicht',' ');
INSERT INTO answer VALUES(1165,292,0,'Höchste brauchbare Frequenz',' ');
INSERT INTO answer VALUES(1166,292,1,'Niedrigste brauchbare Frequenz',' ');
INSERT INTO answer VALUES(1167,292,2,'Kritische Grenzfrequenz',' ');
INSERT INTO answer VALUES(1168,292,3,'Mittlere Nutzfrequenz',' ');
INSERT INTO answer VALUES(1169,293,0,'Fading',' ');
INSERT INTO answer VALUES(1170,293,1,'Flatterfading',' ');
INSERT INTO answer VALUES(1171,293,2,'MUF',' ');
INSERT INTO answer VALUES(1172,293,3,'Mögel-Dellinger-Effekt',' ');
INSERT INTO answer VALUES(1173,294,0,'15 % weiter als der geografische Horizont.',' ');
INSERT INTO answer VALUES(1174,294,1,'doppelt so weit.',' ');
INSERT INTO answer VALUES(1175,294,2,'bis zur Hälfte der Entfernung bis zum geografischen Horizont.',' ');
INSERT INTO answer VALUES(1176,294,3,'bis zum Vierfachen der Entfernung bis zum geografischen Horizont.',' ');
INSERT INTO answer VALUES(1177,295,0,'Streuung der Wellen an troposphärischen Bereichen unterschiedlicher Beschaffenheit.',' ');
INSERT INTO answer VALUES(1178,295,1,'Reflexion der Wellen in der Troposphäre durch das Auftreten sporadischer D-Schichten.',' ');
INSERT INTO answer VALUES(1179,295,2,'Polarisationsdrehungen in der Troposphäre bei hoch liegender Bewölkung.',' ');
INSERT INTO answer VALUES(1180,295,3,'Polarisationsdrehungen in der Troposphäre an Gewitterfronten.',' ');
INSERT INTO answer VALUES(1181,296,0,'troposphärische Ausbreitung genutzt.',' ');
INSERT INTO answer VALUES(1182,296,1,'ionosphärische Ausbreitung genutzt.',' ');
INSERT INTO answer VALUES(1183,296,2,'Bodenwellenausbreitung genutzt.',' ');
INSERT INTO answer VALUES(1184,296,3,'Oberflächenwellenausbreitung genutzt.',' ');
INSERT INTO answer VALUES(1185,297,0,'untere Teil der Atmosphäre, in der die Erscheinungen des Wetters stattfinden.',' ');
INSERT INTO answer VALUES(1186,297,1,'untere Teil der Atmosphäre, der sich nördlich und südlich des Äquators über die Tropen erstreckt.',' ');
INSERT INTO answer VALUES(1187,297,2,'obere Teil der Atmosphäre, in der es zur Bildung sporadischer E-Schichten kommen kann.',' ');
INSERT INTO answer VALUES(1188,297,3,'obere Teil der Atmosphäre, in welcher Aurora- Erscheinungen auftreten können.',' ');
INSERT INTO answer VALUES(1189,298,0,'die optische Sichtweite zunimmt.',' ');
INSERT INTO answer VALUES(1190,298,1,'die dämpfende Wirkung der Erdoberfläche abnimmt.',' ');
INSERT INTO answer VALUES(1191,298,2,'die Entfernung zu den reflektierenden Schichten der Troposphäre abnimmt.',' ');
INSERT INTO answer VALUES(1192,298,3,'in höheren Luftschichten die Temperatur sinkt.',' ');
INSERT INTO answer VALUES(1193,299,0,'das Eindringen geladener Teilchen von der Sonne in die Atmosphäre.',' ');
INSERT INTO answer VALUES(1194,299,1,'eine hohe Sonnenfleckenzahl.',' ');
INSERT INTO answer VALUES(1195,299,2,'eine niedrige Sonnenfleckenzahl.',' ');
INSERT INTO answer VALUES(1196,299,3,'das Auftreten von Meteoritenschauern in den polaren Regionen.',' ');
INSERT INTO answer VALUES(1197,300,0,'CW-Signale haben einen flatternden und verbrummten Ton.',' ');
INSERT INTO answer VALUES(1198,300,1,'CW- Signale haben einen besseren Ton.',' ');
INSERT INTO answer VALUES(1199,300,2,'Die Lesbarkeit der SSB-Signale verbessert sich.',' ');
INSERT INTO answer VALUES(1200,300,3,'Die Lesbarkeit der FM-Signale verbessert sich.',' ');
INSERT INTO answer VALUES(1201,301,0,'CW',' ');
INSERT INTO answer VALUES(1202,301,1,'SSB',' ');
INSERT INTO answer VALUES(1203,301,2,'FM',' ');
INSERT INTO answer VALUES(1204,301,3,'PSK31',' ');
INSERT INTO answer VALUES(1205,302,0,'die Reflexion an lokal begrenzten Bereichen mit ungewöhnlich hoher Ionisation innerhalb der E-Schicht.',' ');
INSERT INTO answer VALUES(1206,302,1,'kurzfristige plötzliche Inversionsänderungen in der E-Schicht, die Fernausbreitung im VHF-Bereich ermöglichen.',' ');
INSERT INTO answer VALUES(1207,302,2,'kurzzeitig auftretende starke Reflexion von VHF-Signalen an Meteorbahnen innerhalb der E-Schicht.',' ');
INSERT INTO answer VALUES(1208,302,3,'lokal begrenzten kurzzeitigen Ausfall der Reflexion durch ungewöhnlich hohe Ionisation innerhalb der E-Schicht.',' ');
INSERT INTO answer VALUES(1209,303,0,'Am besten S-E3, am schlechtesten S-E1',' ');
INSERT INTO answer VALUES(1210,303,1,'Am besten S-E1, am schlechtesten S-E4',' ');
INSERT INTO answer VALUES(1211,303,2,'Am besten S-E3, am schlechtesten S-E4',' ');
INSERT INTO answer VALUES(1212,303,3,'Am besten S-E4, am schlechtesten S-E1',' ');
INSERT INTO answer VALUES(1213,304,0,'der Wechselwirkung der Kräfte zwischen einem permanent magnetischen und einem elektromagnetischen Feld.',' ');
INSERT INTO answer VALUES(1214,304,1,'der Wechselwirkung der Kräfte zwischen einem magnetischen und einem elektrischen Feld.',' ');
INSERT INTO answer VALUES(1215,304,2,'der Wechselwirkung der Kräfte zwischen zwei permanent magnetischen Feldern.',' ');
INSERT INTO answer VALUES(1216,304,3,'dem erdmagnetischen Feld.',' ');
INSERT INTO answer VALUES(1217,305,0,'der kleinsten Einteilung der Anzeige.',' ');
INSERT INTO answer VALUES(1218,305,1,'der Genauigkeit des Instrumentes in Bezug auf den tatsächlichen Wert.',' ');
INSERT INTO answer VALUES(1219,305,2,'der Genauigkeit des Instrumentes.',' ');
INSERT INTO answer VALUES(1220,305,3,'dem Vollausschlag der Instrumentenanzeige.',' ');
INSERT INTO answer VALUES(1221,306,0,'ein abstimmbarer Oszillator mit einem Indikator, der anzeigt, wenn von einem ankoppelten Resonanzkreis bei einer Frequenz HF-Energie aufgenommen oder abgegeben wird.',' ');
INSERT INTO answer VALUES(1222,306,1,'ein selektiver Feldstärkemesser, der den Maximalwert der elektrischen Feldstärke anzeigt und der zur Überprüfung der Nutzsignal- und Nebenwellenabstrahlungen eingesetzt werden kann.',' ');
INSERT INTO answer VALUES(1223,306,2,'eine abgleichbare Stehwellenmessbrücke, mit der der Reflexionsfaktor und der Impedanzverlauf einer angeschlossenen Antenne oder einer LC-Kombination gemessen werden kann.',' ');
INSERT INTO answer VALUES(1224,306,3,'ein auf eine feste Frequenz eingestellter RC-Schwingkreis mit einem Indikator, der anzeigt, wie stark die Abstrahlung unerwünschter Oberwellen ist.',' ');
INSERT INTO answer VALUES(1225,307,0,'ungefähren Bestimmung der Resonanzfrequenz eines Schwingkreises.',' ');
INSERT INTO answer VALUES(1226,307,1,'ungefähren Bestimmung der Leistung eines Senders.',' ');
INSERT INTO answer VALUES(1227,307,2,'genauen Bestimmung der Dämpfung eines Schwingkreises.',' ');
INSERT INTO answer VALUES(1228,307,3,'genauen Bestimmung der Güte eines Schwingkreises.',' ');
INSERT INTO answer VALUES(1229,308,0,'Ein Dipmeter',' ');
INSERT INTO answer VALUES(1230,308,1,'Eine VSWR-Messbrücke',' ');
INSERT INTO answer VALUES(1231,308,2,'Ein Frequenzmessgerät',' ');
INSERT INTO answer VALUES(1232,308,3,'Ein Resonanzwellenmesser',' ');
INSERT INTO answer VALUES(1233,309,0,'durch Messung von L und C und Berechnung oder z.B. mit einem Dipmeter.',' ');
INSERT INTO answer VALUES(1234,309,1,'mit einem Frequenzmesser oder einem Oszilloskop.',' ');
INSERT INTO answer VALUES(1235,309,2,'mit einem Digital -Multimeter in der Stellung Frequenzmessung.',' ');
INSERT INTO answer VALUES(1236,309,3,'mit Hilfe der S-Meter Anzeige bei Anschluss des Schwingkreises an den Empfängereingang.',' ');
INSERT INTO answer VALUES(1237,310,0,'Signalverläufe sichtbar zu machen, um beispielsweise Verzerrungen zu erkennen.',' ');
INSERT INTO answer VALUES(1238,310,1,'Frequenzen genau zu messen.',' ');
INSERT INTO answer VALUES(1239,310,2,'den Temperaturverlauf bei Messungen sichtbar zu machen.',' ');
INSERT INTO answer VALUES(1240,310,3,'die Anpassung bei Antennen zu überprüfen.',' ');
INSERT INTO answer VALUES(1241,311,0,'Ein Oszilloskop',' ');
INSERT INTO answer VALUES(1242,311,1,'Ein Transistorvoltmeter',' ');
INSERT INTO answer VALUES(1243,311,2,'Ein Vielfachmessgerät',' ');
INSERT INTO answer VALUES(1244,311,3,'Ein Frequenzzähler',' ');
INSERT INTO answer VALUES(1245,312,0,'ungewendelten Kohleschichtwiderständen zusammengebaut sein.',' ');
INSERT INTO answer VALUES(1246,312,1,'hochbelastbaren Drahtwiderständen zusammengebaut sein.',' ');
INSERT INTO answer VALUES(1247,312,2,'Glühbirnen zusammengebaut sein.',' ');
INSERT INTO answer VALUES(1248,312,3,'temperaturfesten Blindwiderständen bestehen.',' ');
INSERT INTO answer VALUES(1249,313,0,'10 Kohleschichtwiderstände von 500 &Omega;',' ');
INSERT INTO answer VALUES(1250,313,1,'ein 50-&Omega;-Drahtwiderstand',' ');
INSERT INTO answer VALUES(1251,313,2,'2 parallel geschaltete Drahtwiderstände von 100 ..',' ');
INSERT INTO answer VALUES(1252,313,3,'ein Spulenanpassfilter im Ölbad',' ');
INSERT INTO answer VALUES(1253,314,0,'<img src=''etj201a.png''>',' ');
INSERT INTO answer VALUES(1254,314,1,'<img src=''etj201b.png''>',' ');
INSERT INTO answer VALUES(1255,314,2,'<img src=''etj201c.png''>',' ');
INSERT INTO answer VALUES(1256,314,3,'<img src=''etj201d.png''>',' ');
INSERT INTO answer VALUES(1257,315,0,'Der Spannungsmesser ist parallel zum Messobjekt anzuschließen und sollte hochohmig sein.',' ');
INSERT INTO answer VALUES(1258,315,1,'Der Spannungsmesser ist in den Stromkreis einzuschleifen und sollte niederohmig sein.',' ');
INSERT INTO answer VALUES(1259,315,2,'Der Spannungsmesser ist parallel zum Messobjekt anzuschließen und sollte niederohmig sein.',' ');
INSERT INTO answer VALUES(1260,315,3,'Der Spannungsmesser ist in den Stromkreis einzuschleifen und sollte hochohmig sein.',' ');
INSERT INTO answer VALUES(1261,316,0,'250 Hz.',' ');
INSERT INTO answer VALUES(1262,316,1,'500 Hz.',' ');
INSERT INTO answer VALUES(1263,316,2,'667 Hz.',' ');
INSERT INTO answer VALUES(1264,316,3,'333 Hz.',' ');
INSERT INTO answer VALUES(1265,317,0,'Zur Überprüfung der Anpassung des Senders an die Antenne.',' ');
INSERT INTO answer VALUES(1266,317,1,'Zur Frequenzkontrolle.',' ');
INSERT INTO answer VALUES(1267,317,2,'Zur Modulationskontrolle.',' ');
INSERT INTO answer VALUES(1268,317,3,'Als Abschluss des Senders.',' ');
INSERT INTO answer VALUES(1269,318,0,'2,93 V',' ');
INSERT INTO answer VALUES(1270,318,1,'29,3 V',' ');
INSERT INTO answer VALUES(1271,318,2,'8,8 V',' ');
INSERT INTO answer VALUES(1272,318,3,'88 V',' ');
INSERT INTO answer VALUES(1273,319,0,'Antennenkabel und Antenne.',' ');
INSERT INTO answer VALUES(1274,319,1,'Senderausgang und Antennenkabel.',' ');
INSERT INTO answer VALUES(1275,319,2,'Antennenkabel und Dummy Load.',' ');
INSERT INTO answer VALUES(1276,319,3,'Senderausgang und Antennenanpassgerät.',' ');
INSERT INTO answer VALUES(1277,320,0,'ein Stehwellenverhältnis von 1 anzeigen.',' ');
INSERT INTO answer VALUES(1278,320,1,'einen Rücklauf von 100% anzeigen.',' ');
INSERT INTO answer VALUES(1279,320,2,'ein Stehwellenverhältnis von 0 anzeigen.',' ');
INSERT INTO answer VALUES(1280,320,3,'ein Stehwellenverhältnis von unendlich anzeigen.',' ');
INSERT INTO answer VALUES(1281,321,0,'Ein Frequenzzähler',' ');
INSERT INTO answer VALUES(1282,321,1,'Ein Resonanzwellenmesser',' ');
INSERT INTO answer VALUES(1283,321,2,'Ein Oszilloskop',' ');
INSERT INTO answer VALUES(1284,321,3,'Ein Universalmessgerät',' ');
INSERT INTO answer VALUES(1285,322,0,'mit einer VSWR-Messbrücke.',' ');
INSERT INTO answer VALUES(1286,322,1,'mit einem Absorptionswellenmesser oder einem Dipmeter.',' ');
INSERT INTO answer VALUES(1287,322,2,'durch Strommessung am Anfang und am Ende der Speiseleitung.',' ');
INSERT INTO answer VALUES(1288,322,3,'durch Spannungsmessung am Anfang und am Ende der Speiseleitung.',' ');
INSERT INTO answer VALUES(1289,323,0,'der Antennenanpassung.',' ');
INSERT INTO answer VALUES(1290,323,1,'der Oberwellenausgangsleistung.',' ');
INSERT INTO answer VALUES(1291,323,2,'der Bandbreite.',' ');
INSERT INTO answer VALUES(1292,323,3,'des Wirkungsgrades.',' ');
INSERT INTO answer VALUES(1293,324,0,'Punkt 1',' ');
INSERT INTO answer VALUES(1294,324,1,'Punkt 2',' ');
INSERT INTO answer VALUES(1295,324,2,'Punkt 3',' ');
INSERT INTO answer VALUES(1296,324,3,'Punkt 4',' ');
INSERT INTO answer VALUES(1297,325,0,'Durch den Rückgang der Empfindlichkeit und ggf. das Auftreten von Brodelgeräuschen.',' ');
INSERT INTO answer VALUES(1298,325,1,'Durch Empfindlichkeitssteigerung.',' ');
INSERT INTO answer VALUES(1299,325,2,'Durch das Auftreten von Pfeifstellen im gesamten Abstimmungsbereich.',' ');
INSERT INTO answer VALUES(1300,325,3,'Durch eine zeitweilige Blockierung der Frequenzeinstellung.',' ');
INSERT INTO answer VALUES(1301,326,0,'Es treten Phantomsignale auf, die bei Einschalten eines Abschwächers verschwinden.',' ');
INSERT INTO answer VALUES(1302,326,1,'Das Nutzsignal wird mit einem anderen Signal moduliert und dadurch unverständlich.',' ');
INSERT INTO answer VALUES(1303,326,2,'Es treten Pfeifstellen gleichen Abstands im gesamten Empfangsbereich auf.',' ');
INSERT INTO answer VALUES(1304,326,3,'Dem Empfangssignal ist ein pulsierendes Rauschen überlagert, das die Verständlichkeit beeinträchtigt.',' ');
INSERT INTO answer VALUES(1305,327,0,'Sie empfehlen dem Nachbarn höflich, sich an die Bundesnetzagentur zur Prüfung der Störungsursache zu wenden.',' ');
INSERT INTO answer VALUES(1306,327,1,'Der Nachbar sollte höflich darauf hingewiesen werden, dass es an seiner eigenen Einrichtung liegt.',' ');
INSERT INTO answer VALUES(1307,327,2,'Der Nachbar sollte darauf hingewiesen werden, dass Sie hierfür nicht zuständig sind.',' ');
INSERT INTO answer VALUES(1308,327,3,'Sie benachrichtigen ihren Amateurfunkverband.',' ');
INSERT INTO answer VALUES(1309,328,0,'den geltenden Richtwerten entsprechen.',' ');
INSERT INTO answer VALUES(1310,328,1,'30 dB betragen.',' ');
INSERT INTO answer VALUES(1311,328,2,'100 dB betragen.',' ');
INSERT INTO answer VALUES(1312,328,3,'20 dB betragen.',' ');
INSERT INTO answer VALUES(1313,329,0,'über Leitungen oder Kabel in das zu überprüfende Gerät gelangt.',' ');
INSERT INTO answer VALUES(1314,329,1,'über das ungenügend abgeschirmte Gehäuse in die Elektronik gelangt.',' ');
INSERT INTO answer VALUES(1315,329,2,'über nicht genügend geschirmte Kabel zum Anpassgerät geführt wird.',' ');
INSERT INTO answer VALUES(1316,329,3,'wegen eines schlechten Stehwellenverhältnisses wieder zum Sender zurück strömt.',' ');
INSERT INTO answer VALUES(1317,330,0,'über das ungenügend abgeschirmte Gehäuse in die Elektronik gelangt.',' ');
INSERT INTO answer VALUES(1318,330,1,'über Leitungen oder Kabel in das gestörte Gerät gelangt.',' ');
INSERT INTO answer VALUES(1319,330,2,'über nicht genügend geschirmte Kabel zum gestörten Empfänger gelangt.',' ');
INSERT INTO answer VALUES(1320,330,3,'wegen eines schlechten Stehwellenverhältnisses wieder zum Sender zurück strahlt.',' ');
INSERT INTO answer VALUES(1321,331,0,'Blockierung oder störende Beeinflussung',' ');
INSERT INTO answer VALUES(1322,331,1,'Störung durch unerwünschte Aussendungen',' ');
INSERT INTO answer VALUES(1323,331,2,'Störung durch Nebenaussendungen',' ');
INSERT INTO answer VALUES(1324,331,3,'Hinzunehmende Störung',' ');
INSERT INTO answer VALUES(1325,332,0,'Durch Gleichrichtung starker HF-Signale in der NF-Endstufe der Stereoanlage.',' ');
INSERT INTO answer VALUES(1326,332,1,'Durch Gleichrichtung der ins Stromnetz eingestrahlten HF-Signale an den Dioden des Netzteils.',' ');
INSERT INTO answer VALUES(1327,332,2,'Durch Gleichrichtung abgestrahlter HF-Signale an PN-Übergängen in der NF-Vorstufe.',' ');
INSERT INTO answer VALUES(1328,332,3,'Durch eine Übersteuerung des Tuners mit dem über die Antennenzuleitung aufgenommenen HF-Signal.',' ');
INSERT INTO answer VALUES(1329,333,0,'Über jeden beliebigen Leitungsanschluss und/oder über die ZF-Stufen.',' ');
INSERT INTO answer VALUES(1330,333,1,'Über die Antennenleitung und über alle größeren ungeschirmten Spulen im Fernsehgerät (z.B. Entmagnetisierungsschleife).',' ');
INSERT INTO answer VALUES(1331,333,2,'Über die Stromversorgung des Senders und die Stromversorgung des Fernsehgeräts.',' ');
INSERT INTO answer VALUES(1332,333,3,'Über die Fernsehantenne bzw. das Antennenkabel sowie über die Bildröhre.',' ');
INSERT INTO answer VALUES(1333,334,0,'einem hohen Nebenwellenanteil.',' ');
INSERT INTO answer VALUES(1334,334,1,'lediglich geringen Verzerrungen beim Empfang.',' ');
INSERT INTO answer VALUES(1335,334,2,'einer besseren Verständlichkeit am Empfangsort.',' ');
INSERT INTO answer VALUES(1336,334,3,'einer Verringerung der Ausgangsleistung.',' ');
INSERT INTO answer VALUES(1337,335,0,'7,5 kHz.',' ');
INSERT INTO answer VALUES(1338,335,1,'0 kHz.',' ');
INSERT INTO answer VALUES(1339,335,2,'15 kHz.',' ');
INSERT INTO answer VALUES(1340,335,3,'2,7 kHz.',' ');
INSERT INTO answer VALUES(1341,336,0,'Hubeinstellung',' ');
INSERT INTO answer VALUES(1342,336,1,'HF-Begrenzereigenschaften',' ');
INSERT INTO answer VALUES(1343,336,2,'Vorspannungsreglereinstellung',' ');
INSERT INTO answer VALUES(1344,336,3,'Trägerfrequenz',' ');
INSERT INTO answer VALUES(1345,337,0,'er keine unerwünschten Aussendungen hervorruft.',' ');
INSERT INTO answer VALUES(1346,337,1,'die Selbsterregung maximiert wird.',' ');
INSERT INTO answer VALUES(1347,337,2,'parasitäre Schwingungen vorhanden sind.',' ');
INSERT INTO answer VALUES(1348,337,3,'die Oberwellenabschirmung minimiert wird.',' ');
INSERT INTO answer VALUES(1349,338,0,'werden Gleichtakt-HF-Störsignale unterdrückt.',' ');
INSERT INTO answer VALUES(1350,338,1,'werden niederfrequente Störsignale unterdrückt.',' ');
INSERT INTO answer VALUES(1351,338,2,'werden alle Wechselstromsignale unterdrückt.',' ');
INSERT INTO answer VALUES(1352,338,3,'wird Netzbrummen unterdrückt.',' ');
INSERT INTO answer VALUES(1353,339,0,'Rechtwinklig zur Häuserzeile mit abgewandter Strahlungsrichtung',' ');
INSERT INTO answer VALUES(1354,339,1,'Am gemeinsamen Schornstein neben der Fernsehantenne',' ');
INSERT INTO answer VALUES(1355,339,2,'Entlang der Häuserzeile auf der Höhe der Dachrinne',' ');
INSERT INTO answer VALUES(1356,339,3,'Möglichst innerhalb des Dachbereichs',' ');
INSERT INTO answer VALUES(1357,340,0,'eine außen angebrachte Fernsehantenne zu installieren.',' ');
INSERT INTO answer VALUES(1358,340,1,'ein doppelt geschirmtes Koaxialkabel für die Antennenleitung zu verwenden.',' ');
INSERT INTO answer VALUES(1359,340,2,'einen Vorverstärker in die Antennenleitung einzuschleifen.',' ');
INSERT INTO answer VALUES(1360,340,3,'den Fernsehrundfunkempfänger zu wechseln.',' ');
INSERT INTO answer VALUES(1361,341,0,'die zuständige Außenstelle der Bundesnetzagentur um Prüfung der Gegebenheiten zu bitten.',' ');
INSERT INTO answer VALUES(1362,341,1,'der Sender an die Bundesnetzagentur zu senden.',' ');
INSERT INTO answer VALUES(1363,341,2,'die Rückseite des Fernsehgeräts zu entfernen und das Gehäuse zu erden.',' ');
INSERT INTO answer VALUES(1364,341,3,'ein Fernsehtechniker um Prüfung des Fernsehgeräts zu bitten.',' ');
INSERT INTO answer VALUES(1365,342,0,'auf das für eine zufrieden stellende Kommunikation erforderliche Minimum eingestellt werden.',' ');
INSERT INTO answer VALUES(1366,342,1,'nur auf den zulässigen Pegel eingestellt werden.',' ');
INSERT INTO answer VALUES(1367,342,2,'auf die für eine zufriedenstellende Kommunikation erforderlichen 100 W eingestellt werden.',' ');
INSERT INTO answer VALUES(1368,342,3,'die Hälfte des maximal zulässigen Pegels betragen.',' ');
INSERT INTO answer VALUES(1369,343,0,'Ein Hochpassfilter',' ');
INSERT INTO answer VALUES(1370,343,1,'Ein Tiefpassfilter',' ');
INSERT INTO answer VALUES(1371,343,2,'Eine Bandsperre für die Fernsehbereiche',' ');
INSERT INTO answer VALUES(1372,343,3,'Ein regelbares Dämpfungsglied',' ');
INSERT INTO answer VALUES(1373,344,0,'Ein Hochpassfilter',' ');
INSERT INTO answer VALUES(1374,344,1,'Ein Tiefpassfilter',' ');
INSERT INTO answer VALUES(1375,344,2,'Ein UHF-Abschwächer',' ');
INSERT INTO answer VALUES(1376,344,3,'Eine UHF-Bandsperre',' ');
INSERT INTO answer VALUES(1377,345,0,'Ein Hochpassfilter vor dem Antennennanschluss und zusätzlich je eine Ferritdrossel vor alle Leitungsanschlüsse der gestörten Geräte.',' ');
INSERT INTO answer VALUES(1378,345,1,'Je ein Tiefpassfilter unmittelbar vor dem Antennennanschluss und in das Netzkabel der gestörten Geräte.',' ');
INSERT INTO answer VALUES(1379,345,2,'Eine Bandsperre für die Fernsehbereiche unmittelbar vor dem Antennennanschluss und ein Tiefpassfilter in das Netzkabel der gestörten Geräte.',' ');
INSERT INTO answer VALUES(1380,345,3,'Ein Bandpassfilter bei 30 MHz unmittelbar vor dem Antennennanschluss und ein Tiefpassfilter in das Netzkabel der gestörten Geräte.',' ');
INSERT INTO answer VALUES(1381,346,0,'eine Mantelwellendrossel einzubauen.',' ');
INSERT INTO answer VALUES(1382,346,1,'die Erdverbindung des Senders abzuklemmen.',' ');
INSERT INTO answer VALUES(1383,346,2,'das Abschirmgeflecht am Antennenstecker des Empfängers abzuklemmen.',' ');
INSERT INTO answer VALUES(1384,346,3,'den 144-MHz-Sender mit einem Tiefpassfilter auszustatten.',' ');
INSERT INTO answer VALUES(1385,347,0,'eine getrennte HF-Erdleitung zu verwenden.',' ');
INSERT INTO answer VALUES(1386,347,1,'Antennen auf dem Dachboden zu errichten.',' ');
INSERT INTO answer VALUES(1387,347,2,'die Amateurfunkgeräte mit einem Wasserrohr zu verbinden.',' ');
INSERT INTO answer VALUES(1388,347,3,'die Amateurfunkgeräte mittels des Schutzleiters zu erden.',' ');
INSERT INTO answer VALUES(1389,348,0,'geschirmte Lautsprecherleitungen zu verwenden.',' ');
INSERT INTO answer VALUES(1390,348,1,'ein NF-Filter in das Koaxialkabel einzuschleifen.',' ');
INSERT INTO answer VALUES(1391,348,2,'einen Serienkondensator in die Lautsprecherleitung einzubauen.',' ');
INSERT INTO answer VALUES(1392,348,3,'ein geschirmtes Netzkabel für den Receiver zu verwenden.',' ');
INSERT INTO answer VALUES(1393,349,0,'<img src=''etk314a.png''>',' ');
INSERT INTO answer VALUES(1394,349,1,'<img src=''etk314b.png''>',' ');
INSERT INTO answer VALUES(1395,349,2,'<img src=''etk314c.png''>',' ');
INSERT INTO answer VALUES(1396,349,3,'<img src=''etk314d.png''>',' ');
INSERT INTO answer VALUES(1397,350,0,'mit keiner höheren Leistung zu senden als für eine sichere Kommunikation erforderlich ist.',' ');
INSERT INTO answer VALUES(1398,350,1,'nur mit effektiver Leistung zu senden.',' ');
INSERT INTO answer VALUES(1399,350,2,'nur mit einer Hochgewinn-Richtantenne zu senden.',' ');
INSERT INTO answer VALUES(1400,350,3,'die Antenne unterhalb der Dachhöhe herabzulassen.',' ');
INSERT INTO answer VALUES(1401,351,0,'können Hochfrequenzströme eingekoppelt werden.',' ');
INSERT INTO answer VALUES(1402,351,1,'können harmonische Schwingungen erzeugt werden.',' ');
INSERT INTO answer VALUES(1403,351,2,'könnte erhebliche Überspannung im Netz erzeugt werden.',' ');
INSERT INTO answer VALUES(1404,351,3,'kann 50-Hz-Modulation aller Signale auftreten.',' ');
INSERT INTO answer VALUES(1405,352,0,'einer Übersteuerung eines TV-Empfängers.',' ');
INSERT INTO answer VALUES(1406,352,1,'Problemen mit dem 435-MHz-Empfänger.',' ');
INSERT INTO answer VALUES(1407,352,2,'Eigenschwingungen des 435-MHz-Senders.',' ');
INSERT INTO answer VALUES(1408,352,3,'dem Durchschlag des TV-Antennenkoaxialkabels.',' ');
INSERT INTO answer VALUES(1409,353,0,'Sender im 160-m-Band.',' ');
INSERT INTO answer VALUES(1410,353,1,'UHF-Sender.',' ');
INSERT INTO answer VALUES(1411,353,2,'VHF-Sender.',' ');
INSERT INTO answer VALUES(1412,353,3,'Sender im 10-m-Band.',' ');
INSERT INTO answer VALUES(1413,354,0,'kann in Verbindung mit dem Signal naher Sender unerwünschte Mischprodukte erzeugen, die den Fernsehempfang stören.',' ');
INSERT INTO answer VALUES(1414,354,1,'kann in Verbindung mit dem Oszillatorsignal des Fernsehempfängers unerwünschte Mischprodukte erzeugen, die den Fernsehempfang stören.',' ');
INSERT INTO answer VALUES(1415,354,2,'kann in Verbindung mit Einstreuungen aus dem Stromnetz durch Intermodulation Bild- und Tonstörungen hervorrufen.',' ');
INSERT INTO answer VALUES(1416,354,3,'kann in Verbindung mit dem Signal naher Sender parametrische Schwingungen erzeugen, die einen überhöhten Nutzsignalpegel hervorrufen.',' ');
INSERT INTO answer VALUES(1417,355,0,'sollten alle Einrichtungen mit einer guten HF-Erdung versehen werden.',' ');
INSERT INTO answer VALUES(1418,355,1,'sollte der Sender mit der Wasserleitung im Haus verbunden werden.',' ');
INSERT INTO answer VALUES(1419,355,2,'sollten alle schlechten Erdverbindungen entfernt werden.',' ');
INSERT INTO answer VALUES(1420,355,3,'sollten Wasserleitungsanschlüsse aus Polyäthylen zur Isolation vorgesehen werden.',' ');
INSERT INTO answer VALUES(1421,356,0,'P<sub>ERP</sub> = (P<sub>Sender</sub> - P<sub>Verluste</sub>) * G<sub>Antenne</sub> bezogen auf einen Halbwellendipol',' ');
INSERT INTO answer VALUES(1422,356,1,'P<sub>ERP</sub> = P<sub>Sender</sub> * G<sub>Antenne</sub> - P<sub>Verluste</sub> bezogen auf einen isotropen Kugelstrahler',' ');
INSERT INTO answer VALUES(1423,356,2,'P<sub>ERP</sub> = (P<sub>Sender</sub> + P<sub>Verluste</sub>) * G<sub>Antenne</sub> bezogen auf einen Halbwellendipol',' ');
INSERT INTO answer VALUES(1424,356,3,'P<sub>ERP</sub> = P<sub>Sender</sub> + P<sub>Verluste</sub> + G<sub>Antenne</sub> bezogen auf einen isotropen Kugelstrahler',' ');
INSERT INTO answer VALUES(1425,357,0,'P<sub>EIRP</sub> = (P<sub>Sender</sub> - P<sub>Verluste</sub>) * G<sub>Antenne</sub> bezogen auf einen isotropen Kugelstrahler',' ');
INSERT INTO answer VALUES(1426,357,1,'P<sub>EIRP</sub> = (P<sub>Sender</sub> * G<sub>Antenne</sub>) - P<sub>Verluste</sub> bezogen auf einen Halbwellendipol',' ');
INSERT INTO answer VALUES(1427,357,2,'P<sub>EIRP</sub> = (P<sub>Sender</sub> + P<sub>Verluste</sub>) * G<sub>Antenne</sub> bezogen auf einen Halbwellendipol',' ');
INSERT INTO answer VALUES(1428,357,3,'P<sub>EIRP</sub> = P<sub>Sender</sub> + P<sub>Verluste</sub> + G<sub>Antenne</sub> bezogen auf einen isotropen Kugelstrahler',' ');
INSERT INTO answer VALUES(1429,358,0,'Es ist das Produkt aus der zugeführten Leistung und dem Gewinnfaktor der Antenne und stellt die Leistung dar, die man einem isotropen Strahler zuführen müsste, damit dieser im Fernfeld dieselbe elektrische Feldstärke erzeugte, wie die Antenne.',' ');
INSERT INTO answer VALUES(1430,358,1,'Es ist die Eingangsleistung des verwendeten Senders wie sie in der EMVU-Selbsterklärung anzugeben ist.',' ');
INSERT INTO answer VALUES(1431,358,2,'Es handelt sich um die Leistung, die man im Maximum der Strahlungskeule einer Dipolantenne vorfindet.',' ');
INSERT INTO answer VALUES(1432,358,3,'Es ist das Produkt aus der zugeführten Leistung und dem Antennengewinnfaktor und stellt die durchschnittliche isotrope Spitzenleistung am Senderausgang der Amateurfunkstelle dar, wie sie in der EMVU-Selbsterklärung anzugeben ist.',' ');
INSERT INTO answer VALUES(1433,359,0,'9,8 Watt',' ');
INSERT INTO answer VALUES(1434,359,1,'6,0 Watt',' ');
INSERT INTO answer VALUES(1435,359,2,'7,8 Watt',' ');
INSERT INTO answer VALUES(1436,359,3,'12,7 Watt',' ');
INSERT INTO answer VALUES(1437,360,0,'16,4 Watt',' ');
INSERT INTO answer VALUES(1438,360,1,'6,1 Watt',' ');
INSERT INTO answer VALUES(1439,360,2,'10,0 Watt',' ');
INSERT INTO answer VALUES(1440,360,3,'32,8 Watt',' ');
INSERT INTO answer VALUES(1441,361,0,'75 Watt',' ');
INSERT INTO answer VALUES(1442,361,1,'123 W',' ');
INSERT INTO answer VALUES(1443,361,2,'45,7 W',' ');
INSERT INTO answer VALUES(1444,361,3,'60,6 W',' ');
INSERT INTO answer VALUES(1445,362,0,'Ja, er ist in diesem Fall verpflichtet die Einhaltung der Personenschutzgrenzwerte nachzuweisen.',' ');
INSERT INTO answer VALUES(1446,362,1,'Nein, der Schutz von Personen in elektromagnetischen Feldern ist durch den Funkamateur erst bei einer Strahlungsleistung von mehr als 10 W EIRP sicherzustellen.',' ');
INSERT INTO answer VALUES(1447,362,2,'Nein, aber er muss die Herzschrittmachergrenzwerte einhalten.',' ');
INSERT INTO answer VALUES(1448,362,3,'Nein, bei der Sendeart F3E und Sendezeiten unter 6 Minuten in der Stunde kann der Schutz von Personen in elektromagnetischen Feldern durch den Funkamateur vernachlässigt werden.',' ');
INSERT INTO answer VALUES(1449,363,0,'kleiner 3 Watt (Zuleitungsverluste vernachlässigt)',' ');
INSERT INTO answer VALUES(1450,363,1,'kleiner 6 Watt (Zuleitungsverluste vernachlässigt)',' ');
INSERT INTO answer VALUES(1451,363,2,'kleiner 10 Watt (Zuleitungsverluste vernachlässigt)',' ');
INSERT INTO answer VALUES(1452,363,3,'kleiner 16,4 Watt (Zuleitungsverluste vernachlässigt)',' ');
INSERT INTO answer VALUES(1453,364,0,'2,50 m',' ');
INSERT INTO answer VALUES(1454,364,1,'1,96 m',' ');
INSERT INTO answer VALUES(1455,364,2,'5,01 m',' ');
INSERT INTO answer VALUES(1456,364,3,'13,7 m',' ');
INSERT INTO answer VALUES(1457,365,0,'5,01 m',' ');
INSERT INTO answer VALUES(1458,365,1,'3,91 m',' ');
INSERT INTO answer VALUES(1459,365,2,'2,50 m',' ');
INSERT INTO answer VALUES(1460,365,3,'20,70 m',' ');
INSERT INTO answer VALUES(1461,366,0,'6,86 m',' ');
INSERT INTO answer VALUES(1462,366,1,'5,35 m',' ');
INSERT INTO answer VALUES(1463,366,2,'2,17 m',' ');
INSERT INTO answer VALUES(1464,366,3,'36,3 m',' ');
INSERT INTO answer VALUES(1465,367,0,'Von jedem Punkt der Antenne',' ');
INSERT INTO answer VALUES(1466,367,1,'Vom Einspeisepunkt der Antenne',' ');
INSERT INTO answer VALUES(1467,367,2,'Von der Mitte der Antenne, d.h. dort, wo sie am Mast befestigt ist',' ');
INSERT INTO answer VALUES(1468,367,3,'Vom untersten Punkt der Antenne',' ');
INSERT INTO answer VALUES(1469,368,0,'Mit dem Mittelwert der Ausgangsleistung gemittelt über ein Intervall von 6 Minuten.',' ');
INSERT INTO answer VALUES(1470,368,1,'Mit der größten Ausgangsleistung des Transceivers zuzüglich Antennengewinn, korrigiert um den Gewichtungsfaktor für die verwendete Betriebsart.',' ');
INSERT INTO answer VALUES(1471,368,2,'Mit der durchschnittlich benutzten Ausgangsleistung gemittelt über den Betriebszeitraum und korrigiert um den Gewichtungsfaktor für die verwendete Betriebsart.',' ');
INSERT INTO answer VALUES(1472,368,3,'Mit der maximalen Ausgangsleistung des verwendeten Senders zuzüglich 3 dB Messfehler.',' ');
INSERT INTO answer VALUES(1473,369,0,'Nein, die Feldstärke beeinflusst unmittelbar, also zeitunabhängig.',' ');
INSERT INTO answer VALUES(1474,369,1,'Ja, Grenzwerte gelten im Zeitraum einer Kurzzeitexposition bis zu 6 Minuten.',' ');
INSERT INTO answer VALUES(1475,369,2,'Ja, die Grenzwerte gelten im Zeitraum einer Exposition von 6 Minuten bis zu 8 Stunden.',' ');
INSERT INTO answer VALUES(1476,369,3,'Ja, in Abhängigkeit von der körperlichen Verfassung des Herzschrittmacherträgers.',' ');
INSERT INTO answer VALUES(1477,370,0,'Wenn die vorhandene Blitzschutzanlage fachgerecht aufgebaut ist und das Standrohr mit ihr auf dem kürzesten Wege verbunden werden kann.',' ');
INSERT INTO answer VALUES(1478,370,1,'Nach den geltenden Vorschriften muss das Standrohr der Amateurfunkantenne mit einer vorhandenen Gebäude-Blitzschutzanlage verbunden werden.',' ');
INSERT INTO answer VALUES(1479,370,2,'Nach den geltenden Vorschriften muss immer eine eigene Blitzschutzanlage für eine Amateurfunkantenne aufgebaut werden.',' ');
INSERT INTO answer VALUES(1480,370,3,'Die Bedingung ist ein ausreichend großer Querschnitt für die Verbindungsleitung zur Blitzschutzanlage.',' ');
INSERT INTO answer VALUES(1481,371,0,'Als geeigneter Erdungsleiter gilt ein Einzelmassivdraht mit einem Mindestquerschnitt von 16 mm2 Kupfer, isoliert oder blank, oder 25 mm2 Aluminium isoliert oder 50 mm2 Stahl.',' ');
INSERT INTO answer VALUES(1482,371,1,'Ein- oder mehrdrähtiger - aber nicht feindrähtiger - isolierter oder blanker Kupferleiter mit mindestens 10 mm2 Querschnitt oder ein Aluminiumleiter mit mindestens 16 mm2 Querschnitt.',' ');
INSERT INTO answer VALUES(1483,371,2,'Ein- oder mehrdrähtiger - aber nicht feindrähtiger - isolierter oder blanker Kupferleiter mit mindestens 25 mm2 Querschnitt oder ein Aluminiumleiter mit mindestens 50 mm2 Querschnitt.',' ');
INSERT INTO answer VALUES(1484,371,3,'Als geeigneter Erdungsleiter gilt ein Einzeldraht mit einem Mindestquerschnitt von 4 mm2 Kupfer, isoliert oder blank, oder 10 mm2 Aluminium isoliert.',' ');
INSERT INTO answer VALUES(1485,372,0,'Jeder ordnungsgemäß verlegte Fundamenterder kann verwendet werden, sofern alle Blitzschutzleitungen bis zur Potentialausgleichsschiene getrennt geführt werden.',' ');
INSERT INTO answer VALUES(1486,372,1,'Nach den geltenden Vorschriften muss immer eine eigene Blitzschutzanlage, also auch ein eigener Fundamenterder, für eine Amateurfunkantenne aufgebaut werden.',' ');
INSERT INTO answer VALUES(1487,372,2,'Die in den Sicherheitsvorschriften festgelegte zulässige Leitungslänge des Erdungsleiters darf auf keinen Fall überschritten werden.',' ');
INSERT INTO answer VALUES(1488,372,3,'Die Ausdehnung des Fundamenterders muss größer oder wenigstens gleich der Ausdehnung der Antennenanlage sein.',' ');
INSERT INTO answer VALUES(1489,373,0,'Die Außenleiter (Abschirmung) aller Koaxialkabel- Niederführungen müssen über einen Potentialausgleichsleiter normgerecht mit Erde verbunden werden.',' ');
INSERT INTO answer VALUES(1490,373,1,'Für alle Koaxialkabel-Niederführungen sind entsprechend den Sicherheitsvorschriften Überspannungsableiter vorzusehen.',' ');
INSERT INTO answer VALUES(1491,373,2,'Neben der Erdung des Antennenmastes sind keine weiteren Maßnahmen erforderlich.',' ');
INSERT INTO answer VALUES(1492,373,3,'Die Koaxialkabel müssen das entsprechende Schirmungsmaß aufweisen und entsprechend isoliert sein.',' ');
INSERT INTO answer VALUES(1493,374,0,'grüngelb, braun, blau',' ');
INSERT INTO answer VALUES(1494,374,1,'braun, grüngelb, blau',' ');
INSERT INTO answer VALUES(1495,374,2,'grau, schwarz, rot',' ');
INSERT INTO answer VALUES(1496,374,3,'grüngelb, blau, braun oder schwarz',' ');
INSERT INTO answer VALUES(1497,375,0,'die Anweisungen des Kfz-Herstellers zu beachten.',' ');
INSERT INTO answer VALUES(1498,375,1,'die Bedingungen der Bundesnetzagentur für den Einbau mobiler Sendeanlagen einzuhalten.',' ');
INSERT INTO answer VALUES(1499,375,2,'die Ratschläge des Kfz-Händlers einzuhalten.',' ');
INSERT INTO answer VALUES(1500,375,3,'die Anweisungen des Amateurfunkgeräte- Herstellers zu beachten.',' ');
INSERT INTO answer VALUES(1501,376,0,'Auf der Mitte des Daches.',' ');
INSERT INTO answer VALUES(1502,376,1,'Auf der hinteren Stoßstange.',' ');
INSERT INTO answer VALUES(1503,376,2,'Auf dem vorderen Kotflügel.',' ');
INSERT INTO answer VALUES(1504,376,3,'Auf dem Armaturenbrett.',' ');
INSERT INTO answer VALUES(1505,377,0,'möglichst weit von der Fahrzeugverkabelung entfernt verlegt werden.',' ');
INSERT INTO answer VALUES(1506,377,1,'im Kabelbaum des Kraftfahrzeugs geführt werden.',' ');
INSERT INTO answer VALUES(1507,377,2,'über das Fahrzeugdach verlegt sein.',' ');
INSERT INTO answer VALUES(1508,377,3,'entlang der Innenseite des Motorraumes verlegt werden.',' ');
INSERT INTO answer VALUES(1509,378,0,'Volt pro Meter (V/m)',' ');
INSERT INTO answer VALUES(1510,378,1,'Watt pro Quadratmeter (W/m²)',' ');
INSERT INTO answer VALUES(1511,378,2,'Ampere pro Meter (A/m)',' ');
INSERT INTO answer VALUES(1512,378,3,'Henry pro Meter (H/m)',' ');
INSERT INTO answer VALUES(1513,379,0,'Ampere pro Meter (A/m)',' ');
INSERT INTO answer VALUES(1514,379,1,'Tesla (T)',' ');
INSERT INTO answer VALUES(1515,379,2,'Amperemeter (Am)',' ');
INSERT INTO answer VALUES(1516,379,3,'Henry pro Meter (H/m)',' ');
INSERT INTO answer VALUES(1517,380,0,'Ohm',' ');
INSERT INTO answer VALUES(1518,380,1,'Farad',' ');
INSERT INTO answer VALUES(1519,380,2,'Siemens',' ');
INSERT INTO answer VALUES(1520,380,3,'Henry',' ');
INSERT INTO answer VALUES(1521,381,0,'des Leitwertes eines Widerstands.',' ');
INSERT INTO answer VALUES(1522,381,1,'des ohmschen Widerstands.',' ');
INSERT INTO answer VALUES(1523,381,2,'der Impedanz einer Leitung.',' ');
INSERT INTO answer VALUES(1524,381,3,'der magnetischen Feldstärke.',' ');
INSERT INTO answer VALUES(1525,382,0,'Hz = 1/s',' ');
INSERT INTO answer VALUES(1526,382,1,'Hz = s',' ');
INSERT INTO answer VALUES(1527,382,2,'Hz = s²',' ');
INSERT INTO answer VALUES(1528,382,3,'Hz = 1/s²',' ');
INSERT INTO answer VALUES(1529,383,0,'Meter, Kelvin, Sekunde, Ampere',' ');
INSERT INTO answer VALUES(1530,383,1,'Radiant, Meter, Volt, Watt',' ');
INSERT INTO answer VALUES(1531,383,2,'Farad, Henry, Ohm, Sekunde',' ');
INSERT INTO answer VALUES(1532,383,3,'Grad, Hertz, Ohm, Tesla',' ');
INSERT INTO answer VALUES(1533,384,0,'23,5 dB.',' ');
INSERT INTO answer VALUES(1534,384,1,'52 dB.',' ');
INSERT INTO answer VALUES(1535,384,2,'47 dB.',' ');
INSERT INTO answer VALUES(1536,384,3,'11,7 dB.',' ');
INSERT INTO answer VALUES(1537,385,0,'16 dB.',' ');
INSERT INTO answer VALUES(1538,385,1,'60 dB.',' ');
INSERT INTO answer VALUES(1539,385,2,'32 dB.',' ');
INSERT INTO answer VALUES(1540,385,3,'24 dB.',' ');
INSERT INTO answer VALUES(1541,386,0,'18 dB',' ');
INSERT INTO answer VALUES(1542,386,1,'9 dB',' ');
INSERT INTO answer VALUES(1543,386,2,'28 dB',' ');
INSERT INTO answer VALUES(1544,386,3,'3 dB',' ');
INSERT INTO answer VALUES(1545,387,0,'1 V/m.',' ');
INSERT INTO answer VALUES(1546,387,1,'10 V/m.',' ');
INSERT INTO answer VALUES(1547,387,2,'1000 V/m.',' ');
INSERT INTO answer VALUES(1548,387,3,'1000 kV/m.',' ');
INSERT INTO answer VALUES(1549,388,0,'10<sup>-1</sup> W.',' ');
INSERT INTO answer VALUES(1550,388,1,'0,001 W.',' ');
INSERT INTO answer VALUES(1551,388,2,'0,01 W.',' ');
INSERT INTO answer VALUES(1552,388,3,'10<sup>-2</sup> W.',' ');
INSERT INTO answer VALUES(1553,389,0,'40 dBm',' ');
INSERT INTO answer VALUES(1554,389,1,'30 dBm',' ');
INSERT INTO answer VALUES(1555,389,2,'20 dBm',' ');
INSERT INTO answer VALUES(1556,389,3,'10 dBm',' ');
INSERT INTO answer VALUES(1557,390,0,'10<sup>2</sup> W.',' ');
INSERT INTO answer VALUES(1558,390,1,'10<sup>0,5</sup> W.',' ');
INSERT INTO answer VALUES(1559,390,2,'10<sup>20</sup> W.',' ');
INSERT INTO answer VALUES(1560,390,3,'10<sup>1</sup> W.',' ');
INSERT INTO answer VALUES(1561,391,0,'20 kHz.',' ');
INSERT INTO answer VALUES(1562,391,1,'2 MHz.',' ');
INSERT INTO answer VALUES(1563,391,2,'200 kHz.',' ');
INSERT INTO answer VALUES(1564,391,3,'20 MHz.',' ');
INSERT INTO answer VALUES(1565,392,0,'7,460 MHz.',' ');
INSERT INTO answer VALUES(1566,392,1,'1,865 MHz.',' ');
INSERT INTO answer VALUES(1567,392,2,'11,190 MHz.',' ');
INSERT INTO answer VALUES(1568,392,3,'14,920 MHz.',' ');
INSERT INTO answer VALUES(1569,393,0,'434,070 MHz.',' ');
INSERT INTO answer VALUES(1570,393,1,'289,380 MHz.',' ');
INSERT INTO answer VALUES(1571,393,2,'145,000 MHz.',' ');
INSERT INTO answer VALUES(1572,393,3,'723,450 MHz.',' ');
INSERT INTO answer VALUES(1573,394,0,'0,0001 %.',' ');
INSERT INTO answer VALUES(1574,394,1,'0,001 %.',' ');
INSERT INTO answer VALUES(1575,394,2,'0,01 %.',' ');
INSERT INTO answer VALUES(1576,394,3,'0,1 %.',' ');
INSERT INTO answer VALUES(1577,395,0,'Zwischen 14,2498575 und 14,2501425 MHz',' ');
INSERT INTO answer VALUES(1578,395,1,'Zwischen 14,24998575 und 14,25001425 MHz',' ');
INSERT INTO answer VALUES(1579,395,2,'Zwischen 14,249998575 und 14,250001425 MHz',' ');
INSERT INTO answer VALUES(1580,395,3,'Zwischen 14,248575 und 14,251425 MHz',' ');
INSERT INTO answer VALUES(1581,396,0,'300000 km/s.',' ');
INSERT INTO answer VALUES(1582,396,1,'3000000 km/s.',' ');
INSERT INTO answer VALUES(1583,396,2,'30000 km/s.',' ');
INSERT INTO answer VALUES(1584,396,3,'3000 km/s.',' ');
INSERT INTO answer VALUES(1585,397,0,'10 GHz',' ');
INSERT INTO answer VALUES(1586,397,1,'100 MHz',' ');
INSERT INTO answer VALUES(1587,397,2,'1 MHz',' ');
INSERT INTO answer VALUES(1588,397,3,'100 kHz',' ');
INSERT INTO answer VALUES(1589,398,0,'3 GHz.',' ');
INSERT INTO answer VALUES(1590,398,1,'1,9 GHz.',' ');
INSERT INTO answer VALUES(1591,398,2,'3 MHz.',' ');
INSERT INTO answer VALUES(1592,398,3,'10 GHz.',' ');
INSERT INTO answer VALUES(1593,399,0,'&lambda; = 13,64 m',' ');
INSERT INTO answer VALUES(1594,399,1,'&lambda; = 14,33 m',' ');
INSERT INTO answer VALUES(1595,399,2,'&lambda; = 12,93 m',' ');
INSERT INTO answer VALUES(1596,399,3,'&lambda; = 136,3 m',' ');
INSERT INTO answer VALUES(1597,400,0,'145,631 MHz.',' ');
INSERT INTO answer VALUES(1598,400,1,'150,247 MHz.',' ');
INSERT INTO answer VALUES(1599,400,2,'148,927 MHz.',' ');
INSERT INTO answer VALUES(1600,400,3,'135,754 MHz.',' ');
INSERT INTO answer VALUES(1601,401,0,'434,783 MHz.',' ');
INSERT INTO answer VALUES(1602,401,1,'430,162 MHz.',' ');
INSERT INTO answer VALUES(1603,401,2,'435,574 MHz.',' ');
INSERT INTO answer VALUES(1604,401,3,'440,317 MHz.',' ');
INSERT INTO answer VALUES(1605,402,0,'das Verhältnis der Ausbreitungsgeschwindigkeit entlang einer Leitung zur Ausbreitungsgeschwindigkeit im Vakuum.',' ');
INSERT INTO answer VALUES(1606,402,1,'das Verhältnis von Durchmesser zur Länge eines Leiters.',' ');
INSERT INTO answer VALUES(1607,402,2,'das Verhältnis des Wellen- bzw. des Strahlungswiderstandes zum Feldwellenwiderstand des freien Raumes.',' ');
INSERT INTO answer VALUES(1608,402,3,'die Wurzel aus dem Verhältnis von Induktivität zur Kapazität einer Leitung.',' ');
INSERT INTO answer VALUES(1609,403,0,'bei einer Länge von 1000 mm und einem Querschnitt von 1 mm².',' ');
INSERT INTO answer VALUES(1610,403,1,'bei einer Länge von 100 mm und einem Querschnitt von 1 mm².',' ');
INSERT INTO answer VALUES(1611,403,2,'bei einer Länge von 1 m und einem Querschnitt von 0,1 mm².',' ');
INSERT INTO answer VALUES(1612,403,3,'bei einer Länge von 100 mm und einem Querschnitt von 0,1 mm².',' ');
INSERT INTO answer VALUES(1613,404,0,'1 &Omega;',' ');
INSERT INTO answer VALUES(1614,404,1,'56 &Omega;',' ');
INSERT INTO answer VALUES(1615,404,2,'0,05 &Omega;',' ');
INSERT INTO answer VALUES(1616,404,3,'5,6 &Omega;',' ');
INSERT INTO answer VALUES(1617,405,0,'42,1 m',' ');
INSERT INTO answer VALUES(1618,405,1,'25,3 m',' ');
INSERT INTO answer VALUES(1619,405,2,'4,2 m',' ');
INSERT INTO answer VALUES(1620,405,3,'168,5 m',' ');
INSERT INTO answer VALUES(1621,406,0,'positiv.',' ');
INSERT INTO answer VALUES(1622,406,1,'negativ.',' ');
INSERT INTO answer VALUES(1623,406,2,'logarithmisch.',' ');
INSERT INTO answer VALUES(1624,406,3,'exponentiell.',' ');
INSERT INTO answer VALUES(1625,407,0,'Epoxyd, Polyethylen (PE), Polystyrol (PS)',' ');
INSERT INTO answer VALUES(1626,407,1,'Pertinax, Polyvinylchlorid (PVC), Graphit',' ');
INSERT INTO answer VALUES(1627,407,2,'Polyethylen (PE), Messing, Konstantan',' ');
INSERT INTO answer VALUES(1628,407,3,'Teflon, Pertinax, Bronze',' ');
INSERT INTO answer VALUES(1629,408,0,'Einige Stoffe (z.B. Silizium, Germanium) sind in reinem Zustand bei Zimmertemperatur gute Isolatoren. Durch geringfügige Zusätze von geeigneten anderen Stoffen oder bei hohen Temperaturen werden sie jedoch zu Leitern.',' ');
INSERT INTO answer VALUES(1630,408,1,'Einige Stoffe (z.B. Silizium, Germanium) sind in reinem Zustand bei Zimmertemperatur gute Leiter. Durch geringfügige Zusätze von geeigneten anderen Stoffen oder bei hohen Temperaturen nimmt jedoch ihre Leitfähigkeit ab.',' ');
INSERT INTO answer VALUES(1631,408,2,'Einige Stoffe wie z.B. Indium oder Magnesium sind in reinem Zustand gute Isolatoren. Durch geringfügige Zusätze von Silizium, Germanium oder geeigneten anderen Stoffen werden sie jedoch zu Leitern.',' ');
INSERT INTO answer VALUES(1632,408,3,'Einige Stoffe (z.B. Silizium, Germanium) sind in trockenem Zustand gute Elektrolyten. Durch geringfügige Zusätze von Wismut oder Tellur kann man daraus entweder N-leitendes- oder P-leitendes Material für Anoden bzw. Katoden von Halbleiterbauelementen herstellen.',' ');
INSERT INTO answer VALUES(1633,409,0,'bewegliche Elektronenlücken.',' ');
INSERT INTO answer VALUES(1634,409,1,'das Fehlen von Dotierungsatomen.',' ');
INSERT INTO answer VALUES(1635,409,2,'das Fehlen von Atomen im Gitter des Halbleiterkristalls.',' ');
INSERT INTO answer VALUES(1636,409,3,'Überschuss an freien Elektronen.',' ');
INSERT INTO answer VALUES(1637,410,0,'Zugabe von dreiwertigen Stoffen zum vierwertigen Halbleitergrundstoff',' ');
INSERT INTO answer VALUES(1638,410,1,'Zugabe von fünfwertigen Stoffen zum vierwertigen Halbleitergrundstoff',' ');
INSERT INTO answer VALUES(1639,410,2,'Zugabe von Germaniumatomen zum Siliziumgrundwerkstoff',' ');
INSERT INTO answer VALUES(1640,410,3,'Zugabe von Siliziumatomen zum Germaniumgrundwerkstoff',' ');
INSERT INTO answer VALUES(1641,411,0,'das Vorhandensein frei beweglicher Elektronen.',' ');
INSERT INTO answer VALUES(1642,411,1,'das Fehlen von Dotierungsatomen.',' ');
INSERT INTO answer VALUES(1643,411,2,'das Fehlen von Atomen im Gitter des Halbleiterkristalls.',' ');
INSERT INTO answer VALUES(1644,411,3,'das Vorhandensein beweglicher Elektronenlücken.',' ');
INSERT INTO answer VALUES(1645,412,0,'Zugabe von fünfwertigen Stoffen zum vierwertigen Halbleitergrundstoff',' ');
INSERT INTO answer VALUES(1646,412,1,'Zugabe von dreiwertigen Stoffen zum vierwertigen Halbleitergrundstoff',' ');
INSERT INTO answer VALUES(1647,412,2,'Zugabe von Germaniumatomen zum Siliziumgrundwerkstoff',' ');
INSERT INTO answer VALUES(1648,412,3,'Zugabe von Siliziumatomen zum Germaniumgrundwerkstoff',' ');
INSERT INTO answer VALUES(1649,413,0,'An der Grenzschicht wandern Elektronen aus dem N-Teil in den P-Teil. Dadurch wird auf der N-Seite der Elektronenüberschuss teilweise abgebaut, auf der P-Seite der Elektronenmangel teilweise neutralisiert. Es bildet sich auf beiden Seiten der Grenzfläche eine isolierende Schicht.',' ');
INSERT INTO answer VALUES(1650,413,1,'An der Grenzschicht wandern Elektronen aus dem P-Teil in den N-Teil. Dadurch wird auf der P-Seite der Elektronenüberschuss teilweise abgebaut, auf der N-Seite der Elektronenmangel teilweise neutralisiert. Es bildet sich auf beiden Seiten der Grenzfläche eine isolierende Schicht.',' ');
INSERT INTO answer VALUES(1651,413,2,'An der Grenzschicht wandern Atome aus der Grenzschicht in den N- und P-Teil. Dadurch wird auf beiden Seiten der Atommangel abgebaut. Es bildet sich auf der P-Seite eine leitende Schicht.',' ');
INSERT INTO answer VALUES(1652,413,3,'An der Grenzschicht wandern Atome aus dem N-Teil in den P-Teil. Dadurch wird auf der N-Seite der Atommangel abgebaut, auf der P-Seite der Atommangel vergrößert. Es bildet sich auf der N-Seite eine leitende Schicht.',' ');
INSERT INTO answer VALUES(1653,414,0,'wenn man an die Katode (N-Gebiet) eine positive und an die Anode (P-Gebiet) eine negative Spannung anlegt.',' ');
INSERT INTO answer VALUES(1654,414,1,'wenn man an die Katode (P-Gebiet) eine positive und an die Anode (N-Gebiet) eine negative Spannung anlegt.',' ');
INSERT INTO answer VALUES(1655,414,2,'wenn man an die Katode (P-Gebiet) eine negative und an die Anode (N-Gebiet) eine positive Spannung anlegt.',' ');
INSERT INTO answer VALUES(1656,414,3,'wenn man an die Katode (N-Gebiet) eine negative und an die Anode (P-Gebiet) eine positive Spannung anlegt.',' ');
INSERT INTO answer VALUES(1657,415,0,'Leerlaufspannung: 18 V, Kurzschlussstrom: 4 A',' ');
INSERT INTO answer VALUES(1658,415,1,'Leerlaufspannung: 18 V, Kurzschlussstrom: 30 A',' ');
INSERT INTO answer VALUES(1659,415,2,'Leerlaufspannung: 2,4 V, Kurzschlussstrom: 4 A',' ');
INSERT INTO answer VALUES(1660,415,3,'Leerlaufspannung: 2,4 V, Kurzschlussstrom: 30 A',' ');
INSERT INTO answer VALUES(1661,416,0,'1,22 &Omega;',' ');
INSERT INTO answer VALUES(1662,416,1,'0,82 &Omega;',' ');
INSERT INTO answer VALUES(1663,416,2,'12,15 &Omega;',' ');
INSERT INTO answer VALUES(1664,416,3,'1,1 &Omega;',' ');
INSERT INTO answer VALUES(1665,417,0,'0,25 &Omega;',' ');
INSERT INTO answer VALUES(1666,417,1,'6,75 &Omega;',' ');
INSERT INTO answer VALUES(1667,417,2,'13 &Omega;',' ');
INSERT INTO answer VALUES(1668,417,3,'0,5 &Omega;',' ');
INSERT INTO answer VALUES(1669,418,0,'92,6 %',' ');
INSERT INTO answer VALUES(1670,418,1,'100 %',' ');
INSERT INTO answer VALUES(1671,418,2,'7,5 %',' ');
INSERT INTO answer VALUES(1672,418,3,'13,5 %',' ');
INSERT INTO answer VALUES(1673,419,0,'96,3 %',' ');
INSERT INTO answer VALUES(1674,419,1,'100 %',' ');
INSERT INTO answer VALUES(1675,419,2,'3,7 %',' ');
INSERT INTO answer VALUES(1676,419,3,'27 %',' ');
INSERT INTO answer VALUES(1677,420,0,'0,05 &Omega;',' ');
INSERT INTO answer VALUES(1678,420,1,'8,2 &Omega;',' ');
INSERT INTO answer VALUES(1679,420,2,'0,2 &Omega;',' ');
INSERT INTO answer VALUES(1680,420,3,'0,25 &Omega;',' ');
INSERT INTO answer VALUES(1681,421,0,'R<sub>L</sub> = R<sub>i</sub>',' ');
INSERT INTO answer VALUES(1682,421,1,'R<sub>L</sub> &lt;&lt; R<sub>i</sub>',' ');
INSERT INTO answer VALUES(1683,421,2,'R<sub>L</sub> &gt;&gt; R<sub>i</sub>',' ');
INSERT INTO answer VALUES(1684,421,3,'R<sub>L</sub> = 1 / R<sub>i</sub>',' ');
INSERT INTO answer VALUES(1685,422,0,'R<sub>L</sub> &lt;&lt; R<sub>i</sub>',' ');
INSERT INTO answer VALUES(1686,422,1,'R<sub>L</sub> &gt;&gt; R<sub>i</sub>',' ');
INSERT INTO answer VALUES(1687,422,2,'R<sub>L</sub> = R<sub>i</sub>',' ');
INSERT INTO answer VALUES(1688,422,3,'R<sub>L</sub> = 1/R<sub>i</sub>',' ');
INSERT INTO answer VALUES(1689,423,0,'R<sub>L</sub> &gt;&gt; R<sub>i</sub>',' ');
INSERT INTO answer VALUES(1690,423,1,'R<sub>L</sub> &lt;&lt; R<sub>i</sub>',' ');
INSERT INTO answer VALUES(1691,423,2,'R<sub>L</sub> = R<sub>i</sub>',' ');
INSERT INTO answer VALUES(1692,423,3,'R<sub>L</sub> = 1/R<sub>i</sub>',' ');
INSERT INTO answer VALUES(1693,424,0,'Spannungsquellen sollten einen möglichst niedrigen Innenwiderstand und Stromquellen einen möglichst hohen Innenwiderstand haben.',' ');
INSERT INTO answer VALUES(1694,424,1,'Strom- und Spannungsquellen sollten einen möglichst niedrigen Innenwiderstand haben.',' ');
INSERT INTO answer VALUES(1695,424,2,'Strom- und Spannungsquellen sollten einen möglichst hohen Innenwiderstand haben.',' ');
INSERT INTO answer VALUES(1696,424,3,'Spannungsquellen sollten einen möglichst hohen Innenwiderstand und Stromquellen einen möglichst niedrigen Innenwiderstand haben.',' ');
INSERT INTO answer VALUES(1697,425,0,'2000 kV/m',' ');
INSERT INTO answer VALUES(1698,425,1,'200 V/m',' ');
INSERT INTO answer VALUES(1699,425,2,'2000 V/m',' ');
INSERT INTO answer VALUES(1700,425,3,'200 kV/m',' ');
INSERT INTO answer VALUES(1701,426,0,'Zirka 1500 V/m',' ');
INSERT INTO answer VALUES(1702,426,1,'Zirka 150 V/m',' ');
INSERT INTO answer VALUES(1703,426,2,'Zirka 15 V/m',' ');
INSERT INTO answer VALUES(1704,426,3,'Zirka 5,4 V/m',' ');
INSERT INTO answer VALUES(1705,427,0,'zur Spannung am Leiter.',' ');
INSERT INTO answer VALUES(1706,427,1,'zum Strom durch den Leiter.',' ');
INSERT INTO answer VALUES(1707,427,2,'zum Querschnitt des Leiters.',' ');
INSERT INTO answer VALUES(1708,427,3,'zur Länge des Leiters.',' ');
INSERT INTO answer VALUES(1709,428,0,'6 kV',' ');
INSERT INTO answer VALUES(1710,428,1,'60 kV',' ');
INSERT INTO answer VALUES(1711,428,2,'600 V',' ');
INSERT INTO answer VALUES(1712,428,3,'2,6 kV',' ');
INSERT INTO answer VALUES(1713,429,0,'Homogenes elektrisches Feld',' ');
INSERT INTO answer VALUES(1714,429,1,'Homogenes magnetisches Feld',' ');
INSERT INTO answer VALUES(1715,429,2,'Polarisiertes elektrisches Feld',' ');
INSERT INTO answer VALUES(1716,429,3,'Polarisiertes magnetisches Feld',' ');
INSERT INTO answer VALUES(1717,430,0,'Elektrische Feldlinien',' ');
INSERT INTO answer VALUES(1718,430,1,'Magnetische Feldlinien',' ');
INSERT INTO answer VALUES(1719,430,2,'Polarisierte Feldlinien',' ');
INSERT INTO answer VALUES(1720,430,3,'Horizontale Feldlinien',' ');
INSERT INTO answer VALUES(1721,431,0,'184 A/m',' ');
INSERT INTO answer VALUES(1722,431,1,'1,8 A/m',' ');
INSERT INTO answer VALUES(1723,431,2,'577 A/m',' ');
INSERT INTO answer VALUES(1724,431,3,'5,8 A/m',' ');
INSERT INTO answer VALUES(1725,432,0,'0,25 mT',' ');
INSERT INTO answer VALUES(1726,432,1,'2,5 mT',' ');
INSERT INTO answer VALUES(1727,432,2,'2,5 T',' ');
INSERT INTO answer VALUES(1728,432,3,'0,25 T',' ');
INSERT INTO answer VALUES(1729,433,0,'Das hochfrequente Magnetfeld kann nicht in den Kern eindringen, was den Querschnitt des Feldes verringert.',' ');
INSERT INTO answer VALUES(1730,433,1,'Kupfer und Aluminium sind diamagnetisch und schwächen das Feld ab.',' ');
INSERT INTO answer VALUES(1731,433,2,'Das leitfähige Metall schließt das Feld kurz.',' ');
INSERT INTO answer VALUES(1732,433,3,'Kupfer und Aluminium sind unmagnetisch und haben keinen Einfluss auf das Feld.',' ');
INSERT INTO answer VALUES(1733,434,0,'Drehspulmesswerken.',' ');
INSERT INTO answer VALUES(1734,434,1,'Dreheisenmesswerken.',' ');
INSERT INTO answer VALUES(1735,434,2,'Transformatorenkernen.',' ');
INSERT INTO answer VALUES(1736,434,3,'Spulenkernen.',' ');
INSERT INTO answer VALUES(1737,435,0,'Homogenes magnetisches Feld',' ');
INSERT INTO answer VALUES(1738,435,1,'Homogenes elektrisches Feld',' ');
INSERT INTO answer VALUES(1739,435,2,'Konzentrisches magnetisches Feld',' ');
INSERT INTO answer VALUES(1740,435,3,'Zentriertes magnetisches Feld',' ');
INSERT INTO answer VALUES(1741,436,0,'Magnetfeld aus konzentrischen Kreisen um den Leiter.',' ');
INSERT INTO answer VALUES(1742,436,1,'elektrisches Feld aus konzentrischen Kreisen um den Leiter.',' ');
INSERT INTO answer VALUES(1743,436,2,'homogenes Magnetfeld um den Leiter.',' ');
INSERT INTO answer VALUES(1744,436,3,'homogenes elektrisches Feld um den Leiter.',' ');
INSERT INTO answer VALUES(1745,437,0,'Magnetische Feldlinien',' ');
INSERT INTO answer VALUES(1746,437,1,'Elektrische Feldlinien',' ');
INSERT INTO answer VALUES(1747,437,2,'Radiale Feldlinien',' ');
INSERT INTO answer VALUES(1748,437,3,'Vertikale Feldlinien',' ');
INSERT INTO answer VALUES(1749,438,0,'Elektrische Feldstärke: Volt pro Meter Magnetische Feldstärke: Ampere pro Meter',' ');
INSERT INTO answer VALUES(1750,438,1,'Elektrische Feldstärke: Ampere pro Meter Magnetische Feldstärke: Volt pro Meter',' ');
INSERT INTO answer VALUES(1751,438,2,'Elektrische Feldstärke: Volt mal Meter Magnetische Feldstärke: Ampere mal Meter',' ');
INSERT INTO answer VALUES(1752,438,3,'Elektrische Feldstärke: Ampere mal Meter Magnetische Feldstärke: Volt mal Meter',' ');
INSERT INTO answer VALUES(1753,439,0,'Ein elektromagnetisches Feld entsteht, wenn durch einen elektrischen Leiter ein zeitlich schnell veränderlicher Strom fließt. Es besteht aus der elektrischen und aus der magnetischen Feldkomponente (E-Feld und H-Feld).',' ');
INSERT INTO answer VALUES(1754,439,1,'Ein elektromagnetisches Feld entsteht, wenn durch einen elektrischen Leiter ein konstanter Strom fließt. Es besteht aus dem magnetischen Feld (H-Feld), das wiederum ein elektrisches Feld (E-Feld) induziert.',' ');
INSERT INTO answer VALUES(1755,439,2,'Ein elektromagnetisches Feld entsteht, wenn sich elektrische Ladungen in einem Leiter befinden. Es besteht aus dem elektrischen Feld (E-Feld), das wiederum ein magnetisches Feld (H-Feld) induziert.',' ');
INSERT INTO answer VALUES(1756,439,3,'Ein elektromagnetisches Feld entsteht, wenn an einem elektrischen Leiter eine konstante Spannung angelegt wird. Es besteht aus dem elektrischen Feld (E-Feld), das wiederum ein magnetisches Feld (H-Feld) induziert.',' ');
INSERT INTO answer VALUES(1757,440,0,'Sie erfolgt durch eine sich ausbreitende Wechselwirkung zwischen E-Feld und H-Feld.',' ');
INSERT INTO answer VALUES(1758,440,1,'Die Ausbreitung erfolgt nur über das E-Feld. Das H-Feld ist nur im Nahfeld vorhanden.',' ');
INSERT INTO answer VALUES(1759,440,2,'Die Ausbreitung erfolgt nur über das H-Feld. Das E-Feld ist nur im Nahfeld vorhanden.',' ');
INSERT INTO answer VALUES(1760,440,3,'E-Feld und H-Feld breiten sich unabhängig voneinander aus und stehen senkrecht zueinander und zur Ausbreitungsrichtung.',' ');
INSERT INTO answer VALUES(1761,441,0,'die Richtung des elektrischen Feldes (Vektor des E-Feldes) angegeben.',' ');
INSERT INTO answer VALUES(1762,441,1,'die Richtung des magnetischen Feldes (Vektor des H-Feldes) angegeben.',' ');
INSERT INTO answer VALUES(1763,441,2,'die Richtung der Ausbreitung (S-Vektor Poyntingscher Vektor) angegeben.',' ');
INSERT INTO answer VALUES(1764,441,3,'die Leistungsflussdichte im Speisepunkt der Antenne bestimmt.',' ');
INSERT INTO answer VALUES(1765,442,0,'Horizontale Polarisation',' ');
INSERT INTO answer VALUES(1766,442,1,'Vertikale Polarisation',' ');
INSERT INTO answer VALUES(1767,442,2,'Rechtsdrehende Polarisation',' ');
INSERT INTO answer VALUES(1768,442,3,'Zirkulare Polarisation',' ');
INSERT INTO answer VALUES(1769,443,0,'die Richtung des elektrischen Feldes (E-Vektor).',' ');
INSERT INTO answer VALUES(1770,443,1,'die Richtung des magnetischen Feldes (H-Vektor).',' ');
INSERT INTO answer VALUES(1771,443,2,'die Richtung der Ausbreitung (S-Vektor Poyntingscher Vektor).',' ');
INSERT INTO answer VALUES(1772,443,3,'die räumliche Anordnung der Empfangsantenne.',' ');
INSERT INTO answer VALUES(1773,444,0,'90°.',' ');
INSERT INTO answer VALUES(1774,444,1,'45°.',' ');
INSERT INTO answer VALUES(1775,444,2,'180°.',' ');
INSERT INTO answer VALUES(1776,444,3,'360°.',' ');
INSERT INTO answer VALUES(1777,445,0,'vertikal.',' ');
INSERT INTO answer VALUES(1778,445,1,'horizontal.',' ');
INSERT INTO answer VALUES(1779,445,2,'elliptisch.',' ');
INSERT INTO answer VALUES(1780,445,3,'linksdrehend.',' ');
INSERT INTO answer VALUES(1781,446,0,'Die E-Feldkomponente, die H-Feldkomponente und die Ausbreitungsrichtung befinden sich alle in einem rechten Winkel zueinander.',' ');
INSERT INTO answer VALUES(1782,446,1,'Die E-Feldkomponente und die H-Feldkomponente befinden sich in einem Winkel von 180° zueinander. Die Ausbreitungsrichtung verläuft dazu in einem Winkel von 90°.',' ');
INSERT INTO answer VALUES(1783,446,2,'Die E-Feldkomponente und die H-Feldkomponente sind phasengleich und befinden sich in einem Winkel von 0° zueinander. Die Ausbreitungsrichtung verläuft dazu in einem Winkel von 90°.',' ');
INSERT INTO answer VALUES(1784,446,3,'Die Ausbreitungsrichtung befindet sich in einem Winkel von 180° zur E-Feldkomponente und verläuft parallel zur H-Feldkomponente.',' ');
INSERT INTO answer VALUES(1785,447,0,'Durch den Feldwellenwiderstand des Freiraums',' ');
INSERT INTO answer VALUES(1786,447,1,'Durch die Maxwell-Gleichungen',' ');
INSERT INTO answer VALUES(1787,447,2,'Durch die Ausbreitung in der Ionosphäre',' ');
INSERT INTO answer VALUES(1788,447,3,'Durch die Polarisationsrichtung der Antenne',' ');
INSERT INTO answer VALUES(1789,448,0,'2,2 V/m',' ');
INSERT INTO answer VALUES(1790,448,1,'8,9 V/m',' ');
INSERT INTO answer VALUES(1791,448,2,'0,4 V/m',' ');
INSERT INTO answer VALUES(1792,448,3,'5,5 V/m',' ');
INSERT INTO answer VALUES(1793,449,0,'11,8 V/m',' ');
INSERT INTO answer VALUES(1794,449,1,'9,2 V/m',' ');
INSERT INTO answer VALUES(1795,449,2,'15,1 V/m',' ');
INSERT INTO answer VALUES(1796,449,3,'353 V/m',' ');
INSERT INTO answer VALUES(1797,450,0,'28,3 V/m',' ');
INSERT INTO answer VALUES(1798,450,1,'200 V/m',' ');
INSERT INTO answer VALUES(1799,450,2,'14,1 V/m',' ');
INSERT INTO answer VALUES(1800,450,3,'176,8 V/m',' ');
INSERT INTO answer VALUES(1801,451,0,'U<sub>2</sub> oder U<sub>5</sub>',' ');
INSERT INTO answer VALUES(1802,451,1,'U<sub>1</sub> oder U<sub>6</sub>',' ');
INSERT INTO answer VALUES(1803,451,2,'U<sub>3</sub> oder U<sub>4</sub>',' ');
INSERT INTO answer VALUES(1804,451,3,'nur U<sub>2</sub>',' ');
INSERT INTO answer VALUES(1805,452,0,'40 Volt',' ');
INSERT INTO answer VALUES(1806,452,1,'20 Volt',' ');
INSERT INTO answer VALUES(1807,452,2,'10 Volt',' ');
INSERT INTO answer VALUES(1808,452,3,'4 Volt',' ');
INSERT INTO answer VALUES(1809,453,0,'12 Volt',' ');
INSERT INTO answer VALUES(1810,453,1,'6 Volt',' ');
INSERT INTO answer VALUES(1811,453,2,'8,5 Volt',' ');
INSERT INTO answer VALUES(1812,453,3,'2 Volt',' ');
INSERT INTO answer VALUES(1813,454,0,'83,3 kHz',' ');
INSERT INTO answer VALUES(1814,454,1,'833,3 kHz',' ');
INSERT INTO answer VALUES(1815,454,2,'8,3 MHz',' ');
INSERT INTO answer VALUES(1816,454,3,'83,3 MHz',' ');
INSERT INTO answer VALUES(1817,455,0,'8,33 MHz',' ');
INSERT INTO answer VALUES(1818,455,1,'16,7 MHz',' ');
INSERT INTO answer VALUES(1819,455,2,'8,33 kHz',' ');
INSERT INTO answer VALUES(1820,455,3,'833 kHz',' ');
INSERT INTO answer VALUES(1821,456,0,'50 Hz',' ');
INSERT INTO answer VALUES(1822,456,1,'100 Hz',' ');
INSERT INTO answer VALUES(1823,456,2,'500 Hz',' ');
INSERT INTO answer VALUES(1824,456,3,'1000 Hz',' ');
INSERT INTO answer VALUES(1825,457,0,'33,9 V',' ');
INSERT INTO answer VALUES(1826,457,1,'24 V',' ');
INSERT INTO answer VALUES(1827,457,2,'16,97 V',' ');
INSERT INTO answer VALUES(1828,457,3,'36,4 V',' ');
INSERT INTO answer VALUES(1829,458,0,'325 Volt.',' ');
INSERT INTO answer VALUES(1830,458,1,'163 Volt.',' ');
INSERT INTO answer VALUES(1831,458,2,'460 Volt.',' ');
INSERT INTO answer VALUES(1832,458,3,'650 Volt.',' ');
INSERT INTO answer VALUES(1833,459,0,'650 Volt.',' ');
INSERT INTO answer VALUES(1834,459,1,'163 Volt.',' ');
INSERT INTO answer VALUES(1835,459,2,'325 Volt.',' ');
INSERT INTO answer VALUES(1836,459,3,'460 Volt.',' ');
INSERT INTO answer VALUES(1837,460,0,'2,5 Watt',' ');
INSERT INTO answer VALUES(1838,460,1,'5 Watt',' ');
INSERT INTO answer VALUES(1839,460,2,'10 Watt',' ');
INSERT INTO answer VALUES(1840,460,3,'0,5 Watt',' ');
INSERT INTO answer VALUES(1841,461,0,'3&pi;/2; 270°',' ');
INSERT INTO answer VALUES(1842,461,1,'&pi;/3; 270°',' ');
INSERT INTO answer VALUES(1843,461,2,'3&pi;; 180°',' ');
INSERT INTO answer VALUES(1844,461,3,'3&pi;/4; 135°',' ');
INSERT INTO answer VALUES(1845,462,0,'45°.',' ');
INSERT INTO answer VALUES(1846,462,1,'0°.',' ');
INSERT INTO answer VALUES(1847,462,2,'90°.',' ');
INSERT INTO answer VALUES(1848,462,3,'180°.',' ');
INSERT INTO answer VALUES(1849,463,0,'1500 Hz, 4500 Hz, 7500 Hz und höher',' ');
INSERT INTO answer VALUES(1850,463,1,'1500 Hz, 3000 Hz, 4500 Hz und höher',' ');
INSERT INTO answer VALUES(1851,463,2,'1500 Hz, 2250 Hz, 3000 Hz und höher',' ');
INSERT INTO answer VALUES(1852,463,3,'1500 Hz, 3000 Hz, 6000 Hz und höher',' ');
INSERT INTO answer VALUES(1853,464,0,'0,2 ms.',' ');
INSERT INTO answer VALUES(1854,464,1,'260 µs.',' ');
INSERT INTO answer VALUES(1855,464,2,'230 µs.',' ');
INSERT INTO answer VALUES(1856,464,3,'150 µs.',' ');
INSERT INTO answer VALUES(1857,465,0,'Harmonische sind die ganzzahligen (1, 2, 3 ...) Vielfachen einer Frequenz.',' ');
INSERT INTO answer VALUES(1858,465,1,'Harmonische sind die ganzzahligen (1, 2, 3 ...) Teile einer Frequenz.',' ');
INSERT INTO answer VALUES(1859,465,2,'Harmonische sind die erzeugten Frequenzen oberhalb der ursprünglichen Frequenz.',' ');
INSERT INTO answer VALUES(1860,465,3,'Harmonische sind identisch mit den Oberwellen, wobei die Grundwelle keine Harmonische ist.',' ');
INSERT INTO answer VALUES(1861,466,0,'die vierte Harmonische der Frequenz.',' ');
INSERT INTO answer VALUES(1862,466,1,'die dritte Harmonische der Frequenz.',' ');
INSERT INTO answer VALUES(1863,466,2,'die zweite Harmonische der Frequenz.',' ');
INSERT INTO answer VALUES(1864,466,3,'die zweite ungeradzahlige Harmonische der Frequenz.',' ');
INSERT INTO answer VALUES(1865,467,0,'2 kHz und 4 kHz',' ');
INSERT INTO answer VALUES(1866,467,1,'4 kHz und 6 kHz',' ');
INSERT INTO answer VALUES(1867,467,2,'4 kHz allein',' ');
INSERT INTO answer VALUES(1868,467,3,'2 kHz und 6 kHz',' ');
INSERT INTO answer VALUES(1869,468,0,'2 kHz und 6 kHz',' ');
INSERT INTO answer VALUES(1870,468,1,'4 kHz und 6 kHz',' ');
INSERT INTO answer VALUES(1871,468,2,'2 kHz und 4 kHz',' ');
INSERT INTO answer VALUES(1872,468,3,'4 kHz allein',' ');
INSERT INTO answer VALUES(1873,469,0,'proportional zur Bandbreite.',' ');
INSERT INTO answer VALUES(1874,469,1,'umgekehrt proportional zur Empfängerempfindlichkeit.',' ');
INSERT INTO answer VALUES(1875,469,2,'proportional zum Signal-Rauschabstand.',' ');
INSERT INTO answer VALUES(1876,469,3,'umgekehrt proportional zum Eingangswiderstand.',' ');
INSERT INTO answer VALUES(1877,470,0,'verringert sich um etwa 7 dB.',' ');
INSERT INTO answer VALUES(1878,470,1,'erhöht sich um etwa 7 dB.',' ');
INSERT INTO answer VALUES(1879,470,2,'verringert sich um etwa 20 dB.',' ');
INSERT INTO answer VALUES(1880,470,3,'erhöht sich um etwa 20 dB.',' ');
INSERT INTO answer VALUES(1881,471,0,'Sie entspricht der Differenz zwischen der höchsten und der niedrigsten Frequenz des NF-Signals.',' ');
INSERT INTO answer VALUES(1882,471,1,'Sie entspricht der Hälfte der Bandbreite des NF-Signals.',' ');
INSERT INTO answer VALUES(1883,471,2,'Sie entspricht der doppelten Bandbreite des NF-Signals.',' ');
INSERT INTO answer VALUES(1884,471,3,'Sie ist Null, weil bei SSB-Modulation der HF-Träger unterdrückt wird.',' ');
INSERT INTO answer VALUES(1885,472,0,'7,048 MHz',' ');
INSERT INTO answer VALUES(1886,472,1,'7,050 MHz',' ');
INSERT INTO answer VALUES(1887,472,2,'7,052 MHz',' ');
INSERT INTO answer VALUES(1888,472,3,'7,048 MHz und 7,052 MHz',' ');
INSERT INTO answer VALUES(1889,473,0,'Die Bandbreite beträgt ungefähr 7,6 kHz',' ');
INSERT INTO answer VALUES(1890,473,1,'Die Bandbreite beträgt ungefähr 3,8 kHz',' ');
INSERT INTO answer VALUES(1891,473,2,'Die Bandbreite beträgt ungefähr 5,8 kHz',' ');
INSERT INTO answer VALUES(1892,473,3,'Die Bandbreite beträgt ungefähr 12 kHz',' ');
INSERT INTO answer VALUES(1893,474,0,'Um das Signal/Rausch-Verhältnis durch Anheben der Amplituden der höheren Modulationsfrequenzen zu verbessern.',' ');
INSERT INTO answer VALUES(1894,474,1,'Um das breitbandige FM-Signal durch Anheben der Amplituden der höheren Modulationsfrequenzen auf Schmalband FM zu reduzieren.',' ');
INSERT INTO answer VALUES(1895,474,2,'Um die Ausgangsleistung durch Verdichtung des Spektrums der Modulationsfrequenzen zu erhöhen.',' ');
INSERT INTO answer VALUES(1896,474,3,'Um das FM Kanalraster von 25 kHz auf 12,5 kHz durch Reduzierung der Bandbreite zu ermöglichen.',' ');
INSERT INTO answer VALUES(1897,475,0,'Nein, im Normalfall ist keine Unterscheidung möglich.',' ');
INSERT INTO answer VALUES(1898,475,1,'Ja, weil bei Phasenmodulation die Frequenz immer konstant ist.',' ');
INSERT INTO answer VALUES(1899,475,2,'Ja, weil bei Frequenzmodulation ein kräftigeres Signal erzeugt wird.',' ');
INSERT INTO answer VALUES(1900,475,3,'Ja, weil phasenmodulierte Aussendungen in FM-Empfängern bzw. frequenzmodulierte Aussendungen in Phasendiskriminatoren erhebliche Verzerrungen verursachen.',' ');
INSERT INTO answer VALUES(1901,476,0,'Intermodulationsprodukte erzeugen.',' ');
INSERT INTO answer VALUES(1902,476,1,'Frequenzmodulation hervorrufen.',' ');
INSERT INTO answer VALUES(1903,476,2,'zwei gleiche Seitenbänder produzieren.',' ');
INSERT INTO answer VALUES(1904,476,3,'einen so genannten Dopplereffekt hervorrufen.',' ');
INSERT INTO answer VALUES(1905,477,0,'die unmittelbar nach dem Senderausgang messbare Leistung, bevor sie Zusatzgeräte (z.B. Anpassgeräte) durchläuft.',' ');
INSERT INTO answer VALUES(1906,477,1,'die unmittelbar nach dem Senderausgang gemessene Differenz aus vorlaufender und rücklaufender Leistung.',' ');
INSERT INTO answer VALUES(1907,477,2,'die unmittelbar nach den erforderlichen Zusatzgeräten (z.B. Anpassgeräte) messbare Leistung.',' ');
INSERT INTO answer VALUES(1908,477,3,'die unmittelbar nach dem Senderausgang gemessene Summe aus vorlaufender und rücklaufender Leistung.',' ');
INSERT INTO answer VALUES(1909,478,0,'die durchschnittliche Leistung, die ein Sender unter normalen Betriebsbedingungen während einer Periode der Hochfrequenzschwingung bei der höchsten Spitze der Modulationshüllkurve der Antennenspeiseleitung zuführt.',' ');
INSERT INTO answer VALUES(1910,478,1,'die unmittelbar nach dem Senderausgang messbare Leistung über die Spitzen der Periode einer durchschnittlichen Hochfrequenzschwingung, bevor Zusatzgeräte (z.B. Anpassgeräte) durchlaufen werden.',' ');
INSERT INTO answer VALUES(1911,478,2,'die durchschnittliche Leistung, die ein Sender unter normalen Betriebsbedingungen an die Antennenspeiseleitung während eines Zeitintervalls abgibt, das im Verhältnis zur Periode der tiefsten Modulationsfrequenz ausreichend lang ist.',' ');
INSERT INTO answer VALUES(1912,478,3,'das Produkt aus der Leistung, die unmittelbar der Antenne zugeführt wird und ihrem Gewinnfaktor in einer Richtung, bezogen auf den Halbwellendipol.',' ');
INSERT INTO answer VALUES(1913,479,0,'die durchschnittliche Leistung, die ein Sender unter normalen Betriebsbedingungen an die Antennenspeiseleitung während eines Zeitintervalls abgibt, das im Verhältnis zur Periode der tiefsten Modulationsfrequenz ausreichend lang ist.',' ');
INSERT INTO answer VALUES(1914,479,1,'die unmittelbar nach dem Senderausgang messbare Leistung über die Spitzen der Periode einer durchschnittlichen Hochfrequenzschwingung, bevor Zusatzgeräte (z.B. Anpassgeräte) durchlaufen werden.',' ');
INSERT INTO answer VALUES(1915,479,2,'die durchschnittliche Leistung, die ein Sender unter normalen Betriebsbedingungen während einer Periode der Hochfrequenzschwingung bei der höchsten Spitze der Modulationshüllkurve der Antennenspeiseleitung zuführt.',' ');
INSERT INTO answer VALUES(1916,479,3,'das Produkt aus der Leistung, die unmittelbar der Antenne zugeführt wird und ihrem Gewinnfaktor in einer Richtung, bezogen auf den Halbwellendipol.',' ');
INSERT INTO answer VALUES(1917,480,0,'das Produkt aus der Leistung, die unmittelbar der Antenne zugeführt wird und ihrem Gewinnfaktor in einer Richtung, bezogen auf den Halbwellendipol.',' ');
INSERT INTO answer VALUES(1918,480,1,'das Produkt aus der Leistung, die unmittelbar der Antenne zugeführt wird und ihrem Gewinnfaktor in einer Richtung, bezogen auf den isotropen Kugelstrahler.',' ');
INSERT INTO answer VALUES(1919,480,2,'die durchschnittliche Leistung, die ein Sender unter normalen Betriebsbedingungen während einer Periode der Hochfrequenzschwingung bei der höchsten Spitze der Modulationshüllkurve der Antennenspeiseleitung zuführt.',' ');
INSERT INTO answer VALUES(1920,480,3,'die durchschnittliche Leistung, die ein Sender unter normalen Betriebsbedingungen an die Antennenspeiseleitung während eines Zeitintervalls abgibt, das im Verhältnis zur Periode der tiefsten Modulationsfrequenz ausreichend lang ist.',' ');
INSERT INTO answer VALUES(1921,481,0,'das Produkt aus der Leistung, die unmittelbar der Antenne zugeführt wird und ihrem Gewinnfaktor in einer Richtung, bezogen auf den isotropen Kugelstrahler.',' ');
INSERT INTO answer VALUES(1922,481,1,'das Produkt aus der Leistung, die unmittelbar der Antenne zugeführt wird und ihrem Gewinnfaktor in einer Richtung, bezogen auf den Halbwellendipol.',' ');
INSERT INTO answer VALUES(1923,481,2,'die durchschnittliche Leistung, die ein Sender unter normalen Betriebsbedingungen während einer Periode der Hochfrequenzschwingung bei der höchsten Spitze der Modulationshüllkurve der Antennenspeiseleitung zuführt.',' ');
INSERT INTO answer VALUES(1924,481,3,'die durchschnittliche Leistung, die ein Sender unter normalen Betriebsbedingungen an die Antennenspeiseleitung während eines Zeitintervalls abgibt, das im Verhältnis zur Periode der tiefsten Modulationsfrequenz ausreichend lang ist.',' ');
INSERT INTO answer VALUES(1925,482,0,'bei der die unterhalb ihrer unteren und oberhalb ihrer oberen Frequenzgrenzen ausgesendeten mittleren Leistungen jeweils 0,5 % der gesamten mittleren Leistung einer gegebenen Aussendung betragen.',' ');
INSERT INTO answer VALUES(1926,482,1,'bei der die oberhalb ihrer unteren und unterhalb ihrer oberen Frequenzgrenzen ausgesendeten mittleren Leistungen jeweils 50 % der gesamten mittleren Leistung einer gegebenen Aussendung betragen.',' ');
INSERT INTO answer VALUES(1927,482,2,'bei der die oberhalb ihrer unteren und unterhalb ihrer oberen Frequenzgrenzen ausgesendeten mittleren Leistungen jeweils 10 % der gesamten mittleren Leistung einer gegebenen Aussendung betragen.',' ');
INSERT INTO answer VALUES(1928,482,3,'bei der die unterhalb ihrer unteren und oberhalb ihrer oberen Frequenzgrenzen ausgesendeten mittleren Leistungen jeweils 5 % der gesamten mittleren Leistung einer gegebenen Aussendung betragen.',' ');
INSERT INTO answer VALUES(1929,483,0,'Es ist die Leistung, die man einem isotropen Strahler zuführen müsste, damit dieser die gleiche Feldstärke erzeugt wie eine im Vergleich herangezogene reale Antenne, in die eine Antenneneingangsleistung P eingespeist wird.',' ');
INSERT INTO answer VALUES(1930,483,1,'Es ist die Eingangsleistung des verwendeten Senders wie sie in der EMVU-Selbsterklärung anzugeben ist.',' ');
INSERT INTO answer VALUES(1931,483,2,'Es handelt sich um die Leistung, die man im Maximum der Strahlungskeule einer Dipolantenne vorfindet.',' ');
INSERT INTO answer VALUES(1932,483,3,'Es ist die durchschnittliche Leistung der Amateurfunkstelle wie sie in der EMVU-Selbsterklärung anzugeben ist.',' ');
INSERT INTO answer VALUES(1933,484,0,'HF-Leistung bei der höchsten Spitze der Hüllkurve.',' ');
INSERT INTO answer VALUES(1934,484,1,'Durchschnittsleistung einer SSB-Übertragung.',' ');
INSERT INTO answer VALUES(1935,484,2,'Spitzen-Spitzen-Leistung bei den höchsten Spitzen der Modulationshüllkurve.',' ');
INSERT INTO answer VALUES(1936,484,3,'Mindestleistung bei der Modulationsspitze.',' ');
INSERT INTO answer VALUES(1937,485,0,'ERP = (P<sub>Sender</sub> - P<sub>Verluste</sub>) • G<sub>Antenne</sub> bezogen auf den Halbwellendipol',' ');
INSERT INTO answer VALUES(1938,485,1,'ERP = (P<sub>Sender</sub> • G<sub>Antenne</sub>) - P<sub>Verluste</sub> bezogen auf den isotropen Kugelstrahler',' ');
INSERT INTO answer VALUES(1939,485,2,'ERP = (P<sub>Sender</sub> + P<sub>Verluste</sub>) • G<sub>Antenne</sub> bezogen auf den Halbwellendipol',' ');
INSERT INTO answer VALUES(1940,485,3,'ERP = P<sub>Sender</sub> + P<sub>Verluste</sub> + G<sub>Antenne</sub> bezogen auf den isotropen Kugelstrahler',' ');
INSERT INTO answer VALUES(1941,486,0,'P<sub>EIRP</sub> = (P<sub>Sender</sub> - P<sub>Verluste</sub>) • G<sub>Antenne</sub> bezogen auf den isotropen Kugelstrahler',' ');
INSERT INTO answer VALUES(1942,486,1,'P<sub>EIRP</sub> = (P<sub>Sender</sub> • G<sub>Antenne</sub>) - P<sub>Verluste</sub> bezogen auf den Halbwellendipol',' ');
INSERT INTO answer VALUES(1943,486,2,'P<sub>EIRP</sub> = (P<sub>Sender</sub> + P<sub>Verluste</sub>) • G<sub>Antenne</sub> bezogen auf den isotropen Kugelstrahler',' ');
INSERT INTO answer VALUES(1944,486,3,'P<sub>EIRP</sub> = P<sub>Sender</sub> + P<sub>Verluste</sub> + G<sub>Antenne</sub> bezogen auf den Halbwellendipol',' ');
INSERT INTO answer VALUES(1945,487,0,'auf das für eine zufrieden stellende Kommunikation erforderliche Minimum eingestellt werden.',' ');
INSERT INTO answer VALUES(1946,487,1,'nur auf den zulässigen Pegel eingestellt werden.',' ');
INSERT INTO answer VALUES(1947,487,2,'auf die für eine zufrieden stellende Kommunikation erforderlichen 750 W eingestellt werden.',' ');
INSERT INTO answer VALUES(1948,487,3,'die Hälfte des maximal zulässigen Pegels betragen.',' ');
INSERT INTO answer VALUES(1949,488,0,'Ja, es sind aber die Effektivwerte einzusetzen.',' ');
INSERT INTO answer VALUES(1950,488,1,'Nein, denn Spannung und Strom ändern sich laufend.',' ');
INSERT INTO answer VALUES(1951,488,2,'Ja, es darf aber immer nur mit den Spitzenwerten gerechnet werden.',' ');
INSERT INTO answer VALUES(1952,488,3,'Nein, denn Spannung und Strom sind um den Phasenwinkel Phi verschoben.',' ');
INSERT INTO answer VALUES(1953,489,0,'Fast null Watt',' ');
INSERT INTO answer VALUES(1954,489,1,'0,9 Watt',' ');
INSERT INTO answer VALUES(1955,489,2,'0,75 Watt',' ');
INSERT INTO answer VALUES(1956,489,3,'9 Watt',' ');
INSERT INTO answer VALUES(1957,490,0,'1 W',' ');
INSERT INTO answer VALUES(1958,490,1,'0,125 W',' ');
INSERT INTO answer VALUES(1959,490,2,'10 W',' ');
INSERT INTO answer VALUES(1960,490,3,'100 mW',' ');
INSERT INTO answer VALUES(1961,491,0,'4 A',' ');
INSERT INTO answer VALUES(1962,491,1,'250 mA',' ');
INSERT INTO answer VALUES(1963,491,2,'750 mA',' ');
INSERT INTO answer VALUES(1964,491,3,'36 A',' ');
INSERT INTO answer VALUES(1965,492,0,'200 W.',' ');
INSERT INTO answer VALUES(1966,492,1,'141 W.',' ');
INSERT INTO answer VALUES(1967,492,2,'100 W.',' ');
INSERT INTO answer VALUES(1968,492,3,'283 W.',' ');
INSERT INTO answer VALUES(1969,493,0,'55 W',' ');
INSERT INTO answer VALUES(1970,493,1,'27,5 W',' ');
INSERT INTO answer VALUES(1971,493,2,'750 W',' ');
INSERT INTO answer VALUES(1972,493,3,'5 W',' ');
INSERT INTO answer VALUES(1973,494,0,'200 W.',' ');
INSERT INTO answer VALUES(1974,494,1,'100 W.',' ');
INSERT INTO answer VALUES(1975,494,2,'25 W.',' ');
INSERT INTO answer VALUES(1976,494,3,'250 W.',' ');
INSERT INTO answer VALUES(1977,495,0,'45 %.',' ');
INSERT INTO answer VALUES(1978,495,1,'55 %.',' ');
INSERT INTO answer VALUES(1979,495,2,'100 %.',' ');
INSERT INTO answer VALUES(1980,495,3,'222 %.',' ');
INSERT INTO answer VALUES(1981,496,0,'3 dB',' ');
INSERT INTO answer VALUES(1982,496,1,'-6 dB',' ');
INSERT INTO answer VALUES(1983,496,2,'-3 dB',' ');
INSERT INTO answer VALUES(1984,496,3,'6 dBm',' ');
INSERT INTO answer VALUES(1985,497,0,'9,75 % zu niedrig bestimmen.',' ');
INSERT INTO answer VALUES(1986,497,1,'5 % zu niedrig bestimmen.',' ');
INSERT INTO answer VALUES(1987,497,2,'10,25 % zu hoch bestimmen.',' ');
INSERT INTO answer VALUES(1988,497,3,'5 % zu hoch bestimmen.',' ');
INSERT INTO answer VALUES(1989,498,0,'<p><img src=''tb922a.png''></p>',' ');
INSERT INTO answer VALUES(1990,498,1,'<p><img src=''tb922b.png''></p>',' ');
INSERT INTO answer VALUES(1991,498,2,'<p><img src=''tb922c.png''></p>',' ');
INSERT INTO answer VALUES(1992,498,3,'<p><img src=''tb922d.png''></p>',' ');
INSERT INTO answer VALUES(1993,499,0,'<p><img src=''tb923a.png''></p>',' ');
INSERT INTO answer VALUES(1994,499,1,'<p><img src=''tb923b.png''></p>',' ');
INSERT INTO answer VALUES(1995,499,2,'<p><img src=''tb923c.png''></p>',' ');
INSERT INTO answer VALUES(1996,499,3,'<p><img src=''tb923d.png''></p>',' ');
INSERT INTO answer VALUES(1997,500,0,'<p><img src=''tb924a.png''></p>',' ');
INSERT INTO answer VALUES(1998,500,1,'<p><img src=''tb924b.png''></p>',' ');
INSERT INTO answer VALUES(1999,500,2,'<p><img src=''tb924c.png''></p>',' ');
INSERT INTO answer VALUES(2000,500,3,'<p><img src=''tb924d.png''></p>',' ');
INSERT INTO answer VALUES(2001,501,0,'<p><img src=''tc101a.jpg''></p>',' ');
INSERT INTO answer VALUES(2002,501,1,'<p><img src=''tc101b.jpg''></p>',' ');
INSERT INTO answer VALUES(2003,501,2,'<p><img src=''tc101c.jpg''></p>',' ');
INSERT INTO answer VALUES(2004,501,3,'<p><img src=''tc101d.jpg''></p>',' ');
INSERT INTO answer VALUES(2005,502,0,'haben geringe Fertigungstoleranzen und Temperaturabhängigkeit und sind besonders als Präzisionswiderstände geeignet.',' ');
INSERT INTO answer VALUES(2006,502,1,'sind induktionsarm und eignen sich besonders für den Einsatz bei sehr hohen Frequenzen.',' ');
INSERT INTO answer VALUES(2007,502,2,'sind besonders als Hochlastwiderstände bei niedrigen Frequenzen geeignet.',' ');
INSERT INTO answer VALUES(2008,502,3,'haben einen extrem stark negativen Temperaturkoeffizienten und sind besonders als NTC-Widerstände (Heißleiter) geeignet.',' ');
INSERT INTO answer VALUES(2009,503,0,'sind induktionsarm und eignen sich besonders für den Einsatz bei sehr hohen Frequenzen.',' ');
INSERT INTO answer VALUES(2010,503,1,'haben geringe Toleranzen und Widerstandsänderungen und sind besonders als Präzisionswiderstände in der Messtechnik geeignet.',' ');
INSERT INTO answer VALUES(2011,503,2,'sind besonders als Hochlastwiderstände bei niedrigen Frequenzen geeignet.',' ');
INSERT INTO answer VALUES(2012,503,3,'haben einen extrem stark negativen Temperaturkoeffizienten und sind besonders als NTC-Widerstände (Heißleiter) geeignet.',' ');
INSERT INTO answer VALUES(2013,504,0,'sind besonders als Hochlastwiderstände bei niedrigen Frequenzen geeignet.',' ');
INSERT INTO answer VALUES(2014,504,1,'Drahtwiderstände werden hauptsächlich in Form von SMD-Widerständen hergestellt.',' ');
INSERT INTO answer VALUES(2015,504,2,'sind induktionsarm und eignen sich besonders für den Einsatz bei sehr hohen Frequenzen.',' ');
INSERT INTO answer VALUES(2016,504,3,'haben einen extrem stark negativen Temperaturkoeffizienten und sind besonders als NTC-Widerstände (Heißleiter) geeignet.',' ');
INSERT INTO answer VALUES(2017,505,0,'0,1 kV',' ');
INSERT INTO answer VALUES(2018,505,1,'10 V',' ');
INSERT INTO answer VALUES(2019,505,2,'700 V',' ');
INSERT INTO answer VALUES(2020,505,3,'1 V',' ');
INSERT INTO answer VALUES(2021,506,0,'316 V',' ');
INSERT INTO answer VALUES(2022,506,1,'100 V',' ');
INSERT INTO answer VALUES(2023,506,2,'25 V',' ');
INSERT INTO answer VALUES(2024,506,3,'700 V',' ');
INSERT INTO answer VALUES(2025,507,0,'10 W',' ');
INSERT INTO answer VALUES(2026,507,1,'100 W',' ');
INSERT INTO answer VALUES(2027,507,2,'4,8 W',' ');
INSERT INTO answer VALUES(2028,507,3,'0,5 W',' ');
INSERT INTO answer VALUES(2029,508,0,'438 mA',' ');
INSERT INTO answer VALUES(2030,508,1,'192 mA',' ');
INSERT INTO answer VALUES(2031,508,2,'43,7 mA',' ');
INSERT INTO answer VALUES(2032,508,3,'2,28 A',' ');
INSERT INTO answer VALUES(2033,509,0,'5040 und 6160 &Omega;.',' ');
INSERT INTO answer VALUES(2034,509,1,'4760 und 6440 &Omega;.',' ');
INSERT INTO answer VALUES(2035,509,2,'4,7 und 6,8 k&Omega;.',' ');
INSERT INTO answer VALUES(2036,509,3,'5,2 und 6,3 k&Omega;.',' ');
INSERT INTO answer VALUES(2037,510,0,'250 mA',' ');
INSERT INTO answer VALUES(2038,510,1,'400 mA',' ');
INSERT INTO answer VALUES(2039,510,2,'4 A',' ');
INSERT INTO answer VALUES(2040,510,3,'2,5 A',' ');
INSERT INTO answer VALUES(2041,511,0,'8,8 mA.',' ');
INSERT INTO answer VALUES(2042,511,1,'12,5 mA.',' ');
INSERT INTO answer VALUES(2043,511,2,'25 mA.',' ');
INSERT INTO answer VALUES(2044,511,3,'40 A.',' ');
INSERT INTO answer VALUES(2045,512,0,'für Tonfrequenzen bis etwa 15 kHz.',' ');
INSERT INTO answer VALUES(2046,512,1,'für Funkfrequenzen bis etwa 144 MHz.',' ');
INSERT INTO answer VALUES(2047,512,2,'für UHF-Senderausgänge mit 50 &Omega;.',' ');
INSERT INTO answer VALUES(2048,512,3,'als Langdrahtersatz.',' ');
INSERT INTO answer VALUES(2049,513,0,'ungewendelten Kohleschichtwiderständen zusammengebaut sein.',' ');
INSERT INTO answer VALUES(2050,513,1,'hochbelastbaren Drahtwiderständen zusammengebaut sein.',' ');
INSERT INTO answer VALUES(2051,513,2,'Glühbirnen zusammengebaut sein.',' ');
INSERT INTO answer VALUES(2052,513,3,'temperaturfesten Blindwiderständen bestehen.',' ');
INSERT INTO answer VALUES(2053,514,0,'10 Kohleschichtwiderstände von 500 &Omega;',' ');
INSERT INTO answer VALUES(2054,514,1,'ein 50-&Omega;-Drahtwiderstand',' ');
INSERT INTO answer VALUES(2055,514,2,'2 parallel geschaltete Drahtwiderstände von 100 &Omega;',' ');
INSERT INTO answer VALUES(2056,514,3,'ein Spulenanpassfilter im Ölbad',' ');
INSERT INTO answer VALUES(2057,515,0,'Aus induktionsarmen Kohleschichtwiderständen',' ');
INSERT INTO answer VALUES(2058,515,1,'Aus Drahtwiderständen mit kapazitätsarmen Anschlusskappen',' ');
INSERT INTO answer VALUES(2059,515,2,'Aus einem abgestimmten Topfkreis mit induktiver Einkopplung',' ');
INSERT INTO answer VALUES(2060,515,3,'Aus versilberten Kupfer-Rundstäben von 10 mm Durchmesser',' ');
INSERT INTO answer VALUES(2061,516,0,'Je größer der Plattenabstand ist, desto kleiner ist die Kapazität.',' ');
INSERT INTO answer VALUES(2062,516,1,'Je größer die angelegte Spannung ist, desto kleiner ist die Kapazität.',' ');
INSERT INTO answer VALUES(2063,516,2,'Je größer die Plattenoberfläche ist, desto kleiner ist die Kapazität.',' ');
INSERT INTO answer VALUES(2064,516,3,'Je größer die Dielektrizitätszahl ist, desto kleiner ist die Kapazität.',' ');
INSERT INTO answer VALUES(2065,517,0,'<p><img src=''tc202a.jpg''></p>',' ');
INSERT INTO answer VALUES(2066,517,1,'<p><img src=''tc202b.jpg''></p>',' ');
INSERT INTO answer VALUES(2067,517,2,'<p><img src=''tc202c.jpg''></p>',' ');
INSERT INTO answer VALUES(2068,517,3,'<p><img src=''tc202d.jpg''></p>',' ');
INSERT INTO answer VALUES(2069,518,0,'Der Strom eilt der Spannung um 90° voraus.',' ');
INSERT INTO answer VALUES(2070,518,1,'Die Spannung eilt dem Strom um 90° voraus.',' ');
INSERT INTO answer VALUES(2071,518,2,'Die Spannung eilt dem Strom um 45° voraus.',' ');
INSERT INTO answer VALUES(2072,518,3,'Der Strom eilt der Spannung um 45° voraus.',' ');
INSERT INTO answer VALUES(2073,519,0,'Er nimmt ab.',' ');
INSERT INTO answer VALUES(2074,519,1,'Er bleibt konstant.',' ');
INSERT INTO answer VALUES(2075,519,2,'Er nimmt zu.',' ');
INSERT INTO answer VALUES(2076,519,3,'Er wird unendlich.',' ');
INSERT INTO answer VALUES(2077,520,0,'159 &Omega;',' ');
INSERT INTO answer VALUES(2078,520,1,'1,59 k&Omega;',' ');
INSERT INTO answer VALUES(2079,520,2,'318 &Omega;',' ');
INSERT INTO answer VALUES(2080,520,3,'31,8 &Omega;',' ');
INSERT INTO answer VALUES(2081,521,0,'6,37 µF',' ');
INSERT INTO answer VALUES(2082,521,1,'0,637 µF',' ');
INSERT INTO answer VALUES(2083,521,2,'0,45 µF',' ');
INSERT INTO answer VALUES(2084,521,3,'4,5 µF',' ');
INSERT INTO answer VALUES(2085,522,0,'Der Blindwiderstand ist der mit negativem Vorzeichen versehene Wechselstromwiderstand eines Kondensators. Er ist abhängig von der Kapazität des Kondensators und der anliegenden Frequenz. Im Blindwiderstand entstehen keine Wärmeverluste.',' ');
INSERT INTO answer VALUES(2086,522,1,'Der Blindwiderstand ist der Gleichstromwiderstand eines Kondensators. Er ist abhängig vom Isolationsmaterial des Kondensators und der anliegenden Spannung. Auch im Blindwiderstand entstehen Wärmeverluste.',' ');
INSERT INTO answer VALUES(2087,522,2,'Der Blindwiderstand ist der Wechselstromwiderstand eines Kondensators. Er ist abhängig von der Blindkapazität des Kondensators und der anliegenden Spannung. Im Blindwiderstand entstehen hohe Verluste.',' ');
INSERT INTO answer VALUES(2088,522,3,'Der Blindwiderstand ist der HF-Gleichstromwiderstand eines Kondensators. Er wird mit steigender Kapazität sowie bei erhöhtem Wechselstromanteil und steigender Frequenz größer. Je höher die Frequenz umso eher wandern die Ladungen an die Plattenränder (Skin-Effekt).',' ');
INSERT INTO answer VALUES(2089,523,0,'den Verlustfaktor tan &delta; (Tangens Delta), der dem Kehrwert des Gütefaktors entspricht.',' ');
INSERT INTO answer VALUES(2090,523,1,'den relativen Verlustwiderstand in Ohm pro Picofarad, mit dem die Kondensatorgüte berechnet werden kann.',' ');
INSERT INTO answer VALUES(2091,523,2,'den relativen Blindwiderstand in Ohm pro Picofarad, mit dem die Kondensatorgüte berechnet werden kann.',' ');
INSERT INTO answer VALUES(2092,523,3,'den Verlustfaktor cos &phi; (Cosinus Phi), der dem Kehrwert des Gütefaktors entspricht.',' ');
INSERT INTO answer VALUES(2093,524,0,'Ja, infolge von Verlusten im Dielektrikum, die aber meist vernachlässigbar klein sind.',' ');
INSERT INTO answer VALUES(2094,524,1,'Nein, beim Kondensator handelt es sich immer nur um eine reine Blindleistung.',' ');
INSERT INTO answer VALUES(2095,524,2,'Ja, aber nur dann, wenn Luft als Dielektrikum verwendet wird.',' ');
INSERT INTO answer VALUES(2096,524,3,'Ja, genau wie bei Gleichstrom entsprechend den Formeln für Strom, Spannung und Leistung.',' ');
INSERT INTO answer VALUES(2097,525,0,'<p><img src=''tc202b.jpg''></p>',' ');
INSERT INTO answer VALUES(2098,525,1,'<p><img src=''tc202a.jpg''></p>',' ');
INSERT INTO answer VALUES(2099,525,2,'<p><img src=''tc202c.jpg''></p>',' ');
INSERT INTO answer VALUES(2100,525,3,'<p><img src=''tc202d.jpg''></p>',' ');
INSERT INTO answer VALUES(2101,526,0,'um 90° nach.',' ');
INSERT INTO answer VALUES(2102,526,1,'um 45° voraus.',' ');
INSERT INTO answer VALUES(2103,526,2,'um 45° nach.',' ');
INSERT INTO answer VALUES(2104,526,3,'um 90° voraus.',' ');
INSERT INTO answer VALUES(2105,527,0,'Er nimmt zu.',' ');
INSERT INTO answer VALUES(2106,527,1,'Er nimmt ab.',' ');
INSERT INTO answer VALUES(2107,527,2,'Er bleibt konstant.',' ');
INSERT INTO answer VALUES(2108,527,3,'Er steigt auf ein Maximum und fällt dann ab.',' ');
INSERT INTO answer VALUES(2109,528,0,'Beim Betrieb mit Gleichspannung wirkt nur der Gleichstromwiderstand der Spule. Beim Betrieb mit Wechselspannung wird der induktive Widerstand X<sub>L</sub> wirksam und erhöht den Gesamtwiderstand. Der Strom wird kleiner.',' ');
INSERT INTO answer VALUES(2110,528,1,'Beim Betrieb mit Gleichspannung wirkt nur der Gleichstromwiderstand der Spule. Beim Betrieb mit Wechselspannung wirkt nur der kleinere induktive Widerstand X<sub>L</sub>. Der Strom wird größer.',' ');
INSERT INTO answer VALUES(2111,528,2,'Beim Betrieb mit Gleich- oder Wechselspannung wirkt nur der ohmsche Widerstand X<sub>L</sub> der Spule. Der Strom bleibt gleich.',' ');
INSERT INTO answer VALUES(2112,528,3,'Beim Betrieb mit Wechselspannung wirkt nur der Wechselstromwiderstand der Spule. Beim Betrieb mit Gleichspannung wird nur der ohmsche Widerstand X<sub>L</sub> wirksam. Der Strom wird größer.',' ');
INSERT INTO answer VALUES(2113,529,0,'1885 &Omega;',' ');
INSERT INTO answer VALUES(2114,529,1,'942 &Omega;',' ');
INSERT INTO answer VALUES(2115,529,2,'1885 k&Omega;',' ');
INSERT INTO answer VALUES(2116,529,3,'1,9 &Omega;',' ');
INSERT INTO answer VALUES(2117,530,0,'Der Blindwiderstand ist der Wechselstromwiderstand einer Spule. Er ist abhängig von der Induktivität der Spule und der anliegenden Frequenz. Im Blindwiderstand entstehen keine Wärmeverluste.',' ');
INSERT INTO answer VALUES(2118,530,1,'Der Blindwiderstand ist der Gleichstromwiderstand einer Spule. Er ist abhängig vom Isolationsmaterial der Spule und der anliegenden Spannung. Auch im Blindwiderstand entstehen Wärmeverluste.',' ');
INSERT INTO answer VALUES(2119,530,2,'Der Blindwiderstand ist der Wechselstromwiderstand einer Spule. Er ist abhängig von der Blindinduktivität der Spule und der anliegenden Spannung. Im Blindwiderstand entstehen hohe Verluste.',' ');
INSERT INTO answer VALUES(2120,530,3,'Der Blindwiderstand ist der HF-Gleichstromwiderstand einer Spule. Er wird mit steigender Induktivität sowie bei erhöhtem Wechselstromanteil und steigender Frequenz größer. Je tiefer die Frequenz umso eher wandern die Elektronen an den Spulenrand (Skin-Effekt).',' ');
INSERT INTO answer VALUES(2121,531,0,'den Verlustfaktor tan &delta; (Tangens Delta), der dem Kehrwert des Gütefaktors entspricht.',' ');
INSERT INTO answer VALUES(2122,531,1,'den relativen Verlustwiderstand in Ohm pro Nanohenry, mit dem die Spulengüte berechnet werden kann.',' ');
INSERT INTO answer VALUES(2123,531,2,'den relativen Blindwiderstand in Ohm pro Nanohenry, mit dem die Spulengüte berechnet werden kann..',' ');
INSERT INTO answer VALUES(2124,531,3,'den Verlustfaktor cos &phi; (Cosinus Phi), der dem Kehrwert des Gütefaktors entspricht.',' ');
INSERT INTO answer VALUES(2125,532,0,'Ja, jeder Leiter, gleich welche Form er hat, weist eine Induktivität auf.',' ');
INSERT INTO answer VALUES(2126,532,1,'Nein, der Leiter muss wenigstens eine Krümmung (eine viertel, halbe oder ganze Windung) aufweisen.',' ');
INSERT INTO answer VALUES(2127,532,2,'Ja, aber die Größe der Induktivität hängt vom spezifischen Widerstand des Leitermaterials ab.',' ');
INSERT INTO answer VALUES(2128,532,3,'Ja, aber nicht immer, denn abgeschirmte Leiter, beispielsweise Koaxialkabel und Streifenleitungen, weisen nur eine Kapazität auf.',' ');
INSERT INTO answer VALUES(2129,533,0,'Durch Stauchen der Spule (Verkürzen der Spulenlänge).',' ');
INSERT INTO answer VALUES(2130,533,1,'Durch Auseinanderziehen der Spule (Vergrößerung der Spulenlänge).',' ');
INSERT INTO answer VALUES(2131,533,2,'Durch Einführen eines Kupferkerns in die Spule.',' ');
INSERT INTO answer VALUES(2132,533,3,'Durch Einbau der Spule in einen Abschirmbecher.',' ');
INSERT INTO answer VALUES(2133,534,0,'89',' ');
INSERT INTO answer VALUES(2134,534,1,'3',' ');
INSERT INTO answer VALUES(2135,534,2,'2828',' ');
INSERT INTO answer VALUES(2136,534,3,'53',' ');
INSERT INTO answer VALUES(2137,535,0,'112,5 mH',' ');
INSERT INTO answer VALUES(2138,535,1,'112,5 µH',' ');
INSERT INTO answer VALUES(2139,535,2,'11,25 mH',' ');
INSERT INTO answer VALUES(2140,535,3,'1,125 mH',' ');
INSERT INTO answer VALUES(2141,536,0,'0,294 µH',' ');
INSERT INTO answer VALUES(2142,536,1,'2,94 µH',' ');
INSERT INTO answer VALUES(2143,536,2,'29,4 nH',' ');
INSERT INTO answer VALUES(2144,536,3,'2,94 nH',' ');
INSERT INTO answer VALUES(2145,537,0,'20',' ');
INSERT INTO answer VALUES(2146,537,1,'400',' ');
INSERT INTO answer VALUES(2147,537,2,'360',' ');
INSERT INTO answer VALUES(2148,537,3,'6',' ');
INSERT INTO answer VALUES(2149,538,0,'Der Strom fließt bei hohen Frequenzen nur noch in der Oberfläche des Leiters. Mit sinkendem stromdurchflossenen Querschnitt steigt daher der effektive Widerstand des Leiters.',' ');
INSERT INTO answer VALUES(2150,538,1,'Der Skin-Effekt ist für den mit der Frequenz ansteigenden induktiven Widerstand verantwortlich',' ');
INSERT INTO answer VALUES(2151,538,2,'Der Strom fließt bei hohen Frequenzen nur noch in der Oberfläche des Leiters. Mit sinkendem stromdurchflossenen Querschnitt steigt daher der induktive Widerstand des Leiters.',' ');
INSERT INTO answer VALUES(2152,538,3,'Der Strom fließt bei hohen Frequenzen nur noch in der Oberfläche des Leiters. Mit sinkendem stromdurchflossenen Querschnitt vergrößert sich daher der kapazitive Widerstand des Leiters.',' ');
INSERT INTO answer VALUES(2153,539,0,'Als Skin-Effekt bezeichnet man die Erscheinung, dass sich mit steigender Frequenz der Elektronenstrom mehr und mehr zur Oberfläche eines Leiters hin verlagert. Dadurch erhöht sich mit steigender Frequenz der ohmsche Leiterwiderstand.',' ');
INSERT INTO answer VALUES(2154,539,1,'Als Skin-Effekt bezeichnet man die Erscheinung, dass sich mit steigender Frequenz der Elektronenstrom mehr und mehr zu den Kanten eines Kondensators hin verlagert. Dadurch erhöht sich mit steigender Frequenz die Kapazität.',' ');
INSERT INTO answer VALUES(2155,539,2,'Als Skin-Effekt bezeichnet man die Erscheinung, dass sich mit steigender Frequenz die Induktivität und die Kapazität eines Leiters erhöht. Dadurch erhöht sich mit steigendem Leiterwiderstand die Resonanzfrequenz.',' ');
INSERT INTO answer VALUES(2156,539,3,'Als Skin-Effekt bezeichnet man die Erscheinung, dass sich mit steigender Frequenz der Elektronenstrom mehr und mehr zur Leitermitte hin verlagert. Dadurch erhöht sich der ohmsche Leiterwiderstand bei hohem Wechselstromanteil.',' ');
INSERT INTO answer VALUES(2157,540,0,'Ferrit bestehen.',' ');
INSERT INTO answer VALUES(2158,540,1,'Kunststoff bestehen.',' ');
INSERT INTO answer VALUES(2159,540,2,'Stahl bestehen.',' ');
INSERT INTO answer VALUES(2160,540,3,'paramagnetischem Material bestehen.',' ');
INSERT INTO answer VALUES(2161,541,0,'Die Spule wird um einen Widerstand mit niedrigem Widerstandswert gewickelt.',' ');
INSERT INTO answer VALUES(2162,541,1,'Es wird eine freitragende Spule aus dickem Kupferdraht, der mit einem Silberbelag versehen ist, hergestellt.',' ');
INSERT INTO answer VALUES(2163,541,2,'Es wird ein dicker Kupferdraht um einen Widerstand mit sehr hohem Widerstandswert gewickelt.',' ');
INSERT INTO answer VALUES(2164,541,3,'Es wird ein Kohleschichtwiderstand mit niedrigem Widerstandswert verwendet.',' ');
INSERT INTO answer VALUES(2165,542,0,'in einem Abschirmbecher aus Metall untergebracht werden.',' ');
INSERT INTO answer VALUES(2166,542,1,'in einem nichtmetallischen Harz eingehüllt werden.',' ');
INSERT INTO answer VALUES(2167,542,2,'in einem Abschirmbecher aus Kunststoff untergebracht werden.',' ');
INSERT INTO answer VALUES(2168,542,3,'einen abgestimmten Kunststoffkern aufweisen.',' ');
INSERT INTO answer VALUES(2169,543,0,'ein veränderlicher Strom durch eine magnetisch gekoppelte benachbarte Spule fließt.',' ');
INSERT INTO answer VALUES(2170,543,1,'durch eine magnetisch gekoppelte benachbarte Spule kein Strom fließt.',' ');
INSERT INTO answer VALUES(2171,543,2,'ein konstanter Gleichstrom durch eine magnetisch gekoppelte benachbarte Spule fließt.',' ');
INSERT INTO answer VALUES(2172,543,3,'sich die Spule in einem konstanten Magnetfeld befindet.',' ');
INSERT INTO answer VALUES(2173,544,0,'30 Windungen',' ');
INSERT INTO answer VALUES(2174,544,1,'20 Windungen',' ');
INSERT INTO answer VALUES(2175,544,2,'52 Windungen',' ');
INSERT INTO answer VALUES(2176,544,3,'180 Windungen',' ');
INSERT INTO answer VALUES(2177,545,0,'30 mA',' ');
INSERT INTO answer VALUES(2178,545,1,'22,7 mA',' ');
INSERT INTO answer VALUES(2179,545,2,'0,83 mA',' ');
INSERT INTO answer VALUES(2180,545,3,'33,3 mA',' ');
INSERT INTO answer VALUES(2181,546,0,'0,49 A',' ');
INSERT INTO answer VALUES(2182,546,1,'1,96 A',' ');
INSERT INTO answer VALUES(2183,546,2,'1,25 A',' ');
INSERT INTO answer VALUES(2184,546,3,'0,23 A',' ');
INSERT INTO answer VALUES(2185,547,0,'1 k&Omega;.',' ');
INSERT INTO answer VALUES(2186,547,1,'64 k&Omega;.',' ');
INSERT INTO answer VALUES(2187,547,2,'16 k&Omega;.',' ');
INSERT INTO answer VALUES(2188,547,3,'4 k&Omega;.',' ');
INSERT INTO answer VALUES(2189,548,0,'0,4 k&Omega;.',' ');
INSERT INTO answer VALUES(2190,548,1,'25,6 k&Omega;.',' ');
INSERT INTO answer VALUES(2191,548,2,'6,4 k&Omega;.',' ');
INSERT INTO answer VALUES(2192,548,3,'1,6 k&Omega;.',' ');
INSERT INTO answer VALUES(2193,549,0,'2:1 verwendet werden.',' ');
INSERT INTO answer VALUES(2194,549,1,'4:1 verwendet werden.',' ');
INSERT INTO answer VALUES(2195,549,2,'8:1 verwendet werden.',' ');
INSERT INTO answer VALUES(2196,549,3,'16:1 verwendet werden.',' ');
INSERT INTO answer VALUES(2197,550,0,'1:3,5 aufweisen.',' ');
INSERT INTO answer VALUES(2198,550,1,'1:1 aufweisen.',' ');
INSERT INTO answer VALUES(2199,550,2,'1:5,5 aufweisen.',' ');
INSERT INTO answer VALUES(2200,550,3,'1:12 aufweisen.',' ');
INSERT INTO answer VALUES(2201,551,0,'Sie wandern von N nach P.',' ');
INSERT INTO answer VALUES(2202,551,1,'Sie wandern von P nach N.',' ');
INSERT INTO answer VALUES(2203,551,2,'Sie bleiben im N-Bereich.',' ');
INSERT INTO answer VALUES(2204,551,3,'Sie zerfallen beim Übergang.',' ');
INSERT INTO answer VALUES(2205,552,0,'den Stromfluss von P nach N.',' ');
INSERT INTO answer VALUES(2206,552,1,'den Stromfluss von N nach P.',' ');
INSERT INTO answer VALUES(2207,552,2,'keinen Stromfluss.',' ');
INSERT INTO answer VALUES(2208,552,3,'den Elektronenfluss von P nach N.',' ');
INSERT INTO answer VALUES(2209,553,0,'einen hohen Widerstand.',' ');
INSERT INTO answer VALUES(2210,553,1,'eine hohe Kapazität.',' ');
INSERT INTO answer VALUES(2211,553,2,'eine geringe Impedanz.',' ');
INSERT INTO answer VALUES(2212,553,3,'eine hohe Induktivität.',' ');
INSERT INTO answer VALUES(2213,554,0,'Germanium zwischen 0,2 und 0,4 Volt, bei Silizium zwischen 0,5 und 0,8 Volt.',' ');
INSERT INTO answer VALUES(2214,554,1,'Germanium zwischen 0,5 und 0,8 Volt, bei Silizium zwischen 0,2 und 0,4 Volt.',' ');
INSERT INTO answer VALUES(2215,554,2,'Germanium bei etwa 0,7 Volt, bei Silizium bei etwa 0,3 Volt.',' ');
INSERT INTO answer VALUES(2216,554,3,'allen Dioden bei etwa 0,7 Volt.',' ');
INSERT INTO answer VALUES(2217,555,0,'Die Spannung sinkt bei steigender Temperatur.',' ');
INSERT INTO answer VALUES(2218,555,1,'Die Spannung hängt allein vom Durchlassstrom ab.',' ');
INSERT INTO answer VALUES(2219,555,2,'Die Spannung hängt nur vom Trägermaterial ab (Germanium/Silizium).',' ');
INSERT INTO answer VALUES(2220,555,3,'Die Spannung steigt bei wachsender Temperatur.',' ');
INSERT INTO answer VALUES(2221,556,0,'An der Anode liegen 5,7 Volt, an der Katode 5,0 Volt an.',' ');
INSERT INTO answer VALUES(2222,556,1,'An der Anode liegen 5,7 Volt, an der Katode 6,4 Volt an.',' ');
INSERT INTO answer VALUES(2223,556,2,'An der Anode liegen 5,0 Volt, an der Katode 5,1 Volt an.',' ');
INSERT INTO answer VALUES(2224,556,3,'An der Anode liegen 5,0 Volt, an der Katode 5,7 Volt an.',' ');
INSERT INTO answer VALUES(2225,557,0,'-0,4 V <img src="diode_ka.png"> 0,3 V',' ');
INSERT INTO answer VALUES(2226,557,1,'-3,7 V <img src="diode_ak.png"> -3,0 V',' ');
INSERT INTO answer VALUES(2227,557,2,'1,6 V <img src="diode_ka.png"> 0,9 V',' ');
INSERT INTO answer VALUES(2228,557,3,'3,3 V <img src="diode_ak.png"> 4,0 V',' ');
INSERT INTO answer VALUES(2229,558,0,'0,6 V <img src="diode_ka.png"> 1,3 V',' ');
INSERT INTO answer VALUES(2230,558,1,'-1,4 V <img src="diode_ak.png"> -0,7 V',' ');
INSERT INTO answer VALUES(2231,558,2,'5,0 V <img src="diode_ka.png"> 4,3 V',' ');
INSERT INTO answer VALUES(2232,558,3,'3,4 V <img src="diode_ak.png"> 4,1 V',' ');
INSERT INTO answer VALUES(2233,559,0,'-1,3 V <img src="diode_ak.png"> -2,0 V',' ');
INSERT INTO answer VALUES(2234,559,1,'-0,6 V <img src="diode_ka.png"> -1,3 V',' ');
INSERT INTO answer VALUES(2235,559,2,'4,3 V <img src="diode_ak.png"> 5,0 V',' ');
INSERT INTO answer VALUES(2236,559,3,'4,1 V <img src="diode_ka.png"> 3,4 V',' ');
INSERT INTO answer VALUES(2237,560,0,'-3 V <img src="diode_ak.png"> -3,7 V',' ');
INSERT INTO answer VALUES(2238,560,1,'5,4 V <img src="diode_ka.png"> 4,7 V',' ');
INSERT INTO answer VALUES(2239,560,2,'15 V <img src="diode_ak.png"> 18 V',' ');
INSERT INTO answer VALUES(2240,560,3,'3,9 V <img src="diode_ka.png"> 3,2 V',' ');
INSERT INTO answer VALUES(2241,561,0,'1: Schottkydiode, 2: Germaniumdiode, 3: Siliziumdiode',' ');
INSERT INTO answer VALUES(2242,561,1,'1: Schottkydiode, 2: Siliziumdiode, 3: Germaniumdiode',' ');
INSERT INTO answer VALUES(2243,561,2,'1: Germaniumdiode, 2: Schottkydiode, 3: Siliziumdiode',' ');
INSERT INTO answer VALUES(2244,561,3,'1: Siliziumdiode, 3: Germaniumdiode, 3: Schottkydiode',' ');
INSERT INTO answer VALUES(2245,562,0,'Kennlinie 2',' ');
INSERT INTO answer VALUES(2246,562,1,'Kennlinie 1',' ');
INSERT INTO answer VALUES(2247,562,2,'Kennlinie 3',' ');
INSERT INTO answer VALUES(2248,562,3,'Kennlinie 4',' ');
INSERT INTO answer VALUES(2249,563,0,'Kennlinie 1: Schottkydiode<br> Kennlinie 2: Germaniumdiode<br> Kennlinie 3: Siliziumdiode<br> Kennlinie 4: Leuchtdiode',' ');
INSERT INTO answer VALUES(2250,563,1,'Kennlinie 1: Siliziumdiode<br> Kennlinie 2: Germaniumdiode<br> Kennlinie 3: Schottkydiode<br> Kennlinie 4: Leuchtdiode',' ');
INSERT INTO answer VALUES(2251,563,2,'Kennlinie 1: Schottkydiode<br> Kennlinie 2: Siliziumdiode<br> Kennlinie 3: Germaniumdiode<br> Kennlinie 4: Leuchtdiode',' ');
INSERT INTO answer VALUES(2252,563,3,'Kennlinie 1: Germaniumdiode<br> Kennlinie 2: Leuchtdiode<br> Kennlinie 3: Siliziumdiode<br> Kennlinie 4: Schottkydiode',' ');
INSERT INTO answer VALUES(2253,564,0,'<p><img src=''tc514a.jpg''></p>',' ');
INSERT INTO answer VALUES(2254,564,1,'<p><img src=''tc514b.jpg''></p>',' ');
INSERT INTO answer VALUES(2255,564,2,'<p><img src=''tc514c.jpg''></p>',' ');
INSERT INTO answer VALUES(2256,564,3,'<p><img src=''tc514d.jpg''></p>',' ');
INSERT INTO answer VALUES(2257,565,0,'<p><img src=''tc515a.jpg''></p>',' ');
INSERT INTO answer VALUES(2258,565,1,'<p><img src=''tc515b.jpg''></p>',' ');
INSERT INTO answer VALUES(2259,565,2,'<p><img src=''tc515c.jpg''></p>',' ');
INSERT INTO answer VALUES(2260,565,3,'<p><img src=''tc515d.jpg''></p>',' ');
INSERT INTO answer VALUES(2261,566,0,'280 &Omega; / 175 mW.',' ');
INSERT INTO answer VALUES(2262,566,1,'280 &Omega; / 300 mW.',' ');
INSERT INTO answer VALUES(2263,566,2,'480 &Omega; / 300 mW.',' ');
INSERT INTO answer VALUES(2264,566,3,'200 &Omega; / 175 mW.',' ');
INSERT INTO answer VALUES(2265,567,0,'202 &Omega;.',' ');
INSERT INTO answer VALUES(2266,567,1,'364 &Omega;.',' ');
INSERT INTO answer VALUES(2267,567,2,'188 &Omega;.',' ');
INSERT INTO answer VALUES(2268,567,3,'235 &Omega;.',' ');
INSERT INTO answer VALUES(2269,568,0,'180 &Omega;.',' ');
INSERT INTO answer VALUES(2270,568,1,'250 &Omega;.',' ');
INSERT INTO answer VALUES(2271,568,2,'70 &Omega;.',' ');
INSERT INTO answer VALUES(2272,568,3,'320 &Omega;.',' ');
INSERT INTO answer VALUES(2273,569,0,'150 Ohm / 0,1 Watt',' ');
INSERT INTO answer VALUES(2274,569,1,'220 Ohm / 0,25 Watt',' ');
INSERT INTO answer VALUES(2275,569,2,'70 Ohm / 0,1 Watt',' ');
INSERT INTO answer VALUES(2276,569,3,'290 Ohm / 0,25 Watt',' ');
INSERT INTO answer VALUES(2277,570,0,'Die Frequenz des Schwingkreises steigt.',' ');
INSERT INTO answer VALUES(2278,570,1,'Die Frequenz des Schwingkreises sinkt.',' ');
INSERT INTO answer VALUES(2279,570,2,'Die Frequenz des Schwingkreises ändert sich nicht.',' ');
INSERT INTO answer VALUES(2280,570,3,'Die Diode sperrt und der Schwingkreis wird unterbrochen.',' ');
INSERT INTO answer VALUES(2281,571,0,'Sie nimmt mit abnehmender Sperrspannung zu.',' ');
INSERT INTO answer VALUES(2282,571,1,'Sie erhöht sich mit zunehmender Durchlassspannung.',' ');
INSERT INTO answer VALUES(2283,571,2,'Sie nimmt mit zunehmender Sperrspannung zu.',' ');
INSERT INTO answer VALUES(2284,571,3,'Sie erhöht sich mit zunehmendem Durchlassstrom.',' ');
INSERT INTO answer VALUES(2285,572,0,'Sehr niedrige Durchlassspannung und sehr hohe Schaltfrequenz.',' ');
INSERT INTO answer VALUES(2286,572,1,'Sehr niedrige Durchlassspannung und sehr niedrige Schaltfrequenz.',' ');
INSERT INTO answer VALUES(2287,572,2,'Sehr hohe Durchlassspannung und sehr hohe Schaltfrequenz.',' ');
INSERT INTO answer VALUES(2288,572,3,'Sehr hohe Durchlassspannung und sehr niedrige Schaltfrequenz.',' ');
INSERT INTO answer VALUES(2289,573,0,'die Entkopplung zweier Stromkreise.',' ');
INSERT INTO answer VALUES(2290,573,1,'die Erzeugung von Wechselstrom durch Licht.',' ');
INSERT INTO answer VALUES(2291,573,2,'die Abgabe von Licht zur Signalanzeige.',' ');
INSERT INTO answer VALUES(2292,573,3,'die Erzeugung von Gleichstrom durch Licht.',' ');
INSERT INTO answer VALUES(2293,574,0,'die Umwandlung von Licht in elektrischen Strom.',' ');
INSERT INTO answer VALUES(2294,574,1,'die Abgabe von Licht zur Signalanzeige.',' ');
INSERT INTO answer VALUES(2295,574,2,'die Entkopplung zweier Wechselstromkreise.',' ');
INSERT INTO answer VALUES(2296,574,3,'die Gewinnung von Wechselstrom aus Licht.',' ');
INSERT INTO answer VALUES(2297,575,0,'<p><img src=''tc525a.jpg''></p>',' ');
INSERT INTO answer VALUES(2298,575,1,'<p><img src=''tc525b.jpg''></p>',' ');
INSERT INTO answer VALUES(2299,575,2,'<p><img src=''tc525c.jpg''></p>',' ');
INSERT INTO answer VALUES(2300,575,3,'<p><img src=''tc525d.jpg''></p>',' ');
INSERT INTO answer VALUES(2301,576,0,'<p><img src=''tc525d.jpg''></p>',' ');
INSERT INTO answer VALUES(2302,576,1,'<p><img src=''tc525b.jpg''></p>',' ');
INSERT INTO answer VALUES(2303,576,2,'<p><img src=''tc525c.jpg''></p>',' ');
INSERT INTO answer VALUES(2304,576,3,'<p><img src=''tc525a.jpg''></p>',' ');
INSERT INTO answer VALUES(2305,577,0,'D<sub>1</sub> leitet. D<sub>2</sub> leitet. D<sub>3</sub> leitet nicht.',' ');
INSERT INTO answer VALUES(2306,577,1,'D<sub>1</sub> leitet. D<sub>2</sub> leitet. D<sub>3</sub> leitet.',' ');
INSERT INTO answer VALUES(2307,577,2,'D<sub>1</sub> leitet. D<sub>2</sub> leitet nicht. D<sub>3</sub> leitet nicht.',' ');
INSERT INTO answer VALUES(2308,577,3,'D<sub>1</sub> leitet nicht. D<sub>2</sub> leitet. D<sub>3</sub> leitet.',' ');
INSERT INTO answer VALUES(2309,578,0,'<p><img src=''tc528a.jpg''></p>',' ');
INSERT INTO answer VALUES(2310,578,1,'<p><img src=''tc528b.jpg''></p>',' ');
INSERT INTO answer VALUES(2311,578,2,'<p><img src=''tc528c.jpg''></p>',' ');
INSERT INTO answer VALUES(2312,578,3,'<p><img src=''tc528d.jpg''></p>',' ');
INSERT INTO answer VALUES(2313,579,0,'1: NPN-Transistor 2: PNP-Transistor',' ');
INSERT INTO answer VALUES(2314,579,1,'1: PNP-Transistor 2: NPN-Transistor',' ');
INSERT INTO answer VALUES(2315,579,2,'1: N-Kanal-Transistor 2: P-Kanal-Transistor',' ');
INSERT INTO answer VALUES(2316,579,3,'1: P-Kanal-Transistor 2: N-Kanal-Transistor',' ');
INSERT INTO answer VALUES(2317,580,0,'1: Selbstleitender N-Kanal-Sperrschicht-FET<br> 2: Selbstleitender P-Kanal-Sperrschicht-FET',' ');
INSERT INTO answer VALUES(2318,580,1,'1: Selbstsperrender N-Kanal-Sperrschicht-FET<br> 2: Selbstsperrender P-Kanal-Sperrschicht-FET',' ');
INSERT INTO answer VALUES(2319,580,2,'1: Selbstleitender P-Kanal-Sperrschicht-FET<br> 2: Selbstleitender N-Kanal-Sperrschicht-FET',' ');
INSERT INTO answer VALUES(2320,580,3,'1: Selbstsperrender P-Kanal-Sperrschicht-FET<br> 2: Selbstsperrender N-Kanal-Sperrschicht-FET',' ');
INSERT INTO answer VALUES(2321,581,0,'Selbstsperrender N-Kanal-Isolierschicht FET (MOSFET).',' ');
INSERT INTO answer VALUES(2322,581,1,'Selbstsperrender P-Kanal-Isolierschicht FET (MOSFET).',' ');
INSERT INTO answer VALUES(2323,581,2,'Selbstleitender N-Kanal-Isolierschicht FET (MOSFET).',' ');
INSERT INTO answer VALUES(2324,581,3,'Selbstleitender P-Kanal-Isolierschicht FET (MOSFET).',' ');
INSERT INTO answer VALUES(2325,582,0,'<p><img src=''tc604a.jpg''></p>',' ');
INSERT INTO answer VALUES(2326,582,1,'<p><img src=''tc604b.jpg''></p>',' ');
INSERT INTO answer VALUES(2327,582,2,'<p><img src=''tc604c.jpg''></p>',' ');
INSERT INTO answer VALUES(2328,582,3,'<p><img src=''tc604d.jpg''></p>',' ');
INSERT INTO answer VALUES(2329,583,0,'<p><img src=''tc605a.jpg''></p>',' ');
INSERT INTO answer VALUES(2330,583,1,'<p><img src=''tc605b.jpg''></p>',' ');
INSERT INTO answer VALUES(2331,583,2,'<p><img src=''tc605c.jpg''></p>',' ');
INSERT INTO answer VALUES(2332,583,3,'<p><img src=''tc605d.jpg''></p>',' ');
INSERT INTO answer VALUES(2333,584,0,'2 = Drain, 3 = Source',' ');
INSERT INTO answer VALUES(2334,584,1,'2 = Source, 3 = Drain',' ');
INSERT INTO answer VALUES(2335,584,2,'2 = Drain, 3 = Emitter',' ');
INSERT INTO answer VALUES(2336,584,3,'2 = Gate 2, 3 = Gate 1',' ');
INSERT INTO answer VALUES(2337,585,0,'NPN-Transistoren benötigen positive, PNP-Transistoren negative Kollektorspannungen.',' ');
INSERT INTO answer VALUES(2338,585,1,'NPN- und PNP-Transistoren benötigen negative Kollektorspannungen.',' ');
INSERT INTO answer VALUES(2339,585,2,'PNP-Transistoren benötigen positive, NPN-Transistoren negative Kollektorspannung.',' ');
INSERT INTO answer VALUES(2340,585,3,'PNP- und NPN-Transistoren benötigen positive Kollektorspannungen.',' ');
INSERT INTO answer VALUES(2341,586,0,'NPN- und PNP-Transistoren',' ');
INSERT INTO answer VALUES(2342,586,1,'Dual-Gate-MOS-FETs',' ');
INSERT INTO answer VALUES(2343,586,2,'Isolierschicht FETs',' ');
INSERT INTO answer VALUES(2344,586,3,'Sperrschicht FETs',' ');
INSERT INTO answer VALUES(2345,587,0,'Die Gatespannung steuert den Widerstand des Kanals zwischen Source und Drain.',' ');
INSERT INTO answer VALUES(2346,587,1,'Die Gatespannung steuert den Gatestrom.',' ');
INSERT INTO answer VALUES(2347,587,2,'Der Gatestrom ist allein verantwortlich für den Drainstrom.',' ');
INSERT INTO answer VALUES(2348,587,3,'Der Gatestrom steuert den Widerstand des Kanals zwischen Source und Drain.',' ');
INSERT INTO answer VALUES(2349,588,0,'Es fließt kein Kollektorstrom.',' ');
INSERT INTO answer VALUES(2350,588,1,'Es fließt der maximale Kollektorstrom.',' ');
INSERT INTO answer VALUES(2351,588,2,'Es fließen ca. 5 bis 10 Milliampere.',' ');
INSERT INTO answer VALUES(2352,588,3,'Es fließen je nach Kollektorspannung 0,01 Ampere bis 1 Ampere.',' ');
INSERT INTO answer VALUES(2353,589,0,'auf Höhe der Emitterspannung liegt.',' ');
INSERT INTO answer VALUES(2354,589,1,'auf Höhe der Kollektorspannung liegt.',' ');
INSERT INTO answer VALUES(2355,589,2,'zwischen Kollektor und Emitterspannung liegt.',' ');
INSERT INTO answer VALUES(2356,589,3,'mindestens 0,6 V positiver ist, als das Emitterpotenzial.',' ');
INSERT INTO answer VALUES(2357,590,0,'Sie ist etwa 0,6 V höher als die Emitterspannung.',' ');
INSERT INTO answer VALUES(2358,590,1,'Sie entspricht der Kollektorspannung.',' ');
INSERT INTO answer VALUES(2359,590,2,'Sie ist viel höher als die Emitterspannung.',' ');
INSERT INTO answer VALUES(2360,590,3,'Sie liegt etwa 0,6 V unter der Emitterspannung.',' ');
INSERT INTO answer VALUES(2361,591,0,'in Durchlassrichtung.',' ');
INSERT INTO answer VALUES(2362,591,1,'im Leerlauf.',' ');
INSERT INTO answer VALUES(2363,591,2,'im Kurzschluss.',' ');
INSERT INTO answer VALUES(2364,591,3,'in Sperrrichtung.',' ');
INSERT INTO answer VALUES(2365,592,0,'<p><img src=''tc614a.png''></p>',' ');
INSERT INTO answer VALUES(2366,592,1,'<p><img src=''tc614b.png''></p>',' ');
INSERT INTO answer VALUES(2367,592,2,'<p><img src=''tc614c.png''></p>',' ');
INSERT INTO answer VALUES(2368,592,3,'<p><img src=''tc614d.png''></p>',' ');
INSERT INTO answer VALUES(2369,593,0,'<p><img src=''tc615a.png''></p>',' ');
INSERT INTO answer VALUES(2370,593,1,'<p><img src=''tc615b.png''></p>',' ');
INSERT INTO answer VALUES(2371,593,2,'<p><img src=''tc615c.png''></p>',' ');
INSERT INTO answer VALUES(2372,593,3,'<p><img src=''tc615d.png''></p>',' ');
INSERT INTO answer VALUES(2373,594,0,'<p><img src=''tc616a.png''></p>',' ');
INSERT INTO answer VALUES(2374,594,1,'<p><img src=''tc616b.png''></p>',' ');
INSERT INTO answer VALUES(2375,594,2,'<p><img src=''tc616c.png''></p>',' ');
INSERT INTO answer VALUES(2376,594,3,'<p><img src=''tc616d.png''></p>',' ');
INSERT INTO answer VALUES(2377,595,0,'<p><img src=''tc617a.png''></p>',' ');
INSERT INTO answer VALUES(2378,595,1,'<p><img src=''tc617b.png''></p>',' ');
INSERT INTO answer VALUES(2379,595,2,'<p><img src=''tc617c.png''></p>',' ');
INSERT INTO answer VALUES(2380,595,3,'<p><img src=''tc617d.png''></p>',' ');
INSERT INTO answer VALUES(2381,596,0,'940 k&Omega;',' ');
INSERT INTO answer VALUES(2382,596,1,'1 M&Omega;',' ');
INSERT INTO answer VALUES(2383,596,2,'85,5 k&Omega;',' ');
INSERT INTO answer VALUES(2384,596,3,'47 k&Omega;',' ');
INSERT INTO answer VALUES(2385,597,0,'85,5 k&Omega;',' ');
INSERT INTO answer VALUES(2386,597,1,'940 k&Omega;',' ');
INSERT INTO answer VALUES(2387,597,2,'76,4 k&Omega;',' ');
INSERT INTO answer VALUES(2388,597,3,'540 k&Omega;',' ');
INSERT INTO answer VALUES(2389,598,0,'76,4 k&Omega;',' ');
INSERT INTO answer VALUES(2390,598,1,'540 k&Omega;',' ');
INSERT INTO answer VALUES(2391,598,2,'85,5 k&Omega;',' ');
INSERT INTO answer VALUES(2392,598,3,'940 k&Omega;',' ');
INSERT INTO answer VALUES(2393,599,0,'540 k&Omega;',' ');
INSERT INTO answer VALUES(2394,599,1,'76,4 k&Omega;',' ');
INSERT INTO answer VALUES(2395,599,2,'85,5 k&Omega;',' ');
INSERT INTO answer VALUES(2396,599,3,'1,98 k&Omega;',' ');
INSERT INTO answer VALUES(2397,600,0,'1,98 k&Omega;',' ');
INSERT INTO answer VALUES(2398,600,1,'20,0 k&Omega;',' ');
INSERT INTO answer VALUES(2399,600,2,'85,5 k&Omega;',' ');
INSERT INTO answer VALUES(2400,600,3,'2,97 k&Omega;',' ');
INSERT INTO answer VALUES(2401,601,0,'Der Kollektorstrom wird nur durch R<sub>C</sub> begrenzt. Die Kollektorspannung sinkt auf zirka 0,1 Volt.',' ');
INSERT INTO answer VALUES(2402,601,1,'Es fließt Kurzschlussstrom und der Transistor wird zerstört.',' ');
INSERT INTO answer VALUES(2403,601,2,'Es fließt kein Kollektorstrom mehr. Die Kollektorspannung geht auf Betriebsspannung.',' ');
INSERT INTO answer VALUES(2404,601,3,'Der Kollektorstrom steigt stark an. Die Kollektorspannung geht auf Betriebsspannung.',' ');
INSERT INTO answer VALUES(2405,602,0,'Es fließt kein Kollektorstrom mehr. Die Kollektorspannung geht auf Betriebsspannung.',' ');
INSERT INTO answer VALUES(2406,602,1,'Es fließt Kurzschlussstrom und der Transistor wird zerstört.',' ');
INSERT INTO answer VALUES(2407,602,2,'Der Kollektorstrom wird nur durch R<sub>C</sub> begrenzt. Die Kollektorspannung sinkt auf zirka 0,1 Volt.',' ');
INSERT INTO answer VALUES(2408,602,3,'Der Kollektorstrom steigt stark an. Die Kollektorspannung geht auf Betriebsspannung.',' ');
INSERT INTO answer VALUES(2409,603,0,'10',' ');
INSERT INTO answer VALUES(2410,603,1,'1/10',' ');
INSERT INTO answer VALUES(2411,603,2,'1',' ');
INSERT INTO answer VALUES(2412,603,3,'0',' ');
INSERT INTO answer VALUES(2413,604,0,'<p><img src=''tc626a.jpg''></p>',' ');
INSERT INTO answer VALUES(2414,604,1,'<p><img src=''tc626b.jpg''></p>',' ');
INSERT INTO answer VALUES(2415,604,2,'<p><img src=''tc626c.jpg''></p>',' ');
INSERT INTO answer VALUES(2416,604,3,'<p><img src=''tc626d.jpg''></p>',' ');
INSERT INTO answer VALUES(2417,605,0,'eine komplexe Schaltung auf einem Halbleiterkristallblättchen.',' ');
INSERT INTO answer VALUES(2418,605,1,'eine aus einzelnen Bauteilen aufgebaute vergossene Schaltung.',' ');
INSERT INTO answer VALUES(2419,605,2,'eine miniaturisierte, aus SMD-Bauteilen aufgebaute Schaltung.',' ');
INSERT INTO answer VALUES(2420,605,3,'die Zusammenschaltung einzelner Baugruppen zu einem elektronischen Gerät.',' ');
INSERT INTO answer VALUES(2421,606,0,'Ein Gatter verarbeitet binäre Signale nach logischen Grundmustern.',' ');
INSERT INTO answer VALUES(2422,606,1,'Ein Gatter konvertiert digitale Eingangssignale in analoge Ausgangssignale.',' ');
INSERT INTO answer VALUES(2423,606,2,'Ein Gatter ist eine bistabile Kippschaltung, die zwei stabile Zustände (0 und 1) besitzt.',' ');
INSERT INTO answer VALUES(2424,606,3,'Ein Gatter berechnet die Summe oder die Differenz aus zwei binären Ziffern.',' ');
INSERT INTO answer VALUES(2425,607,0,'UND-Glied (AND), ODER-Glied (OR), NICHT-UND-Glied (NAND), NICHT-ODER-Glied (NOR).',' ');
INSERT INTO answer VALUES(2426,607,1,'(+)-Gatter (UND), (-)-Gatter (OR), NICHT-(+)-Gatter (NUND), NICHT-(-)-Gatter (NODER).',' ');
INSERT INTO answer VALUES(2427,607,2,'UND-Glied (UND), ODER-Glied (ODER), NICHT-UND-Glied (NUND), NICHT-ODER-Glied (NODER).',' ');
INSERT INTO answer VALUES(2428,607,3,'UND-Gatter (UNG), ODER-Gatter (ORG), NICHT-UND-Gatter (NUNG), NICHT-ODER-Gatter (NORG).',' ');
INSERT INTO answer VALUES(2429,608,0,'X=0 und Y=0',' ');
INSERT INTO answer VALUES(2430,608,1,'X=0 und Y=1',' ');
INSERT INTO answer VALUES(2431,608,2,'X=1 und Y=0',' ');
INSERT INTO answer VALUES(2432,608,3,'X=1 und Y=1',' ');
INSERT INTO answer VALUES(2433,609,0,'Die Schaltung stellt ein NAND-Gatter [negiertes UND-Gatter] dar. Der Ausgang Z führt dann Nullpotential, wenn die Eingänge A und B mit der Betriebsspannung verbunden sind. In allen anderen Fällen führt der Ausgang Z die Betriebsspannung.',' ');
INSERT INTO answer VALUES(2434,609,1,'Die Schaltung stellt ein NOR-Gatter [negiertes ODER-Gatter] dar. Der Ausgang Z führt dann die Betriebsspannung, wenn keiner der beiden Eingänge A oder B mit der Betriebsspannung verbunden ist. In allen anderen Fällen führt der Ausgang Z Nullpotential.',' ');
INSERT INTO answer VALUES(2435,609,2,'Die Schaltung stellt ein AND-Gatter dar. Der Ausgang Z führt dann Betriebsspannung, wenn die Eingänge A und B mit der Betriebsspannung verbunden sind. In allen anderen Fällen führt der Ausgang Z Nullpotential.',' ');
INSERT INTO answer VALUES(2436,609,3,'Die Schaltung stellt ein OR-Gatter dar. Der Ausgang Z führt dann Nullpotential, wenn die Eingänge A und B mit der Betriebsspannung verbunden sind. In allen anderen Fällen führt der Ausgang Z die Betriebsspannung.',' ');
INSERT INTO answer VALUES(2437,610,0,'Die Schaltung stellt ein NOR-Gatter [negiertes ODER-Gatter] dar. Der Ausgang Z führt dann die Betriebsspannung, wenn beide Eingänge A und B Nullpotential führen bzw. offen sind. In allen anderen Fällen führt der Ausgang Z Nullpotential.',' ');
INSERT INTO answer VALUES(2438,610,1,'Die Schaltung stellt ein NAND-Gatter [negiertes UND-Gatter] dar. Der Ausgang Z führt dann Nullpotential, wenn die Eingänge A und B mit der Betriebsspannung verbunden sind. In allen anderen Fällen führt der Ausgang Z die Betriebsspannung.',' ');
INSERT INTO answer VALUES(2439,610,2,'Die Schaltung stellt ein OR-Gatter dar. Der Ausgang Z führt dann Betriebsspannung, wenn die Eingänge A und B mit der Betriebsspannung verbunden sind. In allen anderen Fällen führt der Ausgang Z Nullpotential.',' ');
INSERT INTO answer VALUES(2440,610,3,'Die Schaltung stellt ein AND-Gatter dar. Der Ausgang Z führt dann Nullpotential, wenn die Eingänge A und B mit der Betriebsspannung verbunden sind. In allen anderen Fällen führt der Ausgang Z die Betriebsspannung.',' ');
INSERT INTO answer VALUES(2441,611,0,'X<sub>1</sub>',' ');
INSERT INTO answer VALUES(2442,611,1,'X<sub>2</sub>',' ');
INSERT INTO answer VALUES(2443,611,2,'X<sub>3</sub>',' ');
INSERT INTO answer VALUES(2444,611,3,'X<sub>4</sub>',' ');
INSERT INTO answer VALUES(2445,612,0,'X<sub>3</sub>',' ');
INSERT INTO answer VALUES(2446,612,1,'X<sub>1</sub>',' ');
INSERT INTO answer VALUES(2447,612,2,'X<sub>2</sub>',' ');
INSERT INTO answer VALUES(2448,612,3,'X<sub>4</sub>',' ');
INSERT INTO answer VALUES(2449,613,0,'X<sub>2</sub>',' ');
INSERT INTO answer VALUES(2450,613,1,'X<sub>1</sub>',' ');
INSERT INTO answer VALUES(2451,613,2,'X<sub>3</sub>',' ');
INSERT INTO answer VALUES(2452,613,3,'X<sub>4</sub>',' ');
INSERT INTO answer VALUES(2453,614,0,'+3 V bis +15 V',' ');
INSERT INTO answer VALUES(2454,614,1,'+2,5 V bis +5,5 V',' ');
INSERT INTO answer VALUES(2455,614,2,'±2,5 bis ±5,5 V',' ');
INSERT INTO answer VALUES(2456,614,3,'± 5 V',' ');
INSERT INTO answer VALUES(2457,615,0,'Operationsverstärker sind gleichstromgekoppelte Verstärker mit sehr hohem Verstärkungsfaktor und großer Linearität.',' ');
INSERT INTO answer VALUES(2458,615,1,'Operationsverstärker sind wechselstromgekoppelte Verstärker mit niedrigem Eingangswiderstand und großer Linearität.',' ');
INSERT INTO answer VALUES(2459,615,2,'Operationsverstärker sind in Empfängerstufen eingebaute Analogverstärker mit sehr niedrigem Verstärkungsfaktor aber großer Linearität.',' ');
INSERT INTO answer VALUES(2460,615,3,'Operationsverstärker sind digitale Schaltkreise mit niedrigem Verstärkungsfaktor aber großer Linearität.',' ');
INSERT INTO answer VALUES(2461,616,0,'Der Eingangswiderstand ist sehr hoch. Der Ausgangswiderstand ist niedrig. Die Spannungsverstärkung ist gleich eins.',' ');
INSERT INTO answer VALUES(2462,616,1,'Der Eingangswiderstand ist sehr hoch. Der Ausgangswiderstand ist niedrig. Die Spannungsverstärkung ist sehr hoch.',' ');
INSERT INTO answer VALUES(2463,616,2,'Der Eingangswiderstand ist niedrig. Der Ausgangswiderstand ist sehr hoch. Die Spannungsverstärkung ist hoch.',' ');
INSERT INTO answer VALUES(2464,616,3,'Der Eingangswiderstand ist sehr niedrig. Der Ausgangswiderstand ist hoch. Die Spannungsverstärkung ist niedrig.',' ');
INSERT INTO answer VALUES(2465,617,0,'10',' ');
INSERT INTO answer VALUES(2466,617,1,'11',' ');
INSERT INTO answer VALUES(2467,617,2,'19,8',' ');
INSERT INTO answer VALUES(2468,617,3,'24,2',' ');
INSERT INTO answer VALUES(2469,618,0,'11',' ');
INSERT INTO answer VALUES(2470,618,1,'10',' ');
INSERT INTO answer VALUES(2471,618,2,'19,8',' ');
INSERT INTO answer VALUES(2472,618,3,'24,2',' ');
INSERT INTO answer VALUES(2473,619,0,'zirka 20 k&Omega;',' ');
INSERT INTO answer VALUES(2474,619,1,'zirka 1 k&Omega;',' ');
INSERT INTO answer VALUES(2475,619,2,'zirka 400 k&Omega;',' ');
INSERT INTO answer VALUES(2476,619,3,'zirka 1,9 k&Omega;',' ');
INSERT INTO answer VALUES(2477,620,0,'<p><img src=''tc716a.jpg''></p>',' ');
INSERT INTO answer VALUES(2478,620,1,'<p><img src=''tc716b.jpg''></p>',' ');
INSERT INTO answer VALUES(2479,620,2,'<p><img src=''tc716c.jpg''></p>',' ');
INSERT INTO answer VALUES(2480,620,3,'<p><img src=''tc716d.jpg''></p>',' ');
INSERT INTO answer VALUES(2481,621,0,'<p><img src=''tc716b.jpg''></p>',' ');
INSERT INTO answer VALUES(2482,621,1,'<p><img src=''tc716a.jpg''></p>',' ');
INSERT INTO answer VALUES(2483,621,2,'<p><img src=''tc716c.jpg''></p>',' ');
INSERT INTO answer VALUES(2484,621,3,'<p><img src=''tc716d.jpg''></p>',' ');
INSERT INTO answer VALUES(2485,622,0,'Das von der Gitterspannung hervorgerufene elektrische Feld steuert den Anodenstrom.',' ');
INSERT INTO answer VALUES(2486,622,1,'Die Anodenspannung steuert das magnetische Feld an der Anode und damit den Anodenstrom.',' ');
INSERT INTO answer VALUES(2487,622,2,'Die Heizspannung steuert das elektrische Feld an der Katode und damit den Anodenstrom.',' ');
INSERT INTO answer VALUES(2488,622,3,'Die Katodenvorspannung steuert das magnetische Feld an der Katode und damit den Gitterstrom.',' ');
INSERT INTO answer VALUES(2489,623,0,'Der Anodenstrom sinkt.',' ');
INSERT INTO answer VALUES(2490,623,1,'Der Anodenstrom steigt.',' ');
INSERT INTO answer VALUES(2491,623,2,'Der Anodenstrom verändert sich nicht.',' ');
INSERT INTO answer VALUES(2492,623,3,'Der Anodenstrom steigt erst und sinkt dann wieder.',' ');
INSERT INTO answer VALUES(2493,624,0,'142.',' ');
INSERT INTO answer VALUES(2494,624,1,'78.',' ');
INSERT INTO answer VALUES(2495,624,2,'156.',' ');
INSERT INTO answer VALUES(2496,624,3,'248.',' ');
INSERT INTO answer VALUES(2497,625,0,'26.',' ');
INSERT INTO answer VALUES(2498,625,1,'11.',' ');
INSERT INTO answer VALUES(2499,625,2,'16.',' ');
INSERT INTO answer VALUES(2500,625,3,'160.',' ');
INSERT INTO answer VALUES(2501,626,0,'32, 16, 8, 4, 2, 1',' ');
INSERT INTO answer VALUES(2502,626,1,'1, 2, 4, 8, 16, 32',' ');
INSERT INTO answer VALUES(2503,626,2,'65536, 256, 16, 4, 2, 1',' ');
INSERT INTO answer VALUES(2504,626,3,'100000, 10000, 1000, 100, 10, 1',' ');
INSERT INTO answer VALUES(2505,627,0,'7,3 k&Omega;',' ');
INSERT INTO answer VALUES(2506,627,1,'4,0 k&Omega;',' ');
INSERT INTO answer VALUES(2507,627,2,'1,8 k&Omega;',' ');
INSERT INTO answer VALUES(2508,627,3,'35 k&Omega;',' ');
INSERT INTO answer VALUES(2509,628,0,'0,01 µF',' ');
INSERT INTO answer VALUES(2510,628,1,'0,09 µF',' ');
INSERT INTO answer VALUES(2511,628,2,'0,001 µF',' ');
INSERT INTO answer VALUES(2512,628,3,'0,009 µF',' ');
INSERT INTO answer VALUES(2513,629,0,'0,065 µF',' ');
INSERT INTO answer VALUES(2514,629,1,'0,650 µF',' ');
INSERT INTO answer VALUES(2515,629,2,'650 nF',' ');
INSERT INTO answer VALUES(2516,629,3,'650 000 pF',' ');
INSERT INTO answer VALUES(2517,630,0,'1532 µH',' ');
INSERT INTO answer VALUES(2518,630,1,'1503 µH',' ');
INSERT INTO answer VALUES(2519,630,2,'1873 nH',' ');
INSERT INTO answer VALUES(2520,630,3,'1873 µH',' ');
INSERT INTO answer VALUES(2521,631,0,'1,873 µH',' ');
INSERT INTO answer VALUES(2522,631,1,'187,3 nH',' ');
INSERT INTO answer VALUES(2523,631,2,'1532 µH',' ');
INSERT INTO answer VALUES(2524,631,3,'1,532 µH',' ');
INSERT INTO answer VALUES(2525,632,0,'10,9 pF',' ');
INSERT INTO answer VALUES(2526,632,1,'0,12 nF',' ');
INSERT INTO answer VALUES(2527,632,2,'4,1 pF',' ');
INSERT INTO answer VALUES(2528,632,3,'40 pF',' ');
INSERT INTO answer VALUES(2529,633,0,'550 &Omega;',' ');
INSERT INTO answer VALUES(2530,633,1,'360 &Omega;',' ');
INSERT INTO answer VALUES(2531,633,2,'1150 &Omega;',' ');
INSERT INTO answer VALUES(2532,633,3,'383 &Omega;',' ');
INSERT INTO answer VALUES(2533,634,0,'U<sub>1</sub> = 5 • U<sub>2</sub>',' ');
INSERT INTO answer VALUES(2534,634,1,'U<sub>1</sub> = 6 • U<sub>2</sub>',' ');
INSERT INTO answer VALUES(2535,634,2,'U<sub>1</sub> = U<sub>2</sub> / 5',' ');
INSERT INTO answer VALUES(2536,634,3,'U<sub>1</sub> = U<sub>2</sub> / 6',' ');
INSERT INTO answer VALUES(2537,635,0,'U<sub>1</sub> = U<sub>2</sub> / 6',' ');
INSERT INTO answer VALUES(2538,635,1,'U<sub>1</sub> = 6 • U<sub>2</sub>',' ');
INSERT INTO answer VALUES(2539,635,2,'U<sub>1</sub> = U<sub>2</sub> / 5',' ');
INSERT INTO answer VALUES(2540,635,3,'U<sub>1</sub> = 5 • U<sub>2</sub>',' ');
INSERT INTO answer VALUES(2541,636,0,'Spannungen, Ströme, Widerstände und Leistungen einzelner Komponenten müssen unter Beachtung der Phasenwinkel geometrisch addiert werden.',' ');
INSERT INTO answer VALUES(2542,636,1,'Spannungen, Ströme, Widerstände und Leistungen einzelner Komponenten müssen unter Beachtung der Thomsonschen Schwingungsgleichung addiert werden.',' ');
INSERT INTO answer VALUES(2543,636,2,'An Stelle des ohmschen Gesetzes tritt bei Blindwiderständen im Wechselstromkreis die Thomsonsche Schwingungsgleichung.',' ');
INSERT INTO answer VALUES(2544,636,3,'Für jede Kombination von R, L und C gelten eigene ohmsche Gesetze.',' ');
INSERT INTO answer VALUES(2545,637,0,'30 V',' ');
INSERT INTO answer VALUES(2546,637,1,'20 V',' ');
INSERT INTO answer VALUES(2547,637,2,'15 V',' ');
INSERT INTO answer VALUES(2548,637,3,'40 V',' ');
INSERT INTO answer VALUES(2549,638,0,'0,5 mA',' ');
INSERT INTO answer VALUES(2550,638,1,'1,0 mA',' ');
INSERT INTO answer VALUES(2551,638,2,'1,6 mA',' ');
INSERT INTO answer VALUES(2552,638,3,'4,5 mA',' ');
INSERT INTO answer VALUES(2553,639,0,'2,5 mW',' ');
INSERT INTO answer VALUES(2554,639,1,'5,0 mW',' ');
INSERT INTO answer VALUES(2555,639,2,'1,5 mW',' ');
INSERT INTO answer VALUES(2556,639,3,'0,15 W',' ');
INSERT INTO answer VALUES(2557,640,0,'5,0 k&Omega;',' ');
INSERT INTO answer VALUES(2558,640,1,'557 &Omega;',' ');
INSERT INTO answer VALUES(2559,640,2,'10,0 k&Omega;',' ');
INSERT INTO answer VALUES(2560,640,3,'2,5 k&Omega;',' ');
INSERT INTO answer VALUES(2561,641,0,'3 W bei Parallel- und bei Reihenschaltung.',' ');
INSERT INTO answer VALUES(2562,641,1,'3 W bei Parallel- und 1 W bei Reihenschaltung.',' ');
INSERT INTO answer VALUES(2563,641,2,'1 W bei Parallel- und 3 W bei Reihenschaltung.',' ');
INSERT INTO answer VALUES(2564,641,3,'1 W bei Parallel- und bei Reihenschaltung.',' ');
INSERT INTO answer VALUES(2565,642,0,'0,3 µF',' ');
INSERT INTO answer VALUES(2566,642,1,'0,255 µF',' ');
INSERT INTO answer VALUES(2567,642,2,'0,027 µF',' ');
INSERT INTO answer VALUES(2568,642,3,'2,73 nF',' ');
INSERT INTO answer VALUES(2569,643,0,'0,027 µF',' ');
INSERT INTO answer VALUES(2570,643,1,'2,73 nF',' ');
INSERT INTO answer VALUES(2571,643,2,'0,3 µF',' ');
INSERT INTO answer VALUES(2572,643,3,'0,255 µF',' ');
INSERT INTO answer VALUES(2573,644,0,'5 nF',' ');
INSERT INTO answer VALUES(2574,644,1,'12,5 nF',' ');
INSERT INTO answer VALUES(2575,644,2,'7,5 nF',' ');
INSERT INTO answer VALUES(2576,644,3,'0,015 nF',' ');
INSERT INTO answer VALUES(2577,645,0,'1,0 µF',' ');
INSERT INTO answer VALUES(2578,645,1,'4400 nF',' ');
INSERT INTO answer VALUES(2579,645,2,'2,5 µF',' ');
INSERT INTO answer VALUES(2580,645,3,'4,0 µF',' ');
INSERT INTO answer VALUES(2581,646,0,'1821 pF',' ');
INSERT INTO answer VALUES(2582,646,1,'66 pF',' ');
INSERT INTO answer VALUES(2583,646,2,'1,6 nF',' ');
INSERT INTO answer VALUES(2584,646,3,'&asymp;1 pF',' ');
INSERT INTO answer VALUES(2585,647,0,'1100 &Omega;.',' ');
INSERT INTO answer VALUES(2586,647,1,'2200 &Omega;.',' ');
INSERT INTO answer VALUES(2587,647,2,'4400 &Omega;.',' ');
INSERT INTO answer VALUES(2588,647,3,'2,2 k&Omega;.',' ');
INSERT INTO answer VALUES(2589,648,0,'266,7 bis 300 &Omega;',' ');
INSERT INTO answer VALUES(2590,648,1,'200 bis 400 &Omega;',' ');
INSERT INTO answer VALUES(2591,648,2,'100 bis 200 &Omega;',' ');
INSERT INTO answer VALUES(2592,648,3,'300 bis 366,7 &Omega;',' ');
INSERT INTO answer VALUES(2593,649,0,'10,2 k&Omega;',' ');
INSERT INTO answer VALUES(2594,649,1,'82,7 k&Omega;',' ');
INSERT INTO answer VALUES(2595,649,2,'12,7 k&Omega;',' ');
INSERT INTO answer VALUES(2596,649,3,'4,5 k&Omega;',' ');
INSERT INTO answer VALUES(2597,650,0,'4,5 k&Omega;',' ');
INSERT INTO answer VALUES(2598,650,1,'31,5 k&Omega;',' ');
INSERT INTO answer VALUES(2599,650,2,'10,2 k&Omega;',' ');
INSERT INTO answer VALUES(2600,650,3,'5,5 k&Omega;',' ');
INSERT INTO answer VALUES(2601,651,0,'eines Serienschwingkreises.',' ');
INSERT INTO answer VALUES(2602,651,1,'eines Parallelschwingkreises.',' ');
INSERT INTO answer VALUES(2603,651,2,'einer Induktivität.',' ');
INSERT INTO answer VALUES(2604,651,3,'einer Kapazität.',' ');
INSERT INTO answer VALUES(2605,652,0,'einen Parallelschwingkreis.',' ');
INSERT INTO answer VALUES(2606,652,1,'einen Kondensator.',' ');
INSERT INTO answer VALUES(2607,652,2,'eine Spule.',' ');
INSERT INTO answer VALUES(2608,652,3,'einen Serienschwingkreis.',' ');
INSERT INTO answer VALUES(2609,653,0,'Der Betrag des induktiven Widerstands ist dann gleich dem Betrag des kapazitiven Widerstands.',' ');
INSERT INTO answer VALUES(2610,653,1,'Der Wert des Verlustwiderstands der Spule ist dann gleich dem Wert des Verlustwiderstands des Kondensators.',' ');
INSERT INTO answer VALUES(2611,653,2,'Die Größe des elektrischen Feldes in der Spule ist dann gleich der Größe des elektrischen Feldes im Kondensators.',' ');
INSERT INTO answer VALUES(2612,653,3,'Die Größe des magnetischen Feldes in der Spule ist dann gleich der Größe des magnetischen Feldes im Kondensator.',' ');
INSERT INTO answer VALUES(2613,654,0,'<p><img src=''td204a.jpg''></p>',' ');
INSERT INTO answer VALUES(2614,654,1,'<p><img src=''td204b.jpg''></p>',' ');
INSERT INTO answer VALUES(2615,654,2,'<p><img src=''td204c.jpg''></p>',' ');
INSERT INTO answer VALUES(2616,654,3,'<p><img src=''td204d.jpg''></p>',' ');
INSERT INTO answer VALUES(2617,655,0,'Ja, die Wicklung des Übertragers dient dann als Schwingkreisinduktivität.',' ');
INSERT INTO answer VALUES(2618,655,1,'Nein, ein Übertrager kann nur Spannungen und Ströme umsetzen.',' ');
INSERT INTO answer VALUES(2619,655,2,'Ja, es geht dann die Summe der Induktivitäten beider Wicklungen des Übertragers ein.',' ');
INSERT INTO answer VALUES(2620,655,3,'Ja, aber zu jeder Wicklung muss ein passend gewählter Kondensator in Reihe geschaltet werden.',' ');
INSERT INTO answer VALUES(2621,656,0,'Die Resonanzfrequenz wird bei 1. und 2. kleiner und bei 3. größer.',' ');
INSERT INTO answer VALUES(2622,656,1,'Die Resonanzfrequenz wird in allen drei Fällen kleiner.',' ');
INSERT INTO answer VALUES(2623,656,2,'Die Resonanzfrequenz wird bei 1. kleiner und bei 2. und 3. größer.',' ');
INSERT INTO answer VALUES(2624,656,3,'Die Resonanzfrequenz wird bei 1. und 2. größer und bei 3. kleiner.',' ');
INSERT INTO answer VALUES(2625,657,0,'117,973 kHz',' ');
INSERT INTO answer VALUES(2626,657,1,'11,797 kHz',' ');
INSERT INTO answer VALUES(2627,657,2,'1,18 kHz',' ');
INSERT INTO answer VALUES(2628,657,3,'1,17973 MHz',' ');
INSERT INTO answer VALUES(2629,658,0,'159,155 kHz',' ');
INSERT INTO answer VALUES(2630,658,1,'15,9155 kHz',' ');
INSERT INTO answer VALUES(2631,658,2,'1,59155 kHz',' ');
INSERT INTO answer VALUES(2632,658,3,'1591,55 kHz',' ');
INSERT INTO answer VALUES(2633,659,0,'14,5288 MHz',' ');
INSERT INTO answer VALUES(2634,659,1,'145,288 MHz',' ');
INSERT INTO answer VALUES(2635,659,2,'1,45288 MHz',' ');
INSERT INTO answer VALUES(2636,659,3,'145,288 kHz',' ');
INSERT INTO answer VALUES(2637,660,0,'61,033 MHz',' ');
INSERT INTO answer VALUES(2638,660,1,'6,1033 MHz',' ');
INSERT INTO answer VALUES(2639,660,2,'610,33 MHz',' ');
INSERT INTO answer VALUES(2640,660,3,'610,33 kHz',' ');
INSERT INTO answer VALUES(2641,661,0,'1,592 MHz',' ');
INSERT INTO answer VALUES(2642,661,1,'159,155 kHz',' ');
INSERT INTO answer VALUES(2643,661,2,'15,915 MHz',' ');
INSERT INTO answer VALUES(2644,661,3,'15,915 kHz',' ');
INSERT INTO answer VALUES(2645,662,0,'gleich dem reellen Widerstand R.',' ');
INSERT INTO answer VALUES(2646,662,1,'unendlich hoch.',' ');
INSERT INTO answer VALUES(2647,662,2,'gleich dem kapazitiven Widerstand X<sub>C</sub>.',' ');
INSERT INTO answer VALUES(2648,662,3,'gleich dem induktiven Widerstand X<sub>L</sub>.',' ');
INSERT INTO answer VALUES(2649,663,0,'318 Hz',' ');
INSERT INTO answer VALUES(2650,663,1,'0,32 Hz',' ');
INSERT INTO answer VALUES(2651,663,2,'318 kHz',' ');
INSERT INTO answer VALUES(2652,663,3,'421 Hz',' ');
INSERT INTO answer VALUES(2653,664,0,'10',' ');
INSERT INTO answer VALUES(2654,664,1,'1',' ');
INSERT INTO answer VALUES(2655,664,2,'0,1',' ');
INSERT INTO answer VALUES(2656,664,3,'100',' ');
INSERT INTO answer VALUES(2657,665,0,'5,5',' ');
INSERT INTO answer VALUES(2658,665,1,'54,8',' ');
INSERT INTO answer VALUES(2659,665,2,'18,2',' ');
INSERT INTO answer VALUES(2660,665,3,'0,18',' ');
INSERT INTO answer VALUES(2661,666,0,'15,9 kHz',' ');
INSERT INTO answer VALUES(2662,666,1,'159,1 kHz',' ');
INSERT INTO answer VALUES(2663,666,2,'1,59 kHz',' ');
INSERT INTO answer VALUES(2664,666,3,'159 Hz',' ');
INSERT INTO answer VALUES(2665,667,0,'2,65 MHz',' ');
INSERT INTO answer VALUES(2666,667,1,'26,5 MHz',' ');
INSERT INTO answer VALUES(2667,667,2,'795,8 kHz',' ');
INSERT INTO answer VALUES(2668,667,3,'79,6 kHz',' ');
INSERT INTO answer VALUES(2669,668,0,'Die Bandbreite ergibt sich aus der Differenz der beiden Frequenzen, bei denen die Spannung auf den 0,7-fachen Wert gegenüber der maximalen Spannung bei der Resonanzfrequenz abgesunken ist.',' ');
INSERT INTO answer VALUES(2670,668,1,'Die Bandbreite ergibt sich aus der Differenz der beiden Frequenzen, bei denen die Spannung auf den 0,5-fachen Wert gegenüber der maximalen Spannung bei der Resonanzfrequenz abgesunken ist.',' ');
INSERT INTO answer VALUES(2671,668,2,'Die Bandbreite ergibt sich aus der Multiplikation der Resonanzfrequenz mit dem Faktor 0,5.',' ');
INSERT INTO answer VALUES(2672,668,3,'Die Bandbreite ergibt sich aus der Multiplikation der Resonanzfrequenz mit dem Faktor 0,7.',' ');
INSERT INTO answer VALUES(2673,669,0,'Hochpass',' ');
INSERT INTO answer VALUES(2674,669,1,'Bandpass',' ');
INSERT INTO answer VALUES(2675,669,2,'Sperrkreis',' ');
INSERT INTO answer VALUES(2676,669,3,'Tiefpass',' ');
INSERT INTO answer VALUES(2677,670,0,'Tiefpass',' ');
INSERT INTO answer VALUES(2678,670,1,'Hochpass',' ');
INSERT INTO answer VALUES(2679,670,2,'Saugkreis',' ');
INSERT INTO answer VALUES(2680,670,3,'Sperrkreis',' ');
INSERT INTO answer VALUES(2681,671,0,'Saugkreis',' ');
INSERT INTO answer VALUES(2682,671,1,'Hochpass',' ');
INSERT INTO answer VALUES(2683,671,2,'Sperrkreis',' ');
INSERT INTO answer VALUES(2684,671,3,'Tiefpass',' ');
INSERT INTO answer VALUES(2685,672,0,'Sperrkreis',' ');
INSERT INTO answer VALUES(2686,672,1,'Hochpass',' ');
INSERT INTO answer VALUES(2687,672,2,'Saugkreis',' ');
INSERT INTO answer VALUES(2688,672,3,'Tiefpass',' ');
INSERT INTO answer VALUES(2689,673,0,'Sperrfilter.',' ');
INSERT INTO answer VALUES(2690,673,1,'Tiefpassfilter.',' ');
INSERT INTO answer VALUES(2691,673,2,'Hochpassfilter.',' ');
INSERT INTO answer VALUES(2692,673,3,'Dämpfungsglied.',' ');
INSERT INTO answer VALUES(2693,674,0,'Es handelt sich um einen Bandpass. Frequenzen oberhalb der oberen Grenzfrequenz und Frequenzen unterhalb der unteren Grenzfrequenz werden bedämpft. Er lässt nur einen bestimmten Frequenzbereich passieren.',' ');
INSERT INTO answer VALUES(2694,674,1,'Es handelt sich um einen Hochpass. Frequenzen unterhalb der Grenzfrequenz werden bedämpft, oberhalb der Grenzfrequenz durchgelassen.',' ');
INSERT INTO answer VALUES(2695,674,2,'Es handelt sich um einen Tiefpass. Frequenzen oberhalb der Grenzfrequenz werden bedämpft, unterhalb der Grenzfrequenz durchgelassen.',' ');
INSERT INTO answer VALUES(2696,674,3,'Es handelt sich um eine Bandsperre. Frequenzen oberhalb der oberen Grenzfrequenz und Frequenzen unterhalb der unteren Grenzfrequenz werden durchgelassen. Sie bedämpft nur einen bestimmten Frequenzbereich.',' ');
INSERT INTO answer VALUES(2697,675,0,'Hochpassfilter.',' ');
INSERT INTO answer VALUES(2698,675,1,'Sperrfilter.',' ');
INSERT INTO answer VALUES(2699,675,2,'Tiefpassfilter.',' ');
INSERT INTO answer VALUES(2700,675,3,'Notchfilter in Verbindung mit einem Hochpassfilter.',' ');
INSERT INTO answer VALUES(2701,676,0,'<p><img src=''td226a.png''></p>',' ');
INSERT INTO answer VALUES(2702,676,1,'<p><img src=''td226b.png''></p>',' ');
INSERT INTO answer VALUES(2703,676,2,'<p><img src=''td226c.png''></p>',' ');
INSERT INTO answer VALUES(2704,676,3,'<p><img src=''td226d.png''></p>',' ');
INSERT INTO answer VALUES(2705,677,0,'Keramik- oder Luftkondensatoren verwendet werden.',' ');
INSERT INTO answer VALUES(2706,677,1,'Aluminium-Elektrolytkondensatoren verwendet werden.',' ');
INSERT INTO answer VALUES(2707,677,2,'Tantal-Elektrolytkondensatoren verwendet werden.',' ');
INSERT INTO answer VALUES(2708,677,3,'Polykarbonatkondensatoren verwendet werden.',' ');
INSERT INTO answer VALUES(2709,678,0,'Die Kopplung, bei der die Resonanzkurve ihre größte Breite hat und dabei am Resonanzmaximum noch völlig eben ist.',' ');
INSERT INTO answer VALUES(2710,678,1,'Die Kopplung, bei der die Resonanzkurve des Bandfilters ihre größtmögliche Breite hat.',' ');
INSERT INTO answer VALUES(2711,678,2,'Die Kopplung, bei der die Resonanzkurve des Bandfilters eine Welligkeit von 3 dB (Höcker- zu Sattelspannung) zeigt.',' ');
INSERT INTO answer VALUES(2712,678,3,'Die Kopplung, bei der die Ausgangspannung des Bandfilters das 0,707-fache der Eingangsspannung erreicht.',' ');
INSERT INTO answer VALUES(2713,679,0,'Bei der c-Kurve ist die Kopplung loser als bei der a-Kurve.',' ');
INSERT INTO answer VALUES(2714,679,1,'Bei der b-Kurve ist die Kopplung loser als bei der c-Kurve.',' ');
INSERT INTO answer VALUES(2715,679,2,'Bei der a-Kurve ist die Kopplung loser als bei der c-Kurve.',' ');
INSERT INTO answer VALUES(2716,679,3,'Bei der b-Kurve ist die Kopplung loser als bei der d-Kurve.',' ');
INSERT INTO answer VALUES(2717,680,0,'Die b-Kurve zeigt kritische, die a-Kurve zeigt überkritische Kopplung.',' ');
INSERT INTO answer VALUES(2718,680,1,'Die a-Kurve zeigt kritische, die b-Kurve zeigt überkritische Kopplung.',' ');
INSERT INTO answer VALUES(2719,680,2,'Die c-Kurve zeigt kritische, die b-Kurve zeigt überkritische Kopplung.',' ');
INSERT INTO answer VALUES(2720,680,3,'Die d-Kurve zeigt kritische, die c-Kurve zeigt überkritische Kopplung.',' ');
INSERT INTO answer VALUES(2721,681,0,'SSB.',' ');
INSERT INTO answer VALUES(2722,681,1,'AM.',' ');
INSERT INTO answer VALUES(2723,681,2,'FM.',' ');
INSERT INTO answer VALUES(2724,681,3,'CW.',' ');
INSERT INTO answer VALUES(2725,682,0,'AM.',' ');
INSERT INTO answer VALUES(2726,682,1,'SSB.',' ');
INSERT INTO answer VALUES(2727,682,2,'FM.',' ');
INSERT INTO answer VALUES(2728,682,3,'CW.',' ');
INSERT INTO answer VALUES(2729,683,0,'FM.',' ');
INSERT INTO answer VALUES(2730,683,1,'SSB.',' ');
INSERT INTO answer VALUES(2731,683,2,'AM.',' ');
INSERT INTO answer VALUES(2732,683,3,'CW.',' ');
INSERT INTO answer VALUES(2733,684,0,'CW.',' ');
INSERT INTO answer VALUES(2734,684,1,'SSB.',' ');
INSERT INTO answer VALUES(2735,684,2,'AM.',' ');
INSERT INTO answer VALUES(2736,684,3,'FM.',' ');
INSERT INTO answer VALUES(2737,685,0,'<p><img src=''td301a.png''></p>',' ');
INSERT INTO answer VALUES(2738,685,1,'<p><img src=''td301b.png''></p>',' ');
INSERT INTO answer VALUES(2739,685,2,'<p><img src=''td301c.png''></p>',' ');
INSERT INTO answer VALUES(2740,685,3,'<p><img src=''td301d.png''></p>',' ');
INSERT INTO answer VALUES(2741,686,0,'<p><img src=''td302a.png''></p>',' ');
INSERT INTO answer VALUES(2742,686,1,'<p><img src=''td302b.png''></p>',' ');
INSERT INTO answer VALUES(2743,686,2,'<p><img src=''td302c.png''></p>',' ');
INSERT INTO answer VALUES(2744,686,3,'<p><img src=''td302d.png''></p>',' ');
INSERT INTO answer VALUES(2745,687,0,'Ja, wenn der Pluspol des Elektrolytkondensators auf der Seite der Diode liegt.',' ');
INSERT INTO answer VALUES(2746,687,1,'Ja, wenn der Minuspol des Elektrolytkondensators auf der Seite der Diode liegt.',' ');
INSERT INTO answer VALUES(2747,687,2,'Nein, da der Kondensator von Wechselstrom durchflossen wird.',' ');
INSERT INTO answer VALUES(2748,687,3,'Nein, da dies auf Grund der technischen Vorschriften nicht zulässig ist.',' ');
INSERT INTO answer VALUES(2749,688,0,'der Einbau eines Netzfilters erforderlich.',' ');
INSERT INTO answer VALUES(2750,688,1,'der Austausch des Netzteils erforderlich.',' ');
INSERT INTO answer VALUES(2751,688,2,'die Entfernung der Erdung und Neuverlegung des Netzanschlusskabels erforderlich.',' ');
INSERT INTO answer VALUES(2752,688,3,'die Benachrichtigung des zuständigen Stromversorgers erforderlich.',' ');
INSERT INTO answer VALUES(2753,689,0,'40,7 Volt.',' ');
INSERT INTO answer VALUES(2754,689,1,'20,3 Volt.',' ');
INSERT INTO answer VALUES(2755,689,2,'28,8 Volt.',' ');
INSERT INTO answer VALUES(2756,689,3,'57,5 Volt.',' ');
INSERT INTO answer VALUES(2757,690,0,'Sinkt die Ausgangsspannung, so erhält Transistor T2 über die Z-Diode Z<sub>1</sub> weniger Strom und leitet dadurch weniger. Durch den verminderten Kollektorstrom von T2 verringert sich der Spannungsabfall an R<sub>1</sub>/R<sub>2</sub> und die Basisspannung von T1 steigt und somit auch die Emitterspannung.',' ');
INSERT INTO answer VALUES(2758,690,1,'Sinkt die Ausgangsspannung bei Belastung, so erhält Transistor T2 über die Z-Diode Z<sub>1</sub> mehr Strom und leitet dadurch stärker. Durch den ansteigenden Kollektorstrom von T2 nimmt der Spannungsabfall an R<sub>1</sub>/R<sub>2</sub> zu. Dabei sinkt die Basisspannung von T1 und die Emitterspannung steigt wieder.',' ');
INSERT INTO answer VALUES(2759,690,2,'Sinkt die Ausgangsspannung, so fließt durch Transistor T1 weniger Strom. Durch den sich vermindernden Kollektorstrom von T1 steigt aber der Spannungsabfall an R<sub>1</sub>/R<sub>2</sub> und die Basisspannung von T2 über die Z-Diode Z<sub>1</sub>. Somit steigt auch die Emitterspannung von T1.',' ');
INSERT INTO answer VALUES(2760,690,3,'Sinkt die Ausgangsspannung bei Belastung, so fließt durch den Transistor T1 mehr Belastungsstrom. Der Transistor T2 erhält über Z<sub>1</sub> weniger Spannung und der Spannungsabfall am Spannungsteiler R<sub>1</sub>/R<sub>2</sub> nimmt zu. Dabei sinkt die Basisspannung von T1 und die Emitterspannung steigt wieder.',' ');
INSERT INTO answer VALUES(2761,691,0,'Parallelgeschalteter Widerstand',' ');
INSERT INTO answer VALUES(2762,691,1,'In Reihe geschalteter Widerstand',' ');
INSERT INTO answer VALUES(2763,691,2,'Parallelgeschaltete zweite Diode',' ');
INSERT INTO answer VALUES(2764,691,3,'Parallelgeschaltete Spule',' ');
INSERT INTO answer VALUES(2765,692,0,'Zur Spannungsstabilisierung',' ');
INSERT INTO answer VALUES(2766,692,1,'Zur Signalbegrenzung',' ');
INSERT INTO answer VALUES(2767,692,2,'Zur Gleichrichtung in Messgeräten',' ');
INSERT INTO answer VALUES(2768,692,3,'Zur elektronischen Umschaltung',' ');
INSERT INTO answer VALUES(2769,693,0,'<p><img src=''td309a.png''></p>',' ');
INSERT INTO answer VALUES(2770,693,1,'<p><img src=''td309b.png''></p>',' ');
INSERT INTO answer VALUES(2771,693,2,'<p><img src=''td309c.png''></p>',' ');
INSERT INTO answer VALUES(2772,693,3,'<p><img src=''td309d.png''></p>',' ');
INSERT INTO answer VALUES(2773,694,0,'Die Eingangsspannung muss deutlich größer als die gewünschte Ausgangsspannung sein (ca. 15%), damit die Ausgangsspannung stabil bleibt.',' ');
INSERT INTO answer VALUES(2774,694,1,'Die Eingangsspannung muss gleich der gewünschten Ausgangsspannung sein, damit eine maximale Stromentnahme am Ausgang erfolgen kann.',' ');
INSERT INTO answer VALUES(2775,694,2,'Die Eingangsspannung muss mindestens doppelt so groß wie die gewünschte Ausgangsspannung sein, damit die Restwelligkeit der Eingangsspannung auf ein Minimum gehalten werden kann.',' ');
INSERT INTO answer VALUES(2776,694,3,'Die Eingangsspannung muss gleich der gewünschten Ausgangsspannung sein, damit eine maximale Unterdrückung der Restwelligkeit der Eingangsspannung am Ausgang eintritt.',' ');
INSERT INTO answer VALUES(2777,695,0,'<p><img src=''td311a.png''></p>',' ');
INSERT INTO answer VALUES(2778,695,1,'<p><img src=''td311b.png''></p>',' ');
INSERT INTO answer VALUES(2779,695,2,'<p><img src=''td311c.png''></p>',' ');
INSERT INTO answer VALUES(2780,695,3,'<p><img src=''td311d.png''></p>',' ');
INSERT INTO answer VALUES(2781,696,0,'5 Volt.',' ');
INSERT INTO answer VALUES(2782,696,1,'11,2 Volt.',' ');
INSERT INTO answer VALUES(2783,696,2,'6,2 Volt.',' ');
INSERT INTO answer VALUES(2784,696,3,'5,6 Volt.',' ');
INSERT INTO answer VALUES(2785,697,0,'143 Volt betragen.',' ');
INSERT INTO answer VALUES(2786,697,1,'72 Volt betragen.',' ');
INSERT INTO answer VALUES(2787,697,2,'90 Volt betragen.',' ');
INSERT INTO answer VALUES(2788,697,3,'51 Volt betragen.',' ');
INSERT INTO answer VALUES(2789,698,0,'90 Volt betragen.',' ');
INSERT INTO answer VALUES(2790,698,1,'143 Volt betragen.',' ');
INSERT INTO answer VALUES(2791,698,2,'63 Volt betragen.',' ');
INSERT INTO answer VALUES(2792,698,3,'32 Volt betragen.',' ');
INSERT INTO answer VALUES(2793,699,0,'<p><img src=''td315a.png''></p>',' ');
INSERT INTO answer VALUES(2794,699,1,'<p><img src=''td315b.png''></p>',' ');
INSERT INTO answer VALUES(2795,699,2,'<p><img src=''td315c.png''></p>',' ');
INSERT INTO answer VALUES(2796,699,3,'<p><img src=''td315d.png''></p>',' ');
INSERT INTO answer VALUES(2797,700,0,'eine genügende HF-Filterung vorzusehen.',' ');
INSERT INTO answer VALUES(2798,700,1,'eine separate Erdung vorzusehen.',' ');
INSERT INTO answer VALUES(2799,700,2,'eine zusätzliche Schmelzsicherung vorzusehen.',' ');
INSERT INTO answer VALUES(2800,700,3,'eine Schutzdiode vorzusehen.',' ');
INSERT INTO answer VALUES(2801,701,0,'Es ist ein elektronischer Schalter zur Pulsweitensteuerung.',' ');
INSERT INTO answer VALUES(2802,701,1,'Er soll bei Überspannung den Transformator schützen.',' ');
INSERT INTO answer VALUES(2803,701,2,'Er wandelt die Wechselspannung in Gleichspannung um.',' ');
INSERT INTO answer VALUES(2804,701,3,'Er dient als Puls-Gleichrichter in dieser Schaltung.',' ');
INSERT INTO answer VALUES(2805,702,0,'Ein Schaltnetzteil erzeugt Oberwellen, die zu Störungen führen können.',' ');
INSERT INTO answer VALUES(2806,702,1,'Ein Schaltnetzteil benötigt einen größeren Transformator.',' ');
INSERT INTO answer VALUES(2807,702,2,'Ein Schaltnetzteil kann keine so hohen Ströme abgeben.',' ');
INSERT INTO answer VALUES(2808,702,3,'Ein Schaltnetzteil hat höhere Verluste.',' ');
INSERT INTO answer VALUES(2809,703,0,'8,9 V',' ');
INSERT INTO answer VALUES(2810,703,1,'6 V',' ');
INSERT INTO answer VALUES(2811,703,2,'18 V',' ');
INSERT INTO answer VALUES(2812,703,3,'14,9 V',' ');
INSERT INTO answer VALUES(2813,704,0,'3 VSS, 100 Hz.',' ');
INSERT INTO answer VALUES(2814,704,1,'3 VSS, 50 Hz.',' ');
INSERT INTO answer VALUES(2815,704,2,'13,5 +1,5 V, 50 Hz.',' ');
INSERT INTO answer VALUES(2816,704,3,'13,5 +1,5 V, 100 Hz.',' ');
INSERT INTO answer VALUES(2817,705,0,'100 Hz',' ');
INSERT INTO answer VALUES(2818,705,1,'50 Hz',' ');
INSERT INTO answer VALUES(2819,705,2,'25 Hz',' ');
INSERT INTO answer VALUES(2820,705,3,'200 Hz',' ');
INSERT INTO answer VALUES(2821,706,0,'<p><img src=''td322a.png''></p>',' ');
INSERT INTO answer VALUES(2822,706,1,'<p><img src=''td322b.png''></p>',' ');
INSERT INTO answer VALUES(2823,706,2,'<p><img src=''td322c.png''></p>',' ');
INSERT INTO answer VALUES(2824,706,3,'<p><img src=''td322d.png''></p>',' ');
INSERT INTO answer VALUES(2825,707,0,'einen Verstärker in Emitterschaltung.',' ');
INSERT INTO answer VALUES(2826,707,1,'einen Verstärker als Emitterfolger.',' ');
INSERT INTO answer VALUES(2827,707,2,'einen Verstärker in Kollektorschaltung.',' ');
INSERT INTO answer VALUES(2828,707,3,'einen Verstärker in Basisschaltung.',' ');
INSERT INTO answer VALUES(2829,708,0,'Einstellung der Basisvorspannung.',' ');
INSERT INTO answer VALUES(2830,708,1,'Reduzierung der Eingangsempfindlichkeit.',' ');
INSERT INTO answer VALUES(2831,708,2,'Verhinderung von Eigenschwingungen.',' ');
INSERT INTO answer VALUES(2832,708,3,'Festlegung der oberen und unteren Grenzfrequenz.',' ');
INSERT INTO answer VALUES(2833,709,0,'Überbrückung des Emitterwiderstandes für das Wechselstromsignal.',' ');
INSERT INTO answer VALUES(2834,709,1,'Verringerung der Verstärkung.',' ');
INSERT INTO answer VALUES(2835,709,2,'Stabilisierung des Arbeitspunktes des Transistors.',' ');
INSERT INTO answer VALUES(2836,709,3,'Einstellung der Vorspannung am Emitter.',' ');
INSERT INTO answer VALUES(2837,710,0,'Sie nimmt ab.',' ');
INSERT INTO answer VALUES(2838,710,1,'Sie bleibt konstant.',' ');
INSERT INTO answer VALUES(2839,710,2,'Sie nimmt zu.',' ');
INSERT INTO answer VALUES(2840,710,3,'Sie fällt auf Null ab.',' ');
INSERT INTO answer VALUES(2841,711,0,'Wechselstromkopplung.',' ');
INSERT INTO answer VALUES(2842,711,1,'Festlegung der oberen Grenzfrequenz.',' ');
INSERT INTO answer VALUES(2843,711,2,'Erzeugung der erforderlichen Phasenverschiebung.',' ');
INSERT INTO answer VALUES(2844,711,3,'Anhebung niederfrequenter Signalanteile.',' ');
INSERT INTO answer VALUES(2845,712,0,'v<sub>U</sub> ist groß (z.B. 100 ... 300) und &phi;=180°.',' ');
INSERT INTO answer VALUES(2846,712,1,'v<sub>U</sub> ist groß (z.B. 100 ... 300) und &phi;=0°.',' ');
INSERT INTO answer VALUES(2847,712,2,'v<sub>U</sub> ist klein (z.B. 0,9 .... 0,98) und &phi;=180°.',' ');
INSERT INTO answer VALUES(2848,712,3,'v<sub>U</sub> ist klein (z.B. 0,9 .... 0,98) und &phi;=0°.',' ');
INSERT INTO answer VALUES(2849,713,0,'r<sub>e</sub> ist klein (z.B. 100 &Omega; ... 5 k&Omega;) und r<sub>a</sub> ist gegenüber r<sub>e</sub> groß (z.B. 5 k&Omega; ... 50 k&Omega;).',' ');
INSERT INTO answer VALUES(2850,713,1,'r<sub>e</sub> ist groß (z.B. 10 k&Omega; ... 200 k&Omega;) und r<sub>a</sub> ist gegenüber r<sub>e</sub> klein (z.B. 4 &Omega; ... 100 &Omega;).',' ');
INSERT INTO answer VALUES(2851,713,2,'r<sub>e</sub> und r<sub>a</sub> sind beide relativ klein (z.B. 20 &Omega; ... 5 k&Omega;).',' ');
INSERT INTO answer VALUES(2852,713,3,'r<sub>e</sub> und r<sub>a</sub> sind beide relativ groß (z.B. 10 k&Omega; ... 200 k&Omega;).',' ');
INSERT INTO answer VALUES(2853,714,0,'einen Verstärker als Emitterfolger.',' ');
INSERT INTO answer VALUES(2854,714,1,'einen Verstärker in Emitterschaltung.',' ');
INSERT INTO answer VALUES(2855,714,2,'einen Oszillator in Kollektorschaltung.',' ');
INSERT INTO answer VALUES(2856,714,3,'eine Stufe in einer Basisschaltung.',' ');
INSERT INTO answer VALUES(2857,715,0,'v<sub>U</sub> ist klein (z.B. 0,9 .... 0,98) und &phi;=0°.',' ');
INSERT INTO answer VALUES(2858,715,1,'v<sub>U</sub> ist groß (z.B. 100 ... 300) und &phi;=0°.',' ');
INSERT INTO answer VALUES(2859,715,2,'v<sub>U</sub> ist klein (z.B. 0,9 .... 0,98) und &phi;=180°.',' ');
INSERT INTO answer VALUES(2860,715,3,'v<sub>U</sub> ist groß (z.B. 100 ... 300) und &phi;=180°.',' ');
INSERT INTO answer VALUES(2861,716,0,'10 k&Omega; ... 200 k&Omega;',' ');
INSERT INTO answer VALUES(2862,716,1,'1 k&Omega; ... 10 k&Omega;',' ');
INSERT INTO answer VALUES(2863,716,2,'100 &Omega; ... 1 k&Omega;',' ');
INSERT INTO answer VALUES(2864,716,3,'4 &Omega; ... 100 &Omega;',' ');
INSERT INTO answer VALUES(2865,717,0,'4 &Omega; ... 100 &Omega;',' ');
INSERT INTO answer VALUES(2866,717,1,'10 k&Omega; ... 50 k&Omega;',' ');
INSERT INTO answer VALUES(2867,717,2,'100 k&Omega; ... 200 k&Omega;',' ');
INSERT INTO answer VALUES(2868,717,3,'100 k&Omega; ... 2 M&Omega;',' ');
INSERT INTO answer VALUES(2869,718,0,'sehr niedrig im Vergleich zur Eingangsimpedanz.',' ');
INSERT INTO answer VALUES(2870,718,1,'in etwa gleich der Eingangsimpedanz und niederohmig.',' ');
INSERT INTO answer VALUES(2871,718,2,'sehr hoch im Vergleich zur Eingangsimpedanz.',' ');
INSERT INTO answer VALUES(2872,718,3,'in etwa gleich der Eingangsimpedanz und hochohmig.',' ');
INSERT INTO answer VALUES(2873,719,0,'Pufferstufe zwischen Oszillator und Last verwendet werden.',' ');
INSERT INTO answer VALUES(2874,719,1,'Spannungsverstärker mit hohem Gewinn verwendet werden.',' ');
INSERT INTO answer VALUES(2875,719,2,'Phasenumkehrstufe verwendet werden.',' ');
INSERT INTO answer VALUES(2876,719,3,'Frequenzvervielfacher verwendet werden.',' ');
INSERT INTO answer VALUES(2877,720,0,'Die zweite Harmonische',' ');
INSERT INTO answer VALUES(2878,720,1,'Die dritte Harmonische',' ');
INSERT INTO answer VALUES(2879,720,2,'Die vierte Harmonische',' ');
INSERT INTO answer VALUES(2880,720,3,'Die fünfte Harmonische',' ');
INSERT INTO answer VALUES(2881,721,0,'Die dritte Harmonische',' ');
INSERT INTO answer VALUES(2882,721,1,'Die zweite Harmonische',' ');
INSERT INTO answer VALUES(2883,721,2,'Die vierte Harmonische',' ');
INSERT INTO answer VALUES(2884,721,3,'Die fünfte Harmonische',' ');
INSERT INTO answer VALUES(2885,722,0,'12 dB',' ');
INSERT INTO answer VALUES(2886,722,1,'3 dB',' ');
INSERT INTO answer VALUES(2887,722,2,'6 dB',' ');
INSERT INTO answer VALUES(2888,722,3,'9 dB',' ');
INSERT INTO answer VALUES(2889,723,0,'11,8 dB.',' ');
INSERT INTO answer VALUES(2890,723,1,'15,2 dB.',' ');
INSERT INTO answer VALUES(2891,723,2,'17,7 dB.',' ');
INSERT INTO answer VALUES(2892,723,3,'23,6 dB.',' ');
INSERT INTO answer VALUES(2893,724,0,'40 W',' ');
INSERT INTO answer VALUES(2894,724,1,'4 W',' ');
INSERT INTO answer VALUES(2895,724,2,'16 W',' ');
INSERT INTO answer VALUES(2896,724,3,'1 W',' ');
INSERT INTO answer VALUES(2897,725,0,'P<sub>1</sub> entspricht C-Betrieb, P<sub>2</sub> entspricht B-Betrieb, P<sub>3</sub> entspricht AB-Betrieb, P<sub>4</sub> entspricht A-Betrieb.',' ');
INSERT INTO answer VALUES(2898,725,1,'P<sub>2</sub> entspricht C-Betrieb, P<sub>3</sub> entspricht B-Betrieb, P<sub>4</sub> entspricht A-Betrieb, P<sub>1</sub> ist kein geeigneter Verstärkerarbeitspunkt.',' ');
INSERT INTO answer VALUES(2899,725,2,'P<sub>2</sub> entspricht A-Betrieb, P<sub>3</sub> entspricht B-Betrieb, P<sub>4</sub> entspricht C-Betrieb, P<sub>1</sub> ist kein geeigneter Verstärkerarbeitspunkt.',' ');
INSERT INTO answer VALUES(2900,725,3,'P<sub>1</sub> entspricht A-Betrieb, P<sub>2</sub> entspricht AB-Betrieb, P<sub>3</sub> entspricht B-Betrieb, P<sub>4</sub> entspricht C-Betrieb.',' ');
INSERT INTO answer VALUES(2901,726,0,'Wirkungsgrad ca. 40 %, geringst möglicher Oberwellenanteil, hoher Ruhestrom.',' ');
INSERT INTO answer VALUES(2902,726,1,'Wirkungsgrad bis zu 70 %, geringer Oberwellenanteil, geringer bis mittlerer Ruhestrom.',' ');
INSERT INTO answer VALUES(2903,726,2,'Wirkungsgrad bis zu 80 %, geringer Oberwellenanteil, sehr geringer Ruhestrom.',' ');
INSERT INTO answer VALUES(2904,726,3,'Wirkungsgrad 80 bis 87 %, hoher Oberwellenanteil, der Ruhestrom ist fast null.',' ');
INSERT INTO answer VALUES(2905,727,0,'Wirkungsgrad bis zu 80 %, geringer Oberwellenanteil, sehr geringer Ruhestrom.',' ');
INSERT INTO answer VALUES(2906,727,1,'Wirkungsgrad bis zu 70 %, geringer Oberwellenanteil, geringer bis mittlerer Ruhestrom.',' ');
INSERT INTO answer VALUES(2907,727,2,'Wirkungsgrad ca. 40 %, geringst möglicher Oberwellenanteil, hoher Ruhestrom.',' ');
INSERT INTO answer VALUES(2908,727,3,'Wirkungsgrad 80 bis 87 %, hoher Oberwellenanteil, der Ruhestrom ist fast null.',' ');
INSERT INTO answer VALUES(2909,728,0,'Wirkungsgrad 80 bis 87 %, hoher Oberwellenanteil, der Ruhestrom ist fast null.',' ');
INSERT INTO answer VALUES(2910,728,1,'Wirkungsgrad bis zu 70 %, geringer Oberwellenanteil, geringer bis mittlerer Ruhestrom.',' ');
INSERT INTO answer VALUES(2911,728,2,'Wirkungsgrad bis zu 80 %, geringer Oberwellenanteil, sehr geringer Ruhestrom.',' ');
INSERT INTO answer VALUES(2912,728,3,'Wirkungsgrad ca. 40 %, geringst möglicher Oberwellenanteil, hoher Ruhestrom.',' ');
INSERT INTO answer VALUES(2913,729,0,'&asymp; 40 Watt',' ');
INSERT INTO answer VALUES(2914,729,1,'&asymp; 80 Watt',' ');
INSERT INTO answer VALUES(2915,729,2,'&asymp; 60 Watt',' ');
INSERT INTO answer VALUES(2916,729,3,'&asymp; 100 Watt',' ');
INSERT INTO answer VALUES(2917,730,0,'&asymp; 80 Watt',' ');
INSERT INTO answer VALUES(2918,730,1,'&asymp; 100 Watt',' ');
INSERT INTO answer VALUES(2919,730,2,'&asymp; 60 Watt',' ');
INSERT INTO answer VALUES(2920,730,3,'&asymp; 40 Watt',' ');
INSERT INTO answer VALUES(2921,731,0,'Bei fast null Ampere',' ');
INSERT INTO answer VALUES(2922,731,1,'Bei etwa 10 bis 20 % des Stromes bei Nennleistung',' ');
INSERT INTO answer VALUES(2923,731,2,'Bei etwa 70 bis 80 % des Stromes bei Nennleistung',' ');
INSERT INTO answer VALUES(2924,731,3,'Bei fast 100 % des Stromes bei Nennleistung',' ');
INSERT INTO answer VALUES(2925,732,0,'40 %',' ');
INSERT INTO answer VALUES(2926,732,1,'25 %',' ');
INSERT INTO answer VALUES(2927,732,2,'15 %',' ');
INSERT INTO answer VALUES(2928,732,3,'10 %',' ');
INSERT INTO answer VALUES(2929,733,0,'Splatter auf benachbarten Frequenzen.',' ');
INSERT INTO answer VALUES(2930,733,1,'parasitären Schwingungen des Verstärkers.',' ');
INSERT INTO answer VALUES(2931,733,2,'Übernahmeverzerrungen bei den Transistoren des Verstärkers.',' ');
INSERT INTO answer VALUES(2932,733,3,'Kreuzmodulation.',' ');
INSERT INTO answer VALUES(2933,734,0,'Bandpassfilter',' ');
INSERT INTO answer VALUES(2934,734,1,'Tiefpassfilter',' ');
INSERT INTO answer VALUES(2935,734,2,'Hochpassfilter',' ');
INSERT INTO answer VALUES(2936,734,3,'Amplitudenbegrenzer',' ');
INSERT INTO answer VALUES(2937,735,0,'Kopplung zwischen Ein- und Ausgang',' ');
INSERT INTO answer VALUES(2938,735,1,'Unzulängliche Verstärkung',' ');
INSERT INTO answer VALUES(2939,735,2,'Zu hohe Restwelligkeit in der Stromversorgung',' ');
INSERT INTO answer VALUES(2940,735,3,'Unzulängliche Regelung der Stromversorgung',' ');
INSERT INTO answer VALUES(2941,736,0,'Breitband-Gegentaktverstärker.',' ');
INSERT INTO answer VALUES(2942,736,1,'selektiven Hochfrequenzverstärker.',' ');
INSERT INTO answer VALUES(2943,736,2,'steuerbaren Zwischenfrequenzverstärker.',' ');
INSERT INTO answer VALUES(2944,736,3,'einstellbaren Frequenzverdoppler.',' ');
INSERT INTO answer VALUES(2945,737,0,'<p><img src=''td431a.png''></p>',' ');
INSERT INTO answer VALUES(2946,737,1,'<p><img src=''td431b.png''></p>',' ');
INSERT INTO answer VALUES(2947,737,2,'<p><img src=''td431c.png''></p>',' ');
INSERT INTO answer VALUES(2948,737,3,'<p><img src=''td431d.png''></p>',' ');
INSERT INTO answer VALUES(2949,738,0,'<p><img src=''td431b.png''></p>',' ');
INSERT INTO answer VALUES(2950,738,1,'<p><img src=''td431a.png''></p>',' ');
INSERT INTO answer VALUES(2951,738,2,'<p><img src=''td431c.png''></p>',' ');
INSERT INTO answer VALUES(2952,738,3,'<p><img src=''td431d.png''></p>',' ');
INSERT INTO answer VALUES(2953,739,0,'Hüllkurvendemodulator zur Demodulation von AM-Signalen.',' ');
INSERT INTO answer VALUES(2954,739,1,'SSB-Modulator.',' ');
INSERT INTO answer VALUES(2955,739,2,'AM-Modulator.',' ');
INSERT INTO answer VALUES(2956,739,3,'Produktdetektor zu Demodulation von SSB Signalen.',' ');
INSERT INTO answer VALUES(2957,740,0,'der Ausgang für eine Regelspannung.',' ');
INSERT INTO answer VALUES(2958,740,1,'der Ausgang für das NF-Signal.',' ');
INSERT INTO answer VALUES(2959,740,2,'der Ausgang für das Oszillatorsignal.',' ');
INSERT INTO answer VALUES(2960,740,3,'der Ausgang für das ZF-Signal.',' ');
INSERT INTO answer VALUES(2961,741,0,'Signal 1',' ');
INSERT INTO answer VALUES(2962,741,1,'Signal 2',' ');
INSERT INTO answer VALUES(2963,741,2,'Signal 3',' ');
INSERT INTO answer VALUES(2964,741,3,'Signal 4',' ');
INSERT INTO answer VALUES(2965,742,0,'Signal 3',' ');
INSERT INTO answer VALUES(2966,742,1,'Signal 2',' ');
INSERT INTO answer VALUES(2967,742,2,'Signal 1',' ');
INSERT INTO answer VALUES(2968,742,3,'Signal 4',' ');
INSERT INTO answer VALUES(2969,743,0,'Flanken-Diskriminator zur Demodulation von FM-Signalen.',' ');
INSERT INTO answer VALUES(2970,743,1,'Produktdetektor zur Demodulation von SSB-Signalen.',' ');
INSERT INTO answer VALUES(2971,743,2,'Ratiodetektor zur Demodulation von FM-Signalen.',' ');
INSERT INTO answer VALUES(2972,743,3,'Synchrondemodulator zur Demodulation von AM-Signalen.',' ');
INSERT INTO answer VALUES(2973,744,0,'Gegentakt-Flanken-Diskriminator zur Demodulation von FM-Signalen.',' ');
INSERT INTO answer VALUES(2974,744,1,'Ratiodetektor zur Demodulation von FM-Signalen.',' ');
INSERT INTO answer VALUES(2975,744,2,'Hüllkurvendemodulator zur Demodulation von AM-Signalen.',' ');
INSERT INTO answer VALUES(2976,744,3,'Produktdetektor zu Demodulation von SSB-Signalen.',' ');
INSERT INTO answer VALUES(2977,745,0,'Phasendiskriminator zur Demodulation von FM-Signalen.',' ');
INSERT INTO answer VALUES(2978,745,1,'Flanken-Diskriminator zur Demodulation von FM-Signalen.',' ');
INSERT INTO answer VALUES(2979,745,2,'Hüllkurvendemodulator zur Demodulation von AM-Signalen.',' ');
INSERT INTO answer VALUES(2980,745,3,'Produktdetektor zu Demodulation von SSB-Signalen.',' ');
INSERT INTO answer VALUES(2981,746,0,'Ratiodetektor zur Demodulation von FM-Signalen.',' ');
INSERT INTO answer VALUES(2982,746,1,'Hüllkurvendemodulator zur Demodulation von AM-Signalen.',' ');
INSERT INTO answer VALUES(2983,746,2,'Produktdetektor zur Demodulation von SSB-Signalen.',' ');
INSERT INTO answer VALUES(2984,746,3,'Flanken-Diskriminator zur Demodulation von FM-Signalen.',' ');
INSERT INTO answer VALUES(2985,747,0,'PLL-FM-Demodulator.',' ');
INSERT INTO answer VALUES(2986,747,1,'SSB-Demodulator mit PLL-gesteuertem BFO.',' ');
INSERT INTO answer VALUES(2987,747,2,'ZF-Verstärker.',' ');
INSERT INTO answer VALUES(2988,747,3,'AM-Modulator.',' ');
INSERT INTO answer VALUES(2989,748,0,'Begrenzerverstärker mit FM-Diskriminator.',' ');
INSERT INTO answer VALUES(2990,748,1,'Produktdetektor zu Demodulation von SSB-Signalen.',' ');
INSERT INTO answer VALUES(2991,748,2,'Modulator zur Erzeugung von SSB-Signalen.',' ');
INSERT INTO answer VALUES(2992,748,3,'Modulator zur Erzeugung von FM-Signalen.',' ');
INSERT INTO answer VALUES(2993,749,0,'Produktdetektor zu Demodulation von SSB-Signalen.',' ');
INSERT INTO answer VALUES(2994,749,1,'Flankendemodulator zur Demodulation von FM-Signalen.',' ');
INSERT INTO answer VALUES(2995,749,2,'Hüllkurvendemodulator zur Demodulation von AM-Signalen.',' ');
INSERT INTO answer VALUES(2996,749,3,'Diskriminator zur Demodulation von FM-Signalen.',' ');
INSERT INTO answer VALUES(2997,750,0,'AM erzeugt.',' ');
INSERT INTO answer VALUES(2998,750,1,'FM erzeugt.',' ');
INSERT INTO answer VALUES(2999,750,2,'NBFM erzeugt.',' ');
INSERT INTO answer VALUES(3000,750,3,'PM erzeugt.',' ');
INSERT INTO answer VALUES(3001,751,0,'AM-Signalen mit unterdrücktem Träger.',' ');
INSERT INTO answer VALUES(3002,751,1,'phasenmodulierten Signalen.',' ');
INSERT INTO answer VALUES(3003,751,2,'frequenzmodulierten Signalen.',' ');
INSERT INTO answer VALUES(3004,751,3,'AM-Signalen.',' ');
INSERT INTO answer VALUES(3005,752,0,'frequenzmodulierten Signalen.',' ');
INSERT INTO answer VALUES(3006,752,1,'phasenmodulierten Signalen.',' ');
INSERT INTO answer VALUES(3007,752,2,'AM-Signalen mit unterdrücktem Träger.',' ');
INSERT INTO answer VALUES(3008,752,3,'AM-Signalen.',' ');
INSERT INTO answer VALUES(3009,753,0,'phasenmodulierten Signalen.',' ');
INSERT INTO answer VALUES(3010,753,1,'AM-Signalen mit unterdrücktem Träger.',' ');
INSERT INTO answer VALUES(3011,753,2,'frequenzmodulierten Signalen.',' ');
INSERT INTO answer VALUES(3012,753,3,'AM-Signalen.',' ');
INSERT INTO answer VALUES(3013,754,0,'einen kapazitiv rückgekoppelten Dreipunkt-Oszillator.',' ');
INSERT INTO answer VALUES(3014,754,1,'einen Hochfrequenzverstärker in Basisschaltung.',' ');
INSERT INTO answer VALUES(3015,754,2,'einen Hochfrequenzverstärker in Emitterschaltung.',' ');
INSERT INTO answer VALUES(3016,754,3,'einen Oberton-Oszillator in Kollektorschaltung.',' ');
INSERT INTO answer VALUES(3017,755,0,'einen induktiv rückgekoppelten LC-Oszillator in Emitterschaltung.',' ');
INSERT INTO answer VALUES(3018,755,1,'einen induktiv rückgekoppelten LC-Oszillator in Basisschaltung.',' ');
INSERT INTO answer VALUES(3019,755,2,'einen Oberton-Oszillator in Basisschaltung.',' ');
INSERT INTO answer VALUES(3020,755,3,'einen Oberton-Oszillator in Emitterschaltung.',' ');
INSERT INTO answer VALUES(3021,756,0,'einen LC-Oszillator in induktiver Dreipunktschaltung.',' ');
INSERT INTO answer VALUES(3022,756,1,'einen LC-Oszillator in kapazitiver Dreipunktschaltung.',' ');
INSERT INTO answer VALUES(3023,756,2,'einen Oberton-Oszillator in Kollektorschaltung.',' ');
INSERT INTO answer VALUES(3024,756,3,'einen Oberton-Oszillator in Emitterschaltung.',' ');
INSERT INTO answer VALUES(3025,757,0,'Kollektorschaltung, in der der Quarz in seiner Grundschwingung betrieben wird.',' ');
INSERT INTO answer VALUES(3026,757,1,'Kollektorschaltung, in der der Quarz in der 3. Oberschwingung betrieben wird.',' ');
INSERT INTO answer VALUES(3027,757,2,'Basisschaltung, in der der Quarz in Parallelresonanz betrieben wird.',' ');
INSERT INTO answer VALUES(3028,757,3,'Basisschaltung, in der der Quarz in Serienresonanz betrieben wird.',' ');
INSERT INTO answer VALUES(3029,758,0,'Basisschaltung, in der der Quarz in Serienresonanz betrieben wird.',' ');
INSERT INTO answer VALUES(3030,758,1,'Basisschaltung, in der der Quarz in Parallelresonanz betrieben wird.',' ');
INSERT INTO answer VALUES(3031,758,2,'Emitterschaltung, in der der Quarz in Parallelresonanz betrieben wird.',' ');
INSERT INTO answer VALUES(3032,758,3,'Emitterschaltung, in der der Quarz in Serienresonanz betrieben wird.',' ');
INSERT INTO answer VALUES(3033,759,0,'Ja, wenn der Schwingkreis für eine der Obertonfrequenzen des Quarzes ausgelegt wird.',' ');
INSERT INTO answer VALUES(3034,759,1,'Nein, weil die Schaltung keinen Frequenzvervielfacher besitzt.',' ');
INSERT INTO answer VALUES(3035,759,2,'Nein, weil der Quarz in Oberton-Oszillatoren immer in Parallelresonanz betrieben werden muss.',' ');
INSERT INTO answer VALUES(3036,759,3,'Nein, Oszillatorschaltungen, die neben dem Quarz noch einen LC-Schwingkreis besitzen, sind als Oberton-Oszillatoren ungeeignet.',' ');
INSERT INTO answer VALUES(3037,760,0,'Ein VCO ist ein spannungsgesteuerter Oszillator [voltage controlled oscillator]. Die Frequenzvariation erfolgt mittels einer spannungsgesteuerten Kapazitätsvariationsdiode.',' ');
INSERT INTO answer VALUES(3038,760,1,'Ein VCO ist ein variabler Steueroszillator [variable control oscillator]. Die Frequenzvariation erfolgt mittels eines Drehkondensators.',' ');
INSERT INTO answer VALUES(3039,760,2,'Ein VCO ist ein von einem Referenzoszillator mitgezogener Oszillator [variable controlled oscillator]. Die Frequenzvariation erfolgt durch Umschaltung der Frequenz des Referenzoszillators.',' ');
INSERT INTO answer VALUES(3040,760,3,'Ein VCO ist ein variabler Quarzoszillator [variable controlled oscillator]. Die Frequenzvariation erfolgt durch Veränderung (ziehen) der Quarzfrequenz mit Abstimmitteln.',' ');
INSERT INTO answer VALUES(3041,761,0,'D angelegt werden.',' ');
INSERT INTO answer VALUES(3042,761,1,'A angelegt werden.',' ');
INSERT INTO answer VALUES(3043,761,2,'C angelegt werden.',' ');
INSERT INTO answer VALUES(3044,761,3,'B angelegt werden.',' ');
INSERT INTO answer VALUES(3045,762,0,'Das an einem Schaltungspunkt betrachtete Oszillatorsignal muss auf dem Signalweg im Oszillator so verstärkt und phasengedreht werden, dass es wieder gleichphasig und mit mindestens der gleichen Amplitude zum selben Punkt zurückgekoppelt wird.',' ');
INSERT INTO answer VALUES(3046,762,1,'Die Grenzfrequenz des verwendeten Verstärkerelements muss mindestens der Schwingfrequenz des Oszillators entsprechen, und das entstehende Eingangssignal muss über den Rückkopplungsweg wieder gegenphasig zum Eingang zurückgeführt werden.',' ');
INSERT INTO answer VALUES(3047,762,2,'Die Schleifenverstärkung des Signalwegs im Oszillator muss kleiner als 1 sein, und das entstehende Oszillatorsignal darf auf dem Rückkopplungsweg nicht in der Phase gedreht werden.',' ');
INSERT INTO answer VALUES(3048,762,3,'Die Schleifenverstärkung des Signalwegs im Oszillator muss größer als 1 sein, und das Ausgangssignal muss über den Rückkopplungsweg in der Phase so gedreht werden, dass es gegenphasig zum Ausgangspunkt zurückgeführt wird.',' ');
INSERT INTO answer VALUES(3049,763,0,'Oszillatoren.',' ');
INSERT INTO answer VALUES(3050,763,1,'Verstärker.',' ');
INSERT INTO answer VALUES(3051,763,2,'FM-Demodulatoren.',' ');
INSERT INTO answer VALUES(3052,763,3,'Modulatoren.',' ');
INSERT INTO answer VALUES(3053,764,0,'Frequenzänderungen des Oszillators z.B. durch zu schwach ausgelegte Stromversorgung.',' ');
INSERT INTO answer VALUES(3054,764,1,'Frequenzänderungen des Oszillators, weil die Tastung auf der falschen Stufe erfolgt.',' ');
INSERT INTO answer VALUES(3055,764,2,'Phasensprung der Oszillatorfrequenz durch zu steile Flanken des Tastsignals.',' ');
INSERT INTO answer VALUES(3056,764,3,'Kontaktprellungen am Tastrelais.',' ');
INSERT INTO answer VALUES(3057,765,0,'Die Frequenz verringert sich.',' ');
INSERT INTO answer VALUES(3058,765,1,'Die Schwingungen reißen ab (Aussetzer).',' ');
INSERT INTO answer VALUES(3059,765,2,'Die Frequenz erhöht sich.',' ');
INSERT INTO answer VALUES(3060,765,3,'Die Frequenz bleibt stabil .',' ');
INSERT INTO answer VALUES(3061,766,0,'Die Frequenz wird erhöht.',' ');
INSERT INTO answer VALUES(3062,766,1,'Die Schwingungen reißen ab (Aussetzer).',' ');
INSERT INTO answer VALUES(3063,766,2,'Die Frequenz wird niedriger.',' ');
INSERT INTO answer VALUES(3064,766,3,'Die Frequenz bleibt stabil.',' ');
INSERT INTO answer VALUES(3065,767,0,'Die VFO-Frequenz wandert nach unten.',' ');
INSERT INTO answer VALUES(3066,767,1,'Die VFO-Frequenz wandert nach oben.',' ');
INSERT INTO answer VALUES(3067,767,2,'Die VFO-Ausgangsspannung nimmt zu.',' ');
INSERT INTO answer VALUES(3068,767,3,'Die VFO-Ausgangsspannung nimmt ab.',' ');
INSERT INTO answer VALUES(3069,768,0,'eine bessere Frequenzstabilität aufweisen.',' ');
INSERT INTO answer VALUES(3070,768,1,'eine breitere Resonanzkurve haben.',' ');
INSERT INTO answer VALUES(3071,768,2,'einen geringeren Anteil an Oberwellen erzeugen.',' ');
INSERT INTO answer VALUES(3072,768,3,'ein sehr viel geringes Seitenbandrauschen erzeugen.',' ');
INSERT INTO answer VALUES(3073,769,0,'Die Frequenzen an den Punkten A und B sind gleich.',' ');
INSERT INTO answer VALUES(3074,769,1,'Die Frequenz an Punkt A ist höher als die Frequenz an Punkt B.',' ');
INSERT INTO answer VALUES(3075,769,2,'Die Frequenzen an den Punkten A und C sind gleich.',' ');
INSERT INTO answer VALUES(3076,769,3,'Die Frequenz an Punkt B ist höher als die Frequenz an Punkt C.',' ');
INSERT INTO answer VALUES(3077,770,0,'den Eigenschaften des eingesetzten Quarzgenerators.',' ');
INSERT INTO answer VALUES(3078,770,1,'der Genauigkeit und Stabilität des verwendeten spannungsgesteuerten Oszillators (VCO).',' ');
INSERT INTO answer VALUES(3079,770,2,'der Genauigkeit der eingesetzten Frequenzteiler.',' ');
INSERT INTO answer VALUES(3080,770,3,'den Eigenschaften des eingesetzten Phasenvergleichers.',' ');
INSERT INTO answer VALUES(3081,771,0,'Bei zu niedriger Grenzfrequenz werden Frequenzabweichungen nicht schnell genug ausgeregelt. Bei zu hoher Grenzfrequenz wird ein Ausgangssignal mit zu vielen Störanteilen erzeugt.',' ');
INSERT INTO answer VALUES(3082,771,1,'Bei zu hoher Grenzfrequenz werden Frequenzabweichungen nicht schnell genug ausgeregelt. Bei zu niedriger Grenzfrequenz wird ein Ausgangssignal mit zu vielen Störanteilen erzeugt.',' ');
INSERT INTO answer VALUES(3083,771,2,'Bei zu hoher Grenzfrequenz stellt sich die Ausgangsfrequenz bei einer Frequenzumschaltung zu langsam, bzw. erst nach mehreren Überschwingern richtig ein. Dies tritt z.B. bei unterschiedlicher Sende- und Empfangsfrequenz beim Betrieb über Relais- oder Digipeater auf.',' ');
INSERT INTO answer VALUES(3084,771,3,'Der Tiefpass in einer PLL kann keinen Einfluss auf das Ausgangssignal ausüben, weil er nur gleichspannungsseitig eingesetzt ist und daher nur auf die Regelspannung wirken kann.',' ');
INSERT INTO answer VALUES(3085,772,0,'Einen VCO, einen Tiefpass und einen Phasenvergleicher',' ');
INSERT INTO answer VALUES(3086,772,1,'Einen VCO, einen Hochpass und einen Phasenvergleicher',' ');
INSERT INTO answer VALUES(3087,772,2,'Einen Phasenvergleicher, einen Tiefpass und einen Frequenzteiler',' ');
INSERT INTO answer VALUES(3088,772,3,'Einen Phasenvergleicher, einen Hochpass und einen Frequenzteiler',' ');
INSERT INTO answer VALUES(3089,773,0,'100 kHz /V',' ');
INSERT INTO answer VALUES(3090,773,1,'250 kHz/V',' ');
INSERT INTO answer VALUES(3091,773,2,'50 kHz /V',' ');
INSERT INTO answer VALUES(3092,773,3,'1 MHz/V',' ');
INSERT INTO answer VALUES(3093,774,0,'960 bis 1120',' ');
INSERT INTO answer VALUES(3094,774,1,'300 bis 857',' ');
INSERT INTO answer VALUES(3095,774,2,'960 bis 857',' ');
INSERT INTO answer VALUES(3096,774,3,'300 bis 1120',' ');
INSERT INTO answer VALUES(3097,775,0,'ca. 4,167 kHz',' ');
INSERT INTO answer VALUES(3098,775,1,'25 kHz',' ');
INSERT INTO answer VALUES(3099,775,2,'300 kHz',' ');
INSERT INTO answer VALUES(3100,775,3,'150 kHz',' ');
INSERT INTO answer VALUES(3101,776,0,'Die Sendeart J3E beansprucht weniger als die halbe Bandbreite der Sendeart A3E.',' ');
INSERT INTO answer VALUES(3102,776,1,'Die Sendeart J3E beansprucht etwas mehr als die halbe Bandbreite der Sendeart A3E.',' ');
INSERT INTO answer VALUES(3103,776,2,'Die Sendeart J3E beansprucht etwa ¼ Bandbreite der Sendeart A3E.',' ');
INSERT INTO answer VALUES(3104,776,3,'Die unterschiedlichen Sendearten lassen keinen Vergleich zu, da sie grundverschieden erzeugt werden.',' ');
INSERT INTO answer VALUES(3105,777,0,'Durch zu steile Flanken der Tastimpulse',' ');
INSERT INTO answer VALUES(3106,777,1,'Durch prellende Kontakte der verwendeten Taste',' ');
INSERT INTO answer VALUES(3107,777,2,'Durch direkte Tastung der Oszillatorstufe',' ');
INSERT INTO answer VALUES(3108,777,3,'Durch ein unterdimensioniertes Netzteil, dessen Spannung beim Auftasten kurzzeitig zusammenbricht',' ');
INSERT INTO answer VALUES(3109,778,0,'800 Hz',' ');
INSERT INTO answer VALUES(3110,778,1,'200 Hz',' ');
INSERT INTO answer VALUES(3111,778,2,'2,3 kHz',' ');
INSERT INTO answer VALUES(3112,778,3,'455 kHz',' ');
INSERT INTO answer VALUES(3113,779,0,'werden Informationen auf einen Träger aufgeprägt.',' ');
INSERT INTO answer VALUES(3114,779,1,'wird einem Träger Informationen entnommen.',' ');
INSERT INTO answer VALUES(3115,779,2,'werden Sprach- und CW-Signale kombiniert.',' ');
INSERT INTO answer VALUES(3116,779,3,'werden dem Signal NF-Komponenten entnommen.',' ');
INSERT INTO answer VALUES(3117,780,0,'<p><img src=''te105a.png''></p>',' ');
INSERT INTO answer VALUES(3118,780,1,'<p><img src=''te105b.png''></p>',' ');
INSERT INTO answer VALUES(3119,780,2,'<p><img src=''te105c.png''></p>',' ');
INSERT INTO answer VALUES(3120,780,3,'<p><img src=''te105d.png''></p>',' ');
INSERT INTO answer VALUES(3121,781,0,'ausgeprägten Splatter-Erscheinungen.',' ');
INSERT INTO answer VALUES(3122,781,1,'Kreuzmodulation.',' ');
INSERT INTO answer VALUES(3123,781,2,'verminderten Seitenbändern.',' ');
INSERT INTO answer VALUES(3124,781,3,'überhöhtem Hub.',' ');
INSERT INTO answer VALUES(3125,782,0,'Durch Vermischung eines starken unerwünschten Signals mit dem Nutzsignal.',' ');
INSERT INTO answer VALUES(3126,782,1,'Wenn eine Harmonische sich selbst vermischt.',' ');
INSERT INTO answer VALUES(3127,782,2,'Durch die Übermodulation eines Verstärkers.',' ');
INSERT INTO answer VALUES(3128,782,3,'Durch Übermodulation oder zu großem Hub.',' ');
INSERT INTO answer VALUES(3129,783,0,'100 % liegen.',' ');
INSERT INTO answer VALUES(3130,783,1,'50 % liegen.',' ');
INSERT INTO answer VALUES(3131,783,2,'75 % liegen.',' ');
INSERT INTO answer VALUES(3132,783,3,'25 % liegen.',' ');
INSERT INTO answer VALUES(3133,784,0,'Einseitenbandmodulation (SSB) und Morsetelegrafie (CW).',' ');
INSERT INTO answer VALUES(3134,784,1,'Frequenzmodulation (FM) und Frequenzumtastung (FSK).',' ');
INSERT INTO answer VALUES(3135,784,2,'Frequenzumtastung (FSK) und Morsetelegrafie (CW).',' ');
INSERT INTO answer VALUES(3136,784,3,'Einseitenbandmodulation (SSB) und Frequenzmodulation (FM).',' ');
INSERT INTO answer VALUES(3137,785,0,'<p><img src=''te110a.png''></p>',' ');
INSERT INTO answer VALUES(3138,785,1,'<p><img src=''te110b.png''></p>',' ');
INSERT INTO answer VALUES(3139,785,2,'<p><img src=''te110c.png''></p>',' ');
INSERT INTO answer VALUES(3140,785,3,'<p><img src=''te110d.png''></p>',' ');
INSERT INTO answer VALUES(3141,786,0,'50 %.',' ');
INSERT INTO answer VALUES(3142,786,1,'33 %.',' ');
INSERT INTO answer VALUES(3143,786,2,'67 %.',' ');
INSERT INTO answer VALUES(3144,786,3,'75 %.',' ');
INSERT INTO answer VALUES(3145,787,0,'45 %.',' ');
INSERT INTO answer VALUES(3146,787,1,'55 %.',' ');
INSERT INTO answer VALUES(3147,787,2,'30 %.',' ');
INSERT INTO answer VALUES(3148,787,3,'75 %.',' ');
INSERT INTO answer VALUES(3149,788,0,'ein typisches Zweiton-SSB-Testsignal.',' ');
INSERT INTO answer VALUES(3150,788,1,'ein typisches Einton-FM-Testsignal.',' ');
INSERT INTO answer VALUES(3151,788,2,'ein typisches 100-%-AM-Signal.',' ');
INSERT INTO answer VALUES(3152,788,3,'ein typisches CW-Signal.',' ');
INSERT INTO answer VALUES(3153,789,0,'F3E, weil hier die wichtige Information nicht in der Amplitude enthalten ist.',' ');
INSERT INTO answer VALUES(3154,789,1,'C3F, weil hier die wichtige Information in der Amplitude des Restseitenbandes enthalten ist.',' ');
INSERT INTO answer VALUES(3155,789,2,'J3E, weil hier die wichtige Information in der Amplitude eines Seitenbandes enthalten ist.',' ');
INSERT INTO answer VALUES(3156,789,3,'A3E, weil hier die wichtige Information in den Amplituden der beiden Seitenbänder enthalten ist.',' ');
INSERT INTO answer VALUES(3157,790,0,'f<sub>mod</sub> &gt; &Delta;F. Die Bandbreite wird im wesentlichen durch f<sub>mod</sub> bestimmt; B &asymp; 2 * f<sub>mod</sub>.',' ');
INSERT INTO answer VALUES(3158,790,1,'f<sub>mod</sub> &lt; &Delta;F. Die Bandbreite wird im wesentlichen durch &Delta;F bestimmt; B &asymp; 2 * &Delta;F.',' ');
INSERT INTO answer VALUES(3159,790,2,'f<sub>mod</sub> &lt; &Delta;F. Die Bandbreite wird im wesentlichen durch m * &Delta;F bestimmt; B &asymp; m * &Delta;F.',' ');
INSERT INTO answer VALUES(3160,790,3,'f<sub>mod</sub> &gt; &Delta;F. Die Bandbreite wird im wesentlichen durch m * f<sub>mod</sub> bestimmt; B &asymp; m * f<sub>mod</sub>.',' ');
INSERT INTO answer VALUES(3161,791,0,'f<sub>mod</sub> &lt; &Delta;F. Die Bandbreite wird im wesentlichen durch &Delta;F bestimmt; B &asymp; 2 * &Delta;F.',' ');
INSERT INTO answer VALUES(3162,791,1,'f<sub>mod</sub> &gt; &Delta;F. Die Bandbreite wird im wesentlichen durch f<sub>mod</sub> bestimmt; B &asymp; 2 * f<sub>mod</sub>.',' ');
INSERT INTO answer VALUES(3163,791,2,'f<sub>mod</sub> &gt; &Delta;F. Die Bandbreite wird im wesentlichen durch m * &Delta;F bestimmt; B &asymp; m * &Delta;F.',' ');
INSERT INTO answer VALUES(3164,791,3,'f<sub>mod</sub> &lt; &Delta;F. Die Bandbreite wird im wesentlichen durch m * f<sub>mod</sub> bestimmt; B &asymp; m * f<sub>mod</sub>.',' ');
INSERT INTO answer VALUES(3165,792,0,'Durch die Größe der Trägerfrequenzauslenkung.',' ');
INSERT INTO answer VALUES(3166,792,1,'Durch die Geschwindigkeit der Trägerfrequenzänderung.',' ');
INSERT INTO answer VALUES(3167,792,2,'Durch die Änderung der Geschwindigkeit des Frequenzhubes.',' ');
INSERT INTO answer VALUES(3168,792,3,'Durch die Größe der Amplitude des HF-Signals.',' ');
INSERT INTO answer VALUES(3169,793,0,'einer unendlichen Anzahl von Seitenfrequenzen.',' ');
INSERT INTO answer VALUES(3170,793,1,'nur zwei Seitenbändern.',' ');
INSERT INTO answer VALUES(3171,793,2,'keinen Seitenbändern.',' ');
INSERT INTO answer VALUES(3172,793,3,'nur einem Seitenband.',' ');
INSERT INTO answer VALUES(3173,794,0,'geringeren Beeinflussung durch Störquellen.',' ');
INSERT INTO answer VALUES(3174,794,1,'geringen Anforderungen an die Bandbreite.',' ');
INSERT INTO answer VALUES(3175,794,2,'größeren Entfernungsüberbrückung.',' ');
INSERT INTO answer VALUES(3176,794,3,'besseren Kreisgüte.',' ');
INSERT INTO answer VALUES(3177,795,0,'dass die HF-Bandbreite zu groß wird.',' ');
INSERT INTO answer VALUES(3178,795,1,'dass die Sendeendstufe übersteuert wird.',' ');
INSERT INTO answer VALUES(3179,795,2,'dass Verzerrungen auf Grund unerwünschter Unterdrückung der Trägerfrequenz auftreten.',' ');
INSERT INTO answer VALUES(3180,795,3,'dass Verzerrungen auf Grund gegenseitiger Auslöschung der Seitenbänder auftreten.',' ');
INSERT INTO answer VALUES(3181,796,0,'Frequenzmodulation zu erzeugen.',' ');
INSERT INTO answer VALUES(3182,796,1,'Zweiseitenbandmodulation zu erzeugen.',' ');
INSERT INTO answer VALUES(3183,796,2,'CW-Signale zu erzeugen.',' ');
INSERT INTO answer VALUES(3184,796,3,'Amplitudenmodulation zu erzeugen.',' ');
INSERT INTO answer VALUES(3185,797,0,'0,417 kHz',' ');
INSERT INTO answer VALUES(3186,797,1,'12,083 MHz',' ');
INSERT INTO answer VALUES(3187,797,2,'5 kHz',' ');
INSERT INTO answer VALUES(3188,797,3,'60 kHz',' ');
INSERT INTO answer VALUES(3189,798,0,'zu Nachbarkanalstörungen.',' ');
INSERT INTO answer VALUES(3190,798,1,'zur Übersteuerung der Sendeendstufe.',' ');
INSERT INTO answer VALUES(3191,798,2,'zu Verzerrungen auf Grund unerwünschter Unterdrückung der Trägerfrequenz.',' ');
INSERT INTO answer VALUES(3192,798,3,'zu Verzerrungen auf Grund gegenseitiger Auslöschung der Seitenbänder.',' ');
INSERT INTO answer VALUES(3193,799,0,'Eine höhere HF-Bandbreite.',' ');
INSERT INTO answer VALUES(3194,799,1,'Eine größere Sprachkomprimierung.',' ');
INSERT INTO answer VALUES(3195,799,2,'Eine stärkere Unterdrückung von FM-Geräuschen.',' ');
INSERT INTO answer VALUES(3196,799,3,'Eine geringere Störung der Nachbarkanäle.',' ');
INSERT INTO answer VALUES(3197,800,0,'einer größeren HF-Bandbreite.',' ');
INSERT INTO answer VALUES(3198,800,1,'einer Erhöhung der Senderausgangsleistung.',' ');
INSERT INTO answer VALUES(3199,800,2,'einer Erhöhung der Amplitude der Trägerfrequenz.',' ');
INSERT INTO answer VALUES(3200,800,3,'einer Reduktion der Amplituden der Seitenbänder.',' ');
INSERT INTO answer VALUES(3201,801,0,'um den Signalrauschabstand am Ausgang zu erhöhen.',' ');
INSERT INTO answer VALUES(3202,801,1,'um die erforderliche Übertragungsbandbreite zu reduzieren.',' ');
INSERT INTO answer VALUES(3203,801,2,'um die tiefen Frequenzen anzuheben.',' ');
INSERT INTO answer VALUES(3204,801,3,'um die hohen Frequenzanteile zu unterdrücken.',' ');
INSERT INTO answer VALUES(3205,802,0,'2,4 kHz',' ');
INSERT INTO answer VALUES(3206,802,1,'1,7 kHz',' ');
INSERT INTO answer VALUES(3207,802,2,'4,8 kHz',' ');
INSERT INTO answer VALUES(3208,802,3,'3,4 kHz',' ');
INSERT INTO answer VALUES(3209,803,0,'hat seine Trägerfrequenz eine Nullstelle.',' ');
INSERT INTO answer VALUES(3210,803,1,'nimmt der Trägerpegel um den Faktor 2,4 zu.',' ');
INSERT INTO answer VALUES(3211,803,2,'verändert sich der Trägerpegel nicht, da es sich um FM handelt.',' ');
INSERT INTO answer VALUES(3212,803,3,'ist der maximale Hub erreicht.',' ');
INSERT INTO answer VALUES(3213,804,0,'In kHz/V',' ');
INSERT INTO answer VALUES(3214,804,1,'Als Modulationsindex',' ');
INSERT INTO answer VALUES(3215,804,2,'Als Hub',' ');
INSERT INTO answer VALUES(3216,804,3,'In Rad/s',' ');
INSERT INTO answer VALUES(3217,805,0,'3 kHz.',' ');
INSERT INTO answer VALUES(3218,805,1,'25 kHz.',' ');
INSERT INTO answer VALUES(3219,805,2,'7,5 kHz.',' ');
INSERT INTO answer VALUES(3220,805,3,'500 Hz.',' ');
INSERT INTO answer VALUES(3221,806,0,'im NF-Bereich zu erzeugen und auf den Mikrofoneingang des Senders zu geben.',' ');
INSERT INTO answer VALUES(3222,806,1,'mit einem digitalen Modulator zu erzeugen und auf den ZF-Eingang des Senders zu geben.',' ');
INSERT INTO answer VALUES(3223,806,2,'mit einem digitalen Modulator zu erzeugen und auf den CW-Eingang des Senders zu geben.',' ');
INSERT INTO answer VALUES(3224,806,3,'im NF-Bereich zu erzeugen und auf den PTT-Eingang des Senders zu geben.',' ');
INSERT INTO answer VALUES(3225,807,0,'ca. 3 kHz',' ');
INSERT INTO answer VALUES(3226,807,1,'ca. 6,6 kHz',' ');
INSERT INTO answer VALUES(3227,807,2,'12,5 kHz',' ');
INSERT INTO answer VALUES(3228,807,3,'25 kHz',' ');
INSERT INTO answer VALUES(3229,808,0,'1200 / 2200 Hz',' ');
INSERT INTO answer VALUES(3230,808,1,'500 / 1750 Hz',' ');
INSERT INTO answer VALUES(3231,808,2,'850 / 1200 kHz',' ');
INSERT INTO answer VALUES(3232,808,3,'300 / 2700 Hz',' ');
INSERT INTO answer VALUES(3233,809,0,'Die Daten werden paketweise gesendet. Der Beginn eines Paketes wird durch ein Synchronisationszeichen eingeleitet. Der Takt wird im Empfänger aus den Daten zurückgewonnen.',' ');
INSERT INTO answer VALUES(3234,809,1,'Die Daten werden paketweise gesendet. Am Anfang erfolgt ein Startzeichen und am Ende ein Stoppzeichen.',' ');
INSERT INTO answer VALUES(3235,809,2,'Die Daten werden parallel ausgesendet. Der Takt wird im Empfänger aus den Daten zurückgewonnen.',' ');
INSERT INTO answer VALUES(3236,809,3,'Die Daten werden seriell ausgesendet. Es ist ein asynchrones Verfahren.',' ');
INSERT INTO answer VALUES(3237,810,0,'Eine Übertragung wird durch eine Synchronisationssequenz eingeleitet. Nach erfolgreicher Synchronisation werden die Pakete aus dem Binärstrom gelesen.',' ');
INSERT INTO answer VALUES(3238,810,1,'Sende- und Empfangsstelle werden mit Hilfe der Netzfrequenz in Gleichtakt gebracht.',' ');
INSERT INTO answer VALUES(3239,810,2,'Sender und Empfänger werden nach jedem einzelnen Zeichen aufeinander synchronisiert. Die Zeichen enthalten Start- und Stoppbit, die zur Synchronisation dienen.',' ');
INSERT INTO answer VALUES(3240,810,3,'Sender und Empfänger synchronisieren ihre Taktfrequenzen mit einem Normalfrequenzsender.',' ');
INSERT INTO answer VALUES(3241,811,0,'12 kHz',' ');
INSERT INTO answer VALUES(3242,811,1,'25 kHz',' ');
INSERT INTO answer VALUES(3243,811,2,'ca. 6,6 kHz',' ');
INSERT INTO answer VALUES(3244,811,3,'ca. 3 kHz',' ');
INSERT INTO answer VALUES(3245,812,0,'Einen geeigneten Transceiver und ein Terminal oder Computersystem',' ');
INSERT INTO answer VALUES(3246,812,1,'Eine IBM-MF-kompatible Tastatur und ein Modem',' ');
INSERT INTO answer VALUES(3247,812,2,'Ein Multifunktionsmikrofon mit DTMF-Tastatur, einen Monitor und ein Modem',' ');
INSERT INTO answer VALUES(3248,812,3,'Einen Up- /Down-Converter und einen Monitor',' ');
INSERT INTO answer VALUES(3249,813,0,'TX-Delay',' ');
INSERT INTO answer VALUES(3250,813,1,'DWAIT',' ');
INSERT INTO answer VALUES(3251,813,2,'RX-Delay',' ');
INSERT INTO answer VALUES(3252,813,3,'Frack',' ');
INSERT INTO answer VALUES(3253,814,0,'vom Einschwingverhalten des Senders und der Zeit bis alle Geräte von Empfang auf Sendung durchgeschaltet haben.',' ');
INSERT INTO answer VALUES(3254,814,1,'vom Einschwingverhalten des Empfängers der Gegenstation und der Anzahl der Benutzer auf der verwendeten Frequenz.',' ');
INSERT INTO answer VALUES(3255,814,2,'von dem im Computer verwendeten Prozessortyp und dessen Taktgeschwindigkeit.',' ');
INSERT INTO answer VALUES(3256,814,3,'von der Zeit bis die Gegenstelle empfangsbereit ist und der Geschwindigkeit des eigenen Computers.',' ');
INSERT INTO answer VALUES(3257,815,0,'Es muss sende- und empfangsseitig den NF-Frequenzbereich von 20 Hz bis 6 kHz möglichst linear übertragen können. Die Zeit für die Sende-Empfangsumschaltung muss so kurz wie möglich sein, z.B. &lt; 10...100 ms.',' ');
INSERT INTO answer VALUES(3258,815,1,'Es muss sende- und empfangsseitig den HF-Frequenzbereich von 300 Hz bis 3,4 kHz möglichst linear übertragen können. Die Zeit für die Sende-Empfangsumschaltung muss zwischen 100...300 ms liegen.',' ');
INSERT INTO answer VALUES(3259,815,2,'Es muss über einen Anschluss für Mikrofon und Lautsprecher verfügen, an dem ein Terminal-Node-Controller (TNC) oder Modem für 9600 Baud angeschlossen werden kann.',' ');
INSERT INTO answer VALUES(3260,815,3,'Es muss den NF-Frequenzbereich um 9600 Hz linear übertragen können und ein TX-Delay von kleiner 1 ms haben.',' ');
INSERT INTO answer VALUES(3261,816,0,'Die Zuführung des Sendesignals könnte z.B. direkt am FM-Modulator einer Sende-ZF-Aufbereitung erfolgen. Der Abgriff des Empfangssignals könnte z.B. an einem geeigneten Punkt direkt am Demodulator erfolgen.',' ');
INSERT INTO answer VALUES(3262,816,1,'Die Zuführung des Sendesignals könnte z.B. am Eingang des Mikrofonverstärkers erfolgen. Der Abgriff des Empfangssignals könnte z.B. unter Verwendung eines zusätzlichen Hochpassfilters direkt am Ausgang des Audioverstärkers erfolgen.',' ');
INSERT INTO answer VALUES(3263,816,2,'Die Zuführung des Sendesignals könnte z.B. über einen geeigneten Punkt am seriellen Bus des Mikrocontrollers erfolgen. Der Abgriff des Empfangssignals könnte an einem geeigneten Punkt direkt am Demodulator erfolgen.',' ');
INSERT INTO answer VALUES(3264,816,3,'Die Zuführung des Sendesignals könnte z.B. über einen geeigneten Punkt am Eingang des Ringmodulators erfolgen. Der Abgriff des Empfangssignals könnte z.B. unter Verwendung eines zusätzlichen Hochpassfilters direkt am Ausgang des Audioverstärkers erfolgen.',' ');
INSERT INTO answer VALUES(3265,817,0,'Anforderungsbezogener Mehrfachzugriff. Die TNC der Teilnehmer werden vom Netzknoten gepollt (angesprochen) und gehen nur nach Aufforderung des Netzknotens auf Sendung.',' ');
INSERT INTO answer VALUES(3266,817,1,'Automatische Bitratenerkennung. Ein Netzknoten stellt sich automatisch auf die Bitrate des Anwenders ein.',' ');
INSERT INTO answer VALUES(3267,817,2,'Automatische Speicherbereichszuweisung bei Digipeatern. Nach Verbindungsaufbau wird der Speicher für Store & Forward Betrieb bereitgestellt.',' ');
INSERT INTO answer VALUES(3268,817,3,'Asynchrone Zusammenführung der Netzzugänge. Die Signale der Teilnehmer und Linkstrecken werden dem Netzknoten asynchron zugeführt.',' ');
INSERT INTO answer VALUES(3269,818,0,'20 kHz',' ');
INSERT INTO answer VALUES(3270,818,1,'12,5 kHz',' ');
INSERT INTO answer VALUES(3271,818,2,'ca. 6,6 kHz',' ');
INSERT INTO answer VALUES(3272,818,3,'ca. 3 kHz',' ');
INSERT INTO answer VALUES(3273,819,0,'ein Rechnersystem bei dem Texte und Daten über Funk eingespeichert und abgerufen werden können.',' ');
INSERT INTO answer VALUES(3274,819,1,'die Softwaresteuerung einer automatischen Funkstelle.',' ');
INSERT INTO answer VALUES(3275,819,2,'eine fernbedient oder automatisch arbeitende Funkstelle die Internetnachrichten zwischenspeichert.',' ');
INSERT INTO answer VALUES(3276,819,3,'eine Zusatzeinrichtung die E-Mails umwandelt und anschließend zwischenspeichert.',' ');
INSERT INTO answer VALUES(3277,820,0,'besteht aus einem Modem und dem Controller für die digitale Aufbereitung der Daten.',' ');
INSERT INTO answer VALUES(3278,820,1,'wandelt nur die Töne in digitale Daten und schickt diese an den PC.',' ');
INSERT INTO answer VALUES(3279,820,2,'wandelt nur die Töne in digitale Daten und schickt diese an den Sender.',' ');
INSERT INTO answer VALUES(3280,820,3,'ist ein Modem (Modulator und Demodulator) für digitale Signale.',' ');
INSERT INTO answer VALUES(3281,821,0,'Weil die Gesamtinformation einer Station in Teilinformationen zerlegt wird, die zeitversetzt gesendet werden, dazwischen ist genügend Zeit für andere Stationen.',' ');
INSERT INTO answer VALUES(3282,821,1,'Weil es sich um digitale Übertragung handelt, die weit weniger störanfällig ist als analoge Übertragung.',' ');
INSERT INTO answer VALUES(3283,821,2,'Weil in dieser Betriebsart das so genannte "Multitasking" möglich ist.',' ');
INSERT INTO answer VALUES(3284,821,3,'Weil bei Packet-Radio die dazu benutzten Frequenzen im so genannten "Timesharing" genutzt werden.',' ');
INSERT INTO answer VALUES(3285,822,0,'Das Zeitintervall zwischen dem Einschalten des Senders und dem Beginn der Datenübertragung.',' ');
INSERT INTO answer VALUES(3286,822,1,'Die Zeit, bis eine gesendete Nachricht beim Empfänger ankommt.',' ');
INSERT INTO answer VALUES(3287,822,2,'Die maximale Zeitspanne, die eine Station senden darf.',' ');
INSERT INTO answer VALUES(3288,822,3,'Die Zeit, die der Funkamateur warten muss, bis er senden darf.',' ');
INSERT INTO answer VALUES(3289,823,0,'Pactor.',' ');
INSERT INTO answer VALUES(3290,823,1,'SSTV.',' ');
INSERT INTO answer VALUES(3291,823,2,'Packet-Radio.',' ');
INSERT INTO answer VALUES(3292,823,3,'RTTY.',' ');
INSERT INTO answer VALUES(3293,824,0,'AFSK, das Sendesignal wird über den Mikrofoneingang zugeführt.',' ');
INSERT INTO answer VALUES(3294,824,1,'AFSK, das Sendesignal wird direkt dem Modulator zugeführt.',' ');
INSERT INTO answer VALUES(3295,824,2,'FSK, das Sendesignal wird über den Mikrofoneingang zugeführt.',' ');
INSERT INTO answer VALUES(3296,824,3,'FSK, das Sendesignal wird direkt dem Modulator zugeführt.',' ');
INSERT INTO answer VALUES(3297,825,0,'5-Bit-Code mit zusätzlichen Start- und Stoppbits.',' ');
INSERT INTO answer VALUES(3298,825,1,'Fernschreibcode, der Fehlerkorrektur verwendet.',' ');
INSERT INTO answer VALUES(3299,825,2,'7-Bit-Code mit Start-, Stopp- und Paritybits.',' ');
INSERT INTO answer VALUES(3300,825,3,'Fernschreibcode, der "Mark" und "Space" verwendet.',' ');
INSERT INTO answer VALUES(3301,826,0,'Pactor besitzt eine Fehlerkorrektur, RTTY nicht.',' ');
INSERT INTO answer VALUES(3302,826,1,'Pactor belegt eine größere Bandbreite als RTTY.',' ');
INSERT INTO answer VALUES(3303,826,2,'Pactor wird auf UKW, RTTY auf Kurzwelle verwendet.',' ');
INSERT INTO answer VALUES(3304,826,3,'Pactor ist ein digitales Verfahren, RTTY analog.',' ');
INSERT INTO answer VALUES(3305,827,0,'einen PC mit Soundkarte und entsprechender Software.',' ');
INSERT INTO answer VALUES(3306,827,1,'einen Fernschreiber.',' ');
INSERT INTO answer VALUES(3307,827,2,'einen RTTY-Microcontroller.',' ');
INSERT INTO answer VALUES(3308,827,3,'eine Zusatzeinrichtung, die RTTY-Signale umwandelt und anschließend zwischenspeichert.',' ');
INSERT INTO answer VALUES(3309,828,0,'PSK31.',' ');
INSERT INTO answer VALUES(3310,828,1,'RTTY.',' ');
INSERT INTO answer VALUES(3311,828,2,'Pactor.',' ');
INSERT INTO answer VALUES(3312,828,3,'Amtor.',' ');
INSERT INTO answer VALUES(3313,829,0,'für Texte und Daten.',' ');
INSERT INTO answer VALUES(3314,829,1,'nur für Texte.',' ');
INSERT INTO answer VALUES(3315,829,2,'für bewegte Bilder.',' ');
INSERT INTO answer VALUES(3316,829,3,'für Audio-Streams.',' ');
INSERT INTO answer VALUES(3317,830,0,'31 Hz',' ');
INSERT INTO answer VALUES(3318,830,1,'500 Hz',' ');
INSERT INTO answer VALUES(3319,830,2,'2,4 kHz',' ');
INSERT INTO answer VALUES(3320,830,3,'3,1 kHz',' ');
INSERT INTO answer VALUES(3321,831,0,'Wasserfalldiagramm',' ');
INSERT INTO answer VALUES(3322,831,1,'Fourieranalyse',' ');
INSERT INTO answer VALUES(3323,831,2,'Schmetterlingsdarstellung',' ');
INSERT INTO answer VALUES(3324,831,3,'Lissajous-Figuren',' ');
INSERT INTO answer VALUES(3325,832,0,'SSTV überträgt Standbilder, ATV bewegte Bilder.',' ');
INSERT INTO answer VALUES(3326,832,1,'SSTV wird auf UKW, ATV auf Kurzwelle verwendet.',' ');
INSERT INTO answer VALUES(3327,832,2,'SSTV belegt eine größere Bandbreite als ATV.',' ');
INSERT INTO answer VALUES(3328,832,3,'SSTV ist schwarzweiß, ATV in Farbe.',' ');
INSERT INTO answer VALUES(3329,833,0,'Bei Halbduplex gibt es nur einen Übertragungskanal, aber es kann durch Umschaltung abwechselnd in beide Richtungen gesendet werden.',' ');
INSERT INTO answer VALUES(3330,833,1,'Bei Duplex gibt es zwei Übertragungskanäle, aber es kann nur durch Umschaltung abwechselnd in beide Richtungen gesendet werden.',' ');
INSERT INTO answer VALUES(3331,833,2,'Bei Simplex gibt es zwei unabhängige Übertragungskanäle.',' ');
INSERT INTO answer VALUES(3332,833,3,'Bei Halbduplex kann nur in eine Richtung gesendet werden.',' ');
INSERT INTO answer VALUES(3333,834,0,'Halbduplex',' ');
INSERT INTO answer VALUES(3334,834,1,'Simplex',' ');
INSERT INTO answer VALUES(3335,834,2,'Duplex',' ');
INSERT INTO answer VALUES(3336,834,3,'Vollduplex',' ');
INSERT INTO answer VALUES(3337,835,0,'32',' ');
INSERT INTO answer VALUES(3338,835,1,'5',' ');
INSERT INTO answer VALUES(3339,835,2,'64',' ');
INSERT INTO answer VALUES(3340,835,3,'128',' ');
INSERT INTO answer VALUES(3341,836,0,'Mit einer niedrigen zweiten ZF erreicht man leicht eine gute Trennschärfe.',' ');
INSERT INTO answer VALUES(3342,836,1,'Das von der Antenne aufgenommene Signal bleibt bis zum Demodulator in seiner Frequenz erhalten.',' ');
INSERT INTO answer VALUES(3343,836,2,'Mit einer hohen ersten ZF erreicht man leicht eine gute Trennschärfe.',' ');
INSERT INTO answer VALUES(3344,836,3,'Mit einer niedrigen zweiten ZF erreicht man leicht eine gute Spiegelselektion.',' ');
INSERT INTO answer VALUES(3345,837,0,'Fähigkeit des Empfängers, schwache Signale zu empfangen.',' ');
INSERT INTO answer VALUES(3346,837,1,'Stabilität des VFO.',' ');
INSERT INTO answer VALUES(3347,837,2,'Bandbreite des HF-Vorverstärkers.',' ');
INSERT INTO answer VALUES(3348,837,3,'Fähigkeit des Empfängers, starke Signale zu unterdrücken.',' ');
INSERT INTO answer VALUES(3349,838,0,'ermöglicht bei großem Abstand zur Empfangsfrequenz eine hohe Spiegelfrequenzunterdrückung.',' ');
INSERT INTO answer VALUES(3350,838,1,'trägt dazu bei, mögliche Beeinflussungen des lokalen Oszillators durch Empfangssignale zu reduzieren.',' ');
INSERT INTO answer VALUES(3351,838,2,'sollte möglichst nahe an der Empfangsfrequenz liegen, um eine gute Spiegelfrequenzunterdrückung zu erreichen.',' ');
INSERT INTO answer VALUES(3352,838,3,'verhindert auf Grund ihrer Höhe, dass durch die Umsetzung auf die zweite Zwischenfrequenz Spiegelfrequenzen auftreten.',' ');
INSERT INTO answer VALUES(3353,839,0,'Die 1. ZF liegt höher als das Doppelte der maximalen Empfangsfrequenz. Nach der Filterung im Roofing-Filter (1. ZF) wird auf die 2. ZF im Bereich um 9 bis 10 MHz heruntergemischt.',' ');
INSERT INTO answer VALUES(3354,839,1,'Die Empfangsfrequenz wird direkt in die NF-Lage heruntergemischt (Direktmischung). Dabei können keine Spiegelfrequenzen auftreten.',' ');
INSERT INTO answer VALUES(3355,839,2,'Die 1. ZF liegt unter der niedrigsten Empfangsfrequenz. Ein Mitlauffilter unterdrückt Spiegelfrequenzen und andere Störfrequenzen.',' ');
INSERT INTO answer VALUES(3356,839,3,'Die 1. ZF liegt im Bereich um 9 bis 10 MHz. Dabei wird beim Abstimmen in Stufen umgeschaltet.',' ');
INSERT INTO answer VALUES(3357,840,0,'Im Filter bei der letzten ZF',' ');
INSERT INTO answer VALUES(3358,840,1,'Im Filter bei der ersten ZF',' ');
INSERT INTO answer VALUES(3359,840,2,'Durch den gegenseitigen Versatz von 2 Filtern bei der zweiten ZF',' ');
INSERT INTO answer VALUES(3360,840,3,'Im NF-Verstärker',' ');
INSERT INTO answer VALUES(3361,841,0,'Mindestens so groß wie die größte benötigte Bandbreite der vorgesehenen Betriebsarten.',' ');
INSERT INTO answer VALUES(3362,841,1,'Mindestens so groß wie die doppelte Bandbreite der jeweiligen Betriebsart.',' ');
INSERT INTO answer VALUES(3363,841,2,'Mindestens so groß wie das breiteste zu empfangende Amateurband.',' ');
INSERT INTO answer VALUES(3364,841,3,'Sie muss den vollen Abstimmbereich des Empfängers umfassen..',' ');
INSERT INTO answer VALUES(3365,842,0,'Mit einem quarzgesteuerten Frequenzmarken-Generator',' ');
INSERT INTO answer VALUES(3366,842,1,'Mit einem LC-Oszillator (Dipmeter)',' ');
INSERT INTO answer VALUES(3367,842,2,'Mit den Oberschwingungen eines 50-Hz-Gleichrichters',' ');
INSERT INTO answer VALUES(3368,842,3,'Mit einem RC-Oszillator',' ');
INSERT INTO answer VALUES(3369,843,0,'124,2 MHz auftreten.',' ');
INSERT INTO answer VALUES(3370,843,1,'134,9 MHz auftreten.',' ');
INSERT INTO answer VALUES(3371,843,2,'280,5 MHz auftreten.',' ');
INSERT INTO answer VALUES(3372,843,3,'156,3 MHz auftreten.',' ');
INSERT INTO answer VALUES(3373,844,0,'49,7 MHz auftreten.',' ');
INSERT INTO answer VALUES(3374,844,1,'39 MHz auftreten.',' ');
INSERT INTO answer VALUES(3375,844,2,'67,3 MHz auftreten.',' ');
INSERT INTO answer VALUES(3376,844,3,'17,6 MHz auftreten.',' ');
INSERT INTO answer VALUES(3377,845,0,'X und Y sind Mischer, Z ist ein Produktdetektor',' ');
INSERT INTO answer VALUES(3378,845,1,'X ist ein Mischer, Y ist ein Produktdetektor, Z ist ein Mischer',' ');
INSERT INTO answer VALUES(3379,845,2,'X und Y sind Produktdetektoren, Z ist ein HF-Mischer',' ');
INSERT INTO answer VALUES(3380,845,3,'X und Y sind Balancemischer, Z ist ein ZF-Verstärker',' ');
INSERT INTO answer VALUES(3381,846,0,'X ist ein VFO, Y ist ein CO und Z ein BFO',' ');
INSERT INTO answer VALUES(3382,846,1,'X ist ein VFO, Y ist ein BFO und Z ein CO',' ');
INSERT INTO answer VALUES(3383,846,2,'X ist ein BFO, Y ist ein CO und Z ein VFO',' ');
INSERT INTO answer VALUES(3384,846,3,'X ist ein BFO, Y ist ein VFO und Z ein CO',' ');
INSERT INTO answer VALUES(3385,847,0,'Der VFO muss bei 38,70 MHz und der CO bei 11,16 MHz schwingen.',' ');
INSERT INTO answer VALUES(3386,847,1,'Der VFO muss bei 10,24 MHz und der CO bei 17,30 MHz schwingen.',' ');
INSERT INTO answer VALUES(3387,847,2,'Der VFO muss bei 38,70 MHz und der CO bei 12,24 MHz schwingen.',' ');
INSERT INTO answer VALUES(3388,847,3,'Der VFO muss bei 28,46 MHz und der CO bei 11,16 MHz schwingen.',' ');
INSERT INTO answer VALUES(3389,848,0,'45,333 und 45,556 MHz',' ');
INSERT INTO answer VALUES(3390,848,1,'45,556 und 45,778 MHz',' ');
INSERT INTO answer VALUES(3391,848,2,'45,111 und 45,333 MHz',' ');
INSERT INTO answer VALUES(3392,848,3,'44,889 und 45,111 MHz',' ');
INSERT INTO answer VALUES(3393,849,0,'44,667 und 44,889 MHz',' ');
INSERT INTO answer VALUES(3394,849,1,'44,444 und 44,667 MHz',' ');
INSERT INTO answer VALUES(3395,849,2,'44,889 und 45,111 MHz',' ');
INSERT INTO answer VALUES(3396,849,3,'45,111 und 45,333 MHz',' ');
INSERT INTO answer VALUES(3397,850,0,'einen 2-m-Konverter für einen KW-Empfänger dar.',' ');
INSERT INTO answer VALUES(3398,850,1,'Teile von Empfangsstufen eines 10-m-Band-Empfängers dar.',' ');
INSERT INTO answer VALUES(3399,850,2,'einen 2-m-Transverter zur Vorschaltung vor einen KW-Empfänger dar.',' ');
INSERT INTO answer VALUES(3400,850,3,'Teile der Senderaufbereitung für das 10-m-Band dar.',' ');
INSERT INTO answer VALUES(3401,851,0,'Die Spiegelfrequenz liegt sehr weit außerhalb des Empfangsbereichs.',' ');
INSERT INTO answer VALUES(3402,851,1,'Filter für 50 MHz haben eine höhere Trennschärfe.',' ');
INSERT INTO answer VALUES(3403,851,2,'Ein solcher Empfänger hat eine höhere Großsignalfestigkeit.',' ');
INSERT INTO answer VALUES(3404,851,3,'Man erhält einen Empfänger für Kurzwelle und gleichzeitig für Ultrakurzwelle.',' ');
INSERT INTO answer VALUES(3405,852,0,'20 bis 47 MHz oder 53…80 MHz',' ');
INSERT INTO answer VALUES(3406,852,1,'20 bis 47 MHz oder 47…74 MHz',' ');
INSERT INTO answer VALUES(3407,852,2,'23 bis 41 MHz oder 53…80 MHz',' ');
INSERT INTO answer VALUES(3408,852,3,'23 bis 41 MHz oder 47…74 MHz',' ');
INSERT INTO answer VALUES(3409,853,0,'VFO: 46,35 MHz; CO1: 41 MHz; CO2: 9,455 MHz',' ');
INSERT INTO answer VALUES(3410,853,1,'VFO: 23,65 MHz; CO1: 59 MHz; CO2: 8,545 MHz',' ');
INSERT INTO answer VALUES(3411,853,2,'VFO: 46,35 MHz; CO1: 41 MHz; CO2: 9,545 MHz',' ');
INSERT INTO answer VALUES(3412,853,3,'VFO: 46,35 MHz; CO1: 51 MHz; CO2: 9,455 MHz',' ');
INSERT INTO answer VALUES(3413,854,0,'einen Transverter für das 2-m-Band dar.',' ');
INSERT INTO answer VALUES(3414,854,1,'einen Empfangskonverter für das 2-m-Band dar.',' ');
INSERT INTO answer VALUES(3415,854,2,'einen Vorverstärker für das 10-m-Band dar.',' ');
INSERT INTO answer VALUES(3416,854,3,'einen Transceiver für das 10-m-Band dar.',' ');
INSERT INTO answer VALUES(3417,855,0,'VCO<sub>1</sub>: 67,5 MHz VCO<sub>2</sub>: 85,5 MHz',' ');
INSERT INTO answer VALUES(3418,855,1,'VCO<sub>1</sub>: 68,5 MHz VCO<sub>2</sub>: 85,5 MHz',' ');
INSERT INTO answer VALUES(3419,855,2,'VCO<sub>1</sub>: 85,5 MHz VCO<sub>2</sub>: 67,5 MHz',' ');
INSERT INTO answer VALUES(3420,855,3,'VCO<sub>1</sub>: 67,5 MHz VCO<sub>2</sub>: 87,5 MHz',' ');
INSERT INTO answer VALUES(3421,856,0,'Möglichst direkt an der VHF-Antenne',' ');
INSERT INTO answer VALUES(3422,856,1,'Möglichst unmittelbar vor dem Empfängereingang',' ');
INSERT INTO answer VALUES(3423,856,2,'Zwischen Senderausgang und Antennenkabel',' ');
INSERT INTO answer VALUES(3424,856,3,'Zwischen Stehwellenmessgerät und Empfängereingang',' ');
INSERT INTO answer VALUES(3425,857,0,'in nächster Nähe zur Empfangsfrequenz.',' ');
INSERT INTO answer VALUES(3426,857,1,'sehr weit über der Empfangsfrequenz.',' ');
INSERT INTO answer VALUES(3427,857,2,'sehr viel tiefer als die Empfangsfrequenz.',' ');
INSERT INTO answer VALUES(3428,857,3,'bei 9 MHz.',' ');
INSERT INTO answer VALUES(3429,858,0,'Es sind die ZF- oder NF-Signale.',' ');
INSERT INTO answer VALUES(3430,858,1,'Es ist das HF-Signal der Eingangsstufe.',' ');
INSERT INTO answer VALUES(3431,858,2,'Es ist das HF-Signal des VFO.',' ');
INSERT INTO answer VALUES(3432,858,3,'Es ist das ZF-Signal des BFO.',' ');
INSERT INTO answer VALUES(3433,859,0,'Verstärkung der HF-und ZF-Stufen.',' ');
INSERT INTO answer VALUES(3434,859,1,'Amplitude des VFO.',' ');
INSERT INTO answer VALUES(3435,859,2,'Amplitude des BFO.',' ');
INSERT INTO answer VALUES(3436,859,3,'Höhe der Versorgungsspannungen.',' ');
INSERT INTO answer VALUES(3437,860,0,'9 MHz und 69 MHz',' ');
INSERT INTO answer VALUES(3438,860,1,'9 MHz und 39 MHz',' ');
INSERT INTO answer VALUES(3439,860,2,'30 MHz und 39 MHz',' ');
INSERT INTO answer VALUES(3440,860,3,'39 MHz und 69 MHz',' ');
INSERT INTO answer VALUES(3441,861,0,'Balancemischer.',' ');
INSERT INTO answer VALUES(3442,861,1,'Mischer mit einem einzelnen FET.',' ');
INSERT INTO answer VALUES(3443,861,2,'Mischer mit einer Varaktordiode.',' ');
INSERT INTO answer VALUES(3444,861,3,'quarzgesteuerter Mischer.',' ');
INSERT INTO answer VALUES(3445,862,0,'9 MHz und 281 MHz',' ');
INSERT INTO answer VALUES(3446,862,1,'127 MHz und 154 MHz',' ');
INSERT INTO answer VALUES(3447,862,2,'272 MHz und 290 MHz',' ');
INSERT INTO answer VALUES(3448,862,3,'140,5 MHz und 281 MHz',' ');
INSERT INTO answer VALUES(3449,863,0,'1. Oszillatorfrequenz: f<sub>o1</sub> = 38,7 MHz<br> 2. Oszillatorfrequenz: f<sub>o2</sub> = 11,15 MHz',' ');
INSERT INTO answer VALUES(3450,863,1,'1. Oszillatorfrequenz: f<sub>o1</sub> = 38,7 MHz<br> 2. Oszillatorfrequenz: f<sub>o2</sub> = 39,15 MHz',' ');
INSERT INTO answer VALUES(3451,863,2,'1. Oszillatorfrequenz: f<sub>o1</sub> = 11,15 MHz<br> 2. Oszillatorfrequenz: f<sub>o2</sub> = 38,7 MHz',' ');
INSERT INTO answer VALUES(3452,863,3,'1. Oszillatorfrequenz: f<sub>o1</sub> = 28,45 MHz<br> 2. Oszillatorfrequenz: f<sub>o2</sub> = 17,75 MHz',' ');
INSERT INTO answer VALUES(3453,864,0,'J3E : 2,2 kHz, F1B : 500 Hz, F3E : 12 kHz',' ');
INSERT INTO answer VALUES(3454,864,1,'J3E : 6 kHz, F1B : 1,5 kHz, F3E : 12 kHz',' ');
INSERT INTO answer VALUES(3455,864,2,'J3E : 2,2 kHz, F1B : 500 Hz, F3E : 3,6 kHz',' ');
INSERT INTO answer VALUES(3456,864,3,'J3E : 3,6 kHz, F1B : 170 Hz, F3E : 120 kHz',' ');
INSERT INTO answer VALUES(3457,865,0,'Um eine S-Stufe',' ');
INSERT INTO answer VALUES(3458,865,1,'Um zwei S-Stufen',' ');
INSERT INTO answer VALUES(3459,865,2,'Um vier S-Stufen',' ');
INSERT INTO answer VALUES(3460,865,3,'Um acht S-Stufen.',' ');
INSERT INTO answer VALUES(3461,866,0,'Sie erzeugen zusammen die notwendige Rückkopplungsspannung für einen LC-Oszillator.',' ');
INSERT INTO answer VALUES(3462,866,1,'Sie erzeugen zusammen die notwendige Rückkopplungsspannung für eine Audionschaltung.',' ');
INSERT INTO answer VALUES(3463,866,2,'C<sub>3</sub> stabilisiert die Basisvorspannung und C<sub>4</sub> die Emittervorspannung.',' ');
INSERT INTO answer VALUES(3464,866,3,'C<sub>3</sub> kompensiert die Basis-Kollektor-Kapazität und C<sub>4</sub> die Basis-Emitter-Kapazität',' ');
INSERT INTO answer VALUES(3465,867,0,'Sie sorgt für eine stabile Versorgungsspannung, damit die Oszillatorfrequenz stabil bleibt.',' ');
INSERT INTO answer VALUES(3466,867,1,'Sie zeigt das korrekte Einschwingen des Oszillators an.',' ');
INSERT INTO answer VALUES(3467,867,2,'Sie sorgt für eine konstante Ausgangsamplitude des Oszillators über den gesamten Abstimmbereich von C1.',' ');
INSERT INTO answer VALUES(3468,867,3,'Sie ermöglicht eine Frequenzmodulation des Oszillators.',' ');
INSERT INTO answer VALUES(3469,868,0,'gut gefiltert und entkoppelt werden.',' ');
INSERT INTO answer VALUES(3470,868,1,'möglichst spannungsfest angekoppelt werden.',' ');
INSERT INTO answer VALUES(3471,868,2,'möglichst temperaturabhängig sein.',' ');
INSERT INTO answer VALUES(3472,868,3,'im HF-Bereich nicht gefiltert werden.',' ');
INSERT INTO answer VALUES(3473,869,0,'zur Einstellung der Trägerunterdrückung nach Betrag und Phase.',' ');
INSERT INTO answer VALUES(3474,869,1,'zum Ausgleich von Frequenzgang- und Laufzeitunterschieden.',' ');
INSERT INTO answer VALUES(3475,869,2,'zur Einstellung des Frequenzhubes mit Hilfe der ersten Trägernullstelle.',' ');
INSERT INTO answer VALUES(3476,869,3,'zur Einstellung des Modulationsgrades der erzeugten AM-Signale.',' ');
INSERT INTO answer VALUES(3477,870,0,'Schaltungspunkt D',' ');
INSERT INTO answer VALUES(3478,870,1,'Schaltungspunkt A',' ');
INSERT INTO answer VALUES(3479,870,2,'Schaltungspunkt B',' ');
INSERT INTO answer VALUES(3480,870,3,'Schaltungspunkt C',' ');
INSERT INTO answer VALUES(3481,871,0,'NF-Verstärker',' ');
INSERT INTO answer VALUES(3482,871,1,'Mikrofonverstärker',' ');
INSERT INTO answer VALUES(3483,871,2,'HF-Verstärker',' ');
INSERT INTO answer VALUES(3484,871,3,'Tongenerator',' ');
INSERT INTO answer VALUES(3485,872,0,'Zur Widerstandsanpassung',' ');
INSERT INTO answer VALUES(3486,872,1,'Zur Spannungsverstärkung',' ');
INSERT INTO answer VALUES(3487,872,2,'Zur Leistungsverstärkung',' ');
INSERT INTO answer VALUES(3488,872,3,'Zur Verstärkungssteuerung',' ');
INSERT INTO answer VALUES(3489,873,0,'AM-Detektor.',' ');
INSERT INTO answer VALUES(3490,873,1,'FM-Diskriminator.',' ');
INSERT INTO answer VALUES(3491,873,2,'ZF-Modulator.',' ');
INSERT INTO answer VALUES(3492,873,3,'AGC-Gleichrichter.',' ');
INSERT INTO answer VALUES(3493,874,0,'die zwei Seitenbänder.',' ');
INSERT INTO answer VALUES(3494,874,1,'viele Mischprodukte.',' ');
INSERT INTO answer VALUES(3495,874,2,'einen verringerten Träger plus Seitenbänder.',' ');
INSERT INTO answer VALUES(3496,874,3,'den vollständigen Träger.',' ');
INSERT INTO answer VALUES(3497,875,0,'<p><img src=''tf319a.png''></p>',' ');
INSERT INTO answer VALUES(3498,875,1,'<p><img src=''tf319b.png''></p>',' ');
INSERT INTO answer VALUES(3499,875,2,'<p><img src=''tf319c.png''></p>',' ');
INSERT INTO answer VALUES(3500,875,3,'<p><img src=''tf319d.png''></p>',' ');
INSERT INTO answer VALUES(3501,876,0,'Notchfilter',' ');
INSERT INTO answer VALUES(3502,876,1,'Dämpfungsglied',' ');
INSERT INTO answer VALUES(3503,876,2,'Hochpass',' ');
INSERT INTO answer VALUES(3504,876,3,'Sperrfilter',' ');
INSERT INTO answer VALUES(3505,877,0,'0°.',' ');
INSERT INTO answer VALUES(3506,877,1,'90°.',' ');
INSERT INTO answer VALUES(3507,877,2,'18