BEGIN;
DROP TABLE IF EXISTS topic;
DROP TABLE IF EXISTS category;
DROP TABLE IF EXISTS question;
DROP TABLE IF EXISTS answer;
DROP TABLE IF EXISTS question_to_category;
DROP TABLE IF EXISTS question_to_topic;
DROP TABLE IF EXISTS category_to_topic;
DROP TABLE IF EXISTS topic_exam_settings;
DROP TABLE IF EXISTS outdated_questions;

CREATE TABLE topic (_id INT NOT NULL PRIMARY KEY, order_index INT NOT NULL UNIQUE, name TEXT NOT NULL, isprimary INT);
CREATE TABLE category (_id INT NOT NULL PRIMARY KEY, name TEXT NOT NULL, reference TEXT NOT NULL, isprimary INT, parent INT REFERENCES category(_id));
CREATE TABLE question (_id INT NOT NULL PRIMARY KEY, reference TEXT, question TEXT NOT NULL, level INT NOT NULL, next_time INT NOT NULL, wrong INT, correct INT, help TEXT);
CREATE TABLE answer (_id INT NOT NULL PRIMARY KEY, question_id INT NOT NULL REFERENCES question(_id), order_index INT, answer TEXT NOT NULL, help TEXT);
CREATE TABLE question_to_category (_id INT NOT NULL PRIMARY KEY, question_id INT NOT NULL REFERENCES question(_id), category_id INT NOT NULL REFERENCES category(_id));
CREATE TABLE question_to_topic (_id INT NOT NULL PRIMARY KEY, question_id INT NOT NULL REFERENCES question(_id), topic_id INT NOT NULL REFERENCES topic(_id));
CREATE TABLE category_to_topic (_id INT NOT NULL PRIMARY KEY, category_id INT NOT NULL REFERENCES category(_id), topic_id INT NOT NULL REFERENCES topic(_id));
CREATE TABLE topic_exam_settings (_id INT NOT NULL PRIMARY KEY, topic_id INT NOT NULL REFERENCES topic(_id), number_questions INT, number_questions_pass INT, seconds_available INT);
CREATE TABLE outdated_questions (_id INT NOT NULL PRIMARY KEY, question_id INT NOT NULL REFERENCES question(_id), outdated_since INT NOT NULL);

INSERT INTO topic VALUES (1, 1, 'Technische Kenntnisse (Klasse E)', 1);
INSERT INTO topic VALUES (2, 2, 'Technische Kenntnisse (Klasse A)', 1);
INSERT INTO topic VALUES (3, 3, 'Betriebliche Kenntnisse', 1);
INSERT INTO topic VALUES (4, 4, 'Kenntnisse von Vorschriften', 1);
INSERT INTO topic VALUES (5, 5, 'Klasse E alle (Technik, Betrieb, Vorschriften)', 0);
INSERT INTO category VALUES (1, 'Technische Kenntnisse (Klasse E)', 'T', 1, 0);
INSERT INTO category VALUES (2, 'Allgemeine mathematische Grundkenntnisse und Größen', 'A', 0, 1);
INSERT INTO category VALUES (3, 'Allgemeine mathematische Grundkenntnisse', '1', 0, 2);
INSERT INTO category VALUES (4, 'Größen und Einheiten', '2', 0, 2);
INSERT INTO category VALUES (5, 'Elektrizitäts-, Elektromagnetismus- und Funktheorie', 'B', 0, 1);
INSERT INTO category VALUES (6, 'Leiter, Halbleiter und Isolator', '1', 0, 5);
INSERT INTO category VALUES (7, 'Strom- und Spannungsquellen', '2', 0, 5);
INSERT INTO category VALUES (8, 'Elektrisches Feld', '3', 0, 5);
INSERT INTO category VALUES (9, 'Magnetisches Feld', '4', 0, 5);
INSERT INTO category VALUES (10, 'Elektromagnetisches Feld', '5', 0, 5);
INSERT INTO category VALUES (11, 'Sinusförmige Signale', '6', 0, 5);
INSERT INTO category VALUES (12, 'Nichtsinusförmige Signale', '7', 0, 5);
INSERT INTO category VALUES (13, 'Modulierte Signale', '8', 0, 5);
INSERT INTO category VALUES (14, 'Ohmsches Gesetz, Leistung und Energie', '9', 0, 5);
INSERT INTO category VALUES (15, 'Elektrische und elektronische Bauteile', 'C', 0, 1);
INSERT INTO category VALUES (16, 'Widerstand', '1', 0, 15);
INSERT INTO category VALUES (17, 'Kondensator', '2', 0, 15);
INSERT INTO category VALUES (18, 'Spule', '3', 0, 15);
INSERT INTO category VALUES (19, 'Übertrager und Transformatoren', '4', 0, 15);
INSERT INTO category VALUES (20, 'Diode', '5', 0, 15);
INSERT INTO category VALUES (21, 'Transistor', '6', 0, 15);
INSERT INTO category VALUES (22, 'Elektronische Schaltungen und deren Merkmale', 'D', 0, 1);
INSERT INTO category VALUES (23, 'Serien- und Parallelschaltung von Widerständen, Spulen und Kondensatoren', '1', 0, 22);
INSERT INTO category VALUES (24, 'Schwingkreise und Filter', '2', 0, 22);
INSERT INTO category VALUES (25, 'Stromversorgung', '3', 0, 22);
INSERT INTO category VALUES (26, 'Verstärker', '4', 0, 22);
INSERT INTO category VALUES (27, 'Modulator / Demodulator', '5', 0, 22);
INSERT INTO category VALUES (28, 'Oszillator', '6', 0, 22);
INSERT INTO category VALUES (29, 'Analoge und digitale Modulationsverfahren', 'E', 0, 1);
INSERT INTO category VALUES (30, 'Amplitudenmodulation AM, SSB', '1', 0, 29);
INSERT INTO category VALUES (31, 'Frequenzmodulation', '2', 0, 29);
INSERT INTO category VALUES (32, 'Text-, Daten- und Bildübertragung', '3', 0, 29);
INSERT INTO category VALUES (33, 'Funk-Empfänger', 'F', 0, 1);
INSERT INTO category VALUES (34, 'Einfach- und Doppelüberlagerungsempfänger', '1', 0, 33);
INSERT INTO category VALUES (35, 'Blockschaltbilder', '2', 0, 33);
INSERT INTO category VALUES (36, 'Betrieb und Funktionsweise einzelner Stufen', '3', 0, 33);
INSERT INTO category VALUES (37, 'Empfängermerkmale', '4', 0, 33);
INSERT INTO category VALUES (38, 'Funksender', 'G', 0, 1);
INSERT INTO category VALUES (39, 'Blockschaltbilder', '1', 0, 38);
INSERT INTO category VALUES (40, 'Betrieb und Funktionsweise einzelner Stufen', '2', 0, 38);
INSERT INTO category VALUES (41, 'Betrieb und Funktionsweise von HF-Leistungsverstärkern', '3', 0, 38);
INSERT INTO category VALUES (42, 'Betrieb und Funktionsweise von HF-Transceivern', '4', 0, 38);
INSERT INTO category VALUES (43, 'Unerwünschte Aussendungen', '5', 0, 38);
INSERT INTO category VALUES (44, 'Antennen und Übertragungsleitungen', 'H', 0, 1);
INSERT INTO category VALUES (45, 'Antennen', '1', 0, 44);
INSERT INTO category VALUES (46, 'Antennenmerkmale ´', '2', 0, 44);
INSERT INTO category VALUES (47, 'Übertragungsleitungen', '3', 0, 44);
INSERT INTO category VALUES (48, 'Anpassung, Transformation und Symmetrierung', '4', 0, 44);
INSERT INTO category VALUES (49, 'Wellenausbreitung und Ionosphäre', 'I', 0, 1);
INSERT INTO category VALUES (50, 'Ionosphäre', '1', 0, 49);
INSERT INTO category VALUES (51, 'Kurzwellenausbreitung', '2', 0, 49);
INSERT INTO category VALUES (52, 'Wellenausbreitung oberhalb 30 MHz', '3', 0, 49);
INSERT INTO category VALUES (53, 'Messungen und Messinstrumente', 'J', 0, 1);
INSERT INTO category VALUES (54, 'Messinstrumente', '1', 0, 53);
INSERT INTO category VALUES (55, 'Durchführung von Messungen', '2', 0, 53);
INSERT INTO category VALUES (56, 'Störemissionen, Störfestigkeit, Schutzanforderungen, Ursachen, Abhilfe', 'K', 0, 1);
INSERT INTO category VALUES (57, 'Störungen elektronischer Geräte', '1', 0, 56);
INSERT INTO category VALUES (58, 'Ursachen für Störungen', '2', 0, 56);
INSERT INTO category VALUES (59, 'Maßnahmen zur Störungsbeseitigung', '3', 0, 56);
INSERT INTO category VALUES (60, 'Elektromagnetische Verträglichkeit, Anwendung, Personen- und Sachschutz', 'L', 0, 1);
INSERT INTO category VALUES (61, 'Störfestigkeit', '1', 0, 60);
INSERT INTO category VALUES (62, 'Schutz von Personen', '2', 0, 60);
INSERT INTO category VALUES (63, 'Sicherheit', '3', 0, 60);
INSERT INTO category VALUES (64, 'Technische Kenntnisse (Klasse A)', 'T', 1, 0);
INSERT INTO category VALUES (65, 'Allgemeine mathematische Grundkenntnisse und Größen', 'A', 0, 64);
INSERT INTO category VALUES (66, 'Größen und Einheiten', '1', 0, 65);
INSERT INTO category VALUES (67, 'Elektrizitäts-, Elektromagnetismus- und Funktheorie', 'B', 0, 64);
INSERT INTO category VALUES (68, 'Leiter, Halbleiter und Isolator', '1', 0, 67);
INSERT INTO category VALUES (69, 'Strom- und Spannungsquellen', '2', 0, 67);
INSERT INTO category VALUES (70, 'Elektrisches Feld', '3', 0, 67);
INSERT INTO category VALUES (71, 'Magnetisches Feld', '4', 0, 67);
INSERT INTO category VALUES (72, 'Elektromagnetisches Feld', '5', 0, 67);
INSERT INTO category VALUES (73, 'Sinusförmige Signale', '6', 0, 67);
INSERT INTO category VALUES (74, 'Nichtsinusförmige Signale', '7', 0, 67);
INSERT INTO category VALUES (75, 'Modulierte Signale', '8', 0, 67);
INSERT INTO category VALUES (76, 'Leistung und Energie', '9', 0, 67);
INSERT INTO category VALUES (77, 'Elektrische und elektronische Bauteile', 'C', 0, 64);
INSERT INTO category VALUES (78, 'Widerstand', '1', 0, 77);
INSERT INTO category VALUES (79, 'Kondensator', '2', 0, 77);
INSERT INTO category VALUES (80, 'Spule', '3', 0, 77);
INSERT INTO category VALUES (81, 'Übertrager und Transformatoren', '4', 0, 77);
INSERT INTO category VALUES (82, 'Diode', '5', 0, 77);
INSERT INTO category VALUES (83, 'Transistor', '6', 0, 77);
INSERT INTO category VALUES (84, 'Einfache digitale und analoge Schaltkreise und sonstige Bauelemente', '7', 0, 77);
INSERT INTO category VALUES (85, 'Elektronische Schaltungen und deren Merkmale', 'D', 0, 64);
INSERT INTO category VALUES (86, 'Reihen- und Parallelschaltung von Widerständen, Spulen und Kondensatoren', '1', 0, 85);
INSERT INTO category VALUES (87, 'Schwingkreise und Filter', '2', 0, 85);
INSERT INTO category VALUES (88, 'Stromversorgung', '3', 0, 85);
INSERT INTO category VALUES (89, 'Verstärker', '4', 0, 85);
INSERT INTO category VALUES (90, 'Modulator / Demodulator', '5', 0, 85);
INSERT INTO category VALUES (91, 'Oszillator', '6', 0, 85);
INSERT INTO category VALUES (92, 'Phasenregelkreise', '7', 0, 85);
INSERT INTO category VALUES (93, 'Analoge und digitale Modulationsverfahren', 'E', 0, 64);
INSERT INTO category VALUES (94, 'Amplitudenmodulation', '1', 0, 93);
INSERT INTO category VALUES (95, 'Frequenzmodulation', '2', 0, 93);
INSERT INTO category VALUES (96, 'Text- und Daten- und Bildübertragung', '3', 0, 93);
INSERT INTO category VALUES (97, 'Funk-Empfänger', 'F', 0, 64);
INSERT INTO category VALUES (98, 'Einfach- und Doppelsuperhet-Empfänger', '1', 0, 97);
INSERT INTO category VALUES (99, 'Blockschaltbilder', '2', 0, 97);
INSERT INTO category VALUES (100, 'Betrieb und Funktionsweise einzelner Stufen', '3', 0, 97);
INSERT INTO category VALUES (101, 'Empfängermerkmale', '4', 0, 97);
INSERT INTO category VALUES (102, 'Digitale Signalverarbeitung', '5', 0, 97);
INSERT INTO category VALUES (103, 'Sender', 'G', 0, 64);
INSERT INTO category VALUES (104, 'Blockschaltbilder', '1', 0, 103);
INSERT INTO category VALUES (105, 'Betrieb und Funktionsweise einzelner Stufen', '2', 0, 103);
INSERT INTO category VALUES (106, 'Betrieb und Funktionsweise von HF-Leistungsverstärkern', '3', 0, 103);
INSERT INTO category VALUES (107, 'Betrieb und Funktionsweise von HF-Transceivern', '4', 0, 103);
INSERT INTO category VALUES (108, 'Unerwünschte Aussendungen', '5', 0, 103);
INSERT INTO category VALUES (109, 'Antennen und Übertragungsleitungen', 'H', 0, 64);
INSERT INTO category VALUES (110, 'Antennen', '1', 0, 109);
INSERT INTO category VALUES (111, 'Antennenmerkmale', '2', 0, 109);
INSERT INTO category VALUES (112, 'Übertragungsleitungen Anmerkung: Zur Lösung einiger, der folgenden Fragen ist im Formelanhang ein Diagramm mit den Grunddämpfungen verschiedener gebräuchlicher Koaxialleitungen enthalten.', '3', 0, 109);
INSERT INTO category VALUES (113, 'Anpassung, Transformation und Symmetrierung', '4', 0, 109);
INSERT INTO category VALUES (114, 'Wellenausbreitung, Ionosphäre', 'I', 0, 64);
INSERT INTO category VALUES (115, 'Ionosphäre', '1', 0, 114);
INSERT INTO category VALUES (116, 'Kurzwellenausbreitung', '2', 0, 114);
INSERT INTO category VALUES (117, 'Wellenausbreitung oberhalb 30 MHz', '3', 0, 114);
INSERT INTO category VALUES (118, 'Messungen und Messinstrumente', 'J', 0, 64);
INSERT INTO category VALUES (119, 'Strom- und Spannungsmesser', '1', 0, 118);
INSERT INTO category VALUES (120, 'Dipmeter', '2', 0, 118);
INSERT INTO category VALUES (121, 'Oszilloskop', '3', 0, 118);
INSERT INTO category VALUES (122, 'Stehwellenmessgerät', '4', 0, 118);
INSERT INTO category VALUES (123, 'Frequenzzähler', '5', 0, 118);
INSERT INTO category VALUES (124, 'Absorptionsfrequenzmesser', '6', 0, 118);
INSERT INTO category VALUES (125, 'Sonstige Messgeräte und Messmittel', '7', 0, 118);
INSERT INTO category VALUES (126, 'Durchführung von Messungen', '8', 0, 118);
INSERT INTO category VALUES (127, 'Störemissionen, Störfestigkeit, Schutzanforderungen, Ursachen, Abhilfe', 'K', 0, 64);
INSERT INTO category VALUES (128, 'Störungen elektronischer Geräte', '1', 0, 127);
INSERT INTO category VALUES (129, 'Ursachen für Störungen und störende Beeinflussungen', '2', 0, 127);
INSERT INTO category VALUES (130, 'Maßnahmen gegen Störungen und störende Beeinflussungen', '3', 0, 127);
INSERT INTO category VALUES (131, 'Elektromagnetische Verträglichkeit und deren Anwendung, Personen- und Sachschutz', 'L', 0, 64);
INSERT INTO category VALUES (132, 'Störfestigkeit', '1', 0, 131);
INSERT INTO category VALUES (133, 'Schutz von Personen', '2', 0, 131);
INSERT INTO category VALUES (134, 'Sicherheit', '3', 0, 131);
INSERT INTO category VALUES (135, 'Betriebliche Kenntnisse', 'B', 1, 0);
INSERT INTO category VALUES (136, 'Internationales Buchstabieralphabet', 'A', 0, 135);
INSERT INTO category VALUES (137, 'Betriebliche Abkürzungen, Q-Schlüssel, Signalbeurteilung, Sendearten', 'B', 0, 135);
INSERT INTO category VALUES (138, 'Betriebliche Abkürzungen', '1', 0, 137);
INSERT INTO category VALUES (139, 'Q-Schlüssel', '2', 0, 137);
INSERT INTO category VALUES (140, 'Signalbeurteilung', '3', 0, 137);
INSERT INTO category VALUES (141, 'Bezeichnung der Aussendungen (Sendearten)', '4', 0, 137);
INSERT INTO category VALUES (142, 'Frequenzbereiche und IARU-Bandpläne', 'C', 0, 135);
INSERT INTO category VALUES (143, 'Frequenzbereiche des Amateurfunkdienstes', '1', 0, 142);
INSERT INTO category VALUES (144, 'IARU-Bandpläne', '2', 0, 142);
INSERT INTO category VALUES (145, 'Rufzeichen, Landeskenner', 'D', 0, 135);
INSERT INTO category VALUES (146, 'Deutsche Rufzeichen', '1', 0, 145);
INSERT INTO category VALUES (147, 'Europäische Landeskenner', '2', 0, 145);
INSERT INTO category VALUES (148, 'Internationale Landeskenner', '3', 0, 145);
INSERT INTO category VALUES (149, 'Abwicklung des Amateurfunkverkehrs', 'E', 0, 135);
INSERT INTO category VALUES (150, 'Betriebsabwicklung, allgemein', '1', 0, 149);
INSERT INTO category VALUES (151, 'Betriebsabwicklung, speziell', '2', 0, 149);
INSERT INTO category VALUES (152, 'Betriebsabwicklung bei besonderen Betriebsarten', '3', 0, 149);
INSERT INTO category VALUES (153, 'Relaisfunkstellen, Transponder, Satelliten, Baken', '4', 0, 149);
INSERT INTO category VALUES (154, 'Notfunkverkehr und Nachrichtenverkehr bei Naturkatastrophen', 'F', 0, 135);
INSERT INTO category VALUES (155, 'Stationstagebuch, QSL-Karte', 'G', 0, 135);
INSERT INTO category VALUES (156, 'Kenntnisse von Vorschriften', 'V', 1, 0);
INSERT INTO category VALUES (157, 'Vollzugsordnung für den Funkdienst der Internationalen Fernmeldeunion (ITU)', 'A', 0, 156);
INSERT INTO category VALUES (158, 'Definition des Amateurfunkdienstes und des Amateurfunkdienstes über Satelliten', '1', 0, 157);
INSERT INTO category VALUES (159, 'Definition der Amateurfunkstelle', '2', 0, 157);
INSERT INTO category VALUES (160, 'Artikel 25', '3', 0, 157);
INSERT INTO category VALUES (161, 'Weitere Regelungen', '4', 0, 157);
INSERT INTO category VALUES (162, 'Regelungen der CEPT (Europäische Konferenz der Verwaltungen für Post und Telekommunikation) Hinweis: „ECC“ der Ausschuss für elektronische Kommunikation der CEPT. „ERC“ ist der Europäische Ausschuss für Funkangelegenheiten der CEPT. Der ERC ist die Vorgängerorganisation des ECC.', 'B', 0, 156);
INSERT INTO category VALUES (163, 'Amateurfunkgesetz (AFuG)', 'C', 0, 156);
INSERT INTO category VALUES (164, 'Amateurfunkverordnung (AFuV)', 'D', 0, 156);
INSERT INTO category VALUES (165, 'Allgemeines', '1', 0, 164);
INSERT INTO category VALUES (166, 'Rufzeichen, Rufzeichenanwendung', '2', 0, 164);
INSERT INTO category VALUES (167, 'Ausbildungsfunkbetrieb', '3', 0, 164);
INSERT INTO category VALUES (168, 'Klubstationen', '4', 0, 164);
INSERT INTO category VALUES (169, 'Relaisfunkstellen und Funkbaken', '5', 0, 164);
INSERT INTO category VALUES (170, 'Frequenzbereiche und Frequenznutzungsparameter für den Amateurfunk', 'E', 0, 156);
INSERT INTO category VALUES (171, 'Telekommunikationsgesetz (TKG)', 'F', 0, 156);
INSERT INTO category VALUES (172, 'Gesetz über die elektromagnetische Verträglichkeit von Geräten (EMVG), Störfälle', 'G', 0, 156);
INSERT INTO category VALUES (173, 'Gesetz über Funkanlagen und Telekommunikationsendeinrichtungen (FTEG)', 'H', 0, 156);
INSERT INTO category VALUES (174, 'EMVU (elektromagnetische Umweltverträglichkeit) / BEMFV (Verordnung über das Nachweisverfahren zur Begrenzung elektromagnetischer Felder', 'I', 0, 156);
INSERT INTO category VALUES (175, 'Sicherheitsvorschriften', 'J', 0, 156);
INSERT INTO category VALUES (176, 'Sonstiges', 'K', 0, 156);
INSERT INTO question VALUES (1, 'TA101', '0,042 A entspricht', 0, 1, 0, 0, '');
INSERT INTO question VALUES (2, 'TA102', '0,00042 A entspricht', 0, 1, 0, 0, '');
INSERT INTO question VALUES (3, 'TA103', '100 mW entspricht', 0, 1, 0, 0, '');
INSERT INTO question VALUES (4, 'TA104', '4 200 000 Hz entspricht', 0, 1, 0, 0, '');
INSERT INTO question VALUES (5, 'TA201', 'Welche Einheit wird für die elektrische Spannung verwendet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (6, 'TA202', 'Welche Einheit wird für die elektrische Ladung verwendet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (7, 'TA203', 'Welche Einheit wird für die elektrische Leistung verwendet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (8, 'TA204', 'In welcher Einheit wird der elektrische Widerstand angegeben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (9, 'TA205', 'Welche der nachfolgenden Antworten enthält nur Basiseinheiten nach dem internationalen Einheitensystem?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (10, 'TA206', '0,22 µF sind', 0, 1, 0, 0, '');
INSERT INTO question VALUES (11, 'TA207', '3,75 MHz sind', 0, 1, 0, 0, '');
INSERT INTO question VALUES (12, 'TA208', 'Welche Einheit wird für die Kapazität verwendet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (13, 'TB101', 'Welche Gruppe enthält insgesamt die besten gut leitenden Metalle?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (14, 'TB102', 'Welches der genannten Metalle hat die beste elektrische Leitfähigkeit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (15, 'TB103', 'Welches der genannten Metalle hat die schlechteste elektrische Leitfähigkeit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (16, 'TB104', 'Welche Gruppe von Materialien enthält nur Nichtleiter (Isolatoren)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (17, 'TB105', 'Was verstehen Sie unter Halbleitermaterialien?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (18, 'TB201', 'Welche Spannung zeigt der Spannungsmesser in folgender Schaltung?<p><img src=''etb201f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (19, 'TB202', 'Folgende Schaltung eines Akkus besteht aus Zellen von je 2 V. Jede Zelle kann 10 Ah Ladung liefern. Welche Daten hat der Akku?<p><img src=''etb202f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (20, 'TB203', 'Was versteht man unter „technischer Stromrichtung“ in der Elektrotechnik?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (21, 'TB204', 'Kann in folgender Schaltung von zwei gleichen Spannungsquellen Strom fließen? Welche Begründung ist richtig?<p><img src=''etb204f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (22, 'TB205', 'Wie lange könnte man mit einem voll geladenen Akku mit 55 Ah einen Amateurfunkempfänger betreiben, der einen Strom von 0,8 A aufnimmt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (23, 'TB301', 'Welche Einheit wird für die elektrische Feldstärke verwendet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (24, 'TB302', 'Wie nennt man das Feld zwischen zwei parallelen Kondensatorplatten bei Anschluss einer Gleichspannung?<p><img src=''etb302f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (25, 'TB303', 'Wie werden die mit X gekennzeichneten Feldlinien einer Vertikalantenne bezeichnet?<p><img src=''etb303f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (26, 'TB401', 'Welche Einheit wird für die magnetische Feldstärke verwendet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (27, 'TB402', 'Wie nennt man das Feld im Innern einer langen Zylinderspule beim Fließen eines Gleichstroms?<p><img src=''etb402f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (28, 'TB403', 'Wenn Strom durch einen gestreckten Leiter fließt, entsteht ein', 0, 1, 0, 0, '');
INSERT INTO question VALUES (29, 'TB404', 'Wie werden die mit X gekennzeichneten Feldlinien einer Vertikalantenne bezeichnet?<p><img src=''etb404f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (30, 'TB405', 'Welcher der nachfolgenden Werkstoffe ist ein ferromagnetischer Stoff?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (31, 'TB501', 'Wodurch entsteht ein elektromagnetisches Feld? Ein elektromagnetisches Feld entsteht,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (32, 'TB502', 'Wie erfolgt die Ausbreitung einer elektromagnetischen Welle? Die Ausbreitung erfolgt', 0, 1, 0, 0, '');
INSERT INTO question VALUES (33, 'TB503', 'Das folgende Bild zeigt die Feldlinien eines elektromagnetischen Feldes. Welche Polarisation hat die skizzierte Wellenfront?<p><img src=''etb503f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (34, 'TB504', 'Der Winkel zwischen den elektrischen und magnetischen Feldkomponenten eines elektromagnetischen Feldes beträgt im Fernfeld', 0, 1, 0, 0, '');
INSERT INTO question VALUES (35, 'TB505', 'Die Polarisation des Sendesignals in der Hauptstrahlrichtung dieser Richtantenne ist<p><img src=''etb505f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (36, 'TB601', 'Welches ist die Einheit der Wellenlänge?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (37, 'TB602', 'Welcher Wellenlänge &lambda; entspricht die Frequenz 1,84 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (38, 'TB603', 'Welcher Wellenlänge &lambda; entspricht die Frequenz 28,48 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (39, 'TB604', 'Eine Wellenlänge von 2,06 m entspricht einer Frequenz von', 0, 1, 0, 0, '');
INSERT INTO question VALUES (40, 'TB605', 'Eine Wellenlänge von 80,0 m entspricht einer Frequenz von', 0, 1, 0, 0, '');
INSERT INTO question VALUES (41, 'TB606', 'Welche Bezeichnung ist für eine Schwingung von 145 000 000 Perioden pro Sekunde richtig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (42, 'TB607', 'Die Periodendauer von 50 µs entspricht einer Frequenz von', 0, 1, 0, 0, '');
INSERT INTO question VALUES (43, 'TB608', 'Den Frequenzbereich zwischen 30 und 300 MHz bezeichnet man als', 0, 1, 0, 0, '');
INSERT INTO question VALUES (44, 'TB609', 'Das 70-cm-Band befindet sich im', 0, 1, 0, 0, '');
INSERT INTO question VALUES (45, 'TB610', 'Welche Frequenz hat die in diesem Oszillogramm dargestellte Spannung?<p><img src=''etb610f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (46, 'TB611', 'Welche Frequenz hat das in diesem Schirmbild dargestellte Signal?<p><img src=''etb611f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (47, 'TB612', 'Eine sinusförmige Wechselspannung hat einen Spitzenwert von 12 V. Wie groß ist der Effektivwert der Wechselspannung?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (48, 'TB613', 'Ein sinusförmiges Signal hat einen Effektivwert von 12 V. Wie groß ist der Spitzen-Spitzen-Wert?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (49, 'TB701', 'Welche Signalform sollte der Träger einer hochfrequenten Schwingung haben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (50, 'TB702', 'Ein periodische Schwingung, die wie das folgende Signal aussieht, besteht<p><img src=''etb702f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (51, 'TB801', 'Was ist der Unterschied zwischen AM und SSB?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (52, 'TB802', 'Was ist der Unterschied zwischen LSB und USB?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (53, 'TB803', 'Welche Aussage über modulierte Signale ist richtig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (54, 'TB804', 'Was ist der Unterschied zwischen FSK und AFSK?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (55, 'TB805', 'Wie groß ist die HF-Bandbreite, die bei der Übertragung eines SSB-Signals entsteht?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (56, 'TB806', 'Ein Träger von 3,65 MHz wird mit der NF-Frequenz von 2 kHz in SSB (LSB) moduliert. Welche Frequenz/Frequenzen treten im modulierten HF-Signal hauptsächlich auf?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (57, 'TB901', 'Die Maßeinheit der elektrischen Leistung ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (58, 'TB902', 'Welcher der nachfolgenden Zusammenhänge ist richtig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (59, 'TB903', 'Welche Spannung lässt einen Strom von 2 A durch einen Widerstand von 50 Ohm fließen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (60, 'TB904', 'Welcher Widerstand ist erforderlich um einen Strom von 3 A bei einer Spannung von 90 Volt fließen zu lassen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (61, 'TB905', 'Eine Stromversorgung nimmt bei 230 V einen Strom von 0,63 A auf. Welche elektrische Arbeit (Energie) wird bei einer Betriebsdauer von 7 Stunden verbraucht?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (62, 'TB906', 'Eine Glühlampe hat einen Nennwert von 12 V und 48 W. Bei einer 12-V-Versorgung beträgt die Stromentnahme', 0, 1, 0, 0, '');
INSERT INTO question VALUES (63, 'TB907', 'Der Effektivwert der Spannung an einer künstlichen 50-&Omega;-Antenne wird mit 100 V gemessen. Die Leistung an der Last beträgt', 0, 1, 0, 0, '');
INSERT INTO question VALUES (64, 'TB908', 'Ein mit einer künstlichen 50-&Omega;-Antenne in Serie geschaltetes Amperemeter zeigt 2 A an. Die Leistung in der Last beträgt', 0, 1, 0, 0, '');
INSERT INTO question VALUES (65, 'TB909', 'Ein Mobil-Transceiver (Sender-Empfänger) hat bei Sendebetrieb eine Leistungsaufnahme von 100 Watt aus dem 12-V-Bordnetz des Kraftfahrzeuges. Wie groß ist die Stromaufnahme?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (66, 'TB910', 'Ein 100-&Omega;-Widerstand, an dem 10 V anliegen, muss mindestens eine Belastbarkeit haben von', 0, 1, 0, 0, '');
INSERT INTO question VALUES (67, 'TB911', 'Welche Belastbarkeit muss ein Vorwiderstand haben, an dem bei einem Strom von 50 mA eine Spannung von 50 V abfallen soll?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (68, 'TC101', 'Die Farbringe gelb, violett und orange auf einem Widerstand mit 4 Farbringen bedeuten einen Widerstandswert von', 0, 1, 0, 0, '');
INSERT INTO question VALUES (69, 'TC102', 'Die Farbringe gelb, violett und rot auf einem Widerstand mit 4 Farbringen bedeuten einen Widerstandswert von', 0, 1, 0, 0, '');
INSERT INTO question VALUES (70, 'TC103', 'Die Farbringe rot, violett und orange auf einem Widerstand mit 4 Farbringen bedeuten einen Widerstandswert von', 0, 1, 0, 0, '');
INSERT INTO question VALUES (71, 'TC104', 'Die Farbringe rot, violett und rot auf einem Widerstand mit 4 Farbringen bedeuten einen Widerstandswert von', 0, 1, 0, 0, '');
INSERT INTO question VALUES (72, 'TC105', 'Welches Bauteil hat folgendes Schaltzeichen?<p><img src=''etc105f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (73, 'TC106', 'Welches der folgenden Bauteile ist ein NTC?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (74, 'TC107', 'Welches der folgenden Schaltsymbole stellt einen PTC-Widerstand dar?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (75, 'TC108', 'Ein Widerstand hat eine Toleranz von 10 %. Bei einem nominalen Widerstandswert von 5,6 k&Omega; liegt der tatsächliche Wert zwischen', 0, 1, 0, 0, '');
INSERT INTO question VALUES (76, 'TC109', 'Welche Bauart von Widerstand folgender Auswahl ist am besten für eine künstliche Antenne (Dummy Load) geeignet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (77, 'TC110', 'Welchen Wert hat ein SMD-Widerstand mit der Kennzeichnung 221?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (78, 'TC111', 'Welchen Wert hat ein SMD-Widerstand mit der Kennzeichnung 223?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (79, 'TC201', 'Welche Aussage zur Kapazität eines Plattenkondensators ist richtig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (80, 'TC202', 'Ein Bauelement, bei dem sich Platten auf einer isolierten Achse befinden, die zwischen fest stehende Platten hineingedreht werden können, nennt man', 0, 1, 0, 0, '');
INSERT INTO question VALUES (81, 'TC203', 'Welche Kapazität hat nebenstehend abgebildeter Kondensator?<p><img src=''etc203f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (82, 'TC204', 'Welche Kapazität hat nebenstehend abgebildeter Kondensator?<p><img src=''etc204f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (83, 'TC205', 'Welche Kapazität hat nebenstehend abgebildeter Kondensator?<p><img src=''etc205f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (84, 'TC206', 'Drei Kondensatoren mit den Kapazitäten C<sub>1</sub> = 0,1 µF, C<sub>2</sub> = 150 nF und C<sub>3</sub> = 50000 pF werden parallel geschaltet. Wie groß ist die Gesamtkapazität?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (85, 'TC207', 'Bei welchem der folgenden Bauformen von Kondensatoren muss beim Einbau auf die Polarität geachtet werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (86, 'TC208', 'Mit zunehmender Frequenz', 0, 1, 0, 0, '');
INSERT INTO question VALUES (87, 'TC301', 'Wie ändert sich die Induktivität einer Spule von 12 µH, wenn die Windungszahl bei gleicher Wickellänge verdoppelt wird?<p><img src=''etc301f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (88, 'TC302', 'Wie ändert sich die Induktivität einer Spule von 12 µH, wenn die Wicklung auf dem Wickelkörper bei gleicher Windungszahl auf die doppelte Länge auseinander gezogen wird?<p><img src=''etc302f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (89, 'TC303', 'Wie kann man die Induktivität einer Spule vergrößern?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (90, 'TC304', 'Das folgende Bild zeigt einen Kern, um den ein Kabel für den Bau einer Netzdrossel gewickelt ist. Der Kern sollte aus<p><img src=''etc304f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (91, 'TC305', 'Schaltet man zwei Glühlampen gleichzeitig an eine Spannungsquelle, wobei eine Glühlampe zum Helligkeitsausgleich über einen Widerstand und die andere über eine Spule mit vielen Windungen und Eisenkern angeschlossen ist, so<p><img src=''etc305f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (92, 'TC306', 'Mit zunehmender Frequenz', 0, 1, 0, 0, '');
INSERT INTO question VALUES (93, 'TC401', 'Ein Trafo liegt an 230 Volt und gibt 11,5 Volt ab. Seine Primärwicklung hat 600 Windungen. Wie groß ist seine Sekundärwindungszahl?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (94, 'TC402', 'Ein Trafo liegt an 45 Volt und gibt 180 Volt ab. Seine Primärwicklung hat 150 Windungen. Wie groß ist seine Sekundärwindungszahl?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (95, 'TC403', 'Die Primärspule eines Übertragers hat die fünffache Anzahl von Windungen der Sekundärspule. Wie hoch ist die erwartete Sekundärspannung, wenn die Primärspule an eine 230-V-Stromversorgung angeschlossen wird?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (96, 'TC501', 'P-dotiertes Halbleitermaterial ist solches, das mit einem zusätzlichen Stoff versehen wurde, der', 0, 1, 0, 0, '');
INSERT INTO question VALUES (97, 'TC502', 'N-leitendes Halbleitermaterial ist gekennzeichnet durch', 0, 1, 0, 0, '');
INSERT INTO question VALUES (98, 'TC503', 'Ein in Durchlassrichtung betriebener PN-Übergang ermöglicht', 0, 1, 0, 0, '');
INSERT INTO question VALUES (99, 'TC504', 'Eine in Sperrrichtung betriebene Diode hat', 0, 1, 0, 0, '');
INSERT INTO question VALUES (100, 'TC505', 'Die Auswahlantworten enthalten Silizium- Dioden mit unterschiedlichen Arbeitspunkten. Bei welcher Antwort befindet sich die Diode in leitendem Zustand?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (101, 'TC506', 'Die Auswahlantworten enthalten Silizium- Dioden mit unterschiedlichen Arbeitspunkten. Bei welcher Antwort befindet sich die Diode in leitendem Zustand?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (102, 'TC507', 'Wie verhält sich die Kapazität einer Kapazitätsdiode (Varicap)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (103, 'TC508', 'Wozu dient folgende Schaltung? Sie dient<p><img src=''etc508f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (104, 'TC509', 'Wozu dient die folgende Schaltung? Sie dient<p><img src=''etc509f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (105, 'TC601', 'Was versteht man unter Stromverstärkung beim Transistor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (106, 'TC602', 'Das Verhältnis von Kollektorstrom zum Basisstrom eines Transistors liegt üblicherweise im Bereich von', 0, 1, 0, 0, '');
INSERT INTO question VALUES (107, 'TC603', 'Bei diesem Bauelement handelt es sich um einen<p><img src=''etc603f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (108, 'TC604', 'Bei diesem Bauelement handelt es sich um einen<p><img src=''etc604f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (109, 'TC605', 'Welche Kollektorspannungen haben NPN- und PNP-Transistoren?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (110, 'TC606', 'Bei einem bipolaren Transistor in leitendem Zustand befindet sich die Emitter-Basis-Diode', 0, 1, 0, 0, '');
INSERT INTO question VALUES (111, 'TC607', 'Welche Transistortypen sind bipolare Transistoren?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (112, 'TC608', 'Wie lauten die Bezeichnungen der Anschlüsse eines bipolaren Transistors?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (113, 'TC609', 'Ein bipolarer Transistor ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (114, 'TC610', 'Wenn die Basisspannung eines NPN-Transistors gleich der Emitterspannung ist,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (115, 'TC611', 'Wie erfolgt die Steuerung des Stroms im Feldeffekttransistor (FET)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (116, 'TC612', 'Wie bezeichnet man die Anschlüsse des nebenstehenden Transistors? <p><img src=''etc612f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (117, 'TD101', 'Wie groß ist der Ersatzwiderstand der Gesamtschaltung? Gegeben: R<sub>1</sub> = 500 &Omega;, R<sub>2</sub> = 1000 &Omega; und R<sub>3</sub> = 1 k&Omega;<p><img src=''etd101f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (118, 'TD102', 'Wie groß ist der Ersatzwiderstand der Gesamtschaltung? Gegeben: R<sub>1</sub> = 1 k&Omega;, R<sub>2</sub> = 2000 &Omega; und R<sub>3</sub> = 2 k&Omega;<p><img src=''etd101f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (119, 'TD103', 'Wie groß ist der Ersatzwiderstand der Gesamtschaltung? Gegeben: R<sub>1</sub> = 500 &Omega;, R<sub>2</sub> = 500 &Omega; und R<sub>3</sub> = 1 k&Omega;<p><img src=''etd103f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (120, 'TD104', 'Wie groß ist der Ersatzwiderstand der Gesamtschaltung? Gegeben: R<sub>1</sub> = 500 &Omega;, R<sub>2</sub> = 1,5 k&Omega; und R<sub>3</sub> = 2 k&Omega;<p><img src=''etd103f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (121, 'TD105', 'Welche Gesamtkapazität hat die folgende Schaltung? Gegeben: C<sub>1</sub> = 0,01 µF; C<sub>2</sub> = 5 nF, C<sub>3</sub> = 5000 pF<p><img src=''etd105f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (122, 'TD106', 'Welche Gesamtkapazität hat die folgende Schaltung? Gegeben: C<sub>1</sub> = 0,02 µF; C<sub>2</sub> = 10 nF; C<sub>3</sub> = 10000 pF<p><img src=''etd105f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (123, 'TD107', 'Welche Gesamtkapazität hat die folgende Schaltung? Gegeben: C<sub>1</sub> = 0,01 µF; C<sub>2</sub> = 10 nF; C<sub>3</sub> = 5000 pF<p><img src=''etd107f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (124, 'TD108', 'Die Gesamtspannung U an folgendem Spannungsteiler beträgt 12,2 V. Die Widerstände haben die Werte R<sub>1</sub> = 10 k&Omega; und R<sub>2</sub> = 2,2 k&Omega; Wie groß ist die Teilspannung U<sub>2</sub>?<p><img src=''etd108f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (125, 'TD109', 'Zwei Widerstände mit R<sub>1</sub> = 20 &Omega; und R<sub>2</sub> = 30 &Omega; sind parallel geschaltet. Wie groß ist der Ersatzwiderstand?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (126, 'TD110', 'Zwei Widerstände mit R<sub>1</sub> = 100 &Omega; und R<sub>2</sub> = 150 &Omega; sind parallel geschaltet. Wie groß ist der Ersatzwiderstand?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (127, 'TD201', 'Der Impedanzfrequenzgang in der Abbildung zeigt die Kennlinie<p><img src=''etd201f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (128, 'TD202', 'Der im folgenden Bild dargestellte Impedanzfrequenzgang ist typisch für<p><img src=''etd202f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (129, 'TD203', 'Welcher Schwingkreis passt zu dem neben der jeweiligen Schaltung dargestellten Verlauf des Scheinwiderstandes?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (130, 'TD204', 'Wie ändert sich die Resonanzfrequenz eines Schwingkreises, wenn 1. die Spule weniger Windungen erhält, 2. die Länge der Spule durch Zusammenschieben der Drahtwicklung verringert wird, 3. ein Ferritkern in das Innere der Spule gebracht wird?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (131, 'TD205', 'Wie verhält sich ein Parallelschwingkreis bei der Resonanzfrequenz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (132, 'TD206', 'Was stellt die folgende Schaltung dar?<p><img src=''etd206f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (133, 'TD207', 'Was stellt die folgende Schaltung dar?<p><img src=''etd207f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (134, 'TD208', 'Was stellt die folgende Schaltung dar?<p><img src=''etd208f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (135, 'TD209', 'Was stellt die folgende Schaltung dar?<p><img src=''etd209f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (136, 'TD210', 'Welche der nachfolgenden Eigenschaften trifft auf einen Hochpass zu?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (137, 'TD301', 'Welche Eigenschaften sollten Strom- und Spannungsquellen aufweisen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (138, 'TD302', 'Die Leerlaufspannung einer Gleichspannungsquelle beträgt 13,5 V. Wenn die Spannungsquelle einen Strom von 1 A abgibt, sinkt die Klemmenspannung auf 12,4 V. Wie groß ist der Innenwiderstand der Spannungsquelle?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (139, 'TD303', 'Die Leerlaufspannung einer Gleichspannungsquelle beträgt 13,5 V. Wenn die Spannungsquelle einen Strom von 2 A abgibt, sinkt die Klemmenspannung auf 13 V. Wie groß ist der Innenwiderstand der Spannungsquelle?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (140, 'TD304', 'Berechnen Sie die Leerlaufausgangsspannung dieser Schaltung für ein Transformationsverhältnis von 5:1.<p><img src=''etd304f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (141, 'TD305', 'Berechnen Sie die Leerlaufausgangsspannung dieser Schaltung für ein Transformationsverhältnis von 8:1.<p><img src=''etd304f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (142, 'TD306', 'Welches ist der Hauptnachteil eines Schaltnetzteils gegenüber einem konventionellen Netzteil?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (143, 'TD401', 'In welcher der folgenden Zeilen werden nur Verstärker-Bauelemente genannt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (144, 'TD402', 'Was versteht man in der Elektronik unter Verstärkung? Man spricht von Verstärkung, wenn', 0, 1, 0, 0, '');
INSERT INTO question VALUES (145, 'TD403', 'Was ist ein Operationsverstärker?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (146, 'TD404', 'Ein IC (integrated circuit) ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (147, 'TD405', 'Worauf beruht die Verstärkerwirkung von Elektronenröhren?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (148, 'TD501', 'Durch Modulation', 0, 1, 0, 0, '');
INSERT INTO question VALUES (149, 'TD502', 'Welche Aussage zum Frequenzmodulator ist richtig? Durch das Informationssignal', 0, 1, 0, 0, '');
INSERT INTO question VALUES (150, 'TD503', 'Zur Aufbereitung des SSB-Signals müssen', 0, 1, 0, 0, '');
INSERT INTO question VALUES (151, 'TD504', 'Wie kann ein SSB-Signal erzeugt werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (152, 'TD601', 'Was verstehen Sie unter einem „Oszillator“?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (153, 'TD602', 'Was ist ein LC-Oszillator? Es ist ein Schwingungserzeuger, wobei die Frequenz', 0, 1, 0, 0, '');
INSERT INTO question VALUES (154, 'TD603', 'Was ist ein Quarz-Oszillator? Es ist ein Schwingungserzeuger, wobei die Frequenz', 0, 1, 0, 0, '');
INSERT INTO question VALUES (155, 'TD604', 'Wie verhält sich die Frequenz eines LCOszillators bei Temperaturanstieg, wenn die Kapazität des Schwingkreiskondensators mit dem Temperaturanstieg geringer wird?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (156, 'TD605', 'Im VFO eines Senders steigt die Induktivität der Oszillatorspule mit der Temperatur. Der Kondensator bleibt sehr stabil. Welche Auswirkungen hat dies bei steigender Temperatur?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (157, 'TD606', 'Der Vorteil von Quarzoszillatoren gegenüber LC-Oszillatoren liegt darin, dass sie', 0, 1, 0, 0, '');
INSERT INTO question VALUES (158, 'TE101', 'Wie unterscheidet sich SSB (J3E) von AM (A3E) in Bezug auf die Bandbreite?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (159, 'TE102', 'Welches der nachfolgenden Modulationsverfahren hat die geringste Störanfälligkeit bei Funkanlagen in Kraftfahrzeugen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (160, 'TE103', 'Das folgende Oszillogramm zeigt ein AM-Signal. Der Modulationsgrad beträgt hier zirka<p><img src=''ete103f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (161, 'TE104', 'Das folgende Oszillogramm zeigt ein AM-Signal. Der Modulationsgrad beträgt hier zirka<p><img src=''ete104f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (162, 'TE105', 'Das folgende Oszillogramm zeigt<p><img src=''ete105f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (163, 'TE106', 'Das folgende Oszillogramm zeigt ein typisches Zweiton-SSB-Testsignal. Bestimmen Sie den Modulationsgrad!<p><img src=''ete106f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (164, 'TE201', 'Wodurch wird bei Frequenzmodulation die Lautstärke-Information übertragen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (165, 'TE202', 'FM hat gegenüber SSB den Vorteil der', 0, 1, 0, 0, '');
INSERT INTO question VALUES (166, 'TE203', 'Ein zu großer Hub eines FM-Senders führt dazu,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (167, 'TE204', 'Größerer Frequenzhub führt bei einem FM-Sender zu', 0, 1, 0, 0, '');
INSERT INTO question VALUES (168, 'TE301', 'Welche HF-Bandbreite beansprucht ein 1200-Baud-Packet-Radio-AFSK-Signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (169, 'TE302', 'Welche HF-Bandbreite beansprucht ein 9600-Baud-FM-Packet-Radio-Signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (170, 'TE303', 'Welche NF-Zwischenträgerfrequenzen werden in der Regel in Packet Radio bei 1200 Baud benutzt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (171, 'TE304', 'Was versteht man bei Packet Radio unter einem TNC (Terminal Network Controller)? Ein TNC', 0, 1, 0, 0, '');
INSERT INTO question VALUES (172, 'TE305', 'Was bedeutet im Prinzip „Packet Radio“? Die Daten werden', 0, 1, 0, 0, '');
INSERT INTO question VALUES (173, 'TE306', 'Was versteht man unter 1k2-Packet-Radio?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (174, 'TE307', 'Welches ist eine gängige Übertragungsrate in Packet Radio?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (175, 'TE308', 'Eine Packet-Radio-Mailbox ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (176, 'TE309', 'Um RTTY-Betrieb durchzuführen benötigt man außer einem Transceiver beispielsweise', 0, 1, 0, 0, '');
INSERT INTO question VALUES (177, 'TE310', 'Welcher Unterschied zwischen den Betriebsarten ATV und SSTV ist richtig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (178, 'TE311', 'Welches der folgenden digitalen Übertragungsverfahren hat die geringste Bandbreite?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (179, 'TE312', 'Wie heißt die Übertragungsart mit einem Übertragungskanal, bei der durch Umschaltung abwechselnd in beide Richtungen gesendet werden kann?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (180, 'TF101', 'Eine hohe erste ZF vereinfacht die Filterung zur Vermeidung von', 0, 1, 0, 0, '');
INSERT INTO question VALUES (181, 'TF102', 'Eine hohe erste Zwischenfrequenz', 0, 1, 0, 0, '');
INSERT INTO question VALUES (182, 'TF103', 'Welche Aussage ist für einen Doppelsuper richtig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (183, 'TF104', 'Ein Empfänger hat eine ZF von 10,7 MHz und ist auf 28,5 MHz abgestimmt. Der Oszillator des Empfängers schwingt oberhalb der Empfangsfrequenz. Welche Frequenz hat die Spielfrequenz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (184, 'TF105', 'Wodurch wird beim Überlagerungsempfänger die Spiegelfrequenzdämpfung bestimmt? Sie wird vor allem bestimmt durch', 0, 1, 0, 0, '');
INSERT INTO question VALUES (185, 'TF106', 'Einem Mischer werden die Frequenzen 136 MHz und 145 MHz zugeführt. Welche Frequenzen werden beim Mischvorgang erzeugt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (186, 'TF107', 'Einem Mischer werden die Frequenzen 28 MHz und 38,7 MHz zugeführt. Welche Frequenzen werden beim Mischvorgang erzeugt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (187, 'TF108', 'Eine schmale Empfängerbandbreite führt im allgemeinen zu einer', 0, 1, 0, 0, '');
INSERT INTO question VALUES (188, 'TF109', 'Die Frequenzdifferenz zwischen dem HFNutzsignal und dem Spiegelsignal entspricht', 0, 1, 0, 0, '');
INSERT INTO question VALUES (189, 'TF110', 'Durch welchen Vorgang setzt ein Konverter einen Frequenzbereich für einen vorhandenen Empfänger um?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (190, 'TF201', 'Um Schwankungen des NF-Ausgangssignals durch Schwankungen des HF-Eingangssignals zu verringern, wird ein Empfänger mit', 0, 1, 0, 0, '');
INSERT INTO question VALUES (191, 'TF202', 'Bei Empfang eines sehr starken Signals verringert die AGC (automatic gain control)', 0, 1, 0, 0, '');
INSERT INTO question VALUES (192, 'TF203', 'Was bewirkt die AGC (automatic gain control) bei einem starken Eingangssignal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (193, 'TF204', 'Ein Doppelsuper hat eine erste ZF von 10,7 MHz und eine zweite ZF von 460 kHz. Die Empfangsfrequenz soll 28 MHz sein. Welche Frequenzen sind für den VFO und den CO erforderlich, wenn die Oszillatoren oberhalb der Mischer-Eingangssignale schwingen sollen?<p><img src=''etf204f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (194, 'TF205', 'Ein Doppelsuper hat eine erste ZF von 9 MHz und eine zweite ZF von 460 kHz. Die Empfangsfrequenz soll 21,1 MHz sein. Welche Frequenzen sind für den VFO und den CO erforderlich, wenn die Oszillatoren oberhalb der Mischer-Eingangssignale schwingen sollen?<p><img src=''etf204f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (195, 'TF301', 'In der folgenden Schaltung können bei einer Empfangsfrequenz von 28,3 MHz und einer Oszillatorfrequenz von 39 MHz Spiegelfrequenzstörungen bei<p><img src=''etf301f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (196, 'TF302', 'Der Begrenzerverstärker eines FM-Empfängers ist ein Verstärker,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (197, 'TF303', 'Welcher der folgenden als Bandpass einsetzbaren Bauteile verfügt am ehesten über die geringste Bandbreite?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (198, 'TF401', 'Die Empfindlichkeit eines Empfängers bezieht sich auf die', 0, 1, 0, 0, '');
INSERT INTO question VALUES (199, 'TF402', 'Welchen Vorteil bietet ein Überlagerungsempfänger gegenüber einem Geradeaus- Empfänger?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (200, 'TF403', 'Um wie viel S-Stufen müsste die S-Meter- Anzeige Ihres Empfängers steigen, wenn Ihr Partner die Sendeleistung von 10 Watt auf 40 Watt erhöht?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (201, 'TF404', 'Ein Funkamateur kommt laut S-Meter mit S7 an. Dann schaltet er seine Endstufe ein und bittet um einen erneuten Rapport. Das SMeter zeigt S9+8dB. Um welchen Faktor müsste der Funkamateur seine Leistung erhöht haben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (202, 'TF405', 'Ein Funkamateur hat eine Endstufe, welche die Leistung verzehnfacht (von 10 auf 100 Watt). Ohne seine Endstufe zeigt Ihr S-Meter genau S8. Auf welchen Wert müsste die Anzeige Ihres S-Meters ansteigen, wenn er die Endstufe dazuschaltet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (203, 'TF406', 'Wie groß ist der Unterschied von S4 nach S7 in dB?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (204, 'TF407', 'Welche Baugruppe könnte in einem Empfänger gegebenenfalls dazu verwendet werden, um einen schmalen Frequenzbereich zu unterdrücken, in dem Störungen empfangen werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (205, 'TF408', 'Was bedeutet an einem Abstimmelement eines Empfängers die Abkürzung AGC?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (206, 'TF409', 'Welche Baugruppe könnte in einem Empfänger gegebenenfalls dazu verwendet werden, impulsförmige Störungen auszublenden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (207, 'TG101', 'Wie kann die hochfrequente Ausgangsleistung eines SSB-Senders vermindert werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (208, 'TG102', 'Welche der nachfolgenden Antworten trifft für die Wirkungsweise eines Transverters zu?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (209, 'TG103', 'Was kann man tun, wenn der Hub bei einem Handfunkgerät oder Mobil-Transceiver zu groß ist?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (210, 'TG104', 'Was bewirkt in der Regel eine zu hohe Mikrofonverstärkung bei einem SSB-Transceiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (211, 'TG105', 'Was bewirkt eine zu geringe Mikrofonverstärkung bei einem SSB-Transceiver?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (212, 'TG201', 'Wie heißt die Stufe in einem Sender, welche die Eigenschaft hat, leise Sprachsignale gegenüber den lauten etwas anzuheben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (213, 'TG202', 'Welche Schaltung in einem Sender bewirkt, dass der Transceiver allein durch die Stimme auf Sendung geschaltet werden kann?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (214, 'TG203', 'Welche Anforderungen muss ein FM-Funkgerät erfüllen, damit es für die Übertragung von Packet Radio mit 9600 Baud geeignet ist?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (215, 'TG301', 'Ein Sender mit 1 Watt Ausgangsleistung ist an eine Endstufe mit einer Verstärkung von 10 dB angeschlossen. Wie groß ist der Ausgangspegel der Endstufe?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (216, 'TG302', 'Ein HF-Leistungsverstärker hat eine Verstärkung von 16 dB. Welche HF-Ausgangsleistung ist zu erwarten, wenn der Verstärker mit 1 W HF-Eingangsleistung angesteuert wird?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (217, 'TG303', 'Die Ausgangsleistung eines Senders ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (218, 'TG304', 'Die Spitzenleistung eines Senders ist die', 0, 1, 0, 0, '');
INSERT INTO question VALUES (219, 'TG305', 'Eine Verdopplung der Leistung entspricht wie viel dB?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (220, 'TG306', 'Die Ausgangsleistung eines FM-Senders', 0, 1, 0, 0, '');
INSERT INTO question VALUES (221, 'TG307', 'Wie wird in der Regel die hochfrequente Ausgangsleistung eines SSB-Senders vermindert?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (222, 'TG401', 'Was kann man tun, wenn der Hub bei einem Handfunkgerät oder Mobil-Transceiver zu groß ist?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (223, 'TG402', 'In welcher der folgenden Antworten sind Betriebsarten üblicher Kurzwellen-Transceiver aufgezählt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (224, 'TG403', 'Wenn man beim Funkbetrieb mit einem Transceiver die Empfangsfrequenz gegenüber der Senderfrequenz geringfügig verstellen möchte, muss man', 0, 1, 0, 0, '');
INSERT INTO question VALUES (225, 'TG404', 'Wie wird die Taste am Mikrofon bezeichnet, mit der man einen Transceiver auf Sendung schalten kann?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (226, 'TG405', 'Wie wird der Funkbetrieb bezeichnet, bei dem man einen Transceiver allein durch die Stimme auf Sendung schalten kann?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (227, 'TG501', 'Wodurch werden Tastklicks bei einem CW-Sender hervorgerufen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (228, 'TG502', 'Welches Filter wäre zwischen Senderausgang und Antenne eingeschleift am besten zur Verringerung der Oberwellenausstrahlungen geeignet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (229, 'TG503', 'Um Nachbarkanalstörungen zu minimieren, sollte die Übertragungsbandbreite bei SSB', 0, 1, 0, 0, '');
INSERT INTO question VALUES (230, 'TG504', 'Welche Schaltung wäre zwischen Senderausgang und Antenne eingeschleift am besten zur Verringerung der Oberwellenausstrahlungen geeignet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (231, 'TG505', 'Bei der erstmaligen Prüfung eines Senders sollten die Signale zunächst', 0, 1, 0, 0, '');
INSERT INTO question VALUES (232, 'TG506', 'Welche Filtercharakteristik würde sich am besten für einen KW-Mehrband-Sender eignen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (233, 'TH101', 'Was sind typische Kurzwellen-Amateurfunksendeantennen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (234, 'TH102', 'Welche Antennenformen werden im VHF-UHF- Bereich bei den Funkamateuren in der Regel nicht verwendet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (235, 'TH103', 'Welche magnetischen Antennen eignen sich für Sendebetrieb und strahlen dabei im Nahfeld ein starkes magnetisches Feld ab?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (236, 'TH104', 'Berechnen Sie die elektrische Länge eines 5/8-&lambda;-langen Vertikalstrahlers für das 10-m- Band (28,5 MHz).', 0, 1, 0, 0, '');
INSERT INTO question VALUES (237, 'TH105', 'Sie wollen verschiedene Antennen testen, ob sie für den Funkbetrieb auf Kurzwelle für das 80-m-Band geeignet sind. Man stellt Ihnen jeweils drei Antennen zur Verfügung. Welches Angebot wählen sie, um nur die drei besonders geeigneten Antennen testen zu müssen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (238, 'TH106', 'Welche Antenne gehört nicht zu den symmetrischen Antennen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (239, 'TH107', 'Wie nennt man eine Schleifenantenne, die aus drei gleich langen Drahtstücken besteht?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (240, 'TH108', 'Bei welcher Länge hat eine Vertikalantenne die günstigsten Strahlungseigenschaften?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (241, 'TH109', 'Eine Vertikalantenne erzeugt', 0, 1, 0, 0, '');
INSERT INTO question VALUES (242, 'TH110', 'Sie wollen eine Zweibandantenne für 160 und 80 m selbst bauen. Welche der folgenden Antworten enthält die richtige Drahtlänge l zwischen den Schwingkreisen und die richtige Resonanzfrequenz f<sub>res</sub> der Kreise?<p><img src=''eth110f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (243, 'TH111', 'Die elektrischen Gegengewichte einer Groundplane-Antenne bezeichnet man auch als', 0, 1, 0, 0, '');
INSERT INTO question VALUES (244, 'TH112', 'Das folgende Bild enthält eine einfache Richtantenne. Die Bezeichnungen der Elemente in numerischer Reihenfolge lauten<p><img src=''eth112f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (245, 'TH113', 'An welchem Element einer Yagi-Antenne erfolgt die Energieeinspeisung? Sie erfolgt am', 0, 1, 0, 0, '');
INSERT INTO question VALUES (246, 'TH201', 'Welche elektrische Länge muss eine Dipolantenne haben, damit sie in Resonanz ist?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (247, 'TH202', 'Welches Strahlungsdiagramm ist der Antenne richtig zugeordnet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (248, 'TH203', 'Welchen Eingangs- bzw. Fußpunktwiderstand hat die Groundplane?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (249, 'TH204', 'Die Impedanz in der Mitte eines Halbwellendipols beträgt je nach Aufbauhöhe ungefähr', 0, 1, 0, 0, '');
INSERT INTO question VALUES (250, 'TH205', 'Ein Faltdipol hat einen Eingangswiderstand von ungefähr', 0, 1, 0, 0, '');
INSERT INTO question VALUES (251, 'TH206', 'Ein Halbwellendipol wird auf der Grundfrequenz in der Mitte', 0, 1, 0, 0, '');
INSERT INTO question VALUES (252, 'TH207', 'Welcher Prozentsatz entspricht dem Korrekturfaktor, der üblicherweise für die Berechnung der Länge einer Drahtantenne verwendet wird?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (253, 'TH208', 'Das folgende Bild enthält verschiedene UKW-Vertikalantennen. In welcher der folgenden Zeilen ist die entsprechende Bezeichnung der Antenne richtig zugeordnet?<p><img src=''eth208f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (254, 'TH209', 'Das folgende Bild enthält verschiedene UKW-Antennen. Welche der folgenden Antworten ist richtig?<p><img src=''eth209f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (255, 'TH210', 'Eine Drahtantenne für den Amateurfunk im KW-Bereich', 0, 1, 0, 0, '');
INSERT INTO question VALUES (256, 'TH301', 'Am Ende einer Leitung ist nur noch ein Viertel der Leistung vorhanden. Wie groß ist das Dämpfungsmaß des Kabels?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (257, 'TH302', 'Am Ende einer Leitung ist nur noch ein Zehntel der Leistung vorhanden. Wie groß ist das Dämpfungsmaß des Kabels?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (258, 'TH303', 'Eine HF-Ausgangleistung von 100 W wird in eine angepasste Übertragungsleitung eingespeist. Am antennenseitigen Ende der Leitung beträgt die Leistung 50 W bei einem Stehwellenverhältnis von 1:1. Wie hoch ist die Leitungsdämpfung?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (259, 'TH304', 'Welcher der nachfolgenden Zusammenhänge ist richtig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (260, 'TH305', 'Welche Dämpfung hat ein 25 m langes Koaxkabel vom Typ Aircell 7 bei 145 MHz? (siehe hierzu beiliegendes Diagramm)<p><img src=''ekabeldaempfung.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (261, 'TH306', 'Welche Dämpfung hat ein 20 m langes Koaxkabel vom Typ RG 58 bei 29 MHz? (siehe hierzu beiliegendes Diagramm)<p><img src=''ekabeldaempfung.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (262, 'TH307', 'Der Wellenwiderstand einer Leitung', 0, 1, 0, 0, '');
INSERT INTO question VALUES (263, 'TH308', 'Koaxialkabel weisen typischerweise Wellenwiderstände von', 0, 1, 0, 0, '');
INSERT INTO question VALUES (264, 'TH309', 'Welche Vorteile hat eine Paralleldraht-Speiseleitung gegenüber der Speisung über ein Koaxialkabel?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (265, 'TH310', 'Wann ist eine Speiseleitung unsymmetrisch?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (266, 'TH311', 'Welche Leitungen sollten für die HF-Verbindungen zwischen Einrichtungen in der Amateurfunkstelle verwendet werden, um unerwünschte Abstrahlungen zu vermeiden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (267, 'TH312', 'Welches der folgenden Koaxsteckverbindersysteme ist für sehr hohe Frequenzen (70-cm-Band) und hohe Leistungen am besten geeignet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (268, 'TH401', 'Bei welchem Stehwellenverhältnis (VSWR) ist eine Antenne am besten an die Leitung angepasst?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (269, 'TH402', 'Fehlanpassungen oder Beschädigungen von HF-Übertragungsleitungen', 0, 1, 0, 0, '');
INSERT INTO question VALUES (270, 'TH403', 'Welche Auswirkungen hat es, wenn eine symmetrische Antenne (Dipol) mit einem Koaxkabel gleicher Impedanz gespeist wird?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (271, 'TH404', 'Ein symmetrischer Halbwellendipol wird direkt über ein Koaxialkabel von einem Sender gespeist. Das Kabel ist senkrecht am Haus entlang verlegt und verursacht geringe Störungen. Um das Problem weiter zu verringern, empfiehlt es sich', 0, 1, 0, 0, '');
INSERT INTO question VALUES (272, 'TH405', 'Auf einem Ferritkern sind etliche Windungen Koaxialkabel aufgewickelt. Diese Anordnung kann dazu dienen,<p><img src=''eth405f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (273, 'TH406', 'Am Eingang einer Antennenleitung misst man ein VSWR von 3. Wie groß ist in etwa die rücklaufende Leistung am Messpunkt, wenn die vorlaufende Leistung dort 100 Watt beträgt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (274, 'TI101', 'Welche ionosphärischen Schichten bestimmen die Funkwellenausbreitung am Tage?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (275, 'TI102', 'Welche ionosphärischen Schichten bestimmen die Fernausbreitung in der Nacht?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (276, 'TI103', 'In welcher Höhe befinden sich die für die Fernausbreitung (DX) wichtigen ionosphärischen Schichten? Sie befinden sich in ungefähr', 0, 1, 0, 0, '');
INSERT INTO question VALUES (277, 'TI104', 'Welchen Einfluss hat die D-Schicht auf die Fernausbreitung?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (278, 'TI105', 'Wie kommt die Fernausbreitung einer Funkwelle auf den Kurzwellenbändern zustande? Sie kommt zustande durch die Reflexion an', 0, 1, 0, 0, '');
INSERT INTO question VALUES (279, 'TI106', 'Welche Schicht ist für die gute Ausbreitung im 10-m-Band in den Sommermonaten verantwortlich?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (280, 'TI107', 'Die Sonnenfleckenzahl ist einem regelmäßigen Zyklus unterworfen. Welchen Zeitraum hat dieser Zyklus zirka?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (281, 'TI201', 'Die Ausbreitungsgeschwindigkeit freier elektromagnetischer Wellen beträgt etwa', 0, 1, 0, 0, '');
INSERT INTO question VALUES (282, 'TI202', 'Unter der "Toten Zone" wird der Bereich verstanden,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (283, 'TI203', 'Welche der folgenden Aussagen trifft für KW-Funkverbindungen zu, die über Bodenwellen erfolgen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (284, 'TI204', 'Wie groß ist in etwa die maximale Entfernung, die ein KW-Signal bei Reflexion an der E-Schicht auf der Erdoberfläche mit einem Sprung (Hop) überbrücken kann?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (285, 'TI205', 'Von welchem der genannten Parameter ist die Sprungdistanz abhängig, die ein KW-Signal auf der Erdoberfläche überbrücken kann? Sie ist abhängig', 0, 1, 0, 0, '');
INSERT INTO question VALUES (286, 'TI206', 'Bei der Ausbreitung auf Kurzwelle spielt die so genannte "Grey Line" eine besondere Rolle. Was ist die "Grey Line"?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (287, 'TI207', 'Was versteht man unter dem Begriff "Mögel-Dellinger-Effekt"?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (288, 'TI208', 'Ein plötzlicher Anstieg der Intensitäten von UV- und Röntgenstrahlung nach einem Flare (Energieausbruch auf der Sonne) führt zu erhöhter Ionisierung der D-Schicht und damit zu kurzzeitigem Totalausfall der ionosphärischen Kurzwellenausbreitung. Diese Erscheinung wird auch als', 0, 1, 0, 0, '');
INSERT INTO question VALUES (289, 'TI209', 'Unter dem Begriff "Short Skip" versteht man Funkverbindungen besonders im 10-m-Band mit Sprungentfernungen unter 1000 km, die', 0, 1, 0, 0, '');
INSERT INTO question VALUES (290, 'TI210', 'Warum sind Signale im 160- und 80-Meter- Band tagsüber nur schwach und nicht für den weltweiten Funkverkehr geeignet? Sie sind ungeeignet wegen der Tagesdämpfung in der', 0, 1, 0, 0, '');
INSERT INTO question VALUES (291, 'TI211', 'In welcher ionosphärischen Schicht treten gelegentlich Aurora-Erscheinungen auf?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (292, 'TI212', 'Was bedeutet die „MUF“ bei der Kurzwellenausbreitung?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (293, 'TI213', 'Wie nennt man den ionosphärischen Feldstärkeschwund durch Überlagerung von Boden- und Raumwelle, der sich bei der Kurzwellenausbreitung besonders bei AM-Sendungen bemerkbar macht?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (294, 'TI301', 'Wie weit etwa reicht der Funkhorizont im UKW-Bereich über den geografischen Horizont hinaus? Er reicht etwa', 0, 1, 0, 0, '');
INSERT INTO question VALUES (295, 'TI302', 'Überhorizontverbindungen im UHF/VHF-Bereich kommen u.a. zustande durch', 0, 1, 0, 0, '');
INSERT INTO question VALUES (296, 'TI303', 'Für VHF-Weitverkehrsverbindungen wird hauptsächlich die', 0, 1, 0, 0, '');
INSERT INTO question VALUES (297, 'TI304', 'Was ist die "Troposphäre"? Die Troposphäre ist der', 0, 1, 0, 0, '');
INSERT INTO question VALUES (298, 'TI305', 'Wie wirkt die Antennenhöhe auf die Reichweite einer UKW-Verbindung aus? Die Reichweite steigt mit zunehmender Antennenhöhe, weil', 0, 1, 0, 0, '');
INSERT INTO question VALUES (299, 'TI306', 'Was ist die Ursache für Aurora-Erscheinungen? Die Ursache ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (300, 'TI307', 'Wie wirkt sich "Aurora" auf die Signalqualität eines Funksignals aus?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (301, 'TI308', 'Welche Betriebsart eignet sich am besten für Auroraverbindungen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (302, 'TI309', 'Was verstehen Sie unter dem Begriff "Sporadic-E"? Ich verstehe darunter', 0, 1, 0, 0, '');
INSERT INTO question VALUES (303, 'TI310', 'In dem folgenden Geländeprofil sei S ein Sender im 2-m-Band, E1 bis E4 vier Empfangsstationen. Welche Funkstrecke geht wahrscheinlich am besten, welche am schlechtesten?<p><img src=''eti310f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (304, 'TJ101', 'Das Prinzip eines Drehspulmessgeräts beruht auf', 0, 1, 0, 0, '');
INSERT INTO question VALUES (305, 'TJ102', 'Die Auflösung eines Messinstrumentes entspricht', 0, 1, 0, 0, '');
INSERT INTO question VALUES (306, 'TJ103', 'Was ist ein Dipmeter? Ein Dipmeter ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (307, 'TJ104', 'Wozu wird ein Dipmeter beispielsweise verwendet? Ein Dipmeter wird zur', 0, 1, 0, 0, '');
INSERT INTO question VALUES (308, 'TJ105', 'Welches dieser Messgeräte ist für die Ermittlung der Resonanzfrequenz eines Traps, das für einen Dipol genutzt werden soll, am besten geeignet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (309, 'TJ106', 'Wie ermittelt man die Resonanzfrequenz eines Schwingkreises? Man ermittelt sie', 0, 1, 0, 0, '');
INSERT INTO question VALUES (310, 'TJ107', 'Für welche Messungen verwendet man ein Oszilloskop? Ein Oszilloskop verwendet man, um', 0, 1, 0, 0, '');
INSERT INTO question VALUES (311, 'TJ108', 'Welches dieser Geräte wird für die Anzeige von NF-Verzerrungen verwendet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (312, 'TJ109', 'Eine künstliche Antenne für den VHF-Bereich könnte beispielsweise aus', 0, 1, 0, 0, '');
INSERT INTO question VALUES (313, 'TJ110', 'Welche der folgenden Bauteile könnten für eine genaue künstliche Antenne, die bei 28 MHz eingesetzt werden soll, verwendet werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (314, 'TJ201', 'Welche Schaltung könnte dazu verwendet werden, den Wert eines Widerstandes anhand des ohmschen Gesetzes zu ermitteln?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (315, 'TJ202', 'Wie werden elektrische Spannungsmesser an Messobjekte angeschlossen und welche Anforderungen muss das Messgerät erfüllen, damit der Messfehler möglichst gering bleibt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (316, 'TJ203', 'Die Zeitbasis eines Oszilloskops ist so eingestellt, dass ein Skalenteil 0,5 ms entspricht. Welche Frequenz hat die angelegte Spannung?<p><img src=''etj203f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (317, 'TJ204', 'Für welchen Zweck wird eine Stehwellenmessbrücke verwendet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (318, 'TJ205', 'Welche Spannung wird bei dem folgenden Messinstrument angezeigt, wenn dessen Messbereich auf 10 V eingestellt ist?<p><img src=''etj205f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (319, 'TJ206', 'An welcher Stelle einer Antennenanlage muss ein VSWR-Meter eingeschleift werden, um Aussagen über die Antenne selbst machen zu können? Das VSWR-Meter muss eingeschleift werden zwischen', 0, 1, 0, 0, '');
INSERT INTO question VALUES (320, 'TJ207', 'Ein Stehwellenmessgerät wird in ein ideal angepasstes Sender-/Antennensystem eingeschleift. Das Messgerät sollte', 0, 1, 0, 0, '');
INSERT INTO question VALUES (321, 'TJ208', 'Welches dieser Messgeräte ist für genaue Frequenzmessungen am besten geeignet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (322, 'TJ209', 'Wie misst man das Stehwellenverhältnis? Man misst es', 0, 1, 0, 0, '');
INSERT INTO question VALUES (323, 'TJ210', 'Ein Stehwellenmessgerät wird eingesetzt bei Sendern zur Messung', 0, 1, 0, 0, '');
INSERT INTO question VALUES (324, 'TJ211', 'An welchem Punkt sollte das Stehwellenmessgerät eingeschleift werden, um zu prüfen, ob der Sender gut an die Antennenanlage angepasst ist?<p><img src=''etj211f.png''>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (325, 'TK101', 'Wie äußert sich Zustopfen bzw. Blockierung eines Empfängers?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (326, 'TK102', 'Welche Effekte werden durch Intermodulation hervorgerufen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (327, 'TK103', 'Welche Reaktion ist angebracht, wenn Störungen im TV-Rundfunk beim Nachbarn nicht mit den zur Verfügung stehenden Mitteln beseitigt werden können?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (328, 'TK104', 'Bei der Überprüfung des Ausgangssignals eines Senders sollte die Dämpfung der Oberwellen mindestens', 0, 1, 0, 0, '');
INSERT INTO question VALUES (329, 'TK105', 'In welchem Fall spricht man von Einströmungen bei EMV? Einströmungen liegen dann vor, wenn die HF', 0, 1, 0, 0, '');
INSERT INTO question VALUES (330, 'TK106', 'In welchem Fall spricht man von Einstrahlungen bei EMV? Einstrahlungen liegen dann vor, wenn die HF', 0, 1, 0, 0, '');
INSERT INTO question VALUES (331, 'TK107', 'Wie nennt man die elektromagnetische Störung, die durch die Aussendung des reinen Nutzsignals beim Empfang anderer Frequenzen in benachbarten Empfängern auftreten kann?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (332, 'TK201', 'Wie kommen Geräusche aus den Lautsprechern einer abgeschalteten Stereoanlage möglicherweise zustande?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (333, 'TK202', 'Ein Fernsehgerät wird durch das Nutzsignal einer KW-Amateurfunkstelle gestört. Wie dringt das Signal mit größter Wahrscheinlichkeit in das Fernsehgerät ein?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (334, 'TK203', 'Die Übersteuerung eines Leistungsverstärkers führt zu', 0, 1, 0, 0, '');
INSERT INTO question VALUES (335, 'TK204', 'Die gesamte Bandbreite einer FMÜbertragung beträgt 15 kHz. Wie nah an der Bandgrenze kann ein Träger übertragen werden, ohne dass Außerbandaussendungen erzeugt werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (336, 'TK301', 'Durch welche Maßnahme kann die übermäßige Bandbreite einer 2-m-FM-Übertragung verringert werden? Sie kann verringert werden durch die Änderung der', 0, 1, 0, 0, '');
INSERT INTO question VALUES (337, 'TK302', 'Ein Sender sollte so betrieben werden, dass', 0, 1, 0, 0, '');
INSERT INTO question VALUES (338, 'TK303', 'Durch eine Mantelwellendrossel in einem Fernseh-Antennenzuführungskabel', 0, 1, 0, 0, '');
INSERT INTO question VALUES (339, 'TK304', 'Ein Funkamateur wohnt in einem Reihenhaus. An welcher Stelle sollte die KW-Drahtantenne angebracht werden, um störende Beeinflussungen auf ein Mindestmaß zu begrenzen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (340, 'TK305', 'Beim Betrieb Ihres 2-m-Senders wird bei einem Ihrer Nachbarn ein Fernsehempfänger gestört, der mit einer Zimmerantenne betrieben wird. Zur Behebung des Problems schlagen Sie dem Nachbarn vor,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (341, 'TK306', 'Die Bemühungen, die durch eine in der Nähe befindliche Amateurfunkstelle hervorgerufenen Fernsehstörungen zu verringern, sind fehlgeschlagen. Als nächster Schritt ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (342, 'TK307', 'Um die Störwahrscheinlichkeit zu verringern, sollte die benutzte Sendeleistung', 0, 1, 0, 0, '');
INSERT INTO question VALUES (343, 'TK308', 'Welches Filter sollte im Störungsfall für die Dämpfung von Kurzwellensignalen in ein Fernsehantennenkabel eingeschleift werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (344, 'TK309', 'Was sollte zur Herabsetzung starker Signale eines 28-MHz-Senders in das Fernseh- Antennenzuführungskabel eingeschleift werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (345, 'TK310', 'Welche Filter sollten im Störungsfall vor die einzelnen Leitungsanschlüsse eines UKW oder Fernsehrundfunkgeräts oder angeschlossener Geräte eingeschleift werden, um Kurzwellensignale zu dämpfen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (346, 'TK311', 'Die Signale eines 144-MHz-Senders werden in das Koax-Antennenkabel eines FM-Rundfunkempfängers induziert und verursachen Störungen. Eine Möglichkeit zur Verringerung der Störungen besteht darin,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (347, 'TK312', 'Um die Störwahrscheinlichkeit im eigenen Haus zu verringern, empfiehlt es sich vorzugsweise', 0, 1, 0, 0, '');
INSERT INTO question VALUES (348, 'TK313', 'Bei der Hi-Fi-Anlage des Nachbarn wird Einströmung in die NF-Endstufe festgestellt. Eine mögliche Abhilfe wäre', 0, 1, 0, 0, '');
INSERT INTO question VALUES (349, 'TK314', 'Eine KW-Amateurfunkstelle verursacht im Sendebetrieb in einem in der Nähe betriebenen Fernsehempfänger Störungen. Welches Filter schleifen Sie in das Fernsehantennenkabel ein, um die Störwahrscheinlichkeit zu verringern?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (350, 'TK315', 'Bei einem Wohnort in einem Ballungsgebiet empfiehlt es sich, während der abendlichen Fernsehstunden', 0, 1, 0, 0, '');
INSERT INTO question VALUES (351, 'TK316', 'Falls sich eine Antenne in der Nähe und parallel zu einer 230-V-Wechselstrom-Freileitung befindet,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (352, 'TK317', 'Eine 435-MHz-Sendeantenne mit hohem Gewinn ist unmittelbar auf eine UHF-Fernseh-Empfangsantenne gerichtet. Dies führt gegebenenfalls zu', 0, 1, 0, 0, '');
INSERT INTO question VALUES (353, 'TK318', 'Im Mittelwellenbereich ergeben sich häufig Spiegelfrequenzstörungen durch', 0, 1, 0, 0, '');
INSERT INTO question VALUES (354, 'TK319', 'Ein korrodierter Anschluss an der Fernseh-Empfangsantenne des Nachbarn', 0, 1, 0, 0, '');
INSERT INTO question VALUES (355, 'TL101', 'Um eine Amateurfunkstelle in Bezug auf EMV zu optimieren', 0, 1, 0, 0, '');
INSERT INTO question VALUES (356, 'TL201', 'Nach welcher der Antworten kann die ERP (Effective Radiated Power) berechnet werden, und worauf ist die ERP bzw. der zu verwendende Antennengewinn bezogen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (357, 'TL202', 'Nach welcher der Antworten kann die EIRP berechnet werden, und worauf ist die EIRP bzw. der zu verwendende Antennengewinn bezogen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (358, 'TL203', 'Was versteht man unter dem Begriff "EIRP"?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (359, 'TL204', 'Ein Sender mit 0,6 Watt Ausgangsleistung ist über eine Antennenleitung, die 1 dB Kabelverluste hat, an eine Richtantenne mit 11 dB Gewinn (auf Dipol bezogen) angeschlossen. Welche EIRP wird von der Antenne maximal abgestrahlt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (360, 'TL205', 'Ein Sender mit 5 Watt Ausgangsleistung ist über eine Antennenleitung, die 2 dB Kabelverluste hat, an eine Antenne mit 5 dB Gewinn (auf Dipol bezogen) angeschlossen. Welche EIRP wird von der Antenne maximal abgestrahlt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (361, 'TL206', 'Ein Sender mit 75 Watt Ausgangsleistung ist über eine Antennenleitung, die 2,15 dB (Faktor 1,64) Kabelverluste hat, an eine Dipol- Antenne angeschlossen. Welche EIRP wird von der Antenne maximal abgestrahlt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (362, 'TL207', 'Muss ein Funkamateur als Betreiber einer ortsfesten Amateurfunkstelle bei der Sendeart F3E und einer Senderleistung von 6 Watt an einer 15-Element-Yagiantenne mit 13 dB Gewinn für 2 m die Einhaltung der Personenschutzgrenzwerte nachweisen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (363, 'TL208', 'Sie besitzen einen &lambda;/4-Vertikalstrahler. Da Sie für diese Antenne keine Selbsterklärung abgeben möchten und somit nur eine Strahlungsleistung von kleiner 10 W EIRP verwenden dürfen, müssen Sie die Sendeleistung soweit reduzieren, dass sie unter diesem Wert bleiben. Wie groß darf die Sendeleistung dabei sein?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (364, 'TL209', 'Sie möchten den Personenschutz-Sicherheitsabstand für die Antenne Ihrer Amateurfunkstelle für das 10-m-Band und die Betriebsart RTTY berechnen. Der Grenzwert im Fall des Personenschutzes beträgt 28 V/m. Sie betreiben einen Dipol, der von einem Sender mit einer Leistung von 100 W über ein Koaxialkabel gespeist wird. Die Kabeldämpfung sei vernachlässigbar. Wie groß muss der Sicherheitsabstand sein?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (365, 'TL210', 'Sie möchten den Personenschutz-Sicherheitsabstand für die Antenne Ihrer Amateurfunkstelle für das 10-m-Band und die Betriebsart FM berechnen. Der Grenzwert im Fall des Personenschutzes beträgt 28 V/m. Sie betreiben eine Yagi-Antenne mit einem Gewinn von 7,5 dBd. Die Antenne wird von einem Sender mit einer Leistung von 100 W über ein langes Koaxialkabel gespeist. Die Kabeldämpfung beträgt 1,5 dB. Wie groß muss der Sicherheitsabstand sein?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (366, 'TL211', 'Sie möchten den Personenschutz-Sicherheitsabstand für die Antenne Ihrer Amateurfunkstelle in Hauptstrahlrichtung für das 2- m-Band und die Betriebsart FM berechnen. Der Grenzwert im Fall des Personenschutzes beträgt 28 V/m. Sie betreiben eine Yagi- Antenne mit einem Gewinn von 11,5 dBd. Die Antenne wird von einem Sender mit einer Leistung von 75 W über ein Koaxialkabel gespeist. Die Kabeldämpfung beträgt 1,5 dB. Wie groß muss der Sicherheitsabstand sein?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (367, 'TL212', 'Sie errechnen einen Sicherheitsabstand für Ihre Antenne. Von welchem Punkt aus muss dieser Sicherheitsabstand eingehalten werden, wenn Sie bei der Berechnung die Fernfeldnäherung verwendet haben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (368, 'TL213', 'Mit welcher Ausgangsleistung rechnen Sie im Fall des Personenschutzes, um den Sicherheitsabstand zu ermitteln?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (369, 'TL214', 'Herzschrittmacher können auch durch die Aussendung einer Amateurfunkstelle beeinflusst werden. Gibt es einen zeitlichen Grenzwert für die Einwirkdauer?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (370, 'TL301', 'Unter welchen Bedingungen darf das Standrohr einer Amateurfunkantenne auf einem Gebäude mit einer vorhandenen Blitzschutzanlage verbunden werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (371, 'TL302', 'Welches Material und welcher Mindestquerschnitt ist bei einer Erdungsleitung zwischen einem Antennenstandrohr und einer Erdungsanlage nach DIN VDE 0855 Teil 300 für Funksender bis 1 kW zu verwenden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (372, 'TL303', 'Unter welchen Bedingungen darf ein Fundamenterder als Blitzschutzerder verwendet werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (373, 'TL304', 'Welche Sicherheitsmaßnahmen müssen zum Schutz gegen atmosphärische Überspannungen und zur Verhinderung von Spannungsunterschieden bei Koaxialkabel- Niederführungen ergriffen werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (374, 'TL305', 'Welche der Antworten A bis D enthält die heutzutage normgerechten Adern- Kennfarben von 3-adrigen, isolierten Energieleitungen und -kabeln in der Abfolge: Schutzleiter, Außenleiter, Neutralleiter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (375, 'TL306', 'Damit die Zulassung eines Kraftfahrzeugs nicht ungültig wird, sind vor dem Einbau einer mobilen Sende-/Empfangseinrichtung grundsätzlich', 0, 1, 0, 0, '');
INSERT INTO question VALUES (376, 'TL307', 'Wo sollte aus funktechnischer Sicht eine mobile VHF-Antenne an einem PKW vorzugsweise installiert werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (377, 'TL308', 'Um ein Zusammenwirken mit der Elektronik des Kraftfahrzeugs zu verhindern, sollte das Antennenkabel', 0, 1, 0, 0, '');
INSERT INTO question VALUES (378, 'TA101', 'Welche Einheit wird für die elektrische Feldstärke verwendet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (379, 'TA102', 'Welche Einheit wird für die magnetische Feldstärke verwendet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (380, 'TA103', 'In welcher Einheit wird die Impedanz angegeben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (381, 'TA104', 'Die Einheit "Siemens" wird verwendet für die Angabe', 0, 1, 0, 0, '');
INSERT INTO question VALUES (382, 'TA105', 'Wenn [s] für Sekunde steht, gilt für die Einheit der Frequenz', 0, 1, 0, 0, '');
INSERT INTO question VALUES (383, 'TA106', 'Welche der nachfolgenden Antworten enthält nur Basiseinheiten nach dem internationalen Einheitensystem?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (384, 'TA107', 'Einem Spannungsverhältnis von 15 entsprechen', 0, 1, 0, 0, '');
INSERT INTO question VALUES (385, 'TA108', 'Einer Leistungsverstärkung von 40 entsprechen', 0, 1, 0, 0, '');
INSERT INTO question VALUES (386, 'TA109', 'Wie groß ist der Unterschied zwischen S4 und S7 in dB?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (387, 'TA110', 'Der Pegelwert 120 dB &micro;V/m entspricht einer elektrischen Feldstärke von', 0, 1, 0, 0, '');
INSERT INTO question VALUES (388, 'TA111', '100 mW entspricht', 0, 1, 0, 0, '');
INSERT INTO question VALUES (389, 'TA112', 'Ein Sender mit 1 Watt Ausgangsleistung ist an eine Endstufe mit einer Verstärkung von 10 dB angeschlossen. Wie groß ist der Ausgangspegel der Endstufe?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (390, 'TA113', 'Der Ausgangspegel eines Senders beträgt 20 dBW. Dies entspricht einer Ausgangsleistung von', 0, 1, 0, 0, '');
INSERT INTO question VALUES (391, 'TA114', 'Die Periodendauer von 50 µs entspricht einer Frequenz von', 0, 1, 0, 0, '');
INSERT INTO question VALUES (392, 'TA115', 'Die zweite Harmonische der Frequenz 3,730 MHz befindet sich auf', 0, 1, 0, 0, '');
INSERT INTO question VALUES (393, 'TA116', 'Die zweite ungeradzahlige Harmonische der Frequenz 144,690 MHz ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (394, 'TA117', 'Eine Genauigkeit von 1 ppm entspricht', 0, 1, 0, 0, '');
INSERT INTO question VALUES (395, 'TA118', 'Die digitale Anzeige eines Senders hat eine Anzeigegenauigkeit von 10 ppm. Sie zeigt die Sendefrequenz von 14,25 MHz an. In welchen Grenzen kann sich die tatsächliche Frequenz bewegen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (396, 'TA119', 'Die Ausbreitungsgeschwindigkeit freier elektromagnetischer Wellen beträgt etwa', 0, 1, 0, 0, '');
INSERT INTO question VALUES (397, 'TA120', 'Welche Frequenz entspricht einer Wellenlänge von 30 mm im Freiraum?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (398, 'TA121', 'Eine Wellenlänge von 10 cm im Freiraum entspricht einer Frequenz von', 0, 1, 0, 0, '');
INSERT INTO question VALUES (399, 'TA122', 'Welcher Wellenlänge &lambda; entspricht die Frequenz f = 22 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (400, 'TA123', 'Eine Wellenlänge von 2,06 m entspricht einer Frequenz von', 0, 1, 0, 0, '');
INSERT INTO question VALUES (401, 'TA124', 'Eine Wellenlänge von 69 cm entspricht einer Frequenz von', 0, 1, 0, 0, '');
INSERT INTO question VALUES (402, 'TA125', 'Der Verkürzungsfaktor ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (403, 'TB101', 'Der spezifische Widerstand eines Drahtes entspricht dem Widerstand des Drahtes', 0, 1, 0, 0, '');
INSERT INTO question VALUES (404, 'TB102', 'Welchen Widerstand hat eine Kupferdrahtwicklung, wenn der verwendete Draht eine Länge von 1,8 m und einen Durchmesser von 0,2 mm hat?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (405, 'TB103', 'Zwischen den Enden eines Kupferdrahtes mit einem Querschnitt von 0,5 mm² messen Sie einen Widerstand von 1,5 Ohm. Wie lang ist der Draht?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (406, 'TB104', 'Der Temperaturkoeffizient für den Widerstand von metallischen Leitern ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (407, 'TB105', 'Welche Gruppe von Materialien enthält nur Nichtleiter (Isolatoren)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (408, 'TB106', 'Was versteht man unter Halbleitermaterialien?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (409, 'TB107', 'P-leitendes Halbleitermaterial ist gekennzeichnet durch', 0, 1, 0, 0, '');
INSERT INTO question VALUES (410, 'TB108', 'Was versteht man unter Dotierung zu P-leitendem Halbleitermaterial bei Halbleiterwerkstoffen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (411, 'TB109', 'N-leitendes Halbleitermaterial ist gekennzeichnet durch', 0, 1, 0, 0, '');
INSERT INTO question VALUES (412, 'TB110', 'Was versteht man unter Dotierung zu N-leitendem Halbleitermaterial bei Halbleiterwerkstoffen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (413, 'TB111', 'Das folgende Bild zeigt den prinzipiellen Aufbau einer Halbleiterdiode. Wie entsteht die Sperrschicht?<p><img src=''tb111f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (414, 'TB112', 'In einer Halbleiterdiode erweitert sich die Verarmungszone,<p><img src=''tb111f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (415, 'TB201', 'Ein Sonnenkollektor besteht aus vier parallel geschalteten Reihen von je 30 Solarzellen mit je Zelle 0,6 V Leerlaufspannung und 1 A Kurzschlussstrom. Welche Leerlaufspannung und welchen Kurzschlussstrom liefert der Kollektor? In welcher Zeile sind beide Werte richtig angegeben?<p><img src=''tb201f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (416, 'TB202', 'Die Leerlaufspannung einer Gleichspannungsquelle beträgt 13,5 V. Wenn die Spannungsquelle einen Strom von 0,9 A abgibt, sinkt die Klemmenspannung auf 12,4 V. Wie groß ist der Innenwiderstand der Spannungsquelle?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (417, 'TB203', 'Die Leerlaufspannung einer Gleichspannungsquelle beträgt 13,5 V. Wenn die Spannungsquelle einen Strom von 2 A abgibt, sinkt die Klemmenspannung auf 13 V. Wie groß ist der Innenwiderstand der Spannungsquelle?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (418, 'TB204', 'Die Leerlaufspannung einer Gleichspannungsquelle beträgt 13,5 V. Wenn die Spannungsquelle einen Strom von 1 A abgibt, sinkt die Klemmenspannung auf 12,5 V. Wie groß ist der Wirkungsgrad?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (419, 'TB205', 'Die Leerlaufspannung einer Gleichspannungsquelle beträgt 13,5 V. Wenn die Spannungsquelle einen Strom von 2 A abgibt, sinkt die Klemmenspannung auf 13 V. Wie groß ist der Wirkungsgrad?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (420, 'TB206', 'Die Leerlaufspannung einer Spannungsquelle beträgt 5,0 V. Schließt man einen Belastungswiderstand mit 1,2 &Omega; an, so geht die Klemmenspannung der Spannungsquelle auf 4,8 V zurück. Wie hoch ist der Innenwiderstand der Spannungsquelle?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (421, 'TB207', 'In welchem Zusammenhang müssen Innenwiderstand R<sub>i</sub> und Lastwiderstand R<sub>L</sub> stehen, damit Leistungsanpassung vorliegt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (422, 'TB208', 'In welchem Zusammenhang müssen Innenwiderstand R<sub>i</sub> und Lastwiderstand R<sub>L</sub> stehen, damit Stromanpassung vorliegt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (423, 'TB209', 'In welchem Zusammenhang müssen Innenwiderstand R<sub>i</sub> und Lastwiderstand R<sub>L</sub> stehen, damit Spannungsanpassung vorliegt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (424, 'TB210', 'Welche Eigenschaften sollten Strom- und Spannungsquellen aufweisen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (425, 'TB301', 'An den Metallbelägen eines Wickelkondensators mit 0,15 mm starkem Kunststoff-Dielektrikum liegt eine Spannung von 300 V. Wie hoch ist die elektrische Feldstärke zwischen den Metallbelägen?<p><img src=''tb301f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (426, 'TB302', 'Eine Blockbatterie hat eine Klemmenspannung von 9 V (EMK). Wie groß ist die elektrische Feldstärke zwischen den beiden Polen der Batterie bei einem Polabstand von 0,6 cm?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (427, 'TB303', 'Die elektrische Feldstärke um einen einzelnen Leiter ist proportional', 0, 1, 0, 0, '');
INSERT INTO question VALUES (428, 'TB304', 'Ein HF-Abklatschkondensator am Anodenkreis einer Senderendstufe hat eine 0,15 mm starke PTFE-Folie als Dielektrikum. Die Durchschlagsfestigkeit von PTFE beträgt ca. 400 kV/cm. Wie groß wäre die maximale Spannung, die an den Kondensator angelegt werden kann, ohne dass die Folie durchschlagen wird?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (429, 'TB305', 'Wie nennt man das Feld zwischen zwei parallelen Kondensatorplatten bei Anschluss einer Gleichspannung?<p><img src=''tb305f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (430, 'TB306', 'Wie werden die mit X gekennzeichneten Feldlinien einer Vertikalantenne bezeichnet?<p><img src=''tb306f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (431, 'TB401', 'Ein Ringkern hat einen mittleren Durchmesser von 2,6 cm und trägt 6 Windungen Kupferdraht. Wie groß ist die mittlere magnetische Feldstärke im Ringkern, wenn der Strom 2,5 A beträgt?<p><img src=''tb401f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (432, 'TB402', 'Eine Spule ohne Eisenkern erzeugt eine Feldstärke von 200 A/m. Wie groß ist die magnetische Flussdichte?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (433, 'TB403', 'Welcher Effekt verringert die Induktivität einer von hochfrequentem Strom durchflossenen Spule beim Einführen eines Kupferoder Aluminiumkerns?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (434, 'TB404', 'Dauermagnete finden Anwendung in', 0, 1, 0, 0, '');
INSERT INTO question VALUES (435, 'TB405', 'Wie nennt man das Feld im Innern einer langen Zylinderspule beim Fließen eines Gleichstroms?<p><img src=''tb405f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (436, 'TB406', 'Wenn Strom durch einen gestreckten Leiter fließt, entsteht ein', 0, 1, 0, 0, '');
INSERT INTO question VALUES (437, 'TB407', 'Wie werden die mit X gekennzeichneten Feldlinien einer Vertikalantenne bezeichnet?<p><img src=''tb407f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (438, 'TB408', 'Welches sind die richtigen Einheiten der elektrischen und der magnetischen Feldstärke?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (439, 'TB501', 'Wodurch entsteht ein elektromagnetisches Feld und woraus besteht es?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (440, 'TB502', 'Wie erfolgt die Ausbreitung einer elektromagnetischen Welle? (Im folgenden Text ist H-Feld die magnetische Feldkomponente und E-Feld die elektrische Feldkomponente.)', 0, 1, 0, 0, '');
INSERT INTO question VALUES (441, 'TB503', 'Die Polarisation einer elektromagnetischen Welle wird durch', 0, 1, 0, 0, '');
INSERT INTO question VALUES (442, 'TB504', 'Das folgende Bild zeigt die Feldlinien eines elektromagnetischen Feldes. Welche Polarisation hat die skizzierte Wellenfront?<p><img src=''tb504f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (443, 'TB505', 'Die Polarisation einer elektromagnetischen Welle wird definiert durch', 0, 1, 0, 0, '');
INSERT INTO question VALUES (444, 'TB506', 'Der Winkel zwischen den E- und H-Feldkomponenten eines elektromagnetischen Feldes beträgt im Fernfeld', 0, 1, 0, 0, '');
INSERT INTO question VALUES (445, 'TB507', 'Die Polarisation des Sendesignals in der Hauptstrahlrichtung dieser Richtantenne ist<p><img src=''tb507f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (446, 'TB508', 'Welche Aussage trifft auf die elektromagnetische Ausstrahlung im ungestörten Fernfeld zu?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (447, 'TB509', 'Durch welche Größe sind elektrische und magnetische Komponenten eines elektromagnetischen Feldes im Fernfeld miteinander verknüpft?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (448, 'TB510', 'Eine vertikale Dipolantenne wird mit 10 W Senderleistung direkt gespeist. Welche elektrische Feldstärke ergibt sich bei Freiraumausbreitung in 10 m Entfernung?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (449, 'TB511', 'Eine Yagiantenne mit 12,15 dBi Antennengewinn wird mit 250 W Senderleistung direkt gespeist. Welche elektrische Feldstärke ergibt sich bei Freiraumausbreitung in 30 m Entfernung?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (450, 'TB512', 'Welche elektrische Feldstärke E herrscht in der Mitte der dargestellten, symmetrisch aufgebauten Messzelle, wenn der angeschlossene Sender 1 Watt Ausgangsleistung liefert?<p><img src=''tb512f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (451, 'TB601', 'Welche der im folgenden Diagramm eingezeichneten Gleichspannungen (U<sub>1</sub> ... U<sub>6</sub>) setzen an einem Wirkwiderstand die gleiche Leistung um wie die dargestellte sinusförmige Wechselspannung?<p><img src=''tb601f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (452, 'TB602', 'Wie groß ist der Spitzen-Spitzen-Wert (U<sub>ss</sub>) der in der Abbildung dargestellten Spannung?<p><img src=''tb602f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (453, 'TB603', 'Wie groß ist der Spitzen-Spitzen-Wert der in diesem Schirmbild dargestellten Spannung?<p><img src=''tb603f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (454, 'TB604', 'Welche Frequenz hat die in diesem Oszillogramm dargestellte Spannung?<p><img src=''tb603f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (455, 'TB605', 'Welche Frequenz hat das in diesem Schirmbild dargestellte Signal?<p><img src=''tb605f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (456, 'TB606', 'Welche Frequenz hat die in diesem Oszillogramm dargestellte Spannung?<p><img src=''tb602f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (457, 'TB607', 'Ein sinusförmiges Signal hat einen Effektivwert von 12 V. Wie groß ist der Spitzen-Spitzen-Wert?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (458, 'TB608', 'Der Spitzenwert der häuslichen 230-V-Stromversorgung beträgt', 0, 1, 0, 0, '');
INSERT INTO question VALUES (459, 'TB609', 'Der Spitzen-Spitzen-Wert der häuslichen 230-V-Stromversorgung ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (460, 'TB610', 'Ein sinusförmiger Wechselstrom mit einer Amplitude (I<sub>max</sub>) von 0,5 Ampere fließt durch einen Widerstand von 20 Ohm. Wie hoch ist die aufgenommene Leistung?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (461, 'TB611', 'Welche Antwort enthält die richtigen Phasenwinkel einer sinusförmigen Wechselspannung an der mit X<sub>3</sub> bezeichneten Stelle?<p><img src=''tb611f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (462, 'TB612', 'Die Phasendifferenz zwischen den beiden in der Abbildung dargestellten Sinussignalen beträgt<p><img src=''tb612f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (463, 'TB701', 'Ein symmetrisches Rechtecksignal hat eine Grundfrequenz von 1500 Hz. Welche Frequenzen sind in diesem Signal enthalten?<p><img src=''tb701f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (464, 'TB702', 'Die Impulsdauer beträgt hier<p><img src=''tb702f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (465, 'TB703', 'Was sind Harmonische?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (466, 'TB704', 'Die dritte Oberwelle einer Frequenz ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (467, 'TB705', 'Welche Schwingungen sind in der folgenden Wechselspannung enthalten, wenn die Grundwelle 2 kHz beträgt?<p><img src=''tb705f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (468, 'TB706', 'Welche Schwingungen sind in der folgenden Wechselspannung enthalten, wenn die Grundwelle 2 kHz beträgt?<p><img src=''tb706f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (469, 'TB707', 'Die Leistung eines gleichmäßig über einen Frequenzbereich verteilten Rauschens ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (470, 'TB708', 'Wie verhält sich der Pegel des thermischen Rauschens am Empfängerausgang, wenn von einem Quarzfilter mit einer Bandbreite von 2,5 kHz auf ein Quarzfilter mit einer Bandbreite von 0,5 kHz mit gleicher Durchlassdämpfung und Flankensteilheit umgeschaltet wird? Der Rauschpegel', 0, 1, 0, 0, '');
INSERT INTO question VALUES (471, 'TB801', 'Wie groß ist die HF-Bandbreite, die für die Übertragung eines SSB-Signals erforderlich ist?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (472, 'TB802', 'Ein Träger von 7,05 MHz wird mit der NF-Frequenz von 2 kHz in SSB (LSB) moduliert. Welche Frequenzen treten im modulierten HF-Signal auf?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (473, 'TB803', 'Ein Träger von 145 MHz wird mit der NF-Frequenz von 2 kHz und einem Hub von 1,8 kHz frequenzmoduliert. Welche Bandbreite hat das modulierte Signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (474, 'TB804', 'Warum wird bei FM senderseitig eine Preemphasis eingesetzt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (475, 'TB805', 'Kann man auf der Empfängerseite bei Sprachübertragung Frequenz- und Phasenmodulation unterscheiden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (476, 'TB806', 'Zwei in etwa pegelgleiche Aussendungen können an einer nichtlinear arbeitenden Empfängerstufe', 0, 1, 0, 0, '');
INSERT INTO question VALUES (477, 'TB901', 'Die Ausgangsleistung eines Senders ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (478, 'TB902', 'Die Spitzenleistung eines Senders (PEP) ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (479, 'TB903', 'Die mittlere Leistung eines Senders ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (480, 'TB904', 'Die äquivalente (effektive) Strahlungsleistung (ERP) ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (481, 'TB905', 'Die äquivalente isotrope Strahlungsleistung (EIRP) ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (482, 'TB906', 'Die belegte Bandbreite einer Aussendung ist die Frequenzbandbreite,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (483, 'TB907', 'Was versteht man unter dem Begriff "EIRP"?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (484, 'TB908', 'Die Spitzenleistung eines Senders ist die', 0, 1, 0, 0, '');
INSERT INTO question VALUES (485, 'TB909', 'Wie wird die ERP (Effective Radiated Power oder auch Equivalent Radiated Power) berechnet und worauf ist sie bezogen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (486, 'TB910', 'Wie wird die EIRP ermittelt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (487, 'TB911', 'Um die Störwahrscheinlichkeit zu verringern, sollte die benutzte Sendeleistung', 0, 1, 0, 0, '');
INSERT INTO question VALUES (488, 'TB912', 'Gelten die Formeln für die Leistung an einem ohmschen Widerstand auch bei Wechselspannung?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (489, 'TB913', 'An einem Kondensator mit einer Kapazität von 1 µF wird eine NF-Spannung von 10 kHz und 12 V<sub>eff</sub> angelegt. Wie groß ist die aufgenommene Wirkleistung im eingeschwungenen Zustand?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (490, 'TB914', 'Welche Belastbarkeit muss ein 100-Ohm-Widerstand, an dem 10 Volt anliegen, mindestens haben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (491, 'TB915', 'Eine Glühlampe hat einen Nennwert von 12 V und 48 W. Wie hoch ist die Stromentnahme bei einer 12-V-Versorgung?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (492, 'TB916', 'Der Effektivwert der Spannung an einer künstlichen 50-&Omega;-Antenne wird mit 100 V gemessen. Die Leistung an der Last beträgt', 0, 1, 0, 0, '');
INSERT INTO question VALUES (493, 'TB917', 'Eine künstliche 50-&Omega;-Antenne besteht aus elf 560-&Omega;-Kohleschichtwiderständen mit einem Belastungsnennwert von jeweils 5 W. Wie hoch ist die zulässige Gesamtleistung die angelegt werden darf?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (494, 'TB918', 'Ein mit einer künstlichen 50-&Omega;-Antenne in Serie geschaltetes Amperemeter zeigt 2 A an. Die Leistung in der Last beträgt', 0, 1, 0, 0, '');
INSERT INTO question VALUES (495, 'TB919', 'Ein HF-Verstärker ist an eine 12,5-V-Gleichstrom-Versorgung angeschlossen. Wenn die HF-Ausgangsleistung des Verstärkers 90 W beträgt, zeigt das an die Stromversorgung angeschlossene Amperemeter 16 A an. Der Wirkungsgrad des Verstärkers beträgt', 0, 1, 0, 0, '');
INSERT INTO question VALUES (496, 'TB920', 'Eine HF-Ausgangleistung von 100 W wird in eine angepasste Übertragungsleitung eingespeist. Am antennenseitigen Ende der Leitung beträgt die Leistung 50 W bei einem Stehwellenverhältnis von 1. Wie hoch ist die Leitungsdämpfung?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (497, 'TB921', 'Ein Spannungsmesser und ein Amperemeter werden für die Ermittlung der Gleichstromeingangsleistung einer Schaltung verwendet. Der Spannungsmesser zeigt 10 V, das Amperemeter 10 A an. Falls beide dabei im Rahmen ihrer Messgenauigkeit jeweils einen um 5 % zu geringen Wert anzeigen würden, würde man die elektrische Leistung um', 0, 1, 0, 0, '');
INSERT INTO question VALUES (498, 'TB922', 'An einem Widerstand R wird die elektrische Leistung P in Wärme umgesetzt. Sie kennen die Größen P und R. Nach welcher der Formeln können Sie die Spannung ermitteln, die an dem Widerstand R anliegt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (499, 'TB923', 'In welcher Antwort sind alle dargestellten Zusammenhänge zwischen Strom, Spannung, Widerstand und Leistung richtig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (500, 'TB924', 'In welcher Antwort sind alle dargestellten Zusammenhänge zwischen Widerstand, Leistung, Spannung und Strom richtig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (501, 'TC101', 'Welche Schaltung könnte dazu verwendet werden, den Wert eines Widerstandes anhand des ohmschen Gesetzes zu ermitteln?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (502, 'TC102', 'Metallschichtwiderstände', 0, 1, 0, 0, '');
INSERT INTO question VALUES (503, 'TC103', 'Metalloxidwiderstände', 0, 1, 0, 0, '');
INSERT INTO question VALUES (504, 'TC104', 'Drahtwiderstände', 0, 1, 0, 0, '');
INSERT INTO question VALUES (505, 'TC105', 'Ein Widerstand von 10 k&Omega; hat eine maximale Spannungsfestigkeit von 0,7 kV und eine maximale Belastbarkeit von einem Watt. Welche Gleichspannung darf höchstens an den Widerstand angelegt werden ohne ihn zu überlasten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (506, 'TC106', 'Ein Widerstand von 50 k&Omega; hat eine maximale Spannungsfestigkeit von 0,7 kV und eine maximale Belastbarkeit von 2 Watt. Welche Gleichspannung darf höchstens an den Widerstand angelegt werden ohne ihn zu überlasten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (507, 'TC107', 'Welche Belastbarkeit muss ein Vorwiderstand haben, an dem bei einem Strom von 48 mA eine Spannung von 208 V abfallen soll?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (508, 'TC108', 'Ein Widerstand von 120 &Omega; hat eine Belastbarkeit von 23 Watt. Welcher Strom darf höchstens durch den Widerstand fließen, damit er nicht überlastet wird?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (509, 'TC109', 'Ein Widerstand hat eine Toleranz von 10 %. Bei einem nominalen Widerstandswert von 5,6 k&Omega; liegt der tatsächliche Wert zwischen', 0, 1, 0, 0, '');
INSERT INTO question VALUES (510, 'TC110', 'Eine Glühlampe hat einen Nennwert von 12 V und 3 W. Wie viel Strom fließt beim Anschluss an 12 V?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (511, 'TC111', 'Ein Oszilloskop zeigt einen sinusförmigen Spitze-Spitze-Wert von 25 V an einem 1000-&Omega;-Widerstand an. Der Effektivstrom durch den Widerstand beträgt', 0, 1, 0, 0, '');
INSERT INTO question VALUES (512, 'TC112', 'Ein Lastwiderstand besteht aus zwölf parallelgeschalteten 600-&Omega;-Drahtwiderständen. Er eignet sich höchstens', 0, 1, 0, 0, '');
INSERT INTO question VALUES (513, 'TC113', 'Eine künstliche Antenne für den VHF-Bereich könnte beispielsweise aus', 0, 1, 0, 0, '');
INSERT INTO question VALUES (514, 'TC114', 'Welche der folgenden Bauteile könnten für eine genaue künstliche Antenne, die bei 50 MHz eingesetzt werden soll, verwendet werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (515, 'TC115', 'Aus welchen Bauteilen sollte eine künstliche Antenne für den VHF-Bereich gebaut werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (516, 'TC201', 'Welche Aussage zur Kapazität eines Plattenkondensators ist richtig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (517, 'TC202', 'Welchen zeitlichen Verlauf hat die Spannung an einem entladenen Kondensator, wenn dieser über einen Widerstand an eine Gleichspannungsquelle angeschlossen wird?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (518, 'TC203', 'Ein verlustloser Kondensator wird an eine Wechselspannungsquelle angeschlossen. Welche Phasenverschiebung zwischen Spannung und Strom stellt sich ein?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (519, 'TC204', 'Wie verhält sich der Wechselstromwiderstand eines Kondensators mit zunehmender Frequenz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (520, 'TC205', 'Wie groß ist der kapazitive Widerstand eines 10-pF-Kondensators bei 100 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (521, 'TC206', 'An einem unbekannten Kondensator liegt eine Wechselspannung mit 16 V und 50 Hz. Es wird ein Strom von 32 mA gemessen. Welche Kapazität hat der Kondensator?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (522, 'TC207', 'Was versteht man unter dem Blindwiderstand eines Kondensators und von welchen physikalischen Größen hängt er ab?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (523, 'TC208', 'Neben dem kapazitiven Blindwiderstand treten im Wechselstrom durchflossenen Kondensator auch Verluste auf, die rechnerisch in einem parallelgeschalteten Verlustwiderstand zusammengefasst werden können. Die Kondensatorverluste werden angegeben durch', 0, 1, 0, 0, '');
INSERT INTO question VALUES (524, 'TC209', 'Entsteht in einem Wechselstrom durchflossenen Kondensator eine Verlustleistung?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (525, 'TC301', 'An eine Spule wird über einen Widerstand eine Gleichspannung angelegt. Welches der nachfolgenden Diagramme zeigt den zeitlichen Verlauf der Spannung über der Spule?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (526, 'TC302', 'In einer reinen Induktivität, die an einer Wechselspannungsquelle angeschlossen ist, eilt der Strom der angelegten Spannung', 0, 1, 0, 0, '');
INSERT INTO question VALUES (527, 'TC303', 'Wie verhält sich der Wechselstromwiderstand einer Spule mit zunehmender Frequenz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (528, 'TC304', 'Beim Anlegen einer Gleichspannung U = 1 V an eine Spule messen Sie einen Strom. Wird der Strom beim Anlegen von einer Wechselspannung mit U<sub>eff</sub> = 1 V größer oder kleiner?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (529, 'TC305', 'Wie groß ist der Wechselstromwiderstand einer Spule mit 3 &micro;H Induktivität bei einer Frequenz von 100 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (530, 'TC306', 'Was versteht man unter dem Blindwiderstand einer Spule und von welchen physikalischen Größen hängt er ab?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (531, 'TC307', 'Neben dem induktiven Blindwiderstand treten in der Wechselstrom durchflossenen Spule auch Verluste auf, die rechnerisch in einem seriellen Verlustwiderstand zusammengefasst werden können. Die Verluste einer Spule werden angegeben durch', 0, 1, 0, 0, '');
INSERT INTO question VALUES (532, 'TC308', 'Hat ein gerades Leiterstück eine Induktivität?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (533, 'TC309', 'Wie kann man die Induktivität einer Spule vergrößern?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (534, 'TC310', 'Mit einem Schalenkern dessen A<sub>L</sub>-Wert mit 250 angegeben ist, soll eine Spule mit einer Induktivität von 2 mH hergestellt werden. Wie groß ist die erforderliche Windungszahl?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (535, 'TC311', 'Wie groß ist die Induktivität einer Spule mit 300 Windungen, die auf einen Kern mit einem A<sub>L</sub>-Wert von 1250 gewickelt ist?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (536, 'TC312', 'Wie groß ist die Induktivität einer Spule mit 14 Windungen, die auf einen Kern mit einem A<sub>L</sub>-Wert von 1,5 gewickelt ist?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (537, 'TC313', 'Ein Spulenkern hat einen A<sub>L</sub>-Wert von 30. Wie groß ist die erforderliche Windungszahl zur Herstellung einer Induktivität von 12 µH?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (538, 'TC314', 'Welche Folgen hat der Skin-Effekt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (539, 'TC315', 'Was verstehen Sie unter dem technischen Ausdruck Skin-Effekt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (540, 'TC316', 'Das folgende Bild zeigt einen Kern, um den ein Kabel für den Bau einer Netzdrossel gewickelt ist. Der Kern sollte aus<p><img src=''tb401f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (541, 'TC317', 'Für die Unterdrückung parasitärer Schwingungen kann eine verlustbehaftete Drosselspule verwendet werden. Wie wird eine solche Spule gebaut?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (542, 'TC318', 'Um die Abstrahlungen der Spule eines abgestimmten Schwingkreises zu verringern, sollte die Spule', 0, 1, 0, 0, '');
INSERT INTO question VALUES (543, 'TC319', 'Durch Gegeninduktion wird in einer Spule eine Spannung erzeugt, wenn', 0, 1, 0, 0, '');
INSERT INTO question VALUES (544, 'TC401', 'Ein Trafo liegt an 230 Volt und gibt 11,5 Volt ab. Seine Primärwicklung hat 600 Windungen. Wie groß ist seine Sekundärwindungszahl?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (545, 'TC402', 'Ein Transformator setzt die Spannung von 230 Volt auf 6 Volt herunter und liefert dabei einen Strom von 1,15 A. Wie groß ist der dadurch in der Primärwicklung zu erwartende Strom bei Vernachlässigung der Verluste?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (546, 'TC403', 'Eine Transformatorwicklung hat einen Drahtdurchmesser von 0,5 mm. Die zulässige Stromdichte beträgt 2,5 A/mm². Wie groß ist der zulässige Strom?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (547, 'TC404', 'In dieser Schaltung ist R = 16 k&Omega;. Die Impedanz zwischen den Anschlüssen A und B beträgt somit<p><img src=''tc404f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (548, 'TC405', 'In dieser Schaltung ist R = 6,4 k&Omega;. Die Impedanz zwischen den Anschlüssen A und B beträgt somit<p><img src=''tc404f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (549, 'TC406', 'Für die Anpassung einer 300-&Omega;-Antenne an eine 75-&Omega;-Übertragungsleitung kann ein Übertrager mit einem Windungszahlenverhältnis von', 0, 1, 0, 0, '');
INSERT INTO question VALUES (550, 'TC407', 'Für die Anpassung einer 50-&Omega;-Übertragungsleitung an eine 600-&Omega;-Antenne wird ein Übertrager verwendet. Er sollte ein Windungszahlverhältnis von', 0, 1, 0, 0, '');
INSERT INTO question VALUES (551, 'TC501', 'Wie verhalten sich die Elektronen in einem in Durchlassrichtung betriebenen PN-Übergang?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (552, 'TC502', 'Ein in Durchlassrichtung betriebener PN-Übergang ermöglicht', 0, 1, 0, 0, '');
INSERT INTO question VALUES (553, 'TC503', 'Eine in Sperrrichtung betriebene Diode hat', 0, 1, 0, 0, '');
INSERT INTO question VALUES (554, 'TC504', 'Welche typischen Schwellspannungen haben Germanium- und Siliziumdioden? Sie liegen bei', 0, 1, 0, 0, '');
INSERT INTO question VALUES (555, 'TC505', 'Wie ändert sich die Durchlassspannung einer Diode mit der Temperatur?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (556, 'TC506', 'Bei welcher Bedingung wird eine Siliziumdiode leitend?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (557, 'TC507', 'Die Auswahlantworten enthalten Siliziumdioden mit unterschiedlichen Arbeitspunkten. Bei welcher Antwort befindet sich die Diode in leitendem Zustand?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (558, 'TC508', 'Die Auswahlantworten enthalten Siliziumdioden mit unterschiedlichen Arbeitspunkten. Bei welcher Antwort befindet sich die Diode in leitendem Zustand?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (559, 'TC509', 'Die Auswahlantworten enthalten Siliziumdioden mit unterschiedlichen Arbeitspunkten. Bei welcher Antwort befindet sich die Diode in leitendem Zustand?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (560, 'TC510', 'Die Auswahlantworten enthalten Siliziumdioden mit unterschiedlichen Arbeitspunkten. Bei welcher Antwort befindet sich die Diode in leitendem Zustand?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (561, 'TC511', 'In welcher Zeile sind die Diodentypen der entsprechenden Kennlinie richtig zugeordnet?<p><img src=''tc511f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (562, 'TC512', 'Welche der folgenden Kennlinien ist typisch für eine Germaniumdiode?<p><img src=''tc512f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (563, 'TC513', 'In welcher Zeile sind die Diodentypen der entsprechenden Kennlinie richtig zugeordnet?<p><img src=''tc512f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (564, 'TC514', 'In welcher der folgenden Schaltungen ist die Z-Diode zur Spannungsstabilisierung richtig eingesetzt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (565, 'TC515', 'In welcher der folgenden Schaltungen ist die Z-Diode zur Spannungsstabilisierung richtig eingesetzt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (566, 'TC516', 'Eine unbelastete Z-Diode soll eine 12-VBetriebsspannung auf 5 V stabilisieren. Dabei soll ein Strom von 25 mA durch die Z-Diode fließen. Berechnen Sie den Vorwiderstand. Die Werte des benötigten Vorwiderstandes betragen<p><img src=''tc516f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (567, 'TC517', 'Folgende Schaltung einer Stabilisierungsschaltung mit Z-Diode ist gegeben. Der Strom durch die Z-Diode soll 25 mA betragen und der Laststrom ist 20 mA. Der Wert des notwendigen Vorwiderstandes beträgt<p><img src=''tc517f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (568, 'TC518', 'Eine Leuchtdiode mit einer Durchlassspannung von 1,4 V und einem Durchlassstrom von 20 mA soll an eine Spannungsquelle von 5,0 V angeschlossen werden. Berechnen Sie den Vorwiderstand. Die Größe des benötigten Vorwiderstandes beträgt', 0, 1, 0, 0, '');
INSERT INTO question VALUES (569, 'TC519', 'Folgende Schaltung einer Leuchtdiode wird an einer Betriebsspannung von 5,5 V betrieben. Der Strom durch die Leuchtdiode soll 25 mA betragen, wobei die Durchlassspannung 1,75 V beträgt. Der notwendige Vorwiderstand muss folgende Werte haben.<p><img src=''tc519f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (570, 'TC520', 'Wie verändert sich die Frequenz des Schwingkreises in der folgenden Schaltung, wenn das Potentiometer P mehr in Richtung X gedreht wird?<p><img src=''tc520f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (571, 'TC521', 'Wie verhält sich die Kapazität einer Kapazitätsdiode (Varicap)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (572, 'TC522', 'Welches sind die Haupteigenschaften einer Schottkydiode?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (573, 'TC523', 'Die Hauptfunktion eines Optokopplers ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (574, 'TC524', 'Die Hauptfunktion einer Fotodiode ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (575, 'TC525', 'Das folgende Signal wird als U<sub>1</sub> an den Eingang der Schaltung mit Siliziumdioden gelegt. Wie sieht das zugehörige Ausgangssignal U<sub>2</sub> aus?<p><img src=''tc525f1.jpg''></p><p><img src=''tc525f2.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (576, 'TC526', 'Das folgende Signal wird als U<sub>1</sub> an den Eingang der Schaltung mit Germaniumdioden gelegt. Wie sieht das zugehörige Ausgangssignal U<sub>2</sub> aus?<p><img src=''tc525f1.jpg''></p><p><img src=''tc525f2.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (577, 'TC527', 'In der folgenden Schaltung werden 3 Siliziumdioden zur Entkopplung dreier Stromversorgungen eingesetzt. Der Sonnenkollektor liefert U<sub>1</sub> = 14,9 V. Der Akkumulator hat U<sub>2</sub> = 13,9 V. Das Netzteil ist auf U<sub>3</sub> = 13,5 V eingestellt. In welcher Zeile ist der sich unter diesen Voraussetzungen einstellende Zustand der 3 Dioden richtig beschrieben?<p><img src=''tc527f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (578, 'TC528', 'In welcher der folgenden Schaltungen ist die Diode zur Spannungsbegrenzung einer Schaltstufe richtig eingesetzt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (579, 'TC601', 'Welche Bezeichnungen für die Bauelemente sind richtig? <p>1: <img src=''tc601f1.png''></p><p>2: <img src=''tc601f2.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (580, 'TC602', 'Welche Bezeichnungen für die Bauelemente sind richtig? <p>1: <img src=''tc602f1.png''></p><p>2: <img src=''tc602f2.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (581, 'TC603', 'Der folgende Transistor ist ein<p><img src=''tc603f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (582, 'TC604', 'Welcher der folgenden Transistoren ist ein selbstleitender P-Kanal MOSFET?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (583, 'TC605', 'Welcher der folgenden Transistoren ist ein selbstsperrender N-Kanal MOSFET?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (584, 'TC606', 'Wie bezeichnet man die Anschlüsse 2 und 3 des folgenden Transistors?<p><img src=''tc606f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (585, 'TC607', 'Welche Kollektorspannungen haben NPN und PNP-Transistoren?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (586, 'TC608', 'Welche Transistortypen sind bipolare Transistoren?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (587, 'TC609', 'Wie erfolgt die Steuerung des Stroms im Feldeffekttransistor (FET)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (588, 'TC610', 'Wie groß ist der Kollektorstrom eines bipolaren Transistors, wenn die Spannung an seiner Basis die gleiche Höhe hat wie die Spannung an seinem Emitter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (589, 'TC611', 'Bei welcher Basisspannung ist ein NPN-Transistor ausgeschaltet? Er ist ausgeschaltet bei einer Basisspannung, die', 0, 1, 0, 0, '');
INSERT INTO question VALUES (590, 'TC612', 'Wie groß ist die Basisspannung eines NPN-Silizium-Transistors, wenn sich dieser in leitendem Zustand befindet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (591, 'TC613', 'Bei einem bipolaren Transistor in leitendem Zustand befindet sich die Emitter-Basis-Diode', 0, 1, 0, 0, '');
INSERT INTO question VALUES (592, 'TC614', 'In einer Schaltung wurden die Spannungen der Transistoranschlüsse gegenüber Massepotenzial gemessen. Bei welchem der folgenden Transistoren fließt Kollektorstrom?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (593, 'TC615', 'In einer Schaltung wurden die Spannungen der Transistoranschlüsse gegenüber Massepotenzial gemessen. Bei welchem der folgenden Transistoren fließt Kollektorstrom?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (594, 'TC616', 'In einer Schaltung wurden die Spannungen der Transistoranschlüsse gegenüber Massepotenzial gemessen. Bei welchem der folgenden Transistoren fließt Kollektorstrom?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (595, 'TC617', 'In einer Schaltung wurden die Spannungen der Transistoranschlüsse gegenüber Massepotenzial gemessen. Bei welchem der folgenden Transistoren fließt Kollektorstrom?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (596, 'TC618', 'Die Betriebsspannung beträgt 10 V, der Kollektorstrom soll 2 mA betragen, die Gleichstromverstärkung des Transistors beträgt 200. Berechnen Sie den Vorwiderstand R<sub>1</sub>.<p><img src=''tc618f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (597, 'TC619', 'Die Betriebsspannung beträgt 10 V, der Kollektorstrom soll 2 mA betragen, die Gleichstromverstärkung des Transistors beträgt 200. Durch den Querwiderstand R<sub>2</sub> soll der zehnfache Basisstrom fließen. Berechnen Sie den Vorwiderstand R<sub>1</sub>.<p><img src=''tc619f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (598, 'TC620', 'Die Betriebsspannung beträgt 10 V, der Kollektorstrom soll 2 mA betragen, die Gleichstromverstärkung des Transistors beträgt 200. Durch den Querwiderstand R<sub>2</sub> soll der zehnfache Basisstrom fließen. Am Emitterwiderstand soll 1 V abfallen. Berechnen Sie den Vorwiderstand R<sub>1</sub>.<p><img src=''tc620f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (599, 'TC621', 'Die Betriebsspannung beträgt 10 V, der Kollektorstrom soll 2 mA betragen, die Gleichstromverstärkung des Transistors beträgt 200. Die Kollektor-Emitterspannung soll 6 V betragen. Berechnen Sie den Vorwiderstand R<sub>1</sub>.<p><img src=''tc621f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (600, 'TC622', 'Die Betriebsspannung beträgt 10 V, der Kollektorstrom soll 2 mA betragen, die Gleichstromverstärkung des Transistors beträgt 100. Die Kollektor-Emitterspannung soll 6 V betragen. Berechnen Sie den Kollektorwiderstand R<sub>C</sub>.<p><img src=''tc621f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (601, 'TC623', 'Was passiert, wenn der Widerstand R<sub>2</sub> durch eine fehlerhafte Lötstelle an einer Seite keinen Kontakt mehr zur Schaltung hat (Leerlauf)? In welcher Zeile sind beide Aussagen richtig?<p><img src=''tc623f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (602, 'TC624', 'Was passiert, wenn der Widerstand R<sub>1</sub> durch eine fehlerhafte Lötstelle an einer Seite keinen Kontakt mehr zur Schaltung hat (Leerlauf)? In welcher Zeile sind beide Aussagen richtig?<p><img src=''tc623f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (603, 'TC625', 'Bei folgender Emitterschaltung wird die Schaltung ohne den Emitterkondensator betrieben. Auf welchen Betrag etwa sinkt die Spannungsverstärkung?<p><img src=''tc625f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (604, 'TC626', 'Folgendes Signal U<sub>E</sub> wurde auf den Eingang folgender Schaltung gegeben. In welcher Antwort sind alle dargestellten Signale phasenrichtig zugeordnet?<p><img src=''tc626f1.jpg''></p><p><img src=''tc626f2.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (605, 'TC701', 'Eine integrierte Schaltung ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (606, 'TC702', 'Welche Funktion hat ein Gatter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (607, 'TC703', 'Wie heißen die Grundbausteine in der Digitaltechnik?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (608, 'TC704', 'Welche der Aussagen trifft für diese Schaltung zu?<p><img src=''tc704f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (609, 'TC705', 'Welche logische Grundschaltung stellt die folgende Transistorschaltung dar und wie arbeitet sie?<p><img src=''tc705f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (610, 'TC706', 'Welche logische Grundschaltung stellt die folgende Transistorschaltung dar und wie arbeitet sie?<p><img src=''tc706f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (611, 'TC707', 'Welches der vier im Bild dargestellten Ausgangssignale X<sub>1</sub> bis X<sub>4</sub> liefert ein ODER-Gatter, wenn an dessen Eingängen die Signale E<sub>1</sub> und E<sub>2</sub> anliegen?<p><img src=''tc707f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (612, 'TC708', 'Welches der vier im Bild dargestellten Ausgangssignale X<sub>1</sub> bis X<sub>4</sub> liefert ein EXOR-Gatter, wenn an dessen Eingängen die Signale E<sub>1</sub> und E<sub>2</sub> anliegen?<p><img src=''tc707f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (613, 'TC709', 'Welches der vier im Bild dargestellten Ausgangssignale X<sub>1</sub> bis X<sub>4</sub> liefert ein UND-Gatter, wenn an dessen Eingängen die Signale E<sub>1</sub> und E<sub>2</sub> anliegen?<p><img src=''tc707f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (614, 'TC710', 'In welchem Versorgungsspannungsbereich können CMOS-ICs betrieben werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (615, 'TC711', 'Was ist ein Operationsverstärker?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (616, 'TC712', 'Welche Eigenschaften hat folgende Operationsverstärkerschaltung? In welcher Zeile stimmen alle drei Eigenschaften?<p><img src=''tc712f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (617, 'TC713', 'Wie groß ist der Betrag der Spannungsverstärkung U<sub>A</sub>/U<sub>E</sub> der folgenden Operationsverstärkerschaltung?<p><img src=''tc713f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (618, 'TC714', 'Wie groß ist die Spannungsverstärkung U<sub>A</sub>/U<sub>E</sub> der folgenden Operationsverstärkerschaltung?<p><img src=''tc714f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (619, 'TC715', 'Der Eingangswiderstand der folgenden Operationsverstärkerschaltung soll 1 k&Omega; betragen und es wird eine Spannungsverstärkung von zirka 20 erwünscht. Wie groß muss der Rückkopplungswiderstand R<sub>2</sub> sein?<p><img src=''tc715f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (620, 'TC716', 'Welche der folgenden Operationsverstärkerschaltungen arbeitet als invertierender Spannungsverstärker richtig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (621, 'TC717', 'Welche der folgenden Operationsverstärkerschaltungen arbeitet als nichtinvertierender Spannungsverstärker richtig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (622, 'TC718', 'Worauf beruht die Verstärkerwirkung von Elektronenröhren?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (623, 'TC719', 'In folgender Schaltung mit Elektronenröhre wird die Spannung -U<sub>g</sub> am Steuergitter erniedrigt (negativer gemacht). Wie verändert sich der Anodenstrom?<p><img src=''tc719f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (624, 'TC720', 'Berechnen Sie den dezimalen Wert der 8-Bit-Dualzahl 10001110. Die Dezimalzahl lautet', 0, 1, 0, 0, '');
INSERT INTO question VALUES (625, 'TC721', 'Wie lautet der dezimale Wert der zweistelligen Hexadezimalzahl 1A? Die Dezimalzahl lautet', 0, 1, 0, 0, '');
INSERT INTO question VALUES (626, 'TC722', 'Welche dezimalen Werte haben die Stellen der Dualzahl 111111 von links nach rechts?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (627, 'TD101', 'Wie groß ist der Gesamtwiderstand dieser Schaltung, wenn R<sub>1</sub> = 3,3 k&Omega;, R<sub>2</sub> = 4,7 k&Omega; und R<sub>3</sub> = 27 k&Omega; betragen?<p><img src=''td101f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (628, 'TD102', 'Eine Reihenschaltung besteht aus drei Kondensatoren von je 0,03 µF. Wie groß ist die Gesamtkapazität dieser Schaltung?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (629, 'TD103', 'Wie groß ist die Gesamtkapazität von drei parallel geschalteten Kondensatoren von 20 nF, 0,03 µF und 15000 pF?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (630, 'TD104', 'Wie groß ist die Gesamtinduktivität von drei in Reihe geschalteten Spulen von 2000 nH, 0,03 mH und 1500 µH?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (631, 'TD105', 'Wie groß ist die Gesamtinduktivität von drei parallel geschalteten Spulen von 2000 nH, 0,03 mH und 1500 µH?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (632, 'TD106', 'Wie groß ist die Gesamtkapazität, wenn drei Kondensatoren C1 = 0,06 nF, C<sub>2</sub> = 40 pF und C3 = 20 pF in Reihe geschaltet werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (633, 'TD107', 'Wie groß ist der Gesamtwiderstand der dargestellten Schaltung?<p><img src=''td107f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (634, 'TD108', 'Wie teilt sich die Spannung an zwei in Reihe geschalteten Widerständen auf, wenn R<sub>1</sub> = 5 mal so groß ist wie R<sub>2</sub> ?<p><img src=''td108f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (635, 'TD109', 'Wie teilt sich die Spannung an zwei in Reihe geschalteten Widerständen auf, wenn R<sub>1</sub> = 1/6 mal so groß ist wie R<sub>2</sub> ?<p><img src=''td108f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (636, 'TD110', 'Was ist bei der Berechnung von Wechselstromkreisen, die Kombinationen von R, L und C enthalten, zu beachten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (637, 'TD111', 'Wie groß ist die Spannung U, wenn durch R<sub>3</sub> ein Strom von 1 mA fließt und alle Widerstände R<sub>1</sub> bis R<sub>3</sub> je 10 k&Omega; betragen?<p><img src=''td111f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (638, 'TD112', 'Wie groß ist der Strom durch R<sub>3</sub>, wenn U = 15 V und alle Widerstände R<sub>1</sub> bis R<sub>3</sub> je 10 k&Omega; betragen?<p><img src=''td111f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (639, 'TD113', 'Welche Leistung tritt in R<sub>2</sub> auf, wenn U = 15 V und alle Widerstände R<sub>1</sub> bis R<sub>3</sub> je 10 k&Omega; betragen?<p><img src=''td111f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (640, 'TD114', 'Drei gleich große parallel geschaltete Widerstände haben einen Gesamtwiderstand von 1,67 k&Omega;. Welchen Wert hat jeder Einzelwiderstand?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (641, 'TD115', 'Welche Belastbarkeit kann die Zusammenschaltung von drei gleich großen Widerständen mit einer Einzelbelastbarkeit von je 1 W erreichen, wenn alle 3 Widerstände entweder parallel oder in Reihe geschaltet werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (642, 'TD116', 'Welche Gesamtkapazität ergibt sich bei einer Parallelschaltung der Kondensatoren 0,1 µF; 150 nF und 50000 pF?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (643, 'TD117', 'Welche Gesamtkapazität ergibt sich bei einer Reihenschaltung der Kondensatoren 0,1 µF; 150 nF und 50000 pF?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (644, 'TD118', 'Welche Gesamtkapazität hat diese Schaltung, wenn C<sub>1</sub> = 0,01 µF, C<sub>2</sub> = 5 nF und C<sub>3</sub> = 5000 pF betragen?<p><img src=''td118f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (645, 'TD119', 'Welche Gesamtkapazität hat diese Schaltung, wenn C<sub>1</sub> = 2 µF, C<sub>2</sub> = 1 µF und C<sub>3</sub> = 1 µF betragen?<p><img src=''td118f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (646, 'TD120', 'Wie groß ist die Gesamtkapazität dieser Schaltung, wenn C<sub>1</sub> = 0,1 nF, C<sub>2</sub> = 1,5 nF, C<sub>3</sub> = 220 pF und die Eigenkapazität der Spule 1 pF beträgt?<p><img src=''td120f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (647, 'TD121', 'Wenn R<sub>1</sub> und R<sub>3</sub> je 2 k&Omega; hat und R<sub>2</sub> und R<sub>4</sub> je 200 &Omega; betragen, hat die Schaltung einen Gesamtwiderstand von<p><img src=''td121f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (648, 'TD122', 'In welchem Bereich bewegt sich der Eingangswiderstand der folgenden Schaltung, wenn R alle Werte von 0 bis unendlich durchläuft?<p><img src=''td122fj.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (649, 'TD123', 'Wie groß ist der Gesamtwiderstand dieser Schaltung, wenn R<sub>1</sub> = 30 k&Omega;, R<sub>2</sub> = 15 k&Omega;, R<sub>3</sub> = 30 k&Omega; und R<sub>4</sub> = 2,7 k&Omega; betragen?<p><img src=''td123f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (650, 'TD124', 'Wie groß ist der Gesamtwiderstand dieser Schaltung, wenn R<sub>1</sub> = 12 k&Omega;, R<sub>2</sub> = 12 k&Omega;, R<sub>3</sub> = 6 k&Omega; und R<sub>4</sub> = 1,5 k &Omega;betragen?<p><img src=''td123f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (651, 'TD201', 'Der Impedanzfrequenzgang in der Abbildung zeigt die Kennlinie<p><img src=''td201f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (652, 'TD202', 'Der im folgenden Bild dargestellte Impedanzfrequenzgang ist typisch für<p><img src=''td202f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (653, 'TD203', 'Was ist im Resonanzfall bei der Reihenschaltung einer Induktivität mit einer Kapazität erfüllt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (654, 'TD204', 'Welcher Schwingkreis passt zu dem neben der jeweiligen Schaltung dargestellten Verlauf des Scheinwiderstandes?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (655, 'TD205', 'Kann die Wicklung eines Übertragers zusammen mit einem Kondensator als Schwingkreis dienen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (656, 'TD206', 'Wie ändert sich die Resonanzfrequenz eines Schwingkreises, wenn 1. die Spule mehr Windungen erhält,<br> 2. die Länge der Spule durch Zusammenschieben der Drahtwicklung verringert wird,<br> 3. ein Kupferkern in das Innere der Spule gebracht wird?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (657, 'TD207', 'Wie groß ist die Resonanzfrequenz dieser Schaltung, wenn C<sub>1</sub> = 0,1 nF, C<sub>2</sub> = 1,5 nF, C<sub>3</sub> = 220 pF und L = 1 mH beträgt?<p><img src=''td207f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (658, 'TD208', 'Welche Resonanzfrequenz f<sub>res</sub> hat die Reihenschaltung einer Spule von 100 µH mit einem Kondensator von 0,01 µF und einem Widerstand von 100 &Omega;?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (659, 'TD209', 'Welche Resonanzfrequenz f<sub>res</sub> hat die Parallelschaltung einer Spule von 2 µH mit einem Kondensator von 60 pF und einem Widerstand von 10 k&Omega; ?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (660, 'TD210', 'Wie groß ist die Resonanzfrequenz dieser Schaltung, wenn C = 6,8 pF, R = 10 &Omega; und L = 1 µH beträgt?<p><img src=''td210f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (661, 'TD211', 'Wie groß ist die Resonanzfrequenz dieser Schaltung, wenn C = 1 nF, R = 0,1 k&Omega; und L = 10 µH beträgt?<p><img src=''td210f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (662, 'TD212', 'Bei Resonanz ist die Impedanz dieser Schaltung<p><img src=''td210f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (663, 'TD213', 'Welche Grenzfrequenz ergibt sich bei einem Tiefpass mit einem Widerstand von 10 k&Omega; und einem Kondensator von 50 nF?<p><img src=''td213f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (664, 'TD214', 'Welchen Gütefaktor Q hat die Reihenschaltung einer Spule von 100 µH mit einem Kondensator von 0,01 µF und einem Widerstand von 10 &Omega; ?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (665, 'TD215', 'Welchen Gütefaktor Q hat die Parallelschaltung einer Spule von 2 µH mit einem Kondensator von 60 pF und einem Widerstand von 1 k&Omega;?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (666, 'TD216', 'Welche Bandbreite B hat die Reihenschaltung einer Spule von 100 µH mit einem Kondensator von 0,01 µF und einem Widerstand von 10 &Omega;?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (667, 'TD217', 'Welche Bandbreite B hat die Parallelschaltung einer Spule von 2 µH mit einem Kondensator von 60 pF und einem Widerstand von 1 k&Omega;?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (668, 'TD218', 'Wie ergibt sich die Bandbreite B eines Schwingkreises aus der Resonanzkurve?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (669, 'TD219', 'Was stellt diese Schaltung dar?<p><img src=''td219f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (670, 'TD220', 'Was stellt diese Schaltung dar?<p><img src=''td220f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (671, 'TD221', 'Was stellt diese Schaltung dar?<p><img src=''td221f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (672, 'TD222', 'Was stellt diese Schaltung dar?<p><img src=''td222f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (673, 'TD223', 'Bei dem dargestellten Filter handelt es sich um ein<p><img src=''td223f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (674, 'TD224', 'Welche der nachfolgenden Beschreibungen trifft auf diese Schaltung zu und wie nennt man sie?<p><img src=''td224f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (675, 'TD225', 'Im folgenden Bild ist ein Filter dargestellt. Es handelt sich um ein<p><img src=''td225f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (676, 'TD226', 'Welche Schaltung stellt ein Hochpassfilter dar?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (677, 'TD227', 'Für HF-Filter sollten vorzugsweise', 0, 1, 0, 0, '');
INSERT INTO question VALUES (678, 'TD228', 'Welche Kopplung eines Bandfilters wird "kritische Kopplung" genannt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (679, 'TD229', 'Das folgende Bild zeigt ein induktiv gekoppeltes Bandfilter und vier seiner möglichen Übertragungskurven (a bis d). Welche der folgenden Aussagen ist richtig?<p><img src=''td229f1.png''></p><p><img src=''td229f2.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (680, 'TD230', 'Das folgende Bild zeigt ein typisches ZF-Filter und vier seiner möglichen Übertragungskurven (a bis d). Welche Kurve ergibt sich bei kritischer Kopplung und welche bei überkritischer Kopplung?<p><img src=''td229f1.png''></p><p><img src=''td229f2.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (681, 'TD231', 'Ein Quarzfilter mit einer der 3-dB-Bandbreite von 2,3 kHz eignet sich besonders zur Verwendung in einem Sendeempfänger für', 0, 1, 0, 0, '');
INSERT INTO question VALUES (682, 'TD232', 'Ein Quarzfilter mit einer der 3-dB-Bandbreite von 6 kHz eignet sich besonders zur Verwendung in einem Empfänger für', 0, 1, 0, 0, '');
INSERT INTO question VALUES (683, 'TD233', 'Ein Quarzfilter mit einer der 3-dB-Bandbreite von 12 kHz eignet sich besonders zur Verwendung in einem Sendeempfänger für', 0, 1, 0, 0, '');
INSERT INTO question VALUES (684, 'TD234', 'Ein Quarzfilter mit einer der 3-dB-Bandbreite von 500 Hz eignet sich besonders zur Verwendung in einem Sendeempfänger für', 0, 1, 0, 0, '');
INSERT INTO question VALUES (685, 'TD301', 'Welche Form hat die Ausgangsspannung der dargestellten Schaltung?<p><img src=''td301f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (686, 'TD302', 'Welche Ausgangsspannung wird erzeugt, wenn an die dargestellte Schaltung eine Wechselspannung angelegt wird?<p><img src=''td302f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (687, 'TD303', 'Kann für den Kondensator der folgenden Schaltung ein Elektrolytkondensator verwendet werden?<p><img src=''td302f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (688, 'TD304', 'Falls nachgewiesen wird, dass Störungen über das Stromversorgungsnetz in Geräte eindringen, ist wahrscheinlich', 0, 1, 0, 0, '');
INSERT INTO question VALUES (689, 'TD305', 'Wie groß ist die Spannung am Siebkondensator Cs im Leerlauf, wenn die primäre Trafospannung 230 Volt und das Windungsverhältnis 8:1 beträgt? Die Spannung beträgt etwa<p><img src=''td305f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (690, 'TD306', 'Welche Aussage enthält die richtige Beschreibung der Funktionsweise der Regelung in diesem Netzteil, wenn die Ausgangsspannung bei Belastung absinkt?<p><img src=''td306f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (691, 'TD307', 'Eine Hochspannungs-Stromversorgung ist mit mehreren in Reihe geschalteten Gleichrichterdioden ausgestattet. Welches Bauelement sollte zu jeder Diode wie zugeschaltet sein?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (692, 'TD308', 'Für welchen Zweck werden Z-Dioden primär eingesetzt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (693, 'TD309', 'Welche der folgenden Auswahlantworten enthält die richtige Diodenanordnung und Polarität eines Brückengleichrichters?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (694, 'TD310', 'Welche Beziehung muss zwischen der Eingangspannung und der Ausgangsspannung der folgenden Schaltung bestehen, damit der Spannungsregler Q1 seine Funktion erfüllen kann?<p><img src=''td310f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (695, 'TD311', 'Welchen Verlauf hat die Spannung U ?<p><img src=''td311f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (696, 'TD312', 'Die Ausgangsspannung zwischen A und B in der Schaltung beträgt ungefähr<p><img src=''td312f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (697, 'TD313', 'Bei einem Transformationsverhältnis von 5:1 sollte die Spannungsfestigkeit der Diode (max. Spannung plus 10 % Sicherheitsaufschlag) in dieser Schaltung nicht weniger als<p><img src=''td313f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (698, 'TD314', 'Bei einem Transformationsverhältnis von 8:1 sollte die Spannungsfestigkeit der Diode (max. Spannung plus 10 % Sicherheitsaufschlag) in dieser Schaltung nicht weniger als<p><img src=''td313f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (699, 'TD315', 'Welche Gleichrichterschaltung erzeugt eine Vollweg-Gleichrichtung mit der angezeigten Polarität?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (700, 'TD316', 'Bei der Verbindung der Stromversorgung mit HF-Leistungsverstärkern ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (701, 'TD317', 'Welche Funktion hat der Block E bei einem Schaltnetzteil?<p><img src=''td317f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (702, 'TD318', 'Welches ist der Hauptnachteil eines Schaltnetzteils gegenüber einem Netzteil mit Längsregelung?<p><img src=''td317f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (703, 'TD319', 'Welche Ausgangsspannung entsteht mit folgender Spannungsregler-Schaltung?<p><img src=''td319f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (704, 'TD320', 'Im folgenden Bild ist die Spannung am Ausgang einer Stromversorgung dargestellt. Die Restwelligkeit und die Brummfrequenz betragen<p><img src=''td320f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (705, 'TD321', 'Welche Grundfrequenz hat die Ausgangsspannung eines Vollweggleichrichters, der an eine 50-Hz-Versorgung angeschlossen ist?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (706, 'TD322', 'Welche der dargestellten Schaltungen könnte in den Netzeingang eines Geräts eingebaut werden, um HF-Rückfluss in das Stromversorgungsnetz zu verringern?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (707, 'TD401', 'Bei dieser Schaltung handelt es sich um<p><img src=''td401f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (708, 'TD402', 'Welche Funktion haben die Widerstände R<sub>1</sub> und R<sub>2</sub> in der folgenden Schaltung? Sie dienen zur<p><img src=''td402f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (709, 'TD403', 'Welche Funktion hat der Kondensator C<sub>1</sub> in der folgenden Schaltung? Er dient zur<p><img src=''td403f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (710, 'TD404', 'Wie verhält sich die Spannungs-Verstärkung bei der folgenden Schaltung, wenn der Kondensator C<sub>1</sub> entfernt wird?<p><img src=''td403f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (711, 'TD405', 'Welche Funktion haben die Kondensatoren C<sub>1</sub> und C<sub>2</sub> in der folgenden Schaltung? Sie dienen zur<p><img src=''td405f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (712, 'TD406', 'Was lässt sich über die Wechselspannungsverstärkung v<sub>U</sub> und die Phasenverschiebung &phi; zwischen Ausgangs- und Eingangsspannung dieser Schaltung aussagen?<p><img src=''td401f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (713, 'TD407', 'Was lässt sich über den Wechselstromeingangswiderstand r<sub>e</sub> und den Wechselstromausgangswiderstand r<sub>a</sub> dieser Vorverstärkerschaltung aussagen?<p><img src=''td401f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (714, 'TD408', 'Bei dieser Schaltung handelt es sich um<p><img src=''td408f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (715, 'TD409', 'Was lässt sich über die Wechselspannungsverstärkung v<sub>U</sub> und die Phasenverschiebung &phi; zwischen Ausgangs- und Eingangsspannung dieser Schaltung aussagen?<p><img src=''td408f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (716, 'TD410', 'In welchem Bereich liegt der Wechselstrom-Eingangswiderstand eines Emitterfolgers?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (717, 'TD411', 'In welchem Bereich liegt der Wechselstrom-Ausgangswiderstand eines Emitterfolgers?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (718, 'TD412', 'Die Ausgangsimpedanz dieser Schaltung ist<p><img src=''td408f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (719, 'TD413', 'Diese Schaltung kann unter anderem als<p><img src=''td408f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (720, 'TD414', 'Das folgende Oszillogramm zeigt die Ausgangsspannung eines Verstärkers, an dessen Eingang eine rein sinusförmige Wechselspannung anliegt. Welche Harmonische wird von dem Verstärker erzeugt?<p><img src=''tb705f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (721, 'TD415', 'Das folgende Oszillogramm zeigt die Ausgangsspannung eines Verstärkers, an dessen Eingang eine rein sinusförmige Wechselspannung anliegt. Welche Harmonische wird von dem Verstärker erzeugt?<p><img src=''tb706f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (722, 'TD416', 'Ein NF-Verstärker hebt die Eingangsspannung von 1 mV auf 4 mV Ausgangsspannung an. Eingangs- und Ausgangswiderstand sind gleich. Wie groß ist die Spannungsverstärkung des Verstärkers?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (723, 'TD417', 'Ein Leistungsverstärker hebt die Eingangsleistung von 2,5 Watt auf 38 Watt Ausgangsleistung an. Dem entspricht eine Leistungsverstärkung von', 0, 1, 0, 0, '');
INSERT INTO question VALUES (724, 'TD418', 'Ein HF-Leistungsverstärker hat eine Verstärkung von 16 dB. Welche HF-Ausgangsleistung ist zu erwarten, wenn der Verstärker mit 1 W HF-Eingangsleistung angesteuert wird?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (725, 'TD419', 'Das folgende Bild zeigt eine idealisierte Steuerkennlinie eines Transistors mit vier eingezeichneten Arbeitspunkten P<sub>1</sub> bis P<sub>4</sub>. Welcher Arbeitspunkt ist welcher Verstärkerbetriebsart zuzuordnen?<p><img src=''td419f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (726, 'TD420', 'Welche Merkmale hat ein HF-Leistungsverstärker im A-Betrieb?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (727, 'TD421', 'Welche Merkmale hat ein HF-Leistungsverstärker im B-Betrieb?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (728, 'TD422', 'Welche Merkmale hat ein HF-Leistungsverstärker im C-Betrieb?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (729, 'TD423', 'Ein HF-Leistungsverstärker im A-Betrieb wird mit einer Anodenspannung von 800 V und einem Anodenstrom von 130 mA betrieben. Wie hoch ist die zu erwartende Ausgangsleistung des Verstärkers?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (730, 'TD424', 'Ein HF-Leistungsverstärker im C-Betrieb wird mit einer Anodenspannung von 800 V und einem Anodenstrom von 130 mA betrieben. Wie hoch ist die zu erwartende Ausgangsleistung des Verstärkers?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (731, 'TD425', 'In welcher Größenordnung liegt der Ruhestrom eines HF-Leistungsverstärkers im C-Betrieb?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (732, 'TD426', 'Eine Treiberstufe eines HF-Verstärkers braucht am Eingang eine Leistung von 1 Watt um am Ausgang 10 Watt an die Endstufe abgeben zu können. Sie benötigt dazu eine Gleichstromleistung von 25 Watt. Wie hoch ist der Wirkungsgrad der Treiberstufe?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (733, 'TD427', 'Wenn ein linearer HF-Leistungsverstärker im AB-Betrieb durch ein SSB-Signal übersteuert wird, führt dies zu', 0, 1, 0, 0, '');
INSERT INTO question VALUES (734, 'TD428', 'Welche Baugruppe sollte für die Begrenzung der NF-Bandbreite eines Mikrofonverstärkers verwendet werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (735, 'TD429', 'Was ist die Ursache für Eigenschwingungen eines Verstärkers?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (736, 'TD430', 'Welche Art von Schaltung wird im folgenden Bild dargestellt? Es handelt sich um einen<p><img src=''td430f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (737, 'TD431', 'An den Eingang dieser Schaltung wird das folgende Signal gelegt. Welches ist ein mögliches Ausgangssignal U<sub>A</sub>?<p><img src=''td431f1.png''></p><p><img src=''td431f2.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (738, 'TD432', 'An den Eingang dieser Schaltung wird das folgende Signal gelegt. Welches ist ein mögliches Ausgangssignal U<sub>A</sub>?<p><img src=''td432f1.png''></p><p><img src=''td431f2.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (739, 'TD501', 'Bei dieser Schaltung handelt es sich um einen<p><img src=''td501f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (740, 'TD502', 'Bei dieser Schaltung ist der mit X bezeichnete Anschluss<p><img src=''td502f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (741, 'TD503', 'Am ZF-Eingang der folgenden Schaltung liegt ein sinusförmig moduliertes AM-Signal. Welches der folgenden Signale zeigt sich dabei an dem mit X bezeichneten Punkt der Schaltung?<p><img src=''td503f1.jpg''></p><p><img src=''td503f2.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (742, 'TD504', 'Am ZF-Eingang der folgenden Schaltung liegt ein sinusförmig moduliertes AM-Signal. Welches der folgenden Signale zeigt sich dabei an dem mit X bezeichneten Punkt der Schaltung?<p><img src=''td504f1.png''></p><p><img src=''td503f2.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (743, 'TD505', 'Bei dieser Schaltung handelt es sich um einen<p><img src=''td505f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (744, 'TD506', 'Bei dieser Schaltung handelt es sich um einen<p><img src=''td506f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (745, 'TD507', 'Bei dieser Schaltung handelt es sich um einen<p><img src=''td507f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (746, 'TD508', 'Bei dieser Schaltung handelt es sich um einen<p><img src=''td508f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (747, 'TD509', 'Bei dieser Schaltung handelt es sich um einen<p><img src=''td509f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (748, 'TD510', 'Bei dieser Schaltung handelt es sich um einen<p><img src=''td510f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (749, 'TD511', 'Bei dieser Schaltung handelt es sich um einen<p><img src=''td511f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (750, 'TD512', 'Durch Addition eines Nutz- oder Störsignals zur Versorgungsspannung der Senderendstufe wird', 0, 1, 0, 0, '');
INSERT INTO question VALUES (751, 'TD513', 'Bei dieser Schaltung handelt es sich um einen Modulator zur Erzeugung von<p><img src=''td513f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (752, 'TD514', 'Bei dieser Schaltung handelt es sich um einen Modulator zur Erzeugung von<p><img src=''td514f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (753, 'TD515', 'Bei dieser Schaltung handelt es sich um einen Modulator zur Erzeugung von<p><img src=''td515f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (754, 'TD601', 'Bei dieser Schaltung handelt es sich um<p><img src=''td601f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (755, 'TD602', 'Bei dieser Schaltung handelt es sich um<p><img src=''td602f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (756, 'TD603', 'Bei dieser Schaltung handelt es sich um<p><img src=''td603f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (757, 'TD604', 'Bei dieser Oszillatorschaltung handelt es sich um einen kapazitiv rückgekoppelten Quarz-Oszillator in<p><img src=''td604f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (758, 'TD605', 'Bei dieser Oszillatorschaltung handelt es sich um einen kapazitiv rückgekoppelten Quarz-Oszillator in<p><img src=''td605f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (759, 'TD606', 'Ist die folgende Schaltung als Oberton-Oszillator geeignet?<p><img src=''td606f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (760, 'TD607', 'Was ist ein VCO und wie funktioniert er?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (761, 'TD608', 'Für die Messung der Oszillatorfrequenz sollte der Tastkopf hier vorzugsweise am Punkt<p><img src=''td608f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (762, 'TD609', 'Welche Bedingungen müssen zur Erzeugung ungedämpfter Schwingungen in Oszillatoren erfüllt sein?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (763, 'TD610', 'Die Bezeichnungen "Colpitts" und "Hartley" stehen für', 0, 1, 0, 0, '');
INSERT INTO question VALUES (764, 'TD611', '"Chirp" ist eine Form der Frequenzinstabilität. Es wird hervorgerufen durch', 0, 1, 0, 0, '');
INSERT INTO question VALUES (765, 'TD612', 'Wie verhält sich die Frequenz eines Oszillators bei Temperaturanstieg, wenn die Kapazität des Schwingkreiskondensators mit dem Temperaturanstieg ebenfalls ansteigt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (766, 'TD613', 'Wie verhält sich die Frequenz eines Oszillators bei Temperaturanstieg, wenn die Kapazität des Schwingkreiskondensators mit dem Temperaturanstieg geringer wird?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (767, 'TD614', 'Im VFO eines Senders steigt die Induktivität der Spule mit der Temperatur. Der Kondensator bleibt sehr stabil. Welche Auswirkungen hat dies bei steigender Temperatur?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (768, 'TD615', 'Der Vorteil von Quarzoszillatoren gegenüber LC-Oszillatoren liegt darin, dass sie', 0, 1, 0, 0, '');
INSERT INTO question VALUES (769, 'TD701', 'Welche der nachfolgenden Aussagen ist richtig, wenn die im Bild dargestellte Regelschleife in stabilem Zustand ist?<p><img src=''td701f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (770, 'TD702', 'Ein Frequenzsynthesizer soll eine einstellbare Frequenz mit hoher Frequenzgenauigkeit erzeugen. Die Genauigkeit und Stabilität der Ausgangsfrequenz eines Frequenzsynthesizers wird hauptsächlich bestimmt von', 0, 1, 0, 0, '');
INSERT INTO question VALUES (771, 'TD703', 'Welchen Einfluss kann der Tiefpass in der Phasenregelschleife (PLL) auf das vom spannungsgesteuerten Oszillator (VCO) erzeugte Ausgangssignal haben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (772, 'TD704', 'Welche Baugruppen muss eine Phasenregelschleife (PLL) mindestens enthalten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (773, 'TD705', 'Die Ausgangsfrequenz eines VCO ändert sich von 16,5 MHz auf 16,75 MHz, wenn sich die Regelspannung von 5,1 V auf 7,6 V ändert. Welche Regelempfindlichkeit hat der VCO?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (774, 'TD706', 'Die Frequenz an Punkt A beträgt 12,5 kHz. Es sollen Ausgangsfrequenzen im Bereich von 12,000 MHz bis 14,000 MHz erzeugt werden. In welchem Bereich bewegt sich dabei das Teilerverhältnis n?<p><img src=''td701f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (775, 'TD707', 'Wie groß muss bei der folgenden Schaltung die Frequenz an Punkt A sein, wenn bei der versechsfachten Ausgangsfrequenz ein Kanalabstand von 25 kHz benötigt wird?<p><img src=''td701f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (776, 'TE101', 'Wie unterscheidet sich J3E von A3E in Bezug auf die benötigte Bandbreite?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (777, 'TE102', 'Wodurch werden Tastklicks bei einem CW-Sender hervorgerufen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (778, 'TE103', 'Auf welcher Frequenz sollte der Schwebungston eines BFO für den Empfang von CW-Signalen ungefähr liegen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (779, 'TE104', 'Durch Modulation', 0, 1, 0, 0, '');
INSERT INTO question VALUES (780, 'TE105', 'Welches Bild stellt die Übermodulation eines AM-Signals dar?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (781, 'TE106', 'Die Übermodulation eines SSB-Signals führt wahrscheinlich zu', 0, 1, 0, 0, '');
INSERT INTO question VALUES (782, 'TE107', 'Wodurch wird Kreuzmodulation verursacht?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (783, 'TE108', 'Um unnötige Seitenband-Splatter zu vermeiden, sollte der Modulationsgrad eines AM-Signals unter', 0, 1, 0, 0, '');
INSERT INTO question VALUES (784, 'TE109', 'Welche Sendeverfahren weisen das größte Störpotential in Bezug auf NF-Verstärkersysteme auf?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (785, 'TE110', 'In welcher Abbildung ist AM mit einem Modulationsgrad von 100 % dargestellt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (786, 'TE111', 'Das folgende Oszillogramm zeigt ein AM-Signal. Der Modulationsgrad beträgt hier ca.<p><img src=''te111f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (787, 'TE112', 'Das folgende Oszillogramm zeigt ein AM-Signal. Der Modulationsgrad beträgt hier ca.<p><img src=''te112f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (788, 'TE113', 'Das folgende Oszillogramm zeigt<p><img src=''te113f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (789, 'TE201', 'Welche nachfolgende Sendeart hat die geringste Störanfälligkeit bei Funkanlagen in Kraftfahrzeugen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (790, 'TE202', 'Was gilt in etwa für die Bandbreite B eines FM-Signals, wenn der Modulationsindex m &lt; 0,5 wird? (f<sub>mod</sub> sei die Modulationsfrequenz und &Delta;F der Hub.)', 0, 1, 0, 0, '');
INSERT INTO question VALUES (791, 'TE203', 'Was gilt in etwa für die Bandbreite B eines FM-Signals, wenn der Modulationsindex m &gt; 2 wird? (f<sub>mod</sub> sei die Modulationsfrequenz und &Delta;F der Hub.)', 0, 1, 0, 0, '');
INSERT INTO question VALUES (792, 'TE204', 'Wodurch wird bei Frequenzmodulation die Lautstärke-Information übertragen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (793, 'TE205', 'Theoretisch arbeitet die Frequenzmodulation mit', 0, 1, 0, 0, '');
INSERT INTO question VALUES (794, 'TE206', 'FM hat gegenüber SSB den Vorteil der', 0, 1, 0, 0, '');
INSERT INTO question VALUES (795, 'TE207', 'Ein zu großer Hub eines FM-Senders führt dazu,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (796, 'TE208', 'Die Änderung der Kapazität einer über einen Quarzoszillator angeschalteten Varicap-Diode stellt eine Möglichkeit dar', 0, 1, 0, 0, '');
INSERT INTO question VALUES (797, 'TE209', 'Ein 2-m-Sender erzeugt seine Ausgangsfrequenz durch Vervielfachung der Oszillatorfrequenz um den Faktor 12. Der Hub der Ausgangsfrequenz beträgt 5 kHz. Wie groß ist der Hub der Oszillatorfrequenz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (798, 'TE210', 'Eine FM-Telefonie-Aussendung mit zu großem Hub führt möglicherweise', 0, 1, 0, 0, '');
INSERT INTO question VALUES (799, 'TE211', 'Was bewirkt die Erhöhung des Hubes eines frequenzmodulierten Senders?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (800, 'TE212', 'Größerer Frequenzhub führt bei einem FM-Sender zu', 0, 1, 0, 0, '');
INSERT INTO question VALUES (801, 'TE213', 'Bei der FM-Übertragung werden Preemphasis und Deemphasis eingesetzt,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (802, 'TE214', 'Am Spektrumanalysator zeigt ein FM-Sender bei der Modulation mit einem 1-kHz-Ton die erste Trägernullstelle. Wie groß ist der Spitzenhub?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (803, 'TE215', 'Wenn ein FM-Sender mit einem Modulationsindex m = 2,4 betrieben wird,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (804, 'TE216', 'Wie wird die Empfindlichkeit eines FM-Modulators angegeben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (805, 'TE217', 'Der typische Hub eines NBFM-Signals (Schmalband-FM) im Amateurfunk beträgt', 0, 1, 0, 0, '');
INSERT INTO question VALUES (806, 'TE301', 'Wie wird ein Sender mit einem 1200-Bd-Packet-Radio-Signal moduliert? Ein weit verbreitetes Verfahren ist, das Signal', 0, 1, 0, 0, '');
INSERT INTO question VALUES (807, 'TE302', 'Welche NF-Bandbreite beansprucht ein 1200-Bd-Packet-Radio-AFSK-Signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (808, 'TE303', 'Welche NF-Zwischenträgerfrequenzen werden in der Regel in Packet-Radio bei 1200 Bd benutzt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (809, 'TE304', 'Wie erfolgt die Datenübertragung bei Packet-Radio?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (810, 'TE305', 'Wie erfolgt die synchrone Datenübertragung?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (811, 'TE306', 'Welche HF-Bandbreite beansprucht ein 1200-Baud-Packet-Radio-AFSK-Signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (812, 'TE307', 'Welche der nachfolgend genannten Einrichtungen würden Sie an einen Terminal-Node-Controller (TNC) anschließen um am Packet-Radio-Betrieb teilzunehmen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (813, 'TE308', 'Beim Aussenden von Daten in der Betriebsart Packet-Radio muss nach dem Hochtasten des Senders eine gewisse Zeitspanne gewartet werden, bevor mit der Datenübertragung begonnen werden kann. Wie heißt der Parameter mit dem diese Zeitspanne eingestellt wird?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (814, 'TE309', 'Beim Aussenden von Daten in der Betriebsart Packet-Radio muss nach dem Hochtasten des Senders eine gewisse Zeitspanne gewartet werden, bevor mit der Datenübertragung begonnen werden kann. Diese Zeitspanne hängt ab', 0, 1, 0, 0, '');
INSERT INTO question VALUES (815, 'TE310', 'Welche Anforderungen muss ein FM-Funkgerät erfüllen, damit es für die Übertragung von Packet-Radio mit 9600 Baud geeignet ist?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (816, 'TE311', 'Welche Punkte in einem FM-Transceiver sind für die Zuführung bzw. das Abgreifen eines 9600-Baud-FSK-Signals geeignet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (817, 'TE312', 'Was versteht man unter "DAMA" bei der Betriebsart Packet-Radio?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (818, 'TE313', 'Welche HF-Bandbreite beansprucht ein 9600-Baud-FM-Packet-Radio-Signal?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (819, 'TE314', 'Eine Packet-Radio-Mailbox ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (820, 'TE315', 'Was versteht man bei Packet Radio unter einem TNC (Terminal Network Controller)? Ein TNC', 0, 1, 0, 0, '');
INSERT INTO question VALUES (821, 'TE316', 'Warum können auf einer Frequenz mehrere Stationen gleichzeitig Verbindungen in der Betriebsart Packet Radio haben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (822, 'TE317', 'Was versteht man bei Packet-Radio unter dem Begriff "TX-Delay"?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (823, 'TE318', 'Welches der genannten Übertragungsverfahren passt die Übertragungsgeschwindigkeit automatisch den Kanaleigenschaften an?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (824, 'TE319', 'Bei welchem Übertragungsverfahren für Digitalsignale wird ein niederfrequenter Zwischenträger vom Digitalsignal in der Frequenz umgetastet und wie wird das Sendesignal dem Sender zugeführt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (825, 'TE320', 'Der Baudot-Code ist ein', 0, 1, 0, 0, '');
INSERT INTO question VALUES (826, 'TE321', 'Was ist ein wesentlicher Unterschied zwischen den Betriebsarten RTTY und PACTOR?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (827, 'TE322', 'Um RTTY-Betrieb durchzuführen benötigt man außer einem Transceiver beispielsweise', 0, 1, 0, 0, '');
INSERT INTO question VALUES (828, 'TE323', 'Welches der folgenden digitalen Übertragungsverfahren hat die geringste Bandbreite?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (829, 'TE324', 'Pactor ist ein digitales Übertragungsverfahren', 0, 1, 0, 0, '');
INSERT INTO question VALUES (830, 'TE325', 'Die theoretische Bandbreite bei PSK31 beträgt', 0, 1, 0, 0, '');
INSERT INTO question VALUES (831, 'TE326', 'Wie nennt man eine Darstellung der Empfangssignale auf einem Computer, wobei als horizontale Achse die Frequenz, als vertikale Achse die Zeit und als Stärke des Signals die Breite einer Linie dargestellt wird?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (832, 'TE327', 'Was ist ein Unterschied zwischen den Betriebsarten ATV und SSTV?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (833, 'TE328', 'Welche Aussage über die Übertragungsarten ist richtig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (834, 'TE329', 'Wie heißt die Übertragungsart mit einem Übertragungskanal, bei der durch Umschaltung abwechselnd in beide Richtungen gesendet werden kann?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (835, 'TE330', 'Wie viel verschiedene Zeichen kann man mit 5 Bit (z.B. Baudot-Code bei RTTY) erzeugen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (836, 'TF101', 'Welche Aussage ist für einen Doppelsuper richtig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (837, 'TF102', 'Die Empfindlichkeit eines Empfängers bezieht sich auf die', 0, 1, 0, 0, '');
INSERT INTO question VALUES (838, 'TF103', 'Eine hohe erste Zwischenfrequenz', 0, 1, 0, 0, '');
INSERT INTO question VALUES (839, 'TF104', 'Wie ist bei modernen KW-Transceivern der Frequenzplan eines z.B. von 100 kHz bis 30 MHz durchstimmbaren Empfängers?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (840, 'TF105', 'Wo wird die Bandbreite eines durchstimmbaren Empfängers festgelegt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (841, 'TF106', 'Wie groß sollte die Bandbreite des Filters für die 1. ZF in einem durchstimmbaren Empfänger sein?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (842, 'TF107', 'Womit kann die Frequenzanzeige eines durchstimmbaren Empfängers möglichst genau geprüft werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (843, 'TF201', 'In dieser Schaltung können bei einer Empfangsfrequenz von 145,6 MHz und einer Oszillatorfrequenz von 134,9 MHz Spiegelfrequenzstörungen bei<p><img src=''tf201f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (844, 'TF202', 'In dieser Schaltung können bei einer Empfangsfrequenz von 28,3 MHz und einer Oszillatorfrequenz von 39 MHz Spiegelfrequenzstörungen bei<p><img src=''tf202f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (845, 'TF203', 'Folgende Schaltung stellt einen Doppelsuper dar. Welche Funktion haben die drei mit X, Y und Z gekennzeichneten Blöcke?<p><img src=''tf203f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (846, 'TF204', 'Folgende Schaltung stellt einen Doppelsuper dar. Welche Funktion haben die drei mit X, Y und Z gekennzeichneten Blöcke?<p><img src=''tf204f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (847, 'TF205', 'Ein Doppelsuper hat eine erste ZF von 10,7 MHz und ein zweite ZF von 460 kHz. Die Empfangsfrequenz soll 28 MHz sein. Welche Frequenz ist für den VFO und für den CO erforderlich, wenn die Oszillatoren oberhalb des Nutzsignals schwingen sollen?<p><img src=''tf205f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (848, 'TF206', 'Welche beiden Frequenzen muss der Quarzoszillator erzeugen, damit im 70-cm-Bereich die oberen 4 MHz durch diesen Konverter empfangen werden können? Die Oszillatorfrequenz f<sub>osz</sub> soll jeweils unterhalb des Nutzsignals liegen.<p><img src=''tf206f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (849, 'TF207', 'Welche beiden Frequenzen muss der Quarzoszillator erzeugen, damit im 70-cm-Bereich die unteren 4 MHz durch diesen Konverter empfangen werden können? Die Oszillatorfrequenz f<sub>osz</sub> soll jeweils unterhalb des Nutzsignals liegen.<p><img src=''tf207f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (850, 'TF208', 'Diese Schaltung stellt<p><img src=''tf208f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (851, 'TF209', 'Welchen Vorteil haben Kurzwellen-Empfänger mit einer sehr hohen ersten ZF-Frequenz (z.B. 50 MHz)?<p><img src=''tf209f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (852, 'TF210', 'Welchen Frequenzbereich kann der VFO des im folgenden Blockschaltbild gezeichneten HF-Teils eines Empfängers haben?<p><img src=''tf210f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (853, 'TF211', 'Welchen Frequenzen können die drei Oszillatoren des im folgenden Blockschaltbild gezeichneten Empfängers haben, wenn eine Frequenz von 3,65 MHz empfangen wird? Bei welcher Antwort sind alle drei Frequenzen richtig?<p><img src=''tf211f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (854, 'TF212', 'Diese Blockschaltung stellt<p><img src=''tf212f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (855, 'TF213', 'Dies ist das Blockschaltbild eines modernen Empfängers mit PLL-Frequenzaufbereitung. Es soll eine Frequenz von 15,0 MHz empfangen werden. Welche Frequenzen liefern VCO<sub>1</sub> und VCO<sub>2</sub>, wenn der programmierbare Frequenzvervielfacher n<sub>p</sub> dabei 18 MHz liefert?<p><img src=''tf213f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (856, 'TF214', 'An welcher Stelle einer Amateurfunkanlage sollte ein VHF-Vorverstärker eingefügt werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (857, 'TF301', 'Wo liegt bei einem Direktüberlagerungsempfänger üblicherweise die Injektionsfrequenz des Mischers? Sie liegt', 0, 1, 0, 0, '');
INSERT INTO question VALUES (858, 'TF302', 'Welche Signale steuern gewöhnlich die Empfängerstummschaltung (Squelch)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (859, 'TF303', 'Was bewirkt die AGC (automatic gain control) bei einem starken Eingangssignal? Sie reduziert die', 0, 1, 0, 0, '');
INSERT INTO question VALUES (860, 'TF304', 'Welches sind die wichtigsten Ausgangsfrequenzen, die bei der Mischung einer Frequenz von 30 MHz mit einer Frequenz von 39 MHz entstehen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (861, 'TF305', 'Welcher Mischertyp ist am besten geeignet, um ein Doppelseitenbandsignal mit unterdrücktem Träger zu erzeugen? Am besten geeignet ist ein', 0, 1, 0, 0, '');
INSERT INTO question VALUES (862, 'TF306', 'Einem Mischer werden die Frequenzen 136 MHz und 145 MHz zugeführt. Welche Frequenzen werden beim Mischvorgang erzeugt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (863, 'TF307', 'Ein Doppelsuper hat eine erste ZF (ZF<sub>1</sub>) von 10,7 MHz und eine zweite ZF (ZF<sub>2</sub>) von 450 kHz. Die Empfangsfrequenz soll 28 MHz sein. Die Oszillatoren sollen oberhalb des Nutzsignals schwingen. Welche Frequenzen sind für den VFO und den CO erforderlich, wenn die Oszillatoren oberhalb des Mischer-Eingangssignals schwingen sollen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (864, 'TF308', 'Welche ungefähren Werte sollte die Bandbreite der ZF-Verstärker eines Amateurfunk-Empfängers für folgende Sendearten aufweisen: J3E, F1B (RTTY Shift 170 Hz), F3E?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (865, 'TF309', 'Um wie viel S-Stufen müsste die S-Meter-Anzeige Ihres Empfängers steigen, wenn Ihr Partner die Sendeleistung von 100 Watt auf 400 Watt erhöht?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (866, 'TF310', 'Welche Funktion haben die beiden Kondensatoren C<sub>3</sub> und C<sub>4</sub> in der folgenden Schaltung?<p><img src=''tf310f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (867, 'TF311', 'Welchem Zweck dient D<sub>1</sub> in der folgenden Schaltung?<p><img src=''tf311f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (868, 'TF312', 'Um eine Rückkopplung der HF-Signale einer Leistungsverstärkerstufe zum VFO zu verhindern, sollte die Gleichstromversorgung des VFO´s', 0, 1, 0, 0, '');
INSERT INTO question VALUES (869, 'TF313', 'Wozu dienen P und C<sub>4</sub> bei dieser Schaltung? Sie dienen<p><img src=''tf313f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (870, 'TF314', 'An welchem Punkt wird in der Schaltung der Ausgangspegel entnommen?<p><img src=''tf314f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (871, 'TF315', 'Bei dieser Schaltung handelt es sich um einen<p><img src=''tf315f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (872, 'TF316', 'Welchem Zweck dient TR1 in der Schaltung?<p><img src=''tf315f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (873, 'TF317', 'Bei der Schaltung handelt es sich um einen<p><img src=''tf317f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (874, 'TF318', 'Der Ausgang eines richtig eingestellten Balancemischers enthält', 0, 1, 0, 0, '');
INSERT INTO question VALUES (875, 'TF319', 'Welche Konfigurationen wäre für die Unterdrückung unerwünschter Signale am Eingang eines Empfängers hilfreich?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (876, 'TF320', 'Welche Baugruppe könnte in einem Empfänger gegebenenfalls dazu verwendet werden, um einen schmalen Frequenzbereich zu unterdrücken, in dem Störungen empfangen werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (877, 'TF321', 'Die Phasenverschiebung zwischen der Einund Ausgangsspannung einer Verstärkerstufe mit einem Transistor in Kollektorschaltung beträgt', 0, 1, 0, 0, '');
INSERT INTO question VALUES (878, 'TF322', 'Die Phasenverschiebung zwischen der Einund Ausgangsspannung einer Verstärkerstufe mit einem Transistor in Basisschaltung beträgt', 0, 1, 0, 0, '');
INSERT INTO question VALUES (879, 'TF323', 'Die Phasenverschiebung zwischen der Einund Ausgangsspannung einer Verstärkerstufe mit einem Transistor in Emitterschaltung beträgt', 0, 1, 0, 0, '');
INSERT INTO question VALUES (880, 'TF324', 'Wie verhält sich der Kollektorstrom eines NPN-Transistors in einer HF-Verstärkerstufe im B-Betrieb, wenn die Basisspannung erhöht wird?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (881, 'TF325', 'Was bedeutet an einem Abstimmelement eines Empfängers die Abkürzung AGC?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (882, 'TF326', 'Welches Diagramm stellt den Frequenzverlauf eines Empfänger-Notchfilters dar?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (883, 'TF327', 'Bei welchem der folgenden Fälle misst man eine hohe Spannung am Emitterwiderstand einer Empfänger-ZF-Stufe?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (884, 'TF328', 'Die Mischstufe eines Überlagerungsempfängers arbeitet', 0, 1, 0, 0, '');
INSERT INTO question VALUES (885, 'TF329', 'Der Begrenzerverstärker eines FM-Empfängers ist ein Verstärker,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (886, 'TF330', 'Bei welchem der nachfolgenden Fälle misst man nur eine geringe oder gar keine Spannung am Emitterwiderstand einer ZF-Stufe?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (887, 'TF401', 'Ein Empfänger hat eine ZF von 10,7 MHz und ist auf 28,5 MHz abgestimmt. Der Oszillator des Empfängers schwingt oberhalb der Empfangsfrequenz. Welches ist die richtige Spiegelfrequenz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (888, 'TF402', 'Wodurch wird beim Überlagerungsempfänger die Spiegelfrequenzdämpfung bestimmt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (889, 'TF403', 'Welche Baugruppe eines Empfängers bestimmt die Trennschärfe?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (890, 'TF404', 'Die Spule, die Bestandteil des frequenzbestimmenden Elementes eines VFO ist, sollte', 0, 1, 0, 0, '');
INSERT INTO question VALUES (891, 'TF405', 'Welche Stromversorgungsart benötigt ein VFO?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (892, 'TF406', 'Welcher der folgenden als Bandpass einsetzbaren Bauteile verfügt am ehesten über die geringste Bandbreite?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (893, 'TF407', 'Welche Baugruppe sollte für die Erzeugung eines unterdrückten Zweiseitenband-Trägersignals verwendet werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (894, 'TF408', 'Um Einrichtungen mit einem Klappdeckel aus Metall möglichst gut abzuschirmen, empfiehlt es sich, das Scharnier', 0, 1, 0, 0, '');
INSERT INTO question VALUES (895, 'TF409', 'Eine schmale Empfängerbandbreite führt im allgemeinen zu einer', 0, 1, 0, 0, '');
INSERT INTO question VALUES (896, 'TF410', 'Das folgende Bild zeigt die Durchlasskurve eines Empfängerfilters. Es ist besonders für den Empfang von<p><img src=''tf410f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (897, 'TF411', 'In dem dargestellten Diagramm beträgt die Grenzbandbreite bei -60 dB etwa<p><img src=''tf411f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (898, 'TF412', 'Ein Frequenzmarken-Generator in einem Empfänger sollte möglichst', 0, 1, 0, 0, '');
INSERT INTO question VALUES (899, 'TF413', 'Für eine optimale Stabilität sollte auch ein bereits temperaturkompensierter VFO', 0, 1, 0, 0, '');
INSERT INTO question VALUES (900, 'TF414', 'Für CW-Empfang sollte die Differenz zwischen der BFO-Frequenz und der End-ZF ungefähr', 0, 1, 0, 0, '');
INSERT INTO question VALUES (901, 'TF415', 'In einigen NF-Endstufen eines Verstärkers wird der Lautsprecher über einen Abwärtstransformator angesteuert. Dies gewährleistet', 0, 1, 0, 0, '');
INSERT INTO question VALUES (902, 'TF416', 'Beim Empfang einer Funkstelle auf 14,24 MHz, bei der sich die erste ZF des Empfängers auf 10,7 MHz befindet, können Spiegelfrequenzstörungen durch Signale auf', 0, 1, 0, 0, '');
INSERT INTO question VALUES (903, 'TF417', 'Für die Demodulation von SSB-Signalen wird normalerweise ein Hilfsträgeroszillator verwendet. In hochwertigen Empfängern ist dieser Oszillator', 0, 1, 0, 0, '');
INSERT INTO question VALUES (904, 'TF418', 'Ein Empfänger arbeitet mit einer End-ZF von 455 kHz. Welche BFO-Frequenz wäre beim CW-Empfang geeignet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (905, 'TF419', 'Die Stabilität des lokalen Oszillators einer Sende-/Empfangsanlage ist teilweise von', 0, 1, 0, 0, '');
INSERT INTO question VALUES (906, 'TF420', 'Welchem Zweck dient ein BFO in einem Empfänger?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (907, 'TF421', 'Die Frequenzdifferenz zwischen dem HF-Nutzsignal und dem Spiegelsignal entspricht dem', 0, 1, 0, 0, '');
INSERT INTO question VALUES (908, 'TF422', 'Um Schwankungen des NF-Ausgangssignals durch Schwankungen des HF-Eingangssignals zu verringern, wird ein Empfänger mit', 0, 1, 0, 0, '');
INSERT INTO question VALUES (909, 'TF423', 'Die Frequenzdifferenz zwischen dem HF-Nutzsignal und dem Spiegelsignal entspricht', 0, 1, 0, 0, '');
INSERT INTO question VALUES (910, 'TF424', 'Bei Empfang eines sehr starken Signals verringert die AGC', 0, 1, 0, 0, '');
INSERT INTO question VALUES (911, 'TF425', 'Eine hohe erste ZF vereinfacht die Filterung zur Vermeidung von', 0, 1, 0, 0, '');
INSERT INTO question VALUES (912, 'TF426', 'Welche Baugruppe erzeugt ein Zweiseitenbandsignal mit unterdrücktem Träger?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (913, 'TF427', 'Um unerwünschte Abstrahlungen auf ein Minimum zu beschränken, sollte eine Mischstufe', 0, 1, 0, 0, '');
INSERT INTO question VALUES (914, 'TF428', 'Durch welchen Mischer werden unerwünschte Ausgangssignale auf ein Mindestmaß begrenzt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (915, 'TF429', 'Um unerwünschte Abstrahlungen eines Oszillators zu vermeiden, sollte', 0, 1, 0, 0, '');
INSERT INTO question VALUES (916, 'TF430', 'Die Ausgangsstufe eines SSB-Senders ist als', 0, 1, 0, 0, '');
INSERT INTO question VALUES (917, 'TF431', 'Die Ungenauigkeit der digitalen Anzeige eines Empfängers beträgt 0,01 %. Bei welcher Entfernung zur unteren Bandgrenze ist im 10-m-Bereich noch gewährleistet, dass der Träger sich innerhalb des zugelassenen Bandes befindet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (918, 'TF432', 'Auf welche Frequenz müsste ein Empfänger eingestellt werden, um die dritte Harmonische einer nahen 7,050-MHz-Aussendung erkennen zu können?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (919, 'TF433', 'Auf welche Frequenz müsste ein Empfänger eingestellt werden, um die dritte Oberwelle einer 7,20-MHz-Aussendung erkennen zu können?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (920, 'TF434', 'Die Empfindlichkeit eines Empfängers kann durch', 0, 1, 0, 0, '');
INSERT INTO question VALUES (921, 'TF435', 'Was ist die Hauptursache für Intermodulationsprodukte in einem Empfänger?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (922, 'TF436', 'In einem Amateurfunkempfänger werden etwa alle 15625 Hz unerwünschte Signale festgestellt. Dies ist wahrscheinlich zurückzuführen auf', 0, 1, 0, 0, '');
INSERT INTO question VALUES (923, 'TF437', 'Welche Empfängereigenschaft beurteilt man mit dem Interception Point IP3?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (924, 'TF438', 'Wodurch erreicht man eine Verringerung von Intermodulation und Kreuzmodulation beim Empfang?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (925, 'TF439', 'Ein Empfänger liefert bei einem Eingangssignal von 0,25 µV ein Ausgangssignal mit einem Signal-Geräuschabstand von 10 dB. Wie kann diese Eigenschaft angegeben werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (926, 'TF440', 'Was bedeutet Signal-Rauschabstand (S/N) bei einem VHF-Empfänger?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (927, 'TF441', 'Was bedeutet die Rauschzahl F=2 bei einem UHF-Vorverstärker? Das Ausgangssignal des Verstärkers hat ein', 0, 1, 0, 0, '');
INSERT INTO question VALUES (928, 'TF442', 'Was bedeutet die Rauschzahl von 1,8 dB bei einem UHF-Vorverstärker? Das Ausgangssignal des Vorverstärkers hat ein', 0, 1, 0, 0, '');
INSERT INTO question VALUES (929, 'TF501', 'Folgendes Blockschaltbild stellt das Prinzip einer DSP-Signalverarbeitung dar. Welche Aufgabe haben die beiden Blöcke 1 und 2? (DSP ... Digital Signal Processing)<p><img src=''tf501f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (930, 'TF502', 'Wozu kann eine DSP-Signalverarbeitung bei einem Amateurfunkgerät beispielsweise dienen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (931, 'TF503', 'Wozu eignet sich eine DSP-Signalverarbeitung in einem Empfänger? Sie eignet sich', 0, 1, 0, 0, '');
INSERT INTO question VALUES (932, 'TF504', 'Wofür ist die DSP in einem Transceiver geeignet? Eine DSP eignet sich beispielsweise', 0, 1, 0, 0, '');
INSERT INTO question VALUES (933, 'TF505', 'Bei einem Transceiver soll für Steuerungszwecke über die CAT-Schnittstelle der hexadezimale Wert „48h“ eingestellt werden. Das dazu verwendete Steuerprogramm erlaubt aber nur eine dezimale Eingabe des Wertes. Welcher dezimale Wert muss eingegeben werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (934, 'TF506', 'Bei einem Transceiver soll für Steuerungszwecke über die CAT-Schnittstelle der hexadezimale Wert „84h“ eingestellt werden. Das dazu verwendete Steuerprogramm erlaubt aber nur eine dezimale Eingabe des Wertes. Welcher dezimale Wert muss eingegeben werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (935, 'TG101', 'Dieses Blockschaltbild zeigt einen SSB-Sender. Welche Stufe muss beim " ? " arbeiten?<p><img src=''tg101f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (936, 'TG102', 'Diese Schaltung ermöglicht<p><img src=''tg102f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (937, 'TG103', 'Das Blockschaltbild stellt einen Mehrbandsender dar. Welche Frequenz entsteht am Ausgang X, wenn der VFO auf 3,51 MHz eingestellt ist?<p><img src=''tg103f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (938, 'TG104', 'Am Ausgang X dieser Senderaufbereitung wird eine Frequenz von 21,360 MHz gemessen. Welche Frequenz hat der VFO?<p><img src=''tg104f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (939, 'TG105', 'Welche Schaltungen sind bei den Stufen A und B des dargestellten Senders erforderlich?<p><img src=''tg105f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (940, 'TG106', 'Die folgende Blockschaltung zeigt eine SSB-Aufbereitung mit einem 9-MHz-Quarzfilter. Welche Frequenz wird in der Schalterstellung USB mit der NF gemischt?<p><img src=''tg106f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (941, 'TG107', 'Welches Schaltungsteil ist in der folgenden Blockschaltung am Ausgang des NF-Verstärkers angeschlossen?<p><img src=''tg106f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (942, 'TG108', 'Die typische Bandbreite des in der Blockschaltung dargestellten NF-Verstärkers ist<p><img src=''tg106f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (943, 'TG109', 'Welches Teil eines Senders ist in der Schaltung dargestellt?<p><img src=''tg109f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (944, 'TG110', 'Im folgenden Blockschaltbild ist die Frequenzaufbereitung für einen Amateurfunk-Transceiver dargestellt. Welche Frequenz erzeugt der Sender, wenn VCO<sub>1</sub> auf 2,651 MHz eingestellt und VCO<sub>2</sub> auf 6 MHz eingerastet ist?<p><img src=''tg110f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (945, 'TG111', 'Im folgenden Blockschaltbild ist die Frequenzaufbereitung für einen Amateurfunk-Transceiver dargestellt. Auf welcher Frequenz muss der VCO<sub>2</sub> eingerastet haben, wenn eine Ausgangsfrequenz von 14,351 MHz abgegeben wird?<p><img src=''tg110f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (946, 'TG201', 'Welche Schaltung könnte für die Tiefpassfilterung in einem Mikrofonverstärker eingesetzt werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (947, 'TG202', 'Welcher Frequenzgang ist am besten für den Mikrofonverstärker eines Sprechfunkgeräts geeignet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (948, 'TG203', 'Um Splatter bei Telefonie auf ein Mindestmaß zu begrenzen, sollte die NF-Bandbreite auf etwa', 0, 1, 0, 0, '');
INSERT INTO question VALUES (949, 'TG204', 'Wie können Tastklicks bei einem CW-Sender, die in einem Empfänger zu hören sind, verringert werden? Sie können verringert werden durch', 0, 1, 0, 0, '');
INSERT INTO question VALUES (950, 'TG205', 'Welche Tastformung eines CW-Senders vermeidet an wirksamsten die Entstehung von Tastklicks?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (951, 'TG206', 'Eine Art der Instabilität eines CW-Senders ist das "Chirpen". Was ist die Ursache dafür?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (952, 'TG207', 'Wenn der Stromversorgung einer Endstufe NF-Signale überlagert sind, kann dies unerwünschte Modulation der Sendefrequenz erzeugen. Diese zeigt sich als', 0, 1, 0, 0, '');
INSERT INTO question VALUES (953, 'TG208', 'Um Frequenzstabilität in einem Sender zu gewährleisten, sollte der VFO', 0, 1, 0, 0, '');
INSERT INTO question VALUES (954, 'TG209', 'Beim Bau eines VFO sollte die Spule', 0, 1, 0, 0, '');
INSERT INTO question VALUES (955, 'TG210', 'Der VFO eines Senders ist schwankenden Temperaturen unterworfen. Welche wesentliche Auswirkung könnte dies haben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (956, 'TG211', 'Im Regelfall sollte ein Oszillator zunächst an', 0, 1, 0, 0, '');
INSERT INTO question VALUES (957, 'TG212', 'Dieser Schaltungsauszug ist Teil eines Senders. Welche Funktion hat die Diode?<p><img src=''tg212f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (958, 'TG213', 'Wie wird ein SSB-Signal erzeugt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (959, 'TG214', 'Für die Erzeugung eines SSB-Signals wird ein Gegentaktmodulator verwendet. Das zur Unterdrückung eines Seitenbandes nachgeschaltete Filter sollte über', 0, 1, 0, 0, '');
INSERT INTO question VALUES (960, 'TG215', 'Wie arbeitet die Frequenzvervielfachung?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (961, 'TG216', 'Die Stufen mit Frequenzvervielfachung in einer Sendeeinrichtung sollten idealerweise', 0, 1, 0, 0, '');
INSERT INTO question VALUES (962, 'TG217', 'Bei dieser Schaltung handelt es sich um<p><img src=''tg217f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (963, 'TG218', 'Stufen, in denen Harmonische erzeugt werden, sollten', 0, 1, 0, 0, '');
INSERT INTO question VALUES (964, 'TG219', 'Die richtige Oberwellenauswahl in einer Vervielfachungsstufe lässt sich am leichtesten mit einem', 0, 1, 0, 0, '');
INSERT INTO question VALUES (965, 'TG220', 'Ein quarzgesteuertes Funkgerät mit einer Ausgangsfrequenz von 432,050 MHz verursacht Störungen bei 144,017 MHz. Der Quarzoszillator des Funkgeräts schwingt auf einer Grundfrequenz bei 12 MHz. Mit welcher Vervielfachungskombination wird wahrscheinlich die Ausgangsfrequenz bei 432 MHz erzeugt? Die Abfolge der Vervielfachungsstufen ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (966, 'TG221', 'Auf welcher Frequenz muss der Quarzoszillator schwingen, damit nach dem Blockschaltbild von der PA die Frequenz 145,000 MHz verstärkt wird?<p><img src=''tg221f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (967, 'TG222', 'Bei dieser Schaltung handelt es sich um einen<p><img src=''tg222f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (968, 'TG223', 'Welchem Zweck dient C<sub>5</sub> in der folgenden Schaltung?<p><img src=''tg222f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (969, 'TG224', 'Welchem Zweck dient die Anzapfung an L1 in der folgenden Schaltung?<p><img src=''tg222f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (970, 'TG225', 'Welchem Zweck dient C<sub>2</sub> in der folgenden Schaltung?<p><img src=''tg222f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (971, 'TG226', 'Welche wesentlichen Ausgangsfrequenzen erzeugt die in der Abbildung dargestellte Stufe?<p><img src=''tg226f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (972, 'TG227', 'Welche Mischerschaltung unterdrückt am wirksamsten unerwünschte Mischprodukte und Frequenzen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (973, 'TG228', 'Um zu vermeiden, dass unerwünschte Mischprodukte die Senderausgangsstufe erreichen, sollte das Ausgangssignal des Mischers', 0, 1, 0, 0, '');
INSERT INTO question VALUES (974, 'TG229', 'Ein hinter einem VHF-Sender geschalteter Bandpass', 0, 1, 0, 0, '');
INSERT INTO question VALUES (975, 'TG230', 'Welches Filter sollte hinter einem VHF-Sender geschaltet werden, um die unerwünschte Aussendung von Subharmonischen und Harmonischen auf ein Mindestmaß zu begrenzen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (976, 'TG231', 'Welche Filtercharakteristik würde sich am besten für einen Kurzwellen-Mehrband-Sender eignen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (977, 'TG232', 'Welche Filtercharakteristik würde sich am besten für einen 10-m-Band-Sender eignen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (978, 'TG233', 'Welche Aufgabe hat diese Schaltung am Senderausgang und was ist bei der Bemessung des Spannungsteilers zu beachten?<p><img src=''tg233f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (979, 'TG234', 'Stromversorgungskabel in einem Sender sollten', 0, 1, 0, 0, '');
INSERT INTO question VALUES (980, 'TG235', 'Welche der nachfolgenden Antworten trifft für die Wirkungsweise eines Transverters zu?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (981, 'TG236', 'Welche Baugruppen werden benötigt, um aus einem 5,3-MHz-Signal ein 14,3-MHz-Signal erzeugen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (982, 'TG237', 'Bei dieser Schaltung handelt es sich um einen zweistufigen<p><img src=''tg237f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (983, 'TG238', 'Wozu dient der Transformator T1 der folgenden Schaltung? Er dient der Anpassung des Ausgangswiderstandes der<p><img src=''tg238f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (984, 'TG239', 'Weshalb wurden bei C<sub>1</sub>, C<sub>2</sub> und C<sub>3</sub> je zwei Kondensatoren parallel geschaltet?<p><img src=''tg239f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (985, 'TG240', 'Wozu dient der Widerstand R von 180 Ohm parallel zur Trafowicklung?<p><img src=''tg240f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (986, 'TG301', 'Was kann man bezüglich der Ausgangsleistung eines FM-Senders in Abhängigkeit von der Modulation aussagen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (987, 'TG302', 'Was kann man bezüglich der Ausgangsleistung eines SSB-Senders in Abhängigkeit von der Modulation aussagen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (988, 'TG303', 'Ein HF-Leistungsverstärker für einen SSB-Sender kann ein Verstärker im', 0, 1, 0, 0, '');
INSERT INTO question VALUES (989, 'TG304', 'Welche Betriebsart der Leistungsverstärkerstufe eines Senders erzeugt grundsätzlich den größten Oberschwingungsanteil?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (990, 'TG305', 'Die Ausgangsleistung eines FM-Senders', 0, 1, 0, 0, '');
INSERT INTO question VALUES (991, 'TG306', 'Die Ausgangsanpassschaltung und das Filter eines HF-Verstärkers im C-Betrieb sollten', 0, 1, 0, 0, '');
INSERT INTO question VALUES (992, 'TG307', 'Wie und wo wird die Ausgangsleistung eines SSB-Senders gemessen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (993, 'TG308', 'Bei einer Senderausgangsimpedanz von 240 &Omega; sollte für eine optimale Leistungsübertragung die Last', 0, 1, 0, 0, '');
INSERT INTO question VALUES (994, 'TG309', 'Welche Funktion hat das Ausgangs-Pi-Filter eines HF-Senders?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (995, 'TG310', 'LC-Schaltungen unmittelbar vor und hinter einem HF-Leistungsverstärker dienen', 0, 1, 0, 0, '');
INSERT INTO question VALUES (996, 'TG311', 'Welche Funktion haben C<sub>1</sub>, C<sub>2</sub> und L<sub>1</sub> in der folgenden Schaltung?<p><img src=''tg311f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (997, 'TG312', 'Welche der nachfolgenden Aussagen trifft nicht für die Schaltung zu?<p><img src=''tg311f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (998, 'TG313', 'Bei dieser Schaltung handelt es sich um<p><img src=''tg313f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (999, 'TG314', 'Bei C<sub>1</sub>, C<sub>2</sub> und L<sub>1</sub> handelt es sich um<p><img src=''tg313f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1000, 'TG315', 'Das folgende Bild zeigt eine HF-Endstufe. Welche Bedeutung und Funktion haben C<sub>1</sub>, C<sub>2</sub> und L<sub>1</sub> ? Wie sind die Bedienknöpfe der beiden Kondensatoren an einer Endstufe wahrscheinlich beschriftet?<p><img src=''tg313f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1001, 'TG316', 'Wie wird die folgende Endstufe richtig auf die Sendefrequenz abgestimmt?<p><img src=''tg313f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1002, 'TG317', 'Welchem Zweck dient R<sub>1</sub> in der folgenden Schaltung? R<sub>1</sub> dient<p><img src=''tg313f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1003, 'TG318', 'Wodurch könnte R<sub>1</sub> in der folgenden Schaltung ersetzt werden, um den Arbeitspunkt der Röhre von der HF-Aussteuerung unabhängig einzustellen?<p><img src=''tg313f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1004, 'TG401', 'Was kann man tun, wenn der Hub bei einem Handfunkgerät oder Mobil-Transceiver zu groß ist?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1005, 'TG402', 'In welcher der folgenden Antworten sind Betriebsarten aufgezählt, die man bei einem üblichen Kurzwellentransceiver einstellen kann?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1006, 'TG403', 'Wenn man beim Funkbetrieb die Empfangsfrequenz gegenüber der Senderfrequenz geringfügig verstellen möchte, kann man', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1007, 'TG404', 'Wie wird die Taste am Mikrofon bezeichnet, mit der ein Transceiver auf Sendung geschaltet werden kann?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1008, 'TG405', 'Wie wird der Funkbetrieb bezeichnet, mit der ein Transceiver allein durch die Stimme auf Sendung geschaltet werden kann?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1009, 'TG406', 'Wenn das Grundrauschen auf einer Frequenz im FM-Betrieb ausgeblendet werden soll, verstellt man', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1010, 'TG501', 'Wodurch können Tastklicks hervorgerufen werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1011, 'TG502', 'Was passiert, wenn bei einem SSB-Sender die Mikrofonverstärkung zu hoch eingestellt wurde?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1012, 'TG503', 'Wie kann man bei einem VHF-Sender mit kleiner Leistung die Entstehung parasitärer Schwingungen wirksam unterdrücken?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1013, 'TG504', 'Wie ist der Wirkungsgrad eines HF-Generators definiert?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1014, 'TG505', 'Wie kann sich die mangelhafte Frequenzstabilität eines Senders bei dessen Betrieb auswirken?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1015, 'TG506', 'Bei digitalen Betriebsarten bis 9600 Bd sollte die Bandbreite der Signale 6 kHz nicht überschreiten. Geben Sie die richtige Begründung für diese Empfehlung an:', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1016, 'TG507', 'Wie wird in der Regel die hochfrequente Ausgangsleistung eines SSB-Senders vermindert?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1017, 'TG508', 'Mit welcher Arbeitspunkteinstellung darf die Endstufe eines Einseitenbandsenders im SSB-Betrieb nicht arbeiten, um Verzerrungen (Harmonische und Intermodulationsprodukte), die zu unerwünschten Ausstrahlungen führen, zu vermeiden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1018, 'TG509', 'Was für ein Filter muss man zwischen Senderausgang und Antenne einschleifen, um die Abstrahlung von Oberwellen zu reduzieren?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1019, 'TG510', 'Was kann man tun, wenn der Hub bei einem Handfunkgerät oder Mobiltransceiver zu groß ist?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1020, 'TG511', 'Um Nachbarkanalstörungen zu minimieren sollte die Übertragungsbandbreite bei SSB', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1021, 'TG512', 'Was wird eingesetzt, um die Abstrahlung einer spezifischen Harmonischen wirkungsvoll zu begrenzen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1022, 'TG513', 'Welche Schaltung wäre zwischen Senderausgang und Antenne eingeschleift am besten zur Verringerung der Oberwellenausstrahlungen geeignet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1023, 'TG514', 'Um die Gefahr von Eigenschwingungen in HF-Schaltungen zu verringern,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1024, 'TG515', 'Die Ausgangsleistungsanzeige eines HF-Verstärkers zeigt beim Abstimmen geringfügige sprunghafte Schwankungen. Wodurch werden diese Schwankungen möglicherweise hervorgerufen? Sie werden möglicherweise hervorgerufen durch', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1025, 'TG516', 'Um die Wahrscheinlichkeit von Eigenschwingungen in einem Leistungsverstärker zu verringern,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1026, 'TG517', 'Welche Harmonische eines 70-cm-Senders führt am ehesten zu Störungen im UHF-Bereich?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1027, 'TG518', 'Bei Aussendungen im Frequenzbereich 1,81 bis 2,0 MHz können Spiegelfrequenzstörungen im', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1028, 'TG519', 'Bei der erstmaligen Prüfung eines Senders sollten die Signale zunächst', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1029, 'TG520', 'Welches Diagramm stellt den Frequenzgang eines Ausgangsfilters dar, das die Harmonischen eines Einbandsenders wirkungsvoll unterdrückt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1030, 'TG521', 'Die dritte Harmonische einer 29,5-MHz-Aussendung fällt in', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1031, 'TG522', 'Bei der Überprüfung des Ausgangssignals eines Senders sollte die Dämpfung der Oberwellen mindestens', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1032, 'TG523', 'Was gilt beim Sendebetrieb für unerwünschte Aussendungen im Frequenzbereich zwischen 1,7 und 35 MHz? Sofern die Leistung einer unerwünschten Aussendung', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1033, 'TG524', 'Was gilt beim Sendebetrieb für unerwünschte Aussendungen im Frequenzbereich zwischen 50 und 1000 MHz? Sofern die Leistung einer unerwünschten Aussendung', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1034, 'TG525', 'Wie erfolgt die Messung der Leistungen, die zu unerwünschten Aussendungen führen, in Anlehnung an die EU-Normen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1035, 'TH101', 'Welche elektrische Länge muss eine Dipolantenne haben, damit sie in Resonanz ist?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1036, 'TH102', 'Welche Aussage zur Strom- und Spannungsverteilung auf einem Dipol ist richtig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1037, 'TH103', 'Ein Dipol wird stromgespeist, wenn an seinem Einspeisepunkt', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1038, 'TH104', 'Ein Dipol wird spannungsgespeist, wenn an seinem Einspeisepunkt', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1039, 'TH105', 'Ein mittengespeister &lambda;/2-Dipol ist bei seiner Grundfrequenz und deren ungeradzahligen Vielfachen', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1040, 'TH106', 'Ein mittengespeister &lambda;/2-Dipol ist bei geradzahligen Vielfachen seiner Grundfrequenz', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1041, 'TH107', 'Der Eingangswiderstand eines mittengespeisten &lambda;/2-Dipols zeigt sich bei dessen Resonanzfrequenzen', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1042, 'TH108', 'Das folgende Bild zeigt die Stromverteilungen A bis D auf einem Dipol, der auf verschiedenen Resonanzfrequenzen erregt werden kann. Für welche Erregerfrequenz gilt die Stromkurve nach A?<p><img src=''th108f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1043, 'TH109', 'Das folgende Bild zeigt die Stromverteilungen A bis D auf einem Dipol, der auf verschiedenen Resonanzfrequenzen erregt werden kann. Für welche Erregerfrequenz gilt die Stromkurve nach B?<p><img src=''th108f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1044, 'TH110', 'Das folgende Bild zeigt die Stromverteilungen A bis D auf einem Dipol, der auf verschiedenen Resonanzfrequenzen erregt werden kann. Für welche Erregerfrequenz gilt die Stromkurve nach C?<p><img src=''th108f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1045, 'TH111', 'Das folgende Bild zeigt die Stromverteilungen A bis D auf einem Dipol, der auf verschiedenen Resonanzfrequenzen erregt werden kann. Für welche Erregerfrequenz gilt die Stromkurve nach D?<p><img src=''th108f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1046, 'TH112', 'Das folgende Strahlungsdiagramm ist typisch für<p><img src=''th112f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1047, 'TH113', 'Die Impedanz eines Halbwellendipols bei mindestens einer Wellenlänge über dem Boden beträgt ungefähr', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1048, 'TH114', 'Ein Faltdipol hat einen Eingangswiderstand von ungefähr', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1049, 'TH115', 'Die Länge des Drahtes zur Herstellung eines Faltdipols entspricht', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1050, 'TH116', 'Ein Parallelresonanzkreis (Trap) in jeder Dipolhälfte', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1051, 'TH117', 'Sie wollen verschiedene Antennen testen, ob sie für den Funkbetrieb auf Kurzwelle für das 80-m-Band geeignet sind. Man stellt Ihnen jeweils drei Antennen zur Verfügung. Welches Angebot wählen sie, um nur die drei besonders gut geeigneten Antennen testen zu müssen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1052, 'TH118', 'In welcher Zeile sind besonders für den Kurzwellenbereich geeignete Antennen aufgeführt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1053, 'TH119', 'Was sind typische KW-Amateurfunksendeantennen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1054, 'TH120', 'Welche Antennenformen werden im VHF-UHF-Bereich bei den Funkamateuren in der Regel nicht verwendet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1055, 'TH121', 'Welche Antenne gehört nicht zu den symmetrischen Antennen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1056, 'TH122', 'Eine Marconi-Antenne ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1057, 'TH123', 'Bei welcher Länge hat eine Vertikalantenne die günstigsten Strahlungseigenschaften?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1058, 'TH124', 'Eine Vertikalantenne erzeugt', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1059, 'TH125', 'Welche Antennenart ist hier dargestellt?<p><img src=''th125f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1060, 'TH126', 'Welcher Prozentsatz entspricht dem Korrekturfaktor, der üblicherweise für die Berechnung der Länge einer Drahtantenne verwendet wird?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1061, 'TH127', 'Welches der folgenden Bauteile sollte mit einem 15-m-langen Antennendraht in Reihe geschaltet werden, damit die Resonanz im 3,5-MHz-Bereich erfolgen kann?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1062, 'TH128', 'Wie wird die folgende Antenne in der Amateurfunkliteratur bezeichnet?<p><img src=''th128f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1063, 'TH129', 'Wie wird die folgende Antenne in der Amateurfunkliteratur bezeichnet?<p><img src=''th129f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1064, 'TH130', 'Wie wird die folgende Antenne in der Amateurfunkliteratur bezeichnet?<p><img src=''th130f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1065, 'TH131', 'Wie wird die folgende Antenne in der Amateurfunkliteratur bezeichnet?<p><img src=''th131f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1066, 'TH132', 'Welche Antennenart ist hier dargestellt?<p><img src=''th132f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1067, 'TH133', 'Wenn man diese Mehrband-Antenne auf 7 MHz erregt, dann wirken die LC-Resonanzkreise<p><img src=''th133f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1068, 'TH134', 'Wenn man diese Mehrband-Antenne auf 3,5 MHz erregt, dann wirken die LC-Resonanzkreise<p><img src=''th133f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1069, 'TH135', 'Wenn man diese Mehrband-Antenne auf 14 MHz erregt, dann wirken die LC-Resonanzkreise<p><img src=''th133f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1070, 'TH136', 'Das folgende Bild stellt einen Dreiband-Dipol für die Frequenzbänder 20, 15 und 10 Meter dar. Die mit B gekennzeichneten Schwingkreise sind auf<p><img src=''th136f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1071, 'TH137', 'Das folgende Bild stellt einen Dreiband-Dipol für die Frequenzbänder 20, 15 und 10 Meter dar. Die mit A gekennzeichneten Schwingkreise sind auf<p><img src=''th136f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1072, 'TH138', 'Welche Antenne ist hier dargestellt und wozu dient der Kondensator?<p><img src=''th138f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1073, 'TH139', 'Die Radiale einer Groundplane-Antenne bezeichnet man auch als', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1074, 'TH140', 'Jeweils eine Seite einer Quad-Antenne ist in Resonanz mit', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1075, 'TH141', 'Das folgende Bild enthält eine einfache Richtantenne. Die Bezeichnungen der Elemente in numerischer Reihenfolge lauten<p><img src=''th141f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1076, 'TH142', 'An welchem Element einer Yagi-Antenne erfolgt die Energieeinspeisung? Sie erfolgt', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1077, 'TH143', 'Der Anbau von Reflektoren und einem Direktor an einen Faltdipol', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1078, 'TH144', 'Durch den Einbau zusätzlicher Direktoren in eine Richtstrahlantenne wird deren', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1079, 'TH145', 'Die Impedanz des Strahlers eines Multibandbeams richtet sich auch nach', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1080, 'TH146', 'Wie wirken parasitäre Elemente von Antennen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1081, 'TH147', 'Dieses Strahlungsdiagramm ist typisch für<p><img src=''th147f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1082, 'TH148', 'Bei einer Yagi-Antenne mit dem folgenden Strahlungsdiagramm beträgt die ERP in Richtung A 0,6 Watt und in Richtung B 15 Watt. Welches Vor-Rück-Verhältnis hat die Antenne?<p><img src=''th148f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1083, 'TH149', 'Eine Richtantenne mit einem Gewinn von 10 dB über dem Halbwellendipol und einem Vor-Rück-Verhältnis von 20 dB wird mit 100 Watt Senderleistung direkt gespeist. Welche ERP strahlt die Antenne entgegengesetzt zur Senderichtung ab?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1084, 'TH150', 'Eine Richtantenne mit einem Gewinn von 15 dB über dem Halbwellendipol und einem Vor-Rück-Verhältnis von 25 dB wird mit 6 Watt Senderleistung direkt gespeist. Welche ERP strahlt die Antenne entgegengesetzt zur Senderichtung ab?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1085, 'TH151', 'Um die Möglichkeit unerwünschter Abstrahlungen mit Hilfe eines angepassten Antennensystems zu verringern, empfiehlt es sich', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1086, 'TH152', 'Bei welcher der nachfolgend genannten Antennenkonfigurationen ist eine Abstrahlung von der Speiseleitung am wenigsten wahrscheinlich?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1087, 'TH153', 'Welcher Standort ist für eine HF-Richtantenne am besten geeignet, um mögliche Beeinflussungen bei den Geräten des Nachbarn zu vermeiden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1088, 'TH154', 'Eine &lambda;/4-Groundplane-Antenne mit vier Radials soll für 7,1 MHz aus Drähten gefertigt werden. Für Strahler und Radials kann mit einem Korrekturfaktor von 0,95 gerechnet werden. Wie lang müssen Strahler und Radials sein?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1089, 'TH155', 'Eine &lambda;/2-Dipol-Antenne soll für 7,1 MHz aus Draht gefertigt werden. Wie lang müssen die beiden Drähte der Dipolantenne sein? Es soll hier mit einem Korrekturfaktor von 0,95 gerechnet werden.', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1090, 'TH156', 'Eine &lambda;/2-Dipol-Antenne soll für 14,2 MHz aus Draht gefertigt werden. Es kann mit einem Korrekturfaktor von 0,95 gerechnet werden. Wie lang müssen die beiden Drähte der Dipolantenne sein?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1091, 'TH157', 'Ein Drahtdipol hat eine Gesamtlänge von 20,00 m. Für welche Frequenz ist der Dipol in Resonanz, wenn mit einem Korrekturfaktor von 0,95 gerechnet werden kann.', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1092, 'TH158', 'Ein Drahtdipol hat eine Gesamtlänge von 21,00 m. Für welche Frequenz ist der Dipol in Resonanz, wenn mit einem Korrekturfaktor von 0,95 gerechnet werden kann.', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1093, 'TH159', 'Eine Delta-Loop-Antenne mit einer vollen Wellenlänge soll für 7,1 MHz aus Draht hergestellt werden. Es kann mit einem Korrekturfaktor von 0,95 gerechnet werden. Wie lang muss der Draht insgesamt sein?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1094, 'TH160', 'Eine &lambda;-5/8-Antenne (gegen Erde) soll für 14,2 MHz aus Draht hergestellt werden. Es soll mit einem Korrekturfaktor von 0,97 gerechnet werden. Wie lang muss der Vertikaldraht insgesamt sein?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1095, 'TH201', 'Der Strahlungswiderstand einer Antenne', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1096, 'TH202', 'Welchen Eingangs- bzw. Fußpunktwiderstand hat ein Faltdipol?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1097, 'TH203', 'Welchen Eingangs- bzw. Fußpunktwiderstand hat eine Groundplane?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1098, 'TH204', 'Welchen Eingangs- bzw. Fußpunktwiderstand hat ein &lambda;/2-Dipol bei seiner Grundfrequenz und hinreichender Höhe über dem Boden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1099, 'TH205', 'Welche Impedanz hat ein &lambda;/2-Dipol unterhalb und oberhalb seiner Grundfrequenz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1100, 'TH206', 'Das folgende Bild zeigt das Richtdiagramm einer Dipol- und einer Yagi-Antenne. Der Antennengewinn der Yagi-Antenne über dem Dipol ist definiert als<p><img src=''th206f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1101, 'TH207', 'Das folgende Bild zeigt das Richtdiagramm einer Dipol- und einer Yagi-Antenne. Das Vor-/Rück-Verhältnis der Yagi-Antenne ist definiert<p><img src=''th206f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1102, 'TH208', 'Der Gewinn von Antennen wird häufig in dBi angegeben. Auf welche Vergleichsantenne bezieht man sich dabei? Man bezieht sich dabei auf den', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1103, 'TH209', 'Ein Antennenhersteller gibt den Gewinn einer Antenne mit 5 dBd an. Wie groß ist der Gewinn der Antenne in dBi?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1104, 'TH210', 'Warum ist eine &lambda;-5/8-Antenne besser als eine &lambda;/4-Antenne für VHF-UHF-Mobilbetrieb geeignet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1105, 'TH211', 'Die Halbwertsbreite einer Antenne ist der Winkelbereich, innerhalb dem', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1106, 'TH212', 'In dem folgenden Richtdiagramm sind auf der Skala der relativen Feldstärke E / E<sub>max</sub> die Punkte A bis D markiert. Durch welchen der Punkte A bis D ziehen sie mit einem Zirkel den Kreisbogen, um die Halbwertsbreite der Antenne an den Schnittpunkten des Kreises mit der Keule ablesen zu können?<p><img src=''th212f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1107, 'TH213', 'Die folgende Skizze zeigt das Horizontaldiagramm der relativen Feldstärke einer horizontalen Yagiantenne. Wie groß ist im vorliegenden Fall die Halbwertsbreite (Öffnungswinkel)?<p><img src=''th213f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1108, 'TH214', 'Warum muss eine Antenne mechanisch immer etwas kürzer als der theoretisch errechnete Wert sein?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1109, 'TH215', 'Bei einer Drahtantenne bewirkt eine Erhöhung der Drahtlänge', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1110, 'TH216', 'Die Polarisation einer Antenne', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1111, 'TH217', 'Mit welcher Polarisation wird auf den Kurzwellenbändern meistens gesendet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1112, 'TH218', 'Wie wird die Polarisation einer elektromagnetischen Welle bei der Ausbreitung über die Raumwelle beeinflusst?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1113, 'TH219', 'Für die Erzeugung von zirkularer Polarisation mit Yagi-Antennen wird eine horizontale und eine dazu um 90 Grad um die Strahlungsachse gedrehte Yagi-Antenne zusammengeschaltet. Was ist dabei zu beachten, damit tatsächlich zirkulare Polarisation entsteht?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1114, 'TH220', 'Eine Antenne hat ein Stehwellenverhältnis (VSWR) von 3. Wie viel Prozent der vorlaufenden Leistung werden von der Zuleitung auf die Antenne übertragen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1115, 'TH221', 'Ein Kabel mit einem Wellenwiderstand von 75 und vernachlässigbarer Dämpfung wird zur Speisung einer Faltdipol-Antenne verwendet. Welches VSWR kann man auf der Leitung erwarten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1116, 'TH222', 'Welches Strahlungsdiagramm ist der richtigen Antennenbezeichnung zugeordnet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1117, 'TH223', 'Welches Strahlungsdiagramm ist der richtigen Antennenbezeichnung zugeordnet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1118, 'TH224', 'Welches Strahlungsdiagramm ist der richtigen Antennenbezeichnung zugeordnet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1119, 'TH225', 'Ein Sender mit 0,6 Watt Ausgangsleistung ist über eine Antennenleitung, die 1 dB Kabelverluste hat, an eine Richtantenne mit 11 dB Gewinn (auf den Dipol bezogen) angeschlossen. Welche EIRP wird von der Antenne maximal abgestrahlt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1120, 'TH226', 'Ein Sender mit 5 Watt Ausgangsleistung ist über eine Antennenleitung, die 2 dB Kabelverluste hat, an eine Richtantenne mit 5 dB Gewinn (auf den Dipol bezogen) angeschlossen. Welche EIRP wird von der Antenne maximal abgestrahlt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1121, 'TH227', 'Ein Sender mit 8,5 Watt Ausgangsleistung ist über eine Antennenleitung, die 1,5 dB Kabelverluste hat, an eine Antenne mit 0 dB Gewinn (auf den Dipol bezogen) angeschlossen. Welche EIRP wird von der Antenne maximal abgestrahlt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1122, 'TH228', 'An einen Sender mit 100 W Ausgangsleistung ist eine Antenne mit einem Gewinn von 11 dBi angeschlossen. Die Dämpfung des Kabels beträgt 1 dB. Wie hoch ist die äquivalente Strahlungsleistung (EIRP)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1123, 'TH229', 'An einen Sender mit 100 W Ausgangsleistung ist eine Dipolantenne angeschlossen. Die Dämpfung des Kabels beträgt 10 dB. Wie hoch ist die äquivalente isotrope Strahlungsleistung (EIRP)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1124, 'TH230', 'Eine im Außenbereich installierte Sendeantenne wird immer bevorzugt, da', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1125, 'TH231', 'Eine Langdrahtantenne mit einer senkrechten Speiseleitung in der Nähe eines Hauses', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1126, 'TH232', 'Mit einem Feldstärkemessgerät wurden Vergleichsmessungen zwischen Beam und Dipol durchgeführt. In einem Abstand von 32 m wurden folgende Feldstärken gemessen: Beam vorwärts: 300 µV/m, Beam rückwärts: 20 µV/m, Halbwellendipol in Hauptstrahlrichtung: 128 µV/m. Welcher Gewinn und welches Vor-Rück-Verhältnis ergibt sich daraus für den Beam?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1127, 'TH301', 'Der Wellenwiderstand einer Leitung', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1128, 'TH302', 'Eine Übertragungsleitung gilt als richtig angepasst, wenn der Widerstand, mit dem sie abgeschlossen ist,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1129, 'TH303', 'Im Amateurfunk übliche Koaxialkabel weisen typischerweise Wellenwiderstände von', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1130, 'TH304', 'Welche Dämpfung ergibt sich auf der Grundlage des Kabeldämpfungsdiagramms für ein 15-m-langes Koaxialkabel vom Typ RG58 bei 145 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1131, 'TH305', 'Welche Dämpfung ergibt sich auf der Grundlage des Kabeldämpfungsdiagramms für ein 15-m-langes Koaxialkabel vom Typ RG58 bei 435 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1132, 'TH306', 'Welche Dämpfung ergibt sich auf der Grundlage des Kabeldämpfungsdiagramms für ein 25-m-langes Koaxialkabel vom Typ RG213 (MIL) bei 3,5 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1133, 'TH307', 'Welche Dämpfung ergibt sich auf der Grundlage des Kabeldämpfungsdiagramms für ein 25-m-langes Koaxialkabel vom Typ RG213U-S100 bei 29 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1134, 'TH308', 'Welche Dämpfung ergibt sich auf der Grundlage des Kabeldämpfungsdiagramms für ein 25-m-langes Koaxialkabel vom Typ RG213 (MIL) bei 145 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1135, 'TH309', 'Welche Dämpfung ergibt sich auf der Grundlage des Kabeldämpfungsdiagramms für ein 25-m-langes Koaxialkabel vom Typ RG213U-S100 bei 435 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1136, 'TH310', 'Welche Dämpfung ergibt sich auf der Grundlage des Kabeldämpfungsdiagramms für ein 25-m-langes Koaxialkabel vom Typ RG213U-S100 bei 1296 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1137, 'TH311', 'Welches der folgenden Kabel weist im Kurzwellenbereich den geringsten Verlust auf?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1138, 'TH312', 'Welche Vorteile hat eine Paralleldraht-Speiseleitung?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1139, 'TH313', 'Wann ist eine Speiseleitung asymmetrisch?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1140, 'TH314', 'Bei einer Leitung mit symmetrischer Übertragung', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1141, 'TH315', 'Ein Koaxialkabel hat einen Innenleiterdurchmesser von 0,7 mm. Die Isolierung zwischen Innenleiter und Abschirmgeflecht besteht aus Polyethylen (PE) und sie hat einen Durchmesser von 4,4 mm. Der Außendurchmesser des Kabels ist 7,4 mm. Wie hoch ist der ungefähre Wellenwiderstand des Kabels?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1142, 'TH316', 'Eine offene Paralleldrahtleitung ist aus Draht mit einem Durchmesser d = 2 mm gefertigt. Der Abstand der parallelen Leiter beträgt a = 20 cm. Wie groß ist der Wellenwiderstand Z<sub>0</sub> der Leitung?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1143, 'TH317', 'Ein Koaxialkabel (luftisoliert) hat einen Innendurchmesser der Abschirmung von 5 mm. Der Außendurchmesser des inneren Leiters beträgt 1 mm . Wie groß ist der Wellenwiderstand Z<sub>0</sub> des Kabels?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1144, 'TH318', 'Die Ausbreitungsgeschwindigkeit in einem Koaxialkabel', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1145, 'TH319', 'Der Verkürzungsfaktor einer luftisolierten Paralleldrahtleitung ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1146, 'TH320', 'Der Verkürzungsfaktor eines Koaxialkabels mit einem Dielektrikum aus massivem Polyäthylen beträgt ungefähr', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1147, 'TH321', 'Wie lang ist ein Koaxialkabel, das für eine ganze Wellenlänge bei 100 MHz zugeschnitten wurde, wenn der Verkürzungsfaktor 0,6 beträgt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1148, 'TH322', 'Welche mechanische Länge hat ein &lambda;/4-langes Koaxkabel mit Vollpolyethylenisolierung bei 145 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1149, 'TH323', 'Wie verhält sich das Stehwellenverhältnis, wenn Wasser in eine genau angepasste Antennenspeiseleitung eindringt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1150, 'TH324', 'Welche Leitungen sollten für die HF-Verbindungen zwischen Einrichtungen in der Amateurfunkstelle verwendet werden, um unerwünschte Abstrahlungen zu vermeiden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1151, 'TH325', 'Eine Lecherleitung besteht aus zwei parallelen Leitern. Wovon ist ihre Resonanzfrequenz wesentlich abhängig? Sie ist abhängig', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1152, 'TH326', 'Was zeigt diese Darstellung?<p><img src=''th326f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1153, 'TH327', 'Um Ordnung in der Amateurfunkstelle herzustellen, verlegen Sie alle Netzanschlusskabel und HF-Speiseleitungen in einem Kabelkanal. Welche Nachteile kann diese Maßnahme haben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1154, 'TH328', 'Um die Störwahrscheinlichkeit auf ein Mindestmaß zu begrenzen, sollte die für die Sendeantenne verwendete Speiseleitung', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1155, 'TH329', 'Am Eingang einer HF-Übertragungsleitung werden 100 W HF-Leistung bei richtiger Anpassung eingespeist. Die Dämpfung der Leitung beträgt 3 dB. Welche Leistung wird bei Leerlauf oder Kurzschluss am Leitungsende reflektiert, wenn dabei am Leitungsende keine Leistung verbraucht oder abgestrahlt wird?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1156, 'TH330', 'Am Eingang einer Antennenleitung, deren Dämpfung mit 5 dB berechnet wurde, werden 10 Watt HF-Leistung eingespeist. Mit der am Leitungsende angeschlossenen Antenne misst man am Leitungseingang ein VSWR von 1. Welches VSWR ist am Leitungseingang zu erwarten, wenn die Antenne am Leitungsende abgeklemmt wird?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1157, 'TH331', 'Am Eingang einer Antennenleitung, deren Dämpfung mit 3 dB berechnet wurde, werden 10 Watt HF-Leistung eingespeist. Mit der am Leitungsende angeschlossenen Antenne misst man am Leitungseingang ein VSWR von 3. Mit einer künstlichen 50-&Omega;-Antenne am Leitungsende beträgt das VSWR am Leitungseingang etwa 1. Was lässt sich aus diesen Messergebnissen schließen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1158, 'TH401', 'Was zeigt diese Darstellung?<p><img src=''th401f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1159, 'TH402', 'Zur Anpassung von Antennen werden häufig Umwegleitungen verwendet. Wie arbeitet die folgende Schaltung?<p><img src=''th401f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1160, 'TH403', 'Einem Ganzwellendipol wird die Sendeleistung über eine abgestimmte &lambda;/4-Speiseleitung zugeführt. Wie groß ist die Impedanz Z<sub>1</sub> am Einspeisepunkt des Dipols? Und wie groß ist die Impedanz Z<sub>2</sub> am Anfang der Speiseleitung?<p><img src=''th403f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1161, 'TH404', 'Einem Ganzwellendipol wird die Sendeleistung über eine abgestimmte &lambda;/2-Speiseleitung zugeführt. Wie groß ist die Impedanz Z<sub>1</sub> am Einspeisepunkt des Dipols? Und wie groß ist die Impedanz Z<sub>2</sub> am Anfang der Speiseleitung?<p><img src=''th403f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1162, 'TH405', 'Einem Halbwellendipol wird die Sendeleistung über eine abgestimmte &lambda;/2-Speiseleitung zugeführt. Wie groß ist die Impedanz Z<sub>1</sub> am Einspeisepunkt des Dipols? Und wie groß ist die Impedanz Z<sub>2</sub> am Anfang der Speiseleitung?<p><img src=''th403f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1163, 'TH406', 'Ein Faltdipol mit einem Fußpunktwiderstand von 240 &Omega; soll mit einer Hühnerleiter gespeist werden, deren Wellenwiderstand 600 &Omega; beträgt. Zur Anpassung soll ein &lambda;/4-langes Stück Hühnerleiter mit einem anderem Wellenwiderstand verwendet werden. Welchen Wellenwiderstand muss die Transformationsleitung haben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1164, 'TH407', 'Ein Dipol mit einem Fußpunktwiderstand von 60 &Omega; soll über eine &lambda;/4-Transformationsleitung mit einem 240-&Omega;-Flachbandkabel gespeist werden. Welchen Wellenwiderstand muss die Transformationsleitung haben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1165, 'TH408', 'Wie groß ist die Impedanz am Punkt X, wenn die elektrische Länge der abgebildeten Leitung &lambda;/4 beträgt?<p><img src=''th408f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1166, 'TH409', 'Wie groß ist die Impedanz am Punkt X, wenn die elektrische Länge der abgebildeten Leitung &lambda;/4 beträgt?<p><img src=''th409f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1167, 'TH410', 'Eine Viertelwellen-Übertragungsleitung ist an einem Ende offen. Die Impedanz am anderen Ende', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1168, 'TH411', 'Welche Phasenverschiebung erhält ein HF-Signal von A nach B, wenn die elektrische Länge der abgebildeten Leitung &lambda;/4 beträgt?<p><img src=''th411f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1169, 'TH412', 'Welche Phasenverschiebung erhält ein HF-Signal von A nach B, wenn die elektrische Länge der abgebildeten Leitung gleich der Wellenlänge ist?<p><img src=''th411f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1170, 'TH413', 'Eine Halbwellen-Übertragungsleitung ist an einem Ende mit 50 &Omega; abgeschlossen. Wie groß ist die Eingangsimpedanz am anderen Ende dieser Leitung?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1171, 'TH414', 'Ein Halbwellendipol hat an seinem Einspeisepunkt eine Impedanz von 70 . Er wird über ein &lambda;/2-langes 300-&Omega;-Flachbandkabel gespeist. Wie groß ist die Impedanz am Eingang der Speiseleitung?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1172, 'TH415', 'Welche Auswirkungen hat es, wenn eine symmetrische Antenne (Dipol) mit einem Koaxkabel gleicher Impedanz gespeist wird?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1173, 'TH416', 'Eine symmetrische Antenne (Dipol) soll mit einem unsymmetrischen Kabel (Koaxkabel) gleicher Impedanz gespeist werden. Dabei erreicht man einen Symmetriereffekt zum Beispiel', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1174, 'TH417', 'Auf einem Ferritkern sind etliche Windungen Koaxialkabel aufgewickelt. Diese Anordnung kann dazu dienen<p><img src=''tb401f.jpg''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1175, 'TH418', 'Ein symmetrischer Halbwellendipol wird direkt über ein Koaxialkabel von einem Sender gespeist. Das Kabel ist senkrecht am Haus entlang verlegt und verursacht geringe Störungen. Um das Problem weiter zu verringern, empfiehlt es sich', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1176, 'TH419', 'Für welche Antennenimpedanz ist der folgende Balun-Transformator aus zweimal 8 Windungen ausgelegt?<p><img src=''th419f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1177, 'TH420', 'Folgender Balun-Transformator aus zweimal 8 Windungen ist gegeben. Von A nach B wird ein Faltdipol mit 200 Ohm Impedanz angeschlossen. Welche Impedanz misst man zwischen A und M?<p><img src=''th420f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1178, 'TH421', 'Fehlanpassungen, schlecht montierte Steckverbindungen oder Beschädigungen von HF-Übertragungsleitungen', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1179, 'TH422', 'Am Eingang einer Antennenleitung misst man ein VSWR von 3. Wie groß ist in etwa die rücklaufende Leistung am Messpunkt, wenn die vorlaufende Leistung dort 100 Watt beträgt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1180, 'TH423', 'Ein Balun ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1181, 'TI101', 'Welche ionosphärischen Schichten bestimmen die Fernausbreitung am Tage?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1182, 'TI102', 'Welche ionosphärischen Schichten bestimmen die Fernausbreitung in der Nacht?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1183, 'TI103', 'In welcher Höhe befindet sich die für die Fernausbreitung wichtige F1-Schicht an einem Sommertag? Sie befindet sich in ungefähr', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1184, 'TI104', 'In welcher Höhe befindet sich die für die Fernausbreitung wichtige F2-Schicht an einem Sommertag? Sie befindet sich in ungefähr', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1185, 'TI105', 'In welcher Höhe befindet sich die für die Fernausbreitung wichtige E-Schicht an einem Sommertag? Sie befindet sich in ungefähr', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1186, 'TI106', 'In welcher Höhe befindet sich die für die Fernausbreitung wichtige D-Schicht an einem Sommertag? Sie befindet sich in ungefähr', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1187, 'TI107', 'In etwa welcher Höhe über der Erdoberfläche befindet sich die E-Schicht? Sie befindet sich in ungefähr', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1188, 'TI108', 'In welcher Höhe über dem Boden befindet sich in etwa die F1-Schicht? Sie befindet sich in ungefähr', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1189, 'TI109', 'Zu welcher Jahres- und Tageszeit hat die F2-Schicht ihre größte Höhe? Sie hat ihre größte Höhe', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1190, 'TI110', 'Welche ionosphärische Schicht ermöglicht im wesentlichen Weitverkehrsverbindungen im Kurzwellenbereich?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1191, 'TI111', 'Für die Kurzwellenausbreitung über die Raumwelle ist die F1-Schicht', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1192, 'TI112', 'Welchen Einfluss hat die D-Schicht auf die Fernausbreitung?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1193, 'TI113', 'Wodurch kommt die Reflexionsfähigkeit der ionosphärischen Schichten im wesentlichen zustande?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1194, 'TI114', 'Wie kommt die Fernausbreitung einer Funkwelle auf den Kurzwellenbändern zustande? Sie kommt zustande', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1195, 'TI115', 'Der solare Flux F', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1196, 'TI201', 'Unter der "Toten Zone" wird der Bereich verstanden,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1197, 'TI202', 'Welche der folgenden Aussagen trifft für KW-Funkverbindungen zu, die über Bodenwellen erfolgen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1198, 'TI203', 'Eine Aussendung auf 14,18 MHz kann von der Funkstelle A in einer Entfernung von 1500 km, nicht jedoch von der Funkstelle B in 60 km Entfernung empfangen werden. Der Grund hierfür ist, dass', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1199, 'TI204', 'Unter Sprungentfernung versteht man', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1200, 'TI205', 'Was wirkt sich nicht auf die Sprungentfernung aus? Keine Auswirkung hat', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1201, 'TI206', 'Wie groß ist in etwa die maximale Entfernung, die ein KW-Signal bei Reflexion an der F2-Schicht auf der Erdoberfläche mit einem Sprung (Hop) überbrücken kann?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1202, 'TI207', 'Wie groß ist in etwa die maximale Entfernung, die ein KW-Signal bei Reflexion an der E-Schicht auf der Erdoberfläche mit einem Sprung (Hop) überbrücken kann? Sie beträgt ungefähr', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1203, 'TI208', 'Von welchem der genannten Parameter ist die Sprungdistanz abhängig, die ein KW-Signal auf der Erdoberfläche überbrücken kann? Sie ist abhängig', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1204, 'TI209', 'Was ist mit der Aussage "Funkverkehr über den langen Weg (long path)" gemeint?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1205, 'TI210', 'Eine Amateurfunkstation in Frankfurt/Main will eine Verbindung nach Buenos Aires auf dem langen Weg herstellen. Auf welchen Winkel gegen Nord (Azimut) muss der Funkamateur seinen Kurzwellenbeam drehen, wenn die Beamrichtung für den kurzen Weg 231° beträgt? Er muss die Antenne drehen auf', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1206, 'TI211', 'Eine Amateurfunkstation in Frankfurt/Main will eine Verbindung nach Tokio auf dem langen Weg herstellen. Auf welchen Winkel gegen Nord (Azimut) muss der Funkamateur seinen Kurzwellenbeam drehen, wenn die Beamrichtung für den kurzen Weg 38° beträgt? Er muss die Antenne drehen auf', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1207, 'TI212', 'Bei der Ausbreitung auf Kurzwelle spielt die so genannte "Grey Line" eine besondere Rolle. Die "Grey Line" ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1208, 'TI213', 'Was versteht man unter dem Begriff "Mögel-Dellinger-Effekt"? Man versteht darunter', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1209, 'TI214', 'Ein plötzlicher Anstieg der Intensitäten von UV- und Röntgenstrahlung nach einem Flare (Energieausbruch der Sonne) führt zu erhöhter Ionisierung der D-Schicht und damit zu kurzzeitigem Totalausfall der ionosphärischen Kurzwellenausbreitung. Diese Erscheinung wird auch als', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1210, 'TI215', 'Ionosphärische Störungen, hervorgerufen durch stark erhöhte Intensität der UV- und Röntgenstrahlung beeinflussen vor allem', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1211, 'TI216', 'Ionosphärischer Schwund kann auf', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1212, 'TI217', 'Welches Ereignis tritt ein, wenn zwei phasenverschobene Signale an einem Empfangsort zusammentreffen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1213, 'TI218', 'Backscatter oder Rückstreuung kann auftreten, wenn', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1214, 'TI219', 'Was ist für ein "Backscatter-Signal" charakteristisch?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1215, 'TI220', 'Unter dem Begriff "short skip" versteht man Funkverbindungen oberhalb 21 MHz mit Sprungentfernungen unter 1000 km, die', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1216, 'TI221', 'Damit ein Signal zur Erde zurückreflektiert wird, müsste bei zunehmender Sendefrequenz die Ionisierung der reflektierenden Schicht', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1217, 'TI222', 'Die kritische Grenzfrequenz (F<sub>krit</sub>) ist die', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1218, 'TI223', 'Die höchste Frequenz, bei der eine zufrieden stellende Kommunikation zwischen zwei Funkstellen im HF-Bereich gewährleistet ist, wird als', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1219, 'TI224', 'Die MUF für eine Funkstrecke ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1220, 'TI225', 'Eine stärkere Ionisierung der F2-Schicht führt zu', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1221, 'TI226', 'Die höchste brauchbare Frequenz (MUF) für eine Funkstrecke', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1222, 'TI227', 'Wie groß ist die obere brauchbare Frequenz (MUF) und die optimale Frequenz fopt bei Verwendung einer Antenne, die einen Abstrahlwinkel von 45° hat, wenn die kritische Frequenz fk mit 3 MHz gemessen wurde?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1223, 'TI228', 'Was bedeutet die Aussage: "Die kritische Frequenz liegt bei 22 MHz"?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1224, 'TI229', 'Was bedeutet die Aussage: "Die LUF liegt bei 6 MHz"?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1225, 'TI230', 'Die LUF für eine Funkstrecke ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1226, 'TI231', 'Die Ausbreitungsbedingungen für ein Amateurfunkband werden folgendermaßen beschrieben: "Das Band ist nur in Zeiten starker Sonnenaktivität für Verbindungen über die Raumwelle brauchbar. Tagsüber bestehen dann hervorragende DX-Möglichkeiten, auch mit sehr kleiner Sendeleistung. Die tote Zone beträgt bis zu 4000 km. Der Ausbreitungsweg muss auf der Tagseite erfolgen." Welches KW-Band wurde hier beschrieben? Beschrieben wurde das', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1227, 'TI232', 'Die Ausbreitungsbedingungen für ein Amateurfunkband werden folgendermaßen beschrieben: "Die Ausbreitungsbedingungen auf diesem Band sind stark von den Sonnenfleckenzyklen abhängig. Während des Sonnenfleckenmaximums ist das Band fast durchgehend für den DX-Verkehr geöffnet. Im Sonnenfleckenminimum ist das Band bestenfalls in den Sommermonaten tagsüber und meist nur kurzzeitig für den DX-Verkehr brauchbar." Welches KW-Band wurde hier beschrieben? Beschrieben wurde das', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1228, 'TI233', 'Die Ausbreitungsbedingungen für ein Amateurfunkband werden folgendermaßen beschrieben: "Fast zu allen Zeiten lässt sich das Band für den Verkehr mit anderen Kontinenten nutzen. Im Sonnenfleckenminimum ist das Band nur tagsüber und in der Dämmerungsperiode offen. Die Sprungsdistanz liegt zwischen 1000 km im Sonnenfleckenminimum und 400 km im Sonnenfleckenmaximum. Für Europaverbindungen ist das Band nur während des Sonnenfleckenmaximums im Sommer brauchbar, wenn fast keine tote Zone mehr vorhanden ist." Welches KW-Band wurde hier beschrieben? Beschrieben wurde das', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1229, 'TI234', 'Die Ausbreitungsbedingungen für ein Amateurfunkband werden folgendermaßen beschrieben: "In diesem Band ist die Tagesdämpfung durch die D-Schicht noch erheblich. Die Tagesreichweite geht bis zu 1000 km. Die tote Zone beträgt am Tage etwa 100 km. Nachts und während der Wintermonate vergrößert sich die Sprungdistanz mit einem Maximum um Mitternacht. Größte Reichweiten treten auf, wenn sich der gesamt Ausbreitungspfad auf der Nachtseite der Erde befindet." Welches KW-Band wurde hier beschrieben? Beschrieben wurde das', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1230, 'TI235', 'Die Ausbreitungsbedingungen für ein Amateurfunkband werden folgendermaßen beschrieben: "Während der Tagesstunden können nur relativ geringe Entfernungen überbrückt werden, weil die Wellen von der D-Schicht stark absorbiert werden. Im Winter sind die Tagesreichweiten größer als im Sommer, maximal etwa 400 km. Nach Sonnenuntergang steigen die Reichweiten wegen des Abbaus der dämpfenden D-Schicht an. Während des Sonnenfleckenminimums ist in den Morgenstunden oft interkontinentaler Funkverkehr möglich. Die Sprungsdistanz kann dabei auf bis zu 1000 km ansteigen." Welches KW-Band wurde hier beschrieben? Beschrieben wurde das', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1231, 'TI236', 'Die Ausbreitung der Wellen im 160-m-Band erfolgt tagsüber hauptsächlich', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1232, 'TI237', 'Warum sind Signale im 160-, 80- und 40-Meter-Band tagsüber nur schwach und nicht für den weltweiten Funkverkehr geeignet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1233, 'TI238', 'Welches der nachstehend aufgeführten Frequenzbänder ist für Aussendungen zwischen Hamburg und München während des Tages am besten geeignet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1234, 'TI239', 'Welches dieser Frequenzbänder kann am ehesten bei einem Sonnenfleckenminimum für dauerhafte Weitverkehrsverbindungen verwendet werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1235, 'TI301', 'Wie weit etwa reicht der Funkhorizont im UKW-Bereich über den geographischen Horizont hinaus?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1236, 'TI302', 'Überhorizontverbindungen im UHF/VHF-Bereich kommen unter anderem zustande durch', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1237, 'TI303', 'Überhorizontverbindungen im UHF/VHF-Bereich kommen u.a. zustande durch', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1238, 'TI304', 'Überhorizontverbindungen im UHF/VHF-Bereich kommen unter anderem zustande durch', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1239, 'TI305', 'Für VHF-Weitverkehrsverbindungen wird hauptsächlich die', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1240, 'TI306', 'Was ist die "Troposphäre"? Die Troposphäre ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1241, 'TI307', 'Wie wirkt sich die Antennenhöhe auf die Reichweite einer UKW-Verbindung aus?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1242, 'TI308', 'Beim Auftreten von Polarlichtern lassen sich auf den Amateurfunkbändern über 30 MHz beträchtliche Überreichweiten erzielen, weil', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1243, 'TI309', 'Was ist die Ursache für Aurora-Erscheinungen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1244, 'TI310', 'Wie wirkt sich "Aurora" auf die Signalqualität eines Funksignals aus?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1245, 'TI311', 'In welcher ionosphärischen Schicht treten Aurora-Erscheinungen auf? Sie treten auf in der', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1246, 'TI312', 'Welche Betriebsart eignet sich am besten für Auroraverbindungen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1247, 'TI313', 'In welchen Gebieten treten Reflexionen an Nordlicht-Erscheinungen auf? Sie treten auf', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1248, 'TI314', 'Was sind sporadische E-Reflexionen? Es sind Reflexionen von Wellen im UKW-Bereich an', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1249, 'TI315', 'Was bedeutet der Begriff "Sporadic E"? Es ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1250, 'TI316', 'In welcher Region der Erde kommt "Sporadic-E" am häufigsten vor? Sie kommt am häufigsten vor', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1251, 'TI317', 'Welche Aussage ist für das Sonnenfleckenmaximum richtig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1252, 'TJ101', 'Das Prinzip eines Drehspulmessgeräts beruht auf', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1253, 'TJ102', 'Das Drehspulmesswerk in der folgenden Schaltung hat einen maximalen Messstrom I<sub>M</sub> = 100 µA und einen Messwerkwiderstand R<sub>M</sub> = 1 k&Omega;. R<sub>V</sub> = 499 k&Omega; Welche Gleichspannung muss an die Gesamtschaltung angelegt werden, damit das Messwerk Vollausschlag anzeigt?<p><img src=''tj102f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1254, 'TJ103', 'Das Drehspulmesswerk in der folgenden Schaltung hat einen maximalen Messstrom I<sub>M</sub> = 0,3 mA und einen Messwerkwiderstand R<sub>M</sub> = 300 &Omega;. R<sub>V</sub> = 9,7 k Welche Gleichspannung muss an die Gesamtschaltung angelegt werden, damit das Messwerk Vollausschlag anzeigt?<p><img src=''tj102f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1255, 'TJ104', 'Das Drehspulmesswerk in der folgenden Schaltung hat einen maximalen Messstrom I<sub>M</sub> = 100 µA und einen Messwerkwiderstand R<sub>M</sub> = 1 k&Omega;. Wie groß muss R<sub>P</sub> gewählt werden, damit das Messwerk in der Gesamtschaltung bei I = 100 mA Vollausschlag anzeigt?<p><img src=''tj104f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1256, 'TJ105', 'Wenn bei dieser Messschaltung I = 1 A zu einem Vollausschlag des Instruments führt, beträgt der Strom durch R<sub>P</sub><p><img src=''tj105f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1257, 'TJ106', 'Wie groß muss R<sub>P</sub> bei der folgenden Schaltung gewählt werden, wenn I = 1 A zum Vollausschlag des Instruments mit 300 &Omega; Innenwiderstand führen soll?<p><img src=''tj105f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1258, 'TJ107', 'Durch ein Einbauinstrument mit einem Messbereich von 2 V, fließt bei Vollausschlag ein Strom von 2 mA. Das Instrument soll mit einem Vorwiderstand auf einen Messbereich von 20 V Endausschlag erweitert werden. Wie groß ist der Widerstandswert R<sub>V</sub> und die Belastung P<sub>V</sub> des Vorwiderstandes?<p><img src=''tj107f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1259, 'TJ108', 'Der Messbereich eines Amperemeters mit dem Innenwiderstand R<sub>i</sub> soll um den Faktor 5 erweitert werden. Durch welche Maßnahme ist dies erreichbar?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1260, 'TJ109', 'Der Messbereich eines Voltmeters mit dem Innenwiderstand R<sub>i</sub> soll um den Faktor 8 erweitert werden. Durch welche Maßnahme ist dies erreichbar?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1261, 'TJ110', 'Ein Vielfachmessgerät hat in den Wechselspannungsbereichen die Empfindlichkeit 4 k&Omega;/V. Wie groß ist der Strom durch das Messgerät bei Vollausschlag im 10-V Bereich?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1262, 'TJ111', 'Mit welchem Strom zeigt ein 20-k&Omega;/V-Instrument Vollausschlag?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1263, 'TJ112', 'Ein Messgerät hat einen Kennwiderstand von 10 k&Omega;/V. Für 1 Volt Vollausschlag liegt die Stromaufnahme bei', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1264, 'TJ113', 'Die Auflösung eines Messinstruments entspricht', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1265, 'TJ114', 'Welches dieser Messgeräte verfügt normalerweise über die höchste Genauigkeit bei Spannungsmessungen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1266, 'TJ115', 'Ein Drehspulmessgerät hat meistens eine Genauigkeit von', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1267, 'TJ116', 'Welche Spannung wird bei dem folgenden Messinstrument angezeigt, wenn dessen Messbereich auf 10 V eingestellt ist?<p><img src=''tj116f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1268, 'TJ117', 'Welche Spannung wird bei dem folgenden Messinstrument angezeigt, wenn dessen Messbereich auf 300 V eingestellt ist?<p><img src=''tj116f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1269, 'TJ201', 'Ein Dipmeter ist beispielsweise', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1270, 'TJ202', 'Das Drehspulmesswerk eines Dipmeters', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1271, 'TJ203', 'Wozu wird ein Dipmeter beispielsweise verwendet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1272, 'TJ204', 'Wozu wird ein Dipmeter beispielsweise verwendet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1273, 'TJ205', 'Wozu wird ein Dipmeter beispielsweise verwendet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1274, 'TJ206', 'Ein Dipmeter hat normalerweise eine Genauigkeit von etwa', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1275, 'TJ207', 'Um wie viele Kilohertz kann die Frequenz abweichen, wenn mit einem Dipmeter eine Resonanzfrequenz von 7,1 MHz gemessen wurde und die Messgenauigkeit mit 3 % angenommen wird?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1276, 'TJ208', 'Um wie viele Kilohertz kann die Frequenz abweichen, wenn mit einem Dipmeter eine Resonanzfrequenz von 4,5 MHz gemessen wurde und die Genauigkeit mit 3 % angenommen wird?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1277, 'TJ209', 'Mit einem Dipmeter soll auf indirektem Wege eine Induktivität gemessen werden. Die Spule wurde zu einem Kondensator von 220 pF parallel geschaltet und bei 4,5 MHz Resonanz festgestellt. Welche Induktivität hat die Spule?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1278, 'TJ210', 'Mit einem Dipmeter soll auf indirektem Wege eine Induktivität gemessen werden. Die Spule wurde zu einem Kondensator von 330 pF parallel geschaltet und bei 5,5 MHz Resonanz festgestellt. Welche Induktivität hat die Spule?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1279, 'TJ211', 'Welches dieser Messgeräte ist für die Ermittlung der Resonanzfrequenz eines Traps, das für einen Dipol genutzt werden soll, am besten geeignet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1280, 'TJ301', 'Die Zeitbasis eines Oszillografen ist so eingestellt, dass ein Skalenteil 0,5 ms entspricht. Welche Frequenz hat die angelegte Spannung?<p><img src=''tj301f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1281, 'TJ302', 'Die Zeitbasis eines Oszillografen ist so eingestellt, dass ein Skalenteil 0,5 ms entspricht. Welche Periodendauer hat die angelegte Spannung?<p><img src=''tj301f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1282, 'TJ303', 'Um auf dem Bildschirm eines Oszilloskops ein stehendes Bild statt durchlaufender Wellenzüge zu erhalten muss, das Oszilloskop', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1283, 'TJ304', 'Welches Gerät kann für die Prüfung einer Signalform verwendet werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1284, 'TJ305', 'Welches dieser Geräte wird für die Anzeige von NF-Verzerrungen verwendet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1285, 'TJ401', 'Bei dieser Schaltung handelt es sich um<p><img src=''tj401f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1286, 'TJ402', 'Für welchen Zweck wird eine Stehwellenmessbrücke verwendet? Sie wird verwendet', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1287, 'TJ403', 'Ein Stehwellenmessgerät misst bei einer HF-Leitung im Grunde', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1288, 'TJ404', 'Ein Stehwellenmessgerät wird in ein ideal angepasstes Sender-/Antennensystem eingeschleift. Das Messgerät sollte', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1289, 'TJ405', 'Welches dieser Instrumente kann für die Anzeige der Anpassung zwischen einem UHF-Sender und der Speiseleitung verwendet werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1290, 'TJ406', 'Eine Antenne hat ein Stehwellenverhältnis (VSWR) von 3. Wie viel Prozent der vorlaufenden Leistung wird an der Stoßstelle Kabel-Antenne reflektiert?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1291, 'TJ501', 'Um die Skalenendwerte einer Sende-/Empfangsanlage mit VFO mit hinreichender Genauigkeit zu überprüfen, kann man', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1292, 'TJ502', 'Für eine größtmögliche Genauigkeit sollte ein Frequenzzähler', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1293, 'TJ503', 'Mit einem genauen Frequenzzähler und einem entsprechenden Dämpfungsglied kann', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1294, 'TJ504', 'Ein Frequenzzähler verfügt über eine Genauigkeit von ±1 ppm. Wenn der Zähler auf den 100-MHz-Bereich eingestellt wird, beträgt die Genauigkeit am oberen Ende des 100-MHz-Bereichs plus bzw. minus', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1295, 'TJ505', 'Welches der folgenden Messgeräte ist für genaue Frequenzmessungen am besten geeignet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1296, 'TJ506', 'Welches der folgenden Geräte kann in der Regel nicht für die Prüfung von Harmonischen verwendet werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1297, 'TJ507', 'Ein digitaler Frequenzzähler verfügt über eine Genauigkeit von 10 ppm und wird für eine Messung bei 145 MHz verwendet. Welcher der Messwerte weist die richtige Anzahl von genauen Dezimalstellen für die angegebene Genauigkeit auf?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1298, 'TJ508', 'Benutzt man bei einem Frequenzzähler eine Torzeit von 10 s anstelle von 1 s erhöht sich', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1299, 'TJ509', 'Was stellt die mit X gekennzeichnete Stelle der folgenden Anzeige eines Frequenzzählers dar?<p><img src=''tj509f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1300, 'TJ510', 'Was stellt die mit X gekennzeichnete Stelle der folgenden Anzeige eines Frequenzzählers dar?<p><img src=''tj510f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1301, 'TJ601', 'Welches Gerät ist hier dargestellt?<p><img src=''tj601f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1302, 'TJ602', 'Ein Absorptionsfrequenzmesser hat normalerweise eine Genauigkeit von etwa', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1303, 'TJ603', 'Das einfachste Gerät, mit dem geprüft werden kann, ob ein Quarz mit dem richtigen Oberton arbeitet, ist ein', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1304, 'TJ604', 'Mit welchem Messgerät können Harmonische festgestellt werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1305, 'TJ605', 'Ein Absorptionsfrequenzmesser ist ein Hilfsmittel zur Prüfung', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1306, 'TJ606', 'Ein Absorptionsfrequenzmesser eignet sich zur Prüfung', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1307, 'TJ701', 'Was stellt diese Schaltung dar?<p><img src=''tj701f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1308, 'TJ702', 'Wozu dient diese Schaltung? Sie dient<p><img src=''tj701f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1309, 'TJ703', 'Was stellt diese Schaltung dar?<p><img src=''tj703f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1310, 'TJ704', 'Sie wollen mit der folgenden Messschaltung die Ausgangsleistung eines 2-m-Senders überprüfen, der voraussichtlich zirka 15 W HF-Leistung liefert. Was sollte für die Messung vor die dargestellte Messschaltung geschaltet werden?<p><img src=''tj703f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1311, 'TJ705', 'Was muss für die genaue Messung der HF-Ausgangsleistung eines Senders mit einer solchen Schaltung berücksichtigt werden?<p><img src=''tj705f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1312, 'TJ706', 'Was stellt diese Schaltung dar?<p><img src=''tj706f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1313, 'TJ707', 'Mit welchem der folgenden Messinstrumente können die genauen Frequenzen der Harmonischen eines Signals gemessen werden? Sie können gemessen werden', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1314, 'TJ708', 'Für den Bau einer Dummy Load wurden Schichtwiderstände von 150 Ohm / 1 Watt verwendet. Jeweils vier Widerstände wurden in Serie geschaltet und durch Parallelschaltung dieser Serienschaltungen wurden zirka 50 Ohm erreicht. Wie viele Widerstände wurden insgesamt benötigt und welche Dauerleistung verträgt die Dummy Load?<p><img src=''tj708f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1315, 'TJ801', 'Wie werden elektrische Spannungsmesser an Messobjekte angeschlossen und welche Anforderungen muss das Messgerät erfüllen, damit der Messfehler möglichst gering bleibt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1316, 'TJ802', 'Wie sollten Strom- und Spannungsmesser zur Feststellung der Gleichstrom-Eingangsleistung des dargestellten Endverstärkers (PA) angeordnet werden?<p><img src=''tj802f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1317, 'TJ803', 'Für die Messung der Gleichstrom-Eingangsleistung werden verschiedene Messgeräte verwendet. Bei welchen der Instrumente in der Abbildung handelt es sich um Amperemeter?<p><img src=''tj802f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1318, 'TJ804', 'Welches der nachfolgend genannten Messgeräte ermöglicht die genaueste Messung der Spannung zwischen A und B?<p><img src=''tj804f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1319, 'TJ805', 'Mit einem Voltmeter der Klasse 1.5, das einen Skalenendwert von 300 Volt hat, messen Sie an einer Spannungsquelle 230 Volt. In welchem Bereich liegt der wahre Wert?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1320, 'TJ806', 'Mit einem Voltmeter der Klasse 2.5, das einen Skalenendwert von 20 Volt hat, messen Sie an einer Spannungsquelle 12,6 Volt. In welchem Bereich liegt der wahre Wert?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1321, 'TJ807', 'Das an den abgebildeten Spannungsteiler angeschlossene Messgerät ist auf den 10-V-Bereich eingestellt und hat eine Empfindlichkeit von 20 k&Omega;/V. Welcher Spannungswert wird angezeigt?<p><img src=''tj807f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1322, 'TJ808', 'Eine präzise Effektivwertmessung ist mit einem Gleichrichterinstrument', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1323, 'TJ809', 'Zur genauen Messung des Effektivwertes eines nicht sinusförmigen Stromes bis in den GHz-Bereich eignet sich', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1324, 'TJ810', 'Eine künstliche Antenne von 50 &Omega; verfügt über eine Anzapfung bei 5 &Omega; vom erdnahen Ende. Diese Anzapfung ermöglicht die', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1325, 'TJ811', 'Eine künstliche Antenne von 50 &Omega; verfügt über eine Anzapfung bei 5 &Omega; vom erdnahen Ende. Was könnte zur ungefähren Ermittlung der Senderausgangsleistung über diesen Messpunkt eingesetzt werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1326, 'TJ812', 'Wie ermittelt man die Resonanzfrequenz eines passiven Schwingkreises?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1327, 'TJ813', 'Die Resonanzfrequenz eines abgestimmten HF-Kreises kann mit einem', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1328, 'TJ814', 'Ein abgestimmter Kreis wird mit einem Dipmeter geprüft. Um eine Änderung der Resonanzfrequenz zu vermeiden, ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1329, 'TJ815', 'Welches Hilfsmittel sollten Sie bei präzisen Frequenzmessungen benutzen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1330, 'TJ816', 'Wenn ein Frequenzzähler für die Überprüfung der Frequenz eines Senders verwendet wird, ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1331, 'TJ817', 'Welche Konfiguration gewährleistet die höchste Genauigkeit bei der Prüfung der Trägerfrequenz eines FM-Senders?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1332, 'TJ818', 'Ein RTTY-Signal benötigt eine Bandbreite von 3 kHz. Ein Frequenzzähler mit einer Genauigkeit von 1 ppm wird für die Prüfung der Frequenzanzeige eines 145-MHz-Senders verwendet. Wie klein darf der Mindestabstand zur oberen Bandgrenze sein, damit die Aussendung innerhalb des Bandes stattfindet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1333, 'TJ819', 'Ein Quarznormal hat einen relativen Fehler von F = +/- 0,001 %. Wie genau können Sie eine Frequenz von f = 14100 kHz bestimmen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1334, 'TJ820', 'Wenn ein Faktor-10-Frequenzteiler vor einem Frequenzzähler geschaltet wird und der Zähler 14,5625 MHz anzeigt, beträgt die tatsächliche Frequenz', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1335, 'TJ821', 'Wie misst man das Stehwellenverhältnis? Man misst es', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1336, 'TJ822', 'Ein Stehwellenmessgerät wird bei Sendern zur Messung', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1337, 'TJ823', 'An welchem Punkt sollte das Stehwellenmessgerät eingeschleift werden, um zu prüfen, ob der Sender gut an die Antennenanlage angepasst ist?<p><img src=''tj823f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1338, 'TJ824', 'Zur Überprüfung eines Stehwellenmessgerätes wird dessen Ausgang mit einem 150-&Omega;-Widerstand abgeschlossen. Welches Stehwellenverhältnis muss das Messgerät anzeigen, wenn die Impedanz von Messgerät und Sender 50 &Omega; beträgt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1339, 'TJ825', 'Welches Messgerät könnte für den Nachweis von Harmonischen einer Aussendung verwendet werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1340, 'TJ826', 'Wann sollten mögliche Oberwellenausstrahlungen überprüft werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1341, 'TJ827', 'Worauf deutet die folgende Wellenform der Ausgangsspannung eines Leistungsverstärkers hin?<p><img src=''tj827f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1342, 'TJ828', 'Womit misst man am einfachsten die Hüllkurvenform eines HF-Signals? Man misst es am einfachsten mit einem', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1343, 'TJ829', 'Die Pulsbreite wird mit einem Oszilloskop normalerweise bei', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1344, 'TJ830', 'Dem Eingang der folgenden Messschaltung wird eine HF-Leistung von 1 Watt zugeführt. D ist eine Schottkydiode mit U<sub>F</sub> = 0,23V. Welche Spannung U<sub>A</sub> ist am Ausgang A zu erwarten, wenn die Messung mit einem hochohmigen Voltmeter erfolgt?<p><img src=''tj830f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1345, 'TJ831', 'Bei der folgenden Schaltung besteht R<sub>1</sub> aus einer Zusammenschaltung von Widerständen, die einen Gesamtwidersand von 50,77 hat und etwa 200 Watt aufnehmen kann. D ist eine Siliziumdiode mit U<sub>F</sub> = 0,7 V. Am Ausgang wird mit einem Digitalvoltmeter eine Gleichspannung von 14,9 V gemessen. Wie groß ist etwa die HF-Leistung am Eingang der Schaltung?<p><img src=''tj831f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1346, 'TJ832', 'Mit der folgenden Schaltung soll die Ausgangsleistung eines 2-m-Handfunkgerätes gemessen werden. D<sub>1</sub> und D<sub>2</sub> sind Schottkydioden mit U<sub>F</sub> = 0,23 V. Am Ausgang wird mit einem Digitalvoltmeter eine Gleichspannung von 15,3 V gemessen. Wie groß ist etwa die HF-Leistung am Eingang der Schaltung?<p><img src=''tj832f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1347, 'TJ833', 'Die Leistung eines 2-m-Senders soll mit einer künstlichen 50-&Omega;-Antenne bestimmt werden, die über eine Anzapfung bei 5 &Omega; vom erdnahen Ende verfügt. Zur Messung an diesem Punkt wird die folgende Schaltung eingesetzt. D<sub>1</sub> und D<sub>2</sub> sind Schottkydioden mit U<sub>F</sub> = 0,23 V. Am Ausgang der Schaltung wird dabei mit einem Digitalvoltmeter eine Gleichspannung von 15,3 V gemessen. Wie groß ist etwa die HF-Leistung des Senders?<p><img src=''tj833f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1348, 'TJ834', 'Das folgende Bild zeigt das Zweiton-SSB-Ausgangssignal eines KW-Senders, das mit einem Oszilloskop ausreichender Bandbreite über einen 10:1-Tastkopf direkt an der angeschlossenen künstlichen 50-&Omega;-Antenne gemessen wurde. Welche Ausgangsleistung (PEP) liefert der Sender?<p><img src=''tj834f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1349, 'TJ835', 'Das folgende Bild zeigt das Zweiton-SSB-Ausgangssignal eines KW-Senders, das mit einem Oszilloskop ausreichender Bandbreite über einen 2:1-Tastkopf direkt an der angeschlossenen künstlichen 50-&Omega;-Antenne gemessen wurde. Welche Ausgangsleistung (PEP) liefert der Sender?<p><img src=''tj835f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1350, 'TJ836', 'Das folgende Bild zeigt das Zweiton-SSB-Ausgangssignal eines KW-Senders, das mit einem Oszilloskop ausreichender Bandbreite über einen 2:1-Tastkopf direkt an der angeschlossenen künstlichen 50-&Omega;-Antenne gemessen wurde. Welche Ausgangsleistung (PEP) liefert der Sender?<p><img src=''tj836f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1351, 'TK101', 'Wie äußert sich Zustopfen bzw. Blockierung eines Empfängers? Es äußert sich durch', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1352, 'TK102', 'Welche Effekte werden durch Intermodulation hervorgerufen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1353, 'TK103', 'Wie kommen Geräusche aus den Lautsprechern einer abgeschalteten Stereoanlage möglicherweise zustande?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1354, 'TK104', 'Ein Sender sollte so betrieben werden, dass', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1355, 'TK105', 'In einem NF-Verstärker erfolgt die unerwünschte Gleichrichtung eines HF-Signals wahrscheinlich', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1356, 'TK106', 'Alle Geräte, die HF-Ströme übertragen, sollten', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1357, 'TK107', 'Durch eine Mantelwellendrossel in einem Fernseh-Antennenzuführungskabel', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1358, 'TK108', 'Ein unselektiver TV-Vorverstärker wird am wahrscheinlichsten', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1359, 'TK109', 'HF-Einstrahlung in die ZF-Stufe eines Fernsehempfängers führt in der Regel zu', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1360, 'TK110', 'Zur Verbesserung der Störfestigkeit gegenüber HF-Einstrahlungen können in einem NF-Leistungsverstärker', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1361, 'TK111', 'Welche sofortige Reaktion ist angebracht, wenn der Nachbar sich über HF-Einströmungen beklagt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1362, 'TK112', 'Ein Fernsehgerät wird durch das Nutzsignal einer KW-Amateurfunkstelle gestört. Wie kann das Signal in das Fernsehgerät eindringen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1363, 'TK113', 'Ein Funkamateur wohnt in einem Reihenhaus. An welcher Stelle sollte die KW-Drahtantenne angebracht werden, um die Störwahrscheinlichkeit auf ein Mindestmaß zu begrenzen? Sie sollte möglichst', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1364, 'TK114', 'Beim Betrieb Ihres 2-m-Senders wird bei einem Ihrer Nachbarn ein Fernsehempfänger gestört, der mit einer Zimmerantenne betrieben wird. Zur Behebung des Problems schlagen Sie dem Nachbarn vor,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1365, 'TK115', 'Während des Betriebs eines tragbaren KW-Transceivers mit Batterieversorgung treten zu Hause und unter Verwendung der ortsfesten Antenne bei einer elektronischen Orgel Störungen auf. Eine mögliche Ursache hierfür', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1366, 'TK116', 'In welcher Entfernung von einer 70-cm-Sendeantenne sollte eine Fernsehantenne installiert werden, um das Störpotenzial möglichst gering zu halten? Sie sollte', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1367, 'TK117', 'Ein starkes HF-Signal gelangt in die ZF-Stufe des Rundfunkempfängers des Nachbarn. Dieses Phänomen wird als', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1368, 'TK118', 'Die Bemühungen, die durch eine in der Nähe befindliche Amateurfunkstelle hervorgerufenen Fernsehstörungen zu verringern, sind fehlgeschlagen. Als nächster Schritt ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1369, 'TK119', 'Während einer ATV-Aussendung erscheint das Bild auch auf dem Fernsehgerät der Nachbarn. Eine mögliche Abhilfe der Störung wäre die', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1370, 'TK120', 'Bei einem Besuch beim Nachbarn zur Prüfung von Fernsehrundfunkstörungen ist zunächst', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1371, 'TK201', 'Die Übersteuerung eines Leistungsverstärkers führt zu', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1372, 'TK202', 'In HF-Schaltungen können Nebenresonanzen durch die', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1373, 'TK203', 'Diese Modulationshüllkurve eines CW-Senders sollte vermieden werden, da<p><img src=''tk203f.png''></p>', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1374, 'TK204', 'Bei einem Sender mit mehr als 2,5 mW Ausgangsleistung sollte die Dämpfung der Oberwellen im Frequenzbereich 1,7-35 MHz mindestens', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1375, 'TK205', 'Durch welche Maßnahme können Tastklicks verringert werden? Durch', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1376, 'TK206', 'Die gesamte Bandbreite einer FM-Aussendung beträgt 15 kHz. Wie groß ist der Abstand der Mittenfrequenz von der Bandgrenze mindestens zu wählen, damit die Aussendung innerhalb des Bandes bleibt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1377, 'TK207', 'Durch welche Maßnahme kann die übermäßige Bandbreite einer FM-Aussendung verringert werden? Durch die Verringerung der', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1378, 'TK208', 'Parasitäre Schwingungen können Störungen hervorrufen. Man erkennt sie auch daran, dass sie', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1379, 'TK209', 'Um Bandbreite einzusparen sollte der Frequenzumfang eines NF-Sprachsignals, das an einen Modulator angelegt wird,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1380, 'TK210', 'Wenn HF-Signale unerwünscht auf einen VFO zurückkoppeln, kann dies zu', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1381, 'TK211', 'Das Nutzsignal eines 144-MHz-Senders verursacht die Übersteuerung eines in der Nähe befindlichen UHF-Fernsehempfängers. Das Problem lässt sich durch den Einbau eines', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1382, 'TK212', 'Um Oberwellenausstrahlungen eines UHF-Senders zu minimieren, sollte dem Gerät', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1383, 'TK213', 'Ein SSB-Sender wird Störungen auf benachbarten Frequenzen hervorrufen, wenn', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1384, 'TK214', 'Im 144-MHz-Bereich werden Störungen festgestellt, die von einem quarzgesteuerten 432-MHz-Sender verursacht werden, dessen Quarzoszillator bei etwa 12 MHz schwingt. Die Oszillatorfrequenz wird in mehreren Stufen vervielfacht. Bei welcher Kombination der Vervielfacher tritt die Störung auf? Die Störung tritt auf bei der Kombination', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1385, 'TK215', 'Bei der Hi-Fi-Anlage des Nachbarn wird Einströmung in die NF festgestellt. Eine mögliche Abhilfe wäre', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1386, 'TK216', 'Bei einem Wohnort in einem Ballungsgebiet empfiehlt es sich, während der abendlichen Fernsehstunden', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1387, 'TK217', 'Falls sich eine Sendeantenne in der Nähe und parallel zu einer 230-V-Wechselstrom-Freileitung befindet,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1388, 'TK218', 'Zur Verhinderung von Fernsehstörungen, die durch Mantelwellen hervorgerufen werden, ist anstelle einer Mantelwellendrossel alternativ', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1389, 'TK219', 'Eine 435-MHz-Sendeantenne mit hohem Gewinn ist unmittelbar auf eine UHF-Fernseh-Empfangsantenne gerichtet. Dies führt gegebenenfalls zu', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1390, 'TK220', 'Im Mittelwellenbereich ergeben sich häufig Spiegelfrequenzstörungen durch', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1391, 'TK221', 'Ein korrodierter Anschluss an der Fernseh-Empfangsantenne des Nachbarn', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1392, 'TK222', 'Eine 435-MHz-Sendeantenne mit 1 kW ERP ist unmittelbar auf die Fernsehantenne des Nachbarn gerichtet. Dies führt gegebenenfalls', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1393, 'TK301', 'Um die Störwahrscheinlichkeit zu verringern, sollte die benutzte Sendeleistung', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1394, 'TK302', 'Wie kann man hochfrequente Störungen reduzieren, die durch Harmonische hervorgerufen werden? Sie können reduziert werden durch ein', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1395, 'TK303', 'Welchen Frequenzgang sollte ein Filter zur Verringerung der Oberwellenausgangsleistung eines KW-Senders haben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1396, 'TK304', 'Welches Filter sollte im Störungsfall für die Dämpfung von Kurzwellensignalen in ein Fernsehantennenkabel eingeschleift werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1397, 'TK305', 'Was sollte zur Herabsetzung starker Signale eines 21-MHz-Senders in das Fernseh-Antennenzuführungskabel eingeschleift werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1398, 'TK306', 'Welches Filter sollte im Störungsfall vor die einzelnen Leitungsanschlüsse eines UKW oder Fernsehrundfunkgeräts oder angeschlossener Geräte eingeschleift werden, um Kurzwellensignale zu dämpfen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1399, 'TK307', 'Die Signale eines 144-MHz-Senders werden in das Abschirmgeflecht des Antennenkabels eines FM-Rundfunkempfängers induziert und verursachen Störungen. Eine Möglichkeit zur Verringerung der Störungen besteht darin,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1400, 'TK308', 'Um die Störwahrscheinlichkeit im eigenen Haus zu verringern, empfiehlt es sich vorzugsweise', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1401, 'TK309', 'Erdleitungen sollten immer', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1402, 'TK310', 'Eine KW-Amateurfunkstelle verursacht im Sendebetrieb in einem in der Nähe betriebenen Fernsehempfänger Störungen. Welches Filter sollte man am besten in das Fernsehantennenkabel einschleifen, um die Störwahrscheinlichkeit zu verringern?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1403, 'TK311', 'Die Einfügungsdämpfung im Durchlassbereich eines passiven Hochpassfilters für ein Fernsehantennenkabel sollte', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1404, 'TK312', 'Ein Nachbar beschwert sich über Störungen seines Fernsehempfängers, die allerdings auch bei abgeschalteter TV-Antenne auftreten. Die Störungen fallen zeitlich mit den Übertragungszeiten des Funkamateurs zusammen. Als erster Schritt', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1405, 'TK313', 'Welches der nachfolgenden Filter könnte vor einem Netzanschlusskabel eingeschleift werden, um darüber fließende HF-Ströme wirksam zu dämpfen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1406, 'TK314', 'Beim Betrieb eines Funkempfängers mit digitalen Schaltungen auf einer gedruckten Leiterplatte treten erhebliche Störungen auf. Diese könnten verringert werden, indem die Leiterplatte', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1407, 'TK315', 'In einer Babyüberwachungsanlage mit zwei Geräten, die über ein langes Zwillingslitzenkabel miteinander verbunden sind, treten Störungen durch den Betrieb eines nahen Senders auf. Eine Möglichkeit zur Verringerung der Beeinflussungen besteht darin,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1408, 'TK316', 'Welche Art von Kondensatoren sollte zum Abblocken von HF-Spannungen vorzugsweise verwendet werden? Am besten verwendet man', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1409, 'TK317', 'Um etwaige Funkstörungen auf Nachbarfrequenzen zu begrenzen, sollte bei Telefonie die höchste zu übertragende NF-Frequenz', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1410, 'TK318', 'In den nachfolgenden Bildern sind mögliche Signalverläufe des Senderausgangssignals bei der CW-Tastung dargestellt. Welcher Signalverlauf führt zu den geringsten Störungen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1411, 'TL101', 'In Bezug auf EMV sollten Vervielfacherstufen', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1412, 'TL102', 'Um eine Amateurfunkstelle in Bezug auf EMV zu optimieren', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1413, 'TL103', 'Ein Sender ist mittels eines kurzen Koaxialkabels an eine Kollinearantenne mit 6 dB Gewinn angeschlossen. Wenn die der Antenne zugeführte Ausgangsleistung auf 5 W verringert wird, treten keine Störungen der Hi-Fi-Anlage des Nachbarn auf. Die Strahlungsleistung entspricht dabei einer ERP von', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1414, 'TL201', 'Sie besitzen eine &lambda;/4-Vertikalantenne. Da Sie für diese Antenne keine Selbsterklärung abgeben möchten und somit nur eine Strahlungsleistung von weniger als 10 W EIRP verwenden dürfen, müssen Sie die Sendeleistung soweit reduzieren, dass Sie unter diesem Wert bleiben. Wie groß darf die Sendeleistung ohne Berücksichtigung der Kabelverluste dabei sein?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1415, 'TL202', 'Eine Amateurfunkstelle sendet in FM mit einer äquivalenten Strahlungsleistung (ERP) von 100 W. Wie groß ist die Feldstärke im freien Raum in einer Entfernung von 100 m?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1416, 'TL203', 'Sie möchten den Personenschutz-Sicherheitsabstand für die Antenne Ihrer Amateurfunkstelle für das 20-m-Band und die Betriebsart RTTY berechnen. Der Grenzwert im Fall des Personenschutzes beträgt 28 V/m. Sie betreiben einen Dipol, der von einem Sender mit einer Leistung von 700 W über ein Koaxialkabel gespeist wird. Die Kabeldämpfung beträgt 0,5 dB. Wie groß ist der Sicherheitsabstand?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1417, 'TL204', 'Sie möchten den Personenschutz-Sicherheitsabstand für die Antenne Ihrer Amateurfunkstelle für das 2-m-Band und die Betriebsart FM berechnen. Der Grenzwert im Fall des Personenschutzes beträgt 28 V/m. Sie betreiben eine Yagi-Antenne mit einem Gewinn von 10,5 dBd. Die Antenne wird von einem Sender mit einer Leistung von 100 W über ein Koaxialkabel gespeist. Die Kabeldämpfung beträgt 1,5 dB. Wie groß ist der Sicherheitsabstand?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1418, 'TL205', 'Sie möchten den Personenschutz-Sicherheitsabstand für die Antenne Ihrer Amateurfunkstelle für das 20-m-Band und die Betriebsart RTTY berechnen. Der Grenzwert im Fall des Personenschutzes beträgt 28 V/m. Sie betreiben einen Dipol, der von einem Sender mit einer Leistung von 300 W über ein Koaxialkabel gespeist wird. Die Kabeldämpfung beträgt 0,5 dB. Wie groß ist der Sicherheitsabstand?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1419, 'TL206', 'Sie möchten den Personenschutz-Sicherheitsabstand für die Antenne Ihrer Amateurfunkstelle für das 10-m-Band und die Betriebsart RTTY berechnen. Der Grenzwert im Fall des Personenschutzes beträgt 28 V/m. Sie betreiben einen Dipol, der von einem Sender mit einer Leistung von 100 W über ein Koaxialkabel gespeist wird. Die Kabeldämpfung sei vernachlässigbar. Wie groß muss der Sicherheitsabstand sein?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1420, 'TL207', 'Sie möchten den Personenschutz-Sicherheitsabstand für die Antenne Ihrer Amateurfunkstelle für das 10-m-Band und die Betriebsart FM berechnen. Der Grenzwert im Fall des Personenschutzes beträgt 28 V/m. Sie betreiben eine Yagi-Antenne mit einem Gewinn von 7,5 dBd. Die Antenne wird von einem Sender mit einer Leistung von 100 W über ein langes Koaxialkabel gespeist. Die Kabeldämpfung beträgt 1,5 dB. Wie groß muss der Sicherheitsabstand sein?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1421, 'TL208', 'Sie möchten den Personenschutz-Sicherheitsabstand für die Antenne Ihrer Amateurfunkstelle in Hauptstrahlrichtung für das 2-m-Band und die Betriebsart FM berechnen. Der Grenzwert im Fall des Personenschutzes beträgt 28 V/m. Sie betreiben eine Yagi-Antenne mit einem Gewinn von 11,5 dBd. Die Antenne wird von einem Sender mit einer Leistung von 75 W über ein Koaxialkabel gespeist. Die Kabeldämpfung beträgt 1,5 dB. Wie groß muss der Sicherheitsabstand sein?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1422, 'TL209', 'Warum ist im Nahfeld einer Strahlungsquelle keine einfache Umrechnung zwischen den Feldgrößen E, H und S und damit auch keine vereinfachte Berechnung des Schutzabstandes möglich?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1423, 'TL210', 'Sie errechnen einen Sicherheitsabstand für Ihre Antenne. Von welchem Punkt aus muss dieser Sicherheitsabstand eingehalten werden, wenn Sie bei der Berechnung die Fernfeldnäherung verwendet haben? Er muss eingehalten werden', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1424, 'TL211', 'Wie errechnen Sie die Leistung am Einspeisepunkt der Antenne (Antenneneingangsleistung) bei bekannter Senderausgangsleistung?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1425, 'TL212', 'Für Ihre Yagi-Antenne, die an einem hohen Mast befestigt ist, beträgt der Sicherheitsabstand in Hauptstrahlrichtung 20 m. Da die Antenne jedoch über gefährdete Orte hinweg strahlt, dringt nur ein Teil des Feldes in den Bereich unterhalb der Antenne. Sie ermitteln einen kritischen Winkel von 40° und ersehen im Strahlungsdiagramm der Antenne eine Winkeldämpfung von 6 dB. Auf welchen Wert verringert sich dann der Sicherheitsabstand?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1426, 'TL213', 'Wann hat die folgende Formel zur Berechnung des Sicherheitsabstandes Gültigkeit und was sollten Sie tun, wenn die Gültigkeit nicht mehr sichergestellt ist?<br> d = sqrt(30 &Omega; * P<sub>EIRP</sub>) / E', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1427, 'TL214', 'Mit welcher Ausgangsleistung rechnen Sie im Fall des Personenschutzes, um den Sicherheitsabstand zu ermitteln?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1428, 'TL215', 'Sie betreiben eine Amateurfunkstelle auf dem 2-m-Band mit einer Rundstrahlantenne mit 6 dB Gewinn über dem Dipol. Wie hoch darf die maximale Ausgangsleistung Ihres Senders unter Vernachlässigung der Kabeldämpfung sein, wenn der Grenzwert für den Personenschutz 28 V/m und der zur Verfügung stehende Sicherheitsabstand 5 m beträgt.', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1429, 'TL216', 'Muss ein Funkamateur als Betreiber einer ortsfesten 2-m-Amateurfunkstelle bei der Sendeart F3E und einer Senderleistung von 6 Watt an einer 15-Element-Yagiantenne mit 13 dB Gewinn und vernachlässigbaren Kabelverlusten die Einhaltung der Personenschutzgrenzwerte nachweisen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1430, 'TL217', 'Für den Schutz von Trägern aktiver medizinischer Implantate sind auch die Grenzwerte zum Schutz von Herzschrittmacherträgern zu beachten. Welcher Wert der Feldstärke einer Amateurfunkstelle ist mit diesem Grenzwert direkt vergleichbar?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1431, 'TL218', 'Herzschrittmacher können auch durch die Aussendung einer Amateurfunkstelle beeinflusst werden. Gibt es einen zeitlichen Grenzwert für die Einwirkdauer?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1432, 'TL301', 'Unter welchen Bedingungen darf das Standrohr einer Amateurfunkantenne auf einem Gebäude mit einer vorhandenen Blitzschutzanlage verbunden werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1433, 'TL302', 'Welches Material und welcher Mindestquerschnitt ist bei einer Erdungsleitung zwischen einem Antennenstandrohr und einer Erdungsanlage nach DIN VDE 0855 Teil 300 für Funksender bis 1 kW zu verwenden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1434, 'TL303', 'Unter welchen Bedingungen darf ein Fundamenterder als Blitzschutzerder verwendet werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1435, 'TL304', 'Welche Sicherheitsmaßnahmen müssen zum Schutz gegen atmosphärische Überspannungen und zur Verhinderung von Spannungsunterschieden bei Koaxialkabel-Niederführungen ergriffen werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1436, 'TL305', 'Welche der Antworten a bis d enthält die heutzutage normgerechten Adern-Kennfarben von 3-adrigen, isolierten Energieleitungen und -kabeln in der Abfolge: Schutzleiter, Außenleiter, Neutralleiter?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1437, 'TL306', 'Damit die Zulassung eines Kraftfahrzeugs nicht ungültig wird, sind vor dem Einbau einer mobilen Sende-/Empfangseinrichtung grundsätzlich', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1438, 'TL307', 'Um ein Zusammenwirken mit der Elektronik des Kraftfahrzeugs zu verhindern, sollte das Antennenkabel', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1439, 'BA101', 'Wie soll im Telefoniefunkverkehr verhindert werden, dass ähnlich lautende Rufzeichen verwechselt oder missverstanden werden können? Dies wird verhindert durch', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1440, 'BA102', 'Wie ist das Wort "München" mit dem internationalen Buchstabieralphabet richtig zu buchstabieren?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1441, 'BA103', 'Wie ist das Wort "Travemünde" mit dem internationalen Buchstabieralphabet richtig zu buchstabieren?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1442, 'BA104', 'Wie ist das Rufzeichen DO9XYZ unter Zuhilfenahme des Internationalen Buchstabieralphabetes richtig buchstabiert?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1443, 'BA105', 'Wie ist das Rufzeichen DH8DAP unter Zuhilfenahme des Internationalen Buchstabieralphabetes richtig buchstabiert?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1444, 'BA106', 'Wie wird das Rufzeichen DL2KCI mit dem internationalen Buchstabieralphabet richtig buchstabiert?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1445, 'BA107', 'Wie ist das Rufzeichen DF3DCB mit dem internationalen Buchstabieralphabet zu buchstabieren?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1446, 'BA108', 'Wie ist das Rufzeichen "EA5/DJ4UF" mit dem internationalen Buchstabieralphabet richtig zu buchstabieren?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1447, 'BA109', 'Wie ist das Rufzeichen "PY8JW" mit dem internationalen Buchstabieralphabet richtig zu buchstabieren?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1448, 'BA110', 'Wie ist das Rufzeichen "YO9XH" mit dem internationalen Buchstabieralphabet richtig zu buchstabieren?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1449, 'BA111', 'Wie ist das Rufzeichen "HB0/DK1DN/p" mit dem internationalen Buchstabieralphabet richtig zu buchstabieren?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1450, 'BB101', 'Warum werden in Telegrafie- und Fernschreib-Betriebsarten Betriebsabkürzungen und Q-Gruppen verwendet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1451, 'BB102', 'Welche Bedeutung hat für Sie als deutsche Amateurfunkstelle auf Kurzwelle die Abkürzung "DX"?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1452, 'BB103', 'Was bedeuten die gebräuchlichen Abkürzungen "TX", "RX" in dieser Reihenfolge?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1453, 'BB104', 'Was bedeutet die Betriebsabkürzung CQ?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1454, 'BB105', 'Was bedeutet die Betriebsabkürzung CW?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1455, 'BB106', 'Sie hören KA2WEU in Morsetelegrafie rufen: „CQ DL CQ DL DE KA2WEU PSE K“. Was beabsichtigt er damit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1456, 'BB107', 'Was bedeutet die Betriebsabkürzung „R“ am Anfang eines Durchgangs?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1457, 'BB108', 'Was bedeutet die Betriebsabkürzung „K“ am Ende eines Durchgangs in Telegrafie?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1458, 'BB109', 'Was bedeutet die Betriebsabkürzung „BK“ in Telegrafie?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1459, 'BB110', 'Wie gestalten Sie als DO1LEN einen allgemeinen Anruf in Telegrafie?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1460, 'BB111', 'Was bedeutet die Betriebsabkürzung „MSG“?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1461, 'BB201', 'Warum wurden die Q-Gruppen im Funkverkehr eingeführt? Sie wurden eingeführt', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1462, 'BB202', 'Sollen Sie im Sprechfunkverkehr Abkürzungen aus den Q-Gruppen oder aus den anderen Abkürzungen im Funkverkehr verwenden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1463, 'BB203', 'Welche Bedeutung haben in der gleichen Reihenfolge gelesen die Q-Gruppen "QRV" , "QRM?" und "QTH" ?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1464, 'BB204', 'Was bedeutet es, wenn Ihr Funkpartner meldet: „QRK 1“? Er meint damit, dass', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1465, 'BB205', 'Was bedeuten die Q-Gruppen "QRT" , "QRZ?" und "QSL?" ?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1466, 'BB206', 'Welche Bedeutung haben in der gleichen Reihenfolge gelesen die Q-Gruppen "QRO?" , "QSO?" und "QRX?" ?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1467, 'BB207', 'Welche Bedeutung haben in der gleichen Reihenfolge gelesen die Q-Gruppen "QRM" , "QRN" und "QSB?" ?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1468, 'BB208', 'Wie verhalten Sie sich, wenn Sie von der Gegenstation aufgefordert werden: "pse qsy"?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1469, 'BB209', 'Wie verhalten Sie sich, wenn Sie von der Gegenstation aufgefordert werden: "pse qrp"?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1470, 'BB301', 'Was versteht man unter dem RST-Rapport? Es ist eine Kurzformel,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1471, 'BB302', 'Was bedeuten die Buchstaben RST, mit denen Sie die Sendung Ihrer Gegenstation beurteilen können?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1472, 'BB303', 'Um wie viel S-Stufen müsste die S-Meter- Anzeige Ihres Empfängers steigen, wenn Ihr Partner die Sendeleistung von 100 Watt auf 400 Watt erhöht?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1473, 'BB304', 'Wie groß ist der Unterschied zwischen S4 und S7 in Dezibel?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1474, 'BB305', 'In welcher Weise werden nach dem RST-System die Aussendungen einer Amateurfunkstelle beurteilt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1475, 'BB306', 'Um wie viel dB ist die Empfängereingangsspannung abgesunken, wenn die S-Meter- Anzeige durch Änderung der Ausbreitungsbedingungen von S9+20 dB auf S8 zurückgeht? Die Empfängereingangsspannung sinkt um', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1476, 'BB307', 'Durch "Fading" sinkt die S-Meter-Anzeige von S9 auf S8. Auf welchen Wert sinkt dabei die Empfänger-Eingangsspannung ab, wenn bei S9 am Empfängereingang 50µV anliegen? Die Empfänger-Eingangsspannung sinkt auf', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1477, 'BB308', 'Bei einer SSB-Verbindung auf VHF/UHF sagt Ihnen Ihr Gesprächspartner: "Ich empfange Sie mit R5 und 30 dB über Rauschen". Was meint er damit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1478, 'BB309', 'Sie bekommen von Ihrer Gegenstation den Rapport „4 und 8“. Was sagt Ihnen der Rapport?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1479, 'BB310', 'Eine Station kommt mit einem schwachen, störungsbehafteten Signal bei Ihnen an. Welchen Rapport geben Sie?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1480, 'BB311', 'Wie wird ein Aurora-Signal in Telegrafie beurteilt? Es wird beurteilt mit', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1481, 'BB312', 'Wie wird ein SSTV-Signal beurteilt? Es wird beurteilt mit', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1482, 'BB401', 'Wie wird "Morsetelegrafie, Zweiseitenband, ein einziger Kanal, der quantisierte oder digitale Information enthält, ohne Verwendung eines modulierten Hilfsträgers", bezeichnet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1483, 'BB402', 'Wie wird "Frequenzmodulation mit analogen Signalen, für Sprachübertragung" bezeichnet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1484, 'BB403', 'Wie wird "Einseitenbandmodulation mit analogen Signalen für Sprachübertragung" (SSB) bezeichnet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1485, 'BB404', 'Wie wird "Morsetelegrafie unter Verwendung eines modulierenden Hilfsträgers" bezeichnet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1486, 'BB405', 'Wie wird "Fernschreibtelegrafie unter Verwendung eines modulierenden Hilfsträgers" (RTTY) bezeichnet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1487, 'BB406', 'Wie wird "Fernsehen (Video), Restseitenbandübertragung mit analogen Signalen" bezeichnet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1488, 'BB407', 'Wie wird die im Amateurfunk verwendete Betriebsart "PACTOR" nach den Vorgaben der Radio Regulations (VO Funk) bezeichnet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1489, 'BC101', 'Welchen Frequenzbereich umfasst das 13-cm-Amateurfunkband in Deutschland?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1490, 'BC102', 'Welchen Frequenzbereich umfasst das 23-cm-Amateurfunkband in Deutschland?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1491, 'BC103', 'Welchen Frequenzbereich umfasst das 70-cm-Amateurfunkband in Deutschland?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1492, 'BC104', 'Welchen Frequenzbereich umfasst das 2-m-Amateurfunkband in Deutschland?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1493, 'BC105', 'Welchen Frequenzbereich umfasst das 6-m-Amateurfunkband in Deutschland?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1494, 'BC106', 'Welchen Frequenzbereich umfasst das 10-m-Amateurfunkband in Deutschland?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1495, 'BC107', 'Welchen Frequenzbereich umfasst das 12-m-Amateurfunkband in Deutschland?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1496, 'BC108', 'Welchen Frequenzbereich umfasst das 15-m-Amateurfunkband in Deutschland?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1497, 'BC109', 'Welchen Frequenzbereich umfasst das 17-m-Amateurfunkband in Deutschland?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1498, 'BC110', 'Welchen Frequenzbereich umfasst das 20-m-Amateurfunkband in Deutschland?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1499, 'BC111', 'Welchen Frequenzbereich umfasst das 30-m-Amateurfunkband in Deutschland?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1500, 'BC112', 'Welchen Frequenzbereich umfasst das 40-m-Amateurfunkband in Deutschland?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1501, 'BC113', 'Welchen Frequenzbereich umfasst das 80-m-Amateurfunkband in Deutschland?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1502, 'BC114', 'Welchen Frequenzbereich umfasst das 160-m-Amateurfunkband in Deutschland?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1503, 'BC201', 'Welchen Verbindlichkeitsgrad haben die von der IARU (Internationale Amateur Radio Union) aufgestellten Bandpläne?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1504, 'BC202', 'Dürfen Sie im Bereich 145,800 - 146,000 MHz lokalen Funkverkehr abwickeln?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1505, 'BC203', 'Auf welcher Frequenz würden Sie im 2-Meter-Band ein Telefonie QSO führen und zwar 1. in SSB und 2. in FM?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1506, 'BC204', 'Sie rufen auf der Frequenz 144,300 MHz CQ und erhalten einen Anruf. Was tun Sie als nächstes?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1507, 'BC205', 'Welches ist die internationale Anruffrequenz für SSB im 2-m-Band?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1508, 'BC206', 'Sie hören eine französische Station auf 10,143 MHz in SSB CQ rufen. Dürfen Sie in SSB antworten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1509, 'BC207', 'Sie möchten im 2-m-Band ein SSB-QSO führen. Wie verhalten Sie sich?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1510, 'BC208', 'Ist die Annahme richtig, dass man in den Satellitenbereichen z.B. des 2-m- oder 70- cm-Bandes mit einem Handfunkgerät lokalen Funkverkehr in F3E (FM) abwickeln kann, weil die Reichweite zu gering ist, einen Satelliten zu stören?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1511, 'BC209', 'Welches Seitenband wird bei SSB-Betrieb im 80-m-Band in der Regel benutzt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1512, 'BC210', 'Welches Seitenband wird bei SSB-Betrieb im 20-m-Band in der Regel benutzt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1513, 'BC211', 'Welche nachstehend aufgeführten Frequenzbereiche des 80-m- und des 15-m- Bandes sollen auf Empfehlung der Internationalen Amateur Radio Union bevorzugt nur für Morsetelegrafie genutzt werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1514, 'BC212', 'Welcher Frequenzbereich soll im 20-m-Band auf Empfehlung der Internationalen Amateur Radio Union bevorzugt für SSB genutzt werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1515, 'BC213', 'Wie gehen Sie vor, wenn Sie auf Kurzwelle Funkbetrieb in einer neuen digitalen Betriebsart machen wollen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1516, 'BC214', 'Aus welchem Grund sollten Sie in der Dunkelheit und im Winter auch tagsüber im Bereich von 3500-3510 kHz keine innerdeutschen oder innereuropäischen Telegrafie- QSOs durchführen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1517, 'BC215', 'Aus welchem Grund sollten Sie in der Dunkelheit und im Winter auch tagsüber im Bereich von 3775-3800 kHz keine innerdeutschen oder innereuropäischen SSB-QSOs durchführen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1518, 'BC216', 'Welche Bereiche des 10-m- und des 40-m- Bandes stehen nach den Empfehlungen der International Amateur Radio Union ausschließlich für die Betriebsart Telegrafie zur Verfügung?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1519, 'BC217', 'Welche Bereiche des 15-m-, des 20-m- und des 80-m-Bandes stehen nach den Empfehlungen der International Amateur Radio Union ausschließlich für die Betriebsart Telegrafie zur Verfügung?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1520, 'BC218', 'In welchen Bereichen des 2-m- und 70-cm- Bandes arbeiten Amateurfunksatelliten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1521, 'BC219', 'In welchem Bereich des 2-m-Bandes dürfen Sie keinen Sendebetrieb machen, weil dort Funkbaken senden? Es ist der Frequenzbereich', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1522, 'BC220', 'Welche Frequenzen sind wegen des Betriebs der Funkbaken des internationalen Bakenprojektes (IBP) freizuhalten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1523, 'BD101', 'Was erkennen Sie aus dem Rufzeichen DO9RST/MM?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1524, 'BD102', 'Was erkennen Sie aus dem Rufzeichen DA5XX?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1525, 'BD103', 'Was erkennen Sie aus dem Rufzeichen DAØXX?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1526, 'BD104', 'Was erkennen Sie aus dem Rufzeichen DPØXX?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1527, 'BD105', 'Was erkennen Sie aus dem Rufzeichen DP1XX?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1528, 'BD106', 'Was bedeuten die Rufzeichenzusätze "/p" und "/m" bei einer Amateurfunkstelle?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1529, 'BD107', 'In welcher Form muss ein Funkamateur aus einem Land, das die CEPT-Empfehlung T/R 61-01 anwendet, sein Heimatrufzeichen beim Betrieb einer Amateurfunkstelle in Deutschland ergänzen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1530, 'BD108', 'In welcher Form muss ein Funkamateur aus einem Land, das die ECC-Empfehlung (05)06 anwendet, sein Heimatrufzeichen beim Betrieb einer Amateurfunkstelle in Deutschland ergänzen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1531, 'BD109', 'Muss beim Betrieb einer tragbaren oder vorübergehend ortsfest betriebenen Amateurfunkstelle in Deutschland dem Rufzeichen der Zusatz "/p" hinzugefügt werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1532, 'BD110', 'Was bedeutet der Rufzeichenzusatz "/am"?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1533, 'BD111', 'Ein Rufzeichen mit dem Zusatz "/m" kann bei einer Amateurfunkstelle bedeuten,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1534, 'BD112', 'Zu welcher Rufzeichenart gehören Rufzeichen mit dem Präfix DN1 bis DN8 und zwei bis drei Buchstaben im Suffix?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1535, 'BD113', 'Rufzeichen, die mit DFØ, DKØ oder DLØ beginnen, sind zumeist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1536, 'BD114', 'Zu welcher Rufzeichenart und Klasse gehören Rufzeichen, die mit DO1 bis DO9 beginnen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1537, 'BD115', 'Woraus setzen sich die personengebundenen Rufzeichen deutscher Funkamateure zusammen? Sie setzen sich zusammen aus', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1538, 'BD201', 'Wo können Sie nachschlagen, in welchem Land sich eine Amateurfunkstelle mit einem Ihnen bislang unbekannten Landeskenner befindet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1539, 'BD202', 'Welche Antwort enthält nur Landeskenner von Ländern, die an die Bundesrepublik Deutschland grenzen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1540, 'BD203', 'Welche Gruppe gibt die Landeskenner der Länder Rumänien, Bulgarien, Spanien, Norwegen, Polen für ihre Amateurfunkstellen richtig wieder?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1541, 'BD204', 'Welche Länder sind der Reihe nach den folgenden Ländern zugeordnet? Die Landeskenner OE, PA, HBØ, YL, LX entsprechen den Ländern', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1542, 'BD205', 'Welche Länder (Gebiete) sind der Reihe nach den folgenden Landeskennern zugeordnet? Die Landeskenner 3A, 4U, 9A, 9H entsprechen den Ländern (Gebieten)', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1543, 'BD206', 'Welche Länder sind der Reihe nach den folgenden Landeskennern zugeordnet? Die Landeskenner OE, OH, OK, OM, ON, OZ entsprechen den Ländern', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1544, 'BD207', 'Welche Länder sind der Reihe nach den folgenden Landeskennern zugeordnet? Die Landeskenner LA, LY, LZ, YL entsprechen den Ländern', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1545, 'BD208', 'Welche Länder sind der Reihe nach den folgenden Landeskennern zugeordnet? Die Landeskenner SM, S5, SP, SV entsprechen den Ländern', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1546, 'BD209', 'Welche Länder sind der Reihe nach den folgenden Landeskennern zugeordnet? Die Landeskenner EA, EI, EM, ES entsprechen den Ländern', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1547, 'BD210', 'Welche Gruppe gibt die Landeskennern der Länder Portugal, Schweiz, Spanien, Belgien, Polen und Irland für ihre Amateurfunkstellen richtig wieder?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1548, 'BD301', 'Welchem Land bzw. welchen Ländern sind die Landeskenner DA bis DZ zugeordnet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1549, 'BD302', 'Welche Gruppe gibt Landeskenner der Länder USA, Syrien, Südafrika, Neuseeland, Argentinien und Chile für ihre Amateurfunkstellen richtig wieder?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1550, 'BD303', 'Welche Gruppe gibt Landeskenner der Länder China, Japan, Kanada, Australien, Mexiko und USA für ihre Amateurfunkstellen richtig wieder?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1551, 'BD304', 'Welche fünf Landeskenner sind einem einzigen Kontinent zuzuordnen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1552, 'BD305', 'Welche Landeskenner sind afrikanischen Ländern zugewiesen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1553, 'BD306', 'Welche Landeskenner sind südamerikanischen Ländern zugewiesen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1554, 'BD307', 'Welche Bedeutung hat das Rufzeichen VE8ZZ/AM?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1555, 'BD308', 'Welche Länder sind der Reihe nach den folgenden Landeskennern zugeordnet? Die Landeskenner VE, VK, PY, JA, W entsprechen den Ländern', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1556, 'BD309', 'In welcher Zeile stehen nur Rufzeichen aus den Vereinigten Staaten von Amerika (USA)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1557, 'BE101', 'Wie würden Sie antworten, wenn jemand "CQ" ruft?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1558, 'BE102', 'Ein Funkamateur möchte eine verschlüsselte Nachricht an seinen Funkfreund senden. In welcher Sprache ist dies statthaft?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1559, 'BE103', 'Auf welche Arten können Sie eine Amateurfunkverbindung zum Beispiel beginnen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1560, 'BE104', 'Die deutsche Amateurfunkstelle DC8WV ruft auf dem 80-m-Band oberhalb 3700 kHz in Morsetelegrafie "CQ de DC8WV pse k". Dürfen Sie auf diesen allgemeinen Anruf auch in der Betriebsart SSB-Telefonie antworten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1561, 'BE105', 'Sollten Sie einen allgemeinen Anruf mit QRZ beginnen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1562, 'BE106', 'Wie gestalten Sie Ihren allgemeinen Anruf in Telefonie, wenn Sie eine Verbindung mit einer australischen Amateurfunkstelle suchen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1563, 'BE107', 'Sie hören DH8DAP/p in Morsetelegrafie rufen: "CQ FD CQ FD de DH8DAP/p". Was bedeutet das?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1564, 'BE108', 'Sie hören KA2WEU in Morsetelegrafie rufen: "CQ DL CQ DL de KA2WEU pse k". Was beabsichtigt KA2WEU mit diesem Anruf?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1565, 'BE109', 'Ihr Rufzeichen sei DH7RW. Sie hören in Telefonie unvollständig "... 7 Romeo Whiskey". Wie reagieren Sie?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1566, 'BE110', 'Sie hören 4U1ITU in Telefonie rufen: "CQ VK/ZL this is 4U1ITU". Sollten Sie 4U1ITU anrufen, wenn Sie gerne ein QSO mit ihm führen würden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1567, 'BE111', 'Was bedeutet der im 20-m-Band gesendete Anruf "CQ CQ CQ DX de HB9AFN"?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1568, 'BE112', 'Was ist beim Morsetelegrafie-Funkverkehr mit einem offensichtlichen Anfänger zu beachten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1569, 'BE113', 'Eine Station ruft auf VHF/UHF "CQ" mit dem Zusatz "DX". Wann sollten Sie antworten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1570, 'BE114', 'Sie haben eine Funkverbindung mit einer vorher "CQ" rufenden Station beendet. Anschließend werden Sie von einer anderen Station gerufen. Wie verhalten Sie sich?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1571, 'BE115', 'Sie möchten im 20-m-Band einen allgemeinen Anruf starten. Sie finden eine Frequenz die offensichtlich nicht belegt ist. Wie gehen Sie vor?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1572, 'BE116', 'Warum erscheint Ihnen auf den höheren Frequenzbändern der Kurzwelle eine Frequenz als frei, obwohl sie sich anschließend als besetzt herausstellt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1573, 'BE117', 'Welche Betriebsbedingungen sollten Sie für die Teilnahme an einem internationalen KW-Wettbewerb unbedingt einhalten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1574, 'BE118', 'EA3JQ ruft in englischer Sprache CQ. Wie gestalten Sie Ihren Anruf, wenn Sie mit ihm ein QSO führen möchten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1575, 'BE119', 'Mit welcher Tastgeschwindigkeit würden Sie einen CQ-Ruf in Telegrafie beantworten? Ich würde', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1576, 'BE201', 'Was verstehen Sie unter dem Begriff "DX-Pedition"? Es ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1577, 'BE202', 'Was ist mit dem Begriff "pile up" gemeint? Man meint damit das gleichzeitige', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1578, 'BE203', 'Was verstehen Sie bei einer seltenen Station unter der Aufforderung zu "Listenbetrieb"?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1579, 'BE204', 'Was ist gemeint, wenn die Gegenstation sagt: "split up 14250 to 14280"?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1580, 'BE205', 'Eine "seltene" Station, die auf 14205 kHz "CQ" gerufen hat, sagt am Ende ihres CQRufes "tuning 290-300 up". Was tun Sie, wenn Sie diese Station anrufen wollen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1581, 'BE206', 'Eine Station gibt am Ende ihres CQ-Rufes "5 up". Was bedeutet diese Angabe und was ist zu beachten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1582, 'BE207', 'Eine seltene Station ruft in SSB "only number 3, only suffix". Was ist damit gemeint?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1583, 'BE208', 'Was versteht man unter "Split-Verkehr"?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1584, 'BE209', 'Was bedeutet die Aussage, dass ein Funkamateur in Deutschland mit "VK" auf dem "langen Weg" gearbeitet hat?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1585, 'BE210', 'Was meint ein Funkamateur damit, wenn er angibt, dass er auf dem 2-m-Band eine Aurora- Verbindung mit Schottland gehabt hat?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1586, 'BE211', 'Was meint ein Funkamateur damit, wenn er angibt, dass auf dem 2-m-Band „Sporadic-E-Bedingungen“ herrschen? Er meint damit, dass derzeit', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1587, 'BE212', 'Woran können Sie als Funkamateur eine Aurora-Verbindung erkennen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1588, 'BE213', 'Wie erkennt ein Funkamateur in der Regel, dass er mit "PY" auf dem "indirekten" und somit längeren Weg gearbeitet hat?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1589, 'BE214', 'Was versteht man unter dem von Funkamateuren benutzten „Locator“ (Standortkenner)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1590, 'BE215', 'Was verstehen Funkamateure unter einer "Fuchsjagd" (ARDF = Amateur Radio Direction Finding)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1591, 'BE216', 'Was versteht man im Amateurfunk unter „Ham-Spirit"?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1592, 'BE301', 'Welche Betriebsarten sind für QRP-DX-Betrieb auf Kurzwelle am besten geeignet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1593, 'BE302', 'Welche Betriebsarten sind für QRP-DX-Betrieb auf Kurzwelle am besten geeignet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1594, 'BE303', 'Wie teilen Sie Ihrem Funkpartner in der Betriebsart SSTV seinen „Rapport“ mit?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1595, 'BE304', 'Was ist mit dem Begriff "monitoring" in Packet Radio (PR) gemeint?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1596, 'BE305', 'Wozu dient ein "Auto-Router" im Packet- Radio-Betrieb?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1597, 'BE306', 'Was versteht man unter "Forwarding" im Packet-Radio-Betrieb?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1598, 'BE307', 'Warum soll das "TX-Delay" beim Packet- Radio-Betrieb so kurz wie möglich eingestellt sein?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1599, 'BE308', 'Was versteht man unter APRS im Amateurfunk?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1600, 'BE309', 'Was sind "Linkstrecken" und wozu dienen sie?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1601, 'BE310', 'Was ist Simplexbetrieb?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1602, 'BE401', 'Was ist damit gemeint, wenn man sagt, die Relaisfunkstelle hat eine Eingabe- und eine Ausgabefrequenz? Die Relaisfunkstelle', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1603, 'BE402', 'Wie wird eine Funkverbindung beurteilt, wenn über eine F3E-Relaisfunkstelle gearbeitet wird?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1604, 'BE403', 'Geben Sie die richtige Weiterführung an: Eine Amateurfunkbake ist eine Amateurfunkstelle', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1605, 'BE404', 'Warum sollten bei Relaisfunkbetrieb die Durchgänge möglichst kurz gehalten werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1606, 'BE405', 'Bei deutschen 2-m-Relaisfunkstellen liegt die Ausgabefrequenz üblicherweise', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1607, 'BE406', 'Bei deutschen 70-cm-Relaisfunkstellen liegt die Ausgabefrequenz üblicherweise', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1608, 'BE407', 'Was versteht man unter dem Transponder eines "OSCAR" und wie arbeitet er?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1609, 'BE408', 'Was versteht man unter einem "Transponderfahrplan"?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1610, 'BE409', 'Weshalb sind die Frequenzen 14099-14101, 18109-18111, 21149-21151, 24929-24931 und 28190-28225 kHz freizuhalten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1611, 'BE410', 'Welche Gruppe enthält die richtig dargestellte Bedeutung der nachfolgend genannten Begriffe in der richtigen Reihenfolge? 1) Repeater, 2) Digipeater, 3) Mailbox', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1612, 'BE411', 'Die Begriffe 1) OSCAR, 2) Uplink, 3) Downlink, 4) Azimut/Elevation bedeuten in der angegebenen Reihenfolge:', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1613, 'BF101', 'Das 80-m-Amateurfunkband ist unter anderem dem Amateurfunkdienst und dem Seefunkdienst auf primärer Basis zugewiesen. Unter welchen Umständen dürfen Sie in einer Amateurfunkverbindung fortfahren, wenn Sie erst nach Betriebsaufnahme bemerken, dass Ihre benutzte Frequenz auch von einer Küstenfunkstelle benutzt wird?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1614, 'BF102', 'Wie heißt das internationale Notzeichen im Sprechfunk?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1615, 'BF103', 'Welche Notzeichen werden in der Telefonie verwendet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1616, 'BF104', 'Dürfen Sie im Notfall eines der Notzeichen SOS oder Mayday gebrauchen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1617, 'BF105', 'Sie haben am 16. August (Ortsdatum) um 20:00 Uhr mitteleuropäischer Sommerzeit (MESZ) von 9J2NG eine Notfunkmeldung aufgenommen und an eine Hilfeleistungsorganisation per Telefon weitergemeldet. Die Amateurfunkstelle 9J2NG hat Sie gebeten, um 23:00 Uhr UTC erneut mit ihr in Verbindung zu treten. Welcher Zeitpunkt ist dies in Deutschland?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1618, 'BF106', 'Sie haben auf einer Amateurfunkfrequenz eine Notmeldung von einem Schiff in Seenot empfangen. Wie verhalten Sie sich?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1619, 'BF107', 'Sie empfangen einen Notruf einer havarierten privaten Segelyacht auf 14320 kHz. Wie verhalten Sie sich?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1620, 'BF108', 'Sie haben auf der Ausgabefrequenz einer Relaisfunkstelle eine Notmeldung von einem Fahrzeug empfangen. Wie verhalten Sie sich?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1621, 'BF109', 'In den Bandplan-Empfehlungen der IARU sind so genannte Aktivitätszentren für den Notfunkverkehr innerhalb der IARU-Region 1 eingerichtet worden. Bei welchen Frequenzen liegen diese Zentren?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1622, 'BF110', 'Nach den Empfehlungen der International Amateur Radio Union gibt es bei 14300, 18160 und 21360 kHz so genannte Aktivitätszentren für Notfunkverkehr. Was ist das besondere an diesen Frequenzen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1623, 'BG101', 'Welche Uhrzeit tragen Sie in die QSL Karte an XE2AS ein, mit dem Sie um 13:30 MESZ eine Funkverbindung hatten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1624, 'BG102', 'Was sollten sie bei der Eintragung der Uhrzeit in das Funktagebuch beachten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1625, 'BG103', 'Was verstehen Funkamateure unter einem Logbuch (logbook)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1626, 'BG104', 'In welchen Fällen muss ein Stationstagebuch geführt werden? Es muss geführt werden', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1627, 'BG105', 'Welche Uhrzeit tragen Sie in die QSL-Karte an die Funkstation DH4KYL ein, mit der Sie um 15:30 MEZ ein QSO hatten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1628, 'BG106', 'Was wird im Amateurfunk unter "SASE" verstanden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1629, 'BG107', 'Was wird im Amateurfunk unter "IRC" verstanden? IRC ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1630, 'BG108', 'Was ist bei der Erstellung eines "Computer-Logbuchs" bei angeordneter Logbuchführung zu beachten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1631, 'BG109', 'Was ist bei angeordneter Logbuchführung bei einem Wechsel der "Logbuchsoftware" zu berücksichtigen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1632, 'BG110', 'Welches ist der Sinn der QSL-Karte und wozu kann sie dienen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1633, 'BG111', 'Welche Angaben sollten QSL-Karten mindestens enthalten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1634, 'BG112', 'HZ1AB sagte Ihnen "QSL via K8PYD". Was würden Sie tun, um die QSL-Karte von HZ1AB zu erhalten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1635, 'BG113', 'Was können Sie tun, wenn Sie von einer seltenen DX-Station möglichst schnell eine QSL-Karte erhalten möchten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1636, 'BG114', 'Was sollten Sie bei der Eintragung von Uhrzeiten in Stationstagebuch und QSL-Karten beachten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1637, 'BG115', 'Wo können Sie die Anschriften von ausländischen Funkamateuren finden, denen Sie die QSL-Karte direkt zusenden möchten? Ich finde diese', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1638, 'VA101', 'In welchem zum Internationalen Fernmeldevertrag gehörenden Regelungswerk ist der Begriff "Amateurfunkdienst" definiert?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1639, 'VA102', 'Wozu dient der Amateurfunkdienst nach dem Wortlaut seiner internationalen Begriffsbestimmung in den Radio Regulations (VO Funk)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1640, 'VA103', 'Wozu dient der Amateurfunkdienst über Satelliten nach dem Wortlaut seiner internationalen Begriffsbestimmung in den Radio Regulations (VO Funk)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1641, 'VA104', 'Welche Aussage über Funkamateure enthält die Begriffsbestimmung des Amateurfunkdienstes in den Radio Regulations (VO Funk)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1642, 'VA201', 'Wie ist die Amateurfunkstelle in den Radio Regulations (VO Funk) definiert?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1643, 'VA202', 'Wie ist die Funkstelle in den Radio Regulations (VO Funk) definiert?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1644, 'VA203', 'Was ist eine Amateurfunkstelle im Sinne der Radio Regulations (VO Funk)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1645, 'VA204', 'Bei welcher der genannten Einrichtungen handelt es sich um keine Amateurfunkstelle nach der Definition der Radio Regulations (VO Funk) und des AFuG?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1646, 'VA205', 'Bei welcher der genannten Einrichtungen handelt es sich um eine Amateurfunkstelle nach der Definition der Radio Regulations (VO Funk) und des AFuG?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1647, 'VA301', 'Was ist in den Radio Regulations (VO Funk) bezüglich der Morsequalifikation für Funkamateure festgelegt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1648, 'VA302', 'Was ist in den Radio Regulations (VO Funk) hinsichtlich dem Amateurfunkverkehr festgelegt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1649, 'VA303', 'Gelten die allgemeinen Regelungen der Radio Regulations (VO Funk) auch für den Amateurfunkdienst?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1650, 'VA304', 'Was gilt hinsichtlich der Anwendung von Kodes und Verschlüsselungen im internationalen Amateurfunkverkehr zwischen Funkamateuren?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1651, 'VA401', 'Nach den Radio Regulations (VO Funk) ist die Erde in verschiedene Funkregionen unterteilt. Wie viele Funkregionen gibt es und zu welcher davon gehört Deutschland?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1652, 'VA402', 'Nach den Radio Regulations (VO Funk) ist die Erde in verschiedene Funkregionen unterteilt. Wie viele Funkregionen gibt es und zu welcher davon gehört Kanada?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1653, 'VA403', 'Nach den Radio Regulations (VO Funk) ist die Erde in verschiedene Funkregionen unterteilt. Wie viele Funkregionen gibt es und zu welcher davon gehört Australien?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1654, 'VA404', 'Weshalb wird in den Radio Regulations (VO Funk) die Erde in verschiedene Funkregionen eingeteilt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1655, 'VA405', 'Was enthält der "Internationale Frequenzbereichszuweisungsplan"?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1656, 'VA406', 'In welchem Regelungswerk ist die Bedeutung der "Q-Gruppen" festgelegt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1657, 'VA407', 'Was bedeuten im Funk die Zeichen "SOS" und "MAYDAY"?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1658, 'VA408', 'Wo sind die Amateurfunkrufzeichen international geregelt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1659, 'VA409', 'Darf ein Funkamateur in Deutschland alle in den Radio Regulations (VO Funk) für den Amateurfunkdienst zugewiesenen Frequenzbereiche benutzen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1660, 'VB101', 'Welche Bedeutung haben die CEPT-Empfehlungen T/R 61-01 und 05(06) für den Amateurfunkdienst?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1661, 'VB102', 'Was beinhalten die CEPT-Empfehlungen T/R 61-01 und (05)06?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1662, 'VB103', 'Die deutsche Amateurfunkzulassung der Klasse A entspricht der', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1663, 'VB104', 'Die deutsche Amateurfunkzulassung der Klasse E entspricht der', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1664, 'VB105', 'Mit einer gültigen deutschen Amateurfunkzulassung der Klasse A, die als „CEPT-Amateurfunkgenehmigung“ gekennzeichnet ist, dürfen die Betriebsrechte der entsprechenden ausländischen Genehmigung im jeweiligen Beitrittsland gemäß der CEPT-Empfehlung T/R 61-01 wahrgenommen werden,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1665, 'VB106', 'Mit einer gültigen deutschen Amateurfunkzulassung der Klasse E, die als „CEPT-Novice- Amateurfunkgenehmigung“ gekennzeichnet ist, dürfen die Betriebsrechte der entsprechenden ausländischen Genehmigung im jeweiligen Beitrittsland gemäß der ECC-Empfehlung (05)06 wahrgenommen werden,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1666, 'VB107', 'Wie lange darf ein Funkamateur im Rahmen einer der CEPT-Empfehlungen T/R 61-01 oder (05)06 Amateurfunkverkehr in einem Land durchführen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1667, 'VB108', 'Wie muss die Rufzeichennennung von DO1XYZ bei der Nutzung der CEPT-Novice- Amateurfunkgenehmigung in der Schweiz erfolgen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1668, 'VB109', 'Wie muss die Rufzeichennennung von DL1ER bei der Nutzung der CEPT-Amateurfunkgenehmigung in der Schweiz erfolgen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1669, 'VB110', 'Sie hören die Amateurfunkstation mit dem Rufzeichen DL/G3MM. Welcher der nachfolgenden Sachverhalte trifft zu?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1670, 'VB111', 'Darf ein Funkamateur mit einer CEPT-Amateurfunkgenehmigung in allen CEPT-Ländern Amateurfunkverkehr abwickeln?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1671, 'VB112', 'Darf ein Funkamateur mit einer CEPT-Novice- Amateurfunkgenehmigung in allen CEPT-Ländern Amateurfunkverkehr abwickeln?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1672, 'VB113', 'Wo sind die Informationen und Bedingungen für die Ausstellung und die Nutzung der CEPT-Amateurfunkgenehmigung zu finden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1673, 'VB114', 'Wo sind die Informationen und Bedingungen für die Ausstellung und die Nutzung der CEPT-Novice-Amateurfunkgenehmigung zu finden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1674, 'VB115', 'Aufgrund welcher Regelungen dürfen Funkamateure aus bestimmten Ländern ohne individuelle Gastzulassung vorübergehend in Deutschland Amateurfunk ausüben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1675, 'VB116', 'Entsprechend welcher internationalen Regelungen dürfen Inhaber eines deutschen Amateurfunkrufzeichens auch in anderen Ländern vorübergehend am Amateurfunkverkehr teilnehmen, ohne dass sie dort vorher eine besondere Zulassung beantragen müssen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1676, 'VB117', 'Welche der folgenden Aussagen ist richtig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1677, 'VB118', 'Welche Regelungen sind beim Betrieb einer Amateurfunkstelle in einem ausländischen Land zu beachten, das die CEPT-Empfehlungen T/R 61-01 und (05)06 umgesetzt hat?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1678, 'VB119', 'Darf ein Funkamateur mit einer gültigen deutschen Amateurfunkzulassung der Klasse A auch im Gastland Amateurfunkverkehr auf dem 6-m-Band durchführen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1679, 'VB120', 'Ist der vorübergehende Betrieb einer Klubstation nach CEPT-Empfehlung T/R 61-01 in einem Land erlaubt, welches diese Empfehlung anwendet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1680, 'VB121', 'Was hat ein Funkamateur zu veranlassen, wenn er eine Amateurfunkstelle anlässlich einer Urlaubsreise in einem Land betreiben will, das die in seiner Amateurfunkzulassung eingetragene CEPT-Empfehlung nicht anwendet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1681, 'VB122', 'Was ist eine HAREC?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1682, 'VB123', 'Wozu dient eine HAREC?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1683, 'VB124', 'Die CEPT-Empfehlung T/R 61-02 beinhaltet Regelungen für', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1684, 'VB125', 'Welche der folgenden Aussagen ist richtig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1685, 'VC101', 'Welches Gesetz bildet die Rechtsgrundlage für den Amateurfunkdienst in Deutschland?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1686, 'VC102', 'Welches Gesetz regelt die Voraussetzungen und die Bedingungen für die Teilnahme am Amateurfunkdienst?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1687, 'VC103', 'Welche Behörde nimmt die Aufgaben und Befugnisse in Deutschland wahr, die sich aus dem Amateurfunkgesetz (AFuG) und der Amateurfunkverordnung (AFuV) ergeben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1688, 'VC104', 'Wie ist der Begriff "Funkamateur" nach dem AFuG zu verstehen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1689, 'VC105', 'Nach dem Amateurfunkgesetz ist ein Funkamateur der Inhaber eines Amateurfunkzeugnisses oder einer harmonisierten Prüfungsbescheinigung der sich', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1690, 'VC106', 'Nach dem Amateurfunkgesetz ist eine Amateurfunkstelle eine Funkstelle,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1691, 'VC107', 'Mit welchen anderen Funkstellen darf der Funkamateur Funkverkehr abwickeln?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1692, 'VC108', 'Darf der Funkamateur mit anderen Funkstellen, die keine Amateurfunkstellen sind, Funkverkehr abwickeln?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1693, 'VC109', 'Dürfen Sie mit Ihrem Amateurfunktransceiver im 70-cm-Band am LPD-Funkverkehr (LPD = Low Power Devices) teilnehmen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1694, 'VC110', 'Darf ein Funkamateur Nachrichten, die nicht den Amateurfunkdienst betreffen, für und an Dritte übermitteln?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1695, 'VC111', 'Der Amateurfunkdienst ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1696, 'VC112', 'Wozu dient der Amateurfunkdienst nach dem AFuG?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1697, 'VC113', 'Welchen Zwecken dient der Amateurfunkdienst nach dem AFuG?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1698, 'VC114', 'Welchen Zwecken dient der Amateurfunkdienst nach dem AFuG?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1699, 'VC115', 'Welches der nachfolgend genannten Dokumente benötigt man, um ein Funkamateur im Sinne des AFuG zu sein?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1700, 'VC116', 'Was ist neben einer erfolgreich abgelegten Amateurfunkprüfung unbedingt erforderlich, damit Sie eine Amateurfunkstelle betreiben dürfen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1701, 'VC117', 'Was ist erforderlich, um den Amateurfunkbetrieb ausüben zu dürfen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1702, 'VC118', 'Ab wann dürfen Sie eine Amateurfunkstelle betreiben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1703, 'VC119', 'Ist die Erteilung einer Amateurfunkzulassung von einem Mindestalter abhängig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1704, 'VC120', 'Welche Rufzeichenzuteilungsarten gibt es im Amateurfunk?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1705, 'VC121', 'Unter welchen Voraussetzungen darf ein Funkamateur eine Amateurfunkstelle als Relaisfunkstelle betreiben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1706, 'VC122', 'Unter welchen Voraussetzungen darf ein Funkamateur Ausbildungsfunkbetrieb durchführen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1707, 'VC123', 'Unter welchen Voraussetzungen darf ein Funkamateur eine Amateurfunkstelle als Klubstation betreiben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1708, 'VC124', 'Darf ein Funkamateur seine Amateurfunkzulassung oder das damit zugeteilte Rufzeichen unter besonderen Umständen vorübergehend einer anderen Person übertragen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1709, 'VC125', 'Kann ein zugeteiltes Rufzeichen durch die Bundesnetzagentur geändert werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1710, 'VC126', 'Darf die Amateurfunkstelle zu gewerblich-wirtschaftlichen Zwecken in kleinem Rahmen mitbenutzt werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1711, 'VC127', 'Welche der nachfolgenden Aussagen ist zutreffend?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1712, 'VC128', 'Welche der nachfolgenden Aussagen ist zutreffend?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1713, 'VC129', 'Welche der nachfolgenden Aussagen ist zutreffend?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1714, 'VC130', 'Welche der nachfolgenden Aussagen ist zutreffend?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1715, 'VC131', 'Welche der nachfolgenden Aussagen ist zutreffend?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1716, 'VC132', 'Welche der nachfolgenden Aussagen ist zutreffend?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1717, 'VC133', 'Welche der nachfolgenden Aussagen ist zutreffend?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1718, 'VC134', 'Welche der nachfolgenden Aussagen ist zutreffend?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1719, 'VC135', 'Welche der nachfolgenden Aussagen ist zutreffend?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1720, 'VC136', 'Aus welcher Vorschrift ergibt sich die Pflicht, die Einhaltung der Personenschutzgrenzwerte zu dokumentieren?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1721, 'VC137', 'Kann der Funkamateur eine Standortbescheinigung erhalten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1722, 'VC138', 'Die Bundesnetzagentur kann bei Verstößen gegen AFuG oder AFuV', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1723, 'VC139', 'Was hat ein Funkamateur zu erwarten, der seine Amateurfunkstelle entgegen den Bestimmungen über den Amateurfunkdienst betreibt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1724, 'VC140', 'Unter welchen Voraussetzungen kann einem Funkamateur die Zulassung zur Teilnahme am Amateurfunkdienst widerrufen werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1725, 'VC141', 'Was hat ein Funkamateur mit zugeteiltem Rufzeichen zu erwarten, wenn er fortgesetzt gegen AFuG oder AFuV verstößt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1726, 'VC142', 'Wann handelt ein Funkamateur ordnungswidrig im Sinne des Amateurfunkgesetzes?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1727, 'VC143', 'Welche der nachfolgenden Handlungen stellt eine Ordnungswidrigkeit im Sinne des Amateurfunkgesetzes dar?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1728, 'VC144', 'Welche der nachfolgenden Handlungen stellt eine Ordnungswidrigkeit im Sinne des Amateurfunkgesetzes dar?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1729, 'VC145', 'Ein Funkamateur übermittelt unter Benutzung seiner Amateurfunkstelle rechtswidrig Nachrichten an Dritte. Wie hoch kann das Bußgeld für diese Ordnungswidrigkeit sein?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1730, 'VC146', 'Was hat ein Funkamateur zu erwarten, der seine Amateurfunkstelle entgegen den Bestimmungen über den Amateurfunkdienst betreibt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1731, 'VD101', 'Welche der folgenden Begriffsbestimmungen ist gemäß AFuV richtig wiedergegeben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1732, 'VD102', 'Welche der folgenden Begriffsbestimmungen ist entsprechend der AFuV richtig wiedergegeben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1733, 'VD103', 'Welche der folgenden Begriffsbestimmungen ist entsprechend der AFuV richtig wiedergegeben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1734, 'VD104', 'Wo sind die Nutzungsbestimmungen, die maximal zulässigen Sender- bzw. Strahlungsleistungen und die erlaubten Frequenzbereiche für den Amateurfunkdienst und den Amateurfunkdienst über Satelliten zu finden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1735, 'VD105', 'Welche der genannten Bestimmungen enthält Regelungen darüber, welche Frequenzbereiche der Inhaber einer Amateurfunkzulassung entsprechend seiner Zeugnisklasse benutzen darf?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1736, 'VD106', 'Wo ist die Einteilung der deutschen Amateurfunkrufzeichen geregelt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1737, 'VD107', 'Hat ein Funkamateur Anspruch auf Zuteilung eines bestimmten Rufzeichens?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1738, 'VD108', 'Wann und wie oft hat der Funkamateur sein Rufzeichen zu nennen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1739, 'VD109', 'Welche Pflichten hat der Inhaber einer Amateurfunkzulassung im Fall der Änderung seiner Anschrift oder bei der Neuerrichtung einer ortsfesten Amateurfunkstelle?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1740, 'VD110', 'Was muss der Inhaber einer Amateurfunkzulassung bei der Änderung seines Namens oder seiner Anschrift veranlassen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1741, 'VD111', 'Ein Funkamateur verzichtet auf seine Zulassung und damit auf die Zuteilung seines personengebundenen Rufzeichens. Kann er damit rechnen, dass er auf Antrag dieses Rufzeichen nach 2 Jahren erneut zugeteilt bekommt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1742, 'VD112', 'Was gilt in Bezug auf den Empfang von Amateurfunkaussendungen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1743, 'VD113', 'Zu welchen Zwecken kann die Bundesnetzagentur schriftliche Nachweise über den Funkbetrieb verlangen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1744, 'VD114', 'Dürfen im Amateurfunkverkehr internationale Not-, Dringlichkeits- und Sicherheitszeichen (z. B. SOS, MAYDAY) ausgesendet werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1745, 'VD115', 'Darf ein Funkamateur verdeckte bzw. geheime Nachrichten an seinen Funkfreund senden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1746, 'VD116', 'Offene Sprache im Funkverkehr bedeutet, dass der Funkverkehr', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1747, 'VD117', 'Welche der folgenden Aussagen ist richtig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1748, 'VD118', 'Welche technischen Anforderungen stellt die Amateurfunkverordnung u. a. an eine Amateurfunksendeanlage?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1749, 'VD119', 'Welche technischen Anforderungen stellt die Amateurfunkverordnung u. a. an eine Amateurfunksendeanlage?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1750, 'VD120', 'Was ist bei Abgleicharbeiten und Messungen an Sendern im Hinblick auf die Aussendung zu beachten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1751, 'VD121', 'Ist das Aussenden des unmodulierten oder ungetasteten Trägers zulässig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1752, 'VD122', 'Bei der Überprüfung des Ausgangssignals eines Senders sollte die Dämpfung der Oberwellen mindestens', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1753, 'VD123', 'Welche Daten sind in der offiziellen Rufzeichenliste der Bundesnetzagentur immer enthalten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1754, 'VD124', 'Wozu können Aufzeichnungen der Sendetätigkeit (z.B. Stationstagebuch) dienen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1755, 'VD125', 'Wann muss der Funkamateur ein Logbuch führen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1756, 'VD126', 'Wann hat ein Funkamateur der Bundesnetzagentur gemäß AFuV technische Unterlagen über seine Sendeanlage vorzulegen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1757, 'VD127', 'Für welche Zwecke sind Zuteilungen mit Ausnahmen von den technischen und betrieblichen Rahmenbedingungen der AFuV möglich?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1758, 'VD128', 'Rufzeichenzuteilungen für besondere experimentelle und technisch-wissenschaftliche Studien gemäß § 16 Abs. 2 der AFuV sind Zuteilungen,', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1759, 'VD129', 'Ist für den Betrieb einer Amateurfunkstelle auf Wasser beziehungsweise in der Luft eine Sondergenehmigung der Bundesnetzagentur erforderlich?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1760, 'VD201', 'Welche Rückschlüsse lässt das Rufzeichen DP1ZZZ zu?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1761, 'VD202', 'Zu welchem Verwendungszweck und welcher Klasse gehört das Rufzeichen DO3ZZZ? Es ist ein', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1762, 'VD203', 'Zu welchem Verwendungszweck und welcher Klasse gehört das Rufzeichen DJ7ZZZ? Es ist ein', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1763, 'VD204', 'Zu welchem Verwendungszweck und welcher Klasse gehört das Rufzeichen DF9ZZZ? Es ist ein', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1764, 'VD205', 'Zu welchem Verwendungszweck und welcher Klasse gehört das Rufzeichen DGØZZZ? Es ist ein', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1765, 'VD206', 'Zu welchem Verwendungszweck und welcher Klasse gehört das Rufzeichen DLØZZZ? Es ist ein', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1766, 'VD207', 'Zu welchem Verwendungszweck und welcher Klasse gehört das Rufzeichen DB5ZZZ? Es ist ein', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1767, 'VD208', 'Zu welchem Verwendungszweck und welcher Klasse gehört das Rufzeichen DM1ZZZ? Es ist ein', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1768, 'VD209', 'Wie werden deutsche Amateurfunkrufzeichen meistens gebildet?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1769, 'VD210', 'Welche der folgenden Amateurfunkrufzeichen werden in Deutschland auch zugeteilt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1770, 'VD211', 'Wann muss beim Amateurfunkverkehr das zugeteilte Rufzeichen übermittelt werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1771, 'VD212', 'DL5XYZ benutzt sein im Kraftfahrzeug eingebautes Funkgerät für Sprechfunkverkehr. Wie kann der Zusatz zu seinem Rufzeichen lauten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1772, 'VD213', 'Was trifft für die Rufzeichenreihe "DN1AA - DN8ZZZ" zu?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1773, 'VD214', 'Was trifft für die Rufzeichenreihe "DJ1AA - DJ9ZZZ" zu?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1774, 'VD215', 'Was trifft für die Rufzeichenreihe "DL1AA - DL9ZZZ" zu?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1775, 'VD216', 'Was trifft für die Rufzeichenreihe "DB1AA - DB9ZZZ" zu?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1776, 'VD217', 'Was trifft für die Rufzeichenreihe "DO1AA - DO9ZZZ" zu?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1777, 'VD218', 'Woran erkennt man eine Amateurfunkstelle im Funkbetrieb?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1778, 'VD219', 'Was trifft für die Rufzeichenreihe "DBØAA - DBØZZZ" zu?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1779, 'VD220', 'Was trifft für die Rufzeichenreihe "DFØAA - DFØZZZ" zu?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1780, 'VD221', 'Was trifft für die Rufzeichenreihe "DAØAA - DAØZZZ" zu?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1781, 'VD222', 'Was trifft für das Rufzeichen "DA5AA" zu?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1782, 'VD223', 'Werden von der Bundesnetzagentur Ausbildungsrufzeichen für Klubstationen vergeben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1783, 'VD301', 'Von wem ist während des Ausbildungsfunkbetriebs das zugeteilte Ausbildungsrufzeichen zu benutzen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1784, 'VD302', 'Was ist bei der Durchführung von Ausbildungsfunkverkehr zu beachten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1785, 'VD303', 'Was ist u.a. im Zusammenhang mit der Durchführung von Ausbildungsfunkverkehr zu beachten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1786, 'VD304', 'Wann ist mit dem Entzug eines Ausbildungsrufzeichens zu rechnen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1787, 'VD305', 'Nicht-Funkamateure dürfen am Ausbildungsfunkbetrieb', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1788, 'VD306', 'Beim Ausbildungsfunkbetrieb sind', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1789, 'VD307', 'Kann der Inhaber einer Amateurfunkzulassung der Klasse E ein Ausbildungsrufzeichen zugeteilt bekommen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1790, 'VD308', 'Wird das Ausbildungsrufzeichen auf unbegrenzte Zeit erteilt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1791, 'VD309', 'Welche der nachfolgenden Tätigkeiten fällt nicht unter die Ziel- und Zweckbestimmung des Ausbildungsfunkbetriebs?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1792, 'VD401', 'Welche Voraussetzungen müssen für die Erteilung eines Rufzeichens für den Betrieb einer Klubstation erfüllt sein?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1793, 'VD402', 'Welche Voraussetzung muss für die Erteilung eines Rufzeichens für den Betrieb einer Klubstation erfüllt sein?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1794, 'VD403', 'Was ist nötig, damit ein Funkamateur das Rufzeichen einer Klubstation mitbenutzen darf?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1795, 'VD404', 'Wovon sind die Betriebsrechte eines Funkamateurs bei der Mitbenutzung eines Klubstationsrufzeichens abhängig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1796, 'VD405', 'Wovon sind die Betriebsrechte eines Funkamateurs bei der Mitbenutzung eines Klubstationsrufzeichens abhängig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1797, 'VD406', 'Welche der genannten Funkamateure dürfen an einer Klubstation der Klasse A Funkbetrieb im 40-m-Amateurfunkband durchführen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1798, 'VD407', 'Darf ein Funkamateur mit Ausbildungsrufzeichen der Klasse E an einer Klubstation, für deren Betrieb ein Rufzeichen der Klasse A zugeteilt wurde, ausbilden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1799, 'VD408', 'Welche der folgenden Aussagen ist richtig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1800, 'VD409', 'Welche der folgenden Aussagen ist richtig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1801, 'VD410', 'Welche der folgenden Aussagen ist richtig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1802, 'VD411', 'Welche der folgenden Aussagen ist richtig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1803, 'VD501', 'Welche der folgenden Begriffsbestimmungen ist gemäß AFuV richtig wiedergegeben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1804, 'VD502', 'Welche der folgenden Begriffsbestimmungen ist gemäß AFuV richtig wiedergegeben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1805, 'VD503', 'Welche der folgenden Begriffsbestimmungen ist gemäß AFuV richtig wiedergegeben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1806, 'VD504', 'Was ist notwendig, damit ein Funkamateur eine Amateurfunkstelle als Relaisfunkstelle oder Funkbake betreiben darf?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1807, 'VD505', 'Was ist notwendig, damit ein Funkamateur eine Rufzeichenzuteilung für den Betrieb einer fernbedienten oder automatisch arbeitenden Amateurfunkstelle erhalten kann?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1808, 'VD506', 'Wie hoch ist die maximal zulässige Strahlungsleistung einer Relaisfunkstelle oberhalb 30 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1809, 'VD507', 'Was gilt gemäß AFuV bei Relaisfunkstellen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1810, 'VD508', 'Was gilt gemäß AFuV bei Relaisfunkstellen und Funkbaken?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1811, 'VD509', 'Was gilt gemäß AFuV bei Relaisfunkstellen und Funkbaken?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1812, 'VD510', 'Wann kann ein verantwortlicher Funkamateur einen bestimmten Funkamateur vorübergehend vom Betrieb über die von ihm betreute Relaisfunkstelle ausschließen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1813, 'VD511', 'Welcher Fall ist als störungsfreier Betrieb einer Relaisfunkstelle im Sinne des § 13 Abs. 4 AFuV anzusehen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1814, 'VE101', 'Wo sind die ausführlichen Nutzungsbedingungen und die ausgewiesenen Frequenzbereiche für den Amateurfunkdienst in Deutschland zu finden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1815, 'VE102', 'Wo sind Einzelheiten über die Aufteilung und Nutzung der Frequenzbereiche in Deutschland zu finden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1816, 'VE103', 'Darf ein Funkamateur in Deutschland alle in der VO Funk für den Amateurfunkdienst zugewiesenen Frequenzbereiche benutzen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1817, 'VE104', 'Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (160-m-Amateurfunkband)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1818, 'VE105', 'Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (80-m-Amateurfunkband)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1819, 'VE106', 'Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (40-m-Amateurfunkband)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1820, 'VE107', 'Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (30-m-Amateurfunkband)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1821, 'VE108', 'Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (20-m-Amateurfunkband)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1822, 'VE109', 'Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (17-m-Amateurfunkband)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1823, 'VE110', 'Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (15-m-Amateurfunkband)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1824, 'VE111', 'Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (12-m-Amateurfunkband)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1825, 'VE112', 'Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (10-m-Amateurfunkband)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1826, 'VE113', 'Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (6-m-Amateurfunkband)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1827, 'VE114', 'Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (2-m-Amateurfunkband)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1828, 'VE115', 'Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (70-cm-Amateurfunkband)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1829, 'VE116', 'Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (23-cm-Amateurfunkband)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1830, 'VE117', 'Welche Antwort enthält die richtige Anfangs- und Endfrequenz eines für den Amateurfunkdienst in Deutschland ausgewiesenen Frequenzbereichs (13-cm-Amateurfunkband)?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1831, 'VE118', 'Welche Antwort enthält nur Frequenzbereiche, die auch von Rufzeicheninhabern der Klasse E genutzt werden dürfen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1832, 'VE119', 'Welche Antwort enthält nur Frequenzbereiche, die auch von Rufzeicheninhabern der Klasse E genutzt werden dürfen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1833, 'VE120', 'In welchem der genannten Frequenzbereiche hat der Amateurfunkdienst primären Status?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1834, 'VE121', 'In welchem der genannten Frequenzbereiche hat der Amateurfunkdienst primären Status?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1835, 'VE122', 'In welchem der genannten Frequenzbereiche hat der Amateurfunkdienst primären Status?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1836, 'VE123', 'In welchem der genannten Frequenzbereiche hat der Amateurfunkdienst primären Status?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1837, 'VE124', 'In welchem der genannten Frequenzbereiche hat der Amateurfunkdienst primären Status?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1838, 'VE125', 'In welchem der genannten Frequenzbereiche hat der Amateurfunkdienst primären Status?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1839, 'VE126', 'Was gilt für die Rufzeicheninhaber der Klassen A und E im Frequenzbereich 1810 - 1850 kHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1840, 'VE127', 'Was gilt für die Rufzeicheninhaber der Klassen A und E im Frequenzbereich 1850 - 1890 kHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1841, 'VE128', 'Was gilt für die Rufzeicheninhaber der Klassen A und E im Frequenzbereich 1890 - 2000 kHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1842, 'VE129', 'Was gilt für die Rufzeicheninhaber der Klassen A und E im Frequenzbereich 3,5 - 3,8 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1843, 'VE130', 'Wie hoch ist die maximal zulässige Senderausgangsleistung für Rufzeicheninhaber der Klasse A in den Frequenzbereichen 3,5 - 3,8 MHz und 7,0 - 7,1 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1844, 'VE131', 'Wie hoch ist die maximal zulässige Senderausgangsleistung für Rufzeicheninhaber der Klasse A im Frequenzbereich 7,1 - 7,2 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1845, 'VE132', 'Wie hoch ist die maximal zulässige Senderausgangsleistung für Rufzeicheninhaber der Klasse A im Frequenzbereich 10,1 - 10,15 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1846, 'VE133', 'Wie hoch ist die maximal zulässige Senderausgangsleistung für Rufzeicheninhaber der Klasse A in den Frequenzbereichen 14 - 14,35 MHz und 18,068 - 18,168 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1847, 'VE134', 'Wie hoch ist die maximal zulässige Senderausgangsleistung für Rufzeicheninhaber der Klasse A in den Frequenzbereichen 21 - 21,45 MHz und 24,89 - 24,99 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1848, 'VE135', 'Welche Leistungsgrenzen gelten für die Rufzeicheninhaber der Klassen A und E in den Frequenzbereichen 21 - 21,45 MHz und 28 - 29,7 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1849, 'VE136', 'Wie hoch ist die maximal zulässige Strahlungsleistung für die Rufzeicheninhaber der Klassen A und E im Frequenzbereich 50,08 - 51 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1850, 'VE137', 'Was gilt für die Nutzung des Frequenzbereichs 50,08 - 51 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1851, 'VE138', 'Was gilt für die Rufzeicheninhaber der Klassen A und E in den Frequenzbereichen 144 - 146 MHz und 430 - 440 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1852, 'VE139', 'Wie hoch ist die maximal zulässige Sendeleistung für Rufzeicheninhaber der Klasse A im Frequenzbereich 1240 - 1300 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1853, 'VE140', 'Wie hoch ist die maximal zulässige Senderausgangsleistung für Rufzeicheninhaber der Klasse A in den Amateurfunkbändern zwischen 1300 MHz und 250 GHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1854, 'VE141', 'Was gilt für die Rufzeicheninhaber der Klassen A und E im Frequenzbereich 10 - 10,5 GHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1855, 'VE142', 'In welchen Amateurfunkfrequenzbereichen beträgt die maximal zulässige belegte Bandbreite einer Aussendung 800 Hz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1856, 'VE143', 'In welchen Amateurfunkfrequenzbereichen beträgt die maximal zulässige belegte Bandbreite einer Aussendung 2,7 kHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1857, 'VE144', 'In welchen Amateurfunkfrequenzbereichen beträgt die maximal zulässige belegte Bandbreite einer Aussendung 2,7 kHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1858, 'VE145', 'In welchem Amateurfunkfrequenzbereich beträgt die maximal zulässige belegte Bandbreite einer Aussendung 7 kHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1859, 'VE146', 'In welchem Amateurfunkfrequenzbereich beträgt die maximal zulässige belegte Bandbreite einer Aussendung 40 kHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1860, 'VE147', 'In welchem Amateurfunkfrequenzbereich beträgt die maximal zulässige belegte Bandbreite einer Aussendung 2 MHz bzw. für amplitudenmodulierte Fernsehaussendungen 7 MHz?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1861, 'VE148', 'Ist die Betriebsart "Packet-Radio" mit einer Senderausgangsleistung von 20 Watt im 160-m-Amateurfunkband zulässig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1862, 'VE149', 'Welche Aussage ist richtig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1863, 'VE150', 'Wer legt in Deutschland die Bereiche für die unterschiedlichen Betriebsarten in den Amateurfunkbändern verbindlich fest?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1864, 'VE151', 'Was besagt der Hinweis, dass der Frequenzbereich 433,05 - 434,79 MHz als ISM-Frequenzbereich zugewiesen ist?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1865, 'VE152', 'Darf ein Funkamateur mit seinem Amateurfunkgerät Funkverkehr im CB-Funk-Bereich durchführen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1866, 'VE153', 'Ein Funkamateur ist auch Inhaber einer Frequenzzuteilung für den Betriebsfunk. Darf er anstatt eines zugelassenen Betriebsfunkgerätes auch ein Amateurfunkgerät auf der Betriebsfunkfrequenz betreiben?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1867, 'VF101', 'Enthält das TKG für den Funkamateur anwendbare Regelungen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1868, 'VF102', 'Bei welcher Handlung verletzt ein Funkamateur das Fernmeldegeheimnis?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1869, 'VF103', 'Wie hat sich ein Funkamateur zu verhalten, der unbeabsichtigt Nachrichten empfängt, die nicht für Funkamateure, die Allgemeinheit oder einen unbestimmten Personenkreis bestimmt sind?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1870, 'VF104', 'Wie hat sich ein Funkamateur zu verhalten, wenn er Sendungen empfängt, die nicht für Funkamateure, die Allgemeinheit oder einen unbestimmten Personenkreis bestimmt sind?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1871, 'VF105', 'Dürfen Sendefunkanlagen ohne Frequenzzuteilung betrieben werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1872, 'VF106', 'Welcher der nachfolgend genannten Tatbestände ist eine Ordnungswidrigkeit gemäß TKG?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1873, 'VF107', 'Bei welcher der genannten Apparaturen sind nach dem TKG auch der Besitz und die Herstellung verboten und mit erheblichen Strafen bewehrt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1874, 'VF108', 'Darf ein Funkamateur eine Sendeanlage betreiben oder besitzen, die Ihrer Form oder Verkleidung nach einen anderen Gegenstand vortäuscht und somit geeignet ist, das nicht öffentlich gesprochene Wort eines anderen unbemerkt abzuhören, oder das Bild eines anderen unbemerkt aufzunehmen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1875, 'VF109', 'Darf ein Funkamateur eine Funkanlage seiner Amateurfunkstelle zum Abhören des nicht öffentlich gesprochenen Wortes verwenden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1876, 'VG101', 'Was hat der Funkamateur zu veranlassen, wenn bei ihm der Empfang auf Grund mangelnder Empfängerstörfestigkeit stark beeinträchtigt wird?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1877, 'VG102', 'Darf der Funkamateur von den grundlegenden Anforderungen zur Störfestigkeit im Sinne des Gesetzes über die elektromagnetische Verträglichkeit von Geräten abweichen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1878, 'VG103', 'Der Empfang einer Amateurfunkaussendung wird auf der Frequenz 145,5 MHz durch einen PC aus der Nachbarschaft elektromagnetisch gestört. Was trifft für diesen Fall nach den Regelungen des EMVG bzw. AFuG zu?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1879, 'VG104', 'Der Empfang einer Amateurfunkaussendung wird auf der Frequenz 7,05 MHz durch eine Alarmanlage aus der Nachbarschaft elektromagnetisch gestört. Was trifft für diesen Fall nach den Regelungen des EMVG bzw. AFuG zu?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1880, 'VG105', 'Eine Zusatzeinrichtung eines Funkamateurs verursacht eine elektromagnetische Störung im Sinne des EMVG bei einer Betriebsfunkanlage in der Nachbarschaft. Welche Maßnahmen sind entsprechend den Regelungen des EMVG zu treffen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1881, 'VG106', 'Der Empfang einer Amateurfunkaussendung wird auf der dem Amateurfunk sekundär zugewiesenen Frequenz 10,120 MHz durch den Schaltkontakt einer Heizungssteuerung aus der Nachbarschaft gestört. Was trifft für diesen Fall nach den Regelungen des EMVG bzw. AFuG zu?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1882, 'VG107', 'Der Empfang einer Amateurfunkaussendung wird auf der dem Amateurfunk "primär" zugewiesenen Frequenz 7,05 MHz durch den Schaltkontakt einer Heizungssteuerung aus der Nachbarschaft gestört. Was trifft für diesen Fall nach den Regelungen des EMVG bzw. AFuG zu?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1883, 'VG108', 'Durch den Betrieb einer Amateurfunkstelle auf 145,550 MHz wird der UKW-Rundfunkempfang eines Nachbarn gestört. Eine Überprüfung ergibt, dass die Amateurfunkstelle und die Rundfunkempfangsanlage vorschriftsmäßig betrieben werden. Das gestörte Rundfunkgerät hält die nach Norm empfohlene Störfestigkeit ein, der Funkamateur erzeugt jedoch am Ort des gestörten Empfängers eine höhere Feldstärke. Womit muss der Funkamateur rechnen, wenn er seinen Funkbetrieb uneingeschränkt fortsetzt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1884, 'VG109', 'Durch den Betrieb einer Amateurfunkstelle auf 145,550 MHz wird der Rundfunkempfänger eines Nachbarn auf 100,6 MHz durch Direkteinstrahlung gestört. Eine Überprüfung ergibt, dass der Funkamateur am Ort des gestörten Empfängers eine Feldstärke erzeugt, die den in der Norm empfohlenen Grenzwert für die Störfestigkeit von Geräten nicht erreicht. Was hat der Funkamateur zu tun?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1885, 'VG110', 'Durch den Betrieb einer Amateurfunkstelle auf 144,250 MHz wird der Fernsehempfang eines Nachbarn im Sonderkanal S6 gestört. Eine Überprüfung ergibt, dass der Funkamateur am Ort der gestörten Empfangsanlage eine Feldstärke erzeugt, die den, in der Norm empfohlenen Grenzwert für die Störfestigkeit von Kabelverteilanlagen, nicht erreicht. Was hat der Funkamateur zu tun?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1886, 'VG111', 'Durch den Betrieb einer Amateurfunkstelle wird der Rundfunkempfang eines Nachbarn gestört. Eine Überprüfung ergibt, dass sowohl das gestörte Rundfunkgerät, wie auch die störende Amateurfunkstelle die Vorschriften einhalten und Nachbesserungen nicht mehr möglich sind. Was hat der Funkamateur in diesem Fall zu tun?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1887, 'VG112', 'Durch den Betrieb einer Amateurfunkstelle wird der Fernsehempfang im TV Kanal 10 eines Nachbarn gestört. Eine Überprüfung ergibt, dass sowohl das gestörte Fernsehgerät wie auch die störende Amateurfunkstelle die Vorschriften einhalten und Nachbesserungen nicht mehr möglich sind. Was kann der Funkamateur erwarten, wenn er den störenden Betrieb fortsetzt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1888, 'VG113', 'Durch den Betrieb einer Amateurfunkstelle wird der Fernsehempfang im TV-Kanal S6 eines Nachbarn gestört. Eine Überprüfung ergibt, dass sowohl das gestörte Fernsehgerät wie auch die störende Amateurfunkstelle die Vorschriften einhalten und Nachbesserungen nicht mehr möglich sind. Was kann der Funkamateur erwarten, wenn er den störenden Betrieb fortsetzt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1889, 'VH101', 'Welches Gesetz bzw. welche Vorschrift beinhaltet Regelungen für das Inverkehrbringen, den freien Warenverkehr und die Inbetriebnahme, die auch für serienmäßig hergestellte Amateurfunkgeräte gelten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1890, 'VH102', 'Welche grundlegenden Anforderungen werden entsprechend dem FTEG an Amateurfunkgeräte gestellt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1891, 'VH103', 'Welche Vorschriften müssen im Handel erhältliche Empfangsfunkanlagen einhalten, die dem Amateurfunk zugewiesene Frequenzen empfangen können?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1892, 'VH104', 'Welche Geräte fallen nicht in den Anwendungsbereich des FTEG?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1893, 'VH105', 'Wird für selbstgefertigte Amateurfunkgeräte der Nachweis auf Einhaltung der technischen Vorschriften verlangt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1894, 'VI101', 'Wer ist für die Sicherstellung der elektromagnetischen Umweltverträglichkeit verantwortlich?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1895, 'VI102', 'Was müssen Zulassungsinhaber in Bezug auf den Personenschutz einhalten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1896, 'VI103', 'Was bedeutet die Abkürzung EMVU?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1897, 'VI104', 'In welchem Regelungswerk ist der Schutz von Personen bei der Einwirkung elektromagnetischer Felder auch ausführlich für den Amateurfunk geregelt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1898, 'VI105', 'In welcher gesetzlichen Regelung ist das Verfahren zum Schutz von Personen in elektromagnetischen Feldern ortsfester Amateurfunkstellen festgelegt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1899, 'VI106', 'Die Feldstärkegrenzwerte für den Schutz von Personen in elektromagnetischen Feldern sind von der Frequenz abhängig, weil', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1900, 'VI107', 'Was versteht man nach der Verordnung über das Nachweisverfahren zur Begrenzung elektromagnetischer Felder (BEMFV) unter dem "Anzeigeverfahren ortsfester Amateurfunkanlagen"?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1901, 'VI108', 'Welchen Status hat im Rahmen der EMVU die Anzeige einer ortsfesten Amateurfunkanlage?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1902, 'VI109', 'Für welche Amateurfunkstellen muss der Schutz von Personen in elektromagnetischen Feldern vom Funkamateur dokumentiert werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1903, 'VI110', 'Kann die Bundesnetzagentur für den Betrieb einer ortsfesten Amateurfunkstelle eine Standortbescheinigung fordern?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1904, 'VI111', 'Bis zu welchem Bereich darf der in der Anzeige der ortsfesten Amateurfunkanlage angegebene standortbezogene Sicherheitsabstand höchstens reichen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1905, 'VI112', 'Welche physikalischen Größen werden für die Angabe der Konfiguration im Rahmen des Anzeigeverfahrens benötigt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1906, 'VI113', 'Welche der nachfolgenden Aussagen in Bezug auf die Herzschrittmachergrenzwerte ist richtig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1907, 'VI114', 'Wo sind die im Rahmen des Nachweisverfahrens zur Begrenzung elektromagnetischer Felder die anzuwendenden Grenzwerte zu finden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1908, 'VI115', 'Wo sind die DIN-Normen mit den Herzschrittmachergrenzwerten zu finden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1909, 'VI116', 'Wo und wann ist die Anzeige einer ortsfesten Amateurfunkstelle mit einer EIRP von mehr als 10 Watt einzureichen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1910, 'VI117', 'Was hat ein Funkamateur zu beachten, nachdem er seine ortsfeste Amateurfunkstelle bei der Bundesnetzagentur gemäß BEMFV angezeigt hat?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1911, 'VI118', 'Wo und wann hat der Funkamateur die Dokumentation über die Einhaltung der Anforderungen mit allen erforderlichen Unterlagen gemäß BEMFV einzureichen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1912, 'VI119', 'Welche Aussendungen von Amateurfunkanlagen müssen bei der Ermittlung des standortbezogenen Sicherheitsabstandes berücksichtigt werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1913, 'VI120', 'Für die Berechnung des Sicherheitsabstandes wird in der Regel der Antennengewinnfaktor (G) verwendet. Der Antennengewinnfaktor G ist', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1914, 'VI121', 'Wer muss seine Amateurfunkstelle bei der Bundesnetzagentur anzeigen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1915, 'VI122', 'Von wem müssen die Herzschrittmachergrenzwerte eingehalten werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1916, 'VI123', 'Wenn die Herzschrittmachergrenzwerte außerhalb des kontrollierbaren Bereiches überschritten werden, hat der Funkamateur', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1917, 'VJ101', 'Nach welchen Vorschriften müssen Außenantennenanlagen errichtet werden?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1918, 'VJ102', 'Welche Vorschriften bezüglich Blitzschutz gelten für Amateurfunkantennenanlagen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1919, 'VJ103', 'Wie ist die Stromversorgung von Eigenbaugeräten elektrotechnisch sicher aufzubauen?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1920, 'VK101', 'Wer haftet für Schäden, die durch die Antennenanlage einer Amateurfunkstelle entstehen können?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1921, 'VK102', 'Welche regelmäßigen Beiträge hat der Funkamateur zu entrichten?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1922, 'VK103', 'Mit welchen Folgen muss der Funkamateur rechnen, wenn er die zu entrichtenden Gebühren und Beiträge nicht zahlt?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1923, 'VK104', 'Welches Ministerium ist für die Angelegenheiten des Amateurfunkdienstes in Deutschland federführend zuständig?', 0, 1, 0, 0, '');
INSERT INTO question VALUES (1924, 'VK105', 'Darf eine Amateurfunkstelle auch an Bord eines Luftfahrzeuges betrieben werden?', 0, 1, 0, 0, '');
INSERT INTO answer VALUES (1, 1, 0, '42*10<sup>-3</sup> A.', ' ');
INSERT INTO answer VALUES (2, 1, 1, '42*10<sup>3</sup> A.', ' ');
INSERT INTO answer VALUES (3, 1, 2, '42*10<sup>-2</sup> A.', ' ');
INSERT INTO answer VALUES (4, 1, 3, '42*10<sup>-1</sup> A.', ' ');
INSERT INTO answer VALUES (5, 2, 0, '420*10<sup>-6</sup> A.', ' ');
INSERT INTO answer VALUES (6, 2, 1, '420*10<sup>6</sup> A.', ' ');
INSERT INTO answer VALUES (7, 2, 2, '420*10<sup>-5</sup> A.', ' ');
INSERT INTO answer VALUES (8, 2, 3, '42*10<sup>-6</sup> A.', ' ');
INSERT INTO answer VALUES (9, 3, 0, '10<sup>-1</sup> W.', ' ');
INSERT INTO answer VALUES (10, 3, 1, '0,001 W.', ' ');
INSERT INTO answer VALUES (11, 3, 2, '0,01 W.', ' ');
INSERT INTO answer VALUES (12, 3, 3, '10<sup>-2</sup> W.', ' ');
INSERT INTO answer VALUES (13, 4, 0, '4,2*10<sup>6</sup> Hz.', ' ');
INSERT INTO answer VALUES (14, 4, 1, '4,2*10<sup>5</sup> Hz.', ' ');
INSERT INTO answer VALUES (15, 4, 2, '42*10<sup>6</sup> Hz.', ' ');
INSERT INTO answer VALUES (16, 4, 3, '42*10<sup>-5</sup> Hz.', ' ');
INSERT INTO answer VALUES (17, 5, 0, 'Volt (V)', ' ');
INSERT INTO answer VALUES (18, 5, 1, 'Ampere (A)', ' ');
INSERT INTO answer VALUES (19, 5, 2, 'Ohm (&Omega;)', ' ');
INSERT INTO answer VALUES (20, 5, 3, 'Amperestunden (Ah)', ' ');
INSERT INTO answer VALUES (21, 6, 0, 'Amperesekunde (As)', ' ');
INSERT INTO answer VALUES (22, 6, 1, 'Kilowatt (kW)', ' ');
INSERT INTO answer VALUES (23, 6, 2, 'Joule (J)', ' ');
INSERT INTO answer VALUES (24, 6, 3, 'Ampere (A)', ' ');
INSERT INTO answer VALUES (25, 7, 0, 'Watt (W)', ' ');
INSERT INTO answer VALUES (26, 7, 1, 'Kilowattstunden (kWh)', ' ');
INSERT INTO answer VALUES (27, 7, 2, 'Joule (J)', ' ');
INSERT INTO answer VALUES (28, 7, 3, 'Amperestunden (Ah)', ' ');
INSERT INTO answer VALUES (29, 8, 0, 'Ohm', ' ');
INSERT INTO answer VALUES (30, 8, 1, 'Farad', ' ');
INSERT INTO answer VALUES (31, 8, 2, 'Siemens', ' ');
INSERT INTO answer VALUES (32, 8, 3, 'Henry', ' ');
INSERT INTO answer VALUES (33, 9, 0, 'Ampere, Kelvin, Meter, Sekunde', ' ');
INSERT INTO answer VALUES (34, 9, 1, 'Sekunde, Meter, Volt, Watt', ' ');
INSERT INTO answer VALUES (35, 9, 2, 'Farad, Henry, Ohm, Sekunde', ' ');
INSERT INTO answer VALUES (36, 9, 3, 'Grad, Hertz, Ohm, Sekunde', ' ');
INSERT INTO answer VALUES (37, 10, 0, '220 nF.', ' ');
INSERT INTO answer VALUES (38, 10, 1, '22 nF.', ' ');
INSERT INTO answer VALUES (39, 10, 2, '220 pF.', ' ');
INSERT INTO answer VALUES (40, 10, 3, '22 pF.', ' ');
INSERT INTO answer VALUES (41, 11, 0, '3750 kHz.', ' ');
INSERT INTO answer VALUES (42, 11, 1, '375 kHz.', ' ');
INSERT INTO answer VALUES (43, 11, 2, '0,0375 GHz.', ' ');
INSERT INTO answer VALUES (44, 11, 3, '0,375 GHz.', ' ');
INSERT INTO answer VALUES (45, 12, 0, 'Farad (F)', ' ');
INSERT INTO answer VALUES (46, 12, 1, 'Ohm (&Omega;)', ' ');
INSERT INTO answer VALUES (47, 12, 2, 'Siemens (S)', ' ');
INSERT INTO answer VALUES (48, 12, 3, 'Henry (H)', ' ');
INSERT INTO answer VALUES (49, 13, 0, 'Silber, Kupfer, Aluminium', ' ');
INSERT INTO answer VALUES (50, 13, 1, 'Silber, Kupfer, Blei', ' ');
INSERT INTO answer VALUES (51, 13, 2, 'Kupfer, Eisen, Zinn', ' ');
INSERT INTO answer VALUES (52, 13, 3, 'Aluminium, Kupfer, Quecksilber', ' ');
INSERT INTO answer VALUES (53, 14, 0, 'Silber', ' ');
INSERT INTO answer VALUES (54, 14, 1, 'Kupfer', ' ');
INSERT INTO answer VALUES (55, 14, 2, 'Gold', ' ');
INSERT INTO answer VALUES (56, 14, 3, 'Zinn', ' ');
INSERT INTO answer VALUES (57, 15, 0, 'Zinn', ' ');
INSERT INTO answer VALUES (58, 15, 1, 'Kupfer', ' ');
INSERT INTO answer VALUES (59, 15, 2, 'Gold', ' ');
INSERT INTO answer VALUES (60, 15, 3, 'Aluminium', ' ');
INSERT INTO answer VALUES (61, 16, 0, 'Epoxid, Polyethylen (PE), Polystyrol (PS)', ' ');
INSERT INTO answer VALUES (62, 16, 1, 'Pertinax, Polyvinylchlorid (PVC), Graphit', ' ');
INSERT INTO answer VALUES (63, 16, 2, 'Polyethylen (PE), Messing, Konstantan', ' ');
INSERT INTO answer VALUES (64, 16, 3, 'Teflon, Pertinax, Bronze', ' ');
INSERT INTO answer VALUES (65, 17, 0, 'Einige Stoffe (z.B. Silizium, Germanium) sind in reinem Zustand bei Raumtemperatur gute Isolatoren. Durch geringfügige Zusätze von geeigneten anderen Stoffen oder bei hohen Temperaturen werden sie jedoch zu Leitern.', ' ');
INSERT INTO answer VALUES (66, 17, 1, 'Einige Stoffe (z.B. Silizium, Germanium) sind in reinem Zustand bei Raumtemperatur gute Leiter. Durch geringfügige Zusätze von geeigneten anderen Stoffen oder bei hohen Temperaturen nimmt jedoch ihre Leitfähigkeit ab.', ' ');
INSERT INTO answer VALUES (67, 17, 2, 'Einige Stoffe wie z.B. Indium oder Magnesium sind in reinem Zustand gute Isolatoren. Durch geringfügige Zusätze von Silizium, Germanium oder geeigneten anderen Stoffen werden sie jedoch zu Leitern.', ' ');
INSERT INTO answer VALUES (68, 17, 3, 'Einige Stoffe (z.B. Silizium, Germanium) sind in trockenem Zustand gute Elektrolyten. Durch geringfügige Zusätze von Wismut oder Tellur kann man daraus entweder N-leitendes- oder P-leitendes Material für Anoden bzw. Kathoden von Halbleiterbauelementen herstellen.', ' ');
INSERT INTO answer VALUES (69, 18, 0, '0 V', ' ');
INSERT INTO answer VALUES (70, 18, 1, '3 V', ' ');
INSERT INTO answer VALUES (71, 18, 2, '-3 V', ' ');
INSERT INTO answer VALUES (72, 18, 3, '1,5 V', ' ');
INSERT INTO answer VALUES (73, 19, 0, '12 V / 10 Ah', ' ');
INSERT INTO answer VALUES (74, 19, 1, '12 V / 60 Ah', ' ');
INSERT INTO answer VALUES (75, 19, 2, '2 V / 10 Ah', ' ');
INSERT INTO answer VALUES (76, 19, 3, '2 V / 60 Ah', ' ');
INSERT INTO answer VALUES (77, 20, 0, 'Man nimmt an, dass der Strom vom Pluspol zum Minuspol fließt.', ' ');
INSERT INTO answer VALUES (78, 20, 1, 'Man nimmt an, dass der Strom vom Minuspol zum Pluspol fließt.', ' ');
INSERT INTO answer VALUES (79, 20, 2, 'Es ist die Flussrichtung der Elektronen vom Minuspol zum Pluspol.', ' ');
INSERT INTO answer VALUES (80, 20, 3, 'Es ist die Flussrichtung der Elektronen vom Pluspol zum Minuspol.', ' ');
INSERT INTO answer VALUES (81, 21, 0, 'Nein, weil kein geschlossener Stromkreis vorhanden ist.', ' ');
INSERT INTO answer VALUES (82, 21, 1, 'Nein, weil der Pluspol mit dem Minuspol verbunden ist.', ' ');
INSERT INTO answer VALUES (83, 21, 2, 'Ja, sogar Kurzschlussstrom, weil der Pluspol mit dem Minuspol verbunden ist.', ' ');
INSERT INTO answer VALUES (84, 21, 3, 'Ja. Der Strom hängt vom Innenwiderstand der Batterien ab.', ' ');
INSERT INTO answer VALUES (85, 22, 0, '68 Stunden und 45 Minuten', ' ');
INSERT INTO answer VALUES (86, 22, 1, 'Genau 44 Stunden', ' ');
INSERT INTO answer VALUES (87, 22, 2, '6 Stunden 52 Minuten und 30 Sekunden', ' ');
INSERT INTO answer VALUES (88, 22, 3, '69 Stunden und 15 Minuten', ' ');
INSERT INTO answer VALUES (89, 23, 0, 'Volt pro Meter (V/m)', ' ');
INSERT INTO answer VALUES (90, 23, 1, 'Watt pro Quadratmeter (W/m<sup>2</sup>)', ' ');
INSERT INTO answer VALUES (91, 23, 2, 'Ampere pro Meter (A/m)', ' ');
INSERT INTO answer VALUES (92, 23, 3, 'Henry pro Meter (H/m)', ' ');
INSERT INTO answer VALUES (93, 24, 0, 'Homogenes elektrisches Feld', ' ');
INSERT INTO answer VALUES (94, 24, 1, 'Homogenes magnetisches Feld', ' ');
INSERT INTO answer VALUES (95, 24, 2, 'Polarisiertes elektrisches Feld', ' ');
INSERT INTO answer VALUES (96, 24, 3, 'Polarisiertes magnetisches Feld', ' ');
INSERT INTO answer VALUES (97, 25, 0, 'Elektrische Feldlinien', ' ');
INSERT INTO answer VALUES (98, 25, 1, 'Magnetische Feldlinien', ' ');
INSERT INTO answer VALUES (99, 25, 2, 'Polarisierte Feldlinien', ' ');
INSERT INTO answer VALUES (100, 25, 3, 'Horizontale Feldlinien', ' ');
INSERT INTO answer VALUES (101, 26, 0, 'Ampere pro Meter (A/m)', ' ');
INSERT INTO answer VALUES (102, 26, 1, 'Watt pro Quadratmeter (W/m<sup>2</sup>)', ' ');
INSERT INTO answer VALUES (103, 26, 2, 'Volt pro Meter (V/m)', ' ');
INSERT INTO answer VALUES (104, 26, 3, 'Henry pro Meter (H/m)', ' ');
INSERT INTO answer VALUES (105, 27, 0, 'Homogenes magnetisches Feld', ' ');
INSERT INTO answer VALUES (106, 27, 1, 'Homogenes elektrisches Feld', ' ');
INSERT INTO answer VALUES (107, 27, 2, 'Konzentrisches magnetisches Feld', ' ');
INSERT INTO answer VALUES (108, 27, 3, 'Zentriertes magnetisches Feld', ' ');
INSERT INTO answer VALUES (109, 28, 0, 'Magnetfeld aus konzentrischen Kreisen um den Leiter.', ' ');
INSERT INTO answer VALUES (110, 28, 1, 'elektrisches Feld aus konzentrischen Kreisen um den Leiter.', ' ');
INSERT INTO answer VALUES (111, 28, 2, 'homogenes Magnetfeld um den Leiter.', ' ');
INSERT INTO answer VALUES (112, 28, 3, 'homogenes elektrisches Feld um den Leiter.', ' ');
INSERT INTO answer VALUES (113, 29, 0, 'Magnetische Feldlinien', ' ');
INSERT INTO answer VALUES (114, 29, 1, 'Elektrische Feldlinien', ' ');
INSERT INTO answer VALUES (115, 29, 2, 'Radiale Feldlinien', ' ');
INSERT INTO answer VALUES (116, 29, 3, 'Vertikale Feldlinien', ' ');
INSERT INTO answer VALUES (117, 30, 0, 'Eisen', ' ');
INSERT INTO answer VALUES (118, 30, 1, 'Chrom', ' ');
INSERT INTO answer VALUES (119, 30, 2, 'Kupfer', ' ');
INSERT INTO answer VALUES (120, 30, 3, 'Aluminium', ' ');
INSERT INTO answer VALUES (121, 31, 0, 'wenn ein zeitlich schnell veränderlicher Strom durch einen elektrischen Leiter fließt, dessen Länge mindestens 1/100 der Wellenlänge ist.', ' ');
INSERT INTO answer VALUES (122, 31, 1, 'wenn durch einen elektrischen Leiter, dessen Länge mindestens 1/100 der Wellenlänge ist, ein konstanter Strom fließt.', ' ');
INSERT INTO answer VALUES (123, 31, 2, 'wenn sich elektrische Ladungen in einem Leiter befinden, dessen Länge mindestens 1/100 der Wellenlänge ist.', ' ');
INSERT INTO answer VALUES (124, 31, 3, 'wenn an einem elektrischen Leiter, dessen Länge mindestens 1/100 der Wellenlänge ist, eine konstante Spannung angelegt wird.', ' ');
INSERT INTO answer VALUES (125, 32, 0, 'durch eine Wechselwirkung zwischen elektrischem und magnetischem Feld.', ' ');
INSERT INTO answer VALUES (126, 32, 1, 'nur über das elektrische Feld. Das magnetische Feld ist nur im Nahfeld vorhanden.', ' ');
INSERT INTO answer VALUES (127, 32, 2, 'nur über das magnetische Feld. Das elektrische Feld ist nur im Nahfeld vorhanden.', ' ');
INSERT INTO answer VALUES (128, 32, 3, 'über die sich unabhängig voneinander ausbreitenden und senkrecht zueinander stehenden elektrischen und magnetischen Felder.', ' ');
INSERT INTO answer VALUES (129, 33, 0, 'Horizontale Polarisation', ' ');
INSERT INTO answer VALUES (130, 33, 1, 'Vertikale Polarisation', ' ');
INSERT INTO answer VALUES (131, 33, 2, 'Rechtsdrehende Polarisation', ' ');
INSERT INTO answer VALUES (132, 33, 3, 'Zirkulare Polarisation', ' ');
INSERT INTO answer VALUES (133, 34, 0, '90°.', ' ');
INSERT INTO answer VALUES (134, 34, 1, '45°.', ' ');
INSERT INTO answer VALUES (135, 34, 2, '180°.', ' ');
INSERT INTO answer VALUES (136, 34, 3, '360°.', ' ');
INSERT INTO answer VALUES (137, 35, 0, 'vertikal.', ' ');
INSERT INTO answer VALUES (138, 35, 1, 'horizontal.', ' ');
INSERT INTO answer VALUES (139, 35, 2, 'rechtsdrehend.', ' ');
INSERT INTO answer VALUES (140, 35, 3, 'linksdrehend.', ' ');
INSERT INTO answer VALUES (141, 36, 0, 'm', ' ');
INSERT INTO answer VALUES (142, 36, 1, 'm/s', ' ');
INSERT INTO answer VALUES (143, 36, 2, 'Hz', ' ');
INSERT INTO answer VALUES (144, 36, 3, 's/m', ' ');
INSERT INTO answer VALUES (145, 37, 0, '163 m', ' ');
INSERT INTO answer VALUES (146, 37, 1, '16,3 m', ' ');
INSERT INTO answer VALUES (147, 37, 2, '10,5 m', ' ');
INSERT INTO answer VALUES (148, 37, 3, '61,3 m', ' ');
INSERT INTO answer VALUES (149, 38, 0, '10,5 m', ' ');
INSERT INTO answer VALUES (150, 38, 1, '163 m', ' ');
INSERT INTO answer VALUES (151, 38, 2, '9,49 m', ' ');
INSERT INTO answer VALUES (152, 38, 3, '61,3 m', ' ');
INSERT INTO answer VALUES (153, 39, 0, '145,631 MHz', ' ');
INSERT INTO answer VALUES (154, 39, 1, '148,927 MHz', ' ');
INSERT INTO answer VALUES (155, 39, 2, '150,247 MHz', ' ');
INSERT INTO answer VALUES (156, 39, 3, '135,754 MHz', ' ');
INSERT INTO answer VALUES (157, 40, 0, '3,75 MHz', ' ');
INSERT INTO answer VALUES (158, 40, 1, '3,65 MHz', ' ');
INSERT INTO answer VALUES (159, 40, 2, '3,56 MHz', ' ');
INSERT INTO answer VALUES (160, 40, 3, '3,57 MHz', ' ');
INSERT INTO answer VALUES (161, 41, 0, '145 MHz', ' ');
INSERT INTO answer VALUES (162, 41, 1, '145 µs', ' ');
INSERT INTO answer VALUES (163, 41, 2, '145 kHz', ' ');
INSERT INTO answer VALUES (164, 41, 3, '145 km/s', ' ');
INSERT INTO answer VALUES (165, 42, 0, '20 kHz', ' ');
INSERT INTO answer VALUES (166, 42, 1, '2 MHz', ' ');
INSERT INTO answer VALUES (167, 42, 2, '200 kHz', ' ');
INSERT INTO answer VALUES (168, 42, 3, '20 MHz', ' ');
INSERT INTO answer VALUES (169, 43, 0, 'VHF (very high frequency)', ' ');
INSERT INTO answer VALUES (170, 43, 1, 'UHF (ultra high frequency)', ' ');
INSERT INTO answer VALUES (171, 43, 2, 'MF (medium frequency)', ' ');
INSERT INTO answer VALUES (172, 43, 3, 'SHF (super high frequency)', ' ');
INSERT INTO answer VALUES (173, 44, 0, 'UHF-Bereich.', ' ');
INSERT INTO answer VALUES (174, 44, 1, 'VHF-Bereich.', ' ');
INSERT INTO answer VALUES (175, 44, 2, 'SHF-Bereich.', ' ');
INSERT INTO answer VALUES (176, 44, 3, 'EHF-Bereich.', ' ');
INSERT INTO answer VALUES (177, 45, 0, '83,3 kHz', ' ');
INSERT INTO answer VALUES (178, 45, 1, '833,3 kHz', ' ');
INSERT INTO answer VALUES (179, 45, 2, '8,3 MHz', ' ');
INSERT INTO answer VALUES (180, 45, 3, '83,3 MHz', ' ');
INSERT INTO answer VALUES (181, 46, 0, '8,33 MHz', ' ');
INSERT INTO answer VALUES (182, 46, 1, '16,7 MHz', ' ');
INSERT INTO answer VALUES (183, 46, 2, '8,33 kHz', ' ');
INSERT INTO answer VALUES (184, 46, 3, '833 kHz', ' ');
INSERT INTO answer VALUES (185, 47, 0, '8,5 V', ' ');
INSERT INTO answer VALUES (186, 47, 1, '6,0 V', ' ');
INSERT INTO answer VALUES (187, 47, 2, '17 V', ' ');
INSERT INTO answer VALUES (188, 47, 3, '24 V', ' ');
INSERT INTO answer VALUES (189, 48, 0, '33,9 V', ' ');
INSERT INTO answer VALUES (190, 48, 1, '24 V', ' ');
INSERT INTO answer VALUES (191, 48, 2, '16,97 V', ' ');
INSERT INTO answer VALUES (192, 48, 3, '36,4 V', ' ');
INSERT INTO answer VALUES (193, 49, 0, 'sinusförmig', ' ');
INSERT INTO answer VALUES (194, 49, 1, 'rechteckförmig', ' ');
INSERT INTO answer VALUES (195, 49, 2, 'dreieckförmig', ' ');
INSERT INTO answer VALUES (196, 49, 3, 'kreisförmig', ' ');
INSERT INTO answer VALUES (197, 50, 0, 'aus der Grundwelle mit ganzzahligen Vielfachen dieser Frequenz (Oberwellen).', ' ');
INSERT INTO answer VALUES (198, 50, 1, 'aus der Grundwelle und Teilen dieser Frequenz (Unterwellen).', ' ');
INSERT INTO answer VALUES (199, 50, 2, 'aus nur einer einzigen Frequenz.', ' ');
INSERT INTO answer VALUES (200, 50, 3, 'aus der Grundwelle mit vielen Nebenfrequenzen.', ' ');
INSERT INTO answer VALUES (201, 51, 0, 'AM hat einen Träger und zwei Seitenbänder, SSB arbeitet mit Trägerunterdrückung und einem Seitenband.', ' ');
INSERT INTO answer VALUES (202, 51, 1, 'AM hat einen Träger und ein Seitenband, SSB arbeitet mit Trägerunterdrückung und hat zwei Seitenbänder.', ' ');
INSERT INTO answer VALUES (203, 51, 2, 'AM hat keinen Träger und zwei Seitenbänder, SSB arbeitet mit Trägerunterdrückung und einem Seitenband.', ' ');
INSERT INTO answer VALUES (204, 51, 3, 'AM hat keinen Träger und zwei Seitenbänder, SSB arbeitet mit Träger und einem Seitenband.', ' ');
INSERT INTO answer VALUES (205, 52, 0, 'LSB arbeitet mit Trägerunterdrückung und dem unteren Seitenband, USB arbeitet mit Trägerunterdrückung und dem oberen Seitenband.', ' ');
INSERT INTO answer VALUES (206, 52, 1, 'LSB arbeitet mit Träger und zwei Seitenbändern, USB arbeitet mit Trägerunterdrückung und einem Seitenband.', ' ');
INSERT INTO answer VALUES (207, 52, 2, 'LSB arbeitet mit Träger und einem Seitenband, USB arbeitet mit Trägerunterdrückung und beiden Seitenbändern.', ' ');
INSERT INTO answer VALUES (208, 52, 3, 'LSB arbeitet mit Trägerunterdrückung und dem oberen Seitenband, USB arbeitet mit Trägerunterdrückung und dem unteren Seitenband.', ' ');
INSERT INTO answer VALUES (209, 53, 0, 'Bei FM ändert sich die Amplitude des Sendesignals bei Modulation nicht.', ' ');
INSERT INTO answer VALUES (210, 53, 1, 'Bei SSB ändert sich die Amplitude des Sendesignals bei Modulation nicht.', ' ');
INSERT INTO answer VALUES (211, 53, 2, 'Bei FM ändert sich die Amplitude des Sendesignals bei Modulation im Rhythmus der Sprache.', ' ');
INSERT INTO answer VALUES (212, 53, 3, 'Bei AM ändert sich die Amplitude des Sendesignals bei Modulation nicht.', ' ');
INSERT INTO answer VALUES (213, 54, 0, 'Bei FSK wird der Träger direkt und bei AFSK mit Hilfe des Audiosignals moduliert.', ' ');
INSERT INTO answer VALUES (214, 54, 1, 'Bei FSK wird der Träger frequenzmoduliert und bei AFSK amplitudenmoduliert.', ' ');
INSERT INTO answer VALUES (215, 54, 2, 'Bei FSK wird der Träger frequenzmoduliert und bei AFSK wird der Träger unterdrückt.', ' ');
INSERT INTO answer VALUES (216, 54, 3, 'Bei FSK wird der Träger amplitudenmoduliert und bei AFSK frequenzmoduliert.', ' ');
INSERT INTO answer VALUES (217, 55, 0, 'Sie entspricht genau der Bandbreite des NF-Signals.', ' ');
INSERT INTO answer VALUES (218, 55, 1, 'Sie entspricht der Hälfte der Bandbreite des NF-Signals.', ' ');
INSERT INTO answer VALUES (219, 55, 2, 'Sie entspricht der doppelten Bandbreite des NF-Signals.', ' ');
INSERT INTO answer VALUES (220, 55, 3, 'Sie ist Null, weil bei SSB-Modulation der HF-Träger unterdrückt wird.', ' ');
INSERT INTO answer VALUES (221, 56, 0, '3,648 MHz', ' ');
INSERT INTO answer VALUES (222, 56, 1, '3,650 MHz', ' ');
INSERT INTO answer VALUES (223, 56, 2, '3,652 MHz', ' ');
INSERT INTO answer VALUES (224, 56, 3, '3,648 MHz und 3,652 MHz', ' ');
INSERT INTO answer VALUES (225, 57, 0, 'Watt', ' ');
INSERT INTO answer VALUES (226, 57, 1, 'Joule', ' ');
INSERT INTO answer VALUES (227, 57, 2, 'Kilowattstunden', ' ');
INSERT INTO answer VALUES (228, 57, 3, 'Amperestunden', ' ');
INSERT INTO answer VALUES (229, 58, 0, 'U = R * I', ' ');
INSERT INTO answer VALUES (230, 58, 1, 'R = U * I', ' ');
INSERT INTO answer VALUES (231, 58, 2, 'R = I / U', ' ');
INSERT INTO answer VALUES (232, 58, 3, 'I = R / U', ' ');
INSERT INTO answer VALUES (233, 59, 0, '100 Volt', ' ');
INSERT INTO answer VALUES (234, 59, 1, '200 Volt', ' ');
INSERT INTO answer VALUES (235, 59, 2, '25 Volt', ' ');
INSERT INTO answer VALUES (236, 59, 3, '52 Volt', ' ');
INSERT INTO answer VALUES (237, 60, 0, '30 &Omega;', ' ');
INSERT INTO answer VALUES (238, 60, 1, '1/30 &Omega;', ' ');
INSERT INTO answer VALUES (239, 60, 2, '270 &Omega;', ' ');
INSERT INTO answer VALUES (240, 60, 3, '93 &Omega;', ' ');
INSERT INTO answer VALUES (241, 61, 0, '1,01 kWh', ' ');
INSERT INTO answer VALUES (242, 61, 1, '0,1 kWh', ' ');
INSERT INTO answer VALUES (243, 61, 2, '2,56 kWh', ' ');
INSERT INTO answer VALUES (244, 61, 3, '20,7 kWh', ' ');
INSERT INTO answer VALUES (245, 62, 0, '4 A.', ' ');
INSERT INTO answer VALUES (246, 62, 1, '250 mA.', ' ');
INSERT INTO answer VALUES (247, 62, 2, '750 mA.', ' ');
INSERT INTO answer VALUES (248, 62, 3, '36 A.', ' ');
INSERT INTO answer VALUES (249, 63, 0, '200 W.', ' ');
INSERT INTO answer VALUES (250, 63, 1, '141 W.', ' ');
INSERT INTO answer VALUES (251, 63, 2, '100 W.', ' ');
INSERT INTO answer VALUES (252, 63, 3, '283 W.', ' ');
INSERT INTO answer VALUES (253, 64, 0, '200 W.', ' ');
INSERT INTO answer VALUES (254, 64, 1, '100 W.', ' ');
INSERT INTO answer VALUES (255, 64, 2, '25 W.', ' ');
INSERT INTO answer VALUES (256, 64, 3, '250 W.', ' ');
INSERT INTO answer VALUES (257, 65, 0, '8,33 A', ' ');
INSERT INTO answer VALUES (258, 65, 1, '16,6 A', ' ');
INSERT INTO answer VALUES (259, 65, 2, '1200 A', ' ');
INSERT INTO answer VALUES (260, 65, 3, '0,12 A', ' ');
INSERT INTO answer VALUES (261, 66, 0, '1 W.', ' ');
INSERT INTO answer VALUES (262, 66, 1, '10 W.', ' ');
INSERT INTO answer VALUES (263, 66, 2, '0,01 W.', ' ');
INSERT INTO answer VALUES (264, 66, 3, '100 mW.', ' ');
INSERT INTO answer VALUES (265, 67, 0, '2,5 W', ' ');
INSERT INTO answer VALUES (266, 67, 1, '1 W', ' ');
INSERT INTO answer VALUES (267, 67, 2, '25 W', ' ');
INSERT INTO answer VALUES (268, 67, 3, '250 mW', ' ');
INSERT INTO answer VALUES (269, 68, 0, '47 k&Omega;', ' ');
INSERT INTO answer VALUES (270, 68, 1, '4,7 k&Omega;', ' ');
INSERT INTO answer VALUES (271, 68, 2, '470 k&Omega;', ' ');
INSERT INTO answer VALUES (272, 68, 3, '4,7 M&Omega;', ' ');
INSERT INTO answer VALUES (273, 69, 0, '4,7 k&Omega;', ' ');
INSERT INTO answer VALUES (274, 69, 1, '47 k&Omega;', ' ');
INSERT INTO answer VALUES (275, 69, 2, '470 k&Omega;', ' ');
INSERT INTO answer VALUES (276, 69, 3, '4,7 M&Omega;', ' ');
INSERT INTO answer VALUES (277, 70, 0, '27 k&Omega;', ' ');
INSERT INTO answer VALUES (278, 70, 1, '2,7 k&Omega;', ' ');
INSERT INTO answer VALUES (279, 70, 2, '270 k&Omega;', ' ');
INSERT INTO answer VALUES (280, 70, 3, '2,7 M&Omega;', ' ');
INSERT INTO answer VALUES (281, 71, 0, '2,7 k&Omega;', ' ');
INSERT INTO answer VALUES (282, 71, 1, '27 k&Omega;', ' ');
INSERT INTO answer VALUES (283, 71, 2, '270 k&Omega;', ' ');
INSERT INTO answer VALUES (284, 71, 3, '2,7 M&Omega;', ' ');
INSERT INTO answer VALUES (285, 72, 0, 'NTC', ' ');
INSERT INTO answer VALUES (286, 72, 1, 'PTC', ' ');
INSERT INTO answer VALUES (287, 72, 2, 'LDR', ' ');
INSERT INTO answer VALUES (288, 72, 3, 'VDR', ' ');
INSERT INTO answer VALUES (289, 73, 0, '<img src=''etc106a.png''>', ' ');
INSERT INTO answer VALUES (290, 73, 1, '<img src=''etc106b.png''>', ' ');
INSERT INTO answer VALUES (291, 73, 2, '<img src=''etc106c.png''>', ' ');
INSERT INTO answer VALUES (292, 73, 3, '<img src=''etc106d.png''>', ' ');
INSERT INTO answer VALUES (293, 74, 0, '<img src=''etc107a.png''>', ' ');
INSERT INTO answer VALUES (294, 74, 1, '<img src=''etc107b.png''>', ' ');
INSERT INTO answer VALUES (295, 74, 2, '<img src=''etc107c.png''>', ' ');
INSERT INTO answer VALUES (296, 74, 3, '<img src=''etc107d.png''>', ' ');
INSERT INTO answer VALUES (297, 75, 0, '5040 und 6160 &Omega;.', ' ');
INSERT INTO answer VALUES (298, 75, 1, '4760 und 6440 &Omega;.', ' ');
INSERT INTO answer VALUES (299, 75, 2, '4,7 und 6,8 k&Omega;.', ' ');
INSERT INTO answer VALUES (300, 75, 3, '5,2 und 6,3 k&Omega;.', ' ');
INSERT INTO answer VALUES (301, 76, 0, 'Ein Metalloxidwiderstand', ' ');
INSERT INTO answer VALUES (302, 76, 1, 'Ein Kohleschichtwiderstand', ' ');
INSERT INTO answer VALUES (303, 76, 2, 'Ein keramischer Drahtwiderstand', ' ');
INSERT INTO answer VALUES (304, 76, 3, 'Ein frei gewickelter Drahtwiderstand aus Kupferdraht', ' ');
INSERT INTO answer VALUES (305, 77, 0, '220 &Omega;', ' ');
INSERT INTO answer VALUES (306, 77, 1, '221 &Omega;', ' ');
INSERT INTO answer VALUES (307, 77, 2, '22 &Omega;', ' ');
INSERT INTO answer VALUES (308, 77, 3, '22 k&Omega;', ' ');
INSERT INTO answer VALUES (309, 78, 0, '22 k&Omega;', ' ');
INSERT INTO answer VALUES (310, 78, 1, '221 &Omega;', ' ');
INSERT INTO answer VALUES (311, 78, 2, '22 &Omega;', ' ');
INSERT INTO answer VALUES (312, 78, 3, '220 &Omega;', ' ');
INSERT INTO answer VALUES (313, 79, 0, 'Je größer der Plattenabstand ist, desto kleiner ist die Kapazität.', ' ');
INSERT INTO answer VALUES (314, 79, 1, 'Je größer die angelegte Spannung ist, desto kleiner ist die Kapazität.', ' ');
INSERT INTO answer VALUES (315, 79, 2, 'Je größer die Plattenoberfläche ist, desto kleiner ist die Kapazität.', ' ');
INSERT INTO answer VALUES (316, 79, 3, 'Je größer die Dielektrizitätszahl ist, desto kleiner ist die Kapazität.', ' ');
INSERT INTO answer VALUES (317, 80, 0, 'Drehkondensator.', ' ');
INSERT INTO answer VALUES (318, 80, 1, 'Tauchkondensator.', ' ');
INSERT INTO answer VALUES (319, 80, 2, 'Keramischer Kondensator.', ' ');
INSERT INTO answer VALUES (320, 80, 3, 'Rotorkondensator.', ' ');
INSERT INTO answer VALUES (321, 81, 0, '330 µF', ' ');
INSERT INTO answer VALUES (322, 81, 1, '3,3 µF', ' ');
INSERT INTO answer VALUES (323, 81, 2, '33 µF', ' ');
INSERT INTO answer VALUES (324, 81, 3, '33000 µF', ' ');
INSERT INTO answer VALUES (325, 82, 0, '470 pF', ' ');
INSERT INTO answer VALUES (326, 82, 1, '4,7 pF', ' ');
INSERT INTO answer VALUES (327, 82, 2, '47 pF', ' ');
INSERT INTO answer VALUES (328, 82, 3, '47000 pF', ' ');
INSERT INTO answer VALUES (329, 83, 0, '8,2 pF', ' ');
INSERT INTO answer VALUES (330, 83, 1, '820 pF', ' ');
INSERT INTO answer VALUES (331, 83, 2, '82 pF', ' ');
INSERT INTO answer VALUES (332, 83, 3, '0,82 pF', ' ');
INSERT INTO answer VALUES (333, 84, 0, '0,3 µF', ' ');
INSERT INTO answer VALUES (334, 84, 1, '2,73 nF', ' ');
INSERT INTO answer VALUES (335, 84, 2, '0,027 µF', ' ');
INSERT INTO answer VALUES (336, 84, 3, '0,255 µF', ' ');
INSERT INTO answer VALUES (337, 85, 0, 'Elektrolytkondensator', ' ');
INSERT INTO answer VALUES (338, 85, 1, 'Keramischer Kondensator', ' ');
INSERT INTO answer VALUES (339, 85, 2, 'Styroflexkondensator', ' ');
INSERT INTO answer VALUES (340, 85, 3, 'Plattenkondensator', ' ');
INSERT INTO answer VALUES (341, 86, 0, 'sinkt der Wechselstromwiderstand von Kondensatoren.', ' ');
INSERT INTO answer VALUES (342, 86, 1, 'sinkt der Wechselstromwiderstand von Kondensatoren bis zu einem Minimum und steigt dann wieder.', ' ');
INSERT INTO answer VALUES (343, 86, 2, 'steigt der Wechselstromwiderstand von Kondensatoren.', ' ');
INSERT INTO answer VALUES (344, 86, 3, 'steigt der Wechselstromwiderstand von Kondensatoren bis zu einem Maximum und sinkt dann wieder.', ' ');
INSERT INTO answer VALUES (345, 87, 0, 'Die Induktivität steigt auf 48 µH.', ' ');
INSERT INTO answer VALUES (346, 87, 1, 'Die Induktivität steigt auf 24 µH.', ' ');
INSERT INTO answer VALUES (347, 87, 2, 'Die Induktivität sinkt auf 6 µH.', ' ');
INSERT INTO answer VALUES (348, 87, 3, 'Die Induktivität sinkt auf 3 µH.', ' ');
INSERT INTO answer VALUES (349, 88, 0, 'Die Induktivität sinkt auf 6 µH.', ' ');
INSERT INTO answer VALUES (350, 88, 1, 'Die Induktivität steigt auf 24 µH.', ' ');
INSERT INTO answer VALUES (351, 88, 2, 'Die Induktivität steigt auf 48 µH.', ' ');
INSERT INTO answer VALUES (352, 88, 3, 'Die Induktivität sinkt auf 3 µH.', ' ');
INSERT INTO answer VALUES (353, 89, 0, 'Durch Stauchen der Spule (Verkürzen der Spulenlänge).', ' ');
INSERT INTO answer VALUES (354, 89, 1, 'Durch Auseinanderziehen der Spule (Vergrößerung der Spulenlänge).', ' ');
INSERT INTO answer VALUES (355, 89, 2, 'Durch Einführen eines Kupferkerns in die Spule.', ' ');
INSERT INTO answer VALUES (356, 89, 3, 'Durch Einbau der Spule in einen Abschirmbecher.', ' ');
INSERT INTO answer VALUES (357, 90, 0, 'Ferrit bestehen.', ' ');
INSERT INTO answer VALUES (358, 90, 1, 'Kunststoff bestehen.', ' ');
INSERT INTO answer VALUES (359, 90, 2, 'Stahl bestehen.', ' ');
INSERT INTO answer VALUES (360, 90, 3, 'aus gut leitendem Material bestehen.', ' ');
INSERT INTO answer VALUES (361, 91, 0, 'leuchtet H1 zuerst.', ' ');
INSERT INTO answer VALUES (362, 91, 1, 'leuchtet H2 zuerst.', ' ');
INSERT INTO answer VALUES (363, 91, 2, 'leuchten H1 und H2 genau gleich schnell.', ' ');
INSERT INTO answer VALUES (364, 91, 3, 'leuchtet H2 kurz auf und geht wieder aus. H1 leuchtet.', ' ');
INSERT INTO answer VALUES (365, 92, 0, 'steigt der Wechselstromwiderstand einer Spule.', ' ');
INSERT INTO answer VALUES (366, 92, 1, 'sinkt der Wechselstromwiderstand einer Spule.', ' ');
INSERT INTO answer VALUES (367, 92, 2, 'sinkt der Wechselstromwiderstand einer Spule bis zu einem Minimum und steigt dann wieder.', ' ');
INSERT INTO answer VALUES (368, 92, 3, 'steigt der Wechselstromwiderstand einer Spule bis zu einem Maximum und sinkt dann wieder.', ' ');
INSERT INTO answer VALUES (369, 93, 0, '30 Windungen', ' ');
INSERT INTO answer VALUES (370, 93, 1, '20 Windungen', ' ');
INSERT INTO answer VALUES (371, 93, 2, '52 Windungen', ' ');
INSERT INTO answer VALUES (372, 93, 3, '180 Windungen', ' ');
INSERT INTO answer VALUES (373, 94, 0, '600 Windungen', ' ');
INSERT INTO answer VALUES (374, 94, 1, '850 Windungen', ' ');
INSERT INTO answer VALUES (375, 94, 2, '46 Windungen', ' ');
INSERT INTO answer VALUES (376, 94, 3, '30 Windungen', ' ');
INSERT INTO answer VALUES (377, 95, 0, '46 Volt', ' ');
INSERT INTO answer VALUES (378, 95, 1, '9,2 Volt', ' ');
INSERT INTO answer VALUES (379, 95, 2, '23 Volt', ' ');
INSERT INTO answer VALUES (380, 95, 3, '1150 Volt', ' ');
INSERT INTO answer VALUES (381, 96, 0, 'weniger als vier Valenzelektronen enthält.', ' ');
INSERT INTO answer VALUES (382, 96, 1, 'mehr als vier Valenzelektronen enthält.', ' ');
INSERT INTO answer VALUES (383, 96, 2, 'genau vier Valenzelektronen enthält.', ' ');
INSERT INTO answer VALUES (384, 96, 3, 'keine Valenzelektronen enthält.', ' ');
INSERT INTO answer VALUES (385, 97, 0, 'Überschuss an freien Elektronen.', ' ');
INSERT INTO answer VALUES (386, 97, 1, 'das Fehlen von Dotierungsatomen.', ' ');
INSERT INTO answer VALUES (387, 97, 2, 'das Fehlen von Atomen im Gitter des Halbleiterkristalls.', ' ');
INSERT INTO answer VALUES (388, 97, 3, 'bewegliche Elektronenlücken.', ' ');
INSERT INTO answer VALUES (389, 98, 0, 'den Stromfluss von P nach N.', ' ');
INSERT INTO answer VALUES (390, 98, 1, 'den Stromfluss von N nach P.', ' ');
INSERT INTO answer VALUES (391, 98, 2, 'keinen Stromfluss.', ' ');
INSERT INTO answer VALUES (392, 98, 3, 'den Elektronenfluss von P nach N.', ' ');
INSERT INTO answer VALUES (393, 99, 0, 'einen hohen Widerstand.', ' ');
INSERT INTO answer VALUES (394, 99, 1, 'eine hohe Kapazität.', ' ');
INSERT INTO answer VALUES (395, 99, 2, 'eine geringe Impedanz.', ' ');
INSERT INTO answer VALUES (396, 99, 3, 'eine hohe Induktivität.', ' ');
INSERT INTO answer VALUES (397, 100, 0, '0,7 V <img src=''etc505a.png''>1,3 V', ' ');
INSERT INTO answer VALUES (398, 100, 1, '-2,6 V <img src=''etc505b.png''> -2,0 V', ' ');
INSERT INTO answer VALUES (399, 100, 2, '15 V <img src=''etc505a.png''> 9 V', ' ');
INSERT INTO answer VALUES (400, 100, 3, '3,4 V <img src=''etc505b.png''> 4,0 V', ' ');
INSERT INTO answer VALUES (401, 101, 0, '-2 V <img src=''etc505b.png''> -2,6 V', ' ');
INSERT INTO answer VALUES (402, 101, 1, '5,3 V <img src=''etc505a.png''> 4,7 V', ' ');
INSERT INTO answer VALUES (403, 101, 2, '15 V <img src=''etc505b.png''> 18 V', ' ');
INSERT INTO answer VALUES (404, 101, 3, '3,9 V <img src=''etc505a.png''> 3,2 V', ' ');
INSERT INTO answer VALUES (405, 102, 0, 'Sie nimmt mit abnehmender Sperrspannung zu.', ' ');
INSERT INTO answer VALUES (406, 102, 1, 'Sie erhöht sich mit zunehmender Durchlassspannung.', ' ');
INSERT INTO answer VALUES (407, 102, 2, 'Sie nimmt mit zunehmender Sperrspannung zu.', ' ');
INSERT INTO answer VALUES (408, 102, 3, 'Sie erhöht sich mit zunehmendem Durchlassstrom.', ' ');
INSERT INTO answer VALUES (409, 103, 0, 'zur Spannungsstabilisierung.', ' ');
INSERT INTO answer VALUES (410, 103, 1, 'zur Signalbegrenzung.', ' ');
INSERT INTO answer VALUES (411, 103, 2, 'als Leuchtanzeige.', ' ');
INSERT INTO answer VALUES (412, 103, 3, 'zur Stromgewinnung.', ' ');
INSERT INTO answer VALUES (413, 104, 0, 'als Leuchtanzeige.', ' ');
INSERT INTO answer VALUES (414, 104, 1, 'zur Signalbegrenzung.', ' ');
INSERT INTO answer VALUES (415, 104, 2, 'zur Spannungsstabilisierung.', ' ');
INSERT INTO answer VALUES (416, 104, 3, 'zur Stromgewinnung.', ' ');
INSERT INTO answer VALUES (417, 105, 0, 'Mit einem geringen Strom (Basisstrom) wird ein großer Strom (Kollektorstrom) gesteuert.', ' ');
INSERT INTO answer VALUES (418, 105, 1, 'Mit einem geringen Strom (Emitterstrom) wird ein großer Strom (Kollektorstrom) gesteuert.', ' ');
INSERT INTO answer VALUES (419, 105, 2, 'Mit einem geringen Strom (Emitterstrom) wird ein großer Strom (Basisstrom) gesteuert.', ' ');
INSERT INTO answer VALUES (420, 105, 3, 'Mit einem geringen Strom (Kollektorstrom) wird ein großer Strom (Emitterstrom) gesteuert.', ' ');
INSERT INTO answer VALUES (421, 106, 0, '10 zu 1 bis 900 zu 1.', ' ');
INSERT INTO answer VALUES (422, 106, 1, '1 zu 50 bis 1 zu 100.', ' ');
INSERT INTO answer VALUES (423, 106, 2, '1000 zu 1 bis 5000 zu 1.', ' ');
INSERT INTO answer VALUES (424, 106, 3, '1 zu 100 bis 1 zu 500.', ' ');
INSERT INTO answer VALUES (425, 107, 0, 'NPN-Transistor.', ' ');
INSERT INTO answer VALUES (426, 107, 1, 'PNP-Transistor.', ' ');
INSERT INTO answer VALUES (427, 107, 2, 'Sperrschicht-FET.', ' ');
INSERT INTO answer VALUES (428, 107, 3, 'MOSFET.', ' ');
INSERT INTO answer VALUES (429, 108, 0, 'PNP-Transistor.', ' ');
INSERT INTO answer VALUES (430, 108, 1, 'NPN-Transistor.', ' ');
INSERT INTO answer VALUES (431, 108, 2, 'P-Kanal-FET.', ' ');
INSERT INTO answer VALUES (432, 108, 3, 'N-Kanal-FET.', ' ');
INSERT INTO answer VALUES (433, 109, 0, 'NPN-Transistoren benötigen positive, PNP-Transistoren negative Kollektorspannungen.', ' ');
INSERT INTO answer VALUES (434, 109, 1, 'NPN- und PNP-Transistoren benötigen negative Kollektorspannungen.', ' ');
INSERT INTO answer VALUES (435, 109, 2, 'PNP-Transistoren benötigen positive, NPN-Transistoren negative Kollektorspannung.', ' ');
INSERT INTO answer VALUES (436, 109, 3, 'PNP- und NPN-Transistoren benötigen positive Kollektorspannungen.', ' ');
INSERT INTO answer VALUES (437, 110, 0, 'in Durchlassrichtung.', ' ');
INSERT INTO answer VALUES (438, 110, 1, 'im Leerlauf.', ' ');
INSERT INTO answer VALUES (439, 110, 2, 'im Kurzschluss.', ' ');
INSERT INTO answer VALUES (440, 110, 3, 'in Sperrrichtung.', ' ');
INSERT INTO answer VALUES (441, 111, 0, 'NPN- und PNP-Transistoren', ' ');
INSERT INTO answer VALUES (442, 111, 1, 'Dual-Gate-MOS-FETs', ' ');
INSERT INTO answer VALUES (443, 111, 2, 'Isolierschicht-FETs', ' ');
INSERT INTO answer VALUES (444, 111, 3, 'Sperrschicht-FETs', ' ');
INSERT INTO answer VALUES (445, 112, 0, 'Emitter, Basis, Kollektor', ' ');
INSERT INTO answer VALUES (446, 112, 1, 'Emitter, Drain, Source', ' ');
INSERT INTO answer VALUES (447, 112, 2, 'Drain, Source, Kollektor', ' ');
INSERT INTO answer VALUES (448, 112, 3, 'Drain, Gate, Source', ' ');
INSERT INTO answer VALUES (449, 113, 0, 'stromgesteuert.', ' ');
INSERT INTO answer VALUES (450, 113, 1, 'spannungsgesteuert.', ' ');
INSERT INTO answer VALUES (451, 113, 2, 'thermisch gesteuert.', ' ');
INSERT INTO answer VALUES (452, 113, 3, 'ein Gleichspannungsverstärker.', ' ');
INSERT INTO answer VALUES (453, 114, 0, 'fließt kein Kollektorstrom.', ' ');
INSERT INTO answer VALUES (454, 114, 1, 'fließt ein Kollektorstrom von etwa 0,6 A.', ' ');
INSERT INTO answer VALUES (455, 114, 2, 'liegt der Kollektorstrom zwischen 10 mA und 2 A.', ' ');
INSERT INTO answer VALUES (456, 114, 3, 'fließt ein sehr hoher Kollektor-Kurzschlussstrom.', ' ');
INSERT INTO answer VALUES (457, 115, 0, 'Die Gatespannung steuert den Widerstand des Kanals zwischen Source und Drain.', ' ');
INSERT INTO answer VALUES (458, 115, 1, 'Die Gatespannung ist allein verantwortlich für den Drainstrom.', ' ');
INSERT INTO answer VALUES (459, 115, 2, 'Der Gatestrom ist allein verantwortlich für den Drainstrom.', ' ');
INSERT INTO answer VALUES (460, 115, 3, 'Der Gatestrom steuert den Widerstand des Kanals zwischen Source und Drain.', ' ');
INSERT INTO answer VALUES (461, 116, 0, '1 ... Drain, 2 … Source, 3 … Gate.', ' ');
INSERT INTO answer VALUES (462, 116, 1, '1 ... Source, 2 … Drain, 3 … Gate.', ' ');
INSERT INTO answer VALUES (463, 116, 2, '1 ... Anode, 2 … Katode, 3 … Gate.', ' ');
INSERT INTO answer VALUES (464, 116, 3, '1 ... Kollektor, 2 … Emitter, 3 … Basis.', ' ');
INSERT INTO answer VALUES (465, 117, 0, '1 k&Omega;', ' ');
INSERT INTO answer VALUES (466, 117, 1, '2,5 k&Omega;', ' ');
INSERT INTO answer VALUES (467, 117, 2, '501 &Omega;', ' ');
INSERT INTO answer VALUES (468, 117, 3, '5,1 k&Omega;', ' ');
INSERT INTO answer VALUES (469, 118, 0, '2 k&Omega;', ' ');
INSERT INTO answer VALUES (470, 118, 1, '2,5 k&Omega;', ' ');
INSERT INTO answer VALUES (471, 118, 2, '501 &Omega;', ' ');
INSERT INTO answer VALUES (472, 118, 3, '5,1 k&Omega;', ' ');
INSERT INTO answer VALUES (473, 119, 0, '500 &Omega;', ' ');
INSERT INTO answer VALUES (474, 119, 1, '250 &Omega;', ' ');
INSERT INTO answer VALUES (475, 119, 2, '1 k&Omega;', ' ');
INSERT INTO answer VALUES (476, 119, 3, '2 k&Omega;', ' ');
INSERT INTO answer VALUES (477, 120, 0, '1 k&Omega;', ' ');
INSERT INTO answer VALUES (478, 120, 1, '4 k&Omega;', ' ');
INSERT INTO answer VALUES (479, 120, 2, '500 &Omega;', ' ');
INSERT INTO answer VALUES (480, 120, 3, '2 k&Omega;', ' ');
INSERT INTO answer VALUES (481, 121, 0, '5 nF', ' ');
INSERT INTO answer VALUES (482, 121, 1, '0,015 nF', ' ');
INSERT INTO answer VALUES (483, 121, 2, '7,5 nF', ' ');
INSERT INTO answer VALUES (484, 121, 3, '10 nF', ' ');
INSERT INTO answer VALUES (485, 122, 0, '10 nF', ' ');
INSERT INTO answer VALUES (486, 122, 1, '5 nF', ' ');
INSERT INTO answer VALUES (487, 122, 2, '2,5 nF', ' ');
INSERT INTO answer VALUES (488, 122, 3, '40 nF', ' ');
INSERT INTO answer VALUES (489, 123, 0, '10 nF', ' ');
INSERT INTO answer VALUES (490, 123, 1, '5 nF', ' ');
INSERT INTO answer VALUES (491, 123, 2, '2,5 nF', ' ');
INSERT INTO answer VALUES (492, 123, 3, '0,015 nF', ' ');
INSERT INTO answer VALUES (493, 124, 0, '2,20 V', ' ');
INSERT INTO answer VALUES (494, 124, 1, '2,64 V', ' ');
INSERT INTO answer VALUES (495, 124, 2, '10,0 V', ' ');
INSERT INTO answer VALUES (496, 124, 3, '1,22 V', ' ');
INSERT INTO answer VALUES (497, 125, 0, '12 &Omega;', ' ');
INSERT INTO answer VALUES (498, 125, 1, '50 &Omega;', ' ');
INSERT INTO answer VALUES (499, 125, 2, '15 &Omega;', ' ');
INSERT INTO answer VALUES (500, 125, 3, '3,5 &Omega;', ' ');
INSERT INTO answer VALUES (501, 126, 0, '60 &Omega;', ' ');
INSERT INTO answer VALUES (502, 126, 1, '250 &Omega;', ' ');
INSERT INTO answer VALUES (503, 126, 2, '75 &Omega;', ' ');
INSERT INTO answer VALUES (504, 126, 3, '17,5 &Omega;', ' ');
INSERT INTO answer VALUES (505, 127, 0, 'eines Serienschwingkreises.', ' ');
INSERT INTO answer VALUES (506, 127, 1, 'eines Parallelschwingkreises.', ' ');
INSERT INTO answer VALUES (507, 127, 2, 'einer Induktivität.', ' ');
INSERT INTO answer VALUES (508, 127, 3, 'einer Kapazität.', ' ');
INSERT INTO answer VALUES (509, 128, 0, 'einen Parallelschwingkreis.', ' ');
INSERT INTO answer VALUES (510, 128, 1, 'einen Kondensator.', ' ');
INSERT INTO answer VALUES (511, 128, 2, 'eine Spule.', ' ');
INSERT INTO answer VALUES (512, 128, 3, 'einen Serienschwingkreis.', ' ');
INSERT INTO answer VALUES (513, 129, 0, '<img src=''etd203a.png''>', ' ');
INSERT INTO answer VALUES (514, 129, 1, '<img src=''etd203b.png''>', ' ');
INSERT INTO answer VALUES (515, 129, 2, '<img src=''etd203c.png''>', ' ');
INSERT INTO answer VALUES (516, 129, 3, '<img src=''etd203d.png''>', ' ');
INSERT INTO answer VALUES (517, 130, 0, 'Die Resonanzfrequenz wird bei 1. größer und bei 2. und 3. kleiner.', ' ');
INSERT INTO answer VALUES (518, 130, 1, 'Die Resonanzfrequenz wird bei 1. und 2. kleiner und bei 3. größer.', ' ');
INSERT INTO answer VALUES (519, 130, 2, 'Die Resonanzfrequenz wird bei 1. kleiner und bei 2. und 3. größer.', ' ');
INSERT INTO answer VALUES (520, 130, 3, 'Die Resonanzfrequenz wird bei 1. und 2. größer und bei 3. kleiner.', ' ');
INSERT INTO answer VALUES (521, 131, 0, 'Wie ein hochohmiger Widerstand.', ' ');
INSERT INTO answer VALUES (522, 131, 1, 'Wie ein niederohmiger Widerstand.', ' ');
INSERT INTO answer VALUES (523, 131, 2, 'Wie ein Kondensator mit sehr kleiner Kapazität.', ' ');
INSERT INTO answer VALUES (524, 131, 3, 'Wie eine Spule mit sehr großer Induktivität.', ' ');
INSERT INTO answer VALUES (525, 132, 0, 'Hochpass', ' ');
INSERT INTO answer VALUES (526, 132, 1, 'Sperrkreis', ' ');
INSERT INTO answer VALUES (527, 132, 2, 'Bandpass', ' ');
INSERT INTO answer VALUES (528, 132, 3, 'Tiefpass', ' ');
INSERT INTO answer VALUES (529, 133, 0, 'Sperrkreis', ' ');
INSERT INTO answer VALUES (530, 133, 1, 'Saugkreis', ' ');
INSERT INTO answer VALUES (531, 133, 2, 'Bandpass', ' ');
INSERT INTO answer VALUES (532, 133, 3, 'Tiefpass', ' ');
INSERT INTO answer VALUES (533, 134, 0, 'Tiefpass', ' ');
INSERT INTO answer VALUES (534, 134, 1, 'Sperrkreis', ' ');
INSERT INTO answer VALUES (535, 134, 2, 'Bandpass', ' ');
INSERT INTO answer VALUES (536, 134, 3, 'Hochpass', ' ');
INSERT INTO answer VALUES (537, 135, 0, 'Saugkreis', ' ');
INSERT INTO answer VALUES (538, 135, 1, 'Sperrkreis', ' ');
INSERT INTO answer VALUES (539, 135, 2, 'Bandpass', ' ');
INSERT INTO answer VALUES (540, 135, 3, 'Tiefpass', ' ');
INSERT INTO answer VALUES (541, 136, 0, 'Frequenzen oberhalb der Grenzfrequenz werden durchgelassen.', ' ');
INSERT INTO answer VALUES (542, 136, 1, 'Frequenzen unterhalb der Grenzfrequenz werden verstärkt.', ' ');
INSERT INTO answer VALUES (543, 136, 2, 'Frequenzen oberhalb der Grenzfrequenz werden stark bedämpft.', ' ');
INSERT INTO answer VALUES (544, 136, 3, 'Frequenzen unterhalb der Grenzfrequenz werden ungedämpft durchgelassen.', ' ');
INSERT INTO answer VALUES (545, 137, 0, 'Spannungsquellen sollten einen möglichst niedrigen Innenwiderstand und Stromquellen einen möglichst hohen Innenwiderstand haben.', ' ');
INSERT INTO answer VALUES (546, 137, 1, 'Strom- und Spannungsquellen sollten einen möglichst niedrigen Innenwiderstand haben.', ' ');
INSERT INTO answer VALUES (547, 137, 2, 'Strom- und Spannungsquellen sollten einen möglichst hohen Innenwiderstand haben.', ' ');
INSERT INTO answer VALUES (548, 137, 3, 'Spannungsquellen sollten einen möglichst hohen Innenwiderstand und Stromquellen einen möglichst niedrigen Innenwiderstand haben.', ' ');
INSERT INTO answer VALUES (549, 138, 0, '1,1 &Omega;', ' ');
INSERT INTO answer VALUES (550, 138, 1, '13,5 &Omega;', ' ');
INSERT INTO answer VALUES (551, 138, 2, '12,4 &Omega;', ' ');
INSERT INTO answer VALUES (552, 138, 3, '1,2 &Omega;', ' ');
INSERT INTO answer VALUES (553, 139, 0, '0,25 &Omega;', ' ');
INSERT INTO answer VALUES (554, 139, 1, '6,75 &Omega;', ' ');
INSERT INTO answer VALUES (555, 139, 2, '13 &Omega;', ' ');
INSERT INTO answer VALUES (556, 139, 3, '6,5 &Omega;', ' ');
INSERT INTO answer VALUES (557, 140, 0, 'Zirka 65 Volt', ' ');
INSERT INTO answer VALUES (558, 140, 1, 'Zirka 46 Volt', ' ');
INSERT INTO answer VALUES (559, 140, 2, 'Zirka 40 Volt', ' ');
INSERT INTO answer VALUES (560, 140, 3, 'Zirka 28 Volt', ' ');
INSERT INTO answer VALUES (561, 141, 0, 'Zirka 40 Volt', ' ');
INSERT INTO answer VALUES (562, 141, 1, 'Zirka 46 Volt', ' ');
INSERT INTO answer VALUES (563, 141, 2, 'Zirka 65 Volt', ' ');
INSERT INTO answer VALUES (564, 141, 3, 'Zirka 28 Volt', ' ');
INSERT INTO answer VALUES (565, 142, 0, 'Ein Schaltnetzteil erzeugt Oberwellen seiner Taktfrequenz, die beim Empfang zu Störungen führen können.', ' ');
INSERT INTO answer VALUES (566, 142, 1, 'Ein Schaltnetzteil benötigt einen größeren Transformator.', ' ');
INSERT INTO answer VALUES (567, 142, 2, 'Ein Schaltnetzteil kann keine so hohen Ströme abgeben.', ' ');
INSERT INTO answer VALUES (568, 142, 3, 'Ein Schaltnetzteil hat höhere Verluste.', ' ');
INSERT INTO answer VALUES (569, 143, 0, 'Transistor, MOSFET, Operationsverstärker, Röhre', ' ');
INSERT INTO answer VALUES (570, 143, 1, 'Transistor, Halbleiterdiode, Operationsverstärker, Röhre', ' ');
INSERT INTO answer VALUES (571, 143, 2, 'Transistor, Varicap-Diode, Operationsverstärker, Röhre', ' ');
INSERT INTO answer VALUES (572, 143, 3, 'Transistor, MOSFET, Halbleiterdiode, Röhre', ' ');
INSERT INTO answer VALUES (573, 144, 0, 'das Ausgangssignal gegenüber dem Eingangssignal in der Leistung größer ist.', ' ');
INSERT INTO answer VALUES (574, 144, 1, 'das Eingangssignal gegenüber dem Ausgangssignal in der Leistung größer ist.', ' ');
INSERT INTO answer VALUES (575, 144, 2, 'z.B. bei einem Transformator die Ausgangsspannung größer ist als die Eingangsspannung.', ' ');
INSERT INTO answer VALUES (576, 144, 3, 'das Eingangssignal gegenüber dem Ausgangssignal in der Spannung größer ist.', ' ');
INSERT INTO answer VALUES (577, 145, 0, 'Operationsverstärker sind Gleichstrom gekoppelte Verstärker mit sehr hohem Verstärkungsfaktor und großer Linearität.', ' ');
INSERT INTO answer VALUES (578, 145, 1, 'Operationsverstärker sind Wechselstrom gekoppelte Verstärker mit niedrigem Eingangswiderstand und großer Linearität.', ' ');
INSERT INTO answer VALUES (579, 145, 2, 'Operationsverstärker sind in Empfängerstufen eingebaute Analogverstärker mit sehr niedrigem Verstärkungsfaktor aber großer Linearität.', ' ');
INSERT INTO answer VALUES (580, 145, 3, 'Operationsverstärker sind digitale Schaltkreise mit hohem Verstärkungsfaktor.', ' ');
INSERT INTO answer VALUES (581, 146, 0, 'eine komplexe Schaltung auf einem Halbleiterkristallplättchen.', ' ');
INSERT INTO answer VALUES (582, 146, 1, 'eine aus vielen einzelnen Bauteilen aufgebaute Schaltung auf einer Platine.', ' ');
INSERT INTO answer VALUES (583, 146, 2, 'eine miniaturisierte, aus SMD-Bauteilen aufgebaute Schaltung.', ' ');
INSERT INTO answer VALUES (584, 146, 3, 'eine Zusammenschaltung verschiedener Baugruppen zu einer Funktionseinheit.', ' ');
INSERT INTO answer VALUES (585, 147, 0, 'Das von der Gitterspannung hervorgerufene elektrische Feld steuert den Anodenstrom.', ' ');
INSERT INTO answer VALUES (586, 147, 1, 'Die Anodenspannung steuert das magnetische Feld an der Anode und damit den Anodenstrom.', ' ');
INSERT INTO answer VALUES (587, 147, 2, 'Die Heizspannung steuert das elektrische Feld an der Kathode und damit den Anodenstrom.', ' ');
INSERT INTO answer VALUES (588, 147, 3, 'Die Katodenvorspannung steuert das magnetische Feld an der Kathode und damit den Gitterstrom.', ' ');
INSERT INTO answer VALUES (589, 148, 0, 'werden Informationen auf einen oder mehrere Träger übertragen.', ' ');
INSERT INTO answer VALUES (590, 148, 1, 'wird einem oder mehreren Trägern Informationen entnommen.', ' ');
INSERT INTO answer VALUES (591, 148, 2, 'werden Sprach- und CW-Signale kombiniert.', ' ');
INSERT INTO answer VALUES (592, 148, 3, 'werden dem Signal NF-Komponenten entnommen.', ' ');
INSERT INTO answer VALUES (593, 149, 0, 'wird die Frequenz des Trägers beeinflusst. Die Amplitude des Trägers bleibt dabei konstant.', ' ');
INSERT INTO answer VALUES (594, 149, 1, 'wird die Amplitude des Trägers beeinflusst. Die Frequenz des Trägers bleibt dabei konstant.', ' ');
INSERT INTO answer VALUES (595, 149, 2, 'werden gleichzeitig Frequenz und Amplitude des Trägers beeinflusst.', ' ');
INSERT INTO answer VALUES (596, 149, 3, 'findet keinerlei Beeinflussung von Trägerfrequenz oder Trägeramplitude statt. Die Information steuert nur die Kapazität des Oszillators.', ' ');
INSERT INTO answer VALUES (597, 150, 0, 'der Träger und ein Seitenband unterdrückt oder ausgefiltert werden.', ' ');
INSERT INTO answer VALUES (598, 150, 1, 'der Träger hinzugesetzt und ein Seitenband ausgefiltert werden.', ' ');
INSERT INTO answer VALUES (599, 150, 2, 'der Träger unterdrückt und ein Seitenband hinzugesetzt werden.', ' ');
INSERT INTO answer VALUES (600, 150, 3, 'der Träger unterdrückt und beide Seitenbänder ausgefiltert werden.', ' ');
INSERT INTO answer VALUES (601, 151, 0, 'Im Balancemodulator wird ein Zweiseitenband- Signal erzeugt. Das Seitenbandfilter selektiert ein Seitenband heraus.', ' ');
INSERT INTO answer VALUES (602, 151, 1, 'Im Balancemodulator wird ein Zweiseitenband- Signal erzeugt. Ein auf die Trägerfrequenz abgestimmter Saugkreis filtert den Träger aus.', ' ');
INSERT INTO answer VALUES (603, 151, 2, 'Im Balancemodulator wird ein Einseitenband- Signal erzeugt. Ein auf die Trägerfrequenz abgestimmter Sperrkreis filtert den Träger aus.', ' ');
INSERT INTO answer VALUES (604, 151, 3, 'Im Balancemodulator wird ein Zweiseitenband- Signal erzeugt. In einem Frequenzteiler wird ein Seitenband abgespalten.', ' ');
INSERT INTO answer VALUES (605, 152, 0, 'Es ist ein Schwingungserzeuger.', ' ');
INSERT INTO answer VALUES (606, 152, 1, 'Es ist ein sehr schmales Filter.', ' ');
INSERT INTO answer VALUES (607, 152, 2, 'Es ist ein Messgerät zur Anzeige von Schwingungen.', ' ');
INSERT INTO answer VALUES (608, 152, 3, 'Es ist ein FM-Modulator.', ' ');
INSERT INTO answer VALUES (609, 153, 0, 'von einer Spule und einem Kondensator (LC-Schwingkreis) bestimmt wird.', ' ');
INSERT INTO answer VALUES (610, 153, 1, 'durch einen hochstabilen Quarz bestimmt wird.', ' ');
INSERT INTO answer VALUES (611, 153, 2, 'mittels LC-Tiefpass gefiltert wird.', ' ');
INSERT INTO answer VALUES (612, 153, 3, 'mittels LC-Hochpass gefiltert wird.', ' ');
INSERT INTO answer VALUES (613, 154, 0, 'durch einen hochstabilen Quarz bestimmt wird.', ' ');
INSERT INTO answer VALUES (614, 154, 1, 'allein durch einen Quarz erzeugt wird.', ' ');
INSERT INTO answer VALUES (615, 154, 2, 'mittels Quarz-Tiefpass gefiltert wird.', ' ');
INSERT INTO answer VALUES (616, 154, 3, 'mittels Quarz-Hochpass gefiltert wird.', ' ');
INSERT INTO answer VALUES (617, 155, 0, 'Die Frequenz wird erhöht.', ' ');
INSERT INTO answer VALUES (618, 155, 1, 'Die Schwingungen reißen ab (Aussetzer).', ' ');
INSERT INTO answer VALUES (619, 155, 2, 'Die Frequenz wird niedriger.', ' ');
INSERT INTO answer VALUES (620, 155, 3, 'Die Frequenz bleibt stabil.', ' ');
INSERT INTO answer VALUES (621, 156, 0, 'Die VFO-Frequenz wandert nach unten.', ' ');
INSERT INTO answer VALUES (622, 156, 1, 'Die VFO-Frequenz wandert nach oben.', ' ');
INSERT INTO answer VALUES (623, 156, 2, 'Die VFO-Ausgangsspannung nimmt zu.', ' ');
INSERT INTO answer VALUES (624, 156, 3, 'Die VFO-Ausgangsspannung nimmt ab.', ' ');
INSERT INTO answer VALUES (625, 157, 0, 'eine bessere Frequenzstabilität aufweisen.', ' ');
INSERT INTO answer VALUES (626, 157, 1, 'eine breitere Resonanzkurve haben.', ' ');
INSERT INTO answer VALUES (627, 157, 2, 'einen geringeren Anteil an Oberwellen erzeugen.', ' ');
INSERT INTO answer VALUES (628, 157, 3, 'ein sehr viel geringes Seitenbandrauschen erzeugen.', ' ');
INSERT INTO answer VALUES (629, 158, 0, 'Die Sendeart J3E beansprucht weniger als die halbe Bandbreite der Sendeart A3E.', ' ');
INSERT INTO answer VALUES (630, 158, 1, 'Die Sendeart J3E beansprucht etwas mehr als die halbe Bandbreite der Sendeart A3E.', ' ');
INSERT INTO answer VALUES (631, 158, 2, 'Die Sendeart J3E beansprucht etwa 1/4 Bandbreite der Sendeart A3E.', ' ');
INSERT INTO answer VALUES (632, 158, 3, 'Die unterschiedlichen Modulationsarten lassen keinen Vergleich zu, da sie grundverschieden erzeugt werden.', ' ');
INSERT INTO answer VALUES (633, 159, 0, 'FM', ' ');
INSERT INTO answer VALUES (634, 159, 1, 'SSB', ' ');
INSERT INTO answer VALUES (635, 159, 2, 'DSB', ' ');
INSERT INTO answer VALUES (636, 159, 3, 'AM', ' ');
INSERT INTO answer VALUES (637, 160, 0, '50 %.', ' ');
INSERT INTO answer VALUES (638, 160, 1, '33 %.', ' ');
INSERT INTO answer VALUES (639, 160, 2, '67 %.', ' ');
INSERT INTO answer VALUES (640, 160, 3, '75 %.', ' ');
INSERT INTO answer VALUES (641, 161, 0, '45 %.', ' ');
INSERT INTO answer VALUES (642, 161, 1, '55 %.', ' ');
INSERT INTO answer VALUES (643, 161, 2, '30 %.', ' ');
INSERT INTO answer VALUES (644, 161, 3, '75 %.', ' ');
INSERT INTO answer VALUES (645, 162, 0, 'ein typisches Zweiton-SSB-Testsignal.', ' ');
INSERT INTO answer VALUES (646, 162, 1, 'ein typisches Einton-FM-Testsignal.', ' ');
INSERT INTO answer VALUES (647, 162, 2, 'ein typisches 100%-AM-Signal.', ' ');
INSERT INTO answer VALUES (648, 162, 3, 'ein typisches CW-Signal.', ' ');
INSERT INTO answer VALUES (649, 163, 0, 'Man kann keinen Modulationsgrad bestimmen, da es keinen Träger gibt.', ' ');
INSERT INTO answer VALUES (650, 163, 1, 'Er beträgt 100 %.', ' ');
INSERT INTO answer VALUES (651, 163, 2, 'Er beträgt 0 %.', ' ');
INSERT INTO answer VALUES (652, 163, 3, 'Er beträgt ca. 50 %.', ' ');
INSERT INTO answer VALUES (653, 164, 0, 'Durch die Größe der Trägerfrequenzauslenkung.', ' ');
INSERT INTO answer VALUES (654, 164, 1, 'Durch die Geschwindigkeit der Trägerfrequenzänderung.', ' ');
INSERT INTO answer VALUES (655, 164, 2, 'Durch die Änderung der Geschwindigkeit des Frequenzhubes.', ' ');
INSERT INTO answer VALUES (656, 164, 3, 'Durch die Größe der Amplitude des HF-Signals.', ' ');
INSERT INTO answer VALUES (657, 165, 0, 'geringeren Beeinflussung durch Störquellen.', ' ');
INSERT INTO answer VALUES (658, 165, 1, 'geringen Anforderungen an die Bandbreite.', ' ');
INSERT INTO answer VALUES (659, 165, 2, 'größeren Entfernungsüberbrückung.', ' ');
INSERT INTO answer VALUES (660, 165, 3, 'besseren Kreisgüte.', ' ');
INSERT INTO answer VALUES (661, 166, 0, 'dass die HF-Bandbreite zu groß wird.', ' ');
INSERT INTO answer VALUES (662, 166, 1, 'dass die Sendeendstufe übersteuert wird.', ' ');
INSERT INTO answer VALUES (663, 166, 2, 'dass Verzerrungen auf Grund unerwünschter Unterdrückung der Trägerfrequenz auftreten.', ' ');
INSERT INTO answer VALUES (664, 166, 3, 'dass Verzerrungen auf Grund gegenseitiger Auslöschung der Seitenbänder auftreten.', ' ');
INSERT INTO answer VALUES (665, 167, 0, 'einer größeren HF-Bandbreite.', ' ');
INSERT INTO answer VALUES (666, 167, 1, 'einer Erhöhung der Senderausgangsleistung.', ' ');
INSERT INTO answer VALUES (667, 167, 2, 'einer Erhöhung der Amplitude der Trägerfrequenz.', ' ');
INSERT INTO answer VALUES (668, 167, 3, 'einer Reduktion der Amplituden der Seitenbänder.', ' ');
INSERT INTO answer VALUES (669, 168, 0, '12 kHz', ' ');
INSERT INTO answer VALUES (670, 168, 1, '25 kHz', ' ');
INSERT INTO answer VALUES (671, 168, 2, 'ca. 6,6 kHz', ' ');
INSERT INTO answer VALUES (672, 168, 3, 'ca. 3 kHz', ' ');
INSERT INTO answer VALUES (673, 169, 0, '20 kHz', ' ');
INSERT INTO answer VALUES (674, 169, 1, '12,5 kHz', ' ');
INSERT INTO answer VALUES (675, 169, 2, 'ca. 6,6 kHz', ' ');
INSERT INTO answer VALUES (676, 169, 3, 'ca. 3 kHz', ' ');
INSERT INTO answer VALUES (677, 170, 0, '1200 / 2200 Hz', ' ');
INSERT INTO answer VALUES (678, 170, 1, '850 / 1200 kHz', ' ');
INSERT INTO answer VALUES (679, 170, 2, '500 / 1750 Hz', ' ');
INSERT INTO answer VALUES (680, 170, 3, '300 / 2700 Hz', ' ');
INSERT INTO answer VALUES (681, 171, 0, 'besteht aus einem Modem und dem Controller für die digitale Aufbereitung der Daten.', ' ');
INSERT INTO answer VALUES (682, 171, 1, 'wandelt nur die Töne in digitale Daten und schickt diese an den PC.', ' ');
INSERT INTO answer VALUES (683, 171, 2, 'wandelt nur die Töne in digitale Daten und schickt diese an den Sender.', ' ');
INSERT INTO answer VALUES (684, 171, 3, 'ist ein Modem (Modulator und Demodulator) für digitale Signale.', ' ');
INSERT INTO answer VALUES (685, 172, 0, 'paketweise (stoßweise) gesendet.', ' ');
INSERT INTO answer VALUES (686, 172, 1, 'in der Mailbox in Paketen aufbewahrt.', ' ');
INSERT INTO answer VALUES (687, 172, 2, '8-Bit-weise parallel gepackt gesendet.', ' ');
INSERT INTO answer VALUES (688, 172, 3, 'zu 8 Bit gepackt und dann gesendet.', ' ');
INSERT INTO answer VALUES (689, 173, 0, 'Die Übertragung erfolgt mit 1200 Baud.', ' ');
INSERT INTO answer VALUES (690, 173, 1, 'Man arbeitet mit einem einzelnen Ton von 1200 Hz.', ' ');
INSERT INTO answer VALUES (691, 173, 2, 'Die Frequenz am Packet-Radio-Eingang beträgt 1200 Hertz.', ' ');
INSERT INTO answer VALUES (692, 173, 3, 'Die Daten werden in Paketen von 1200 Bits übertragen.', ' ');
INSERT INTO answer VALUES (693, 174, 0, '9600 Baud', ' ');
INSERT INTO answer VALUES (694, 174, 1, '12000 Baud', ' ');
INSERT INTO answer VALUES (695, 174, 2, '2700 Baud', ' ');
INSERT INTO answer VALUES (696, 174, 3, '6400 Baud', ' ');
INSERT INTO answer VALUES (697, 175, 0, 'ein Rechnersystem bei dem Texte und Daten über Funk eingespeichert und abgerufen werden können.', ' ');
INSERT INTO answer VALUES (698, 175, 1, 'die Softwaresteuerung einer automatischen Funkstelle.', ' ');
INSERT INTO answer VALUES (699, 175, 2, 'eine fernbedient oder automatisch arbeitende Funkstelle die Internetnachrichten zwischenspeichert.', ' ');
INSERT INTO answer VALUES (700, 175, 3, 'eine Zusatzeinrichtung die E-Mails umwandelt und anschließend zwischenspeichert.', ' ');
INSERT INTO answer VALUES (701, 176, 0, 'einen PC mit Soundkarte und entsprechender Software.', ' ');
INSERT INTO answer VALUES (702, 176, 1, 'einen Fernschreiber.', ' ');
INSERT INTO answer VALUES (703, 176, 2, 'einen RTTY-Microcontroller.', ' ');
INSERT INTO answer VALUES (704, 176, 3, 'eine Zusatzeinrichtung, die RTTY-Signale umwandelt und anschließend zwischenspeichert.', ' ');
INSERT INTO answer VALUES (705, 177, 0, 'SSTV überträgt Standbilder, ATV bewegte Bilder.', ' ');
INSERT INTO answer VALUES (706, 177, 1, 'SSTV wird nur auf Kurzwelle, ATV auf UKW verwendet.', ' ');
INSERT INTO answer VALUES (707, 177, 2, 'SSTV belegt eine größere Bandbreite als ATV.', ' ');
INSERT INTO answer VALUES (708, 177, 3, 'SSTV ist schwarzweiß, ATV in Farbe.', ' ');
INSERT INTO answer VALUES (709, 178, 0, 'PSK31', ' ');
INSERT INTO answer VALUES (710, 178, 1, 'RTTY', ' ');
INSERT INTO answer VALUES (711, 178, 2, 'Pactor', ' ');
INSERT INTO answer VALUES (712, 178, 3, 'Packet Radio', ' ');
INSERT INTO answer VALUES (713, 179, 0, 'Halbduplex', ' ');
INSERT INTO answer VALUES (714, 179, 1, 'Simplex', ' ');
INSERT INTO answer VALUES (715, 179, 2, 'Duplex', ' ');
INSERT INTO answer VALUES (716, 179, 3, 'Vollduplex', ' ');
INSERT INTO answer VALUES (717, 180, 0, 'Spiegelfrequenzstörungen.', ' ');
INSERT INTO answer VALUES (718, 180, 1, 'Beeinflussung des lokalen Oszillators.', ' ');
INSERT INTO answer VALUES (719, 180, 2, 'Nebenaussendungen.', ' ');
INSERT INTO answer VALUES (720, 180, 3, 'Störungen der zweiten ZF.', ' ');
INSERT INTO answer VALUES (721, 181, 0, 'ermöglicht bei großem Abstand zur Empfangsfrequenz eine hohe Spiegelfrequenzunterdrückung.', ' ');
INSERT INTO answer VALUES (722, 181, 1, 'trägt dazu bei, mögliche Beeinflussungen des lokalen Oszillators durch Empfangssignale zu reduzieren.', ' ');
INSERT INTO answer VALUES (723, 181, 2, 'sollte möglichst nahe an der Empfangsfrequenz liegen, um eine gute Spiegelfrequenzunterdrückung zu erreichen.', ' ');
INSERT INTO answer VALUES (724, 181, 3, 'verhindert auf Grund ihrer Höhe, dass durch die Umsetzung auf die zweite Zwischenfrequenz Spiegelfrequenzen auftreten.', ' ');
INSERT INTO answer VALUES (725, 182, 0, 'Mit einer niedrigen zweiten ZF erreicht man leicht eine gute Trennschärfe.', ' ');
INSERT INTO answer VALUES (726, 182, 1, 'Das von der Antenne aufgenommene Signal bleibt bis zum Demodulator in seiner Frequenz erhalten.', ' ');
INSERT INTO answer VALUES (727, 182, 2, 'Durch eine hohe erste ZF erreicht man leicht eine gute Trennschärfe.', ' ');
INSERT INTO answer VALUES (728, 182, 3, 'Durch eine niedrige zweite ZF erreicht man leicht eine gute Spiegelselektion.', ' ');
INSERT INTO answer VALUES (729, 183, 0, '49,9 MHz', ' ');
INSERT INTO answer VALUES (730, 183, 1, '48,9 MHz', ' ');
INSERT INTO answer VALUES (731, 183, 2, '39,2 MHz', ' ');
INSERT INTO answer VALUES (732, 183, 3, '17,8 MHz', ' ');
INSERT INTO answer VALUES (733, 184, 0, 'die Höhe der ersten ZF.', ' ');
INSERT INTO answer VALUES (734, 184, 1, 'die Höhe der zweiten ZF bei einem Doppelüberlagerungsempfänger.', ' ');
INSERT INTO answer VALUES (735, 184, 2, 'die Bandbreite der ZF-Stufen.', ' ');
INSERT INTO answer VALUES (736, 184, 3, 'die NF-Bandbreite.', ' ');
INSERT INTO answer VALUES (737, 185, 0, '9 MHz und 281 MHz', ' ');
INSERT INTO answer VALUES (738, 185, 1, '127 MHz und 154 MHz', ' ');
INSERT INTO answer VALUES (739, 185, 2, '272 MHz und 290 MHz', ' ');
INSERT INTO answer VALUES (740, 185, 3, '140,5 MHz und 281 MHz', ' ');
INSERT INTO answer VALUES (741, 186, 0, '10,7 MHz und 66,7 MHz', ' ');
INSERT INTO answer VALUES (742, 186, 1, 'nur 10,7 MHz', ' ');
INSERT INTO answer VALUES (743, 186, 2, '56 MHz und 66,7 MHz', ' ');
INSERT INTO answer VALUES (744, 186, 3, '10,7 MHz und 56 MHz', ' ');
INSERT INTO answer VALUES (745, 187, 0, 'hohen Trennschärfe.', ' ');
INSERT INTO answer VALUES (746, 187, 1, 'fehlenden Trennschärfe.', ' ');
INSERT INTO answer VALUES (747, 187, 2, 'unzulänglichen Trennschärfe.', ' ');
INSERT INTO answer VALUES (748, 187, 3, 'schlechten Demodulation.', ' ');
INSERT INTO answer VALUES (749, 188, 0, 'dem zweifachen der ersten ZF.', ' ');
INSERT INTO answer VALUES (750, 188, 1, 'der Frequenz des lokalen Oszillators.', ' ');
INSERT INTO answer VALUES (751, 188, 2, 'der HF-Eingangsfrequenz.', ' ');
INSERT INTO answer VALUES (752, 188, 3, 'der Frequenz des Preselektors.', ' ');
INSERT INTO answer VALUES (753, 189, 0, 'Durch Mischung.', ' ');
INSERT INTO answer VALUES (754, 189, 1, 'Durch Vervielfachung.', ' ');
INSERT INTO answer VALUES (755, 189, 2, 'Durch Frequenzteilung.', ' ');
INSERT INTO answer VALUES (756, 189, 3, 'Durch Rückkopplung.', ' ');
INSERT INTO answer VALUES (757, 190, 0, 'einer automatischen Verstärkungsregelung ausgestattet.', ' ');
INSERT INTO answer VALUES (758, 190, 1, 'einer NF-Pegelbegrenzung ausgestattet.', ' ');
INSERT INTO answer VALUES (759, 190, 2, 'NF-Filtern ausgestattet.', ' ');
INSERT INTO answer VALUES (760, 190, 3, 'einer NF-Vorspannungsregelung ausgestattet.', ' ');
INSERT INTO answer VALUES (761, 191, 0, 'die Verstärkung der HF- und ZF-Stufen.', ' ');
INSERT INTO answer VALUES (762, 191, 1, 'die Versorgungsspannung des VFO.', ' ');
INSERT INTO answer VALUES (763, 191, 2, 'eine Verstärkung der NF-Stufen.', ' ');
INSERT INTO answer VALUES (764, 191, 3, 'eine Filterreaktion.', ' ');
INSERT INTO answer VALUES (765, 192, 0, 'Sie reduziert die Verstärkung der HF-und ZF-Stufen.', ' ');
INSERT INTO answer VALUES (766, 192, 1, 'Sie reduziert die Amplitude des VFO.', ' ');
INSERT INTO answer VALUES (767, 192, 2, 'Sie reduziert die Amplitude des BFO.', ' ');
INSERT INTO answer VALUES (768, 192, 3, 'Sie reduziert die Höhe der Versorgungsspannungen.', ' ');
INSERT INTO answer VALUES (769, 193, 0, 'Der VFO muss bei 38,70 MHz und der CO bei 11,16 MHz schwingen.', ' ');
INSERT INTO answer VALUES (770, 193, 1, 'Der VFO muss bei 10,26 MHz und der CO bei 17,30 MHz schwingen.', ' ');
INSERT INTO answer VALUES (771, 193, 2, 'Der VFO muss bei 11,16 MHz und der CO bei 38,70 MHz schwingen.', ' ');
INSERT INTO answer VALUES (772, 193, 3, 'Der VFO muss bei 28,460 MHz und der CO bei 38,26 MHz schwingen.', ' ');
INSERT INTO answer VALUES (773, 194, 0, 'Der VFO muss bei 30,1 MHz und der CO bei 9,46 MHz schwingen.', ' ');
INSERT INTO answer VALUES (774, 194, 1, 'Der VFO muss bei 9,46 MHz und der CO bei 8,54 MHz schwingen.', ' ');
INSERT INTO answer VALUES (775, 194, 2, 'Der VFO muss bei 30,1 MHz und der CO bei 8,54 MHz schwingen.', ' ');
INSERT INTO answer VALUES (776, 194, 3, 'Der VFO muss bei 21,56 MHz und der CO bei 12,1 MHz schwingen.', ' ');
INSERT INTO answer VALUES (777, 195, 0, '49,7 MHz auftreten.', ' ');
INSERT INTO answer VALUES (778, 195, 1, '39 MHz auftreten.', ' ');
INSERT INTO answer VALUES (779, 195, 2, '67,3 MHz auftreten.', ' ');
INSERT INTO answer VALUES (780, 195, 3, '17,6 MHz auftreten.', ' ');
INSERT INTO answer VALUES (781, 196, 0, 'der sein Ausgangssignal ab einem bestimmten Eingangspegel begrenzt.', ' ');
INSERT INTO answer VALUES (782, 196, 1, 'der zur Verringerung des Vorstufenrauschens dient.', ' ');
INSERT INTO answer VALUES (783, 196, 2, 'der zur Begrenzung des Hubes für den FM-Demodulator dient.', ' ');
INSERT INTO answer VALUES (784, 196, 3, 'der den ZF-Träger unabhängig vom Eingangssignal auf niedrigem Pegel konstant hält.', ' ');
INSERT INTO answer VALUES (785, 197, 0, 'Ein Quarzkristall', ' ');
INSERT INTO answer VALUES (786, 197, 1, 'Ein LC-Bandpass', ' ');
INSERT INTO answer VALUES (787, 197, 2, 'Ein Keramikresonator', ' ');
INSERT INTO answer VALUES (788, 197, 3, 'Ein RC-Bandpass', ' ');
INSERT INTO answer VALUES (789, 198, 0, 'Fähigkeit des Empfängers, schwache Signale zu empfangen.', ' ');
INSERT INTO answer VALUES (790, 198, 1, 'Stabilität des VFO.', ' ');
INSERT INTO answer VALUES (791, 198, 2, 'Bandbreite des HF-Vorverstärkers.', ' ');
INSERT INTO answer VALUES (792, 198, 3, 'Fähigkeit des Empfängers, starke Signale zu unterdrücken.', ' ');
INSERT INTO answer VALUES (793, 199, 0, 'Bessere Trennschärfe', ' ');
INSERT INTO answer VALUES (794, 199, 1, 'Höhere Bandbreiten', ' ');
INSERT INTO answer VALUES (795, 199, 2, 'Geringere Anforderungen an die VFO-Stabilität', ' ');
INSERT INTO answer VALUES (796, 199, 3, 'Wesentlich einfachere Konstruktion', ' ');
INSERT INTO answer VALUES (797, 200, 0, 'Um eine S-Stufe', ' ');
INSERT INTO answer VALUES (798, 200, 1, 'Um zwei S-Stufen', ' ');
INSERT INTO answer VALUES (799, 200, 2, 'Um vier S-Stufen', ' ');
INSERT INTO answer VALUES (800, 200, 3, 'Um acht S-Stufen', ' ');
INSERT INTO answer VALUES (801, 201, 0, '100-fach', ' ');
INSERT INTO answer VALUES (802, 201, 1, '20-fach', ' ');
INSERT INTO answer VALUES (803, 201, 2, '10-fach', ' ');
INSERT INTO answer VALUES (804, 201, 3, '120-fach', ' ');
INSERT INTO answer VALUES (805, 202, 0, 'S9+4dB', ' ');
INSERT INTO answer VALUES (806, 202, 1, 'S18', ' ');
INSERT INTO answer VALUES (807, 202, 2, 'S10+10 dB', ' ');
INSERT INTO answer VALUES (808, 202, 3, 'S9+9 dB', ' ');
INSERT INTO answer VALUES (809, 203, 0, '18 dB', ' ');
INSERT INTO answer VALUES (810, 203, 1, '9 dB', ' ');
INSERT INTO answer VALUES (811, 203, 2, '3 dB', ' ');
INSERT INTO answer VALUES (812, 203, 3, '24 dB', ' ');
INSERT INTO answer VALUES (813, 204, 0, 'Notchfilter', ' ');
INSERT INTO answer VALUES (814, 204, 1, 'Noise Filter', ' ');
INSERT INTO answer VALUES (815, 204, 2, 'Störaustaster', ' ');
INSERT INTO answer VALUES (816, 204, 3, 'Die AGC', ' ');
INSERT INTO answer VALUES (817, 205, 0, 'Automatische Verstärkungsregelung', ' ');
INSERT INTO answer VALUES (818, 205, 1, 'Automatische Frequenzregelung', ' ');
INSERT INTO answer VALUES (819, 205, 2, 'Automatische Gleichlaufsteuerung', ' ');
INSERT INTO answer VALUES (820, 205, 3, 'Automatische Antennenabstimmung', ' ');
INSERT INTO answer VALUES (821, 206, 0, 'Noise Blanker', ' ');
INSERT INTO answer VALUES (822, 206, 1, 'Notchfilter', ' ');
INSERT INTO answer VALUES (823, 206, 2, 'Passband-Tuning', ' ');
INSERT INTO answer VALUES (824, 206, 3, 'Die AGC', ' ');
INSERT INTO answer VALUES (825, 207, 0, 'Durch die Verringerung der NF-Ansteuerung und/oder durch Einfügung eines Dämpfungsgliedes zwischen Steuersender und Endstufe.', ' ');
INSERT INTO answer VALUES (826, 207, 1, 'Durch die Veränderung des Arbeitspunktes der Endstufe.', ' ');
INSERT INTO answer VALUES (827, 207, 2, 'Durch die Verringerung des Hubes und/oder durch Einfügung eines Dämpfungsgliedes zwischen Steuersender und Endstufe.', ' ');
INSERT INTO answer VALUES (828, 207, 3, 'Nur durch Verringerung des Hubes allein.', ' ');
INSERT INTO answer VALUES (829, 208, 0, 'Ein Transverter setzt beim Empfangen z.B. ein 70-cm-Signal in das 10-m-Band und beim Senden das 10-m-Sendesignal auf das 70-cm-Band um.', ' ');
INSERT INTO answer VALUES (830, 208, 1, 'Ein Transverter setzt beim Senden als auch beim Empfangen z.B. ein 70-cm-Signal in das 10-m-Band um.', ' ');
INSERT INTO answer VALUES (831, 208, 2, 'Ein Transverter setzt beim Senden als auch beim Empfangen z.B. ein frequenzmoduliertes Signal in ein amplitudenmoduliertes Signal um.', ' ');
INSERT INTO answer VALUES (832, 208, 3, 'Ein Transverter setzt nur den zu empfangenden Frequenzbereich in einen anderen Frequenzbereich um, z.B. das 70-cm-Band in das 10-m- Band.', ' ');
INSERT INTO answer VALUES (833, 209, 0, 'Leiser ins Mikrofon sprechen.', ' ');
INSERT INTO answer VALUES (834, 209, 1, 'Lauter ins Mikrofon sprechen.', ' ');
INSERT INTO answer VALUES (835, 209, 2, 'Weniger Leistung verwenden.', ' ');
INSERT INTO answer VALUES (836, 209, 3, 'Mehr Leistung verwenden.', ' ');
INSERT INTO answer VALUES (837, 210, 0, 'Splatter bei Stationen, die auf dem Nachbarkanal arbeiten.', ' ');
INSERT INTO answer VALUES (838, 210, 1, 'Störungen von Stationen, die auf einem anderen Frequenzband arbeiten.', ' ');
INSERT INTO answer VALUES (839, 210, 2, 'Störungen der Stromversorgung des Transceivers.', ' ');
INSERT INTO answer VALUES (840, 210, 3, 'Störungen von Computern.', ' ');
INSERT INTO answer VALUES (841, 211, 0, 'geringe Ausgangsleistung', ' ');
INSERT INTO answer VALUES (842, 211, 1, 'Störungen von Stationen, die auf einem anderen Frequenzband arbeiten', ' ');
INSERT INTO answer VALUES (843, 211, 2, 'Verringerung der Modulationsqualität', ' ');
INSERT INTO answer VALUES (844, 211, 3, 'Splatter bei Stationen, die auf dem Nachbarkanal arbeiten', ' ');
INSERT INTO answer VALUES (845, 212, 0, 'Speech Processor', ' ');
INSERT INTO answer VALUES (846, 212, 1, 'Noise Blanker', ' ');
INSERT INTO answer VALUES (847, 212, 2, 'Clarifier', ' ');
INSERT INTO answer VALUES (848, 212, 3, 'Notchfilter', ' ');
INSERT INTO answer VALUES (849, 213, 0, 'VOX', ' ');
INSERT INTO answer VALUES (850, 213, 1, 'PTT', ' ');
INSERT INTO answer VALUES (851, 213, 2, 'RIT', ' ');
INSERT INTO answer VALUES (852, 213, 3, 'PSK', ' ');
INSERT INTO answer VALUES (853, 214, 0, 'Es muss sende- und empfangsseitig den Frequenzbereich von 20 Hz bis 6 kHz möglichst linear übertragen können und die Zeit für die Sende-Empfangsumschaltung muss so kurz wie möglich sein z.B. &lt; 10...100 ms.', ' ');
INSERT INTO answer VALUES (854, 214, 1, 'Es muss sende- und empfangsseitig den Frequenzbereich von 300 Hz bis 3,4 kHz möglichst linear übertragen können und die Zeit für die Sende-Empfangsumschaltung muss zwischen 100...300 ms liegen.', ' ');
INSERT INTO answer VALUES (855, 214, 2, 'Es muss über einen Anschluss für Mikrofon und Lautsprecher verfügen, an dem ein TNC oder Modem angeschlossen werden kann.', ' ');
INSERT INTO answer VALUES (856, 214, 3, 'Es muss den Frequenzbereich von 300 Hz bis 10 kHz linear übertragen können und ein TX-Delay von kleiner 1 ms haben.', ' ');
INSERT INTO answer VALUES (857, 215, 0, '10 dBW', ' ');
INSERT INTO answer VALUES (858, 215, 1, '1 dBW', ' ');
INSERT INTO answer VALUES (859, 215, 2, '3 dBW', ' ');
INSERT INTO answer VALUES (860, 215, 3, '20 dBW', ' ');
INSERT INTO answer VALUES (861, 216, 0, '40 W', ' ');
INSERT INTO answer VALUES (862, 216, 1, '4 W', ' ');
INSERT INTO answer VALUES (863, 216, 2, '16 W', ' ');
INSERT INTO answer VALUES (864, 216, 3, '20 W', ' ');
INSERT INTO answer VALUES (865, 217, 0, 'die unmittelbar nach dem Senderausgang messbare Leistung, bevor sie Zusatzgeräte (z.B. Anpassgeräte) durchläuft.', ' ');
INSERT INTO answer VALUES (866, 217, 1, 'die unmittelbar nach dem Senderausgang gemessene Differenz aus vorlaufender und rücklaufender Leistung.', ' ');
INSERT INTO answer VALUES (867, 217, 2, 'die unmittelbar nach den erforderlichen Zusatzgeräten (z.B. Anpassgeräte) messbare Leistung.', ' ');
INSERT INTO answer VALUES (868, 217, 3, 'die unmittelbar nach dem Senderausgang gemessene Summe aus vorlaufender und rücklaufender Leistung.', ' ');
INSERT INTO answer VALUES (869, 218, 0, 'HF-Leistung bei der höchsten Spitze der Hüllkurve.', ' ');
INSERT INTO answer VALUES (870, 218, 1, 'Durchschnittsleistung einer SSB-Übertragung.', ' ');
INSERT INTO answer VALUES (871, 218, 2, 'Spitzen-Spitzen-Leistung bei den höchsten Spitzen der Modulationshüllkurve.', ' ');
INSERT INTO answer VALUES (872, 218, 3, 'Mindestleistung bei der Modulationsspitze.', ' ');
INSERT INTO answer VALUES (873, 219, 0, '3 dB', ' ');
INSERT INTO answer VALUES (874, 219, 1, '6 dB', ' ');
INSERT INTO answer VALUES (875, 219, 2, '1,5 dB', ' ');
INSERT INTO answer VALUES (876, 219, 3, '12 dB', ' ');
INSERT INTO answer VALUES (877, 220, 0, 'wird nicht durch die Modulation beeinflusst.', ' ');
INSERT INTO answer VALUES (878, 220, 1, 'ändert sich durch die Modulation.', ' ');
INSERT INTO answer VALUES (879, 220, 2, 'beträgt bei fehlender Modulation Null.', ' ');
INSERT INTO answer VALUES (880, 220, 3, 'verringert sich durch Modulation auf 70 %.', ' ');
INSERT INTO answer VALUES (881, 221, 0, 'Durch die Verringerung der NF- Ansteuerung und/oder durch Einfügung eines Dämpfungsgliedes zwischen Steuersender und Endstufe.', ' ');
INSERT INTO answer VALUES (882, 221, 1, 'Durch die Veränderung des Arbeitspunktes der Endstufe.', ' ');
INSERT INTO answer VALUES (883, 221, 2, 'Durch die Verringerung des Hubes und/oder durch Einfügung eines Dämpfungsgliedes zwischen Steuersender und Endstufe.', ' ');
INSERT INTO answer VALUES (884, 221, 3, 'Nur durch Verringerung des Hubes allein.', ' ');
INSERT INTO answer VALUES (885, 222, 0, 'Leiser ins Mikrofon sprechen', ' ');
INSERT INTO answer VALUES (886, 222, 1, 'Mehr Leistung verwenden', ' ');
INSERT INTO answer VALUES (887, 222, 2, 'Weniger Leistung verwenden', ' ');
INSERT INTO answer VALUES (888, 222, 3, 'Lauter ins Mikrofon sprechen', ' ');
INSERT INTO answer VALUES (889, 223, 0, 'USB, LSB, FM, AM, CW', ' ');
INSERT INTO answer VALUES (890, 223, 1, 'USB, PSK31, FM, SSTV, CW', ' ');
INSERT INTO answer VALUES (891, 223, 2, 'USB, LSB, FM, SSTV, CW', ' ');
INSERT INTO answer VALUES (892, 223, 3, 'USB, LSB, Amtor, Pactor, CW', ' ');
INSERT INTO answer VALUES (893, 224, 0, 'die RIT bedienen.', ' ');
INSERT INTO answer VALUES (894, 224, 1, 'das Notchfilter einschalten.', ' ');
INSERT INTO answer VALUES (895, 224, 2, 'die Passband-Tuning verstellen.', ' ');
INSERT INTO answer VALUES (896, 224, 3, 'die PTT einschalten.', ' ');
INSERT INTO answer VALUES (897, 225, 0, 'PTT', ' ');
INSERT INTO answer VALUES (898, 225, 1, 'VOX', ' ');
INSERT INTO answer VALUES (899, 225, 2, 'RIT', ' ');
INSERT INTO answer VALUES (900, 225, 3, 'SSB', ' ');
INSERT INTO answer VALUES (901, 226, 0, 'VOX-Betrieb', ' ');
INSERT INTO answer VALUES (902, 226, 1, 'PTT-Betrieb', ' ');
INSERT INTO answer VALUES (903, 226, 2, 'RIT-Betrieb', ' ');
INSERT INTO answer VALUES (904, 226, 3, 'SSB-Betrieb', ' ');
INSERT INTO answer VALUES (905, 227, 0, 'Durch zu steile Flanken der Tastimpulse', ' ');
INSERT INTO answer VALUES (906, 227, 1, 'Durch prellende Kontakte der verwendeten Taste', ' ');
INSERT INTO answer VALUES (907, 227, 2, 'Durch direkte Tastung der Oszillatorstufe', ' ');
INSERT INTO answer VALUES (908, 227, 3, 'Durch ein unterdimensioniertes Netzteil, dessen Spannung beim Auftasten kurzzeitig zusammenbricht', ' ');
INSERT INTO answer VALUES (909, 228, 0, 'Ein Tiefpassfilter', ' ');
INSERT INTO answer VALUES (910, 228, 1, 'Ein Hochpassfilter', ' ');
INSERT INTO answer VALUES (911, 228, 2, 'Ein Antennenfilter', ' ');
INSERT INTO answer VALUES (912, 228, 3, 'Ein Sperrkreisfilter', ' ');
INSERT INTO answer VALUES (913, 229, 0, 'höchstens 3 kHz betragen.', ' ');
INSERT INTO answer VALUES (914, 229, 1, 'höchstens 5 kHz betragen.', ' ');
INSERT INTO answer VALUES (915, 229, 2, 'höchstens 10 kHz betragen.', ' ');
INSERT INTO answer VALUES (916, 229, 3, 'höchstens 15 kHz betragen.', ' ');
INSERT INTO answer VALUES (917, 230, 0, '<img src=''etg504a.png''>', ' ');
INSERT INTO answer VALUES (918, 230, 1, '<img src=''etg504b.png''>', ' ');
INSERT INTO answer VALUES (919, 230, 2, '<img src=''etg504c.png''>', ' ');
INSERT INTO answer VALUES (920, 230, 3, '<img src=''etg504d.png''>', ' ');
INSERT INTO answer VALUES (921, 231, 0, 'in eine künstliche 50-&Omega;-Antenne eingespeist werden.', ' ');
INSERT INTO answer VALUES (922, 231, 1, 'in eine Antenne eingespeist werden.', ' ');
INSERT INTO answer VALUES (923, 231, 2, 'in einen Kondensator mit einem Blindwiderstand von 50 &Omega; eingespeist werden.', ' ');
INSERT INTO answer VALUES (924, 231, 3, 'in einen 50-&Omega;-Drahtwiderstand eingespeist werden.', ' ');
INSERT INTO answer VALUES (925, 232, 0, '<img src=''etg506a.png''>', ' ');
INSERT INTO answer VALUES (926, 232, 1, '<img src=''etg506b.png''>', ' ');
INSERT INTO answer VALUES (927, 232, 2, '<img src=''etg506c.png''>', ' ');
INSERT INTO answer VALUES (928, 232, 3, '<img src=''etg506d.png''>', ' ');
INSERT INTO answer VALUES (929, 233, 0, 'Langdraht-Antenne, Groundplane-Antenne, Yagiantenne, Dipolantenne, Windom-Antenne, Delta-Loop-Antenne', ' ');
INSERT INTO answer VALUES (930, 233, 1, 'Langdraht-Antenne, Groundplane-Antenne, Gestockte Yagiantenne, Dipolantenne, Windom- Antenne, Delta-Loop-Antenne', ' ');
INSERT INTO answer VALUES (931, 233, 2, 'Langdraht-Antenne, Groundplane-Antenne, Gruppenantenne, Dipolantenne, Windom- Antenne, Delta-Loop-Antenne', ' ');
INSERT INTO answer VALUES (932, 233, 3, 'Langdraht-Antenne, Groundplane-Antenne, Kreuzyagi-Antenne, Dipolantenne, Windom- Antenne, Delta-Loop-Antenne', ' ');
INSERT INTO answer VALUES (933, 234, 0, 'Langdraht-Antennen', ' ');
INSERT INTO answer VALUES (934, 234, 1, 'Yagi-Antennen', ' ');
INSERT INTO answer VALUES (935, 234, 2, 'Quad-Antennen', ' ');
INSERT INTO answer VALUES (936, 234, 3, 'Groundplane-Antennen', ' ');
INSERT INTO answer VALUES (937, 235, 0, 'Magnetische Ringantennen mit einem Umfang von etwa &lambda;/10.', ' ');
INSERT INTO answer VALUES (938, 235, 1, 'Ferritstabantennen und magnetische Ringantennen.', ' ');
INSERT INTO answer VALUES (939, 235, 2, 'Rahmenantennen mit mehreren Drahtwindungen.', ' ');
INSERT INTO answer VALUES (940, 235, 3, 'Ferritstabantennen und Rahmenantennen mit mehreren Drahtwindungen.', ' ');
INSERT INTO answer VALUES (941, 236, 0, '6,58 m', ' ');
INSERT INTO answer VALUES (942, 236, 1, '3,29 m', ' ');
INSERT INTO answer VALUES (943, 236, 2, '2,08 m', ' ');
INSERT INTO answer VALUES (944, 236, 3, '5,26 m', ' ');
INSERT INTO answer VALUES (945, 237, 0, 'Dipol, Delta-Loop, W3DZZ-Antenne', ' ');
INSERT INTO answer VALUES (946, 237, 1, 'Beam, Groundplane-Antenne, Dipol', ' ');
INSERT INTO answer VALUES (947, 237, 2, 'Dipol, W3DZZ-Antenne, Beam', ' ');
INSERT INTO answer VALUES (948, 237, 3, 'Dipol, Delta-Loop, Langyagi', ' ');
INSERT INTO answer VALUES (949, 238, 0, 'Groundplane', ' ');
INSERT INTO answer VALUES (950, 238, 1, 'Faltdipol', ' ');
INSERT INTO answer VALUES (951, 238, 2, 'Yagi', ' ');
INSERT INTO answer VALUES (952, 238, 3, '&lambda;/2-Dipol', ' ');
INSERT INTO answer VALUES (953, 239, 0, 'Delta-Loop-Antenne', ' ');
INSERT INTO answer VALUES (954, 239, 1, '3-Element Quad-Loop-Antenne', ' ');
INSERT INTO answer VALUES (955, 239, 2, 'W3DZZ Antenne', ' ');
INSERT INTO answer VALUES (956, 239, 3, '3-Element-Beam', ' ');
INSERT INTO answer VALUES (957, 240, 0, '5&lambda;/8', ' ');
INSERT INTO answer VALUES (958, 240, 1, '&lambda;/4', ' ');
INSERT INTO answer VALUES (959, 240, 2, '&lambda;/2', ' ');
INSERT INTO answer VALUES (960, 240, 3, '3&lambda;/4', ' ');
INSERT INTO answer VALUES (961, 241, 0, 'einen flachen Abstrahlwinkel.', ' ');
INSERT INTO answer VALUES (962, 241, 1, 'zirkulare Polarisation.', ' ');
INSERT INTO answer VALUES (963, 241, 2, 'einen hohen Abstrahlwinkel.', ' ');
INSERT INTO answer VALUES (964, 241, 3, 'elliptische Polarisation.', ' ');
INSERT INTO answer VALUES (965, 242, 0, 'l beträgt zirka 40 m, f<sub>res</sub> liegt bei zirka 3,65 MHz.', ' ');
INSERT INTO answer VALUES (966, 242, 1, 'l beträgt zirka 80 m, f<sub>res</sub> liegt bei zirka 3,65 MHz.', ' ');
INSERT INTO answer VALUES (967, 242, 2, 'l beträgt zirka 40 m, f<sub>res</sub> liegt bei zirka 1,85 MHz.', ' ');
INSERT INTO answer VALUES (968, 242, 3, 'l beträgt zirka 80 m, f<sub>res</sub> liegt bei zirka 1,85 MHz.', ' ');
INSERT INTO answer VALUES (969, 243, 0, 'Radiale.', ' ');
INSERT INTO answer VALUES (970, 243, 1, 'Reflektoren.', ' ');
INSERT INTO answer VALUES (971, 243, 2, 'Parasitärstrahler.', ' ');
INSERT INTO answer VALUES (972, 243, 3, 'Erdelemente.', ' ');
INSERT INTO answer VALUES (973, 244, 0, '1 Reflektor, 2 Strahler und 3 Direktor.', ' ');
INSERT INTO answer VALUES (974, 244, 1, '1 Strahler, 2 Direktor und 3 Reflektor.', ' ');
INSERT INTO answer VALUES (975, 244, 2, '1 Direktor, 2 Strahler und 3 Reflektor.', ' ');
INSERT INTO answer VALUES (976, 244, 3, '1 Direktor, 2 Reflektor und 3 Strahler.', ' ');
INSERT INTO answer VALUES (977, 245, 0, 'Strahler', ' ');
INSERT INTO answer VALUES (978, 245, 1, 'Direktor', ' ');
INSERT INTO answer VALUES (979, 245, 2, 'Reflektor', ' ');
INSERT INTO answer VALUES (980, 245, 3, 'Strahler und am Reflektor gleichzeitig', ' ');
INSERT INTO answer VALUES (981, 246, 0, 'Sie muss ein ganzzahliges Vielfaches von &lambda;/2 betragen. (n * &lambda;/2, n=1, 2, 3...)', ' ');
INSERT INTO answer VALUES (982, 246, 1, 'Sie muss ein ungeradzahliges Vielfaches von &lambda;/4 betragen. (n * &lambda;/4, n=1, 3, 5...)', ' ');
INSERT INTO answer VALUES (983, 246, 2, 'Sie muss 5/8 &lambda;, &lambda;/4 oder deren geradzahlige Vielfache (n * &lambda;/4, n=2, 4, 6...) betragen.', ' ');
INSERT INTO answer VALUES (984, 246, 3, 'Sie darf kein ganzzahliges Vielfaches von &lambda; betragen.', ' ');
INSERT INTO answer VALUES (985, 247, 0, 'Dipol<p><img src=''eth202a.png''>', ' ');
INSERT INTO answer VALUES (986, 247, 1, 'Groundplane<p><img src=''eth202b.png''>', ' ');
INSERT INTO answer VALUES (987, 247, 2, 'Yagiantenne<p><img src=''eth202c.png''>', ' ');
INSERT INTO answer VALUES (988, 247, 3, 'Faltdipol<p><img src=''eth202d.png''>', ' ');
INSERT INTO answer VALUES (989, 248, 0, 'ca. 30 ... 50 &Omega;', ' ');
INSERT INTO answer VALUES (990, 248, 1, 'ca. 60 ... 120 &Omega;', ' ');
INSERT INTO answer VALUES (991, 248, 2, 'ca. 600 &Omega;', ' ');
INSERT INTO answer VALUES (992, 248, 3, 'ca. 240 &Omega;', ' ');
INSERT INTO answer VALUES (993, 249, 0, '40 bis 80 &Omega;.', ' ');
INSERT INTO answer VALUES (994, 249, 1, '60 bis 120 &Omega;.', ' ');
INSERT INTO answer VALUES (995, 249, 2, '120 bis 240 &Omega;.', ' ');
INSERT INTO answer VALUES (996, 249, 3, '240 bis 600 &Omega;.', ' ');
INSERT INTO answer VALUES (997, 250, 0, '240 &Omega;.', ' ');
INSERT INTO answer VALUES (998, 250, 1, '600 &Omega;.', ' ');
INSERT INTO answer VALUES (999, 250, 2, '50 &Omega;.', ' ');
INSERT INTO answer VALUES (1000, 250, 3, '30-60 &Omega;.', ' ');
INSERT INTO answer VALUES (1001, 251, 0, 'stromgespeist.', ' ');
INSERT INTO answer VALUES (1002, 251, 1, 'spannungsgespeist.', ' ');
INSERT INTO answer VALUES (1003, 251, 2, 'endgespeist.', ' ');
INSERT INTO answer VALUES (1004, 251, 3, 'parallel gespeist.', ' ');
INSERT INTO answer VALUES (1005, 252, 0, '95 %', ' ');
INSERT INTO answer VALUES (1006, 252, 1, '75 %', ' ');
INSERT INTO answer VALUES (1007, 252, 2, '66 %', ' ');
INSERT INTO answer VALUES (1008, 252, 3, '100 %', ' ');
INSERT INTO answer VALUES (1009, 253, 0, 'Bild 1 zeigt einen &lambda;/4-Vertikalstrahler (Viertelwellenstab).', ' ');
INSERT INTO answer VALUES (1010, 253, 1, 'Bild 2 zeigt eine Sperrtopf-Antenne.', ' ');
INSERT INTO answer VALUES (1011, 253, 2, 'Bild 3 zeigt eine &lambda;/2-Antenne mit Fuchskreis.', ' ');
INSERT INTO answer VALUES (1012, 253, 3, 'Bild 4 zeigt eine 5/8-&lambda;-Antenne.', ' ');
INSERT INTO answer VALUES (1013, 254, 0, 'Bild 1 zeigt eine horizontal polarisierte Yagi-Antenne.', ' ');
INSERT INTO answer VALUES (1014, 254, 1, 'Bild 2 zeigt eine Kreuz-Yagi-Antenne.', ' ');
INSERT INTO answer VALUES (1015, 254, 2, 'Bild 3 zeigt eine gestockte X-Yagi-Antenne.', ' ');
INSERT INTO answer VALUES (1016, 254, 3, 'Bild 4 zeigt eine vertikal polarisierte Yagi-Antenne.', ' ');
INSERT INTO answer VALUES (1017, 255, 0, 'kann eine beliebige Länge haben.', ' ');
INSERT INTO answer VALUES (1018, 255, 1, 'muss unbedingt lambda-halbe lang sein.', ' ');
INSERT INTO answer VALUES (1019, 255, 2, 'muss genau lambda-viertel lang sein.', ' ');
INSERT INTO answer VALUES (1020, 255, 3, 'muss eine Länge von dreiviertel Lambda haben.', ' ');
INSERT INTO answer VALUES (1021, 256, 0, '6 dB', ' ');
INSERT INTO answer VALUES (1022, 256, 1, '3 dB', ' ');
INSERT INTO answer VALUES (1023, 256, 2, '10 dB', ' ');
INSERT INTO answer VALUES (1024, 256, 3, '16 dB', ' ');
INSERT INTO answer VALUES (1025, 257, 0, '10 dB', ' ');
INSERT INTO answer VALUES (1026, 257, 1, '3 dB', ' ');
INSERT INTO answer VALUES (1027, 257, 2, '6 dB', ' ');
INSERT INTO answer VALUES (1028, 257, 3, '16 dB', ' ');
INSERT INTO answer VALUES (1029, 258, 0, '3 dB', ' ');
INSERT INTO answer VALUES (1030, 258, 1, '-6 dB', ' ');
INSERT INTO answer VALUES (1031, 258, 2, '-3 dB', ' ');
INSERT INTO answer VALUES (1032, 258, 3, '6 dBm', ' ');
INSERT INTO answer VALUES (1033, 259, 0, '0 dBm entspricht 1 mW; 3 dBm entspricht 2 mW; 20 dBm entspricht 100 mW', ' ');
INSERT INTO answer VALUES (1034, 259, 1, '0 dBm entspricht 1 mW; 3 dBm entspricht 1,4 mW; 20 dBm entspricht 10 mW', ' ');
INSERT INTO answer VALUES (1035, 259, 2, '0 dBm entspricht 0 mW; 3 dBm entspricht 30 mW; 20 dBm entspricht 200 mW', ' ');
INSERT INTO answer VALUES (1036, 259, 3, '1 dBm entspricht 0 mW; 2 dBm entspricht 3 mW; 100 dBm entspricht 20 mW', ' ');
INSERT INTO answer VALUES (1037, 260, 0, '1,9 dB', ' ');
INSERT INTO answer VALUES (1038, 260, 1, '7,5 dB', ' ');
INSERT INTO answer VALUES (1039, 260, 2, '3,75 dB', ' ');
INSERT INTO answer VALUES (1040, 260, 3, '1,5 dB', ' ');
INSERT INTO answer VALUES (1041, 261, 0, '1,8 dB', ' ');
INSERT INTO answer VALUES (1042, 261, 1, '4,5 dB', ' ');
INSERT INTO answer VALUES (1043, 261, 2, '3,75 dB', ' ');
INSERT INTO answer VALUES (1044, 261, 3, '1,5 dB', ' ');
INSERT INTO answer VALUES (1045, 262, 0, 'ist im HF-Bereich in etwa konstant und unabhängig vom Leitungsabschluss.', ' ');
INSERT INTO answer VALUES (1046, 262, 1, 'ist völlig frequenzunabhängig.', ' ');
INSERT INTO answer VALUES (1047, 262, 2, 'hängt von der Beschaltung am Leitungsende ab.', ' ');
INSERT INTO answer VALUES (1048, 262, 3, 'hängt von der Leitungslänge und der Beschaltung am Leitungsende ab.', ' ');
INSERT INTO answer VALUES (1049, 263, 0, '50, 60 und 75 &Omega; auf.', ' ');
INSERT INTO answer VALUES (1050, 263, 1, '50, 300 und 600 &Omega; auf.', ' ');
INSERT INTO answer VALUES (1051, 263, 2, '60, 120 und 240 &Omega; auf.', ' ');
INSERT INTO answer VALUES (1052, 263, 3, '50, 75 und 240 &Omega; auf.', ' ');
INSERT INTO answer VALUES (1053, 264, 0, 'Sie hat geringere Dämpfung und hohe Spannungsfestigkeit.', ' ');
INSERT INTO answer VALUES (1054, 264, 1, 'Sie vermeidet Mantelwellen durch Wegfall der Abschirmung.', ' ');
INSERT INTO answer VALUES (1055, 264, 2, 'Sie erlaubt leichtere Kontrolle des Wellenwiderstandes durch Verschieben der Spreizer.', ' ');
INSERT INTO answer VALUES (1056, 264, 3, 'Sie bietet guten Blitzschutz durch niederohmige Drähte.', ' ');
INSERT INTO answer VALUES (1057, 265, 0, 'Wenn die beiden Leiter unterschiedlich geformt sind, z.B. Koaxialkabel.', ' ');
INSERT INTO answer VALUES (1058, 265, 1, 'Wenn die hin- und zurücklaufende Leistung verschieden sind.', ' ');
INSERT INTO answer VALUES (1059, 265, 2, 'Wenn sie außerhalb ihrer Resonanzfrequenz betrieben wird.', ' ');
INSERT INTO answer VALUES (1060, 265, 3, 'Wenn die Koaxial-Leitung Spannung gegen Erde führt.', ' ');
INSERT INTO answer VALUES (1061, 266, 0, 'Hochwertige Koaxialkabel.', ' ');
INSERT INTO answer VALUES (1062, 266, 1, 'Symmetrische Feederleitungen.', ' ');
INSERT INTO answer VALUES (1063, 266, 2, 'Unabgestimmte Speiseleitungen.', ' ');
INSERT INTO answer VALUES (1064, 266, 3, 'Hochwertige abgeschirmte Netzanschlusskabel.', ' ');
INSERT INTO answer VALUES (1065, 267, 0, 'N', ' ');
INSERT INTO answer VALUES (1066, 267, 1, 'SMA', ' ');
INSERT INTO answer VALUES (1067, 267, 2, 'UHF', ' ');
INSERT INTO answer VALUES (1068, 267, 3, 'BNC', ' ');
INSERT INTO answer VALUES (1069, 268, 0, '1', ' ');
INSERT INTO answer VALUES (1070, 268, 1, '0', ' ');
INSERT INTO answer VALUES (1071, 268, 2, '3', ' ');
INSERT INTO answer VALUES (1072, 268, 3, 'unendlich', ' ');
INSERT INTO answer VALUES (1073, 269, 0, 'führen zu Reflektionen des übertragenen HF-Signals und einem erhöhten VSWR.', ' ');
INSERT INTO answer VALUES (1074, 269, 1, 'führen zur einer Überbeanspruchung der angeschlossenen Antenne.', ' ');
INSERT INTO answer VALUES (1075, 269, 2, 'führen zu einem VSWR von kleiner oder gleich 1.', ' ');
INSERT INTO answer VALUES (1076, 269, 3, 'führen zur Erzeugung unerwünschter Aussendungen, da innerhalb der erforderlichen Bandbreite keine Anpassung gegeben ist.', ' ');
INSERT INTO answer VALUES (1077, 270, 0, 'Die Richtcharakteristik der Antenne wird verformt und es können Mantelwellen auftreten.', ' ');
INSERT INTO answer VALUES (1078, 270, 1, 'Es treten keine nennenswerten Auswirkungen auf, da die Antenne angepasst ist und die Speisung über ein Koaxkabel erfolgt, dessen Außenleiter Erdpotential hat.', ' ');
INSERT INTO answer VALUES (1079, 270, 2, 'Am Speisepunkt der Antenne treten gegenphasige Spannungen und Ströme gleicher Größe auf, die eine Fehlanpassung hervorrufen.', ' ');
INSERT INTO answer VALUES (1080, 270, 3, 'Es treten Polarisationsdrehungen auf, die von der Kabellänge abhängig sind.', ' ');
INSERT INTO answer VALUES (1081, 271, 0, 'den Dipol über ein Symmetrierglied zu speisen.', ' ');
INSERT INTO answer VALUES (1082, 271, 1, 'das Koaxialkabel durch eine Eindrahtspeiseleitung zu ersetzen.', ' ');
INSERT INTO answer VALUES (1083, 271, 2, 'beim Koaxialkabel alle 5 m eine Schleife mit 3 Windungen einzulegen.', ' ');
INSERT INTO answer VALUES (1084, 271, 3, 'das Koaxialkabel in einem Kunststoffrohr zur mechanischen Schirmung unterzubringen.', ' ');
INSERT INTO answer VALUES (1085, 272, 0, 'Mantelwellen zu dämpfen.', ' ');
INSERT INTO answer VALUES (1086, 272, 1, 'statische Aufladungen zu verhindern.', ' ');
INSERT INTO answer VALUES (1087, 272, 2, 'eine Antennenleitung abzustimmen.', ' ');
INSERT INTO answer VALUES (1088, 272, 3, 'Oberwellen zu unterdrücken.', ' ');
INSERT INTO answer VALUES (1089, 273, 0, '25 W', ' ');
INSERT INTO answer VALUES (1090, 273, 1, '12,5 W', ' ');
INSERT INTO answer VALUES (1091, 273, 2, '50 W', ' ');
INSERT INTO answer VALUES (1092, 273, 3, '75 W', ' ');
INSERT INTO answer VALUES (1093, 274, 0, 'Die D-, E-, F1- und F2-Schicht', ' ');
INSERT INTO answer VALUES (1094, 274, 1, 'Die E- und F-Schicht', ' ');
INSERT INTO answer VALUES (1095, 274, 2, 'Die F1- und F2-Schicht', ' ');
INSERT INTO answer VALUES (1096, 274, 3, 'Die E- und D-Schicht', ' ');
INSERT INTO answer VALUES (1097, 275, 0, 'Die F2-Schicht', ' ');
INSERT INTO answer VALUES (1098, 275, 1, 'Die D-, E- und F2-Schicht', ' ');
INSERT INTO answer VALUES (1099, 275, 2, 'Die F1- und F2-Schicht', ' ');
INSERT INTO answer VALUES (1100, 275, 3, 'Die D- und E-Schicht', ' ');
INSERT INTO answer VALUES (1101, 276, 0, '200 bis 500 km Höhe.', ' ');
INSERT INTO answer VALUES (1102, 276, 1, '2 bis 5 km Höhe.', ' ');
INSERT INTO answer VALUES (1103, 276, 2, '20 bis 50 km Höhe.', ' ');
INSERT INTO answer VALUES (1104, 276, 3, '2000 bis 5000 km Höhe.', ' ');
INSERT INTO answer VALUES (1105, 277, 0, 'Die D-Schicht führt tagsüber zu starker Dämpfung im 80- und 160-m-Band.', ' ');
INSERT INTO answer VALUES (1106, 277, 1, 'Die D-Schicht reflektiert tagsüber die Wellen im 80- und 160-m-Band.', ' ');
INSERT INTO answer VALUES (1107, 277, 2, 'Die D-Schicht absorbiert tagsüber die Wellen im 10-m-Band.', ' ');
INSERT INTO answer VALUES (1108, 277, 3, 'Die D-Schicht ist im Sonnenfleckenmaximum am wenigsten ausgeprägt.', ' ');
INSERT INTO answer VALUES (1109, 278, 0, 'elektrisch aufgeladenen Luftschichten in der Ionosphäre.', ' ');
INSERT INTO answer VALUES (1110, 278, 1, 'Hoch- und Tiefdruckgebieten der hohen Atmosphäre.', ' ');
INSERT INTO answer VALUES (1111, 278, 2, 'den Wolken in der niedrigen Atmosphäre.', ' ');
INSERT INTO answer VALUES (1112, 278, 3, 'den parasitären Elementen einer Richtantenne.', ' ');
INSERT INTO answer VALUES (1113, 279, 0, 'Die E-Schicht', ' ');
INSERT INTO answer VALUES (1114, 279, 1, 'Die D-Schicht', ' ');
INSERT INTO answer VALUES (1115, 279, 2, 'Die F1-Schicht', ' ');
INSERT INTO answer VALUES (1116, 279, 3, 'Die F2-Schicht', ' ');
INSERT INTO answer VALUES (1117, 280, 0, '11 Jahre', ' ');
INSERT INTO answer VALUES (1118, 280, 1, '6 Monate', ' ');
INSERT INTO answer VALUES (1119, 280, 2, '12 Monate', ' ');
INSERT INTO answer VALUES (1120, 280, 3, '100 Jahre', ' ');
INSERT INTO answer VALUES (1121, 281, 0, '300 000 km/s.', ' ');
INSERT INTO answer VALUES (1122, 281, 1, '3 000 000 km/s.', ' ');
INSERT INTO answer VALUES (1123, 281, 2, '30 000 km/s.', ' ');
INSERT INTO answer VALUES (1124, 281, 3, '3 000 km/s.', ' ');
INSERT INTO answer VALUES (1125, 282, 0, 'der durch die Bodenwelle nicht mehr erreicht wird und durch die reflektierte Raumwelle noch nicht erreicht wird.', ' ');
INSERT INTO answer VALUES (1126, 282, 1, 'der durch die Bodenwelle überdeckt wird, so dass schwächere DX-Stationen zugedeckt werden.', ' ');
INSERT INTO answer VALUES (1127, 282, 2, 'der durch die Bodenwelle erreicht wird und für die Raumwelle nicht zugänglich ist.', ' ');
INSERT INTO answer VALUES (1128, 282, 3, 'der durch die Interferenz der Bodenwelle mit der Raumwelle in einer Zone der gegenseitigen Auslöschung liegt.', ' ');
INSERT INTO answer VALUES (1129, 283, 0, 'Die Bodenwelle folgt der Erdkrümmung und geht über den geografischen Horizont hinaus. Sie wird in höheren Frequenzbereichen stärker gedämpft als in niedrigeren Frequenzbereichen.', ' ');
INSERT INTO answer VALUES (1130, 283, 1, 'Die Bodenwelle folgt der Erdkrümmung und geht nicht über den geografischen Horizont hinaus. Sie wird in höheren Frequenzbereichen stärker gedämpft als in niedrigeren Frequenzbereichen.', ' ');
INSERT INTO answer VALUES (1131, 283, 2, 'Die Bodenwelle folgt der Erdkrümmung und geht über den geografischen Horizont hinaus. Sie wird in niedrigeren Frequenzbereichen stärker gedämpft als in höheren Frequenzbereichen.', ' ');
INSERT INTO answer VALUES (1132, 283, 3, 'Die Bodenwelle folgt der Erdkrümmung und geht nicht über den geografischen Horizont hinaus. Sie wird in niedrigeren Frequenzbereichen stärker gedämpft als in höheren Frequenzbereichen.', ' ');
INSERT INTO answer VALUES (1133, 284, 0, 'Etwa 2200 km', ' ');
INSERT INTO answer VALUES (1134, 284, 1, 'Etwa 1100 km', ' ');
INSERT INTO answer VALUES (1135, 284, 2, 'Etwa 4500 km', ' ');
INSERT INTO answer VALUES (1136, 284, 3, 'Etwa 9000 km', ' ');
INSERT INTO answer VALUES (1137, 285, 0, 'vom Abstrahlwinkel der Antenne.', ' ');
INSERT INTO answer VALUES (1138, 285, 1, 'von der Polarisation der Antenne.', ' ');
INSERT INTO answer VALUES (1139, 285, 2, 'von der Sendeleistung.', ' ');
INSERT INTO answer VALUES (1140, 285, 3, 'vom Antennengewinn.', ' ');
INSERT INTO answer VALUES (1141, 286, 0, 'Der Streifen der Dämmerungsphase vor Sonnenaufgang oder nach Sonnenuntergang.', ' ');
INSERT INTO answer VALUES (1142, 286, 1, 'Die instabilen Ausbreitungsbedingungen in der Äquatorialzone.', ' ');
INSERT INTO answer VALUES (1143, 286, 2, 'Die Zeit mit den besten Möglichkeiten für "Short Skip" Ausbreitung.', ' ');
INSERT INTO answer VALUES (1144, 286, 3, 'Die Übergangszeit vor und nach dem Winter, in der sich die D-Schicht ab- und wieder aufbaut.', ' ');
INSERT INTO answer VALUES (1145, 287, 0, 'Den totalen, zeitlich begrenzten Ausfall der Reflexion in der Ionosphäre.', ' ');
INSERT INTO answer VALUES (1146, 287, 1, 'Den zeitlich begrenzten Schwund durch Mehrwegeausbreitung in der Ionosphäre.', ' ');
INSERT INTO answer VALUES (1147, 287, 2, 'Die zeitlich begrenzt auftretende Verzerrung der Modulation.', ' ');
INSERT INTO answer VALUES (1148, 287, 3, 'Das Übersprechen der Modulation eines starken Senders auf andere, über die Ionosphäre übertragene HF-Signale.', ' ');
INSERT INTO answer VALUES (1149, 288, 0, 'Mögel-Dellinger-Effekt bezeichnet.', ' ');
INSERT INTO answer VALUES (1150, 288, 1, 'sporadische E-Ausbreitung bezeichnet.', ' ');
INSERT INTO answer VALUES (1151, 288, 2, 'kritischer Schwund bezeichnet.', ' ');
INSERT INTO answer VALUES (1152, 288, 3, 'Aurora-Effekt bezeichnet.', ' ');
INSERT INTO answer VALUES (1153, 289, 0, 'durch Reflexion an sporadischen E-Schichten ermöglicht werden.', ' ');
INSERT INTO answer VALUES (1154, 289, 1, 'bei entsprechendem Abstrahlwinkel durch Reflexion an der F1-Schicht ermöglicht werden.', ' ');
INSERT INTO answer VALUES (1155, 289, 2, 'bei entsprechendem Abstrahlwinkel durch Reflexion an der F2-Schicht ermöglicht werden.', ' ');
INSERT INTO answer VALUES (1156, 289, 3, 'durch Reflexion an hochionisierten D-Schichten ermöglicht werden.', ' ');
INSERT INTO answer VALUES (1157, 290, 0, 'D-Schicht', ' ');
INSERT INTO answer VALUES (1158, 290, 1, 'F1-Schicht', ' ');
INSERT INTO answer VALUES (1159, 290, 2, 'F2-Schicht', ' ');
INSERT INTO answer VALUES (1160, 290, 3, 'A-Schicht', ' ');
INSERT INTO answer VALUES (1161, 291, 0, 'In der E-Schicht', ' ');
INSERT INTO answer VALUES (1162, 291, 1, 'In der F-Schicht', ' ');
INSERT INTO answer VALUES (1163, 291, 2, 'In der E-Schicht in der Nähe des Äquators', ' ');
INSERT INTO answer VALUES (1164, 291, 3, 'In der D-Schicht', ' ');
INSERT INTO answer VALUES (1165, 292, 0, 'Höchste brauchbare Frequenz', ' ');
INSERT INTO answer VALUES (1166, 292, 1, 'Niedrigste brauchbare Frequenz', ' ');
INSERT INTO answer VALUES (1167, 292, 2, 'Kritische Grenzfrequenz', ' ');
INSERT INTO answer VALUES (1168, 292, 3, 'Mittlere Nutzfrequenz', ' ');
INSERT INTO answer VALUES (1169, 293, 0, 'Fading', ' ');
INSERT INTO answer VALUES (1170, 293, 1, 'Flatterfading', ' ');
INSERT INTO answer VALUES (1171, 293, 2, 'MUF', ' ');
INSERT INTO answer VALUES (1172, 293, 3, 'Mögel-Dellinger-Effekt', ' ');
INSERT INTO answer VALUES (1173, 294, 0, '15 % weiter als der geografische Horizont.', ' ');
INSERT INTO answer VALUES (1174, 294, 1, 'doppelt so weit.', ' ');
INSERT INTO answer VALUES (1175, 294, 2, 'bis zur Hälfte der Entfernung bis zum geografischen Horizont.', ' ');
INSERT INTO answer VALUES (1176, 294, 3, 'bis zum Vierfachen der Entfernung bis zum geografischen Horizont.', ' ');
INSERT INTO answer VALUES (1177, 295, 0, 'Streuung der Wellen an troposphärischen Bereichen unterschiedlicher Beschaffenheit.', ' ');
INSERT INTO answer VALUES (1178, 295, 1, 'Reflexion der Wellen in der Troposphäre durch das Auftreten sporadischer D-Schichten.', ' ');
INSERT INTO answer VALUES (1179, 295, 2, 'Polarisationsdrehungen in der Troposphäre bei hoch liegender Bewölkung.', ' ');
INSERT INTO answer VALUES (1180, 295, 3, 'Polarisationsdrehungen in der Troposphäre an Gewitterfronten.', ' ');
INSERT INTO answer VALUES (1181, 296, 0, 'troposphärische Ausbreitung genutzt.', ' ');
INSERT INTO answer VALUES (1182, 296, 1, 'ionosphärische Ausbreitung genutzt.', ' ');
INSERT INTO answer VALUES (1183, 296, 2, 'Bodenwellenausbreitung genutzt.', ' ');
INSERT INTO answer VALUES (1184, 296, 3, 'Oberflächenwellenausbreitung genutzt.', ' ');
INSERT INTO answer VALUES (1185, 297, 0, 'untere Teil der Atmosphäre, in der die Erscheinungen des Wetters stattfinden.', ' ');
INSERT INTO answer VALUES (1186, 297, 1, 'untere Teil der Atmosphäre, der sich nördlich und südlich des Äquators über die Tropen erstreckt.', ' ');
INSERT INTO answer VALUES (1187, 297, 2, 'obere Teil der Atmosphäre, in der es zur Bildung sporadischer E-Schichten kommen kann.', ' ');
INSERT INTO answer VALUES (1188, 297, 3, 'obere Teil der Atmosphäre, in welcher Aurora- Erscheinungen auftreten können.', ' ');
INSERT INTO answer VALUES (1189, 298, 0, 'die optische Sichtweite zunimmt.', ' ');
INSERT INTO answer VALUES (1190, 298, 1, 'die dämpfende Wirkung der Erdoberfläche abnimmt.', ' ');
INSERT INTO answer VALUES (1191, 298, 2, 'die Entfernung zu den reflektierenden Schichten der Troposphäre abnimmt.', ' ');
INSERT INTO answer VALUES (1192, 298, 3, 'in höheren Luftschichten die Temperatur sinkt.', ' ');
INSERT INTO answer VALUES (1193, 299, 0, 'das Eindringen geladener Teilchen von der Sonne in die Atmosphäre.', ' ');
INSERT INTO answer VALUES (1194, 299, 1, 'eine hohe Sonnenfleckenzahl.', ' ');
INSERT INTO answer VALUES (1195, 299, 2, 'eine niedrige Sonnenfleckenzahl.', ' ');
INSERT INTO answer VALUES (1196, 299, 3, 'das Auftreten von Meteoritenschauern in den polaren Regionen.', ' ');
INSERT INTO answer VALUES (1197, 300, 0, 'CW-Signale haben einen flatternden und verbrummten Ton.', ' ');
INSERT INTO answer VALUES (1198, 300, 1, 'CW- Signale haben einen besseren Ton.', ' ');
INSERT INTO answer VALUES (1199, 300, 2, 'Die Lesbarkeit der SSB-Signale verbessert sich.', ' ');
INSERT INTO answer VALUES (1200, 300, 3, 'Die Lesbarkeit der FM-Signale verbessert sich.', ' ');
INSERT INTO answer VALUES (1201, 301, 0, 'CW', ' ');
INSERT INTO answer VALUES (1202, 301, 1, 'SSB', ' ');
INSERT INTO answer VALUES (1203, 301, 2, 'FM', ' ');
INSERT INTO answer VALUES (1204, 301, 3, 'PSK31', ' ');
INSERT INTO answer VALUES (1205, 302, 0, 'die Reflexion an lokal begrenzten Bereichen mit ungewöhnlich hoher Ionisation innerhalb der E-Schicht.', ' ');
INSERT INTO answer VALUES (1206, 302, 1, 'kurzfristige plötzliche Inversionsänderungen in der E-Schicht, die Fernausbreitung im VHF-Bereich ermöglichen.', ' ');
INSERT INTO answer VALUES (1207, 302, 2, 'kurzzeitig auftretende starke Reflexion von VHF-Signalen an Meteorbahnen innerhalb der E-Schicht.', ' ');
INSERT INTO answer VALUES (1208, 302, 3, 'lokal begrenzten kurzzeitigen Ausfall der Reflexion durch ungewöhnlich hohe Ionisation innerhalb der E-Schicht.', ' ');
INSERT INTO answer VALUES (1209, 303, 0, 'Am besten S-E3, am schlechtesten S-E1', ' ');
INSERT INTO answer VALUES (1210, 303, 1, 'Am besten S-E1, am schlechtesten S-E4', ' ');
INSERT INTO answer VALUES (1211, 303, 2, 'Am besten S-E3, am schlechtesten S-E4', ' ');
INSERT INTO answer VALUES (1212, 303, 3, 'Am besten S-E4, am schlechtesten S-E1', ' ');
INSERT INTO answer VALUES (1213, 304, 0, 'der Wechselwirkung der Kräfte zwischen einem permanent magnetischen und einem elektromagnetischen Feld.', ' ');
INSERT INTO answer VALUES (1214, 304, 1, 'der Wechselwirkung der Kräfte zwischen einem magnetischen und einem elektrischen Feld.', ' ');
INSERT INTO answer VALUES (1215, 304, 2, 'der Wechselwirkung der Kräfte zwischen zwei permanent magnetischen Feldern.', ' ');
INSERT INTO answer VALUES (1216, 304, 3, 'dem erdmagnetischen Feld.', ' ');
INSERT INTO answer VALUES (1217, 305, 0, 'der kleinsten Einteilung der Anzeige.', ' ');
INSERT INTO answer VALUES (1218, 305, 1, 'der Genauigkeit des Instrumentes in Bezug auf den tatsächlichen Wert.', ' ');
INSERT INTO answer VALUES (1219, 305, 2, 'der Genauigkeit des Instrumentes.', ' ');
INSERT INTO answer VALUES (1220, 305, 3, 'dem Vollausschlag der Instrumentenanzeige.', ' ');
INSERT INTO answer VALUES (1221, 306, 0, 'ein abstimmbarer Oszillator mit einem Indikator, der anzeigt, wenn von einem ankoppelten Resonanzkreis bei einer Frequenz HF-Energie aufgenommen oder abgegeben wird.', ' ');
INSERT INTO answer VALUES (1222, 306, 1, 'ein selektiver Feldstärkemesser, der den Maximalwert der elektrischen Feldstärke anzeigt und der zur Überprüfung der Nutzsignal- und Nebenwellenabstrahlungen eingesetzt werden kann.', ' ');
INSERT INTO answer VALUES (1223, 306, 2, 'eine abgleichbare Stehwellenmessbrücke, mit der der Reflexionsfaktor und der Impedanzverlauf einer angeschlossenen Antenne oder einer LC-Kombination gemessen werden kann.', ' ');
INSERT INTO answer VALUES (1224, 306, 3, 'ein auf eine feste Frequenz eingestellter RC-Schwingkreis mit einem Indikator, der anzeigt, wie stark die Abstrahlung unerwünschter Oberwellen ist.', ' ');
INSERT INTO answer VALUES (1225, 307, 0, 'ungefähren Bestimmung der Resonanzfrequenz eines Schwingkreises.', ' ');
INSERT INTO answer VALUES (1226, 307, 1, 'ungefähren Bestimmung der Leistung eines Senders.', ' ');
INSERT INTO answer VALUES (1227, 307, 2, 'genauen Bestimmung der Dämpfung eines Schwingkreises.', ' ');
INSERT INTO answer VALUES (1228, 307, 3, 'genauen Bestimmung der Güte eines Schwingkreises.', ' ');
INSERT INTO answer VALUES (1229, 308, 0, 'Ein Dipmeter', ' ');
INSERT INTO answer VALUES (1230, 308, 1, 'Eine VSWR-Messbrücke', ' ');
INSERT INTO answer VALUES (1231, 308, 2, 'Ein Frequenzmessgerät', ' ');
INSERT INTO answer VALUES (1232, 308, 3, 'Ein Resonanzwellenmesser', ' ');
INSERT INTO answer VALUES (1233, 309, 0, 'durch Messung von L und C und Berechnung oder z.B. mit einem Dipmeter.', ' ');
INSERT INTO answer VALUES (1234, 309, 1, 'mit einem Frequenzmesser oder einem Oszilloskop.', ' ');
INSERT INTO answer VALUES (1235, 309, 2, 'mit einem Digital -Multimeter in der Stellung Frequenzmessung.', ' ');
INSERT INTO answer VALUES (1236, 309, 3, 'mit Hilfe der S-Meter Anzeige bei Anschluss des Schwingkreises an den Empfängereingang.', ' ');
INSERT INTO answer VALUES (1237, 310, 0, 'Signalverläufe sichtbar zu machen, um beispielsweise Verzerrungen zu erkennen.', ' ');
INSERT INTO answer VALUES (1238, 310, 1, 'Frequenzen genau zu messen.', ' ');
INSERT INTO answer VALUES (1239, 310, 2, 'den Temperaturverlauf bei Messungen sichtbar zu machen.', ' ');
INSERT INTO answer VALUES (1240, 310, 3, 'die Anpassung bei Antennen zu überprüfen.', ' ');
INSERT INTO answer VALUES (1241, 311, 0, 'Ein Oszilloskop', ' ');
INSERT INTO answer VALUES (1242, 311, 1, 'Ein Transistorvoltmeter', ' ');
INSERT INTO answer VALUES (1243, 311, 2, 'Ein Vielfachmessgerät', ' ');
INSERT INTO answer VALUES (1244, 311, 3, 'Ein Frequenzzähler', ' ');
INSERT INTO answer VALUES (1245, 312, 0, 'ungewendelten Kohleschichtwiderständen zusammengebaut sein.', ' ');
INSERT INTO answer VALUES (1246, 312, 1, 'hochbelastbaren Drahtwiderständen zusammengebaut sein.', ' ');
INSERT INTO answer VALUES (1247, 312, 2, 'Glühbirnen zusammengebaut sein.', ' ');
INSERT INTO answer VALUES (1248, 312, 3, 'temperaturfesten Blindwiderständen bestehen.', ' ');
INSERT INTO answer VALUES (1249, 313, 0, '10 Kohleschichtwiderstände von 500 &Omega;', ' ');
INSERT INTO answer VALUES (1250, 313, 1, 'ein 50-&Omega;-Drahtwiderstand', ' ');
INSERT INTO answer VALUES (1251, 313, 2, '2 parallel geschaltete Drahtwiderstände von 100 ..', ' ');
INSERT INTO answer VALUES (1252, 313, 3, 'ein Spulenanpassfilter im Ölbad', ' ');
INSERT INTO answer VALUES (1253, 314, 0, '<img src=''etj201a.png''>', ' ');
INSERT INTO answer VALUES (1254, 314, 1, '<img src=''etj201b.png''>', ' ');
INSERT INTO answer VALUES (1255, 314, 2, '<img src=''etj201c.png''>', ' ');
INSERT INTO answer VALUES (1256, 314, 3, '<img src=''etj201d.png''>', ' ');
INSERT INTO answer VALUES (1257, 315, 0, 'Der Spannungsmesser ist parallel zum Messobjekt anzuschließen und sollte hochohmig sein.', ' ');
INSERT INTO answer VALUES (1258, 315, 1, 'Der Spannungsmesser ist in den Stromkreis einzuschleifen und sollte niederohmig sein.', ' ');
INSERT INTO answer VALUES (1259, 315, 2, 'Der Spannungsmesser ist parallel zum Messobjekt anzuschließen und sollte niederohmig sein.', ' ');
INSERT INTO answer VALUES (1260, 315, 3, 'Der Spannungsmesser ist in den Stromkreis einzuschleifen und sollte hochohmig sein.', ' ');
INSERT INTO answer VALUES (1261, 316, 0, '250 Hz.', ' ');
INSERT INTO answer VALUES (1262, 316, 1, '500 Hz.', ' ');
INSERT INTO answer VALUES (1263, 316, 2, '667 Hz.', ' ');
INSERT INTO answer VALUES (1264, 316, 3, '333 Hz.', ' ');
INSERT INTO answer VALUES (1265, 317, 0, 'Zur Überprüfung der Anpassung des Senders an die Antenne.', ' ');
INSERT INTO answer VALUES (1266, 317, 1, 'Zur Frequenzkontrolle.', ' ');
INSERT INTO answer VALUES (1267, 317, 2, 'Zur Modulationskontrolle.', ' ');
INSERT INTO answer VALUES (1268, 317, 3, 'Als Abschluss des Senders.', ' ');
INSERT INTO answer VALUES (1269, 318, 0, '2,93 V', ' ');
INSERT INTO answer VALUES (1270, 318, 1, '29,3 V', ' ');
INSERT INTO answer VALUES (1271, 318, 2, '8,8 V', ' ');
INSERT INTO answer VALUES (1272, 318, 3, '88 V', ' ');
INSERT INTO answer VALUES (1273, 319, 0, 'Antennenkabel und Antenne.', ' ');
INSERT INTO answer VALUES (1274, 319, 1, 'Senderausgang und Antennenkabel.', ' ');
INSERT INTO answer VALUES (1275, 319, 2, 'Antennenkabel und Dummy Load.', ' ');
INSERT INTO answer VALUES (1276, 319, 3, 'Senderausgang und Antennenanpassgerät.', ' ');
INSERT INTO answer VALUES (1277, 320, 0, 'ein Stehwellenverhältnis von 1 anzeigen.', ' ');
INSERT INTO answer VALUES (1278, 320, 1, 'einen Rücklauf von 100% anzeigen.', ' ');
INSERT INTO answer VALUES (1279, 320, 2, 'ein Stehwellenverhältnis von 0 anzeigen.', ' ');
INSERT INTO answer VALUES (1280, 320, 3, 'ein Stehwellenverhältnis von unendlich anzeigen.', ' ');
INSERT INTO answer VALUES (1281, 321, 0, 'Ein Frequenzzähler', ' ');
INSERT INTO answer VALUES (1282, 321, 1, 'Ein Resonanzwellenmesser', ' ');
INSERT INTO answer VALUES (1283, 321, 2, 'Ein Oszilloskop', ' ');
INSERT INTO answer VALUES (1284, 321, 3, 'Ein Universalmessgerät', ' ');
INSERT INTO answer VALUES (1285, 322, 0, 'mit einer VSWR-Messbrücke.', ' ');
INSERT INTO answer VALUES (1286, 322, 1, 'mit einem Absorptionswellenmesser oder einem Dipmeter.', ' ');
INSERT INTO answer VALUES (1287, 322, 2, 'durch Strommessung am Anfang und am Ende der Speiseleitung.', ' ');
INSERT INTO answer VALUES (1288, 322, 3, 'durch Spannungsmessung am Anfang und am Ende der Speiseleitung.', ' ');
INSERT INTO answer VALUES (1289, 323, 0, 'der Antennenanpassung.', ' ');
INSERT INTO answer VALUES (1290, 323, 1, 'der Oberwellenausgangsleistung.', ' ');
INSERT INTO answer VALUES (1291, 323, 2, 'der Bandbreite.', ' ');
INSERT INTO answer VALUES (1292, 323, 3, 'des Wirkungsgrades.', ' ');
INSERT INTO answer VALUES (1293, 324, 0, 'Punkt 1', ' ');
INSERT INTO answer VALUES (1294, 324, 1, 'Punkt 2', ' ');
INSERT INTO answer VALUES (1295, 324, 2, 'Punkt 3', ' ');
INSERT INTO answer VALUES (1296, 324, 3, 'Punkt 4', ' ');
INSERT INTO answer VALUES (1297, 325, 0, 'Durch den Rückgang der Empfindlichkeit und ggf. das Auftreten von Brodelgeräuschen.', ' ');
INSERT INTO answer VALUES (1298, 325, 1, 'Durch Empfindlichkeitssteigerung.', ' ');
INSERT INTO answer VALUES (1299, 325, 2, 'Durch das Auftreten von Pfeifstellen im gesamten Abstimmungsbereich.', ' ');
INSERT INTO answer VALUES (1300, 325, 3, 'Durch eine zeitweilige Blockierung der Frequenzeinstellung.', ' ');
INSERT INTO answer VALUES (1301, 326, 0, 'Es treten Phantomsignale auf, die bei Einschalten eines Abschwächers verschwinden.', ' ');
INSERT INTO answer VALUES (1302, 326, 1, 'Das Nutzsignal wird mit einem anderen Signal moduliert und dadurch unverständlich.', ' ');
INSERT INTO answer VALUES (1303, 326, 2, 'Es treten Pfeifstellen gleichen Abstands im gesamten Empfangsbereich auf.', ' ');
INSERT INTO answer VALUES (1304, 326, 3, 'Dem Empfangssignal ist ein pulsierendes Rauschen überlagert, das die Verständlichkeit beeinträchtigt.', ' ');
INSERT INTO answer VALUES (1305, 327, 0, 'Sie empfehlen dem Nachbarn höflich, sich an die Bundesnetzagentur zur Prüfung der Störungsursache zu wenden.', ' ');
INSERT INTO answer VALUES (1306, 327, 1, 'Der Nachbar sollte höflich darauf hingewiesen werden, dass es an seiner eigenen Einrichtung liegt.', ' ');
INSERT INTO answer VALUES (1307, 327, 2, 'Der Nachbar sollte darauf hingewiesen werden, dass Sie hierfür nicht zuständig sind.', ' ');
INSERT INTO answer VALUES (1308, 327, 3, 'Sie benachrichtigen ihren Amateurfunkverband.', ' ');
INSERT INTO answer VALUES (1309, 328, 0, 'den geltenden Richtwerten entsprechen.', ' ');
INSERT INTO answer VALUES (1310, 328, 1, '30 dB betragen.', ' ');
INSERT INTO answer VALUES (1311, 328, 2, '100 dB betragen.', ' ');
INSERT INTO answer VALUES (1312, 328, 3, '20 dB betragen.', ' ');
INSERT INTO answer VALUES (1313, 329, 0, 'über Leitungen oder Kabel in das zu überprüfende Gerät gelangt.', ' ');
INSERT INTO answer VALUES (1314, 329, 1, 'über das ungenügend abgeschirmte Gehäuse in die Elektronik gelangt.', ' ');
INSERT INTO answer VALUES (1315, 329, 2, 'über nicht genügend geschirmte Kabel zum Anpassgerät geführt wird.', ' ');
INSERT INTO answer VALUES (1316, 329, 3, 'wegen eines schlechten Stehwellenverhältnisses wieder zum Sender zurück strömt.', ' ');
INSERT INTO answer VALUES (1317, 330, 0, 'über das ungenügend abgeschirmte Gehäuse in die Elektronik gelangt.', ' ');
INSERT INTO answer VALUES (1318, 330, 1, 'über Leitungen oder Kabel in das gestörte Gerät gelangt.', ' ');
INSERT INTO answer VALUES (1319, 330, 2, 'über nicht genügend geschirmte Kabel zum gestörten Empfänger gelangt.', ' ');
INSERT INTO answer VALUES (1320, 330, 3, 'wegen eines schlechten Stehwellenverhältnisses wieder zum Sender zurück strahlt.', ' ');
INSERT INTO answer VALUES (1321, 331, 0, 'Blockierung oder störende Beeinflussung', ' ');
INSERT INTO answer VALUES (1322, 331, 1, 'Störung durch unerwünschte Aussendungen', ' ');
INSERT INTO answer VALUES (1323, 331, 2, 'Störung durch Nebenaussendungen', ' ');
INSERT INTO answer VALUES (1324, 331, 3, 'Hinzunehmende Störung', ' ');
INSERT INTO answer VALUES (1325, 332, 0, 'Durch Gleichrichtung starker HF-Signale in der NF-Endstufe der Stereoanlage.', ' ');
INSERT INTO answer VALUES (1326, 332, 1, 'Durch Gleichrichtung der ins Stromnetz eingestrahlten HF-Signale an den Dioden des Netzteils.', ' ');
INSERT INTO answer VALUES (1327, 332, 2, 'Durch Gleichrichtung abgestrahlter HF-Signale an PN-Übergängen in der NF-Vorstufe.', ' ');
INSERT INTO answer VALUES (1328, 332, 3, 'Durch eine Übersteuerung des Tuners mit dem über die Antennenzuleitung aufgenommenen HF-Signal.', ' ');
INSERT INTO answer VALUES (1329, 333, 0, 'Über jeden beliebigen Leitungsanschluss und/oder über die ZF-Stufen.', ' ');
INSERT INTO answer VALUES (1330, 333, 1, 'Über die Antennenleitung und über alle größeren ungeschirmten Spulen im Fernsehgerät (z.B. Entmagnetisierungsschleife).', ' ');
INSERT INTO answer VALUES (1331, 333, 2, 'Über die Stromversorgung des Senders und die Stromversorgung des Fernsehgeräts.', ' ');
INSERT INTO answer VALUES (1332, 333, 3, 'Über die Fernsehantenne bzw. das Antennenkabel sowie über die Bildröhre.', ' ');
INSERT INTO answer VALUES (1333, 334, 0, 'einem hohen Nebenwellenanteil.', ' ');
INSERT INTO answer VALUES (1334, 334, 1, 'lediglich geringen Verzerrungen beim Empfang.', ' ');
INSERT INTO answer VALUES (1335, 334, 2, 'einer besseren Verständlichkeit am Empfangsort.', ' ');
INSERT INTO answer VALUES (1336, 334, 3, 'einer Verringerung der Ausgangsleistung.', ' ');
INSERT INTO answer VALUES (1337, 335, 0, '7,5 kHz.', ' ');
INSERT INTO answer VALUES (1338, 335, 1, '0 kHz.', ' ');
INSERT INTO answer VALUES (1339, 335, 2, '15 kHz.', ' ');
INSERT INTO answer VALUES (1340, 335, 3, '2,7 kHz.', ' ');
INSERT INTO answer VALUES (1341, 336, 0, 'Hubeinstellung', ' ');
INSERT INTO answer VALUES (1342, 336, 1, 'HF-Begrenzereigenschaften', ' ');
INSERT INTO answer VALUES (1343, 336, 2, 'Vorspannungsreglereinstellung', ' ');
INSERT INTO answer VALUES (1344, 336, 3, 'Trägerfrequenz', ' ');
INSERT INTO answer VALUES (1345, 337, 0, 'er keine unerwünschten Aussendungen hervorruft.', ' ');
INSERT INTO answer VALUES (1346, 337, 1, 'die Selbsterregung maximiert wird.', ' ');
INSERT INTO answer VALUES (1347, 337, 2, 'parasitäre Schwingungen vorhanden sind.', ' ');
INSERT INTO answer VALUES (1348, 337, 3, 'die Oberwellenabschirmung minimiert wird.', ' ');
INSERT INTO answer VALUES (1349, 338, 0, 'werden Gleichtakt-HF-Störsignale unterdrückt.', ' ');
INSERT INTO answer VALUES (1350, 338, 1, 'werden niederfrequente Störsignale unterdrückt.', ' ');
INSERT INTO answer VALUES (1351, 338, 2, 'werden alle Wechselstromsignale unterdrückt.', ' ');
INSERT INTO answer VALUES (1352, 338, 3, 'wird Netzbrummen unterdrückt.', ' ');
INSERT INTO answer VALUES (1353, 339, 0, 'Rechtwinklig zur Häuserzeile mit abgewandter Strahlungsrichtung', ' ');
INSERT INTO answer VALUES (1354, 339, 1, 'Am gemeinsamen Schornstein neben der Fernsehantenne', ' ');
INSERT INTO answer VALUES (1355, 339, 2, 'Entlang der Häuserzeile auf der Höhe der Dachrinne', ' ');
INSERT INTO answer VALUES (1356, 339, 3, 'Möglichst innerhalb des Dachbereichs', ' ');
INSERT INTO answer VALUES (1357, 340, 0, 'eine außen angebrachte Fernsehantenne zu installieren.', ' ');
INSERT INTO answer VALUES (1358, 340, 1, 'ein doppelt geschirmtes Koaxialkabel für die Antennenleitung zu verwenden.', ' ');
INSERT INTO answer VALUES (1359, 340, 2, 'einen Vorverstärker in die Antennenleitung einzuschleifen.', ' ');
INSERT INTO answer VALUES (1360, 340, 3, 'den Fernsehrundfunkempfänger zu wechseln.', ' ');
INSERT INTO answer VALUES (1361, 341, 0, 'die zuständige Außenstelle der Bundesnetzagentur um Prüfung der Gegebenheiten zu bitten.', ' ');
INSERT INTO answer VALUES (1362, 341, 1, 'der Sender an die Bundesnetzagentur zu senden.', ' ');
INSERT INTO answer VALUES (1363, 341, 2, 'die Rückseite des Fernsehgeräts zu entfernen und das Gehäuse zu erden.', ' ');
INSERT INTO answer VALUES (1364, 341, 3, 'ein Fernsehtechniker um Prüfung des Fernsehgeräts zu bitten.', ' ');
INSERT INTO answer VALUES (1365, 342, 0, 'auf das für eine zufrieden stellende Kommunikation erforderliche Minimum eingestellt werden.', ' ');
INSERT INTO answer VALUES (1366, 342, 1, 'nur auf den zulässigen Pegel eingestellt werden.', ' ');
INSERT INTO answer VALUES (1367, 342, 2, 'auf die für eine zufriedenstellende Kommunikation erforderlichen 100 W eingestellt werden.', ' ');
INSERT INTO answer VALUES (1368, 342, 3, 'die Hälfte des maximal zulässigen Pegels betragen.', ' ');
INSERT INTO answer VALUES (1369, 343, 0, 'Ein Hochpassfilter', ' ');
INSERT INTO answer VALUES (1370, 343, 1, 'Ein Tiefpassfilter', ' ');
INSERT INTO answer VALUES (1371, 343, 2, 'Eine Bandsperre für die Fernsehbereiche', ' ');
INSERT INTO answer VALUES (1372, 343, 3, 'Ein regelbares Dämpfungsglied', ' ');
INSERT INTO answer VALUES (1373, 344, 0, 'Ein Hochpassfilter', ' ');
INSERT INTO answer VALUES (1374, 344, 1, 'Ein Tiefpassfilter', ' ');
INSERT INTO answer VALUES (1375, 344, 2, 'Ein UHF-Abschwächer', ' ');
INSERT INTO answer VALUES (1376, 344, 3, 'Eine UHF-Bandsperre', ' ');
INSERT INTO answer VALUES (1377, 345, 0, 'Ein Hochpassfilter vor dem Antennennanschluss und zusätzlich je eine Ferritdrossel vor alle Leitungsanschlüsse der gestörten Geräte.', ' ');
INSERT INTO answer VALUES (1378, 345, 1, 'Je ein Tiefpassfilter unmittelbar vor dem Antennennanschluss und in das Netzkabel der gestörten Geräte.', ' ');
INSERT INTO answer VALUES (1379, 345, 2, 'Eine Bandsperre für die Fernsehbereiche unmittelbar vor dem Antennennanschluss und ein Tiefpassfilter in das Netzkabel der gestörten Geräte.', ' ');
INSERT INTO answer VALUES (1380, 345, 3, 'Ein Bandpassfilter bei 30 MHz unmittelbar vor dem Antennennanschluss und ein Tiefpassfilter in das Netzkabel der gestörten Geräte.', ' ');
INSERT INTO answer VALUES (1381, 346, 0, 'eine Mantelwellendrossel einzubauen.', ' ');
INSERT INTO answer VALUES (1382, 346, 1, 'die Erdverbindung des Senders abzuklemmen.', ' ');
INSERT INTO answer VALUES (1383, 346, 2, 'das Abschirmgeflecht am Antennenstecker des Empfängers abzuklemmen.', ' ');
INSERT INTO answer VALUES (1384, 346, 3, 'den 144-MHz-Sender mit einem Tiefpassfilter auszustatten.', ' ');
INSERT INTO answer VALUES (1385, 347, 0, 'eine getrennte HF-Erdleitung zu verwenden.', ' ');
INSERT INTO answer VALUES (1386, 347, 1, 'Antennen auf dem Dachboden zu errichten.', ' ');
INSERT INTO answer VALUES (1387, 347, 2, 'die Amateurfunkgeräte mit einem Wasserrohr zu verbinden.', ' ');
INSERT INTO answer VALUES (1388, 347, 3, 'die Amateurfunkgeräte mittels des Schutzleiters zu erden.', ' ');
INSERT INTO answer VALUES (1389, 348, 0, 'geschirmte Lautsprecherleitungen zu verwenden.', ' ');
INSERT INTO answer VALUES (1390, 348, 1, 'ein NF-Filter in das Koaxialkabel einzuschleifen.', ' ');
INSERT INTO answer VALUES (1391, 348, 2, 'einen Serienkondensator in die Lautsprecherleitung einzubauen.', ' ');
INSERT INTO answer VALUES (1392, 348, 3, 'ein geschirmtes Netzkabel für den Receiver zu verwenden.', ' ');
INSERT INTO answer VALUES (1393, 349, 0, '<img src=''etk314a.png''>', ' ');
INSERT INTO answer VALUES (1394, 349, 1, '<img src=''etk314b.png''>', ' ');
INSERT INTO answer VALUES (1395, 349, 2, '<img src=''etk314c.png''>', ' ');
INSERT INTO answer VALUES (1396, 349, 3, '<img src=''etk314d.png''>', ' ');
INSERT INTO answer VALUES (1397, 350, 0, 'mit keiner höheren Leistung zu senden als für eine sichere Kommunikation erforderlich ist.', ' ');
INSERT INTO answer VALUES (1398, 350, 1, 'nur mit effektiver Leistung zu senden.', ' ');
INSERT INTO answer VALUES (1399, 350, 2, 'nur mit einer Hochgewinn-Richtantenne zu senden.', ' ');
INSERT INTO answer VALUES (1400, 350, 3, 'die Antenne unterhalb der Dachhöhe herabzulassen.', ' ');
INSERT INTO answer VALUES (1401, 351, 0, 'können Hochfrequenzströme eingekoppelt werden.', ' ');
INSERT INTO answer VALUES (1402, 351, 1, 'können harmonische Schwingungen erzeugt werden.', ' ');
INSERT INTO answer VALUES (1403, 351, 2, 'könnte erhebliche Überspannung im Netz erzeugt werden.', ' ');
INSERT INTO answer VALUES (1404, 351, 3, 'kann 50-Hz-Modulation aller Signale auftreten.', ' ');
INSERT INTO answer VALUES (1405, 352, 0, 'einer Übersteuerung eines TV-Empfängers.', ' ');
INSERT INTO answer VALUES (1406, 352, 1, 'Problemen mit dem 435-MHz-Empfänger.', ' ');
INSERT INTO answer VALUES (1407, 352, 2, 'Eigenschwingungen des 435-MHz-Senders.', ' ');
INSERT INTO answer VALUES (1408, 352, 3, 'dem Durchschlag des TV-Antennenkoaxialkabels.', ' ');
INSERT INTO answer VALUES (1409, 353, 0, 'Sender im 160-m-Band.', ' ');
INSERT INTO answer VALUES (1410, 353, 1, 'UHF-Sender.', ' ');
INSERT INTO answer VALUES (1411, 353, 2, 'VHF-Sender.', ' ');
INSERT INTO answer VALUES (1412, 353, 3, 'Sender im 10-m-Band.', ' ');
INSERT INTO answer VALUES (1413, 354, 0, 'kann in Verbindung mit dem Signal naher Sender unerwünschte Mischprodukte erzeugen, die den Fernsehempfang stören.', ' ');
INSERT INTO answer VALUES (1414, 354, 1, 'kann in Verbindung mit dem Oszillatorsignal des Fernsehempfängers unerwünschte Mischprodukte erzeugen, die den Fernsehempfang stören.', ' ');
INSERT INTO answer VALUES (1415, 354, 2, 'kann in Verbindung mit Einstreuungen aus dem Stromnetz durch Intermodulation Bild- und Tonstörungen hervorrufen.', ' ');
INSERT INTO answer VALUES (1416, 354, 3, 'kann in Verbindung mit dem Signal naher Sender parametrische Schwingungen erzeugen, die einen überhöhten Nutzsignalpegel hervorrufen.', ' ');
INSERT INTO answer VALUES (1417, 355, 0, 'sollten alle Einrichtungen mit einer guten HF-Erdung versehen werden.', ' ');
INSERT INTO answer VALUES (1418, 355, 1, 'sollte der Sender mit der Wasserleitung im Haus verbunden werden.', ' ');
INSERT INTO answer VALUES (1419, 355, 2, 'sollten alle schlechten Erdverbindungen entfernt werden.', ' ');
INSERT INTO answer VALUES (1420, 355, 3, 'sollten Wasserleitungsanschlüsse aus Polyäthylen zur Isolation vorgesehen werden.', ' ');
INSERT INTO answer VALUES (1421, 356, 0, 'P<sub>ERP</sub> = (P<sub>Sender</sub> - P<sub>Verluste</sub>) * G<sub>Antenne</sub> bezogen auf einen Halbwellendipol', ' ');
INSERT INTO answer VALUES (1422, 356, 1, 'P<sub>ERP</sub> = P<sub>Sender</sub> * G<sub>Antenne</sub> - P<sub>Verluste</sub> bezogen auf einen isotropen Kugelstrahler', ' ');
INSERT INTO answer VALUES (1423, 356, 2, 'P<sub>ERP</sub> = (P<sub>Sender</sub> + P<sub>Verluste</sub>) * G<sub>Antenne</sub> bezogen auf einen Halbwellendipol', ' ');
INSERT INTO answer VALUES (1424, 356, 3, 'P<sub>ERP</sub> = P<sub>Sender</sub> + P<sub>Verluste</sub> + G<sub>Antenne</sub> bezogen auf einen isotropen Kugelstrahler', ' ');
INSERT INTO answer VALUES (1425, 357, 0, 'P<sub>EIRP</sub> = (P<sub>Sender</sub> - P<sub>Verluste</sub>) * G<sub>Antenne</sub> bezogen auf einen isotropen Kugelstrahler', ' ');
INSERT INTO answer VALUES (1426, 357, 1, 'P<sub>EIRP</sub> = (P<sub>Sender</sub> * G<sub>Antenne</sub>) - P<sub>Verluste</sub> bezogen auf einen Halbwellendipol', ' ');
INSERT INTO answer VALUES (1427, 357, 2, 'P<sub>EIRP</sub> = (P<sub>Sender</sub> + P<sub>Verluste</sub>) * G<sub>Antenne</sub> bezogen auf einen Halbwellendipol', ' ');
INSERT INTO answer VALUES (1428, 357, 3, 'P<sub>EIRP</sub> = P<sub>Sender</sub> + P<sub>Verluste</sub> + G<sub>Antenne</sub> bezogen auf einen isotropen Kugelstrahler', ' ');
INSERT INTO answer VALUES (1429, 358, 0, 'Es ist das Produkt aus der zugeführten Leistung und dem Gewinnfaktor der Antenne und stellt die Leistung dar, die man einem isotropen Strahler zuführen müsste, damit dieser im Fernfeld dieselbe elektrische Feldstärke erzeugte, wie die Antenne.', ' ');
INSERT INTO answer VALUES (1430, 358, 1, 'Es ist die Eingangsleistung des verwendeten Senders wie sie in der EMVU-Selbsterklärung anzugeben ist.', ' ');
INSERT INTO answer VALUES (1431, 358, 2, 'Es handelt sich um die Leistung, die man im Maximum der Strahlungskeule einer Dipolantenne vorfindet.', ' ');
INSERT INTO answer VALUES (1432, 358, 3, 'Es ist das Produkt aus der zugeführten Leistung und dem Antennengewinnfaktor und stellt die durchschnittliche isotrope Spitzenleistung am Senderausgang der Amateurfunkstelle dar, wie sie in der EMVU-Selbsterklärung anzugeben ist.', ' ');
INSERT INTO answer VALUES (1433, 359, 0, '9,8 Watt', ' ');
INSERT INTO answer VALUES (1434, 359, 1, '6,0 Watt', ' ');
INSERT INTO answer VALUES (1435, 359, 2, '7,8 Watt', ' ');
INSERT INTO answer VALUES (1436, 359, 3, '12,7 Watt', ' ');
INSERT INTO answer VALUES (1437, 360, 0, '16,4 Watt', ' ');
INSERT INTO answer VALUES (1438, 360, 1, '6,1 Watt', ' ');
INSERT INTO answer VALUES (1439, 360, 2, '10,0 Watt', ' ');
INSERT INTO answer VALUES (1440, 360, 3, '32,8 Watt', ' ');
INSERT INTO answer VALUES (1441, 361, 0, '75 Watt', ' ');
INSERT INTO answer VALUES (1442, 361, 1, '123 W', ' ');
INSERT INTO answer VALUES (1443, 361, 2, '45,7 W', ' ');
INSERT INTO answer VALUES (1444, 361, 3, '60,6 W', ' ');
INSERT INTO answer VALUES (1445, 362, 0, 'Ja, er ist in diesem Fall verpflichtet die Einhaltung der Personenschutzgrenzwerte nachzuweisen.', ' ');
INSERT INTO answer VALUES (1446, 362, 1, 'Nein, der Schutz von Personen in elektromagnetischen Feldern ist durch den Funkamateur erst bei einer Strahlungsleistung von mehr als 10 W EIRP sicherzustellen.', ' ');
INSERT INTO answer VALUES (1447, 362, 2, 'Nein, aber er muss die Herzschrittmachergrenzwerte einhalten.', ' ');
INSERT INTO answer VALUES (1448, 362, 3, 'Nein, bei der Sendeart F3E und Sendezeiten unter 6 Minuten in der Stunde kann der Schutz von Personen in elektromagnetischen Feldern durch den Funkamateur vernachlässigt werden.', ' ');
INSERT INTO answer VALUES (1449, 363, 0, 'kleiner 3 Watt (Zuleitungsverluste vernachlässigt)', ' ');
INSERT INTO answer VALUES (1450, 363, 1, 'kleiner 6 Watt (Zuleitungsverluste vernachlässigt)', ' ');
INSERT INTO answer VALUES (1451, 363, 2, 'kleiner 10 Watt (Zuleitungsverluste vernachlässigt)', ' ');
INSERT INTO answer VALUES (1452, 363, 3, 'kleiner 16,4 Watt (Zuleitungsverluste vernachlässigt)', ' ');
INSERT INTO answer VALUES (1453, 364, 0, '2,50 m', ' ');
INSERT INTO answer VALUES (1454, 364, 1, '1,96 m', ' ');
INSERT INTO answer VALUES (1455, 364, 2, '5,01 m', ' ');
INSERT INTO answer VALUES (1456, 364, 3, '13,7 m', ' ');
INSERT INTO answer VALUES (1457, 365, 0, '5,01 m', ' ');
INSERT INTO answer VALUES (1458, 365, 1, '3,91 m', ' ');
INSERT INTO answer VALUES (1459, 365, 2, '2,50 m', ' ');
INSERT INTO answer VALUES (1460, 365, 3, '20,70 m', ' ');
INSERT INTO answer VALUES (1461, 366, 0, '6,86 m', ' ');
INSERT INTO answer VALUES (1462, 366, 1, '5,35 m', ' ');
INSERT INTO answer VALUES (1463, 366, 2, '2,17 m', ' ');
INSERT INTO answer VALUES (1464, 366, 3, '36,3 m', ' ');
INSERT INTO answer VALUES (1465, 367, 0, 'Von jedem Punkt der Antenne', ' ');
INSERT INTO answer VALUES (1466, 367, 1, 'Vom Einspeisepunkt der Antenne', ' ');
INSERT INTO answer VALUES (1467, 367, 2, 'Von der Mitte der Antenne, d.h. dort, wo sie am Mast befestigt ist', ' ');
INSERT INTO answer VALUES (1468, 367, 3, 'Vom untersten Punkt der Antenne', ' ');
INSERT INTO answer VALUES (1469, 368, 0, 'Mit dem Mittelwert der Ausgangsleistung gemittelt über ein Intervall von 6 Minuten.', ' ');
INSERT INTO answer VALUES (1470, 368, 1, 'Mit der größten Ausgangsleistung des Transceivers zuzüglich Antennengewinn, korrigiert um den Gewichtungsfaktor für die verwendete Betriebsart.', ' ');
INSERT INTO answer VALUES (1471, 368, 2, 'Mit der durchschnittlich benutzten Ausgangsleistung gemittelt über den Betriebszeitraum und korrigiert um den Gewichtungsfaktor für die verwendete Betriebsart.', ' ');
INSERT INTO answer VALUES (1472, 368, 3, 'Mit der maximalen Ausgangsleistung des verwendeten Senders zuzüglich 3 dB Messfehler.', ' ');
INSERT INTO answer VALUES (1473, 369, 0, 'Nein, die Feldstärke beeinflusst unmittelbar, also zeitunabhängig.', ' ');
INSERT INTO answer VALUES (1474, 369, 1, 'Ja, Grenzwerte gelten im Zeitraum einer Kurzzeitexposition bis zu 6 Minuten.', ' ');
INSERT INTO answer VALUES (1475, 369, 2, 'Ja, die Grenzwerte gelten im Zeitraum einer Exposition von 6 Minuten bis zu 8 Stunden.', ' ');
INSERT INTO answer VALUES (1476, 369, 3, 'Ja, in Abhängigkeit von der körperlichen Verfassung des Herzschrittmacherträgers.', ' ');
INSERT INTO answer VALUES (1477, 370, 0, 'Wenn die vorhandene Blitzschutzanlage fachgerecht aufgebaut ist und das Standrohr mit ihr auf dem kürzesten Wege verbunden werden kann.', ' ');
INSERT INTO answer VALUES (1478, 370, 1, 'Nach den geltenden Vorschriften muss das Standrohr der Amateurfunkantenne mit einer vorhandenen Gebäude-Blitzschutzanlage verbunden werden.', ' ');
INSERT INTO answer VALUES (1479, 370, 2, 'Nach den geltenden Vorschriften muss immer eine eigene Blitzschutzanlage für eine Amateurfunkantenne aufgebaut werden.', ' ');
INSERT INTO answer VALUES (1480, 370, 3, 'Die Bedingung ist ein ausreichend großer Querschnitt für die Verbindungsleitung zur Blitzschutzanlage.', ' ');
INSERT INTO answer VALUES (1481, 371, 0, 'Als geeigneter Erdungsleiter gilt ein Einzelmassivdraht mit einem Mindestquerschnitt von 16 mm2 Kupfer, isoliert oder blank, oder 25 mm2 Aluminium isoliert oder 50 mm2 Stahl.', ' ');
INSERT INTO answer VALUES (1482, 371, 1, 'Ein- oder mehrdrähtiger - aber nicht feindrähtiger - isolierter oder blanker Kupferleiter mit mindestens 10 mm2 Querschnitt oder ein Aluminiumleiter mit mindestens 16 mm2 Querschnitt.', ' ');
INSERT INTO answer VALUES (1483, 371, 2, 'Ein- oder mehrdrähtiger - aber nicht feindrähtiger - isolierter oder blanker Kupferleiter mit mindestens 25 mm2 Querschnitt oder ein Aluminiumleiter mit mindestens 50 mm2 Querschnitt.', ' ');
INSERT INTO answer VALUES (1484, 371, 3, 'Als geeigneter Erdungsleiter gilt ein Einzeldraht mit einem Mindestquerschnitt von 4 mm2 Kupfer, isoliert oder blank, oder 10 mm2 Aluminium isoliert.', ' ');
INSERT INTO answer VALUES (1485, 372, 0, 'Jeder ordnungsgemäß verlegte Fundamenterder kann verwendet werden, sofern alle Blitzschutzleitungen bis zur Potentialausgleichsschiene getrennt geführt werden.', ' ');
INSERT INTO answer VALUES (1486, 372, 1, 'Nach den geltenden Vorschriften muss immer eine eigene Blitzschutzanlage, also auch ein eigener Fundamenterder, für eine Amateurfunkantenne aufgebaut werden.', ' ');
INSERT INTO answer VALUES (1487, 372, 2, 'Die in den Sicherheitsvorschriften festgelegte zulässige Leitungslänge des Erdungsleiters darf auf keinen Fall überschritten werden.', ' ');
INSERT INTO answer VALUES (1488, 372, 3, 'Die Ausdehnung des Fundamenterders muss größer oder wenigstens gleich der Ausdehnung der Antennenanlage sein.', ' ');
INSERT INTO answer VALUES (1489, 373, 0, 'Die Außenleiter (Abschirmung) aller Koaxialkabel- Niederführungen müssen über einen Potentialausgleichsleiter normgerecht mit Erde verbunden werden.', ' ');
INSERT INTO answer VALUES (1490, 373, 1, 'Für alle Koaxialkabel-Niederführungen sind entsprechend den Sicherheitsvorschriften Überspannungsableiter vorzusehen.', ' ');
INSERT INTO answer VALUES (1491, 373, 2, 'Neben der Erdung des Antennenmastes sind keine weiteren Maßnahmen erforderlich.', ' ');
INSERT INTO answer VALUES (1492, 373, 3, 'Die Koaxialkabel müssen das entsprechende Schirmungsmaß aufweisen und entsprechend isoliert sein.', ' ');
INSERT INTO answer VALUES (1493, 374, 0, 'grüngelb, braun, blau', ' ');
INSERT INTO answer VALUES (1494, 374, 1, 'braun, grüngelb, blau', ' ');
INSERT INTO answer VALUES (1495, 374, 2, 'grau, schwarz, rot', ' ');
INSERT INTO answer VALUES (1496, 374, 3, 'grüngelb, blau, braun oder schwarz', ' ');
INSERT INTO answer VALUES (1497, 375, 0, 'die Anweisungen des Kfz-Herstellers zu beachten.', ' ');
INSERT INTO answer VALUES (1498, 375, 1, 'die Bedingungen der Bundesnetzagentur für den Einbau mobiler Sendeanlagen einzuhalten.', ' ');
INSERT INTO answer VALUES (1499, 375, 2, 'die Ratschläge des Kfz-Händlers einzuhalten.', ' ');
INSERT INTO answer VALUES (1500, 375, 3, 'die Anweisungen des Amateurfunkgeräte- Herstellers zu beachten.', ' ');
INSERT INTO answer VALUES (1501, 376, 0, 'Auf der Mitte des Daches.', ' ');
INSERT INTO answer VALUES (1502, 376, 1, 'Auf der hinteren Stoßstange.', ' ');
INSERT INTO answer VALUES (1503, 376, 2, 'Auf dem vorderen Kotflügel.', ' ');
INSERT INTO answer VALUES (1504, 376, 3, 'Auf dem Armaturenbrett.', ' ');
INSERT INTO answer VALUES (1505, 377, 0, 'möglichst weit von der Fahrzeugverkabelung entfernt verlegt werden.', ' ');
INSERT INTO answer VALUES (1506, 377, 1, 'im Kabelbaum des Kraftfahrzeugs geführt werden.', ' ');
INSERT INTO answer VALUES (1507, 377, 2, 'über das Fahrzeugdach verlegt sein.', ' ');
INSERT INTO answer VALUES (1508, 377, 3, 'entlang der Innenseite des Motorraumes verlegt werden.', ' ');
INSERT INTO answer VALUES (1509, 378, 0, 'Volt pro Meter (V/m)', ' ');
INSERT INTO answer VALUES (1510, 378, 1, 'Watt pro Quadratmeter (W/m²)', ' ');
INSERT INTO answer VALUES (1511, 378, 2, 'Ampere pro Meter (A/m)', ' ');
INSERT INTO answer VALUES (1512, 378, 3, 'Henry pro Meter (H/m)', ' ');
INSERT INTO answer VALUES (1513, 379, 0, 'Ampere pro Meter (A/m)', ' ');
INSERT INTO answer VALUES (1514, 379, 1, 'Tesla (T)', ' ');
INSERT INTO answer VALUES (1515, 379, 2, 'Amperemeter (Am)', ' ');
INSERT INTO answer VALUES (1516, 379, 3, 'Henry pro Meter (H/m)', ' ');
INSERT INTO answer VALUES (1517, 380, 0, 'Ohm', ' ');
INSERT INTO answer VALUES (1518, 380, 1, 'Farad', ' ');
INSERT INTO answer VALUES (1519, 380, 2, 'Siemens', ' ');
INSERT INTO answer VALUES (1520, 380, 3, 'Henry', ' ');
INSERT INTO answer VALUES (1521, 381, 0, 'des Leitwertes eines Widerstands.', ' ');
INSERT INTO answer VALUES (1522, 381, 1, 'des ohmschen Widerstands.', ' ');
INSERT INTO answer VALUES (1523, 381, 2, 'der Impedanz einer Leitung.', ' ');
INSERT INTO answer VALUES (1524, 381, 3, 'der magnetischen Feldstärke.', ' ');
INSERT INTO answer VALUES (1525, 382, 0, 'Hz = 1/s', ' ');
INSERT INTO answer VALUES (1526, 382, 1, 'Hz = s', ' ');
INSERT INTO answer VALUES (1527, 382, 2, 'Hz = s²', ' ');
INSERT INTO answer VALUES (1528, 382, 3, 'Hz = 1/s²', ' ');
INSERT INTO answer VALUES (1529, 383, 0, 'Meter, Kelvin, Sekunde, Ampere', ' ');
INSERT INTO answer VALUES (1530, 383, 1, 'Radiant, Meter, Volt, Watt', ' ');
INSERT INTO answer VALUES (1531, 383, 2, 'Farad, Henry, Ohm, Sekunde', ' ');
INSERT INTO answer VALUES (1532, 383, 3, 'Grad, Hertz, Ohm, Tesla', ' ');
INSERT INTO answer VALUES (1533, 384, 0, '23,5 dB.', ' ');
INSERT INTO answer VALUES (1534, 384, 1, '52 dB.', ' ');
INSERT INTO answer VALUES (1535, 384, 2, '47 dB.', ' ');
INSERT INTO answer VALUES (1536, 384, 3, '11,7 dB.', ' ');
INSERT INTO answer VALUES (1537, 385, 0, '16 dB.', ' ');
INSERT INTO answer VALUES (1538, 385, 1, '60 dB.', ' ');
INSERT INTO answer VALUES (1539, 385, 2, '32 dB.', ' ');
INSERT INTO answer VALUES (1540, 385, 3, '24 dB.', ' ');
INSERT INTO answer VALUES (1541, 386, 0, '18 dB', ' ');
INSERT INTO answer VALUES (1542, 386, 1, '9 dB', ' ');
INSERT INTO answer VALUES (1543, 386, 2, '28 dB', ' ');
INSERT INTO answer VALUES (1544, 386, 3, '3 dB', ' ');
INSERT INTO answer VALUES (1545, 387, 0, '1 V/m.', ' ');
INSERT INTO answer VALUES (1546, 387, 1, '10 V/m.', ' ');
INSERT INTO answer VALUES (1547, 387, 2, '1000 V/m.', ' ');
INSERT INTO answer VALUES (1548, 387, 3, '1000 kV/m.', ' ');
INSERT INTO answer VALUES (1549, 388, 0, '10<sup>-1</sup> W.', ' ');
INSERT INTO answer VALUES (1550, 388, 1, '0,001 W.', ' ');
INSERT INTO answer VALUES (1551, 388, 2, '0,01 W.', ' ');
INSERT INTO answer VALUES (1552, 388, 3, '10<sup>-2</sup> W.', ' ');
INSERT INTO answer VALUES (1553, 389, 0, '40 dBm', ' ');
INSERT INTO answer VALUES (1554, 389, 1, '30 dBm', ' ');
INSERT INTO answer VALUES (1555, 389, 2, '20 dBm', ' ');
INSERT INTO answer VALUES (1556, 389, 3, '10 dBm', ' ');
INSERT INTO answer VALUES (1557, 390, 0, '10<sup>2</sup> W.', ' ');
INSERT INTO answer VALUES (1558, 390, 1, '10<sup>0,5</sup> W.', ' ');
INSERT INTO answer VALUES (1559, 390, 2, '10<sup>20</sup> W.', ' ');
INSERT INTO answer VALUES (1560, 390, 3, '10<sup>1</sup> W.', ' ');
INSERT INTO answer VALUES (1561, 391, 0, '20 kHz.', ' ');
INSERT INTO answer VALUES (1562, 391, 1, '2 MHz.', ' ');
INSERT INTO answer VALUES (1563, 391, 2, '200 kHz.', ' ');
INSERT INTO answer VALUES (1564, 391, 3, '20 MHz.', ' ');
INSERT INTO answer VALUES (1565, 392, 0, '7,460 MHz.', ' ');
INSERT INTO answer VALUES (1566, 392, 1, '1,865 MHz.', ' ');
INSERT INTO answer VALUES (1567, 392, 2, '11,190 MHz.', ' ');
INSERT INTO answer VALUES (1568, 392, 3, '14,920 MHz.', ' ');
INSERT INTO answer VALUES (1569, 393, 0, '434,070 MHz.', ' ');
INSERT INTO answer VALUES (1570, 393, 1, '289,380 MHz.', ' ');
INSERT INTO answer VALUES (1571, 393, 2, '145,000 MHz.', ' ');
INSERT INTO answer VALUES (1572, 393, 3, '723,450 MHz.', ' ');
INSERT INTO answer VALUES (1573, 394, 0, '0,0001 %.', ' ');
INSERT INTO answer VALUES (1574, 394, 1, '0,001 %.', ' ');
INSERT INTO answer VALUES (1575, 394, 2, '0,01 %.', ' ');
INSERT INTO answer VALUES (1576, 394, 3, '0,1 %.', ' ');
INSERT INTO answer VALUES (1577, 395, 0, 'Zwischen 14,2498575 und 14,2501425 MHz', ' ');
INSERT INTO answer VALUES (1578, 395, 1, 'Zwischen 14,24998575 und 14,25001425 MHz', ' ');
INSERT INTO answer VALUES (1579, 395, 2, 'Zwischen 14,249998575 und 14,250001425 MHz', ' ');
INSERT INTO answer VALUES (1580, 395, 3, 'Zwischen 14,248575 und 14,251425 MHz', ' ');
INSERT INTO answer VALUES (1581, 396, 0, '300000 km/s.', ' ');
INSERT INTO answer VALUES (1582, 396, 1, '3000000 km/s.', ' ');
INSERT INTO answer VALUES (1583, 396, 2, '30000 km/s.', ' ');
INSERT INTO answer VALUES (1584, 396, 3, '3000 km/s.', ' ');
INSERT INTO answer VALUES (1585, 397, 0, '10 GHz', ' ');
INSERT INTO answer VALUES (1586, 397, 1, '100 MHz', ' ');
INSERT INTO answer VALUES (1587, 397, 2, '1 MHz', ' ');
INSERT INTO answer VALUES (1588, 397, 3, '100 kHz', ' ');
INSERT INTO answer VALUES (1589, 398, 0, '3 GHz.', ' ');
INSERT INTO answer VALUES (1590, 398, 1, '1,9 GHz.', ' ');
INSERT INTO answer VALUES (1591, 398, 2, '3 MHz.', ' ');
INSERT INTO answer VALUES (1592, 398, 3, '10 GHz.', ' ');
INSERT INTO answer VALUES (1593, 399, 0, '&lambda; = 13,64 m', ' ');
INSERT INTO answer VALUES (1594, 399, 1, '&lambda; = 14,33 m', ' ');
INSERT INTO answer VALUES (1595, 399, 2, '&lambda; = 12,93 m', ' ');
INSERT INTO answer VALUES (1596, 399, 3, '&lambda; = 136,3 m', ' ');
INSERT INTO answer VALUES (1597, 400, 0, '145,631 MHz.', ' ');
INSERT INTO answer VALUES (1598, 400, 1, '150,247 MHz.', ' ');
INSERT INTO answer VALUES (1599, 400, 2, '148,927 MHz.', ' ');
INSERT INTO answer VALUES (1600, 400, 3, '135,754 MHz.', ' ');
INSERT INTO answer VALUES (1601, 401, 0, '434,783 MHz.', ' ');
INSERT INTO answer VALUES (1602, 401, 1, '430,162 MHz.', ' ');
INSERT INTO answer VALUES (1603, 401, 2, '435,574 MHz.', ' ');
INSERT INTO answer VALUES (1604, 401, 3, '440,317 MHz.', ' ');
INSERT INTO answer VALUES (1605, 402, 0, 'das Verhältnis der Ausbreitungsgeschwindigkeit entlang einer Leitung zur Ausbreitungsgeschwindigkeit im Vakuum.', ' ');
INSERT INTO answer VALUES (1606, 402, 1, 'das Verhältnis von Durchmesser zur Länge eines Leiters.', ' ');
INSERT INTO answer VALUES (1607, 402, 2, 'das Verhältnis des Wellen- bzw. des Strahlungswiderstandes zum Feldwellenwiderstand des freien Raumes.', ' ');
INSERT INTO answer VALUES (1608, 402, 3, 'die Wurzel aus dem Verhältnis von Induktivität zur Kapazität einer Leitung.', ' ');
INSERT INTO answer VALUES (1609, 403, 0, 'bei einer Länge von 1000 mm und einem Querschnitt von 1 mm².', ' ');
INSERT INTO answer VALUES (1610, 403, 1, 'bei einer Länge von 100 mm und einem Querschnitt von 1 mm².', ' ');
INSERT INTO answer VALUES (1611, 403, 2, 'bei einer Länge von 1 m und einem Querschnitt von 0,1 mm².', ' ');
INSERT INTO answer VALUES (1612, 403, 3, 'bei einer Länge von 100 mm und einem Querschnitt von 0,1 mm².', ' ');
INSERT INTO answer VALUES (1613, 404, 0, '1 &Omega;', ' ');
INSERT INTO answer VALUES (1614, 404, 1, '56 &Omega;', ' ');
INSERT INTO answer VALUES (1615, 404, 2, '0,05 &Omega;', ' ');
INSERT INTO answer VALUES (1616, 404, 3, '5,6 &Omega;', ' ');
INSERT INTO answer VALUES (1617, 405, 0, '42,1 m', ' ');
INSERT INTO answer VALUES (1618, 405, 1, '25,3 m', ' ');
INSERT INTO answer VALUES (1619, 405, 2, '4,2 m', ' ');
INSERT INTO answer VALUES (1620, 405, 3, '168,5 m', ' ');
INSERT INTO answer VALUES (1621, 406, 0, 'positiv.', ' ');
INSERT INTO answer VALUES (1622, 406, 1, 'negativ.', ' ');
INSERT INTO answer VALUES (1623, 406, 2, 'logarithmisch.', ' ');
INSERT INTO answer VALUES (1624, 406, 3, 'exponentiell.', ' ');
INSERT INTO answer VALUES (1625, 407, 0, 'Epoxyd, Polyethylen (PE), Polystyrol (PS)', ' ');
INSERT INTO answer VALUES (1626, 407, 1, 'Pertinax, Polyvinylchlorid (PVC), Graphit', ' ');
INSERT INTO answer VALUES (1627, 407, 2, 'Polyethylen (PE), Messing, Konstantan', ' ');
INSERT INTO answer VALUES (1628, 407, 3, 'Teflon, Pertinax, Bronze', ' ');
INSERT INTO answer VALUES (1629, 408, 0, 'Einige Stoffe (z.B. Silizium, Germanium) sind in reinem Zustand bei Zimmertemperatur gute Isolatoren. Durch geringfügige Zusätze von geeigneten anderen Stoffen oder bei hohen Temperaturen werden sie jedoch zu Leitern.', ' ');
INSERT INTO answer VALUES (1630, 408, 1, 'Einige Stoffe (z.B. Silizium, Germanium) sind in reinem Zustand bei Zimmertemperatur gute Leiter. Durch geringfügige Zusätze von geeigneten anderen Stoffen oder bei hohen Temperaturen nimmt jedoch ihre Leitfähigkeit ab.', ' ');
INSERT INTO answer VALUES (1631, 408, 2, 'Einige Stoffe wie z.B. Indium oder Magnesium sind in reinem Zustand gute Isolatoren. Durch geringfügige Zusätze von Silizium, Germanium oder geeigneten anderen Stoffen werden sie jedoch zu Leitern.', ' ');
INSERT INTO answer VALUES (1632, 408, 3, 'Einige Stoffe (z.B. Silizium, Germanium) sind in trockenem Zustand gute Elektrolyten. Durch geringfügige Zusätze von Wismut oder Tellur kann man daraus entweder N-leitendes- oder P-leitendes Material für Anoden bzw. Katoden von Halbleiterbauelementen herstellen.', ' ');
INSERT INTO answer VALUES (1633, 409, 0, 'bewegliche Elektronenlücken.', ' ');
INSERT INTO answer VALUES (1634, 409, 1, 'das Fehlen von Dotierungsatomen.', ' ');
INSERT INTO answer VALUES (1635, 409, 2, 'das Fehlen von Atomen im Gitter des Halbleiterkristalls.', ' ');
INSERT INTO answer VALUES (1636, 409, 3, 'Überschuss an freien Elektronen.', ' ');
INSERT INTO answer VALUES (1637, 410, 0, 'Zugabe von dreiwertigen Stoffen zum vierwertigen Halbleitergrundstoff', ' ');
INSERT INTO answer VALUES (1638, 410, 1, 'Zugabe von fünfwertigen Stoffen zum vierwertigen Halbleitergrundstoff', ' ');
INSERT INTO answer VALUES (1639, 410, 2, 'Zugabe von Germaniumatomen zum Siliziumgrundwerkstoff', ' ');
INSERT INTO answer VALUES (1640, 410, 3, 'Zugabe von Siliziumatomen zum Germaniumgrundwerkstoff', ' ');
INSERT INTO answer VALUES (1641, 411, 0, 'das Vorhandensein frei beweglicher Elektronen.', ' ');
INSERT INTO answer VALUES (1642, 411, 1, 'das Fehlen von Dotierungsatomen.', ' ');
INSERT INTO answer VALUES (1643, 411, 2, 'das Fehlen von Atomen im Gitter des Halbleiterkristalls.', ' ');
INSERT INTO answer VALUES (1644, 411, 3, 'das Vorhandensein beweglicher Elektronenlücken.', ' ');
INSERT INTO answer VALUES (1645, 412, 0, 'Zugabe von fünfwertigen Stoffen zum vierwertigen Halbleitergrundstoff', ' ');
INSERT INTO answer VALUES (1646, 412, 1, 'Zugabe von dreiwertigen Stoffen zum vierwertigen Halbleitergrundstoff', ' ');
INSERT INTO answer VALUES (1647, 412, 2, 'Zugabe von Germaniumatomen zum Siliziumgrundwerkstoff', ' ');
INSERT INTO answer VALUES (1648, 412, 3, 'Zugabe von Siliziumatomen zum Germaniumgrundwerkstoff', ' ');
INSERT INTO answer VALUES (1649, 413, 0, 'An der Grenzschicht wandern Elektronen aus dem N-Teil in den P-Teil. Dadurch wird auf der N-Seite der Elektronenüberschuss teilweise abgebaut, auf der P-Seite der Elektronenmangel teilweise neutralisiert. Es bildet sich auf beiden Seiten der Grenzfläche eine isolierende Schicht.', ' ');
INSERT INTO answer VALUES (1650, 413, 1, 'An der Grenzschicht wandern Elektronen aus dem P-Teil in den N-Teil. Dadurch wird auf der P-Seite der Elektronenüberschuss teilweise abgebaut, auf der N-Seite der Elektronenmangel teilweise neutralisiert. Es bildet sich auf beiden Seiten der Grenzfläche eine isolierende Schicht.', ' ');
INSERT INTO answer VALUES (1651, 413, 2, 'An der Grenzschicht wandern Atome aus der Grenzschicht in den N- und P-Teil. Dadurch wird auf beiden Seiten der Atommangel abgebaut. Es bildet sich auf der P-Seite eine leitende Schicht.', ' ');
INSERT INTO answer VALUES (1652, 413, 3, 'An der Grenzschicht wandern Atome aus dem N-Teil in den P-Teil. Dadurch wird auf der N-Seite der Atommangel abgebaut, auf der P-Seite der Atommangel vergrößert. Es bildet sich auf der N-Seite eine leitende Schicht.', ' ');
INSERT INTO answer VALUES (1653, 414, 0, 'wenn man an die Katode (N-Gebiet) eine positive und an die Anode (P-Gebiet) eine negative Spannung anlegt.', ' ');
INSERT INTO answer VALUES (1654, 414, 1, 'wenn man an die Katode (P-Gebiet) eine positive und an die Anode (N-Gebiet) eine negative Spannung anlegt.', ' ');
INSERT INTO answer VALUES (1655, 414, 2, 'wenn man an die Katode (P-Gebiet) eine negative und an die Anode (N-Gebiet) eine positive Spannung anlegt.', ' ');
INSERT INTO answer VALUES (1656, 414, 3, 'wenn man an die Katode (N-Gebiet) eine negative und an die Anode (P-Gebiet) eine positive Spannung anlegt.', ' ');
INSERT INTO answer VALUES (1657, 415, 0, 'Leerlaufspannung: 18 V, Kurzschlussstrom: 4 A', ' ');
INSERT INTO answer VALUES (1658, 415, 1, 'Leerlaufspannung: 18 V, Kurzschlussstrom: 30 A', ' ');
INSERT INTO answer VALUES (1659, 415, 2, 'Leerlaufspannung: 2,4 V, Kurzschlussstrom: 4 A', ' ');
INSERT INTO answer VALUES (1660, 415, 3, 'Leerlaufspannung: 2,4 V, Kurzschlussstrom: 30 A', ' ');
INSERT INTO answer VALUES (1661, 416, 0, '1,22 &Omega;', ' ');
INSERT INTO answer VALUES (1662, 416, 1, '0,82 &Omega;', ' ');
INSERT INTO answer VALUES (1663, 416, 2, '12,15 &Omega;', ' ');
INSERT INTO answer VALUES (1664, 416, 3, '1,1 &Omega;', ' ');
INSERT INTO answer VALUES (1665, 417, 0, '0,25 &Omega;', ' ');
INSERT INTO answer VALUES (1666, 417, 1, '6,75 &Omega;', ' ');
INSERT INTO answer VALUES (1667, 417, 2, '13 &Omega;', ' ');
INSERT INTO answer VALUES (1668, 417, 3, '0,5 &Omega;', ' ');
INSERT INTO answer VALUES (1669, 418, 0, '92,6 %', ' ');
INSERT INTO answer VALUES (1670, 418, 1, '100 %', ' ');
INSERT INTO answer VALUES (1671, 418, 2, '7,5 %', ' ');
INSERT INTO answer VALUES (1672, 418, 3, '13,5 %', ' ');
INSERT INTO answer VALUES (1673, 419, 0, '96,3 %', ' ');
INSERT INTO answer VALUES (1674, 419, 1, '100 %', ' ');
INSERT INTO answer VALUES (1675, 419, 2, '3,7 %', ' ');
INSERT INTO answer VALUES (1676, 419, 3, '27 %', ' ');
INSERT INTO answer VALUES (1677, 420, 0, '0,05 &Omega;', ' ');
INSERT INTO answer VALUES (1678, 420, 1, '8,2 &Omega;', ' ');
INSERT INTO answer VALUES (1679, 420, 2, '0,2 &Omega;', ' ');
INSERT INTO answer VALUES (1680, 420, 3, '0,25 &Omega;', ' ');
INSERT INTO answer VALUES (1681, 421, 0, 'R<sub>L</sub> = R<sub>i</sub>', ' ');
INSERT INTO answer VALUES (1682, 421, 1, 'R<sub>L</sub> &lt;&lt; R<sub>i</sub>', ' ');
INSERT INTO answer VALUES (1683, 421, 2, 'R<sub>L</sub> &gt;&gt; R<sub>i</sub>', ' ');
INSERT INTO answer VALUES (1684, 421, 3, 'R<sub>L</sub> = 1 / R<sub>i</sub>', ' ');
INSERT INTO answer VALUES (1685, 422, 0, 'R<sub>L</sub> &lt;&lt; R<sub>i</sub>', ' ');
INSERT INTO answer VALUES (1686, 422, 1, 'R<sub>L</sub> &gt;&gt; R<sub>i</sub>', ' ');
INSERT INTO answer VALUES (1687, 422, 2, 'R<sub>L</sub> = R<sub>i</sub>', ' ');
INSERT INTO answer VALUES (1688, 422, 3, 'R<sub>L</sub> = 1/R<sub>i</sub>', ' ');
INSERT INTO answer VALUES (1689, 423, 0, 'R<sub>L</sub> &gt;&gt; R<sub>i</sub>', ' ');
INSERT INTO answer VALUES (1690, 423, 1, 'R<sub>L</sub> &lt;&lt; R<sub>i</sub>', ' ');
INSERT INTO answer VALUES (1691, 423, 2, 'R<sub>L</sub> = R<sub>i</sub>', ' ');
INSERT INTO answer VALUES (1692, 423, 3, 'R<sub>L</sub> = 1/R<sub>i</sub>', ' ');
INSERT INTO answer VALUES (1693, 424, 0, 'Spannungsquellen sollten einen möglichst niedrigen Innenwiderstand und Stromquellen einen möglichst hohen Innenwiderstand haben.', ' ');
INSERT INTO answer VALUES (1694, 424, 1, 'Strom- und Spannungsquellen sollten einen möglichst niedrigen Innenwiderstand haben.', ' ');
INSERT INTO answer VALUES (1695, 424, 2, 'Strom- und Spannungsquellen sollten einen möglichst hohen Innenwiderstand haben.', ' ');
INSERT INTO answer VALUES (1696, 424, 3, 'Spannungsquellen sollten einen möglichst hohen Innenwiderstand und Stromquellen einen möglichst niedrigen Innenwiderstand haben.', ' ');
INSERT INTO answer VALUES (1697, 425, 0, '2000 kV/m', ' ');
INSERT INTO answer VALUES (1698, 425, 1, '200 V/m', ' ');
INSERT INTO answer VALUES (1699, 425, 2, '2000 V/m', ' ');
INSERT INTO answer VALUES (1700, 425, 3, '200 kV/m', ' ');
INSERT INTO answer VALUES (1701, 426, 0, 'Zirka 1500 V/m', ' ');
INSERT INTO answer VALUES (1702, 426, 1, 'Zirka 150 V/m', ' ');
INSERT INTO answer VALUES (1703, 426, 2, 'Zirka 15 V/m', ' ');
INSERT INTO answer VALUES (1704, 426, 3, 'Zirka 5,4 V/m', ' ');
INSERT INTO answer VALUES (1705, 427, 0, 'zur Spannung am Leiter.', ' ');
INSERT INTO answer VALUES (1706, 427, 1, 'zum Strom durch den Leiter.', ' ');
INSERT INTO answer VALUES (1707, 427, 2, 'zum Querschnitt des Leiters.', ' ');
INSERT INTO answer VALUES (1708, 427, 3, 'zur Länge des Leiters.', ' ');
INSERT INTO answer VALUES (1709, 428, 0, '6 kV', ' ');
INSERT INTO answer VALUES (1710, 428, 1, '60 kV', ' ');
INSERT INTO answer VALUES (1711, 428, 2, '600 V', ' ');
INSERT INTO answer VALUES (1712, 428, 3, '2,6 kV', ' ');
INSERT INTO answer VALUES (1713, 429, 0, 'Homogenes elektrisches Feld', ' ');
INSERT INTO answer VALUES (1714, 429, 1, 'Homogenes magnetisches Feld', ' ');
INSERT INTO answer VALUES (1715, 429, 2, 'Polarisiertes elektrisches Feld', ' ');
INSERT INTO answer VALUES (1716, 429, 3, 'Polarisiertes magnetisches Feld', ' ');
INSERT INTO answer VALUES (1717, 430, 0, 'Elektrische Feldlinien', ' ');
INSERT INTO answer VALUES (1718, 430, 1, 'Magnetische Feldlinien', ' ');
INSERT INTO answer VALUES (1719, 430, 2, 'Polarisierte Feldlinien', ' ');
INSERT INTO answer VALUES (1720, 430, 3, 'Horizontale Feldlinien', ' ');
INSERT INTO answer VALUES (1721, 431, 0, '184 A/m', ' ');
INSERT INTO answer VALUES (1722, 431, 1, '1,8 A/m', ' ');
INSERT INTO answer VALUES (1723, 431, 2, '577 A/m', ' ');
INSERT INTO answer VALUES (1724, 431, 3, '5,8 A/m', ' ');
INSERT INTO answer VALUES (1725, 432, 0, '0,25 mT', ' ');
INSERT INTO answer VALUES (1726, 432, 1, '2,5 mT', ' ');
INSERT INTO answer VALUES (1727, 432, 2, '2,5 T', ' ');
INSERT INTO answer VALUES (1728, 432, 3, '0,25 T', ' ');
INSERT INTO answer VALUES (1729, 433, 0, 'Das hochfrequente Magnetfeld kann nicht in den Kern eindringen, was den Querschnitt des Feldes verringert.', ' ');
INSERT INTO answer VALUES (1730, 433, 1, 'Kupfer und Aluminium sind diamagnetisch und schwächen das Feld ab.', ' ');
INSERT INTO answer VALUES (1731, 433, 2, 'Das leitfähige Metall schließt das Feld kurz.', ' ');
INSERT INTO answer VALUES (1732, 433, 3, 'Kupfer und Aluminium sind unmagnetisch und haben keinen Einfluss auf das Feld.', ' ');
INSERT INTO answer VALUES (1733, 434, 0, 'Drehspulmesswerken.', ' ');
INSERT INTO answer VALUES (1734, 434, 1, 'Dreheisenmesswerken.', ' ');
INSERT INTO answer VALUES (1735, 434, 2, 'Transformatorenkernen.', ' ');
INSERT INTO answer VALUES (1736, 434, 3, 'Spulenkernen.', ' ');
INSERT INTO answer VALUES (1737, 435, 0, 'Homogenes magnetisches Feld', ' ');
INSERT INTO answer VALUES (1738, 435, 1, 'Homogenes elektrisches Feld', ' ');
INSERT INTO answer VALUES (1739, 435, 2, 'Konzentrisches magnetisches Feld', ' ');
INSERT INTO answer VALUES (1740, 435, 3, 'Zentriertes magnetisches Feld', ' ');
INSERT INTO answer VALUES (1741, 436, 0, 'Magnetfeld aus konzentrischen Kreisen um den Leiter.', ' ');
INSERT INTO answer VALUES (1742, 436, 1, 'elektrisches Feld aus konzentrischen Kreisen um den Leiter.', ' ');
INSERT INTO answer VALUES (1743, 436, 2, 'homogenes Magnetfeld um den Leiter.', ' ');
INSERT INTO answer VALUES (1744, 436, 3, 'homogenes elektrisches Feld um den Leiter.', ' ');
INSERT INTO answer VALUES (1745, 437, 0, 'Magnetische Feldlinien', ' ');
INSERT INTO answer VALUES (1746, 437, 1, 'Elektrische Feldlinien', ' ');
INSERT INTO answer VALUES (1747, 437, 2, 'Radiale Feldlinien', ' ');
INSERT INTO answer VALUES (1748, 437, 3, 'Vertikale Feldlinien', ' ');
INSERT INTO answer VALUES (1749, 438, 0, 'Elektrische Feldstärke: Volt pro Meter Magnetische Feldstärke: Ampere pro Meter', ' ');
INSERT INTO answer VALUES (1750, 438, 1, 'Elektrische Feldstärke: Ampere pro Meter Magnetische Feldstärke: Volt pro Meter', ' ');
INSERT INTO answer VALUES (1751, 438, 2, 'Elektrische Feldstärke: Volt mal Meter Magnetische Feldstärke: Ampere mal Meter', ' ');
INSERT INTO answer VALUES (1752, 438, 3, 'Elektrische Feldstärke: Ampere mal Meter Magnetische Feldstärke: Volt mal Meter', ' ');
INSERT INTO answer VALUES (1753, 439, 0, 'Ein elektromagnetisches Feld entsteht, wenn durch einen elektrischen Leiter ein zeitlich schnell veränderlicher Strom fließt. Es besteht aus der elektrischen und aus der magnetischen Feldkomponente (E-Feld und H-Feld).', ' ');
INSERT INTO answer VALUES (1754, 439, 1, 'Ein elektromagnetisches Feld entsteht, wenn durch einen elektrischen Leiter ein konstanter Strom fließt. Es besteht aus dem magnetischen Feld (H-Feld), das wiederum ein elektrisches Feld (E-Feld) induziert.', ' ');
INSERT INTO answer VALUES (1755, 439, 2, 'Ein elektromagnetisches Feld entsteht, wenn sich elektrische Ladungen in einem Leiter befinden. Es besteht aus dem elektrischen Feld (E-Feld), das wiederum ein magnetisches Feld (H-Feld) induziert.', ' ');
INSERT INTO answer VALUES (1756, 439, 3, 'Ein elektromagnetisches Feld entsteht, wenn an einem elektrischen Leiter eine konstante Spannung angelegt wird. Es besteht aus dem elektrischen Feld (E-Feld), das wiederum ein magnetisches Feld (H-Feld) induziert.', ' ');
INSERT INTO answer VALUES (1757, 440, 0, 'Sie erfolgt durch eine sich ausbreitende Wechselwirkung zwischen E-Feld und H-Feld.', ' ');
INSERT INTO answer VALUES (1758, 440, 1, 'Die Ausbreitung erfolgt nur über das E-Feld. Das H-Feld ist nur im Nahfeld vorhanden.', ' ');
INSERT INTO answer VALUES (1759, 440, 2, 'Die Ausbreitung erfolgt nur über das H-Feld. Das E-Feld ist nur im Nahfeld vorhanden.', ' ');
INSERT INTO answer VALUES (1760, 440, 3, 'E-Feld und H-Feld breiten sich unabhängig voneinander aus und stehen senkrecht zueinander und zur Ausbreitungsrichtung.', ' ');
INSERT INTO answer VALUES (1761, 441, 0, 'die Richtung des elektrischen Feldes (Vektor des E-Feldes) angegeben.', ' ');
INSERT INTO answer VALUES (1762, 441, 1, 'die Richtung des magnetischen Feldes (Vektor des H-Feldes) angegeben.', ' ');
INSERT INTO answer VALUES (1763, 441, 2, 'die Richtung der Ausbreitung (S-Vektor Poyntingscher Vektor) angegeben.', ' ');
INSERT INTO answer VALUES (1764, 441, 3, 'die Leistungsflussdichte im Speisepunkt der Antenne bestimmt.', ' ');
INSERT INTO answer VALUES (1765, 442, 0, 'Horizontale Polarisation', ' ');
INSERT INTO answer VALUES (1766, 442, 1, 'Vertikale Polarisation', ' ');
INSERT INTO answer VALUES (1767, 442, 2, 'Rechtsdrehende Polarisation', ' ');
INSERT INTO answer VALUES (1768, 442, 3, 'Zirkulare Polarisation', ' ');
INSERT INTO answer VALUES (1769, 443, 0, 'die Richtung des elektrischen Feldes (E-Vektor).', ' ');
INSERT INTO answer VALUES (1770, 443, 1, 'die Richtung des magnetischen Feldes (H-Vektor).', ' ');
INSERT INTO answer VALUES (1771, 443, 2, 'die Richtung der Ausbreitung (S-Vektor Poyntingscher Vektor).', ' ');
INSERT INTO answer VALUES (1772, 443, 3, 'die räumliche Anordnung der Empfangsantenne.', ' ');
INSERT INTO answer VALUES (1773, 444, 0, '90°.', ' ');
INSERT INTO answer VALUES (1774, 444, 1, '45°.', ' ');
INSERT INTO answer VALUES (1775, 444, 2, '180°.', ' ');
INSERT INTO answer VALUES (1776, 444, 3, '360°.', ' ');
INSERT INTO answer VALUES (1777, 445, 0, 'vertikal.', ' ');
INSERT INTO answer VALUES (1778, 445, 1, 'horizontal.', ' ');
INSERT INTO answer VALUES (1779, 445, 2, 'elliptisch.', ' ');
INSERT INTO answer VALUES (1780, 445, 3, 'linksdrehend.', ' ');
INSERT INTO answer VALUES (1781, 446, 0, 'Die E-Feldkomponente, die H-Feldkomponente und die Ausbreitungsrichtung befinden sich alle in einem rechten Winkel zueinander.', ' ');
INSERT INTO answer VALUES (1782, 446, 1, 'Die E-Feldkomponente und die H-Feldkomponente befinden sich in einem Winkel von 180° zueinander. Die Ausbreitungsrichtung verläuft dazu in einem Winkel von 90°.', ' ');
INSERT INTO answer VALUES (1783, 446, 2, 'Die E-Feldkomponente und die H-Feldkomponente sind phasengleich und befinden sich in einem Winkel von 0° zueinander. Die Ausbreitungsrichtung verläuft dazu in einem Winkel von 90°.', ' ');
INSERT INTO answer VALUES (1784, 446, 3, 'Die Ausbreitungsrichtung befindet sich in einem Winkel von 180° zur E-Feldkomponente und verläuft parallel zur H-Feldkomponente.', ' ');
INSERT INTO answer VALUES (1785, 447, 0, 'Durch den Feldwellenwiderstand des Freiraums', ' ');
INSERT INTO answer VALUES (1786, 447, 1, 'Durch die Maxwell-Gleichungen', ' ');
INSERT INTO answer VALUES (1787, 447, 2, 'Durch die Ausbreitung in der Ionosphäre', ' ');
INSERT INTO answer VALUES (1788, 447, 3, 'Durch die Polarisationsrichtung der Antenne', ' ');
INSERT INTO answer VALUES (1789, 448, 0, '2,2 V/m', ' ');
INSERT INTO answer VALUES (1790, 448, 1, '8,9 V/m', ' ');
INSERT INTO answer VALUES (1791, 448, 2, '0,4 V/m', ' ');
INSERT INTO answer VALUES (1792, 448, 3, '5,5 V/m', ' ');
INSERT INTO answer VALUES (1793, 449, 0, '11,8 V/m', ' ');
INSERT INTO answer VALUES (1794, 449, 1, '9,2 V/m', ' ');
INSERT INTO answer VALUES (1795, 449, 2, '15,1 V/m', ' ');
INSERT INTO answer VALUES (1796, 449, 3, '353 V/m', ' ');
INSERT INTO answer VALUES (1797, 450, 0, '28,3 V/m', ' ');
INSERT INTO answer VALUES (1798, 450, 1, '200 V/m', ' ');
INSERT INTO answer VALUES (1799, 450, 2, '14,1 V/m', ' ');
INSERT INTO answer VALUES (1800, 450, 3, '176,8 V/m', ' ');
INSERT INTO answer VALUES (1801, 451, 0, 'U<sub>2</sub> oder U<sub>5</sub>', ' ');
INSERT INTO answer VALUES (1802, 451, 1, 'U<sub>1</sub> oder U<sub>6</sub>', ' ');
INSERT INTO answer VALUES (1803, 451, 2, 'U<sub>3</sub> oder U<sub>4</sub>', ' ');
INSERT INTO answer VALUES (1804, 451, 3, 'nur U<sub>2</sub>', ' ');
INSERT INTO answer VALUES (1805, 452, 0, '40 Volt', ' ');
INSERT INTO answer VALUES (1806, 452, 1, '20 Volt', ' ');
INSERT INTO answer VALUES (1807, 452, 2, '10 Volt', ' ');
INSERT INTO answer VALUES (1808, 452, 3, '4 Volt', ' ');
INSERT INTO answer VALUES (1809, 453, 0, '12 Volt', ' ');
INSERT INTO answer VALUES (1810, 453, 1, '6 Volt', ' ');
INSERT INTO answer VALUES (1811, 453, 2, '8,5 Volt', ' ');
INSERT INTO answer VALUES (1812, 453, 3, '2 Volt', ' ');
INSERT INTO answer VALUES (1813, 454, 0, '83,3 kHz', ' ');
INSERT INTO answer VALUES (1814, 454, 1, '833,3 kHz', ' ');
INSERT INTO answer VALUES (1815, 454, 2, '8,3 MHz', ' ');
INSERT INTO answer VALUES (1816, 454, 3, '83,3 MHz', ' ');
INSERT INTO answer VALUES (1817, 455, 0, '8,33 MHz', ' ');
INSERT INTO answer VALUES (1818, 455, 1, '16,7 MHz', ' ');
INSERT INTO answer VALUES (1819, 455, 2, '8,33 kHz', ' ');
INSERT INTO answer VALUES (1820, 455, 3, '833 kHz', ' ');
INSERT INTO answer VALUES (1821, 456, 0, '50 Hz', ' ');
INSERT INTO answer VALUES (1822, 456, 1, '100 Hz', ' ');
INSERT INTO answer VALUES (1823, 456, 2, '500 Hz', ' ');
INSERT INTO answer VALUES (1824, 456, 3, '1000 Hz', ' ');
INSERT INTO answer VALUES (1825, 457, 0, '33,9 V', ' ');
INSERT INTO answer VALUES (1826, 457, 1, '24 V', ' ');
INSERT INTO answer VALUES (1827, 457, 2, '16,97 V', ' ');
INSERT INTO answer VALUES (1828, 457, 3, '36,4 V', ' ');
INSERT INTO answer VALUES (1829, 458, 0, '325 Volt.', ' ');
INSERT INTO answer VALUES (1830, 458, 1, '163 Volt.', ' ');
INSERT INTO answer VALUES (1831, 458, 2, '460 Volt.', ' ');
INSERT INTO answer VALUES (1832, 458, 3, '650 Volt.', ' ');
INSERT INTO answer VALUES (1833, 459, 0, '650 Volt.', ' ');
INSERT INTO answer VALUES (1834, 459, 1, '163 Volt.', ' ');
INSERT INTO answer VALUES (1835, 459, 2, '325 Volt.', ' ');
INSERT INTO answer VALUES (1836, 459, 3, '460 Volt.', ' ');
INSERT INTO answer VALUES (1837, 460, 0, '2,5 Watt', ' ');
INSERT INTO answer VALUES (1838, 460, 1, '5 Watt', ' ');
INSERT INTO answer VALUES (1839, 460, 2, '10 Watt', ' ');
INSERT INTO answer VALUES (1840, 460, 3, '0,5 Watt', ' ');
INSERT INTO answer VALUES (1841, 461, 0, '3&pi;/2; 270°', ' ');
INSERT INTO answer VALUES (1842, 461, 1, '&pi;/3; 270°', ' ');
INSERT INTO answer VALUES (1843, 461, 2, '3&pi;; 180°', ' ');
INSERT INTO answer VALUES (1844, 461, 3, '3&pi;/4; 135°', ' ');
INSERT INTO answer VALUES (1845, 462, 0, '45°.', ' ');
INSERT INTO answer VALUES (1846, 462, 1, '0°.', ' ');
INSERT INTO answer VALUES (1847, 462, 2, '90°.', ' ');
INSERT INTO answer VALUES (1848, 462, 3, '180°.', ' ');
INSERT INTO answer VALUES (1849, 463, 0, '1500 Hz, 4500 Hz, 7500 Hz und höher', ' ');
INSERT INTO answer VALUES (1850, 463, 1, '1500 Hz, 3000 Hz, 4500 Hz und höher', ' ');
INSERT INTO answer VALUES (1851, 463, 2, '1500 Hz, 2250 Hz, 3000 Hz und höher', ' ');
INSERT INTO answer VALUES (1852, 463, 3, '1500 Hz, 3000 Hz, 6000 Hz und höher', ' ');
INSERT INTO answer VALUES (1853, 464, 0, '0,2 ms.', ' ');
INSERT INTO answer VALUES (1854, 464, 1, '260 µs.', ' ');
INSERT INTO answer VALUES (1855, 464, 2, '230 µs.', ' ');
INSERT INTO answer VALUES (1856, 464, 3, '150 µs.', ' ');
INSERT INTO answer VALUES (1857, 465, 0, 'Harmonische sind die ganzzahligen (1, 2, 3 ...) Vielfachen einer Frequenz.', ' ');
INSERT INTO answer VALUES (1858, 465, 1, 'Harmonische sind die ganzzahligen (1, 2, 3 ...) Teile einer Frequenz.', ' ');
INSERT INTO answer VALUES (1859, 465, 2, 'Harmonische sind die erzeugten Frequenzen oberhalb der ursprünglichen Frequenz.', ' ');
INSERT INTO answer VALUES (1860, 465, 3, 'Harmonische sind identisch mit den Oberwellen, wobei die Grundwelle keine Harmonische ist.', ' ');
INSERT INTO answer VALUES (1861, 466, 0, 'die vierte Harmonische der Frequenz.', ' ');
INSERT INTO answer VALUES (1862, 466, 1, 'die dritte Harmonische der Frequenz.', ' ');
INSERT INTO answer VALUES (1863, 466, 2, 'die zweite Harmonische der Frequenz.', ' ');
INSERT INTO answer VALUES (1864, 466, 3, 'die zweite ungeradzahlige Harmonische der Frequenz.', ' ');
INSERT INTO answer VALUES (1865, 467, 0, '2 kHz und 4 kHz', ' ');
INSERT INTO answer VALUES (1866, 467, 1, '4 kHz und 6 kHz', ' ');
INSERT INTO answer VALUES (1867, 467, 2, '4 kHz allein', ' ');
INSERT INTO answer VALUES (1868, 467, 3, '2 kHz und 6 kHz', ' ');
INSERT INTO answer VALUES (1869, 468, 0, '2 kHz und 6 kHz', ' ');
INSERT INTO answer VALUES (1870, 468, 1, '4 kHz und 6 kHz', ' ');
INSERT INTO answer VALUES (1871, 468, 2, '2 kHz und 4 kHz', ' ');
INSERT INTO answer VALUES (1872, 468, 3, '4 kHz allein', ' ');
INSERT INTO answer VALUES (1873, 469, 0, 'proportional zur Bandbreite.', ' ');
INSERT INTO answer VALUES (1874, 469, 1, 'umgekehrt proportional zur Empfängerempfindlichkeit.', ' ');
INSERT INTO answer VALUES (1875, 469, 2, 'proportional zum Signal-Rauschabstand.', ' ');
INSERT INTO answer VALUES (1876, 469, 3, 'umgekehrt proportional zum Eingangswiderstand.', ' ');
INSERT INTO answer VALUES (1877, 470, 0, 'verringert sich um etwa 7 dB.', ' ');
INSERT INTO answer VALUES (1878, 470, 1, 'erhöht sich um etwa 7 dB.', ' ');
INSERT INTO answer VALUES (1879, 470, 2, 'verringert sich um etwa 20 dB.', ' ');
INSERT INTO answer VALUES (1880, 470, 3, 'erhöht sich um etwa 20 dB.', ' ');
INSERT INTO answer VALUES (1881, 471, 0, 'Sie entspricht der Differenz zwischen der höchsten und der niedrigsten Frequenz des NF-Signals.', ' ');
INSERT INTO answer VALUES (1882, 471, 1, 'Sie entspricht der Hälfte der Bandbreite des NF-Signals.', ' ');
INSERT INTO answer VALUES (1883, 471, 2, 'Sie entspricht der doppelten Bandbreite des NF-Signals.', ' ');
INSERT INTO answer VALUES (1884, 471, 3, 'Sie ist Null, weil bei SSB-Modulation der HF-Träger unterdrückt wird.', ' ');
INSERT INTO answer VALUES (1885, 472, 0, '7,048 MHz', ' ');
INSERT INTO answer VALUES (1886, 472, 1, '7,050 MHz', ' ');
INSERT INTO answer VALUES (1887, 472, 2, '7,052 MHz', ' ');
INSERT INTO answer VALUES (1888, 472, 3, '7,048 MHz und 7,052 MHz', ' ');
INSERT INTO answer VALUES (1889, 473, 0, 'Die Bandbreite beträgt ungefähr 7,6 kHz', ' ');
INSERT INTO answer VALUES (1890, 473, 1, 'Die Bandbreite beträgt ungefähr 3,8 kHz', ' ');
INSERT INTO answer VALUES (1891, 473, 2, 'Die Bandbreite beträgt ungefähr 5,8 kHz', ' ');
INSERT INTO answer VALUES (1892, 473, 3, 'Die Bandbreite beträgt ungefähr 12 kHz', ' ');
INSERT INTO answer VALUES (1893, 474, 0, 'Um das Signal/Rausch-Verhältnis durch Anheben der Amplituden der höheren Modulationsfrequenzen zu verbessern.', ' ');
INSERT INTO answer VALUES (1894, 474, 1, 'Um das breitbandige FM-Signal durch Anheben der Amplituden der höheren Modulationsfrequenzen auf Schmalband FM zu reduzieren.', ' ');
INSERT INTO answer VALUES (1895, 474, 2, 'Um die Ausgangsleistung durch Verdichtung des Spektrums der Modulationsfrequenzen zu erhöhen.', ' ');
INSERT INTO answer VALUES (1896, 474, 3, 'Um das FM Kanalraster von 25 kHz auf 12,5 kHz durch Reduzierung der Bandbreite zu ermöglichen.', ' ');
INSERT INTO answer VALUES (1897, 475, 0, 'Nein, im Normalfall ist keine Unterscheidung möglich.', ' ');
INSERT INTO answer VALUES (1898, 475, 1, 'Ja, weil bei Phasenmodulation die Frequenz immer konstant ist.', ' ');
INSERT INTO answer VALUES (1899, 475, 2, 'Ja, weil bei Frequenzmodulation ein kräftigeres Signal erzeugt wird.', ' ');
INSERT INTO answer VALUES (1900, 475, 3, 'Ja, weil phasenmodulierte Aussendungen in FM-Empfängern bzw. frequenzmodulierte Aussendungen in Phasendiskriminatoren erhebliche Verzerrungen verursachen.', ' ');
INSERT INTO answer VALUES (1901, 476, 0, 'Intermodulationsprodukte erzeugen.', ' ');
INSERT INTO answer VALUES (1902, 476, 1, 'Frequenzmodulation hervorrufen.', ' ');
INSERT INTO answer VALUES (1903, 476, 2, 'zwei gleiche Seitenbänder produzieren.', ' ');
INSERT INTO answer VALUES (1904, 476, 3, 'einen so genannten Dopplereffekt hervorrufen.', ' ');
INSERT INTO answer VALUES (1905, 477, 0, 'die unmittelbar nach dem Senderausgang messbare Leistung, bevor sie Zusatzgeräte (z.B. Anpassgeräte) durchläuft.', ' ');
INSERT INTO answer VALUES (1906, 477, 1, 'die unmittelbar nach dem Senderausgang gemessene Differenz aus vorlaufender und rücklaufender Leistung.', ' ');
INSERT INTO answer VALUES (1907, 477, 2, 'die unmittelbar nach den erforderlichen Zusatzgeräten (z.B. Anpassgeräte) messbare Leistung.', ' ');
INSERT INTO answer VALUES (1908, 477, 3, 'die unmittelbar nach dem Senderausgang gemessene Summe aus vorlaufender und rücklaufender Leistung.', ' ');
INSERT INTO answer VALUES (1909, 478, 0, 'die durchschnittliche Leistung, die ein Sender unter normalen Betriebsbedingungen während einer Periode der Hochfrequenzschwingung bei der höchsten Spitze der Modulationshüllkurve der Antennenspeiseleitung zuführt.', ' ');
INSERT INTO answer VALUES (1910, 478, 1, 'die unmittelbar nach dem Senderausgang messbare Leistung über die Spitzen der Periode einer durchschnittlichen Hochfrequenzschwingung, bevor Zusatzgeräte (z.B. Anpassgeräte) durchlaufen werden.', ' ');
INSERT INTO answer VALUES (1911, 478, 2, 'die durchschnittliche Leistung, die ein Sender unter normalen Betriebsbedingungen an die Antennenspeiseleitung während eines Zeitintervalls abgibt, das im Verhältnis zur Periode der tiefsten Modulationsfrequenz ausreichend lang ist.', ' ');
INSERT INTO answer VALUES (1912, 478, 3, 'das Produkt aus der Leistung, die unmittelbar der Antenne zugeführt wird und ihrem Gewinnfaktor in einer Richtung, bezogen auf den Halbwellendipol.', ' ');
INSERT INTO answer VALUES (1913, 479, 0, 'die durchschnittliche Leistung, die ein Sender unter normalen Betriebsbedingungen an die Antennenspeiseleitung während eines Zeitintervalls abgibt, das im Verhältnis zur Periode der tiefsten Modulationsfrequenz ausreichend lang ist.', ' ');
INSERT INTO answer VALUES (1914, 479, 1, 'die unmittelbar nach dem Senderausgang messbare Leistung über die Spitzen der Periode einer durchschnittlichen Hochfrequenzschwingung, bevor Zusatzgeräte (z.B. Anpassgeräte) durchlaufen werden.', ' ');
INSERT INTO answer VALUES (1915, 479, 2, 'die durchschnittliche Leistung, die ein Sender unter normalen Betriebsbedingungen während einer Periode der Hochfrequenzschwingung bei der höchsten Spitze der Modulationshüllkurve der Antennenspeiseleitung zuführt.', ' ');
INSERT INTO answer VALUES (1916, 479, 3, 'das Produkt aus der Leistung, die unmittelbar der Antenne zugeführt wird und ihrem Gewinnfaktor in einer Richtung, bezogen auf den Halbwellendipol.', ' ');
INSERT INTO answer VALUES (1917, 480, 0, 'das Produkt aus der Leistung, die unmittelbar der Antenne zugeführt wird und ihrem Gewinnfaktor in einer Richtung, bezogen auf den Halbwellendipol.', ' ');
INSERT INTO answer VALUES (1918, 480, 1, 'das Produkt aus der Leistung, die unmittelbar der Antenne zugeführt wird und ihrem Gewinnfaktor in einer Richtung, bezogen auf den isotropen Kugelstrahler.', ' ');
INSERT INTO answer VALUES (1919, 480, 2, 'die durchschnittliche Leistung, die ein Sender unter normalen Betriebsbedingungen während einer Periode der Hochfrequenzschwingung bei der höchsten Spitze der Modulationshüllkurve der Antennenspeiseleitung zuführt.', ' ');
INSERT INTO answer VALUES (1920, 480, 3, 'die durchschnittliche Leistung, die ein Sender unter normalen Betriebsbedingungen an die Antennenspeiseleitung während eines Zeitintervalls abgibt, das im Verhältnis zur Periode der tiefsten Modulationsfrequenz ausreichend lang ist.', ' ');
INSERT INTO answer VALUES (1921, 481, 0, 'das Produkt aus der Leistung, die unmittelbar der Antenne zugeführt wird und ihrem Gewinnfaktor in einer Richtung, bezogen auf den isotropen Kugelstrahler.', ' ');
INSERT INTO answer VALUES (1922, 481, 1, 'das Produkt aus der Leistung, die unmittelbar der Antenne zugeführt wird und ihrem Gewinnfaktor in einer Richtung, bezogen auf den Halbwellendipol.', ' ');
INSERT INTO answer VALUES (1923, 481, 2, 'die durchschnittliche Leistung, die ein Sender unter normalen Betriebsbedingungen während einer Periode der Hochfrequenzschwingung bei der höchsten Spitze der Modulationshüllkurve der Antennenspeiseleitung zuführt.', ' ');
INSERT INTO answer VALUES (1924, 481, 3, 'die durchschnittliche Leistung, die ein Sender unter normalen Betriebsbedingungen an die Antennenspeiseleitung während eines Zeitintervalls abgibt, das im Verhältnis zur Periode der tiefsten Modulationsfrequenz ausreichend lang ist.', ' ');
INSERT INTO answer VALUES (1925, 482, 0, 'bei der die unterhalb ihrer unteren und oberhalb ihrer oberen Frequenzgrenzen ausgesendeten mittleren Leistungen jeweils 0,5 % der gesamten mittleren Leistung einer gegebenen Aussendung betragen.', ' ');
INSERT INTO answer VALUES (1926, 482, 1, 'bei der die oberhalb ihrer unteren und unterhalb ihrer oberen Frequenzgrenzen ausgesendeten mittleren Leistungen jeweils 50 % der gesamten mittleren Leistung einer gegebenen Aussendung betragen.', ' ');
INSERT INTO answer VALUES (1927, 482, 2, 'bei der die oberhalb ihrer unteren und unterhalb ihrer oberen Frequenzgrenzen ausgesendeten mittleren Leistungen jeweils 10 % der gesamten mittleren Leistung einer gegebenen Aussendung betragen.', ' ');
INSERT INTO answer VALUES (1928, 482, 3, 'bei der die unterhalb ihrer unteren und oberhalb ihrer oberen Frequenzgrenzen ausgesendeten mittleren Leistungen jeweils 5 % der gesamten mittleren Leistung einer gegebenen Aussendung betragen.', ' ');
INSERT INTO answer VALUES (1929, 483, 0, 'Es ist die Leistung, die man einem isotropen Strahler zuführen müsste, damit dieser die gleiche Feldstärke erzeugt wie eine im Vergleich herangezogene reale Antenne, in die eine Antenneneingangsleistung P eingespeist wird.', ' ');
INSERT INTO answer VALUES (1930, 483, 1, 'Es ist die Eingangsleistung des verwendeten Senders wie sie in der EMVU-Selbsterklärung anzugeben ist.', ' ');
INSERT INTO answer VALUES (1931, 483, 2, 'Es handelt sich um die Leistung, die man im Maximum der Strahlungskeule einer Dipolantenne vorfindet.', ' ');
INSERT INTO answer VALUES (1932, 483, 3, 'Es ist die durchschnittliche Leistung der Amateurfunkstelle wie sie in der EMVU-Selbsterklärung anzugeben ist.', ' ');
INSERT INTO answer VALUES (1933, 484, 0, 'HF-Leistung bei der höchsten Spitze der Hüllkurve.', ' ');
INSERT INTO answer VALUES (1934, 484, 1, 'Durchschnittsleistung einer SSB-Übertragung.', ' ');
INSERT INTO answer VALUES (1935, 484, 2, 'Spitzen-Spitzen-Leistung bei den höchsten Spitzen der Modulationshüllkurve.', ' ');
INSERT INTO answer VALUES (1936, 484, 3, 'Mindestleistung bei der Modulationsspitze.', ' ');
INSERT INTO answer VALUES (1937, 485, 0, 'ERP = (P<sub>Sender</sub> - P<sub>Verluste</sub>) • G<sub>Antenne</sub> bezogen auf den Halbwellendipol', ' ');
INSERT INTO answer VALUES (1938, 485, 1, 'ERP = (P<sub>Sender</sub> • G<sub>Antenne</sub>) - P<sub>Verluste</sub> bezogen auf den isotropen Kugelstrahler', ' ');
INSERT INTO answer VALUES (1939, 485, 2, 'ERP = (P<sub>Sender</sub> + P<sub>Verluste</sub>) • G<sub>Antenne</sub> bezogen auf den Halbwellendipol', ' ');
INSERT INTO answer VALUES (1940, 485, 3, 'ERP = P<sub>Sender</sub> + P<sub>Verluste</sub> + G<sub>Antenne</sub> bezogen auf den isotropen Kugelstrahler', ' ');
INSERT INTO answer VALUES (1941, 486, 0, 'P<sub>EIRP</sub> = (P<sub>Sender</sub> - P<sub>Verluste</sub>) • G<sub>Antenne</sub> bezogen auf den isotropen Kugelstrahler', ' ');
INSERT INTO answer VALUES (1942, 486, 1, 'P<sub>EIRP</sub> = (P<sub>Sender</sub> • G<sub>Antenne</sub>) - P<sub>Verluste</sub> bezogen auf den Halbwellendipol', ' ');
INSERT INTO answer VALUES (1943, 486, 2, 'P<sub>EIRP</sub> = (P<sub>Sender</sub> + P<sub>Verluste</sub>) • G<sub>Antenne</sub> bezogen auf den isotropen Kugelstrahler', ' ');
INSERT INTO answer VALUES (1944, 486, 3, 'P<sub>EIRP</sub> = P<sub>Sender</sub> + P<sub>Verluste</sub> + G<sub>Antenne</sub> bezogen auf den Halbwellendipol', ' ');
INSERT INTO answer VALUES (1945, 487, 0, 'auf das für eine zufrieden stellende Kommunikation erforderliche Minimum eingestellt werden.', ' ');
INSERT INTO answer VALUES (1946, 487, 1, 'nur auf den zulässigen Pegel eingestellt werden.', ' ');
INSERT INTO answer VALUES (1947, 487, 2, 'auf die für eine zufrieden stellende Kommunikation erforderlichen 750 W eingestellt werden.', ' ');
INSERT INTO answer VALUES (1948, 487, 3, 'die Hälfte des maximal zulässigen Pegels betragen.', ' ');
INSERT INTO answer VALUES (1949, 488, 0, 'Ja, es sind aber die Effektivwerte einzusetzen.', ' ');
INSERT INTO answer VALUES (1950, 488, 1, 'Nein, denn Spannung und Strom ändern sich laufend.', ' ');
INSERT INTO answer VALUES (1951, 488, 2, 'Ja, es darf aber immer nur mit den Spitzenwerten gerechnet werden.', ' ');
INSERT INTO answer VALUES (1952, 488, 3, 'Nein, denn Spannung und Strom sind um den Phasenwinkel Phi verschoben.', ' ');
INSERT INTO answer VALUES (1953, 489, 0, 'Fast null Watt', ' ');
INSERT INTO answer VALUES (1954, 489, 1, '0,9 Watt', ' ');
INSERT INTO answer VALUES (1955, 489, 2, '0,75 Watt', ' ');
INSERT INTO answer VALUES (1956, 489, 3, '9 Watt', ' ');
INSERT INTO answer VALUES (1957, 490, 0, '1 W', ' ');
INSERT INTO answer VALUES (1958, 490, 1, '0,125 W', ' ');
INSERT INTO answer VALUES (1959, 490, 2, '10 W', ' ');
INSERT INTO answer VALUES (1960, 490, 3, '100 mW', ' ');
INSERT INTO answer VALUES (1961, 491, 0, '4 A', ' ');
INSERT INTO answer VALUES (1962, 491, 1, '250 mA', ' ');
INSERT INTO answer VALUES (1963, 491, 2, '750 mA', ' ');
INSERT INTO answer VALUES (1964, 491, 3, '36 A', ' ');
INSERT INTO answer VALUES (1965, 492, 0, '200 W.', ' ');
INSERT INTO answer VALUES (1966, 492, 1, '141 W.', ' ');
INSERT INTO answer VALUES (1967, 492, 2, '100 W.', ' ');
INSERT INTO answer VALUES (1968, 492, 3, '283 W.', ' ');
INSERT INTO answer VALUES (1969, 493, 0, '55 W', ' ');
INSERT INTO answer VALUES (1970, 493, 1, '27,5 W', ' ');
INSERT INTO answer VALUES (1971, 493, 2, '750 W', ' ');
INSERT INTO answer VALUES (1972, 493, 3, '5 W', ' ');
INSERT INTO answer VALUES (1973, 494, 0, '200 W.', ' ');
INSERT INTO answer VALUES (1974, 494, 1, '100 W.', ' ');
INSERT INTO answer VALUES (1975, 494, 2, '25 W.', ' ');
INSERT INTO answer VALUES (1976, 494, 3, '250 W.', ' ');
INSERT INTO answer VALUES (1977, 495, 0, '45 %.', ' ');
INSERT INTO answer VALUES (1978, 495, 1, '55 %.', ' ');
INSERT INTO answer VALUES (1979, 495, 2, '100 %.', ' ');
INSERT INTO answer VALUES (1980, 495, 3, '222 %.', ' ');
INSERT INTO answer VALUES (1981, 496, 0, '3 dB', ' ');
INSERT INTO answer VALUES (1982, 496, 1, '-6 dB', ' ');
INSERT INTO answer VALUES (1983, 496, 2, '-3 dB', ' ');
INSERT INTO answer VALUES (1984, 496, 3, '6 dBm', ' ');
INSERT INTO answer VALUES (1985, 497, 0, '9,75 % zu niedrig bestimmen.', ' ');
INSERT INTO answer VALUES (1986, 497, 1, '5 % zu niedrig bestimmen.', ' ');
INSERT INTO answer VALUES (1987, 497, 2, '10,25 % zu hoch bestimmen.', ' ');
INSERT INTO answer VALUES (1988, 497, 3, '5 % zu hoch bestimmen.', ' ');
INSERT INTO answer VALUES (1989, 498, 0, '<p><img src=''tb922a.png''></p>', ' ');
INSERT INTO answer VALUES (1990, 498, 1, '<p><img src=''tb922b.png''></p>', ' ');
INSERT INTO answer VALUES (1991, 498, 2, '<p><img src=''tb922c.png''></p>', ' ');
INSERT INTO answer VALUES (1992, 498, 3, '<p><img src=''tb922d.png''></p>', ' ');
INSERT INTO answer VALUES (1993, 499, 0, '<p><img src=''tb923a.png''></p>', ' ');
INSERT INTO answer VALUES (1994, 499, 1, '<p><img src=''tb923b.png''></p>', ' ');
INSERT INTO answer VALUES (1995, 499, 2, '<p><img src=''tb923c.png''></p>', ' ');
INSERT INTO answer VALUES (1996, 499, 3, '<p><img src=''tb923d.png''></p>', ' ');
INSERT INTO answer VALUES (1997, 500, 0, '<p><img src=''tb924a.png''></p>', ' ');
INSERT INTO answer VALUES (1998, 500, 1, '<p><img src=''tb924b.png''></p>', ' ');
INSERT INTO answer VALUES (1999, 500, 2, '<p><img src=''tb924c.png''></p>', ' ');
INSERT INTO answer VALUES (2000, 500, 3, '<p><img src=''tb924d.png''></p>', ' ');
INSERT INTO answer VALUES (2001, 501, 0, '<p><img src=''tc101a.jpg''></p>', ' ');
INSERT INTO answer VALUES (2002, 501, 1, '<p><img src=''tc101b.jpg''></p>', ' ');
INSERT INTO answer VALUES (2003, 501, 2, '<p><img src=''tc101c.jpg''></p>', ' ');
INSERT INTO answer VALUES (2004, 501, 3, '<p><img src=''tc101d.jpg''></p>', ' ');
INSERT INTO answer VALUES (2005, 502, 0, 'haben geringe Fertigungstoleranzen und Temperaturabhängigkeit und sind besonders als Präzisionswiderstände geeignet.', ' ');
INSERT INTO answer VALUES (2006, 502, 1, 'sind induktionsarm und eignen sich besonders für den Einsatz bei sehr hohen Frequenzen.', ' ');
INSERT INTO answer VALUES (2007, 502, 2, 'sind besonders als Hochlastwiderstände bei niedrigen Frequenzen geeignet.', ' ');
INSERT INTO answer VALUES (2008, 502, 3, 'haben einen extrem stark negativen Temperaturkoeffizienten und sind besonders als NTC-Widerstände (Heißleiter) geeignet.', ' ');
INSERT INTO answer VALUES (2009, 503, 0, 'sind induktionsarm und eignen sich besonders für den Einsatz bei sehr hohen Frequenzen.', ' ');
INSERT INTO answer VALUES (2010, 503, 1, 'haben geringe Toleranzen und Widerstandsänderungen und sind besonders als Präzisionswiderstände in der Messtechnik geeignet.', ' ');
INSERT INTO answer VALUES (2011, 503, 2, 'sind besonders als Hochlastwiderstände bei niedrigen Frequenzen geeignet.', ' ');
INSERT INTO answer VALUES (2012, 503, 3, 'haben einen extrem stark negativen Temperaturkoeffizienten und sind besonders als NTC-Widerstände (Heißleiter) geeignet.', ' ');
INSERT INTO answer VALUES (2013, 504, 0, 'sind besonders als Hochlastwiderstände bei niedrigen Frequenzen geeignet.', ' ');
INSERT INTO answer VALUES (2014, 504, 1, 'Drahtwiderstände werden hauptsächlich in Form von SMD-Widerständen hergestellt.', ' ');
INSERT INTO answer VALUES (2015, 504, 2, 'sind induktionsarm und eignen sich besonders für den Einsatz bei sehr hohen Frequenzen.', ' ');
INSERT INTO answer VALUES (2016, 504, 3, 'haben einen extrem stark negativen Temperaturkoeffizienten und sind besonders als NTC-Widerstände (Heißleiter) geeignet.', ' ');
INSERT INTO answer VALUES (2017, 505, 0, '0,1 kV', ' ');
INSERT INTO answer VALUES (2018, 505, 1, '10 V', ' ');
INSERT INTO answer VALUES (2019, 505, 2, '700 V', ' ');
INSERT INTO answer VALUES (2020, 505, 3, '1 V', ' ');
INSERT INTO answer VALUES (2021, 506, 0, '316 V', ' ');
INSERT INTO answer VALUES (2022, 506, 1, '100 V', ' ');
INSERT INTO answer VALUES (2023, 506, 2, '25 V', ' ');
INSERT INTO answer VALUES (2024, 506, 3, '700 V', ' ');
INSERT INTO answer VALUES (2025, 507, 0, '10 W', ' ');
INSERT INTO answer VALUES (2026, 507, 1, '100 W', ' ');
INSERT INTO answer VALUES (2027, 507, 2, '4,8 W', ' ');
INSERT INTO answer VALUES (2028, 507, 3, '0,5 W', ' ');
INSERT INTO answer VALUES (2029, 508, 0, '438 mA', ' ');
INSERT INTO answer VALUES (2030, 508, 1, '192 mA', ' ');
INSERT INTO answer VALUES (2031, 508, 2, '43,7 mA', ' ');
INSERT INTO answer VALUES (2032, 508, 3, '2,28 A', ' ');
INSERT INTO answer VALUES (2033, 509, 0, '5040 und 6160 &Omega;.', ' ');
INSERT INTO answer VALUES (2034, 509, 1, '4760 und 6440 &Omega;.', ' ');
INSERT INTO answer VALUES (2035, 509, 2, '4,7 und 6,8 k&Omega;.', ' ');
INSERT INTO answer VALUES (2036, 509, 3, '5,2 und 6,3 k&Omega;.', ' ');
INSERT INTO answer VALUES (2037, 510, 0, '250 mA', ' ');
INSERT INTO answer VALUES (2038, 510, 1, '400 mA', ' ');
INSERT INTO answer VALUES (2039, 510, 2, '4 A', ' ');
INSERT INTO answer VALUES (2040, 510, 3, '2,5 A', ' ');
INSERT INTO answer VALUES (2041, 511, 0, '8,8 mA.', ' ');
INSERT INTO answer VALUES (2042, 511, 1, '12,5 mA.', ' ');
INSERT INTO answer VALUES (2043, 511, 2, '25 mA.', ' ');
INSERT INTO answer VALUES (2044, 511, 3, '40 A.', ' ');
INSERT INTO answer VALUES (2045, 512, 0, 'für Tonfrequenzen bis etwa 15 kHz.', ' ');
INSERT INTO answer VALUES (2046, 512, 1, 'für Funkfrequenzen bis etwa 144 MHz.', ' ');
INSERT INTO answer VALUES (2047, 512, 2, 'für UHF-Senderausgänge mit 50 &Omega;.', ' ');
INSERT INTO answer VALUES (2048, 512, 3, 'als Langdrahtersatz.', ' ');
INSERT INTO answer VALUES (2049, 513, 0, 'ungewendelten Kohleschichtwiderständen zusammengebaut sein.', ' ');
INSERT INTO answer VALUES (2050, 513, 1, 'hochbelastbaren Drahtwiderständen zusammengebaut sein.', ' ');
INSERT INTO answer VALUES (2051, 513, 2, 'Glühbirnen zusammengebaut sein.', ' ');
INSERT INTO answer VALUES (2052, 513, 3, 'temperaturfesten Blindwiderständen bestehen.', ' ');
INSERT INTO answer VALUES (2053, 514, 0, '10 Kohleschichtwiderstände von 500 &Omega;', ' ');
INSERT INTO answer VALUES (2054, 514, 1, 'ein 50-&Omega;-Drahtwiderstand', ' ');
INSERT INTO answer VALUES (2055, 514, 2, '2 parallel geschaltete Drahtwiderstände von 100 &Omega;', ' ');
INSERT INTO answer VALUES (2056, 514, 3, 'ein Spulenanpassfilter im Ölbad', ' ');
INSERT INTO answer VALUES (2057, 515, 0, 'Aus induktionsarmen Kohleschichtwiderständen', ' ');
INSERT INTO answer VALUES (2058, 515, 1, 'Aus Drahtwiderständen mit kapazitätsarmen Anschlusskappen', ' ');
INSERT INTO answer VALUES (2059, 515, 2, 'Aus einem abgestimmten Topfkreis mit induktiver Einkopplung', ' ');
INSERT INTO answer VALUES (2060, 515, 3, 'Aus versilberten Kupfer-Rundstäben von 10 mm Durchmesser', ' ');
INSERT INTO answer VALUES (2061, 516, 0, 'Je größer der Plattenabstand ist, desto kleiner ist die Kapazität.', ' ');
INSERT INTO answer VALUES (2062, 516, 1, 'Je größer die angelegte Spannung ist, desto kleiner ist die Kapazität.', ' ');
INSERT INTO answer VALUES (2063, 516, 2, 'Je größer die Plattenoberfläche ist, desto kleiner ist die Kapazität.', ' ');
INSERT INTO answer VALUES (2064, 516, 3, 'Je größer die Dielektrizitätszahl ist, desto kleiner ist die Kapazität.', ' ');
INSERT INTO answer VALUES (2065, 517, 0, '<p><img src=''tc202a.jpg''></p>', ' ');
INSERT INTO answer VALUES (2066, 517, 1, '<p><img src=''tc202b.jpg''></p>', ' ');
INSERT INTO answer VALUES (2067, 517, 2, '<p><img src=''tc202c.jpg''></p>', ' ');
INSERT INTO answer VALUES (2068, 517, 3, '<p><img src=''tc202d.jpg''></p>', ' ');
INSERT INTO answer VALUES (2069, 518, 0, 'Der Strom eilt der Spannung um 90° voraus.', ' ');
INSERT INTO answer VALUES (2070, 518, 1, 'Die Spannung eilt dem Strom um 90° voraus.', ' ');
INSERT INTO answer VALUES (2071, 518, 2, 'Die Spannung eilt dem Strom um 45° voraus.', ' ');
INSERT INTO answer VALUES (2072, 518, 3, 'Der Strom eilt der Spannung um 45° voraus.', ' ');
INSERT INTO answer VALUES (2073, 519, 0, 'Er nimmt ab.', ' ');
INSERT INTO answer VALUES (2074, 519, 1, 'Er bleibt konstant.', ' ');
INSERT INTO answer VALUES (2075, 519, 2, 'Er nimmt zu.', ' ');
INSERT INTO answer VALUES (2076, 519, 3, 'Er wird unendlich.', ' ');
INSERT INTO answer VALUES (2077, 520, 0, '159 &Omega;', ' ');
INSERT INTO answer VALUES (2078, 520, 1, '1,59 k&Omega;', ' ');
INSERT INTO answer VALUES (2079, 520, 2, '318 &Omega;', ' ');
INSERT INTO answer VALUES (2080, 520, 3, '31,8 &Omega;', ' ');
INSERT INTO answer VALUES (2081, 521, 0, '6,37 µF', ' ');
INSERT INTO answer VALUES (2082, 521, 1, '0,637 µF', ' ');
INSERT INTO answer VALUES (2083, 521, 2, '0,45 µF', ' ');
INSERT INTO answer VALUES (2084, 521, 3, '4,5 µF', ' ');
INSERT INTO answer VALUES (2085, 522, 0, 'Der Blindwiderstand ist der mit negativem Vorzeichen versehene Wechselstromwiderstand eines Kondensators. Er ist abhängig von der Kapazität des Kondensators und der anliegenden Frequenz. Im Blindwiderstand entstehen keine Wärmeverluste.', ' ');
INSERT INTO answer VALUES (2086, 522, 1, 'Der Blindwiderstand ist der Gleichstromwiderstand eines Kondensators. Er ist abhängig vom Isolationsmaterial des Kondensators und der anliegenden Spannung. Auch im Blindwiderstand entstehen Wärmeverluste.', ' ');
INSERT INTO answer VALUES (2087, 522, 2, 'Der Blindwiderstand ist der Wechselstromwiderstand eines Kondensators. Er ist abhängig von der Blindkapazität des Kondensators und der anliegenden Spannung. Im Blindwiderstand entstehen hohe Verluste.', ' ');
INSERT INTO answer VALUES (2088, 522, 3, 'Der Blindwiderstand ist der HF-Gleichstromwiderstand eines Kondensators. Er wird mit steigender Kapazität sowie bei erhöhtem Wechselstromanteil und steigender Frequenz größer. Je höher die Frequenz umso eher wandern die Ladungen an die Plattenränder (Skin-Effekt).', ' ');
INSERT INTO answer VALUES (2089, 523, 0, 'den Verlustfaktor tan &delta; (Tangens Delta), der dem Kehrwert des Gütefaktors entspricht.', ' ');
INSERT INTO answer VALUES (2090, 523, 1, 'den relativen Verlustwiderstand in Ohm pro Picofarad, mit dem die Kondensatorgüte berechnet werden kann.', ' ');
INSERT INTO answer VALUES (2091, 523, 2, 'den relativen Blindwiderstand in Ohm pro Picofarad, mit dem die Kondensatorgüte berechnet werden kann.', ' ');
INSERT INTO answer VALUES (2092, 523, 3, 'den Verlustfaktor cos &phi; (Cosinus Phi), der dem Kehrwert des Gütefaktors entspricht.', ' ');
INSERT INTO answer VALUES (2093, 524, 0, 'Ja, infolge von Verlusten im Dielektrikum, die aber meist vernachlässigbar klein sind.', ' ');
INSERT INTO answer VALUES (2094, 524, 1, 'Nein, beim Kondensator handelt es sich immer nur um eine reine Blindleistung.', ' ');
INSERT INTO answer VALUES (2095, 524, 2, 'Ja, aber nur dann, wenn Luft als Dielektrikum verwendet wird.', ' ');
INSERT INTO answer VALUES (2096, 524, 3, 'Ja, genau wie bei Gleichstrom entsprechend den Formeln für Strom, Spannung und Leistung.', ' ');
INSERT INTO answer VALUES (2097, 525, 0, '<p><img src=''tc202b.jpg''></p>', ' ');
INSERT INTO answer VALUES (2098, 525, 1, '<p><img src=''tc202a.jpg''></p>', ' ');
INSERT INTO answer VALUES (2099, 525, 2, '<p><img src=''tc202c.jpg''></p>', ' ');
INSERT INTO answer VALUES (2100, 525, 3, '<p><img src=''tc202d.jpg''></p>', ' ');
INSERT INTO answer VALUES (2101, 526, 0, 'um 90° nach.', ' ');
INSERT INTO answer VALUES (2102, 526, 1, 'um 45° voraus.', ' ');
INSERT INTO answer VALUES (2103, 526, 2, 'um 45° nach.', ' ');
INSERT INTO answer VALUES (2104, 526, 3, 'um 90° voraus.', ' ');
INSERT INTO answer VALUES (2105, 527, 0, 'Er nimmt zu.', ' ');
INSERT INTO answer VALUES (2106, 527, 1, 'Er nimmt ab.', ' ');
INSERT INTO answer VALUES (2107, 527, 2, 'Er bleibt konstant.', ' ');
INSERT INTO answer VALUES (2108, 527, 3, 'Er steigt auf ein Maximum und fällt dann ab.', ' ');
INSERT INTO answer VALUES (2109, 528, 0, 'Beim Betrieb mit Gleichspannung wirkt nur der Gleichstromwiderstand der Spule. Beim Betrieb mit Wechselspannung wird der induktive Widerstand X<sub>L</sub> wirksam und erhöht den Gesamtwiderstand. Der Strom wird kleiner.', ' ');
INSERT INTO answer VALUES (2110, 528, 1, 'Beim Betrieb mit Gleichspannung wirkt nur der Gleichstromwiderstand der Spule. Beim Betrieb mit Wechselspannung wirkt nur der kleinere induktive Widerstand X<sub>L</sub>. Der Strom wird größer.', ' ');
INSERT INTO answer VALUES (2111, 528, 2, 'Beim Betrieb mit Gleich- oder Wechselspannung wirkt nur der ohmsche Widerstand X<sub>L</sub> der Spule. Der Strom bleibt gleich.', ' ');
INSERT INTO answer VALUES (2112, 528, 3, 'Beim Betrieb mit Wechselspannung wirkt nur der Wechselstromwiderstand der Spule. Beim Betrieb mit Gleichspannung wird nur der ohmsche Widerstand X<sub>L</sub> wirksam. Der Strom wird größer.', ' ');
INSERT INTO answer VALUES (2113, 529, 0, '1885 &Omega;', ' ');
INSERT INTO answer VALUES (2114, 529, 1, '942 &Omega;', ' ');
INSERT INTO answer VALUES (2115, 529, 2, '1885 k&Omega;', ' ');
INSERT INTO answer VALUES (2116, 529, 3, '1,9 &Omega;', ' ');
INSERT INTO answer VALUES (2117, 530, 0, 'Der Blindwiderstand ist der Wechselstromwiderstand einer Spule. Er ist abhängig von der Induktivität der Spule und der anliegenden Frequenz. Im Blindwiderstand entstehen keine Wärmeverluste.', ' ');
INSERT INTO answer VALUES (2118, 530, 1, 'Der Blindwiderstand ist der Gleichstromwiderstand einer Spule. Er ist abhängig vom Isolationsmaterial der Spule und der anliegenden Spannung. Auch im Blindwiderstand entstehen Wärmeverluste.', ' ');
INSERT INTO answer VALUES (2119, 530, 2, 'Der Blindwiderstand ist der Wechselstromwiderstand einer Spule. Er ist abhängig von der Blindinduktivität der Spule und der anliegenden Spannung. Im Blindwiderstand entstehen hohe Verluste.', ' ');
INSERT INTO answer VALUES (2120, 530, 3, 'Der Blindwiderstand ist der HF-Gleichstromwiderstand einer Spule. Er wird mit steigender Induktivität sowie bei erhöhtem Wechselstromanteil und steigender Frequenz größer. Je tiefer die Frequenz umso eher wandern die Elektronen an den Spulenrand (Skin-Effekt).', ' ');
INSERT INTO answer VALUES (2121, 531, 0, 'den Verlustfaktor tan &delta; (Tangens Delta), der dem Kehrwert des Gütefaktors entspricht.', ' ');
INSERT INTO answer VALUES (2122, 531, 1, 'den relativen Verlustwiderstand in Ohm pro Nanohenry, mit dem die Spulengüte berechnet werden kann.', ' ');
INSERT INTO answer VALUES (2123, 531, 2, 'den relativen Blindwiderstand in Ohm pro Nanohenry, mit dem die Spulengüte berechnet werden kann..', ' ');
INSERT INTO answer VALUES (2124, 531, 3, 'den Verlustfaktor cos &phi; (Cosinus Phi), der dem Kehrwert des Gütefaktors entspricht.', ' ');
INSERT INTO answer VALUES (2125, 532, 0, 'Ja, jeder Leiter, gleich welche Form er hat, weist eine Induktivität auf.', ' ');
INSERT INTO answer VALUES (2126, 532, 1, 'Nein, der Leiter muss wenigstens eine Krümmung (eine viertel, halbe oder ganze Windung) aufweisen.', ' ');
INSERT INTO answer VALUES (2127, 532, 2, 'Ja, aber die Größe der Induktivität hängt vom spezifischen Widerstand des Leitermaterials ab.', ' ');
INSERT INTO answer VALUES (2128, 532, 3, 'Ja, aber nicht immer, denn abgeschirmte Leiter, beispielsweise Koaxialkabel und Streifenleitungen, weisen nur eine Kapazität auf.', ' ');
INSERT INTO answer VALUES (2129, 533, 0, 'Durch Stauchen der Spule (Verkürzen der Spulenlänge).', ' ');
INSERT INTO answer VALUES (2130, 533, 1, 'Durch Auseinanderziehen der Spule (Vergrößerung der Spulenlänge).', ' ');
INSERT INTO answer VALUES (2131, 533, 2, 'Durch Einführen eines Kupferkerns in die Spule.', ' ');
INSERT INTO answer VALUES (2132, 533, 3, 'Durch Einbau der Spule in einen Abschirmbecher.', ' ');
INSERT INTO answer VALUES (2133, 534, 0, '89', ' ');
INSERT INTO answer VALUES (2134, 534, 1, '3', ' ');
INSERT INTO answer VALUES (2135, 534, 2, '2828', ' ');
INSERT INTO answer VALUES (2136, 534, 3, '53', ' ');
INSERT INTO answer VALUES (2137, 535, 0, '112,5 mH', ' ');
INSERT INTO answer VALUES (2138, 535, 1, '112,5 µH', ' ');
INSERT INTO answer VALUES (2139, 535, 2, '11,25 mH', ' ');
INSERT INTO answer VALUES (2140, 535, 3, '1,125 mH', ' ');
INSERT INTO answer VALUES (2141, 536, 0, '0,294 µH', ' ');
INSERT INTO answer VALUES (2142, 536, 1, '2,94 µH', ' ');
INSERT INTO answer VALUES (2143, 536, 2, '29,4 nH', ' ');
INSERT INTO answer VALUES (2144, 536, 3, '2,94 nH', ' ');
INSERT INTO answer VALUES (2145, 537, 0, '20', ' ');
INSERT INTO answer VALUES (2146, 537, 1, '400', ' ');
INSERT INTO answer VALUES (2147, 537, 2, '360', ' ');
INSERT INTO answer VALUES (2148, 537, 3, '6', ' ');
INSERT INTO answer VALUES (2149, 538, 0, 'Der Strom fließt bei hohen Frequenzen nur noch in der Oberfläche des Leiters. Mit sinkendem stromdurchflossenen Querschnitt steigt daher der effektive Widerstand des Leiters.', ' ');
INSERT INTO answer VALUES (2150, 538, 1, 'Der Skin-Effekt ist für den mit der Frequenz ansteigenden induktiven Widerstand verantwortlich', ' ');
INSERT INTO answer VALUES (2151, 538, 2, 'Der Strom fließt bei hohen Frequenzen nur noch in der Oberfläche des Leiters. Mit sinkendem stromdurchflossenen Querschnitt steigt daher der induktive Widerstand des Leiters.', ' ');
INSERT INTO answer VALUES (2152, 538, 3, 'Der Strom fließt bei hohen Frequenzen nur noch in der Oberfläche des Leiters. Mit sinkendem stromdurchflossenen Querschnitt vergrößert sich daher der kapazitive Widerstand des Leiters.', ' ');
INSERT INTO answer VALUES (2153, 539, 0, 'Als Skin-Effekt bezeichnet man die Erscheinung, dass sich mit steigender Frequenz der Elektronenstrom mehr und mehr zur Oberfläche eines Leiters hin verlagert. Dadurch erhöht sich mit steigender Frequenz der ohmsche Leiterwiderstand.', ' ');
INSERT INTO answer VALUES (2154, 539, 1, 'Als Skin-Effekt bezeichnet man die Erscheinung, dass sich mit steigender Frequenz der Elektronenstrom mehr und mehr zu den Kanten eines Kondensators hin verlagert. Dadurch erhöht sich mit steigender Frequenz die Kapazität.', ' ');
INSERT INTO answer VALUES (2155, 539, 2, 'Als Skin-Effekt bezeichnet man die Erscheinung, dass sich mit steigender Frequenz die Induktivität und die Kapazität eines Leiters erhöht. Dadurch erhöht sich mit steigendem Leiterwiderstand die Resonanzfrequenz.', ' ');
INSERT INTO answer VALUES (2156, 539, 3, 'Als Skin-Effekt bezeichnet man die Erscheinung, dass sich mit steigender Frequenz der Elektronenstrom mehr und mehr zur Leitermitte hin verlagert. Dadurch erhöht sich der ohmsche Leiterwiderstand bei hohem Wechselstromanteil.', ' ');
INSERT INTO answer VALUES (2157, 540, 0, 'Ferrit bestehen.', ' ');
INSERT INTO answer VALUES (2158, 540, 1, 'Kunststoff bestehen.', ' ');
INSERT INTO answer VALUES (2159, 540, 2, 'Stahl bestehen.', ' ');
INSERT INTO answer VALUES (2160, 540, 3, 'paramagnetischem Material bestehen.', ' ');
INSERT INTO answer VALUES (2161, 541, 0, 'Die Spule wird um einen Widerstand mit niedrigem Widerstandswert gewickelt.', ' ');
INSERT INTO answer VALUES (2162, 541, 1, 'Es wird eine freitragende Spule aus dickem Kupferdraht, der mit einem Silberbelag versehen ist, hergestellt.', ' ');
INSERT INTO answer VALUES (2163, 541, 2, 'Es wird ein dicker Kupferdraht um einen Widerstand mit sehr hohem Widerstandswert gewickelt.', ' ');
INSERT INTO answer VALUES (2164, 541, 3, 'Es wird ein Kohleschichtwiderstand mit niedrigem Widerstandswert verwendet.', ' ');
INSERT INTO answer VALUES (2165, 542, 0, 'in einem Abschirmbecher aus Metall untergebracht werden.', ' ');
INSERT INTO answer VALUES (2166, 542, 1, 'in einem nichtmetallischen Harz eingehüllt werden.', ' ');
INSERT INTO answer VALUES (2167, 542, 2, 'in einem Abschirmbecher aus Kunststoff untergebracht werden.', ' ');
INSERT INTO answer VALUES (2168, 542, 3, 'einen abgestimmten Kunststoffkern aufweisen.', ' ');
INSERT INTO answer VALUES (2169, 543, 0, 'ein veränderlicher Strom durch eine magnetisch gekoppelte benachbarte Spule fließt.', ' ');
INSERT INTO answer VALUES (2170, 543, 1, 'durch eine magnetisch gekoppelte benachbarte Spule kein Strom fließt.', ' ');
INSERT INTO answer VALUES (2171, 543, 2, 'ein konstanter Gleichstrom durch eine magnetisch gekoppelte benachbarte Spule fließt.', ' ');
INSERT INTO answer VALUES (2172, 543, 3, 'sich die Spule in einem konstanten Magnetfeld befindet.', ' ');
INSERT INTO answer VALUES (2173, 544, 0, '30 Windungen', ' ');
INSERT INTO answer VALUES (2174, 544, 1, '20 Windungen', ' ');
INSERT INTO answer VALUES (2175, 544, 2, '52 Windungen', ' ');
INSERT INTO answer VALUES (2176, 544, 3, '180 Windungen', ' ');
INSERT INTO answer VALUES (2177, 545, 0, '30 mA', ' ');
INSERT INTO answer VALUES (2178, 545, 1, '22,7 mA', ' ');
INSERT INTO answer VALUES (2179, 545, 2, '0,83 mA', ' ');
INSERT INTO answer VALUES (2180, 545, 3, '33,3 mA', ' ');
INSERT INTO answer VALUES (2181, 546, 0, '0,49 A', ' ');
INSERT INTO answer VALUES (2182, 546, 1, '1,96 A', ' ');
INSERT INTO answer VALUES (2183, 546, 2, '1,25 A', ' ');
INSERT INTO answer VALUES (2184, 546, 3, '0,23 A', ' ');
INSERT INTO answer VALUES (2185, 547, 0, '1 k&Omega;.', ' ');
INSERT INTO answer VALUES (2186, 547, 1, '64 k&Omega;.', ' ');
INSERT INTO answer VALUES (2187, 547, 2, '16 k&Omega;.', ' ');
INSERT INTO answer VALUES (2188, 547, 3, '4 k&Omega;.', ' ');
INSERT INTO answer VALUES (2189, 548, 0, '0,4 k&Omega;.', ' ');
INSERT INTO answer VALUES (2190, 548, 1, '25,6 k&Omega;.', ' ');
INSERT INTO answer VALUES (2191, 548, 2, '6,4 k&Omega;.', ' ');
INSERT INTO answer VALUES (2192, 548, 3, '1,6 k&Omega;.', ' ');
INSERT INTO answer VALUES (2193, 549, 0, '2:1 verwendet werden.', ' ');
INSERT INTO answer VALUES (2194, 549, 1, '4:1 verwendet werden.', ' ');
INSERT INTO answer VALUES (2195, 549, 2, '8:1 verwendet werden.', ' ');
INSERT INTO answer VALUES (2196, 549, 3, '16:1 verwendet werden.', ' ');
INSERT INTO answer VALUES (2197, 550, 0, '1:3,5 aufweisen.', ' ');
INSERT INTO answer VALUES (2198, 550, 1, '1:1 aufweisen.', ' ');
INSERT INTO answer VALUES (2199, 550, 2, '1:5,5 aufweisen.', ' ');
INSERT INTO answer VALUES (2200, 550, 3, '1:12 aufweisen.', ' ');
INSERT INTO answer VALUES (2201, 551, 0, 'Sie wandern von N nach P.', ' ');
INSERT INTO answer VALUES (2202, 551, 1, 'Sie wandern von P nach N.', ' ');
INSERT INTO answer VALUES (2203, 551, 2, 'Sie bleiben im N-Bereich.', ' ');
INSERT INTO answer VALUES (2204, 551, 3, 'Sie zerfallen beim Übergang.', ' ');
INSERT INTO answer VALUES (2205, 552, 0, 'den Stromfluss von P nach N.', ' ');
INSERT INTO answer VALUES (2206, 552, 1, 'den Stromfluss von N nach P.', ' ');
INSERT INTO answer VALUES (2207, 552, 2, 'keinen Stromfluss.', ' ');
INSERT INTO answer VALUES (2208, 552, 3, 'den Elektronenfluss von P nach N.', ' ');
INSERT INTO answer VALUES (2209, 553, 0, 'einen hohen Widerstand.', ' ');
INSERT INTO answer VALUES (2210, 553, 1, 'eine hohe Kapazität.', ' ');
INSERT INTO answer VALUES (2211, 553, 2, 'eine geringe Impedanz.', ' ');
INSERT INTO answer VALUES (2212, 553, 3, 'eine hohe Induktivität.', ' ');
INSERT INTO answer VALUES (2213, 554, 0, 'Germanium zwischen 0,2 und 0,4 Volt, bei Silizium zwischen 0,5 und 0,8 Volt.', ' ');
INSERT INTO answer VALUES (2214, 554, 1, 'Germanium zwischen 0,5 und 0,8 Volt, bei Silizium zwischen 0,2 und 0,4 Volt.', ' ');
INSERT INTO answer VALUES (2215, 554, 2, 'Germanium bei etwa 0,7 Volt, bei Silizium bei etwa 0,3 Volt.', ' ');
INSERT INTO answer VALUES (2216, 554, 3, 'allen Dioden bei etwa 0,7 Volt.', ' ');
INSERT INTO answer VALUES (2217, 555, 0, 'Die Spannung sinkt bei steigender Temperatur.', ' ');
INSERT INTO answer VALUES (2218, 555, 1, 'Die Spannung hängt allein vom Durchlassstrom ab.', ' ');
INSERT INTO answer VALUES (2219, 555, 2, 'Die Spannung hängt nur vom Trägermaterial ab (Germanium/Silizium).', ' ');
INSERT INTO answer VALUES (2220, 555, 3, 'Die Spannung steigt bei wachsender Temperatur.', ' ');
INSERT INTO answer VALUES (2221, 556, 0, 'An der Anode liegen 5,7 Volt, an der Katode 5,0 Volt an.', ' ');
INSERT INTO answer VALUES (2222, 556, 1, 'An der Anode liegen 5,7 Volt, an der Katode 6,4 Volt an.', ' ');
INSERT INTO answer VALUES (2223, 556, 2, 'An der Anode liegen 5,0 Volt, an der Katode 5,1 Volt an.', ' ');
INSERT INTO answer VALUES (2224, 556, 3, 'An der Anode liegen 5,0 Volt, an der Katode 5,7 Volt an.', ' ');
INSERT INTO answer VALUES (2225, 557, 0, '-0,4 V <img src="diode_ka.png"> 0,3 V', ' ');
INSERT INTO answer VALUES (2226, 557, 1, '-3,7 V <img src="diode_ak.png"> -3,0 V', ' ');
INSERT INTO answer VALUES (2227, 557, 2, '1,6 V <img src="diode_ka.png"> 0,9 V', ' ');
INSERT INTO answer VALUES (2228, 557, 3, '3,3 V <img src="diode_ak.png"> 4,0 V', ' ');
INSERT INTO answer VALUES (2229, 558, 0, '0,6 V <img src="diode_ka.png"> 1,3 V', ' ');
INSERT INTO answer VALUES (2230, 558, 1, '-1,4 V <img src="diode_ak.png"> -0,7 V', ' ');
INSERT INTO answer VALUES (2231, 558, 2, '5,0 V <img src="diode_ka.png"> 4,3 V', ' ');
INSERT INTO answer VALUES (2232, 558, 3, '3,4 V <img src="diode_ak.png"> 4,1 V', ' ');
INSERT INTO answer VALUES (2233, 559, 0, '-1,3 V <img src="diode_ak.png"> -2,0 V', ' ');
INSERT INTO answer VALUES (2234, 559, 1, '-0,6 V <img src="diode_ka.png"> -1,3 V', ' ');
INSERT INTO answer VALUES (2235, 559, 2, '4,3 V <img src="diode_ak.png"> 5,0 V', ' ');
INSERT INTO answer VALUES (2236, 559, 3, '4,1 V <img src="diode_ka.png"> 3,4 V', ' ');
INSERT INTO answer VALUES (2237, 560, 0, '-3 V <img src="diode_ak.png"> -3,7 V', ' ');
INSERT INTO answer VALUES (2238, 560, 1, '5,4 V <img src="diode_ka.png"> 4,7 V', ' ');
INSERT INTO answer VALUES (2239, 560, 2, '15 V <img src="diode_ak.png"> 18 V', ' ');
INSERT INTO answer VALUES (2240, 560, 3, '3,9 V <img src="diode_ka.png"> 3,2 V', ' ');
INSERT INTO answer VALUES (2241, 561, 0, '1: Schottkydiode, 2: Germaniumdiode, 3: Siliziumdiode', ' ');
INSERT INTO answer VALUES (2242, 561, 1, '1: Schottkydiode, 2: Siliziumdiode, 3: Germaniumdiode', ' ');
INSERT INTO answer VALUES (2243, 561, 2, '1: Germaniumdiode, 2: Schottkydiode, 3: Siliziumdiode', ' ');
INSERT INTO answer VALUES (2244, 561, 3, '1: Siliziumdiode, 3: Germaniumdiode, 3: Schottkydiode', ' ');
INSERT INTO answer VALUES (2245, 562, 0, 'Kennlinie 2', ' ');
INSERT INTO answer VALUES (2246, 562, 1, 'Kennlinie 1', ' ');
INSERT INTO answer VALUES (2247, 562, 2, 'Kennlinie 3', ' ');
INSERT INTO answer VALUES (2248, 562, 3, 'Kennlinie 4', ' ');
INSERT INTO answer VALUES (2249, 563, 0, 'Kennlinie 1: Schottkydiode<br> Kennlinie 2: Germaniumdiode<br> Kennlinie 3: Siliziumdiode<br> Kennlinie 4: Leuchtdiode', ' ');
INSERT INTO answer VALUES (2250, 563, 1, 'Kennlinie 1: Siliziumdiode<br> Kennlinie 2: Germaniumdiode<br> Kennlinie 3: Schottkydiode<br> Kennlinie 4: Leuchtdiode', ' ');
INSERT INTO answer VALUES (2251, 563, 2, 'Kennlinie 1: Schottkydiode<br> Kennlinie 2: Siliziumdiode<br> Kennlinie 3: Germaniumdiode<br> Kennlinie 4: Leuchtdiode', ' ');
INSERT INTO answer VALUES (2252, 563, 3, 'Kennlinie 1: Germaniumdiode<br> Kennlinie 2: Leuchtdiode<br> Kennlinie 3: Siliziumdiode<br> Kennlinie 4: Schottkydiode', ' ');
INSERT INTO answer VALUES (2253, 564, 0, '<p><img src=''tc514a.jpg''></p>', ' ');
INSERT INTO answer VALUES (2254, 564, 1, '<p><img src=''tc514b.jpg''></p>', ' ');
INSERT INTO answer VALUES (2255, 564, 2, '<p><img src=''tc514c.jpg''></p>', ' ');
INSERT INTO answer VALUES (2256, 564, 3, '<p><img src=''tc514d.jpg''></p>', ' ');
INSERT INTO answer VALUES (2257, 565, 0, '<p><img src=''tc515a.jpg''></p>', ' ');
INSERT INTO answer VALUES (2258, 565, 1, '<p><img src=''tc515b.jpg''></p>', ' ');
INSERT INTO answer VALUES (2259, 565, 2, '<p><img src=''tc515c.jpg''></p>', ' ');
INSERT INTO answer VALUES (2260, 565, 3, '<p><img src=''tc515d.jpg''></p>', ' ');
INSERT INTO answer VALUES (2261, 566, 0, '280 &Omega; / 175 mW.', ' ');
INSERT INTO answer VALUES (2262, 566, 1, '280 &Omega; / 300 mW.', ' ');
INSERT INTO answer VALUES (2263, 566, 2, '480 &Omega; / 300 mW.', ' ');
INSERT INTO answer VALUES (2264, 566, 3, '200 &Omega; / 175 mW.', ' ');
INSERT INTO answer VALUES (2265, 567, 0, '202 &Omega;.', ' ');
INSERT INTO answer VALUES (2266, 567, 1, '364 &Omega;.', ' ');
INSERT INTO answer VALUES (2267, 567, 2, '188 &Omega;.', ' ');
INSERT INTO answer VALUES (2268, 567, 3, '235 &Omega;.', ' ');
INSERT INTO answer VALUES (2269, 568, 0, '180 &Omega;.', ' ');
INSERT INTO answer VALUES (2270, 568, 1, '250 &Omega;.', ' ');
INSERT INTO answer VALUES (2271, 568, 2, '70 &Omega;.', ' ');
INSERT INTO answer VALUES (2272, 568, 3, '320 &Omega;.', ' ');
INSERT INTO answer VALUES (2273, 569, 0, '150 Ohm / 0,1 Watt', ' ');
INSERT INTO answer VALUES (2274, 569, 1, '220 Ohm / 0,25 Watt', ' ');
INSERT INTO answer VALUES (2275, 569, 2, '70 Ohm / 0,1 Watt', ' ');
INSERT INTO answer VALUES (2276, 569, 3, '290 Ohm / 0,25 Watt', ' ');
INSERT INTO answer VALUES (2277, 570, 0, 'Die Frequenz des Schwingkreises steigt.', ' ');
INSERT INTO answer VALUES (2278, 570, 1, 'Die Frequenz des Schwingkreises sinkt.', ' ');
INSERT INTO answer VALUES (2279, 570, 2, 'Die Frequenz des Schwingkreises ändert sich nicht.', ' ');
INSERT INTO answer VALUES (2280, 570, 3, 'Die Diode sperrt und der Schwingkreis wird unterbrochen.', ' ');
INSERT INTO answer VALUES (2281, 571, 0, 'Sie nimmt mit abnehmender Sperrspannung zu.', ' ');
INSERT INTO answer VALUES (2282, 571, 1, 'Sie erhöht sich mit zunehmender Durchlassspannung.', ' ');
INSERT INTO answer VALUES (2283, 571, 2, 'Sie nimmt mit zunehmender Sperrspannung zu.', ' ');
INSERT INTO answer VALUES (2284, 571, 3, 'Sie erhöht sich mit zunehmendem Durchlassstrom.', ' ');
INSERT INTO answer VALUES (2285, 572, 0, 'Sehr niedrige Durchlassspannung und sehr hohe Schaltfrequenz.', ' ');
INSERT INTO answer VALUES (2286, 572, 1, 'Sehr niedrige Durchlassspannung und sehr niedrige Schaltfrequenz.', ' ');
INSERT INTO answer VALUES (2287, 572, 2, 'Sehr hohe Durchlassspannung und sehr hohe Schaltfrequenz.', ' ');
INSERT INTO answer VALUES (2288, 572, 3, 'Sehr hohe Durchlassspannung und sehr niedrige Schaltfrequenz.', ' ');
INSERT INTO answer VALUES (2289, 573, 0, 'die Entkopplung zweier Stromkreise.', ' ');
INSERT INTO answer VALUES (2290, 573, 1, 'die Erzeugung von Wechselstrom durch Licht.', ' ');
INSERT INTO answer VALUES (2291, 573, 2, 'die Abgabe von Licht zur Signalanzeige.', ' ');
INSERT INTO answer VALUES (2292, 573, 3, 'die Erzeugung von Gleichstrom durch Licht.', ' ');
INSERT INTO answer VALUES (2293, 574, 0, 'die Umwandlung von Licht in elektrischen Strom.', ' ');
INSERT INTO answer VALUES (2294, 574, 1, 'die Abgabe von Licht zur Signalanzeige.', ' ');
INSERT INTO answer VALUES (2295, 574, 2, 'die Entkopplung zweier Wechselstromkreise.', ' ');
INSERT INTO answer VALUES (2296, 574, 3, 'die Gewinnung von Wechselstrom aus Licht.', ' ');
INSERT INTO answer VALUES (2297, 575, 0, '<p><img src=''tc525a.jpg''></p>', ' ');
INSERT INTO answer VALUES (2298, 575, 1, '<p><img src=''tc525b.jpg''></p>', ' ');
INSERT INTO answer VALUES (2299, 575, 2, '<p><img src=''tc525c.jpg''></p>', ' ');
INSERT INTO answer VALUES (2300, 575, 3, '<p><img src=''tc525d.jpg''></p>', ' ');
INSERT INTO answer VALUES (2301, 576, 0, '<p><img src=''tc525d.jpg''></p>', ' ');
INSERT INTO answer VALUES (2302, 576, 1, '<p><img src=''tc525b.jpg''></p>', ' ');
INSERT INTO answer VALUES (2303, 576, 2, '<p><img src=''tc525c.jpg''></p>', ' ');
INSERT INTO answer VALUES (2304, 576, 3, '<p><img src=''tc525a.jpg''></p>', ' ');
INSERT INTO answer VALUES (2305, 577, 0, 'D<sub>1</sub> leitet. D<sub>2</sub> leitet. D<sub>3</sub> leitet nicht.', ' ');
INSERT INTO answer VALUES (2306, 577, 1, 'D<sub>1</sub> leitet. D<sub>2</sub> leitet. D<sub>3</sub> leitet.', ' ');
INSERT INTO answer VALUES (2307, 577, 2, 'D<sub>1</sub> leitet. D<sub>2</sub> leitet nicht. D<sub>3</sub> leitet nicht.', ' ');
INSERT INTO answer VALUES (2308, 577, 3, 'D<sub>1</sub> leitet nicht. D<sub>2</sub> leitet. D<sub>3</sub> leitet.', ' ');
INSERT INTO answer VALUES (2309, 578, 0, '<p><img src=''tc528a.jpg''></p>', ' ');
INSERT INTO answer VALUES (2310, 578, 1, '<p><img src=''tc528b.jpg''></p>', ' ');
INSERT INTO answer VALUES (2311, 578, 2, '<p><img src=''tc528c.jpg''></p>', ' ');
INSERT INTO answer VALUES (2312, 578, 3, '<p><img src=''tc528d.jpg''></p>', ' ');
INSERT INTO answer VALUES (2313, 579, 0, '1: NPN-Transistor 2: PNP-Transistor', ' ');
INSERT INTO answer VALUES (2314, 579, 1, '1: PNP-Transistor 2: NPN-Transistor', ' ');
INSERT INTO answer VALUES (2315, 579, 2, '1: N-Kanal-Transistor 2: P-Kanal-Transistor', ' ');
INSERT INTO answer VALUES (2316, 579, 3, '1: P-Kanal-Transistor 2: N-Kanal-Transistor', ' ');
INSERT INTO answer VALUES (2317, 580, 0, '1: Selbstleitender N-Kanal-Sperrschicht-FET<br> 2: Selbstleitender P-Kanal-Sperrschicht-FET', ' ');
INSERT INTO answer VALUES (2318, 580, 1, '1: Selbstsperrender N-Kanal-Sperrschicht-FET<br> 2: Selbstsperrender P-Kanal-Sperrschicht-FET', ' ');
INSERT INTO answer VALUES (2319, 580, 2, '1: Selbstleitender P-Kanal-Sperrschicht-FET<br> 2: Selbstleitender N-Kanal-Sperrschicht-FET', ' ');
INSERT INTO answer VALUES (2320, 580, 3, '1: Selbstsperrender P-Kanal-Sperrschicht-FET<br> 2: Selbstsperrender N-Kanal-Sperrschicht-FET', ' ');
INSERT INTO answer VALUES (2321, 581, 0, 'Selbstsperrender N-Kanal-Isolierschicht FET (MOSFET).', ' ');
INSERT INTO answer VALUES (2322, 581, 1, 'Selbstsperrender P-Kanal-Isolierschicht FET (MOSFET).', ' ');
INSERT INTO answer VALUES (2323, 581, 2, 'Selbstleitender N-Kanal-Isolierschicht FET (MOSFET).', ' ');
INSERT INTO answer VALUES (2324, 581, 3, 'Selbstleitender P-Kanal-Isolierschicht FET (MOSFET).', ' ');
INSERT INTO answer VALUES (2325, 582, 0, '<p><img src=''tc604a.jpg''></p>', ' ');
INSERT INTO answer VALUES (2326, 582, 1, '<p><img src=''tc604b.jpg''></p>', ' ');
INSERT INTO answer VALUES (2327, 582, 2, '<p><img src=''tc604c.jpg''></p>', ' ');
INSERT INTO answer VALUES (2328, 582, 3, '<p><img src=''tc604d.jpg''></p>', ' ');
INSERT INTO answer VALUES (2329, 583, 0, '<p><img src=''tc605a.jpg''></p>', ' ');
INSERT INTO answer VALUES (2330, 583, 1, '<p><img src=''tc605b.jpg''></p>', ' ');
INSERT INTO answer VALUES (2331, 583, 2, '<p><img src=''tc605c.jpg''></p>', ' ');
INSERT INTO answer VALUES (2332, 583, 3, '<p><img src=''tc605d.jpg''></p>', ' ');
INSERT INTO answer VALUES (2333, 584, 0, '2 = Drain, 3 = Source', ' ');
INSERT INTO answer VALUES (2334, 584, 1, '2 = Source, 3 = Drain', ' ');
INSERT INTO answer VALUES (2335, 584, 2, '2 = Drain, 3 = Emitter', ' ');
INSERT INTO answer VALUES (2336, 584, 3, '2 = Gate 2, 3 = Gate 1', ' ');
INSERT INTO answer VALUES (2337, 585, 0, 'NPN-Transistoren benötigen positive, PNP-Transistoren negative Kollektorspannungen.', ' ');
INSERT INTO answer VALUES (2338, 585, 1, 'NPN- und PNP-Transistoren benötigen negative Kollektorspannungen.', ' ');
INSERT INTO answer VALUES (2339, 585, 2, 'PNP-Transistoren benötigen positive, NPN-Transistoren negative Kollektorspannung.', ' ');
INSERT INTO answer VALUES (2340, 585, 3, 'PNP- und NPN-Transistoren benötigen positive Kollektorspannungen.', ' ');
INSERT INTO answer VALUES (2341, 586, 0, 'NPN- und PNP-Transistoren', ' ');
INSERT INTO answer VALUES (2342, 586, 1, 'Dual-Gate-MOS-FETs', ' ');
INSERT INTO answer VALUES (2343, 586, 2, 'Isolierschicht FETs', ' ');
INSERT INTO answer VALUES (2344, 586, 3, 'Sperrschicht FETs', ' ');
INSERT INTO answer VALUES (2345, 587, 0, 'Die Gatespannung steuert den Widerstand des Kanals zwischen Source und Drain.', ' ');
INSERT INTO answer VALUES (2346, 587, 1, 'Die Gatespannung steuert den Gatestrom.', ' ');
INSERT INTO answer VALUES (2347, 587, 2, 'Der Gatestrom ist allein verantwortlich für den Drainstrom.', ' ');
INSERT INTO answer VALUES (2348, 587, 3, 'Der Gatestrom steuert den Widerstand des Kanals zwischen Source und Drain.', ' ');
INSERT INTO answer VALUES (2349, 588, 0, 'Es fließt kein Kollektorstrom.', ' ');
INSERT INTO answer VALUES (2350, 588, 1, 'Es fließt der maximale Kollektorstrom.', ' ');
INSERT INTO answer VALUES (2351, 588, 2, 'Es fließen ca. 5 bis 10 Milliampere.', ' ');
INSERT INTO answer VALUES (2352, 588, 3, 'Es fließen je nach Kollektorspannung 0,01 Ampere bis 1 Ampere.', ' ');
INSERT INTO answer VALUES (2353, 589, 0, 'auf Höhe der Emitterspannung liegt.', ' ');
INSERT INTO answer VALUES (2354, 589, 1, 'auf Höhe der Kollektorspannung liegt.', ' ');
INSERT INTO answer VALUES (2355, 589, 2, 'zwischen Kollektor und Emitterspannung liegt.', ' ');
INSERT INTO answer VALUES (2356, 589, 3, 'mindestens 0,6 V positiver ist, als das Emitterpotenzial.', ' ');
INSERT INTO answer VALUES (2357, 590, 0, 'Sie ist etwa 0,6 V höher als die Emitterspannung.', ' ');
INSERT INTO answer VALUES (2358, 590, 1, 'Sie entspricht der Kollektorspannung.', ' ');
INSERT INTO answer VALUES (2359, 590, 2, 'Sie ist viel höher als die Emitterspannung.', ' ');
INSERT INTO answer VALUES (2360, 590, 3, 'Sie liegt etwa 0,6 V unter der Emitterspannung.', ' ');
INSERT INTO answer VALUES (2361, 591, 0, 'in Durchlassrichtung.', ' ');
INSERT INTO answer VALUES (2362, 591, 1, 'im Leerlauf.', ' ');
INSERT INTO answer VALUES (2363, 591, 2, 'im Kurzschluss.', ' ');
INSERT INTO answer VALUES (2364, 591, 3, 'in Sperrrichtung.', ' ');
INSERT INTO answer VALUES (2365, 592, 0, '<p><img src=''tc614a.png''></p>', ' ');
INSERT INTO answer VALUES (2366, 592, 1, '<p><img src=''tc614b.png''></p>', ' ');
INSERT INTO answer VALUES (2367, 592, 2, '<p><img src=''tc614c.png''></p>', ' ');
INSERT INTO answer VALUES (2368, 592, 3, '<p><img src=''tc614d.png''></p>', ' ');
INSERT INTO answer VALUES (2369, 593, 0, '<p><img src=''tc615a.png''></p>', ' ');
INSERT INTO answer VALUES (2370, 593, 1, '<p><img src=''tc615b.png''></p>', ' ');
INSERT INTO answer VALUES (2371, 593, 2, '<p><img src=''tc615c.png''></p>', ' ');
INSERT INTO answer VALUES (2372, 593, 3, '<p><img src=''tc615d.png''></p>', ' ');
INSERT INTO answer VALUES (2373, 594, 0, '<p><img src=''tc616a.png''></p>', ' ');
INSERT INTO answer VALUES (2374, 594, 1, '<p><img src=''tc616b.png''></p>', ' ');
INSERT INTO answer VALUES (2375, 594, 2, '<p><img src=''tc616c.png''></p>', ' ');
INSERT INTO answer VALUES (2376, 594, 3, '<p><img src=''tc616d.png''></p>', ' ');
INSERT INTO answer VALUES (2377, 595, 0, '<p><img src=''tc617a.png''></p>', ' ');
INSERT INTO answer VALUES (2378, 595, 1, '<p><img src=''tc617b.png''></p>', ' ');
INSERT INTO answer VALUES (2379, 595, 2, '<p><img src=''tc617c.png''></p>', ' ');
INSERT INTO answer VALUES (2380, 595, 3, '<p><img src=''tc617d.png''></p>', ' ');
INSERT INTO answer VALUES (2381, 596, 0, '940 k&Omega;', ' ');
INSERT INTO answer VALUES (2382, 596, 1, '1 M&Omega;', ' ');
INSERT INTO answer VALUES (2383, 596, 2, '85,5 k&Omega;', ' ');
INSERT INTO answer VALUES (2384, 596, 3, '47 k&Omega;', ' ');
INSERT INTO answer VALUES (2385, 597, 0, '85,5 k&Omega;', ' ');
INSERT INTO answer VALUES (2386, 597, 1, '940 k&Omega;', ' ');
INSERT INTO answer VALUES (2387, 597, 2, '76,4 k&Omega;', ' ');
INSERT INTO answer VALUES (2388, 597, 3, '540 k&Omega;', ' ');
INSERT INTO answer VALUES (2389, 598, 0, '76,4 k&Omega;', ' ');
INSERT INTO answer VALUES (2390, 598, 1, '540 k&Omega;', ' ');
INSERT INTO answer VALUES (2391, 598, 2, '85,5 k&Omega;', ' ');
INSERT INTO answer VALUES (2392, 598, 3, '940 k&Omega;', ' ');
INSERT INTO answer VALUES (2393, 599, 0, '540 k&Omega;', ' ');
INSERT INTO answer VALUES (2394, 599, 1, '76,4 k&Omega;', ' ');
INSERT INTO answer VALUES (2395, 599, 2, '85,5 k&Omega;', ' ');
INSERT INTO answer VALUES (2396, 599, 3, '1,98 k&Omega;', ' ');
INSERT INTO answer VALUES (2397, 600, 0, '1,98 k&Omega;', ' ');
INSERT INTO answer VALUES (2398, 600, 1, '20,0 k&Omega;', ' ');
INSERT INTO answer VALUES (2399, 600, 2, '85,5 k&Omega;', ' ');
INSERT INTO answer VALUES (2400, 600, 3, '2,97 k&Omega;', ' ');
INSERT INTO answer VALUES (2401, 601, 0, 'Der Kollektorstrom wird nur durch R<sub>C</sub> begrenzt. Die Kollektorspannung sinkt auf zirka 0,1 Volt.', ' ');
INSERT INTO answer VALUES (2402, 601, 1, 'Es fließt Kurzschlussstrom und der Transistor wird zerstört.', ' ');
INSERT INTO answer VALUES (2403, 601, 2, 'Es fließt kein Kollektorstrom mehr. Die Kollektorspannung geht auf Betriebsspannung.', ' ');
INSERT INTO answer VALUES (2404, 601, 3, 'Der Kollektorstrom steigt stark an. Die Kollektorspannung geht auf Betriebsspannung.', ' ');
INSERT INTO answer VALUES (2405, 602, 0, 'Es fließt kein Kollektorstrom mehr. Die Kollektorspannung geht auf Betriebsspannung.', ' ');
INSERT INTO answer VALUES (2406, 602, 1, 'Es fließt Kurzschlussstrom und der Transistor wird zerstört.', ' ');
INSERT INTO answer VALUES (2407, 602, 2, 'Der Kollektorstrom wird nur durch R<sub>C</sub> begrenzt. Die Kollektorspannung sinkt auf zirka 0,1 Volt.', ' ');
INSERT INTO answer VALUES (2408, 602, 3, 'Der Kollektorstrom steigt stark an. Die Kollektorspannung geht auf Betriebsspannung.', ' ');
INSERT INTO answer VALUES (2409, 603, 0, '10', ' ');
INSERT INTO answer VALUES (2410, 603, 1, '1/10', ' ');
INSERT INTO answer VALUES (2411, 603, 2, '1', ' ');
INSERT INTO answer VALUES (2412, 603, 3, '0', ' ');
INSERT INTO answer VALUES (2413, 604, 0, '<p><img src=''tc626a.jpg''></p>', ' ');
INSERT INTO answer VALUES (2414, 604, 1, '<p><img src=''tc626b.jpg''></p>', ' ');
INSERT INTO answer VALUES (2415, 604, 2, '<p><img src=''tc626c.jpg''></p>', ' ');
INSERT INTO answer VALUES (2416, 604, 3, '<p><img src=''tc626d.jpg''></p>', ' ');
INSERT INTO answer VALUES (2417, 605, 0, 'eine komplexe Schaltung auf einem Halbleiterkristallblättchen.', ' ');
INSERT INTO answer VALUES (2418, 605, 1, 'eine aus einzelnen Bauteilen aufgebaute vergossene Schaltung.', ' ');
INSERT INTO answer VALUES (2419, 605, 2, 'eine miniaturisierte, aus SMD-Bauteilen aufgebaute Schaltung.', ' ');
INSERT INTO answer VALUES (2420, 605, 3, 'die Zusammenschaltung einzelner Baugruppen zu einem elektronischen Gerät.', ' ');
INSERT INTO answer VALUES (2421, 606, 0, 'Ein Gatter verarbeitet binäre Signale nach logischen Grundmustern.', ' ');
INSERT INTO answer VALUES (2422, 606, 1, 'Ein Gatter konvertiert digitale Eingangssignale in analoge Ausgangssignale.', ' ');
INSERT INTO answer VALUES (2423, 606, 2, 'Ein Gatter ist eine bistabile Kippschaltung, die zwei stabile Zustände (0 und 1) besitzt.', ' ');
INSERT INTO answer VALUES (2424, 606, 3, 'Ein Gatter berechnet die Summe oder die Differenz aus zwei binären Ziffern.', ' ');
INSERT INTO answer VALUES (2425, 607, 0, 'UND-Glied (AND), ODER-Glied (OR), NICHT-UND-Glied (NAND), NICHT-ODER-Glied (NOR).', ' ');
INSERT INTO answer VALUES (2426, 607, 1, '(+)-Gatter (UND), (-)-Gatter (OR), NICHT-(+)-Gatter (NUND), NICHT-(-)-Gatter (NODER).', ' ');
INSERT INTO answer VALUES (2427, 607, 2, 'UND-Glied (UND), ODER-Glied (ODER), NICHT-UND-Glied (NUND), NICHT-ODER-Glied (NODER).', ' ');
INSERT INTO answer VALUES (2428, 607, 3, 'UND-Gatter (UNG), ODER-Gatter (ORG), NICHT-UND-Gatter (NUNG), NICHT-ODER-Gatter (NORG).', ' ');
INSERT INTO answer VALUES (2429, 608, 0, 'X=0 und Y=0', ' ');
INSERT INTO answer VALUES (2430, 608, 1, 'X=0 und Y=1', ' ');
INSERT INTO answer VALUES (2431, 608, 2, 'X=1 und Y=0', ' ');
INSERT INTO answer VALUES (2432, 608, 3, 'X=1 und Y=1', ' ');
INSERT INTO answer VALUES (2433, 609, 0, 'Die Schaltung stellt ein NAND-Gatter [negiertes UND-Gatter] dar. Der Ausgang Z führt dann Nullpotential, wenn die Eingänge A und B mit der Betriebsspannung verbunden sind. In allen anderen Fällen führt der Ausgang Z die Betriebsspannung.', ' ');
INSERT INTO answer VALUES (2434, 609, 1, 'Die Schaltung stellt ein NOR-Gatter [negiertes ODER-Gatter] dar. Der Ausgang Z führt dann die Betriebsspannung, wenn keiner der beiden Eingänge A oder B mit der Betriebsspannung verbunden ist. In allen anderen Fällen führt der Ausgang Z Nullpotential.', ' ');
INSERT INTO answer VALUES (2435, 609, 2, 'Die Schaltung stellt ein AND-Gatter dar. Der Ausgang Z führt dann Betriebsspannung, wenn die Eingänge A und B mit der Betriebsspannung verbunden sind. In allen anderen Fällen führt der Ausgang Z Nullpotential.', ' ');
INSERT INTO answer VALUES (2436, 609, 3, 'Die Schaltung stellt ein OR-Gatter dar. Der Ausgang Z führt dann Nullpotential, wenn die Eingänge A und B mit der Betriebsspannung verbunden sind. In allen anderen Fällen führt der Ausgang Z die Betriebsspannung.', ' ');
INSERT INTO answer VALUES (2437, 610, 0, 'Die Schaltung stellt ein NOR-Gatter [negiertes ODER-Gatter] dar. Der Ausgang Z führt dann die Betriebsspannung, wenn beide Eingänge A und B Nullpotential führen bzw. offen sind. In allen anderen Fällen führt der Ausgang Z Nullpotential.', ' ');
INSERT INTO answer VALUES (2438, 610, 1, 'Die Schaltung stellt ein NAND-Gatter [negiertes UND-Gatter] dar. Der Ausgang Z führt dann Nullpotential, wenn die Eingänge A und B mit der Betriebsspannung verbunden sind. In allen anderen Fällen führt der Ausgang Z die Betriebsspannung.', ' ');
INSERT INTO answer VALUES (2439, 610, 2, 'Die Schaltung stellt ein OR-Gatter dar. Der Ausgang Z führt dann Betriebsspannung, wenn die Eingänge A und B mit der Betriebsspannung verbunden sind. In allen anderen Fällen führt der Ausgang Z Nullpotential.', ' ');
INSERT INTO answer VALUES (2440, 610, 3, 'Die Schaltung stellt ein AND-Gatter dar. Der Ausgang Z führt dann Nullpotential, wenn die Eingänge A und B mit der Betriebsspannung verbunden sind. In allen anderen Fällen führt der Ausgang Z die Betriebsspannung.', ' ');
INSERT INTO answer VALUES (2441, 611, 0, 'X<sub>1</sub>', ' ');
INSERT INTO answer VALUES (2442, 611, 1, 'X<sub>2</sub>', ' ');
INSERT INTO answer VALUES (2443, 611, 2, 'X<sub>3</sub>', ' ');
INSERT INTO answer VALUES (2444, 611, 3, 'X<sub>4</sub>', ' ');
INSERT INTO answer VALUES (2445, 612, 0, 'X<sub>3</sub>', ' ');
INSERT INTO answer VALUES (2446, 612, 1, 'X<sub>1</sub>', ' ');
INSERT INTO answer VALUES (2447, 612, 2, 'X<sub>2</sub>', ' ');
INSERT INTO answer VALUES (2448, 612, 3, 'X<sub>4</sub>', ' ');
INSERT INTO answer VALUES (2449, 613, 0, 'X<sub>2</sub>', ' ');
INSERT INTO answer VALUES (2450, 613, 1, 'X<sub>1</sub>', ' ');
INSERT INTO answer VALUES (2451, 613, 2, 'X<sub>3</sub>', ' ');
INSERT INTO answer VALUES (2452, 613, 3, 'X<sub>4</sub>', ' ');
INSERT INTO answer VALUES (2453, 614, 0, '+3 V bis +15 V', ' ');
INSERT INTO answer VALUES (2454, 614, 1, '+2,5 V bis +5,5 V', ' ');
INSERT INTO answer VALUES (2455, 614, 2, '±2,5 bis ±5,5 V', ' ');
INSERT INTO answer VALUES (2456, 614, 3, '± 5 V', ' ');
INSERT INTO answer VALUES (2457, 615, 0, 'Operationsverstärker sind gleichstromgekoppelte Verstärker mit sehr hohem Verstärkungsfaktor und großer Linearität.', ' ');
INSERT INTO answer VALUES (2458, 615, 1, 'Operationsverstärker sind wechselstromgekoppelte Verstärker mit niedrigem Eingangswiderstand und großer Linearität.', ' ');
INSERT INTO answer VALUES (2459, 615, 2, 'Operationsverstärker sind in Empfängerstufen eingebaute Analogverstärker mit sehr niedrigem Verstärkungsfaktor aber großer Linearität.', ' ');
INSERT INTO answer VALUES (2460, 615, 3, 'Operationsverstärker sind digitale Schaltkreise mit niedrigem Verstärkungsfaktor aber großer Linearität.', ' ');
INSERT INTO answer VALUES (2461, 616, 0, 'Der Eingangswiderstand ist sehr hoch. Der Ausgangswiderstand ist niedrig. Die Spannungsverstärkung ist gleich eins.', ' ');
INSERT INTO answer VALUES (2462, 616, 1, 'Der Eingangswiderstand ist sehr hoch. Der Ausgangswiderstand ist niedrig. Die Spannungsverstärkung ist sehr hoch.', ' ');
INSERT INTO answer VALUES (2463, 616, 2, 'Der Eingangswiderstand ist niedrig. Der Ausgangswiderstand ist sehr hoch. Die Spannungsverstärkung ist hoch.', ' ');
INSERT INTO answer VALUES (2464, 616, 3, 'Der Eingangswiderstand ist sehr niedrig. Der Ausgangswiderstand ist hoch. Die Spannungsverstärkung ist niedrig.', ' ');
INSERT INTO answer VALUES (2465, 617, 0, '10', ' ');
INSERT INTO answer VALUES (2466, 617, 1, '11', ' ');
INSERT INTO answer VALUES (2467, 617, 2, '19,8', ' ');
INSERT INTO answer VALUES (2468, 617, 3, '24,2', ' ');
INSERT INTO answer VALUES (2469, 618, 0, '11', ' ');
INSERT INTO answer VALUES (2470, 618, 1, '10', ' ');
INSERT INTO answer VALUES (2471, 618, 2, '19,8', ' ');
INSERT INTO answer VALUES (2472, 618, 3, '24,2', ' ');
INSERT INTO answer VALUES (2473, 619, 0, 'zirka 20 k&Omega;', ' ');
INSERT INTO answer VALUES (2474, 619, 1, 'zirka 1 k&Omega;', ' ');
INSERT INTO answer VALUES (2475, 619, 2, 'zirka 400 k&Omega;', ' ');
INSERT INTO answer VALUES (2476, 619, 3, 'zirka 1,9 k&Omega;', ' ');
INSERT INTO answer VALUES (2477, 620, 0, '<p><img src=''tc716a.jpg''></p>', ' ');
INSERT INTO answer VALUES (2478, 620, 1, '<p><img src=''tc716b.jpg''></p>', ' ');
INSERT INTO answer VALUES (2479, 620, 2, '<p><img src=''tc716c.jpg''></p>', ' ');
INSERT INTO answer VALUES (2480, 620, 3, '<p><img src=''tc716d.jpg''></p>', ' ');
INSERT INTO answer VALUES (2481, 621, 0, '<p><img src=''tc716b.jpg''></p>', ' ');
INSERT INTO answer VALUES (2482, 621, 1, '<p><img src=''tc716a.jpg''></p>', ' ');
INSERT INTO answer VALUES (2483, 621, 2, '<p><img src=''tc716c.jpg''></p>', ' ');
INSERT INTO answer VALUES (2484, 621, 3, '<p><img src=''tc716d.jpg''></p>', ' ');
INSERT INTO answer VALUES (2485, 622, 0, 'Das von der Gitterspannung hervorgerufene elektrische Feld steuert den Anodenstrom.', ' ');
INSERT INTO answer VALUES (2486, 622, 1, 'Die Anodenspannung steuert das magnetische Feld an der Anode und damit den Anodenstrom.', ' ');
INSERT INTO answer VALUES (2487, 622, 2, 'Die Heizspannung steuert das elektrische Feld an der Katode und damit den Anodenstrom.', ' ');
INSERT INTO answer VALUES (2488, 622, 3, 'Die Katodenvorspannung steuert das magnetische Feld an der Katode und damit den Gitterstrom.', ' ');
INSERT INTO answer VALUES (2489, 623, 0, 'Der Anodenstrom sinkt.', ' ');
INSERT INTO answer VALUES (2490, 623, 1, 'Der Anodenstrom steigt.', ' ');
INSERT INTO answer VALUES (2491, 623, 2, 'Der Anodenstrom verändert sich nicht.', ' ');
INSERT INTO answer VALUES (2492, 623, 3, 'Der Anodenstrom steigt erst und sinkt dann wieder.', ' ');
INSERT INTO answer VALUES (2493, 624, 0, '142.', ' ');
INSERT INTO answer VALUES (2494, 624, 1, '78.', ' ');
INSERT INTO answer VALUES (2495, 624, 2, '156.', ' ');
INSERT INTO answer VALUES (2496, 624, 3, '248.', ' ');
INSERT INTO answer VALUES (2497, 625, 0, '26.', ' ');
INSERT INTO answer VALUES (2498, 625, 1, '11.', ' ');
INSERT INTO answer VALUES (2499, 625, 2, '16.', ' ');
INSERT INTO answer VALUES (2500, 625, 3, '160.', ' ');
INSERT INTO answer VALUES (2501, 626, 0, '32, 16, 8, 4, 2, 1', ' ');
INSERT INTO answer VALUES (2502, 626, 1, '1, 2, 4, 8, 16, 32', ' ');
INSERT INTO answer VALUES (2503, 626, 2, '65536, 256, 16, 4, 2, 1', ' ');
INSERT INTO answer VALUES (2504, 626, 3, '100000, 10000, 1000, 100, 10, 1', ' ');
INSERT INTO answer VALUES (2505, 627, 0, '7,3 k&Omega;', ' ');
INSERT INTO answer VALUES (2506, 627, 1, '4,0 k&Omega;', ' ');
INSERT INTO answer VALUES (2507, 627, 2, '1,8 k&Omega;', ' ');
INSERT INTO answer VALUES (2508, 627, 3, '35 k&Omega;', ' ');
INSERT INTO answer VALUES (2509, 628, 0, '0,01 µF', ' ');
INSERT INTO answer VALUES (2510, 628, 1, '0,09 µF', ' ');
INSERT INTO answer VALUES (2511, 628, 2, '0,001 µF', ' ');
INSERT INTO answer VALUES (2512, 628, 3, '0,009 µF', ' ');
INSERT INTO answer VALUES (2513, 629, 0, '0,065 µF', ' ');
INSERT INTO answer VALUES (2514, 629, 1, '0,650 µF', ' ');
INSERT INTO answer VALUES (2515, 629, 2, '650 nF', ' ');
INSERT INTO answer VALUES (2516, 629, 3, '650 000 pF', ' ');
INSERT INTO answer VALUES (2517, 630, 0, '1532 µH', ' ');
INSERT INTO answer VALUES (2518, 630, 1, '1503 µH', ' ');
INSERT INTO answer VALUES (2519, 630, 2, '1873 nH', ' ');
INSERT INTO answer VALUES (2520, 630, 3, '1873 µH', ' ');
INSERT INTO answer VALUES (2521, 631, 0, '1,873 µH', ' ');
INSERT INTO answer VALUES (2522, 631, 1, '187,3 nH', ' ');
INSERT INTO answer VALUES (2523, 631, 2, '1532 µH', ' ');
INSERT INTO answer VALUES (2524, 631, 3, '1,532 µH', ' ');
INSERT INTO answer VALUES (2525, 632, 0, '10,9 pF', ' ');
INSERT INTO answer VALUES (2526, 632, 1, '0,12 nF', ' ');
INSERT INTO answer VALUES (2527, 632, 2, '4,1 pF', ' ');
INSERT INTO answer VALUES (2528, 632, 3, '40 pF', ' ');
INSERT INTO answer VALUES (2529, 633, 0, '550 &Omega;', ' ');
INSERT INTO answer VALUES (2530, 633, 1, '360 &Omega;', ' ');
INSERT INTO answer VALUES (2531, 633, 2, '1150 &Omega;', ' ');
INSERT INTO answer VALUES (2532, 633, 3, '383 &Omega;', ' ');
INSERT INTO answer VALUES (2533, 634, 0, 'U<sub>1</sub> = 5 • U<sub>2</sub>', ' ');
INSERT INTO answer VALUES (2534, 634, 1, 'U<sub>1</sub> = 6 • U<sub>2</sub>', ' ');
INSERT INTO answer VALUES (2535, 634, 2, 'U<sub>1</sub> = U<sub>2</sub> / 5', ' ');
INSERT INTO answer VALUES (2536, 634, 3, 'U<sub>1</sub> = U<sub>2</sub> / 6', ' ');
INSERT INTO answer VALUES (2537, 635, 0, 'U<sub>1</sub> = U<sub>2</sub> / 6', ' ');
INSERT INTO answer VALUES (2538, 635, 1, 'U<sub>1</sub> = 6 • U<sub>2</sub>', ' ');
INSERT INTO answer VALUES (2539, 635, 2, 'U<sub>1</sub> = U<sub>2</sub> / 5', ' ');
INSERT INTO answer VALUES (2540, 635, 3, 'U<sub>1</sub> = 5 • U<sub>2</sub>', ' ');
INSERT INTO answer VALUES (2541, 636, 0, 'Spannungen, Ströme, Widerstände und Leistungen einzelner Komponenten müssen unter Beachtung der Phasenwinkel geometrisch addiert werden.', ' ');
INSERT INTO answer VALUES (2542, 636, 1, 'Spannungen, Ströme, Widerstände und Leistungen einzelner Komponenten müssen unter Beachtung der Thomsonschen Schwingungsgleichung addiert werden.', ' ');
INSERT INTO answer VALUES (2543, 636, 2, 'An Stelle des ohmschen Gesetzes tritt bei Blindwiderständen im Wechselstromkreis die Thomsonsche Schwingungsgleichung.', ' ');
INSERT INTO answer VALUES (2544, 636, 3, 'Für jede Kombination von R, L und C gelten eigene ohmsche Gesetze.', ' ');
INSERT INTO answer VALUES (2545, 637, 0, '30 V', ' ');
INSERT INTO answer VALUES (2546, 637, 1, '20 V', ' ');
INSERT INTO answer VALUES (2547, 637, 2, '15 V', ' ');
INSERT INTO answer VALUES (2548, 637, 3, '40 V', ' ');
INSERT INTO answer VALUES (2549, 638, 0, '0,5 mA', ' ');
INSERT INTO answer VALUES (2550, 638, 1, '1,0 mA', ' ');
INSERT INTO answer VALUES (2551, 638, 2, '1,6 mA', ' ');
INSERT INTO answer VALUES (2552, 638, 3, '4,5 mA', ' ');
INSERT INTO answer VALUES (2553, 639, 0, '2,5 mW', ' ');
INSERT INTO answer VALUES (2554, 639, 1, '5,0 mW', ' ');
INSERT INTO answer VALUES (2555, 639, 2, '1,5 mW', ' ');
INSERT INTO answer VALUES (2556, 639, 3, '0,15 W', ' ');
INSERT INTO answer VALUES (2557, 640, 0, '5,0 k&Omega;', ' ');
INSERT INTO answer VALUES (2558, 640, 1, '557 &Omega;', ' ');
INSERT INTO answer VALUES (2559, 640, 2, '10,0 k&Omega;', ' ');
INSERT INTO answer VALUES (2560, 640, 3, '2,5 k&Omega;', ' ');
INSERT INTO answer VALUES (2561, 641, 0, '3 W bei Parallel- und bei Reihenschaltung.', ' ');
INSERT INTO answer VALUES (2562, 641, 1, '3 W bei Parallel- und 1 W bei Reihenschaltung.', ' ');
INSERT INTO answer VALUES (2563, 641, 2, '1 W bei Parallel- und 3 W bei Reihenschaltung.', ' ');
INSERT INTO answer VALUES (2564, 641, 3, '1 W bei Parallel- und bei Reihenschaltung.', ' ');
INSERT INTO answer VALUES (2565, 642, 0, '0,3 µF', ' ');
INSERT INTO answer VALUES (2566, 642, 1, '0,255 µF', ' ');
INSERT INTO answer VALUES (2567, 642, 2, '0,027 µF', ' ');
INSERT INTO answer VALUES (2568, 642, 3, '2,73 nF', ' ');
INSERT INTO answer VALUES (2569, 643, 0, '0,027 µF', ' ');
INSERT INTO answer VALUES (2570, 643, 1, '2,73 nF', ' ');
INSERT INTO answer VALUES (2571, 643, 2, '0,3 µF', ' ');
INSERT INTO answer VALUES (2572, 643, 3, '0,255 µF', ' ');
INSERT INTO answer VALUES (2573, 644, 0, '5 nF', ' ');
INSERT INTO answer VALUES (2574, 644, 1, '12,5 nF', ' ');
INSERT INTO answer VALUES (2575, 644, 2, '7,5 nF', ' ');
INSERT INTO answer VALUES (2576, 644, 3, '0,015 nF', ' ');
INSERT INTO answer VALUES (2577, 645, 0, '1,0 µF', ' ');
INSERT INTO answer VALUES (2578, 645, 1, '4400 nF', ' ');
INSERT INTO answer VALUES (2579, 645, 2, '2,5 µF', ' ');
INSERT INTO answer VALUES (2580, 645, 3, '4,0 µF', ' ');
INSERT INTO answer VALUES (2581, 646, 0, '1821 pF', ' ');
INSERT INTO answer VALUES (2582, 646, 1, '66 pF', ' ');
INSERT INTO answer VALUES (2583, 646, 2, '1,6 nF', ' ');
INSERT INTO answer VALUES (2584, 646, 3, '&asymp;1 pF', ' ');
INSERT INTO answer VALUES (2585, 647, 0, '1100 &Omega;.', ' ');
INSERT INTO answer VALUES (2586, 647, 1, '2200 &Omega;.', ' ');
INSERT INTO answer VALUES (2587, 647, 2, '4400 &Omega;.', ' ');
INSERT INTO answer VALUES (2588, 647, 3, '2,2 k&Omega;.', ' ');
INSERT INTO answer VALUES (2589, 648, 0, '266,7 bis 300 &Omega;', ' ');
INSERT INTO answer VALUES (2590, 648, 1, '200 bis 400 &Omega;', ' ');
INSERT INTO answer VALUES (2591, 648, 2, '100 bis 200 &Omega;', ' ');
INSERT INTO answer VALUES (2592, 648, 3, '300 bis 366,7 &Omega;', ' ');
INSERT INTO answer VALUES (2593, 649, 0, '10,2 k&Omega;', ' ');
INSERT INTO answer VALUES (2594, 649, 1, '82,7 k&Omega;', ' ');
INSERT INTO answer VALUES (2595, 649, 2, '12,7 k&Omega;', ' ');
INSERT INTO answer VALUES (2596, 649, 3, '4,5 k&Omega;', ' ');
INSERT INTO answer VALUES (2597, 650, 0, '4,5 k&Omega;', ' ');
INSERT INTO answer VALUES (2598, 650, 1, '31,5 k&Omega;', ' ');
INSERT INTO answer VALUES (2599, 650, 2, '10,2 k&Omega;', ' ');
INSERT INTO answer VALUES (2600, 650, 3, '5,5 k&Omega;', ' ');
INSERT INTO answer VALUES (2601, 651, 0, 'eines Serienschwingkreises.', ' ');
INSERT INTO answer VALUES (2602, 651, 1, 'eines Parallelschwingkreises.', ' ');
INSERT INTO answer VALUES (2603, 651, 2, 'einer Induktivität.', ' ');
INSERT INTO answer VALUES (2604, 651, 3, 'einer Kapazität.', ' ');
INSERT INTO answer VALUES (2605, 652, 0, 'einen Parallelschwingkreis.', ' ');
INSERT INTO answer VALUES (2606, 652, 1, 'einen Kondensator.', ' ');
INSERT INTO answer VALUES (2607, 652, 2, 'eine Spule.', ' ');
INSERT INTO answer VALUES (2608, 652, 3, 'einen Serienschwingkreis.', ' ');
INSERT INTO answer VALUES (2609, 653, 0, 'Der Betrag des induktiven Widerstands ist dann gleich dem Betrag des kapazitiven Widerstands.', ' ');
INSERT INTO answer VALUES (2610, 653, 1, 'Der Wert des Verlustwiderstands der Spule ist dann gleich dem Wert des Verlustwiderstands des Kondensators.', ' ');
INSERT INTO answer VALUES (2611, 653, 2, 'Die Größe des elektrischen Feldes in der Spule ist dann gleich der Größe des elektrischen Feldes im Kondensators.', ' ');
INSERT INTO answer VALUES (2612, 653, 3, 'Die Größe des magnetischen Feldes in der Spule ist dann gleich der Größe des magnetischen Feldes im Kondensator.', ' ');
INSERT INTO answer VALUES (2613, 654, 0, '<p><img src=''td204a.jpg''></p>', ' ');
INSERT INTO answer VALUES (2614, 654, 1, '<p><img src=''td204b.jpg''></p>', ' ');
INSERT INTO answer VALUES (2615, 654, 2, '<p><img src=''td204c.jpg''></p>', ' ');
INSERT INTO answer VALUES (2616, 654, 3, '<p><img src=''td204d.jpg''></p>', ' ');
INSERT INTO answer VALUES (2617, 655, 0, 'Ja, die Wicklung des Übertragers dient dann als Schwingkreisinduktivität.', ' ');
INSERT INTO answer VALUES (2618, 655, 1, 'Nein, ein Übertrager kann nur Spannungen und Ströme umsetzen.', ' ');
INSERT INTO answer VALUES (2619, 655, 2, 'Ja, es geht dann die Summe der Induktivitäten beider Wicklungen des Übertragers ein.', ' ');
INSERT INTO answer VALUES (2620, 655, 3, 'Ja, aber zu jeder Wicklung muss ein passend gewählter Kondensator in Reihe geschaltet werden.', ' ');
INSERT INTO answer VALUES (2621, 656, 0, 'Die Resonanzfrequenz wird bei 1. und 2. kleiner und bei 3. größer.', ' ');
INSERT INTO answer VALUES (2622, 656, 1, 'Die Resonanzfrequenz wird in allen drei Fällen kleiner.', ' ');
INSERT INTO answer VALUES (2623, 656, 2, 'Die Resonanzfrequenz wird bei 1. kleiner und bei 2. und 3. größer.', ' ');
INSERT INTO answer VALUES (2624, 656, 3, 'Die Resonanzfrequenz wird bei 1. und 2. größer und bei 3. kleiner.', ' ');
INSERT INTO answer VALUES (2625, 657, 0, '117,973 kHz', ' ');
INSERT INTO answer VALUES (2626, 657, 1, '11,797 kHz', ' ');
INSERT INTO answer VALUES (2627, 657, 2, '1,18 kHz', ' ');
INSERT INTO answer VALUES (2628, 657, 3, '1,17973 MHz', ' ');
INSERT INTO answer VALUES (2629, 658, 0, '159,155 kHz', ' ');
INSERT INTO answer VALUES (2630, 658, 1, '15,9155 kHz', ' ');
INSERT INTO answer VALUES (2631, 658, 2, '1,59155 kHz', ' ');
INSERT INTO answer VALUES (2632, 658, 3, '1591,55 kHz', ' ');
INSERT INTO answer VALUES (2633, 659, 0, '14,5288 MHz', ' ');
INSERT INTO answer VALUES (2634, 659, 1, '145,288 MHz', ' ');
INSERT INTO answer VALUES (2635, 659, 2, '1,45288 MHz', ' ');
INSERT INTO answer VALUES (2636, 659, 3, '145,288 kHz', ' ');
INSERT INTO answer VALUES (2637, 660, 0, '61,033 MHz', ' ');
INSERT INTO answer VALUES (2638, 660, 1, '6,1033 MHz', ' ');
INSERT INTO answer VALUES (2639, 660, 2, '610,33 MHz', ' ');
INSERT INTO answer VALUES (2640, 660, 3, '610,33 kHz', ' ');
INSERT INTO answer VALUES (2641, 661, 0, '1,592 MHz', ' ');
INSERT INTO answer VALUES (2642, 661, 1, '159,155 kHz', ' ');
INSERT INTO answer VALUES (2643, 661, 2, '15,915 MHz', ' ');
INSERT INTO answer VALUES (2644, 661, 3, '15,915 kHz', ' ');
INSERT INTO answer VALUES (2645, 662, 0, 'gleich dem reellen Widerstand R.', ' ');
INSERT INTO answer VALUES (2646, 662, 1, 'unendlich hoch.', ' ');
INSERT INTO answer VALUES (2647, 662, 2, 'gleich dem kapazitiven Widerstand X<sub>C</sub>.', ' ');
INSERT INTO answer VALUES (2648, 662, 3, 'gleich dem induktiven Widerstand X<sub>L</sub>.', ' ');
INSERT INTO answer VALUES (2649, 663, 0, '318 Hz', ' ');
INSERT INTO answer VALUES (2650, 663, 1, '0,32 Hz', ' ');
INSERT INTO answer VALUES (2651, 663, 2, '318 kHz', ' ');
INSERT INTO answer VALUES (2652, 663, 3, '421 Hz', ' ');
INSERT INTO answer VALUES (2653, 664, 0, '10', ' ');
INSERT INTO answer VALUES (2654, 664, 1, '1', ' ');
INSERT INTO answer VALUES (2655, 664, 2, '0,1', ' ');
INSERT INTO answer VALUES (2656, 664, 3, '100', ' ');
INSERT INTO answer VALUES (2657, 665, 0, '5,5', ' ');
INSERT INTO answer VALUES (2658, 665, 1, '54,8', ' ');
INSERT INTO answer VALUES (2659, 665, 2, '18,2', ' ');
INSERT INTO answer VALUES (2660, 665, 3, '0,18', ' ');
INSERT INTO answer VALUES (2661, 666, 0, '15,9 kHz', ' ');
INSERT INTO answer VALUES (2662, 666, 1, '159,1 kHz', ' ');
INSERT INTO answer VALUES (2663, 666, 2, '1,59 kHz', ' ');
INSERT INTO answer VALUES (2664, 666, 3, '159 Hz', ' ');
INSERT INTO answer VALUES (2665, 667, 0, '2,65 MHz', ' ');
INSERT INTO answer VALUES (2666, 667, 1, '26,5 MHz', ' ');
INSERT INTO answer VALUES (2667, 667, 2, '795,8 kHz', ' ');
INSERT INTO answer VALUES (2668, 667, 3, '79,6 kHz', ' ');
INSERT INTO answer VALUES (2669, 668, 0, 'Die Bandbreite ergibt sich aus der Differenz der beiden Frequenzen, bei denen die Spannung auf den 0,7-fachen Wert gegenüber der maximalen Spannung bei der Resonanzfrequenz abgesunken ist.', ' ');
INSERT INTO answer VALUES (2670, 668, 1, 'Die Bandbreite ergibt sich aus der Differenz der beiden Frequenzen, bei denen die Spannung auf den 0,5-fachen Wert gegenüber der maximalen Spannung bei der Resonanzfrequenz abgesunken ist.', ' ');
INSERT INTO answer VALUES (2671, 668, 2, 'Die Bandbreite ergibt sich aus der Multiplikation der Resonanzfrequenz mit dem Faktor 0,5.', ' ');
INSERT INTO answer VALUES (2672, 668, 3, 'Die Bandbreite ergibt sich aus der Multiplikation der Resonanzfrequenz mit dem Faktor 0,7.', ' ');
INSERT INTO answer VALUES (2673, 669, 0, 'Hochpass', ' ');
INSERT INTO answer VALUES (2674, 669, 1, 'Bandpass', ' ');
INSERT INTO answer VALUES (2675, 669, 2, 'Sperrkreis', ' ');
INSERT INTO answer VALUES (2676, 669, 3, 'Tiefpass', ' ');
INSERT INTO answer VALUES (2677, 670, 0, 'Tiefpass', ' ');
INSERT INTO answer VALUES (2678, 670, 1, 'Hochpass', ' ');
INSERT INTO answer VALUES (2679, 670, 2, 'Saugkreis', ' ');
INSERT INTO answer VALUES (2680, 670, 3, 'Sperrkreis', ' ');
INSERT INTO answer VALUES (2681, 671, 0, 'Saugkreis', ' ');
INSERT INTO answer VALUES (2682, 671, 1, 'Hochpass', ' ');
INSERT INTO answer VALUES (2683, 671, 2, 'Sperrkreis', ' ');
INSERT INTO answer VALUES (2684, 671, 3, 'Tiefpass', ' ');
INSERT INTO answer VALUES (2685, 672, 0, 'Sperrkreis', ' ');
INSERT INTO answer VALUES (2686, 672, 1, 'Hochpass', ' ');
INSERT INTO answer VALUES (2687, 672, 2, 'Saugkreis', ' ');
INSERT INTO answer VALUES (2688, 672, 3, 'Tiefpass', ' ');
INSERT INTO answer VALUES (2689, 673, 0, 'Sperrfilter.', ' ');
INSERT INTO answer VALUES (2690, 673, 1, 'Tiefpassfilter.', ' ');
INSERT INTO answer VALUES (2691, 673, 2, 'Hochpassfilter.', ' ');
INSERT INTO answer VALUES (2692, 673, 3, 'Dämpfungsglied.', ' ');
INSERT INTO answer VALUES (2693, 674, 0, 'Es handelt sich um einen Bandpass. Frequenzen oberhalb der oberen Grenzfrequenz und Frequenzen unterhalb der unteren Grenzfrequenz werden bedämpft. Er lässt nur einen bestimmten Frequenzbereich passieren.', ' ');
INSERT INTO answer VALUES (2694, 674, 1, 'Es handelt sich um einen Hochpass. Frequenzen unterhalb der Grenzfrequenz werden bedämpft, oberhalb der Grenzfrequenz durchgelassen.', ' ');
INSERT INTO answer VALUES (2695, 674, 2, 'Es handelt sich um einen Tiefpass. Frequenzen oberhalb der Grenzfrequenz werden bedämpft, unterhalb der Grenzfrequenz durchgelassen.', ' ');
INSERT INTO answer VALUES (2696, 674, 3, 'Es handelt sich um eine Bandsperre. Frequenzen oberhalb der oberen Grenzfrequenz und Frequenzen unterhalb der unteren Grenzfrequenz werden durchgelassen. Sie bedämpft nur einen bestimmten Frequenzbereich.', ' ');
INSERT INTO answer VALUES (2697, 675, 0, 'Hochpassfilter.', ' ');
INSERT INTO answer VALUES (2698, 675, 1, 'Sperrfilter.', ' ');
INSERT INTO answer VALUES (2699, 675, 2, 'Tiefpassfilter.', ' ');
INSERT INTO answer VALUES (2700, 675, 3, 'Notchfilter in Verbindung mit einem Hochpassfilter.', ' ');
INSERT INTO answer VALUES (2701, 676, 0, '<p><img src=''td226a.png''></p>', ' ');
INSERT INTO answer VALUES (2702, 676, 1, '<p><img src=''td226b.png''></p>', ' ');
INSERT INTO answer VALUES (2703, 676, 2, '<p><img src=''td226c.png''></p>', ' ');
INSERT INTO answer VALUES (2704, 676, 3, '<p><img src=''td226d.png''></p>', ' ');
INSERT INTO answer VALUES (2705, 677, 0, 'Keramik- oder Luftkondensatoren verwendet werden.', ' ');
INSERT INTO answer VALUES (2706, 677, 1, 'Aluminium-Elektrolytkondensatoren verwendet werden.', ' ');
INSERT INTO answer VALUES (2707, 677, 2, 'Tantal-Elektrolytkondensatoren verwendet werden.', ' ');
INSERT INTO answer VALUES (2708, 677, 3, 'Polykarbonatkondensatoren verwendet werden.', ' ');
INSERT INTO answer VALUES (2709, 678, 0, 'Die Kopplung, bei der die Resonanzkurve ihre größte Breite hat und dabei am Resonanzmaximum noch völlig eben ist.', ' ');
INSERT INTO answer VALUES (2710, 678, 1, 'Die Kopplung, bei der die Resonanzkurve des Bandfilters ihre größtmögliche Breite hat.', ' ');
INSERT INTO answer VALUES (2711, 678, 2, 'Die Kopplung, bei der die Resonanzkurve des Bandfilters eine Welligkeit von 3 dB (Höcker- zu Sattelspannung) zeigt.', ' ');
INSERT INTO answer VALUES (2712, 678, 3, 'Die Kopplung, bei der die Ausgangspannung des Bandfilters das 0,707-fache der Eingangsspannung erreicht.', ' ');
INSERT INTO answer VALUES (2713, 679, 0, 'Bei der c-Kurve ist die Kopplung loser als bei der a-Kurve.', ' ');
INSERT INTO answer VALUES (2714, 679, 1, 'Bei der b-Kurve ist die Kopplung loser als bei der c-Kurve.', ' ');
INSERT INTO answer VALUES (2715, 679, 2, 'Bei der a-Kurve ist die Kopplung loser als bei der c-Kurve.', ' ');
INSERT INTO answer VALUES (2716, 679, 3, 'Bei der b-Kurve ist die Kopplung loser als bei der d-Kurve.', ' ');
INSERT INTO answer VALUES (2717, 680, 0, 'Die b-Kurve zeigt kritische, die a-Kurve zeigt überkritische Kopplung.', ' ');
INSERT INTO answer VALUES (2718, 680, 1, 'Die a-Kurve zeigt kritische, die b-Kurve zeigt überkritische Kopplung.', ' ');
INSERT INTO answer VALUES (2719, 680, 2, 'Die c-Kurve zeigt kritische, die b-Kurve zeigt überkritische Kopplung.', ' ');
INSERT INTO answer VALUES (2720, 680, 3, 'Die d-Kurve zeigt kritische, die c-Kurve zeigt überkritische Kopplung.', ' ');
INSERT INTO answer VALUES (2721, 681, 0, 'SSB.', ' ');
INSERT INTO answer VALUES (2722, 681, 1, 'AM.', ' ');
INSERT INTO answer VALUES (2723, 681, 2, 'FM.', ' ');
INSERT INTO answer VALUES (2724, 681, 3, 'CW.', ' ');
INSERT INTO answer VALUES (2725, 682, 0, 'AM.', ' ');
INSERT INTO answer VALUES (2726, 682, 1, 'SSB.', ' ');
INSERT INTO answer VALUES (2727, 682, 2, 'FM.', ' ');
INSERT INTO answer VALUES (2728, 682, 3, 'CW.', ' ');
INSERT INTO answer VALUES (2729, 683, 0, 'FM.', ' ');
INSERT INTO answer VALUES (2730, 683, 1, 'SSB.', ' ');
INSERT INTO answer VALUES (2731, 683, 2, 'AM.', ' ');
INSERT INTO answer VALUES (2732, 683, 3, 'CW.', ' ');
INSERT INTO answer VALUES (2733, 684, 0, 'CW.', ' ');
INSERT INTO answer VALUES (2734, 684, 1, 'SSB.', ' ');
INSERT INTO answer VALUES (2735, 684, 2, 'AM.', ' ');
INSERT INTO answer VALUES (2736, 684, 3, 'FM.', ' ');
INSERT INTO answer VALUES (2737, 685, 0, '<p><img src=''td301a.png''></p>', ' ');
INSERT INTO answer VALUES (2738, 685, 1, '<p><img src=''td301b.png''></p>', ' ');
INSERT INTO answer VALUES (2739, 685, 2, '<p><img src=''td301c.png''></p>', ' ');
INSERT INTO answer VALUES (2740, 685, 3, '<p><img src=''td301d.png''></p>', ' ');
INSERT INTO answer VALUES (2741, 686, 0, '<p><img src=''td302a.png''></p>', ' ');
INSERT INTO answer VALUES (2742, 686, 1, '<p><img src=''td302b.png''></p>', ' ');
INSERT INTO answer VALUES (2743, 686, 2, '<p><img src=''td302c.png''></p>', ' ');
INSERT INTO answer VALUES (2744, 686, 3, '<p><img src=''td302d.png''></p>', ' ');
INSERT INTO answer VALUES (2745, 687, 0, 'Ja, wenn der Pluspol des Elektrolytkondensators auf der Seite der Diode liegt.', ' ');
INSERT INTO answer VALUES (2746, 687, 1, 'Ja, wenn der Minuspol des Elektrolytkondensators auf der Seite der Diode liegt.', ' ');
INSERT INTO answer VALUES (2747, 687, 2, 'Nein, da der Kondensator von Wechselstrom durchflossen wird.', ' ');
INSERT INTO answer VALUES (2748, 687, 3, 'Nein, da dies auf Grund der technischen Vorschriften nicht zulässig ist.', ' ');
INSERT INTO answer VALUES (2749, 688, 0, 'der Einbau eines Netzfilters erforderlich.', ' ');
INSERT INTO answer VALUES (2750, 688, 1, 'der Austausch des Netzteils erforderlich.', ' ');
INSERT INTO answer VALUES (2751, 688, 2, 'die Entfernung der Erdung und Neuverlegung des Netzanschlusskabels erforderlich.', ' ');
INSERT INTO answer VALUES (2752, 688, 3, 'die Benachrichtigung des zuständigen Stromversorgers erforderlich.', ' ');
INSERT INTO answer VALUES (2753, 689, 0, '40,7 Volt.', ' ');
INSERT INTO answer VALUES (2754, 689, 1, '20,3 Volt.', ' ');
INSERT INTO answer VALUES (2755, 689, 2, '28,8 Volt.', ' ');
INSERT INTO answer VALUES (2756, 689, 3, '57,5 Volt.', ' ');
INSERT INTO answer VALUES (2757, 690, 0, 'Sinkt die Ausgangsspannung, so erhält Transistor T2 über die Z-Diode Z<sub>1</sub> weniger Strom und leitet dadurch weniger. Durch den verminderten Kollektorstrom von T2 verringert sich der Spannungsabfall an R<sub>1</sub>/R<sub>2</sub> und die Basisspannung von T1 steigt und somit auch die Emitterspannung.', ' ');
INSERT INTO answer VALUES (2758, 690, 1, 'Sinkt die Ausgangsspannung bei Belastung, so erhält Transistor T2 über die Z-Diode Z<sub>1</sub> mehr Strom und leitet dadurch stärker. Durch den ansteigenden Kollektorstrom von T2 nimmt der Spannungsabfall an R<sub>1</sub>/R<sub>2</sub> zu. Dabei sinkt die Basisspannung von T1 und die Emitterspannung steigt wieder.', ' ');
INSERT INTO answer VALUES (2759, 690, 2, 'Sinkt die Ausgangsspannung, so fließt durch Transistor T1 weniger Strom. Durch den sich vermindernden Kollektorstrom von T1 steigt aber der Spannungsabfall an R<sub>1</sub>/R<sub>2</sub> und die Basisspannung von T2 über die Z-Diode Z<sub>1</sub>. Somit steigt auch die Emitterspannung von T1.', ' ');
INSERT INTO answer VALUES (2760, 690, 3, 'Sinkt die Ausgangsspannung bei Belastung, so fließt durch den Transistor T1 mehr Belastungsstrom. Der Transistor T2 erhält über Z<sub>1</sub> weniger Spannung und der Spannungsabfall am Spannungsteiler R<sub>1</sub>/R<sub>2</sub> nimmt zu. Dabei sinkt die Basisspannung von T1 und die Emitterspannung steigt wieder.', ' ');
INSERT INTO answer VALUES (2761, 691, 0, 'Parallelgeschalteter Widerstand', ' ');
INSERT INTO answer VALUES (2762, 691, 1, 'In Reihe geschalteter Widerstand', ' ');
INSERT INTO answer VALUES (2763, 691, 2, 'Parallelgeschaltete zweite Diode', ' ');
INSERT INTO answer VALUES (2764, 691, 3, 'Parallelgeschaltete Spule', ' ');
INSERT INTO answer VALUES (2765, 692, 0, 'Zur Spannungsstabilisierung', ' ');
INSERT INTO answer VALUES (2766, 692, 1, 'Zur Signalbegrenzung', ' ');
INSERT INTO answer VALUES (2767, 692, 2, 'Zur Gleichrichtung in Messgeräten', ' ');
INSERT INTO answer VALUES (2768, 692, 3, 'Zur elektronischen Umschaltung', ' ');
INSERT INTO answer VALUES (2769, 693, 0, '<p><img src=''td309a.png''></p>', ' ');
INSERT INTO answer VALUES (2770, 693, 1, '<p><img src=''td309b.png''></p>', ' ');
INSERT INTO answer VALUES (2771, 693, 2, '<p><img src=''td309c.png''></p>', ' ');
INSERT INTO answer VALUES (2772, 693, 3, '<p><img src=''td309d.png''></p>', ' ');
INSERT INTO answer VALUES (2773, 694, 0, 'Die Eingangsspannung muss deutlich größer als die gewünschte Ausgangsspannung sein (ca. 15%), damit die Ausgangsspannung stabil bleibt.', ' ');
INSERT INTO answer VALUES (2774, 694, 1, 'Die Eingangsspannung muss gleich der gewünschten Ausgangsspannung sein, damit eine maximale Stromentnahme am Ausgang erfolgen kann.', ' ');
INSERT INTO answer VALUES (2775, 694, 2, 'Die Eingangsspannung muss mindestens doppelt so groß wie die gewünschte Ausgangsspannung sein, damit die Restwelligkeit der Eingangsspannung auf ein Minimum gehalten werden kann.', ' ');
INSERT INTO answer VALUES (2776, 694, 3, 'Die Eingangsspannung muss gleich der gewünschten Ausgangsspannung sein, damit eine maximale Unterdrückung der Restwelligkeit der Eingangsspannung am Ausgang eintritt.', ' ');
INSERT INTO answer VALUES (2777, 695, 0, '<p><img src=''td311a.png''></p>', ' ');
INSERT INTO answer VALUES (2778, 695, 1, '<p><img src=''td311b.png''></p>', ' ');
INSERT INTO answer VALUES (2779, 695, 2, '<p><img src=''td311c.png''></p>', ' ');
INSERT INTO answer VALUES (2780, 695, 3, '<p><img src=''td311d.png''></p>', ' ');
INSERT INTO answer VALUES (2781, 696, 0, '5 Volt.', ' ');
INSERT INTO answer VALUES (2782, 696, 1, '11,2 Volt.', ' ');
INSERT INTO answer VALUES (2783, 696, 2, '6,2 Volt.', ' ');
INSERT INTO answer VALUES (2784, 696, 3, '5,6 Volt.', ' ');
INSERT INTO answer VALUES (2785, 697, 0, '143 Volt betragen.', ' ');
INSERT INTO answer VALUES (2786, 697, 1, '72 Volt betragen.', ' ');
INSERT INTO answer VALUES (2787, 697, 2, '90 Volt betragen.', ' ');
INSERT INTO answer VALUES (2788, 697, 3, '51 Volt betragen.', ' ');
INSERT INTO answer VALUES (2789, 698, 0, '90 Volt betragen.', ' ');
INSERT INTO answer VALUES (2790, 698, 1, '143 Volt betragen.', ' ');
INSERT INTO answer VALUES (2791, 698, 2, '63 Volt betragen.', ' ');
INSERT INTO answer VALUES (2792, 698, 3, '32 Volt betragen.', ' ');
INSERT INTO answer VALUES (2793, 699, 0, '<p><img src=''td315a.png''></p>', ' ');
INSERT INTO answer VALUES (2794, 699, 1, '<p><img src=''td315b.png''></p>', ' ');
INSERT INTO answer VALUES (2795, 699, 2, '<p><img src=''td315c.png''></p>', ' ');
INSERT INTO answer VALUES (2796, 699, 3, '<p><img src=''td315d.png''></p>', ' ');
INSERT INTO answer VALUES (2797, 700, 0, 'eine genügende HF-Filterung vorzusehen.', ' ');
INSERT INTO answer VALUES (2798, 700, 1, 'eine separate Erdung vorzusehen.', ' ');
INSERT INTO answer VALUES (2799, 700, 2, 'eine zusätzliche Schmelzsicherung vorzusehen.', ' ');
INSERT INTO answer VALUES (2800, 700, 3, 'eine Schutzdiode vorzusehen.', ' ');
INSERT INTO answer VALUES (2801, 701, 0, 'Es ist ein elektronischer Schalter zur Pulsweitensteuerung.', ' ');
INSERT INTO answer VALUES (2802, 701, 1, 'Er soll bei Überspannung den Transformator schützen.', ' ');
INSERT INTO answer VALUES (2803, 701, 2, 'Er wandelt die Wechselspannung in Gleichspannung um.', ' ');
INSERT INTO answer VALUES (2804, 701, 3, 'Er dient als Puls-Gleichrichter in dieser Schaltung.', ' ');
INSERT INTO answer VALUES (2805, 702, 0, 'Ein Schaltnetzteil erzeugt Oberwellen, die zu Störungen führen können.', ' ');
INSERT INTO answer VALUES (2806, 702, 1, 'Ein Schaltnetzteil benötigt einen größeren Transformator.', ' ');
INSERT INTO answer VALUES (2807, 702, 2, 'Ein Schaltnetzteil kann keine so hohen Ströme abgeben.', ' ');
INSERT INTO answer VALUES (2808, 702, 3, 'Ein Schaltnetzteil hat höhere Verluste.', ' ');
INSERT INTO answer VALUES (2809, 703, 0, '8,9 V', ' ');
INSERT INTO answer VALUES (2810, 703, 1, '6 V', ' ');
INSERT INTO answer VALUES (2811, 703, 2, '18 V', ' ');
INSERT INTO answer VALUES (2812, 703, 3, '14,9 V', ' ');
INSERT INTO answer VALUES (2813, 704, 0, '3 VSS, 100 Hz.', ' ');
INSERT INTO answer VALUES (2814, 704, 1, '3 VSS, 50 Hz.', ' ');
INSERT INTO answer VALUES (2815, 704, 2, '13,5 +1,5 V, 50 Hz.', ' ');
INSERT INTO answer VALUES (2816, 704, 3, '13,5 +1,5 V, 100 Hz.', ' ');
INSERT INTO answer VALUES (2817, 705, 0, '100 Hz', ' ');
INSERT INTO answer VALUES (2818, 705, 1, '50 Hz', ' ');
INSERT INTO answer VALUES (2819, 705, 2, '25 Hz', ' ');
INSERT INTO answer VALUES (2820, 705, 3, '200 Hz', ' ');
INSERT INTO answer VALUES (2821, 706, 0, '<p><img src=''td322a.png''></p>', ' ');
INSERT INTO answer VALUES (2822, 706, 1, '<p><img src=''td322b.png''></p>', ' ');
INSERT INTO answer VALUES (2823, 706, 2, '<p><img src=''td322c.png''></p>', ' ');
INSERT INTO answer VALUES (2824, 706, 3, '<p><img src=''td322d.png''></p>', ' ');
INSERT INTO answer VALUES (2825, 707, 0, 'einen Verstärker in Emitterschaltung.', ' ');
INSERT INTO answer VALUES (2826, 707, 1, 'einen Verstärker als Emitterfolger.', ' ');
INSERT INTO answer VALUES (2827, 707, 2, 'einen Verstärker in Kollektorschaltung.', ' ');
INSERT INTO answer VALUES (2828, 707, 3, 'einen Verstärker in Basisschaltung.', ' ');
INSERT INTO answer VALUES (2829, 708, 0, 'Einstellung der Basisvorspannung.', ' ');
INSERT INTO answer VALUES (2830, 708, 1, 'Reduzierung der Eingangsempfindlichkeit.', ' ');
INSERT INTO answer VALUES (2831, 708, 2, 'Verhinderung von Eigenschwingungen.', ' ');
INSERT INTO answer VALUES (2832, 708, 3, 'Festlegung der oberen und unteren Grenzfrequenz.', ' ');
INSERT INTO answer VALUES (2833, 709, 0, 'Überbrückung des Emitterwiderstandes für das Wechselstromsignal.', ' ');
INSERT INTO answer VALUES (2834, 709, 1, 'Verringerung der Verstärkung.', ' ');
INSERT INTO answer VALUES (2835, 709, 2, 'Stabilisierung des Arbeitspunktes des Transistors.', ' ');
INSERT INTO answer VALUES (2836, 709, 3, 'Einstellung der Vorspannung am Emitter.', ' ');
INSERT INTO answer VALUES (2837, 710, 0, 'Sie nimmt ab.', ' ');
INSERT INTO answer VALUES (2838, 710, 1, 'Sie bleibt konstant.', ' ');
INSERT INTO answer VALUES (2839, 710, 2, 'Sie nimmt zu.', ' ');
INSERT INTO answer VALUES (2840, 710, 3, 'Sie fällt auf Null ab.', ' ');
INSERT INTO answer VALUES (2841, 711, 0, 'Wechselstromkopplung.', ' ');
INSERT INTO answer VALUES (2842, 711, 1, 'Festlegung der oberen Grenzfrequenz.', ' ');
INSERT INTO answer VALUES (2843, 711, 2, 'Erzeugung der erforderlichen Phasenverschiebung.', ' ');
INSERT INTO answer VALUES (2844, 711, 3, 'Anhebung niederfrequenter Signalanteile.', ' ');
INSERT INTO answer VALUES (2845, 712, 0, 'v<sub>U</sub> ist groß (z.B. 100 ... 300) und &phi;=180°.', ' ');
INSERT INTO answer VALUES (2846, 712, 1, 'v<sub>U</sub> ist groß (z.B. 100 ... 300) und &phi;=0°.', ' ');
INSERT INTO answer VALUES (2847, 712, 2, 'v<sub>U</sub> ist klein (z.B. 0,9 .... 0,98) und &phi;=180°.', ' ');
INSERT INTO answer VALUES (2848, 712, 3, 'v<sub>U</sub> ist klein (z.B. 0,9 .... 0,98) und &phi;=0°.', ' ');
INSERT INTO answer VALUES (2849, 713, 0, 'r<sub>e</sub> ist klein (z.B. 100 &Omega; ... 5 k&Omega;) und r<sub>a</sub> ist gegenüber r<sub>e</sub> groß (z.B. 5 k&Omega; ... 50 k&Omega;).', ' ');
INSERT INTO answer VALUES (2850, 713, 1, 'r<sub>e</sub> ist groß (z.B. 10 k&Omega; ... 200 k&Omega;) und r<sub>a</sub> ist gegenüber r<sub>e</sub> klein (z.B. 4 &Omega; ... 100 &Omega;).', ' ');
INSERT INTO answer VALUES (2851, 713, 2, 'r<sub>e</sub> und r<sub>a</sub> sind beide relativ klein (z.B. 20 &Omega; ... 5 k&Omega;).', ' ');
INSERT INTO answer VALUES (2852, 713, 3, 'r<sub>e</sub> und r<sub>a</sub> sind beide relativ groß (z.B. 10 k&Omega; ... 200 k&Omega;).', ' ');
INSERT INTO answer VALUES (2853, 714, 0, 'einen Verstärker als Emitterfolger.', ' ');
INSERT INTO answer VALUES (2854, 714, 1, 'einen Verstärker in Emitterschaltung.', ' ');
INSERT INTO answer VALUES (2855, 714, 2, 'einen Oszillator in Kollektorschaltung.', ' ');
INSERT INTO answer VALUES (2856, 714, 3, 'eine Stufe in einer Basisschaltung.', ' ');
INSERT INTO answer VALUES (2857, 715, 0, 'v<sub>U</sub> ist klein (z.B. 0,9 .... 0,98) und &phi;=0°.', ' ');
INSERT INTO answer VALUES (2858, 715, 1, 'v<sub>U</sub> ist groß (z.B. 100 ... 300) und &phi;=0°.', ' ');
INSERT INTO answer VALUES (2859, 715, 2, 'v<sub>U</sub> ist klein (z.B. 0,9 .... 0,98) und &phi;=180°.', ' ');
INSERT INTO answer VALUES (2860, 715, 3, 'v<sub>U</sub> ist groß (z.B. 100 ... 300) und &phi;=180°.', ' ');
INSERT INTO answer VALUES (2861, 716, 0, '10 k&Omega; ... 200 k&Omega;', ' ');
INSERT INTO answer VALUES (2862, 716, 1, '1 k&Omega; ... 10 k&Omega;', ' ');
INSERT INTO answer VALUES (2863, 716, 2, '100 &Omega; ... 1 k&Omega;', ' ');
INSERT INTO answer VALUES (2864, 716, 3, '4 &Omega; ... 100 &Omega;', ' ');
INSERT INTO answer VALUES (2865, 717, 0, '4 &Omega; ... 100 &Omega;', ' ');
INSERT INTO answer VALUES (2866, 717, 1, '10 k&Omega; ... 50 k&Omega;', ' ');
INSERT INTO answer VALUES (2867, 717, 2, '100 k&Omega; ... 200 k&Omega;', ' ');
INSERT INTO answer VALUES (2868, 717, 3, '100 k&Omega; ... 2 M&Omega;', ' ');
INSERT INTO answer VALUES (2869, 718, 0, 'sehr niedrig im Vergleich zur Eingangsimpedanz.', ' ');
INSERT INTO answer VALUES (2870, 718, 1, 'in etwa gleich der Eingangsimpedanz und niederohmig.', ' ');
INSERT INTO answer VALUES (2871, 718, 2, 'sehr hoch im Vergleich zur Eingangsimpedanz.', ' ');
INSERT INTO answer VALUES (2872, 718, 3, 'in etwa gleich der Eingangsimpedanz und hochohmig.', ' ');
INSERT INTO answer VALUES (2873, 719, 0, 'Pufferstufe zwischen Oszillator und Last verwendet werden.', ' ');
INSERT INTO answer VALUES (2874, 719, 1, 'Spannungsverstärker mit hohem Gewinn verwendet werden.', ' ');
INSERT INTO answer VALUES (2875, 719, 2, 'Phasenumkehrstufe verwendet werden.', ' ');
INSERT INTO answer VALUES (2876, 719, 3, 'Frequenzvervielfacher verwendet werden.', ' ');
INSERT INTO answer VALUES (2877, 720, 0, 'Die zweite Harmonische', ' ');
INSERT INTO answer VALUES (2878, 720, 1, 'Die dritte Harmonische', ' ');
INSERT INTO answer VALUES (2879, 720, 2, 'Die vierte Harmonische', ' ');
INSERT INTO answer VALUES (2880, 720, 3, 'Die fünfte Harmonische', ' ');
INSERT INTO answer VALUES (2881, 721, 0, 'Die dritte Harmonische', ' ');
INSERT INTO answer VALUES (2882, 721, 1, 'Die zweite Harmonische', ' ');
INSERT INTO answer VALUES (2883, 721, 2, 'Die vierte Harmonische', ' ');
INSERT INTO answer VALUES (2884, 721, 3, 'Die fünfte Harmonische', ' ');
INSERT INTO answer VALUES (2885, 722, 0, '12 dB', ' ');
INSERT INTO answer VALUES (2886, 722, 1, '3 dB', ' ');
INSERT INTO answer VALUES (2887, 722, 2, '6 dB', ' ');
INSERT INTO answer VALUES (2888, 722, 3, '9 dB', ' ');
INSERT INTO answer VALUES (2889, 723, 0, '11,8 dB.', ' ');
INSERT INTO answer VALUES (2890, 723, 1, '15,2 dB.', ' ');
INSERT INTO answer VALUES (2891, 723, 2, '17,7 dB.', ' ');
INSERT INTO answer VALUES (2892, 723, 3, '23,6 dB.', ' ');
INSERT INTO answer VALUES (2893, 724, 0, '40 W', ' ');
INSERT INTO answer VALUES (2894, 724, 1, '4 W', ' ');
INSERT INTO answer VALUES (2895, 724, 2, '16 W', ' ');
INSERT INTO answer VALUES (2896, 724, 3, '1 W', ' ');
INSERT INTO answer VALUES (2897, 725, 0, 'P<sub>1</sub> entspricht C-Betrieb, P<sub>2</sub> entspricht B-Betrieb, P<sub>3</sub> entspricht AB-Betrieb, P<sub>4</sub> entspricht A-Betrieb.', ' ');
INSERT INTO answer VALUES (2898, 725, 1, 'P<sub>2</sub> entspricht C-Betrieb, P<sub>3</sub> entspricht B-Betrieb, P<sub>4</sub> entspricht A-Betrieb, P<sub>1</sub> ist kein geeigneter Verstärkerarbeitspunkt.', ' ');
INSERT INTO answer VALUES (2899, 725, 2, 'P<sub>2</sub> entspricht A-Betrieb, P<sub>3</sub> entspricht B-Betrieb, P<sub>4</sub> entspricht C-Betrieb, P<sub>1</sub> ist kein geeigneter Verstärkerarbeitspunkt.', ' ');
INSERT INTO answer VALUES (2900, 725, 3, 'P<sub>1</sub> entspricht A-Betrieb, P<sub>2</sub> entspricht AB-Betrieb, P<sub>3</sub> entspricht B-Betrieb, P<sub>4</sub> entspricht C-Betrieb.', ' ');
INSERT INTO answer VALUES (2901, 726, 0, 'Wirkungsgrad ca. 40 %, geringst möglicher Oberwellenanteil, hoher Ruhestrom.', ' ');
INSERT INTO answer VALUES (2902, 726, 1, 'Wirkungsgrad bis zu 70 %, geringer Oberwellenanteil, geringer bis mittlerer Ruhestrom.', ' ');
INSERT INTO answer VALUES (2903, 726, 2, 'Wirkungsgrad bis zu 80 %, geringer Oberwellenanteil, sehr geringer Ruhestrom.', ' ');
INSERT INTO answer VALUES (2904, 726, 3, 'Wirkungsgrad 80 bis 87 %, hoher Oberwellenanteil, der Ruhestrom ist fast null.', ' ');
INSERT INTO answer VALUES (2905, 727, 0, 'Wirkungsgrad bis zu 80 %, geringer Oberwellenanteil, sehr geringer Ruhestrom.', ' ');
INSERT INTO answer VALUES (2906, 727, 1, 'Wirkungsgrad bis zu 70 %, geringer Oberwellenanteil, geringer bis mittlerer Ruhestrom.', ' ');
INSERT INTO answer VALUES (2907, 727, 2, 'Wirkungsgrad ca. 40 %, geringst möglicher Oberwellenanteil, hoher Ruhestrom.', ' ');
INSERT INTO answer VALUES (2908, 727, 3, 'Wirkungsgrad 80 bis 87 %, hoher Oberwellenanteil, der Ruhestrom ist fast null.', ' ');
INSERT INTO answer VALUES (2909, 728, 0, 'Wirkungsgrad 80 bis 87 %, hoher Oberwellenanteil, der Ruhestrom ist fast null.', ' ');
INSERT INTO answer VALUES (2910, 728, 1, 'Wirkungsgrad bis zu 70 %, geringer Oberwellenanteil, geringer bis mittlerer Ruhestrom.', ' ');
INSERT INTO answer VALUES (2911, 728, 2, 'Wirkungsgrad bis zu 80 %, geringer Oberwellenanteil, sehr geringer Ruhestrom.', ' ');
INSERT INTO answer VALUES (2912, 728, 3, 'Wirkungsgrad ca. 40 %, geringst möglicher Oberwellenanteil, hoher Ruhestrom.', ' ');
INSERT INTO answer VALUES (2913, 729, 0, '&asymp; 40 Watt', ' ');
INSERT INTO answer VALUES (2914, 729, 1, '&asymp; 80 Watt', ' ');
INSERT INTO answer VALUES (2915, 729, 2, '&asymp; 60 Watt', ' ');
INSERT INTO answer VALUES (2916, 729, 3, '&asymp; 100 Watt', ' ');
INSERT INTO answer VALUES (2917, 730, 0, '&asymp; 80 Watt', ' ');
INSERT INTO answer VALUES (2918, 730, 1, '&asymp; 100 Watt', ' ');
INSERT INTO answer VALUES (2919, 730, 2, '&asymp; 60 Watt', ' ');
INSERT INTO answer VALUES (2920, 730, 3, '&asymp; 40 Watt', ' ');
INSERT INTO answer VALUES (2921, 731, 0, 'Bei fast null Ampere', ' ');
INSERT INTO answer VALUES (2922, 731, 1, 'Bei etwa 10 bis 20 % des Stromes bei Nennleistung', ' ');
INSERT INTO answer VALUES (2923, 731, 2, 'Bei etwa 70 bis 80 % des Stromes bei Nennleistung', ' ');
INSERT INTO answer VALUES (2924, 731, 3, 'Bei fast 100 % des Stromes bei Nennleistung', ' ');
INSERT INTO answer VALUES (2925, 732, 0, '40 %', ' ');
INSERT INTO answer VALUES (2926, 732, 1, '25 %', ' ');
INSERT INTO answer VALUES (2927, 732, 2, '15 %', ' ');
INSERT INTO answer VALUES (2928, 732, 3, '10 %', ' ');
INSERT INTO answer VALUES (2929, 733, 0, 'Splatter auf benachbarten Frequenzen.', ' ');
INSERT INTO answer VALUES (2930, 733, 1, 'parasitären Schwingungen des Verstärkers.', ' ');
INSERT INTO answer VALUES (2931, 733, 2, 'Übernahmeverzerrungen bei den Transistoren des Verstärkers.', ' ');
INSERT INTO answer VALUES (2932, 733, 3, 'Kreuzmodulation.', ' ');
INSERT INTO answer VALUES (2933, 734, 0, 'Bandpassfilter', ' ');
INSERT INTO answer VALUES (2934, 734, 1, 'Tiefpassfilter', ' ');
INSERT INTO answer VALUES (2935, 734, 2, 'Hochpassfilter', ' ');
INSERT INTO answer VALUES (2936, 734, 3, 'Amplitudenbegrenzer', ' ');
INSERT INTO answer VALUES (2937, 735, 0, 'Kopplung zwischen Ein- und Ausgang', ' ');
INSERT INTO answer VALUES (2938, 735, 1, 'Unzulängliche Verstärkung', ' ');
INSERT INTO answer VALUES (2939, 735, 2, 'Zu hohe Restwelligkeit in der Stromversorgung', ' ');
INSERT INTO answer VALUES (2940, 735, 3, 'Unzulängliche Regelung der Stromversorgung', ' ');
INSERT INTO answer VALUES (2941, 736, 0, 'Breitband-Gegentaktverstärker.', ' ');
INSERT INTO answer VALUES (2942, 736, 1, 'selektiven Hochfrequenzverstärker.', ' ');
INSERT INTO answer VALUES (2943, 736, 2, 'steuerbaren Zwischenfrequenzverstärker.', ' ');
INSERT INTO answer VALUES (2944, 736, 3, 'einstellbaren Frequenzverdoppler.', ' ');
INSERT INTO answer VALUES (2945, 737, 0, '<p><img src=''td431a.png''></p>', ' ');
INSERT INTO answer VALUES (2946, 737, 1, '<p><img src=''td431b.png''></p>', ' ');
INSERT INTO answer VALUES (2947, 737, 2, '<p><img src=''td431c.png''></p>', ' ');
INSERT INTO answer VALUES (2948, 737, 3, '<p><img src=''td431d.png''></p>', ' ');
INSERT INTO answer VALUES (2949, 738, 0, '<p><img src=''td431b.png''></p>', ' ');
INSERT INTO answer VALUES (2950, 738, 1, '<p><img src=''td431a.png''></p>', ' ');
INSERT INTO answer VALUES (2951, 738, 2, '<p><img src=''td431c.png''></p>', ' ');
INSERT INTO answer VALUES (2952, 738, 3, '<p><img src=''td431d.png''></p>', ' ');
INSERT INTO answer VALUES (2953, 739, 0, 'Hüllkurvendemodulator zur Demodulation von AM-Signalen.', ' ');
INSERT INTO answer VALUES (2954, 739, 1, 'SSB-Modulator.', ' ');
INSERT INTO answer VALUES (2955, 739, 2, 'AM-Modulator.', ' ');
INSERT INTO answer VALUES (2956, 739, 3, 'Produktdetektor zu Demodulation von SSB Signalen.', ' ');
INSERT INTO answer VALUES (2957, 740, 0, 'der Ausgang für eine Regelspannung.', ' ');
INSERT INTO answer VALUES (2958, 740, 1, 'der Ausgang für das NF-Signal.', ' ');
INSERT INTO answer VALUES (2959, 740, 2, 'der Ausgang für das Oszillatorsignal.', ' ');
INSERT INTO answer VALUES (2960, 740, 3, 'der Ausgang für das ZF-Signal.', ' ');
INSERT INTO answer VALUES (2961, 741, 0, 'Signal 1', ' ');
INSERT INTO answer VALUES (2962, 741, 1, 'Signal 2', ' ');
INSERT INTO answer VALUES (2963, 741, 2, 'Signal 3', ' ');
INSERT INTO answer VALUES (2964, 741, 3, 'Signal 4', ' ');
INSERT INTO answer VALUES (2965, 742, 0, 'Signal 3', ' ');
INSERT INTO answer VALUES (2966, 742, 1, 'Signal 2', ' ');
INSERT INTO answer VALUES (2967, 742, 2, 'Signal 1', ' ');
INSERT INTO answer VALUES (2968, 742, 3, 'Signal 4', ' ');
INSERT INTO answer VALUES (2969, 743, 0, 'Flanken-Diskriminator zur Demodulation von FM-Signalen.', ' ');
INSERT INTO answer VALUES (2970, 743, 1, 'Produktdetektor zur Demodulation von SSB-Signalen.', ' ');
INSERT INTO answer VALUES (2971, 743, 2, 'Ratiodetektor zur Demodulation von FM-Signalen.', ' ');
INSERT INTO answer VALUES (2972, 743, 3, 'Synchrondemodulator zur Demodulation von AM-Signalen.', ' ');
INSERT INTO answer VALUES (2973, 744, 0, 'Gegentakt-Flanken-Diskriminator zur Demodulation von FM-Signalen.', ' ');
INSERT INTO answer VALUES (2974, 744, 1, 'Ratiodetektor zur Demodulation von FM-Signalen.', ' ');
INSERT INTO answer VALUES (2975, 744, 2, 'Hüllkurvendemodulator zur Demodulation von AM-Signalen.', ' ');
INSERT INTO answer VALUES (2976, 744, 3, 'Produktdetektor zu Demodulation von SSB-Signalen.', ' ');
INSERT INTO answer VALUES (2977, 745, 0, 'Phasendiskriminator zur Demodulation von FM-Signalen.', ' ');
INSERT INTO answer VALUES (2978, 745, 1, 'Flanken-Diskriminator zur Demodulation von FM-Signalen.', ' ');
INSERT INTO answer VALUES (2979, 745, 2, 'Hüllkurvendemodulator zur Demodulation von AM-Signalen.', ' ');
INSERT INTO answer VALUES (2980, 745, 3, 'Produktdetektor zu Demodulation von SSB-Signalen.', ' ');
INSERT INTO answer VALUES (2981, 746, 0, 'Ratiodetektor zur Demodulation von FM-Signalen.', ' ');
INSERT INTO answer VALUES (2982, 746, 1, 'Hüllkurvendemodulator zur Demodulation von AM-Signalen.', ' ');
INSERT INTO answer VALUES (2983, 746, 2, 'Produktdetektor zur Demodulation von SSB-Signalen.', ' ');
INSERT INTO answer VALUES (2984, 746, 3, 'Flanken-Diskriminator zur Demodulation von FM-Signalen.', ' ');
INSERT INTO answer VALUES (2985, 747, 0, 'PLL-FM-Demodulator.', ' ');
INSERT INTO answer VALUES (2986, 747, 1, 'SSB-Demodulator mit PLL-gesteuertem BFO.', ' ');
INSERT INTO answer VALUES (2987, 747, 2, 'ZF-Verstärker.', ' ');
INSERT INTO answer VALUES (2988, 747, 3, 'AM-Modulator.', ' ');
INSERT INTO answer VALUES (2989, 748, 0, 'Begrenzerverstärker mit FM-Diskriminator.', ' ');
INSERT INTO answer VALUES (2990, 748, 1, 'Produktdetektor zu Demodulation von SSB-Signalen.', ' ');
INSERT INTO answer VALUES (2991, 748, 2, 'Modulator zur Erzeugung von SSB-Signalen.', ' ');
INSERT INTO answer VALUES (2992, 748, 3, 'Modulator zur Erzeugung von FM-Signalen.', ' ');
INSERT INTO answer VALUES (2993, 749, 0, 'Produktdetektor zu Demodulation von SSB-Signalen.', ' ');
INSERT INTO answer VALUES (2994, 749, 1, 'Flankendemodulator zur Demodulation von FM-Signalen.', ' ');
INSERT INTO answer VALUES (2995, 749, 2, 'Hüllkurvendemodulator zur Demodulation von AM-Signalen.', ' ');
INSERT INTO answer VALUES (2996, 749, 3, 'Diskriminator zur Demodulation von FM-Signalen.', ' ');
INSERT INTO answer VALUES (2997, 750, 0, 'AM erzeugt.', ' ');
INSERT INTO answer VALUES (2998, 750, 1, 'FM erzeugt.', ' ');
INSERT INTO answer VALUES (2999, 750, 2, 'NBFM erzeugt.', ' ');
INSERT INTO answer VALUES (3000, 750, 3, 'PM erzeugt.', ' ');
INSERT INTO answer VALUES (3001, 751, 0, 'AM-Signalen mit unterdrücktem Träger.', ' ');
INSERT INTO answer VALUES (3002, 751, 1, 'phasenmodulierten Signalen.', ' ');
INSERT INTO answer VALUES (3003, 751, 2, 'frequenzmodulierten Signalen.', ' ');
INSERT INTO answer VALUES (3004, 751, 3, 'AM-Signalen.', ' ');
INSERT INTO answer VALUES (3005, 752, 0, 'frequenzmodulierten Signalen.', ' ');
INSERT INTO answer VALUES (3006, 752, 1, 'phasenmodulierten Signalen.', ' ');
INSERT INTO answer VALUES (3007, 752, 2, 'AM-Signalen mit unterdrücktem Träger.', ' ');
INSERT INTO answer VALUES (3008, 752, 3, 'AM-Signalen.', ' ');
INSERT INTO answer VALUES (3009, 753, 0, 'phasenmodulierten Signalen.', ' ');
INSERT INTO answer VALUES (3010, 753, 1, 'AM-Signalen mit unterdrücktem Träger.', ' ');
INSERT INTO answer VALUES (3011, 753, 2, 'frequenzmodulierten Signalen.', ' ');
INSERT INTO answer VALUES (3012, 753, 3, 'AM-Signalen.', ' ');
INSERT INTO answer VALUES (3013, 754, 0, 'einen kapazitiv rückgekoppelten Dreipunkt-Oszillator.', ' ');
INSERT INTO answer VALUES (3014, 754, 1, 'einen Hochfrequenzverstärker in Basisschaltung.', ' ');
INSERT INTO answer VALUES (3015, 754, 2, 'einen Hochfrequenzverstärker in Emitterschaltung.', ' ');
INSERT INTO answer VALUES (3016, 754, 3, 'einen Oberton-Oszillator in Kollektorschaltung.', ' ');
INSERT INTO answer VALUES (3017, 755, 0, 'einen induktiv rückgekoppelten LC-Oszillator in Emitterschaltung.', ' ');
INSERT INTO answer VALUES (3018, 755, 1, 'einen induktiv rückgekoppelten LC-Oszillator in Basisschaltung.', ' ');
INSERT INTO answer VALUES (3019, 755, 2, 'einen Oberton-Oszillator in Basisschaltung.', ' ');
INSERT INTO answer VALUES (3020, 755, 3, 'einen Oberton-Oszillator in Emitterschaltung.', ' ');
INSERT INTO answer VALUES (3021, 756, 0, 'einen LC-Oszillator in induktiver Dreipunktschaltung.', ' ');
INSERT INTO answer VALUES (3022, 756, 1, 'einen LC-Oszillator in kapazitiver Dreipunktschaltung.', ' ');
INSERT INTO answer VALUES (3023, 756, 2, 'einen Oberton-Oszillator in Kollektorschaltung.', ' ');
INSERT INTO answer VALUES (3024, 756, 3, 'einen Oberton-Oszillator in Emitterschaltung.', ' ');
INSERT INTO answer VALUES (3025, 757, 0, 'Kollektorschaltung, in der der Quarz in seiner Grundschwingung betrieben wird.', ' ');
INSERT INTO answer VALUES (3026, 757, 1, 'Kollektorschaltung, in der der Quarz in der 3. Oberschwingung betrieben wird.', ' ');
INSERT INTO answer VALUES (3027, 757, 2, 'Basisschaltung, in der der Quarz in Parallelresonanz betrieben wird.', ' ');
INSERT INTO answer VALUES (3028, 757, 3, 'Basisschaltung, in der der Quarz in Serienresonanz betrieben wird.', ' ');
INSERT INTO answer VALUES (3029, 758, 0, 'Basisschaltung, in der der Quarz in Serienresonanz betrieben wird.', ' ');
INSERT INTO answer VALUES (3030, 758, 1, 'Basisschaltung, in der der Quarz in Parallelresonanz betrieben wird.', ' ');
INSERT INTO answer VALUES (3031, 758, 2, 'Emitterschaltung, in der der Quarz in Parallelresonanz betrieben wird.', ' ');
INSERT INTO answer VALUES (3032, 758, 3, 'Emitterschaltung, in der der Quarz in Serienresonanz betrieben wird.', ' ');
INSERT INTO answer VALUES (3033, 759, 0, 'Ja, wenn der Schwingkreis für eine der Obertonfrequenzen des Quarzes ausgelegt wird.', ' ');
INSERT INTO answer VALUES (3034, 759, 1, 'Nein, weil die Schaltung keinen Frequenzvervielfacher besitzt.', ' ');
INSERT INTO answer VALUES (3035, 759, 2, 'Nein, weil der Quarz in Oberton-Oszillatoren immer in Parallelresonanz betrieben werden muss.', ' ');
INSERT INTO answer VALUES (3036, 759, 3, 'Nein, Oszillatorschaltungen, die neben dem Quarz noch einen LC-Schwingkreis besitzen, sind als Oberton-Oszillatoren ungeeignet.', ' ');
INSERT INTO answer VALUES (3037, 760, 0, 'Ein VCO ist ein spannungsgesteuerter Oszillator [voltage controlled oscillator]. Die Frequenzvariation erfolgt mittels einer spannungsgesteuerten Kapazitätsvariationsdiode.', ' ');
INSERT INTO answer VALUES (3038, 760, 1, 'Ein VCO ist ein variabler Steueroszillator [variable control oscillator]. Die Frequenzvariation erfolgt mittels eines Drehkondensators.', ' ');
INSERT INTO answer VALUES (3039, 760, 2, 'Ein VCO ist ein von einem Referenzoszillator mitgezogener Oszillator [variable controlled oscillator]. Die Frequenzvariation erfolgt durch Umschaltung der Frequenz des Referenzoszillators.', ' ');
INSERT INTO answer VALUES (3040, 760, 3, 'Ein VCO ist ein variabler Quarzoszillator [variable controlled oscillator]. Die Frequenzvariation erfolgt durch Veränderung (ziehen) der Quarzfrequenz mit Abstimmitteln.', ' ');
INSERT INTO answer VALUES (3041, 761, 0, 'D angelegt werden.', ' ');
INSERT INTO answer VALUES (3042, 761, 1, 'A angelegt werden.', ' ');
INSERT INTO answer VALUES (3043, 761, 2, 'C angelegt werden.', ' ');
INSERT INTO answer VALUES (3044, 761, 3, 'B angelegt werden.', ' ');
INSERT INTO answer VALUES (3045, 762, 0, 'Das an einem Schaltungspunkt betrachtete Oszillatorsignal muss auf dem Signalweg im Oszillator so verstärkt und phasengedreht werden, dass es wieder gleichphasig und mit mindestens der gleichen Amplitude zum selben Punkt zurückgekoppelt wird.', ' ');
INSERT INTO answer VALUES (3046, 762, 1, 'Die Grenzfrequenz des verwendeten Verstärkerelements muss mindestens der Schwingfrequenz des Oszillators entsprechen, und das entstehende Eingangssignal muss über den Rückkopplungsweg wieder gegenphasig zum Eingang zurückgeführt werden.', ' ');
INSERT INTO answer VALUES (3047, 762, 2, 'Die Schleifenverstärkung des Signalwegs im Oszillator muss kleiner als 1 sein, und das entstehende Oszillatorsignal darf auf dem Rückkopplungsweg nicht in der Phase gedreht werden.', ' ');
INSERT INTO answer VALUES (3048, 762, 3, 'Die Schleifenverstärkung des Signalwegs im Oszillator muss größer als 1 sein, und das Ausgangssignal muss über den Rückkopplungsweg in der Phase so gedreht werden, dass es gegenphasig zum Ausgangspunkt zurückgeführt wird.', ' ');
INSERT INTO answer VALUES (3049, 763, 0, 'Oszillatoren.', ' ');
INSERT INTO answer VALUES (3050, 763, 1, 'Verstärker.', ' ');
INSERT INTO answer VALUES (3051, 763, 2, 'FM-Demodulatoren.', ' ');
INSERT INTO answer VALUES (3052, 763, 3, 'Modulatoren.', ' ');
INSERT INTO answer VALUES (3053, 764, 0, 'Frequenzänderungen des Oszillators z.B. durch zu schwach ausgelegte Stromversorgung.', ' ');
INSERT INTO answer VALUES (3054, 764, 1, 'Frequenzänderungen des Oszillators, weil die Tastung auf der falschen Stufe erfolgt.', ' ');
INSERT INTO answer VALUES (3055, 764, 2, 'Phasensprung der Oszillatorfrequenz durch zu steile Flanken des Tastsignals.', ' ');
INSERT INTO answer VALUES (3056, 764, 3, 'Kontaktprellungen am Tastrelais.', ' ');
INSERT INTO answer VALUES (3057, 765, 0, 'Die Frequenz verringert sich.', ' ');
INSERT INTO answer VALUES (3058, 765, 1, 'Die Schwingungen reißen ab (Aussetzer).', ' ');
INSERT INTO answer VALUES (3059, 765, 2, 'Die Frequenz erhöht sich.', ' ');
INSERT INTO answer VALUES (3060, 765, 3, 'Die Frequenz bleibt stabil .', ' ');
INSERT INTO answer VALUES (3061, 766, 0, 'Die Frequenz wird erhöht.', ' ');
INSERT INTO answer VALUES (3062, 766, 1, 'Die Schwingungen reißen ab (Aussetzer).', ' ');
INSERT INTO answer VALUES (3063, 766, 2, 'Die Frequenz wird niedriger.', ' ');
INSERT INTO answer VALUES (3064, 766, 3, 'Die Frequenz bleibt stabil.', ' ');
INSERT INTO answer VALUES (3065, 767, 0, 'Die VFO-Frequenz wandert nach unten.', ' ');
INSERT INTO answer VALUES (3066, 767, 1, 'Die VFO-Frequenz wandert nach oben.', ' ');
INSERT INTO answer VALUES (3067, 767, 2, 'Die VFO-Ausgangsspannung nimmt zu.', ' ');
INSERT INTO answer VALUES (3068, 767, 3, 'Die VFO-Ausgangsspannung nimmt ab.', ' ');
INSERT INTO answer VALUES (3069, 768, 0, 'eine bessere Frequenzstabilität aufweisen.', ' ');
INSERT INTO answer VALUES (3070, 768, 1, 'eine breitere Resonanzkurve haben.', ' ');
INSERT INTO answer VALUES (3071, 768, 2, 'einen geringeren Anteil an Oberwellen erzeugen.', ' ');
INSERT INTO answer VALUES (3072, 768, 3, 'ein sehr viel geringes Seitenbandrauschen erzeugen.', ' ');
INSERT INTO answer VALUES (3073, 769, 0, 'Die Frequenzen an den Punkten A und B sind gleich.', ' ');
INSERT INTO answer VALUES (3074, 769, 1, 'Die Frequenz an Punkt A ist höher als die Frequenz an Punkt B.', ' ');
INSERT INTO answer VALUES (3075, 769, 2, 'Die Frequenzen an den Punkten A und C sind gleich.', ' ');
INSERT INTO answer VALUES (3076, 769, 3, 'Die Frequenz an Punkt B ist höher als die Frequenz an Punkt C.', ' ');
INSERT INTO answer VALUES (3077, 770, 0, 'den Eigenschaften des eingesetzten Quarzgenerators.', ' ');
INSERT INTO answer VALUES (3078, 770, 1, 'der Genauigkeit und Stabilität des verwendeten spannungsgesteuerten Oszillators (VCO).', ' ');
INSERT INTO answer VALUES (3079, 770, 2, 'der Genauigkeit der eingesetzten Frequenzteiler.', ' ');
INSERT INTO answer VALUES (3080, 770, 3, 'den Eigenschaften des eingesetzten Phasenvergleichers.', ' ');
INSERT INTO answer VALUES (3081, 771, 0, 'Bei zu niedriger Grenzfrequenz werden Frequenzabweichungen nicht schnell genug ausgeregelt. Bei zu hoher Grenzfrequenz wird ein Ausgangssignal mit zu vielen Störanteilen erzeugt.', ' ');
INSERT INTO answer VALUES (3082, 771, 1, 'Bei zu hoher Grenzfrequenz werden Frequenzabweichungen nicht schnell genug ausgeregelt. Bei zu niedriger Grenzfrequenz wird ein Ausgangssignal mit zu vielen Störanteilen erzeugt.', ' ');
INSERT INTO answer VALUES (3083, 771, 2, 'Bei zu hoher Grenzfrequenz stellt sich die Ausgangsfrequenz bei einer Frequenzumschaltung zu langsam, bzw. erst nach mehreren Überschwingern richtig ein. Dies tritt z.B. bei unterschiedlicher Sende- und Empfangsfrequenz beim Betrieb über Relais- oder Digipeater auf.', ' ');
INSERT INTO answer VALUES (3084, 771, 3, 'Der Tiefpass in einer PLL kann keinen Einfluss auf das Ausgangssignal ausüben, weil er nur gleichspannungsseitig eingesetzt ist und daher nur auf die Regelspannung wirken kann.', ' ');
INSERT INTO answer VALUES (3085, 772, 0, 'Einen VCO, einen Tiefpass und einen Phasenvergleicher', ' ');
INSERT INTO answer VALUES (3086, 772, 1, 'Einen VCO, einen Hochpass und einen Phasenvergleicher', ' ');
INSERT INTO answer VALUES (3087, 772, 2, 'Einen Phasenvergleicher, einen Tiefpass und einen Frequenzteiler', ' ');
INSERT INTO answer VALUES (3088, 772, 3, 'Einen Phasenvergleicher, einen Hochpass und einen Frequenzteiler', ' ');
INSERT INTO answer VALUES (3089, 773, 0, '100 kHz /V', ' ');
INSERT INTO answer VALUES (3090, 773, 1, '250 kHz/V', ' ');
INSERT INTO answer VALUES (3091, 773, 2, '50 kHz /V', ' ');
INSERT INTO answer VALUES (3092, 773, 3, '1 MHz/V', ' ');
INSERT INTO answer VALUES (3093, 774, 0, '960 bis 1120', ' ');
INSERT INTO answer VALUES (3094, 774, 1, '300 bis 857', ' ');
INSERT INTO answer VALUES (3095, 774, 2, '960 bis 857', ' ');
INSERT INTO answer VALUES (3096, 774, 3, '300 bis 1120', ' ');
INSERT INTO answer VALUES (3097, 775, 0, 'ca. 4,167 kHz', ' ');
INSERT INTO answer VALUES (3098, 775, 1, '25 kHz', ' ');
INSERT INTO answer VALUES (3099, 775, 2, '300 kHz', ' ');
INSERT INTO answer VALUES (3100, 775, 3, '150 kHz', ' ');
INSERT INTO answer VALUES (3101, 776, 0, 'Die Sendeart J3E beansprucht weniger als die halbe Bandbreite der Sendeart A3E.', ' ');
INSERT INTO answer VALUES (3102, 776, 1, 'Die Sendeart J3E beansprucht etwas mehr als die halbe Bandbreite der Sendeart A3E.', ' ');
INSERT INTO answer VALUES (3103, 776, 2, 'Die Sendeart J3E beansprucht etwa ¼ Bandbreite der Sendeart A3E.', ' ');
INSERT INTO answer VALUES (3104, 776, 3, 'Die unterschiedlichen Sendearten lassen keinen Vergleich zu, da sie grundverschieden erzeugt werden.', ' ');
INSERT INTO answer VALUES (3105, 777, 0, 'Durch zu steile Flanken der Tastimpulse', ' ');
INSERT INTO answer VALUES (3106, 777, 1, 'Durch prellende Kontakte der verwendeten Taste', ' ');
INSERT INTO answer VALUES (3107, 777, 2, 'Durch direkte Tastung der Oszillatorstufe', ' ');
INSERT INTO answer VALUES (3108, 777, 3, 'Durch ein unterdimensioniertes Netzteil, dessen Spannung beim Auftasten kurzzeitig zusammenbricht', ' ');
INSERT INTO answer VALUES (3109, 778, 0, '800 Hz', ' ');
INSERT INTO answer VALUES (3110, 778, 1, '200 Hz', ' ');
INSERT INTO answer VALUES (3111, 778, 2, '2,3 kHz', ' ');
INSERT INTO answer VALUES (3112, 778, 3, '455 kHz', ' ');
INSERT INTO answer VALUES (3113, 779, 0, 'werden Informationen auf einen Träger aufgeprägt.', ' ');
INSERT INTO answer VALUES (3114, 779, 1, 'wird einem Träger Informationen entnommen.', ' ');
INSERT INTO answer VALUES (3115, 779, 2, 'werden Sprach- und CW-Signale kombiniert.', ' ');
INSERT INTO answer VALUES (3116, 779, 3, 'werden dem Signal NF-Komponenten entnommen.', ' ');
INSERT INTO answer VALUES (3117, 780, 0, '<p><img src=''te105a.png''></p>', ' ');
INSERT INTO answer VALUES (3118, 780, 1, '<p><img src=''te105b.png''></p>', ' ');
INSERT INTO answer VALUES (3119, 780, 2, '<p><img src=''te105c.png''></p>', ' ');
INSERT INTO answer VALUES (3120, 780, 3, '<p><img src=''te105d.png''></p>', ' ');
INSERT INTO answer VALUES (3121, 781, 0, 'ausgeprägten Splatter-Erscheinungen.', ' ');
INSERT INTO answer VALUES (3122, 781, 1, 'Kreuzmodulation.', ' ');
INSERT INTO answer VALUES (3123, 781, 2, 'verminderten Seitenbändern.', ' ');
INSERT INTO answer VALUES (3124, 781, 3, 'überhöhtem Hub.', ' ');
INSERT INTO answer VALUES (3125, 782, 0, 'Durch Vermischung eines starken unerwünschten Signals mit dem Nutzsignal.', ' ');
INSERT INTO answer VALUES (3126, 782, 1, 'Wenn eine Harmonische sich selbst vermischt.', ' ');
INSERT INTO answer VALUES (3127, 782, 2, 'Durch die Übermodulation eines Verstärkers.', ' ');
INSERT INTO answer VALUES (3128, 782, 3, 'Durch Übermodulation oder zu großem Hub.', ' ');
INSERT INTO answer VALUES (3129, 783, 0, '100 % liegen.', ' ');
INSERT INTO answer VALUES (3130, 783, 1, '50 % liegen.', ' ');
INSERT INTO answer VALUES (3131, 783, 2, '75 % liegen.', ' ');
INSERT INTO answer VALUES (3132, 783, 3, '25 % liegen.', ' ');
INSERT INTO answer VALUES (3133, 784, 0, 'Einseitenbandmodulation (SSB) und Morsetelegrafie (CW).', ' ');
INSERT INTO answer VALUES (3134, 784, 1, 'Frequenzmodulation (FM) und Frequenzumtastung (FSK).', ' ');
INSERT INTO answer VALUES (3135, 784, 2, 'Frequenzumtastung (FSK) und Morsetelegrafie (CW).', ' ');
INSERT INTO answer VALUES (3136, 784, 3, 'Einseitenbandmodulation (SSB) und Frequenzmodulation (FM).', ' ');
INSERT INTO answer VALUES (3137, 785, 0, '<p><img src=''te110a.png''></p>', ' ');
INSERT INTO answer VALUES (3138, 785, 1, '<p><img src=''te110b.png''></p>', ' ');
INSERT INTO answer VALUES (3139, 785, 2, '<p><img src=''te110c.png''></p>', ' ');
INSERT INTO answer VALUES (3140, 785, 3, '<p><img src=''te110d.png''></p>', ' ');
INSERT INTO answer VALUES (3141, 786, 0, '50 %.', ' ');
INSERT INTO answer VALUES (3142, 786, 1, '33 %.', ' ');
INSERT INTO answer VALUES (3143, 786, 2, '67 %.', ' ');
INSERT INTO answer VALUES (3144, 786, 3, '75 %.', ' ');
INSERT INTO answer VALUES (3145, 787, 0, '45 %.', ' ');
INSERT INTO answer VALUES (3146, 787, 1, '55 %.', ' ');
INSERT INTO answer VALUES (3147, 787, 2, '30 %.', ' ');
INSERT INTO answer VALUES (3148, 787, 3, '75 %.', ' ');
INSERT INTO answer VALUES (3149, 788, 0, 'ein typisches Zweiton-SSB-Testsignal.', ' ');
INSERT INTO answer VALUES (3150, 788, 1, 'ein typisches Einton-FM-Testsignal.', ' ');
INSERT INTO answer VALUES (3151, 788, 2, 'ein typisches 100-%-AM-Signal.', ' ');
INSERT INTO answer VALUES (3152, 788, 3, 'ein typisches CW-Signal.', ' ');
INSERT INTO answer VALUES (3153, 789, 0, 'F3E, weil hier die wichtige Information nicht in der Amplitude enthalten ist.', ' ');
INSERT INTO answer VALUES (3154, 789, 1, 'C3F, weil hier die wichtige Information in der Amplitude des Restseitenbandes enthalten ist.', ' ');
INSERT INTO answer VALUES (3155, 789, 2, 'J3E, weil hier die wichtige Information in der Amplitude eines Seitenbandes enthalten ist.', ' ');
INSERT INTO answer VALUES (3156, 789, 3, 'A3E, weil hier die wichtige Information in den Amplituden der beiden Seitenbänder enthalten ist.', ' ');
INSERT INTO answer VALUES (3157, 790, 0, 'f<sub>mod</sub> &gt; &Delta;F. Die Bandbreite wird im wesentlichen durch f<sub>mod</sub> bestimmt; B &asymp; 2 * f<sub>mod</sub>.', ' ');
INSERT INTO answer VALUES (3158, 790, 1, 'f<sub>mod</sub> &lt; &Delta;F. Die Bandbreite wird im wesentlichen durch &Delta;F bestimmt; B &asymp; 2 * &Delta;F.', ' ');
INSERT INTO answer VALUES (3159, 790, 2, 'f<sub>mod</sub> &lt; &Delta;F. Die Bandbreite wird im wesentlichen durch m * &Delta;F bestimmt; B &asymp; m * &Delta;F.', ' ');
INSERT INTO answer VALUES (3160, 790, 3, 'f<sub>mod</sub> &gt; &Delta;F. Die Bandbreite wird im wesentlichen durch m * f<sub>mod</sub> bestimmt; B &asymp; m * f<sub>mod</sub>.', ' ');
INSERT INTO answer VALUES (3161, 791, 0, 'f<sub>mod</sub> &lt; &Delta;F. Die Bandbreite wird im wesentlichen durch &Delta;F bestimmt; B &asymp; 2 * &Delta;F.', ' ');
INSERT INTO answer VALUES (3162, 791, 1, 'f<sub>mod</sub> &gt; &Delta;F. Die Bandbreite wird im wesentlichen durch f<sub>mod</sub> bestimmt; B &asymp; 2 * f<sub>mod</sub>.', ' ');
INSERT INTO answer VALUES (3163, 791, 2, 'f<sub>mod</sub> &gt; &Delta;F. Die Bandbreite wird im wesentlichen durch m * &Delta;F bestimmt; B &asymp; m * &Delta;F.', ' ');
INSERT INTO answer VALUES (3164, 791, 3, 'f<sub>mod</sub> &lt; &Delta;F. Die Bandbreite wird im wesentlichen durch m * f<sub>mod</sub> bestimmt; B &asymp; m * f<sub>mod</sub>.', ' ');
INSERT INTO answer VALUES (3165, 792, 0, 'Durch die Größe der Trägerfrequenzauslenkung.', ' ');
INSERT INTO answer VALUES (3166, 792, 1, 'Durch die Geschwindigkeit der Trägerfrequenzänderung.', ' ');
INSERT INTO answer VALUES (3167, 792, 2, 'Durch die Änderung der Geschwindigkeit des Frequenzhubes.', ' ');
INSERT INTO answer VALUES (3168, 792, 3, 'Durch die Größe der Amplitude des HF-Signals.', ' ');
INSERT INTO answer VALUES (3169, 793, 0, 'einer unendlichen Anzahl von Seitenfrequenzen.', ' ');
INSERT INTO answer VALUES (3170, 793, 1, 'nur zwei Seitenbändern.', ' ');
INSERT INTO answer VALUES (3171, 793, 2, 'keinen Seitenbändern.', ' ');
INSERT INTO answer VALUES (3172, 793, 3, 'nur einem Seitenband.', ' ');
INSERT INTO answer VALUES (3173, 794, 0, 'geringeren Beeinflussung durch Störquellen.', ' ');
INSERT INTO answer VALUES (3174, 794, 1, 'geringen Anforderungen an die Bandbreite.', ' ');
INSERT INTO answer VALUES (3175, 794, 2, 'größeren Entfernungsüberbrückung.', ' ');
INSERT INTO answer VALUES (3176, 794, 3, 'besseren Kreisgüte.', ' ');
INSERT INTO answer VALUES (3177, 795, 0, 'dass die HF-Bandbreite zu groß wird.', ' ');
INSERT INTO answer VALUES (3178, 795, 1, 'dass die Sendeendstufe übersteuert wird.', ' ');
INSERT INTO answer VALUES (3179, 795, 2, 'dass Verzerrungen auf Grund unerwünschter Unterdrückung der Trägerfrequenz auftreten.', ' ');
INSERT INTO answer VALUES (3180, 795, 3, 'dass Verzerrungen auf Grund gegenseitiger Auslöschung der Seitenbänder auftreten.', ' ');
INSERT INTO answer VALUES (3181, 796, 0, 'Frequenzmodulation zu erzeugen.', ' ');
INSERT INTO answer VALUES (3182, 796, 1, 'Zweiseitenbandmodulation zu erzeugen.', ' ');
INSERT INTO answer VALUES (3183, 796, 2, 'CW-Signale zu erzeugen.', ' ');
INSERT INTO answer VALUES (3184, 796, 3, 'Amplitudenmodulation zu erzeugen.', ' ');
INSERT INTO answer VALUES (3185, 797, 0, '0,417 kHz', ' ');
INSERT INTO answer VALUES (3186, 797, 1, '12,083 MHz', ' ');
INSERT INTO answer VALUES (3187, 797, 2, '5 kHz', ' ');
INSERT INTO answer VALUES (3188, 797, 3, '60 kHz', ' ');
INSERT INTO answer VALUES (3189, 798, 0, 'zu Nachbarkanalstörungen.', ' ');
INSERT INTO answer VALUES (3190, 798, 1, 'zur Übersteuerung der Sendeendstufe.', ' ');
INSERT INTO answer VALUES (3191, 798, 2, 'zu Verzerrungen auf Grund unerwünschter Unterdrückung der Trägerfrequenz.', ' ');
INSERT INTO answer VALUES (3192, 798, 3, 'zu Verzerrungen auf Grund gegenseitiger Auslöschung der Seitenbänder.', ' ');
INSERT INTO answer VALUES (3193, 799, 0, 'Eine höhere HF-Bandbreite.', ' ');
INSERT INTO answer VALUES (3194, 799, 1, 'Eine größere Sprachkomprimierung.', ' ');
INSERT INTO answer VALUES (3195, 799, 2, 'Eine stärkere Unterdrückung von FM-Geräuschen.', ' ');
INSERT INTO answer VALUES (3196, 799, 3, 'Eine geringere Störung der Nachbarkanäle.', ' ');
INSERT INTO answer VALUES (3197, 800, 0, 'einer größeren HF-Bandbreite.', ' ');
INSERT INTO answer VALUES (3198, 800, 1, 'einer Erhöhung der Senderausgangsleistung.', ' ');
INSERT INTO answer VALUES (3199, 800, 2, 'einer Erhöhung der Amplitude der Trägerfrequenz.', ' ');
INSERT INTO answer VALUES (3200, 800, 3, 'einer Reduktion der Amplituden der Seitenbänder.', ' ');
INSERT INTO answer VALUES (3201, 801, 0, 'um den Signalrauschabstand am Ausgang zu erhöhen.', ' ');
INSERT INTO answer VALUES (3202, 801, 1, 'um die erforderliche Übertragungsbandbreite zu reduzieren.', ' ');
INSERT INTO answer VALUES (3203, 801, 2, 'um die tiefen Frequenzen anzuheben.', ' ');
INSERT INTO answer VALUES (3204, 801, 3, 'um die hohen Frequenzanteile zu unterdrücken.', ' ');
INSERT INTO answer VALUES (3205, 802, 0, '2,4 kHz', ' ');
INSERT INTO answer VALUES (3206, 802, 1, '1,7 kHz', ' ');
INSERT INTO answer VALUES (3207, 802, 2, '4,8 kHz', ' ');
INSERT INTO answer VALUES (3208, 802, 3, '3,4 kHz', ' ');
INSERT INTO answer VALUES (3209, 803, 0, 'hat seine Trägerfrequenz eine Nullstelle.', ' ');
INSERT INTO answer VALUES (3210, 803, 1, 'nimmt der Trägerpegel um den Faktor 2,4 zu.', ' ');
INSERT INTO answer VALUES (3211, 803, 2, 'verändert sich der Trägerpegel nicht, da es sich um FM handelt.', ' ');
INSERT INTO answer VALUES (3212, 803, 3, 'ist der maximale Hub erreicht.', ' ');
INSERT INTO answer VALUES (3213, 804, 0, 'In kHz/V', ' ');
INSERT INTO answer VALUES (3214, 804, 1, 'Als Modulationsindex', ' ');
INSERT INTO answer VALUES (3215, 804, 2, 'Als Hub', ' ');
INSERT INTO answer VALUES (3216, 804, 3, 'In Rad/s', ' ');
INSERT INTO answer VALUES (3217, 805, 0, '3 kHz.', ' ');
INSERT INTO answer VALUES (3218, 805, 1, '25 kHz.', ' ');
INSERT INTO answer VALUES (3219, 805, 2, '7,5 kHz.', ' ');
INSERT INTO answer VALUES (3220, 805, 3, '500 Hz.', ' ');
INSERT INTO answer VALUES (3221, 806, 0, 'im NF-Bereich zu erzeugen und auf den Mikrofoneingang des Senders zu geben.', ' ');
INSERT INTO answer VALUES (3222, 806, 1, 'mit einem digitalen Modulator zu erzeugen und auf den ZF-Eingang des Senders zu geben.', ' ');
INSERT INTO answer VALUES (3223, 806, 2, 'mit einem digitalen Modulator zu erzeugen und auf den CW-Eingang des Senders zu geben.', ' ');
INSERT INTO answer VALUES (3224, 806, 3, 'im NF-Bereich zu erzeugen und auf den PTT-Eingang des Senders zu geben.', ' ');
INSERT INTO answer VALUES (3225, 807, 0, 'ca. 3 kHz', ' ');
INSERT INTO answer VALUES (3226, 807, 1, 'ca. 6,6 kHz', ' ');
INSERT INTO answer VALUES (3227, 807, 2, '12,5 kHz', ' ');
INSERT INTO answer VALUES (3228, 807, 3, '25 kHz', ' ');
INSERT INTO answer VALUES (3229, 808, 0, '1200 / 2200 Hz', ' ');
INSERT INTO answer VALUES (3230, 808, 1, '500 / 1750 Hz', ' ');
INSERT INTO answer VALUES (3231, 808, 2, '850 / 1200 kHz', ' ');
INSERT INTO answer VALUES (3232, 808, 3, '300 / 2700 Hz', ' ');
INSERT INTO answer VALUES (3233, 809, 0, 'Die Daten werden paketweise gesendet. Der Beginn eines Paketes wird durch ein Synchronisationszeichen eingeleitet. Der Takt wird im Empfänger aus den Daten zurückgewonnen.', ' ');
INSERT INTO answer VALUES (3234, 809, 1, 'Die Daten werden paketweise gesendet. Am Anfang erfolgt ein Startzeichen und am Ende ein Stoppzeichen.', ' ');
INSERT INTO answer VALUES (3235, 809, 2, 'Die Daten werden parallel ausgesendet. Der Takt wird im Empfänger aus den Daten zurückgewonnen.', ' ');
INSERT INTO answer VALUES (3236, 809, 3, 'Die Daten werden seriell ausgesendet. Es ist ein asynchrones Verfahren.', ' ');
INSERT INTO answer VALUES (3237, 810, 0, 'Eine Übertragung wird durch eine Synchronisationssequenz eingeleitet. Nach erfolgreicher Synchronisation werden die Pakete aus dem Binärstrom gelesen.', ' ');
INSERT INTO answer VALUES (3238, 810, 1, 'Sende- und Empfangsstelle werden mit Hilfe der Netzfrequenz in Gleichtakt gebracht.', ' ');
INSERT INTO answer VALUES (3239, 810, 2, 'Sender und Empfänger werden nach jedem einzelnen Zeichen aufeinander synchronisiert. Die Zeichen enthalten Start- und Stoppbit, die zur Synchronisation dienen.', ' ');
INSERT INTO answer VALUES (3240, 810, 3, 'Sender und Empfänger synchronisieren ihre Taktfrequenzen mit einem Normalfrequenzsender.', ' ');
INSERT INTO answer VALUES (3241, 811, 0, '12 kHz', ' ');
INSERT INTO answer VALUES (3242, 811, 1, '25 kHz', ' ');
INSERT INTO answer VALUES (3243, 811, 2, 'ca. 6,6 kHz', ' ');
INSERT INTO answer VALUES (3244, 811, 3, 'ca. 3 kHz', ' ');
INSERT INTO answer VALUES (3245, 812, 0, 'Einen geeigneten Transceiver und ein Terminal oder Computersystem', ' ');
INSERT INTO answer VALUES (3246, 812, 1, 'Eine IBM-MF-kompatible Tastatur und ein Modem', ' ');
INSERT INTO answer VALUES (3247, 812, 2, 'Ein Multifunktionsmikrofon mit DTMF-Tastatur, einen Monitor und ein Modem', ' ');
INSERT INTO answer VALUES (3248, 812, 3, 'Einen Up- /Down-Converter und einen Monitor', ' ');
INSERT INTO answer VALUES (3249, 813, 0, 'TX-Delay', ' ');
INSERT INTO answer VALUES (3250, 813, 1, 'DWAIT', ' ');
INSERT INTO answer VALUES (3251, 813, 2, 'RX-Delay', ' ');
INSERT INTO answer VALUES (3252, 813, 3, 'Frack', ' ');
INSERT INTO answer VALUES (3253, 814, 0, 'vom Einschwingverhalten des Senders und der Zeit bis alle Geräte von Empfang auf Sendung durchgeschaltet haben.', ' ');
INSERT INTO answer VALUES (3254, 814, 1, 'vom Einschwingverhalten des Empfängers der Gegenstation und der Anzahl der Benutzer auf der verwendeten Frequenz.', ' ');
INSERT INTO answer VALUES (3255, 814, 2, 'von dem im Computer verwendeten Prozessortyp und dessen Taktgeschwindigkeit.', ' ');
INSERT INTO answer VALUES (3256, 814, 3, 'von der Zeit bis die Gegenstelle empfangsbereit ist und der Geschwindigkeit des eigenen Computers.', ' ');
INSERT INTO answer VALUES (3257, 815, 0, 'Es muss sende- und empfangsseitig den NF-Frequenzbereich von 20 Hz bis 6 kHz möglichst linear übertragen können. Die Zeit für die Sende-Empfangsumschaltung muss so kurz wie möglich sein, z.B. &lt; 10...100 ms.', ' ');
INSERT INTO answer VALUES (3258, 815, 1, 'Es muss sende- und empfangsseitig den HF-Frequenzbereich von 300 Hz bis 3,4 kHz möglichst linear übertragen können. Die Zeit für die Sende-Empfangsumschaltung muss zwischen 100...300 ms liegen.', ' ');
INSERT INTO answer VALUES (3259, 815, 2, 'Es muss über einen Anschluss für Mikrofon und Lautsprecher verfügen, an dem ein Terminal-Node-Controller (TNC) oder Modem für 9600 Baud angeschlossen werden kann.', ' ');
INSERT INTO answer VALUES (3260, 815, 3, 'Es muss den NF-Frequenzbereich um 9600 Hz linear übertragen können und ein TX-Delay von kleiner 1 ms haben.', ' ');
INSERT INTO answer VALUES (3261, 816, 0, 'Die Zuführung des Sendesignals könnte z.B. direkt am FM-Modulator einer Sende-ZF-Aufbereitung erfolgen. Der Abgriff des Empfangssignals könnte z.B. an einem geeigneten Punkt direkt am Demodulator erfolgen.', ' ');
INSERT INTO answer VALUES (3262, 816, 1, 'Die Zuführung des Sendesignals könnte z.B. am Eingang des Mikrofonverstärkers erfolgen. Der Abgriff des Empfangssignals könnte z.B. unter Verwendung eines zusätzlichen Hochpassfilters direkt am Ausgang des Audioverstärkers erfolgen.', ' ');
INSERT INTO answer VALUES (3263, 816, 2, 'Die Zuführung des Sendesignals könnte z.B. über einen geeigneten Punkt am seriellen Bus des Mikrocontrollers erfolgen. Der Abgriff des Empfangssignals könnte an einem geeigneten Punkt direkt am Demodulator erfolgen.', ' ');
INSERT INTO answer VALUES (3264, 816, 3, 'Die Zuführung des Sendesignals könnte z.B. über einen geeigneten Punkt am Eingang des Ringmodulators erfolgen. Der Abgriff des Empfangssignals könnte z.B. unter Verwendung eines zusätzlichen Hochpassfilters direkt am Ausgang des Audioverstärkers erfolgen.', ' ');
INSERT INTO answer VALUES (3265, 817, 0, 'Anforderungsbezogener Mehrfachzugriff. Die TNC der Teilnehmer werden vom Netzknoten gepollt (angesprochen) und gehen nur nach Aufforderung des Netzknotens auf Sendung.', ' ');
INSERT INTO answer VALUES (3266, 817, 1, 'Automatische Bitratenerkennung. Ein Netzknoten stellt sich automatisch auf die Bitrate des Anwenders ein.', ' ');
INSERT INTO answer VALUES (3267, 817, 2, 'Automatische Speicherbereichszuweisung bei Digipeatern. Nach Verbindungsaufbau wird der Speicher für Store & Forward Betrieb bereitgestellt.', ' ');
INSERT INTO answer VALUES (3268, 817, 3, 'Asynchrone Zusammenführung der Netzzugänge. Die Signale der Teilnehmer und Linkstrecken werden dem Netzknoten asynchron zugeführt.', ' ');
INSERT INTO answer VALUES (3269, 818, 0, '20 kHz', ' ');
INSERT INTO answer VALUES (3270, 818, 1, '12,5 kHz', ' ');
INSERT INTO answer VALUES (3271, 818, 2, 'ca. 6,6 kHz', ' ');
INSERT INTO answer VALUES (3272, 818, 3, 'ca. 3 kHz', ' ');
INSERT INTO answer VALUES (3273, 819, 0, 'ein Rechnersystem bei dem Texte und Daten über Funk eingespeichert und abgerufen werden können.', ' ');
INSERT INTO answer VALUES (3274, 819, 1, 'die Softwaresteuerung einer automatischen Funkstelle.', ' ');
INSERT INTO answer VALUES (3275, 819, 2, 'eine fernbedient oder automatisch arbeitende Funkstelle die Internetnachrichten zwischenspeichert.', ' ');
INSERT INTO answer VALUES (3276, 819, 3, 'eine Zusatzeinrichtung die E-Mails umwandelt und anschließend zwischenspeichert.', ' ');
INSERT INTO answer VALUES (3277, 820, 0, 'besteht aus einem Modem und dem Controller für die digitale Aufbereitung der Daten.', ' ');
INSERT INTO answer VALUES (3278, 820, 1, 'wandelt nur die Töne in digitale Daten und schickt diese an den PC.', ' ');
INSERT INTO answer VALUES (3279, 820, 2, 'wandelt nur die Töne in digitale Daten und schickt diese an den Sender.', ' ');
INSERT INTO answer VALUES (3280, 820, 3, 'ist ein Modem (Modulator und Demodulator) für digitale Signale.', ' ');
INSERT INTO answer VALUES (3281, 821, 0, 'Weil die Gesamtinformation einer Station in Teilinformationen zerlegt wird, die zeitversetzt gesendet werden, dazwischen ist genügend Zeit für andere Stationen.', ' ');
INSERT INTO answer VALUES (3282, 821, 1, 'Weil es sich um digitale Übertragung handelt, die weit weniger störanfällig ist als analoge Übertragung.', ' ');
INSERT INTO answer VALUES (3283, 821, 2, 'Weil in dieser Betriebsart das so genannte "Multitasking" möglich ist.', ' ');
INSERT INTO answer VALUES (3284, 821, 3, 'Weil bei Packet-Radio die dazu benutzten Frequenzen im so genannten "Timesharing" genutzt werden.', ' ');
INSERT INTO answer VALUES (3285, 822, 0, 'Das Zeitintervall zwischen dem Einschalten des Senders und dem Beginn der Datenübertragung.', ' ');
INSERT INTO answer VALUES (3286, 822, 1, 'Die Zeit, bis eine gesendete Nachricht beim Empfänger ankommt.', ' ');
INSERT INTO answer VALUES (3287, 822, 2, 'Die maximale Zeitspanne, die eine Station senden darf.', ' ');
INSERT INTO answer VALUES (3288, 822, 3, 'Die Zeit, die der Funkamateur warten muss, bis er senden darf.', ' ');
INSERT INTO answer VALUES (3289, 823, 0, 'Pactor.', ' ');
INSERT INTO answer VALUES (3290, 823, 1, 'SSTV.', ' ');
INSERT INTO answer VALUES (3291, 823, 2, 'Packet-Radio.', ' ');
INSERT INTO answer VALUES (3292, 823, 3, 'RTTY.', ' ');
INSERT INTO answer VALUES (3293, 824, 0, 'AFSK, das Sendesignal wird über den Mikrofoneingang zugeführt.', ' ');
INSERT INTO answer VALUES (3294, 824, 1, 'AFSK, das Sendesignal wird direkt dem Modulator zugeführt.', ' ');
INSERT INTO answer VALUES (3295, 824, 2, 'FSK, das Sendesignal wird über den Mikrofoneingang zugeführt.', ' ');
INSERT INTO answer VALUES (3296, 824, 3, 'FSK, das Sendesignal wird direkt dem Modulator zugeführt.', ' ');
INSERT INTO answer VALUES (3297, 825, 0, '5-Bit-Code mit zusätzlichen Start- und Stoppbits.', ' ');
INSERT INTO answer VALUES (3298, 825, 1, 'Fernschreibcode, der Fehlerkorrektur verwendet.', ' ');
INSERT INTO answer VALUES (3299, 825, 2, '7-Bit-Code mit Start-, Stopp- und Paritybits.', ' ');
INSERT INTO answer VALUES (3300, 825, 3, 'Fernschreibcode, der "Mark" und "Space" verwendet.', ' ');
INSERT INTO answer VALUES (3301, 826, 0, 'Pactor besitzt eine Fehlerkorrektur, RTTY nicht.', ' ');
INSERT INTO answer VALUES (3302, 826, 1, 'Pactor belegt eine größere Bandbreite als RTTY.', ' ');
INSERT INTO answer VALUES (3303, 826, 2, 'Pactor wird auf UKW, RTTY auf Kurzwelle verwendet.', ' ');
INSERT INTO answer VALUES (3304, 826, 3, 'Pactor ist ein digitales Verfahren, RTTY analog.', ' ');
INSERT INTO answer VALUES (3305, 827, 0, 'einen PC mit Soundkarte und entsprechender Software.', ' ');
INSERT INTO answer VALUES (3306, 827, 1, 'einen Fernschreiber.', ' ');
INSERT INTO answer VALUES (3307, 827, 2, 'einen RTTY-Microcontroller.', ' ');
INSERT INTO answer VALUES (3308, 827, 3, 'eine Zusatzeinrichtung, die RTTY-Signale umwandelt und anschließend zwischenspeichert.', ' ');
INSERT INTO answer VALUES (3309, 828, 0, 'PSK31.', ' ');
INSERT INTO answer VALUES (3310, 828, 1, 'RTTY.', ' ');
INSERT INTO answer VALUES (3311, 828, 2, 'Pactor.', ' ');
INSERT INTO answer VALUES (3312, 828, 3, 'Amtor.', ' ');
INSERT INTO answer VALUES (3313, 829, 0, 'für Texte und Daten.', ' ');
INSERT INTO answer VALUES (3314, 829, 1, 'nur für Texte.', ' ');
INSERT INTO answer VALUES (3315, 829, 2, 'für bewegte Bilder.', ' ');
INSERT INTO answer VALUES (3316, 829, 3, 'für Audio-Streams.', ' ');
INSERT INTO answer VALUES (3317, 830, 0, '31 Hz', ' ');
INSERT INTO answer VALUES (3318, 830, 1, '500 Hz', ' ');
INSERT INTO answer VALUES (3319, 830, 2, '2,4 kHz', ' ');
INSERT INTO answer VALUES (3320, 830, 3, '3,1 kHz', ' ');
INSERT INTO answer VALUES (3321, 831, 0, 'Wasserfalldiagramm', ' ');
INSERT INTO answer VALUES (3322, 831, 1, 'Fourieranalyse', ' ');
INSERT INTO answer VALUES (3323, 831, 2, 'Schmetterlingsdarstellung', ' ');
INSERT INTO answer VALUES (3324, 831, 3, 'Lissajous-Figuren', ' ');
INSERT INTO answer VALUES (3325, 832, 0, 'SSTV überträgt Standbilder, ATV bewegte Bilder.', ' ');
INSERT INTO answer VALUES (3326, 832, 1, 'SSTV wird auf UKW, ATV auf Kurzwelle verwendet.', ' ');
INSERT INTO answer VALUES (3327, 832, 2, 'SSTV belegt eine größere Bandbreite als ATV.', ' ');
INSERT INTO answer VALUES (3328, 832, 3, 'SSTV ist schwarzweiß, ATV in Farbe.', ' ');
INSERT INTO answer VALUES (3329, 833, 0, 'Bei Halbduplex gibt es nur einen Übertragungskanal, aber es kann durch Umschaltung abwechselnd in beide Richtungen gesendet werden.', ' ');
INSERT INTO answer VALUES (3330, 833, 1, 'Bei Duplex gibt es zwei Übertragungskanäle, aber es kann nur durch Umschaltung abwechselnd in beide Richtungen gesendet werden.', ' ');
INSERT INTO answer VALUES (3331, 833, 2, 'Bei Simplex gibt es zwei unabhängige Übertragungskanäle.', ' ');
INSERT INTO answer VALUES (3332, 833, 3, 'Bei Halbduplex kann nur in eine Richtung gesendet werden.', ' ');
INSERT INTO answer VALUES (3333, 834, 0, 'Halbduplex', ' ');
INSERT INTO answer VALUES (3334, 834, 1, 'Simplex', ' ');
INSERT INTO answer VALUES (3335, 834, 2, 'Duplex', ' ');
INSERT INTO answer VALUES (3336, 834, 3, 'Vollduplex', ' ');
INSERT INTO answer VALUES (3337, 835, 0, '32', ' ');
INSERT INTO answer VALUES (3338, 835, 1, '5', ' ');
INSERT INTO answer VALUES (3339, 835, 2, '64', ' ');
INSERT INTO answer VALUES (3340, 835, 3, '128', ' ');
INSERT INTO answer VALUES (3341, 836, 0, 'Mit einer niedrigen zweiten ZF erreicht man leicht eine gute Trennschärfe.', ' ');
INSERT INTO answer VALUES (3342, 836, 1, 'Das von der Antenne aufgenommene Signal bleibt bis zum Demodulator in seiner Frequenz erhalten.', ' ');
INSERT INTO answer VALUES (3343, 836, 2, 'Mit einer hohen ersten ZF erreicht man leicht eine gute Trennschärfe.', ' ');
INSERT INTO answer VALUES (3344, 836, 3, 'Mit einer niedrigen zweiten ZF erreicht man leicht eine gute Spiegelselektion.', ' ');
INSERT INTO answer VALUES (3345, 837, 0, 'Fähigkeit des Empfängers, schwache Signale zu empfangen.', ' ');
INSERT INTO answer VALUES (3346, 837, 1, 'Stabilität des VFO.', ' ');
INSERT INTO answer VALUES (3347, 837, 2, 'Bandbreite des HF-Vorverstärkers.', ' ');
INSERT INTO answer VALUES (3348, 837, 3, 'Fähigkeit des Empfängers, starke Signale zu unterdrücken.', ' ');
INSERT INTO answer VALUES (3349, 838, 0, 'ermöglicht bei großem Abstand zur Empfangsfrequenz eine hohe Spiegelfrequenzunterdrückung.', ' ');
INSERT INTO answer VALUES (3350, 838, 1, 'trägt dazu bei, mögliche Beeinflussungen des lokalen Oszillators durch Empfangssignale zu reduzieren.', ' ');
INSERT INTO answer VALUES (3351, 838, 2, 'sollte möglichst nahe an der Empfangsfrequenz liegen, um eine gute Spiegelfrequenzunterdrückung zu erreichen.', ' ');
INSERT INTO answer VALUES (3352, 838, 3, 'verhindert auf Grund ihrer Höhe, dass durch die Umsetzung auf die zweite Zwischenfrequenz Spiegelfrequenzen auftreten.', ' ');
INSERT INTO answer VALUES (3353, 839, 0, 'Die 1. ZF liegt höher als das Doppelte der maximalen Empfangsfrequenz. Nach der Filterung im Roofing-Filter (1. ZF) wird auf die 2. ZF im Bereich um 9 bis 10 MHz heruntergemischt.', ' ');
INSERT INTO answer VALUES (3354, 839, 1, 'Die Empfangsfrequenz wird direkt in die NF-Lage heruntergemischt (Direktmischung). Dabei können keine Spiegelfrequenzen auftreten.', ' ');
INSERT INTO answer VALUES (3355, 839, 2, 'Die 1. ZF liegt unter der niedrigsten Empfangsfrequenz. Ein Mitlauffilter unterdrückt Spiegelfrequenzen und andere Störfrequenzen.', ' ');
INSERT INTO answer VALUES (3356, 839, 3, 'Die 1. ZF liegt im Bereich um 9 bis 10 MHz. Dabei wird beim Abstimmen in Stufen umgeschaltet.', ' ');
INSERT INTO answer VALUES (3357, 840, 0, 'Im Filter bei der letzten ZF', ' ');
INSERT INTO answer VALUES (3358, 840, 1, 'Im Filter bei der ersten ZF', ' ');
INSERT INTO answer VALUES (3359, 840, 2, 'Durch den gegenseitigen Versatz von 2 Filtern bei der zweiten ZF', ' ');
INSERT INTO answer VALUES (3360, 840, 3, 'Im NF-Verstärker', ' ');
INSERT INTO answer VALUES (3361, 841, 0, 'Mindestens so groß wie die größte benötigte Bandbreite der vorgesehenen Betriebsarten.', ' ');
INSERT INTO answer VALUES (3362, 841, 1, 'Mindestens so groß wie die doppelte Bandbreite der jeweiligen Betriebsart.', ' ');
INSERT INTO answer VALUES (3363, 841, 2, 'Mindestens so groß wie das breiteste zu empfangende Amateurband.', ' ');
INSERT INTO answer VALUES (3364, 841, 3, 'Sie muss den vollen Abstimmbereich des Empfängers umfassen..', ' ');
INSERT INTO answer VALUES (3365, 842, 0, 'Mit einem quarzgesteuerten Frequenzmarken-Generator', ' ');
INSERT INTO answer VALUES (3366, 842, 1, 'Mit einem LC-Oszillator (Dipmeter)', ' ');
INSERT INTO answer VALUES (3367, 842, 2, 'Mit den Oberschwingungen eines 50-Hz-Gleichrichters', ' ');
INSERT INTO answer VALUES (3368, 842, 3, 'Mit einem RC-Oszillator', ' ');
INSERT INTO answer VALUES (3369, 843, 0, '124,2 MHz auftreten.', ' ');
INSERT INTO answer VALUES (3370, 843, 1, '134,9 MHz auftreten.', ' ');
INSERT INTO answer VALUES (3371, 843, 2, '280,5 MHz auftreten.', ' ');
INSERT INTO answer VALUES (3372, 843, 3, '156,3 MHz auftreten.', ' ');
INSERT INTO answer VALUES (3373, 844, 0, '49,7 MHz auftreten.', ' ');
INSERT INTO answer VALUES (3374, 844, 1, '39 MHz auftreten.', ' ');
INSERT INTO answer VALUES (3375, 844, 2, '67,3 MHz auftreten.', ' ');
INSERT INTO answer VALUES (3376, 844, 3, '17,6 MHz auftreten.', ' ');
INSERT INTO answer VALUES (3377, 845, 0, 'X und Y sind Mischer, Z ist ein Produktdetektor', ' ');
INSERT INTO answer VALUES (3378, 845, 1, 'X ist ein Mischer, Y ist ein Produktdetektor, Z ist ein Mischer', ' ');
INSERT INTO answer VALUES (3379, 845, 2, 'X und Y sind Produktdetektoren, Z ist ein HF-Mischer', ' ');
INSERT INTO answer VALUES (3380, 845, 3, 'X und Y sind Balancemischer, Z ist ein ZF-Verstärker', ' ');
INSERT INTO answer VALUES (3381, 846, 0, 'X ist ein VFO, Y ist ein CO und Z ein BFO', ' ');
INSERT INTO answer VALUES (3382, 846, 1, 'X ist ein VFO, Y ist ein BFO und Z ein CO', ' ');
INSERT INTO answer VALUES (3383, 846, 2, 'X ist ein BFO, Y ist ein CO und Z ein VFO', ' ');
INSERT INTO answer VALUES (3384, 846, 3, 'X ist ein BFO, Y ist ein VFO und Z ein CO', ' ');
INSERT INTO answer VALUES (3385, 847, 0, 'Der VFO muss bei 38,70 MHz und der CO bei 11,16 MHz schwingen.', ' ');
INSERT INTO answer VALUES (3386, 847, 1, 'Der VFO muss bei 10,24 MHz und der CO bei 17,30 MHz schwingen.', ' ');
INSERT INTO answer VALUES (3387, 847, 2, 'Der VFO muss bei 38,70 MHz und der CO bei 12,24 MHz schwingen.', ' ');
INSERT INTO answer VALUES (3388, 847, 3, 'Der VFO muss bei 28,46 MHz und der CO bei 11,16 MHz schwingen.', ' ');
INSERT INTO answer VALUES (3389, 848, 0, '45,333 und 45,556 MHz', ' ');
INSERT INTO answer VALUES (3390, 848, 1, '45,556 und 45,778 MHz', ' ');
INSERT INTO answer VALUES (3391, 848, 2, '45,111 und 45,333 MHz', ' ');
INSERT INTO answer VALUES (3392, 848, 3, '44,889 und 45,111 MHz', ' ');
INSERT INTO answer VALUES (3393, 849, 0, '44,667 und 44,889 MHz', ' ');
INSERT INTO answer VALUES (3394, 849, 1, '44,444 und 44,667 MHz', ' ');
INSERT INTO answer VALUES (3395, 849, 2, '44,889 und 45,111 MHz', ' ');
INSERT INTO answer VALUES (3396, 849, 3, '45,111 und 45,333 MHz', ' ');
INSERT INTO answer VALUES (3397, 850, 0, 'einen 2-m-Konverter für einen KW-Empfänger dar.', ' ');
INSERT INTO answer VALUES (3398, 850, 1, 'Teile von Empfangsstufen eines 10-m-Band-Empfängers dar.', ' ');
INSERT INTO answer VALUES (3399, 850, 2, 'einen 2-m-Transverter zur Vorschaltung vor einen KW-Empfänger dar.', ' ');
INSERT INTO answer VALUES (3400, 850, 3, 'Teile der Senderaufbereitung für das 10-m-Band dar.', ' ');
INSERT INTO answer VALUES (3401, 851, 0, 'Die Spiegelfrequenz liegt sehr weit außerhalb des Empfangsbereichs.', ' ');
INSERT INTO answer VALUES (3402, 851, 1, 'Filter für 50 MHz haben eine höhere Trennschärfe.', ' ');
INSERT INTO answer VALUES (3403, 851, 2, 'Ein solcher Empfänger hat eine höhere Großsignalfestigkeit.', ' ');
INSERT INTO answer VALUES (3404, 851, 3, 'Man erhält einen Empfänger für Kurzwelle und gleichzeitig für Ultrakurzwelle.', ' ');
INSERT INTO answer VALUES (3405, 852, 0, '20 bis 47 MHz oder 53…80 MHz', ' ');
INSERT INTO answer VALUES (3406, 852, 1, '20 bis 47 MHz oder 47…74 MHz', ' ');
INSERT INTO answer VALUES (3407, 852, 2, '23 bis 41 MHz oder 53…80 MHz', ' ');
INSERT INTO answer VALUES (3408, 852, 3, '23 bis 41 MHz oder 47…74 MHz', ' ');
INSERT INTO answer VALUES (3409, 853, 0, 'VFO: 46,35 MHz; CO1: 41 MHz; CO2: 9,455 MHz', ' ');
INSERT INTO answer VALUES (3410, 853, 1, 'VFO: 23,65 MHz; CO1: 59 MHz; CO2: 8,545 MHz', ' ');
INSERT INTO answer VALUES (3411, 853, 2, 'VFO: 46,35 MHz; CO1: 41 MHz; CO2: 9,545 MHz', ' ');
INSERT INTO answer VALUES (3412, 853, 3, 'VFO: 46,35 MHz; CO1: 51 MHz; CO2: 9,455 MHz', ' ');
INSERT INTO answer VALUES (3413, 854, 0, 'einen Transverter für das 2-m-Band dar.', ' ');
INSERT INTO answer VALUES (3414, 854, 1, 'einen Empfangskonverter für das 2-m-Band dar.', ' ');
INSERT INTO answer VALUES (3415, 854, 2, 'einen Vorverstärker für das 10-m-Band dar.', ' ');
INSERT INTO answer VALUES (3416, 854, 3, 'einen Transceiver für das 10-m-Band dar.', ' ');
INSERT INTO answer VALUES (3417, 855, 0, 'VCO<sub>1</sub>: 67,5 MHz VCO<sub>2</sub>: 85,5 MHz', ' ');
INSERT INTO answer VALUES (3418, 855, 1, 'VCO<sub>1</sub>: 68,5 MHz VCO<sub>2</sub>: 85,5 MHz', ' ');
INSERT INTO answer VALUES (3419, 855, 2, 'VCO<sub>1</sub>: 85,5 MHz VCO<sub>2</sub>: 67,5 MHz', ' ');
INSERT INTO answer VALUES (3420, 855, 3, 'VCO<sub>1</sub>: 67,5 MHz VCO<sub>2</sub>: 87,5 MHz', ' ');
INSERT INTO answer VALUES (3421, 856, 0, 'Möglichst direkt an der VHF-Antenne', ' ');
INSERT INTO answer VALUES (3422, 856, 1, 'Möglichst unmittelbar vor dem Empfängereingang', ' ');
INSERT INTO answer VALUES (3423, 856, 2, 'Zwischen Senderausgang und Antennenkabel', ' ');
INSERT INTO answer VALUES (3424, 856, 3, 'Zwischen Stehwellenmessgerät und Empfängereingang', ' ');
INSERT INTO answer VALUES (3425, 857, 0, 'in nächster Nähe zur Empfangsfrequenz.', ' ');
INSERT INTO answer VALUES (3426, 857, 1, 'sehr weit über der Empfangsfrequenz.', ' ');
INSERT INTO answer VALUES (3427, 857, 2, 'sehr viel tiefer als die Empfangsfrequenz.', ' ');
INSERT INTO answer VALUES (3428, 857, 3, 'bei 9 MHz.', ' ');
INSERT INTO answer VALUES (3429, 858, 0, 'Es sind die ZF- oder NF-Signale.', ' ');
INSERT INTO answer VALUES (3430, 858, 1, 'Es ist das HF-Signal der Eingangsstufe.', ' ');
INSERT INTO answer VALUES (3431, 858, 2, 'Es ist das HF-Signal des VFO.', ' ');
INSERT INTO answer VALUES (3432, 858, 3, 'Es ist das ZF-Signal des BFO.', ' ');
INSERT INTO answer VALUES (3433, 859, 0, 'Verstärkung der HF-und ZF-Stufen.', ' ');
INSERT INTO answer VALUES (3434, 859, 1, 'Amplitude des VFO.', ' ');
INSERT INTO answer VALUES (3435, 859, 2, 'Amplitude des BFO.', ' ');
INSERT INTO answer VALUES (3436, 859, 3, 'Höhe der Versorgungsspannungen.', ' ');
INSERT INTO answer VALUES (3437, 860, 0, '9 MHz und 69 MHz', ' ');
INSERT INTO answer VALUES (3438, 860, 1, '9 MHz und 39 MHz', ' ');
INSERT INTO answer VALUES (3439, 860, 2, '30 MHz und 39 MHz', ' ');
INSERT INTO answer VALUES (3440, 860, 3, '39 MHz und 69 MHz', ' ');
INSERT INTO answer VALUES (3441, 861, 0, 'Balancemischer.', ' ');
INSERT INTO answer VALUES (3442, 861, 1, 'Mischer mit einem einzelnen FET.', ' ');
INSERT INTO answer VALUES (3443, 861, 2, 'Mischer mit einer Varaktordiode.', ' ');
INSERT INTO answer VALUES (3444, 861, 3, 'quarzgesteuerter Mischer.', ' ');
INSERT INTO answer VALUES (3445, 862, 0, '9 MHz und 281 MHz', ' ');
INSERT INTO answer VALUES (3446, 862, 1, '127 MHz und 154 MHz', ' ');
INSERT INTO answer VALUES (3447, 862, 2, '272 MHz und 290 MHz', ' ');
INSERT INTO answer VALUES (3448, 862, 3, '140,5 MHz und 281 MHz', ' ');
INSERT INTO answer VALUES (3449, 863, 0, '1. Oszillatorfrequenz: f<sub>o1</sub> = 38,7 MHz<br> 2. Oszillatorfrequenz: f<sub>o2</sub> = 11,15 MHz', ' ');
INSERT INTO answer VALUES (3450, 863, 1, '1. Oszillatorfrequenz: f<sub>o1</sub> = 38,7 MHz<br> 2. Oszillatorfrequenz: f<sub>o2</sub> = 39,15 MHz', ' ');
INSERT INTO answer VALUES (3451, 863, 2, '1. Oszillatorfrequenz: f<sub>o1</sub> = 11,15 MHz<br> 2. Oszillatorfrequenz: f<sub>o2</sub> = 38,7 MHz', ' ');
INSERT INTO answer VALUES (3452, 863, 3, '1. Oszillatorfrequenz: f<sub>o1</sub> = 28,45 MHz<br> 2. Oszillatorfrequenz: f<sub>o2</sub> = 17,75 MHz', ' ');
INSERT INTO answer VALUES (3453, 864, 0, 'J3E : 2,2 kHz, F1B : 500 Hz, F3E : 12 kHz', ' ');
INSERT INTO answer VALUES (3454, 864, 1, 'J3E : 6 kHz, F1B : 1,5 kHz, F3E : 12 kHz', ' ');
INSERT INTO answer VALUES (3455, 864, 2, 'J3E : 2,2 kHz, F1B : 500 Hz, F3E : 3,6 kHz', ' ');
INSERT INTO answer VALUES (3456, 864, 3, 'J3E : 3,6 kHz, F1B : 170 Hz, F3E : 120 kHz', ' ');
INSERT INTO answer VALUES (3457, 865, 0, 'Um eine S-Stufe', ' ');
INSERT INTO answer VALUES (3458, 865, 1, 'Um zwei S-Stufen', ' ');
INSERT INTO answer VALUES (3459, 865, 2, 'Um vier S-Stufen', ' ');
INSERT INTO answer VALUES (3460, 865, 3, 'Um acht S-Stufen.', ' ');
INSERT INTO answer VALUES (3461, 866, 0, 'Sie erzeugen zusammen die notwendige Rückkopplungsspannung für einen LC-Oszillator.', ' ');
INSERT INTO answer VALUES (3462, 866, 1, 'Sie erzeugen zusammen die notwendige Rückkopplungsspannung für eine Audionschaltung.', ' ');
INSERT INTO answer VALUES (3463, 866, 2, 'C<sub>3</sub> stabilisiert die Basisvorspannung und C<sub>4</sub> die Emittervorspannung.', ' ');
INSERT INTO answer VALUES (3464, 866, 3, 'C<sub>3</sub> kompensiert die Basis-Kollektor-Kapazität und C<sub>4</sub> die Basis-Emitter-Kapazität', ' ');
INSERT INTO answer VALUES (3465, 867, 0, 'Sie sorgt für eine stabile Versorgungsspannung, damit die Oszillatorfrequenz stabil bleibt.', ' ');
INSERT INTO answer VALUES (3466, 867, 1, 'Sie zeigt das korrekte Einschwingen des Oszillators an.', ' ');
INSERT INTO answer VALUES (3467, 867, 2, 'Sie sorgt für eine konstante Ausgangsamplitude des Oszillators über den gesamten Abstimmbereich von C1.', ' ');
INSERT INTO answer VALUES (3468, 867, 3, 'Sie ermöglicht eine Frequenzmodulation des Oszillators.', ' ');
INSERT INTO answer VALUES (3469, 868, 0, 'gut gefiltert und entkoppelt werden.', ' ');
INSERT INTO answer VALUES (3470, 868, 1, 'möglichst spannungsfest angekoppelt werden.', ' ');
INSERT INTO answer VALUES (3471, 868, 2, 'möglichst temperaturabhängig sein.', ' ');
INSERT INTO answer VALUES (3472, 868, 3, 'im HF-Bereich nicht gefiltert werden.', ' ');
INSERT INTO answer VALUES (3473, 869, 0, 'zur Einstellung der Trägerunterdrückung nach Betrag und Phase.', ' ');
INSERT INTO answer VALUES (3474, 869, 1, 'zum Ausgleich von Frequenzgang- und Laufzeitunterschieden.', ' ');
INSERT INTO answer VALUES (3475, 869, 2, 'zur Einstellung des Frequenzhubes mit Hilfe der ersten Trägernullstelle.', ' ');
INSERT INTO answer VALUES (3476, 869, 3, 'zur Einstellung des Modulationsgrades der erzeugten AM-Signale.', ' ');
INSERT INTO answer VALUES (3477, 870, 0, 'Schaltungspunkt D', ' ');
INSERT INTO answer VALUES (3478, 870, 1, 'Schaltungspunkt A', ' ');
INSERT INTO answer VALUES (3479, 870, 2, 'Schaltungspunkt B', ' ');
INSERT INTO answer VALUES (3480, 870, 3, 'Schaltungspunkt C', ' ');
INSERT INTO answer VALUES (3481, 871, 0, 'NF-Verstärker', ' ');
INSERT INTO answer VALUES (3482, 871, 1, 'Mikrofonverstärker', ' ');
INSERT INTO answer VALUES (3483, 871, 2, 'HF-Verstärker', ' ');
INSERT INTO answer VALUES (3484, 871, 3, 'Tongenerator', ' ');
INSERT INTO answer VALUES (3485, 872, 0, 'Zur Widerstandsanpassung', ' ');
INSERT INTO answer VALUES (3486, 872, 1, 'Zur Spannungsverstärkung', ' ');
INSERT INTO answer VALUES (3487, 872, 2, 'Zur Leistungsverstärkung', ' ');
INSERT INTO answer VALUES (3488, 872, 3, 'Zur Verstärkungssteuerung', ' ');
INSERT INTO answer VALUES (3489, 873, 0, 'AM-Detektor.', ' ');
INSERT INTO answer VALUES (3490, 873, 1, 'FM-Diskriminator.', ' ');
INSERT INTO answer VALUES (3491, 873, 2, 'ZF-Modulator.', ' ');
INSERT INTO answer VALUES (3492, 873, 3, 'AGC-Gleichrichter.', ' ');
INSERT INTO answer VALUES (3493, 874, 0, 'die zwei Seitenbänder.', ' ');
INSERT INTO answer VALUES (3494, 874, 1, 'viele Mischprodukte.', ' ');
INSERT INTO answer VALUES (3495, 874, 2, 'einen verringerten Träger plus Seitenbänder.', ' ');
INSERT INTO answer VALUES (3496, 874, 3, 'den vollständigen Träger.', ' ');
INSERT INTO answer VALUES (3497, 875, 0, '<p><img src=''tf319a.png''></p>', ' ');
INSERT INTO answer VALUES (3498, 875, 1, '<p><img src=''tf319b.png''></p>', ' ');
INSERT INTO answer VALUES (3499, 875, 2, '<p><img src=''tf319c.png''></p>', ' ');
INSERT INTO answer VALUES (3500, 875, 3, '<p><img src=''tf319d.png''></p>', ' ');
INSERT INTO answer VALUES (3501, 876, 0, 'Notchfilter', ' ');
INSERT INTO answer VALUES (3502, 876, 1, 'Dämpfungsglied', ' ');
INSERT INTO answer VALUES (3503, 876, 2, 'Hochpass', ' ');
INSERT INTO answer VALUES (3504, 876, 3, 'Sperrfilter', ' ');
INSERT INTO answer VALUES (3505, 877, 0, '0°.', ' ');
INSERT INTO answer VALUES (3506, 877, 1, '90°.', ' ');
INSERT INTO answer VALUES (3507, 877, 2, '180°.', ' ');
INSERT INTO answer VALUES (3508, 877, 3, '270°.', ' ');
INSERT INTO answer VALUES (3509, 878, 0, '0°.', ' ');
INSERT INTO answer VALUES (3510, 878, 1, '90°.', ' ');
INSERT INTO answer VALUES (3511, 878, 2, '180°.', ' ');
INSERT INTO answer VALUES (3512, 878, 3, '270°.', ' ');
INSERT INTO answer VALUES (3513, 879, 0, '180°.', ' ');
INSERT INTO answer VALUES (3514, 879, 1, '90°.', ' ');
INSERT INTO answer VALUES (3515, 879, 2, '0°.', ' ');
INSERT INTO answer VALUES (3516, 879, 3, '270°.', ' ');
INSERT INTO answer VALUES (3517, 880, 0, 'Er nimmt erheblich zu.', ' ');
INSERT INTO answer VALUES (3518, 880, 1, 'Er verringert sich geringfügig.', ' ');
INSERT INTO answer VALUES (3519, 880, 2, 'Er bleibt konstant.', ' ');
INSERT INTO answer VALUES (3520, 880, 3, 'Er nimmt erheblich ab.', ' ');
INSERT INTO answer VALUES (3521, 881, 0, 'Automatische Verstärkungsregelung', ' ');
INSERT INTO answer VALUES (3522, 881, 1, 'Hilfspegelbegrenzung', ' ');
INSERT INTO answer VALUES (3523, 881, 2, 'Automatische Gleichlaufsteuerung', ' ');
INSERT INTO answer VALUES (3524, 881, 3, 'Wechselstromverstärkung', ' ');
INSERT INTO answer VALUES (3525, 882, 0, '<p><img src=''tf326a.png''></p>', ' ');
INSERT INTO answer VALUES (3526, 882, 1, '<p><img src=''tf326b.png''></p>', ' ');
INSERT INTO answer VALUES (3527, 882, 2, '<p><img src=''tf326c.png''></p>', ' ');
INSERT INTO answer VALUES (3528, 882, 3, '<p><img src=''tf326d.png''></p>', ' ');
INSERT INTO answer VALUES (3529, 883, 0, 'Der Transistor hat einen Kurzschluss.', ' ');
INSERT INTO answer VALUES (3530, 883, 1, 'Der Widerstand hat einen Kurzschluss.', ' ');
INSERT INTO answer VALUES (3531, 883, 2, 'Der Transistor ist hochohmig.', ' ');
INSERT INTO answer VALUES (3532, 883, 3, 'Der Abblockkondensator hat nicht mehr die erforderliche Kapazität.', ' ');
INSERT INTO answer VALUES (3533, 884, 0, 'im nichtlinearen Bereich.', ' ');
INSERT INTO answer VALUES (3534, 884, 1, 'im A-Betrieb.', ' ');
INSERT INTO answer VALUES (3535, 884, 2, 'im B-Betrieb.', ' ');
INSERT INTO answer VALUES (3536, 884, 3, 'im linearen Bereich.', ' ');
INSERT INTO answer VALUES (3537, 885, 0, 'der das Ausgangssignal ab einem bestimmten Eingangspegel begrenzt.', ' ');
INSERT INTO answer VALUES (3538, 885, 1, 'der zur Verringerung des Vorstufenrauschens dient.', ' ');
INSERT INTO answer VALUES (3539, 885, 2, 'der zur Begrenzung des Hubes für den FM-Demodulator dient.', ' ');
INSERT INTO answer VALUES (3540, 885, 3, 'der den ZF-Träger unabhängig vom Eingangssignal auf niedrigem Pegel konstant hält.', ' ');
INSERT INTO answer VALUES (3541, 886, 0, 'Wenn der Transistor eine Unterbrechung hat.', ' ');
INSERT INTO answer VALUES (3542, 886, 1, 'Wenn der Abblockkondensator seine Kapazität verloren hat.', ' ');
INSERT INTO answer VALUES (3543, 886, 2, 'Wenn kein Eingangssignal am Empfänger anliegt.', ' ');
INSERT INTO answer VALUES (3544, 886, 3, 'Wenn der Widerstand hochohmig geworden ist.', ' ');
INSERT INTO answer VALUES (3545, 887, 0, '49,9 MHz', ' ');
INSERT INTO answer VALUES (3546, 887, 1, '39,2 MHz', ' ');
INSERT INTO answer VALUES (3547, 887, 2, '17,8 MHz', ' ');
INSERT INTO answer VALUES (3548, 887, 3, '48,9 MHz', ' ');
INSERT INTO answer VALUES (3549, 888, 0, 'Durch die Vorselektion', ' ');
INSERT INTO answer VALUES (3550, 888, 1, 'Durch die Demodulatorkennlinie', ' ');
INSERT INTO answer VALUES (3551, 888, 2, 'Durch die Abstimmung des Oszillators', ' ');
INSERT INTO answer VALUES (3552, 888, 3, 'Durch die PLL-Frequenzaufbereitung', ' ');
INSERT INTO answer VALUES (3553, 889, 0, 'Die Filter im ZF-Verstärker', ' ');
INSERT INTO answer VALUES (3554, 889, 1, 'Die Vorkreise in der Vorstufe', ' ');
INSERT INTO answer VALUES (3555, 889, 2, 'Der Oszillatorschwingkreis in der Mischstufe', ' ');
INSERT INTO answer VALUES (3556, 889, 3, 'Die PLL-Frequenzaufbereitung', ' ');
INSERT INTO answer VALUES (3557, 890, 0, 'eine solide mechanische Konstruktion aufweisen.', ' ');
INSERT INTO answer VALUES (3558, 890, 1, 'aus Widerstandsdraht bestehen.', ' ');
INSERT INTO answer VALUES (3559, 890, 2, 'freitragend sein.', ' ');
INSERT INTO answer VALUES (3560, 890, 3, 'um einen Stahlkern gewickelt sein.', ' ');
INSERT INTO answer VALUES (3561, 891, 0, 'Temperaturstabilisierte Versorgung', ' ');
INSERT INTO answer VALUES (3562, 891, 1, 'Unmittelbare Stromzufuhr aus der Glättungsschaltung', ' ');
INSERT INTO answer VALUES (3563, 891, 2, 'Destabilisierte Versorgungsspannungen', ' ');
INSERT INTO answer VALUES (3564, 891, 3, 'Stabilisierte Wechselstromversorgung', ' ');
INSERT INTO answer VALUES (3565, 892, 0, 'Der Quarzkristall', ' ');
INSERT INTO answer VALUES (3566, 892, 1, 'Der LC-Bandpass', ' ');
INSERT INTO answer VALUES (3567, 892, 2, 'Der Keramikresonator', ' ');
INSERT INTO answer VALUES (3568, 892, 3, 'Der RC-Bandpass', ' ');
INSERT INTO answer VALUES (3569, 893, 0, 'Balancemischer', ' ');
INSERT INTO answer VALUES (3570, 893, 1, 'Quarzfilter', ' ');
INSERT INTO answer VALUES (3571, 893, 2, 'Gegentakt-Transistor', ' ');
INSERT INTO answer VALUES (3572, 893, 3, 'Doppeldiode', ' ');
INSERT INTO answer VALUES (3573, 894, 0, 'mit einem guten Erdband zu überbrücken.', ' ');
INSERT INTO answer VALUES (3574, 894, 1, 'das Halteband mit einer Ferritperle zu versehen.', ' ');
INSERT INTO answer VALUES (3575, 894, 2, 'mit einem Polystyrol-Kondensator abzublocken.', ' ');
INSERT INTO answer VALUES (3576, 894, 3, 'mit einem Kunststoffhalter zu versehen.', ' ');
INSERT INTO answer VALUES (3577, 895, 0, 'hohen Trennschärfe.', ' ');
INSERT INTO answer VALUES (3578, 895, 1, 'fehlenden Trennschärfe.', ' ');
INSERT INTO answer VALUES (3579, 895, 2, 'unzulänglichen Trennschärfe.', ' ');
INSERT INTO answer VALUES (3580, 895, 3, 'schlechten Demodulation.', ' ');
INSERT INTO answer VALUES (3581, 896, 0, 'SSB-Signalen geeignet.', ' ');
INSERT INTO answer VALUES (3582, 896, 1, 'CW-Signalen geeignet.', ' ');
INSERT INTO answer VALUES (3583, 896, 2, 'Breitbandfernsehsignalen geeignet.', ' ');
INSERT INTO answer VALUES (3584, 896, 3, 'breitbandigen FM-Signalen geeignet.', ' ');
INSERT INTO answer VALUES (3585, 897, 0, '4 kHz.', ' ');
INSERT INTO answer VALUES (3586, 897, 1, '5,6 kHz.', ' ');
INSERT INTO answer VALUES (3587, 897, 2, '6 kHz.', ' ');
INSERT INTO answer VALUES (3588, 897, 3, '2,5 kHz.', ' ');
INSERT INTO answer VALUES (3589, 898, 0, 'ein Quarzoszillator sein.', ' ');
INSERT INTO answer VALUES (3590, 898, 1, 'ein LC-Oszillator sein.', ' ');
INSERT INTO answer VALUES (3591, 898, 2, 'ein RC-Oszillator sein.', ' ');
INSERT INTO answer VALUES (3592, 898, 3, 'ein BFO sein.', ' ');
INSERT INTO answer VALUES (3593, 899, 0, 'in möglichst großem Abstand zu Wärmequellen aufgebaut sein.', ' ');
INSERT INTO answer VALUES (3594, 899, 1, 'auf einem eigenen Kühlkörper montiert sein.', ' ');
INSERT INTO answer VALUES (3595, 899, 2, 'auf dem gleichen Kühlkörper wie der Leistungsverstärker montiert sein.', ' ');
INSERT INTO answer VALUES (3596, 899, 3, 'über eine separate Luftkühlung durch einen kleinen Ventilator verfügen.', ' ');
INSERT INTO answer VALUES (3597, 900, 0, '800 Hz betragen.', ' ');
INSERT INTO answer VALUES (3598, 900, 1, 'die halbe ZF-Frequenz betragen.', ' ');
INSERT INTO answer VALUES (3599, 900, 2, '200 Hz betragen.', ' ');
INSERT INTO answer VALUES (3600, 900, 3, '4 kHz betragen.', ' ');
INSERT INTO answer VALUES (3601, 901, 0, 'eine Anpassung des Verstärkers an den Lautsprecher.', ' ');
INSERT INTO answer VALUES (3602, 901, 1, 'einen höheren NF-Gewinn.', ' ');
INSERT INTO answer VALUES (3603, 901, 2, 'eine bessere NF-Qualität.', ' ');
INSERT INTO answer VALUES (3604, 901, 3, 'einen sparsameren Stromverbrauch.', ' ');
INSERT INTO answer VALUES (3605, 902, 0, '35,64 MHz auftreten.', ' ');
INSERT INTO answer VALUES (3606, 902, 1, '10,7 MHz auftreten.', ' ');
INSERT INTO answer VALUES (3607, 902, 2, '3,54 MHz auftreten.', ' ');
INSERT INTO answer VALUES (3608, 902, 3, '24,94 MHz auftreten.', ' ');
INSERT INTO answer VALUES (3609, 903, 0, 'quarzgesteuert.', ' ');
INSERT INTO answer VALUES (3610, 903, 1, 'varaktorgesteuert.', ' ');
INSERT INTO answer VALUES (3611, 903, 2, 'freischwingend.', ' ');
INSERT INTO answer VALUES (3612, 903, 3, 'ein VFO.', ' ');
INSERT INTO answer VALUES (3613, 904, 0, '455,8 kHz.', ' ');
INSERT INTO answer VALUES (3614, 904, 1, '465,7 kHz.', ' ');
INSERT INTO answer VALUES (3615, 904, 2, '455 kHz.', ' ');
INSERT INTO answer VALUES (3616, 904, 3, '10,7 MHz.', ' ');
INSERT INTO answer VALUES (3617, 905, 0, 'einer robusten mechanischen Konstruktion abhängig.', ' ');
INSERT INTO answer VALUES (3618, 905, 1, 'der Verwendung von Tantalkondensatoren für die frequenzbestimmenden Teile abhängig.', ' ');
INSERT INTO answer VALUES (3619, 905, 2, 'der Verwendung von Widerstandsdraht für die Spule abhängig.', ' ');
INSERT INTO answer VALUES (3620, 905, 3, 'einer niederohmigen Gleichstromversorgung des VFO abhängig.', ' ');
INSERT INTO answer VALUES (3621, 906, 0, 'Zur Trägererzeugung, um A1A-Signale hörbar zu machen.', ' ');
INSERT INTO answer VALUES (3622, 906, 1, 'Zur Mischung mit einem Empfangssignal zur Erzeugung der ZF.', ' ');
INSERT INTO answer VALUES (3623, 906, 2, 'Zur Unterdrückung der Amplitudenüberlagerung.', ' ');
INSERT INTO answer VALUES (3624, 906, 3, 'Um FM-Signale zu unterdrücken.', ' ');
INSERT INTO answer VALUES (3625, 907, 0, 'zweifachen der ersten ZF.', ' ');
INSERT INTO answer VALUES (3626, 907, 1, 'zweifachen des HF-Nutzsignals.', ' ');
INSERT INTO answer VALUES (3627, 907, 2, 'dreifachen der dritten ZF.', ' ');
INSERT INTO answer VALUES (3628, 907, 3, 'HF-Nutzsignal plus der ersten ZF.', ' ');
INSERT INTO answer VALUES (3629, 908, 0, 'einer automatischen Verstärkungsregelung ausgestattet.', ' ');
INSERT INTO answer VALUES (3630, 908, 1, 'einer NF-Pegelbegrenzung ausgestattet.', ' ');
INSERT INTO answer VALUES (3631, 908, 2, 'NF-Filtern ausgestattet.', ' ');
INSERT INTO answer VALUES (3632, 908, 3, 'einer NF-Vorspannungsregelung ausgestattet.', ' ');
INSERT INTO answer VALUES (3633, 909, 0, 'dem zweifachen der ersten ZF.', ' ');
INSERT INTO answer VALUES (3634, 909, 1, 'der Frequenz des lokalen Oszillators.', ' ');
INSERT INTO answer VALUES (3635, 909, 2, 'der HF-Eingangsfrequenz.', ' ');
INSERT INTO answer VALUES (3636, 909, 3, 'der Frequenz des Preselektors.', ' ');
INSERT INTO answer VALUES (3637, 910, 0, 'die Verstärkung der HF- und ZF-Stufen.', ' ');
INSERT INTO answer VALUES (3638, 910, 1, 'die Versorgungsspannung des VFO.', ' ');
INSERT INTO answer VALUES (3639, 910, 2, 'eine Verstärkung der NF-Stufen.', ' ');
INSERT INTO answer VALUES (3640, 910, 3, 'eine Filterreaktion.', ' ');
INSERT INTO answer VALUES (3641, 911, 0, 'Spiegelfrequenzstörungen.', ' ');
INSERT INTO answer VALUES (3642, 911, 1, 'Beeinflussung des lokalen Oszillators.', ' ');
INSERT INTO answer VALUES (3643, 911, 2, 'Nebenaussendungen.', ' ');
INSERT INTO answer VALUES (3644, 911, 3, 'Störungen der zweiten ZF.', ' ');
INSERT INTO answer VALUES (3645, 912, 0, 'Ein Balancemischer', ' ');
INSERT INTO answer VALUES (3646, 912, 1, 'Ein Seitenbandfilter', ' ');
INSERT INTO answer VALUES (3647, 912, 2, 'Der Tiefpass', ' ');
INSERT INTO answer VALUES (3648, 912, 3, 'Der ZF-Verstärker', ' ');
INSERT INTO answer VALUES (3649, 913, 0, 'gut abgeschirmt sein.', ' ');
INSERT INTO answer VALUES (3650, 913, 1, 'niederfrequent entkoppelt werden.', ' ');
INSERT INTO answer VALUES (3651, 913, 2, 'nicht geerdet werden.', ' ');
INSERT INTO answer VALUES (3652, 913, 3, 'mit gut gesiebter Gleichspannung gespeist werden.', ' ');
INSERT INTO answer VALUES (3653, 914, 0, 'Balancemischer', ' ');
INSERT INTO answer VALUES (3654, 914, 1, 'Produkt-Demodulator', ' ');
INSERT INTO answer VALUES (3655, 914, 2, 'Dualtransistormischer', ' ');
INSERT INTO answer VALUES (3656, 914, 3, 'Doppeldiodenmischer', ' ');
INSERT INTO answer VALUES (3657, 915, 0, 'er in einem Metallkasten untergebracht werden.', ' ');
INSERT INTO answer VALUES (3658, 915, 1, 'er nicht abgeschirmt werden.', ' ');
INSERT INTO answer VALUES (3659, 915, 2, 'er niederohmig HF-entkoppelt sein.', ' ');
INSERT INTO answer VALUES (3660, 915, 3, 'die Speisespannung gesiebt sein.', ' ');
INSERT INTO answer VALUES (3661, 916, 0, 'linearer Verstärker gebaut.', ' ');
INSERT INTO answer VALUES (3662, 916, 1, 'Schaltstufe gebaut.', ' ');
INSERT INTO answer VALUES (3663, 916, 2, 'nichtlinearer Verstärker gebaut.', ' ');
INSERT INTO answer VALUES (3664, 916, 3, 'Vervielfacher gebaut.', ' ');
INSERT INTO answer VALUES (3665, 917, 0, '2800 Hz', ' ');
INSERT INTO answer VALUES (3666, 917, 1, '280 Hz', ' ');
INSERT INTO answer VALUES (3667, 917, 2, '28 MHz', ' ');
INSERT INTO answer VALUES (3668, 917, 3, '28 kHz', ' ');
INSERT INTO answer VALUES (3669, 918, 0, '21,15 MHz', ' ');
INSERT INTO answer VALUES (3670, 918, 1, '14,050 MHz', ' ');
INSERT INTO answer VALUES (3671, 918, 2, '24,15 MHz', ' ');
INSERT INTO answer VALUES (3672, 918, 3, '28,050 MHz', ' ');
INSERT INTO answer VALUES (3673, 919, 0, '28,80 MHz', ' ');
INSERT INTO answer VALUES (3674, 919, 1, '21,60 MHz', ' ');
INSERT INTO answer VALUES (3675, 919, 2, '24,20 MHz', ' ');
INSERT INTO answer VALUES (3676, 919, 3, '28,20 MHz', ' ');
INSERT INTO answer VALUES (3677, 920, 0, 'starke HF-Signale auf einer nahen Frequenz beeinträchtigt werden.', ' ');
INSERT INTO answer VALUES (3678, 920, 1, 'gute Erdung verbessert werden.', ' ');
INSERT INTO answer VALUES (3679, 920, 2, 'zu starke NF-Filterung beeinträchtigt werden.', ' ');
INSERT INTO answer VALUES (3680, 920, 3, 'fehlerhafte Einstellung des BFO beeinträchtigt werden.', ' ');
INSERT INTO answer VALUES (3681, 921, 0, 'Es sind Nichtlinearitäten in den HF-Stufen.', ' ');
INSERT INTO answer VALUES (3682, 921, 1, 'Der Empfänger ist nicht genau auf den Kanal eingestellt.', ' ');
INSERT INTO answer VALUES (3683, 921, 2, 'Es wird ein unlineares Quarzfilter verwendet.', ' ');
INSERT INTO answer VALUES (3684, 921, 3, 'Es wird ein zu hochwertiger Preselektor verwendet.', ' ');
INSERT INTO answer VALUES (3685, 922, 0, 'unerwünschte Abstrahlungen eines TV-Zeilenoszillators.', ' ');
INSERT INTO answer VALUES (3686, 922, 1, 'erwünschte Abstrahlungen eines TV-Zeilenoszillators.', ' ');
INSERT INTO answer VALUES (3687, 922, 2, 'erwünschte Abstrahlungen eines TV-Normalfrequenzsenders.', ' ');
INSERT INTO answer VALUES (3688, 922, 3, 'eine Funkstelle des Betriebsfunks mit NF-Tonruf.', ' ');
INSERT INTO answer VALUES (3689, 923, 0, 'Die Großsignalfestigkeit', ' ');
INSERT INTO answer VALUES (3690, 923, 1, 'Die Trennschärfe', ' ');
INSERT INTO answer VALUES (3691, 923, 2, 'Die Grenzempfindlichkeit', ' ');
INSERT INTO answer VALUES (3692, 923, 3, 'Das Signal-Rausch-Verhältnis', ' ');
INSERT INTO answer VALUES (3693, 924, 0, 'Einschalten eines Dämpfungsgliedes vor den Empfängereingang', ' ');
INSERT INTO answer VALUES (3694, 924, 1, 'Einschalten des Vorverstärkers', ' ');
INSERT INTO answer VALUES (3695, 924, 2, 'Einschalten des Noise-Blankers', ' ');
INSERT INTO answer VALUES (3696, 924, 3, 'Passband-Tuning', ' ');
INSERT INTO answer VALUES (3697, 925, 0, 'Durch die Empfindlichkeitsangabe 0,25 µV für S/N=10 dB', ' ');
INSERT INTO answer VALUES (3698, 925, 1, 'Durch die Grenzempfindlichkeit von 0,25 µV bei 10 dB Rauschen', ' ');
INSERT INTO answer VALUES (3699, 925, 2, 'Durch die Rauschzahl F = 10 für 0,25 µV', ' ');
INSERT INTO answer VALUES (3700, 925, 3, 'Durch den Interception Point IP3 = 10 bei 0,25 µV', ' ');
INSERT INTO answer VALUES (3701, 926, 0, 'Er gibt an, um wie viel dB das Nutzsignal stärker ist als das Rauschsignal.', ' ');
INSERT INTO answer VALUES (3702, 926, 1, 'Er gibt an, um wie viel dB das Rauschsignal stärker ist als das Nutzsignal.', ' ');
INSERT INTO answer VALUES (3703, 926, 2, 'Es ist der Abstand in Kilohertz zwischen Empfangssignal und Störsignal.', ' ');
INSERT INTO answer VALUES (3704, 926, 3, 'Es ist der Abstand in Kilohertz zwischen Empfangsfrequenz und Spiegelfrequenz.', ' ');
INSERT INTO answer VALUES (3705, 927, 0, 'um 3dB geringeres Signal-Rauschverhältnis als das Eingangssignal.', ' ');
INSERT INTO answer VALUES (3706, 927, 1, 'um 3dB höheres Signal-Rauschverhältnis als das Eingangssignal.', ' ');
INSERT INTO answer VALUES (3707, 927, 2, 'um 6dB geringeres Signal-Rauschverhältnis als das Eingangssignal.', ' ');
INSERT INTO answer VALUES (3708, 927, 3, 'um 6dB höheres Signal-Rauschverhältnis als das Eingangssignal.', ' ');
INSERT INTO answer VALUES (3709, 928, 0, 'um 1,8 dB geringeres Signal-Rauschverhältnis als das Eingangssignal.', ' ');
INSERT INTO answer VALUES (3710, 928, 1, 'um 1,8 dB höheres Signal-Rauschverhältnis als das Eingangssignal.', ' ');
INSERT INTO answer VALUES (3711, 928, 2, 'um etwa 151 % höheres Signal-Rauschverhältnis als das Eingangssignal.', ' ');
INSERT INTO answer VALUES (3712, 928, 3, 'um etwa 66 % geringeres Signal-Rauschverhältnis als das Eingangssignal.', ' ');
INSERT INTO answer VALUES (3713, 929, 0, '1: AD-Wandler, 2: DA-Wandler', ' ');
INSERT INTO answer VALUES (3714, 929, 1, '1: DA-Wandler, 2: AD-Wandler', ' ');
INSERT INTO answer VALUES (3715, 929, 2, 'beides DA-Wandler', ' ');
INSERT INTO answer VALUES (3716, 929, 3, 'beides AD-Wandler', ' ');
INSERT INTO answer VALUES (3717, 930, 0, 'Zur weitgehenden Unterdrückung von Störgeräuschen oder zur Dynamikkompression.', ' ');
INSERT INTO answer VALUES (3718, 930, 1, 'Zur digitalen Erzeugung der Empfänger-Regelspannung aus dem Audiosignal.', ' ');
INSERT INTO answer VALUES (3719, 930, 2, 'Zur direkten Modulation der Sendeendstufen und zur Unterdrückung von unerwünschten Aussendungen.', ' ');
INSERT INTO answer VALUES (3720, 930, 3, 'Zur Beseitigung von Spiegelfrequenzen und zur weitgehenden Unterdrückung von Nebenaussendungen.', ' ');
INSERT INTO answer VALUES (3721, 931, 0, 'als Frequenzfilter.', ' ');
INSERT INTO answer VALUES (3722, 931, 1, 'als Digital-Analog-Wandler.', ' ');
INSERT INTO answer VALUES (3723, 931, 2, 'zur Sprachausgabe.', ' ');
INSERT INTO answer VALUES (3724, 931, 3, 'zur Unterdrückung der Spiegelfrequenzen.', ' ');
INSERT INTO answer VALUES (3725, 932, 0, 'als Frequenzfilter oder als Dynamikkompressor.', ' ');
INSERT INTO answer VALUES (3726, 932, 1, 'zur Frequenzstabilisierung.', ' ');
INSERT INTO answer VALUES (3727, 932, 2, 'zur Speicherung von Frequenzen.', ' ');
INSERT INTO answer VALUES (3728, 932, 3, 'als Signalfeinverstimmung zwischen Sender und Empfänger.', ' ');
INSERT INTO answer VALUES (3729, 933, 0, '72', ' ');
INSERT INTO answer VALUES (3730, 933, 1, '48', ' ');
INSERT INTO answer VALUES (3731, 933, 2, '768', ' ');
INSERT INTO answer VALUES (3732, 933, 3, '00110000', ' ');
INSERT INTO answer VALUES (3733, 934, 0, '132', ' ');
INSERT INTO answer VALUES (3734, 934, 1, '72', ' ');
INSERT INTO answer VALUES (3735, 934, 2, '1344', ' ');
INSERT INTO answer VALUES (3736, 934, 3, '01010100', ' ');
INSERT INTO answer VALUES (3737, 935, 0, 'Ein Quarzfilter als Seitenbandsperre', ' ');
INSERT INTO answer VALUES (3738, 935, 1, 'Ein USB-Hochpass als Trägerfrequenzsperre', ' ');
INSERT INTO answer VALUES (3739, 935, 2, 'Ein LSB-Tiefpass als Trägerfrequenzsperre', ' ');
INSERT INTO answer VALUES (3740, 935, 3, 'Ein ZF-Notchfilter als Seitenbandsperre', ' ');
INSERT INTO answer VALUES (3741, 936, 0, 'die Hubbegrenzung und –einstellung bei FM-Funkgeräten.', ' ');
INSERT INTO answer VALUES (3742, 936, 1, 'die HF-Pegelbegrenzung und –einstellung bei FM-Funkgeräten.', ' ');
INSERT INTO answer VALUES (3743, 936, 2, 'die Erzeugung von Amplitudenmodulation.', ' ');
INSERT INTO answer VALUES (3744, 936, 3, 'die Erzeugung von Phasenmodulation.', ' ');
INSERT INTO answer VALUES (3745, 937, 0, '14,04 MHz', ' ');
INSERT INTO answer VALUES (3746, 937, 1, '7,02 MHz', ' ');
INSERT INTO answer VALUES (3747, 937, 2, '21,06 MHz', ' ');
INSERT INTO answer VALUES (3748, 937, 3, '3,55 MHz', ' ');
INSERT INTO answer VALUES (3749, 938, 0, '3,560 MHz', ' ');
INSERT INTO answer VALUES (3750, 938, 1, '4,272 MHz', ' ');
INSERT INTO answer VALUES (3751, 938, 2, '7,120 MHz', ' ');
INSERT INTO answer VALUES (3752, 938, 3, '5,340 MHz', ' ');
INSERT INTO answer VALUES (3753, 939, 0, 'Je ein Frequenzverdreifacher', ' ');
INSERT INTO answer VALUES (3754, 939, 1, 'Ein Frequenzverdreifacher und ein Frequenzverdoppler', ' ');
INSERT INTO answer VALUES (3755, 939, 2, 'Ein Frequenzvervierfacher und ein Frequenzverdoppler', ' ');
INSERT INTO answer VALUES (3756, 939, 3, 'Ein Oberwellenmischer und eine Treiberstufe', ' ');
INSERT INTO answer VALUES (3757, 940, 0, '8,9985 MHz', ' ');
INSERT INTO answer VALUES (3758, 940, 1, '8,9970 MHz', ' ');
INSERT INTO answer VALUES (3759, 940, 2, '9,0000 MHz', ' ');
INSERT INTO answer VALUES (3760, 940, 3, '9,0030 MHz', ' ');
INSERT INTO answer VALUES (3761, 941, 0, 'Ein Balancemischer', ' ');
INSERT INTO answer VALUES (3762, 941, 1, 'Ein symmetrisches Filter', ' ');
INSERT INTO answer VALUES (3763, 941, 2, 'Ein Ringdemodulator', ' ');
INSERT INTO answer VALUES (3764, 941, 3, 'Ein unsymmetrischer Mischer', ' ');
INSERT INTO answer VALUES (3765, 942, 0, 'ca. 2,5 kHz.', ' ');
INSERT INTO answer VALUES (3766, 942, 1, 'ca. 6 kHz.', ' ');
INSERT INTO answer VALUES (3767, 942, 2, 'ca. 1000 Hz.', ' ');
INSERT INTO answer VALUES (3768, 942, 3, 'ca. 9,0 MHz.', ' ');
INSERT INTO answer VALUES (3769, 943, 0, 'Ein Mikrofonverstärker mit Pegelbegrenzung.', ' ');
INSERT INTO answer VALUES (3770, 943, 1, 'Ein Mikrofonverstärker mit Diodenmischer zur Erzeugung von Phasenmodulation.', ' ');
INSERT INTO answer VALUES (3771, 943, 2, 'Ein Mikrofonverstärker mit Amplitudenmodulator und HF-Filter.', ' ');
INSERT INTO answer VALUES (3772, 943, 3, 'Ein Mikrofonverstärker mit automatischer Pegelregelung.', ' ');
INSERT INTO answer VALUES (3773, 944, 0, '3,651 MHz', ' ');
INSERT INTO answer VALUES (3774, 944, 1, '6,651 MHz', ' ');
INSERT INTO answer VALUES (3775, 944, 2, '8,651 MHz', ' ');
INSERT INTO answer VALUES (3776, 944, 3, '14,351 MHz', ' ');
INSERT INTO answer VALUES (3777, 945, 0, '17,000 MHz', ' ');
INSERT INTO answer VALUES (3778, 945, 1, '2,351 MHz', ' ');
INSERT INTO answer VALUES (3779, 945, 2, '6,000 MHz', ' ');
INSERT INTO answer VALUES (3780, 945, 3, '6,351 MHz', ' ');
INSERT INTO answer VALUES (3781, 946, 0, '<p><img src=''tg201a.png''></p>', ' ');
INSERT INTO answer VALUES (3782, 946, 1, '<p><img src=''tg201b.png''></p>', ' ');
INSERT INTO answer VALUES (3783, 946, 2, '<p><img src=''tg201c.png''></p>', ' ');
INSERT INTO answer VALUES (3784, 946, 3, '<p><img src=''tg201d.png''></p>', ' ');
INSERT INTO answer VALUES (3785, 947, 0, '<p><img src=''tg202a.png''></p>', ' ');
INSERT INTO answer VALUES (3786, 947, 1, '<p><img src=''tg202b.png''></p>', ' ');
INSERT INTO answer VALUES (3787, 947, 2, '<p><img src=''tg202c.png''></p>', ' ');
INSERT INTO answer VALUES (3788, 947, 3, '<p><img src=''tg202d.png''></p>', ' ');
INSERT INTO answer VALUES (3789, 948, 0, '3 kHz beschränkt werden.', ' ');
INSERT INTO answer VALUES (3790, 948, 1, '12,5 kHz beschränkt werden.', ' ');
INSERT INTO answer VALUES (3791, 948, 2, '25 kHz beschränkt werden.', ' ');
INSERT INTO answer VALUES (3792, 948, 3, '455 kHz beschränkt werden.', ' ');
INSERT INTO answer VALUES (3793, 949, 0, 'Verrundung der Flanken des Tastsignals.', ' ');
INSERT INTO answer VALUES (3794, 949, 1, 'Verwendung einer nicht abgeschirmten Leitung zur Taste.', ' ');
INSERT INTO answer VALUES (3795, 949, 2, 'Verwendung eines sehr kleinen Hubes an der Taste.', ' ');
INSERT INTO answer VALUES (3796, 949, 3, 'langsamere Tastung.', ' ');
INSERT INTO answer VALUES (3797, 950, 0, '<p><img src=''tg205a.png''></p>', ' ');
INSERT INTO answer VALUES (3798, 950, 1, '<p><img src=''tg205b.png''></p>', ' ');
INSERT INTO answer VALUES (3799, 950, 2, '<p><img src=''tg205c.png''></p>', ' ');
INSERT INTO answer VALUES (3800, 950, 3, '<p><img src=''tg205d.png''></p>', ' ');
INSERT INTO answer VALUES (3801, 951, 0, 'Das Verziehen der Oszillatorfrequenz beim Tasten des Senders.', ' ');
INSERT INTO answer VALUES (3802, 951, 1, 'Die Übermodulation der Endstufe beim Tasten des Senders.', ' ');
INSERT INTO answer VALUES (3803, 951, 2, 'Das Ansprechen der AGC-Stufe beim Tasten des Senders.', ' ');
INSERT INTO answer VALUES (3804, 951, 3, 'Die Überhöhung des Frequenzhubs beim Tasten des Senders.', ' ');
INSERT INTO answer VALUES (3805, 952, 0, 'AM', ' ');
INSERT INTO answer VALUES (3806, 952, 1, 'FM', ' ');
INSERT INTO answer VALUES (3807, 952, 2, 'NBFM', ' ');
INSERT INTO answer VALUES (3808, 952, 3, 'PM', ' ');
INSERT INTO answer VALUES (3809, 953, 0, 'mit einer stabilen Gleichstromversorgung betrieben werden.', ' ');
INSERT INTO answer VALUES (3810, 953, 1, 'in einem Kunststoffbehälter untergebracht werden.', ' ');
INSERT INTO answer VALUES (3811, 953, 2, 'mit einer stabilisierten Wechselstromversorgung betrieben werden.', ' ');
INSERT INTO answer VALUES (3812, 953, 3, 'die Frequenz in Abhängigkeit der Temperatur verändern.', ' ');
INSERT INTO answer VALUES (3813, 954, 0, 'in einer Position angeordnet werden, die möglichst geringen Temperaturschwankungen unterworfen ist.', ' ');
INSERT INTO answer VALUES (3814, 954, 1, 'locker um einen Keramikkern gewickelt werden.', ' ');
INSERT INTO answer VALUES (3815, 954, 2, 'neben einem Ventilator angebracht werden um sie zu kühlen.', ' ');
INSERT INTO answer VALUES (3816, 954, 3, 'so fest wie möglich um einen Kern aus rostfreiem Stahl gewickelt werden.', ' ');
INSERT INTO answer VALUES (3817, 955, 0, 'Die Frequenz des Oszillators ändert sich langsam (Drift).', ' ');
INSERT INTO answer VALUES (3818, 955, 1, 'Die Frequenz des Oszillators ändert sich sehr schnell (Chirp).', ' ');
INSERT INTO answer VALUES (3819, 955, 2, 'Die Amplitude der Oszillatorfrequenz schwankt (unerwünschte AM).', ' ');
INSERT INTO answer VALUES (3820, 955, 3, 'Die Frequenz des Oszillators ändert sich unregelmäßig (unerwünschte FM).', ' ');
INSERT INTO answer VALUES (3821, 956, 0, 'eine Pufferstufe angeschlossen sein.', ' ');
INSERT INTO answer VALUES (3822, 956, 1, 'einen Leistungsverstärker angeschlossen sein.', ' ');
INSERT INTO answer VALUES (3823, 956, 2, 'einen HF-Verstärker im C-Betrieb angeschlossen sein.', ' ');
INSERT INTO answer VALUES (3824, 956, 3, 'ein Notchfilter angeschlossen sein.', ' ');
INSERT INTO answer VALUES (3825, 957, 0, 'Sie beeinflusst die Resonanzfrequenz des Schwingkreises in Abhängigkeit von den Frequenzen im Basisband und moduliert so die Oszillatorfrequenz.', ' ');
INSERT INTO answer VALUES (3826, 957, 1, 'Sie richtet das Eingangssignal gleich und erzeugt so die Betriebsspannung für den Oszillator, um diesen von der Stromversorgung der anderen Stufen zu entkoppeln.', ' ');
INSERT INTO answer VALUES (3827, 957, 2, 'Sie begrenzt die Amplituden des Eingangssignals und vermeidet so die Übersteuerung der Oszillatorstufe.', ' ');
INSERT INTO answer VALUES (3828, 957, 3, 'Sie dient zur Erzeugung von Amplitudenmodulation und zur Abstimmung der Oszillatorfrequenz.', ' ');
INSERT INTO answer VALUES (3829, 958, 0, 'Im Balancemodulator wird ein Zweiseitenband-Signal erzeugt. Das Seitenbandfilter selektiert ein Seitenband heraus.', ' ');
INSERT INTO answer VALUES (3830, 958, 1, 'Im Balancemodulator wird ein Zweiseitenband-Signal erzeugt. Ein auf die Trägerfrequenz abgestimmter Saugkreis filtert den Träger aus.', ' ');
INSERT INTO answer VALUES (3831, 958, 2, 'Im Balancemodulator wird ein Zweiseitenband-Signal erzeugt. Ein auf die Trägerfrequenz abgestimmter Sperrkreis filtert den Träger aus.', ' ');
INSERT INTO answer VALUES (3832, 958, 3, 'Im Balancemodulator wird ein Zweiseitenband-Signal erzeugt. In einem Frequenzteiler wird ein Seitenband abgespalten.', ' ');
INSERT INTO answer VALUES (3833, 959, 0, '2,4 kHz Bandbreite verfügen.', ' ');
INSERT INTO answer VALUES (3834, 959, 1, '800 Hz Bandbreite verfügen.', ' ');
INSERT INTO answer VALUES (3835, 959, 2, '455 kHz Bandbreite verfügen.', ' ');
INSERT INTO answer VALUES (3836, 959, 3, '10,7 MHz Bandbreite verfügen.', ' ');
INSERT INTO answer VALUES (3837, 960, 0, 'Das Signal wird einer nicht linearen Verzerrerstufe zugeführt und die gewünschte Oberwelle beziehungsweise Harmonische ausgefiltert.', ' ');
INSERT INTO answer VALUES (3838, 960, 1, 'Das jeweils um plus und minus 90° phasenverschobene Signal wird einem additiven Mischer zugeführt, der die gewünschte Oberwelle beziehungsweise Harmonische erzeugt.', ' ');
INSERT INTO answer VALUES (3839, 960, 2, 'Das Signal wird gefiltert und einem Ringmischer zugeführt, der die gewünschte Oberwelle beziehungsweise Harmonische erzeugt.', ' ');
INSERT INTO answer VALUES (3840, 960, 3, 'Das jeweils um plus und minus 90° phasenverschobene Signal wird einem multiplikativen Mischer zugeführt, der die gewünschte Oberwelle beziehungsweise Harmonische erzeugt.', ' ');
INSERT INTO answer VALUES (3841, 961, 0, 'gut abgeschirmt sein, um unerwünschte Abstrahlungen zu minimieren.', ' ');
INSERT INTO answer VALUES (3842, 961, 1, 'frequenzmoduliert werden.', ' ');
INSERT INTO answer VALUES (3843, 961, 2, 'in PTFE eingehüllt werden.', ' ');
INSERT INTO answer VALUES (3844, 961, 3, 'sehr gut gekühlt werden.', ' ');
INSERT INTO answer VALUES (3845, 962, 0, 'einen Frequenzvervielfacher.', ' ');
INSERT INTO answer VALUES (3846, 962, 1, 'einen Oszillator.', ' ');
INSERT INTO answer VALUES (3847, 962, 2, 'einen abstimmbaren HF-Verstärker im C-Betrieb.', ' ');
INSERT INTO answer VALUES (3848, 962, 3, 'die Pufferstufe für einen Oszillator.', ' ');
INSERT INTO answer VALUES (3849, 963, 0, 'sehr sorgfältig abgeschirmt werden.', ' ');
INSERT INTO answer VALUES (3850, 963, 1, 'sehr gute Mantelwellenfilter enthalten.', ' ');
INSERT INTO answer VALUES (3851, 963, 2, 'in Polystyrol eingegossen werden.', ' ');
INSERT INTO answer VALUES (3852, 963, 3, 'eine besonders gesiebte Spannungsstabilisierung erhalten.', ' ');
INSERT INTO answer VALUES (3853, 964, 0, 'Absorptionsfrequenzmesser prüfen.', ' ');
INSERT INTO answer VALUES (3854, 964, 1, 'Diodentastkopf prüfen.', ' ');
INSERT INTO answer VALUES (3855, 964, 2, 'Universalmessgerät prüfen.', ' ');
INSERT INTO answer VALUES (3856, 964, 3, 'Frequenzzähler prüfen.', ' ');
INSERT INTO answer VALUES (3857, 965, 0, '2 mal 2 mal 3 mal 3.', ' ');
INSERT INTO answer VALUES (3858, 965, 1, '2 mal 3 mal 3 mal 2.', ' ');
INSERT INTO answer VALUES (3859, 965, 2, '3 mal 3 mal 2 mal 2.', ' ');
INSERT INTO answer VALUES (3860, 965, 3, '3 mal 2 mal 3 mal 2.', ' ');
INSERT INTO answer VALUES (3861, 966, 0, '12,083333 MHz', ' ');
INSERT INTO answer VALUES (3862, 966, 1, '36,250000 MHz', ' ');
INSERT INTO answer VALUES (3863, 966, 2, '20,714285 MHz', ' ');
INSERT INTO answer VALUES (3864, 966, 3, '24,166666 MHz', ' ');
INSERT INTO answer VALUES (3865, 967, 0, 'HF-Verstärker.', ' ');
INSERT INTO answer VALUES (3866, 967, 1, 'Mischer.', ' ');
INSERT INTO answer VALUES (3867, 967, 2, 'NF-Verstärker.', ' ');
INSERT INTO answer VALUES (3868, 967, 3, 'Oszillator.', ' ');
INSERT INTO answer VALUES (3869, 968, 0, 'Zur HF-Entkopplung', ' ');
INSERT INTO answer VALUES (3870, 968, 1, 'Zur Abstimmung', ' ');
INSERT INTO answer VALUES (3871, 968, 2, 'Zur Wechselstromkopplung', ' ');
INSERT INTO answer VALUES (3872, 968, 3, 'Zur Kopplung mit der nächstfolgenden Stufe', ' ');
INSERT INTO answer VALUES (3873, 969, 0, 'Sie dient zur Anpassung der Eingangsimpedanz der Stufe.', ' ');
INSERT INTO answer VALUES (3874, 969, 1, 'Sie schützt die Verstärkerstufe vor wilden Schwingungen.', ' ');
INSERT INTO answer VALUES (3875, 969, 2, 'Sie bewirkt die notwendige Entkopplung für den Schwingungseinsatz der Oszillatorstufe.', ' ');
INSERT INTO answer VALUES (3876, 969, 3, 'Sie dient zur Erhöhung des HF-Wirkungsgrades der Verstärkerstufe.', ' ');
INSERT INTO answer VALUES (3877, 970, 0, 'Zur Festlegung der HF-Kopplung', ' ');
INSERT INTO answer VALUES (3878, 970, 1, 'Zur Verhinderung der Schwingneigung', ' ');
INSERT INTO answer VALUES (3879, 970, 2, 'Zur Gleichstromentkopplung', ' ');
INSERT INTO answer VALUES (3880, 970, 3, 'Zur Unterdrückung von Oberwellen', ' ');
INSERT INTO answer VALUES (3881, 971, 0, '10,7 und 52,7 MHz', ' ');
INSERT INTO answer VALUES (3882, 971, 1, '42 und 63,4 MHz', ' ');
INSERT INTO answer VALUES (3883, 971, 2, '21 und 63,4 MHz', ' ');
INSERT INTO answer VALUES (3884, 971, 3, '21,4 und 105,4 MHz', ' ');
INSERT INTO answer VALUES (3885, 972, 0, 'Ein balancierter Ringmischer', ' ');
INSERT INTO answer VALUES (3886, 972, 1, 'Ein stabilisierter Produktdetektor', ' ');
INSERT INTO answer VALUES (3887, 972, 2, 'Ein optimierter Transistormischer', ' ');
INSERT INTO answer VALUES (3888, 972, 3, 'Ein optimierter Diodenmischer', ' ');
INSERT INTO answer VALUES (3889, 973, 0, 'gut gefiltert werden.', ' ');
INSERT INTO answer VALUES (3890, 973, 1, 'unmittelbar gekoppelt werden.', ' ');
INSERT INTO answer VALUES (3891, 973, 2, 'an einen linear dämpfenden Transistor angeschlossen werden.', ' ');
INSERT INTO answer VALUES (3892, 973, 3, 'an eine Widerstandskopplung angeschlossen werden.', ' ');
INSERT INTO answer VALUES (3893, 974, 0, 'sollte den gewünschten Frequenzbereich durchlassen.', ' ');
INSERT INTO answer VALUES (3894, 974, 1, 'sollte alle Harmonischen durchlassen.', ' ');
INSERT INTO answer VALUES (3895, 974, 2, 'sollte die Abstrahlung aller Subharmonischen zulassen.', ' ');
INSERT INTO answer VALUES (3896, 974, 3, 'unterdrückt das Oberband.', ' ');
INSERT INTO answer VALUES (3897, 975, 0, 'Bandpass', ' ');
INSERT INTO answer VALUES (3898, 975, 1, 'Tiefpassfilter', ' ');
INSERT INTO answer VALUES (3899, 975, 2, 'Hochpassfilter', ' ');
INSERT INTO answer VALUES (3900, 975, 3, 'Notchfilter', ' ');
INSERT INTO answer VALUES (3901, 976, 0, '<p><img src=''tg231a.png''></p>', ' ');
INSERT INTO answer VALUES (3902, 976, 1, '<p><img src=''tg231b.png''></p>', ' ');
INSERT INTO answer VALUES (3903, 976, 2, '<p><img src=''tg231c.png''></p>', ' ');
INSERT INTO answer VALUES (3904, 976, 3, '<p><img src=''tg231d.png''></p>', ' ');
INSERT INTO answer VALUES (3905, 977, 0, '<p><img src=''tg231d.png''></p>', ' ');
INSERT INTO answer VALUES (3906, 977, 1, '<p><img src=''tg231a.png''></p>', ' ');
INSERT INTO answer VALUES (3907, 977, 2, '<p><img src=''tg231b.png''></p>', ' ');
INSERT INTO answer VALUES (3908, 977, 3, '<p><img src=''tg232d.png''></p>', ' ');
INSERT INTO answer VALUES (3909, 978, 0, 'Sie dient als HF-Spannungsmesser. Der Spannungsteiler R<sub>1</sub>/R<sub>2</sub> muss so bemessen sein, dass die Spannungsbelastbarkeit der Diode nicht überschritten wird. Der Widerstand R<sub>1</sub> muss so bemessen sein, dass die an der Diode entstehenden Oberwellen von der Antenne möglichst hoch entkoppelt sind.', ' ');
INSERT INTO answer VALUES (3910, 978, 1, 'Sie dient als SWR-Anzeige. Der Spannungsteiler R<sub>1</sub>/R<sub>2</sub> wird mit Hilfe eines Reflektometers voreingestellt. Die Spannungsbelastbarkeit der Diode darf nicht überschritten werden. Der Widerstand R<sub>1</sub> muss so bemessen sein, dass die an der gekrümmten Kennlinie der Diode zusätzlich entstehenden Oberwellen nicht die Messung verfälschen.', ' ');
INSERT INTO answer VALUES (3911, 978, 2, 'Sie dient als Antennenimpedanzmesser. Der Spannungsteiler R<sub>1</sub>/R<sub>2</sub> wird als Impedanzanpassung der Messdiode verwendet. Die Spannungsbelastbarkeit der Diode darf nicht überschritten werden. Der Widerstand R<sub>1</sub> muss so bemessen sein, dass die an der gekrümmten Kennlinie der Diode zusätzlich entstehenden Oberwellen nicht die Messung verfälschen.', ' ');
INSERT INTO answer VALUES (3912, 978, 3, 'Sie dient als Leistungsmesser. Über den Spannungsteiler R<sub>1</sub>/R<sub>2</sub> wird das HF-Hitzdraht-Amperemeter kalibriert. Der Widerstand R<sub>1</sub> muss so bemessen sein, dass die an der gekrümmten Kennlinie der Diode zusätzlich entstehenden Oberwellen vom Messinstrument möglichst hoch entkoppelt sind und nicht die Messung verfälschen.', ' ');
INSERT INTO answer VALUES (3913, 979, 0, 'gegen HF-Einstrahlung gut entkoppelt sein.', ' ');
INSERT INTO answer VALUES (3914, 979, 1, 'gegen Erde HF-Potential aufweisen.', ' ');
INSERT INTO answer VALUES (3915, 979, 2, 'über das Leistungsverstärkergehäuse geführt werden.', ' ');
INSERT INTO answer VALUES (3916, 979, 3, 'HF-Schwingungen aufweisen.', ' ');
INSERT INTO answer VALUES (3917, 980, 0, 'Ein Transverter setzt beim Empfangen z.B. ein 70-cm-Signal in das 10-m-Band und beim Senden das 10-m-Sendesignal auf das 70-cm-Band um.', ' ');
INSERT INTO answer VALUES (3918, 980, 1, 'Ein Transverter setzt beim Senden als auch beim Empfangen z.B. ein 70-cm-Signal in das 10-m-Band um.', ' ');
INSERT INTO answer VALUES (3919, 980, 2, 'Ein Transverter setzt sowohl beim Senden als auch beim Empfangen z.B. ein frequenzmoduliertes Signal in ein amplitudenmoduliertes Signal um.', ' ');
INSERT INTO answer VALUES (3920, 980, 3, 'Ein Transverter setzt den zu empfangenden Frequenzbereich in einen anderen Frequenzbereich um, z.B. das 70-cm-Band in das 10-m-Band.', ' ');
INSERT INTO answer VALUES (3921, 981, 0, 'Ein Mischer und ein 9-MHz-Oszillator', ' ');
INSERT INTO answer VALUES (3922, 981, 1, 'Ein Vervielfacher und ein selektiver Verstärker', ' ');
INSERT INTO answer VALUES (3923, 981, 2, 'Ein Phasenvergleicher und ein Oberwellenmischer', ' ');
INSERT INTO answer VALUES (3924, 981, 3, 'Ein Frequenzteiler durch 3 und ein Verachtfacher', ' ');
INSERT INTO answer VALUES (3925, 982, 0, 'Breitband-HF-Verstärker.', ' ');
INSERT INTO answer VALUES (3926, 982, 1, 'selektiven Hochfrequenzverstärker.', ' ');
INSERT INTO answer VALUES (3927, 982, 2, 'Gegentakt-Verstärker.', ' ');
INSERT INTO answer VALUES (3928, 982, 3, 'Niederfrequenz-Verstärker.', ' ');
INSERT INTO answer VALUES (3929, 983, 0, 'Emitterschaltung an den Eingang der folgenden Emitterschaltung.', ' ');
INSERT INTO answer VALUES (3930, 983, 1, 'Emitterschaltung an den Eingang der folgenden Kollektorschaltung.', ' ');
INSERT INTO answer VALUES (3931, 983, 2, 'Kollektorschaltung an den Eingang der folgenden Emitterschaltung.', ' ');
INSERT INTO answer VALUES (3932, 983, 3, 'Kollektorschaltung an den Eingang der folgenden PA.', ' ');
INSERT INTO answer VALUES (3933, 984, 0, 'Der Kondensator geringer Kapazität dient jeweils zum Abblocken hoher Frequenzen, der Kondensator hoher Kapazität zum Abblocken niedriger Frequenzen.', ' ');
INSERT INTO answer VALUES (3934, 984, 1, 'Die Kapazität nur eines Kondensators reicht bei der hohen Frequenz nicht aus.', ' ');
INSERT INTO answer VALUES (3935, 984, 2, 'Der Kondensator mit der geringen Kapazität dient zur Siebung der niedrigen und der Kondensator mit der hohen Kapazität zur Siebung der hohen Frequenzen.', ' ');
INSERT INTO answer VALUES (3936, 984, 3, 'Zu einem Elektrolytkondensator muss immer ein keramischer Kondensator parallel geschaltet werden, weil er sonst bei hohen Frequenzen zerstört werden würde.', ' ');
INSERT INTO answer VALUES (3937, 985, 0, 'Er soll die Entstehung parasitärer Schwingungen verhindern.', ' ');
INSERT INTO answer VALUES (3938, 985, 1, 'Er dient zur Anpassung der Primärwicklung an die folgende PA.', ' ');
INSERT INTO answer VALUES (3939, 985, 2, 'Er dient zur Erhöhung des HF-Wirkungsgrades der Verstärkerstufe.', ' ');
INSERT INTO answer VALUES (3940, 985, 3, 'Er dient zur Begrenzung des Kollektorstroms bei Übersteuerung.', ' ');
INSERT INTO answer VALUES (3941, 986, 0, 'Sie ist unabhängig von der Modulation.', ' ');
INSERT INTO answer VALUES (3942, 986, 1, 'Sie variiert mit der Modulationsleistung, wenn der Sender moduliert wird.', ' ');
INSERT INTO answer VALUES (3943, 986, 2, 'Sie reduziert sich um 50 %, wenn der Sender moduliert wird.', ' ');
INSERT INTO answer VALUES (3944, 986, 3, 'Sie geht gegen Null, wenn der Sender nicht moduliert wird.', ' ');
INSERT INTO answer VALUES (3945, 987, 0, 'Sie ist sehr gering, wenn der Sender nicht moduliert wird.', ' ');
INSERT INTO answer VALUES (3946, 987, 1, 'Sie ist unabhängig von der Modulation.', ' ');
INSERT INTO answer VALUES (3947, 987, 2, 'Sie reduziert sich um 50 %, wenn der Sender moduliert wird.', ' ');
INSERT INTO answer VALUES (3948, 987, 3, 'Sie ist am höchsten, wenn der Sender nicht moduliert wird.', ' ');
INSERT INTO answer VALUES (3949, 988, 0, 'A-, AB- oder B-Betrieb sein', ' ');
INSERT INTO answer VALUES (3950, 988, 1, 'AB-, B- oder C-Betrieb sein', ' ');
INSERT INTO answer VALUES (3951, 988, 2, 'B- oder C-Betrieb sein', ' ');
INSERT INTO answer VALUES (3952, 988, 3, 'A-, AB-, B- oder C-Betrieb sein', ' ');
INSERT INTO answer VALUES (3953, 989, 0, 'C-Betrieb', ' ');
INSERT INTO answer VALUES (3954, 989, 1, 'B-Betrieb', ' ');
INSERT INTO answer VALUES (3955, 989, 2, 'AB-Betrieb', ' ');
INSERT INTO answer VALUES (3956, 989, 3, 'A-Betrieb', ' ');
INSERT INTO answer VALUES (3957, 990, 0, 'wird nicht durch die Modulation beeinflusst.', ' ');
INSERT INTO answer VALUES (3958, 990, 1, 'ändert sich durch die Modulation.', ' ');
INSERT INTO answer VALUES (3959, 990, 2, 'beträgt bei fehlender Modulation Null.', ' ');
INSERT INTO answer VALUES (3960, 990, 3, 'verringert sich durch Modulation auf 70 %.', ' ');
INSERT INTO answer VALUES (3961, 991, 0, 'in einem auf Masse liegenden Metallkasten untergebracht werden.', ' ');
INSERT INTO answer VALUES (3962, 991, 1, 'hinter dem Verstärker aufgestellt werden, um die Kühlung zu verbessern.', ' ');
INSERT INTO answer VALUES (3963, 991, 2, 'vor dem Verstärker eingebaut werden.', ' ');
INSERT INTO answer VALUES (3964, 991, 3, 'direkt an der Antenne befestigt werden.', ' ');
INSERT INTO answer VALUES (3965, 992, 0, 'An der Antennenbuchse wird bei Ein- oder Zweitonaussteuerung die Leistung gemessen.', ' ');
INSERT INTO answer VALUES (3966, 992, 1, 'Am Speisepunkt der Antenne wird bei Eintonaussteuerung die Leistung gemessen.', ' ');
INSERT INTO answer VALUES (3967, 992, 2, 'An der Antennenbuchse wird bei Sprachmodulation die maximale Hüllkurvenleistung (PEP) gemessen.', ' ');
INSERT INTO answer VALUES (3968, 992, 3, 'Am Speisepunkt der Antenne wird bei Sprachmodulation die maximale Hüllkurvenleistung (PEP) gemessen.', ' ');
INSERT INTO answer VALUES (3969, 993, 0, '240 &Omega; betragen.', ' ');
INSERT INTO answer VALUES (3970, 993, 1, '60 &Omega; betragen.', ' ');
INSERT INTO answer VALUES (3971, 993, 2, '120 &Omega; betragen.', ' ');
INSERT INTO answer VALUES (3972, 993, 3, '50 &Omega; betragen.', ' ');
INSERT INTO answer VALUES (3973, 994, 0, 'Es dient der Anpassung der Last und verbessert die Unterdrückung von Oberwellen.', ' ');
INSERT INTO answer VALUES (3974, 994, 1, 'Es dient der Verbesserung des Stehwellenverhältnisses bei nicht resonanter Antenne.', ' ');
INSERT INTO answer VALUES (3975, 994, 2, 'Es dient der Verbesserung des Wirkungsgrads der Endstufe durch Änderung der ALC.', ' ');
INSERT INTO answer VALUES (3976, 994, 3, 'Es dient dem Schutz der Endstufe bei offener oder kurzgeschlossener Antennenbuchse.', ' ');
INSERT INTO answer VALUES (3977, 995, 0, 'zur optimalen Anpassung der Ein- und Ausgangsimpedanzen.', ' ');
INSERT INTO answer VALUES (3978, 995, 1, 'zur optimalen Einstellung des Arbeitspunktes nach Betrag und Phase.', ' ');
INSERT INTO answer VALUES (3979, 995, 2, 'zur Verringerung der rücklaufenden Leistung bei Fehlanpassung.', ' ');
INSERT INTO answer VALUES (3980, 995, 3, 'zur Erhöhung des HF-Wirkungsgrades der Verstärkerstufe.', ' ');
INSERT INTO answer VALUES (3981, 996, 0, 'Sie passen die Eingangsimpedanz an den niederohmigeren Transistoreingang an.', ' ');
INSERT INTO answer VALUES (3982, 996, 1, 'Sie unterdrücken unerwünschte Harmonische der vorhergehenden Treiberstufe', ' ');
INSERT INTO answer VALUES (3983, 996, 2, 'Sie dienen zur optimalen Einstellung des Arbeitspunktes für den Endstufentransistor.', ' ');
INSERT INTO answer VALUES (3984, 996, 3, 'Sie schützen den Endstufentransistor vor Überlastung.', ' ');
INSERT INTO answer VALUES (3985, 997, 0, 'R<sub>1</sub> dient zur Arbeitspunkteinstellung des Transistors T1.', ' ');
INSERT INTO answer VALUES (3986, 997, 1, 'C<sub>4</sub>, C<sub>5</sub> und L<sub>2</sub> passen den Transistorausgang an die niederohmigere Ausgangsimpedanz an.', ' ');
INSERT INTO answer VALUES (3987, 997, 2, 'C<sub>1</sub>, C<sub>2</sub> und L<sub>1</sub> passen die hochohmigere Eingangsimpedanz an den Transistoreingang an.', ' ');
INSERT INTO answer VALUES (3988, 997, 3, 'HF-Eingang und HF-Ausgang sind gleichspannungsfrei.', ' ');
INSERT INTO answer VALUES (3989, 998, 0, 'eine HF-Endstufe mit einer Triode in Gitterbasisschaltung.', ' ');
INSERT INTO answer VALUES (3990, 998, 1, 'einen HF-Oszillator mit Katodenmodulation.', ' ');
INSERT INTO answer VALUES (3991, 998, 2, 'eine UKW-Vorstufe mit einer Triode in Katodenbasisschaltung.', ' ');
INSERT INTO answer VALUES (3992, 998, 3, 'ein Pendelaudion mit Selbstüberlagerung.', ' ');
INSERT INTO answer VALUES (3993, 999, 0, 'einen Pi-Filter zur Anpassung der Antenne an die Ausgangsimpedanz der Röhre.', ' ');
INSERT INTO answer VALUES (3994, 999, 1, 'einen regelbaren Bandfilter mit veränderbarer Bandbreite zur Kompensation der Auskoppelverluste.', ' ');
INSERT INTO answer VALUES (3995, 999, 2, 'einen abstimmbaren Sperrkreis zur Unterdrückung von Harmonischen.', ' ');
INSERT INTO answer VALUES (3996, 999, 3, 'einen Idler-Kreis, der die zweite Harmonische unterdrückt und so den Wirkungsgrad der Verstärkerstufe erhöht.', ' ');
INSERT INTO answer VALUES (3997, 1000, 0, 'An dem Drehknopf für C<sub>1</sub> steht "C<sub>Plate</sub>" oder "Plate", an dem für C<sub>2</sub> steht "C<sub>Load</sub>" oder "Load". Die drei Bauelemente C<sub>1</sub>, C<sub>2</sub> und L<sub>1</sub> bilden zusammen einen so genannten Pi-Tankkreis zur Anpassung der Ausgangsimpedanz der Röhre an die Antennenimpedanz.', ' ');
INSERT INTO answer VALUES (3998, 1000, 1, 'An dem Drehknopf für C<sub>1</sub> steht "C<sub>Load</sub>" oder "Load", an dem für C<sub>2</sub> steht "C<sub>Plate</sub>" oder "Plate". Die drei Bauelemente C<sub>1</sub>, C<sub>2</sub> und L<sub>1</sub> bilden zusammen ein abstimmbaren Sperrkreis zur Unterdrückung von Harmonischen.', ' ');
INSERT INTO answer VALUES (3999, 1000, 2, 'An dem Drehknopf für C<sub>1</sub> steht "C<sub>Plate</sub>" oder "Plate", an dem für C<sub>2</sub> steht "C<sub>Load</sub>" oder "Load". Die drei Bauelemente C<sub>1</sub>, C<sub>2</sub> und L<sub>1</sub> bilden zusammen ein abstimmbaren Sperrkreis zur Unterdrückung von Harmonischen.', ' ');
INSERT INTO answer VALUES (4000, 1000, 3, 'An dem Drehknopf für C<sub>1</sub> steht "C<sub>Load</sub>" oder "Load", an dem für C<sub>2</sub> steht "C<sub>Plate</sub>" oder "Plate". Die drei Bauelemente C<sub>1</sub>, C<sub>2</sub> und L<sub>1</sub> bilden zusammen einen so genannten Pi-Tankkreis zur Anpassung der Ausgangsimpedanz der Röhre an die Antennenimpedanz.', ' ');
INSERT INTO answer VALUES (4001, 1001, 0, 'C<sub>1</sub> und C<sub>2</sub> auf maximale Kapazität stellen. C1 auf Dip im Anodenstrom (Resonanz) stellen, dann mit C<sub>2</sub> einen etwas höheren Anodenstrom einstellen (Leistung auskoppeln). Vorgang mit C<sub>1</sub> und C<sub>2</sub> wechselweise mehrmals wiederholen bis die maximale Ausgangsleistung erreicht ist. Nach dem Abstimmvorgang sollte ein Dip von etwa 10 % verbleiben.', ' ');
INSERT INTO answer VALUES (4002, 1001, 1, 'C<sub>1</sub> und C<sub>2</sub> auf minimale Kapazität stellen. C2 auf Dip im Anodenstrom (Resonanz) stellen, dann mit C<sub>1</sub> einen etwas höheren Anodenstrom einstellen (Leistung auskoppeln). Vorgang mit C<sub>1</sub> und C<sub>2</sub> wechselweise mehrmals wiederholen bis die maximale Ausgangsleistung erreicht ist. Nach dem Abstimmvorgang sollte ein Dip von etwa 20 % verbleiben.', ' ');
INSERT INTO answer VALUES (4003, 1001, 2, 'C<sub>1</sub> und C<sub>2</sub> auf maximale Kapazität stellen. C1 auf Dip im Anodenstrom (Resonanz) stellen, dann mit C<sub>2</sub> einen etwas niedrigeren Anodenstrom einstellen (Leistung einkoppeln). Vorgang mit C<sub>1</sub> und C<sub>2</sub> wechselweise mehrmals wiederholen bis die maximale Oberwellenleistung erreicht ist. Nach dem Abstimmvorgang sollte ein Dip von etwa 10 % verbleiben.', ' ');
INSERT INTO answer VALUES (4004, 1001, 3, 'C<sub>1</sub> und C<sub>2</sub> auf minimale Kapazität stellen. C2 auf maximalen Anodenstrom (Resonanz) stellen, dann mit C<sub>1</sub> einen etwas niedrigeren Anodenstrom (Dip) einstellen. Vorgang so oft wiederholen bis die maximale Ausgangsleistung erreicht ist. Nach dem Abstimmvorgang sollte ein Dip von etwa 20 % verbleiben.', ' ');
INSERT INTO answer VALUES (4005, 1002, 0, 'als Katodenwiderstand zur Erzeugung einer negativen Gittervorspannung.', ' ');
INSERT INTO answer VALUES (4006, 1002, 1, 'zur Bedämpfung des Eingangskreises um Schwingneigung zu verhindern.', ' ');
INSERT INTO answer VALUES (4007, 1002, 2, 'als Vorwiderstand für den Heizfaden.', ' ');
INSERT INTO answer VALUES (4008, 1002, 3, 'zur Ableitung von Störeinflüssen durch die Heizspannung.', ' ');
INSERT INTO answer VALUES (4009, 1003, 0, 'Durch eine Konstantspannungsquelle', ' ');
INSERT INTO answer VALUES (4010, 1003, 1, 'Durch eine Konstantstromquelle', ' ');
INSERT INTO answer VALUES (4011, 1003, 2, 'Durch mehrere Siliziumdioden in Sperrrichtung', ' ');
INSERT INTO answer VALUES (4012, 1003, 3, 'Durch nichts, da R<sub>1</sub> ohnehin überflüssig ist', ' ');
INSERT INTO answer VALUES (4013, 1004, 0, 'Leiser ins Mikrofon sprechen', ' ');
INSERT INTO answer VALUES (4014, 1004, 1, 'Mehr Leistung verwenden', ' ');
INSERT INTO answer VALUES (4015, 1004, 2, 'Weniger Leistung verwenden', ' ');
INSERT INTO answer VALUES (4016, 1004, 3, 'Lauter ins Mikrofon sprechen', ' ');
INSERT INTO answer VALUES (4017, 1005, 0, 'USB, LSB, FM, RTTY, CW', ' ');
INSERT INTO answer VALUES (4018, 1005, 1, 'USB, PSK31, FM, SSTV, CW', ' ');
INSERT INTO answer VALUES (4019, 1005, 2, 'USB, LSB, FM, SSTV, CW', ' ');
INSERT INTO answer VALUES (4020, 1005, 3, 'USB, LSB, Amtor, Pactor, CW', ' ');
INSERT INTO answer VALUES (4021, 1006, 0, 'die RIT bedienen.', ' ');
INSERT INTO answer VALUES (4022, 1006, 1, 'das Notchfilter einschalten.', ' ');
INSERT INTO answer VALUES (4023, 1006, 2, 'das Passband-Tuning verstellen.', ' ');
INSERT INTO answer VALUES (4024, 1006, 3, 'die PTT einschalten.', ' ');
INSERT INTO answer VALUES (4025, 1007, 0, 'PTT', ' ');
INSERT INTO answer VALUES (4026, 1007, 1, 'VOX', ' ');
INSERT INTO answer VALUES (4027, 1007, 2, 'RIT', ' ');
INSERT INTO answer VALUES (4028, 1007, 3, 'SSB', ' ');
INSERT INTO answer VALUES (4029, 1008, 0, 'VOX-Betrieb', ' ');
INSERT INTO answer VALUES (4030, 1008, 1, 'PTT-Betrieb', ' ');
INSERT INTO answer VALUES (4031, 1008, 2, 'RIT-Betrieb', ' ');
INSERT INTO answer VALUES (4032, 1008, 3, 'SSB-Betrieb', ' ');
INSERT INTO answer VALUES (4033, 1009, 0, 'den Squelch.', ' ');
INSERT INTO answer VALUES (4034, 1009, 1, 'die VOX.', ' ');
INSERT INTO answer VALUES (4035, 1009, 2, 'die RIT.', ' ');
INSERT INTO answer VALUES (4036, 1009, 3, 'das Passband-Tuning.', ' ');
INSERT INTO answer VALUES (4037, 1010, 0, 'Durch zu steile Flanken der Tastimpulse', ' ');
INSERT INTO answer VALUES (4038, 1010, 1, 'Durch eine instabile Stromversorgung', ' ');
INSERT INTO answer VALUES (4039, 1010, 2, 'Durch zu geringe Aussteuerung des Senders', ' ');
INSERT INTO answer VALUES (4040, 1010, 3, 'Durch falsche Abstimmung der Pufferstufe', ' ');
INSERT INTO answer VALUES (4041, 1011, 0, 'Es werden mehr Nebenprodukte der Sendefrequenz erzeugt, die als unerwünschte Ausstrahlung Störungen hervorrufen.', ' ');
INSERT INTO answer VALUES (4042, 1011, 1, 'Die Gleichspannungskomponente des Ausgangssignals erhöht sich, wodurch der Wirkungsgrad des Senders abnimmt.', ' ');
INSERT INTO answer VALUES (4043, 1011, 2, 'Es werden mehr Subharmonische der Sendefrequenz erzeugt, die als unerwünschte Ausstrahlung Splattern auf den benachbarten Frequenzen hervorrufen.', ' ');
INSERT INTO answer VALUES (4044, 1011, 3, 'Es werden mehr Oberwellen der Sendefrequenz erzeugt, die als unerwünschte Ausstrahlung Splattern auf den benachbarten Frequenzen hervorrufen.', ' ');
INSERT INTO answer VALUES (4045, 1012, 0, 'Durch Aufstecken einer Ferritperle auf die Emitterzuleitung des Endstufentransistors.', ' ');
INSERT INTO answer VALUES (4046, 1012, 1, 'Durch Anbringen eines Klappferritkerns an der Mikrofonzuleitung.', ' ');
INSERT INTO answer VALUES (4047, 1012, 2, 'Durch Aufkleben einer Ferritperle auf das Gehäuse des Endstufentransistors.', ' ');
INSERT INTO answer VALUES (4048, 1012, 3, 'Durch Anbringen eines Klappferritkerns an der Stromversorgungszuleitung.', ' ');
INSERT INTO answer VALUES (4049, 1013, 0, 'Als Verhältnis der HF-Ausgangsleistung zu der zugeführten Gleichstromleistung.', ' ');
INSERT INTO answer VALUES (4050, 1013, 1, 'Als Verhältnis der Stärke der erwünschten Aussendung zur Stärke der unerwünschten Aussendungen.', ' ');
INSERT INTO answer VALUES (4051, 1013, 2, 'Als Verhältnis der HF-Leistung zu der Verlustleistung der Endstufenröhre bzw. des Endstufentransistors.', ' ');
INSERT INTO answer VALUES (4052, 1013, 3, 'Als Erhöhung der Ausgangsleistung in der Endstufe bezogen auf die Eingangsleistung.', ' ');
INSERT INTO answer VALUES (4053, 1014, 0, 'Durch mögliche Aussendungen außerhalb der Bandgrenzen.', ' ');
INSERT INTO answer VALUES (4054, 1014, 1, 'Durch Spannungsüberschläge in der Endstufe des Senders.', ' ');
INSERT INTO answer VALUES (4055, 1014, 2, 'Durch Überlastung der Endstufe des Senders.', ' ');
INSERT INTO answer VALUES (4056, 1014, 3, 'Durch überhöhte Stromentnahme aus der Stromversorgungsquelle.', ' ');
INSERT INTO answer VALUES (4057, 1015, 0, 'Um möglichst sparsam mit der Bandbreite umzugehen.', ' ');
INSERT INTO answer VALUES (4058, 1015, 1, 'Um die Oberwellen zu verringern.', ' ');
INSERT INTO answer VALUES (4059, 1015, 2, 'Um die Sendeleistung zu reduzieren.', ' ');
INSERT INTO answer VALUES (4060, 1015, 3, 'Um die Gefahr der Selbsterregung zu verringern.', ' ');
INSERT INTO answer VALUES (4061, 1016, 0, 'Durch die Verringerung der NF-Ansteuerung und/oder durch Einfügung eines Dämpfungsgliedes zwischen Treiberstufe und Endstufe.', ' ');
INSERT INTO answer VALUES (4062, 1016, 1, 'Durch die Veränderung des Arbeitspunktes der Endstufe.', ' ');
INSERT INTO answer VALUES (4063, 1016, 2, 'Durch die Verringerung des Hubes und/oder durch Einfügung eines Dämpfungsgliedes zwischen Steuersender und Endstufe.', ' ');
INSERT INTO answer VALUES (4064, 1016, 3, 'Nur durch Verringerung des Hubes allein.', ' ');
INSERT INTO answer VALUES (4065, 1017, 0, 'Im C-Betrieb', ' ');
INSERT INTO answer VALUES (4066, 1017, 1, 'Im A-Betrieb', ' ');
INSERT INTO answer VALUES (4067, 1017, 2, 'Im B-Betrieb', ' ');
INSERT INTO answer VALUES (4068, 1017, 3, 'Im AB-Betrieb', ' ');
INSERT INTO answer VALUES (4069, 1018, 0, 'Ein Tiefpassfilter', ' ');
INSERT INTO answer VALUES (4070, 1018, 1, 'Ein Hochpassfilter', ' ');
INSERT INTO answer VALUES (4071, 1018, 2, 'Ein Antennenfilter', ' ');
INSERT INTO answer VALUES (4072, 1018, 3, 'Ein Sperrkreisfilter', ' ');
INSERT INTO answer VALUES (4073, 1019, 0, 'Leiser ins Mikrofon sprechen', ' ');
INSERT INTO answer VALUES (4074, 1019, 1, 'Mehr Leistung verwenden', ' ');
INSERT INTO answer VALUES (4075, 1019, 2, 'Weniger Leistung verwenden', ' ');
INSERT INTO answer VALUES (4076, 1019, 3, 'Lauter ins Mikrofon sprechen', ' ');
INSERT INTO answer VALUES (4077, 1020, 0, 'höchstens 3 kHz betragen.', ' ');
INSERT INTO answer VALUES (4078, 1020, 1, 'höchstens 5 kHz betragen.', ' ');
INSERT INTO answer VALUES (4079, 1020, 2, 'höchstens 10 kHz betragen.', ' ');
INSERT INTO answer VALUES (4080, 1020, 3, 'höchstens 15 kHz betragen.', ' ');
INSERT INTO answer VALUES (4081, 1021, 0, 'Ein Sperrkreis am Senderausgang', ' ');
INSERT INTO answer VALUES (4082, 1021, 1, 'Eine Gegentaktendstufe', ' ');
INSERT INTO answer VALUES (4083, 1021, 2, 'Ein Hochpassfilter am Senderausgang', ' ');
INSERT INTO answer VALUES (4084, 1021, 3, 'Ein Hochpassfilter am Eingang der Senderendstufe', ' ');
INSERT INTO answer VALUES (4085, 1022, 0, '<p><img src=''tg513a.png''></p>', ' ');
INSERT INTO answer VALUES (4086, 1022, 1, '<p><img src=''tg513b.png''></p>', ' ');
INSERT INTO answer VALUES (4087, 1022, 2, '<p><img src=''tg513c.png''></p>', ' ');
INSERT INTO answer VALUES (4088, 1022, 3, '<p><img src=''tg513d.png''></p>', ' ');
INSERT INTO answer VALUES (4089, 1023, 0, 'sollte jede Stufe gut abgeschirmt sein.', ' ');
INSERT INTO answer VALUES (4090, 1023, 1, 'sollten die Abschirmungen der einzelnen Stufen nicht miteinander verbunden werden.', ' ');
INSERT INTO answer VALUES (4091, 1023, 2, 'sollten die Betriebsspannungen den einzelnen Stufen mit koaxialen oder verdrillten Leitungen zugeführt werden.', ' ');
INSERT INTO answer VALUES (4092, 1023, 3, 'sollte jede Stufe eine eigene stabilisierte Stromversorgung haben.', ' ');
INSERT INTO answer VALUES (4093, 1024, 0, 'parasitäre Schwingungen.', ' ');
INSERT INTO answer VALUES (4094, 1024, 1, 'die Stromversorgung.', ' ');
INSERT INTO answer VALUES (4095, 1024, 2, 'Temperaturschwankungen im Netzteil.', ' ');
INSERT INTO answer VALUES (4096, 1024, 3, 'vom Wind verursachte Bewegungen der Antenne.', ' ');
INSERT INTO answer VALUES (4097, 1025, 0, 'sollten die Ein- und Ausgangsschaltungen gut voneinander entkoppelt werden.', ' ');
INSERT INTO answer VALUES (4098, 1025, 1, 'sollte Verstärkerausgang und Netzteil möglichst weit voneinander entfernt aufgebaut werden.', ' ');
INSERT INTO answer VALUES (4099, 1025, 2, 'sollte die Versorgungsspannung über ein Netzfilter zugeführt werden.', ' ');
INSERT INTO answer VALUES (4100, 1025, 3, 'sollte kein Schaltnetzteil als Stromversorgung verwendet werden.', ' ');
INSERT INTO answer VALUES (4101, 1026, 0, 'Die zweite Harmonische', ' ');
INSERT INTO answer VALUES (4102, 1026, 1, 'Die dritte Harmonische', ' ');
INSERT INTO answer VALUES (4103, 1026, 2, 'Die vierte Harmonische', ' ');
INSERT INTO answer VALUES (4104, 1026, 3, 'Die fünfte Harmonische', ' ');
INSERT INTO answer VALUES (4105, 1027, 0, 'MW-Bereich auftreten.', ' ');
INSERT INTO answer VALUES (4106, 1027, 1, 'FM-Rundfunkbereich auftreten.', ' ');
INSERT INTO answer VALUES (4107, 1027, 2, 'LW-Bereich auftreten.', ' ');
INSERT INTO answer VALUES (4108, 1027, 3, '10-m-Amateurfunkband auftreten.', ' ');
INSERT INTO answer VALUES (4109, 1028, 0, 'in eine künstliche 50-&Omega;-Antenne eingespeist werden.', ' ');
INSERT INTO answer VALUES (4110, 1028, 1, 'in eine Antenne eingespeist werden.', ' ');
INSERT INTO answer VALUES (4111, 1028, 2, 'in einen Kondensator mit einem Blindwiderstand von 50 &Omega; eingespeist werden.', ' ');
INSERT INTO answer VALUES (4112, 1028, 3, 'in einen 50-&Omega;-Drahtwiderstand eingespeist werden.', ' ');
INSERT INTO answer VALUES (4113, 1029, 0, '<p><img src=''tg520a.png''></p>', ' ');
INSERT INTO answer VALUES (4114, 1029, 1, '<p><img src=''tg520b.png''></p>', ' ');
INSERT INTO answer VALUES (4115, 1029, 2, '<p><img src=''tg520c.png''></p>', ' ');
INSERT INTO answer VALUES (4116, 1029, 3, '<p><img src=''tg520d.png''></p>', ' ');
INSERT INTO answer VALUES (4117, 1030, 0, 'den FM-Rundfunkbereich.', ' ');
INSERT INTO answer VALUES (4118, 1030, 1, 'den VHF-Fernsehbereich.', ' ');
INSERT INTO answer VALUES (4119, 1030, 2, 'den UKW-Betriebsfunk-Bereich.', ' ');
INSERT INTO answer VALUES (4120, 1030, 3, 'den 2-m-Amateurfunkbereich.', ' ');
INSERT INTO answer VALUES (4121, 1031, 0, 'den geltenden Richtwerten entsprechen.', ' ');
INSERT INTO answer VALUES (4122, 1031, 1, '30 dB betragen.', ' ');
INSERT INTO answer VALUES (4123, 1031, 2, '100 dB betragen.', ' ');
INSERT INTO answer VALUES (4124, 1031, 3, '20 dB betragen.', ' ');
INSERT INTO answer VALUES (4125, 1032, 0, '0,25 µW überschreitet, sollte sie um mindestens 40 dB gegenüber der maximalen PEP des Senders gedämpft werden.', ' ');
INSERT INTO answer VALUES (4126, 1032, 1, '0,25 µW überschreitet, sollte sie um mindestens 60 dB gegenüber der maximalen PEP des Senders gedämpft werden.', ' ');
INSERT INTO answer VALUES (4127, 1032, 2, '1 µW überschreitet, sollte sie um mindestens 60 dB gegenüber der maximalen PEP des Senders gedämpft werden.', ' ');
INSERT INTO answer VALUES (4128, 1032, 3, '1 µW überschreitet, sollte sie um mindestens 50 dB gegenüber der maximalen PEP des Senders gedämpft werden.', ' ');
INSERT INTO answer VALUES (4129, 1033, 0, '0,25 µW überschreitet, sollte sie um mindestens 60 dB gegenüber der maximalen PEP des Senders gedämpft werden.', ' ');
INSERT INTO answer VALUES (4130, 1033, 1, '0,25 µW überschreitet, sollte sie um mindestens 40 dB gegenüber der maximalen PEP des Senders gedämpft werden.', ' ');
INSERT INTO answer VALUES (4131, 1033, 2, '1 µW überschreitet, sollte sie um mindestens 60 dB gegenüber der maximalen PEP des Senders gedämpft werden.', ' ');
INSERT INTO answer VALUES (4132, 1033, 3, '1 µW überschreitet, sollte sie um mindestens 50 dB gegenüber der maximalen PEP des Senders gedämpft werden.', ' ');
INSERT INTO answer VALUES (4133, 1034, 0, 'Die Messung erfolgt am Senderausgang unter Einbeziehung des gegebenenfalls verwendeten Stehwellenmessgeräts und des gegebenenfalls verwendeten Tiefpassfilters.', ' ');
INSERT INTO answer VALUES (4134, 1034, 1, 'Die Messung erfolgt am Fußpunkt der im Funkbetrieb verwendeten Antenne unter Einbeziehung des gegebenenfalls verwendeten Antennenanpassgeräts.', ' ');
INSERT INTO answer VALUES (4135, 1034, 2, 'Die Messung erfolgt am Ausgang der Antennenleitung unter Einbeziehung des im Funkbetrieb verwendeten Antennenanpassgeräts.', ' ');
INSERT INTO answer VALUES (4136, 1034, 3, 'Die Messung erfolgt am Senderausgang mit einem hochohmigen HF-Tastkopf und angeschlossenem Transistorvoltmeter.', ' ');
INSERT INTO answer VALUES (4137, 1035, 0, 'Die elektrische Länge muss ein ganzzahliges Vielfaches von &lambda;/2 betragen (n * &lambda;/2, n=1,2,3...).', ' ');
INSERT INTO answer VALUES (4138, 1035, 1, 'Die elektrische Länge muss ein ganzzahliges Vielfaches von &lambda;/4 betragen (n * &lambda;/4, n=1,2,3...).', ' ');
INSERT INTO answer VALUES (4139, 1035, 2, 'Die elektrische Länge muss 5/8*&lambda;, &lambda;/4 oder deren ganzzahlige Vielfache betragen.', ' ');
INSERT INTO answer VALUES (4140, 1035, 3, 'Die elektrische Länge muss ein ganzzahliges Vielfaches von &lambda; betragen (n * &lambda;, n=1,2,3...).', ' ');
INSERT INTO answer VALUES (4141, 1036, 0, 'An den Enden eines Dipols entsteht immer ein Stromknoten und ein Spannungsbauch.', ' ');
INSERT INTO answer VALUES (4142, 1036, 1, 'An den Enden eines Dipols entsteht immer ein Spannungsknoten und ein Strombauch.', ' ');
INSERT INTO answer VALUES (4143, 1036, 2, 'Am Einspeisepunkt eines Dipols entsteht immer ein Spannungsknoten und ein Strombauch.', ' ');
INSERT INTO answer VALUES (4144, 1036, 3, 'Am Einspeisepunkt eines Dipols entsteht immer ein Spannungsbauch und ein Stromknoten.', ' ');
INSERT INTO answer VALUES (4145, 1037, 0, 'ein Spannungsknoten und ein Strombauch liegt. Er ist daher niederohmig.', ' ');
INSERT INTO answer VALUES (4146, 1037, 1, 'ein Spannungsbauch und ein Stromknoten liegt. Er ist daher hochohmig.', ' ');
INSERT INTO answer VALUES (4147, 1037, 2, 'ein Spannungs- und ein Strombauch liegt. Er ist daher niederohmig.', ' ');
INSERT INTO answer VALUES (4148, 1037, 3, 'ein Spannungs- und ein Stromknoten liegt. Er ist daher hochohmig.', ' ');
INSERT INTO answer VALUES (4149, 1038, 0, 'ein Spannungsbauch und ein Stromknoten liegt. Er ist daher hochohmig.', ' ');
INSERT INTO answer VALUES (4150, 1038, 1, 'ein Spannungsknoten und ein Strombauch liegt. Er ist daher niederohmig.', ' ');
INSERT INTO answer VALUES (4151, 1038, 2, 'ein Spannungs- und ein Strombauch liegt. Er ist daher niederohmig.', ' ');
INSERT INTO answer VALUES (4152, 1038, 3, 'ein Spannungs- und ein Stromknoten liegt. Er ist daher hochohmig.', ' ');
INSERT INTO answer VALUES (4153, 1039, 0, 'stromgespeist, in Serienresonanz und am Eingang niederohmig.', ' ');
INSERT INTO answer VALUES (4154, 1039, 1, 'spannungsgespeist, in Parallelresonanz und am Eingang hochohmig.', ' ');
INSERT INTO answer VALUES (4155, 1039, 2, 'strom- und spannungsgespeist und weist einen rein kapazitiven Eingangswiderstand auf.', ' ');
INSERT INTO answer VALUES (4156, 1039, 3, 'strom- und spannungsgespeist und weist einen rein induktiven Eingangswiderstand auf.', ' ');
INSERT INTO answer VALUES (4157, 1040, 0, 'spannungsgespeist, in Parallelresonanz und am Eingang hochohmig.', ' ');
INSERT INTO answer VALUES (4158, 1040, 1, 'stromgespeist, in Serienresonanz und am Eingang niederohmig.', ' ');
INSERT INTO answer VALUES (4159, 1040, 2, 'strom- und spannungsgespeist und weist einen rein kapazitiven Eingangswiderstand auf.', ' ');
INSERT INTO answer VALUES (4160, 1040, 3, 'strom- und spannungsgespeist und weist einen rein induktiven Eingangswiderstand auf.', ' ');
INSERT INTO answer VALUES (4161, 1041, 0, 'im Wesentlichen als reeller Widerstand.', ' ');
INSERT INTO answer VALUES (4162, 1041, 1, 'im Wesentlichen als kapazitiver Blindwiderstand.', ' ');
INSERT INTO answer VALUES (4163, 1041, 2, 'im Wesentlichen als induktiver Blindwiderstand.', ' ');
INSERT INTO answer VALUES (4164, 1041, 3, 'abwechselnd als kapazitiver oder induktiver Blindwiderstand.', ' ');
INSERT INTO answer VALUES (4165, 1042, 0, 'Sie gilt für eine Erregung auf 28 MHz.', ' ');
INSERT INTO answer VALUES (4166, 1042, 1, 'Sie gilt für eine Erregung auf 14 MHz.', ' ');
INSERT INTO answer VALUES (4167, 1042, 2, 'Sie gilt für eine Erregung auf 7 MHz.', ' ');
INSERT INTO answer VALUES (4168, 1042, 3, 'Sie gilt für eine Erregung auf 3,5 MHz.', ' ');
INSERT INTO answer VALUES (4169, 1043, 0, 'Sie gilt für eine Erregung auf 14 MHz.', ' ');
INSERT INTO answer VALUES (4170, 1043, 1, 'Sie gilt für eine Erregung auf 28 MHz.', ' ');
INSERT INTO answer VALUES (4171, 1043, 2, 'Sie gilt für eine Erregung auf 7 MHz.', ' ');
INSERT INTO answer VALUES (4172, 1043, 3, 'Sie gilt für eine Erregung auf 3,5 MHz.', ' ');
INSERT INTO answer VALUES (4173, 1044, 0, 'Sie gilt für eine Erregung auf 7 MHz.', ' ');
INSERT INTO answer VALUES (4174, 1044, 1, 'Sie gilt für eine Erregung auf 28 MHz.', ' ');
INSERT INTO answer VALUES (4175, 1044, 2, 'Sie gilt für eine Erregung auf 14 MHz.', ' ');
INSERT INTO answer VALUES (4176, 1044, 3, 'Sie gilt für eine Erregung auf 3,5 MHz.', ' ');
INSERT INTO answer VALUES (4177, 1045, 0, 'Sie gilt für eine Erregung auf 3,5 MHz.', ' ');
INSERT INTO answer VALUES (4178, 1045, 1, 'Sie gilt für eine Erregung auf 28 MHz.', ' ');
INSERT INTO answer VALUES (4179, 1045, 2, 'Sie gilt für eine Erregung auf 7 MHz.', ' ');
INSERT INTO answer VALUES (4180, 1045, 3, 'Sie gilt für eine Erregung auf 14 MHz.', ' ');
INSERT INTO answer VALUES (4181, 1046, 0, 'einen Halbwellendipol.', ' ');
INSERT INTO answer VALUES (4182, 1046, 1, 'eine Richtstrahlantenne mit zwei Elementen.', ' ');
INSERT INTO answer VALUES (4183, 1046, 2, 'eine Ganzwellenantenne.', ' ');
INSERT INTO answer VALUES (4184, 1046, 3, 'eine Drei-Halbwellenlängen-Antenne.', ' ');
INSERT INTO answer VALUES (4185, 1047, 0, '75 &Omega;.', ' ');
INSERT INTO answer VALUES (4186, 1047, 1, '50 &Omega;.', ' ');
INSERT INTO answer VALUES (4187, 1047, 2, '30 &Omega;.', ' ');
INSERT INTO answer VALUES (4188, 1047, 3, '600 &Omega;.', ' ');
INSERT INTO answer VALUES (4189, 1048, 0, '240 &Omega;.', ' ');
INSERT INTO answer VALUES (4190, 1048, 1, '60 &Omega;.', ' ');
INSERT INTO answer VALUES (4191, 1048, 2, '50 &Omega;.', ' ');
INSERT INTO answer VALUES (4192, 1048, 3, '30-60 &Omega;.', ' ');
INSERT INTO answer VALUES (4193, 1049, 0, 'einer Wellenlänge.', ' ');
INSERT INTO answer VALUES (4194, 1049, 1, 'einer Halbwellenlänge.', ' ');
INSERT INTO answer VALUES (4195, 1049, 2, 'zwei Wellenlängen.', ' ');
INSERT INTO answer VALUES (4196, 1049, 3, 'vier Wellenlängen.', ' ');
INSERT INTO answer VALUES (4197, 1050, 0, 'erlaubt eine Anpassung für mindestens zwei Frequenzbereiche.', ' ');
INSERT INTO answer VALUES (4198, 1050, 1, 'erhöht die effiziente Nutzung des jeweiligen Frequenzbereichs.', ' ');
INSERT INTO answer VALUES (4199, 1050, 2, 'ermöglicht eine breitbandigere Anpassung.', ' ');
INSERT INTO answer VALUES (4200, 1050, 3, 'ermöglicht die Unterdrückung der Harmonischen.', ' ');
INSERT INTO answer VALUES (4201, 1051, 0, 'Dipol, Delta-Loop, W3DZZ-Antenne', ' ');
INSERT INTO answer VALUES (4202, 1051, 1, 'Beam, Groundplane-Antenne, Dipol', ' ');
INSERT INTO answer VALUES (4203, 1051, 2, 'Dipol, W3DZZ-Antenne, Beam', ' ');
INSERT INTO answer VALUES (4204, 1051, 3, 'Dipol, Delta-Loop, Langyagi', ' ');
INSERT INTO answer VALUES (4205, 1052, 0, 'Delta-Loop, Rhombus-Antenne, Groundplane', ' ');
INSERT INTO answer VALUES (4206, 1052, 1, 'Beam, Groundplane-Antenne, Hornstrahler', ' ');
INSERT INTO answer VALUES (4207, 1052, 2, 'Helical-Antenne, Rhombus-Antenne, Hornstrahler', ' ');
INSERT INTO answer VALUES (4208, 1052, 3, 'Parabolantenne, Windom-Antenne, Langyagi', ' ');
INSERT INTO answer VALUES (4209, 1053, 0, 'Langdraht-Antenne, Groundplane-Antenne, Yagiantenne, Dipolantenne, Rhombus-Antenne, Cubical-Quad-Antenne, Windom-Antenne, Delta-Loop-Antenne', ' ');
INSERT INTO answer VALUES (4210, 1053, 1, 'Langdraht-Antenne, Backfire-Antenne, Dipolantenne, Rhombus-Antenne, Helical-Antenne, Groundplane-Antenne, Doppelquad, Malteserkreuzantenne, Winkelreflektorantenne', ' ');
INSERT INTO answer VALUES (4211, 1053, 2, 'Groundplane-Antenne, W3DZZ-Dipolantenne, Langyagi, Rhombus-Antenne, Kugelstrahler, Big Wheel-Antenne, J-Antenne, Ferritantenne, Schlitzantennen, Kreuzyagi-Antenne', ' ');
INSERT INTO answer VALUES (4212, 1053, 3, 'Dipolantenne, Rhombus-Antenne, Cubical-Quad-Antenne, Discone-Antenne, HB9CV-Antenne, Hornstrahler, J-Antenne, Sperrtopf, Parabolspiegel', ' ');
INSERT INTO answer VALUES (4213, 1054, 0, 'Langdraht-Antennen', ' ');
INSERT INTO answer VALUES (4214, 1054, 1, 'Yagi-Antennen', ' ');
INSERT INTO answer VALUES (4215, 1054, 2, 'Parabolantennen', ' ');
INSERT INTO answer VALUES (4216, 1054, 3, 'Schlitz-Antennen', ' ');
INSERT INTO answer VALUES (4217, 1055, 0, 'Groundplane', ' ');
INSERT INTO answer VALUES (4218, 1055, 1, 'Faltdipol', ' ');
INSERT INTO answer VALUES (4219, 1055, 2, 'Yagi', ' ');
INSERT INTO answer VALUES (4220, 1055, 3, '&lambda;/2-Dipol', ' ');
INSERT INTO answer VALUES (4221, 1056, 0, 'eine gegen Erde erregte &lambda;/4-Vertikalantenne.', ' ');
INSERT INTO answer VALUES (4222, 1056, 1, 'eine Groundplane-Antenne mit abgestimmten Radials.', ' ');
INSERT INTO answer VALUES (4223, 1056, 2, 'eine horizontale &lambda;/2-Langdrahtantenne.', ' ');
INSERT INTO answer VALUES (4224, 1056, 3, 'eine vertikale Halbwellenantenne.', ' ');
INSERT INTO answer VALUES (4225, 1057, 0, '5/8 &lambda;', ' ');
INSERT INTO answer VALUES (4226, 1057, 1, '&lambda;/4', ' ');
INSERT INTO answer VALUES (4227, 1057, 2, '&lambda;/2', ' ');
INSERT INTO answer VALUES (4228, 1057, 3, '3/4 &lambda;', ' ');
INSERT INTO answer VALUES (4229, 1058, 0, 'einen flachen Abstrahlwinkel.', ' ');
INSERT INTO answer VALUES (4230, 1058, 1, 'zirkulare Polarisation.', ' ');
INSERT INTO answer VALUES (4231, 1058, 2, 'einen hohen Abstrahlwinkel.', ' ');
INSERT INTO answer VALUES (4232, 1058, 3, 'elliptische Polarisation.', ' ');
INSERT INTO answer VALUES (4233, 1059, 0, 'Langdrahtantenne', ' ');
INSERT INTO answer VALUES (4234, 1059, 1, 'Koaxialgespeiste Doppel-Windom-Antenne', ' ');
INSERT INTO answer VALUES (4235, 1059, 2, 'Dipolantenne', ' ');
INSERT INTO answer VALUES (4236, 1059, 3, 'Groundplane-Antenne', ' ');
INSERT INTO answer VALUES (4237, 1060, 0, '95 %', ' ');
INSERT INTO answer VALUES (4238, 1060, 1, '75 %', ' ');
INSERT INTO answer VALUES (4239, 1060, 2, '66 %', ' ');
INSERT INTO answer VALUES (4240, 1060, 3, '100 %', ' ');
INSERT INTO answer VALUES (4241, 1061, 0, 'Spule', ' ');
INSERT INTO answer VALUES (4242, 1061, 1, 'Parallelkreis mit einer Resonanzfrequenz von 3,5 MHz', ' ');
INSERT INTO answer VALUES (4243, 1061, 2, 'Kondensator', ' ');
INSERT INTO answer VALUES (4244, 1061, 3, 'RC-Glied', ' ');
INSERT INTO answer VALUES (4245, 1062, 0, 'Sie wird Zeppelin-Antenne genannt.', ' ');
INSERT INTO answer VALUES (4246, 1062, 1, 'Sie wird Windom-Antenne genannt.', ' ');
INSERT INTO answer VALUES (4247, 1062, 2, 'Sie wird Fuchs-Antenne genannt.', ' ');
INSERT INTO answer VALUES (4248, 1062, 3, 'Sie wird Marconi-Antenne genannt.', ' ');
INSERT INTO answer VALUES (4249, 1063, 0, 'Sie wird G5RV-Antenne genannt.', ' ');
INSERT INTO answer VALUES (4250, 1063, 1, 'Sie wird Windom-Antenne genannt.', ' ');
INSERT INTO answer VALUES (4251, 1063, 2, 'Sie wird Fuchs-Antenne genannt.', ' ');
INSERT INTO answer VALUES (4252, 1063, 3, 'Sie wird Zeppelin-Antenne genannt.', ' ');
INSERT INTO answer VALUES (4253, 1064, 0, 'Sie wird Windom-Antenne genannt.', ' ');
INSERT INTO answer VALUES (4254, 1064, 1, 'Sie wird Fuchs-Antenne genannt.', ' ');
INSERT INTO answer VALUES (4255, 1064, 2, 'Sie wird Zeppelin-Antenne genannt.', ' ');
INSERT INTO answer VALUES (4256, 1064, 3, 'Sie wird Marconi-Antenne genannt.', ' ');
INSERT INTO answer VALUES (4257, 1065, 0, 'Sie wird Fuchs-Antenne genannt.', ' ');
INSERT INTO answer VALUES (4258, 1065, 1, 'Sie wird Windom-Antenne genannt.', ' ');
INSERT INTO answer VALUES (4259, 1065, 2, 'Sie wird G5RV-Antenne genannt.', ' ');
INSERT INTO answer VALUES (4260, 1065, 3, 'Sie wird Zeppelin-Antenne genannt.', ' ');
INSERT INTO answer VALUES (4261, 1066, 0, 'Trap-Dipol', ' ');
INSERT INTO answer VALUES (4262, 1066, 1, 'Einband-Dipol mit Oberwellenfilter', ' ');
INSERT INTO answer VALUES (4263, 1066, 2, 'Feedergespeister einfacher Dipol mit Gleichwellenfilter', ' ');
INSERT INTO answer VALUES (4264, 1066, 3, 'Feedergespeiste Doppel-Quad', ' ');
INSERT INTO answer VALUES (4265, 1067, 0, 'als Sperrkreise für die Erregerfrequenz.', ' ');
INSERT INTO answer VALUES (4266, 1067, 1, 'wie eine induktive Verlängerung des Strahlers.', ' ');
INSERT INTO answer VALUES (4267, 1067, 2, 'wie eine kapazitive Verkürzung des Strahlers.', ' ');
INSERT INTO answer VALUES (4268, 1067, 3, 'wie eine Vergrößerung des Strahlungswiderstands der Antenne.', ' ');
INSERT INTO answer VALUES (4269, 1068, 0, 'wie eine induktive Verlängerung des Strahlers.', ' ');
INSERT INTO answer VALUES (4270, 1068, 1, 'als Sperrkreise für die Erregerfrequenz.', ' ');
INSERT INTO answer VALUES (4271, 1068, 2, 'wie eine kapazitive Verkürzung des Strahlers.', ' ');
INSERT INTO answer VALUES (4272, 1068, 3, 'wie eine Vergrößerung des Strahlungswiderstands der Antenne.', ' ');
INSERT INTO answer VALUES (4273, 1069, 0, 'wie eine kapazitive Verkürzung des Strahlers.', ' ');
INSERT INTO answer VALUES (4274, 1069, 1, 'als Sperrkreise für die Erregerfrequenz.', ' ');
INSERT INTO answer VALUES (4275, 1069, 2, 'wie eine induktive Verlängerung des Strahlers.', ' ');
INSERT INTO answer VALUES (4276, 1069, 3, 'wie eine Vergrößerung des Strahlungswiderstands der Antenne.', ' ');
INSERT INTO answer VALUES (4277, 1070, 0, '29,0 MHz abgestimmt.', ' ');
INSERT INTO answer VALUES (4278, 1070, 1, '10,1 MHz abgestimmt.', ' ');
INSERT INTO answer VALUES (4279, 1070, 2, '14,2 MHz abgestimmt.', ' ');
INSERT INTO answer VALUES (4280, 1070, 3, '21,2 MHz abgestimmt.', ' ');
INSERT INTO answer VALUES (4281, 1071, 0, '21,2 MHz abgestimmt.', ' ');
INSERT INTO answer VALUES (4282, 1071, 1, '10,1 MHz abgestimmt.', ' ');
INSERT INTO answer VALUES (4283, 1071, 2, '14,2 MHz abgestimmt.', ' ');
INSERT INTO answer VALUES (4284, 1071, 3, '29,0 MHz abgestimmt.', ' ');
INSERT INTO answer VALUES (4285, 1072, 0, '&lambda;/4-Groundplane mit Verkürzungskondensator', ' ');
INSERT INTO answer VALUES (4286, 1072, 1, '&lambda;/2-Groundplane mit &lambda;/4-Verkürzungskondensator', ' ');
INSERT INTO answer VALUES (4287, 1072, 2, '&lambda;/4-Sperrtopfantenne mit Verlängerungskondensator', ' ');
INSERT INTO answer VALUES (4288, 1072, 3, '&lambda;/4-Kreuzdipol mit kapazitiv verkürztem &lambda;/4-Vertikalstrahler', ' ');
INSERT INTO answer VALUES (4289, 1073, 0, 'Gegengewichte.', ' ');
INSERT INTO answer VALUES (4290, 1073, 1, 'künstliche Strahler.', ' ');
INSERT INTO answer VALUES (4291, 1073, 2, 'Parasitärstrahler.', ' ');
INSERT INTO answer VALUES (4292, 1073, 3, 'Blitzschutzelemente.', ' ');
INSERT INTO answer VALUES (4293, 1074, 0, 'einer Viertelwelle.', ' ');
INSERT INTO answer VALUES (4294, 1074, 1, 'einer Halbwelle.', ' ');
INSERT INTO answer VALUES (4295, 1074, 2, 'dreiviertel einer Wellenlänge.', ' ');
INSERT INTO answer VALUES (4296, 1074, 3, 'einer ganzen Wellenlänge.', ' ');
INSERT INTO answer VALUES (4297, 1075, 0, '1 Reflektor, 2 Strahler und 3 Direktor.', ' ');
INSERT INTO answer VALUES (4298, 1075, 1, '1 Strahler, 2 Direktor und 3 Reflektor.', ' ');
INSERT INTO answer VALUES (4299, 1075, 2, '1 Direktor, 2 Strahler und 3 Reflektor.', ' ');
INSERT INTO answer VALUES (4300, 1075, 3, '1 Direktor, 2 Reflektor und 3 Strahler.', ' ');
INSERT INTO answer VALUES (4301, 1076, 0, 'am Dipol.', ' ');
INSERT INTO answer VALUES (4302, 1076, 1, 'am Direktor.', ' ');
INSERT INTO answer VALUES (4303, 1076, 2, 'am Reflektor.', ' ');
INSERT INTO answer VALUES (4304, 1076, 3, 'an Dipol und Reflektor.', ' ');
INSERT INTO answer VALUES (4305, 1077, 0, 'verringert die Impedanz.', ' ');
INSERT INTO answer VALUES (4306, 1077, 1, 'erhöht die Impedanz.', ' ');
INSERT INTO answer VALUES (4307, 1077, 2, 'hat keinen Einfluss auf die Impedanz.', ' ');
INSERT INTO answer VALUES (4308, 1077, 3, 'verhindert Rückwärtsstrahlung.', ' ');
INSERT INTO answer VALUES (4309, 1078, 0, 'Keulenbreite verringert.', ' ');
INSERT INTO answer VALUES (4310, 1078, 1, 'Keulenbreite erhöht.', ' ');
INSERT INTO answer VALUES (4311, 1078, 2, 'Strahlungswiderstand erhöht.', ' ');
INSERT INTO answer VALUES (4312, 1078, 3, 'Vor-Rück-Verhältnis verringert.', ' ');
INSERT INTO answer VALUES (4313, 1079, 0, 'den Abständen zwischen den Direktoren und Reflektoren.', ' ');
INSERT INTO answer VALUES (4314, 1079, 1, 'dem Strahlungswiderstand des Reflektors.', ' ');
INSERT INTO answer VALUES (4315, 1079, 2, 'dem Widerstand des Zuführungskabels.', ' ');
INSERT INTO answer VALUES (4316, 1079, 3, 'den Ausbreitungsbedingungen.', ' ');
INSERT INTO answer VALUES (4317, 1080, 0, 'Sie geraten in Resonanz und strahlen einen Teil der aufgenommenen Leistung phasenverschoben wieder ab. Die dabei zusammenwirkenden Komponenten ermöglichen, dass die Abstrahlung in einer Richtung gebündelt wird.', ' ');
INSERT INTO answer VALUES (4318, 1080, 1, 'Sie sind in Wellenwiderstand und Länge so bemessen, dass sie als Phasenleitungen wirken. Dadurch kann bei der Zusammenschaltung von Antennen rechts- oder linksdrehende zirkulare Polarisation erzeugt werden.', ' ');
INSERT INTO answer VALUES (4319, 1080, 2, 'Sie geraten in Resonanz und strahlen einen Teil der aufgenommenen Leistung phasenverschoben wieder ab. Dies bewirkt die gleichmäßige Verteilung der Energie in alle Richtungen.', ' ');
INSERT INTO answer VALUES (4320, 1080, 3, 'Sie sind in Wellenwiderstand und Länge so bemessen, dass sie als Impedanztransformatoren wirken. Damit wird eine Zusammenschaltung mehrerer Antennen ermöglicht.', ' ');
INSERT INTO answer VALUES (4321, 1081, 0, 'eine Richtstrahlantenne.', ' ');
INSERT INTO answer VALUES (4322, 1081, 1, 'einen Halbwellendipol.', ' ');
INSERT INTO answer VALUES (4323, 1081, 2, 'einen Viertelwellenstrahler.', ' ');
INSERT INTO answer VALUES (4324, 1081, 3, 'eine Marconi-Antenne.', ' ');
INSERT INTO answer VALUES (4325, 1082, 0, '14 dB', ' ');
INSERT INTO answer VALUES (4326, 1082, 1, '27,9 dB', ' ');
INSERT INTO answer VALUES (4327, 1082, 2, '2,8 dB', ' ');
INSERT INTO answer VALUES (4328, 1082, 3, '25 dB', ' ');
INSERT INTO answer VALUES (4329, 1083, 0, '10 Watt', ' ');
INSERT INTO answer VALUES (4330, 1083, 1, '100 Watt', ' ');
INSERT INTO answer VALUES (4331, 1083, 2, '0,1 Watt', ' ');
INSERT INTO answer VALUES (4332, 1083, 3, '1 Watt', ' ');
INSERT INTO answer VALUES (4333, 1084, 0, '0,6 Watt', ' ');
INSERT INTO answer VALUES (4334, 1084, 1, '0,019 Watt', ' ');
INSERT INTO answer VALUES (4335, 1084, 2, '0,19 Watt', ' ');
INSERT INTO answer VALUES (4336, 1084, 3, '60 Watt', ' ');
INSERT INTO answer VALUES (4337, 1085, 0, 'einen Antennentuner oder ein Filter zu verwenden.', ' ');
INSERT INTO answer VALUES (4338, 1085, 1, 'mit einem hohen Stehwellenverhältnis zu arbeiten.', ' ');
INSERT INTO answer VALUES (4339, 1085, 2, 'die Gleichstrom-Speisespannung zu überwachen.', ' ');
INSERT INTO answer VALUES (4340, 1085, 3, 'eine Mehrbandantenne zu verwenden.', ' ');
INSERT INTO answer VALUES (4341, 1086, 0, 'Bei einem mit symmetrischer Speiseleitung mittengespeisten Dipol.', ' ');
INSERT INTO answer VALUES (4342, 1086, 1, 'Bei einem mit doppelt geschirmten Koaxialkabel mittengespeisten Dipol.', ' ');
INSERT INTO answer VALUES (4343, 1086, 2, 'Bei einer L-Antenne mit senkrechter Speiseleitung.', ' ');
INSERT INTO answer VALUES (4344, 1086, 3, 'Bei einer endgespeisten Langdrahtantenne mit direkt angeschlossener Speiseleitung.', ' ');
INSERT INTO answer VALUES (4345, 1087, 0, 'So hoch und weit weg wie möglich.', ' ');
INSERT INTO answer VALUES (4346, 1087, 1, 'An der Seitenwand zum Nachbarn.', ' ');
INSERT INTO answer VALUES (4347, 1087, 2, 'Auf dem Dach, wobei die Dachfläche des Nachbarn mit abgedeckt werden sollte.', ' ');
INSERT INTO answer VALUES (4348, 1087, 3, 'So niedrig und nah am Haus wie möglich.', ' ');
INSERT INTO answer VALUES (4349, 1088, 0, 'Strahler: 10,03 m, Radials: 10,03 m', ' ');
INSERT INTO answer VALUES (4350, 1088, 1, 'Strahler: 10,56 m, Radials: 21,13 m', ' ');
INSERT INTO answer VALUES (4351, 1088, 2, 'Strahler: 21,13 m, Radials: 10,56 m', ' ');
INSERT INTO answer VALUES (4352, 1088, 3, 'Strahler: 10,03 m, Radials: 20,07 m', ' ');
INSERT INTO answer VALUES (4353, 1089, 0, 'Je 10,03 m', ' ');
INSERT INTO answer VALUES (4354, 1089, 1, 'Je 10,56 m', ' ');
INSERT INTO answer VALUES (4355, 1089, 2, 'Je 20,07 m', ' ');
INSERT INTO answer VALUES (4356, 1089, 3, 'Je 21,13 m', ' ');
INSERT INTO answer VALUES (4357, 1090, 0, 'Je 5,02 m', ' ');
INSERT INTO answer VALUES (4358, 1090, 1, 'Je 10,56 m', ' ');
INSERT INTO answer VALUES (4359, 1090, 2, 'Je 10,03 m', ' ');
INSERT INTO answer VALUES (4360, 1090, 3, 'Je 5,28 m', ' ');
INSERT INTO answer VALUES (4361, 1091, 0, '7,12 MHz', ' ');
INSERT INTO answer VALUES (4362, 1091, 1, '6,77 MHz', ' ');
INSERT INTO answer VALUES (4363, 1091, 2, '7,50 MHz', ' ');
INSERT INTO answer VALUES (4364, 1091, 3, '7,00 MHz', ' ');
INSERT INTO answer VALUES (4365, 1092, 0, '6,78 MHz', ' ');
INSERT INTO answer VALUES (4366, 1092, 1, '7,14 MHz', ' ');
INSERT INTO answer VALUES (4367, 1092, 2, '7,51 MHz', ' ');
INSERT INTO answer VALUES (4368, 1092, 3, '7,00 MHz', ' ');
INSERT INTO answer VALUES (4369, 1093, 0, '40,14 m', ' ');
INSERT INTO answer VALUES (4370, 1093, 1, '42,25 m', ' ');
INSERT INTO answer VALUES (4371, 1093, 2, '20,07 m', ' ');
INSERT INTO answer VALUES (4372, 1093, 3, '21,13 m', ' ');
INSERT INTO answer VALUES (4373, 1094, 0, '12,80 m', ' ');
INSERT INTO answer VALUES (4374, 1094, 1, '13,20 m', ' ');
INSERT INTO answer VALUES (4375, 1094, 2, '10,03 m', ' ');
INSERT INTO answer VALUES (4376, 1094, 3, '13,61 m', ' ');
INSERT INTO answer VALUES (4377, 1095, 0, 'entspricht dem für einen bestimmten Antennenpunkt berechneten Ersatzwiderstand, der die von der Antenne abgestrahlte Leistung verbrauchen würde.', ' ');
INSERT INTO answer VALUES (4378, 1095, 1, 'ist die an einem bestimmten Antennenpunkt auftretende Antennenimpedanz, die auch immer die nicht zur Strahlung beitragenden Verlustwiderstände der Antenne beinhaltet.', ' ');
INSERT INTO answer VALUES (4379, 1095, 2, 'ist ein Blindwiderstand, der zur Anpassung der Antenne verwendet wird.', ' ');
INSERT INTO answer VALUES (4380, 1095, 3, 'ergibt sich aus der abgestrahlten Leistung dividiert durch das Quadrat der HF-Spannung am Antenneneingang und kann für beliebige Punkte der Antenne angegeben werden.', ' ');
INSERT INTO answer VALUES (4381, 1096, 0, 'ca. 240 bis 300 &Omega;', ' ');
INSERT INTO answer VALUES (4382, 1096, 1, 'ca. 30 bis 60 &Omega;', ' ');
INSERT INTO answer VALUES (4383, 1096, 2, 'ca. 60 &Omega;', ' ');
INSERT INTO answer VALUES (4384, 1096, 3, 'ca. 120 &Omega;', ' ');
INSERT INTO answer VALUES (4385, 1097, 0, 'ca. 30 bis 50 &Omega;', ' ');
INSERT INTO answer VALUES (4386, 1097, 1, 'ca. 60 bis 120 &Omega;', ' ');
INSERT INTO answer VALUES (4387, 1097, 2, 'ca. 600 &Omega;', ' ');
INSERT INTO answer VALUES (4388, 1097, 3, 'ca. 240 &Omega;', ' ');
INSERT INTO answer VALUES (4389, 1098, 0, 'ca. 60 bis 75 &Omega;', ' ');
INSERT INTO answer VALUES (4390, 1098, 1, 'ca. 30 &Omega;', ' ');
INSERT INTO answer VALUES (4391, 1098, 2, 'ca. 120 &Omega;', ' ');
INSERT INTO answer VALUES (4392, 1098, 3, 'ca. 240 bis 300 &Omega;', ' ');
INSERT INTO answer VALUES (4393, 1099, 0, 'Unterhalb der Grundfrequenz ist die Impedanz kapazitiv, oberhalb induktiv.', ' ');
INSERT INTO answer VALUES (4394, 1099, 1, 'Unterhalb der Grundfrequenz ist die Impedanz induktiv, oberhalb kapazitiv.', ' ');
INSERT INTO answer VALUES (4395, 1099, 2, 'Unterhalb der Grundfrequenz ist die Impedanz niedriger, oberhalb höher.', ' ');
INSERT INTO answer VALUES (4396, 1099, 3, 'Unterhalb der Grundfrequenz ist die Impedanz höher, oberhalb niedriger.', ' ');
INSERT INTO answer VALUES (4397, 1100, 0, 'das Verhältnis von P<sub>v</sub> zu P<sub>D</sub>.', ' ');
INSERT INTO answer VALUES (4398, 1100, 1, 'das Verhältnis von P<sub>D</sub> zu P<sub>R</sub>.', ' ');
INSERT INTO answer VALUES (4399, 1100, 2, 'das Verhältnis von P<sub>v</sub> zu P<sub>R</sub>.', ' ');
INSERT INTO answer VALUES (4400, 1100, 3, 'das Verhältnis von 0,7•P<sub>v</sub> zu 0,7•P<sub>R</sub> .', ' ');
INSERT INTO answer VALUES (4401, 1101, 0, 'als das Verhältnis von P<sub>v</sub> zu P<sub>R</sub>.', ' ');
INSERT INTO answer VALUES (4402, 1101, 1, 'als das Verhältnis von P<sub>D</sub> zu P<sub>R</sub>.', ' ');
INSERT INTO answer VALUES (4403, 1101, 2, 'als das Verhältnis von P<sub>v</sub> zu P<sub>D</sub>.', ' ');
INSERT INTO answer VALUES (4404, 1101, 3, 'als das Verhältnis von 0,7•P<sub>v</sub> zu 0,7•P<sub>D</sub> .', ' ');
INSERT INTO answer VALUES (4405, 1102, 0, 'isotropen Kugelstrahler.', ' ');
INSERT INTO answer VALUES (4406, 1102, 1, 'Halbwellenstrahler.', ' ');
INSERT INTO answer VALUES (4407, 1102, 2, 'horizontalen Rundstrahler.', ' ');
INSERT INTO answer VALUES (4408, 1102, 3, 'vertikalen Rundstrahler.', ' ');
INSERT INTO answer VALUES (4409, 1103, 0, '7,15 dBi', ' ');
INSERT INTO answer VALUES (4410, 1103, 1, '5 dBi', ' ');
INSERT INTO answer VALUES (4411, 1103, 2, '2,5 dBi', ' ');
INSERT INTO answer VALUES (4412, 1103, 3, '2,85 dBi', ' ');
INSERT INTO answer VALUES (4413, 1104, 0, 'Sie hat mehr Gewinn.', ' ');
INSERT INTO answer VALUES (4414, 1104, 1, 'Sie verträgt mehr Leistung.', ' ');
INSERT INTO answer VALUES (4415, 1104, 2, 'Sie ist leichter zu montieren.', ' ');
INSERT INTO answer VALUES (4416, 1104, 3, 'Sie ist weniger störanfällig.', ' ');
INSERT INTO answer VALUES (4417, 1105, 0, 'die Feldstärke auf nicht weniger als den 0,707-fachen Wert der maximalen Feldstärke absinkt.', ' ');
INSERT INTO answer VALUES (4418, 1105, 1, 'die Feldstärke auf nicht weniger als die Hälfte der maximalen Feldstärke absinkt.', ' ');
INSERT INTO answer VALUES (4419, 1105, 2, 'die Strahlungsdichte auf nicht weniger als den 1 / &radic;<span style="text-decoration:overline">2</span>-fachen Wert der maximalen Strahlungsdichte absinkt.', ' ');
INSERT INTO answer VALUES (4420, 1105, 3, 'die abgestrahlte Leistung auf nicht weniger als den 1 / &radic;<span style="text-decoration:overline">2</span>-fachen Wert des Leistungsmaximums absinkt.', ' ');
INSERT INTO answer VALUES (4421, 1106, 0, 'Durch den Punkt C.', ' ');
INSERT INTO answer VALUES (4422, 1106, 1, 'Durch den Punkt B.', ' ');
INSERT INTO answer VALUES (4423, 1106, 2, 'Durch den Punkt D.', ' ');
INSERT INTO answer VALUES (4424, 1106, 3, 'Durch den Punkt A.', ' ');
INSERT INTO answer VALUES (4425, 1107, 0, 'Etwa 55°.', ' ');
INSERT INTO answer VALUES (4426, 1107, 1, 'Etwa 34°.', ' ');
INSERT INTO answer VALUES (4427, 1107, 2, 'Etwa 69°.', ' ');
INSERT INTO answer VALUES (4428, 1107, 3, 'Etwa 27°.', ' ');
INSERT INTO answer VALUES (4429, 1108, 0, 'Weil sich diese Antenne nicht im idealen freien Raum befindet und weil sie nicht unendlich dünn ist. Kapazitive Einflüsse der Umgebung und der Durchmesser des Strahlers verlängern die Antenne elektrisch. Dies wird durch eine mechanische Verkürzung ausgeglichen.', ' ');
INSERT INTO answer VALUES (4430, 1108, 1, 'Weil sich diese Antenne nicht im idealen freien Raum befindet und weil die Antennenelemente nicht die Idealform des Kugelstrahlers besitzen. Kapazitive Einflüsse der Umgebung und die Abweichung von der idealen Kugelform verlängern die Antenne elektrisch. Dies wird durch eine mechanische Verkürzung ausgeglichen.', ' ');
INSERT INTO answer VALUES (4431, 1108, 2, 'Weil sich durch die mechanische Verkürzung die elektromagnetischen Wellen leichter von der Antenne ablösen. Dadurch steigt der Wirkungsgrad, so dass größere Reichweiten (DX-Verbindungen) möglich werden.', ' ');
INSERT INTO answer VALUES (4432, 1108, 3, 'Weil sich durch die mechanische Verkürzung der Verlustwiderstand eines Antennenstabes verringert. Dadurch steigt der Wirkungsgrad, so dass größere Reichweiten (DX-Verbindungen) möglich werden.', ' ');
INSERT INTO answer VALUES (4433, 1109, 0, 'eine Verringerung der Resonanzfrequenz.', ' ');
INSERT INTO answer VALUES (4434, 1109, 1, 'die Erhöhung der Güte.', ' ');
INSERT INTO answer VALUES (4435, 1109, 2, 'eine Vergrößerung der Belastbarkeit.', ' ');
INSERT INTO answer VALUES (4436, 1109, 3, 'eine Erhöhung der Resonanzfrequenz.', ' ');
INSERT INTO answer VALUES (4437, 1110, 0, 'wird nach der Ausrichtung der elektrischen Feldkomponente in der Hauptstrahlrichtung in Bezug zur Erdoberfläche angegeben.', ' ');
INSERT INTO answer VALUES (4438, 1110, 1, 'wird nach der Ausrichtung der magnetischen Feldkomponente in der Hauptstrahlrichtung in Bezug zur Erdoberfläche angegeben.', ' ');
INSERT INTO answer VALUES (4439, 1110, 2, 'entspricht der Richtung der magnetischen Feldkomponente des empfangenen oder ausgesendeten Feldes in Bezug auf die Nordrichtung (Azimut).', ' ');
INSERT INTO answer VALUES (4440, 1110, 3, 'entspricht der Richtung der elektrischen Feldkomponente des empfangenen oder ausgesendeten Feldes in Bezug auf die Nordrichtung (Azimut).', ' ');
INSERT INTO answer VALUES (4441, 1111, 0, 'Es wird meist mit horizontaler oder vertikaler Polarisation gesendet.', ' ');
INSERT INTO answer VALUES (4442, 1111, 1, 'Es wird meist mit horizontaler oder zirkularer Polarisation gesendet.', ' ');
INSERT INTO answer VALUES (4443, 1111, 2, 'Es wird meist mit vertikaler oder zirkularer Polarisation gesendet.', ' ');
INSERT INTO answer VALUES (4444, 1111, 3, 'Es wird nur mit horizontaler Polarisation gesendet.', ' ');
INSERT INTO answer VALUES (4445, 1112, 0, 'Die in der Ionosphäre reflektierten Wellen sind -unabhängig von der Polarisation der ausgesendeten Wellen - meist elliptisch polarisiert.', ' ');
INSERT INTO answer VALUES (4446, 1112, 1, 'Die Polarisation der ausgesendeten Wellen bleibt bei der Reflexion in der Ionosphäre stets unverändert.', ' ');
INSERT INTO answer VALUES (4447, 1112, 2, 'Die Polarisation der ausgesendeten Wellen wird in der Ionosphäre auf Grund des Faraday-Effektes stets um 90° gedreht.', ' ');
INSERT INTO answer VALUES (4448, 1112, 3, 'Die Polarisation der ausgesendeten Wellen wird bei jedem Sprung (Hop) in der Ionosphäre auf Grund des Faraday-Effektes um 90° gedreht.', ' ');
INSERT INTO answer VALUES (4449, 1113, 0, 'Bei einer der Antennen muss die Welle um &lambda;/4 verzögert werden. Dies kann entweder durch eine zusätzlich eingefügte Viertelwellen-Verzögerungsleitung oder durch mechanische "Verschiebung" beider Yagi-Antennen um &lambda;/4 gegeneinander hergestellt werden.', ' ');
INSERT INTO answer VALUES (4450, 1113, 1, 'Bei einer der Antennen muss die Welle um &lambda;/2 verzögert werden. Dies kann entweder durch eine zusätzlich eingefügte &lambda;/2-Verzögerungsleitung oder durch mechanische "Verschiebung" beider Yagi-Antennen um &lambda;/2 gegeneinander hergestellt werden.', ' ');
INSERT INTO answer VALUES (4451, 1113, 2, 'Die Zusammenschaltung der Antennen muss über eine Halbwellen-Lecherleitung erfolgen. Zur Anpassung an den Wellenwiderstand muss zwischen der Speiseleitung und den Antennen noch ein &lambda;/4-Transformationsstück eingefügt werden.', ' ');
INSERT INTO answer VALUES (4452, 1113, 3, 'Die kreuzförmig angeordneten Elemente der beiden Antennen sind um 45° zu verdrehen, so dass in der Draufsicht ein liegendes Kreuz gebildet wird. Die Antennen werden über Leitungsstücke gleicher Länge parallel geschaltet. Die Anpassung erfolgt mit einem Symmetrierglied.', ' ');
INSERT INTO answer VALUES (4453, 1114, 0, '75 %', ' ');
INSERT INTO answer VALUES (4454, 1114, 1, '50 %', ' ');
INSERT INTO answer VALUES (4455, 1114, 2, '25 %', ' ');
INSERT INTO answer VALUES (4456, 1114, 3, '29 %', ' ');
INSERT INTO answer VALUES (4457, 1115, 0, 'ca. 3,2 bis 4', ' ');
INSERT INTO answer VALUES (4458, 1115, 1, '0,3', ' ');
INSERT INTO answer VALUES (4459, 1115, 2, 'ca. 1,5 bis 2', ' ');
INSERT INTO answer VALUES (4460, 1115, 3, '5,7', ' ');
INSERT INTO answer VALUES (4461, 1116, 0, 'Dipol<p><img src=''th222a.png''></p>', ' ');
INSERT INTO answer VALUES (4462, 1116, 1, 'Groundplane<p><img src=''th222b.png''></p>', ' ');
INSERT INTO answer VALUES (4463, 1116, 2, 'Yagi<p><img src=''th222c.png''></p>', ' ');
INSERT INTO answer VALUES (4464, 1116, 3, 'Sperrtopf<p><img src=''th222d.png''></p>', ' ');
INSERT INTO answer VALUES (4465, 1117, 0, 'Yagi<p><img src=''th222b.png''></p>', ' ');
INSERT INTO answer VALUES (4466, 1117, 1, 'Groundplane<p><img src=''th222a.png''></p>', ' ');
INSERT INTO answer VALUES (4467, 1117, 2, 'Dipol<p><img src=''th222c.png''></p>', ' ');
INSERT INTO answer VALUES (4468, 1117, 3, 'Sperrtopf<p><img src=''th222d.png''></p>', ' ');
INSERT INTO answer VALUES (4469, 1118, 0, 'Groundplane<p><img src=''th222c.png''></p>', ' ');
INSERT INTO answer VALUES (4470, 1118, 1, 'Sperrtopf<p><img src=''th222a.png''></p>', ' ');
INSERT INTO answer VALUES (4471, 1118, 2, 'Dipol<p><img src=''th222b.png''></p>', ' ');
INSERT INTO answer VALUES (4472, 1118, 3, 'Yagi<p><img src=''th222d.png''></p>', ' ');
INSERT INTO answer VALUES (4473, 1119, 0, '9,8 Watt', ' ');
INSERT INTO answer VALUES (4474, 1119, 1, '5,4 Watt', ' ');
INSERT INTO answer VALUES (4475, 1119, 2, '12,7 Watt', ' ');
INSERT INTO answer VALUES (4476, 1119, 3, '7,8 Watt', ' ');
INSERT INTO answer VALUES (4477, 1120, 0, '16,4 Watt', ' ');
INSERT INTO answer VALUES (4478, 1120, 1, '8,2 Watt', ' ');
INSERT INTO answer VALUES (4479, 1120, 2, '41,2 Watt', ' ');
INSERT INTO answer VALUES (4480, 1120, 3, '9,98 Watt', ' ');
INSERT INTO answer VALUES (4481, 1121, 0, '9,9 Watt', ' ');
INSERT INTO answer VALUES (4482, 1121, 1, '19,7 Watt', ' ');
INSERT INTO answer VALUES (4483, 1121, 2, '12,0 Watt', ' ');
INSERT INTO answer VALUES (4484, 1121, 3, '6,0 Watt', ' ');
INSERT INTO answer VALUES (4485, 1122, 0, '1000 Watt', ' ');
INSERT INTO answer VALUES (4486, 1122, 1, '100 Watt', ' ');
INSERT INTO answer VALUES (4487, 1122, 2, '111 Watt', ' ');
INSERT INTO answer VALUES (4488, 1122, 3, '1110 Watt', ' ');
INSERT INTO answer VALUES (4489, 1123, 0, '16,4 Watt', ' ');
INSERT INTO answer VALUES (4490, 1123, 1, '90 Watt', ' ');
INSERT INTO answer VALUES (4491, 1123, 2, '164 Watt', ' ');
INSERT INTO answer VALUES (4492, 1123, 3, '10 Watt', ' ');
INSERT INTO answer VALUES (4493, 1124, 0, 'die Kopplung mit der Netzspannungsverkabelung auf ein Minimum beschränkt ist.', ' ');
INSERT INTO answer VALUES (4494, 1124, 1, 'sie in geringerem Ausmaß Ausstrahlungen unterworfen ist.', ' ');
INSERT INTO answer VALUES (4495, 1124, 2, 'sie eine geringere Anzahl von Harmonischen abstrahlt.', ' ');
INSERT INTO answer VALUES (4496, 1124, 3, 'das Sendesignal einen niedrigeren Pegel aufweist.', ' ');
INSERT INTO answer VALUES (4497, 1125, 0, 'kann unerwünschte Signale in TV-Koaxialkabel induzieren.', ' ');
INSERT INTO answer VALUES (4498, 1125, 1, 'induziert keine Störungen in horizontalen Antennen.', ' ');
INSERT INTO answer VALUES (4499, 1125, 2, 'erzeugt keine unerwünschten Signale in horizontal verlegten Stromleitungen.', ' ');
INSERT INTO answer VALUES (4500, 1125, 3, 'erzeugt ein Summen im Stromversorgungsnetz.', ' ');
INSERT INTO answer VALUES (4501, 1126, 0, 'Gewinn: 7,4 dBd, Vor-Rück-Verhältnis: 23,5 dB', ' ');
INSERT INTO answer VALUES (4502, 1126, 1, 'Gewinn: 3,7 dBd, Vor-Rück-Verhältnis: 11,7 dB', ' ');
INSERT INTO answer VALUES (4503, 1126, 2, 'Gewinn: 9,4 dBd, Vor-Rück-Verhältnis: 23,5 dB', ' ');
INSERT INTO answer VALUES (4504, 1126, 3, 'Gewinn: 7,4 dBd, Vor-Rück-Verhältnis: 15 dB', ' ');
INSERT INTO answer VALUES (4505, 1127, 0, 'ist im HF-Bereich in etwa konstant.', ' ');
INSERT INTO answer VALUES (4506, 1127, 1, 'ist völlig frequenzunabhängig.', ' ');
INSERT INTO answer VALUES (4507, 1127, 2, 'hängt von der Beschaltung am Leitungsende ab.', ' ');
INSERT INTO answer VALUES (4508, 1127, 3, 'hängt von der Leitungslänge und der Beschaltung am Leitungsende ab.', ' ');
INSERT INTO answer VALUES (4509, 1128, 0, 'den Wert des Wellenwiderstandes aufweist.', ' ');
INSERT INTO answer VALUES (4510, 1128, 1, '50 &Omega; beträgt.', ' ');
INSERT INTO answer VALUES (4511, 1128, 2, 'reell ist.', ' ');
INSERT INTO answer VALUES (4512, 1128, 3, 'eine offene Leitung darstellt.', ' ');
INSERT INTO answer VALUES (4513, 1129, 0, '50, 60 und 75 &Omega; auf.', ' ');
INSERT INTO answer VALUES (4514, 1129, 1, '50, 300 und 600 &Omega; auf.', ' ');
INSERT INTO answer VALUES (4515, 1129, 2, '60, 120 und 240 &Omega; auf.', ' ');
INSERT INTO answer VALUES (4516, 1129, 3, '50, 75 und 240 &Omega; auf.', ' ');
INSERT INTO answer VALUES (4517, 1130, 0, '3,0 dB', ' ');
INSERT INTO answer VALUES (4518, 1130, 1, '4,5 dB', ' ');
INSERT INTO answer VALUES (4519, 1130, 2, '1,3 dB', ' ');
INSERT INTO answer VALUES (4520, 1130, 3, '0,8 dB', ' ');
INSERT INTO answer VALUES (4521, 1131, 0, '5,4 dB', ' ');
INSERT INTO answer VALUES (4522, 1131, 1, '8,1 dB', ' ');
INSERT INTO answer VALUES (4523, 1131, 2, '2,3 dB', ' ');
INSERT INTO answer VALUES (4524, 1131, 3, '1,4 dB', ' ');
INSERT INTO answer VALUES (4525, 1132, 0, '0,3 dB', ' ');
INSERT INTO answer VALUES (4526, 1132, 1, '1,2 dB', ' ');
INSERT INTO answer VALUES (4527, 1132, 2, '0,6 dB', ' ');
INSERT INTO answer VALUES (4528, 1132, 3, '0,1 dB', ' ');
INSERT INTO answer VALUES (4529, 1133, 0, '0,5 dB', ' ');
INSERT INTO answer VALUES (4530, 1133, 1, '2,1 dB', ' ');
INSERT INTO answer VALUES (4531, 1133, 2, '1,1 dB', ' ');
INSERT INTO answer VALUES (4532, 1133, 3, '0,2 dB', ' ');
INSERT INTO answer VALUES (4533, 1134, 0, '2,2 dB', ' ');
INSERT INTO answer VALUES (4534, 1134, 1, '8,7 dB', ' ');
INSERT INTO answer VALUES (4535, 1134, 2, '4,4 dB', ' ');
INSERT INTO answer VALUES (4536, 1134, 3, '0,9 dB', ' ');
INSERT INTO answer VALUES (4537, 1135, 0, '2,8 dB', ' ');
INSERT INTO answer VALUES (4538, 1135, 1, '11,0 dB', ' ');
INSERT INTO answer VALUES (4539, 1135, 2, '5,5 dB', ' ');
INSERT INTO answer VALUES (4540, 1135, 3, '1,1 dB', ' ');
INSERT INTO answer VALUES (4541, 1136, 0, '5,3 dB', ' ');
INSERT INTO answer VALUES (4542, 1136, 1, '21,0 dB', ' ');
INSERT INTO answer VALUES (4543, 1136, 2, '10,5 dB', ' ');
INSERT INTO answer VALUES (4544, 1136, 3, '2,1 dB', ' ');
INSERT INTO answer VALUES (4545, 1137, 0, 'Offene Zweidrahtleitung', ' ');
INSERT INTO answer VALUES (4546, 1137, 1, 'Koaxialkabel mit Vollisolation', ' ');
INSERT INTO answer VALUES (4547, 1137, 2, 'UKW-Bandleitung', ' ');
INSERT INTO answer VALUES (4548, 1137, 3, 'Kunststoffisolierte Zweidrahtleitung', ' ');
INSERT INTO answer VALUES (4549, 1138, 0, 'Sie hat geringere Dämpfung als andere Speiseleitungen und hohe Spannungsfestigkeit.', ' ');
INSERT INTO answer VALUES (4550, 1138, 1, 'Sie vermeidet Mantelwellen durch Wegfall der Abschirmung.', ' ');
INSERT INTO answer VALUES (4551, 1138, 2, 'Sie erlaubt leichtere Kontrolle des Wellenwiderstandes durch Verschieben der Spreizer.', ' ');
INSERT INTO answer VALUES (4552, 1138, 3, 'Sie bietet guten Blitzschutz durch niederohmige Drähte.', ' ');
INSERT INTO answer VALUES (4553, 1139, 0, 'Wenn die beiden Leiter unterschiedlich geformt sind, z.B. Koaxialkabel.', ' ');
INSERT INTO answer VALUES (4554, 1139, 1, 'Wenn die hin- und zurücklaufende Leistung verschieden sind.', ' ');
INSERT INTO answer VALUES (4555, 1139, 2, 'Wenn sie außerhalb ihrer Resonanzfrequenz betrieben wird.', ' ');
INSERT INTO answer VALUES (4556, 1139, 3, 'Wenn die Koaxial-Leitung Spannung gegen Erde führt.', ' ');
INSERT INTO answer VALUES (4557, 1140, 0, 'ist Strom und Spannung in den beiden Leitern gegenüber Erde gleich groß und gegenphasig.', ' ');
INSERT INTO answer VALUES (4558, 1140, 1, 'liegt einer der beiden Leiter auf Erdpotential.', ' ');
INSERT INTO answer VALUES (4559, 1140, 2, 'sind die Impedanzen bei beiden Leitern gegen Erde unendlich hoch.', ' ');
INSERT INTO answer VALUES (4560, 1140, 3, 'ist Strom und Spannung in den beiden Leitern gegenüber Erde gleich groß und gleichphasig.', ' ');
INSERT INTO answer VALUES (4561, 1141, 0, 'ca. 75 &Omega;', ' ');
INSERT INTO answer VALUES (4562, 1141, 1, 'ca. 20 &Omega;', ' ');
INSERT INTO answer VALUES (4563, 1141, 2, 'ca. 50 &Omega;', ' ');
INSERT INTO answer VALUES (4564, 1141, 3, 'ca. 95 &Omega;', ' ');
INSERT INTO answer VALUES (4565, 1142, 0, 'ca. 635 &Omega;', ' ');
INSERT INTO answer VALUES (4566, 1142, 1, 'ca. 276 &Omega;', ' ');
INSERT INTO answer VALUES (4567, 1142, 2, 'ca. 2,8 k&Omega;', ' ');
INSERT INTO answer VALUES (4568, 1142, 3, 'ca. 820 &Omega;', ' ');
INSERT INTO answer VALUES (4569, 1143, 0, 'ca. 97 &Omega;', ' ');
INSERT INTO answer VALUES (4570, 1143, 1, 'ca. 60 &Omega;', ' ');
INSERT INTO answer VALUES (4571, 1143, 2, 'ca. 50 &Omega;', ' ');
INSERT INTO answer VALUES (4572, 1143, 3, 'ca. 120 &Omega;', ' ');
INSERT INTO answer VALUES (4573, 1144, 0, 'ist geringer als im Freiraum.', ' ');
INSERT INTO answer VALUES (4574, 1144, 1, 'ist höher als im Freiraum.', ' ');
INSERT INTO answer VALUES (4575, 1144, 2, 'entspricht der Geschwindigkeit im Freiraum.', ' ');
INSERT INTO answer VALUES (4576, 1144, 3, 'ist fast unbegrenzt.', ' ');
INSERT INTO answer VALUES (4577, 1145, 0, 'ungefähr 1.', ' ');
INSERT INTO answer VALUES (4578, 1145, 1, '0,1.', ' ');
INSERT INTO answer VALUES (4579, 1145, 2, '0,66.', ' ');
INSERT INTO answer VALUES (4580, 1145, 3, 'unbestimmt.', ' ');
INSERT INTO answer VALUES (4581, 1146, 0, '0,66.', ' ');
INSERT INTO answer VALUES (4582, 1146, 1, '0,1.', ' ');
INSERT INTO answer VALUES (4583, 1146, 2, '0,8.', ' ');
INSERT INTO answer VALUES (4584, 1146, 3, '1,0.', ' ');
INSERT INTO answer VALUES (4585, 1147, 0, '1,8 m', ' ');
INSERT INTO answer VALUES (4586, 1147, 1, '0,18 m', ' ');
INSERT INTO answer VALUES (4587, 1147, 2, '3 m', ' ');
INSERT INTO answer VALUES (4588, 1147, 3, '6 m', ' ');
INSERT INTO answer VALUES (4589, 1148, 0, '34,2 cm', ' ');
INSERT INTO answer VALUES (4590, 1148, 1, '51,7 cm', ' ');
INSERT INTO answer VALUES (4591, 1148, 2, '103 cm', ' ');
INSERT INTO answer VALUES (4592, 1148, 3, '17 cm', ' ');
INSERT INTO answer VALUES (4593, 1149, 0, 'Es erhöht sich.', ' ');
INSERT INTO answer VALUES (4594, 1149, 1, 'Es nimmt ab.', ' ');
INSERT INTO answer VALUES (4595, 1149, 2, 'Es fällt auf 1:1 ab.', ' ');
INSERT INTO answer VALUES (4596, 1149, 3, 'Es bleibt konstant.', ' ');
INSERT INTO answer VALUES (4597, 1150, 0, 'Hochwertige asymmetrische Koaxialkabel', ' ');
INSERT INTO answer VALUES (4598, 1150, 1, 'Symmetrische Feederleitungen', ' ');
INSERT INTO answer VALUES (4599, 1150, 2, 'Unabgestimmte Speiseleitungen', ' ');
INSERT INTO answer VALUES (4600, 1150, 3, 'Hochwertige abgeschirmte Netzanschlusskabel', ' ');
INSERT INTO answer VALUES (4601, 1151, 0, 'von der Leitungslänge', ' ');
INSERT INTO answer VALUES (4602, 1151, 1, 'vom verwendeten Abschlusswiderstand.', ' ');
INSERT INTO answer VALUES (4603, 1151, 2, 'vom Leerlauf-Kurzschlussverhalten.', ' ');
INSERT INTO answer VALUES (4604, 1151, 3, 'vom Wellenwiderstand der beiden parallelen Leiter.', ' ');
INSERT INTO answer VALUES (4605, 1152, 0, 'Sie zeigt die Strom- und Spannungsverteilung an einer offenen &lambda;/4-Lecherleitung. Sie wirkt als Reihenschwingkreis.', ' ');
INSERT INTO answer VALUES (4606, 1152, 1, 'Sie zeigt die Strom- und Spannungsverteilung an einer Antennenspeiseleitung. Die Antenne arbeitet als Serienresonanzkreis.', ' ');
INSERT INTO answer VALUES (4607, 1152, 2, 'Sie zeigt die Strom- und Spannungsverteilung an einer Antenne. Die Antenne arbeitet als Groundplane mit Verkürzungskondensator.', ' ');
INSERT INTO answer VALUES (4608, 1152, 3, 'Sie zeigt die Strom- und Spannungsverteilung an den Radialen einer Groundplane. Die Antenne arbeitet mit Verlängerungsspule zur Resonanzanpassung.', ' ');
INSERT INTO answer VALUES (4609, 1153, 0, 'Die nebeneinander liegenden HF- und Netzkabel können Netzstörungen hervorrufen.', ' ');
INSERT INTO answer VALUES (4610, 1153, 1, 'Die nebeneinander liegenden HF- und Netzkabel können zu unerwünschter 50-Hz-Modulation auf dem Koaxialkabel führen.', ' ');
INSERT INTO answer VALUES (4611, 1153, 2, 'Zwischen den nebeneinander liegenden HF- und Netzkabeln kann es zu Spannungsüberschlägen kommen.', ' ');
INSERT INTO answer VALUES (4612, 1153, 3, 'Die nebeneinander liegenden HF- und Netzkabel können sich bei guter Isolierung nicht gegenseitig beeinflussen.', ' ');
INSERT INTO answer VALUES (4613, 1154, 0, 'geschirmt sein und nahe am Gebäude verlaufen.', ' ');
INSERT INTO answer VALUES (4614, 1154, 1, 'möglichst &lambda;/4 lang sein.', ' ');
INSERT INTO answer VALUES (4615, 1154, 2, 'als ungeschirmte Speiseleitung nahe am Gebäude verlaufen.', ' ');
INSERT INTO answer VALUES (4616, 1154, 3, 'an keiner Stelle geerdet sein.', ' ');
INSERT INTO answer VALUES (4617, 1155, 0, '50 Watt', ' ');
INSERT INTO answer VALUES (4618, 1155, 1, '25 Watt', ' ');
INSERT INTO answer VALUES (4619, 1155, 2, '50 Watt bei Leerlauf und 0 Watt bei Kurzschluss', ' ');
INSERT INTO answer VALUES (4620, 1155, 3, '0 Watt bei Leerlauf und 50 Watt bei Kurzschluss', ' ');
INSERT INTO answer VALUES (4621, 1156, 0, 'Ein VSWR von zirka 1,9 oder weniger.', ' ');
INSERT INTO answer VALUES (4622, 1156, 1, 'Ein VSWR von zirka 3,6 oder mehr.', ' ');
INSERT INTO answer VALUES (4623, 1156, 2, 'Ein VSWR von zirka 0, da sich vorlaufende und rücklaufende Leistung gegenseitig auslöschen.', ' ');
INSERT INTO answer VALUES (4624, 1156, 3, 'Ein VSWR, das gegen unendlich geht, da am Ende der Leitung die gesamte HF-Leistung reflektiert wird.', ' ');
INSERT INTO answer VALUES (4625, 1157, 0, 'Die Antenne ist fehlerhaft. Sie strahlt so gut wie keine HF-Leistung ab.', ' ');
INSERT INTO answer VALUES (4626, 1157, 1, 'Die Antennenleitung ist fehlerhaft, an der Antenne kommt so gut wie keine HF-Leistung an.', ' ');
INSERT INTO answer VALUES (4627, 1157, 2, 'Die Antennenanlage ist in Ordnung. Es werden etwa 5 Watt HF-Leistung abgestrahlt.', ' ');
INSERT INTO answer VALUES (4628, 1157, 3, 'Die Antennenanlage ist in Ordnung. Es werden etwa 3,75 Watt HF-Leistung abgestrahlt.', ' ');
INSERT INTO answer VALUES (4629, 1158, 0, 'Sie zeigt einen &lambda;/2-Faltdipol mit &lambda;/2-Umwegleitung. Durch die Anordnung wird der Fußpunktwiderstand der symmetrischen Antenne von 240 &Omega; an ein unsymmetrisches 60-&Omega;-Antennenkabel angepasst.', ' ');
INSERT INTO answer VALUES (4630, 1158, 1, 'Sie zeigt einen symmetrischen 60-&Omega;-Schleifendipol mit Koaxialkabel-Balun. Durch die Anordnung wird die symmetrische Antenne an ein unsymmetrisches 60-&Omega;-Antennenkabel angepasst.', ' ');
INSERT INTO answer VALUES (4631, 1158, 2, 'Sie zeigt einen &lambda;/2-Dipol mit symmetrierender &lambda;/2-Umwegleitung. Durch die Anordnung wird der Fußpunktwiderstand der symmetrischen Antenne von 120 &Omega; an ein unsymmetrisches 60-&Omega;-Antennenkabel angepasst.', ' ');
INSERT INTO answer VALUES (4632, 1158, 3, 'Sie zeigt einen symmetrischen 60-&Omega;-Schleifendipol mit einem koaxialen Leitungskreis, der als Sperrfilter zur Unterdrückung von unerwünschten Aussendungen eingesetzt ist.', ' ');
INSERT INTO answer VALUES (4633, 1159, 0, 'Der &lambda;/2-Faltdipol hat an jedem seiner Anschlüsse eine Impedanz von 120 &Omega; gegen Erde. Durch die &lambda;/2-Umwegleitung erfolgt eine 1:1 Widerstandstransformation mit Phasendrehung um 180°. An der Seite der Antennenleitung erfolgt eine phasenrichtige Parallelschaltung von 2 mal 120 &Omega; gegen Erde, womit eine Ausgangsimpedanz von 60 &Omega; erreicht wird.', ' ');
INSERT INTO answer VALUES (4634, 1159, 1, 'Der &lambda;/2-Faltdipol hat eine Impedanz von 240 &Omega;. Durch die &lambda;/2-Umwegleitung erfolgt eine 4:1 Widerstandstransformation mit Phasendrehung um 360°, womit an der Seite der Antennenleitung eine Ausgangsimpedanz von 60 &Omega; erreicht wird.', ' ');
INSERT INTO answer VALUES (4635, 1159, 2, 'Der &lambda;/2-Dipol hat eine Impedanz von 60 &Omega;. Durch die &lambda;/2-Umwegleitung erfolgt eine 1:2 Widerstandstransformation mit Phasendrehung um 180°. An der Seite der Antennenleitung erfolgt eine phasenrichtige Parallelschaltung von 2 mal 120 &Omega; gegen Erde. Womit eine Ausgangsimpedanz von 60 &Omega; erreicht wird.', ' ');
INSERT INTO answer VALUES (4636, 1159, 3, 'Der &lambda;/2-Dipol hat eine Impedanz von 240 &Omega;. Durch die &lambda;/2-Umwegleitung erfolgt eine 4:1 Widerstandstransformation mit Phasendrehung um 360°, womit an der Seite der Antennenleitung eine Ausgangsimpedanz von 60 &Omega; erreicht wird.', ' ');
INSERT INTO answer VALUES (4637, 1160, 0, 'Z<sub>1</sub> ist hochohmig und Z<sub>2</sub> niederohmig.', ' ');
INSERT INTO answer VALUES (4638, 1160, 1, 'Z<sub>1</sub> und Z<sub>2</sub> sind hochohmig.', ' ');
INSERT INTO answer VALUES (4639, 1160, 2, 'Z<sub>1</sub> und Z<sub>2</sub> sind niederohmig.', ' ');
INSERT INTO answer VALUES (4640, 1160, 3, 'Z<sub>1</sub> ist niederohmig und Z<sub>2</sub> hochohmig.', ' ');
INSERT INTO answer VALUES (4641, 1161, 0, 'Z<sub>1</sub> und Z<sub>2</sub> sind hochohmig.', ' ');
INSERT INTO answer VALUES (4642, 1161, 1, 'Z<sub>1</sub> ist niederohmig und Z<sub>2</sub> hochohmig.', ' ');
INSERT INTO answer VALUES (4643, 1161, 2, 'Z<sub>1</sub> und Z<sub>2</sub> sind niederohmig.', ' ');
INSERT INTO answer VALUES (4644, 1161, 3, 'Z<sub>1</sub> ist hochohmig und Z<sub>2</sub> niederohmig.', ' ');
INSERT INTO answer VALUES (4645, 1162, 0, 'Z<sub>1</sub> und Z<sub>2</sub> sind niederohmig.', ' ');
INSERT INTO answer VALUES (4646, 1162, 1, 'Z<sub>1</sub> und Z<sub>2</sub> sind hochohmig.', ' ');
INSERT INTO answer VALUES (4647, 1162, 2, 'Z<sub>1</sub> ist niederohmig und Z<sub>2</sub> hochohmig.', ' ');
INSERT INTO answer VALUES (4648, 1162, 3, 'Z<sub>1</sub> ist hochohmig und Z<sub>2</sub> niederohmig.', ' ');
INSERT INTO answer VALUES (4649, 1163, 0, '380 &Omega;', ' ');
INSERT INTO answer VALUES (4650, 1163, 1, '420 &Omega;', ' ');
INSERT INTO answer VALUES (4651, 1163, 2, '840 &Omega;', ' ');
INSERT INTO answer VALUES (4652, 1163, 3, '240 &Omega;', ' ');
INSERT INTO answer VALUES (4653, 1164, 0, '120 &Omega;', ' ');
INSERT INTO answer VALUES (4654, 1164, 1, '247 &Omega;', ' ');
INSERT INTO answer VALUES (4655, 1164, 2, '232 &Omega;', ' ');
INSERT INTO answer VALUES (4656, 1164, 3, '300 &Omega;', ' ');
INSERT INTO answer VALUES (4657, 1165, 0, 'Sehr hochohmig', ' ');
INSERT INTO answer VALUES (4658, 1165, 1, 'Annähernd 0 &Omega;', ' ');
INSERT INTO answer VALUES (4659, 1165, 2, '50 &Omega;', ' ');
INSERT INTO answer VALUES (4660, 1165, 3, 'Ungefähr 100 &Omega;', ' ');
INSERT INTO answer VALUES (4661, 1166, 0, 'Annähernd 0 &Omega;', ' ');
INSERT INTO answer VALUES (4662, 1166, 1, 'Sehr hochohmig', ' ');
INSERT INTO answer VALUES (4663, 1166, 2, '50 &Omega;', ' ');
INSERT INTO answer VALUES (4664, 1166, 3, 'Ungefähr 100 &Omega;', ' ');
INSERT INTO answer VALUES (4665, 1167, 0, 'beträgt nahezu Null.', ' ');
INSERT INTO answer VALUES (4666, 1167, 1, 'ist gleich dem Wellenwiderstand.', ' ');
INSERT INTO answer VALUES (4667, 1167, 2, 'beträgt das Dreifache des Wellenwiderstandes.', ' ');
INSERT INTO answer VALUES (4668, 1167, 3, 'ist nahezu unendlich hoch.', ' ');
INSERT INTO answer VALUES (4669, 1168, 0, '90°', ' ');
INSERT INTO answer VALUES (4670, 1168, 1, '180°', ' ');
INSERT INTO answer VALUES (4671, 1168, 2, '&pi; / 4', ' ');
INSERT INTO answer VALUES (4672, 1168, 3, 'Null', ' ');
INSERT INTO answer VALUES (4673, 1169, 0, '2 &pi;', ' ');
INSERT INTO answer VALUES (4674, 1169, 1, '180°', ' ');
INSERT INTO answer VALUES (4675, 1169, 2, '&pi;² / 4', ' ');
INSERT INTO answer VALUES (4676, 1169, 3, '90°', ' ');
INSERT INTO answer VALUES (4677, 1170, 0, '50 &Omega;', ' ');
INSERT INTO answer VALUES (4678, 1170, 1, '25 &Omega;', ' ');
INSERT INTO answer VALUES (4679, 1170, 2, '100 &Omega;', ' ');
INSERT INTO answer VALUES (4680, 1170, 3, '200 &Omega;', ' ');
INSERT INTO answer VALUES (4681, 1171, 0, '70 &Omega;.', ' ');
INSERT INTO answer VALUES (4682, 1171, 1, '185 &Omega;.', ' ');
INSERT INTO answer VALUES (4683, 1171, 2, '300 &Omega;.', ' ');
INSERT INTO answer VALUES (4684, 1171, 3, '370 &Omega;.', ' ');
INSERT INTO answer VALUES (4685, 1172, 0, 'Die Richtcharakteristik der Antenne wird verformt und es können Mantelwellen auftreten.', ' ');
INSERT INTO answer VALUES (4686, 1172, 1, 'Es treten keine nennenswerten Auswirkungen auf, da die Antenne angepasst ist und die Speisung über ein Koaxkabel erfolgt, dessen Außenleiter Erdpotential hat.', ' ');
INSERT INTO answer VALUES (4687, 1172, 2, 'Am Speisepunkt der Antenne treten gegenphasige Spannungen und Ströme gleicher Größe auf, die eine Fehlanpassung hervorrufen.', ' ');
INSERT INTO answer VALUES (4688, 1172, 3, 'Es treten Polarisationsdrehungen auf, die von der Kabellänge abhängig sind.', ' ');
INSERT INTO answer VALUES (4689, 1173, 0, 'durch Symmetrierglieder wie Umwegleitung oder Balun.', ' ');
INSERT INTO answer VALUES (4690, 1173, 1, 'durch die Einfügung von Sperrkreisen (Traps) in den Dipol.', ' ');
INSERT INTO answer VALUES (4691, 1173, 2, 'durch Parallelschalten eines am freien Ende offenen &lambda;/4-langen Leitungsstücks (Stub) am Speisepunkt der Antenne.', ' ');
INSERT INTO answer VALUES (4692, 1173, 3, 'durch Parallelschalten eines am freien Ende kurzgeschlossenen &lambda;/2-langen Leitungsstücks (Stub) am Speisepunkt der Antenne.', ' ');
INSERT INTO answer VALUES (4693, 1174, 0, 'Mantelwellen zu dämpfen.', ' ');
INSERT INTO answer VALUES (4694, 1174, 1, 'statische Aufladungen zu verhindern.', ' ');
INSERT INTO answer VALUES (4695, 1174, 2, 'eine Antennenleitung abzustimmen.', ' ');
INSERT INTO answer VALUES (4696, 1174, 3, 'Oberwellen zu unterdrücken.', ' ');
INSERT INTO answer VALUES (4697, 1175, 0, 'den Dipol über ein Symmetrierglied zu speisen.', ' ');
INSERT INTO answer VALUES (4698, 1175, 1, 'das Koaxialkabel durch eine Eindrahtspeiseleitung zu ersetzen.', ' ');
INSERT INTO answer VALUES (4699, 1175, 2, 'beim Koaxialkabel alle 5 m eine Schleife mit 3 Windungen einzulegen.', ' ');
INSERT INTO answer VALUES (4700, 1175, 3, 'das Koaxialkabel in einem Kunststoffrohr zur mechanischen Schirmung unterzubringen.', ' ');
INSERT INTO answer VALUES (4701, 1176, 0, '200 &Omega;', ' ');
INSERT INTO answer VALUES (4702, 1176, 1, '50 &Omega;', ' ');
INSERT INTO answer VALUES (4703, 1176, 2, '100 &Omega;', ' ');
INSERT INTO answer VALUES (4704, 1176, 3, '400 &Omega;', ' ');
INSERT INTO answer VALUES (4705, 1177, 0, '50 &Omega;', ' ');
INSERT INTO answer VALUES (4706, 1177, 1, '100 &Omega;', ' ');
INSERT INTO answer VALUES (4707, 1177, 2, '200 &Omega;', ' ');
INSERT INTO answer VALUES (4708, 1177, 3, '400 &Omega;', ' ');
INSERT INTO answer VALUES (4709, 1178, 0, 'führen zu Reflektionen des übertragenen HF-Signals und zu einem erhöhten VSWR.', ' ');
INSERT INTO answer VALUES (4710, 1178, 1, 'führen zur einer Überbeanspruchung der angeschlossenen Antenne.', ' ');
INSERT INTO answer VALUES (4711, 1178, 2, 'führen zu einem VSWR von kleiner oder gleich 1.', ' ');
INSERT INTO answer VALUES (4712, 1178, 3, 'führen zur Erzeugung unerwünschter Aussendungen, da innerhalb der erforderlichen Bandbreite keine Anpassung gegeben ist.', ' ');
INSERT INTO answer VALUES (4713, 1179, 0, '25 W', ' ');
INSERT INTO answer VALUES (4714, 1179, 1, '12,5 W', ' ');
INSERT INTO answer VALUES (4715, 1179, 2, '50 W', ' ');
INSERT INTO answer VALUES (4716, 1179, 3, '75 W', ' ');
INSERT INTO answer VALUES (4717, 1180, 0, 'ein Symmetrierglied.', ' ');
INSERT INTO answer VALUES (4718, 1180, 1, 'ein Netztransformator.', ' ');
INSERT INTO answer VALUES (4719, 1180, 2, 'eine Spule mit mindestens trifilarer Wicklung.', ' ');
INSERT INTO answer VALUES (4720, 1180, 3, 'eine HF-Eichleitung.', ' ');
INSERT INTO answer VALUES (4721, 1181, 0, 'D-, E-, F1- und F2-Schicht', ' ');
INSERT INTO answer VALUES (4722, 1181, 1, 'E- und F-Schicht', ' ');
INSERT INTO answer VALUES (4723, 1181, 2, 'F1- und F2-Schicht', ' ');
INSERT INTO answer VALUES (4724, 1181, 3, 'E- und D-Schicht', ' ');
INSERT INTO answer VALUES (4725, 1182, 0, 'F2-Schicht', ' ');
INSERT INTO answer VALUES (4726, 1182, 1, 'D-, E- und F2-Schicht', ' ');
INSERT INTO answer VALUES (4727, 1182, 2, 'F1- und F2-Schicht', ' ');
INSERT INTO answer VALUES (4728, 1182, 3, 'D- und E-Schicht', ' ');
INSERT INTO answer VALUES (4729, 1183, 0, '200 km Höhe.', ' ');
INSERT INTO answer VALUES (4730, 1183, 1, '400 km Höhe.', ' ');
INSERT INTO answer VALUES (4731, 1183, 2, '90 bis 120 km Höhe.', ' ');
INSERT INTO answer VALUES (4732, 1183, 3, '70 bis 90 km Höhe.', ' ');
INSERT INTO answer VALUES (4733, 1184, 0, '400 km Höhe.', ' ');
INSERT INTO answer VALUES (4734, 1184, 1, '200 km Höhe.', ' ');
INSERT INTO answer VALUES (4735, 1184, 2, '90 bis 120 km Höhe.', ' ');
INSERT INTO answer VALUES (4736, 1184, 3, '70 bis 90 km Höhe.', ' ');
INSERT INTO answer VALUES (4737, 1185, 0, '90 bis 120 km Höhe.', ' ');
INSERT INTO answer VALUES (4738, 1185, 1, '200 km Höhe.', ' ');
INSERT INTO answer VALUES (4739, 1185, 2, '400 km Höhe.', ' ');
INSERT INTO answer VALUES (4740, 1185, 3, '70 bis 90 km Höhe.', ' ');
INSERT INTO answer VALUES (4741, 1186, 0, '70 bis 90 km Höhe.', ' ');
INSERT INTO answer VALUES (4742, 1186, 1, '200km Höhe.', ' ');
INSERT INTO answer VALUES (4743, 1186, 2, '400km Höhe.', ' ');
INSERT INTO answer VALUES (4744, 1186, 3, '90 bis 120 km Höhe.', ' ');
INSERT INTO answer VALUES (4745, 1187, 0, '100 km Höhe.', ' ');
INSERT INTO answer VALUES (4746, 1187, 1, '70 km Höhe.', ' ');
INSERT INTO answer VALUES (4747, 1187, 2, '360 km Höhe.', ' ');
INSERT INTO answer VALUES (4748, 1187, 3, '1500 km Höhe.', ' ');
INSERT INTO answer VALUES (4749, 1188, 0, '200 km Höhe.', ' ');
INSERT INTO answer VALUES (4750, 1188, 1, '80 km Höhe.', ' ');
INSERT INTO answer VALUES (4751, 1188, 2, '120 km Höhe.', ' ');
INSERT INTO answer VALUES (4752, 1188, 3, '500 km Höhe.', ' ');
INSERT INTO answer VALUES (4753, 1189, 0, 'im Sommer zur Mittagszeit.', ' ');
INSERT INTO answer VALUES (4754, 1189, 1, 'im Sommer um Mitternacht.', ' ');
INSERT INTO answer VALUES (4755, 1189, 2, 'im Frühjahr und Herbst zur Dämmerungszeit.', ' ');
INSERT INTO answer VALUES (4756, 1189, 3, 'im Winter zur Mittagszeit.', ' ');
INSERT INTO answer VALUES (4757, 1190, 0, 'F2-Schicht', ' ');
INSERT INTO answer VALUES (4758, 1190, 1, 'D-Schicht', ' ');
INSERT INTO answer VALUES (4759, 1190, 2, 'E-Schicht', ' ');
INSERT INTO answer VALUES (4760, 1190, 3, 'F1-Schicht', ' ');
INSERT INTO answer VALUES (4761, 1191, 0, 'unerwünscht, weil sie durch Absorption die Ausbreitung durch Reflexion an der F2-Schicht behindern kann.', ' ');
INSERT INTO answer VALUES (4762, 1191, 1, 'erwünscht, weil sie durch zusätzliche Reflexion die Wirkung der F2-Schicht verstärken kann.', ' ');
INSERT INTO answer VALUES (4763, 1191, 2, 'nicht von großer Bedeutung, weil sie vor allem für die höheren Frequenzen durchlässig ist.', ' ');
INSERT INTO answer VALUES (4764, 1191, 3, 'von großer Bedeutung, weil sie die F2-Schicht in noch größere Höhen verschiebt und damit die Sprungsdistanz vergrößert.', ' ');
INSERT INTO answer VALUES (4765, 1192, 0, 'Die D-Schicht führt tagsüber zu starker Dämpfung im 80- und 160-m-Band.', ' ');
INSERT INTO answer VALUES (4766, 1192, 1, 'Die D-Schicht reflektiert tagsüber die Wellen im 20-, 30- und 40-m-Band.', ' ');
INSERT INTO answer VALUES (4767, 1192, 2, 'Die D-Schicht absorbiert tagsüber die Wellen im 10- und 15-m-Band.', ' ');
INSERT INTO answer VALUES (4768, 1192, 3, 'Die D-Schicht ist im Sonnenfleckenmaximum am wenigsten ausgeprägt.', ' ');
INSERT INTO answer VALUES (4769, 1193, 0, 'Durch die von der Sonne ausgehende UV-Strahlung, welche die Moleküle in den verschiedenen Schichthöhen je nach Strahlungsintensität ionisiert.', ' ');
INSERT INTO answer VALUES (4770, 1193, 1, 'Durch die von der Sonne ausgehende Infrarotstrahlung, welche die Moleküle in den verschiedenen Schichthöhen je nach Strahlungsintensität ionisiert.', ' ');
INSERT INTO answer VALUES (4771, 1193, 2, 'Durch die von der Sonne ausgehende UV-Strahlung, welche die Sauerstoffatome in den verschiedenen Schichthöhen je nach Strahlungsintensität aktiviert.', ' ');
INSERT INTO answer VALUES (4772, 1193, 3, 'Durch die von der Sonne ausgehende Infrarotstrahlung, welche die Sauerstoffatome in den verschiedenen Schichthöhen je nach Strahlungsintensität aktiviert.', ' ');
INSERT INTO answer VALUES (4773, 1194, 0, 'durch die Reflexion an elektrisch aufgeladenen Luftschichten in der Ionosphäre.', ' ');
INSERT INTO answer VALUES (4774, 1194, 1, 'durch die Reflexion an Hoch- und Tiefdruckgebieten der hohen Atmosphäre.', ' ');
INSERT INTO answer VALUES (4775, 1194, 2, 'durch die Reflexion an den Wolken in der niedrigen Atmosphäre.', ' ');
INSERT INTO answer VALUES (4776, 1194, 3, 'durch die Reflexion an den parasitären Elementen einer Richtantennen.', ' ');
INSERT INTO answer VALUES (4777, 1195, 0, 'ist die im GHz-Bereich gemessene Energiestrahlung der Sonne. Fluxwerte über 100 führen zu einem stark erhöhten Ionisationsgrad in der Ionosphäre und zu einer erheblich verbesserten Fernausbreitung auf den höheren Kurzwellenbändern.', ' ');
INSERT INTO answer VALUES (4778, 1195, 1, 'ist die im Kurzwellenbereich gemessene Energiestrahlung der Sonne. Fluxwerte über 60 führen zu einem stark erhöhten Ionisationsgrad in der Ionosphäre und zu einer erheblich verbesserten Fernausbreitung auf den höheren Kurzwellenbändern.', ' ');
INSERT INTO answer VALUES (4779, 1195, 2, 'wird aus der Sonnenfleckenrelativzahl R abgeleitet und ist ein Indikator für die Aktivität der Sonne. Fluxwerte über 100 führen zu einem stark erhöhten Ionisationsgrad der D-Schicht und damit zu einer erheblichen Verschlechterung der Fernausbreitung auf den Kurzwellenbändern.', ' ');
INSERT INTO answer VALUES (4780, 1195, 3, 'wird aus der Sonnenfleckenrelativzahl R abgeleitet und ist ein Indikator für die Aktivität der Sonne. Fluxwerte über 60 führen zu einem stark erhöhten Ionisationsgrad in der Ionosphäre und zu einer erheblich verbesserten Fernausbreitung auf den höheren Kurzwellenbändern.', ' ');
INSERT INTO answer VALUES (4781, 1196, 0, 'der durch die Bodenwelle nicht mehr erreicht und durch die reflektierte Raumwelle noch nicht erreicht wird.', ' ');
INSERT INTO answer VALUES (4782, 1196, 1, 'der durch die Bodenwelle überdeckt wird, so dass schwächere DX-Stationen zugedeckt werden.', ' ');
INSERT INTO answer VALUES (4783, 1196, 2, 'der durch die Bodenwelle erreicht wird und für die Raumwelle nicht zugänglich ist.', ' ');
INSERT INTO answer VALUES (4784, 1196, 3, 'der durch die Interferenz der Bodenwelle mit der Raumwelle in einer Zone der gegenseitigen Auslöschung liegt.', ' ');
INSERT INTO answer VALUES (4785, 1197, 0, 'Die Bodenwelle folgt der Erdkrümmung und kann über den geografischen Horizont hinausreichen. Sie wird in höheren Frequenzbereichen stärker gedämpft als in niedrigeren.', ' ');
INSERT INTO answer VALUES (4786, 1197, 1, 'Die Bodenwelle folgt der Erdkrümmung und reicht nicht über den geografischen Horizont hinaus. Sie wird in höheren Frequenzbereichen stärker gedämpft als in niedrigeren.', ' ');
INSERT INTO answer VALUES (4787, 1197, 2, 'Die Bodenwelle folgt der Erdkrümmung und reicht über den geografischen Horizont hinaus. Sie wird in niedrigeren Frequenzbereichen stärker gedämpft als in höheren.', ' ');
INSERT INTO answer VALUES (4788, 1197, 3, 'Die Bodenwelle folgt der Erdkrümmung und reicht nicht über den geografischen Horizont hinaus. Sie wird in niedrigeren Frequenzbereichen stärker gedämpft als in höheren.', ' ');
INSERT INTO answer VALUES (4789, 1198, 0, 'Funkstelle B sich innerhalb der ersten Sprungzone befindet.', ' ');
INSERT INTO answer VALUES (4790, 1198, 1, 'die Boden- und Raumwellen sich bei Funkstelle B gegenseitig aufheben.', ' ');
INSERT INTO answer VALUES (4791, 1198, 2, 'zwei an verschiedenen ionosphärischen Schichten reflektierte Wellen mit auslöschender Phase bei Funkstelle B eintreffen', ' ');
INSERT INTO answer VALUES (4792, 1198, 3, 'bei Funkstelle B der Mögel-Dellinger-Effekt aufgetreten ist.', ' ');
INSERT INTO answer VALUES (4793, 1199, 0, 'die Entfernung zwischen dem Sender und dem Punkt, an dem die Raumwelle erstmals zur Erde zurückkehrt.', ' ');
INSERT INTO answer VALUES (4794, 1199, 1, 'die Entfernung zwischen dem Ende der Bodenwelle und dem Punkt, an dem die Raumwelle erstmals zur Erde zurückkehrt', ' ');
INSERT INTO answer VALUES (4795, 1199, 2, 'die maximale Entfernung vom Sender, an dem ein Signal empfangen werden kann.', ' ');
INSERT INTO answer VALUES (4796, 1199, 3, 'die Entfernung, bei dem kein Signal von Empfänger empfangen werden kann.', ' ');
INSERT INTO answer VALUES (4797, 1200, 0, 'die Änderung der Strahlungsleistung.', ' ');
INSERT INTO answer VALUES (4798, 1200, 1, 'die Änderung der Frequenz des ausgesendeten Signals.', ' ');
INSERT INTO answer VALUES (4799, 1200, 2, 'die Tageszeit.', ' ');
INSERT INTO answer VALUES (4800, 1200, 3, 'die aktuelle Höhe der ionisierten Schichten.', ' ');
INSERT INTO answer VALUES (4801, 1201, 0, 'Etwa 4000 km.', ' ');
INSERT INTO answer VALUES (4802, 1201, 1, 'Etwa 2000 km.', ' ');
INSERT INTO answer VALUES (4803, 1201, 2, 'Etwa 12000 km.', ' ');
INSERT INTO answer VALUES (4804, 1201, 3, 'Etwa 8000 km.', ' ');
INSERT INTO answer VALUES (4805, 1202, 0, '2200 km', ' ');
INSERT INTO answer VALUES (4806, 1202, 1, '1100 km', ' ');
INSERT INTO answer VALUES (4807, 1202, 2, '4500 km', ' ');
INSERT INTO answer VALUES (4808, 1202, 3, '9000 km', ' ');
INSERT INTO answer VALUES (4809, 1203, 0, 'vom Abstrahlwinkel der Antenne.', ' ');
INSERT INTO answer VALUES (4810, 1203, 1, 'von der Polarisation.', ' ');
INSERT INTO answer VALUES (4811, 1203, 2, 'von der Sendeleistung.', ' ');
INSERT INTO answer VALUES (4812, 1203, 3, 'vom Antennengewinn.', ' ');
INSERT INTO answer VALUES (4813, 1204, 0, 'Die Funkverbindung läuft nicht über den direkten Weg zur Gegenstation, sondern über die dem kürzesten Weg entgegen gesetzte Richtung.', ' ');
INSERT INTO answer VALUES (4814, 1204, 1, 'Bei guten Ausbreitungsbedingungen treten Mehrfachreflexionen mit vielen Sprüngen (hops) auf. Dann ist es möglich, sehr weite Entfernungen – "lange Wege" - zu überbrücken.', ' ');
INSERT INTO answer VALUES (4815, 1204, 2, 'Bei guten Ausbreitungsbedingungen treten Mehrfachreflexionen mit vielen Sprüngen (hops) auf. Sie hören dann Ihre eigenen Zeichen zeitverzögert als "Echo" im Empfänger wieder. Sie laufen also den "langen Weg einmal um die Erde".', ' ');
INSERT INTO answer VALUES (4816, 1204, 3, 'Bei sehr guten Ausbreitungsbedingungen liegen die reflektierenden Schichten in großer Höhe. Die Sprungsdistanzen werden dann sehr groß, so dass sie die Reichweite der Bodenwelle um ein Vielfaches übertreffen. Dann kann man mit einem Sprung einen "sehr langen Weg" zurücklegen.', ' ');
INSERT INTO answer VALUES (4817, 1205, 0, 'zirka 51°.', ' ');
INSERT INTO answer VALUES (4818, 1205, 1, 'zirka 321°.', ' ');
INSERT INTO answer VALUES (4819, 1205, 2, 'zirka 141°.', ' ');
INSERT INTO answer VALUES (4820, 1205, 3, 'zirka 129°.', ' ');
INSERT INTO answer VALUES (4821, 1206, 0, 'zirka 218°.', ' ');
INSERT INTO answer VALUES (4822, 1206, 1, 'zirka 322°.', ' ');
INSERT INTO answer VALUES (4823, 1206, 2, 'zirka 122°.', ' ');
INSERT INTO answer VALUES (4824, 1206, 3, 'zirka 308°.', ' ');
INSERT INTO answer VALUES (4825, 1207, 0, 'der Streifen der Dämmerungsphase vor Sonnenaufgang oder nach Sonnenuntergang.', ' ');
INSERT INTO answer VALUES (4826, 1207, 1, 'die instabilen Ausbreitungsbedingungen in der Äquatorialzone.', ' ');
INSERT INTO answer VALUES (4827, 1207, 2, 'die Zeit mit den besten Möglichkeiten für "shortskip" Ausbreitung.', ' ');
INSERT INTO answer VALUES (4828, 1207, 3, 'die Übergangszeit vor und nach dem Winter, in der sich die D-Schicht ab- und wieder aufbaut.', ' ');
INSERT INTO answer VALUES (4829, 1208, 0, 'den totalen, zeitlich begrenzten Ausfall der Reflexion an der Ionosphäre.', ' ');
INSERT INTO answer VALUES (4830, 1208, 1, 'den zeitlich begrenzten Schwund durch Mehrwegeausbreitung in der Ionosphäre.', ' ');
INSERT INTO answer VALUES (4831, 1208, 2, 'die zeitlich begrenzt auftretende Verzerrung der Modulation.', ' ');
INSERT INTO answer VALUES (4832, 1208, 3, 'das Übersprechen der Modulation eines starken Senders auf andere, über die Ionosphäre übertragene HF-Signale.', ' ');
INSERT INTO answer VALUES (4833, 1209, 0, 'Mögel-Dellinger-Effekt bezeichnet.', ' ');
INSERT INTO answer VALUES (4834, 1209, 1, 'sporadische E-Ausbreitung bezeichnet.', ' ');
INSERT INTO answer VALUES (4835, 1209, 2, 'kritischer Schwund bezeichnet.', ' ');
INSERT INTO answer VALUES (4836, 1209, 3, 'Aurora-Effekt bezeichnet.', ' ');
INSERT INTO answer VALUES (4837, 1210, 0, 'die D-Schicht, die dann fast die gesamte KW-Ausstrahlung absorbiert, so dass keine Ausbreitung über die Raumwelle stattfinden kann.', ' ');
INSERT INTO answer VALUES (4838, 1210, 1, 'die F2-Schicht, die dann so stark ionisiert wird, dass fast die gesamte KW-Ausstrahlung reflektiert wird.', ' ');
INSERT INTO answer VALUES (4839, 1210, 2, 'die E-Schicht, die dann für die höheren Frequenzen durchlässiger wird und durch Reflexion an der F2-Schicht für gute Ausbreitungsbedingungen sorgt.', ' ');
INSERT INTO answer VALUES (4840, 1210, 3, 'die F1-Schicht, die durch Absorption der höheren Frequenzen die Reflexion an der F2-Schicht behindert.', ' ');
INSERT INTO answer VALUES (4841, 1211, 0, 'das Zusammenwirken zwischen Raum- und Bodenwellen zurückzuführen sein.', ' ');
INSERT INTO answer VALUES (4842, 1211, 1, 'eine unzulänglich angepasste Antenne zurückzuführen sein.', ' ');
INSERT INTO answer VALUES (4843, 1211, 2, 'die Verwendung einer falschen Polarisation zurückzuführen sein.', ' ');
INSERT INTO answer VALUES (4844, 1211, 3, 'ein unzulängliches Koaxialkabel zurückzuführen sein.', ' ');
INSERT INTO answer VALUES (4845, 1212, 0, 'Es kommt zu Interferenzen der beiden Signale.', ' ');
INSERT INTO answer VALUES (4846, 1212, 1, 'Es kommt zu Reflexionen der beiden Signale.', ' ');
INSERT INTO answer VALUES (4847, 1212, 2, 'Es kommt zu Drehungen der Polarisationsebene der beiden Signale.', ' ');
INSERT INTO answer VALUES (4848, 1212, 3, 'Es kommt zu Beugungseffekten bei beiden Signalen.', ' ');
INSERT INTO answer VALUES (4849, 1213, 0, 'Inhomogenitäten in der Ionosphäre oder Troposphäre auftreten und die Betriebsfrequenz weit über der MUF liegt.', ' ');
INSERT INTO answer VALUES (4850, 1213, 1, 'Inhomogenitäten in der Ionosphäre oder Troposphäre auftreten und die Betriebsfrequenz etwas oberhalb der MUF liegt.', ' ');
INSERT INTO answer VALUES (4851, 1213, 2, 'Inhomogenitäten in der Ionosphäre oder Troposphäre auftreten und die Betriebsfrequenz etwas oberhalb der LUF liegt.', ' ');
INSERT INTO answer VALUES (4852, 1213, 3, 'intensive Korpuskularstrahlung in der Exosphäre eine ionisierte Schicht aufbaut und die Betriebsfrequenz etwas unterhalb der MUF liegt .', ' ');
INSERT INTO answer VALUES (4853, 1214, 0, 'Flatterfading.', ' ');
INSERT INTO answer VALUES (4854, 1214, 1, 'Sferic-Geräusche.', ' ');
INSERT INTO answer VALUES (4855, 1214, 2, 'Hohe Signalstärken.', ' ');
INSERT INTO answer VALUES (4856, 1214, 3, 'Breitbandiges Rauschen.', ' ');
INSERT INTO answer VALUES (4857, 1215, 0, 'durch Reflexion an einer sporadisch auftretenden E-Schicht ermöglicht werden.', ' ');
INSERT INTO answer VALUES (4858, 1215, 1, 'bei entsprechendem Abstrahlwinkel durch Reflexion an der F1-Schicht ermöglicht werden.', ' ');
INSERT INTO answer VALUES (4859, 1215, 2, 'bei entsprechendem Abstrahlwinkel durch Reflexion an der F2-Schicht ermöglicht werden.', ' ');
INSERT INTO answer VALUES (4860, 1215, 3, 'durch Reflexion an hochionisierten D-Schichten ermöglicht werden.', ' ');
INSERT INTO answer VALUES (4861, 1216, 0, 'höher sein.', ' ');
INSERT INTO answer VALUES (4862, 1216, 1, 'niedriger sein.', ' ');
INSERT INTO answer VALUES (4863, 1216, 2, 'auf Null gehen.', ' ');
INSERT INTO answer VALUES (4864, 1216, 3, 'sich nicht ändern.', ' ');
INSERT INTO answer VALUES (4865, 1217, 0, 'höchste Frequenz, die bei senkrechter Abstrahlung von der Ionosphäre noch reflektiert wird.', ' ');
INSERT INTO answer VALUES (4866, 1217, 1, 'niedrigste Frequenz, die bei senkrechter Abstrahlung von der Ionosphäre noch reflektiert wird.', ' ');
INSERT INTO answer VALUES (4867, 1217, 2, 'höchste Frequenz, die bei waagerechter Abstrahlung von der Ionosphäre noch reflektiert wird.', ' ');
INSERT INTO answer VALUES (4868, 1217, 3, 'niedrigste Frequenz, die bei waagerechter Abstrahlung von der Ionosphäre noch reflektiert wird.', ' ');
INSERT INTO answer VALUES (4869, 1218, 0, 'höchste nutzbare Frequenz bezeichnet (MUF).', ' ');
INSERT INTO answer VALUES (4870, 1218, 1, 'optimale Arbeitsfrequenz bezeichnet (F<sub>opt</sub>).', ' ');
INSERT INTO answer VALUES (4871, 1218, 2, 'kritische Grenzfrequenz bezeichnet (F<sub>krit</sub>).', ' ');
INSERT INTO answer VALUES (4872, 1218, 3, 'höchste durchlässige Frequenz bezeichnet (LUF).', ' ');
INSERT INTO answer VALUES (4873, 1219, 0, 'die höchste brauchbare Frequenz, bei der sich elektromagnetische Wellen zwischen zwei Orten durch ionosphärische Brechung ausbreiten können.', ' ');
INSERT INTO answer VALUES (4874, 1219, 1, 'der Mittelwert aus der höchsten und niedrigsten brauchbaren Frequenz, bei der sich elektromagnetische Wellen zwischen zwei Orten durch ionosphärische Brechung ausbreiten können.', ' ');
INSERT INTO answer VALUES (4875, 1219, 2, 'die niedrigste brauchbaren Frequenz, bei der sich elektromagnetische Wellen zwischen zwei Orten durch ionosphärische Brechung ausbreiten können.', ' ');
INSERT INTO answer VALUES (4876, 1219, 3, 'die vorgeschriebene nutzbare Frequenz bei der sich elektromagnetische Wellen zwischen zwei Orten durch ionosphärische Brechung ausbreiten können.', ' ');
INSERT INTO answer VALUES (4877, 1220, 0, 'einer höheren MUF.', ' ');
INSERT INTO answer VALUES (4878, 1220, 1, 'einer stärkeren Absorption der höheren Frequenzen.', ' ');
INSERT INTO answer VALUES (4879, 1220, 2, 'einer niedrigeren MUF.', ' ');
INSERT INTO answer VALUES (4880, 1220, 3, 'einer größeren Durchlässigkeit für die höheren Frequenzen.', ' ');
INSERT INTO answer VALUES (4881, 1221, 0, 'wird höher als die kritische Grenzfrequenz, wenn der Abstrahlwinkel der Sendeantenne kleiner wird.', ' ');
INSERT INTO answer VALUES (4882, 1221, 1, 'wird kleiner als die kritische Grenzfrequenz, wenn der Abstrahlwinkel der Sendeantenne kleiner wird.', ' ');
INSERT INTO answer VALUES (4883, 1221, 2, 'wird kleiner als die kritische Grenzfrequenz, wenn der Abstrahlwinkel der Sendeantenne höher wird.', ' ');
INSERT INTO answer VALUES (4884, 1221, 3, 'ist nur abhängig vom Ionisierungsgrad der D-, E- und F-Schichten.', ' ');
INSERT INTO answer VALUES (4885, 1222, 0, 'Die MUF liegt bei 4,2 MHz und fopt bei 3,6 MHz.', ' ');
INSERT INTO answer VALUES (4886, 1222, 1, 'Die MUF liegt bei 2,1 MHz und fopt bei 1,8 MHz.', ' ');
INSERT INTO answer VALUES (4887, 1222, 2, 'Die MUF liegt bei 2,1 MHz und fopt bei 2,5 MHz.', ' ');
INSERT INTO answer VALUES (4888, 1222, 3, 'Die MUF liegt bei 4,2 MHz und fopt bei 4,9 MHz.', ' ');
INSERT INTO answer VALUES (4889, 1223, 0, 'Bei Einstrahlung in die Ionosphäre unter einem Winkel von 90° liegt die höchste noch reflektierte Signalfrequenz bei 22 MHz.', ' ');
INSERT INTO answer VALUES (4890, 1223, 1, 'Bei Einstrahlung in die Ionosphäre unter einem Winkel von 90° liegt die niedrigste noch reflektierte Signalfrequenz bei 22 MHz.', ' ');
INSERT INTO answer VALUES (4891, 1223, 2, 'Bei Einstrahlung in die Ionosphäre unter einem Winkel von 45° liegt die höchste noch reflektierte Signalfrequenz bei 22 MHz.', ' ');
INSERT INTO answer VALUES (4892, 1223, 3, 'Bei Einstrahlung in die Ionosphäre unter einem Winkel von 45° liegt die niedrigste noch reflektierte Signalfrequenz bei 22 MHz.', ' ');
INSERT INTO answer VALUES (4893, 1224, 0, 'Die niedrigste Frequenz im KW-Bereich, die für Verbindungen über die Raumwelle als noch brauchbar angesehen wird, liegt bei 6 MHz.', ' ');
INSERT INTO answer VALUES (4894, 1224, 1, 'Die höchste Frequenz im KW-Bereich, die für Verbindungen über die Raumwelle als noch brauchbar angesehen wird, liegt bei 6 MHz.', ' ');
INSERT INTO answer VALUES (4895, 1224, 2, 'Die mittlere Frequenz im KW-Bereich, die für Verbindungen über die Raumwelle genutzt werden kann, liegt bei 6 MHz.', ' ');
INSERT INTO answer VALUES (4896, 1224, 3, 'Die optimale Frequenz, im KW-Bereich, die für Verbindungen über die Raumwelle genutzt werden kann, liegt bei 6 MHz.', ' ');
INSERT INTO answer VALUES (4897, 1225, 0, 'die niedrigste brauchbare Frequenz im KW-Bereich, bei der die Verbindung zwischen zwei Orten über die Raumwelle hergestellt werden kann.', ' ');
INSERT INTO answer VALUES (4898, 1225, 1, 'der Mittelwert der höchsten und niedrigsten brauchbaren Frequenz im KW-Bereich, bei der die Verbindung zwischen zwei Orten über die Raumwelle hergestellt werden kann.', ' ');
INSERT INTO answer VALUES (4899, 1225, 2, 'die gemessene brauchbare Frequenz im KW-Bereich, bei der die Verbindung zwischen zwei Orten über die Raumwelle hergestellt werden kann.', ' ');
INSERT INTO answer VALUES (4900, 1225, 3, 'die geeignetste brauchbare Frequenz im KW-Bereich, bei der die Verbindung zwischen zwei Orten über die Raumwelle hergestellt werden kann.', ' ');
INSERT INTO answer VALUES (4901, 1226, 0, '10-m-Band.', ' ');
INSERT INTO answer VALUES (4902, 1226, 1, '15-m-Band.', ' ');
INSERT INTO answer VALUES (4903, 1226, 2, '20-m-Band.', ' ');
INSERT INTO answer VALUES (4904, 1226, 3, '40-m-Band.', ' ');
INSERT INTO answer VALUES (4905, 1227, 0, '15-m-Band.', ' ');
INSERT INTO answer VALUES (4906, 1227, 1, '80-m-Band.', ' ');
INSERT INTO answer VALUES (4907, 1227, 2, '20-m-Band.', ' ');
INSERT INTO answer VALUES (4908, 1227, 3, '40-m-Band.', ' ');
INSERT INTO answer VALUES (4909, 1228, 0, '20-m-Band.', ' ');
INSERT INTO answer VALUES (4910, 1228, 1, '15-m-Band.', ' ');
INSERT INTO answer VALUES (4911, 1228, 2, '30-m-Band.', ' ');
INSERT INTO answer VALUES (4912, 1228, 3, '40-m-Band.', ' ');
INSERT INTO answer VALUES (4913, 1229, 0, '40-m-Band.', ' ');
INSERT INTO answer VALUES (4914, 1229, 1, '20-m-Band.', ' ');
INSERT INTO answer VALUES (4915, 1229, 2, '30-m-Band.', ' ');
INSERT INTO answer VALUES (4916, 1229, 3, '80-m-Band.', ' ');
INSERT INTO answer VALUES (4917, 1230, 0, '80-m-Band.', ' ');
INSERT INTO answer VALUES (4918, 1230, 1, '20-m-Band.', ' ');
INSERT INTO answer VALUES (4919, 1230, 2, '30-m-Band.', ' ');
INSERT INTO answer VALUES (4920, 1230, 3, '40-m-Band.', ' ');
INSERT INTO answer VALUES (4921, 1231, 0, 'über die Bodenwellen, weil durch die Dämpfung der D-Schicht keine Raumwellen entstehen können.', ' ');
INSERT INTO answer VALUES (4922, 1231, 1, 'über die Raumwellen, weil die Reflexionen an der D-Schicht für Frequenzen bis zu 2 MHz besonders stark sind.', ' ');
INSERT INTO answer VALUES (4923, 1231, 2, 'über Raum- und Bodenwellen, weil es bei den Frequenzen unter 2 MHz nur zu geringfügiger Phasenverschiebung zwischen reflektierten und direkten Wellen kommt.', ' ');
INSERT INTO answer VALUES (4924, 1231, 3, 'über die Raumwelle, weil es in der Troposphäre durch Temperaturinversionen zu Reflexionen für die Frequenzen unter 2 MHz kommen kann.', ' ');
INSERT INTO answer VALUES (4925, 1232, 0, 'Wegen der Tagesdämpfung in der D-Schicht.', ' ');
INSERT INTO answer VALUES (4926, 1232, 1, 'Wegen der Tagesdämpfung in der F1-Schicht.', ' ');
INSERT INTO answer VALUES (4927, 1232, 2, 'Wegen der Tagesdämpfung in der F2-Schicht.', ' ');
INSERT INTO answer VALUES (4928, 1232, 3, 'Wegen der Tagesdämpfung in der A-Schicht.', ' ');
INSERT INTO answer VALUES (4929, 1233, 0, '40-m-Band', ' ');
INSERT INTO answer VALUES (4930, 1233, 1, '160-m-Band', ' ');
INSERT INTO answer VALUES (4931, 1233, 2, '80-m-Band', ' ');
INSERT INTO answer VALUES (4932, 1233, 3, '15-m-Band', ' ');
INSERT INTO answer VALUES (4933, 1234, 0, '14 MHz', ' ');
INSERT INTO answer VALUES (4934, 1234, 1, '3,5 MHz', ' ');
INSERT INTO answer VALUES (4935, 1234, 2, '28 MHz', ' ');
INSERT INTO answer VALUES (4936, 1234, 3, '7 MHz', ' ');
INSERT INTO answer VALUES (4937, 1235, 0, 'Etwa 15 % weiter als der geographische Horizont.', ' ');
INSERT INTO answer VALUES (4938, 1235, 1, 'Etwa doppelt so weit.', ' ');
INSERT INTO answer VALUES (4939, 1235, 2, 'Etwa bis zur Hälfte der Entfernung bis zum geographischen Horizont.', ' ');
INSERT INTO answer VALUES (4940, 1235, 3, 'Etwa bis zum Vierfachen der Entfernung bis zum geographischen Horizont.', ' ');
INSERT INTO answer VALUES (4941, 1236, 0, 'Streuung der Wellen an troposphärischen Bereichen unterschiedlicher Beschaffenheit.', ' ');
INSERT INTO answer VALUES (4942, 1236, 1, 'Reflexion der Wellen in der Troposphäre durch das Auftreten sporadischer D-Schichten.', ' ');
INSERT INTO answer VALUES (4943, 1236, 2, 'Polarisationsdrehungen in der Troposphäre bei hoch liegender Bewölkung.', ' ');
INSERT INTO answer VALUES (4944, 1236, 3, 'Polarisationsdrehungen in der Troposphäre an Gewitterfronten.', ' ');
INSERT INTO answer VALUES (4945, 1237, 0, 'Brechung und Streuung der Wellen in troposphärischen Bereichen mit unterschiedlichem Brechungsindex.', ' ');
INSERT INTO answer VALUES (4946, 1237, 1, 'Reflexion der Wellen in der Troposphäre durch das Auftreten sporadischer D-Schichten.', ' ');
INSERT INTO answer VALUES (4947, 1237, 2, 'Polarisationsdrehungen in der Troposphäre bei hoch liegender Bewölkung.', ' ');
INSERT INTO answer VALUES (4948, 1237, 3, 'Polarisationsdrehungen in der Troposphäre an Gewitterfronten.', ' ');
INSERT INTO answer VALUES (4949, 1238, 0, 'troposphärische Ductübertragung beim Auftreten von Inversionsschichten.', ' ');
INSERT INTO answer VALUES (4950, 1238, 1, 'Reflexion der Wellen in der Troposphäre durch das Auftreten sporadischer D-Schichten.', ' ');
INSERT INTO answer VALUES (4951, 1238, 2, 'Polarisationsdrehungen in der Troposphäre bei hoch liegender Bewölkung.', ' ');
INSERT INTO answer VALUES (4952, 1238, 3, 'Polarisationsdrehungen in der Troposphäre an Gewitterfronten.', ' ');
INSERT INTO answer VALUES (4953, 1239, 0, 'troposphärische Ausbreitung genutzt.', ' ');
INSERT INTO answer VALUES (4954, 1239, 1, 'ionosphärische Ausbreitung genutzt.', ' ');
INSERT INTO answer VALUES (4955, 1239, 2, 'Bodenwellenausbreitung genutzt.', ' ');
INSERT INTO answer VALUES (4956, 1239, 3, 'Oberflächenwellenausbreitung genutzt.', ' ');
INSERT INTO answer VALUES (4957, 1240, 0, 'der untere Teil der Atmosphäre, in der die Erscheinungen des Wetters stattfinden.', ' ');
INSERT INTO answer VALUES (4958, 1240, 1, 'der untere Teil der Atmosphäre, der sich nördlich und südlich des Äquators über die Tropen erstreckt.', ' ');
INSERT INTO answer VALUES (4959, 1240, 2, 'der obere Teil der Atmosphäre, in der es zur Bildung sporadischer E-Schichten kommen kann.', ' ');
INSERT INTO answer VALUES (4960, 1240, 3, 'der obere Teil der Atmosphäre, in welcher Aurora-Erscheinungen auftreten können.', ' ');
INSERT INTO answer VALUES (4961, 1241, 0, 'Die Reichweite steigt mit zunehmender Antennenhöhe, weil die optische Sichtweite zunimmt.', ' ');
INSERT INTO answer VALUES (4962, 1241, 1, 'Die Reichweite steigt mit zunehmender Antennenhöhe, weil die dämpfende Wirkung der Erdoberfläche abnimmt.', ' ');
INSERT INTO answer VALUES (4963, 1241, 2, 'Die Reichweite steigt mit zunehmender Antennenhöhe, weil die Entfernung zu den reflektierenden Schichten der Troposphäre abnimmt.', ' ');
INSERT INTO answer VALUES (4964, 1241, 3, 'Die Reichweite steigt mit zunehmen der Antennenhöhe, weil viele Sekundärstrahler an der Ausbreitung beteiligt sind.', ' ');
INSERT INTO answer VALUES (4965, 1242, 0, 'mit dem Polarlicht stark ionisierte Bereiche auftreten, die Reflexionen erzeugen.', ' ');
INSERT INTO answer VALUES (4966, 1242, 1, 'mit dem Polarlicht starke Magnetfelder auftreten, die Reflexionen erzeugen.', ' ');
INSERT INTO answer VALUES (4967, 1242, 2, 'mit dem Polarlicht starke Inversionsfelder auftreten, die Reflexionen erzeugen.', ' ');
INSERT INTO answer VALUES (4968, 1242, 3, 'mit dem Polarlicht starke sporadische D-Schichten auftreten, die Reflexionen erzeugen.', ' ');
INSERT INTO answer VALUES (4969, 1243, 0, 'Das Eindringen geladener Teilchen von der Sonne in die Atmosphäre.', ' ');
INSERT INTO answer VALUES (4970, 1243, 1, 'Eine hohe Sonnenfleckenzahl.', ' ');
INSERT INTO answer VALUES (4971, 1243, 2, 'Eine niedrige Sonnenfleckenzahl.', ' ');
INSERT INTO answer VALUES (4972, 1243, 3, 'Auftreten von Meteoritenschauern in den polaren Regionen.', ' ');
INSERT INTO answer VALUES (4973, 1244, 0, 'CW-Signale haben einen flatternden und verbrummten Ton.', ' ');
INSERT INTO answer VALUES (4974, 1244, 1, 'CW- Signale haben einen besseren Ton.', ' ');
INSERT INTO answer VALUES (4975, 1244, 2, 'Die Lesbarkeit der SSB-Signale verbessert sich.', ' ');
INSERT INTO answer VALUES (4976, 1244, 3, 'Die Lesbarkeit der FM-Signale verbessert sich.', ' ');
INSERT INTO answer VALUES (4977, 1245, 0, 'E-Schicht.', ' ');
INSERT INTO answer VALUES (4978, 1245, 1, 'F-Schicht.', ' ');
INSERT INTO answer VALUES (4979, 1245, 2, 'E-Schicht in Äquatornähe.', ' ');
INSERT INTO answer VALUES (4980, 1245, 3, 'D-Schicht.', ' ');
INSERT INTO answer VALUES (4981, 1246, 0, 'CW', ' ');
INSERT INTO answer VALUES (4982, 1246, 1, 'SSB', ' ');
INSERT INTO answer VALUES (4983, 1246, 2, 'FM', ' ');
INSERT INTO answer VALUES (4984, 1246, 3, 'RTTY', ' ');
INSERT INTO answer VALUES (4985, 1247, 0, 'in den Polargebieten.', ' ');
INSERT INTO answer VALUES (4986, 1247, 1, 'in den äquatorialen Gebieten.', ' ');
INSERT INTO answer VALUES (4987, 1247, 2, 'im Bereich der Sonnenflecken.', ' ');
INSERT INTO answer VALUES (4988, 1247, 3, 'in den tropischen Regionen.', ' ');
INSERT INTO answer VALUES (4989, 1248, 0, 'besonders stark ionisierten Bereichen der E-Schicht.', ' ');
INSERT INTO answer VALUES (4990, 1248, 1, 'Inversionen am unteren Rand der E-Schicht.', ' ');
INSERT INTO answer VALUES (4991, 1248, 2, 'geomagnetischen Störungen am unteren Rand der E-Schicht.', ' ');
INSERT INTO answer VALUES (4992, 1248, 3, 'Ionisationsspuren von Meteoriten in der E-Schicht.', ' ');
INSERT INTO answer VALUES (4993, 1249, 0, 'eine Reflexion an lokal begrenzten Bereichen mit ungewöhnlich hoher Ionisation innerhalb der E-Schicht.', ' ');
INSERT INTO answer VALUES (4994, 1249, 1, 'eine kurzfristige, plötzliche Inversionsänderung in der E-Schicht, die Fernausbreitung im VHF-Bereich ermöglicht.', ' ');
INSERT INTO answer VALUES (4995, 1249, 2, 'eine kurzzeitig auftretende, starke Reflexion von VHF-Signalen an Meteorbahnen innerhalb der E-Schicht.', ' ');
INSERT INTO answer VALUES (4996, 1249, 3, 'ein lokal begrenzter, kurzzeitiger Ausfall der Reflexion durch ungewöhnlich hohe Ionisation innerhalb der E-Schicht.', ' ');
INSERT INTO answer VALUES (4997, 1250, 0, 'in der nördlichen Hemisphäre.', ' ');
INSERT INTO answer VALUES (4998, 1250, 1, 'in Äquatornähe.', ' ');
INSERT INTO answer VALUES (4999, 1250, 2, 'in der arktischen Region.', ' ');
INSERT INTO answer VALUES (5000, 1250, 3, 'in den Polregionen.', ' ');
INSERT INTO answer VALUES (5001, 1251, 0, 'Die MUF ist hoch.', ' ');
INSERT INTO answer VALUES (5002, 1251, 1, 'Die LUF ist niedrig.', ' ');
INSERT INTO answer VALUES (5003, 1251, 2, 'UKW-Wellen werden an der F2-Schicht reflektiert.', ' ');
INSERT INTO answer VALUES (5004, 1251, 3, 'UKW-Wellen werden an der F1-Schicht reflektiert.', ' ');
INSERT INTO answer VALUES (5005, 1252, 0, 'der Wechselwirkung der Kräfte zwischen einem permanent magnetischen und einem elektromagnetischen Feld.', ' ');
INSERT INTO answer VALUES (5006, 1252, 1, 'der Wechselwirkung der Kräfte zwischen einem magnetischen und einem elektrischen Feld.', ' ');
INSERT INTO answer VALUES (5007, 1252, 2, 'der Wechselwirkung der Kräfte zwischen zwei permanent magnetischen Feldern.', ' ');
INSERT INTO answer VALUES (5008, 1252, 3, 'dem erdmagnetischen Feld.', ' ');
INSERT INTO answer VALUES (5009, 1253, 0, '50 Volt', ' ');
INSERT INTO answer VALUES (5010, 1253, 1, '10 Volt', ' ');
INSERT INTO answer VALUES (5011, 1253, 2, '500 Volt', ' ');
INSERT INTO answer VALUES (5012, 1253, 3, '100 Volt', ' ');
INSERT INTO answer VALUES (5013, 1254, 0, '3 Volt', ' ');
INSERT INTO answer VALUES (5014, 1254, 1, '10 Volt', ' ');
INSERT INTO answer VALUES (5015, 1254, 2, '30 Volt', ' ');
INSERT INTO answer VALUES (5016, 1254, 3, '1 Volt', ' ');
INSERT INTO answer VALUES (5017, 1255, 0, '1 &Omega;', ' ');
INSERT INTO answer VALUES (5018, 1255, 1, '10 &Omega;', ' ');
INSERT INTO answer VALUES (5019, 1255, 2, '0,1 &Omega;', ' ');
INSERT INTO answer VALUES (5020, 1255, 3, '100 &Omega;', ' ');
INSERT INTO answer VALUES (5021, 1256, 0, '0,999 A.', ' ');
INSERT INTO answer VALUES (5022, 1256, 1, '0,9 A.', ' ');
INSERT INTO answer VALUES (5023, 1256, 2, '1 mA.', ' ');
INSERT INTO answer VALUES (5024, 1256, 3, '99 mA.', ' ');
INSERT INTO answer VALUES (5025, 1257, 0, '0,3 &Omega;', ' ');
INSERT INTO answer VALUES (5026, 1257, 1, '0,03 &Omega;', ' ');
INSERT INTO answer VALUES (5027, 1257, 2, '3 &Omega;', ' ');
INSERT INTO answer VALUES (5028, 1257, 3, '30 &Omega;', ' ');
INSERT INTO answer VALUES (5029, 1258, 0, 'R<sub>V</sub> = 9 k&Omega; P<sub>V</sub> = 36 mW', ' ');
INSERT INTO answer VALUES (5030, 1258, 1, 'R<sub>V</sub> = 10 k&Omega; P<sub>V</sub> = 40 mW', ' ');
INSERT INTO answer VALUES (5031, 1258, 2, 'R<sub>V</sub> = 9 k&Omega; P<sub>V</sub> = 4 mW', ' ');
INSERT INTO answer VALUES (5032, 1258, 3, 'R<sub>V</sub> = 0,1 M&Omega; P<sub>V</sub> = 131 mW', ' ');
INSERT INTO answer VALUES (5033, 1259, 0, 'Durch Parallelschaltung mit R<sub>p</sub> = 1/4 * R<sub>i</sub>', ' ');
INSERT INTO answer VALUES (5034, 1259, 1, 'Durch Parallelschaltung mit R<sub>p</sub> = 5 * R<sub>i</sub>', ' ');
INSERT INTO answer VALUES (5035, 1259, 2, 'Durch Reihenschaltung mit R<sub>v</sub> = 1/4 * R<sub>i</sub>', ' ');
INSERT INTO answer VALUES (5036, 1259, 3, 'Durch Reihenschaltung mit R<sub>v</sub> = 5 * R<sub>i</sub>', ' ');
INSERT INTO answer VALUES (5037, 1260, 0, 'Durch Reihenschaltung mit R<sub>v</sub> = 7 * R<sub>i</sub>', ' ');
INSERT INTO answer VALUES (5038, 1260, 1, 'Durch Reihenschaltung mit R<sub>v</sub> = 8 * R<sub>i</sub>', ' ');
INSERT INTO answer VALUES (5039, 1260, 2, 'Durch Reihenschaltung mit R<sub>v</sub> = 1/8 * R<sub>i</sub>', ' ');
INSERT INTO answer VALUES (5040, 1260, 3, 'Durch Reihenschaltung mit R<sub>p</sub> = 1/7 * R<sub>i</sub>', ' ');
INSERT INTO answer VALUES (5041, 1261, 0, '0,25 mA', ' ');
INSERT INTO answer VALUES (5042, 1261, 1, '2,5 mA', ' ');
INSERT INTO answer VALUES (5043, 1261, 2, '2,5 µA', ' ');
INSERT INTO answer VALUES (5044, 1261, 3, '400 µA', ' ');
INSERT INTO answer VALUES (5045, 1262, 0, '50 µA', ' ');
INSERT INTO answer VALUES (5046, 1262, 1, '5 mA', ' ');
INSERT INTO answer VALUES (5047, 1262, 2, '50 mA', ' ');
INSERT INTO answer VALUES (5048, 1262, 3, '500 µA', ' ');
INSERT INTO answer VALUES (5049, 1263, 0, '100 µA.', ' ');
INSERT INTO answer VALUES (5050, 1263, 1, '10 µA.', ' ');
INSERT INTO answer VALUES (5051, 1263, 2, '50 µA.', ' ');
INSERT INTO answer VALUES (5052, 1263, 3, '200 µA.', ' ');
INSERT INTO answer VALUES (5053, 1264, 0, 'der kleinsten Einteilung der Anzeige.', ' ');
INSERT INTO answer VALUES (5054, 1264, 1, 'der Genauigkeit des Instruments in Bezug auf den tatsächlichen Wert.', ' ');
INSERT INTO answer VALUES (5055, 1264, 2, 'der Genauigkeit des Instruments.', ' ');
INSERT INTO answer VALUES (5056, 1264, 3, 'dem Vollausschlag der Instrumentenanzeige.', ' ');
INSERT INTO answer VALUES (5057, 1265, 0, 'Digitalvoltmeter', ' ');
INSERT INTO answer VALUES (5058, 1265, 1, 'Interferenzwellenmesser', ' ');
INSERT INTO answer VALUES (5059, 1265, 2, 'Digitaloszilloskop', ' ');
INSERT INTO answer VALUES (5060, 1265, 3, 'Elektronisches Analogvoltmeter', ' ');
INSERT INTO answer VALUES (5061, 1266, 0, 'ca. 1,5 % vom Endausschlag.', ' ');
INSERT INTO answer VALUES (5062, 1266, 1, 'ca. 0,3 % vom Ablesewert.', ' ');
INSERT INTO answer VALUES (5063, 1266, 2, 'ca. 0,3 % vom Endausschlag.', ' ');
INSERT INTO answer VALUES (5064, 1266, 3, 'ca. 0,05 % vom Ablesewert.', ' ');
INSERT INTO answer VALUES (5065, 1267, 0, '2,93 V', ' ');
INSERT INTO answer VALUES (5066, 1267, 1, '29,3 V', ' ');
INSERT INTO answer VALUES (5067, 1267, 2, '8,8 V', ' ');
INSERT INTO answer VALUES (5068, 1267, 3, '88 V', ' ');
INSERT INTO answer VALUES (5069, 1268, 0, '88 V', ' ');
INSERT INTO answer VALUES (5070, 1268, 1, '29,3 V', ' ');
INSERT INTO answer VALUES (5071, 1268, 2, '8,8 V', ' ');
INSERT INTO answer VALUES (5072, 1268, 3, '293 V', ' ');
INSERT INTO answer VALUES (5073, 1269, 0, 'ein abstimmbarer Oszillator mit Drehspulmesswerk, das anzeigt, wenn dem Oszillator durch einen angekoppelten Schwingkreis bei einer Frequenz Energie entzogen oder zugeführt wird.', ' ');
INSERT INTO answer VALUES (5074, 1269, 1, 'ein selektiver Feldstärkemesser, der den Maximalwert der elektrischen Feldstärke anzeigt und der zur Überprüfung der Nutzsignal- und Nebenwellenabstrahlungen eingesetzt werden kann.', ' ');
INSERT INTO answer VALUES (5075, 1269, 2, 'eine abgleichbare Stehwellenmessbrücke, mit der der Reflexionsfaktor und der Impedanzverlauf einer angeschlossenen Antenne oder einer LC-Kombination gemessen werden kann.', ' ');
INSERT INTO answer VALUES (5076, 1269, 3, 'ein auf eine feste Frequenz eingestellter RC-Schwingkreis mit einem Indikator, der anzeigt, wie stark die Abstrahlung unerwünschter Oberwellen ist.', ' ');
INSERT INTO answer VALUES (5077, 1270, 0, 'liefert eine Aussage über die Schwingkreisamplitude im Oszillator.', ' ');
INSERT INTO answer VALUES (5078, 1270, 1, 'zeigt die von der Oszillatorspule abgestrahlte Leistung in mW an.', ' ');
INSERT INTO answer VALUES (5079, 1270, 2, 'zeigt die ungefähre Frequenz des Oszillators an.', ' ');
INSERT INTO answer VALUES (5080, 1270, 3, 'liefert eine Aussage über den Spitzenwert des Modulationsgrades.', ' ');
INSERT INTO answer VALUES (5081, 1271, 0, 'Zur Prüfung der Schwingkreisresonanz in Sendern und Empfängern.', ' ');
INSERT INTO answer VALUES (5082, 1271, 1, 'Zur ungefähren Bestimmung der Leistung eines Senders.', ' ');
INSERT INTO answer VALUES (5083, 1271, 2, 'Zur genauen Bestimmung der Dämpfung eines Schwingkreises.', ' ');
INSERT INTO answer VALUES (5084, 1271, 3, 'Zur genauen Bestimmung der Güte eines Schwingkreises.', ' ');
INSERT INTO answer VALUES (5085, 1272, 0, 'Zur Feststellung der Resonanzfrequenz von Schwingkreisen.', ' ');
INSERT INTO answer VALUES (5086, 1272, 1, 'Zur ungefähren Bestimmung der Leistung eines Senders.', ' ');
INSERT INTO answer VALUES (5087, 1272, 2, 'Zur genauen Bestimmung der Dämpfung eines Schwingkreises.', ' ');
INSERT INTO answer VALUES (5088, 1272, 3, 'Zur genauen Bestimmung der Güte eines Schwingkreises.', ' ');
INSERT INTO answer VALUES (5089, 1273, 0, 'Zur Feststellung der Schwingfrequenz und des Funktionierens eines Oszillators.', ' ');
INSERT INTO answer VALUES (5090, 1273, 1, 'Zur ungefähren Bestimmung der Leistung eines Senders.', ' ');
INSERT INTO answer VALUES (5091, 1273, 2, 'Zur genauen Bestimmung der Dämpfung eines Schwingkreises.', ' ');
INSERT INTO answer VALUES (5092, 1273, 3, 'Zur genauen Bestimmung der Güte eines Schwingkreises.', ' ');
INSERT INTO answer VALUES (5093, 1274, 0, '10 %.', ' ');
INSERT INTO answer VALUES (5094, 1274, 1, '1 %.', ' ');
INSERT INTO answer VALUES (5095, 1274, 2, '0,05 %.', ' ');
INSERT INTO answer VALUES (5096, 1274, 3, '0,001 %.', ' ');
INSERT INTO answer VALUES (5097, 1275, 0, '± 213 kHz', ' ');
INSERT INTO answer VALUES (5098, 1275, 1, '± 21,3 kHz', ' ');
INSERT INTO answer VALUES (5099, 1275, 2, '± 135 kHz', ' ');
INSERT INTO answer VALUES (5100, 1275, 3, '± 13,5 kHz', ' ');
INSERT INTO answer VALUES (5101, 1276, 0, '± 135 kHz', ' ');
INSERT INTO answer VALUES (5102, 1276, 1, '± 13,5 kHz', ' ');
INSERT INTO answer VALUES (5103, 1276, 2, '± 213 kHz', ' ');
INSERT INTO answer VALUES (5104, 1276, 3, '± 213 Hz', ' ');
INSERT INTO answer VALUES (5105, 1277, 0, '5,7 µH', ' ');
INSERT INTO answer VALUES (5106, 1277, 1, '5,7 mH', ' ');
INSERT INTO answer VALUES (5107, 1277, 2, '2,5 µH', ' ');
INSERT INTO answer VALUES (5108, 1277, 3, '2,5 mH', ' ');
INSERT INTO answer VALUES (5109, 1278, 0, '2,5 µH', ' ');
INSERT INTO answer VALUES (5110, 1278, 1, '5,7 mH', ' ');
INSERT INTO answer VALUES (5111, 1278, 2, '2,5 mH', ' ');
INSERT INTO answer VALUES (5112, 1278, 3, '5,7 µH', ' ');
INSERT INTO answer VALUES (5113, 1279, 0, 'Dipmeter', ' ');
INSERT INTO answer VALUES (5114, 1279, 1, 'SWR-Messbrücke', ' ');
INSERT INTO answer VALUES (5115, 1279, 2, 'Frequenzmessgerät', ' ');
INSERT INTO answer VALUES (5116, 1279, 3, 'Absorptionsfrequenzmesser', ' ');
INSERT INTO answer VALUES (5117, 1280, 0, '250 Hz', ' ');
INSERT INTO answer VALUES (5118, 1280, 1, '500 Hz', ' ');
INSERT INTO answer VALUES (5119, 1280, 2, '667 Hz', ' ');
INSERT INTO answer VALUES (5120, 1280, 3, '333 Hz', ' ');
INSERT INTO answer VALUES (5121, 1281, 0, '4 ms', ' ');
INSERT INTO answer VALUES (5122, 1281, 1, '2 ms', ' ');
INSERT INTO answer VALUES (5123, 1281, 2, '1,5 ms', ' ');
INSERT INTO answer VALUES (5124, 1281, 3, '3 ms', ' ');
INSERT INTO answer VALUES (5125, 1282, 0, 'eine Triggereinrichtung haben.', ' ');
INSERT INTO answer VALUES (5126, 1282, 1, 'einen X-Vorteiler haben.', ' ');
INSERT INTO answer VALUES (5127, 1282, 2, 'einen Y-Vorteiler haben.', ' ');
INSERT INTO answer VALUES (5128, 1282, 3, 'einen Frequenzmarken-Generator haben.', ' ');
INSERT INTO answer VALUES (5129, 1283, 0, 'Oszilloskop', ' ');
INSERT INTO answer VALUES (5130, 1283, 1, 'Absorptionsfrequenzmesser', ' ');
INSERT INTO answer VALUES (5131, 1283, 2, 'Frequenzzähler', ' ');
INSERT INTO answer VALUES (5132, 1283, 3, 'Dipmeter', ' ');
INSERT INTO answer VALUES (5133, 1284, 0, 'Oszilloskop', ' ');
INSERT INTO answer VALUES (5134, 1284, 1, 'Transistorvoltmeter', ' ');
INSERT INTO answer VALUES (5135, 1284, 2, 'Vielfachmessgerät', ' ');
INSERT INTO answer VALUES (5136, 1284, 3, 'Frequenzzähler', ' ');
INSERT INTO answer VALUES (5137, 1285, 0, 'ein Reflektometer.', ' ');
INSERT INTO answer VALUES (5138, 1285, 1, 'ein Impedanzmessgerät.', ' ');
INSERT INTO answer VALUES (5139, 1285, 2, 'einen Absolutleistungsmesser.', ' ');
INSERT INTO answer VALUES (5140, 1285, 3, 'einen Absorptionsfrequenzmesser.', ' ');
INSERT INTO answer VALUES (5141, 1286, 0, 'zur Überprüfung der Anpassung.', ' ');
INSERT INTO answer VALUES (5142, 1286, 1, 'zur Frequenzkontrolle.', ' ');
INSERT INTO answer VALUES (5143, 1286, 2, 'zur Modulationskontrolle.', ' ');
INSERT INTO answer VALUES (5144, 1286, 3, 'als Abschluss des Senders.', ' ');
INSERT INTO answer VALUES (5145, 1287, 0, 'die Summen der Spannungen, die kapazitiv und induktiv bei einer Koppelschleife einkoppeln.', ' ');
INSERT INTO answer VALUES (5146, 1287, 1, 'die vorhandene Impedanz in Vor- und Rückrichtung der Leitung.', ' ');
INSERT INTO answer VALUES (5147, 1287, 2, 'die vorlaufende und rücklaufende Leistung am eingebauten Abschlusswiderstand.', ' ');
INSERT INTO answer VALUES (5148, 1287, 3, 'die Maximalspannung (Umax) und die Minimalspannung (Umin) auf der Leitung.', ' ');
INSERT INTO answer VALUES (5149, 1288, 0, 'ein Stehwellenverhältnis von 1 anzeigen.', ' ');
INSERT INTO answer VALUES (5150, 1288, 1, 'einen Rücklauf von 100% anzeigen.', ' ');
INSERT INTO answer VALUES (5151, 1288, 2, 'ein Stehwellenverhältnis von 0 anzeigen.', ' ');
INSERT INTO answer VALUES (5152, 1288, 3, 'ein Stehwellenverhältnis von 1:0 anzeigen.', ' ');
INSERT INTO answer VALUES (5153, 1289, 0, 'Reflektometer', ' ');
INSERT INTO answer VALUES (5154, 1289, 1, 'Universalmessgerät mit Widerstandsanzeige', ' ');
INSERT INTO answer VALUES (5155, 1289, 2, 'Interferometer', ' ');
INSERT INTO answer VALUES (5156, 1289, 3, 'Anpassungsübertrager', ' ');
INSERT INTO answer VALUES (5157, 1290, 0, '25 %', ' ');
INSERT INTO answer VALUES (5158, 1290, 1, '33 %', ' ');
INSERT INTO answer VALUES (5159, 1290, 2, '50 %', ' ');
INSERT INTO answer VALUES (5160, 1290, 3, '75 %', ' ');
INSERT INTO answer VALUES (5161, 1291, 0, 'einen Frequenzzähler verwenden.', ' ');
INSERT INTO answer VALUES (5162, 1291, 1, 'ein Dipmeter verwenden.', ' ');
INSERT INTO answer VALUES (5163, 1291, 2, 'einen Absorptionsfrequenzmesser verwenden.', ' ');
INSERT INTO answer VALUES (5164, 1291, 3, 'ein Oszilloskop verwenden.', ' ');
INSERT INTO answer VALUES (5165, 1292, 0, 'mit einer temperaturstabilisierten Quarzzeitbasis ausgestattet sein.', ' ');
INSERT INTO answer VALUES (5166, 1292, 1, 'mit einem 1:10 Vorteiler ausgestattet sein.', ' ');
INSERT INTO answer VALUES (5167, 1292, 2, 'mit einer möglichst kurzen Torzeit betrieben werden.', ' ');
INSERT INTO answer VALUES (5168, 1292, 3, 'mit einer Triggereinrichtung ausgestattet sein.', ' ');
INSERT INTO answer VALUES (5169, 1293, 0, 'die genaue Messung einer Senderfrequenz erfolgen.', ' ');
INSERT INTO answer VALUES (5170, 1293, 1, 'die genaue Messung der Oberschwingungsanteile eines Senders erfolgen.', ' ');
INSERT INTO answer VALUES (5171, 1293, 2, 'die Messung des Seitenbandinhalts eines Senders erfolgen.', ' ');
INSERT INTO answer VALUES (5172, 1293, 3, 'die Messung des Frequenzhubes eines FM-Senders erfolgen.', ' ');
INSERT INTO answer VALUES (5173, 1294, 0, '100 Hz.', ' ');
INSERT INTO answer VALUES (5174, 1294, 1, '10 Hz.', ' ');
INSERT INTO answer VALUES (5175, 1294, 2, '1 kHz.', ' ');
INSERT INTO answer VALUES (5176, 1294, 3, '100 MHz.', ' ');
INSERT INTO answer VALUES (5177, 1295, 0, 'Frequenzzähler', ' ');
INSERT INTO answer VALUES (5178, 1295, 1, 'Absorptionsfrequenzmesser', ' ');
INSERT INTO answer VALUES (5179, 1295, 2, 'Oszilloskop', ' ');
INSERT INTO answer VALUES (5180, 1295, 3, 'Dipmeter', ' ');
INSERT INTO answer VALUES (5181, 1296, 0, 'Frequenzzähler', ' ');
INSERT INTO answer VALUES (5182, 1296, 1, 'Interferenzwellenmesser', ' ');
INSERT INTO answer VALUES (5183, 1296, 2, 'Absorptionsfrequenzmesser', ' ');
INSERT INTO answer VALUES (5184, 1296, 3, 'Spektrumanalysator', ' ');
INSERT INTO answer VALUES (5185, 1297, 0, '145,07 MHz', ' ');
INSERT INTO answer VALUES (5186, 1297, 1, '145,07522 MHz', ' ');
INSERT INTO answer VALUES (5187, 1297, 2, '145,0752 MHz', ' ');
INSERT INTO answer VALUES (5188, 1297, 3, '145,075215 MHz', ' ');
INSERT INTO answer VALUES (5189, 1298, 0, 'die Auflösung.', ' ');
INSERT INTO answer VALUES (5190, 1298, 1, 'die Langzeitstabilität.', ' ');
INSERT INTO answer VALUES (5191, 1298, 2, 'die Messgenauigkeit.', ' ');
INSERT INTO answer VALUES (5192, 1298, 3, 'die Stabilität.', ' ');
INSERT INTO answer VALUES (5193, 1299, 0, 'Kilohertz', ' ');
INSERT INTO answer VALUES (5194, 1299, 1, 'Hertz', ' ');
INSERT INTO answer VALUES (5195, 1299, 2, 'Hundertfache Hertz', ' ');
INSERT INTO answer VALUES (5196, 1299, 3, 'Zehnfache Hertz', ' ');
INSERT INTO answer VALUES (5197, 1300, 0, 'Zehnfache Hertz', ' ');
INSERT INTO answer VALUES (5198, 1300, 1, 'Hertz', ' ');
INSERT INTO answer VALUES (5199, 1300, 2, 'Hundertfache Hertz', ' ');
INSERT INTO answer VALUES (5200, 1300, 3, 'Kilohertz', ' ');
INSERT INTO answer VALUES (5201, 1301, 0, 'Absorptionsfrequenzmesser', ' ');
INSERT INTO answer VALUES (5202, 1301, 1, 'Dipmeter', ' ');
INSERT INTO answer VALUES (5203, 1301, 2, 'Stehwellenmessgerät', ' ');
INSERT INTO answer VALUES (5204, 1301, 3, 'Interferenzwellenmesser', ' ');
INSERT INTO answer VALUES (5205, 1302, 0, '5 %.', ' ');
INSERT INTO answer VALUES (5206, 1302, 1, '1 %.', ' ');
INSERT INTO answer VALUES (5207, 1302, 2, '0,05 %.', ' ');
INSERT INTO answer VALUES (5208, 1302, 3, '0,001 %.', ' ');
INSERT INTO answer VALUES (5209, 1303, 0, 'Absorptionsfrequenzmesser.', ' ');
INSERT INTO answer VALUES (5210, 1303, 1, 'Digitalvoltmeter.', ' ');
INSERT INTO answer VALUES (5211, 1303, 2, 'Hitzdraht-Amperemeter.', ' ');
INSERT INTO answer VALUES (5212, 1303, 3, 'Breitband-Pegelmesser.', ' ');
INSERT INTO answer VALUES (5213, 1304, 0, 'Absorptionsfrequenzmesser', ' ');
INSERT INTO answer VALUES (5214, 1304, 1, 'Vielfachmessgerät', ' ');
INSERT INTO answer VALUES (5215, 1304, 2, 'Frequenzzähler', ' ');
INSERT INTO answer VALUES (5216, 1304, 3, 'Diodentastkopf', ' ');
INSERT INTO answer VALUES (5217, 1305, 0, 'der Oberwellenausstrahlungen.', ' ');
INSERT INTO answer VALUES (5218, 1305, 1, 'der Frequenzdrift.', ' ');
INSERT INTO answer VALUES (5219, 1305, 2, 'des Spitzenwertes des Modulationsgrades.', ' ');
INSERT INTO answer VALUES (5220, 1305, 3, 'der genauen Sendefrequenz.', ' ');
INSERT INTO answer VALUES (5221, 1306, 0, 'der richtigen Oberwellenauswahl in einem Vervielfacher.', ' ');
INSERT INTO answer VALUES (5222, 1306, 1, 'der Empfängerübersteuerung.', ' ');
INSERT INTO answer VALUES (5223, 1306, 2, 'der Übermodulation.', ' ');
INSERT INTO answer VALUES (5224, 1306, 3, 'von Signalen an der Bandgrenze.', ' ');
INSERT INTO answer VALUES (5225, 1307, 0, 'HF-Tastkopf', ' ');
INSERT INTO answer VALUES (5226, 1307, 1, 'Absorptionsfrequenzmesser', ' ');
INSERT INTO answer VALUES (5227, 1307, 2, 'Antennenimpedanzmesser', ' ');
INSERT INTO answer VALUES (5228, 1307, 3, 'HF-Dipmeter', ' ');
INSERT INTO answer VALUES (5229, 1308, 0, 'zum Abgleich von HF-Schaltungen.', ' ');
INSERT INTO answer VALUES (5230, 1308, 1, 'als Messkopf für Messungen mit einem HF-Dipmeter.', ' ');
INSERT INTO answer VALUES (5231, 1308, 2, 'zur Messung der Resonanzfrequenz mit einem Frequenzzähler.', ' ');
INSERT INTO answer VALUES (5232, 1308, 3, 'als Tastkopf für einen Logiktester.', ' ');
INSERT INTO answer VALUES (5233, 1309, 0, 'Messkopf zur HF-Leistungsmessung', ' ');
INSERT INTO answer VALUES (5234, 1309, 1, 'Absorptionsfrequenzmesser', ' ');
INSERT INTO answer VALUES (5235, 1309, 2, 'Antennenimpedanzmesser', ' ');
INSERT INTO answer VALUES (5236, 1309, 3, 'HF-Dipmeter', ' ');
INSERT INTO answer VALUES (5237, 1310, 0, 'Dämpfungsglied 20 dB, 20 Watt', ' ');
INSERT INTO answer VALUES (5238, 1310, 1, '25-m-langes Koaxialkabel vom Typ RG213 (MIL)', ' ');
INSERT INTO answer VALUES (5239, 1310, 2, 'Stehwellenmessgerät', ' ');
INSERT INTO answer VALUES (5240, 1310, 3, 'Adapter BNC-Buchse auf N-Stecker', ' ');
INSERT INTO answer VALUES (5241, 1311, 0, 'Korrekturwerte, die z.B. aus Vergleichsmessungen stammen.', ' ');
INSERT INTO answer VALUES (5242, 1311, 1, 'R<sub>1</sub> muss genau 50 &Omega; betragen.', ' ');
INSERT INTO answer VALUES (5243, 1311, 2, 'Bei den Umrechnungen darf nur mit dem Effektivwert gerechnet werden.', ' ');
INSERT INTO answer VALUES (5244, 1311, 3, 'Die Messschaltung muss vor jeder Messung mit einem Dipmeter überprüft werden.', ' ');
INSERT INTO answer VALUES (5245, 1312, 0, 'Feldstärkeanzeiger', ' ');
INSERT INTO answer VALUES (5246, 1312, 1, 'Einfacher Peilempfänger', ' ');
INSERT INTO answer VALUES (5247, 1312, 2, 'Antennenimpedanzmesser', ' ');
INSERT INTO answer VALUES (5248, 1312, 3, 'Dipmeter', ' ');
INSERT INTO answer VALUES (5249, 1313, 0, 'mit einem Spektrumanalysator.', ' ');
INSERT INTO answer VALUES (5250, 1313, 1, 'mit einen digitalen Frequenzzähler.', ' ');
INSERT INTO answer VALUES (5251, 1313, 2, 'mit einem Breitbandpegelmesser.', ' ');
INSERT INTO answer VALUES (5252, 1313, 3, 'mit einem Oszilloskop.', ' ');
INSERT INTO answer VALUES (5253, 1314, 0, 'gesamt 48 Widerstände, 48 Watt', ' ');
INSERT INTO answer VALUES (5254, 1314, 1, 'gesamt 48 Widerstände, 12 Watt', ' ');
INSERT INTO answer VALUES (5255, 1314, 2, 'gesamt 12 Widerstände, 48 Watt', ' ');
INSERT INTO answer VALUES (5256, 1314, 3, 'gesamt 16 Widerstände, 16 Watt', ' ');
INSERT INTO answer VALUES (5257, 1315, 0, 'Der Spannungsmesser ist parallel zum Messobjekt anzuschließen und sollte hochohmig sein.', ' ');
INSERT INTO answer VALUES (5258, 1315, 1, 'Der Spannungsmesser ist in den Stromkreis einzuschleifen und sollte niederohmig sein.', ' ');
INSERT INTO answer VALUES (5259, 1315, 2, 'Der Spannungsmesser ist parallel zum Messobjekt anzuschließen und sollte niederohmig sein.', ' ');
INSERT INTO answer VALUES (5260, 1315, 3, 'Der Spannungsmesser ist in den Stromkreis einzuschleifen und sollte hochohmig sein.', ' ');
INSERT INTO answer VALUES (5261, 1316, 0, 'Spannungsmesser bei 1, Amperemeter bei 3.', ' ');
INSERT INTO answer VALUES (5262, 1316, 1, 'Spannungsmesser bei 1, Amperemeter bei 2.', ' ');
INSERT INTO answer VALUES (5263, 1316, 2, 'Spannungsmesser bei 3, Amperemeter bei 1.', ' ');
INSERT INTO answer VALUES (5264, 1316, 3, 'Spannungsmesser bei 3, Amperemeter bei 4.', ' ');
INSERT INTO answer VALUES (5265, 1317, 0, '2, 3 und 4', ' ');
INSERT INTO answer VALUES (5266, 1317, 1, '1, 2 und 3', ' ');
INSERT INTO answer VALUES (5267, 1317, 2, '2, 4 und 1', ' ');
INSERT INTO answer VALUES (5268, 1317, 3, '1, 3 und 4', ' ');
INSERT INTO answer VALUES (5269, 1318, 0, 'Digital Multimeter mit einer Genauigkeit von ± 0,5 % ± 1 Digit und einem Eingangswiderstand von 10 M&Omega; in den Gleichspannungsmessbereichen', ' ');
INSERT INTO answer VALUES (5270, 1318, 1, 'Feinmessgerät der Klasse 0,5 mit einer Empfindlichkeit von 10 k&Omega;/V', ' ');
INSERT INTO answer VALUES (5271, 1318, 2, 'Drehspulmessgerät mit einer Empfindlichkeit von 4 k&Omega;/V', ' ');
INSERT INTO answer VALUES (5272, 1318, 3, 'Digital Multimeter mit einer Genauigkeit von ± 0,5 % ± 1 Digit und einem Eingangswiderstand von 1 M&Omega; in den Gleichspannungsmessbereichen', ' ');
INSERT INTO answer VALUES (5273, 1319, 0, 'Er liegt zwischen 225,5 und 234,5 Volt.', ' ');
INSERT INTO answer VALUES (5274, 1319, 1, 'Er liegt zwischen 226,5 und 233,5 Volt.', ' ');
INSERT INTO answer VALUES (5275, 1319, 2, 'Er liegt zwischen 229,5 und 230,5 Volt.', ' ');
INSERT INTO answer VALUES (5276, 1319, 3, 'Er liegt zwischen 229,7 und 230,3 Volt.', ' ');
INSERT INTO answer VALUES (5277, 1320, 0, 'Er liegt zwischen 12,1 und 13,1 Volt.', ' ');
INSERT INTO answer VALUES (5278, 1320, 1, 'Er liegt zwischen 12,3 und 12,9 Volt.', ' ');
INSERT INTO answer VALUES (5279, 1320, 2, 'Er liegt zwischen 12,55 und 12,65 Volt.', ' ');
INSERT INTO answer VALUES (5280, 1320, 3, 'Er liegt zwischen 12,57 und 12,63 Volt.', ' ');
INSERT INTO answer VALUES (5281, 1321, 0, '5 Volt', ' ');
INSERT INTO answer VALUES (5282, 1321, 1, '6,7 Volt', ' ');
INSERT INTO answer VALUES (5283, 1321, 2, '7,5 Volt', ' ');
INSERT INTO answer VALUES (5284, 1321, 3, '3,3 Volt', ' ');
INSERT INTO answer VALUES (5285, 1322, 0, 'nur bei sinusförmigen Signalen möglich.', ' ');
INSERT INTO answer VALUES (5286, 1322, 1, 'bei allen Signalformen möglich.', ' ');
INSERT INTO answer VALUES (5287, 1322, 2, 'nur bei rechteck- und sinusförmigen Signale möglich.', ' ');
INSERT INTO answer VALUES (5288, 1322, 3, 'bei allen Signalen, die Oberwellen enthalten möglich.', ' ');
INSERT INTO answer VALUES (5289, 1323, 0, 'ein Messgerät mit Thermoumformer.', ' ');
INSERT INTO answer VALUES (5290, 1323, 1, 'ein Oszillograf.', ' ');
INSERT INTO answer VALUES (5291, 1323, 2, 'ein Messgerät mit Diodentastkopf.', ' ');
INSERT INTO answer VALUES (5292, 1323, 3, 'ein Digitalmultimeter.', ' ');
INSERT INTO answer VALUES (5293, 1324, 0, 'Messung der Ausgangsleistung.', ' ');
INSERT INTO answer VALUES (5294, 1324, 1, 'Änderung der Antennenanpassung.', ' ');
INSERT INTO answer VALUES (5295, 1324, 2, 'Erhöhung des Lastwirkungsgrades.', ' ');
INSERT INTO answer VALUES (5296, 1324, 3, 'Einstellung der SWR-Messbrücke auf Null.', ' ');
INSERT INTO answer VALUES (5297, 1325, 0, 'Digitalmultimeter mit HF-Tastkopf', ' ');
INSERT INTO answer VALUES (5298, 1325, 1, 'Dipmeter mit Linkleitung', ' ');
INSERT INTO answer VALUES (5299, 1325, 2, 'Stehwellenmessgerät ohne Abschlusswiderstand.', ' ');
INSERT INTO answer VALUES (5300, 1325, 3, 'Künstliche 50-&Omega;-Antenne mit zusätzlichem HF-Dämpfungsglied', ' ');
INSERT INTO answer VALUES (5301, 1326, 0, 'Durch Messung von L und C und Berechnung oder z.B. mit einem Dipmeter.', ' ');
INSERT INTO answer VALUES (5302, 1326, 1, 'Mit einem Frequenzmesser oder einem Oszilloskop.', ' ');
INSERT INTO answer VALUES (5303, 1326, 2, 'Mit einem Digital-Multimeter in der Stellung Frequenzmessung.', ' ');
INSERT INTO answer VALUES (5304, 1326, 3, 'Mit Hilfe der S-Meter Anzeige bei Anschluss des Schwingkreises an den Empfängereingang.', ' ');
INSERT INTO answer VALUES (5305, 1327, 0, 'Dipmeter überprüft werden.', ' ');
INSERT INTO answer VALUES (5306, 1327, 1, 'Gleichspannungsmesser überprüft werden.', ' ');
INSERT INTO answer VALUES (5307, 1327, 2, 'digitalen Frequenzmessgerät überprüft werden.', ' ');
INSERT INTO answer VALUES (5308, 1327, 3, 'Ohmmeter überprüft werden.', ' ');
INSERT INTO answer VALUES (5309, 1328, 0, 'eine verhältnismäßig lose Kopplung erforderlich.', ' ');
INSERT INTO answer VALUES (5310, 1328, 1, 'Widerstandskopplung erforderlich.', ' ');
INSERT INTO answer VALUES (5311, 1328, 2, 'eine starke Kopplung erforderlich.', ' ');
INSERT INTO answer VALUES (5312, 1328, 3, 'höchstmögliche Kopplung erforderlich.', ' ');
INSERT INTO answer VALUES (5313, 1329, 0, 'Einen Frequenzzähler mit stabiler Zeitbasis.', ' ');
INSERT INTO answer VALUES (5314, 1329, 1, 'Einen KW-Empfänger mit Frequenzanzeige.', ' ');
INSERT INTO answer VALUES (5315, 1329, 2, 'Ein Digital-Multimeter in der Stellung Frequenzmessung.', ' ');
INSERT INTO answer VALUES (5316, 1329, 3, 'Einen Absorptionsfrequenzmesser oder ein Dipmeter.', ' ');
INSERT INTO answer VALUES (5317, 1330, 0, 'ein Träger ohne Modulation zu verwenden.', ' ');
INSERT INTO answer VALUES (5318, 1330, 1, 'der Zähler an den Netztransformator zu synchronisieren.', ' ');
INSERT INTO answer VALUES (5319, 1330, 2, 'der Zähler mit der Sendefrequenz zu synchronisieren.', ' ');
INSERT INTO answer VALUES (5320, 1330, 3, 'eine analoge Modulation des Trägers zu verwenden.', ' ');
INSERT INTO answer VALUES (5321, 1331, 0, 'Frequenzzähler und unmodulierter Träger', ' ');
INSERT INTO answer VALUES (5322, 1331, 1, 'Oszilloskop und unmodulierter Träger', ' ');
INSERT INTO answer VALUES (5323, 1331, 2, 'Frequenzzähler und modulierter Träger', ' ');
INSERT INTO answer VALUES (5324, 1331, 3, 'Absorptionsfrequenzmesser und modulierter Träger', ' ');
INSERT INTO answer VALUES (5325, 1332, 0, '3,145 kHz', ' ');
INSERT INTO answer VALUES (5326, 1332, 1, '6,30 kHz', ' ');
INSERT INTO answer VALUES (5327, 1332, 2, '4,45 kHz', ' ');
INSERT INTO answer VALUES (5328, 1332, 3, '6,00 kHz', ' ');
INSERT INTO answer VALUES (5329, 1333, 0, 'F = ±141 Hz', ' ');
INSERT INTO answer VALUES (5330, 1333, 1, 'F = ±1,41 Hz', ' ');
INSERT INTO answer VALUES (5331, 1333, 2, 'F = ±14,1 Hz', ' ');
INSERT INTO answer VALUES (5332, 1333, 3, 'F = ±1410 Hz', ' ');
INSERT INTO answer VALUES (5333, 1334, 0, '145,625 MHz.', ' ');
INSERT INTO answer VALUES (5334, 1334, 1, '1,45625 MHz.', ' ');
INSERT INTO answer VALUES (5335, 1334, 2, '14,5625 MHz.', ' ');
INSERT INTO answer VALUES (5336, 1334, 3, '135,625 MHz.', ' ');
INSERT INTO answer VALUES (5337, 1335, 0, 'mit einer SWR-Messbrücke oder einer Messleitung.', ' ');
INSERT INTO answer VALUES (5338, 1335, 1, 'mit einem Absorptionsfrequenzmesser oder einem Dipmeter.', ' ');
INSERT INTO answer VALUES (5339, 1335, 2, 'durch Strommessung am Anfang und am Ende der Speiseleitung.', ' ');
INSERT INTO answer VALUES (5340, 1335, 3, 'durch Spannungsmessung am Anfang und am Ende der Speiseleitung.', ' ');
INSERT INTO answer VALUES (5341, 1336, 0, 'der Antennenanpassung eingesetzt.', ' ');
INSERT INTO answer VALUES (5342, 1336, 1, 'der Oberwellenausgangsleistung eingesetzt.', ' ');
INSERT INTO answer VALUES (5343, 1336, 2, 'der Bandbreite eingesetzt.', ' ');
INSERT INTO answer VALUES (5344, 1336, 3, 'des Wirkungsgrades eingesetzt.', ' ');
INSERT INTO answer VALUES (5345, 1337, 0, 'Punkt 1', ' ');
INSERT INTO answer VALUES (5346, 1337, 1, 'Punkt 2', ' ');
INSERT INTO answer VALUES (5347, 1337, 2, 'Punkt 3', ' ');
INSERT INTO answer VALUES (5348, 1337, 3, 'Punkt 4', ' ');
INSERT INTO answer VALUES (5349, 1338, 0, '3', ' ');
INSERT INTO answer VALUES (5350, 1338, 1, '2,5', ' ');
INSERT INTO answer VALUES (5351, 1338, 2, '3,33', ' ');
INSERT INTO answer VALUES (5352, 1338, 3, '2', ' ');
INSERT INTO answer VALUES (5353, 1339, 0, 'Absorptionsfrequenzmesser', ' ');
INSERT INTO answer VALUES (5354, 1339, 1, 'Stehwellenmessgerät', ' ');
INSERT INTO answer VALUES (5355, 1339, 2, 'Frequenzzähler', ' ');
INSERT INTO answer VALUES (5356, 1339, 3, 'HF-Leistungsmesser', ' ');
INSERT INTO answer VALUES (5357, 1340, 0, 'Gelegentlich', ' ');
INSERT INTO answer VALUES (5358, 1340, 1, 'Nur im Falle einer Beschwerde', ' ');
INSERT INTO answer VALUES (5359, 1340, 2, 'Bei Empfang eines Störsignals', ' ');
INSERT INTO answer VALUES (5360, 1340, 3, 'Täglich', ' ');
INSERT INTO answer VALUES (5361, 1341, 0, 'Der Verstärker wird übersteuert und erzeugt Oberwellen.', ' ');
INSERT INTO answer VALUES (5362, 1341, 1, 'Vor dem Modulator erfolgt eine Hubbegrenzung.', ' ');
INSERT INTO answer VALUES (5363, 1341, 2, 'Das Ansteuersignal ist zu schwach, um den Verstärker voll auszusteuern.', ' ');
INSERT INTO answer VALUES (5364, 1341, 3, 'Eine Blitzschutzpatrone begrenzt die Spannung.', ' ');
INSERT INTO answer VALUES (5365, 1342, 0, 'breitbandigen Oszilloskop.', ' ');
INSERT INTO answer VALUES (5366, 1342, 1, 'hochohmigen Vielfachinstrument in Stellung AC.', ' ');
INSERT INTO answer VALUES (5367, 1342, 2, 'empfindlichen Dipmeter in Stellung Wellenmessung.', ' ');
INSERT INTO answer VALUES (5368, 1342, 3, 'breitbandigen Detektor und Kopfhörer.', ' ');
INSERT INTO answer VALUES (5369, 1343, 0, '50 % der Amplitude gemessen.', ' ');
INSERT INTO answer VALUES (5370, 1343, 1, '90 % der Amplitude gemessen.', ' ');
INSERT INTO answer VALUES (5371, 1343, 2, '70 % der Amplitude gemessen.', ' ');
INSERT INTO answer VALUES (5372, 1343, 3, '10 % der Amplitude gemessen.', ' ');
INSERT INTO answer VALUES (5373, 1344, 0, '4,8 V', ' ');
INSERT INTO answer VALUES (5374, 1344, 1, '3,3 V', ' ');
INSERT INTO answer VALUES (5375, 1344, 2, '7,1 V', ' ');
INSERT INTO answer VALUES (5376, 1344, 3, '9,8 V', ' ');
INSERT INTO answer VALUES (5377, 1345, 0, '9,5 Watt', ' ');
INSERT INTO answer VALUES (5378, 1345, 1, '37,8 Watt', ' ');
INSERT INTO answer VALUES (5379, 1345, 2, '4,7 Watt', ' ');
INSERT INTO answer VALUES (5380, 1345, 3, '19 Watt', ' ');
INSERT INTO answer VALUES (5381, 1346, 0, 'Zirka 600 mW', ' ');
INSERT INTO answer VALUES (5382, 1346, 1, 'Zirka 4,7 Watt', ' ');
INSERT INTO answer VALUES (5383, 1346, 2, 'Zirka 1,2 Watt', ' ');
INSERT INTO answer VALUES (5384, 1346, 3, 'Zirka 2,4 Watt', ' ');
INSERT INTO answer VALUES (5385, 1347, 0, 'Zirka 60 Watt', ' ');
INSERT INTO answer VALUES (5386, 1347, 1, 'Zirka 480 Watt', ' ');
INSERT INTO answer VALUES (5387, 1347, 2, 'Zirka 340 Watt', ' ');
INSERT INTO answer VALUES (5388, 1347, 3, 'Zirka 240 Watt', ' ');
INSERT INTO answer VALUES (5389, 1348, 0, '36,0 W', ' ');
INSERT INTO answer VALUES (5390, 1348, 1, '144 W', ' ');
INSERT INTO answer VALUES (5391, 1348, 2, '400 W', ' ');
INSERT INTO answer VALUES (5392, 1348, 3, '576 W', ' ');
INSERT INTO answer VALUES (5393, 1349, 0, '144 W', ' ');
INSERT INTO answer VALUES (5394, 1349, 1, '36,0 W', ' ');
INSERT INTO answer VALUES (5395, 1349, 2, '400 W', ' ');
INSERT INTO answer VALUES (5396, 1349, 3, '576 W', ' ');
INSERT INTO answer VALUES (5397, 1350, 0, '400 W', ' ');
INSERT INTO answer VALUES (5398, 1350, 1, '36,0 W', ' ');
INSERT INTO answer VALUES (5399, 1350, 2, '144 W', ' ');
INSERT INTO answer VALUES (5400, 1350, 3, '1,6 kW', ' ');
INSERT INTO answer VALUES (5401, 1351, 0, 'den Rückgang der Empfindlichkeit und ggf. das Auftreten von Brodelgeräuschen.', ' ');
INSERT INTO answer VALUES (5402, 1351, 1, 'Empfindlichkeitssteigerung.', ' ');
INSERT INTO answer VALUES (5403, 1351, 2, 'das Auftreten von Pfeifstellen im gesamten Abstimmungsbereich.', ' ');
INSERT INTO answer VALUES (5404, 1351, 3, 'eine zeitweilige Blockierung der Frequenzeinstellung.', ' ');
INSERT INTO answer VALUES (5405, 1352, 0, 'Es treten Phantomsignale auf, die bei Einschalten eines Abschwächers in den HF-Signalweg verschwinden.', ' ');
INSERT INTO answer VALUES (5406, 1352, 1, 'Das Nutzsignal wird mit einem anderen Signal moduliert und dadurch unverständlich.', ' ');
INSERT INTO answer VALUES (5407, 1352, 2, 'Es treten Pfeifstellen gleichen Abstands im gesamten Empfangsbereich auf.', ' ');
INSERT INTO answer VALUES (5408, 1352, 3, 'Dem Empfangssignal ist ein pulsierendes Rauschen überlagert, das die Verständlichkeit beeinträchtigt.', ' ');
INSERT INTO answer VALUES (5409, 1353, 0, 'Durch Gleichrichtung starker HF-Signale an PN-Übergängen in der NF-Endstufe.', ' ');
INSERT INTO answer VALUES (5410, 1353, 1, 'Durch Gleichrichtung der ins Stromnetz eingestrahlten HF-Signale an den Dioden des Netzteils.', ' ');
INSERT INTO answer VALUES (5411, 1353, 2, 'Durch Gleichrichtung abgestrahlter HF-Signale an PN-Übergängen in der NF-Vorstufe.', ' ');
INSERT INTO answer VALUES (5412, 1353, 3, 'Durch eine Übersteuerung des Tuners mit dem über die Antennenzuleitung aufgenommenen HF-Signal.', ' ');
INSERT INTO answer VALUES (5413, 1354, 0, 'er keine unerwünschten Aussendungen hervorruft.', ' ');
INSERT INTO answer VALUES (5414, 1354, 1, 'die Selbsterregung maximiert wird.', ' ');
INSERT INTO answer VALUES (5415, 1354, 2, 'parasitäre Schwingungen vorhanden sind.', ' ');
INSERT INTO answer VALUES (5416, 1354, 3, 'die Oberwellenabschirmung minimiert wird.', ' ');
INSERT INTO answer VALUES (5417, 1355, 0, 'an einem Basis-Emitter-Übergang.', ' ');
INSERT INTO answer VALUES (5418, 1355, 1, 'an der Lautsprecherleitung.', ' ');
INSERT INTO answer VALUES (5419, 1355, 2, 'an der Verbindung zweier Widerstände.', ' ');
INSERT INTO answer VALUES (5420, 1355, 3, 'an einem Kupferdraht.', ' ');
INSERT INTO answer VALUES (5421, 1356, 0, 'möglichst gut geschirmt sein.', ' ');
INSERT INTO answer VALUES (5422, 1356, 1, 'nicht geerdet sein.', ' ');
INSERT INTO answer VALUES (5423, 1356, 2, 'über das Stromversorgungsnetz geerdet sein.', ' ');
INSERT INTO answer VALUES (5424, 1356, 3, 'durch Kunststoffabdeckungen geschützt sein.', ' ');
INSERT INTO answer VALUES (5425, 1357, 0, 'werden Gleichtakt-HF-Störsignale unterdrückt.', ' ');
INSERT INTO answer VALUES (5426, 1357, 1, 'werden niederfrequente Störsignale unterdrückt.', ' ');
INSERT INTO answer VALUES (5427, 1357, 2, 'werden alle Wechselstromsignale unterdrückt.', ' ');
INSERT INTO answer VALUES (5428, 1357, 3, 'wird Netzbrummen unterdrückt.', ' ');
INSERT INTO answer VALUES (5429, 1358, 0, 'durch Übersteuerung mit dem Signal eines nahen Sender störend beeinflusst.', ' ');
INSERT INTO answer VALUES (5430, 1358, 1, 'auf Grund von Netzeinwirkungen beim Betrieb eines nahen Senders störend beeinflusst.', ' ');
INSERT INTO answer VALUES (5431, 1358, 2, 'durch Einwirkungen auf die Gleichstromversorgung beim Betrieb eines nahen Senders störend beeinflusst.', ' ');
INSERT INTO answer VALUES (5432, 1358, 3, 'auf Grund seiner zu niedrigen Verstärkung beim Betrieb eines nahen Senders störend beeinflusst.', ' ');
INSERT INTO answer VALUES (5433, 1359, 0, 'Problemen mit dem Fernsehempfang.', ' ');
INSERT INTO answer VALUES (5434, 1359, 1, 'mangelhafter Regelung der Stromversorgung.', ' ');
INSERT INTO answer VALUES (5435, 1359, 2, 'ungesteuertem Kanalwechsel.', ' ');
INSERT INTO answer VALUES (5436, 1359, 3, 'fehlender Regelspannung für den Tuner.', ' ');
INSERT INTO answer VALUES (5437, 1360, 0, 'keramische Kondensatoren über die Basis-Emitter-Übergänge der Endstufentransistoren eingebaut werden.', ' ');
INSERT INTO answer VALUES (5438, 1360, 1, 'HF-Drosseln über die Basis-Emitter-Übergänge der Endstufentransistoren eingebaut werden.', ' ');
INSERT INTO answer VALUES (5439, 1360, 2, 'keramische Kondensatoren über die Emitterwiderstände der Endstufentransistoren eingebaut werden.', ' ');
INSERT INTO answer VALUES (5440, 1360, 3, 'HF-Drosseln parallel zu den Kollektor- und Emitteranschlüssen der Endstufentransistoren eingebaut werden.', ' ');
INSERT INTO answer VALUES (5441, 1361, 0, 'Sie bieten höflich an, die erforderlichen Prüfungen in die Wege zu leiten.', ' ');
INSERT INTO answer VALUES (5442, 1361, 1, 'Er sollte höflich darauf hingewiesen werden, dass es an seiner eigenen Einrichtung liegt.', ' ');
INSERT INTO answer VALUES (5443, 1361, 2, 'Er sollte darauf hingewiesen werden, dass Sie hierfür nicht zuständig sind.', ' ');
INSERT INTO answer VALUES (5444, 1361, 3, 'Sie benachrichtigen die Bundesnetzagentur und den RTA.', ' ');
INSERT INTO answer VALUES (5445, 1362, 0, 'Über jeden beliebigen Leitungsanschluss und/oder über die ZF-Stufen.', ' ');
INSERT INTO answer VALUES (5446, 1362, 1, 'Über die Antennenleitung und über alle größeren ungeschirmten Spulen im Fernsehgerät (z.B. Entmagnetisierungsschleife).', ' ');
INSERT INTO answer VALUES (5447, 1362, 2, 'Über die Stromversorgung des Senders und die Stromversorgung des Fernsehgeräts.', ' ');
INSERT INTO answer VALUES (5448, 1362, 3, 'Über die Fernsehantenne bzw. das Antennenkabel sowie über die Bildröhre.', ' ');
INSERT INTO answer VALUES (5449, 1363, 0, 'rechtwinklig zur Häuserzeile angebracht werden.', ' ');
INSERT INTO answer VALUES (5450, 1363, 1, 'am gemeinsamen Schornstein neben der Fernsehantenne angebracht werden.', ' ');
INSERT INTO answer VALUES (5451, 1363, 2, 'entlang der Häuserzeile auf der Höhe der Dachrinne angebracht werden.', ' ');
INSERT INTO answer VALUES (5452, 1363, 3, 'innerhalb des Dachbereichs angebracht werden.', ' ');
INSERT INTO answer VALUES (5453, 1364, 0, 'eine außen angebrachte Fernsehantenne zu installieren.', ' ');
INSERT INTO answer VALUES (5454, 1364, 1, 'ein doppelt geschirmtes Koaxialkabel für die Antennenleitung zu verwenden.', ' ');
INSERT INTO answer VALUES (5455, 1364, 2, 'einen Vorverstärker in die Antennenleitung einzuschleifen.', ' ');
INSERT INTO answer VALUES (5456, 1364, 3, 'den Fernsehrundfunkempfänger zu wechseln.', ' ');
INSERT INTO answer VALUES (5457, 1365, 0, 'ist unzureichende HF-Erdung.', ' ');
INSERT INTO answer VALUES (5458, 1365, 1, 'ist die Erzeugung von Subharmonischen am Sender.', ' ');
INSERT INTO answer VALUES (5459, 1365, 2, 'sind sehr starke Empfangssignale.', ' ');
INSERT INTO answer VALUES (5460, 1365, 3, 'ist die mangelhafte Stromversorgung des Senders.', ' ');
INSERT INTO answer VALUES (5461, 1366, 0, 'so weit entfernt wie möglich installiert werden.', ' ');
INSERT INTO answer VALUES (5462, 1366, 1, 'außerhalb des reaktiven Nahfeldes installiert werden.', ' ');
INSERT INTO answer VALUES (5463, 1366, 2, 'in einer Entfernung von mindestens 4 Wellenlängen installiert werden.', ' ');
INSERT INTO answer VALUES (5464, 1366, 3, 'in einer Entfernung von mindestens einer halben Wellenlänge bei 432 MHz installiert werden.', ' ');
INSERT INTO answer VALUES (5465, 1367, 0, 'Direkteinstrahlung bezeichnet.', ' ');
INSERT INTO answer VALUES (5466, 1367, 1, 'Direktabsorption bezeichnet.', ' ');
INSERT INTO answer VALUES (5467, 1367, 2, 'Direktmischung bezeichnet.', ' ');
INSERT INTO answer VALUES (5468, 1367, 3, 'HF-Durchschlag bezeichnet.', ' ');
INSERT INTO answer VALUES (5469, 1368, 0, 'die zuständige Außenstelle der Bundesnetzagentur um Prüfung der Gegebenheiten zu bitten.', ' ');
INSERT INTO answer VALUES (5470, 1368, 1, 'der Sender an die Bundesnetzagentur zu senden.', ' ');
INSERT INTO answer VALUES (5471, 1368, 2, 'die Rückseite des Fernsehgeräts zu entfernen und das Gehäuse zu erden.', ' ');
INSERT INTO answer VALUES (5472, 1368, 3, 'der EMV-Beauftragte des RTA um Prüfung des Fernsehgeräts zu bitten.', ' ');
INSERT INTO answer VALUES (5473, 1369, 0, 'Verminderung der Ausgangsleistung.', ' ');
INSERT INTO answer VALUES (5474, 1369, 1, 'Erhöhung des Modulationsgrades der ATV-Aussendung.', ' ');
INSERT INTO answer VALUES (5475, 1369, 2, 'Verringerung von Bildkontrast und -helligkeit beim Nachbarn.', ' ');
INSERT INTO answer VALUES (5476, 1369, 3, 'Verbesserung der Seitenbandunterdrückung beim Nachbarn.', ' ');
INSERT INTO answer VALUES (5477, 1370, 0, 'die Antennenleitung vom Fernsehgeräts zu trennen um zu prüfen, ob die Störungen anhalten.', ' ');
INSERT INTO answer VALUES (5478, 1370, 1, 'das Fernsehgerät zu erden und abzuschalten um zu prüfen, ob die Störungen anhalten.', ' ');
INSERT INTO answer VALUES (5479, 1370, 2, 'die Rückseite des Fernsehgeräts zu entfernen und das Gehäuse zu erden.', ' ');
INSERT INTO answer VALUES (5480, 1370, 3, 'der Netzstecker aus der Steckdose zu ziehen um zu prüfen, ob die Störung über das Netz eingeschleppt wird.', ' ');
INSERT INTO answer VALUES (5481, 1371, 0, 'einem hohen Nebenwellenanteil.', ' ');
INSERT INTO answer VALUES (5482, 1371, 1, 'lediglich geringen Verzerrungen beim Empfang.', ' ');
INSERT INTO answer VALUES (5483, 1371, 2, 'einer besseren Verständlichkeit am Empfangsort.', ' ');
INSERT INTO answer VALUES (5484, 1371, 3, 'einer Verringerung der Ausgangsleistung.', ' ');
INSERT INTO answer VALUES (5485, 1372, 0, 'Eigenresonanz der HF-Drosseln hervorgerufen werden.', ' ');
INSERT INTO answer VALUES (5486, 1372, 1, 'Stromversorgung hervorgerufen werden.', ' ');
INSERT INTO answer VALUES (5487, 1372, 2, 'Sättigung der Kerne der HF-Spulen hervorgerufen werden.', ' ');
INSERT INTO answer VALUES (5488, 1372, 3, 'Widerstandseigenschaft einer Drossel hervorgerufen werden.', ' ');
INSERT INTO answer VALUES (5489, 1373, 0, 'wahrscheinlich Tastklicks erzeugt werden.', ' ');
INSERT INTO answer VALUES (5490, 1373, 1, 'während der Aussetzer Probleme im Leistungsverstärker entstehen könnten.', ' ');
INSERT INTO answer VALUES (5491, 1373, 2, 'sie schwierig zu interpretieren ist.', ' ');
INSERT INTO answer VALUES (5492, 1373, 3, 'die Stromversorgung überlastet wird.', ' ');
INSERT INTO answer VALUES (5493, 1374, 0, '40 dB betragen.', ' ');
INSERT INTO answer VALUES (5494, 1374, 1, '60 dB betragen.', ' ');
INSERT INTO answer VALUES (5495, 1374, 2, '100 dB betragen.', ' ');
INSERT INTO answer VALUES (5496, 1374, 3, '20 dB betragen.', ' ');
INSERT INTO answer VALUES (5497, 1375, 0, 'die Verringerung der Flankensteilheit.', ' ');
INSERT INTO answer VALUES (5498, 1375, 1, 'die Vergrößerung der Flankensteilheit.', ' ');
INSERT INTO answer VALUES (5499, 1375, 2, 'den Einsatz eines Bandpassfilters.', ' ');
INSERT INTO answer VALUES (5500, 1375, 3, 'die Verringerung des Tastenhubes.', ' ');
INSERT INTO answer VALUES (5501, 1376, 0, '7,5 kHz', ' ');
INSERT INTO answer VALUES (5502, 1376, 1, '0 kHz', ' ');
INSERT INTO answer VALUES (5503, 1376, 2, '15 kHz', ' ');
INSERT INTO answer VALUES (5504, 1376, 3, '2,7 kHz', ' ');
INSERT INTO answer VALUES (5505, 1377, 0, 'Hubeinstellung.', ' ');
INSERT INTO answer VALUES (5506, 1377, 1, 'HF-Begrenzung.', ' ');
INSERT INTO answer VALUES (5507, 1377, 2, 'Vorspannung in der Endstufe.', ' ');
INSERT INTO answer VALUES (5508, 1377, 3, 'Trägerfrequenz.', ' ');
INSERT INTO answer VALUES (5509, 1378, 0, 'keinen festen Bezug zur Betriebsfrequenz haben.', ' ');
INSERT INTO answer VALUES (5510, 1378, 1, 'bei ungeradzahligen Vielfachen der Betriebsfrequenz auftreten.', ' ');
INSERT INTO answer VALUES (5511, 1378, 2, 'bei geradzahligen Vielfachen der Betriebsfrequenz auftreten.', ' ');
INSERT INTO answer VALUES (5512, 1378, 3, 'bei ganzzahligen Vielfachen der Betriebsfrequenz auftreten.', ' ');
INSERT INTO answer VALUES (5513, 1379, 0, '3 kHz nicht überschreiten.', ' ');
INSERT INTO answer VALUES (5514, 1379, 1, '1 kHz nicht überschreiten.', ' ');
INSERT INTO answer VALUES (5515, 1379, 2, '800 Hz nicht überschreiten.', ' ');
INSERT INTO answer VALUES (5516, 1379, 3, '15 kHz nicht überschreiten.', ' ');
INSERT INTO answer VALUES (5517, 1380, 0, 'Frequenzinstabilität führen.', ' ');
INSERT INTO answer VALUES (5518, 1380, 1, 'Frequenzsynthese führen.', ' ');
INSERT INTO answer VALUES (5519, 1380, 2, 'Gegenkopplung führen.', ' ');
INSERT INTO answer VALUES (5520, 1380, 3, 'Mehrwegeausbreitung führen.', ' ');
INSERT INTO answer VALUES (5521, 1381, 0, 'Hochpassfilters in das Antennenzuführungskabel des Fernsehempfängers lösen.', ' ');
INSERT INTO answer VALUES (5522, 1381, 1, 'Tiefpassfilter in das Antennenzuführungskabel des Fernsehempfängers lösen.', ' ');
INSERT INTO answer VALUES (5523, 1381, 2, 'Subharmonischenfilters vor dem Tuner des Fernsehempfängers lösen.', ' ');
INSERT INTO answer VALUES (5524, 1381, 3, 'ZF-Begrenzers hinter dem Tuner des Fernsehempfängers lösen.', ' ');
INSERT INTO answer VALUES (5525, 1382, 0, 'ein Tiefpassfilter nachgeschaltet werden.', ' ');
INSERT INTO answer VALUES (5526, 1382, 1, 'ein Hochpassfilter nachgeschaltet werden.', ' ');
INSERT INTO answer VALUES (5527, 1382, 2, 'eine Bandsperre vorgeschaltet werden.', ' ');
INSERT INTO answer VALUES (5528, 1382, 3, 'ein Notchfilter vorgeschaltet werden.', ' ');
INSERT INTO answer VALUES (5529, 1383, 0, 'der Leistungsverstärker übersteuert wird.', ' ');
INSERT INTO answer VALUES (5530, 1383, 1, 'das Antennenkabel einen Wackelkontakt hat.', ' ');
INSERT INTO answer VALUES (5531, 1383, 2, 'die Ansteuerung der NF-Stufe zu gering ist.', ' ');
INSERT INTO answer VALUES (5532, 1383, 3, 'das Ausgangs-PI-Filter falsch abgestimmt ist.', ' ');
INSERT INTO answer VALUES (5533, 1384, 0, 'Quarzfrequenz x 2 x 2 x 3 x 3', ' ');
INSERT INTO answer VALUES (5534, 1384, 1, 'Quarzfrequenz x 2 x 3 x 3 x 2', ' ');
INSERT INTO answer VALUES (5535, 1384, 2, 'Quarzfrequenz x 3 x 3 x 2 x 3', ' ');
INSERT INTO answer VALUES (5536, 1384, 3, 'Quarzfrequenz x 3 x 2 x 3 x 2', ' ');
INSERT INTO answer VALUES (5537, 1385, 0, 'geschirmte Lautsprecherleitungen zu verwenden.', ' ');
INSERT INTO answer VALUES (5538, 1385, 1, 'ein NF-Filter in das Koaxialkabel einzuschleifen.', ' ');
INSERT INTO answer VALUES (5539, 1385, 2, 'einen Serienkondensator in die Lautsprecherleitung einzubauen.', ' ');
INSERT INTO answer VALUES (5540, 1385, 3, 'eine geschirmtes Netzkabel für den Receiver zu verwenden.', ' ');
INSERT INTO answer VALUES (5541, 1386, 0, 'mit keiner höheren Leistung zu senden, als für eine sichere Kommunikation unbedingt erforderlich ist.', ' ');
INSERT INTO answer VALUES (5542, 1386, 1, 'nur mit effektiver Leistung zu senden.', ' ');
INSERT INTO answer VALUES (5543, 1386, 2, 'die Benutzung der Fernseh-Frequenzbereiche zu vermeiden.', ' ');
INSERT INTO answer VALUES (5544, 1386, 3, 'die Antenne unterhalb der Dachhöhe herabzulassen.', ' ');
INSERT INTO answer VALUES (5545, 1387, 0, 'können HF-Spannungen ins Netz einkoppeln.', ' ');
INSERT INTO answer VALUES (5546, 1387, 1, 'können harmonische Schwingungen erzeugt werden.', ' ');
INSERT INTO answer VALUES (5547, 1387, 2, 'könnte erhebliche Überspannung im Netz erzeugt werden.', ' ');
INSERT INTO answer VALUES (5548, 1387, 3, 'kann 50-Hz-Modulation beim Sendesignal auftreten.', ' ');
INSERT INTO answer VALUES (5549, 1388, 0, 'der Einbau eines HF-Trenntrafos möglich.', ' ');
INSERT INTO answer VALUES (5550, 1388, 1, 'der Einbau eines Tiefpassfilters nach dem Senderausgang möglich.', ' ');
INSERT INTO answer VALUES (5551, 1388, 2, 'der Einbau eines Bandpassfilters nach dem Senderausgang möglich.', ' ');
INSERT INTO answer VALUES (5552, 1388, 3, 'der Einbau einer seriellen Drosselspule in den Innenleiter der Empfangsantennenleitung möglich.', ' ');
INSERT INTO answer VALUES (5553, 1389, 0, 'einer Übersteuerung eines TV-Empfängers.', ' ');
INSERT INTO answer VALUES (5554, 1389, 1, 'Problemen mit dem 435-MHz-Empfänger.', ' ');
INSERT INTO answer VALUES (5555, 1389, 2, 'Eigenschwingungen des 435-MHz-Senders.', ' ');
INSERT INTO answer VALUES (5556, 1389, 3, 'dem Durchschlag des TV-Antennenkoaxialkabels.', ' ');
INSERT INTO answer VALUES (5557, 1390, 0, '1,8-MHz-Sender.', ' ');
INSERT INTO answer VALUES (5558, 1390, 1, 'UHF-Sender.', ' ');
INSERT INTO answer VALUES (5559, 1390, 2, 'VHF-Sender.', ' ');
INSERT INTO answer VALUES (5560, 1390, 3, '28-MHz-Sender', ' ');
INSERT INTO answer VALUES (5561, 1391, 0, 'kann in Verbindung mit dem Signal naher Sender unerwünschte Mischprodukte erzeugen, die den Fernsehempfang stören.', ' ');
INSERT INTO answer VALUES (5562, 1391, 1, 'kann in Verbindung mit dem Oszillatorsignal des Fernsehempfängers unerwünschte Mischprodukte erzeugen, die den Fernsehempfang stören.', ' ');
INSERT INTO answer VALUES (5563, 1391, 2, 'kann in Verbindung mit Einstreuungen aus dem Stromnetz durch Intermodulation Bild- und Tonstörungen hervorrufen.', ' ');
INSERT INTO answer VALUES (5564, 1391, 3, 'kann in Verbindung mit dem Signal naher Sender parametrische Schwingungen erzeugen, die einen überhöhten Nutzsignalpegel hervorrufen.', ' ');
INSERT INTO answer VALUES (5565, 1392, 0, 'zur Übersteuerung der Vorstufe des Fernsehers.', ' ');
INSERT INTO answer VALUES (5566, 1392, 1, 'zur Erzeugung von parasitären Schwingungen.', ' ');
INSERT INTO answer VALUES (5567, 1392, 2, 'zu unerwünschten Reflexionen des Sendesignals.', ' ');
INSERT INTO answer VALUES (5568, 1392, 3, 'zu Zeilenfrequenzstörungen beim 435-MHz-Empfang.', ' ');
INSERT INTO answer VALUES (5569, 1393, 0, 'auf das für eine zufrieden stellende Kommunikation erforderliche Minimum eingestellt werden.', ' ');
INSERT INTO answer VALUES (5570, 1393, 1, 'nur auf den zulässigen Pegel eingestellt werden.', ' ');
INSERT INTO answer VALUES (5571, 1393, 2, 'auf die für eine zufrieden stellende Kommunikation erforderlichen 750 W eingestellt werden.', ' ');
INSERT INTO answer VALUES (5572, 1393, 3, 'die Hälfte des maximal zulässigen Pegels betragen.', ' ');
INSERT INTO answer VALUES (5573, 1394, 0, 'Oberwellenfilter', ' ');
INSERT INTO answer VALUES (5574, 1394, 1, 'Nachbarkanalfilter', ' ');
INSERT INTO answer VALUES (5575, 1394, 2, 'ZF-Filter', ' ');
INSERT INTO answer VALUES (5576, 1394, 3, 'Hochpassfilter', ' ');
INSERT INTO answer VALUES (5577, 1395, 0, '<p><img src=''tk303a.png''></p>', ' ');
INSERT INTO answer VALUES (5578, 1395, 1, '<p><img src=''tk303b.png''></p>', ' ');
INSERT INTO answer VALUES (5579, 1395, 2, '<p><img src=''tk303c.png''></p>', ' ');
INSERT INTO answer VALUES (5580, 1395, 3, '<p><img src=''tk303d.png''></p>', ' ');
INSERT INTO answer VALUES (5581, 1396, 0, 'Hochpassfilter', ' ');
INSERT INTO answer VALUES (5582, 1396, 1, 'Tiefpassfilter', ' ');
INSERT INTO answer VALUES (5583, 1396, 2, 'Bandsperre für die Fernsehbereiche', ' ');
INSERT INTO answer VALUES (5584, 1396, 3, 'Regelbares Dämpfungsglied', ' ');
INSERT INTO answer VALUES (5585, 1397, 0, 'Hochpassfilter', ' ');
INSERT INTO answer VALUES (5586, 1397, 1, 'Tiefpassfilter', ' ');
INSERT INTO answer VALUES (5587, 1397, 2, 'UHF-Abschwächer', ' ');
INSERT INTO answer VALUES (5588, 1397, 3, 'UHF-Bandsperre', ' ');
INSERT INTO answer VALUES (5589, 1398, 0, 'Ein Hochpassfilter vor dem Antennenanschluss und zusätzlich je eine hochpermeable Ferritdrossel vor alle Leitungsanschlüsse der gestörten Geräte.', ' ');
INSERT INTO answer VALUES (5590, 1398, 1, 'Je ein Tiefpassfilter unmittelbar vor dem Antennenanschluss und in das Netzkabel der gestörten Geräte.', ' ');
INSERT INTO answer VALUES (5591, 1398, 2, 'Eine Bandsperre für die Fernsehbereiche unmittelbar vor dem Antennenanschluss und ein Tiefpassfilter in das Netzkabel der gestörten Geräte.', ' ');
INSERT INTO answer VALUES (5592, 1398, 3, 'Ein Bandpassfilter bei 30 MHz unmittelbar vor dem Antennenanschluss und ein Tiefpassfilter in das Netzkabel der gestörten Geräte.', ' ');
INSERT INTO answer VALUES (5593, 1399, 0, 'eine Mantelwellendrossel in das Kabel vor den FM-Rundfunkempfänger einzusetzen.', ' ');
INSERT INTO answer VALUES (5594, 1399, 1, 'die Erdverbindung des Senders abzuklemmen.', ' ');
INSERT INTO answer VALUES (5595, 1399, 2, 'das Abschirmgeflecht am Antennenstecker des Empfängers abzuklemmen.', ' ');
INSERT INTO answer VALUES (5596, 1399, 3, 'den 144-MHz-Sender mit einem Tiefpassfilter auszustatten.', ' ');
INSERT INTO answer VALUES (5597, 1400, 0, 'eine vom Potenzialausgleich getrennte HF-Erdleitung zu verwenden.', ' ');
INSERT INTO answer VALUES (5598, 1400, 1, 'Antennen auf dem Dachboden zu errichten.', ' ');
INSERT INTO answer VALUES (5599, 1400, 2, 'die Amateurfunkgeräte mit einem Wasserrohr zu verbinden.', ' ');
INSERT INTO answer VALUES (5600, 1400, 3, 'die Amateurfunkgeräte mittels des Schutzleiters zu erden.', ' ');
INSERT INTO answer VALUES (5601, 1401, 0, 'über eine niedrige Impedanz verfügen.', ' ');
INSERT INTO answer VALUES (5602, 1401, 1, 'über eine hohe Reaktanz verfügen.', ' ');
INSERT INTO answer VALUES (5603, 1401, 2, 'über eine hohe Impedanz verfügen.', ' ');
INSERT INTO answer VALUES (5604, 1401, 3, 'induktiv gekoppelt sein.', ' ');
INSERT INTO answer VALUES (5605, 1402, 0, '<p><img src=''tk310a.png''></p>', ' ');
INSERT INTO answer VALUES (5606, 1402, 1, '<p><img src=''tk310b.png''></p>', ' ');
INSERT INTO answer VALUES (5607, 1402, 2, '<p><img src=''tk310c.png''></p>', ' ');
INSERT INTO answer VALUES (5608, 1402, 3, '<p><img src=''tk310d.png''></p>', ' ');
INSERT INTO answer VALUES (5609, 1403, 0, 'höchstens 2 bis 3 dB betragen.', ' ');
INSERT INTO answer VALUES (5610, 1403, 1, 'höchstens 10 bis 15 dB betragen.', ' ');
INSERT INTO answer VALUES (5611, 1403, 2, 'mindestens 40 bis 60 dB betragen.', ' ');
INSERT INTO answer VALUES (5612, 1403, 3, 'mindestens 80 bis 100 dB betragen.', ' ');
INSERT INTO answer VALUES (5613, 1404, 0, 'ist ein Netzfilter vorzusehen.', ' ');
INSERT INTO answer VALUES (5614, 1404, 1, 'ist das Fernsehgerät und der Sender von der Bundesnetzagentur zu überprüfen.', ' ');
INSERT INTO answer VALUES (5615, 1404, 2, 'ist die Rückseite des Fernsehgeräts zu entfernen und das Gehäuse zu erden.', ' ');
INSERT INTO answer VALUES (5616, 1404, 3, 'ist der EMV-Beauftragte des RTA um Prüfung des Fernsehgeräts zu bitten.', ' ');
INSERT INTO answer VALUES (5617, 1405, 0, '<p><img src=''tk313a.png''></p>', ' ');
INSERT INTO answer VALUES (5618, 1405, 1, '<p><img src=''tk313b.png''></p>', ' ');
INSERT INTO answer VALUES (5619, 1405, 2, '<p><img src=''tk313c.png''></p>', ' ');
INSERT INTO answer VALUES (5620, 1405, 3, '<p><img src=''tk313d.png''></p>', ' ');
INSERT INTO answer VALUES (5621, 1406, 0, 'in einem geerdeten Metallgehäuse untergebracht wird.', ' ');
INSERT INTO answer VALUES (5622, 1406, 1, 'in Epoxydharz eingegossen wird.', ' ');
INSERT INTO answer VALUES (5623, 1406, 2, 'über kunststoffisolierte Leitungen angeschlossen wird.', ' ');
INSERT INTO answer VALUES (5624, 1406, 3, 'in einem Kunststoffgehäuse untergebracht wird.', ' ');
INSERT INTO answer VALUES (5625, 1407, 0, 'ein geschirmtes Verbindungskabel zu verwenden.', ' ');
INSERT INTO answer VALUES (5626, 1407, 1, 'die Länge des Kabels zu verdoppeln.', ' ');
INSERT INTO answer VALUES (5627, 1407, 2, 'ein doppeltes Zwillingslitzenkabel zu verwenden.', ' ');
INSERT INTO answer VALUES (5628, 1407, 3, 'das Zwillingslitzenkabel aufzusplitten und getrennt zu verlegen.', ' ');
INSERT INTO answer VALUES (5629, 1408, 0, 'Keramikkondensatoren.', ' ');
INSERT INTO answer VALUES (5630, 1408, 1, 'Aluminium-Elektrolytkondensatoren.', ' ');
INSERT INTO answer VALUES (5631, 1408, 2, 'Tantalkondensatoren.', ' ');
INSERT INTO answer VALUES (5632, 1408, 3, 'Polykarbonatkondensatoren.', ' ');
INSERT INTO answer VALUES (5633, 1409, 0, 'unter 3 kHz liegen.', ' ');
INSERT INTO answer VALUES (5634, 1409, 1, 'unter 1 kHz liegen.', ' ');
INSERT INTO answer VALUES (5635, 1409, 2, 'unter 5 kHz liegen.', ' ');
INSERT INTO answer VALUES (5636, 1409, 3, 'unter 10 kHz liegen.', ' ');
INSERT INTO answer VALUES (5637, 1410, 0, '<p><img src=''tk318a.png''></p>', ' ');
INSERT INTO answer VALUES (5638, 1410, 1, '<p><img src=''tk318b.png''></p>', ' ');
INSERT INTO answer VALUES (5639, 1410, 2, '<p><img src=''tk318c.png''></p>', ' ');
INSERT INTO answer VALUES (5640, 1410, 3, '<p><img src=''tk318d.png''></p>', ' ');
INSERT INTO answer VALUES (5641, 1411, 0, 'gut abgeschirmt werden.', ' ');
INSERT INTO answer VALUES (5642, 1411, 1, 'eine besonders abgeschirmte Spannungsversorgung erhalten.', ' ');
INSERT INTO answer VALUES (5643, 1411, 2, 'in Kunststoff eingehüllt werden.', ' ');
INSERT INTO answer VALUES (5644, 1411, 3, 'nur kapazitive Auskopplungen enthalten.', ' ');
INSERT INTO answer VALUES (5645, 1412, 0, 'sollten alle Einrichtungen mit einer guten HF-Erdung versehen werden.', ' ');
INSERT INTO answer VALUES (5646, 1412, 1, 'sollte der Sender mit der Wasserleitung im Haus verbunden werden.', ' ');
INSERT INTO answer VALUES (5647, 1412, 2, 'sollten alle schlechten Erdverbindungen entfernt werden.', ' ');
INSERT INTO answer VALUES (5648, 1412, 3, 'sollten die Wasserleitungsanschlüsse aus Polyäthylen zur Isolation vorgesehen werden.', ' ');
INSERT INTO answer VALUES (5649, 1413, 0, '20 W.', ' ');
INSERT INTO answer VALUES (5650, 1413, 1, '1 W.', ' ');
INSERT INTO answer VALUES (5651, 1413, 2, '10 W.', ' ');
INSERT INTO answer VALUES (5652, 1413, 3, '30 W.', ' ');
INSERT INTO answer VALUES (5653, 1414, 0, '3 Watt', ' ');
INSERT INTO answer VALUES (5654, 1414, 1, '10 Watt', ' ');
INSERT INTO answer VALUES (5655, 1414, 2, '5 Watt', ' ');
INSERT INTO answer VALUES (5656, 1414, 3, '2 Watt', ' ');
INSERT INTO answer VALUES (5657, 1415, 0, '0,7 V/m', ' ');
INSERT INTO answer VALUES (5658, 1415, 1, '0,35 V/m', ' ');
INSERT INTO answer VALUES (5659, 1415, 2, '0,43 V/m', ' ');
INSERT INTO answer VALUES (5660, 1415, 3, '0,55 V/m', ' ');
INSERT INTO answer VALUES (5661, 1416, 0, '6,3 m', ' ');
INSERT INTO answer VALUES (5662, 1416, 1, '8,9 m', ' ');
INSERT INTO answer VALUES (5663, 1416, 2, '2,1 m', ' ');
INSERT INTO answer VALUES (5664, 1416, 3, '5,2 m', ' ');
INSERT INTO answer VALUES (5665, 1417, 0, '7,1 m', ' ');
INSERT INTO answer VALUES (5666, 1417, 1, '6,6 m', ' ');
INSERT INTO answer VALUES (5667, 1417, 2, '2,1 m', ' ');
INSERT INTO answer VALUES (5668, 1417, 3, '5,0 m', ' ');
INSERT INTO answer VALUES (5669, 1418, 0, '4,1 m', ' ');
INSERT INTO answer VALUES (5670, 1418, 1, '5,8 m', ' ');
INSERT INTO answer VALUES (5671, 1418, 2, '3,4 m', ' ');
INSERT INTO answer VALUES (5672, 1418, 3, '1,4 m', ' ');
INSERT INTO answer VALUES (5673, 1419, 0, '2,50 m', ' ');
INSERT INTO answer VALUES (5674, 1419, 1, '1,96 m', ' ');
INSERT INTO answer VALUES (5675, 1419, 2, '5,01 m', ' ');
INSERT INTO answer VALUES (5676, 1419, 3, '13,7 m', ' ');
INSERT INTO answer VALUES (5677, 1420, 0, '5,01 m', ' ');
INSERT INTO answer VALUES (5678, 1420, 1, '3,91 m', ' ');
INSERT INTO answer VALUES (5679, 1420, 2, '2,50 m', ' ');
INSERT INTO answer VALUES (5680, 1420, 3, '20,70 m', ' ');
INSERT INTO answer VALUES (5681, 1421, 0, '6,86 m', ' ');
INSERT INTO answer VALUES (5682, 1421, 1, '5,35 m', ' ');
INSERT INTO answer VALUES (5683, 1421, 2, '2,17 m', ' ');
INSERT INTO answer VALUES (5684, 1421, 3, '36,3 m', ' ');
INSERT INTO answer VALUES (5685, 1422, 0, 'Weil die elektrische und die magnetische Feldstärke im Nahfeld keine konstante Phasenbeziehung zueinander aufweisen.', ' ');
INSERT INTO answer VALUES (5686, 1422, 1, 'Weil die elektrische und die magnetische Feldstärke im Nahfeld immer senkrecht aufeinander stehen und eine Phasendifferenz von 90° aufweisen.', ' ');
INSERT INTO answer VALUES (5687, 1422, 2, 'Weil die elektrische und die magnetische Feldstärke im Nahfeld nicht senkrecht zur Ausbreitungsrichtung stehen und auf Grund des Einflusses der Erdoberfläche eine Phasendifferenz von größer 180° aufweisen.', ' ');
INSERT INTO answer VALUES (5688, 1422, 3, 'Weil die elektrische und die magnetische Feldstärke im Nahfeld nicht exakt senkrecht aufeinander stehen und sich durch die nicht ideale Leitfähigkeit des Erdbodens am Sendeort der Feldwellenwiderstand des freien Raumes verändert.', ' ');
INSERT INTO answer VALUES (5689, 1423, 0, 'von jedem Punkt der Antenne.', ' ');
INSERT INTO answer VALUES (5690, 1423, 1, 'vom Einspeisepunkt der Antenne.', ' ');
INSERT INTO answer VALUES (5691, 1423, 2, 'von der Mitte der Antenne, d.h. dort, wo sie am Mast befestigt ist.', ' ');
INSERT INTO answer VALUES (5692, 1423, 3, 'vom untersten Punkt der Antenne.', ' ');
INSERT INTO answer VALUES (5693, 1424, 0, 'Sie addieren die Verluste zwischen Senderausgang und Antenneneingang und berechnen aus dieser Dämpfung einen Dämpfungsfaktor D; die Antenneneingangsleistung ist dann<br> P<sub>Ant</sub> = D * P<sub>Sender</sub>.', ' ');
INSERT INTO answer VALUES (5694, 1424, 1, 'Antenneneingangsleistung und Senderausgangsleistung sind gleich, da die Kabelverluste bei Amateurfunkstationen vernachlässigbar klein sind, d. h. es gilt<br> P<sub>Ant</sub> = P<sub>Sender</sub>.', ' ');
INSERT INTO answer VALUES (5695, 1424, 2, 'Die Antenneneingangsleistung ist der Spitzenwert der Senderausgangsleistung, also<br> P<sub>Ant</sub> = sqrt(2 * P<sub>Sender</sub>).', ' ');
INSERT INTO answer VALUES (5696, 1424, 3, 'Die Antenneneingangsleistung ist der Spitzen-Spitzen-Wert der Senderausgangsleistung, also<br> P<sub>Ant</sub> = 2 * sqrt(2 * P<sub>Sender</sub>).', ' ');
INSERT INTO answer VALUES (5697, 1425, 0, 'Er verringert sich auf 10 m.', ' ');
INSERT INTO answer VALUES (5698, 1425, 1, 'Er verringert sich auf 3,33 m.', ' ');
INSERT INTO answer VALUES (5699, 1425, 2, 'Er verringert sich auf 5,02 m.', ' ');
INSERT INTO answer VALUES (5700, 1425, 3, 'Er verringert sich nicht.', ' ');
INSERT INTO answer VALUES (5701, 1426, 0, 'Die Formel gilt nur für Abstände d &gt; &lambda; / (2 * &pi;) bei Dipol-Antennen (Drahtdipole, Yagi-Antennen etc.). Für andere Antennenarten und in kürzerem Abstand zur Antenne muss der Sicherheitsabstand durch andere Methoden ermittelt werden. Dies können Messungen, Simulationsrechnungen, Nahfeldberechnungen oder Verfahren sein, die die Situation im reaktiven Nahfeld berücksichtigen.', ' ');
INSERT INTO answer VALUES (5702, 1426, 1, 'Die angegebene Formel gilt nur im Nahfeld der Antenne d. h. für Abstände d &lt; &lambda; / (2 * &pi;). Sie kann jedoch auch im Fernfeld verwendet werden, weil die damit errechneten Feldstärken stets höher liegen als die wirklich auftretenden Feldstärken, so dass die Sicherheit immer erhalten bleibt.', ' ');
INSERT INTO answer VALUES (5703, 1426, 2, 'Im Bereich von Amateurfunkstellen ist der Unterschied zwischen Nah- und Fernfeld so gering, dass obige Formel, die zwar nur im Fernfeld gilt, trotzdem für alle Raumbereiche verwendet werden kann.', ' ');
INSERT INTO answer VALUES (5704, 1426, 3, 'Die Formel gilt nur für Abstände d &gt; &lambda; / (2 * &pi;) bei horizontal polarisierten Antennen. Bei vertikal oder zirkular polarisierten Antennen und in kürzerem Abstand zur Antenne muss der Sicherheitsabstand durch andere Methoden ermittelt werden. Dies können Messungen, Simulationsrechnungen, Nahfeldberechnungen oder Verfahren sein, die Situation im reaktiven Nahfeld berücksichtigen.', ' ');
INSERT INTO answer VALUES (5705, 1427, 0, 'Mit dem Mittelwert der Ausgangsleistung gemittelt über ein Intervall von 6 Minuten.', ' ');
INSERT INTO answer VALUES (5706, 1427, 1, 'Mit der größten Ausgangsleistung des Transceivers zuzüglich Antennengewinn, korrigiert um den Gewichtungsfaktor für die verwendete Betriebsart.', ' ');
INSERT INTO answer VALUES (5707, 1427, 2, 'Mit der durchschnittlich benutzten Ausgangsleistung gemittelt über den Betriebszeitraum und korrigiert um den Gewichtungsfaktor für die verwendete Betriebsart.', ' ');
INSERT INTO answer VALUES (5708, 1427, 3, 'Mit der maximalen Ausgangsleistung des verwendeten Senders zuzüglich 3 dB Messfehler.', ' ');
INSERT INTO answer VALUES (5709, 1428, 0, 'ca. 100 Watt', ' ');
INSERT INTO answer VALUES (5710, 1428, 1, 'ca. 75 Watt', ' ');
INSERT INTO answer VALUES (5711, 1428, 2, 'ca. 160 Watt', ' ');
INSERT INTO answer VALUES (5712, 1428, 3, 'ca. 265 Watt', ' ');
INSERT INTO answer VALUES (5713, 1429, 0, 'Ja, er ist in diesem Fall verpflichtet, die Einhaltung der Personenschutzgrenzwerte nachzuweisen.', ' ');
INSERT INTO answer VALUES (5714, 1429, 1, 'Nein, der Schutz von Personen in elektromagnetischen Feldern ist durch den Funkamateur erst bei einer Strahlungsleistung von mehr als 10 W EIRP sicherzustellen.', ' ');
INSERT INTO answer VALUES (5715, 1429, 2, 'Nur wenn die Antenne vertikal polarisiert ist. Bei horizontaler Polarisation kann er davon ausgehen, dass eine Richtantenne mit diesem Gewinn einen sehr kleinen vertikalen Öffnungswinkel hat und die Personenschutzgrenzwerte auf jeden Fall eingehalten werden.', ' ');
INSERT INTO answer VALUES (5716, 1429, 3, 'Nein, bei der Sendeart F3E und Sendezeiten unter 6 Minuten in der Stunde kann der Schutz von Personen in elektromagnetischen Feldern durch den Funkamateur vernachlässigt werden.', ' ');
INSERT INTO answer VALUES (5717, 1430, 0, 'Der maximale Augenblickswert der Feldstärke des modulierten Trägers.', ' ');
INSERT INTO answer VALUES (5718, 1430, 1, 'Der zeitlich gemittelte Wert der Feldstärke des modulierten Trägers.', ' ');
INSERT INTO answer VALUES (5719, 1430, 2, 'Die mittlere Feldstärke des modulierten Trägers.', ' ');
INSERT INTO answer VALUES (5720, 1430, 3, 'Die effektive Feldstärke des unmodulierten Trägers.', ' ');
INSERT INTO answer VALUES (5721, 1431, 0, 'Nein, die Feldstärke beeinflusst unmittelbar, also zeitunabhängig.', ' ');
INSERT INTO answer VALUES (5722, 1431, 1, 'Ja, Grenzwerte gelten im Zeitraum einer Kurzzeitexposition bis zu 6 Minuten.', ' ');
INSERT INTO answer VALUES (5723, 1431, 2, 'Ja, die Grenzwerte gelten im Zeitraum einer Exposition von 6 Minuten bis zu 8 Stunden.', ' ');
INSERT INTO answer VALUES (5724, 1431, 3, 'Ja, in Abhängigkeit von der körperlichen Verfassung des Herzschrittmacherträgers.', ' ');
INSERT INTO answer VALUES (5725, 1432, 0, 'Wenn die vorhandene Blitzschutzanlage fachgerecht aufgebaut ist und das Standrohr mit ihr auf einem sehr kurzen Weg verbunden werden kann.', ' ');
INSERT INTO answer VALUES (5726, 1432, 1, 'Nach den geltenden Vorschriften muss das Standrohr der Amateurfunkantenne mit einer vorhandenen Gebäude-Blitzschutzanlage verbunden werden.', ' ');
INSERT INTO answer VALUES (5727, 1432, 2, 'Nach den geltenden Vorschriften muss immer eine eigene Blitzschutzanlage für eine Amateurfunkantenne aufgebaut werden.', ' ');
INSERT INTO answer VALUES (5728, 1432, 3, 'Die Bedingung ist ein ausreichend großer Querschnitt für die Verbindungsleitung zur Blitzschutzanlage.', ' ');
INSERT INTO answer VALUES (5729, 1433, 0, 'Als geeigneter Erdungsleiter gilt ein Einzelmassivdraht mit einem Mindestquerschnitt von 16 mm² Kupfer, isoliert oder blank, oder 25 mm² Aluminium isoliert oder 50 mm² Stahl.', ' ');
INSERT INTO answer VALUES (5730, 1433, 1, 'Ein- oder mehrdrähtiger - aber nicht feindrähtiger - isolierter oder blanker Kupferleiter mit mindestens 10 mm² Querschnitt oder ein Aluminiumleiter mit mindestens 16 mm² Querschnitt.', ' ');
INSERT INTO answer VALUES (5731, 1433, 2, 'Ein- oder mehrdrähtiger - aber nicht feindrähtiger - isolierter oder blanker Kupferleiter mit mindestens 25 mm² Querschnitt oder ein Aluminiumleiter mit mindestens 50 mm² Querschnitt.', ' ');
INSERT INTO answer VALUES (5732, 1433, 3, 'Als geeigneter Erdungsleiter gilt ein Einzeldraht mit einem Mindestquerschnitt von 4 mm² Kupfer, isoliert oder blank, oder 10 mm² Aluminium isoliert.', ' ');
INSERT INTO answer VALUES (5733, 1434, 0, 'Jeder ordnungsgemäß verlegte Fundamenterder kann verwendet werden, sofern alle Blitzschutzleitungen bis zur Potentialausgleichsschiene getrennt geführt werden.', ' ');
INSERT INTO answer VALUES (5734, 1434, 1, 'Nach den geltenden Vorschriften muss immer eine eigene Blitzschutzanlage, also auch ein eigener Fundamenterder, für eine Amateurfunkantenne aufgebaut werden.', ' ');
INSERT INTO answer VALUES (5735, 1434, 2, 'Die in den Sicherheitsvorschriften festgelegte zulässige Leitungslänge des Erdungsleiters darf auf keinen Fall überschritten werden.', ' ');
INSERT INTO answer VALUES (5736, 1434, 3, 'Die Ausdehnung des Fundamenterders muss größer oder wenigstens gleich der Ausdehnung der Antennenanlage sein.', ' ');
INSERT INTO answer VALUES (5737, 1435, 0, 'Die Außenleiter (Abschirmung) aller Koaxialkabel-Niederführungen müssen über einen Potentialausgleichsleiter normgerecht mit Erde verbunden werden.', ' ');
INSERT INTO answer VALUES (5738, 1435, 1, 'Für alle Koaxialkabel-Niederführungen sind entsprechend den Sicherheitsvorschriften Überspannungsableiter vorzusehen.', ' ');
INSERT INTO answer VALUES (5739, 1435, 2, 'Neben der Erdung des Antennenmastes sind keine weiteren Maßnahmen erforderlich.', ' ');
INSERT INTO answer VALUES (5740, 1435, 3, 'Die Koaxialkabel müssen das entsprechende Schirmungsmaß aufweisen und entsprechend isoliert sein.', ' ');
INSERT INTO answer VALUES (5741, 1436, 0, 'grüngelb, braun, blau', ' ');
INSERT INTO answer VALUES (5742, 1436, 1, 'braun, grüngelb, blau', ' ');
INSERT INTO answer VALUES (5743, 1436, 2, 'grau, schwarz, rot', ' ');
INSERT INTO answer VALUES (5744, 1436, 3, 'grüngelb, blau, braun oder schwarz', ' ');
INSERT INTO answer VALUES (5745, 1437, 0, 'die Anweisungen des Kfz-Herstellers zu beachten.', ' ');
INSERT INTO answer VALUES (5746, 1437, 1, 'die Bedingungen der Bundesnetzagentur für den Einbau mobiler Sendeanlagen einzuhalten.', ' ');
INSERT INTO answer VALUES (5747, 1437, 2, 'die Ratschläge des Kfz-Händlers einzuhalten.', ' ');
INSERT INTO answer VALUES (5748, 1437, 3, 'die Anweisungen des Amateurfunkgeräte-Herstellers zu beachten.', ' ');
INSERT INTO answer VALUES (5749, 1438, 0, 'möglichst weit von der Fahrzeugverkabelung entfernt verlegt werden.', ' ');
INSERT INTO answer VALUES (5750, 1438, 1, 'im Kabelbaum des Kraftfahrzeugs geführt werden.', ' ');
INSERT INTO answer VALUES (5751, 1438, 2, 'über das Fahrzeugdach verlegt sein.', ' ');
INSERT INTO answer VALUES (5752, 1438, 3, 'entlang der Innenseite des Motorraumes verlegt werden.', ' ');
INSERT INTO answer VALUES (5753, 1439, 0, 'die Verwendung der internationalen Buchstabiertafel nach den Radio Regulations (VO Funk).', ' ');
INSERT INTO answer VALUES (5754, 1439, 1, 'die Überprüfung des Rufzeichens in einer Liste.', ' ');
INSERT INTO answer VALUES (5755, 1439, 2, 'Beachtung der Vorschriften zur AFuV.', ' ');
INSERT INTO answer VALUES (5756, 1439, 3, 'mehrmalige Wiederholungen.', ' ');
INSERT INTO answer VALUES (5757, 1440, 0, 'Mike Uniform Echo November Charlie Hotel Echo November', ' ');
INSERT INTO answer VALUES (5758, 1440, 1, 'Mike United Echo Nancy Charlie Hotel Echo Nancy', ' ');
INSERT INTO answer VALUES (5759, 1440, 2, 'Mike Uniform Emil Nevada Charlie Hotel Emil November', ' ');
INSERT INTO answer VALUES (5760, 1440, 3, 'Michigan Union Echo November Charlie Hotel Echo Nancy', ' ');
INSERT INTO answer VALUES (5761, 1441, 0, 'Tango Romeo Alpha Viktor Echo, Mike, Uniform, Echo, November, Delta, Echo', ' ');
INSERT INTO answer VALUES (5762, 1441, 1, 'Tango Romeo Alpha Viktor Echo, Mike, Übel, November, Delta, Echo', ' ');
INSERT INTO answer VALUES (5763, 1441, 2, 'Tango Romeo Alpha Viktor Echo, Mike, Ülzen, Echo, November, Delta, Echo', ' ');
INSERT INTO answer VALUES (5764, 1441, 3, 'Tango Romeo Alpha Viktor Echo, Mike, Uniform, Echo, Nancy, Delta, Echo', ' ');
INSERT INTO answer VALUES (5765, 1442, 0, 'Delta Oscar 9 X-Ray Yankee Zulu', ' ');
INSERT INTO answer VALUES (5766, 1442, 1, 'Dora Otto 9 Xantippe Ypsilon Zeppelin', ' ');
INSERT INTO answer VALUES (5767, 1442, 2, 'Delta Oscar 9 X-Ray Yankee Zansibar', ' ');
INSERT INTO answer VALUES (5768, 1442, 3, 'Denmark Ontario 9 Xylophon Yokohama Zansibar', ' ');
INSERT INTO answer VALUES (5769, 1443, 0, 'Delta Hotel acht Delta Alpha Papa', ' ');
INSERT INTO answer VALUES (5770, 1443, 1, 'Dora Heinrich acht Dora Anton Paula', ' ');
INSERT INTO answer VALUES (5771, 1443, 2, 'Delta Hotel acht Delta Alpha Portugal', ' ');
INSERT INTO answer VALUES (5772, 1443, 3, 'Denmark Honolulu acht Delta Alpha Papa', ' ');
INSERT INTO answer VALUES (5773, 1444, 0, 'Delta Lima zwo Kilo Charlie India', ' ');
INSERT INTO answer VALUES (5774, 1444, 1, 'Dora Ludwig zwei Kaufmann Cäsar Ida', ' ');
INSERT INTO answer VALUES (5775, 1444, 2, 'Delta Lima zwo Kilo Charlie Italy', ' ');
INSERT INTO answer VALUES (5776, 1444, 3, 'Deutschland London zwo Kilo Charlie India', ' ');
INSERT INTO answer VALUES (5777, 1445, 0, 'Delta Foxtrott drei Delta Charlie Bravo', ' ');
INSERT INTO answer VALUES (5778, 1445, 1, 'Dora Friedrich drei Dora Cäsar Berta', ' ');
INSERT INTO answer VALUES (5779, 1445, 2, 'Delta Fox drei Delta Charlie Baltimore', ' ');
INSERT INTO answer VALUES (5780, 1445, 3, 'Da Fangen drei Dänen Charlie Braun', ' ');
INSERT INTO answer VALUES (5781, 1446, 0, 'Echo Alpha fünf Strich Delta Juliett vier Uniform Foxtrott', ' ');
INSERT INTO answer VALUES (5782, 1446, 1, 'Echo Alpha fünf Strich Delta Juliett vier United Fox', ' ');
INSERT INTO answer VALUES (5783, 1446, 2, 'England Amerika fünf Strich Dänemark Japan vier Uruguay Frankreich', ' ');
INSERT INTO answer VALUES (5784, 1446, 3, 'Emil Anton fünf Strich Dora Japan vier Ullrich Friedrich', ' ');
INSERT INTO answer VALUES (5785, 1447, 0, 'Papa Yankee 8 Juliett Whiskey', ' ');
INSERT INTO answer VALUES (5786, 1447, 1, 'Papa Yankee 8 Japan Whiskey', ' ');
INSERT INTO answer VALUES (5787, 1447, 2, 'Paraguay Yankee 8 Juliett Whiskey', ' ');
INSERT INTO answer VALUES (5788, 1447, 3, 'Pacific Yankee 8 Juliett Wilhelm', ' ');
INSERT INTO answer VALUES (5789, 1448, 0, 'Yankee Oskar 9 X-Ray Hotel', ' ');
INSERT INTO answer VALUES (5790, 1448, 1, 'Ypsilon Ontario 9 X-Ray Hotel', ' ');
INSERT INTO answer VALUES (5791, 1448, 2, 'Yankee Oskar 9 X-Ray Honolulu', ' ');
INSERT INTO answer VALUES (5792, 1448, 3, 'Yuliett Ontario 9 Xanthippe Hotel', ' ');
INSERT INTO answer VALUES (5793, 1449, 0, 'Hotel Bravo null Strich Delta Kilo eins Delta November Strich portabel', ' ');
INSERT INTO answer VALUES (5794, 1449, 1, 'Heinrich Berta null Strich Dora Kaufmann eins Dora Nordpol Strich portabel', ' ');
INSERT INTO answer VALUES (5795, 1449, 2, 'Honolulu Baltimore null Strich Dänemark Kanada eins Dänemark Norwegen Strich portabel', ' ');
INSERT INTO answer VALUES (5796, 1449, 3, 'Hotel Bravo null Strich Delta Kilo eins Delta Norway Strich portabel', ' ');
INSERT INTO answer VALUES (5797, 1450, 0, 'Durch die Verwendung von Betriebsabkürzungen und Q-Gruppen wird der Betriebsablauf vereinfacht und der übertragende Informationsgehalt pro Zeiteinheit optimiert.', ' ');
INSERT INTO answer VALUES (5798, 1450, 1, 'Durch die Verwendung von Betriebsabkürzungen und Q-Gruppen wird der Informationsgehalt einer Aussendung verschleiert und damit für Unbeteiligte nicht verständlich.', ' ');
INSERT INTO answer VALUES (5799, 1450, 2, 'Betriebsabkürzungen und Q-Gruppen werden nur bei besonderen Betriebsbedingungen verwendet, um z.B. den Einfluss von Fading oder Aurora auszugleichen.', ' ');
INSERT INTO answer VALUES (5800, 1450, 3, 'Ein Betriebsverfahren, bei dem jeweils manuell auf Empfang geschaltet werden muss.', ' ');
INSERT INTO answer VALUES (5801, 1451, 0, '"DX" bedeutet für Stationen aus Deutschland, dass keine innereuropäischen Funkverbindungen gemeint sind.', ' ');
INSERT INTO answer VALUES (5802, 1451, 1, '"DX" bedeutet für Stationen aus Deutschland, dass Stationen außerhalb der Landesgrenzen gemeint sind.', ' ');
INSERT INTO answer VALUES (5803, 1451, 2, '"DX" bedeutet für Stationen aus Deutschland, dass die Gegenstelle nur einen kurzen Rapportaustausch durchführen möchte.', ' ');
INSERT INTO answer VALUES (5804, 1451, 3, '"DX" bedeutet für Stationen aus Deutschland die Bezeichnung für einen Wettbewerb.', ' ');
INSERT INTO answer VALUES (5805, 1452, 0, 'Sender, Empfänger', ' ');
INSERT INTO answer VALUES (5806, 1452, 1, 'Empfänger, Sender', ' ');
INSERT INTO answer VALUES (5807, 1452, 2, 'Tonqualität, Bildqualität', ' ');
INSERT INTO answer VALUES (5808, 1452, 3, 'Bildqualität, Tonqualität', ' ');
INSERT INTO answer VALUES (5809, 1453, 0, 'Allgemeiner Anruf', ' ');
INSERT INTO answer VALUES (5810, 1453, 1, 'Telegrafie', ' ');
INSERT INTO answer VALUES (5811, 1453, 2, 'Große Entfernung', ' ');
INSERT INTO answer VALUES (5812, 1453, 3, 'Sie werden gerufen.', ' ');
INSERT INTO answer VALUES (5813, 1454, 0, 'Telegrafie (continuous wave)', ' ');
INSERT INTO answer VALUES (5814, 1454, 1, 'Telefonie (continuous wireless)', ' ');
INSERT INTO answer VALUES (5815, 1454, 2, 'Allgemeiner Anruf (calling wide)', ' ');
INSERT INTO answer VALUES (5816, 1454, 3, 'Sie werden gerufen. (calling wave)', ' ');
INSERT INTO answer VALUES (5817, 1455, 0, 'KA2WEU sucht eine Verbindung mit einem Funkamateur aus Deutschland.', ' ');
INSERT INTO answer VALUES (5818, 1455, 1, 'Der amerikanische Funkamateur sucht Verbindungen mit Funkamateuren, die weit entfernt sind.', ' ');
INSERT INTO answer VALUES (5819, 1455, 2, 'KA2WEU sucht nur eine Verbindung mit einem Funkamateur, dessen Rufzeichen mit DL beginnt.', ' ');
INSERT INTO answer VALUES (5820, 1455, 3, 'KA2WEU sucht eine Verbindung mit Stationen, die an einem deutschen Wettbewerb teilnehmen.', ' ');
INSERT INTO answer VALUES (5821, 1456, 0, 'Received (richtig empfangen)', ' ');
INSERT INTO answer VALUES (5822, 1456, 1, 'Repeat (wiederhole)', ' ');
INSERT INTO answer VALUES (5823, 1456, 2, 'Rapport', ' ');
INSERT INTO answer VALUES (5824, 1456, 3, 'Readability (Lesbarkeit)', ' ');
INSERT INTO answer VALUES (5825, 1457, 0, 'Aufforderung zum Senden', ' ');
INSERT INTO answer VALUES (5826, 1457, 1, 'Unterbrechung der Sendung', ' ');
INSERT INTO answer VALUES (5827, 1457, 2, 'Bitte warten!', ' ');
INSERT INTO answer VALUES (5828, 1457, 3, 'Beendigung des Funkverkehrs', ' ');
INSERT INTO answer VALUES (5829, 1458, 0, 'Signal zur Unterbrechung der Sendung', ' ');
INSERT INTO answer VALUES (5830, 1458, 1, 'Alles richtig verstanden', ' ');
INSERT INTO answer VALUES (5831, 1458, 2, 'Bitte warten!', ' ');
INSERT INTO answer VALUES (5832, 1458, 3, 'Beendigung des Funkverkehrs', ' ');
INSERT INTO answer VALUES (5833, 1459, 0, 'CQ CQ CQ DE DO1LEN DO1LEN DO1LEN', ' ');
INSERT INTO answer VALUES (5834, 1459, 1, 'CQ CQ CQ CQ CQ CQ DE DO1LEN', ' ');
INSERT INTO answer VALUES (5835, 1459, 2, 'QRZ QRZ QRZ DE DO1LEN DO1LEN DO1LEN', ' ');
INSERT INTO answer VALUES (5836, 1459, 3, 'CQ QRZ CQ QRZ DE DO1LEN DO1LEN DO1LEN', ' ');
INSERT INTO answer VALUES (5837, 1460, 0, 'Mitteilung', ' ');
INSERT INTO answer VALUES (5838, 1460, 1, 'Alles richtig verstanden', ' ');
INSERT INTO answer VALUES (5839, 1460, 2, 'Mit freundlichen Grüßen', ' ');
INSERT INTO answer VALUES (5840, 1460, 3, 'Mäßiges Signal', ' ');
INSERT INTO answer VALUES (5841, 1461, 0, 'zur Vereinfachung und Erleichterung des Betriebsablaufs bei Telegrafie, sekundär zur Überwindung sprachlicher Grenzen.', ' ');
INSERT INTO answer VALUES (5842, 1461, 1, 'zur Verschleierung des Funkbetriebes gegenüber unbefugten Zuhörern.', ' ');
INSERT INTO answer VALUES (5843, 1461, 2, 'zur Zeitersparnis im Telefoniefunkverkehr.', ' ');
INSERT INTO answer VALUES (5844, 1461, 3, 'um im internationalen Funkverkehr den Betriebsablauf zu erleichtern, weil kein Englisch mehr gesprochen werden muss.', ' ');
INSERT INTO answer VALUES (5845, 1462, 0, 'Nein, weil die Abkürzungen für den Telegrafiefunkverkehr vorgesehen sind.', ' ');
INSERT INTO answer VALUES (5846, 1462, 1, 'Ja, weil die Abkürzungen die Abwicklung des Funkverkehrs beschleunigen.', ' ');
INSERT INTO answer VALUES (5847, 1462, 2, 'Ja, weil die Abkürzungen bei deutschsprachigen Funkverbindungen erlaubt sind.', ' ');
INSERT INTO answer VALUES (5848, 1462, 3, 'Ja, weil die Abkürzungen die Besonderheit der Sprache im Funkverkehr kennzeichnet.', ' ');
INSERT INTO answer VALUES (5849, 1463, 0, 'Ich bin bereit. Werden Sie gestört? Mein Standort ist …', ' ');
INSERT INTO answer VALUES (5850, 1463, 1, 'Senden Sie eine Reihe V. Soll ich mehr Sendeleistung anwenden? Ihre gesendeten Töne sind kaum hörbar.', ' ');
INSERT INTO answer VALUES (5851, 1463, 2, 'Ich habe nichts mehr für Sie. Werden Sie gestört? Mein Standort ist …', ' ');
INSERT INTO answer VALUES (5852, 1463, 3, 'Ich habe nichts mehr für Sie. Mein Standort ist … Ich bin bereit.', ' ');
INSERT INTO answer VALUES (5853, 1464, 0, 'die Verständlichkeit meiner Zeichen schlecht ist.', ' ');
INSERT INTO answer VALUES (5854, 1464, 1, 'ich um 1 kHz Frequenzwechsel machen soll.', ' ');
INSERT INTO answer VALUES (5855, 1464, 2, 'ich eine Minute warten soll.', ' ');
INSERT INTO answer VALUES (5856, 1464, 3, 'er atmosphärische Störungen der Stärke 1 hat.', ' ');
INSERT INTO answer VALUES (5857, 1465, 0, 'Stellen Sie die Übermittlung ein. Von wem werde ich gerufen? Können Sie mir Empfangsbestätigung geben?', ' ');
INSERT INTO answer VALUES (5858, 1465, 1, 'Stellen Sie die Übermittlung ein. Ich bin bereit. Schicken Sie eine QSL-Karte?', ' ');
INSERT INTO answer VALUES (5859, 1465, 2, 'Stellen Sie die Übermittlung ein. Wie ist Ihr Standort? Können Sie mir Empfangsbestätigung geben?', ' ');
INSERT INTO answer VALUES (5860, 1465, 3, 'Ich habe nichts für Sie. Von wem werde ich gerufen? Können Sie mir Empfangsbestätigung geben?', ' ');
INSERT INTO answer VALUES (5861, 1466, 0, 'Soll ich die Sendeleistung erhöhen? Können Sie direkt Funkverkehr aufnehmen mit …? Wann werden Sie mich wieder rufen?', ' ');
INSERT INTO answer VALUES (5862, 1466, 1, 'Soll ich meine Sendeleistung erhöhen? Haben Sie noch etwas für mich vorliegen? Werden Sie mich wieder rufen?', ' ');
INSERT INTO answer VALUES (5863, 1466, 2, 'Soll ich die Sendeleistung erniedrigen? Haben Sie noch etwas für mich vorliegen? Können Sie direkt Funkverkehr aufnehmen mit …?', ' ');
INSERT INTO answer VALUES (5864, 1466, 3, 'Haben Sie noch etwas für mich vorliegen? Können Sie direkt Funkverkehr aufnehmen mit …? Wann werden Sie mich wieder rufen?', ' ');
INSERT INTO answer VALUES (5865, 1467, 0, 'Ich werde gestört. Ich habe atmosphärische Störungen. Schwankt die Stärke meiner Zeichen?', ' ');
INSERT INTO answer VALUES (5866, 1467, 1, 'Ich habe Störungen. Sie haben Schwankungen Ihrer Zeichen. Werden Sie gestört?', ' ');
INSERT INTO answer VALUES (5867, 1467, 2, 'Ich habe atmosphärische Störungen. Ich werde gestört. Schwankt die Stärke meiner Zeichen?', ' ');
INSERT INTO answer VALUES (5868, 1467, 3, 'Die Stärke Ihrer Zeichen schwankt. Ich werde gestört. Haben Sie atmosphärische Störungen?', ' ');
INSERT INTO answer VALUES (5869, 1468, 0, 'Sie wechseln die Frequenz.', ' ');
INSERT INTO answer VALUES (5870, 1468, 1, 'Sie erhöhen die Sendeleistung.', ' ');
INSERT INTO answer VALUES (5871, 1468, 2, 'Sie verringern die Sendeleistung.', ' ');
INSERT INTO answer VALUES (5872, 1468, 3, 'Sie senden eine Bestätigungskarte an die Gegenstation.', ' ');
INSERT INTO answer VALUES (5873, 1469, 0, 'Sie verringern die Sendeleistung.', ' ');
INSERT INTO answer VALUES (5874, 1469, 1, 'Sie erhöhen die Sendeleistung.', ' ');
INSERT INTO answer VALUES (5875, 1469, 2, 'Sie wechseln die Frequenz.', ' ');
INSERT INTO answer VALUES (5876, 1469, 3, 'Sie senden eine Bestätigungskarte an die Gegenstation.', ' ');
INSERT INTO answer VALUES (5877, 1470, 0, 'um die Empfangsqualität zu beschreiben.', ' ');
INSERT INTO answer VALUES (5878, 1470, 1, 'um die Sendeleistung zu beschreiben.', ' ');
INSERT INTO answer VALUES (5879, 1470, 2, 'um den Ionosphärenzustand zu beschreiben.', ' ');
INSERT INTO answer VALUES (5880, 1470, 3, 'um die Sonnenfleckenaktivität zu beschreiben.', ' ');
INSERT INTO answer VALUES (5881, 1471, 0, 'R = Lesbarkeit, S = Signalstärke, T = Tonqualität', ' ');
INSERT INTO answer VALUES (5882, 1471, 1, 'R = Rufzeichen, S = Signalstärke, T = Tonqualität', ' ');
INSERT INTO answer VALUES (5883, 1471, 2, 'R = Lesbarkeit, S = Signalstärke, T = Trägerfrequenz', ' ');
INSERT INTO answer VALUES (5884, 1471, 3, 'R = Rufzeichen, S = Standort, T = Tonqualität', ' ');
INSERT INTO answer VALUES (5885, 1472, 0, 'Um eine S-Stufe', ' ');
INSERT INTO answer VALUES (5886, 1472, 1, 'Um zwei S-Stufen', ' ');
INSERT INTO answer VALUES (5887, 1472, 2, 'Um vier S-Stufen', ' ');
INSERT INTO answer VALUES (5888, 1472, 3, 'Um acht S-Stufen', ' ');
INSERT INTO answer VALUES (5889, 1473, 0, '18 dB', ' ');
INSERT INTO answer VALUES (5890, 1473, 1, '9 dB', ' ');
INSERT INTO answer VALUES (5891, 1473, 2, '28 dB', ' ');
INSERT INTO answer VALUES (5892, 1473, 3, '3 dB', ' ');
INSERT INTO answer VALUES (5893, 1474, 0, 'Lesbarkeit in Stufen von 1-5, Signalstärke in Stufen von 1-9 und Tonqualität in Stufen von 1-9', ' ');
INSERT INTO answer VALUES (5894, 1474, 1, 'Lesbarkeit in Stufen von 1-5, Signalstärke in Stufen von 1-5 und Tonhöhe in Stufen von 1-9', ' ');
INSERT INTO answer VALUES (5895, 1474, 2, 'Signalqualität in Stufen von 1-5, Signalstärke in Stufen von 1-5 und Tonqualität in Stufen von 1-9', ' ');
INSERT INTO answer VALUES (5896, 1474, 3, 'Lesbarkeit in Stufen von 1-9, Signalqualität in Stufen von 1-5 und Tonhöhe in Stufen von 1-4', ' ');
INSERT INTO answer VALUES (5897, 1475, 0, '26 dB.', ' ');
INSERT INTO answer VALUES (5898, 1475, 1, '23 dB.', ' ');
INSERT INTO answer VALUES (5899, 1475, 2, '6 dB.', ' ');
INSERT INTO answer VALUES (5900, 1475, 3, '20 dB.', ' ');
INSERT INTO answer VALUES (5901, 1476, 0, '25 µV.', ' ');
INSERT INTO answer VALUES (5902, 1476, 1, '37 µV.', ' ');
INSERT INTO answer VALUES (5903, 1476, 2, '40 µV.', ' ');
INSERT INTO answer VALUES (5904, 1476, 3, '30 µV.', ' ');
INSERT INTO answer VALUES (5905, 1477, 0, 'Er kann mich einwandfrei lesen und mein Signal ist ausreichend stark. Bei seinem Empfänger ist die relative Signalstärke in dB ablesbar.', ' ');
INSERT INTO answer VALUES (5906, 1477, 1, 'Er kann mich einwandfrei lesen, mein Signal ist stark und fast rauschfrei. Bei seinem Empfänger ist die relative Signalstärke in dBµV ablesbar.', ' ');
INSERT INTO answer VALUES (5907, 1477, 2, 'Er kann mich ohne Schwierigkeiten lesen, obwohl mein Signal sehr schwach ist. Bei seinem Empfänger wird das Signal-/Rauschverhältnis in dB angezeigt.', ' ');
INSERT INTO answer VALUES (5908, 1477, 3, 'Er kann mich nur mit Schwierigkeiten lesen, da mein Signal mit 30 dB stark verrauscht ist. Bei ihm ist die relative Signalstärke auf einem Messgerät in dB ablesbar.', ' ');
INSERT INTO answer VALUES (5909, 1478, 0, 'Die Station kann mich ohne Schwierigkeiten mit einem starken Signal empfangen.', ' ');
INSERT INTO answer VALUES (5910, 1478, 1, 'Die Station kann mich ohne Schwierigkeiten mit einem relativ schwachen Signal empfangen.', ' ');
INSERT INTO answer VALUES (5911, 1478, 2, 'Die Station kann mich nur mit Schwierigkeiten mit einem schwachen Signal empfangen.', ' ');
INSERT INTO answer VALUES (5912, 1478, 3, 'Die Station kann mich nur zeitweise aber mit einem starken Signal empfangen.', ' ');
INSERT INTO answer VALUES (5913, 1479, 0, 'Ich gebe einen Rapport von zum Beispiel 33 bzw. 339, damit der Funkpartner weiß, dass er seine Angaben deutlich und mit eventuell mehreren Wiederholungen durchgeben muss.', ' ');
INSERT INTO answer VALUES (5914, 1479, 1, 'Ich gebe den Rapport 59 bzw. 599 nach subjektiver Einschätzung, denn auf die S-Meter- Anzeige kann ich mich in diesem Fall nicht verlassen.', ' ');
INSERT INTO answer VALUES (5915, 1479, 2, 'Ich bestätige z.B. mit 57 bzw. 579, frage aber zur Sicherheit im nächsten Durchgang noch einmal nach Name und Standort.', ' ');
INSERT INTO answer VALUES (5916, 1479, 3, 'Ich gebe grundsätzlich 59 oder 599, da ich ja das Rufzeichen der Station einwandfrei aufgenommen habe.', ' ');
INSERT INTO answer VALUES (5917, 1480, 0, 'R, S und "A" für Aurora, da der Ton bei Aurora sehr rau ist und nicht beurteilt werden kann.', ' ');
INSERT INTO answer VALUES (5918, 1480, 1, 'R, S, T.', ' ');
INSERT INTO answer VALUES (5919, 1480, 2, 'R und T, da Aurora als Lineartransponder wirkt.', ' ');
INSERT INTO answer VALUES (5920, 1480, 3, 'R, S, T und "A" für Aurora.', ' ');
INSERT INTO answer VALUES (5921, 1481, 0, 'R, S und „V" für Video-Qualität, V in 5 Stufen.', ' ');
INSERT INTO answer VALUES (5922, 1481, 1, 'V, S, T, mit „V" für Video-Qualität, V in 5 Stufen.', ' ');
INSERT INTO answer VALUES (5923, 1481, 2, 'mit „S“ für Signalstärke und „V" für Video- Qualität, S und V in 9 Stufen.', ' ');
INSERT INTO answer VALUES (5924, 1481, 3, 'R, S, T und einer zusätzlichen Bildbewertung.', ' ');
INSERT INTO answer VALUES (5925, 1482, 0, 'A1A', ' ');
INSERT INTO answer VALUES (5926, 1482, 1, 'NØN', ' ');
INSERT INTO answer VALUES (5927, 1482, 2, 'A2A', ' ');
INSERT INTO answer VALUES (5928, 1482, 3, 'R3E', ' ');
INSERT INTO answer VALUES (5929, 1483, 0, 'F3E', ' ');
INSERT INTO answer VALUES (5930, 1483, 1, 'A3E', ' ');
INSERT INTO answer VALUES (5931, 1483, 2, 'A2A', ' ');
INSERT INTO answer VALUES (5932, 1483, 3, 'R3E', ' ');
INSERT INTO answer VALUES (5933, 1484, 0, 'J3E', ' ');
INSERT INTO answer VALUES (5934, 1484, 1, 'J2E', ' ');
INSERT INTO answer VALUES (5935, 1484, 2, 'R2A', ' ');
INSERT INTO answer VALUES (5936, 1484, 3, 'A1A', ' ');
INSERT INTO answer VALUES (5937, 1485, 0, 'A2A', ' ');
INSERT INTO answer VALUES (5938, 1485, 1, 'A2B', ' ');
INSERT INTO answer VALUES (5939, 1485, 2, 'J2M', ' ');
INSERT INTO answer VALUES (5940, 1485, 3, 'A2C', ' ');
INSERT INTO answer VALUES (5941, 1486, 0, 'J2B', ' ');
INSERT INTO answer VALUES (5942, 1486, 1, 'A1B', ' ');
INSERT INTO answer VALUES (5943, 1486, 2, 'F3B', ' ');
INSERT INTO answer VALUES (5944, 1486, 3, 'A2C', ' ');
INSERT INTO answer VALUES (5945, 1487, 0, 'C3F', ' ');
INSERT INTO answer VALUES (5946, 1487, 1, 'J3F', ' ');
INSERT INTO answer VALUES (5947, 1487, 2, 'F3F', ' ');
INSERT INTO answer VALUES (5948, 1487, 3, 'A3F', ' ');
INSERT INTO answer VALUES (5949, 1488, 0, 'J2B', ' ');
INSERT INTO answer VALUES (5950, 1488, 1, 'J3B', ' ');
INSERT INTO answer VALUES (5951, 1488, 2, 'F2A', ' ');
INSERT INTO answer VALUES (5952, 1488, 3, 'J3A', ' ');
INSERT INTO answer VALUES (5953, 1489, 0, '2320 - 2450 MHz', ' ');
INSERT INTO answer VALUES (5954, 1489, 1, '1240 - 1300 MHz', ' ');
INSERT INTO answer VALUES (5955, 1489, 2, '3400 - 3475 MHz', ' ');
INSERT INTO answer VALUES (5956, 1489, 3, '5650 - 5850 MHz', ' ');
INSERT INTO answer VALUES (5957, 1490, 0, '1240 - 1300 MHz', ' ');
INSERT INTO answer VALUES (5958, 1490, 1, '2320 - 2450 MHz', ' ');
INSERT INTO answer VALUES (5959, 1490, 2, '3400 - 3475 MHz', ' ');
INSERT INTO answer VALUES (5960, 1490, 3, '5650 - 5850 MHz', ' ');
INSERT INTO answer VALUES (5961, 1491, 0, '430 - 440 MHz', ' ');
INSERT INTO answer VALUES (5962, 1491, 1, '50,08 - 51 MHz', ' ');
INSERT INTO answer VALUES (5963, 1491, 2, '144 - 146 MHz', ' ');
INSERT INTO answer VALUES (5964, 1491, 3, '1240 - 1300 MHz', ' ');
INSERT INTO answer VALUES (5965, 1492, 0, '144 - 146 MHz', ' ');
INSERT INTO answer VALUES (5966, 1492, 1, '50,08 - 51 MHz', ' ');
INSERT INTO answer VALUES (5967, 1492, 2, '430 - 440 MHz', ' ');
INSERT INTO answer VALUES (5968, 1492, 3, '70 - 70,5 MHz', ' ');
INSERT INTO answer VALUES (5969, 1493, 0, '50,08 - 51 MHz', ' ');
INSERT INTO answer VALUES (5970, 1493, 1, '144 - 146 MHz', ' ');
INSERT INTO answer VALUES (5971, 1493, 2, '28 - 29,7 MHz', ' ');
INSERT INTO answer VALUES (5972, 1493, 3, '70 - 70,5 MHz', ' ');
INSERT INTO answer VALUES (5973, 1494, 0, '28000 - 29700 kHz', ' ');
INSERT INTO answer VALUES (5974, 1494, 1, '18068 - 18168 kHz', ' ');
INSERT INTO answer VALUES (5975, 1494, 2, '24890 - 24990 kHz', ' ');
INSERT INTO answer VALUES (5976, 1494, 3, '21000 - 21450 kHz', ' ');
INSERT INTO answer VALUES (5977, 1495, 0, '24890 - 24990 kHz', ' ');
INSERT INTO answer VALUES (5978, 1495, 1, '14000 - 14350 kHz', ' ');
INSERT INTO answer VALUES (5979, 1495, 2, '18068 - 18168 kHz', ' ');
INSERT INTO answer VALUES (5980, 1495, 3, '21000 - 21450 kHz', ' ');
INSERT INTO answer VALUES (5981, 1496, 0, '21000 - 21450 kHz', ' ');
INSERT INTO answer VALUES (5982, 1496, 1, '14000 - 14350 kHz', ' ');
INSERT INTO answer VALUES (5983, 1496, 2, '24890 - 24990 kHz', ' ');
INSERT INTO answer VALUES (5984, 1496, 3, '18068 - 18168 kHz', ' ');
INSERT INTO answer VALUES (5985, 1497, 0, '18068 - 18168 kHz', ' ');
INSERT INTO answer VALUES (5986, 1497, 1, '14000 - 14350 kHz', ' ');
INSERT INTO answer VALUES (5987, 1497, 2, '24890 - 24990 kHz', ' ');
INSERT INTO answer VALUES (5988, 1497, 3, '21000 - 21450 kHz', ' ');
INSERT INTO answer VALUES (5989, 1498, 0, '14000 - 14350 kHz', ' ');
INSERT INTO answer VALUES (5990, 1498, 1, '21000 - 21450 kHz', ' ');
INSERT INTO answer VALUES (5991, 1498, 2, '24890 - 24990 kHz', ' ');
INSERT INTO answer VALUES (5992, 1498, 3, '18068 - 18168 kHz', ' ');
INSERT INTO answer VALUES (5993, 1499, 0, '10100 - 10150 kHz', ' ');
INSERT INTO answer VALUES (5994, 1499, 1, '21000 - 21450 kHz', ' ');
INSERT INTO answer VALUES (5995, 1499, 2, '14000 - 14350 kHz', ' ');
INSERT INTO answer VALUES (5996, 1499, 3, '18068 - 18168 kHz', ' ');
INSERT INTO answer VALUES (5997, 1500, 0, '7000 - 7200 kHz', ' ');
INSERT INTO answer VALUES (5998, 1500, 1, '3500 - 3800 kHz', ' ');
INSERT INTO answer VALUES (5999, 1500, 2, '14000 - 14350 kHz', ' ');
INSERT INTO answer VALUES (6000, 1500, 3, '10100 - 10150 kHz', ' ');
INSERT INTO answer VALUES (6001, 1501, 0, '3500 - 3800 kHz', ' ');
INSERT INTO answer VALUES (6002, 1501, 1, '7000 - 7200 kHz', ' ');
INSERT INTO answer VALUES (6003, 1501, 2, '1810 - 2000 kHz', ' ');
INSERT INTO answer VALUES (6004, 1501, 3, '135,7 - 137,8 kHz', ' ');
INSERT INTO answer VALUES (6005, 1502, 0, '1810 - 2000 kHz', ' ');
INSERT INTO answer VALUES (6006, 1502, 1, '3500 - 3800 kHz', ' ');
INSERT INTO answer VALUES (6007, 1502, 2, '135,7 - 137,8 kHz', ' ');
INSERT INTO answer VALUES (6008, 1502, 3, '7000 - 7200 kHz', ' ');
INSERT INTO answer VALUES (6009, 1503, 0, 'Die IARU-Bandpläne haben den Charakter einer Empfehlung. Dennoch kommt eine freiwillige möglichst ausnahmslose Einhaltung der Bandpläne allen Teilnehmern am Amateurfunk zugute.', ' ');
INSERT INTO answer VALUES (6010, 1503, 1, 'Die IARU-Bandpläne sind nur in den Ländern oder Regionen mit hoher Amateurfunkstellendichte (z. B. Europa) von praktischem Wert. Dort müssen die Bandpläne grundsätzlich eingehalten werden.', ' ');
INSERT INTO answer VALUES (6011, 1503, 2, 'IARU-Bandpläne sind aufgestellte Frequenzraster nur für solche Amateurfunkstellen, die unbesetzt und automatisch betrieben werden, d. h. Relaisfunkstellen, Digipeater und Funkbaken.', ' ');
INSERT INTO answer VALUES (6012, 1503, 3, 'IARU-Bandpläne haben den Sinn, für die einzelnen Sende- und Betriebsarten eigene, geschützte Frequenzteilbereiche auszuweisen. Jeder Funkamateur hat sich daher verbindlich an die IARU-Bandpläne zu halten.', ' ');
INSERT INTO answer VALUES (6013, 1504, 0, 'Nein, weil ich dann den Amateurfunkdienst über Satelliten stören würde, der in diesem Bereich arbeitet.', ' ');
INSERT INTO answer VALUES (6014, 1504, 1, 'Nein, weil ich dann die Amateurfunkbaken stören würde, die in diesem Bereich arbeiten.', ' ');
INSERT INTO answer VALUES (6015, 1504, 2, 'Ja, denn die beim lokalen Funkverkehr angewandten Sendeleistungen und Antennengewinne sind zu gering, um den in diesem Bereich angesiedelten Amateurfunkdienst über Satelliten zu stören.', ' ');
INSERT INTO answer VALUES (6016, 1504, 3, 'Ja, ich darf in diesem Bereich immer arbeiten, wenn ich den dort ansässigen Amateurfunkverkehr nur gering störe.', ' ');
INSERT INTO answer VALUES (6017, 1505, 0, 'SSB: 144,250 MHz, FM: 145,450 MHz', ' ');
INSERT INTO answer VALUES (6018, 1505, 1, 'SSB: 144,250 MHz, FM: 144,450 MHz', ' ');
INSERT INTO answer VALUES (6019, 1505, 2, 'SSB: 144,300 MHz, FM: 145,050 MHz', ' ');
INSERT INTO answer VALUES (6020, 1505, 3, 'SSB: 145,250 MHz, FM: 144,350 MHz', ' ');
INSERT INTO answer VALUES (6021, 1506, 0, 'Ich schlage der anrufenden Station QSY vor, warte auf die Bestätigung und wechsle die Frequenz.', ' ');
INSERT INTO answer VALUES (6022, 1506, 1, 'Ich gebe zunächst einen Rapport und den Standortkenner durch.', ' ');
INSERT INTO answer VALUES (6023, 1506, 2, 'Ich gebe zunächst die wichtigsten QSO-Daten durch. Wenn ein längeres Gespräch geführt werden soll, schlage ich Frequenzwechsel vor.', ' ');
INSERT INTO answer VALUES (6024, 1506, 3, 'Ich frage die Gegenstation, ob sie eine andere Station auf der Frequenz hört. Wenn nicht, tauschen wir auf dieser Frequenz die Daten aus.', ' ');
INSERT INTO answer VALUES (6025, 1507, 0, '144,300 MHz', ' ');
INSERT INTO answer VALUES (6026, 1507, 1, '144,000 MHz', ' ');
INSERT INTO answer VALUES (6027, 1507, 2, '144,500 MHz', ' ');
INSERT INTO answer VALUES (6028, 1507, 3, '145,300 MHz', ' ');
INSERT INTO answer VALUES (6029, 1508, 0, 'Nein, denn im 30-m-Band ist für deutsche Stationen nur eine Bandbreite bis 800 Hz erlaubt.', ' ');
INSERT INTO answer VALUES (6030, 1508, 1, 'Ja, denn wenn dort eine Station in SSB ruft, wird SSB auch für deutsche Stationen erlaubt sein.', ' ');
INSERT INTO answer VALUES (6031, 1508, 2, 'Ja, denn in diesem Bandsektor ist SSB grundsätzlich erlaubt.', ' ');
INSERT INTO answer VALUES (6032, 1508, 3, 'Nein, der SSB-Bereich ist von 10,100 bis 10,125 MHz.', ' ');
INSERT INTO answer VALUES (6033, 1509, 0, 'Ich suche eine freie Frequenz in dem nach den IARU-Bandplänen für SSB empfohlenen Frequenzbereich im 2-m-Band und rufe „CQ“.', ' ');
INSERT INTO answer VALUES (6034, 1509, 1, 'Ich suche eine freie Frequenz irgendwo im 2-m- Band und rufe „CQ“.', ' ');
INSERT INTO answer VALUES (6035, 1509, 2, 'Ich suche eine freie Frequenz im FM-Simplex- Bereich und rufe „CQ“.', ' ');
INSERT INTO answer VALUES (6036, 1509, 3, 'Ich suche eine freie Frequenz unterhalb von 144,150 MHz und rufe „CQ“.', ' ');
INSERT INTO answer VALUES (6037, 1510, 0, 'Nein, weil besonders die niedrig fliegenden Amateurfunksatelliten wegen der hindernisfreien direkten "Sichtverbindung" sehr stark gestört würden.', ' ');
INSERT INTO answer VALUES (6038, 1510, 1, 'Ja, weil Amateurfunksatelliten dadurch nicht gestört werden.', ' ');
INSERT INTO answer VALUES (6039, 1510, 2, 'Ja, weil Amateurfunksatelliten in anderen als den benutzten Frequenzbereichen arbeiten und deshalb trotz der direkten "Sichtverbindung" nicht gestört werden.', ' ');
INSERT INTO answer VALUES (6040, 1510, 3, 'Nein, weil besonders niedrig fliegende Amateurfunksatelliten wegen der hindernisfreien direkten "Sichtverbindung" zu Ihnen sehr stark stören könnten.', ' ');
INSERT INTO answer VALUES (6041, 1511, 0, 'In der Regel wird im 80-m-Band das untere Seitenband benutzt.', ' ');
INSERT INTO answer VALUES (6042, 1511, 1, 'Im Europaverkehr wird das untere, sonst im Weitverkehr (so genannter DX-Verkehr) wird das obere Seitenband benutzt.', ' ');
INSERT INTO answer VALUES (6043, 1511, 2, 'Um den Nachteil der relativ niedrigen Sendefrequenz des 80-m-Bandes auszugleichen, wird das obere Seitenband benutzt.', ' ');
INSERT INTO answer VALUES (6044, 1511, 3, 'In der unteren Bandhälfte (d. h. zwischen 3500 und 3650 kHz) das untere Seitenband, in der oberen Bandhälfte (d. h. zwischen 3650 und 3800 kHz) das obere Seitenband.', ' ');
INSERT INTO answer VALUES (6045, 1512, 0, 'In der Regel wird im 20-m-Band das obere Seitenband benutzt.', ' ');
INSERT INTO answer VALUES (6046, 1512, 1, 'Im Europaverkehr wird das untere, sonst im Weitverkehr (so genannter DX-Verkehr) wird das obere Seitenband benutzt.', ' ');
INSERT INTO answer VALUES (6047, 1512, 2, 'Um den Nachteil der relativ niedrigen Sendefrequenz des 20-m-Bandes auszugleichen, wird das untere Seitenband benutzt.', ' ');
INSERT INTO answer VALUES (6048, 1512, 3, 'In der unteren Bandhälfte das untere Seitenband, in der oberen Bandhälfte das obere Seitenband.', ' ');
INSERT INTO answer VALUES (6049, 1513, 0, '3500-3580 kHz und 21000-21070 kHz', ' ');
INSERT INTO answer VALUES (6050, 1513, 1, '3500-3600 kHz und 21000-21100 kHz', ' ');
INSERT INTO answer VALUES (6051, 1513, 2, '3580-3620 kHz und 21080-21120 kHz', ' ');
INSERT INTO answer VALUES (6052, 1513, 3, '3500-3540 kHz und 21000-21040 kHz', ' ');
INSERT INTO answer VALUES (6053, 1514, 0, '14112-14350 kHz', ' ');
INSERT INTO answer VALUES (6054, 1514, 1, '14000-14350 kHz', ' ');
INSERT INTO answer VALUES (6055, 1514, 2, '14030-14150 kHz', ' ');
INSERT INTO answer VALUES (6056, 1514, 3, '14100-14300 kHz', ' ');
INSERT INTO answer VALUES (6057, 1515, 0, 'Ich schaue im aktuellen HF-Bandplan der IARU nach, in welchen Frequenzbereichen bevorzugt Funkverkehr in digitalen Betriebsarten stattfinden soll.', ' ');
INSERT INTO answer VALUES (6058, 1515, 1, 'Ich verabrede mich mit meinem Funkpartner auf einer beliebigen freien Frequenz.', ' ');
INSERT INTO answer VALUES (6059, 1515, 2, 'Ich verwende eine Frequenz jeweils in den ersten 30 kHz vom Bandanfang.', ' ');
INSERT INTO answer VALUES (6060, 1515, 3, 'Ich sende auf den Frequenzen, die für das internationale Bakenprojekt (IBP) reserviert sind.', ' ');
INSERT INTO answer VALUES (6061, 1516, 0, 'Im IARU-Region-1-Kurzwellenbandplan ist dieser Bereich als "CW DX" ausgewiesen und sollte für interkontinentale Verbindungen freigehalten werden.', ' ');
INSERT INTO answer VALUES (6062, 1516, 1, 'Gemäß Frequenzbereichszuweisungsplan ist dieser Bereich auch kommerziellen Stationen zugewiesen und muss nachts und im Winter freigehalten werden.', ' ');
INSERT INTO answer VALUES (6063, 1516, 2, 'Im IARU-Region-1-Kurzwellenbandplan ist dieser Bereich für Digimode-Betriebsarten ausgewiesen und sollte von CW-Stationen nicht benutzt werden.', ' ');
INSERT INTO answer VALUES (6064, 1516, 3, 'Weil dieser Bereich im Ausland auch für Rundfunkstationen ausgewiesen ist und daher nachts und im Winter durch den Amateurfunkdienst nicht genutzt werden darf.', ' ');
INSERT INTO answer VALUES (6065, 1517, 0, 'Im IARU-Region-1-Kurzwellenbandplan ist dieser Bereich als "Fonie-DX" ausgewiesen und sollte für DX-Verbindungen freigehalten werden.', ' ');
INSERT INTO answer VALUES (6066, 1517, 1, 'Gemäß Frequenzbereichszuweisungsplan ist dieser Bereich auch kommerziellen Stationen zugewiesen und muss nachts und im Winter freigehalten werden.', ' ');
INSERT INTO answer VALUES (6067, 1517, 2, 'Im IARU-Region-1-Kurzwellenbandplan ist dieser Bereich für Digimode-Betriebsarten ausgewiesen und sollte von SSB-Stationen nicht benutzt werden.', ' ');
INSERT INTO answer VALUES (6068, 1517, 3, 'Weil dieser Bereich im Ausland auch für Rundfunkstationen ausgewiesen ist und daher nachts und im Winter durch den Amateurfunkdienst nicht genutzt werden darf.', ' ');
INSERT INTO answer VALUES (6069, 1518, 0, '28000-28070 kHz und 7000-7035 kHz', ' ');
INSERT INTO answer VALUES (6070, 1518, 1, '28000-28100 kHz und 7000-7050 kHz', ' ');
INSERT INTO answer VALUES (6071, 1518, 2, '28000-28200 kHz und 7000-7070 kHz', ' ');
INSERT INTO answer VALUES (6072, 1518, 3, '28000-28300 kHz und 7000-7080 kHz', ' ');
INSERT INTO answer VALUES (6073, 1519, 0, '21000-21070 kHz, 14000-14070 kHz und 3500-3580 kHz', ' ');
INSERT INTO answer VALUES (6074, 1519, 1, '21000-21050 kHz, 14000-14080 kHz und 3500-3560 kHz', ' ');
INSERT INTO answer VALUES (6075, 1519, 2, '21000-21200 kHz, 14000-14100 kHz und 3500-3600 kHz', ' ');
INSERT INTO answer VALUES (6076, 1519, 3, '21000-21100 kHz, 14000-14050 kHz und 3500-3620 kHz', ' ');
INSERT INTO answer VALUES (6077, 1520, 0, 'Im 2-m-Band auf 145,800-146,000 MHz, im 70-cm-Band auf 435,000-438,000 MHz', ' ');
INSERT INTO answer VALUES (6078, 1520, 1, 'Im 2-m-Band auf 145,300-146,500 MHz, im 70-cm-Band auf 438,000-440,000 MHz', ' ');
INSERT INTO answer VALUES (6079, 1520, 2, 'Im 2-m-Band auf 144,800-145,000 MHz, im 70-cm-Band auf 435,000-438,000 MHz', ' ');
INSERT INTO answer VALUES (6080, 1520, 3, 'Im 2-m-Band auf 145,800-146,000 MHz, im 70-cm-Band auf 433,000-435,000 MHz', ' ');
INSERT INTO answer VALUES (6081, 1521, 0, '144,400 bis 144,490 MHz', ' ');
INSERT INTO answer VALUES (6082, 1521, 1, '145,400 bis 145,490 MHz', ' ');
INSERT INTO answer VALUES (6083, 1521, 2, '144,300 bis 144,400 MHz', ' ');
INSERT INTO answer VALUES (6084, 1521, 3, '145,300 bis 145,400 MHz', ' ');
INSERT INTO answer VALUES (6085, 1522, 0, 'Jeweils ±1 kHz um die Frequenzen 14100 kHz, 18110 kHz, 21150 kHz und 24930 kHz sowie der Frequenzbereich 28190 - 28225 kHz.', ' ');
INSERT INTO answer VALUES (6086, 1522, 1, 'Jeweils ±1 kHz um die Frequenzen 1850 kHz, 3579 kHz, 7050 kHz, 10050 kHz und 18150 kHz.', ' ');
INSERT INTO answer VALUES (6087, 1522, 2, 'Jeweils ±1 kHz um die Frequenzen 144,100 MHz, 430,100 MHz und 1240,100 MHz sowie die Frequenzbereiche 2320 - 2322 MHz 3400 - 3402 MHz.', ' ');
INSERT INTO answer VALUES (6088, 1522, 3, 'Jeweils ±1 kHz um die Frequenzen 24900 kHz, 28500 kHz, 29300 kHz, 29400 kHz und 29500 kHz.', ' ');
INSERT INTO answer VALUES (6089, 1523, 0, 'Die deutsche Amateurfunkstelle wird an Bord eines Wasserfahrzeugs betrieben, das sich auf See befindet.', ' ');
INSERT INTO answer VALUES (6090, 1523, 1, 'Die deutsche Amateurfunkstelle darf aufgrund einer Sonderzulassung in deutschen Hoheitsgewässern in "maritim mobiler" Weise tragbar betrieben werden.', ' ');
INSERT INTO answer VALUES (6091, 1523, 2, 'Der Funkamateur DO9RST, der an sein Rufzeichen "MM" anhängt, bringt damit zum Ausdruck, dass er mit anderen Funkamateuren in Kontakt treten möchte, die ihre Funkstelle zur Zeit auch "maritim mobil" betreiben.', ' ');
INSERT INTO answer VALUES (6092, 1523, 3, 'Die deutsche Amateurfunkstelle DO9RST befindet sich auf einem Landfahrzeug oder auf einem Schiff, das gemäß Schiffssicherheitsverordnung funkausrüstungspflichtig ist.', ' ');
INSERT INTO answer VALUES (6093, 1524, 0, 'Es handelt sich um eine Amateurfunkstelle, die für besondere experimentelle und technisch-wissenschaftliche Studien betrieben wird.', ' ');
INSERT INTO answer VALUES (6094, 1524, 1, 'Es handelt sich um eine Versuchsfunkstelle, die zur Erprobung technischer oder wissenschaftlicher Entwicklungen betrieben wird.', ' ');
INSERT INTO answer VALUES (6095, 1524, 2, 'Es handelt sich um ein Klasse-A-Klubstationsrufzeichen von Funkamateuren, die Angehörige der Gaststreitkräfte in Deutschland sind.', ' ');
INSERT INTO answer VALUES (6096, 1524, 3, 'Es handelt sich um eine Kurzzeitzuteilung für einen ausländischen Funkamateur, der eine Amateurfunkprüfungsbescheinigung, aber kein individuelles Rufzeichen hat.', ' ');
INSERT INTO answer VALUES (6097, 1525, 0, 'Es handelt sich um eine Zuteilung für eine Kurzzeitklubstation.', ' ');
INSERT INTO answer VALUES (6098, 1525, 1, 'Es handelt sich um eine Zuteilung für besondere technisch-wissenschaftliche Studien der Zuteilungsklasse A.', ' ');
INSERT INTO answer VALUES (6099, 1525, 2, 'Es handelt sich um eine Zuteilung für Gaststreitkräfte.', ' ');
INSERT INTO answer VALUES (6100, 1525, 3, 'Es handelt sich um die Zuteilung eines Ausbildungsrufzeichens für Gaststreitkräfte.', ' ');
INSERT INTO answer VALUES (6101, 1526, 0, 'Es handelt sich um eine exterritoriale deutsche Funkstelle des Amateurfunkdienstes oder des Amateurfunkdienstes über Satelliten.', ' ');
INSERT INTO answer VALUES (6102, 1526, 1, 'Es handelt sich um eine Amateurfunkstelle der Klasse A oder E, die ohne Anzeige nach BEMFV betrieben werden darf.', ' ');
INSERT INTO answer VALUES (6103, 1526, 2, 'Es handelt sich um ein Klubstationsrufzeichen von Funkamateuren, die Angehörige der Gaststreitkräfte in Deutschland sind.', ' ');
INSERT INTO answer VALUES (6104, 1526, 3, 'Es handelt sich um ein Ausbildungsrufzeichen der Klasse A für Angehörige der Gaststreitkräfte in Deutschland.', ' ');
INSERT INTO answer VALUES (6105, 1527, 0, 'Es handelt sich um eine deutsche Amateurfunkstelle, die an einem Ort mit exterritorialem Status betrieben wird.', ' ');
INSERT INTO answer VALUES (6106, 1527, 1, 'Es handelt sich um eine Amateurfunkstelle der Klasse A oder E, die ohne Anzeige nach BEMFV betrieben werden darf.', ' ');
INSERT INTO answer VALUES (6107, 1527, 2, 'Es handelt sich um eine Kurzzeitzuteilung für einen ausländischen Funkamateur, der eine Amateurfunkprüfungsbescheinigung, aber kein individuelles Rufzeichen hat.', ' ');
INSERT INTO answer VALUES (6108, 1527, 3, 'Es handelt sich um ein Ausbildungsrufzeichen der Klasse A für Angehörige der Gaststreitkräfte in Deutschland.', ' ');
INSERT INTO answer VALUES (6109, 1528, 0, '"/p" bedeutet, dass es sich um eine tragbare oder vorübergehend ortsfest betriebene Amateurfunkstelle handelt, und "/m" bedeutet, dass es sich um eine bewegliche Amateurfunkstelle in einem Landfahrzeug oder an Bord eines Wasserfahrzeugs auf Binnengewässern handelt.', ' ');
INSERT INTO answer VALUES (6110, 1528, 1, '"/p" bedeutet, dass es sich um eine tragbare Amateurfunkstelle handelt, und "/m" bedeutet, dass die Amateurfunkstelle vorübergehend ortsfest betrieben wird.', ' ');
INSERT INTO answer VALUES (6111, 1528, 2, '"/p" bedeutet, dass die Amateurfunkstelle tragbar oder vorübergehend ortsfest an einem Ort mit exterritorialem Status betrieben wird, und "/m" bedeutet, dass die Amateurfunkstelle an Bord eines Wasserfahrzeuges betrieben wird, das sich auf See auf Binnengewässern befindet.', ' ');
INSERT INTO answer VALUES (6112, 1528, 3, '"/p" bedeutet, dass die Amateurfunkstelle vorübergehend ortsfest im benachbarten Ausland betrieben wird, und "/m" bedeutet, dass die Amateurfunkstelle an Bord eines Wasserfahrzeugs betrieben wird, das sich auf See oder in einem Landfahrzeug befindet.', ' ');
INSERT INTO answer VALUES (6113, 1529, 0, 'Dem Heimatrufzeichen wird DL/ vorangestellt.', ' ');
INSERT INTO answer VALUES (6114, 1529, 1, 'Dem Heimatrufzeichen wird /DL angehängt.', ' ');
INSERT INTO answer VALUES (6115, 1529, 2, 'Dem Heimatrufzeichen wird DO/ vorangestellt.', ' ');
INSERT INTO answer VALUES (6116, 1529, 3, 'Dem Heimatrufzeichen wird /DO angehängt.', ' ');
INSERT INTO answer VALUES (6117, 1530, 0, 'Dem Heimatrufzeichen wird DO/ vorangestellt.', ' ');
INSERT INTO answer VALUES (6118, 1530, 1, 'Dem Heimatrufzeichen wird /DO angehängt.', ' ');
INSERT INTO answer VALUES (6119, 1530, 2, 'Dem Heimatrufzeichen wird DL/ vorangestellt.', ' ');
INSERT INTO answer VALUES (6120, 1530, 3, 'Dem Heimatrufzeichen wird /DL angehängt.', ' ');
INSERT INTO answer VALUES (6121, 1531, 0, 'Nein, er kann aber zur weiteren Information verwendet werden.', ' ');
INSERT INTO answer VALUES (6122, 1531, 1, 'Ja, weil für die Überwachungsbehörde erkennbar sein muss, dass die Amateurfunkstelle an einem anderen, als dem gemeldeten Standort betrieben wird.', ' ');
INSERT INTO answer VALUES (6123, 1531, 2, 'Ja, weil dies durch die internationalen Regelungen in der VO Funk so vorgegeben ist.', ' ');
INSERT INTO answer VALUES (6124, 1531, 3, 'Nein, den Zusatz müssen in Deutschland nur ausländische Stationen führen.', ' ');
INSERT INTO answer VALUES (6125, 1532, 0, 'Die Amateurfunkstelle wird an Bord eines Luftfahrzeuges betrieben.', ' ');
INSERT INTO answer VALUES (6126, 1532, 1, 'Die Amateurfunkstelle verwendet als Betriebsart Amplitudenmodulation.', ' ');
INSERT INTO answer VALUES (6127, 1532, 2, 'Die Amateurfunkstelle wird an Bord eines Wasserfahrzeuges betrieben.', ' ');
INSERT INTO answer VALUES (6128, 1532, 3, 'Die Amateurfunkstelle arbeitet mit geringer Leistung.', ' ');
INSERT INTO answer VALUES (6129, 1533, 0, 'dass es sich um eine bewegliche Amateurfunkstelle in einem Landfahrzeug handelt.', ' ');
INSERT INTO answer VALUES (6130, 1533, 1, 'dass die Amateurfunkstelle als Leitstation bei einem Peilwettbewerb fungiert.', ' ');
INSERT INTO answer VALUES (6131, 1533, 2, 'dass bei der Amateurfunkstelle eine Mailbox angeschlossen ist.', ' ');
INSERT INTO answer VALUES (6132, 1533, 3, 'dass es sich um eine vorübergehend ortsfest betriebene Amateurfunkstelle in einem Landfahrzeug handelt.', ' ');
INSERT INTO answer VALUES (6133, 1534, 0, 'Ausbildungsrufzeichen', ' ');
INSERT INTO answer VALUES (6134, 1534, 1, 'Klubstationsrufzeichen', ' ');
INSERT INTO answer VALUES (6135, 1534, 2, 'Personengebundene Rufzeichen', ' ');
INSERT INTO answer VALUES (6136, 1534, 3, 'Rufzeichen für automatisch arbeitende Stationen', ' ');
INSERT INTO answer VALUES (6137, 1535, 0, 'Klubstationsrufzeichen der Klasse A.', ' ');
INSERT INTO answer VALUES (6138, 1535, 1, 'Ausbildungsrufzeichen der Klasse E.', ' ');
INSERT INTO answer VALUES (6139, 1535, 2, 'Personengebundene Rufzeichen der Klasse A.', ' ');
INSERT INTO answer VALUES (6140, 1535, 3, 'Rufzeichen für automatisch arbeitende Stationen der Klasse E.', ' ');
INSERT INTO answer VALUES (6141, 1536, 0, 'Personengebundene Rufzeichen der Klasse E', ' ');
INSERT INTO answer VALUES (6142, 1536, 1, 'Personengebundene Rufzeichen der Klasse A', ' ');
INSERT INTO answer VALUES (6143, 1536, 2, 'Ausbildungsrufzeichen der Klasse A', ' ');
INSERT INTO answer VALUES (6144, 1536, 3, 'Ausbildungsrufzeichen der Klasse E', ' ');
INSERT INTO answer VALUES (6145, 1537, 0, 'zwei Buchstaben als Präfix, einer Ziffer und 1-3 Buchstaben als Suffix.', ' ');
INSERT INTO answer VALUES (6146, 1537, 1, 'zwei Buchstaben als Präfix, zwei Ziffer und zwei Buchstaben als Suffix.', ' ');
INSERT INTO answer VALUES (6147, 1537, 2, 'einem Buchstaben als Präfix, einer Ziffer und zwei bis drei Buchstaben als Suffix.', ' ');
INSERT INTO answer VALUES (6148, 1537, 3, 'zwei Buchstaben oder Ziffern und zwei bis drei Buchstaben als Suffix.', ' ');
INSERT INTO answer VALUES (6149, 1538, 0, 'In der Landeskennerliste der ITU, Amateurfunkhandbüchern und Rufzeichenlisten', ' ');
INSERT INTO answer VALUES (6150, 1538, 1, 'In der Rufzeichenliste der Bundesnetzagentur für Elektrizität, Gas, Telekommunikation, Post und Eisenbahnen', ' ');
INSERT INTO answer VALUES (6151, 1538, 2, 'In den Empfehlungen der IARU', ' ');
INSERT INTO answer VALUES (6152, 1538, 3, 'Im Frequenzbereichszuweisungsplan der Bundesrepublik Deutschland', ' ');
INSERT INTO answer VALUES (6153, 1539, 0, 'F, HB, OZ, SP', ' ');
INSERT INTO answer VALUES (6154, 1539, 1, 'EA, GM, OE, ON', ' ');
INSERT INTO answer VALUES (6155, 1539, 2, 'SM, LA, LZ, HB', ' ');
INSERT INTO answer VALUES (6156, 1539, 3, 'CT, I, LX, OK', ' ');
INSERT INTO answer VALUES (6157, 1540, 0, 'YO, LZ, EA, LA, SP', ' ');
INSERT INTO answer VALUES (6158, 1540, 1, 'YO, LZ, SP, LA, PO', ' ');
INSERT INTO answer VALUES (6159, 1540, 2, 'YO, BL, EA, LA, SP', ' ');
INSERT INTO answer VALUES (6160, 1540, 3, 'RO, LA, SP, LZ, SP', ' ');
INSERT INTO answer VALUES (6161, 1541, 0, 'Österreich, Niederlande, Liechtenstein, Lettland, Luxemburg.', ' ');
INSERT INTO answer VALUES (6162, 1541, 1, 'Österreich, Niederlande, Schweiz, Lettland, Luxemburg.', ' ');
INSERT INTO answer VALUES (6163, 1541, 2, 'Österreich, Polen, Liechtenstein, Lettland, Luxemburg.', ' ');
INSERT INTO answer VALUES (6164, 1541, 3, 'Österreich, Niederlande, Liechtenstein, Luxemburg, Lettland.', ' ');
INSERT INTO answer VALUES (6165, 1542, 0, 'Monaco, Vereinte Nationen, Kroatien, Malta.', ' ');
INSERT INTO answer VALUES (6166, 1542, 1, 'Monaco, Vereinte Nationen, Malta, Kroatien.', ' ');
INSERT INTO answer VALUES (6167, 1542, 2, 'Malta, Vereinte Nationen, Kroatien, Monaco.', ' ');
INSERT INTO answer VALUES (6168, 1542, 3, 'Monaco, Kroatien, Vereinte Nationen, Malta.', ' ');
INSERT INTO answer VALUES (6169, 1543, 0, 'Österreich, Finnland, Tschechien, Slowakei, Belgien, Dänemark.', ' ');
INSERT INTO answer VALUES (6170, 1543, 1, 'Österreich, Belgien, Tschechien, Slowakei, Finnland, Dänemark.', ' ');
INSERT INTO answer VALUES (6171, 1543, 2, 'Österreich, Finnland, Tschechien, Belgien, Slowakei, Dänemark.', ' ');
INSERT INTO answer VALUES (6172, 1543, 3, 'Österreich, Slowakei, Tschechien, Finnland, Belgien, Dänemark.', ' ');
INSERT INTO answer VALUES (6173, 1544, 0, 'Norwegen, Litauen, Bulgarien, Lettland.', ' ');
INSERT INTO answer VALUES (6174, 1544, 1, 'Norwegen, Bulgarien, Litauen, Lettland.', ' ');
INSERT INTO answer VALUES (6175, 1544, 2, 'Litauen, Norwegen, Bulgarien, Lettland.', ' ');
INSERT INTO answer VALUES (6176, 1544, 3, 'Norwegen, Litauen, Lettland, Bulgarien.', ' ');
INSERT INTO answer VALUES (6177, 1545, 0, 'Schweden, Slowenien, Polen, Griechenland.', ' ');
INSERT INTO answer VALUES (6178, 1545, 1, 'Schweden, Slowakei, Polen, Griechenland.', ' ');
INSERT INTO answer VALUES (6179, 1545, 2, 'Slowenien, Griechenland, Polen, Schweden.', ' ');
INSERT INTO answer VALUES (6180, 1545, 3, 'Schweden, Slowenien, Griechenland, Polen.', ' ');
INSERT INTO answer VALUES (6181, 1546, 0, 'Spanien, Irland, Ukraine, Estland.', ' ');
INSERT INTO answer VALUES (6182, 1546, 1, 'Spanien, Ukraine, Irland, Estland.', ' ');
INSERT INTO answer VALUES (6183, 1546, 2, 'Spanien, Irland, Estland, Ukraine.', ' ');
INSERT INTO answer VALUES (6184, 1546, 3, 'Spanien, Ukraine, Estland, Irland.', ' ');
INSERT INTO answer VALUES (6185, 1547, 0, 'CT, HB9, EA, ON, SP, EI', ' ');
INSERT INTO answer VALUES (6186, 1547, 1, 'PO, HB9, EB, OY, SP, IR', ' ');
INSERT INTO answer VALUES (6187, 1547, 2, 'CU, HB0, EA, BE, SP, EI', ' ');
INSERT INTO answer VALUES (6188, 1547, 3, 'CT, CH, EA, ON, PL, EI', ' ');
INSERT INTO answer VALUES (6189, 1548, 0, 'Deutschland (DA-DR), Südkorea (DS-DT) und Philippinen (DU-DZ).', ' ');
INSERT INTO answer VALUES (6190, 1548, 1, 'Ausschließlich Deutschland (DA-DZ)', ' ');
INSERT INTO answer VALUES (6191, 1548, 2, 'Deutschland (DA-DT) und Philippinen (DU-DZ)', ' ');
INSERT INTO answer VALUES (6192, 1548, 3, 'Deutschland (DA-DO), Taiwan (DP-DT) und Philippinen (DU-DZ)', ' ');
INSERT INTO answer VALUES (6193, 1549, 0, 'W, YK, ZS, ZL, LU, CE', ' ');
INSERT INTO answer VALUES (6194, 1549, 1, 'K, YL, ZL, ZS, LU, CE', ' ');
INSERT INTO answer VALUES (6195, 1549, 2, 'N, YK, ZL, ZS, AR, CE', ' ');
INSERT INTO answer VALUES (6196, 1549, 3, 'W, YK, ZS, ZL, AR, CE', ' ');
INSERT INTO answer VALUES (6197, 1550, 0, 'BY, JA, VE, VK, XE, K', ' ');
INSERT INTO answer VALUES (6198, 1550, 1, 'BY, JA, VK, VE, MX, W', ' ');
INSERT INTO answer VALUES (6199, 1550, 2, 'CE, JA, VE, VK, XE, W', ' ');
INSERT INTO answer VALUES (6200, 1550, 3, 'CE, JA, VE, VK, MX, N', ' ');
INSERT INTO answer VALUES (6201, 1551, 0, 'CE, PY, LU, OA, YV', ' ');
INSERT INTO answer VALUES (6202, 1551, 1, 'HV, EA, EP, ZS, 4S', ' ');
INSERT INTO answer VALUES (6203, 1551, 2, 'OH, OA, OZ, SM, UA', ' ');
INSERT INTO answer VALUES (6204, 1551, 3, 'G, F, K, W, JA, SP', ' ');
INSERT INTO answer VALUES (6205, 1552, 0, 'SU, 3V, ZS, 9X, 5H', ' ');
INSERT INTO answer VALUES (6206, 1552, 1, 'EL, LU, VK, VU, ZL', ' ');
INSERT INTO answer VALUES (6207, 1552, 2, 'ZS, ZL, PY, 3V, 5B', ' ');
INSERT INTO answer VALUES (6208, 1552, 3, 'ST, VU, XE, OK, 4N', ' ');
INSERT INTO answer VALUES (6209, 1553, 0, 'PY, HC, HK, OA, YV', ' ');
INSERT INTO answer VALUES (6210, 1553, 1, 'LU, VE, HB, OK, YU', ' ');
INSERT INTO answer VALUES (6211, 1553, 2, 'OA, JA, JT, 4X, SM', ' ');
INSERT INTO answer VALUES (6212, 1553, 3, 'YV, YU, BY, BV, VE', ' ');
INSERT INTO answer VALUES (6213, 1554, 0, 'Es handelt sich um eine Amateurfunkstelle mit einem kanadischen Rufzeichen, die in einem Luftfahrzeug betrieben wird.', ' ');
INSERT INTO answer VALUES (6214, 1554, 1, 'Es handelt sich um eine kanadische Amateurfunkstelle, die vorübergehend in den Vereinigten Staaten von Amerika betrieben wird.', ' ');
INSERT INTO answer VALUES (6215, 1554, 2, 'Es handelt sich um eine kanadische Amateurfunkstelle, die in der Betriebsart Amplitudenmodulation betrieben wird.', ' ');
INSERT INTO answer VALUES (6216, 1554, 3, 'Es handelt sich um eine automatisch arbeitende Pactor-Amateurfunkstelle mit angeschlossener Mailbox in Kanada.', ' ');
INSERT INTO answer VALUES (6217, 1555, 0, 'Kanada, Australien, Brasilien, Japan, USA.', ' ');
INSERT INTO answer VALUES (6218, 1555, 1, 'Kanada, Brasilien, Australien, Japan, USA.', ' ');
INSERT INTO answer VALUES (6219, 1555, 2, 'USA, Australien, Brasilien, Japan, Kanada.', ' ');
INSERT INTO answer VALUES (6220, 1555, 3, 'Kanada, Australien, Japan, Brasilien, USA.', ' ');
INSERT INTO answer VALUES (6221, 1556, 0, 'K2ABC, W3DEF, N4GHI, AB5JKL, KA7MNO, WB7PQR', ' ');
INSERT INTO answer VALUES (6222, 1556, 1, 'W3DEF, N4GHI, VE5JKL, KA7MNO, WB7PQR, K2ABC', ' ');
INSERT INTO answer VALUES (6223, 1556, 2, 'N4GHI, AB5JKL, KA7MNO, WB7PQR, US2ABC, W3DEF', ' ');
INSERT INTO answer VALUES (6224, 1556, 3, 'AB5JKL, KA7MNO, WB7PQR, K2ABC, UA3DEF, N4GHI', ' ');
INSERT INTO answer VALUES (6225, 1557, 0, 'Ich nenne das Rufzeichen der rufenden Station einmal, anschließend sage ich einmal: "Hier ist {eigenes Rufzeichen buchstabieren}, bitte kommen".', ' ');
INSERT INTO answer VALUES (6226, 1557, 1, 'Ich nenne das Rufzeichen der rufenden Station mindestens fünfmal und anschließend sage ich mindestens einmal "Hier ist {eigenes Rufzeichen}".', ' ');
INSERT INTO answer VALUES (6227, 1557, 2, 'Ich rufe ebenfalls CQ und nenne das Rufzeichen der rufenden Station mindestens dreimal, anschließend sage ich mindestens fünfmal "Hier ist {eigenes Rufzeichen buchstabieren}".', ' ');
INSERT INTO answer VALUES (6228, 1557, 3, 'Ich nenne mein Rufzeichen und fordere die rufende Station auf, auf einer anderen Frequenz weiter zu rufen {mindestens zweimal}.', ' ');
INSERT INTO answer VALUES (6229, 1558, 0, 'Verschlüsselte Nachrichten sind nicht gestattet. Der Funkverkehr muss in offener Sprache abgewickelt werden.', ' ');
INSERT INTO answer VALUES (6230, 1558, 1, 'In allen Sprachen', ' ');
INSERT INTO answer VALUES (6231, 1558, 2, 'Nur in Deutsch', ' ');
INSERT INTO answer VALUES (6232, 1558, 3, 'Nur in den europäischen Sprachen', ' ');
INSERT INTO answer VALUES (6233, 1559, 0, 'Durch Benutzen der internationalen Betriebsabkürzung "CQ", bzw. mit einem allgemeinen Anruf; mit einem gezielten Anruf an eine bestimmte Station oder mit einer Antwort auf einen allgemeinen Anruf, jeweils mit Nennung des eigenen Rufzeichens.', ' ');
INSERT INTO answer VALUES (6234, 1559, 1, 'Durch wiederholtes Aussenden der internationalen Q-Gruppe "QRZ?" mit angehängtem eigenen Rufzeichen und dem Abhören der Frequenz in den Sendepausen. Durch einen gezielten Anruf an eine bestimmte Station oder mit einer Antwort auf einen an die eigene Station gerichteten Anruf.', ' ');
INSERT INTO answer VALUES (6235, 1559, 2, 'Durch mehrmaliges, bei schlechten Ausbreitungsbedingungen häufiges Aussenden der Abkürzung "CQ", des eigenen Rufzeichens und der Q-Gruppe "QTH" mit Zwischenhören.', ' ');
INSERT INTO answer VALUES (6236, 1559, 3, 'Durch das Aussenden Ihres Rufzeichens und des in der IARU festgelegten Auftast-Tones von 1750 Hz, durch den die abhörenden Stationen Ihren Verbindungswunsch erkennen.', ' ');
INSERT INTO answer VALUES (6237, 1560, 0, 'Ja. Es ist allerdings die Regel, zunächst nur in der gleichen Betriebsart zu antworten, in der der Anruf der anderen Station erfolgte.', ' ');
INSERT INTO answer VALUES (6238, 1560, 1, 'Nein. Es ist eine nationale Regel, zunächst in der gleichen Betriebsart zu antworten, in der der Anruf der anderen Station erfolgte.', ' ');
INSERT INTO answer VALUES (6239, 1560, 2, 'Ja, weil die Betriebsfrequenz in einem Frequenzbereich liegt, in dem auch die Betriebsart Telefonie benutzt werden darf, und weil DC8WV mit dem angehängten "k" zum Ausdruck bringt, dass er für die Betriebsart bei der Antwort keine Beschränkung festlegt.', ' ');
INSERT INTO answer VALUES (6240, 1560, 3, 'Ja, da oberhalb 3700 kHz keine Morsetelegrafie angewendet werden darf, und ich DC8WV in Telefonie darauf aufmerksam machen sollte.', ' ');
INSERT INTO answer VALUES (6241, 1561, 0, 'Nein, weil QRZ nach VO Funk nicht die Bedeutung von CQ hat.', ' ');
INSERT INTO answer VALUES (6242, 1561, 1, 'Ja, weil QRZ? bedeutet: Wer möchte angerufen werden?', ' ');
INSERT INTO answer VALUES (6243, 1561, 2, 'Ja, weil QRZ nach VO Funk die gleiche Bedeutung wie CQ hat.', ' ');
INSERT INTO answer VALUES (6244, 1561, 3, 'Nein, weil QRZ nur für einen gezielten Anruf benutzt wird.', ' ');
INSERT INTO answer VALUES (6245, 1562, 0, 'CQ Australia this is DL7RBI calling (etwa 3mal wiederholen) and DL7RBI is listening (internationales Buchstabieralphabet beim Rufzeichen benutzen).', ' ');
INSERT INTO answer VALUES (6246, 1562, 1, 'CQ Australien hier ist DL7RBI (etwa 3mal wiederholen) and DL7RBI is listed (internationales Buchstabieralphabet beim Rufzeichen benutzen).', ' ');
INSERT INTO answer VALUES (6247, 1562, 2, 'Australia, Australia, Australia (etwa 3mal wiederholen) here is DL7RBI listening (internationales Buchstabieralphabet beim Rufzeichen benutzen).', ' ');
INSERT INTO answer VALUES (6248, 1562, 3, 'CQ this is DL7RBI Australia calling (etwa 3mal wiederholen) and DL7RBI is listening to Australia (internationales Buchstabieralphabet beim Rufzeichen benutzen).', ' ');
INSERT INTO answer VALUES (6249, 1563, 0, 'DH8DAP/p nimmt an einem Fieldday-Kontest teil und sucht vornehmlich Verbindungen mit Stationen, die sich ebenfalls an diesem Kontest beteiligen.', ' ');
INSERT INTO answer VALUES (6250, 1563, 1, 'DH8DAP/p sucht Verbindungen mit Stationen aus französischen Überseegebieten (French Departements).', ' ');
INSERT INTO answer VALUES (6251, 1563, 2, 'DH8DAP/p sucht Verbindungen mit Stationen aus dem Autokennzeichenbezirk Fulda.', ' ');
INSERT INTO answer VALUES (6252, 1563, 3, 'DH8DAP/p sucht Verbindungen mit Stationen aus französischen Überseegebieten (French Departements), die für den Portabel-Kontest gewertet werden können.', ' ');
INSERT INTO answer VALUES (6253, 1564, 0, 'KA2WEU sucht eine Verbindung mit einem Funkamateur aus Deutschland.', ' ');
INSERT INTO answer VALUES (6254, 1564, 1, 'Der amerikanische Funkamateur KA2WEU sucht Verbindungen mit Funkamateuren, die weit entfernt sind.', ' ');
INSERT INTO answer VALUES (6255, 1564, 2, 'KA2WEU sucht nur Verbindungen mit deutschen Funkamateuren deren Rufzeichenpräfix DL ist.', ' ');
INSERT INTO answer VALUES (6256, 1564, 3, 'KA2WEU sucht eine Verbindung mit Stationen, die an einem deutschen Wettbewerb teilnehmen.', ' ');
INSERT INTO answer VALUES (6257, 1565, 0, 'Ich antworte: "Hier ist DH7RW, wurde ich gerufen?"', ' ');
INSERT INTO answer VALUES (6258, 1565, 1, 'Ich frage: "Wer hat mich gerufen?"', ' ');
INSERT INTO answer VALUES (6259, 1565, 2, 'Ich frage erneut: "QRZ?"', ' ');
INSERT INTO answer VALUES (6260, 1565, 3, 'Ich antworte: "QRZ, wurde ich gerufen?"', ' ');
INSERT INTO answer VALUES (6261, 1566, 0, 'Nein! 4U1ITU sucht eine Verbindung mit Australien oder Neuseeland.', ' ');
INSERT INTO answer VALUES (6262, 1566, 1, 'Ja! 4U1ITU in Australien/Neuseeland sucht eine Verbindung.', ' ');
INSERT INTO answer VALUES (6263, 1566, 2, 'Ja! Aber nur wenn Sie geborener Australier oder Neuseeländer sind.', ' ');
INSERT INTO answer VALUES (6264, 1566, 3, 'Nein! 4U1ITU sucht nur Verbindungen mit Indien oder Südafrika.', ' ');
INSERT INTO answer VALUES (6265, 1567, 0, 'HB9AFN sucht eine Überseeverbindung und sollte durch europäische Funkamateure nicht angerufen werden.', ' ');
INSERT INTO answer VALUES (6266, 1567, 1, 'HB9AFN sucht eine Verbindung mit dem Ausland und sollte durch andere Funkamateure nicht angerufen werden.', ' ');
INSERT INTO answer VALUES (6267, 1567, 2, 'HB9AFN sucht eine Verbindung über 500 km und sollte durch Funkamateure aus einer geringeren Entfernung als 500 km nicht angerufen werden.', ' ');
INSERT INTO answer VALUES (6268, 1567, 3, 'HB9AFN sucht eine Verbindung mit Stationen von den Philippinen (Präfix "DX").', ' ');
INSERT INTO answer VALUES (6269, 1568, 0, 'Ich passe mich bei der Verkehrsabwicklung dem Gebetempo des Anfängers an.', ' ');
INSERT INTO answer VALUES (6270, 1568, 1, 'Ich führe nur eine kurze Verbindung um ihn nicht zu sehr zu belasten.', ' ');
INSERT INTO answer VALUES (6271, 1568, 2, 'Ich gebe alle Zeichen doppelt.', ' ');
INSERT INTO answer VALUES (6272, 1568, 3, 'Ich wiederhole alle Angaben dreimal mit langsamem Gebetempo.', ' ');
INSERT INTO answer VALUES (6273, 1569, 0, 'Nur bei Stationen, die erkennbar einige hundert Kilometer entfernt sind, ggf., wenn nach mehrmaligen erfolglosen Anrufen niemand antwortet.', ' ');
INSERT INTO answer VALUES (6274, 1569, 1, 'Nur wenn die Entfernung zwischen beiden Stationen höchstens 500 km beträgt und sonst niemand auf den Anruf antwortet.', ' ');
INSERT INTO answer VALUES (6275, 1569, 2, 'Nur wenn ich als hörende Station die rufende Station mit guter Lautstärke empfange.', ' ');
INSERT INTO answer VALUES (6276, 1569, 3, 'Nur wenn es sich bei der anrufenden Station um eine außereuropäische Station handelt oder wenn - nach mehrmaligen erfolglosen Anrufen - niemand antwortet.', ' ');
INSERT INTO answer VALUES (6277, 1570, 0, 'Nach entsprechender Verständigung mit der neuen Gegenstation nehme ich die neue Verbindung mit ihr auf einer anderen, freien Frequenz auf.', ' ');
INSERT INTO answer VALUES (6278, 1570, 1, 'Ich bleibe auf der Frequenz und tätige ein QSO mit der neu rufenden Station.', ' ');
INSERT INTO answer VALUES (6279, 1570, 2, 'Ich gehe etwa 1 kHz neben die bisherige Frequenz und rufe dort die anrufende Station.', ' ');
INSERT INTO answer VALUES (6280, 1570, 3, 'Ich reagiere nicht auf den Anruf, weil die Frequenz der Station gehört, die CQ gerufen hat.', ' ');
INSERT INTO answer VALUES (6281, 1571, 0, 'Ich beobachte die Frequenz und frage dann etwa zwei bis dreimal ob die Frequenz besetzt ist. Erfolgt keine Antwort, kann ich davon ausgehen, dass die Frequenz frei ist und dort CQ rufen.', ' ');
INSERT INTO answer VALUES (6282, 1571, 1, 'Ich warte und beobachte die Frequenz für einige Sekunden. Höre ich nichts, so kann ich mit meinem CQ-Ruf beginnen.', ' ');
INSERT INTO answer VALUES (6283, 1571, 2, 'Da ich auf der Frequenz kein Signal höre kann ich mit meinem CQ-Ruf beginnen.', ' ');
INSERT INTO answer VALUES (6284, 1571, 3, 'Ich stimme meinen Sender auf der Frequenz ab und starte dann meinen CQ-Ruf.', ' ');
INSERT INTO answer VALUES (6285, 1572, 0, 'Die auf dieser Frequenz sendende Station liegt innerhalb der toten Zone und konnte daher von mir nicht gehört werden.', ' ');
INSERT INTO answer VALUES (6286, 1572, 1, 'Die auf dieser Frequenz sendenden Stationen haben eine zu geringe Sendeleistung.', ' ');
INSERT INTO answer VALUES (6287, 1572, 2, 'Für die auf dieser Frequenz sendenden Stationen sind die Ausbreitungsbedingungen zu schlecht.', ' ');
INSERT INTO answer VALUES (6288, 1572, 3, 'Die auf dieser Frequenz sendende Station wurde durch den Mögel-Dellinger-Effekt kurzfristig unterbrochen.', ' ');
INSERT INTO answer VALUES (6289, 1573, 0, 'Ich arbeite nur in den Frequenzbereichen, die nach dem internationalen Kurzwellenbandplan und der jeweiligen Kontestauschreibung für diesen Wettbewerb vorgesehen sind.', ' ');
INSERT INTO answer VALUES (6290, 1573, 1, 'Ich nenne mein Rufzeichen nur in größeren Abständen, um die QSO-Anzahl hoch zu halten.', ' ');
INSERT INTO answer VALUES (6291, 1573, 2, 'Ich lese vorher die Ausschreibungsbedingungen in den Fachzeitschriften und notiere mir die geforderten Angaben.', ' ');
INSERT INTO answer VALUES (6292, 1573, 3, 'Ich überhole meine Antenneneinrichtungen, stimme die Endstufe sorgfältig ab und optimiere meine Logbuchtechnik.', ' ');
INSERT INTO answer VALUES (6293, 1574, 0, 'EA3JQ, this is DH8DAP calling you', ' ');
INSERT INTO answer VALUES (6294, 1574, 1, 'CQ CQ CQ de DH8DAP for EA3JQ, please go ahead', ' ');
INSERT INTO answer VALUES (6295, 1574, 2, 'EA3JQ, es ruft Sie DH8DAP, bitte kommen', ' ');
INSERT INTO answer VALUES (6296, 1574, 3, 'QRZ EA3JQ from DH8DAP, over', ' ');
INSERT INTO answer VALUES (6297, 1575, 0, 'mit der gleichen Geschwindigkeit des empfangenen Signals antworten.', ' ');
INSERT INTO answer VALUES (6298, 1575, 1, 'mit meiner gewohnten Geschwindigkeit antworten.', ' ');
INSERT INTO answer VALUES (6299, 1575, 2, 'mit einer solch hohen Geschwindigkeit antworten, wie ich sie auch aufnehmen könnte.', ' ');
INSERT INTO answer VALUES (6300, 1575, 3, 'die Geschwindigkeit der eingestellten automatischen Morsetaste nicht ändern, sondern immer mit dieser Geschwindigkeit antworten.', ' ');
INSERT INTO answer VALUES (6301, 1576, 0, 'eine Amateurfunkexpedition zu Ländern oder Inseln, die selten im Amateurfunk zu hören sind.', ' ');
INSERT INTO answer VALUES (6302, 1576, 1, 'eine weltweite Aktivitätswoche.', ' ');
INSERT INTO answer VALUES (6303, 1576, 2, 'ein internationaler Funkwettbewerb.', ' ');
INSERT INTO answer VALUES (6304, 1576, 3, 'eine Zusammenstellung aller noch von Funkamateuren begehrten Länder.', ' ');
INSERT INTO answer VALUES (6305, 1577, 0, 'Anrufen einer selten zu hörenden Station durch viele Amateurfunkstellen.', ' ');
INSERT INTO answer VALUES (6306, 1577, 1, 'Senden einer Station auf mehreren Amateurfunkfrequenzen in einem Kontest.', ' ');
INSERT INTO answer VALUES (6307, 1577, 2, 'Senden einer Station mit mehreren Antennen bei einem Kontest.', ' ');
INSERT INTO answer VALUES (6308, 1577, 3, 'Hören einer Station mit mehreren Empfängern bei einem Kontest.', ' ');
INSERT INTO answer VALUES (6309, 1578, 0, 'Eine gut hörbare andere Station nimmt anrufenden Stationen in eine Liste und ruft später diese Stationen zur Aufnahme einer Funkverbindung mit der seltenen Station auf.', ' ');
INSERT INTO answer VALUES (6310, 1578, 1, 'Eine gut hörbare andere Station schickt per Internet Listen anrufender Stationen an die seltene Station.', ' ');
INSERT INTO answer VALUES (6311, 1578, 2, 'Die seltene Station ruft Stationen nach einer Liste der Landeskenner alphabetisch auf.', ' ');
INSERT INTO answer VALUES (6312, 1578, 3, 'Die seltene Station oder ihr QSL-Manager veröffentlicht eine Liste der gearbeiteten Stationen in den Amateurfunkzeitschriften.', ' ');
INSERT INTO answer VALUES (6313, 1579, 0, 'Die seltene Station hört oberhalb ihrer Sendefrequenz in dem angegebenen Bereich.', ' ');
INSERT INTO answer VALUES (6314, 1579, 1, 'Die seltene Station kündigt einen Frequenzwechsel in den angegebenen Bereich an.', ' ');
INSERT INTO answer VALUES (6315, 1579, 2, 'Die seltene Station bitte anrufende Stationen in dem angegebenen Bereich CW zu verwenden.', ' ');
INSERT INTO answer VALUES (6316, 1579, 3, 'Die seltene Station nimmt in dem angegebenen Bereich eine Liste auf.', ' ');
INSERT INTO answer VALUES (6317, 1580, 0, 'Ich muss zwischen 14290 und 14300 kHz rufen.', ' ');
INSERT INTO answer VALUES (6318, 1580, 1, 'Ich sende auf 14205 kHz und höre auf 14290 kHz.', ' ');
INSERT INTO answer VALUES (6319, 1580, 2, 'Die Funkstelle stimmt auf 14290 kHz ab.', ' ');
INSERT INTO answer VALUES (6320, 1580, 3, 'Ich muss auf 14290 kHz oder darüber hören.', ' ');
INSERT INTO answer VALUES (6321, 1581, 0, 'Die rufende Station hört 5 kHz oberhalb ihrer eigenen Sendefrequenz. Ich muss also bei meinem Anruf 5 kHz höher senden.', ' ');
INSERT INTO answer VALUES (6322, 1581, 1, 'Die rufende Station hört 5 Minuten später auf ihrer eigenen Sendefrequenz. Ich muss also bei meinem Anruf 5 Minuten später senden und vorher prüfen, ob die Frequenz frei ist.', ' ');
INSERT INTO answer VALUES (6323, 1581, 2, 'Die rufende Station sendet 5 kHz oberhalb ihrer eigenen Sendefrequenz. Ich muss also bei meinem Anruf 5 kHz höher empfangen und vorher prüfen, ob die Frequenz frei ist.', ' ');
INSERT INTO answer VALUES (6324, 1581, 3, 'Die rufende Station behandelt meinen Anruf an 5ter Stelle. Ich muss also bei meinem Anruf 5 andere Funkverbindungen abwarten.', ' ');
INSERT INTO answer VALUES (6325, 1582, 0, 'Die Station möchte nur Anrufe von Stationen mit der Ziffer "3" im Rufzeichen und bittet, nur mit den Buchstaben des Suffixes zu rufen.', ' ');
INSERT INTO answer VALUES (6326, 1582, 1, 'Die Station möchte jeweils drei rufende Stationen in eine Liste aufnehmen.', ' ');
INSERT INTO answer VALUES (6327, 1582, 2, 'Die Station möchte nur Stationen mit dreistelligem Suffix aufrufen.', ' ');
INSERT INTO answer VALUES (6328, 1582, 3, 'Die Station möchte, dass anrufende Stationen dreimal nur ihr Suffix durchgeben.', ' ');
INSERT INTO answer VALUES (6329, 1583, 0, 'Senden und Empfangen erfolgt nicht wie sonst üblich auf der gleichen Frequenz, sondern auf verschiedenen Frequenzen des gleichen Amateurfunkbandes.', ' ');
INSERT INTO answer VALUES (6330, 1583, 1, 'Zwei Relaisfunkstellen, die sich im gleichen Versorgungsgebiet die gleiche Frequenz zeitlich teilen müssen.', ' ');
INSERT INTO answer VALUES (6331, 1583, 2, 'Wegen örtlicher Funkstörprobleme benutzen beide Funkamateure bei ihrer Funkverbindung unterschiedliche Betriebsarten, z. B. Morsen und Sprechfunk.', ' ');
INSERT INTO answer VALUES (6332, 1583, 3, 'Senden und Empfangen erfolgt in zwei unterschiedlichen Amateurfunkgeräten.', ' ');
INSERT INTO answer VALUES (6333, 1584, 0, 'Die Verbindung mit Australien ist wegen der Ausbreitungsbedingungen auf dem indirekten und somit längeren Weg über Südamerika hinweg zustande gekommen.', ' ');
INSERT INTO answer VALUES (6334, 1584, 1, 'Die Verbindung mit Australien ist wegen der Ausbreitungsbedingungen auf langem direktem Weg über Südamerika hinweg zustande gekommen.', ' ');
INSERT INTO answer VALUES (6335, 1584, 2, 'Die Verbindung mit Südamerika ist wegen der Ausbreitungsbedingungen auf dem indirekten und somit längeren Weg über Australien hinweg, zustande gekommen.', ' ');
INSERT INTO answer VALUES (6336, 1584, 3, 'Der Verbindungsweg mit Australien ist wegen der schlechten Ausbreitungsbedingungen erst nach langer Wartezeit zustande gekommen.', ' ');
INSERT INTO answer VALUES (6337, 1585, 0, 'Die Verbindung ist durch Reflexion von Ultrakurzwellen an polaren Nordlichtern zustande gekommen (Reflexion an polaren Ionisationserscheinungen).', ' ');
INSERT INTO answer VALUES (6338, 1585, 1, 'Die Verbindung ist durch Beugung von Ultrakurzwellen an Lichtquellen der Polarregion zustande gekommen (Beugung an ionisierten Polarschichten).', ' ');
INSERT INTO answer VALUES (6339, 1585, 2, 'Die Verbindung ist durch Verstärkung der polaren Nordlichter mittels Ultrakurzwellen zustande gekommen (Reflexion von ionisiertem Polarlicht).', ' ');
INSERT INTO answer VALUES (6340, 1585, 3, 'Die Verbindung ist durch Reflexion von verbrummten Ultrakurzwellen am Polarkreis zustande gekommen (Reflexion an Ionisationserscheinungen des Polarkreises).', ' ');
INSERT INTO answer VALUES (6341, 1586, 0, 'Stationen aus Entfernungen von 1000 bis 2000 km zu hören sind, die über Reflexionen an der sporadischen E-Schicht empfangen werden.', ' ');
INSERT INTO answer VALUES (6342, 1586, 1, 'außereuropäische Stationen zu hören sind, die über Reflexionen an der sporadischen E-Schicht empfangen werden.', ' ');
INSERT INTO answer VALUES (6343, 1586, 2, 'außereuropäische Stationen zu hören sind, die über Reflexion an Ionisationserscheinungen des Polarkreises empfangen werden.', ' ');
INSERT INTO answer VALUES (6344, 1586, 3, 'Stationen aus Entfernungen von 1000 bis 2000 km zu hören sind, die über Reflexion an Ionisationserscheinungen des Polarkreises empfangen werden.', ' ');
INSERT INTO answer VALUES (6345, 1587, 0, 'Die Verbindung kann durch Reflexion von Funkwellen an polaren Nordlichtern zustande gekommen sein, wenn die empfangenen Signale sehr rau (verrauscht und verbrummt) sind und die Antennenrichtung meist nicht mit der direkten Richtung zur Gegenstation übereinstimmt.', ' ');
INSERT INTO answer VALUES (6346, 1587, 1, 'Die Verbindung kann durch Beugung von Funkwellen an Lichtquellen der Polarregion zustande gekommen sein, wenn die empfangenen Signale stark sind und die Antennenrichtung mit der indirekten Richtung zur Gegenstation übereinstimmt.', ' ');
INSERT INTO answer VALUES (6347, 1587, 2, 'Die Verbindung kann durch Verstärkung am verbrummten Nordlicht mittels Ultrakurzwellen zustande gekommen sein und die Antennenrichtung nicht mit der der Gegenstation übereinstimmen.', ' ');
INSERT INTO answer VALUES (6348, 1587, 3, 'Die Verbindung kann durch Reflexion von verbrummten Ultrakurzwellen am Polarkreis zustande gekommen sein, wenn gute Ausbreitungsbedingungen bestehen und die Antenne nur indirekt mit der Gegenstation übereinstimmt.', ' ');
INSERT INTO answer VALUES (6349, 1588, 0, 'Aus der Stellung seiner Richtantenne erkennt er, dass diese der Richtung des kürzesten Weges nach Brasilien um 180° entgegengesetzt ist. Das heißt, er hat "PY" auf dem "langen Weg" gearbeitet.', ' ');
INSERT INTO answer VALUES (6350, 1588, 1, 'Durch die verhallte Tonlage der Verbindung erkennt er, dass diese in zwei Richtungen nach Brasilien stattgefunden hat. Das heißt, er hat "PY" nicht nur direkt sondern auf einem "längeren Weg" gearbeitet.', ' ');
INSERT INTO answer VALUES (6351, 1588, 2, 'Aus der Stellung seiner Richtantenne erkennt er, dass diese in Richtung des längeren Weges nach Brasilien eingesetzt ist. Das heißt, er hat "PY" auf dem "direkten Weg" gearbeitet.', ' ');
INSERT INTO answer VALUES (6352, 1588, 3, 'Durch die verhallte Tonlage der Verbindung nach Brasilien, Ausbreitung der Funkwellen über zwei entgegengesetzte Wege.', ' ');
INSERT INTO answer VALUES (6353, 1589, 0, 'Er ist eine international anerkannte Einteilung der Erdoberfläche nach Längen- und Breitengraden in Groß- und Kleinfelder, die mit Buchstaben und Zahlen bezeichnet wird.', ' ');
INSERT INTO answer VALUES (6354, 1589, 1, 'Es ist der Standort einer Amateurfunkstelle, so wie er der zuständigen Behörde mitgeteilt werden muss.', ' ');
INSERT INTO answer VALUES (6355, 1589, 2, 'Es ist die genaue Angabe der Standortdaten in Stunden, Minuten und Sekunden geographischer Länge und Breite.', ' ');
INSERT INTO answer VALUES (6356, 1589, 3, 'Es ist die genaue Geografie des Standorts einer Amateurfunkstelle in fein eingeteilten Koordinaten von Länge oder Breite der Funkstelle in Grad, Minuten und Sekunden.', ' ');
INSERT INTO answer VALUES (6357, 1590, 0, 'Es ist ein Funkpeilwettbewerb, wobei mit Hilfe von tragbaren Peilempfängern versteckte Kleinsender im KW- oder UKW-Bereich, die nur kurzzeitig senden, aufzufinden sind.', ' ');
INSERT INTO answer VALUES (6358, 1590, 1, 'Es ist ein Funkpeilwettbewerb, wobei versucht wird, in einer vorgegebenen Zeit von meistens 24 Stunden, auf einem Amateurfunkband mit möglichst vielen Ländern aus verschiedenen Richtungen Funkverbindungen herzustellen.', ' ');
INSERT INTO answer VALUES (6359, 1590, 2, 'Bei einer Fuchsjagd versuchen kleine Mannschaften von zwei oder drei Funkamateuren von verschiedenen Standorten aus durch Kreuzpeilungen versteckte Peilsender aufzufinden. Dabei übermitteln sich die Funkamateure die Peilergebnisse gegenseitig per Funk.', ' ');
INSERT INTO answer VALUES (6360, 1590, 3, 'Es ist ein Funkpeilwettbewerb, der von Funkamateuren ausschließlich für SWL (short wave listener) veranstaltet wird. Da diese Höramateure noch keine eigenen Sender betreiben dürfen, ist die Aufgabe, so schnell wie möglich versteckte Kleinsender mit Hilfe von tragbaren Peilempfängern aufzufinden.', ' ');
INSERT INTO answer VALUES (6361, 1591, 0, 'Den Ehrenkodex der Funkamateure', ' ');
INSERT INTO answer VALUES (6362, 1591, 1, 'Eine Amateurfunkvereinigung', ' ');
INSERT INTO answer VALUES (6363, 1591, 2, 'Eine Klubzeitschrift der Funkamateure', ' ');
INSERT INTO answer VALUES (6364, 1591, 3, 'Ein bekanntes amerikanisches Amateurfunkdiplom', ' ');
INSERT INTO answer VALUES (6365, 1592, 0, 'CW, Pactor, PSK31.', ' ');
INSERT INTO answer VALUES (6366, 1592, 1, 'RTTY, SSB, CW.', ' ');
INSERT INTO answer VALUES (6367, 1592, 2, 'Pactor, RTTY, SSB.', ' ');
INSERT INTO answer VALUES (6368, 1592, 3, 'SSTV, PSK31, AM.', ' ');
INSERT INTO answer VALUES (6369, 1593, 0, 'CW, Digimodes', ' ');
INSERT INTO answer VALUES (6370, 1593, 1, 'RTTY, Hellschreiben', ' ');
INSERT INTO answer VALUES (6371, 1593, 2, 'ATV, SSTV', ' ');
INSERT INTO answer VALUES (6372, 1593, 3, 'FM, SSB', ' ');
INSERT INTO answer VALUES (6373, 1594, 0, 'Ich schreibe den Rapport direkt in das zu übertragende Bild.', ' ');
INSERT INTO answer VALUES (6374, 1594, 1, 'Ich teile ihm den Rapport später auf der QSL-Karte mit.', ' ');
INSERT INTO answer VALUES (6375, 1594, 2, 'Ich sende den Rapport nach der Bildübertragung in CW.', ' ');
INSERT INTO answer VALUES (6376, 1594, 3, 'Ich teile ihm den Rapport während der Bildübertragung in SSB mit.', ' ');
INSERT INTO answer VALUES (6377, 1595, 0, 'Eine Empfangsstation zeigt alle Nachrichten auf einer PR-Frequenz an.', ' ');
INSERT INTO answer VALUES (6378, 1595, 1, 'Die Bandwacht beobachtet den Datenaustausch auf einer PR-Frequenz.', ' ');
INSERT INTO answer VALUES (6379, 1595, 2, 'Die Bundesnetzagentur zeichnet den Datenaustausch auf einer PR-Frequenz auf.', ' ');
INSERT INTO answer VALUES (6380, 1595, 3, 'Eine Empfangsstation zeigt nur fehlerhafte Pakete von Nachrichten auf einer PR-Frequenz an.', ' ');
INSERT INTO answer VALUES (6381, 1596, 0, 'Eine Einrichtung, die es ermöglicht automatisch ein Zielrufzeichen zu erreichen.', ' ');
INSERT INTO answer VALUES (6382, 1596, 1, 'Automatische Streckenplanung vom Urlaubsort zum Heimat-Digipeater.', ' ');
INSERT INTO answer VALUES (6383, 1596, 2, 'Automatische Streckenführung einer mobilen PR-Station zum Digipeater.', ' ');
INSERT INTO answer VALUES (6384, 1596, 3, 'Automatische Rubrikzuweisung von in Mailboxen eingehenden Nachrichten.', ' ');
INSERT INTO answer VALUES (6385, 1597, 0, 'Automatisches Weiterleiten von Nachrichten an andere Mailboxen', ' ');
INSERT INTO answer VALUES (6386, 1597, 1, 'Das Übersenden von QSL-Karten', ' ');
INSERT INTO answer VALUES (6387, 1597, 2, 'Bevorzugtes Weiterleiten der eigenen Nachrichten', ' ');
INSERT INTO answer VALUES (6388, 1597, 3, 'Bevorzugtes Weiterleiten von Nachrichten in englischer Sprache', ' ');
INSERT INTO answer VALUES (6389, 1598, 0, 'Um die Frequenz möglichst ökonomisch zu nutzen', ' ');
INSERT INTO answer VALUES (6390, 1598, 1, 'TX-Delay dient zur Bevorzugung von Sendern mit kurzer Umschaltzeit', ' ');
INSERT INTO answer VALUES (6391, 1598, 2, 'Zur Verlängerung der Akku-Lebensdauer von batteriebetriebenen Geräten', ' ');
INSERT INTO answer VALUES (6392, 1598, 3, 'Um die Dauer eines QSO zu verkürzen', ' ');
INSERT INTO answer VALUES (6393, 1599, 0, 'Es ist ein automatisches Positionsmeldesystem.', ' ');
INSERT INTO answer VALUES (6394, 1599, 1, 'Es bedeutet eine automatische Adressierung bei Packet Radio.', ' ');
INSERT INTO answer VALUES (6395, 1599, 2, 'Es dient zur automatischen Verbindung mit dem Zielrufzeichen.', ' ');
INSERT INTO answer VALUES (6396, 1599, 3, 'Es dient zur automatischen Streckenführung einer mobilen PR-Station.', ' ');
INSERT INTO answer VALUES (6397, 1600, 0, 'Es sind fest eingerichtete Funkverbindungen zur Vernetzung von Relaisfunkstellen oder Digipeatern.', ' ');
INSERT INTO answer VALUES (6398, 1600, 1, 'Es sind Einrichtungen bei Relaisfunkstellen oder Digipeatern, die eine Verbindungsherstellung über das Telefonnetz erlauben.', ' ');
INSERT INTO answer VALUES (6399, 1600, 2, 'Es sind Verbindungen zwischen Netzwerken mit unterschiedlichen Protokollen, z.B. zwischen Packet-Radio-Netz und Pactor.', ' ');
INSERT INTO answer VALUES (6400, 1600, 3, 'Es sind Digipeater-Einstiege auf einem zweiten Empfangskanal.', ' ');
INSERT INTO answer VALUES (6401, 1601, 0, 'Senden bzw. Empfangen auf der gleichen Frequenz', ' ');
INSERT INTO answer VALUES (6402, 1601, 1, 'Senden bzw. Empfangen über kurze Entfernung', ' ');
INSERT INTO answer VALUES (6403, 1601, 2, 'Senden bzw. Empfangen mit unterschiedlichen Sende- und Empfangsfrequenzen', ' ');
INSERT INTO answer VALUES (6404, 1601, 3, 'Senden bzw. Empfangen mit minimaler Senderleistung', ' ');
INSERT INTO answer VALUES (6405, 1602, 0, 'empfängt auf der Eingabefrequenz und sendet auf einer Ausgabefrequenz.', ' ');
INSERT INTO answer VALUES (6406, 1602, 1, 'stellt bei starker Belegung der Eingabefrequenz eine zusätzliche Ausgabefrequenz zur Verfügung.', ' ');
INSERT INTO answer VALUES (6407, 1602, 2, 'benutzt eine Eingabefrequenz zur Umsetzung des empfangenen Signals; und die Ausgabefrequenz zur Fernsteuerung.', ' ');
INSERT INTO answer VALUES (6408, 1602, 3, 'muss auf der Ausgabefrequenz mit einem Tonruf geöffnet werden, bevor es auf der Eingabefrequenz in Betrieb gehen kann.', ' ');
INSERT INTO answer VALUES (6409, 1603, 0, 'Es wird nur die Lesbarkeit R beurteilt, weil sich die Signalstärke S auf die Relaisfunkstelle bezieht.', ' ');
INSERT INTO answer VALUES (6410, 1603, 1, 'Es werden die Lesbarkeit R und die Signalstärke S beurteilt, weil das zu einem vollständigen Rapport dazugehört.', ' ');
INSERT INTO answer VALUES (6411, 1603, 2, 'Es werden die Lesbarkeit R und die Signalstärke S vermindert um eine S-Stufe beurteilt, weil die Relaisfunkstelle meist eine höhere Leistung als die anderen Stationen haben.', ' ');
INSERT INTO answer VALUES (6412, 1603, 3, 'Es werden nur verbale Aussagen gemacht, da die exakte Einschätzung bei Betrieb über eine Relaisfunkstelle nicht möglich ist.', ' ');
INSERT INTO answer VALUES (6413, 1604, 0, 'bei der mit besonderer Zulassung auf einer festen Frequenz an einem festgelegten Standort ein Amateurfunksender betrieben wird.', ' ');
INSERT INTO answer VALUES (6414, 1604, 1, 'die mit einer entsprechenden Sonderzulassung der zuständigen Behörde an mehreren Standorten auf verschiedenen Frequenzen betrieben werden kann.', ' ');
INSERT INTO answer VALUES (6415, 1604, 2, 'die auf einer festen Frequenz arbeitet. Der Standort der Funkanlage kann je nach Notwendigkeit verändert werden.', ' ');
INSERT INTO answer VALUES (6416, 1604, 3, 'die mit geringer Sendeleistung auf einer festen Frequenz nur in den Nachtstunden zur Feststellung der Bandbelegung betrieben wird.', ' ');
INSERT INTO answer VALUES (6417, 1605, 0, 'Damit es besonders Mobilstationen leichter möglich ist, die Relaisfunkstelle zu nutzen', ' ');
INSERT INTO answer VALUES (6418, 1605, 1, 'Um zeitweilig Simplex-Verkehr zu ermöglichen', ' ');
INSERT INTO answer VALUES (6419, 1605, 2, 'Nach der Amateurfunkverordnung darf ein Durchgang höchstens 60 Sekunden betragen.', ' ');
INSERT INTO answer VALUES (6420, 1605, 3, 'Die Sprachspeicher einer Relaisfunkstelle haben eine zeitlich begrenzte Kapazität.', ' ');
INSERT INTO answer VALUES (6421, 1606, 0, '600 kHz höher als die Eingabefrequenz.', ' ');
INSERT INTO answer VALUES (6422, 1606, 1, '600 kHz niedriger als die Eingabefrequenz.', ' ');
INSERT INTO answer VALUES (6423, 1606, 2, '1,6 MHz höher als die Eingabefrequenz.', ' ');
INSERT INTO answer VALUES (6424, 1606, 3, '1,6 MHz niedriger als die Eingabefrequenz.', ' ');
INSERT INTO answer VALUES (6425, 1607, 0, '7,6 MHz höher als die Eingabefrequenz.', ' ');
INSERT INTO answer VALUES (6426, 1607, 1, '600 kHz niedriger als die Eingabefrequenz.', ' ');
INSERT INTO answer VALUES (6427, 1607, 2, '600 kHz höher als die Eingabefrequenz.', ' ');
INSERT INTO answer VALUES (6428, 1607, 3, '7,6 MHz niedriger als die Eingabefrequenz.', ' ');
INSERT INTO answer VALUES (6429, 1608, 0, 'Einen Umsetzer an Bord eines Amateurfunksatelliten, der die aufgenommenen Signale in einen anderen Frequenzbereich umsetzt und wieder zur Erde sendet.', ' ');
INSERT INTO answer VALUES (6430, 1608, 1, 'Es handelt sich um einen mit einer fernbedienten Amateurfunkstelle bestückten Stratosphärenballon, der empfangene Signale aufbereitet zur Erde zurücksendet.', ' ');
INSERT INTO answer VALUES (6431, 1608, 2, 'Dies ist ein Umsetzer an Bord eines Amateurfunksatelliten, der die vom Satelliten aufgenommenen Wetterbilder und weitere Telemetriedaten automatisch zur Erde sendet.', ' ');
INSERT INTO answer VALUES (6432, 1608, 3, 'Dies ist ein Bakensender an Bord eines Amateurfunksatelliten, der zur Beobachtung der Ausbreitungsbedingungen im VHF-, UHF- und SHF-Bereich dient.', ' ');
INSERT INTO answer VALUES (6433, 1609, 0, 'Der Transponderfahrplan eines Satelliten gibt an, wann und über welchen Transponder Funkbetrieb abgewickelt werden kann.', ' ');
INSERT INTO answer VALUES (6434, 1609, 1, 'Der Transponderfahrplan eines Satelliten gibt an, zu welchen Zeiten dieser hörbar ist und Funkbetrieb abgewickelt werden muss.', ' ');
INSERT INTO answer VALUES (6435, 1609, 2, 'Der Transponderfahrplan eines Satelliten gibt an, wann die Transponder untereinander den Funkbetrieb abwickeln können. Es sind Batterieabschaltzeiten zur Aufladung erforderlich.', ' ');
INSERT INTO answer VALUES (6436, 1609, 3, 'Die Transponderfahrpläne der Satelliten geben an, bei welchen Satellitenbahnen und zu welchen Zeiten Satellitenbetrieb zulässig ist.', ' ');
INSERT INTO answer VALUES (6437, 1610, 0, 'Diese Frequenzen sind nach der IARU-Empfehlung für das Internationale Bakenprojekt (IBP) vorgesehen und sind für die Beobachtung der Ausbreitungsbedingungen anhand von Bakensignalen freizuhalten.', ' ');
INSERT INTO answer VALUES (6438, 1610, 1, 'Diese Frequenzbereiche sind nach der IARU-Empfehlung für Packet Radio vorgesehen und sollen für die Beobachtung dieser Sendungen freigehalten werden.', ' ');
INSERT INTO answer VALUES (6439, 1610, 2, 'Diese Frequenzen sind nach der IARU-Empfehlung besonders für DX-Verkehr vorgesehen und sollen möglichst für Funkverkehr bei "DX-Expeditionen" genutzt werden.', ' ');
INSERT INTO answer VALUES (6440, 1610, 3, 'Diese Frequenzbereiche sind nach Empfehlung der Radio Regulations (VO Funk) für besondere Amateurfunk-Zeitzeichen- und Normalfrequenzaussendungen vorgesehen und sollen möglichst freigehalten werden.', ' ');
INSERT INTO answer VALUES (6441, 1611, 0, '1) Fernbediente Amateurfunkstelle, die an einem festen Standort unbesetzt betrieben wird (Relaisfunkstelle) 2) Relaisfunkstelle für Packet Radio 3) Datenbank mit allgemeinen Zugriff zum Einspeichern und Auslesen von Informationen', ' ');
INSERT INTO answer VALUES (6442, 1611, 1, '1) Automatisch arbeitende Amateurfunkstelle, die an einem festen Standort unbesetzt betrieben wird 2) Digitale Multimedia Funkbake 3) Datenbank mit allgemeinen Zugriff zum Einspeichern und Auslesen von Informationen', ' ');
INSERT INTO answer VALUES (6443, 1611, 2, '1) Fernbediente Amateurfunkstelle, die an einem festen Standort unbesetzt betrieben wird 2) Relaisfunkstelle für digitales Amateurfunkfernsehen 3) Einrichtung zur automatischen Antennenanpassung bei Relaisfunkstellen und Funkbaken', ' ');
INSERT INTO answer VALUES (6444, 1611, 3, '1) Automatisch arbeitende Amateurfunkstelle, die an einem festen Standort unbesetzt betrieben wird (Relaisfunkstelle) 2) Relaisfunkstelle für digitales Amateurfunkfernsehen 3) Einrichtung zur automatischen Antennenanpassung bei Relaisfunkstellen und Funkbaken', ' ');
INSERT INTO answer VALUES (6445, 1612, 0, '1) Umlaufender Satellit, der Amateurfunktechnik beinhaltet 2) Senderichtung von der Erde zum Satelliten 3) Senderichtung vom Satelliten zur Erde 4) Horizontale / vertikale Winkelangaben', ' ');
INSERT INTO answer VALUES (6446, 1612, 1, '1) Umlaufender Satellit, der Amateurfunktechnik beinhaltet 2) Senderichtung vom Satelliten zur Erde 3) Senderichtung von der Erde zum Satelliten 4) Horizontale / vertikale Entfernungsangaben', ' ');
INSERT INTO answer VALUES (6447, 1612, 2, '1) Ortsfester Satellit der Amateurfunktechnik beinhaltet 2) Senderichtung vom Satelliten zur Erde 3) Senderichtung von der Erde zum Satelliten 4) Horizontale / vertikale Winkelangaben', ' ');
INSERT INTO answer VALUES (6448, 1612, 3, '1) Ortsfester Satellit, der Amateurfunktechnik beinhaltet 2) Senderichtung von der Erde zum Satelliten 3) Senderichtung vom Satelliten zur Erde 4) Horizontale / vertikale Längenangaben zur Berechnung der Laufzeiten', ' ');
INSERT INTO answer VALUES (6449, 1613, 0, 'Sie dürfen die Frequenz unter keinen Umständen weiterbenutzen (außer im echten Notfall), da der Küstenfunkstelle eine feste Frequenz zugeteilt ist, die sie nicht verändern kann.', ' ');
INSERT INTO answer VALUES (6450, 1613, 1, 'Sie dürfen die Frequenz weiter benutzen, wenn aus der dauernd wiederholten, automatisch ablaufenden Morseaussendung klar hervorgeht, dass die Küstenfunkstelle keinen zweiseitigen Funkverkehr abwickelt, sondern offenbar nur die Frequenz belegt.', ' ');
INSERT INTO answer VALUES (6451, 1613, 2, 'Sie dürfen die Frequenz weiter benutzen, wenn der Standort Ihrer Amateurfunkstelle mehr als 200 km von einer Meeresküste entfernt ist, und Sie weniger als 100 Watt Sendeleistung anwenden.', ' ');
INSERT INTO answer VALUES (6452, 1613, 3, 'Sie dürfen die begonnene Funkverbindung mit Ihrer Gegenfunkstelle solange fortführen, bis Sie von der Küstenfunkstelle zum Frequenzwechsel aufgefordert werden.', ' ');
INSERT INTO answer VALUES (6453, 1614, 0, 'Mayday', ' ');
INSERT INTO answer VALUES (6454, 1614, 1, 'Securité', ' ');
INSERT INTO answer VALUES (6455, 1614, 2, 'Distresse', ' ');
INSERT INTO answer VALUES (6456, 1614, 3, 'Prudence', ' ');
INSERT INTO answer VALUES (6457, 1615, 0, 'Mayday', ' ');
INSERT INTO answer VALUES (6458, 1615, 1, 'XXX, TTT', ' ');
INSERT INTO answer VALUES (6459, 1615, 2, 'Distresse', ' ');
INSERT INTO answer VALUES (6460, 1615, 3, 'DDD, SOS', ' ');
INSERT INTO answer VALUES (6461, 1616, 0, 'Nein, niemals', ' ');
INSERT INTO answer VALUES (6462, 1616, 1, 'Unter Umständen schon, wenn ich beispielsweise ein Schiff untergehen sehe', ' ');
INSERT INTO answer VALUES (6463, 1616, 2, 'Ja, aber nicht auf der internationalen Notruffrequenz', ' ');
INSERT INTO answer VALUES (6464, 1616, 3, 'SOS nicht, aber Mayday im Notfall', ' ');
INSERT INTO answer VALUES (6465, 1617, 0, '01:00 MESZ am 17. August (Ortsdatum)', ' ');
INSERT INTO answer VALUES (6466, 1617, 1, '21:00 MESZ am 16. August (Ortsdatum)', ' ');
INSERT INTO answer VALUES (6467, 1617, 2, '22:00 MESZ am 16. August (Ortsdatum)', ' ');
INSERT INTO answer VALUES (6468, 1617, 3, '00:00 MESZ am 18. August (Ortsdatum)', ' ');
INSERT INTO answer VALUES (6469, 1618, 0, 'Ich beobachte die Frequenz und achte darauf, ob die Notmeldung von einer Rettungsorganisation bestätigt wird. Wenn dies innerhalb einer kurzen Zeit nicht geschieht, rufe ich die Station an und biete meine Hilfe an.', ' ');
INSERT INTO answer VALUES (6470, 1618, 1, 'Ich rufe die Station sofort an und biete meine Hilfe an.', ' ');
INSERT INTO answer VALUES (6471, 1618, 2, 'Da es sich nicht um Amateurfunkverkehr handelt verlasse ich die Frequenz.', ' ');
INSERT INTO answer VALUES (6472, 1618, 3, 'Ich wiederhole umgehend die Notmeldung auf der gleichen Frequenz.', ' ');
INSERT INTO answer VALUES (6473, 1619, 0, 'Ich nehme Kontakt mit der Segelyacht auf, um die Position zu erfahren. Danach informiere ich die Polizei und bitte um Weitergabe der Information an die zuständigen Rettungsorganisationen.', ' ');
INSERT INTO answer VALUES (6474, 1619, 1, 'Ich nehme Kontakt mit anderen Amateurfunkstationen auf, um gemeinsam eine Rettung zu organisieren.', ' ');
INSERT INTO answer VALUES (6475, 1619, 2, 'Ich beobachte die Frequenz weiter, um festzustellen ob sich Stationen melden, die sich näher am Standort des Havaristen befinden.', ' ');
INSERT INTO answer VALUES (6476, 1619, 3, 'Ich nehme Kontakt mit der Segelyacht auf, um die Position zu erfahren. Danach verständige ich die örtliche Presse und das Lokalradio und bitte um Mithilfe.', ' ');
INSERT INTO answer VALUES (6477, 1620, 0, 'Ich versuche Kontakt mit der Funkstelle aufzunehmen, um den Standort zu erfahren. Danach informiere ich die Polizei und bitte um Weitergabe der Information an die zuständigen Rettungsorganisationen.', ' ');
INSERT INTO answer VALUES (6478, 1620, 1, 'Ich versuche Kontakt mit der Funkstelle aufzunehmen, um den Standort zu erfahren. Danach informiere ich den ADAC oder biete eigene Abschlepphilfe an.', ' ');
INSERT INTO answer VALUES (6479, 1620, 2, 'Ich versuche Kontakt mit der Polizei aufzunehmen, um den Standort zu erfahren. Danach informiere ich die Funkstelle und beruhige den Betreiber.', ' ');
INSERT INTO answer VALUES (6480, 1620, 3, 'Ich wiederhole umgehend die Notmeldung auf der Relaiseingabefrequenz.', ' ');
INSERT INTO answer VALUES (6481, 1621, 0, '3760 und 7060 kHz', ' ');
INSERT INTO answer VALUES (6482, 1621, 1, '3600 und 7050 kHz', ' ');
INSERT INTO answer VALUES (6483, 1621, 2, '3700 und 7080 kHz', ' ');
INSERT INTO answer VALUES (6484, 1621, 3, '3500 und 7000 kHz', ' ');
INSERT INTO answer VALUES (6485, 1622, 0, 'Sie dürfen weltweit für den Notfunkverkehr im Amateurfunk benutzt werden.', ' ');
INSERT INTO answer VALUES (6486, 1622, 1, 'Sie dürfen nur für den Notfunkverkehr innerhalb der eigenen Landesgrenze benutzt werden.', ' ');
INSERT INTO answer VALUES (6487, 1622, 2, 'Sie dürfen nur für den Notfunk innerhalb der IARU-Region 1 verwendet werden.', ' ');
INSERT INTO answer VALUES (6488, 1622, 3, 'Sie haben keine besondere Bedeutung.', ' ');
INSERT INTO answer VALUES (6489, 1623, 0, '11:30 UTC', ' ');
INSERT INTO answer VALUES (6490, 1623, 1, '13:30 UTC', ' ');
INSERT INTO answer VALUES (6491, 1623, 2, '12:30 UTC', ' ');
INSERT INTO answer VALUES (6492, 1623, 3, '14:30 UTC', ' ');
INSERT INTO answer VALUES (6493, 1624, 0, 'Sie sollte in UTC eingetragen werden.', ' ');
INSERT INTO answer VALUES (6494, 1624, 1, 'Sie sollte in meiner aktuellen Ortszeit eingetragen werden.', ' ');
INSERT INTO answer VALUES (6495, 1624, 2, 'Sie sollte in der Ortszeit der Gegenstation eingetragen werden.', ' ');
INSERT INTO answer VALUES (6496, 1624, 3, 'Sie sollte in MEZ erfolgen.', ' ');
INSERT INTO answer VALUES (6497, 1625, 0, 'Es ist das Stationstagebuch, das ein Funkamateur freiwillig führt oder in besonderen Fällen führen muss.', ' ');
INSERT INTO answer VALUES (6498, 1625, 1, 'Es ist das Stationstagebuch, das jeder Funkamateur führen muss.', ' ');
INSERT INTO answer VALUES (6499, 1625, 2, 'Es ist die Dokumentation aller Geräte und Antennen des Funkamateurs.', ' ');
INSERT INTO answer VALUES (6500, 1625, 3, 'Es ist die Dokumentation über die Einhaltung der Sicherheitsabstände bezüglich des Personenschutzes.', ' ');
INSERT INTO answer VALUES (6501, 1626, 0, 'auf Anordnung der zuständigen Behörde.', ' ');
INSERT INTO answer VALUES (6502, 1626, 1, 'wenn die zulässigen Grenzwerte zum Personenschutz überschritten werden.', ' ');
INSERT INTO answer VALUES (6503, 1626, 2, 'wenn die effektive isotrope Strahlungsleistung (EIRP) mehr als 10 Watt beträgt.', ' ');
INSERT INTO answer VALUES (6504, 1626, 3, 'in den ersten zwei Jahren nach der Zulassung am Amateurfunkdienst.', ' ');
INSERT INTO answer VALUES (6505, 1627, 0, '14:30 UTC', ' ');
INSERT INTO answer VALUES (6506, 1627, 1, '13:30 UTC', ' ');
INSERT INTO answer VALUES (6507, 1627, 2, '17:30 UTC', ' ');
INSERT INTO answer VALUES (6508, 1627, 3, '16:30 UTC', ' ');
INSERT INTO answer VALUES (6509, 1628, 0, 'Freigemachter und mit eigener Adresse versehener Umschlag', ' ');
INSERT INTO answer VALUES (6510, 1628, 1, 'Internationaler Antwortschein', ' ');
INSERT INTO answer VALUES (6511, 1628, 2, 'Adressierter Umschlag', ' ');
INSERT INTO answer VALUES (6512, 1628, 3, 'Internationale Postwertzeichen', ' ');
INSERT INTO answer VALUES (6513, 1629, 0, 'ein internationaler Antwortschein.', ' ');
INSERT INTO answer VALUES (6514, 1629, 1, 'die internationale Radio Konferenz.', ' ');
INSERT INTO answer VALUES (6515, 1629, 2, 'ein adressierter Freiumschlag.', ' ');
INSERT INTO answer VALUES (6516, 1629, 3, 'ein freigemachter und mit eigener Adresse versehener Umschlag.', ' ');
INSERT INTO answer VALUES (6517, 1630, 0, 'Die Daten müssen, wie auch beim Papierlogbuch, über eine bestimmte Zeit einsehbar sein.', ' ');
INSERT INTO answer VALUES (6518, 1630, 1, 'Es dürfen ausschließlich IBM-Kompatible PCs verwendet werden.', ' ');
INSERT INTO answer VALUES (6519, 1630, 2, 'Es muss zusätzlich ein herkömmliches Papierlogbuch geführt werden.', ' ');
INSERT INTO answer VALUES (6520, 1630, 3, 'Es muss jederzeit ein Ausdruck des Logbuches vorhanden sein.', ' ');
INSERT INTO answer VALUES (6521, 1631, 0, 'Die alte Software muss verfügbar bleiben, um die Betriebsdaten bei eventuellen späteren Überprüfungen einsehen zu können.', ' ');
INSERT INTO answer VALUES (6522, 1631, 1, 'Es sollte auf eine Software für ein 32-Bit- System gewechselt werden.', ' ');
INSERT INTO answer VALUES (6523, 1631, 2, 'Die alte Software muss auf jeden Fall gelöscht werden, um Kollisionen bei den Datenformaten zu vermeiden.', ' ');
INSERT INTO answer VALUES (6524, 1631, 3, 'Es sollte ein Logbuchprogramm mit Druckfunktion verwendet werden, um zu vermeiden, dass weiterhin ein herkömmliches Papierlogbuch geführt werden muss.', ' ');
INSERT INTO answer VALUES (6525, 1632, 0, 'Die QSL-Karte ist die schriftliche Bestätigung einer Amateurfunkverbindung. Sie dient zur Bestätigung der Angaben, die im QSO gemacht wurden. Ihr weiterer Wert liegt in der Verwendung als Beleg bei der Beantragung von Amateurfunk- Diplomen', ' ');
INSERT INTO answer VALUES (6526, 1632, 1, 'Die QSL-Karte ist eine Ansichtskarte, die die Station des Funkamateurs zeigt. Sie dient als Werbung für die Gerätehersteller.', ' ');
INSERT INTO answer VALUES (6527, 1632, 2, 'Die QSL-Karte ist eine Einladung zum Besuch eines Funkamateurs. Sie dient dem näheren Kennenlernen der Funkamateure untereinander.', ' ');
INSERT INTO answer VALUES (6528, 1632, 3, 'Die QSL-Karte ist eine Reservierungsbestätigung in einer Amateurfunkrunde. Sie sichert dem Funkamateur die Teilnahme an der Runde.', ' ');
INSERT INTO answer VALUES (6529, 1633, 0, 'Verwendetes Rufzeichen, Rufzeichen der Gegenstation, Datum und Uhrzeit der Funkverbindung in UTC, Frequenz, Betriebsart, Signal- Rapport und die Unterschrift des Operators.', ' ');
INSERT INTO answer VALUES (6530, 1633, 1, 'Verwendetes Rufzeichen, Datum und Uhrzeit der Funkverbindung in UTC, Frequenz, Betriebsart, Signal-Rapport, die Unterschrift des Operators sowie den eigenen Namen, Standort, Locator, die eigene Sendeleistung und Angaben zur eingesetzten technischen Ausrüstung.', ' ');
INSERT INTO answer VALUES (6531, 1633, 2, 'Rufzeichen der Gegenstation, Datum und Uhrzeit der Funkverbindung in UTC, Frequenz, Betriebsart, Signal-Rapport und weitere übliche Angaben wie den eigenen Namen, Standort, Locator und die eigene Sendeleistung.', ' ');
INSERT INTO answer VALUES (6532, 1633, 3, 'Rufzeichen der Gegenstation, Datum und Uhrzeit der Funkverbindung in UTC, Frequenz, Betriebsart, Angaben über das Funkwetter und die Unterschrift des Operators.', ' ');
INSERT INTO an