# How to contribute

Contributions are very welcome and encouraged.
This is a non-profit initiative that has been built exclusively by volunteers.

Many different ways to contribute are already listed [on the Transportr homepage](https://transportr.app/contribute).
Here, we focus on contributions made via GitHub.

## Creating Issues

Before creating a new issue,
please have a look at the list of [open](https://github.com/grote/Transportr/issues)
*and* [closed issues](https://github.com/grote/Transportr/issues?q=is%3Aissue+is%3Aclosed)
to see if it already has been reported.
An issue will be closed once it has been fixed in the source code.
This fix however might not have its way to the version of Transportr you are using,
so please don't forget to also check the closed issues.

If the problem you have found is not reported already,
please create a new issue
and describe what exactly you did to produce the faulty behavior mentioning the version of Transportr you are using.
Screenshots are always welcome to illustrate your description.

**Important:** Please check if the issue you are going to report is actually related to Transportr.
For example, if you get an error when searching for directions,
this is most likely an issue you need to report to [public-transport-enabler](https://github.com/schildbach/public-transport-enabler/issues),
because this is the library Transportr uses to provide public transport data.
When the issue gets fixed there,
it will automatically get fixed in the next version of Transportr.

If in doubt, feel free to create an issue with Transportr.
If the issue is unrelated to it,
it will be closed with a pointer to the upstream software the issue belongs to.

## Creating Pull Requests

If you want to do more than fixing bugs,
please create an issue for the feature you want to work on (if it does not already exist)
before doing any major work,
so that other developers know about your plans,
can coordinate, prevent duplicated work
and discuss the best approach for your undertaking.

Missing features are documented [in the issue tracker](https://github.com/grote/Transportr/issues?labels=enhancement&state=open).
Feel free to look there for ideas or to add your own enhancement ticket.

There is also [a list of beginner tasks](https://github.com/grote/Transportr/labels/beginner%20job) for you to get started easily. 

Please do not touch any translations with your pull request.
These are exclusively done [via Transifex](https://www.transifex.com/projects/p/transportr/).
