package de.georgelsas.tuttocounter;

import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.util.Log;
import android.view.View;
import android.widget.Toast;

import androidx.core.content.FileProvider;

import java.io.File;
import java.io.FileOutputStream;

public class ScreenshotSharer {

    private final MainActivity activity;

    public ScreenshotSharer(MainActivity activity) {
        this.activity = activity;
    }

    public void shareScreenshot() {
        try {
            // Screenshot vom Root-View
            View rootView = activity.getWindow().getDecorView().findViewById(android.R.id.content);
            rootView.setDrawingCacheEnabled(true);
            Bitmap bitmap = Bitmap.createBitmap(rootView.getDrawingCache());
            rootView.setDrawingCacheEnabled(false);

            // Datei speichern
            File cachePath = new File(activity.getCacheDir(), "images");
            cachePath.mkdirs();
            File file = new File(cachePath, "screenshot.png");

            FileOutputStream fos = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, fos);
            fos.close();

            Uri contentUri = FileProvider.getUriForFile(
                    activity,
                    activity.getPackageName() + ".fileprovider",
                    file
            );

            // Share Intent
            Intent shareIntent = new Intent(Intent.ACTION_SEND);
            shareIntent.setType("image/png");
            shareIntent.putExtra(Intent.EXTRA_STREAM, contentUri);
            shareIntent.addFlags(Intent.FLAG_GRANT_READ_URI_PERMISSION);

            activity.startActivity(Intent.createChooser(shareIntent, "Scores teilen"));

        } catch (Exception e) {
            Log.e("ScreenshotSharer", "Fehler beim Erstellen des Screenshots", e);
            Toast.makeText(activity, "Screenshot konnte nicht erstellt werden.", Toast.LENGTH_SHORT).show();
        }
    }
}
