package de.georgelsas.tuttocounter;

import android.app.AlertDialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Color;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.widget.Toast;

import androidx.core.content.ContextCompat;

import com.github.mikephil.charting.charts.LineChart;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.LineDataSet;
import com.github.mikephil.charting.formatter.ValueFormatter;
import com.github.mikephil.charting.interfaces.datasets.ILineDataSet;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.SimpleDateFormat;
import java.util.*;

public class ProgressChartDialog {

    public static void show(Context context, int backgroundDrawableResId) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context, R.style.RoundedAlertDialogTheme);
        View view = LayoutInflater.from(context).inflate(R.layout.dialog_chart, null);
        builder.setView(view);

        LineChart lineChart = view.findViewById(R.id.lineChart);

        try {
            SharedPreferences sharedPreferences = context.getSharedPreferences("CardData", Context.MODE_PRIVATE);
            String json = sharedPreferences.getString("cardHistory", "[]");
            JSONArray historyArray = new JSONArray(json);

            String cardsJson = sharedPreferences.getString("cards", "[]");
            JSONArray cardsArray = new JSONArray(cardsJson);
            Map<String, Integer> cardColorMap = new HashMap<>();

            for (int i = 0; i < cardsArray.length(); i++) {
                JSONObject card = cardsArray.getJSONObject(i);
                String name = card.getString("name");
                int color = card.getInt("color");
                cardColorMap.put(name, color);
            }


            Map<String, List<Entry>> cardDataMap = new HashMap<>();
            List<Long> timestamps = new ArrayList<>();

            for (int i = 0; i < historyArray.length(); i++) {
                JSONObject snapshot = historyArray.getJSONObject(i);
                long timestamp = snapshot.getLong("timestamp");
                timestamps.add(timestamp);

                JSONArray cardItems = snapshot.getJSONArray("cardItems");

                for (int j = 0; j < cardItems.length(); j++) {
                    JSONObject card = cardItems.getJSONObject(j);
                    String name = card.getString("name");
                    int number = card.getInt("number");

                    if (!cardDataMap.containsKey(name)) {
                        cardDataMap.put(name, new ArrayList<>());
                    }

                    Objects.requireNonNull(cardDataMap.get(name)).add(new Entry(i, number));
                }
            }

            List<ILineDataSet> dataSets = new ArrayList<>();
            for (Map.Entry<String, List<Entry>> entry : cardDataMap.entrySet()) {
                String cardName = entry.getKey();
                int color = cardColorMap.containsKey(cardName) ? cardColorMap.get(cardName) : Color.GRAY;

                LineDataSet dataSet = new LineDataSet(entry.getValue(), cardName);
                dataSet.setColor(color);
                dataSet.setLineWidth(4f);
                dataSet.setCircleRadius(4f);
                dataSet.setCircleColor(color);
                dataSet.setValueTextSize(18f);
                dataSet.setMode(LineDataSet.Mode.CUBIC_BEZIER);
                dataSets.add(dataSet);
            }

            LineData lineData = new LineData(dataSets);
            lineChart.setData(lineData);

            // Setze Textfarben für Dark Mode
            int textColor = ContextCompat.getColor(context, R.color.chartTextColor);

            lineChart.setNoDataTextColor(textColor);
            lineChart.setGridBackgroundColor(Color.TRANSPARENT);
            lineChart.setBackgroundColor(Color.TRANSPARENT);

// Achsen
            lineChart.getXAxis().setTextColor(textColor);
            lineChart.getAxisLeft().setTextColor(textColor);
            lineChart.getAxisRight().setTextColor(textColor);

// Labels über den Punkten
            for (ILineDataSet set : lineChart.getData().getDataSets()) {
                if (set instanceof LineDataSet) {
                    ((LineDataSet) set).setValueTextColor(textColor);
                }
            }

// Legende
            lineChart.getLegend().setTextColor(textColor);
            lineChart.getLegend().setTextSize(15);


            lineChart.getXAxis().setValueFormatter(new ValueFormatter() {
                @Override
                public String getFormattedValue(float value) {
                    int index = (int) value;
                    if (index >= 0 && index < timestamps.size()) {
                        Date date = new Date(timestamps.get(index));
                        return new SimpleDateFormat("HH:mm", Locale.getDefault()).format(date);
                    }
                    return "";
                }
            });

            lineChart.getXAxis().setPosition(XAxis.XAxisPosition.BOTTOM);
            lineChart.getDescription().setEnabled(false);
            lineChart.invalidate();

            builder.setPositiveButton(context.getText(R.string.close), null);
            AlertDialog dialog = builder.create();
            dialog.show();
            Window window = dialog.getWindow();
            if (window != null) {
                window.setBackgroundDrawable(ContextCompat.getDrawable(context, backgroundDrawableResId));
            }
        } catch (JSONException e) {
            Log.e("TuttoError", Objects.requireNonNull(e.getLocalizedMessage()));
            Toast.makeText(context, "Fehler beim Laden der History", Toast.LENGTH_SHORT).show();
        }
    }
}
