package de.georgelsas.tuttocounter;

import android.content.Context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NameManager {

    private final List<String> allNames = new ArrayList<>();
    private final List<String> availableNames = new ArrayList<>();

    public NameManager(Context context) {

        loadNamesFromResources(context);
        resetNames();

    }

    private void loadNamesFromResources(Context context) {

        TuttoSettings tuttoSettings = ((MainActivity) context).getTuttoSettings();
        if (tuttoSettings.getStatusOfNameCategory(TuttoSettings.PossibleNames.ANIMALS)){
            String[] animals = context.getResources().getStringArray(R.array.animals);
            Collections.addAll(allNames, animals);}

        if (tuttoSettings.getStatusOfNameCategory(TuttoSettings.PossibleNames.FRUITS)) {
            String[] fruits = context.getResources().getStringArray(R.array.fruits);
            Collections.addAll(allNames, fruits);
        }
        if (tuttoSettings.getStatusOfNameCategory(TuttoSettings.PossibleNames.VEGETABLES)){
            String[] vegetables = context.getResources().getStringArray(R.array.vegetables);
            Collections.addAll(allNames, vegetables);
        }
        if (tuttoSettings.getStatusOfNameCategory(TuttoSettings.PossibleNames.CARS)){
            String[] cars = context.getResources().getStringArray(R.array.cars);
            Collections.addAll(allNames, cars);
        }
        if (tuttoSettings.getStatusOfNameCategory(TuttoSettings.PossibleNames.CITIES)) {
            String[] cities = context.getResources().getStringArray(R.array.cities);
            Collections.addAll(allNames, cities);
        }
        if (tuttoSettings.getStatusOfNameCategory(TuttoSettings.PossibleNames.COUNTRIES)) {
            String[] countries = context.getResources().getStringArray(R.array.countries);
            Collections.addAll(allNames, countries);
        }
        if (tuttoSettings.getStatusOfNameCategory(TuttoSettings.PossibleNames.SPORTS)) {
            String[] sports = context.getResources().getStringArray(R.array.sports);
            Collections.addAll(allNames, sports);
        }
        if (allNames.isEmpty()) {
            allNames.add("");
        }
    }

    public String getNextName() {
        if (availableNames.isEmpty()) {
            resetNames();
        }
        int index = (int) (Math.random() * availableNames.size());
        return availableNames.remove(index);
    }

    private void resetNames() {
        availableNames.clear();
        availableNames.addAll(allNames);
        Collections.shuffle(availableNames);
    }
}
