package de.georgelsas.tuttocounter;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;

import com.king.view.arcseekbar.ArcSeekBar;

public class LockableArcSeekBar extends ArcSeekBar {

    private boolean interactionEnabled = true;

    public LockableArcSeekBar(Context context) {
        super(context);
    }

    public LockableArcSeekBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public LockableArcSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    /**
     * Aktiviert / deaktiviert Benutzerinteraktion zuverlässig
     */
    public void setInteractionEnabled(boolean enabled) {
        this.interactionEnabled = enabled;
        setAlpha(enabled ? 1f : 0.4f);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (!interactionEnabled) {
            return false; // ❗ blockiert JEDE Bewegung
        }
        return super.onTouchEvent(event);
    }
}
