package de.georgelsas.tuttocounter;

import android.graphics.Color;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ColorManager {
    private final List<Integer> allColors = Arrays.asList(
            Color.parseColor("#303F9F"), // Dark Blue
            Color.parseColor("#3F51B5"), // Indigo
            Color.parseColor("#00796B"), // Teal
            Color.parseColor("#673AB7"), // Deep Purple
            Color.parseColor("#388E3C"), // Dark Green
            Color.parseColor("#616161"), // Grey
            Color.parseColor("#1E88E5"), // Blue
            Color.parseColor("#8E24AA"), // Purple
            Color.parseColor("#795548"), // Brown
            Color.parseColor("#F57C00")  // Orange
    );

    private final List<Integer> availableColors = new ArrayList<>();

    public ColorManager() {
        resetColors();
    }

    public int getNextColor() {
        if (availableColors.isEmpty()) {
            resetColors();
        }

        // Zufällig eine Farbe wählen und entfernen
        int index = (int) (Math.random() * availableColors.size());
        return availableColors.remove(index);
    }

    private void resetColors() {
        availableColors.clear();
        availableColors.addAll(allColors);
        // Optional: shuffle, damit Reihenfolge neu ist
        Collections.shuffle(availableColors);
    }
}
