package de.georgelsas.tuttocounter;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.cardview.widget.CardView;
import androidx.recyclerview.widget.RecyclerView;

public class CardAdapter extends RecyclerView.Adapter<CardAdapter.CardViewHolder> {

    private final MainActivity activity;
    private final CardManager cardManager;

    public CardAdapter(MainActivity activity, CardManager cardManager) {
        this.activity = activity;
        this.cardManager = cardManager;
    }


    @NonNull
    @Override
    public CardViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_card, parent, false);
        return new CardViewHolder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull CardViewHolder holder, int position) {
        CardItem card = cardManager.getCardItems().get(position);

        holder.nameView.setText(card.getName());
        holder.numberView.setText(String.valueOf(card.getNumber()));
        holder.cardView.setCardBackgroundColor(card.getColor());

        holder.cardView.setOnClickListener(v ->
                activity.showEditDialog(card, holder.numberView));

        holder.editIcon.setOnClickListener(v ->
                activity.showNameAndColorEditDialog(card, holder.nameView, holder.cardView));
    }

    @Override
    public int getItemCount() {
        return cardManager.getCardItems().size();
    }

    public void moveItem(int fromPos, int toPos) {
        cardManager.swapCards(fromPos, toPos);
        notifyItemMoved(fromPos, toPos);
    }

    public static class CardViewHolder extends RecyclerView.ViewHolder {
        TextView nameView, numberView;
        ImageView editIcon;
        CardView cardView;

        CardViewHolder(View itemView) {
            super(itemView);
            cardView = (CardView) itemView;
            nameView = itemView.findViewById(R.id.card_name);
            numberView = itemView.findViewById(R.id.card_number);
            editIcon = itemView.findViewById(R.id.card_edit_icon);
        }
    }
}
