plugins {
    alias(libs.plugins.android.application)
    alias(libs.plugins.kotlin.android)  // <- Diese Zeile hinzufügen

}

android {
    namespace = "de.georgelsas.tuttocounter"
    compileSdk = 36

    defaultConfig {
        applicationId = "de.georgelsas.tuttocounter"
        minSdk = 24
        targetSdk = 36
        versionCode = 6
        versionName = "0.6"

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
    }

    buildTypes {
        release {
            isMinifyEnabled = false
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
        }
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_11
        targetCompatibility = JavaVersion.VERSION_11
    }

    kotlinOptions {
        jvmTarget = "11"
    }

    packaging {
        resources {
            excludes += setOf(
                "assets/dexopt/baseline.prof",
                "META-INF/*.version",
                "META-INF/*.kotlin_module"
            )
        }
    }
}

dependencies {

    implementation(libs.appcompat)
    implementation(libs.material)
    implementation(libs.activity)
    implementation(libs.constraintlayout)
    implementation(libs.cardview)
    testImplementation(libs.junit)
    androidTestImplementation(libs.ext.junit)
    androidTestImplementation(libs.espresso.core)
    // Eigenes
    implementation(libs.gson)
    implementation("com.github.jenly1314:arcseekbar:1.2.0")
    implementation("com.github.skydoves:colorpickerpreference:2.0.6")
    implementation("com.github.PhilJay:MPAndroidChart:v3.1.0")
    implementation("nl.dionsegijn:konfetti-xml:2.0.5")
    implementation("com.github.deano2390:MaterialShowcaseView:1.3.7")
}
