package de.georgelsas.tuttocounter;

import android.content.Context;
import android.content.SharedPreferences;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class TuttoSettings {
    public enum PossibleNames {
        SPORTS,
        CITIES,
        VEGETABLES,
        FRUITS,
        CARS,
        COUNTRIES,
        ANIMALS
    }

    private int winningValue;
    private Map<PossibleNames, Boolean> names = new HashMap<>();
    private final SharedPreferences sharedPreferences;
    private final String preferenceIndex = "possibleNames";

    public TuttoSettings(MainActivity mainActivity) {
        this.sharedPreferences = mainActivity.getSharedPreferences("CardData", Context.MODE_PRIVATE);
        this.winningValue = mainActivity.getResources().getInteger(R.integer.winningValue);
        loadPossibleNamesStatus();
    }

    public void savePossibleNamesStatus() {
        Gson gson = new Gson();
        String json = gson.toJson(names);

        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString(preferenceIndex, json);
        editor.apply();

    }

    private void loadPossibleNamesStatus() {
        Gson gson = new Gson();
        String json = sharedPreferences.getString(preferenceIndex, null);

        if (json != null) {
            Type type = new TypeToken<Map<PossibleNames, Boolean>>(){}.getType();
            names = gson.fromJson(json, type);
        }
        else {
            for (PossibleNames possibility : PossibleNames.values()) {
                names.put(possibility, true);
            }
        }
    }

    public void setStatusOfNameCategory(PossibleNames category, Boolean activated) {
        names.put(category, activated);
    }

    public Boolean getStatusOfNameCategory(PossibleNames category) {return names.get(category);}

    public int getWinningValue() {
        return this.winningValue;
    }

    public void setWinningValue(int winningValue) {
        this.winningValue = winningValue;
    }
}
