package de.georgelsas.tuttocounter;

import android.app.AlertDialog;
import android.text.InputType;
import android.view.Window;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;

import androidx.core.content.ContextCompat;

public class SetWinningValueDialog extends ConfirmationDialogHelper {
    private final MainActivity context;

    public SetWinningValueDialog(MainActivity mainActivity) {
        super(mainActivity);
        this.context = mainActivity;
        
    
    }
    public void show(String titleResId,
                     Runnable checkForWinner,
                     int positiveButtonResId,
                     int negativeButtonResId,
                     int positiveColorResId,
                     int negativeColorResId,
                     int backgroundDrawableResId,
                     TuttoSettings tuttoSettings) {

        AlertDialog.Builder builder = new AlertDialog.Builder(context, R.style.RoundedAlertDialogTheme);
        builder.setTitle(titleResId);
        final EditText input = new EditText(context);
        input.setText(String.valueOf(tuttoSettings.getWinningValue()));
        input.setInputType(InputType.TYPE_CLASS_NUMBER);
        input.setHint(this.context.getString(R.string.set_value_for_winning_the_game));

        builder.setView(input);
        builder.setPositiveButton(positiveButtonResId, (dialog, which) -> {
            try {
                int winningValue = Integer.parseInt(input.getText().toString());
                tuttoSettings.setWinningValue(winningValue);
                if (checkForWinner != null ) {
                    checkForWinner.run();
                }
            } catch (NumberFormatException e) {
                Toast.makeText(this.context,
                        R.string.invalid_value,
                        Toast.LENGTH_SHORT).show();
            }

        });

        builder.setNegativeButton(negativeButtonResId, null);

        AlertDialog dialog = builder.create();
        dialog.show();

        Button positiveButton = dialog.getButton(AlertDialog.BUTTON_POSITIVE);
        Button negativeButton = dialog.getButton(AlertDialog.BUTTON_NEGATIVE);

        positiveButton.setTextColor(ContextCompat.getColor(context, positiveColorResId));
        negativeButton.setTextColor(ContextCompat.getColor(context, negativeColorResId));

        Window window = dialog.getWindow();
        if (window != null) {
            window.setBackgroundDrawable(ContextCompat.getDrawable(context, backgroundDrawableResId));
        }
    }
}
