package de.georgelsas.tuttocounter;

import android.app.Activity;
import android.text.InputType;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.appcompat.app.AlertDialog;
import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;

import com.skydoves.colorpickerview.ColorPickerDialog;
import com.skydoves.colorpickerview.listeners.ColorEnvelopeListener;

public class NameAndColorDialog {

    public static void showNameAndColorEditDialog(Activity activity,
                                                  CardManager cardManager,
                                                  CardItem card,
                                                  TextView nameTextView,
                                                  CardView cardView,
                                                  AddPointsDialog.OnCardsUpdatedListener listener,
                                                  int backgroundDrawableResId) {
        AlertDialog.Builder builder = new AlertDialog.Builder(activity, R.style.RoundedAlertDialogTheme);
        builder.setTitle(R.string.changeCard);

        LinearLayout dialogLayout = new LinearLayout(activity);
        dialogLayout.setOrientation(LinearLayout.VERTICAL);
        dialogLayout.setPadding(50, 40, 50, 10);

        EditText nameInput = new EditText(activity);
        nameInput.setText(card.getName());
        dialogLayout.addView(nameInput);

        EditText valueInput = new EditText(activity);
        valueInput.setHint(activity.getString(R.string.enter_value));
        valueInput.setInputType(InputType.TYPE_CLASS_NUMBER);
        valueInput.setText(String.valueOf(card.getNumber()));  // Falls vorhanden
        valueInput.setVisibility(View.GONE); // <- Anfangszustand: versteckt
        dialogLayout.addView(valueInput);

        // Button: "Wert ändern"
        Button showValueInputButton = new Button(activity);
        showValueInputButton.setText(R.string.change_value);
        dialogLayout.addView(showValueInputButton);

        showValueInputButton.setOnClickListener(v -> {
            // Sichtbarkeit togglen (einmalig anzeigen)
            valueInput.setVisibility(View.VISIBLE);
            showValueInputButton.setVisibility(View.GONE); // optional: Button ausblenden
        });

        Button colorPickerButton = new Button(activity);
        colorPickerButton.setText(R.string.selectColor);
        dialogLayout.addView(colorPickerButton);

        final int[] selectedColor = {card.getColor()};

        colorPickerButton.setOnClickListener(v -> {
            AlertDialog colorDialog = new ColorPickerDialog.Builder(activity)
                    .setTitle(activity.getString(R.string.colorpicker_dialog))
                    .setPreferenceName("MyColorPickerDialog")

                    .setPositiveButton(activity.getString(R.string.confirm),
                            (ColorEnvelopeListener) (envelope, fromUser) -> {
                                selectedColor[0] = envelope.getColor();
                                colorPickerButton.setBackgroundColor(selectedColor[0]);
                                colorPickerButton.setText(activity.getString(R.string.selectedColor));


                            })
                    .setNegativeButton(activity.getString(R.string.cancel),
                            (dialogInterface, i) -> dialogInterface.dismiss())
                    .attachAlphaSlideBar(true) // the default value is true.
                    .attachBrightnessSlideBar(true)  // the default value is true.
                    .setBottomSpace(12) // set a bottom space between the last slidebar and buttons.
                    .create();

            colorDialog.show();

            // Runde Ecken setzen
            Window window = colorDialog.getWindow();
            if (window != null) {
                window.setBackgroundDrawable(ContextCompat.getDrawable(activity, R.drawable.dialog_background));
            }
        });

        colorPickerButton.setBackgroundColor(selectedColor[0]);


        builder.setView(dialogLayout);

        builder.setPositiveButton(R.string.saveButton, (dialog, which) -> {
            card.setName(nameInput.getText().toString());
            card.setColor(selectedColor[0]);
            nameTextView.setText(card.getName());
            cardView.setCardBackgroundColor(selectedColor[0]);
            if (valueInput.getVisibility() == View.VISIBLE) {
                try {
                    int value = Integer.parseInt(
                            valueInput.getText().toString());
                    card.setNumber(value);
                    listener.onCardsUpdated();
                } catch (NumberFormatException e) {
                    Toast.makeText(activity,
                            R.string.invalid_value,
                            Toast.LENGTH_SHORT).show();
                }
            }
        });

        builder.setNegativeButton(R.string.abortButton, null);

        Button deleteButton = new Button(activity);
        deleteButton.setText(R.string.delete_card);
        AlertDialog dialog = builder.create();
        deleteButton.setTextColor(ContextCompat.getColor(activity, R.color.my_delete_color));

        Window window = dialog.getWindow();
        if (window != null) {
            window.setBackgroundDrawable(ContextCompat.getDrawable(activity, backgroundDrawableResId));
        }

        dialog.show();
        dialogLayout.addView(deleteButton);
        Button positiveButton = dialog.getButton(AlertDialog.BUTTON_POSITIVE); // TODO kann weg, oder?

        deleteButton.setOnClickListener(v -> {

            ConfirmationDialogHelper dialogHelper = new ConfirmationDialogHelper(activity);

            dialogHelper.show(
                    activity.getString(R.string.delete_card_message, card.getName()),
                    () -> {
                        cardManager.removeCard(card);
                        listener.onCardsUpdated();
                        dialog.dismiss();
                    },
                    R.string.confirm,
                    R.string.abortButton,
                    R.color.my_positive_color,
                    R.color.my_negative_color,
                    R.drawable.dialog_background
            );
        });
    }

}
