package de.georgelsas.tuttocounter;

import java.util.List;

/**
 * Represents an item in the card history, containing a snapshot of all card items at a specific timestamp.
 */
public class CardHistoryItem {
    private List<CardItem> cardItems;  // A copy of the cards at this point in time.
    private long timestamp;            // The timestamp when this history entry was created.

    public CardHistoryItem(List<CardItem> cardItems, long timestamp) {
        this.cardItems = cardItems;
        this.timestamp = timestamp;
    }

    public List<CardItem> getCardItems() {
        return cardItems;
    }

    public long getTimestamp() {
        return timestamp;
    }
}
