package de.georgelsas.tuttocounter;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.view.Gravity;
import android.view.HapticFeedbackConstants;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.NumberPicker;
import android.widget.TextView;

import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;

import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.google.android.material.slider.LabelFormatter;
import com.google.android.material.slider.Slider;
import com.king.view.arcseekbar.ArcSeekBar;

import java.util.List;

public class AddPointsDialog {


    public interface OnCardsUpdatedListener {
        void onCardsUpdated();
    }

    public static void showEditDialog(Activity activity,
                                      CardItem cardItem,
                                      TextView numberTextView,
                                      CardManager cardManager,
                                      OnCardsUpdatedListener listener) {
        // here one could use another input
        showEditDialogArcKnob(activity,cardItem, numberTextView, cardManager, listener);
        // showEditDialogWithNumberPicker(activity,cardItem, numberTextView, cardManager, listener);
        // showEditDialogWithCustomSlider(activity,cardItem, numberTextView, cardManager, listener);
    }

    @SuppressLint("ClickableViewAccessibility")
    public static void showEditDialogWithNumberPicker(Activity activity,
                                      CardItem cardItem,
                                      TextView numberTextView,
                                      CardManager cardManager,
                                      OnCardsUpdatedListener listener) {

        View dialogView = LayoutInflater.from(activity).inflate(R.layout.dialog_edit_number, null);




        Button confirmButton = dialogView.findViewById(R.id.confirm_button);
        TextView valueText = dialogView.findViewById(R.id.dialog_title);
        final int[] selectedValue = {0};


        LinearLayout wrapper = dialogView.findViewById(R.id.picker_button_wrapper);
        LinearLayout.LayoutParams paramsButton = (LinearLayout.LayoutParams) confirmButton.getLayoutParams();
        int orientation = activity.getResources().getConfiguration().orientation;

        if (orientation == Configuration.ORIENTATION_LANDSCAPE) {
            wrapper.setOrientation(LinearLayout.HORIZONTAL);
            // NumberPicker nimmt Platz links, Button am rechten Ende
            paramsButton.setMargins(16, 0, 0, 0); // minimaler Abstand links
            paramsButton.width = LinearLayout.LayoutParams.WRAP_CONTENT;
            confirmButton.setLayoutParams(paramsButton);
            // Füge Spacer zwischen NumberPicker und Button, damit Button ans Ende wandert
            wrapper.setGravity(Gravity.CENTER_VERTICAL);
            wrapper.setHorizontalGravity(Gravity.END);
        } else {
            wrapper.setOrientation(LinearLayout.VERTICAL);
            paramsButton.setMargins(0, 16, 0, 0);
            confirmButton.setLayoutParams(paramsButton);
            wrapper.setGravity(Gravity.CENTER_HORIZONTAL);
        }

        Slider slider = dialogView.findViewById(R.id.mode_slider);

        final int[] selectedMode = {0};

        MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(activity)
                .setView(dialogView)
                .setCancelable(true);
        AlertDialog dialog = builder.create();

        confirmButton.setOnClickListener(v -> {
            int mode = selectedMode[0];
            if (mode == 1) {
                // Fall: "+/- 1000" → Alle mit Maximalwert anpassen
                List<CardItem> allCards = cardManager.getCardItems();

                // Max-Wert finden
                int max = Integer.MIN_VALUE;
                for (CardItem card : allCards) {
                    if (card.getNumber() > max) {
                        max = card.getNumber();
                    }
                }

                // Alle mit Max-Wert anpassen
                for (CardItem card : allCards) {
                    if (card.getNumber() == max && card.getIndex() != cardItem.getIndex()) {
                        int newVal = Math.max(0, card.getNumber() - selectedValue[0]);
                        cardManager.updateCardNumber(card.getIndex(), newVal);
                    }
                }



            }

            int newValue = cardItem.getNumber() + selectedValue[0];
            cardManager.updateCardNumber(cardItem.getIndex(), newValue);
            cardManager.addHistorySnapshot();
            cardManager.saveCards();              // erst jetzt!
            listener.onCardsUpdated();


            dialog.dismiss();
        });


        NumberPicker numberPicker = dialogView.findViewById(R.id.number_picker);

// Werte von 0 bis 2000 in 50er-Schritten
        String[] values = new String[41];
        for (int i = 0; i <= 40; i++) {
            values[i] = String.valueOf(i * 50);
        }
        numberPicker.setMinValue(0);
        numberPicker.setMaxValue(values.length - 1);
        numberPicker.setDisplayedValues(values);
        numberPicker.setValue((int) (selectedValue[0] / 50));
        numberPicker.setWrapSelectorWheel(false);

// Listener für Picker
        numberPicker.setOnValueChangedListener((picker, oldVal, newVal) -> {
            selectedValue[0] = newVal * 50;
            valueText.setText(activity.getString(R.string.points_dynamic) + selectedValue[0]);
        });

// Slider-Modus
        String[] labels = {activity.getString(R.string.free_input),
                activity.getString(R.string.plusMinus1000),
                activity.getString(R.string.street)};
        slider.setValueFrom(0);
        slider.setValueTo(2);
        slider.setStepSize(1);
        slider.setLabelBehavior(LabelFormatter.LABEL_FLOATING);
        slider.setLabelFormatter(value -> labels[Math.round(value)]);

        slider.addOnChangeListener((s, value, fromUser) -> {
            int mode = Math.round(value);
            selectedMode[0] = mode;

            switch (mode) {
                case 0:
                    // NumberPicker aktivieren
                    numberPicker.setEnabled(true);
                    numberPicker.setAlpha(1.0f);
                    selectedValue[0] = numberPicker.getValue() * 50;
                    break;

                case 1:
                    // NumberPicker deaktivieren + Textfeld auf 1000 setzen
                    numberPicker.setEnabled(false);
                    numberPicker.setAlpha(0.4f);
                    selectedValue[0] = 1000;
                    break;

                case 2:
                    // NumberPicker deaktivieren + Textfeld auf 2000 setzen
                    numberPicker.setEnabled(false);
                    numberPicker.setAlpha(0.4f);
                    selectedValue[0] = 2000;
                    break;
            }
            valueText.setText(activity.getString(R.string.points_dynamic) + selectedValue[0]);
        });

        dialog.show();
    }

    public static void showEditDialogWithCustomSlider(Activity activity,
                                                      CardItem cardItem,
                                                      TextView numberTextView,
                                                      CardManager cardManager,
                                                      OnCardsUpdatedListener listener) {
            View dialogView = LayoutInflater.from(activity).inflate(R.layout.dialog_edit_number_knob, null);

            Slider customKnob = dialogView.findViewById(R.id.custom_knob);
            Slider modeSlider = dialogView.findViewById(R.id.mode_slider);
            Button confirmButton = dialogView.findViewById(R.id.confirm_button);
            TextView valueText = dialogView.findViewById(R.id.dialog_title);

            // Initialwerte
            final int[] selectedValue = { (int) customKnob.getValue() };
            final int[] selectedMode = {0};

            // Farben programmgesteuert setzen (statt in XML)
            customKnob.setThumbTintList(ColorStateList.valueOf(
                    ContextCompat.getColor(activity, android.R.color.holo_blue_light)));
            customKnob.setHaloTintList(ColorStateList.valueOf(
                    ContextCompat.getColor(activity, android.R.color.holo_blue_bright)));
            customKnob.setTrackActiveTintList(ColorStateList.valueOf(
                    ContextCompat.getColor(activity, android.R.color.holo_blue_dark)));
            customKnob.setTrackInactiveTintList(ColorStateList.valueOf(
                    ContextCompat.getColor(activity, android.R.color.darker_gray)));

            // Titel setzen
            String title = activity.getString(R.string.points_dynamic) + selectedValue[0];
            valueText.setText(title);

            MaterialAlertDialogBuilder builder = new MaterialAlertDialogBuilder(activity)
                    .setView(dialogView)
                    .setCancelable(true);
            AlertDialog dialog = builder.create();

            // --- Save Button ---
            confirmButton.setOnClickListener(v -> {
                int mode = selectedMode[0];
                if (mode == 1) {
                    // Fall: "+/- 1000" → Alle mit Maximalwert anpassen
                    List<CardItem> allCards = cardManager.getCardItems();

                    int max = Integer.MIN_VALUE;
                    for (CardItem card : allCards) {
                        if (card.getNumber() > max) {
                            max = card.getNumber();
                        }
                    }

                    for (CardItem card : allCards) {
                        if (card.getNumber() == max && card.getIndex() != cardItem.getIndex()) {
                            int newVal = Math.max(0, card.getNumber() - selectedValue[0]);
                            cardManager.updateCardNumber(card.getIndex(), newVal);
                        }
                    }
                }

                int newValue = cardItem.getNumber() + selectedValue[0];
                cardManager.updateCardNumber(cardItem.getIndex(), newValue);
                cardManager.addHistorySnapshot();
                cardManager.saveCards();
                listener.onCardsUpdated();

                dialog.dismiss();
            });

            // --- CustomKnob Listener ---
            customKnob.addOnChangeListener((slider, value, fromUser) -> {
                selectedValue[0] = (int) value;
                String newText = activity.getString(R.string.points_dynamic) + selectedValue[0];
                valueText.setText(newText);

                if (fromUser) {
                    slider.performHapticFeedback(HapticFeedbackConstants.VIRTUAL_KEY);
                }
            });

            // --- Mode Slider ---
            String[] labels = {
                    activity.getString(R.string.free_input),
                    activity.getString(R.string.plusMinus1000),
                    activity.getString(R.string.street)
            };

            modeSlider.setLabelFormatter(value -> labels[Math.round(value)]);

            modeSlider.addOnChangeListener((s, value, fromUser) -> {
                int position = Math.round(value);
                selectedMode[0] = position;
                switch (position) {
                    case 0:
                        // Free input
                        customKnob.setEnabled(true);
                        customKnob.setAlpha(1.0f);
                        selectedValue[0] = (int) customKnob.getValue();
                        break;
                    case 1:
                        // Fix 1000
                        customKnob.setEnabled(false);
                        customKnob.setAlpha(0.4f);
                        selectedValue[0] = 1000;
                        break;
                    case 2:
                        // Fix 2000
                        customKnob.setEnabled(false);
                        customKnob.setAlpha(0.4f);
                        selectedValue[0] = 2000;
                        break;
                }
                String newText = activity.getString(R.string.points_dynamic) + selectedValue[0];
                valueText.setText(newText);
            });

            dialog.show();
        }
    @SuppressLint("ClickableViewAccessibility")
    public static void showEditDialogArcKnob(Activity activity,
                                             CardItem cardItem,
                                             TextView numberTextView,
                                             CardManager cardManager,
                                             OnCardsUpdatedListener listener) {
        View dialogView = LayoutInflater.from(activity)
                .inflate(R.layout.dialog_edit_number_arc_knob, null);
        Slider modeSlider = dialogView.findViewById(R.id.mode_slider);
        ArcSeekBar arcSeekBar = dialogView.findViewById(R.id.arcSeekBar);
        Button confirmButton = dialogView.findViewById(R.id.confirm_button);
        TextView valueText = dialogView.findViewById(R.id.dialog_title);

        final int[] selectedValue = {0};
        final int[] selectedMode = {0};

        // set startvalue
        int startvalue = 350;
        arcSeekBar.setProgress(startvalue);
        selectedValue[0] = startvalue;

        // set the text on the top
        valueText.setText(activity.getString(R.string.points_dynamic) + selectedValue[0]);

        // set the bottom text to the progress
        String initialPointsText = activity.getString(R.string.points_dynamic) + arcSeekBar.getProgress();
        arcSeekBar.setLabelText(initialPointsText);

        arcSeekBar.setOnChangeListener(new ArcSeekBar.OnChangeListener() {
            @Override
            public void onProgressChanged(float progress, float max, boolean fromUser) {
                // progress ist ein Float, also ggf. runden
                int roundedValue = Math.round(progress / 50) * 50;
                selectedValue[0] = roundedValue;

                String pointsText = activity.getString(R.string.points_dynamic) + selectedValue[0];
                valueText.setText(pointsText);
                arcSeekBar.setLabelText(pointsText);
                if (fromUser && roundedValue != Math.round(progress)) {
                    arcSeekBar.setProgress(roundedValue);
                }
            }

            @Override
            public void onStartTrackingTouch(boolean isTouch) {
                if (isTouch) {
                    arcSeekBar.performHapticFeedback(HapticFeedbackConstants.VIRTUAL_KEY);
                }
            }

            @Override
            public void onStopTrackingTouch(boolean isTouch) {
                // hier könntest du speichern oder anderes tun
            }

            @Override
            public void onSingleTapUp() {

            }
        });



        String[] labels = {
                activity.getString(R.string.free_input),
                activity.getString(R.string.plusMinus1000),
                activity.getString(R.string.street)
        };
        modeSlider.setLabelFormatter(val -> labels[Math.round(val)]);
        modeSlider.addOnChangeListener((s, value, fromUser) -> {
            selectedMode[0] = Math.round(value);
            switch (selectedMode[0]) {
                case 0:
                    arcSeekBar.setEnabled(true);
                    arcSeekBar.setAlpha(1f);
                    break;
                case 1:
                    arcSeekBar.setEnabled(false);
                    arcSeekBar.setAlpha(0.4f);
                    selectedValue[0] = 1000;
                    break;
                case 2:
                    arcSeekBar.setEnabled(false);
                    arcSeekBar.setAlpha(0.4f);
                    selectedValue[0] = 2000;
                    break;
            }
            valueText.setText(activity.getString(R.string.points_dynamic) + selectedValue[0]);
        });

        AlertDialog dialog = new MaterialAlertDialogBuilder(activity)
                .setView(dialogView)
                .setCancelable(true)
                .create();

        confirmButton.setOnClickListener(v -> {
            if (selectedMode[0] == 1) {
                int max = cardManager.getCardItems().stream().mapToInt(CardItem::getNumber).max().orElse(0);
                for (CardItem card : cardManager.getCardItems()) {
                    if (card.getNumber() == max && card.getIndex() != cardItem.getIndex()) {
                        cardManager.updateCardNumber(card.getIndex(), Math.max(0, card.getNumber() - selectedValue[0]));
                    }
                }
            }
            int newValue = cardItem.getNumber() + selectedValue[0];
            cardManager.updateCardNumber(cardItem.getIndex(), newValue);
            cardManager.addHistorySnapshot();
            cardManager.saveCards();
            listener.onCardsUpdated();
            dialog.dismiss();
        });

        dialog.show();
    }

}
