package de.georgelsas.tuttocounter;

import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.widget.Button;

import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;

public class SettingsDialog {

    public SettingsDialog() {
    }

    public static void show(MainActivity context, int backgroundDrawableResId) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle(R.string.settings);
        View view = LayoutInflater.from(context).inflate(R.layout.settings_dialog, null);

        Button setWinningValueButton = view.findViewById(R.id.setWinningValueButton);
        setWinningValueButton.setOnClickListener(view2 -> context.setWinningValue());

        Button setPossibleNamesButton = view.findViewById(R.id.setPossibleNamesButton);
        setPossibleNamesButton.setOnClickListener(view1 -> context.setPossibleNames());

        builder.setView(view);
        builder.setPositiveButton(context.getText(R.string.close), null);
        AlertDialog dialog = builder.create();

        dialog.show();
        Window window = dialog.getWindow();
        if (window != null) {
            window.setBackgroundDrawable(ContextCompat.getDrawable(context, backgroundDrawableResId));
        }
    }
}
