package de.georgelsas.tuttocounter;

import android.app.AlertDialog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.Toast;

import androidx.core.content.ContextCompat;

import com.google.android.material.chip.Chip;

public class SetPossibleNamesDialog extends ConfirmationDialogHelper {
    private final MainActivity context;

    public SetPossibleNamesDialog(MainActivity mainActivity) {
        super(mainActivity);
        this.context = mainActivity;
        
    
    }

    public void show(String titleResId,
                     Runnable reloadNameManager,
                     int positiveButtonResId,
                     int negativeButtonResId,
                     int positiveColorResId,
                     int negativeColorResId,
                     int backgroundDrawableResId,
                     TuttoSettings tuttoSettings) {

        AlertDialog.Builder builder = new AlertDialog.Builder(context, R.style.RoundedAlertDialogTheme);
        View possible_names_dialog = LayoutInflater.from(context).inflate(R.layout.possible_names_dialog, null);
        builder.setView(possible_names_dialog);
        builder.setTitle(titleResId);
        adaptChip(tuttoSettings, possible_names_dialog.findViewById(R.id.animalChip),
                R.string.animals, TuttoSettings.PossibleNames.ANIMALS);
        adaptChip(tuttoSettings, possible_names_dialog.findViewById(R.id.fruitsChip),
                R.string.fruits, TuttoSettings.PossibleNames.FRUITS);
        adaptChip(tuttoSettings, possible_names_dialog.findViewById(R.id.vegetablesChip),
                R.string.vegetables, TuttoSettings.PossibleNames.VEGETABLES);
        adaptChip(tuttoSettings, possible_names_dialog.findViewById(R.id.citiesChip),
                R.string.cities, TuttoSettings.PossibleNames.CITIES);
        adaptChip(tuttoSettings, possible_names_dialog.findViewById(R.id.countriesChip),
                R.string.countries, TuttoSettings.PossibleNames.COUNTRIES);
        adaptChip(tuttoSettings, possible_names_dialog.findViewById(R.id.carsChip),
                R.string.cars, TuttoSettings.PossibleNames.CARS);
        adaptChip(tuttoSettings, possible_names_dialog.findViewById(R.id.sportsChip),
                R.string.sports, TuttoSettings.PossibleNames.SPORTS);
        builder.setPositiveButton(positiveButtonResId, (dialog, which) -> {

            Toast.makeText(this.context,
                    R.string.saved,
                    Toast.LENGTH_SHORT).show();
            tuttoSettings.savePossibleNamesStatus();
            reloadNameManager.run();
        });

        builder.setNegativeButton(negativeButtonResId, null);

        AlertDialog dialog = builder.create();
        dialog.show();

        Button positiveButton = dialog.getButton(AlertDialog.BUTTON_POSITIVE);
        Button negativeButton = dialog.getButton(AlertDialog.BUTTON_NEGATIVE);

        positiveButton.setTextColor(ContextCompat.getColor(context, positiveColorResId));
        negativeButton.setTextColor(ContextCompat.getColor(context, negativeColorResId));

        Window window = dialog.getWindow();
        if (window != null) {
            window.setBackgroundDrawable(ContextCompat.getDrawable(context, backgroundDrawableResId));
        }
    }

    private static void adaptChip(TuttoSettings tuttoSettings, Chip animalChip, int nameString, TuttoSettings.PossibleNames possibleName) {
        if (tuttoSettings.getStatusOfNameCategory(possibleName)) {
            animalChip.setChecked(true);
            animalChip.setChipBackgroundColorResource(R.color.my_positive_color);
        } else {
            animalChip.setChecked(false);
            animalChip.setChipBackgroundColorResource(R.color.my_negative_color);
        }
        animalChip.setText(nameString);
        animalChip.setCheckable(true);
        animalChip.setOnClickListener(view -> {
            if (animalChip.isChecked()){
                animalChip.setChipBackgroundColorResource(R.color.my_positive_color);
            } else {
                animalChip.setChipBackgroundColorResource(R.color.my_negative_color);
            }

            tuttoSettings.setStatusOfNameCategory(
                    possibleName,!tuttoSettings.getStatusOfNameCategory(possibleName));
        });
    }
}
