package de.georgelsas.tuttocounter;

import android.app.AlertDialog;
import android.content.Context;
import android.view.Window;
import android.widget.Button;

import androidx.core.content.ContextCompat;

public class ConfirmationDialogHelper {

    private final Context context;

    public ConfirmationDialogHelper(Context context) {
        this.context = context;
    }

    public void show(String titleResId,
                     Runnable onConfirmAction,
                     int positiveButtonResId,
                     int negativeButtonResId,
                     int positiveColorResId,
                     int negativeColorResId,
                     int backgroundDrawableResId) {

        AlertDialog.Builder builder = new AlertDialog.Builder(context, R.style.RoundedAlertDialogTheme);
        builder.setTitle(titleResId);

        builder.setPositiveButton(positiveButtonResId, (dialog, which) -> {
            if (onConfirmAction != null) {
                onConfirmAction.run();
            }
        });

        builder.setNegativeButton(negativeButtonResId, null);

        AlertDialog dialog = builder.create();
        dialog.show();

        Button positiveButton = dialog.getButton(AlertDialog.BUTTON_POSITIVE);
        Button negativeButton = dialog.getButton(AlertDialog.BUTTON_NEGATIVE);

        positiveButton.setTextColor(ContextCompat.getColor(context, positiveColorResId));
        negativeButton.setTextColor(ContextCompat.getColor(context, negativeColorResId));

        Window window = dialog.getWindow();
        if (window != null) {
            window.setBackgroundDrawable(ContextCompat.getDrawable(context, backgroundDrawableResId));
        }
    }
}
