package de.georgelsas.tuttocounter;

import java.util.Objects;
import java.util.UUID;

public class CardItem {
    private final String id;
    private String name;
    private int number;
    private int color;
    private int index;

    public CardItem(String id, String name, int number, int color, int index) {
        this.id = id;
        this.name = name;
        this.number = number;
        this.color = color;
        this.index = index;
    }

    public CardItem(String name, int number, int color, int index) {
        this(UUID.randomUUID().toString(), name, number, color, index);
    }

    public String getId() {
        return id;
    }

    // Getter und Setter für Name und Zahl
    public String getName() {
        return name.trim();
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getNumber() {
        return number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public int getColor() {
        return color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }


    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null || getClass() != obj.getClass()) return false;
        CardItem other = (CardItem) obj;
        return id.equals(other.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }
}
