plugins {
    id("com.android.application") version "8.11.2"
    id("com.mikepenz.aboutlibraries.plugin") version "12.2.4"
    id("org.jetbrains.kotlin.android") version "2.2.20"
    id("de.mannodermaus.android-junit5") version "1.13.4.0"
}

repositories {
    mavenCentral()
    google()
}

android {

    compileSdk = 36
    namespace = "de.freewarepoint.whohasmystuff"

    defaultConfig {
        applicationId = "de.freewarepoint.whohasmystuff"
        minSdk = 26
        targetSdk = 36
        versionCode = 43
        versionName = "1.1.3"
    }

    if (project.hasProperty("RELEASE_STORE_FILE")) {
        signingConfigs.create("release") {
            storeFile = file(property("RELEASE_STORE_FILE") as String)
            storePassword = property("RELEASE_STORE_PASSWORD") as String
            keyAlias = property("RELEASE_KEY_ALIAS") as String
            keyPassword = property("RELEASE_KEY_PASSWORD") as String
        }
    }

    buildTypes.named("release") {
        isMinifyEnabled = false
        if (project.hasProperty("RELEASE_STORE_FILE")) {
        }
    }

    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_21
        targetCompatibility = JavaVersion.VERSION_21
    }

    lint {
        abortOnError = false
    }

    dependencies {
        implementation("androidx.fragment:fragment-ktx:1.8.9")
        implementation("com.mikepenz:aboutlibraries:12.2.4")
        testImplementation("org.junit.jupiter:junit-jupiter-api:5.13.4")
        testRuntimeOnly("org.junit.platform:junit-platform-launcher:1.13.4")
        testImplementation("org.assertj:assertj-core:3.27.6")
        testImplementation("org.mockito:mockito-junit-jupiter:5.20.0")
    }
}