// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Portuguese (`pt`).
class AppLocalizationsPt extends AppLocalizations {
  AppLocalizationsPt([String locale = 'pt']) : super(locale);

  @override
  String get loginToCalibreWb => 'Login no Calibre Web';

  @override
  String get calibreWebUrl => 'https://calibre.exemplo.com';

  @override
  String get enterCalibreWebUrl => 'Insira a URL do Calibre Web';

  @override
  String get username => 'Nome de usuário';

  @override
  String get enterYourUsername => 'Insira seu nome de usuário';

  @override
  String get password => 'Senha';

  @override
  String get enterYourPassword => 'Insira sua senha';

  @override
  String get login => 'Entrar';

  @override
  String get pleaseFillInAllFields => 'Por favor, preencha todos os campos';

  @override
  String get failedToLognIn => 'Falha ao fazer login';

  @override
  String get books => 'Livros';

  @override
  String get discover => 'Descobrir';

  @override
  String get me => 'Eu';

  @override
  String get discoverBooks => 'Descobrir livros';

  @override
  String get search => 'Pesquisar';

  @override
  String get searchBook => 'Pesquisar livro';

  @override
  String get enterTitleAuthorOrTags => 'Insira título, autor ou tags ...';

  @override
  String get showReadBooks => 'Mostrar livros lidos';

  @override
  String get showUnReadBooks => 'Mostrar livros não lidos';

  @override
  String get showBookmarkedBooks => 'Mostrar livros favoritos';

  @override
  String get readBooks => 'Livros lidos';

  @override
  String get unreadBooks => 'Livros não lidos';

  @override
  String get bookmarkedBooks => 'Livros favoritos';

  @override
  String get showHotBooks => 'Mostrar livros populares';

  @override
  String get hotBooks => 'Livros populares';

  @override
  String get showNewBooks => 'Mostrar novos livros';

  @override
  String get newBooks => 'Novos livros';

  @override
  String get showRatedBooks => 'Mostrar livros avaliados';

  @override
  String get ratedBooks => 'Livros avaliados';

  @override
  String get titleAZ => 'Título (A-Z)';

  @override
  String get titleZA => 'Título (Z-A)';

  @override
  String get authorAZ => 'Autor (A-Z)';

  @override
  String get authorZA => 'Autor (Z-A)';

  @override
  String get newestFirst => 'Mais recentes primeiro';

  @override
  String get oldestFirst => 'Mais antigos primeiro';

  @override
  String get authors => 'Autores';

  @override
  String get categories => 'Categorias';

  @override
  String get series => 'Séries';

  @override
  String get formats => 'Formatos';

  @override
  String get languages => 'Idiomas';

  @override
  String get publishers => 'Editoras';

  @override
  String get ratings => 'Avaliações';

  @override
  String get rating => 'Avaliação';

  @override
  String get showAuthors => 'Mostrar autores';

  @override
  String get showCategories => 'Mostrar categorias';

  @override
  String get showSeries => 'Mostrar séries';

  @override
  String get showFormats => 'Mostrar formatos';

  @override
  String get showLanguages => 'Mostrar idiomas';

  @override
  String get showPublishers => 'Mostrar editoras';

  @override
  String get showRatings => 'Mostrar avaliações';

  @override
  String by(Object author) {
    return 'por $author';
  }

  @override
  String get book => 'Livro';

  @override
  String get publicationInfo => 'Informações da publicação';

  @override
  String get published => 'Publicado';

  @override
  String get updated => 'Atualizado';

  @override
  String get publisher => 'Editora';

  @override
  String get language => 'Idioma';

  @override
  String get fileInfo => 'Informações do arquivo';

  @override
  String get size => 'Tamanho';

  @override
  String get description => 'Descrição';

  @override
  String get noCoverAvailable => 'Capa não disponível';

  @override
  String get english => 'Inglês';

  @override
  String get german => 'Alemão';

  @override
  String get french => 'Francês';

  @override
  String get spanish => 'Espanhol';

  @override
  String get italian => 'Italiano';

  @override
  String get japanese => 'Japonês';

  @override
  String get russian => 'Russo';

  @override
  String get portuguese => 'Português';

  @override
  String get chineese => 'Chinês';

  @override
  String get dutch => 'Holandês';

  @override
  String get sendToEReader => 'Enviar para E-Reader';

  @override
  String get sendToKindleKobo => 'Enviar para Kindle/Kobo';

  @override
  String get enter4DigitCode => 'Insira o código de 4 dígitos exibido no navegador do seu E-Reader:';

  @override
  String get visit => 'Visite';

  @override
  String get onYourEReader => 'no seu E-Reader para obter um código';

  @override
  String get pleaseEnter4DigitCode => 'Por favor, insira um código válido de 4 dígitos';

  @override
  String get send => 'Enviar';

  @override
  String get startingDownloadProcess => 'Iniciando processo de download';

  @override
  String get preparingTransfer => 'Preparando transferência...';

  @override
  String get downloadingBook => 'Baixando livro...';

  @override
  String get sendingToEReader => 'Enviando para E-Reader...';

  @override
  String get successfullySentToEReader => 'Enviado com sucesso para o E-Reader';

  @override
  String get transferFailed => 'Transferência falhou';

  @override
  String get downloadToDevice => 'Baixar para o dispositivo';

  @override
  String get errorDownloading => 'Erro ao baixar';

  @override
  String get downlaodFomat => 'Formato de download';

  @override
  String get preparingDownload => 'Preparando download...';

  @override
  String get selectDownloadDestination => 'Selecione o destino do download';

  @override
  String get successfullyDownloadedBook => 'Livro baixado com sucesso';

  @override
  String get downloadFailed => 'Download falhou';

  @override
  String get libraryStatistics => 'Estatísticas da biblioteca';

  @override
  String get cancel => 'Cancelar';

  @override
  String get close => 'Fechar';

  @override
  String get retry => 'Tentar novamente';

  @override
  String get tryAgain => 'Tente novamente';

  @override
  String get error => 'Erro';

  @override
  String get errorLoadingBooks => 'Erro ao carregar livros';

  @override
  String get errorLoadingData => 'Erro ao carregar dados';

  @override
  String get erroLoadingBookDetails => 'Erro ao carregar detalhes do livro';

  @override
  String get noBooksFound => 'Nenhum livro encontrado';

  @override
  String get noDataFound => 'Nenhum dado encontrado';

  @override
  String get unknownError => 'Erro desconhecido';

  @override
  String get loading => 'Carregando...';

  @override
  String get settings => 'Configurações';

  @override
  String get appearance => 'Aparência';

  @override
  String get about => 'Sobre';

  @override
  String get themeMode => 'Modo do tema';

  @override
  String get systemTheme => 'Tema do sistema';

  @override
  String get lightTheme => 'Tema claro';

  @override
  String get darkTheme => 'Tema escuro';

  @override
  String get downloadService => 'Serviço de download';

  @override
  String get downloads => 'Downloads';

  @override
  String get searchForABook => 'Pesquisar por um livro';

  @override
  String get noDownloadsFound => 'Nenhum download encontrado';

  @override
  String foundBooks(Object count) {
    return 'Encontrado(s) $count livro(s)';
  }

  @override
  String get addedBookToTheDownloadQueue => 'Livro adicionado à fila de download';

  @override
  String get download => 'Baixar';

  @override
  String get available => 'Disponível';

  @override
  String get downloading => 'Baixando';

  @override
  String get completed => 'Concluído';

  @override
  String get failed => 'Falhou';

  @override
  String get queued => 'Na fila';

  @override
  String get notDownloaded => 'Não baixado';

  @override
  String get downloadServiceUrl => 'URL do serviço de download';

  @override
  String get enterUrlOfYourDownloadService => 'Insira a URL do seu serviço de download';

  @override
  String get bookWillBeSendToYourEmailAdress => 'O livro será enviado como EPUB para seu endereço de e-mail registrado.';

  @override
  String get makeSureEmailSettingsAreConfigured => 'Certifique-se de que as configurações de e-mail SMTP estejam configuradas no servidor.';

  @override
  String get markAsReadUnread => 'Marcar como lido/não lido';

  @override
  String get archiveUnarchive => 'Arquivar/Desarquivar';

  @override
  String get addToShelf => 'Adicionar à estante';

  @override
  String get selectShelf => 'Selecionar estante';

  @override
  String get noShelvesFound => 'Nenhuma estante encontrada';

  @override
  String bookAddedToShelf(Object book) {
    return 'Livro adicionado à estante $book';
  }

  @override
  String get failedToAddToShelf => 'Falha ao adicionar à estante';

  @override
  String bookRemovedFromShelf(Object book) {
    return 'Livro removido da estante $book';
  }

  @override
  String get failedToRemoveFromShelf => 'Falha ao remover livro da estante';

  @override
  String get removeFromShelf => 'Remover';

  @override
  String get shelfs => 'Estantes';

  @override
  String shelfContains(Object count) {
    return 'A estante contém $count livros';
  }

  @override
  String get errorLoadingShelf => 'Erro ao carregar estante';

  @override
  String get createShelf => 'Criar estante';

  @override
  String get shelfName => 'Nome da estante';

  @override
  String get shelfNameRequired => 'O nome da estante é obrigatório';

  @override
  String get shelfSuccessfullyCreated => 'Estante criada com sucesso';

  @override
  String errorCreatingShelf(Object name) {
    return 'Erro ao criar estante $name';
  }

  @override
  String get create => 'Criar';

  @override
  String get creating => 'Criando';

  @override
  String get noShelvesFoundCreateOne => 'Nenhuma estante encontrada. Crie uma!';

  @override
  String get editShelf => 'Editar estante';

  @override
  String get deleteShelf => 'Excluir estante';

  @override
  String get bookOptions => 'Opções do livro';

  @override
  String get successfullyDeletedShelf => 'Estante excluída com sucesso';

  @override
  String get failedToDeleteShelf => 'Falha ao excluir estante';

  @override
  String get delete => 'Excluir';

  @override
  String get deleting => 'Excluindo';

  @override
  String get successfullyEditedShelf => 'Estante editada com sucesso';

  @override
  String get failedToEditShelf => 'Falha ao editar estante';

  @override
  String get edit => 'Editar';

  @override
  String get editing => 'Editando';

  @override
  String deleteShelfConfirmation(Object name) {
    return 'Tem certeza de que deseja excluir a estante $name?';
  }

  @override
  String get addBooksToShelf => 'Adicionar livros à estante';

  @override
  String get shelfIsEmpty => 'A estante está vazia';

  @override
  String get removing => 'Removendo';

  @override
  String get manageBookShelves => 'Gerenciar estantes de livros';

  @override
  String bookInShelfs(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count estantes',
      one: 'uma estante',
    );
    return 'Livro em $_temp0';
  }

  @override
  String get searchForBooks => 'Pesquisar por livros';

  @override
  String get connectionSettings => 'Configurações de conexão';

  @override
  String get costumHttpPHeader => 'Cabeçalho HTTP personalizado';

  @override
  String get addHeader => 'Adicionar cabeçalho';

  @override
  String get httpHeader => 'Cabeçalho HTTP';

  @override
  String get addACostumHttpHeaderThatWillBeSentWithEveryRequest => 'Adicione um cabeçalho HTTP personalizado que será enviado com cada solicitação';

  @override
  String get noCostumHttpHeadersYet => 'Nenhum cabeçalho HTTP personalizado ainda';

  @override
  String get header => 'Cabeçalho';

  @override
  String get headerKey => 'Chave do cabeçalho';

  @override
  String get headerValue => 'Valor do cabeçalho';

  @override
  String get deleteHeader => 'Excluir cabeçalho';

  @override
  String get urlMustStartWithHttpOrHttps => 'A URL deve começar com http:// ou https://';

  @override
  String get connection => 'Conexão';

  @override
  String get httpHeaderSettings => 'Configurações de autenticação';

  @override
  String get feedback => 'Feedback';

  @override
  String get reportIssue => 'Reportar problema';

  @override
  String get reportAppIssueOrSuggestFeature => 'Reportar problema no app ou sugerir recurso';

  @override
  String get title => 'Título';

  @override
  String get required => 'Obrigatório';

  @override
  String get submit => 'Enviar';

  @override
  String get bookActions => 'Ações do livro';

  @override
  String get openBookInBrowser => 'Abrir livro no navegador';

  @override
  String get metadataUpdateSuccessfully => 'Metadados atualizados com sucesso';

  @override
  String get editBookMetadata => 'Editar metadados do livro';

  @override
  String get updateFailed => 'Atualização falhou';

  @override
  String get save => 'Salvar';

  @override
  String get separateWithCommas => 'Separar com vírgulas';

  @override
  String get separateWithAnd => 'Separate with \'&\'';

  @override
  String get ratingOneToTen => 'Avaliação (1-10)';

  @override
  String get markedAsReadSuccessfully => 'Marcado como lido com sucesso';

  @override
  String get markedAsReadFailed => 'Falha ao marcar como lido';

  @override
  String get markedAsUnreadSuccessfully => 'Marcado como não lido com sucesso';

  @override
  String get markedAsUnreadFailed => 'Falha ao marcar como não lido';

  @override
  String get archivedBookSuccessfully => 'Livro arquivado com sucesso';

  @override
  String get archivedBookFailed => 'Falha ao arquivar livro';

  @override
  String get unarchivedBookSuccessfully => 'Livro desarquivado com sucesso';

  @override
  String get unarchivedBookFailed => 'Falha ao desarquivar livro';

  @override
  String get themeColor => 'Cor do tema';

  @override
  String get system => 'Sistema';

  @override
  String get custom => 'Personalizado';

  @override
  String get systemThemeDescription => 'O app usará o tema do sistema';

  @override
  String get selectDownloadSchema => 'Selecione o esquema de download';

  @override
  String get schemaFlat => 'Plano (Flat)';

  @override
  String get schemaAuthorOnly => 'Apenas Autor';

  @override
  String get schemaAuthorBook => 'Autor/Livro';

  @override
  String get schemaAuthorSeriesBook => 'Autor/Série/Livro';

  @override
  String get lightGreen => 'Verde claro';

  @override
  String get amber => 'Âmbar';

  @override
  String get blueGrey => 'Cinza azulado';

  @override
  String get grey => 'Cinza';

  @override
  String get lightBlue => 'Azul claro';

  @override
  String get lime => 'Lima';

  @override
  String get teal => 'Ciano';

  @override
  String get appVersion => 'Versão do app';

  @override
  String get bookRecommendations => 'Recomendações de livros';

  @override
  String get recommendations => 'Recomendações';

  @override
  String get selectABookFromYourLibrary => 'Selecione um livro lido da sua biblioteca';

  @override
  String get searchRecommendations => 'Pesquisar recomendações';

  @override
  String get selectBook => 'Selecionar livro';

  @override
  String get selectABookToGetRecommendations => 'Selecione um livro para obter recomendações';

  @override
  String get noRecommendationsFoundForThisBook => 'Nenhuma recomendação encontrada para este livro';

  @override
  String get bookRecommendationsInfo1 => 'As recomendações de livros são obtidas de ';

  @override
  String get bookRecommendationsInfo2 => ' e funcionam melhor com títulos de livros em inglês.';

  @override
  String get info => 'Informações';

  @override
  String get refresh => 'Atualizar';

  @override
  String get noMatchingBooksFound => 'Nenhum livro correspondente encontrado';

  @override
  String get bookCouldNotBeFound => 'O livro não pôde ser encontrado';

  @override
  String get logout => 'Sair';

  @override
  String get searching => 'Pesquisando...';

  @override
  String get tags => 'Tags';

  @override
  String get recommendedBasedOn => 'Recomendado com base em';

  @override
  String get storagePermissionRequiredToSelectAFolder => 'Permissão de armazenamento necessária para selecionar uma pasta';

  @override
  String get noFolderWasSelected => 'Nenhuma pasta foi selecionada';

  @override
  String get folderSelectedSuccessfully => 'Pasta selecionada com sucesso';

  @override
  String get select => 'Selecionar';

  @override
  String get schemaWasSelectedSuccessfully => 'Esquema selecionado com sucesso';

  @override
  String get downloadSchema => 'Esquema de download';

  @override
  String get noFolderSelected => 'Nenhuma pasta selecionada';

  @override
  String get downloadFolder => 'Pasta de download';

  @override
  String get openInReader => 'Abrir no leitor';

  @override
  String get bookOpenedExternallySuccessfully => 'Livro aberto externamente com sucesso';

  @override
  String get openBookExternallyFailed => 'Falha ao abrir livro externamente';

  @override
  String get headers => 'Cabeçalhos HTTP';

  @override
  String get authSystems => 'Sistemas de Autenticação';

  @override
  String get webViewAuth => 'Autenticação via WebView';

  @override
  String get basePath => 'Caminho Base (Base Path)';

  @override
  String get authSystem => 'Sistema de Autenticação';

  @override
  String get authSystemDescription => 'Escolha o sistema de autenticação usado pela sua instância do Calibre Web';

  @override
  String get webViewAuthentication => 'Autenticação Baseada em Navegador';

  @override
  String get browserBasedAuth => 'Autenticação via Navegador';

  @override
  String get webViewAuthDescription => 'Faça login usando um navegador para sistemas de autenticação avançados como SSO';

  @override
  String get webViewSessionActive => 'Sessão do navegador ativa detectada';

  @override
  String get webViewSessionInactive => 'Nenhuma sessão ativa do navegador encontrada';

  @override
  String get lastAuthentication => 'Última autenticação:';

  @override
  String get authenticate => 'Autenticar';

  @override
  String get clearSession => 'Limpar Sessão';

  @override
  String get authenticationSuccessful => 'A autenticação foi bem-sucedida';

  @override
  String get sessionCleared => 'A sessão foi limpa';

  @override
  String get webViewAuthInstructions => 'Instruções de Login';

  @override
  String get webViewSessionSaved => 'Sessão do navegador salva com sucesso';

  @override
  String get saveSession => 'Salvar Sessão';

  @override
  String get reload => 'Recarregar';

  @override
  String get homePage => 'Página Inicial';

  @override
  String get serverUrlMissing => 'URL do servidor está faltando';

  @override
  String get pleaseConfigureServerURL => 'Por favor, configure a URL do servidor nas configurações primeiro';

  @override
  String get goBack => 'Voltar';

  @override
  String get helpAndInfo => 'Ajuda e Informações';

  @override
  String get authSystemHelp1 => 'Sistemas de autenticação podem exigir cabeçalhos HTTP específicos.';

  @override
  String get authSystemHelp2 => 'Configurações predefinidas estão disponíveis para sistemas comuns.';

  @override
  String get authSystemHelp3 => 'Você pode personalizar cabeçalhos na aba Cabeçalhos.';

  @override
  String get authSystemHelp4 => 'Para sistemas avançados, use Autenticação via WebView.';

  @override
  String get webViewHelp1 => 'Autenticação baseada em navegador é ideal para SSO e sistemas avançados.';

  @override
  String get webViewHelp2 => 'A sessão é salva e reutilizada para solicitações futuras.';

  @override
  String get webViewHelp3 => 'As sessões podem expirar após um certo período.';

  @override
  String get settingsSaved => 'Configurações salvas com sucesso';

  @override
  String get send2ereaderService => 'Serviço Send2Ereader';

  @override
  String get send2ereaderServiceUrl => 'URL do serviço Send2Ereader';

  @override
  String get enterUrlOfYourSend2ereaderService => 'Insira a URL do seu serviço Send2Ereader';

  @override
  String get noFilesSelected => 'Nenhum arquivo selecionado';

  @override
  String get preparingUpload => 'Preparando upload';

  @override
  String get uploadFailed => 'Upload falhou';

  @override
  String get uploadingBook => 'Enviando livro';

  @override
  String get columnsCount => 'Contagem de colunas';

  @override
  String get columns => 'Colunas';

  @override
  String get listView => 'List view';

  @override
  String get uploadEbook => 'Enviar eBook';

  @override
  String get logoutFailed => 'Falha ao sair';

  @override
  String get shelfNotFound => 'Estante não encontrada';

  @override
  String get titleIsRequired => 'O título é obrigatório';

  @override
  String get descriptionIsRequired => 'A descrição é obrigatória';

  @override
  String get downloadCancelled => 'Download cancelado';

  @override
  String get transferCancelled => 'Transferência cancelada';

  @override
  String get logoutConfirmation => 'Tem certeza de que deseja sair?';

  @override
  String get basePathTitle => 'Caminho Base da API';

  @override
  String get basePathLabel => 'Caminho Base';

  @override
  String get basePathHint => 'ex: /opds ou /calibre';

  @override
  String get basePathDescription => 'Defina um caminho base personalizado para solicitações de API';

  @override
  String get bookCover => 'Capa do livro';

  @override
  String get currentCover => 'Capa atual';

  @override
  String get newCover => 'Nova capa';

  @override
  String get selectCover => 'Selecionar capa';

  @override
  String get removeCover => 'Remover capa';

  @override
  String get removeCoverConfirmation => 'Tem certeza de que deseja remover a capa?';

  @override
  String get remove => 'Remover';

  @override
  String get noCover => 'Sem capa';

  @override
  String get loadingBooks => 'Carregando livros...';

  @override
  String get sucessfullyUploadedBook => 'Livro enviado com sucesso';

  @override
  String get sslSettings => 'Configurações SSL';

  @override
  String get sslCertificate => 'Certificado SSL';

  @override
  String get settingsForSSL => 'Configurações para certificado SSL';

  @override
  String get allowSelfSignedCertificates => 'Permitir certificados autoassinados';

  @override
  String get allowUnsafeConnections => 'Permitir conexões inseguras';

  @override
  String get ok => 'Ok';

  @override
  String get attentionSSLCertificate => 'Atenção: Certificados autoassinados podem ser inseguros. Use-os apenas se entender os riscos.';

  @override
  String get ssoLogin => 'Login SSO';

  @override
  String get pleaseLoginWithYourSSOAccount => 'Por favor, faça login com sua conta SSO. Você será redirecionado de volta para o app após o login bem-sucedido.';

  @override
  String get loginWithSSO => 'Entrar com SSO';

  @override
  String get pleaseEnterSSOUrl => 'Por favor, insira a URL do SSO';

  @override
  String get openInInternalReader => 'Abrir no Leitor Interno';

  @override
  String get errorOpeningBookInInternalReader => 'Erro ao abrir livro no leitor interno';

  @override
  String get readNow => 'Ler agora';

  @override
  String get showReadNowButton => 'Mostrar botão \'Ler agora\'';

  @override
  String get showReadNowButtonDescription => 'Substitui o botão \'Enviar para E-Reader\' por um botão \'Ler agora\' para abrir livros diretamente.';

  @override
  String get bookDetails => 'Detalhes do livro';

  @override
  String get applyFilters => 'Aplicar filtros';

  @override
  String get any => 'Qualquer';

  @override
  String get contentType => 'Tipo de conteúdo';

  @override
  String get author => 'Autor';

  @override
  String get reset => 'Redefinir';

  @override
  String get searchFilters => 'Filtros de pesquisa';

  @override
  String get bookFiction => 'Livro (Ficção)';

  @override
  String get bookNonFiction => 'Livro (Não ficção)';

  @override
  String get magazine => 'Revista';

  @override
  String get comic => 'Quadrinho';

  @override
  String get audiobook => 'Audiolivro';

  @override
  String get sectionDisabledOrNotFound => 'Seção indisponível';

  @override
  String get sectionDisabledDescription => 'Esta seção parece estar desativada nas configurações do seu servidor Calibre-Web ou não existe.';
}
