// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for French (`fr`).
class AppLocalizationsFr extends AppLocalizations {
  AppLocalizationsFr([String locale = 'fr']) : super(locale);

  @override
  String get loginToCalibreWb => 'Connexion à Calibre Web';

  @override
  String get calibreWebUrl => 'https://calibre.example.com';

  @override
  String get enterCalibreWebUrl => 'Entrez l\'URL de Calibre Web';

  @override
  String get username => 'Nom d\'utilisateur';

  @override
  String get enterYourUsername => 'Entrez votre nom d\'utilisateur';

  @override
  String get password => 'Mot de passe';

  @override
  String get enterYourPassword => 'Entrez votre mot de passe';

  @override
  String get login => 'Se connecter';

  @override
  String get pleaseFillInAllFields => 'Veuillez remplir tous les champs';

  @override
  String get failedToLognIn => 'Échec de la connexion';

  @override
  String get books => 'Livres';

  @override
  String get discover => 'Découvrir';

  @override
  String get me => 'Moi';

  @override
  String get discoverBooks => 'Découvrir des livres';

  @override
  String get search => 'Rechercher';

  @override
  String get searchBook => 'Rechercher un livre';

  @override
  String get enterTitleAuthorOrTags => 'Entrez le titre, l\'auteur ou les tags...';

  @override
  String get showReadBooks => 'Afficher les livres lus';

  @override
  String get showUnReadBooks => 'Afficher les livres non lus';

  @override
  String get showBookmarkedBooks => 'Afficher les livres marqués';

  @override
  String get readBooks => 'Livres lus';

  @override
  String get unreadBooks => 'Livres non lus';

  @override
  String get bookmarkedBooks => 'Livres marqués';

  @override
  String get showHotBooks => 'Afficher les livres populaires';

  @override
  String get hotBooks => 'Livres populaires';

  @override
  String get showNewBooks => 'Afficher les nouveaux livres';

  @override
  String get newBooks => 'Nouveaux livres';

  @override
  String get showRatedBooks => 'Afficher les livres notés';

  @override
  String get ratedBooks => 'Livres notés';

  @override
  String get titleAZ => 'Titre (A-Z)';

  @override
  String get titleZA => 'Titre (Z-A)';

  @override
  String get authorAZ => 'Auteur (A-Z)';

  @override
  String get authorZA => 'Auteur (Z-A)';

  @override
  String get newestFirst => 'Plus récents d\'abord';

  @override
  String get oldestFirst => 'Plus anciens d\'abord';

  @override
  String get authors => 'Auteurs';

  @override
  String get categories => 'Catégories';

  @override
  String get series => 'Séries';

  @override
  String get formats => 'Formats';

  @override
  String get languages => 'Langues';

  @override
  String get publishers => 'Éditeurs';

  @override
  String get ratings => 'Évaluations';

  @override
  String get rating => 'Évaluation';

  @override
  String get showAuthors => 'Auteurs';

  @override
  String get showCategories => 'Catégories';

  @override
  String get showSeries => 'Séries';

  @override
  String get showFormats => 'Formats';

  @override
  String get showLanguages => 'Langues';

  @override
  String get showPublishers => 'Éditeurs';

  @override
  String get showRatings => 'Évaluations';

  @override
  String by(Object author) {
    return 'par $author';
  }

  @override
  String get book => 'Livre';

  @override
  String get publicationInfo => 'Informations de publication';

  @override
  String get published => 'Publié';

  @override
  String get updated => 'Mis à jour';

  @override
  String get publisher => 'Éditeur';

  @override
  String get language => 'Langue';

  @override
  String get fileInfo => 'Informations sur le fichier';

  @override
  String get size => 'Taille';

  @override
  String get description => 'Description';

  @override
  String get noCoverAvailable => 'Pas de couverture disponible';

  @override
  String get english => 'Anglais';

  @override
  String get german => 'Allemand';

  @override
  String get french => 'Français';

  @override
  String get spanish => 'Espagnol';

  @override
  String get italian => 'Italien';

  @override
  String get japanese => 'Japonais';

  @override
  String get russian => 'Russe';

  @override
  String get portuguese => 'Portugais';

  @override
  String get chineese => 'Chinois';

  @override
  String get dutch => 'Néerlandais';

  @override
  String get sendToEReader => 'Envoyer à une liseuse';

  @override
  String get sendToKindleKobo => 'Envoyer à Kindle/Kobo';

  @override
  String get enter4DigitCode => 'Entrez le code à 4 chiffres affiché sur le navigateur de votre liseuse :';

  @override
  String get visit => 'Visitez';

  @override
  String get onYourEReader => 'sur votre liseuse pour obtenir un code';

  @override
  String get pleaseEnter4DigitCode => 'Veuillez entrer un code à 4 chiffres valide';

  @override
  String get send => 'Envoyer';

  @override
  String get startingDownloadProcess => 'Démarrage du processus de téléchargement';

  @override
  String get preparingTransfer => 'Préparation du transfert...';

  @override
  String get downloadingBook => 'Téléchargement du livre...';

  @override
  String get sendingToEReader => 'Envoi à la liseuse...';

  @override
  String get successfullySentToEReader => 'Envoyé avec succès à la liseuse';

  @override
  String get transferFailed => 'Le transfert a échoué';

  @override
  String get downloadToDevice => 'Télécharger sur l\'appareil';

  @override
  String get errorDownloading => 'Erreur de téléchargement';

  @override
  String get downlaodFomat => 'Format de téléchargement';

  @override
  String get preparingDownload => 'Préparation du téléchargement...';

  @override
  String get selectDownloadDestination => 'Sélectionner la destination du téléchargement';

  @override
  String get successfullyDownloadedBook => 'Livre téléchargé avec succès';

  @override
  String get downloadFailed => 'Le téléchargement a échoué';

  @override
  String get libraryStatistics => 'Statistiques de la bibliothèque';

  @override
  String get cancel => 'Annuler';

  @override
  String get close => 'Fermer';

  @override
  String get retry => 'Réessayer';

  @override
  String get tryAgain => 'Essayer à nouveau';

  @override
  String get error => 'Erreur';

  @override
  String get errorLoadingBooks => 'Erreur lors du chargement des livres';

  @override
  String get errorLoadingData => 'Erreur lors du chargement des données';

  @override
  String get erroLoadingBookDetails => 'Erreur lors du chargement des détails du livre';

  @override
  String get noBooksFound => 'Aucun livre trouvé';

  @override
  String get noDataFound => 'Aucune donnée trouvée';

  @override
  String get unknownError => 'Erreur inconnue';

  @override
  String get loading => 'Chargement...';

  @override
  String get settings => 'Paramètres';

  @override
  String get appearance => 'Apparence';

  @override
  String get about => 'À propos';

  @override
  String get themeMode => 'Mode thème';

  @override
  String get systemTheme => 'Thème du système';

  @override
  String get lightTheme => 'Thème clair';

  @override
  String get darkTheme => 'Thème sombre';

  @override
  String get downloadService => 'Service de téléchargement';

  @override
  String get downloads => 'Téléchargements';

  @override
  String get searchForABook => 'Rechercher un livre';

  @override
  String get noDownloadsFound => 'Aucun téléchargement trouvé';

  @override
  String foundBooks(Object count) {
    return '$count livres trouvés';
  }

  @override
  String get addedBookToTheDownloadQueue => 'Livre ajouté à la file d\'attente de téléchargement';

  @override
  String get download => 'Télécharger';

  @override
  String get available => 'Disponible';

  @override
  String get downloading => 'Téléchargement';

  @override
  String get completed => 'Terminé';

  @override
  String get failed => 'Échoué';

  @override
  String get queued => 'En file d\'attente';

  @override
  String get notDownloaded => 'Non téléchargé';

  @override
  String get downloadServiceUrl => 'URL du service de téléchargement';

  @override
  String get enterUrlOfYourDownloadService => 'Entrez l\'URL de votre service de téléchargement';

  @override
  String get bookWillBeSendToYourEmailAdress => 'Le livre sera envoyé en EPUB à votre adresse e-mail enregistrée.';

  @override
  String get makeSureEmailSettingsAreConfigured => 'Assurez-vous que les paramètres de messagerie SMTP sont configurés sur le serveur.';

  @override
  String get markAsReadUnread => 'Marquer comme lu/non lu';

  @override
  String get archiveUnarchive => 'Archiver/Désarchiver';

  @override
  String get addToShelf => 'Ajouter à l\'étagère';

  @override
  String get selectShelf => 'Sélectionner une étagère';

  @override
  String get noShelvesFound => 'Aucune étagère trouvée';

  @override
  String bookAddedToShelf(Object book) {
    return 'Livre ajouté à l\'étagère $book';
  }

  @override
  String get failedToAddToShelf => 'Échec de l\'ajout à l\'étagère';

  @override
  String bookRemovedFromShelf(Object book) {
    return 'Livre retiré de l\'étagère $book';
  }

  @override
  String get failedToRemoveFromShelf => 'Échec du retrait de l\'étagère';

  @override
  String get removeFromShelf => 'Retirer';

  @override
  String get shelfs => 'Étagères';

  @override
  String shelfContains(Object count) {
    return 'L\'étagère contient $count livres';
  }

  @override
  String get errorLoadingShelf => 'Erreur lors du chargement de l\'étagère';

  @override
  String get createShelf => 'Créer une étagère';

  @override
  String get shelfName => 'Nom de l\'étagère';

  @override
  String get shelfNameRequired => 'Le nom de l\'étagère est requis';

  @override
  String get shelfSuccessfullyCreated => 'Étagère créée avec succès';

  @override
  String errorCreatingShelf(Object name) {
    return 'Erreur lors de la création de l\'étagère $name';
  }

  @override
  String get create => 'Créer';

  @override
  String get creating => 'Création';

  @override
  String get noShelvesFoundCreateOne => 'Aucune étagère trouvée. Créez-en une !';

  @override
  String get editShelf => 'Modifier l\'étagère';

  @override
  String get deleteShelf => 'Supprimer l\'étagère';

  @override
  String get bookOptions => 'Options du livre';

  @override
  String get successfullyDeletedShelf => 'Étagère supprimée avec succès';

  @override
  String get failedToDeleteShelf => 'Échec de la suppression de l\'étagère';

  @override
  String get delete => 'Supprimer';

  @override
  String get deleting => 'Suppression';

  @override
  String get successfullyEditedShelf => 'Étagère modifiée avec succès';

  @override
  String get failedToEditShelf => 'Échec de la modification de l\'étagère';

  @override
  String get edit => 'Modifier';

  @override
  String get editing => 'Modification';

  @override
  String deleteShelfConfirmation(Object name) {
    return 'Êtes-vous sûr de vouloir supprimer l\'étagère $name ?';
  }

  @override
  String get addBooksToShelf => 'Ajouter des livres à l\'étagère';

  @override
  String get shelfIsEmpty => 'L\'étagère est vide';

  @override
  String get removing => 'Suppression';

  @override
  String get manageBookShelves => 'Gérer les étagères de livres';

  @override
  String bookInShelfs(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count étagères',
      one: 'une étagère',
    );
    return 'Livre dans $_temp0';
  }

  @override
  String get searchForBooks => 'Rechercher des livres';

  @override
  String get connectionSettings => 'Paramètres de connexion';

  @override
  String get costumHttpPHeader => 'En-tête HTTP personnalisé';

  @override
  String get addHeader => 'Ajouter un en-tête';

  @override
  String get httpHeader => 'En-tête HTTP';

  @override
  String get addACostumHttpHeaderThatWillBeSentWithEveryRequest => 'Ajoutez un en-tête HTTP personnalisé qui sera envoyé avec chaque demande';

  @override
  String get noCostumHttpHeadersYet => 'Pas encore d\'en-têtes HTTP personnalisés';

  @override
  String get header => 'En-tête';

  @override
  String get headerKey => 'Clé de l\'en-tête';

  @override
  String get headerValue => 'Valeur de l\'en-tête';

  @override
  String get deleteHeader => 'Supprimer l\'en-tête';

  @override
  String get urlMustStartWithHttpOrHttps => 'L\'URL doit commencer par http:// ou https://';

  @override
  String get connection => 'Connexion';

  @override
  String get httpHeaderSettings => 'Paramètres de l\'en-tête HTTP';

  @override
  String get feedback => 'Retour d\'information';

  @override
  String get reportIssue => 'Signaler un problème';

  @override
  String get reportAppIssueOrSuggestFeature => 'Signaler un problème avec l\'application ou suggérer une fonctionnalité';

  @override
  String get title => 'Titre';

  @override
  String get required => 'Requis';

  @override
  String get submit => 'Soumettre';

  @override
  String get bookActions => 'Actions du livre';

  @override
  String get openBookInBrowser => 'Ouvrir le livre dans le navigateur';

  @override
  String get metadataUpdateSuccessfully => 'Métadonnées mises à jour avec succès';

  @override
  String get editBookMetadata => 'Modifier les métadonnées du livre';

  @override
  String get updateFailed => 'Échec de la mise à jour';

  @override
  String get save => 'Enregistrer';

  @override
  String get separateWithCommas => 'Séparer par des virgules';

  @override
  String get separateWithAnd => 'Séparer par \'&\'';

  @override
  String get ratingOneToTen => 'Évaluation (1-10)';

  @override
  String get markedAsReadSuccessfully => 'Marqué comme lu/non lu avec succès';

  @override
  String get markedAsReadFailed => 'Échec du marquage comme lu/non lu';

  @override
  String get markedAsUnreadSuccessfully => 'Marqué comme non lu avec succès';

  @override
  String get markedAsUnreadFailed => 'Échec du marquage comme non lu';

  @override
  String get archivedBookSuccessfully => 'Livre archivé avec succès';

  @override
  String get archivedBookFailed => 'Échec de l\'archivage du livre';

  @override
  String get unarchivedBookSuccessfully => 'Livre désarchivé avec succès';

  @override
  String get unarchivedBookFailed => 'Échec de la désarchivage du livre';

  @override
  String get themeColor => 'Couleur du thème';

  @override
  String get system => 'Système';

  @override
  String get custom => 'Personnalisé';

  @override
  String get systemThemeDescription => 'L\'application utilisera le thème du système';

  @override
  String get selectDownloadSchema => 'Sélectionner le schéma de téléchargement';

  @override
  String get schemaFlat => 'Plat';

  @override
  String get schemaAuthorOnly => 'Auteur uniquement';

  @override
  String get schemaAuthorBook => 'Auteur/Livre';

  @override
  String get schemaAuthorSeriesBook => 'Auteur/Série/Livre';

  @override
  String get lightGreen => 'Vert clair';

  @override
  String get amber => 'Ambre';

  @override
  String get blueGrey => 'Bleu gris';

  @override
  String get grey => 'Gris';

  @override
  String get lightBlue => 'Bleu clair';

  @override
  String get lime => 'Citron vert';

  @override
  String get teal => 'Sarcelle';

  @override
  String get appVersion => 'Version de l\'application';

  @override
  String get bookRecommendations => 'Recommandations de livres';

  @override
  String get recommendations => 'Recommandations';

  @override
  String get selectABookFromYourLibrary => 'Sélectionnez un livre de votre bibliothèque';

  @override
  String get searchRecommendations => 'Rechercher des recommandations';

  @override
  String get selectBook => 'Sélectionner un livre';

  @override
  String get selectABookToGetRecommendations => 'Sélectionnez un livre pour obtenir des recommandations';

  @override
  String get noRecommendationsFoundForThisBook => 'Aucune recommandation trouvée pour ce livre';

  @override
  String get bookRecommendationsInfo1 => 'Les recommandations de livres sont récupérées depuis ';

  @override
  String get bookRecommendationsInfo2 => ' et fonctionnent mieux avec des titres de livres en anglais.';

  @override
  String get info => 'Info';

  @override
  String get refresh => 'Actualiser';

  @override
  String get noMatchingBooksFound => 'Aucun livre correspondant trouvé';

  @override
  String get bookCouldNotBeFound => 'Le livre n\'a pas pu être trouvé';

  @override
  String get logout => 'Déconnexion';

  @override
  String get searching => 'Recherche en cours...';

  @override
  String get tags => 'Tags';

  @override
  String get recommendedBasedOn => 'Recommandé en fonction de';

  @override
  String get storagePermissionRequiredToSelectAFolder => 'Autorisation de stockage requise pour sélectionner un dossier';

  @override
  String get noFolderWasSelected => 'Aucun dossier n\'a été sélectionné';

  @override
  String get folderSelectedSuccessfully => 'Dossier sélectionné avec succès';

  @override
  String get select => 'Sélectionner';

  @override
  String get schemaWasSelectedSuccessfully => 'Le schéma a été sélectionné avec succès';

  @override
  String get downloadSchema => 'Schéma de téléchargement';

  @override
  String get noFolderSelected => 'Aucun dossier sélectionné';

  @override
  String get downloadFolder => 'Dossier de téléchargement';

  @override
  String get openInReader => 'Ouvrir dans le lecteur';

  @override
  String get bookOpenedExternallySuccessfully => 'Livre ouvert avec succès dans l\'application externe';

  @override
  String get openBookExternallyFailed => 'Échec de l\'ouverture du livre dans l\'application externe';

  @override
  String get headers => 'En-têtes';

  @override
  String get authSystems => 'Systèmes d\'authentification';

  @override
  String get webViewAuth => 'Authentification WebView';

  @override
  String get basePath => 'Chemin de base';

  @override
  String get authSystem => 'Système d\'authentification';

  @override
  String get authSystemDescription => 'Sélectionnez le système d\'authentification derrière lequel fonctionne votre instance Calibre Web';

  @override
  String get webViewAuthentication => 'Authentification via navigateur';

  @override
  String get browserBasedAuth => 'Authentification basée sur le navigateur';

  @override
  String get webViewAuthDescription => 'Connectez-vous via le navigateur pour des systèmes d\'authentification complexes comme SSO';

  @override
  String get webViewSessionActive => 'Session de navigateur active disponible';

  @override
  String get webViewSessionInactive => 'Aucune session de navigateur active';

  @override
  String get lastAuthentication => 'Dernière authentification :';

  @override
  String get authenticate => 'Authentifier';

  @override
  String get clearSession => 'Effacer la session';

  @override
  String get authenticationSuccessful => 'Authentification réussie';

  @override
  String get sessionCleared => 'Session effacée';

  @override
  String get webViewAuthInstructions => 'Instructions de connexion';

  @override
  String get webViewSessionSaved => 'Session de navigateur enregistrée avec succès';

  @override
  String get saveSession => 'Enregistrer la session';

  @override
  String get reload => 'Recharger';

  @override
  String get homePage => 'Page d\'accueil';

  @override
  String get serverUrlMissing => 'URL du serveur manquante';

  @override
  String get pleaseConfigureServerURL => 'Veuillez d\'abord configurer l\'URL du serveur dans les paramètres';

  @override
  String get goBack => 'Retour';

  @override
  String get helpAndInfo => 'Aide & Informations';

  @override
  String get authSystemHelp1 => 'Les systèmes d\'authentification peuvent nécessiter des en-têtes HTTP spécifiques.';

  @override
  String get authSystemHelp2 => 'Des configurations prédéfinies sont disponibles pour les systèmes courants.';

  @override
  String get authSystemHelp3 => 'Vous pouvez personnaliser les en-têtes dans l\'onglet En-têtes.';

  @override
  String get authSystemHelp4 => 'Pour les systèmes complexes, utilisez plutôt l\'authentification WebView.';

  @override
  String get webViewHelp1 => 'L\'authentification via navigateur est utile pour les SSO et les systèmes d\'authentification complexes.';

  @override
  String get webViewHelp2 => 'La session est enregistrée et utilisée pour les requêtes futures.';

  @override
  String get webViewHelp3 => 'Les sessions peuvent expirer après un certain temps.';

  @override
  String get settingsSaved => 'Paramètres enregistrés';

  @override
  String get send2ereaderService => 'Service Send2ereader';

  @override
  String get send2ereaderServiceUrl => 'URL du service Send2ereader';

  @override
  String get enterUrlOfYourSend2ereaderService => 'Entrez l\'URL de votre service Send2ereader';

  @override
  String get noFilesSelected => 'Aucun fichier sélectionné';

  @override
  String get preparingUpload => 'Préparation du téléchargement';

  @override
  String get uploadFailed => 'Échec du téléchargement';

  @override
  String get uploadingBook => 'Téléchargement du livre';

  @override
  String get columnsCount => 'Nombre de colonnes';

  @override
  String get columns => 'Colonnes';

  @override
  String get listView => 'Vue en liste';

  @override
  String get uploadEbook => 'Télécharger un eBook';

  @override
  String get logoutFailed => 'Échec de la déconnexion';

  @override
  String get shelfNotFound => 'Étagère non trouvée';

  @override
  String get titleIsRequired => 'Le titre est requis';

  @override
  String get descriptionIsRequired => 'La description est requise';

  @override
  String get downloadCancelled => 'Téléchargement annulé';

  @override
  String get transferCancelled => 'Transfert annulé';

  @override
  String get logoutConfirmation => 'Êtes-vous sûr de vouloir vous déconnecter ?';

  @override
  String get basePathTitle => 'Chemin de base de l\'API';

  @override
  String get basePathLabel => 'Chemin de base';

  @override
  String get basePathHint => 'ex. /opds ou /calibre';

  @override
  String get basePathDescription => 'Définir un chemin de base personnalisé pour les requêtes API';

  @override
  String get bookCover => 'Couverture de livre';

  @override
  String get currentCover => 'Couverture actuelle';

  @override
  String get newCover => 'Nouvelle couverture';

  @override
  String get selectCover => 'Sélectionner une couverture';

  @override
  String get removeCover => 'Supprimer la couverture';

  @override
  String get removeCoverConfirmation => 'Êtes-vous sûr de vouloir supprimer la couverture actuelle ?';

  @override
  String get remove => 'Supprimer';

  @override
  String get noCover => 'Aucune couverture';

  @override
  String get loadingBooks => 'Chargement des livres...';

  @override
  String get sucessfullyUploadedBook => 'Livre téléchargé avec succès';

  @override
  String get sslSettings => 'Paramètres SSL';

  @override
  String get sslCertificate => 'Certificat SSL';

  @override
  String get settingsForSSL => 'Paramètres pour le certificat SSL';

  @override
  String get allowSelfSignedCertificates => 'Autoriser les certificats auto-signés';

  @override
  String get allowUnsafeConnections => 'Autoriser les connexions non sécurisées';

  @override
  String get ok => 'Ok';

  @override
  String get attentionSSLCertificate => 'Attention : Les certificats auto-signés peuvent être non sécurisés. Utilisez-les uniquement si vous comprenez les risques.';

  @override
  String get ssoLogin => 'SSO-Connexion';

  @override
  String get pleaseLoginWithYourSSOAccount => 'Veuillez vous connecter avec votre compte SSO. Vous serez redirigé vers l\'application après une connexion réussie.';

  @override
  String get loginWithSSO => 'Connexion avec SSO';

  @override
  String get pleaseEnterSSOUrl => 'Veuillez entrer l\'URL SSO';

  @override
  String get openInInternalReader => 'Ouvrir dans le lecteur interne';

  @override
  String get errorOpeningBookInInternalReader => 'Erreur lors de l\'ouverture du livre dans le lecteur interne';

  @override
  String get readNow => 'Lire maintenant';

  @override
  String get showReadNowButton => 'Afficher le bouton \'Lire maintenant\'';

  @override
  String get showReadNowButtonDescription => 'Affiche un bouton \'Lire maintenant\' sur les détails du livre pour ouvrir le livre dans le lecteur interne.';

  @override
  String get bookDetails => 'Détails du livre';

  @override
  String get applyFilters => 'Appliquer les filtres';

  @override
  String get any => 'N\'importe lequel';

  @override
  String get contentType => 'Type de contenu';

  @override
  String get author => 'Auteur';

  @override
  String get reset => 'Réinitialiser';

  @override
  String get searchFilters => 'Filtres de recherche';

  @override
  String get bookFiction => 'Fiction';

  @override
  String get bookNonFiction => 'Non-fiction';

  @override
  String get magazine => 'Magazine';

  @override
  String get comic => 'Bande dessinée';

  @override
  String get audiobook => 'Livre audio';

  @override
  String get sectionDisabledOrNotFound => 'Section non disponible';

  @override
  String get sectionDisabledDescription => 'Cette section semble être désactivée dans les paramètres de votre serveur Calibre-Web ou n\'existe pas.';
}
