// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Spanish Castilian (`es`).
class AppLocalizationsEs extends AppLocalizations {
  AppLocalizationsEs([String locale = 'es']) : super(locale);

  @override
  String get loginToCalibreWb => 'Iniciar sesión en Calibre Web';

  @override
  String get calibreWebUrl => 'https://calibre.example.com';

  @override
  String get enterCalibreWebUrl => 'Introduce la URL de Calibre Web';

  @override
  String get username => 'Nombre de usuario';

  @override
  String get enterYourUsername => 'Introduce tu nombre de usuario';

  @override
  String get password => 'Contraseña';

  @override
  String get enterYourPassword => 'Introduce tu contraseña';

  @override
  String get login => 'Iniciar sesión';

  @override
  String get pleaseFillInAllFields => 'Por favor, completa todos los campos';

  @override
  String get failedToLognIn => 'Error al iniciar sesión';

  @override
  String get books => 'Libros';

  @override
  String get discover => 'Descubrir';

  @override
  String get me => 'Yo';

  @override
  String get discoverBooks => 'Descubrir libros';

  @override
  String get search => 'Buscar';

  @override
  String get searchBook => 'Buscar libro';

  @override
  String get enterTitleAuthorOrTags => 'Introduce título, autor o etiquetas...';

  @override
  String get showReadBooks => 'Mostrar libros leídos';

  @override
  String get showUnReadBooks => 'Mostrar libros no leídos';

  @override
  String get showBookmarkedBooks => 'Mostrar libros marcados';

  @override
  String get readBooks => 'Libros leídos';

  @override
  String get unreadBooks => 'Libros no leídos';

  @override
  String get bookmarkedBooks => 'Libros marcados';

  @override
  String get showHotBooks => 'Mostrar libros populares';

  @override
  String get hotBooks => 'Libros populares';

  @override
  String get showNewBooks => 'Mostrar libros nuevos';

  @override
  String get newBooks => 'Libros nuevos';

  @override
  String get showRatedBooks => 'Mostrar libros calificados';

  @override
  String get ratedBooks => 'Libros calificados';

  @override
  String get titleAZ => 'Título (A-Z)';

  @override
  String get titleZA => 'Título (Z-A)';

  @override
  String get authorAZ => 'Autor (A-Z)';

  @override
  String get authorZA => 'Autor (Z-A)';

  @override
  String get newestFirst => 'Más recientes primero';

  @override
  String get oldestFirst => 'Más antiguos primero';

  @override
  String get authors => 'Autores';

  @override
  String get categories => 'Categorías';

  @override
  String get series => 'Series';

  @override
  String get formats => 'Formatos';

  @override
  String get languages => 'Idiomas';

  @override
  String get publishers => 'Editoriales';

  @override
  String get ratings => 'Calificaciones';

  @override
  String get rating => 'Calificación';

  @override
  String get showAuthors => 'Autores';

  @override
  String get showCategories => 'Categorías';

  @override
  String get showSeries => 'Series';

  @override
  String get showFormats => 'Formatos';

  @override
  String get showLanguages => 'Idiomas';

  @override
  String get showPublishers => 'Editoriales';

  @override
  String get showRatings => 'Calificaciones';

  @override
  String by(Object author) {
    return 'por $author';
  }

  @override
  String get book => 'Libro';

  @override
  String get publicationInfo => 'Información de publicación';

  @override
  String get published => 'Publicado';

  @override
  String get updated => 'Actualizado';

  @override
  String get publisher => 'Editorial';

  @override
  String get language => 'Idioma';

  @override
  String get fileInfo => 'Información del archivo';

  @override
  String get size => 'Tamaño';

  @override
  String get description => 'Descripción';

  @override
  String get noCoverAvailable => 'Portada no disponible';

  @override
  String get english => 'Inglés';

  @override
  String get german => 'Alemán';

  @override
  String get french => 'Francés';

  @override
  String get spanish => 'Español';

  @override
  String get italian => 'Italiano';

  @override
  String get japanese => 'Japonés';

  @override
  String get russian => 'Ruso';

  @override
  String get portuguese => 'Portugués';

  @override
  String get chineese => 'Chino';

  @override
  String get dutch => 'Holandés';

  @override
  String get sendToEReader => 'Enviar a lector electrónico';

  @override
  String get sendToKindleKobo => 'Enviar a Kindle/Kobo';

  @override
  String get enter4DigitCode => 'Introduce el código de 4 dígitos que aparece en el navegador de tu lector electrónico:';

  @override
  String get visit => 'Visita';

  @override
  String get onYourEReader => 'en tu lector electrónico para obtener un código';

  @override
  String get pleaseEnter4DigitCode => 'Por favor, introduce un código válido de 4 dígitos';

  @override
  String get send => 'Enviar';

  @override
  String get startingDownloadProcess => 'Iniciando proceso de descarga';

  @override
  String get preparingTransfer => 'Preparando transferencia...';

  @override
  String get downloadingBook => 'Descargando libro...';

  @override
  String get sendingToEReader => 'Enviando al lector electrónico...';

  @override
  String get successfullySentToEReader => 'Enviado con éxito al lector electrónico';

  @override
  String get transferFailed => 'La transferencia falló';

  @override
  String get downloadToDevice => 'Descargar al dispositivo';

  @override
  String get errorDownloading => 'Error al descargar';

  @override
  String get downlaodFomat => 'Formato de descarga';

  @override
  String get preparingDownload => 'Preparando descarga...';

  @override
  String get selectDownloadDestination => 'Seleccionar destino de descarga';

  @override
  String get successfullyDownloadedBook => 'Libro descargado con éxito';

  @override
  String get downloadFailed => 'La descarga falló';

  @override
  String get libraryStatistics => 'Estadísticas de la biblioteca';

  @override
  String get cancel => 'Cancelar';

  @override
  String get close => 'Cerrar';

  @override
  String get retry => 'Reintentar';

  @override
  String get tryAgain => 'Intentar de nuevo';

  @override
  String get error => 'Error';

  @override
  String get errorLoadingBooks => 'Error al cargar los libros';

  @override
  String get errorLoadingData => 'Error al cargar los datos';

  @override
  String get erroLoadingBookDetails => 'Error al cargar los detalles del libro';

  @override
  String get noBooksFound => 'No se encontraron libros';

  @override
  String get noDataFound => 'No se encontraron datos';

  @override
  String get unknownError => 'Error desconocido';

  @override
  String get loading => 'Cargando...';

  @override
  String get settings => 'Ajustes';

  @override
  String get appearance => 'Apariencia';

  @override
  String get about => 'Acerca de';

  @override
  String get themeMode => 'Modo de tema';

  @override
  String get systemTheme => 'Tema del sistema';

  @override
  String get lightTheme => 'Tema claro';

  @override
  String get darkTheme => 'Tema oscuro';

  @override
  String get downloadService => 'Servicio de descarga';

  @override
  String get downloads => 'Descargas';

  @override
  String get searchForABook => 'Buscar un libro';

  @override
  String get noDownloadsFound => 'No se encontraron descargas';

  @override
  String foundBooks(Object count) {
    return '$count libros encontrados';
  }

  @override
  String get addedBookToTheDownloadQueue => 'Libro añadido a la cola de descargas';

  @override
  String get download => 'Descargar';

  @override
  String get available => 'Disponible';

  @override
  String get downloading => 'Descargando';

  @override
  String get completed => 'Completado';

  @override
  String get failed => 'Fallido';

  @override
  String get queued => 'En cola';

  @override
  String get notDownloaded => 'No descargado';

  @override
  String get downloadServiceUrl => 'URL del servicio de descarga';

  @override
  String get enterUrlOfYourDownloadService => 'Introduce la URL de tu servicio de descarga';

  @override
  String get bookWillBeSendToYourEmailAdress => 'El libro se enviará como EPUB a tu dirección de correo electrónico registrada.';

  @override
  String get makeSureEmailSettingsAreConfigured => 'Asegúrate de que la configuración de correo SMTP esté configurada en el servidor.';

  @override
  String get markAsReadUnread => 'Marcar como leído/no leído';

  @override
  String get archiveUnarchive => 'Archivar/Desarchivar';

  @override
  String get addToShelf => 'Añadir al estante';

  @override
  String get selectShelf => 'Seleccionar estante';

  @override
  String get noShelvesFound => 'No se encontraron estantes';

  @override
  String bookAddedToShelf(Object book) {
    return 'Libro añadido al estante $book';
  }

  @override
  String get failedToAddToShelf => 'Error al añadir al estante';

  @override
  String bookRemovedFromShelf(Object book) {
    return 'Libro eliminado del estante $book';
  }

  @override
  String get failedToRemoveFromShelf => 'Error al eliminar del estante';

  @override
  String get removeFromShelf => 'Eliminar';

  @override
  String get shelfs => 'Estantes';

  @override
  String shelfContains(Object count) {
    return 'El estante contiene $count libros';
  }

  @override
  String get errorLoadingShelf => 'Error al cargar el estante';

  @override
  String get createShelf => 'Crear estante';

  @override
  String get shelfName => 'Nombre del estante';

  @override
  String get shelfNameRequired => 'El nombre del estante es obligatorio';

  @override
  String get shelfSuccessfullyCreated => 'Estante creado con éxito';

  @override
  String errorCreatingShelf(Object name) {
    return 'Error al crear el estante $name';
  }

  @override
  String get create => 'Crear';

  @override
  String get creating => 'Creando';

  @override
  String get noShelvesFoundCreateOne => 'No se encontraron estantes. ¡Crea uno!';

  @override
  String get editShelf => 'Editar estante';

  @override
  String get deleteShelf => 'Eliminar estante';

  @override
  String get bookOptions => 'Opciones del libro';

  @override
  String get successfullyDeletedShelf => 'Estante eliminado con éxito';

  @override
  String get failedToDeleteShelf => 'Error al eliminar el estante';

  @override
  String get delete => 'Eliminar';

  @override
  String get deleting => 'Eliminando';

  @override
  String get successfullyEditedShelf => 'Estante editado con éxito';

  @override
  String get failedToEditShelf => 'Error al editar el estante';

  @override
  String get edit => 'Editar';

  @override
  String get editing => 'Editando';

  @override
  String deleteShelfConfirmation(Object name) {
    return '¿Estás seguro de que quieres eliminar el estante $name?';
  }

  @override
  String get addBooksToShelf => 'Añadir libros al estante';

  @override
  String get shelfIsEmpty => 'El estante está vacío';

  @override
  String get removing => 'Eliminando';

  @override
  String get manageBookShelves => 'Gestionar estantes de libros';

  @override
  String bookInShelfs(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count estantes',
      one: 'un estante',
    );
    return 'Libro en $_temp0';
  }

  @override
  String get searchForBooks => 'Buscar libros';

  @override
  String get connectionSettings => 'Configuración de conexión';

  @override
  String get costumHttpPHeader => 'Encabezado HTTP personalizado';

  @override
  String get addHeader => 'Añadir encabezado';

  @override
  String get httpHeader => 'Encabezado HTTP';

  @override
  String get addACostumHttpHeaderThatWillBeSentWithEveryRequest => 'Añade un encabezado HTTP personalizado que se enviará con cada solicitud';

  @override
  String get noCostumHttpHeadersYet => 'Aún no hay encabezados HTTP personalizados';

  @override
  String get header => 'Encabezado';

  @override
  String get headerKey => 'Clave del encabezado';

  @override
  String get headerValue => 'Valor del encabezado';

  @override
  String get deleteHeader => 'Eliminar encabezado';

  @override
  String get urlMustStartWithHttpOrHttps => 'La URL debe comenzar con http:// o https://';

  @override
  String get connection => 'Conexión';

  @override
  String get httpHeaderSettings => 'Configuración de encabezado HTTP';

  @override
  String get feedback => 'Comentarios';

  @override
  String get reportIssue => 'Informar de un problema';

  @override
  String get reportAppIssueOrSuggestFeature => 'Informar de un problema de la aplicación o sugerir una función';

  @override
  String get title => 'Título';

  @override
  String get required => 'Requerido';

  @override
  String get submit => 'Enviar';

  @override
  String get bookActions => 'Acciones del libro';

  @override
  String get openBookInBrowser => 'Abrir libro en el navegador';

  @override
  String get metadataUpdateSuccessfully => 'Metadatos actualizados con éxito';

  @override
  String get editBookMetadata => 'Editar metadatos del libro';

  @override
  String get updateFailed => 'Error al actualizar';

  @override
  String get save => 'Guardar';

  @override
  String get separateWithCommas => 'Separar con comas';

  @override
  String get separateWithAnd => 'Separar con \'&\'';

  @override
  String get ratingOneToTen => 'Calificación (1-10)';

  @override
  String get markedAsReadSuccessfully => 'Marcado como leído/no leído con éxito';

  @override
  String get markedAsReadFailed => 'Error al marcar como leído/no leído';

  @override
  String get markedAsUnreadSuccessfully => 'Marcado como no leído con éxito';

  @override
  String get markedAsUnreadFailed => 'Error al marcar como no leído';

  @override
  String get archivedBookSuccessfully => 'Libro archivado con éxito';

  @override
  String get archivedBookFailed => 'Error al archivar el libro';

  @override
  String get unarchivedBookSuccessfully => 'Libro desarchivado con éxito';

  @override
  String get unarchivedBookFailed => 'Error al desarchivar el libro';

  @override
  String get themeColor => 'Color del tema';

  @override
  String get system => 'Sistema';

  @override
  String get custom => 'Personalizado';

  @override
  String get systemThemeDescription => 'La aplicación usará el tema del sistema';

  @override
  String get selectDownloadSchema => 'Seleccionar esquema de descarga';

  @override
  String get schemaFlat => 'Plano';

  @override
  String get schemaAuthorOnly => 'Solo autor';

  @override
  String get schemaAuthorBook => 'Autor/Libro';

  @override
  String get schemaAuthorSeriesBook => 'Autor/Serie/Libro';

  @override
  String get lightGreen => 'Verde claro';

  @override
  String get amber => 'Ámbar';

  @override
  String get blueGrey => 'Azul grisáceo';

  @override
  String get grey => 'Gris';

  @override
  String get lightBlue => 'Azul claro';

  @override
  String get lime => 'Lima';

  @override
  String get teal => 'Verde azulado';

  @override
  String get appVersion => 'Versión de la aplicación';

  @override
  String get bookRecommendations => 'Recomendaciones de libros';

  @override
  String get recommendations => 'Recomendaciones';

  @override
  String get selectABookFromYourLibrary => 'Selecciona un libro de tu biblioteca';

  @override
  String get searchRecommendations => 'Buscar recomendaciones';

  @override
  String get selectBook => 'Seleccionar libro';

  @override
  String get selectABookToGetRecommendations => 'Selecciona un libro para obtener recomendaciones';

  @override
  String get noRecommendationsFoundForThisBook => 'No se encontraron recomendaciones para este libro';

  @override
  String get bookRecommendationsInfo1 => 'Las recomendaciones de libros se obtienen de ';

  @override
  String get bookRecommendationsInfo2 => ' y funcionan mejor con títulos de libros en inglés.';

  @override
  String get info => 'Información';

  @override
  String get refresh => 'Actualizar';

  @override
  String get noMatchingBooksFound => 'No se encontraron libros coincidentes';

  @override
  String get bookCouldNotBeFound => 'No se pudo encontrar el libro';

  @override
  String get logout => 'Cerrar sesión';

  @override
  String get searching => 'Buscando...';

  @override
  String get tags => 'Etiquetas';

  @override
  String get recommendedBasedOn => 'Recomendado en función de';

  @override
  String get storagePermissionRequiredToSelectAFolder => 'Se requiere permiso de almacenamiento para seleccionar una carpeta';

  @override
  String get noFolderWasSelected => 'No se seleccionó ninguna carpeta';

  @override
  String get folderSelectedSuccessfully => 'Carpeta seleccionada con éxito';

  @override
  String get select => 'Seleccionar';

  @override
  String get schemaWasSelectedSuccessfully => 'Esquema seleccionado con éxito';

  @override
  String get downloadSchema => 'Esquema de descarga';

  @override
  String get noFolderSelected => 'No se seleccionó ninguna carpeta';

  @override
  String get downloadFolder => 'Carpeta de descarga';

  @override
  String get openInReader => 'Abrir en lector';

  @override
  String get bookOpenedExternallySuccessfully => 'Libro abierto externamente con éxito';

  @override
  String get openBookExternallyFailed => 'Error al abrir el libro externamente';

  @override
  String get headers => 'Encabezados';

  @override
  String get authSystems => 'Sistemas de autenticación';

  @override
  String get webViewAuth => 'Autenticación WebView';

  @override
  String get basePath => 'Ruta base';

  @override
  String get authSystem => 'Sistema de autenticación';

  @override
  String get authSystemDescription => 'Selecciona el sistema de autenticación detrás del cual se ejecuta tu instancia de Calibre Web';

  @override
  String get webViewAuthentication => 'Autenticación basada en navegador';

  @override
  String get browserBasedAuth => 'Autenticación basada en navegador';

  @override
  String get webViewAuthDescription => 'Inicia sesión a través del navegador para sistemas de autenticación complejos como SSO';

  @override
  String get webViewSessionActive => 'Sesión activa del navegador disponible';

  @override
  String get webViewSessionInactive => 'No hay sesión activa del navegador';

  @override
  String get lastAuthentication => 'Última autenticación:';

  @override
  String get authenticate => 'Autenticar';

  @override
  String get clearSession => 'Borrar sesión';

  @override
  String get authenticationSuccessful => 'Autenticación exitosa';

  @override
  String get sessionCleared => 'Sesión borrada';

  @override
  String get webViewAuthInstructions => 'Instrucciones de inicio de sesión';

  @override
  String get webViewSessionSaved => 'Sesión del navegador guardada con éxito';

  @override
  String get saveSession => 'Guardar sesión';

  @override
  String get reload => 'Recargar';

  @override
  String get homePage => 'Inicio';

  @override
  String get serverUrlMissing => 'Falta la URL del servidor';

  @override
  String get pleaseConfigureServerURL => 'Por favor, configura la URL del servidor en los ajustes primero';

  @override
  String get goBack => 'Volver';

  @override
  String get helpAndInfo => 'Ayuda e información';

  @override
  String get authSystemHelp1 => 'Los sistemas de autenticación pueden requerir encabezados HTTP específicos.';

  @override
  String get authSystemHelp2 => 'Hay configuraciones predefinidas disponibles para sistemas comunes.';

  @override
  String get authSystemHelp3 => 'Puedes personalizar los encabezados en la pestaña Encabezados.';

  @override
  String get authSystemHelp4 => 'Para sistemas complejos, utiliza la autenticación WebView.';

  @override
  String get webViewHelp1 => 'La autenticación basada en navegador es útil para SSO y sistemas de autenticación complejos.';

  @override
  String get webViewHelp2 => 'La sesión se guarda y se utiliza para solicitudes futuras.';

  @override
  String get webViewHelp3 => 'Las sesiones pueden expirar después de un tiempo.';

  @override
  String get settingsSaved => 'Ajustes guardados';

  @override
  String get send2ereaderService => 'Servicio Send2ereader';

  @override
  String get send2ereaderServiceUrl => 'URL del servicio Send2ereader';

  @override
  String get enterUrlOfYourSend2ereaderService => 'Introduce la URL de tu servicio Send2ereader';

  @override
  String get noFilesSelected => 'No se seleccionaron archivos';

  @override
  String get preparingUpload => 'Preparando carga';

  @override
  String get uploadFailed => 'Error al cargar';

  @override
  String get uploadingBook => 'Cargando libro';

  @override
  String get columnsCount => 'Número de columnas';

  @override
  String get columns => 'Columnas';

  @override
  String get listView => 'Vista de lista';

  @override
  String get uploadEbook => 'Cargar libro electrónico';

  @override
  String get logoutFailed => 'Error al cerrar sesión';

  @override
  String get shelfNotFound => 'Estante no encontrado';

  @override
  String get titleIsRequired => 'El título es obligatorio';

  @override
  String get descriptionIsRequired => 'La descripción es obligatoria';

  @override
  String get downloadCancelled => 'Descarga cancelada';

  @override
  String get transferCancelled => 'Transferencia cancelada';

  @override
  String get logoutConfirmation => '¿Estás seguro de que quieres cerrar sesión?';

  @override
  String get basePathTitle => 'Ruta base de la API';

  @override
  String get basePathLabel => 'Ruta base';

  @override
  String get basePathHint => 'ej., /opds o /calibre';

  @override
  String get basePathDescription => 'Define una ruta base personalizada para las solicitudes de la API';

  @override
  String get bookCover => 'Portada del libro';

  @override
  String get currentCover => 'Portada actual';

  @override
  String get newCover => 'Nueva portada';

  @override
  String get selectCover => 'Seleccionar portada';

  @override
  String get removeCover => 'Eliminar portada';

  @override
  String get removeCoverConfirmation => '¿Estás seguro de que quieres eliminar la portada del libro?';

  @override
  String get remove => 'Eliminar';

  @override
  String get noCover => 'Sin portada';

  @override
  String get loadingBooks => 'Cargando libros...';

  @override
  String get sucessfullyUploadedBook => 'Libro cargado con éxito';

  @override
  String get sslSettings => 'Configuración SSL';

  @override
  String get sslCertificate => 'Certificado SSL';

  @override
  String get settingsForSSL => 'Configuración para certificado SSL';

  @override
  String get allowSelfSignedCertificates => 'Permitir certificados autofirmados';

  @override
  String get allowUnsafeConnections => 'Permitir conexiones inseguras';

  @override
  String get ok => 'Ok';

  @override
  String get attentionSSLCertificate => 'Atención: Los certificados autofirmados pueden ser inseguros. Úsalos solo si entiendes los riesgos.';

  @override
  String get ssoLogin => 'SSO-Iniciar sesión';

  @override
  String get pleaseLoginWithYourSSOAccount => 'Por favor, inicia sesión con tu cuenta SSO. Serás redirigido de vuelta a la aplicación después de iniciar sesión correctamente.';

  @override
  String get loginWithSSO => 'Iniciar sesión con SSO';

  @override
  String get pleaseEnterSSOUrl => 'Por favor, introduce la URL de SSO';

  @override
  String get openInInternalReader => 'Abrir en lector interno';

  @override
  String get errorOpeningBookInInternalReader => 'Error al abrir el libro en el lector interno';

  @override
  String get readNow => 'Leer ahora';

  @override
  String get showReadNowButton => 'Mostrar botón Leer ahora';

  @override
  String get showReadNowButtonDescription => 'Muestra un botón \'Leer ahora\' en los detalles del libro para abrir el libro en el lector interno';

  @override
  String get bookDetails => 'Detalles del libro';

  @override
  String get applyFilters => 'Aplicar filtros';

  @override
  String get any => 'Cualquiera';

  @override
  String get contentType => 'Tipo de contenido';

  @override
  String get author => 'Autor';

  @override
  String get reset => 'Restablecer';

  @override
  String get searchFilters => 'Filtros de búsqueda';

  @override
  String get bookFiction => 'Ficción';

  @override
  String get bookNonFiction => 'No ficción';

  @override
  String get magazine => 'Revista';

  @override
  String get comic => 'Cómic';

  @override
  String get audiobook => 'Audiolibro';

  @override
  String get sectionDisabledOrNotFound => 'Sección no disponible';

  @override
  String get sectionDisabledDescription => 'Esta sección parece estar deshabilitada en la configuración de tu servidor Calibre-Web o no existe.';
}
