// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for English (`en`).
class AppLocalizationsEn extends AppLocalizations {
  AppLocalizationsEn([String locale = 'en']) : super(locale);

  @override
  String get loginToCalibreWb => 'Login to Calibre Web';

  @override
  String get calibreWebUrl => 'https://calibre.example.com';

  @override
  String get enterCalibreWebUrl => 'Enter Calibre Web URL';

  @override
  String get username => 'Username';

  @override
  String get enterYourUsername => 'Enter your username';

  @override
  String get password => 'Password';

  @override
  String get enterYourPassword => 'Enter your password';

  @override
  String get login => 'Login';

  @override
  String get pleaseFillInAllFields => 'Please fill in all fields';

  @override
  String get failedToLognIn => 'Failed to login';

  @override
  String get books => 'Books';

  @override
  String get discover => 'Discover';

  @override
  String get me => 'Me';

  @override
  String get discoverBooks => 'Discover books';

  @override
  String get search => 'Search';

  @override
  String get searchBook => 'Search book';

  @override
  String get enterTitleAuthorOrTags => 'Enter title, author or tags ...';

  @override
  String get showReadBooks => 'Show read books';

  @override
  String get showUnReadBooks => 'Show unread books';

  @override
  String get showBookmarkedBooks => 'Show bookmarked books';

  @override
  String get readBooks => 'Read books';

  @override
  String get unreadBooks => 'Unread books';

  @override
  String get bookmarkedBooks => 'Bookmarked books';

  @override
  String get showHotBooks => 'Show hot books';

  @override
  String get hotBooks => 'Hot books';

  @override
  String get showNewBooks => 'Show new books';

  @override
  String get newBooks => 'New books';

  @override
  String get showRatedBooks => 'Show rated books';

  @override
  String get ratedBooks => 'Rated books';

  @override
  String get titleAZ => 'Title (A-Z)';

  @override
  String get titleZA => 'Title (Z-A)';

  @override
  String get authorAZ => 'Author (A-Z)';

  @override
  String get authorZA => 'Author (Z-A)';

  @override
  String get newestFirst => 'Newest first';

  @override
  String get oldestFirst => 'Oldest first';

  @override
  String get authors => 'Authors';

  @override
  String get categories => 'Categories';

  @override
  String get series => 'Series';

  @override
  String get formats => 'Formats';

  @override
  String get languages => 'Languages';

  @override
  String get publishers => 'Publishers';

  @override
  String get ratings => 'Ratings';

  @override
  String get rating => 'Rating';

  @override
  String get showAuthors => 'Show authors';

  @override
  String get showCategories => 'Show categories';

  @override
  String get showSeries => 'Show series';

  @override
  String get showFormats => 'Show formats';

  @override
  String get showLanguages => 'Show languages';

  @override
  String get showPublishers => 'Show publishers';

  @override
  String get showRatings => 'Show ratings';

  @override
  String by(Object author) {
    return 'by $author';
  }

  @override
  String get book => 'Book';

  @override
  String get publicationInfo => 'Publication info';

  @override
  String get published => 'Published';

  @override
  String get updated => 'Updated';

  @override
  String get publisher => 'Publisher';

  @override
  String get language => 'Language';

  @override
  String get fileInfo => 'File info';

  @override
  String get size => 'Size';

  @override
  String get description => 'Description';

  @override
  String get noCoverAvailable => 'No cover available';

  @override
  String get english => 'English';

  @override
  String get german => 'German';

  @override
  String get french => 'French';

  @override
  String get spanish => 'Spanish';

  @override
  String get italian => 'Italian';

  @override
  String get japanese => 'Japanese';

  @override
  String get russian => 'Russian';

  @override
  String get portuguese => 'Portuguese';

  @override
  String get chineese => 'Chineese';

  @override
  String get dutch => 'Dutch';

  @override
  String get sendToEReader => 'Send to E-Reader';

  @override
  String get sendToKindleKobo => 'Send to Kindle/Kobo';

  @override
  String get enter4DigitCode => 'Enter the 4-digit code displayed on your E-Reader\'s browser:';

  @override
  String get visit => 'Visit';

  @override
  String get onYourEReader => 'on your E-Reader to get a code';

  @override
  String get pleaseEnter4DigitCode => 'Please enter a valid 4-digit code';

  @override
  String get send => 'Send';

  @override
  String get startingDownloadProcess => 'Starting download process';

  @override
  String get preparingTransfer => 'Preparing transfer...';

  @override
  String get downloadingBook => 'Downloading book...';

  @override
  String get sendingToEReader => 'Sending to E-Reader...';

  @override
  String get successfullySentToEReader => 'Successfully sent to E-Reader';

  @override
  String get transferFailed => 'Transfer failed';

  @override
  String get downloadToDevice => 'Download to device';

  @override
  String get errorDownloading => 'Error downloading';

  @override
  String get downlaodFomat => 'Download format';

  @override
  String get preparingDownload => 'Preparing download...';

  @override
  String get selectDownloadDestination => 'Select download destination';

  @override
  String get successfullyDownloadedBook => 'Successfully downloaded book';

  @override
  String get downloadFailed => 'Download failed';

  @override
  String get libraryStatistics => 'Library statistics';

  @override
  String get cancel => 'Cancel';

  @override
  String get close => 'Close';

  @override
  String get retry => 'Retry';

  @override
  String get tryAgain => 'Try again';

  @override
  String get error => 'Error';

  @override
  String get errorLoadingBooks => 'Error loading books';

  @override
  String get errorLoadingData => 'Error loading data';

  @override
  String get erroLoadingBookDetails => 'Error loading book details';

  @override
  String get noBooksFound => 'No books found';

  @override
  String get noDataFound => 'No data found';

  @override
  String get unknownError => 'Unknown error';

  @override
  String get loading => 'Loading...';

  @override
  String get settings => 'Settings';

  @override
  String get appearance => 'Appearance';

  @override
  String get about => 'About';

  @override
  String get themeMode => 'Theme mode';

  @override
  String get systemTheme => 'System theme';

  @override
  String get lightTheme => 'Light theme';

  @override
  String get darkTheme => 'Dark theme';

  @override
  String get downloadService => 'Download service';

  @override
  String get downloads => 'Downloads';

  @override
  String get searchForABook => 'Search for a book';

  @override
  String get noDownloadsFound => 'No downloads found';

  @override
  String foundBooks(Object count) {
    return 'Found $count books';
  }

  @override
  String get addedBookToTheDownloadQueue => 'Added book to the download queue';

  @override
  String get download => 'Download';

  @override
  String get available => 'Available';

  @override
  String get downloading => 'Downloading';

  @override
  String get completed => 'Completed';

  @override
  String get failed => 'Failed';

  @override
  String get queued => 'Queued';

  @override
  String get notDownloaded => 'Not downloaded';

  @override
  String get downloadServiceUrl => 'Download service URL';

  @override
  String get enterUrlOfYourDownloadService => 'Enter URL of your download service';

  @override
  String get bookWillBeSendToYourEmailAdress => 'The book will be sent as EPUB to your registered email address.';

  @override
  String get makeSureEmailSettingsAreConfigured => 'Make sure SMTP mail settings are configured on the server.';

  @override
  String get markAsReadUnread => 'Mark as read/unread';

  @override
  String get archiveUnarchive => 'Archive/Unarchive';

  @override
  String get addToShelf => 'Add to shelf';

  @override
  String get selectShelf => 'Select shelf';

  @override
  String get noShelvesFound => 'No shelves found';

  @override
  String bookAddedToShelf(Object book) {
    return 'Book added to shelf $book';
  }

  @override
  String get failedToAddToShelf => 'Failed to add to shelf';

  @override
  String bookRemovedFromShelf(Object book) {
    return 'Book removed from shelf $book';
  }

  @override
  String get failedToRemoveFromShelf => 'Failed to remove book from shelf';

  @override
  String get removeFromShelf => 'Remove';

  @override
  String get shelfs => 'Shelves';

  @override
  String shelfContains(Object count) {
    return 'Shelf contains $count books';
  }

  @override
  String get errorLoadingShelf => 'Error loading shelf';

  @override
  String get createShelf => 'Create shelf';

  @override
  String get shelfName => 'Shelf name';

  @override
  String get shelfNameRequired => 'Shelf name is required';

  @override
  String get shelfSuccessfullyCreated => 'Shelf successfully created';

  @override
  String errorCreatingShelf(Object name) {
    return 'Error creating shelf $name';
  }

  @override
  String get create => 'Create';

  @override
  String get creating => 'Creating';

  @override
  String get noShelvesFoundCreateOne => 'No shelves found. Create one!';

  @override
  String get editShelf => 'Edit shelf';

  @override
  String get deleteShelf => 'Delete shelf';

  @override
  String get bookOptions => 'Book options';

  @override
  String get successfullyDeletedShelf => 'Successfully deleted shelf';

  @override
  String get failedToDeleteShelf => 'Failed to delete shelf';

  @override
  String get delete => 'Delete';

  @override
  String get deleting => 'Deleting';

  @override
  String get successfullyEditedShelf => 'Successfully edited shelf';

  @override
  String get failedToEditShelf => 'Failed to edit shelf';

  @override
  String get edit => 'Edit';

  @override
  String get editing => 'Editing';

  @override
  String deleteShelfConfirmation(Object name) {
    return 'Are you sure you want to delete the shelf $name?';
  }

  @override
  String get addBooksToShelf => 'Add books to shelf';

  @override
  String get shelfIsEmpty => 'Shelf is empty';

  @override
  String get removing => 'Removing';

  @override
  String get manageBookShelves => 'Manage book shelves';

  @override
  String bookInShelfs(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count shelves',
      one: 'one shelf',
    );
    return 'Book in $_temp0';
  }

  @override
  String get searchForBooks => 'Search for books';

  @override
  String get connectionSettings => 'Connection settings';

  @override
  String get costumHttpPHeader => 'Custom HTTP-Header';

  @override
  String get addHeader => 'Add header';

  @override
  String get httpHeader => 'HTTP-Header';

  @override
  String get addACostumHttpHeaderThatWillBeSentWithEveryRequest => 'Add a custom HTTP-Header that will be sent with every request';

  @override
  String get noCostumHttpHeadersYet => 'No custom HTTP-Header yet';

  @override
  String get header => 'Header';

  @override
  String get headerKey => 'Header key';

  @override
  String get headerValue => 'Header value';

  @override
  String get deleteHeader => 'Delete header';

  @override
  String get urlMustStartWithHttpOrHttps => 'URL must start with http:// or https://';

  @override
  String get connection => 'Connection';

  @override
  String get httpHeaderSettings => 'Authentication settings';

  @override
  String get feedback => 'Feedback';

  @override
  String get reportIssue => 'Report issue';

  @override
  String get reportAppIssueOrSuggestFeature => 'Report app issue or suggest feature';

  @override
  String get title => 'Title';

  @override
  String get required => 'Required';

  @override
  String get submit => 'Submit';

  @override
  String get bookActions => 'Book actions';

  @override
  String get openBookInBrowser => 'Open book in browser';

  @override
  String get metadataUpdateSuccessfully => 'Metadata updated successfully';

  @override
  String get editBookMetadata => 'Edit book metadata';

  @override
  String get updateFailed => 'Update failed';

  @override
  String get save => 'Save';

  @override
  String get separateWithCommas => 'Separate with commas';

  @override
  String get separateWithAnd => 'Separate with \'&\'';

  @override
  String get ratingOneToTen => 'Rating (1-10)';

  @override
  String get markedAsReadSuccessfully => 'Marked as read successfully';

  @override
  String get markedAsReadFailed => 'Failed to mark as read';

  @override
  String get markedAsUnreadSuccessfully => 'Marked as unread successfully';

  @override
  String get markedAsUnreadFailed => 'Failed to mark as unread';

  @override
  String get archivedBookSuccessfully => 'Archived book successfully';

  @override
  String get archivedBookFailed => 'Failed to archive book';

  @override
  String get unarchivedBookSuccessfully => 'Unarchived book successfully';

  @override
  String get unarchivedBookFailed => 'Failed to unarchive book';

  @override
  String get themeColor => 'Theme color';

  @override
  String get system => 'System';

  @override
  String get custom => 'Custom';

  @override
  String get systemThemeDescription => 'The app will use the system theme';

  @override
  String get selectDownloadSchema => 'Select download schema';

  @override
  String get schemaFlat => 'Flat';

  @override
  String get schemaAuthorOnly => 'Author only';

  @override
  String get schemaAuthorBook => 'Author/Book';

  @override
  String get schemaAuthorSeriesBook => 'Author/Series/Book';

  @override
  String get lightGreen => 'Light green';

  @override
  String get amber => 'Amber';

  @override
  String get blueGrey => 'Blue grey';

  @override
  String get grey => 'Grey';

  @override
  String get lightBlue => 'Light blue';

  @override
  String get lime => 'Lime';

  @override
  String get teal => 'Teal';

  @override
  String get appVersion => 'App version';

  @override
  String get bookRecommendations => 'Book recommendations';

  @override
  String get recommendations => 'Recommendations';

  @override
  String get selectABookFromYourLibrary => 'Select a read book from your library';

  @override
  String get searchRecommendations => 'Search recommendations';

  @override
  String get selectBook => 'Select book';

  @override
  String get selectABookToGetRecommendations => 'Select a book to get recommendations';

  @override
  String get noRecommendationsFoundForThisBook => 'No recommendations found for this book';

  @override
  String get bookRecommendationsInfo1 => 'Book recommendations are fetched from ';

  @override
  String get bookRecommendationsInfo2 => ' and work best with English book titles.';

  @override
  String get info => 'Info';

  @override
  String get refresh => 'Refresh';

  @override
  String get noMatchingBooksFound => 'No matching books found';

  @override
  String get bookCouldNotBeFound => 'Book could not be found';

  @override
  String get logout => 'Logout';

  @override
  String get searching => 'Searching...';

  @override
  String get tags => 'Tags';

  @override
  String get recommendedBasedOn => 'Recommended based on';

  @override
  String get storagePermissionRequiredToSelectAFolder => 'Storage permission required to select a folder';

  @override
  String get noFolderWasSelected => 'No folder was selected';

  @override
  String get folderSelectedSuccessfully => 'Folder selected successfully';

  @override
  String get select => 'Select';

  @override
  String get schemaWasSelectedSuccessfully => 'Schema was selected successfully';

  @override
  String get downloadSchema => 'Download schema';

  @override
  String get noFolderSelected => 'No folder selected';

  @override
  String get downloadFolder => 'Download folder';

  @override
  String get openInReader => 'Open in reader';

  @override
  String get bookOpenedExternallySuccessfully => 'Book opened externally successfully';

  @override
  String get openBookExternallyFailed => 'Failed to open book externally';

  @override
  String get headers => 'HTTP Headers';

  @override
  String get authSystems => 'Authentication Systems';

  @override
  String get webViewAuth => 'WebView Authentication';

  @override
  String get basePath => 'Base Path';

  @override
  String get authSystem => 'Authentication System';

  @override
  String get authSystemDescription => 'Choose the authentication system used by your Calibre Web instance';

  @override
  String get webViewAuthentication => 'Browser-Based Authentication';

  @override
  String get browserBasedAuth => 'Authentication via Browser';

  @override
  String get webViewAuthDescription => 'Log in using a browser for advanced authentication systems like SSO';

  @override
  String get webViewSessionActive => 'Active browser session detected';

  @override
  String get webViewSessionInactive => 'No active browser session found';

  @override
  String get lastAuthentication => 'Last Authentication:';

  @override
  String get authenticate => 'Authenticate';

  @override
  String get clearSession => 'Clear Session';

  @override
  String get authenticationSuccessful => 'Authentication was successful';

  @override
  String get sessionCleared => 'Session has been cleared';

  @override
  String get webViewAuthInstructions => 'Login Instructions';

  @override
  String get webViewSessionSaved => 'Browser session saved successfully';

  @override
  String get saveSession => 'Save Session';

  @override
  String get reload => 'Reload';

  @override
  String get homePage => 'Home Page';

  @override
  String get serverUrlMissing => 'Server URL is missing';

  @override
  String get pleaseConfigureServerURL => 'Please configure the server URL in the settings first';

  @override
  String get goBack => 'Go Back';

  @override
  String get helpAndInfo => 'Help & Information';

  @override
  String get authSystemHelp1 => 'Authentication systems may require specific HTTP headers.';

  @override
  String get authSystemHelp2 => 'Predefined configurations are available for common systems.';

  @override
  String get authSystemHelp3 => 'You can customize headers in the Headers tab.';

  @override
  String get authSystemHelp4 => 'For advanced systems, use WebView Authentication instead.';

  @override
  String get webViewHelp1 => 'Browser-based authentication is ideal for SSO and advanced systems.';

  @override
  String get webViewHelp2 => 'The session is saved and reused for future requests.';

  @override
  String get webViewHelp3 => 'Sessions may expire after a certain period.';

  @override
  String get settingsSaved => 'Settings saved successfully';

  @override
  String get send2ereaderService => 'Send2Ereader service';

  @override
  String get send2ereaderServiceUrl => 'Send2Ereader service URL';

  @override
  String get enterUrlOfYourSend2ereaderService => 'Enter the URL of your Send2Ereader service';

  @override
  String get noFilesSelected => 'No files selected';

  @override
  String get preparingUpload => 'Preparing upload';

  @override
  String get uploadFailed => 'Upload failed';

  @override
  String get uploadingBook => 'Uploading book';

  @override
  String get columnsCount => 'Columns count';

  @override
  String get columns => 'Columns';

  @override
  String get listView => 'List view';

  @override
  String get uploadEbook => 'Upload eBook';

  @override
  String get logoutFailed => 'Logout failed';

  @override
  String get shelfNotFound => 'Shelf not found';

  @override
  String get titleIsRequired => 'Title is required';

  @override
  String get descriptionIsRequired => 'Description is required';

  @override
  String get downloadCancelled => 'Download cancelled';

  @override
  String get transferCancelled => 'Transfer cancelled';

  @override
  String get logoutConfirmation => 'Are you sure you want to logout?';

  @override
  String get basePathTitle => 'API Base Path';

  @override
  String get basePathLabel => 'Base Path';

  @override
  String get basePathHint => 'e.g., /opds or /calibre';

  @override
  String get basePathDescription => 'Define a custom base path for API requests';

  @override
  String get bookCover => 'Book cover';

  @override
  String get currentCover => 'Current cover';

  @override
  String get newCover => 'New cover';

  @override
  String get selectCover => 'Select cover';

  @override
  String get removeCover => 'Remove cover';

  @override
  String get removeCoverConfirmation => 'Are you sure you want to remove the cover?';

  @override
  String get remove => 'Remove';

  @override
  String get noCover => 'No cover';

  @override
  String get loadingBooks => 'Loading books...';

  @override
  String get sucessfullyUploadedBook => 'Successfully uploaded book';

  @override
  String get sslSettings => 'SSL Settings';

  @override
  String get sslCertificate => 'SSL Certificate';

  @override
  String get settingsForSSL => 'Settings for SSL certificate';

  @override
  String get allowSelfSignedCertificates => 'Allow self-signed certificates';

  @override
  String get allowUnsafeConnections => 'Allow unsafe connections';

  @override
  String get ok => 'Ok';

  @override
  String get attentionSSLCertificate => 'Attention: Self-signed certificates can be insecure. Use them only if you understand the risks.';

  @override
  String get ssoLogin => 'SSO-Login';

  @override
  String get pleaseLoginWithYourSSOAccount => 'Please login with your SSO account. You will be redirected back to the app after successful login.';

  @override
  String get loginWithSSO => 'Login with SSO';

  @override
  String get pleaseEnterSSOUrl => 'Please enter the SSO URL';

  @override
  String get openInInternalReader => 'Open in Internal Reader';

  @override
  String get errorOpeningBookInInternalReader => 'Error opening book in internal reader';

  @override
  String get readNow => 'Read Now';

  @override
  String get showReadNowButton => 'Show \'Read Now\' button';

  @override
  String get showReadNowButtonDescription => 'Replaces the \'Send to E-Reader\' button with a \'Read Now\' button to open books directly.';

  @override
  String get bookDetails => 'Book Details';

  @override
  String get applyFilters => 'Apply Filters';

  @override
  String get any => 'Any';

  @override
  String get contentType => 'Content Type';

  @override
  String get author => 'Author';

  @override
  String get reset => 'Reset';

  @override
  String get searchFilters => 'Search Filters';

  @override
  String get bookFiction => 'Book (Fiction)';

  @override
  String get bookNonFiction => 'Book (Non-Fiction)';

  @override
  String get magazine => 'Magazine';

  @override
  String get comic => 'Comic';

  @override
  String get audiobook => 'Audiobook';

  @override
  String get sectionDisabledOrNotFound => 'Section unavailable';

  @override
  String get sectionDisabledDescription => 'This section appears to be disabled in your Calibre-Web server settings or does not exist.';
}
