// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for German (`de`).
class AppLocalizationsDe extends AppLocalizations {
  AppLocalizationsDe([String locale = 'de']) : super(locale);

  @override
  String get loginToCalibreWb => 'Melde dich bei Calibre Web an';

  @override
  String get calibreWebUrl => 'https://calibre.example.com';

  @override
  String get enterCalibreWebUrl => 'Gib die Calibre Web URL ein';

  @override
  String get username => 'Benutzername';

  @override
  String get enterYourUsername => 'Gib deinen Benutzernamen ein';

  @override
  String get password => 'Passwort';

  @override
  String get enterYourPassword => 'Gib dein Passwort ein';

  @override
  String get login => 'Anmelden';

  @override
  String get pleaseFillInAllFields => 'Bitte fülle alle Felder aus';

  @override
  String get failedToLognIn => 'Anmeldung fehlgeschlagen';

  @override
  String get books => 'Bücher';

  @override
  String get discover => 'Entdecken';

  @override
  String get me => 'Ich';

  @override
  String get discoverBooks => 'Bücher entdecken';

  @override
  String get search => 'Suchen';

  @override
  String get searchBook => 'Buch suchen';

  @override
  String get enterTitleAuthorOrTags => 'Titel, Autor oder Tags eingeben ...';

  @override
  String get showReadBooks => 'Gelesene Bücher';

  @override
  String get showUnReadBooks => 'Ungelesene Bücher';

  @override
  String get showBookmarkedBooks => 'Gemerkte Bücher';

  @override
  String get readBooks => 'Gelesene Bücher';

  @override
  String get unreadBooks => 'Ungelesene Bücher';

  @override
  String get bookmarkedBooks => 'Gemerkte Bücher';

  @override
  String get showHotBooks => 'Heiße Bücher';

  @override
  String get hotBooks => 'Heiße Bücher';

  @override
  String get showNewBooks => 'Neue Bücher';

  @override
  String get newBooks => 'Neue Bücher';

  @override
  String get showRatedBooks => 'Bewertete Bücher';

  @override
  String get ratedBooks => 'Bewertete Bücher';

  @override
  String get titleAZ => 'Titel (A-Z)';

  @override
  String get titleZA => 'Titel (Z-A)';

  @override
  String get authorAZ => 'Autor (A-Z)';

  @override
  String get authorZA => 'Autor (Z-A)';

  @override
  String get newestFirst => 'Neueste zuerst';

  @override
  String get oldestFirst => 'Älteste zuerst';

  @override
  String get authors => 'Autoren';

  @override
  String get categories => 'Kategorien';

  @override
  String get series => 'Serien';

  @override
  String get formats => 'Formate';

  @override
  String get languages => 'Sprachen';

  @override
  String get publishers => 'Verlage';

  @override
  String get ratings => 'Bewertungen';

  @override
  String get rating => 'Bewertung';

  @override
  String get showAuthors => 'Autoren';

  @override
  String get showCategories => 'Kategorien';

  @override
  String get showSeries => 'Serien';

  @override
  String get showFormats => 'Formate';

  @override
  String get showLanguages => 'Sprachen';

  @override
  String get showPublishers => 'Verlage';

  @override
  String get showRatings => 'Bewertungen';

  @override
  String by(Object author) {
    return 'von $author';
  }

  @override
  String get book => 'Buch';

  @override
  String get publicationInfo => 'Veröffentlichungsinformationen';

  @override
  String get published => 'Veröffentlicht';

  @override
  String get updated => 'Aktualisiert';

  @override
  String get publisher => 'Verlag';

  @override
  String get language => 'Sprache';

  @override
  String get fileInfo => 'Dateiinformationen';

  @override
  String get size => 'Größe';

  @override
  String get description => 'Beschreibung';

  @override
  String get noCoverAvailable => 'Kein Cover verfügbar';

  @override
  String get english => 'Englisch';

  @override
  String get german => 'Deutsch';

  @override
  String get french => 'Französisch';

  @override
  String get spanish => 'Spanisch';

  @override
  String get italian => 'Italienisch';

  @override
  String get japanese => 'Japanisch';

  @override
  String get russian => 'Russisch';

  @override
  String get portuguese => 'Portugiesisch';

  @override
  String get chineese => 'Chinesisch';

  @override
  String get dutch => 'Niederländisch';

  @override
  String get sendToEReader => 'An E-Reader senden';

  @override
  String get sendToKindleKobo => 'An Kindle/Kobo senden';

  @override
  String get enter4DigitCode => 'Gib den 4-stelligen Code ein der auf dem Browser deines E-Readers angezeigt wird:';

  @override
  String get visit => 'Besuche';

  @override
  String get onYourEReader => 'auf deinem E-Reader um einen Code zu erhalten';

  @override
  String get pleaseEnter4DigitCode => 'Bitte gib einen gültigen 4-stelligen Code ein';

  @override
  String get send => 'Senden';

  @override
  String get startingDownloadProcess => 'Downloadprozess starten';

  @override
  String get preparingTransfer => 'Transfer vorbereiten...';

  @override
  String get downloadingBook => 'Buch herunterladen...';

  @override
  String get sendingToEReader => 'An E-Reader senden...';

  @override
  String get successfullySentToEReader => 'Erfolgreich an E-Reader gesendet';

  @override
  String get transferFailed => 'Transfer fehlgeschlagen';

  @override
  String get downloadToDevice => 'Auf Gerät herunterladen';

  @override
  String get errorDownloading => 'Fehler beim Herunterladen';

  @override
  String get downlaodFomat => 'Downloadformat';

  @override
  String get preparingDownload => 'Download vorbereiten...';

  @override
  String get selectDownloadDestination => 'Downloadziel auswählen';

  @override
  String get successfullyDownloadedBook => 'Buch erfolgreich heruntergeladen';

  @override
  String get downloadFailed => 'Download fehlgeschlagen';

  @override
  String get libraryStatistics => 'Bibliotheksstatistiken';

  @override
  String get cancel => 'Abbrechen';

  @override
  String get close => 'Schließen';

  @override
  String get retry => 'Wiederholen';

  @override
  String get tryAgain => 'Erneut versuchen';

  @override
  String get error => 'Fehler';

  @override
  String get errorLoadingBooks => 'Fehler beim Laden der Bücher';

  @override
  String get errorLoadingData => 'Fehler beim Laden der Daten';

  @override
  String get erroLoadingBookDetails => 'Fehler beim Laden der Buchdetails';

  @override
  String get noBooksFound => 'Keine Bücher gefunden';

  @override
  String get noDataFound => 'Keine Daten gefunden';

  @override
  String get unknownError => 'Unbekannter Fehler';

  @override
  String get loading => 'Laden...';

  @override
  String get settings => 'Einstellungen';

  @override
  String get appearance => 'Erscheinungsbild';

  @override
  String get about => 'Über';

  @override
  String get themeMode => 'Themenmodus';

  @override
  String get systemTheme => 'Systemthema';

  @override
  String get lightTheme => 'Helles Thema';

  @override
  String get darkTheme => 'Dunkles Thema';

  @override
  String get downloadService => 'Download-Service';

  @override
  String get downloads => 'Downloads';

  @override
  String get searchForABook => 'Suche nach einem Buch';

  @override
  String get noDownloadsFound => 'Keine Downloads gefunden';

  @override
  String foundBooks(Object count) {
    return '$count Bücher gefunden';
  }

  @override
  String get addedBookToTheDownloadQueue => 'Buch zur Download-Warteschlange hinzugefügt';

  @override
  String get download => 'Herunterladen';

  @override
  String get available => 'Verfügbar';

  @override
  String get downloading => 'Herunterladen';

  @override
  String get completed => 'Abgeschlossen';

  @override
  String get failed => 'Fehlgeschlagen';

  @override
  String get queued => 'In Warteschlange';

  @override
  String get notDownloaded => 'Nicht heruntergeladen';

  @override
  String get downloadServiceUrl => 'Download-Service-URL';

  @override
  String get enterUrlOfYourDownloadService => 'Gib die URL deines Download-Services ein';

  @override
  String get bookWillBeSendToYourEmailAdress => 'Das Buch wird als EPUB an deine registrierte E-Mail-Adresse gesendet.';

  @override
  String get makeSureEmailSettingsAreConfigured => 'Stelle sicher, dass die SMTP-Mail-Einstellungen auf dem Server konfiguriert sind.';

  @override
  String get markAsReadUnread => 'Als gelesen/ungelesen markieren';

  @override
  String get archiveUnarchive => 'Archivieren/Archivierung aufheben';

  @override
  String get addToShelf => 'Zum Regal hinzufügen';

  @override
  String get selectShelf => 'Regal auswählen';

  @override
  String get noShelvesFound => 'Keine Regale gefunden';

  @override
  String bookAddedToShelf(Object book) {
    return 'Buch zum Regal hinzugefügt $book';
  }

  @override
  String get failedToAddToShelf => 'Fehler beim Hinzufügen zum Regal';

  @override
  String bookRemovedFromShelf(Object book) {
    return 'Buch aus Regal entfernt $book';
  }

  @override
  String get failedToRemoveFromShelf => 'Fehler beim Entfernen aus dem Regal';

  @override
  String get removeFromShelf => 'Entfernen';

  @override
  String get shelfs => 'Regale';

  @override
  String shelfContains(Object count) {
    return 'Regal enthält $count Bücher';
  }

  @override
  String get errorLoadingShelf => 'Fehler beim Laden des Regals';

  @override
  String get createShelf => 'Regal erstellen';

  @override
  String get shelfName => 'Regalname';

  @override
  String get shelfNameRequired => 'Regalname ist erforderlich';

  @override
  String get shelfSuccessfullyCreated => 'Regal erfolgreich erstellt';

  @override
  String errorCreatingShelf(Object name) {
    return 'Fehler beim Erstellen des Regals $name';
  }

  @override
  String get create => 'Erstellen';

  @override
  String get creating => 'Erstellen...';

  @override
  String get noShelvesFoundCreateOne => 'Keine Regale gefunden. Erstelle eins!';

  @override
  String get editShelf => 'Regal bearbeiten';

  @override
  String get deleteShelf => 'Regal löschen';

  @override
  String get bookOptions => 'Buchoptionen';

  @override
  String get successfullyDeletedShelf => 'Regal erfolgreich gelöscht';

  @override
  String get failedToDeleteShelf => 'Fehler beim Löschen des Regals';

  @override
  String get delete => 'Löschen';

  @override
  String get deleting => 'Löschen...';

  @override
  String get successfullyEditedShelf => 'Regal erfolgreich bearbeitet';

  @override
  String get failedToEditShelf => 'Fehler beim Bearbeiten des Regals';

  @override
  String get edit => 'Bearbeiten';

  @override
  String get editing => 'Bearbeiten...';

  @override
  String deleteShelfConfirmation(Object name) {
    return 'Bist du sicher, dass du das Regal $name löschen möchtest?';
  }

  @override
  String get addBooksToShelf => 'Bücher zum Regal hinzufügen';

  @override
  String get shelfIsEmpty => 'Regal ist leer';

  @override
  String get removing => 'Entfernen...';

  @override
  String get manageBookShelves => 'Bücherregale verwalten';

  @override
  String bookInShelfs(num count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Regalen',
      one: 'einem Regal',
    );
    return 'Buch in $_temp0';
  }

  @override
  String get searchForBooks => 'Suche nach Büchern';

  @override
  String get connectionSettings => 'Verbindungseinstellungen';

  @override
  String get costumHttpPHeader => 'Benutzerdefinierter HTTP-Header';

  @override
  String get addHeader => 'Header hinzufügen';

  @override
  String get httpHeader => 'HTTP-Header';

  @override
  String get addACostumHttpHeaderThatWillBeSentWithEveryRequest => 'Fügen Sie einen benutzerdefinierten HTTP-Header hinzu, der bei jeder Anfrage gesendet wird';

  @override
  String get noCostumHttpHeadersYet => 'Noch keine benutzerdefinierten HTTP-Header';

  @override
  String get header => 'Header';

  @override
  String get headerKey => 'Header-Schlüssel';

  @override
  String get headerValue => 'Header-Wert';

  @override
  String get deleteHeader => 'Header löschen';

  @override
  String get urlMustStartWithHttpOrHttps => 'URL muss mit http:// oder https:// beginnen';

  @override
  String get connection => 'Verbindung';

  @override
  String get httpHeaderSettings => 'Authentifizierungs Einstellungen';

  @override
  String get feedback => 'Feedback';

  @override
  String get reportIssue => 'Problem melden';

  @override
  String get reportAppIssueOrSuggestFeature => 'App-Problem melden oder Funktion vorschlagen';

  @override
  String get title => 'Titel';

  @override
  String get required => 'Erforderlich';

  @override
  String get submit => 'Absenden';

  @override
  String get bookActions => 'Buchaktionen';

  @override
  String get openBookInBrowser => 'Buch im Browser öffnen';

  @override
  String get metadataUpdateSuccessfully => 'Metadaten erfolgreich aktualisiert';

  @override
  String get editBookMetadata => 'Buchmetadaten bearbeiten';

  @override
  String get updateFailed => 'Aktualisierung fehlgeschlagen';

  @override
  String get save => 'Speichern';

  @override
  String get separateWithCommas => 'Mit Kommas trennen';

  @override
  String get separateWithAnd => 'Mit \'&\' trennen';

  @override
  String get ratingOneToTen => 'Bewertung (1-10)';

  @override
  String get markedAsReadSuccessfully => 'Erfolgreich als gelesen/ungelesen markiert';

  @override
  String get markedAsReadFailed => 'Fehler beim Markieren als gelesen/ungelesen';

  @override
  String get markedAsUnreadSuccessfully => 'Erfolgreich als ungelesen markiert';

  @override
  String get markedAsUnreadFailed => 'Fehler beim Markieren als ungelesen';

  @override
  String get archivedBookSuccessfully => 'Buch erfolgreich archiviert';

  @override
  String get archivedBookFailed => 'Fehler beim Archivieren des Buches';

  @override
  String get unarchivedBookSuccessfully => 'Buch erfolgreich aus der Archivierung geholt';

  @override
  String get unarchivedBookFailed => 'Fehler beim Aufheben der Archivierung des Buches';

  @override
  String get themeColor => 'Themenfarbe';

  @override
  String get system => 'System';

  @override
  String get custom => 'Benutzerdefiniert';

  @override
  String get systemThemeDescription => 'Die App verwendet das Systemthema';

  @override
  String get selectDownloadSchema => 'Download-Schema auswählen';

  @override
  String get schemaFlat => 'Flach';

  @override
  String get schemaAuthorOnly => 'Nur Autor';

  @override
  String get schemaAuthorBook => 'Autor/Buch';

  @override
  String get schemaAuthorSeriesBook => 'Autor/Serie/Buch';

  @override
  String get lightGreen => 'Hellgrün';

  @override
  String get amber => 'Bernstein';

  @override
  String get blueGrey => 'Blaugrau';

  @override
  String get grey => 'Grau';

  @override
  String get lightBlue => 'Hellblau';

  @override
  String get lime => 'Limette';

  @override
  String get teal => 'Türkis';

  @override
  String get appVersion => 'App-Version';

  @override
  String get bookRecommendations => 'Buch-Empfehlungen';

  @override
  String get recommendations => 'Empfehlungen';

  @override
  String get selectABookFromYourLibrary => 'Wähle ein gelesenes Buch aus deiner Bibliothek';

  @override
  String get searchRecommendations => 'Empfehlungen suchen';

  @override
  String get selectBook => 'Buch auswählen';

  @override
  String get selectABookToGetRecommendations => 'Wähle ein Buch, um Empfehlungen zu erhalten';

  @override
  String get noRecommendationsFoundForThisBook => 'Keine Empfehlungen für dieses Buch gefunden';

  @override
  String get bookRecommendationsInfo1 => 'Buch-Empfehlungen werden von ';

  @override
  String get bookRecommendationsInfo2 => ' abgerufen und funktionieren am besten mit englischen Buchtiteln.';

  @override
  String get info => 'Info';

  @override
  String get refresh => 'Aktualisieren';

  @override
  String get noMatchingBooksFound => 'Keine passenden Bücher gefunden';

  @override
  String get bookCouldNotBeFound => 'Buch konnte nicht gefunden werden';

  @override
  String get logout => 'Abmelden';

  @override
  String get searching => 'Suchen...';

  @override
  String get tags => 'Tags';

  @override
  String get recommendedBasedOn => 'Empfohlen basierend auf';

  @override
  String get storagePermissionRequiredToSelectAFolder => 'Speicherberechtigung erforderlich, um einen Ordner auszuwählen';

  @override
  String get noFolderWasSelected => 'Es wurde kein Ordner ausgewählt';

  @override
  String get folderSelectedSuccessfully => 'Ordner erfolgreich ausgewählt';

  @override
  String get select => 'Auswählen';

  @override
  String get schemaWasSelectedSuccessfully => 'Schema erfolgreich ausgewählt';

  @override
  String get downloadSchema => 'Download-Schema';

  @override
  String get noFolderSelected => 'Kein Ordner ausgewählt';

  @override
  String get downloadFolder => 'Download-Ordner';

  @override
  String get openInReader => 'In E-Book App öffnen';

  @override
  String get bookOpenedExternallySuccessfully => 'Buch wurde in externer App geöffnet';

  @override
  String get openBookExternallyFailed => 'Buch konnte nicht in externer App geöffnet werden';

  @override
  String get headers => 'Header';

  @override
  String get authSystems => 'Authentifizierungssysteme';

  @override
  String get webViewAuth => 'WebView-Authentifizierung';

  @override
  String get basePath => 'Basis-Pfad';

  @override
  String get authSystem => 'Authentifizierungssystem';

  @override
  String get authSystemDescription => 'Wählen Sie das Authentifizierungssystem aus, hinter dem Ihre Calibre-Web-Instanz läuft';

  @override
  String get webViewAuthentication => 'Browser-Authentifizierung';

  @override
  String get browserBasedAuth => 'Browserbasierte Authentifizierung';

  @override
  String get webViewAuthDescription => 'Melden Sie sich über den Browser für komplexe Authentifizierungssysteme wie SSO an';

  @override
  String get webViewSessionActive => 'Aktive Browsersitzung verfügbar';

  @override
  String get webViewSessionInactive => 'Keine aktive Browsersitzung';

  @override
  String get lastAuthentication => 'Letzte Authentifizierung:';

  @override
  String get authenticate => 'Authentifizieren';

  @override
  String get clearSession => 'Sitzung löschen';

  @override
  String get authenticationSuccessful => 'Authentifizierung erfolgreich';

  @override
  String get sessionCleared => 'Sitzung gelöscht';

  @override
  String get webViewAuthInstructions => 'Anmeldeanweisungen';

  @override
  String get webViewSessionSaved => 'Browsersitzung erfolgreich gespeichert';

  @override
  String get saveSession => 'Sitzung speichern';

  @override
  String get reload => 'Neu laden';

  @override
  String get homePage => 'Startseite';

  @override
  String get serverUrlMissing => 'Server-URL fehlt';

  @override
  String get pleaseConfigureServerURL => 'Bitte konfigurieren Sie zuerst die Server-URL in den Einstellungen';

  @override
  String get goBack => 'Zurück';

  @override
  String get helpAndInfo => 'Hilfe & Informationen';

  @override
  String get authSystemHelp1 => 'Authentifizierungssysteme können spezifische HTTP-Header erfordern.';

  @override
  String get authSystemHelp2 => 'Vordefinierte Konfigurationen sind für gängige Systeme verfügbar.';

  @override
  String get authSystemHelp3 => 'Sie können Header im Tab \'Header\' anpassen.';

  @override
  String get authSystemHelp4 => 'Für komplexe Systeme verwenden Sie stattdessen die WebView-Authentifizierung.';

  @override
  String get webViewHelp1 => 'Die Browser-Authentifizierung ist nützlich für SSO und komplexe Authentifizierungssysteme.';

  @override
  String get webViewHelp2 => 'Die Sitzung wird gespeichert und für zukünftige Anfragen verwendet.';

  @override
  String get webViewHelp3 => 'Sitzungen können nach einiger Zeit ablaufen.';

  @override
  String get settingsSaved => 'Einstellungen gespeichert';

  @override
  String get send2ereaderService => 'Send2ereader-Service';

  @override
  String get send2ereaderServiceUrl => 'Send2ereader-Service-URL';

  @override
  String get enterUrlOfYourSend2ereaderService => 'Gib die URL deines Send2ereader-Services ein';

  @override
  String get noFilesSelected => 'Keine Dateien ausgewählt';

  @override
  String get preparingUpload => 'Upload vorbereiten';

  @override
  String get uploadFailed => 'Upload fehlgeschlagen';

  @override
  String get uploadingBook => 'Buch hochladen';

  @override
  String get columnsCount => 'Anzahl der Spalten';

  @override
  String get columns => 'Spalten';

  @override
  String get listView => 'Listenansicht';

  @override
  String get uploadEbook => 'E-Book hochladen';

  @override
  String get logoutFailed => 'Abmeldung fehlgeschlagen';

  @override
  String get shelfNotFound => 'Regal nicht gefunden';

  @override
  String get titleIsRequired => 'Titel ist erforderlich';

  @override
  String get descriptionIsRequired => 'Beschreibung ist erforderlich';

  @override
  String get downloadCancelled => 'Download abgebrochen';

  @override
  String get transferCancelled => 'Transfer abgebrochen';

  @override
  String get logoutConfirmation => 'Bist du sicher, dass du dich abmelden möchtest?';

  @override
  String get basePathTitle => 'API-Basis-Pfad';

  @override
  String get basePathLabel => 'Basis-Pfad';

  @override
  String get basePathHint => 'z.B. /opds oder /calibre';

  @override
  String get basePathDescription => 'Definiere einen benutzerdefinierten Basis-Pfad für API-Anfragen';

  @override
  String get bookCover => 'Buchcover';

  @override
  String get currentCover => 'Aktuelles Cover';

  @override
  String get newCover => 'Neues Cover';

  @override
  String get selectCover => 'Cover auswählen';

  @override
  String get removeCover => 'Cover entfernen';

  @override
  String get removeCoverConfirmation => 'Bist du sicher, dass du das Cover entfernen möchtest?';

  @override
  String get remove => 'Entfernen';

  @override
  String get noCover => 'Kein Cover';

  @override
  String get loadingBooks => 'Bücher werden geladen...';

  @override
  String get sucessfullyUploadedBook => 'Buch erfolgreich hochgeladen';

  @override
  String get sslSettings => 'SSL-Einstellungen';

  @override
  String get sslCertificate => 'SSL-Zertifikat';

  @override
  String get settingsForSSL => 'Einstellungen für SSL-Zertifikat';

  @override
  String get allowSelfSignedCertificates => 'Selbstsignierte Zertifikate zulassen';

  @override
  String get allowUnsafeConnections => 'Unsichere Verbindungen zulassen';

  @override
  String get ok => 'Ok';

  @override
  String get attentionSSLCertificate => 'Achtung: Selbstsignierte Zertifikate können unsicher sein. Verwende sie nur, wenn du die Risiken verstehst.';

  @override
  String get ssoLogin => 'SSO-Anmeldung';

  @override
  String get pleaseLoginWithYourSSOAccount => 'Bitte melde dich mit deinem SSO-Konto an. Du wirst nach der Anmeldung automatisch zur App zurückgeleitet.';

  @override
  String get loginWithSSO => 'Mit SSO anmelden';

  @override
  String get pleaseEnterSSOUrl => 'Bitte gib die SSO-URL ein';

  @override
  String get openInInternalReader => 'Im internen Reader öffnen';

  @override
  String get errorOpeningBookInInternalReader => 'Fehler beim Öffnen des Buches im internen Reader';

  @override
  String get readNow => 'Jetzt lesen';

  @override
  String get showReadNowButton => '\'Jetzt lesen\' Button anzeigen';

  @override
  String get showReadNowButtonDescription => 'Ersetzt den \'An E-Reader senden\' Button durch \'Jetzt lesen\', um Bücher direkt zu öffnen.';

  @override
  String get bookDetails => 'Buchdetails';

  @override
  String get applyFilters => 'Filter anwenden';

  @override
  String get any => 'Beliebig';

  @override
  String get contentType => 'Inhaltstyp';

  @override
  String get author => 'Autor';

  @override
  String get reset => 'Zurücksetzen';

  @override
  String get searchFilters => 'Suchfilter';

  @override
  String get bookFiction => 'Buch (Fiktion)';

  @override
  String get bookNonFiction => 'Buch (Sachbuch)';

  @override
  String get magazine => 'Magazin';

  @override
  String get comic => 'Comic';

  @override
  String get audiobook => 'Hörbuch';

  @override
  String get sectionDisabledOrNotFound => 'Bereich nicht verfügbar';

  @override
  String get sectionDisabledDescription => 'Dieser Bereich scheint in deinen Calibre-Web Servereinstellungen deaktiviert zu sein oder existiert nicht.';
}
