<p align="center">
    <img src="docs/icon/icon.png" alt="App Icon" width="100" />
    <br>
    v1.8.0
</p>

<p align="center">
    <a href="https://github.com/doen1el/calibre-web-companion/releases">
        <img src="https://img.shields.io/github/downloads/doen1el/calibre-web-companion/total?color=green&label=github%20downloads" alt="GitHub all releases">
    </a>
    <a href="https://github.com/doen1el/calibre-web-companion/releases">
        <img src="https://img.shields.io/github/v/release/doen1el/calibre-web-companion?color=green&label=download&sort=semver" alt="GitHub release (latest SemVer)">
    </a>
    <a href="https://github.com/doen1el/calibre-web-companion/actions?query=workflow%3ABuild+branch%3Adev">
        <img src="https://img.shields.io/github/actions/workflow/status/doen1el/calibre-web-companion/main.yml?branch=dev" alt="GitHub Workflow Status">
    </a>
    <a href="https://hosted.weblate.org/engage/calibre-web-companion/">
        <img src="https://hosted.weblate.org/widget/calibre-web-companion/svg-badge.svg" alt="Translation status" />
    </a>
</p>

# Calibre Web Companion

This is an unofficial companion application for [Calibre Web](https://github.com/janeczku/calibre-web) (which also works for [Calibre Web Automated](https://github.com/crocodilestick/Calibre-Web-Automated)) that allows you to browse your book collection and download books directly to your device. You can also interact with your books by marking them as read, unread or bookmarked. It is also possible to send books directly to your e-reader (Kindle/Kobo) thanks to the great work of [send2ereader](https://github.com/daniel-j/send2ereader).

The app is built with [Flutter](https://github.com/flutter/flutter) and uses **Material You**. It is currently available for **Android** only.

## 📦 Installation

<p align="left">
    <a href="https://f-droid.org/en/packages/de.doen1el.calibreWebCompanion/">
        <img src="https://f-droid.org/badge/get-it-on.png" alt="Get it on F-Droid" height="80">
    </a>
    <a href="https://play.google.com/store/apps/details?id=de.doen1el.calibreWebCompanion">
        <img src="docs/badges/badge_play.png" alt="Get it on Google Play" height="80">
    </a>
    <a href="https://github.com/doen1el/calibre-web-companion/releases">
        <img src="docs/badges/badge_github.png" alt="Get it on GitHub" height="80">
    </a>
    <a href="https://github.com/doen1el/calibre-web-companion/wiki/Installing-Calibre%E2%80%90Web%E2%80%90Companion-from-GitHub-using-Obtainium">
        <img src="docs/badges/badge_obtainium.png" alt="Get it on Obtainium" height="80">
    </a>
</p>

## 💪 Features

- Log into your Calibre Web (Automated) server.
- Enjoy seamless navigation through your book collection.
- Explore books organized by various categories, such as author, series, trending, and more.
- View detailed information about each book.
- Easily mark books as read or unread, organize them into shelves, or archive them.
- Access comprehensive collection statistics at a glance.
- Download books directly onto your device.
- Instantly send books to your e-reader using [send2ereader](https://github.com/daniel-j/send2ereader) or via Calibre Web's mail function. You can also use your own send2ereader instance.
- Automatically download books to your collection with [calibre-web-automated-book-downloader](https://github.com/calibrain/calibre-web-automated-book-downloader).
- Manage and customize your shelves.
- Upload books to your Calibre Web server.
- Edit your book's metadata and upload new covers.

## 🖼️ Impressions

<p align="center">
    <img src="docs/feature_graphics/1.png" alt="InApp" width="32%"/>
    <img src="docs/feature_graphics/2.png" alt="Share" width="32%" />
    <img src="docs/feature_graphics/3.png" alt="OpenTracks" width="32%" />
    <img src="docs/feature_graphics/4.png" alt="OpenTracks" width="32%" />
    <img src="docs/feature_graphics/5.png" alt="OpenTracks" width="32%" />
    <img src="docs/feature_graphics/6.png" alt="OpenTracks" width="32%" />
</p>

## 🌍 l10n

You can help translate Calibre Web Companion on [Weblate](https://hosted.weblate.org/projects/calibre-web-companion/app/).

<a href="https://hosted.weblate.org/engage/calibre-web-companion/">
<img src="https://hosted.weblate.org/widget/calibre-web-companion/app/multi-auto.svg" alt="Translation status" />
</a>

## 🚀 Contributing

You can of course open issues for bugs, feedback, and feature ideas. All suggestions are very welcome :)

## 🚧 Roadmap

- [x] Add localization
- [x] Add dark mode
- [x] Toggle read/unread status
- [x] Add bookmark function
- [x] Calibre Web Automated Download integration
- [x] Add and remove from shelfs
- [x] Code refactoring
- [x] Better error handling
- [x] Integrate [Weblate](https://hosted.weblate.org/) for translations

## 📜 Credits

- [Calibre Web](https://github.com/janeczku/calibre-web)
- [Calibre Web Automated](https://github.com/crocodilestick/Calibre-Web-Automated)
- [calibre-web-automated-book-downloader](https://github.com/calibrain/calibre-web-automated-book-downloader)
- [send2ereader](https://github.com/daniel-j/send2ereader)
- [Flutter](https://github.com/flutter/flutter)
- [IconKitchen](https://icon.kitchen)
- [Weblate](https://hosted.weblate.org/)
