# How to contribute?

## Testing

Just use OpenTracks and tell us what can be improved by opening an
issue [here](https://codeberg.org/OpenTracksApp/OpenTracks/issues/new/choose).

If we broke things (happens now and then), please tell us also.

## Translations

Translations are hosted on [hosted.weblate.org](https://hosted.weblate.org/engage/opentracks/).

## Coding new features

You have a cool idea for a feature that is missing in OpenTracks?
And you would like to help by implementing it?
If not, you can just take a look at
the [issue tracker](https://codeberg.org/OpenTracksApp/OpenTracks/issues).

Advices:

* creating an issue beforehand might be a good idea
  Sometimes it is helpful to discuss your idea and also your implementation approach first.
  We may be able to give you some hints on how to tackle the problem.
  It also makes merging your changes easier and, usually, faster.
* please only add new dependencies if is absolutely necessary
  If you need to:
  * tell us why those are required,
  * what alternatives are existing, and
  * why you choose this dependency.
  And also verify that the license(s) are compatible with _Apache 2.0_ as well as open-source.
 
## Coding conventions

None so far.
Just keep it simple.
And follow the _scout rule_. 

You can take a look at existing code and get a feeling for it.

Please autoformat your code using AndroidStudio's code formatter. 
