package de.danoeh.antennapod.ui.preferences.screen.about;

import android.os.Bundle;
import android.view.View;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.ListFragment;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleOnSubscribe;
import io.reactivex.rxjava3.android.schedulers.AndroidSchedulers;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class TranslatorsFragment extends ListFragment {
    private Disposable translatorsLoader;

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        getListView().setDivider(null);
        getListView().setSelector(android.R.color.transparent);

        translatorsLoader = Single.create((SingleOnSubscribe<ArrayList<SimpleIconListAdapter.ListItem>>) emitter -> {
            ArrayList<SimpleIconListAdapter.ListItem> translators = new ArrayList<>();
            BufferedReader reader = new BufferedReader(new InputStreamReader(
                    getContext().getAssets().open("translators.csv"), "UTF-8"));
            String line;
            while ((line = reader.readLine()) != null) {
                String[] info = line.split(";");
                translators.add(new SimpleIconListAdapter.ListItem(info[0], info[1], null));
            }
            emitter.onSuccess(translators);
        })
        .subscribeOn(Schedulers.io())
        .observeOn(AndroidSchedulers.mainThread())
        .subscribe(
                translators -> setListAdapter(new SimpleIconListAdapter<>(getContext(), translators)),
                error -> Toast.makeText(getContext(), error.getMessage(), Toast.LENGTH_LONG).show()
        );

    }

    @Override
    public void onStop() {
        super.onStop();
        if (translatorsLoader != null) {
            translatorsLoader.dispose();
        }
    }
}
