/// An ASP.NET Core SignalR Dart Client
///
/// ASP.NET Core SignalR is an open-source library that simplifies adding real-time web functionality to apps.
/// Real-time web functionality enables server-side code to push content to clients instantly.
library signalr_core;

export 'src/connection.dart';
export 'src/default_reconnect_policy.dart';
export 'src/handshake_protocol.dart';
export 'src/http_connection.dart';
export 'src/http_connection_options.dart';
export 'src/hub_connection.dart';
export 'src/hub_connection_builder.dart';
export 'src/hub_protocol.dart';
export 'src/json_hub_protocol.dart';
export 'src/logger.dart';
export 'src/retry_policy.dart';
export 'src/text_message_format.dart';
export 'src/transport.dart';
export 'src/utils.dart';
