package de.ciluvien.mensen.ui.viewmodels

import androidx.compose.runtime.mutableStateOf
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import de.ciluvien.mensen.AppModule
import de.ciluvien.mensen.data.local.Bookmark
import de.ciluvien.mensen.data.local.Meal
import kotlinx.coroutines.launch
import java.time.LocalDate

class MealDetailsViewModel(appModule: AppModule) : ViewModel() {
    private val dao = appModule.canteenDao
    private val mealsInit = emptyList<Meal>()
    private var _mealsState = mutableStateOf(mealsInit)
    val meals = _mealsState
    private var _bookmarkState = mutableStateOf(false)
    val bookmarkState = _bookmarkState

    suspend fun getMeals(mealIds: List<Int>, date: LocalDate) {
        _mealsState.value = mealIds.mapNotNull { dao.getMeal(it, date) }
    }

    fun setBookmarkState(boolean: Boolean, mealId: Int, date: LocalDate) {
        viewModelScope.launch {
            if (boolean) {
                dao.insertBookmark(Bookmark(mealId, date))
            } else {
                dao.deleteBookmark(Bookmark(mealId, date))
            }
            getBookmarkState(mealId, date)
        }
    }

    suspend fun getBookmarkState(mealId: Int, date: LocalDate) {
        _bookmarkState.value = dao.getBookmark(mealId, date) != null
    }
}