package de.ciluvien.mensen.ui.viewmodels

import androidx.compose.runtime.mutableStateOf
import androidx.lifecycle.ViewModel
import de.ciluvien.mensen.AppModule
import de.ciluvien.mensen.data.local.relations.CanteenAndPosition

class MapViewModel(
    appModule: AppModule
): ViewModel() {
    private val dao = appModule.canteenDao
    private val api = appModule.openMensaApi
    private val dataService = appModule.dataService

    private val _state = mutableStateOf(emptyList<CanteenAndPosition>())
    val canteensAndPositions = _state

    suspend fun setCanteens() {
        _state.value = dao.getCanteensAndPositionsOrdered()
    }
}