package de.ciluvien.mensen.ui.screens

import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.padding
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.outlined.ArrowBack
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.Scaffold
import androidx.compose.material3.TopAppBarDefaults
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.input.nestedscroll.nestedScroll
import androidx.compose.ui.platform.LocalContext
import androidx.lifecycle.viewmodel.compose.viewModel
import de.ciluvien.mensen.MensenApp
import de.ciluvien.mensen.R
import de.ciluvien.mensen.ui.components.core.CustomTextIcon
import de.ciluvien.mensen.ui.components.core.SingleActionTopAppBar
import de.ciluvien.mensen.ui.components.settings.Settings
import de.ciluvien.mensen.ui.viewModelFactory
import de.ciluvien.mensen.ui.viewmodels.SettingsViewModel

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun SettingsScreen(
    onNavigateBack: () -> Unit,
    onNavigateLibraries: () -> Unit
) {
    val context = LocalContext.current
    val viewModel = viewModel<SettingsViewModel>(
        factory = viewModelFactory {
            SettingsViewModel(MensenApp.appModule)
        }
    )

    val scrollBehavior = TopAppBarDefaults.pinnedScrollBehavior()
    Scaffold(
        modifier = Modifier.nestedScroll(scrollBehavior.nestedScrollConnection),
        topBar = {
            SingleActionTopAppBar(
                title = context.resources.getText(R.string.settings).toString(),
                scrollBehavior = scrollBehavior,
                leftIcon = CustomTextIcon(
                    onClick = onNavigateBack,
                    icon = Icons.AutoMirrored.Outlined.ArrowBack,
                    description = context.resources.getText(R.string.settings_back).toString()
                )
            )
        }
    ) {padding ->
        Box(modifier = Modifier.padding(padding)) {
            Settings(onNavigateLibraries, viewModel, scrollBehavior)
        }
    }
}