package de.ciluvien.mensen.ui.components.settings

import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.selection.selectable
import androidx.compose.foundation.selection.selectableGroup
import androidx.compose.material3.Card
import androidx.compose.material3.CardDefaults
import androidx.compose.material3.Icon
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.RadioButton
import androidx.compose.material3.Text
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.outlined.Home
import androidx.compose.material3.Switch
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.res.vectorResource
import androidx.compose.ui.semantics.Role
import androidx.compose.ui.unit.dp
import de.ciluvien.mensen.R
import de.ciluvien.mensen.ui.Screen
import de.ciluvien.mensen.ui.viewmodels.SettingsViewModel

@Composable
fun Behavior(settingsViewModel: SettingsViewModel) {
    val context = LocalContext.current

    Card(
        colors = CardDefaults.cardColors(
            containerColor = MaterialTheme.colorScheme.surfaceContainer,
        ),
        border = BorderStroke(2.dp, MaterialTheme.colorScheme.surfaceContainer),
        modifier = Modifier
            .fillMaxWidth()
            .padding(2.dp)
    ) {
        Column(
            modifier = Modifier
                .fillMaxWidth()
                .padding(10.dp),
        ) {
            Text(
                text = context.resources.getText(R.string.settings_behavior).toString(),
                style = MaterialTheme.typography.headlineSmall,
                modifier = Modifier.align(Alignment.CenterHorizontally)
            )

            Spacer(modifier = Modifier.size(10.dp))

            Row (
                horizontalArrangement = Arrangement.SpaceBetween,
                verticalAlignment = Alignment.CenterVertically,
                modifier = Modifier.fillMaxWidth()
            ) {
                Column(
                    modifier = Modifier.fillMaxWidth(0.8F)
                ) {
                    Text(
                        text = context.resources.getText(R.string.settings_behavior_nfc_launch).toString(),
                        style = MaterialTheme.typography.titleLarge
                    )
                    Text(
                        text = context.resources.getText(R.string.settings_behavior_nfc_launch_description).toString(),
                        style = MaterialTheme.typography.bodyLarge
                    )
                }
                Switch(
                    checked = settingsViewModel.isNfcAutoLaunch.collectAsState().value,
                    onCheckedChange = { settingsViewModel.setNfcAutoLaunch(it) }
                )
            }

            Spacer(modifier = Modifier.size(10.dp))

            Text(
                text = context.resources.getText(R.string.settings_behavior_startup).toString(),
                style = MaterialTheme.typography.titleLarge,
                modifier = Modifier.align(Alignment.Start)
            )
            Spacer(modifier = Modifier.size(10.dp))

            Column(
                horizontalAlignment = Alignment.Start,
                verticalArrangement = Arrangement.spacedBy(5.dp),
                modifier = Modifier.fillMaxWidth().selectableGroup()
            ) {
                val isCanteenScreen = settingsViewModel.isCanteenScreen.collectAsState()
                val isMenuScreen = settingsViewModel.isMenuScreen.collectAsState()

                val canteensColor = if (isCanteenScreen.value) {
                    MaterialTheme.colorScheme.onSurface
                } else {
                    MaterialTheme.colorScheme.onSurfaceVariant
                }

                val menuColor = if (isMenuScreen.value) {
                    MaterialTheme.colorScheme.onSurface
                } else {
                    MaterialTheme.colorScheme.onSurfaceVariant
                }

                Row(
                    verticalAlignment = Alignment.CenterVertically,
                    horizontalArrangement = Arrangement.Start,
                    modifier = Modifier.selectable(
                        selected = isCanteenScreen.value,
                        onClick = { settingsViewModel.setStartScreen(Screen.CanteenScreen) },
                        role = Role.RadioButton
                    )
                ) {
                    RadioButton(
                        selected = isCanteenScreen.value or !(isCanteenScreen.value or isMenuScreen.value),
                        onClick = null
                    )
                    Spacer(Modifier.size(10.dp))
                    Text(
                        text = context.resources.getText(R.string.canteens_title).toString(),
                        style = MaterialTheme.typography.titleLarge,
                        color = canteensColor
                    )
                    Spacer(Modifier.size(5.dp))
                    Icon(
                        imageVector = Icons.Outlined.Home,
                        contentDescription = context.resources.getText(R.string.canteens_title).toString()
                    )
                }

                Row(
                    verticalAlignment = Alignment.CenterVertically,
                    horizontalArrangement = Arrangement.Start,
                    modifier = Modifier.selectable(
                        selected = isMenuScreen.value,
                        onClick = { settingsViewModel.setStartScreen(Screen.MenuScreen) },
                        role = Role.RadioButton
                    )
                ) {
                    RadioButton(
                        selected = isMenuScreen.value,
                        onClick = null
                    )
                    Spacer(Modifier.size(10.dp))
                    Text(
                        text = context.resources.getText(R.string.menu_title).toString(),
                        style = MaterialTheme.typography.titleLarge,
                        color = menuColor
                    )
                    Spacer(Modifier.size(5.dp))
                    Icon(
                        imageVector = ImageVector.vectorResource(R.drawable.fork_knife_24),
                        contentDescription = context.resources.getText(R.string.menu_title).toString()
                    )
                }
            }
        }
    }
}
