package de.ciluvien.mensen.ui.components.settings

import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.material3.Card
import androidx.compose.material3.CardDefaults
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Switch
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.collectAsState
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.unit.dp
import de.ciluvien.mensen.R
import de.ciluvien.mensen.ui.viewmodels.SettingsViewModel

@Composable
fun Appearance(settingsViewModel: SettingsViewModel) {
    val context = LocalContext.current

    Card(
        colors = CardDefaults.cardColors(
            containerColor = MaterialTheme.colorScheme.surfaceContainer,
        ),
        border = BorderStroke(2.dp, MaterialTheme.colorScheme.surfaceContainer),
        modifier = Modifier
            .fillMaxWidth()
            .padding(2.dp)
    ) {
        Column(
            modifier = Modifier.padding(10.dp)
        ) {
            Text(
                text = context.resources.getText(R.string.settings_appearance).toString(),
                style = MaterialTheme.typography.headlineSmall,
                modifier = Modifier.align(Alignment.CenterHorizontally)
            )

            Spacer(modifier = Modifier.size(10.dp))
            Row (
                horizontalArrangement = Arrangement.SpaceBetween,
                verticalAlignment = Alignment.CenterVertically,
                modifier = Modifier.fillMaxWidth()
            ) {
                Column(
                    modifier = Modifier.fillMaxWidth(0.8F)
                ) {
                    Text(
                        text = context.resources.getText(R.string.settings_appearance_ultra_dark).toString(),
                        style = MaterialTheme.typography.titleLarge
                    )
                    Text(
                        text = context.resources.getText(R.string.settings_appearance_ultra_dark_description).toString(),
                        style = MaterialTheme.typography.bodyLarge
                    )
                }
                Switch(
                    checked = settingsViewModel.isUltraDark.collectAsState().value,
                    onCheckedChange = { settingsViewModel.setUltraDark(it) }
                )
            }

            Spacer(modifier = Modifier.size(10.dp))
            Row (
                horizontalArrangement = Arrangement.SpaceBetween,
                verticalAlignment = Alignment.CenterVertically,
                modifier = Modifier.fillMaxWidth()
            ) {
                Column(
                    modifier = Modifier.fillMaxWidth(0.8F)
                ) {
                    Text(
                        text = context.resources.getText(R.string.settings_appearance_allergens).toString(),
                        style = MaterialTheme.typography.titleLarge
                    )
                    Text(
                        text = context.resources.getText(R.string.settings_appearance_allergens_description).toString(),
                        style = MaterialTheme.typography.bodyLarge
                    )
                }
                Switch(
                    checked = settingsViewModel.areAllergensVisible.collectAsState().value,
                    onCheckedChange = { settingsViewModel.setAllergensVisible(it) }
                )
            }
        }
    }
}
