package de.ciluvien.mensen.ui.components.settings

import android.content.Intent
import android.net.Uri
import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.material3.Card
import androidx.compose.material3.CardDefaults
import androidx.compose.material3.Icon
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.dp
import de.ciluvien.mensen.R

@Composable
fun About(onNavigateLibraries: () -> Unit) {
    val context = LocalContext.current
    val packageInfo = context.packageManager.getPackageInfo(context.packageName, 0)
    val versionName = packageInfo.versionName ?: ""

    Card(
        colors = CardDefaults.cardColors(
            containerColor = MaterialTheme.colorScheme.surfaceContainer,
        ),
        border = BorderStroke(2.dp, MaterialTheme.colorScheme.surfaceContainer),
        modifier = Modifier
            .fillMaxWidth()
            .padding(2.dp)
    ) {
        Column(
            modifier = Modifier.padding(10.dp)
        ) {
            Text(
                text = context.resources.getText(R.string.settings_about).toString(),
                style = MaterialTheme.typography.headlineSmall,
                modifier = Modifier.align(Alignment.CenterHorizontally)
            )

            Spacer(modifier = Modifier.size(10.dp))
            Text(
                text = context.resources.getText(R.string.version).toString(),
                style = MaterialTheme.typography.titleLarge
            )
            Text(
                text = versionName,
                style = MaterialTheme.typography.bodyLarge
            )

            Spacer(modifier = Modifier.size(10.dp))
            Text(
                text = context.resources.getText(R.string.settings_author).toString(),
                style = MaterialTheme.typography.titleLarge
            )
            Text(
                text = context.resources.getText(R.string.settings_author_name).toString(),
                style = MaterialTheme.typography.bodyLarge
            )

            Spacer(modifier = Modifier.size(10.dp))
            Text(
                text = context.resources.getText(R.string.settings_license).toString(),
                style = MaterialTheme.typography.titleLarge
            )
            Text(
                text = context.resources.getText(R.string.settings_free_software).toString(),
                style = MaterialTheme.typography.bodyLarge
            )
            Text(
                text = context.resources.getText(R.string.settings_AGPL).toString(),
                style = MaterialTheme.typography.bodyLarge
            )

            /* Open Source Licences section removed until aboutlibraries more stable
            Spacer(modifier = Modifier.size(10.dp))
            Row(
                verticalAlignment = Alignment.CenterVertically,
                modifier = Modifier.clickable {
                    onNavigateLibraries.invoke()
                }
            ) {
                Text(
                    text = context.resources.getText(R.string.libraries_title).toString(),
                    style = MaterialTheme.typography.titleLarge
                )
                Spacer(Modifier.size(10.dp))
                Icon(
                    painter = painterResource(id = R.drawable.baseline_open_in_new_24),
                    contentDescription = context.resources.getText(R.string.settings_open_libraries)
                        .toString()
                )
            }
             */

            Spacer(modifier = Modifier.size(10.dp))
            Row(
                verticalAlignment = Alignment.CenterVertically,
                modifier = Modifier.clickable {
                    val webpage: Uri = Uri.parse(
                        context.resources.getText(R.string.settings_codeberg_link).toString()
                    )
                    val intent = Intent(Intent.ACTION_VIEW, webpage)
                    if (intent.resolveActivity(context.packageManager) != null) {
                        context.startActivity(intent)
                    }
                }
            ) {
                Text(
                    text = context.resources.getText(R.string.settings_source_code).toString(),
                    style = MaterialTheme.typography.titleLarge
                )
                Spacer(Modifier.size(10.dp))
                Icon(
                    painter = painterResource(id = R.drawable.baseline_open_in_new_24),
                    contentDescription = context.resources.getText(R.string.settings_codeberg)
                        .toString()
                )
            }
        }
    }
}