package de.ciluvien.mensen.ui.components.core

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.outlined.Settings
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.TopAppBarDefaults
import androidx.compose.material3.TopAppBarScrollBehavior
import androidx.compose.runtime.Composable
import androidx.compose.ui.platform.LocalContext
import de.ciluvien.mensen.R

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun SettingsTopAppBar(
    onNavigateSettings: () -> Unit,
    title: String,
    scrollBehavior: TopAppBarScrollBehavior = TopAppBarDefaults.pinnedScrollBehavior(),
    leftIcon: CustomTextIcon? = null
) {
    val context = LocalContext.current
    SingleActionTopAppBar(
        title = title,
        leftIcon = leftIcon,
        scrollBehavior = scrollBehavior,
        rightIcon = CustomTextIcon(
            onClick = onNavigateSettings,
            icon = Icons.Outlined.Settings,
            description = context.resources.getText(R.string.settings).toString()
        )
    )
}