package de.ciluvien.mensen.ui.components.core

import androidx.compose.foundation.layout.Box
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.Home
import androidx.compose.material.icons.filled.Place
import androidx.compose.material.icons.outlined.Home
import androidx.compose.material.icons.outlined.Place
import androidx.compose.material3.Icon
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.NavigationBar
import androidx.compose.material3.NavigationBarItem
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.remember
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.res.vectorResource
import androidx.navigation.NavController
import androidx.navigation.NavDestination.Companion.hierarchy
import androidx.navigation.compose.currentBackStackEntryAsState
import de.ciluvien.mensen.R
import de.ciluvien.mensen.ui.Screen

data class BottomNavigationItem(
    val route: String,
    val title: String,
    val selectedIcon: ImageVector,
    val unselectedIcon: ImageVector,
)
@Composable
fun BottomNavigationBar(navController: NavController) {
    val context = LocalContext.current
    val paymentIcon = ImageVector.vectorResource(R.drawable.baseline_payment_24)
    val menuIcon = ImageVector.vectorResource(R.drawable.fork_knife_24)

    val items = remember {
        listOf(
            BottomNavigationItem(
                route = Screen.CanteenScreen.route,
                title = context.resources.getText(R.string.canteens_title).toString(),
                selectedIcon = Icons.Filled.Home,
                unselectedIcon = Icons.Outlined.Home,
            ),
            BottomNavigationItem(
                route = Screen.MenuScreen.route,
                title = context.resources.getText(R.string.menu_title).toString(),
                selectedIcon = menuIcon,
                unselectedIcon = menuIcon,
            ),
            BottomNavigationItem(
                route = Screen.CardScreen.route,
                title = context.resources.getText(R.string.balance).toString(),
                selectedIcon = paymentIcon,
                unselectedIcon = paymentIcon,
            ),
            BottomNavigationItem(
                route = Screen.MapScreen.route,
                title = context.resources.getText(R.string.map_title).toString(),
                selectedIcon = Icons.Filled.Place,
                unselectedIcon = Icons.Outlined.Place,
            )
        )
    }

    NavigationBar {
        val navBackStackEntry by navController.currentBackStackEntryAsState()
        val currentDestination = navBackStackEntry?.destination
        items.forEach { item ->
            val isSelected = currentDestination?.hierarchy?.any { it.route?.contains(item.route) == true } == true
            NavigationBarItem(
                selected = isSelected,
                label = {
                    Text(
                        text = item.title,
                        style = MaterialTheme.typography.labelLarge
                    )
                },
                alwaysShowLabel = false,
                onClick = {
                    navController.navigate(item.route)
                },
                icon = {
                    Box {
                        Icon(
                            imageVector = if (isSelected) {
                                item.selectedIcon
                            } else item.unselectedIcon,
                            contentDescription = item.title,
                        )
                    }
                }
            )
        }
    }
}
