package de.ciluvien.mensen.ui.components

import android.content.Context
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.Card
import androidx.compose.material3.CardColors
import androidx.compose.material3.CardDefaults
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.ComposeView
import androidx.compose.ui.unit.dp
import org.osmdroid.views.MapView
import org.osmdroid.views.overlay.Marker
import org.osmdroid.views.overlay.infowindow.InfoWindow

class CustomInfoWindow(
    mapView: MapView,
    context: Context,
    private val onClick: () -> Unit
) : InfoWindow(ComposeView(context), mapView) {
    override fun onOpen(item: Any?) {
        closeAllInfoWindowsOn(mapView)
        if (item is Marker) {
            (mView as ComposeView).setContent {
                CustomInfoWindowContent(
                    title = item.title,
                    description = item.subDescription,
                    onClick = onClick
                )
            }
        }
    }

    override fun onClose() {
    }
}

@Composable
fun CustomInfoWindowContent(
    title: String,
    description: String,
    onClick: () -> Unit
) {
    Card(
        onClick = onClick,
        colors = CardDefaults.cardColors()
    ) {
        Column(
            modifier = Modifier
                .padding(10.dp)
        ) {
            Text(
                text = title,
                style = MaterialTheme.typography.headlineSmall,
            )
            Spacer(modifier = Modifier.height(4.dp))
            Text(
                text = description,
                style = MaterialTheme.typography.bodyLarge,
            )
        }

    }
}
