package de.ciluvien.mensen.data.remote

import android.content.Context
import android.content.pm.PackageManager
import io.ktor.client.HttpClient
import io.ktor.client.engine.okhttp.OkHttp
import io.ktor.client.plugins.UserAgent
import io.ktor.client.plugins.contentnegotiation.ContentNegotiation
import io.ktor.client.plugins.logging.LogLevel
import io.ktor.client.plugins.logging.Logging
import io.ktor.serialization.kotlinx.json.json
import kotlinx.serialization.json.Json
import java.time.LocalDate


interface OpenMensaService {
    suspend fun getCanteens(): List<CanteenResponse>

    suspend fun getDays(canteenID: Int): List<DayResponse>

    suspend fun getDay(canteenID: Int, date: LocalDate): DayResponse?

    suspend fun getMeals(canteenID: Int, date: LocalDate): List<MealResponse>

    suspend fun getMeal(canteenID: Int, date: LocalDate, mealID: Int): MealResponse?

    companion object {
        fun create(context: Context): OpenMensaService {
            return OpenMensaImpl(client = HttpClient(OkHttp) {
                install(Logging) {
                    level = LogLevel.ALL
                }
                install(ContentNegotiation){
                    json(Json {
                        prettyPrint = true
                        isLenient = true
                    })
                }
                val packageName = context.packageName
                val packageVersion = try {
                    val pInfo = context.packageManager.getPackageInfo(context.packageName, 0)
                    pInfo.versionName
                } catch (e: PackageManager.NameNotFoundException) {
                    e.printStackTrace()
                    ""
                }
                install(UserAgent){
                    agent = "${packageName}/${packageVersion}"
                }
            })
        }
    }
}